(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
(* :Title: ToFI *)

(* :Author: Rolf Mertig *)

(* ------------------------------------------------------------------------ *)
(* :History: File created on November 10th 2003 , RM*)
(* ------------------------------------------------------------------------ *)

(* :Summary: introduce Feynman integrals as functions (see also ToTFI) *) 

(* ------------------------------------------------------------------------ *)

BeginPackage["HighEnergyPhysics`fcloops`ToFI`",
             "HighEnergyPhysics`FeynCalc`"];

ToFI::"usage" = "ToFI[expr, {q1, q2}, {p}] translates all non-tensorial 
loop integrals in expr into TFI notation from Tarcer. 
ToFI[expr, {q}, {p}] introduces TBI B0-like integrals. \
ToFI can be extended to more external particles and more loops if needed.";

(* ------------------------------------------------------------------------ *)

Begin["`Private`"];
   
MakeContext[FCE, FeynmanIntegral, Select1, Select2, ToTFI];

(* ToFI should be generalized *)

ToFI[x_,y_List, z_List] := tofi[x,y,z] /. {FeynmanIntegral[expr_, {q_}, {p_}] :> ToTFI[expr, q, p],
                         FeynmanIntegral[expr_, {q1_, q2_}, {p_}] :> ToTFI[expr, q1, q2, p]
                        };

tofi[a_, {q__},__] := a /; FreeQ[a, Alternatives@@{q}];

tofi[expr_Plus,m__] := tofi[#, m]& /@ expr;

tofi[expr_Times, {q__}, {ps__}] := ( FCE[Select1[expr, {q}]] * 
        FeynmanIntegral[FCE @ Select2[expr, {q}], {q}, {ps}] 
    ) /; Select1[expr, {q}] =!= 1;

ToFI[e_,{q_},{p_}] := ToTFI[e, q, p];
ToFI[e_,{q1_, q2_},{p_}] := ToTFI[e, q1, q2, p];


End[]; EndPackage[];
(* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ *)
If[$VeryVerbose > 0,WriteString["stdout", "ToTFI | \n "]];
Null
