(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    203123,       6853]*)
(*NotebookOutlinePosition[    204098,       6886]*)
(*  CellTagsIndexPosition[    203964,       6879]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["QCD 1 - loop example: gluon self energy", "Subsection"],

Cell[BoxData[
    \(<< HighEnergyPhysics`FeynCalc`\)], "Input"],

Cell[CellGroupData[{

Cell["The graphs", "Subsubsection"],

Cell["\<\
This generates the 1-loop self energy diagrams using a model file \
for QCD from the Models directory in HighEnergyPhyiscs.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Paint[
        inserts = 
          InsertFields[
            CreateTopologies[1, 1 \[Rule] 1, 
              ExcludeTopologies \[Rule] Tadpoles], {V[5]} \[Rule] {V[5]}, 
            InsertionLevel \[Rule] {Classes}, 
            GenericModel -> "\<FCQCDLorentz\>", Model \[Rule] "\<FCQCD\>"], 
        ColumnsXRows \[Rule] {4, 1}, SheetHeader \[Rule] None, 
        Numbering \[Rule] Simple];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .25 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0113636 -3.46945e-18 0.0113636 [
[ 0 0 0 0 ]
[ 1 .25 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .25 L
0 .25 L
closepath
clip
newpath
% Start of sub-graphic
p
-1.38778e-17 -3.46945e-18 0.25 0.25 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.5 .5 m
.4944 .49538 L
.48801 .49183 L
.48105 .48955 L
.47379 .48864 L
.46649 .48917 L
.45943 .49109 L
.45287 .49432 L
.44703 .49867 L
.44213 .50393 L
.4383 .50981 L
.43563 .51602 L
.43417 .52222 L
.43387 .52808 L
.43463 .53331 L
.43632 .53763 L
.43874 .54081 L
.44164 .54268 L
.44477 .54315 L
.44785 .54219 L
.45061 .53985 L
.4528 .53626 L
.4542 .53161 L
.45461 .52613 L
.45392 .52011 L
.45205 .51387 L
.44898 .50774 L
.44477 .50203 L
.43952 .49706 L
.43341 .49306 L
.42665 .49027 L
.41948 .48882 L
.41216 .48878 L
.40498 .49017 L
.39819 .4929 L
.39204 .49684 L
.38675 .50178 L
.38249 .50745 L
.37936 .51357 L
.37743 .51981 L
.37668 .52584 L
.37705 .53136 L
.3784 .53606 L
.38056 .5397 L
.3833 .5421 L
.38637 .54313 L
.3895 .54272 L
.39242 .54092 L
.39486 .5378 L
.39659 .53353 L
Mistroke
.39741 .52834 L
.39716 .52249 L
.39575 .5163 L
.39315 .51009 L
.38937 .50418 L
.38452 .49889 L
.37872 .49448 L
.37219 .4912 L
.36514 .48921 L
.35785 .48862 L
.35058 .48945 L
.34361 .49167 L
.33718 .49516 L
.33154 .49974 L
.32686 .50516 L
.32328 .51114 L
.32088 .51737 L
.31967 .52353 L
.31961 .52928 L
.3206 .53433 L
.32247 .53841 L
.32501 .54132 L
.32798 .54289 L
.33112 .54305 L
.33416 .54178 L
.33681 .53916 L
.33885 .53531 L
.34004 .53045 L
.34023 .52483 L
.33928 .51874 L
.33714 .51249 L
.33381 .50643 L
.32937 .50086 L
.32392 .49608 L
.31765 .49233 L
.31077 .48982 L
.30354 .48868 L
.29623 .48895 L
.28911 .49064 L
.28244 .49366 L
.27647 .49783 L
.27139 .50296 L
.26737 .50876 L
.2645 .51493 L
.26283 .52115 L
.26234 .5271 L
.26293 .53246 L
.26448 .53695 L
.26678 .54033 L
.26962 .54244 L
Mistroke
.27273 .54315 L
.27584 .54244 L
.27867 .54033 L
.28098 .53695 L
.28252 .53246 L
.28312 .5271 L
.28262 .52115 L
.28095 .51493 L
.27808 .50876 L
.27406 .50296 L
.26899 .49783 L
.26301 .49366 L
.25634 .49064 L
.24922 .48895 L
.24191 .48868 L
.23468 .48982 L
.22781 .49233 L
.22154 .49608 L
.21609 .50086 L
.21164 .50643 L
.20831 .51249 L
.20618 .51874 L
.20523 .52483 L
.20541 .53045 L
.20661 .53531 L
.20864 .53916 L
.2113 .54178 L
.21433 .54305 L
.21747 .54289 L
.22045 .54132 L
.22299 .53841 L
.22486 .53433 L
.22584 .52928 L
.22578 .52353 L
.22458 .51737 L
.22218 .51114 L
.2186 .50516 L
.21392 .49974 L
.20827 .49516 L
.20185 .49167 L
.19487 .48945 L
.1876 .48862 L
.18031 .48921 L
.17327 .4912 L
.16673 .49448 L
.16094 .49889 L
.15608 .50418 L
.15231 .51009 L
.1497 .5163 L
.14829 .52249 L
Mistroke
.14804 .52834 L
.14886 .53353 L
.15059 .5378 L
.15303 .54092 L
.15595 .54272 L
.15908 .54313 L
.16216 .5421 L
.1649 .5397 L
.16705 .53606 L
.16841 .53136 L
.16877 .52584 L
.16802 .51981 L
.16609 .51357 L
.16297 .50745 L
.1587 .50178 L
.15341 .49684 L
.14727 .4929 L
.14048 .49017 L
.13329 .48878 L
.12598 .48882 L
.1188 .49027 L
.11204 .49306 L
.10593 .49706 L
.10069 .50203 L
.09648 .50774 L
.09341 .51387 L
.09153 .52011 L
.09084 .52613 L
.09126 .53161 L
.09265 .53626 L
.09484 .53985 L
.09761 .54219 L
.10069 .54315 L
.10381 .54268 L
.10672 .54081 L
.10913 .53763 L
.11082 .53331 L
.11159 .52808 L
.11129 .52222 L
.10982 .51602 L
.10716 .50981 L
.10333 .50393 L
.09842 .49867 L
.09259 .49432 L
.08602 .49109 L
.07896 .48917 L
.07166 .48864 L
.0644 .48955 L
.05745 .49183 L
.05106 .49538 L
Mistroke
.04545 .5 L
Mfstroke
gsave
.27273 .45704 -63 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .5 m
.5056 .50462 L
.51199 .50817 L
.51895 .51045 L
.52621 .51136 L
.53351 .51083 L
.54057 .50891 L
.54713 .50568 L
.55297 .50133 L
.55787 .49607 L
.5617 .49019 L
.56437 .48398 L
.56583 .47778 L
.56613 .47192 L
.56537 .46669 L
.56368 .46237 L
.56126 .45919 L
.55836 .45732 L
.55523 .45685 L
.55215 .45781 L
.54939 .46015 L
.5472 .46374 L
.5458 .46839 L
.54539 .47387 L
.54608 .47989 L
.54795 .48613 L
.55102 .49226 L
.55523 .49797 L
.56048 .50294 L
.56659 .50694 L
.57335 .50973 L
.58052 .51118 L
.58784 .51122 L
.59502 .50983 L
.60181 .5071 L
.60796 .50316 L
.61325 .49822 L
.61751 .49255 L
.62064 .48643 L
.62257 .48019 L
.62332 .47416 L
.62295 .46864 L
.6216 .46394 L
.61944 .4603 L
.6167 .4579 L
.61363 .45687 L
.6105 .45728 L
.60758 .45908 L
.60514 .4622 L
.60341 .46647 L
Mistroke
.60259 .47166 L
.60284 .47751 L
.60425 .4837 L
.60685 .48991 L
.61063 .49582 L
.61548 .50111 L
.62128 .50552 L
.62781 .5088 L
.63486 .51079 L
.64215 .51138 L
.64942 .51055 L
.65639 .50833 L
.66282 .50484 L
.66846 .50026 L
.67314 .49484 L
.67672 .48886 L
.67912 .48263 L
.68033 .47647 L
.68039 .47072 L
.6794 .46567 L
.67753 .46159 L
.67499 .45868 L
.67202 .45711 L
.66888 .45695 L
.66584 .45822 L
.66319 .46084 L
.66115 .46469 L
.65996 .46955 L
.65977 .47517 L
.66072 .48126 L
.66286 .48751 L
.66619 .49357 L
.67063 .49914 L
.67608 .50392 L
.68235 .50767 L
.68923 .51018 L
.69646 .51132 L
.70377 .51105 L
.71089 .50936 L
.71756 .50634 L
.72353 .50217 L
.72861 .49704 L
.73263 .49124 L
.7355 .48507 L
.73717 .47885 L
.73766 .4729 L
.73707 .46754 L
.73552 .46305 L
.73322 .45967 L
.73038 .45756 L
Mistroke
.72727 .45685 L
.72416 .45756 L
.72133 .45967 L
.71902 .46305 L
.71748 .46754 L
.71688 .4729 L
.71738 .47885 L
.71905 .48507 L
.72192 .49124 L
.72594 .49704 L
.73101 .50217 L
.73699 .50634 L
.74366 .50936 L
.75078 .51105 L
.75809 .51132 L
.76532 .51018 L
.77219 .50767 L
.77846 .50392 L
.78391 .49914 L
.78836 .49357 L
.79169 .48751 L
.79382 .48126 L
.79477 .47517 L
.79459 .46955 L
.79339 .46469 L
.79136 .46084 L
.7887 .45822 L
.78567 .45695 L
.78253 .45711 L
.77955 .45868 L
.77701 .46159 L
.77514 .46567 L
.77416 .47072 L
.77422 .47647 L
.77542 .48263 L
.77782 .48886 L
.7814 .49484 L
.78608 .50026 L
.79173 .50484 L
.79815 .50833 L
.80513 .51055 L
.8124 .51138 L
.81969 .51079 L
.82673 .5088 L
.83327 .50552 L
.83906 .50111 L
.84392 .49582 L
.84769 .48991 L
.8503 .4837 L
.85171 .47751 L
Mistroke
.85196 .47166 L
.85114 .46647 L
.84941 .4622 L
.84697 .45908 L
.84405 .45728 L
.84092 .45687 L
.83784 .4579 L
.8351 .4603 L
.83295 .46394 L
.83159 .46864 L
.83123 .47416 L
.83198 .48019 L
.83391 .48643 L
.83703 .49255 L
.8413 .49822 L
.84659 .50316 L
.85273 .5071 L
.85952 .50983 L
.86671 .51122 L
.87402 .51118 L
.8812 .50973 L
.88796 .50694 L
.89407 .50294 L
.89931 .49797 L
.90352 .49226 L
.90659 .48613 L
.90847 .47989 L
.90916 .47387 L
.90874 .46839 L
.90735 .46374 L
.90516 .46015 L
.90239 .45781 L
.89931 .45685 L
.89619 .45732 L
.89328 .45919 L
.89087 .46237 L
.88918 .46669 L
.88841 .47192 L
.88871 .47778 L
.89018 .48398 L
.89284 .49019 L
.89667 .49607 L
.90158 .50133 L
.90741 .50568 L
.91398 .50891 L
.92104 .51083 L
.92834 .51136 L
.9356 .51045 L
.94255 .50817 L
.94894 .50462 L
Mistroke
.95455 .5 L
Mfstroke
gsave
.72727 .42522 -63 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .5 m
.49454 .49592 L
.48812 .493 L
.48102 .49145 L
.4736 .49143 L
.46628 .49296 L
.45947 .49597 L
.45355 .50025 L
.44881 .50553 L
.44541 .5115 L
.44341 .51781 L
.44276 .52415 L
.4433 .53025 L
.4448 .53588 L
.447 .54089 L
.44963 .54515 L
.45243 .54858 L
.45517 .5511 L
.45768 .55266 L
.4598 .55324 L
.46145 .55282 L
.46256 .55142 L
.46309 .5491 L
.463 .54594 L
.46223 .5421 L
.46072 .53777 L
.45839 .53318 L
.4552 .52862 L
.45108 .52437 L
.44606 .52075 L
.4402 .51807 L
.43369 .51659 L
.42676 .51652 L
.41974 .51797 L
.41302 .52094 L
.40698 .52531 L
.40196 .53084 L
.39825 .53723 L
.39602 .5441 L
.39532 .55105 L
.39608 .55776 L
.39813 .56393 L
.40124 .56936 L
.4051 .57394 L
.40942 .57762 L
.41388 .58041 L
.41821 .58237 L
.42214 .58355 L
.42547 .584 L
.42804 .58377 L
Mistroke
.42974 .58289 L
.43051 .58142 L
.4303 .5794 L
.42912 .57692 L
.427 .5741 L
.42397 .57113 L
.42008 .56821 L
.41539 .56561 L
.41001 .5636 L
.40407 .56246 L
.39776 .56243 L
.39133 .56371 L
.38508 .56641 L
.37936 .5705 L
.37448 .57588 L
.37076 .58229 L
.36844 .5894 L
.36764 .5968 L
.3684 .60407 L
.37061 .61084 L
.37409 .61677 L
.37857 .62166 L
.38375 .62539 L
.38932 .62796 L
.39498 .62947 L
.40044 .63004 L
.40547 .62987 L
.40987 .62913 L
.41345 .62799 L
.41609 .62658 L
.41769 .62502 L
.41819 .62338 L
.41758 .62172 L
.41586 .62011 L
.41312 .61864 L
.40944 .61742 L
.40496 .61659 L
.39985 .61634 L
.39432 .61685 L
.3886 .6183 L
.38298 .62085 L
.37775 .62458 L
.37322 .62948 L
.36971 .63544 L
.36746 .64223 L
.36668 .64953 L
.36745 .65694 L
.36975 .66405 L
.37344 .67046 L
.37828 .67583 L
Mistroke
.38396 .67992 L
.39017 .68261 L
.39655 .68391 L
.40282 .68393 L
.40873 .68284 L
.41408 .68092 L
.41875 .67842 L
.42261 .67561 L
.42561 .67276 L
.42768 .67006 L
.42879 .66768 L
.42892 .66575 L
.42805 .66433 L
.42624 .66349 L
.42355 .66327 L
.42009 .6637 L
.41604 .66485 L
.4116 .66678 L
.40704 .66954 L
.40263 .67321 L
.3987 .67778 L
.39554 .68323 L
.39345 .68943 L
.39266 .69617 L
.39335 .70317 L
.39557 .71007 L
.39927 .71648 L
.40427 .72204 L
.41029 .72643 L
.41698 .7294 L
.42395 .73087 L
.43085 .73081 L
.43733 .72936 L
.44316 .72673 L
.44818 .72317 L
.4523 .719 L
.45552 .71453 L
.45788 .71004 L
.45942 .70583 L
.46022 .70211 L
.46032 .69908 L
.45978 .69688 L
.45862 .69559 L
.4569 .69526 L
.45469 .69592 L
.45208 .69754 L
.44922 .7001 L
.4463 .70356 L
.44356 .70785 L
.44127 .71288 L
Mistroke
.43969 .71855 L
.43911 .72469 L
.43973 .73107 L
.44171 .73742 L
.44511 .74343 L
.44987 .74876 L
.4558 .75307 L
.46261 .7561 L
.46992 .75766 L
.47732 .75766 L
.48439 .75615 L
.49079 .75325 L
.49623 .74922 L
.50055 .74432 L
.50369 .73888 L
.50569 .7332 L
.50668 .72758 L
.50682 .72227 L
.5063 .71749 L
.5053 .71344 L
.50397 .71026 L
.50245 .70807 L
.50083 .70696 L
.49917 .70696 L
.49755 .70807 L
.49603 .71026 L
.4947 .71344 L
.4937 .71749 L
.49318 .72227 L
.49332 .72758 L
.49431 .7332 L
.49631 .73888 L
.49945 .74432 L
.50377 .74922 L
.50921 .75325 L
.51561 .75615 L
.52268 .75766 L
.53008 .75766 L
.53739 .7561 L
.5442 .75307 L
.55013 .74876 L
.55489 .74343 L
.55829 .73742 L
.56027 .73107 L
.56089 .72469 L
.56031 .71855 L
.55873 .71288 L
.55644 .70785 L
.5537 .70356 L
.55078 .7001 L
Mistroke
.54792 .69754 L
.54531 .69592 L
.5431 .69526 L
.54138 .69559 L
.54022 .69688 L
.53968 .69908 L
.53978 .70211 L
.54058 .70583 L
.54212 .71004 L
.54448 .71453 L
.5477 .719 L
.55182 .72317 L
.55684 .72673 L
.56267 .72936 L
.56915 .73081 L
.57605 .73087 L
.58302 .7294 L
.58971 .72643 L
.59573 .72204 L
.60073 .71648 L
.60443 .71007 L
.60665 .70317 L
.60734 .69617 L
.60655 .68943 L
.60446 .68323 L
.6013 .67778 L
.59737 .67321 L
.59296 .66954 L
.5884 .66678 L
.58396 .66485 L
.57991 .6637 L
.57645 .66327 L
.57376 .66349 L
.57195 .66433 L
.57108 .66575 L
.57121 .66768 L
.57232 .67006 L
.57439 .67276 L
.57739 .67561 L
.58125 .67842 L
.58592 .68092 L
.59127 .68284 L
.59718 .68393 L
.60345 .68391 L
.60983 .68261 L
.61604 .67992 L
.62172 .67583 L
.62656 .67046 L
.63025 .66405 L
.63255 .65694 L
Mistroke
.63332 .64953 L
.63254 .64223 L
.63029 .63544 L
.62678 .62948 L
.62225 .62458 L
.61702 .62085 L
.6114 .6183 L
.60568 .61685 L
.60015 .61634 L
.59504 .61659 L
.59056 .61742 L
.58688 .61864 L
.58414 .62011 L
.58242 .62172 L
.58181 .62338 L
.58231 .62502 L
.58391 .62658 L
.58655 .62799 L
.59013 .62913 L
.59453 .62987 L
.59956 .63004 L
.60502 .62947 L
.61068 .62796 L
.61625 .62539 L
.62143 .62166 L
.62591 .61677 L
.62939 .61084 L
.6316 .60407 L
.63236 .5968 L
.63156 .5894 L
.62924 .58229 L
.62552 .57588 L
.62064 .5705 L
.61492 .56641 L
.60867 .56371 L
.60224 .56243 L
.59593 .56246 L
.58999 .5636 L
.58461 .56561 L
.57992 .56821 L
.57603 .57113 L
.573 .5741 L
.57088 .57692 L
.5697 .5794 L
.56949 .58142 L
.57026 .58289 L
.57196 .58377 L
.57453 .584 L
.57786 .58355 L
.58179 .58237 L
Mistroke
.58612 .58041 L
.59058 .57762 L
.5949 .57394 L
.59876 .56936 L
.60187 .56393 L
.60392 .55776 L
.60468 .55105 L
.60398 .5441 L
.60175 .53723 L
.59804 .53084 L
.59302 .52531 L
.58698 .52094 L
.58026 .51797 L
.57324 .51652 L
.56631 .51659 L
.5598 .51807 L
.55394 .52075 L
.54892 .52437 L
.5448 .52862 L
.54161 .53318 L
.53928 .53777 L
.53777 .5421 L
.537 .54594 L
.53691 .5491 L
.53744 .55142 L
.53855 .55282 L
.5402 .55324 L
.54232 .55266 L
.54483 .5511 L
.54757 .54858 L
.55037 .54515 L
.553 .54089 L
.5552 .53588 L
.5567 .53025 L
.55724 .52415 L
.55659 .51781 L
.55459 .5115 L
.55119 .50553 L
.54645 .50025 L
.54053 .49597 L
.53372 .49296 L
.5264 .49143 L
.51898 .49145 L
.51188 .493 L
.50546 .49592 L
.5 .5 L
Mfstroke
gsave
.5 .79296 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.5 .5 Mdot
gsave
.5 .02273 -64.9688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.562 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.25 -3.46945e-18 0.5 0.25 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.31818 .5 m
.31277 .49545 L
.3066 .49194 L
.29988 .48964 L
.29285 .48866 L
.28576 .48906 L
.27887 .49082 L
.27244 .49385 L
.26669 .49798 L
.26181 .50303 L
.25795 .50872 L
.2552 .51478 L
.2536 .52089 L
.25314 .52676 L
.25373 .53207 L
.25526 .53657 L
.25754 .54002 L
.26036 .54225 L
.26347 .54316 L
.26663 .54268 L
.26957 .54086 L
.27204 .53777 L
.27382 .53358 L
.27473 .52849 L
.27461 .52277 L
.27337 .5167 L
.27098 .5106 L
.26746 .50475 L
.26289 .49948 L
.25739 .49503 L
.25115 .49164 L
.24438 .48947 L
.23733 .48864 L
.23025 .48918 L
.22341 .49108 L
.21704 .49422 L
.21137 .49847 L
.20659 .50359 L
.20284 .50934 L
.20021 .51542 L
.19873 .52152 L
.19838 .52734 L
.19908 .53258 L
.2007 .53698 L
.20304 .54031 L
.2059 .54241 L
.20904 .54317 L
.21218 .54255 L
.21508 .54059 L
.21749 .53738 L
Mistroke
.21919 .53308 L
.22 .52792 L
.21977 .52215 L
.21841 .51606 L
.2159 .50996 L
.21226 .50417 L
.20758 .49897 L
.202 .49462 L
.19569 .49135 L
.18888 .48932 L
.18182 .48863 L
.17475 .48932 L
.16794 .49135 L
.16164 .49462 L
.15605 .49897 L
.15137 .50417 L
.14774 .50996 L
.14523 .51606 L
.14387 .52215 L
.14364 .52792 L
.14444 .53308 L
.14614 .53738 L
.14855 .54059 L
.15145 .54255 L
.1546 .54317 L
.15773 .54241 L
.16059 .54031 L
.16294 .53698 L
.16455 .53258 L
.16525 .52734 L
.16491 .52152 L
.16343 .51542 L
.1608 .50934 L
.15705 .50359 L
.15227 .49847 L
.1466 .49422 L
.14023 .49108 L
.13338 .48918 L
.1263 .48864 L
.11925 .48947 L
.11249 .49164 L
.10625 .49503 L
.10075 .49948 L
.09617 .50475 L
.09265 .5106 L
.09026 .5167 L
.08903 .52277 L
.08891 .52849 L
.08981 .53358 L
.0916 .53777 L
Mistroke
.09407 .54086 L
.09701 .54268 L
.10016 .54316 L
.10328 .54225 L
.1061 .54002 L
.10838 .53657 L
.1099 .53207 L
.1105 .52676 L
.11004 .52089 L
.10844 .51478 L
.10569 .50872 L
.10183 .50303 L
.09694 .49798 L
.09119 .49385 L
.08476 .49082 L
.07788 .48906 L
.07079 .48866 L
.06376 .48964 L
.05703 .49194 L
.05086 .49545 L
.04545 .5 L
Mfstroke
gsave
.18182 .45704 -63 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.68723 .50455 L
.6934 .50806 L
.70012 .51036 L
.70715 .51134 L
.71424 .51094 L
.72113 .50918 L
.72756 .50615 L
.73331 .50202 L
.73819 .49697 L
.74205 .49128 L
.7448 .48522 L
.7464 .47911 L
.74686 .47324 L
.74627 .46793 L
.74474 .46343 L
.74246 .45998 L
.73964 .45775 L
.73653 .45684 L
.73337 .45732 L
.73043 .45914 L
.72796 .46223 L
.72618 .46642 L
.72527 .47151 L
.72539 .47723 L
.72663 .4833 L
.72902 .4894 L
.73254 .49525 L
.73711 .50052 L
.74261 .50497 L
.74885 .50836 L
.75562 .51053 L
.76267 .51136 L
.76975 .51082 L
.77659 .50892 L
.78296 .50578 L
.78863 .50153 L
.79341 .49641 L
.79716 .49066 L
.79979 .48458 L
.80127 .47848 L
.80162 .47266 L
.80092 .46742 L
.7993 .46302 L
.79696 .45969 L
.7941 .45759 L
.79096 .45683 L
.78782 .45745 L
.78492 .45941 L
.78251 .46262 L
Mistroke
.78081 .46692 L
.78 .47208 L
.78023 .47785 L
.78159 .48394 L
.7841 .49004 L
.78774 .49583 L
.79242 .50103 L
.798 .50538 L
.80431 .50865 L
.81112 .51068 L
.81818 .51137 L
.82525 .51068 L
.83206 .50865 L
.83836 .50538 L
.84395 .50103 L
.84863 .49583 L
.85226 .49004 L
.85477 .48394 L
.85613 .47785 L
.85636 .47208 L
.85556 .46692 L
.85386 .46262 L
.85145 .45941 L
.84855 .45745 L
.8454 .45683 L
.84227 .45759 L
.83941 .45969 L
.83706 .46302 L
.83545 .46742 L
.83475 .47266 L
.83509 .47848 L
.83657 .48458 L
.8392 .49066 L
.84295 .49641 L
.84773 .50153 L
.8534 .50578 L
.85977 .50892 L
.86662 .51082 L
.8737 .51136 L
.88075 .51053 L
.88751 .50836 L
.89375 .50497 L
.89925 .50052 L
.90383 .49525 L
.90735 .4894 L
.90974 .4833 L
.91097 .47723 L
.91109 .47151 L
.91019 .46642 L
.9084 .46223 L
Mistroke
.90593 .45914 L
.90299 .45732 L
.89984 .45684 L
.89672 .45775 L
.8939 .45998 L
.89162 .46343 L
.8901 .46793 L
.8895 .47324 L
.88996 .47911 L
.89156 .48522 L
.89431 .49128 L
.89817 .49697 L
.90306 .50202 L
.90881 .50615 L
.91524 .50918 L
.92212 .51094 L
.92921 .51134 L
.93624 .51036 L
.94297 .50806 L
.94914 .50455 L
.95455 .5 L
Mfstroke
gsave
.81818 .54296 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.5 .54091 .18636 192.68 347.32 arc
s
.47273 .35455 m
.52727 .33636 L
.52727 .37273 L
F
gsave
.5 .31158 -63 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.5 .45909 .18636 12.6804 167.32 arc
s
.52727 .64545 m
.47273 .66364 L
.47273 .62727 L
F
gsave
.5 .68842 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -64.9688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.562 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.5 -3.46945e-18 0.75 0.25 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.31818 .5 m
.31277 .49545 L
.3066 .49194 L
.29988 .48964 L
.29285 .48866 L
.28576 .48906 L
.27887 .49082 L
.27244 .49385 L
.26669 .49798 L
.26181 .50303 L
.25795 .50872 L
.2552 .51478 L
.2536 .52089 L
.25314 .52676 L
.25373 .53207 L
.25526 .53657 L
.25754 .54002 L
.26036 .54225 L
.26347 .54316 L
.26663 .54268 L
.26957 .54086 L
.27204 .53777 L
.27382 .53358 L
.27473 .52849 L
.27461 .52277 L
.27337 .5167 L
.27098 .5106 L
.26746 .50475 L
.26289 .49948 L
.25739 .49503 L
.25115 .49164 L
.24438 .48947 L
.23733 .48864 L
.23025 .48918 L
.22341 .49108 L
.21704 .49422 L
.21137 .49847 L
.20659 .50359 L
.20284 .50934 L
.20021 .51542 L
.19873 .52152 L
.19838 .52734 L
.19908 .53258 L
.2007 .53698 L
.20304 .54031 L
.2059 .54241 L
.20904 .54317 L
.21218 .54255 L
.21508 .54059 L
.21749 .53738 L
Mistroke
.21919 .53308 L
.22 .52792 L
.21977 .52215 L
.21841 .51606 L
.2159 .50996 L
.21226 .50417 L
.20758 .49897 L
.202 .49462 L
.19569 .49135 L
.18888 .48932 L
.18182 .48863 L
.17475 .48932 L
.16794 .49135 L
.16164 .49462 L
.15605 .49897 L
.15137 .50417 L
.14774 .50996 L
.14523 .51606 L
.14387 .52215 L
.14364 .52792 L
.14444 .53308 L
.14614 .53738 L
.14855 .54059 L
.15145 .54255 L
.1546 .54317 L
.15773 .54241 L
.16059 .54031 L
.16294 .53698 L
.16455 .53258 L
.16525 .52734 L
.16491 .52152 L
.16343 .51542 L
.1608 .50934 L
.15705 .50359 L
.15227 .49847 L
.1466 .49422 L
.14023 .49108 L
.13338 .48918 L
.1263 .48864 L
.11925 .48947 L
.11249 .49164 L
.10625 .49503 L
.10075 .49948 L
.09617 .50475 L
.09265 .5106 L
.09026 .5167 L
.08903 .52277 L
.08891 .52849 L
.08981 .53358 L
.0916 .53777 L
Mistroke
.09407 .54086 L
.09701 .54268 L
.10016 .54316 L
.10328 .54225 L
.1061 .54002 L
.10838 .53657 L
.1099 .53207 L
.1105 .52676 L
.11004 .52089 L
.10844 .51478 L
.10569 .50872 L
.10183 .50303 L
.09694 .49798 L
.09119 .49385 L
.08476 .49082 L
.07788 .48906 L
.07079 .48866 L
.06376 .48964 L
.05703 .49194 L
.05086 .49545 L
.04545 .5 L
Mfstroke
gsave
.18182 .45704 -63 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.68723 .50455 L
.6934 .50806 L
.70012 .51036 L
.70715 .51134 L
.71424 .51094 L
.72113 .50918 L
.72756 .50615 L
.73331 .50202 L
.73819 .49697 L
.74205 .49128 L
.7448 .48522 L
.7464 .47911 L
.74686 .47324 L
.74627 .46793 L
.74474 .46343 L
.74246 .45998 L
.73964 .45775 L
.73653 .45684 L
.73337 .45732 L
.73043 .45914 L
.72796 .46223 L
.72618 .46642 L
.72527 .47151 L
.72539 .47723 L
.72663 .4833 L
.72902 .4894 L
.73254 .49525 L
.73711 .50052 L
.74261 .50497 L
.74885 .50836 L
.75562 .51053 L
.76267 .51136 L
.76975 .51082 L
.77659 .50892 L
.78296 .50578 L
.78863 .50153 L
.79341 .49641 L
.79716 .49066 L
.79979 .48458 L
.80127 .47848 L
.80162 .47266 L
.80092 .46742 L
.7993 .46302 L
.79696 .45969 L
.7941 .45759 L
.79096 .45683 L
.78782 .45745 L
.78492 .45941 L
.78251 .46262 L
Mistroke
.78081 .46692 L
.78 .47208 L
.78023 .47785 L
.78159 .48394 L
.7841 .49004 L
.78774 .49583 L
.79242 .50103 L
.798 .50538 L
.80431 .50865 L
.81112 .51068 L
.81818 .51137 L
.82525 .51068 L
.83206 .50865 L
.83836 .50538 L
.84395 .50103 L
.84863 .49583 L
.85226 .49004 L
.85477 .48394 L
.85613 .47785 L
.85636 .47208 L
.85556 .46692 L
.85386 .46262 L
.85145 .45941 L
.84855 .45745 L
.8454 .45683 L
.84227 .45759 L
.83941 .45969 L
.83706 .46302 L
.83545 .46742 L
.83475 .47266 L
.83509 .47848 L
.83657 .48458 L
.8392 .49066 L
.84295 .49641 L
.84773 .50153 L
.8534 .50578 L
.85977 .50892 L
.86662 .51082 L
.8737 .51136 L
.88075 .51053 L
.88751 .50836 L
.89375 .50497 L
.89925 .50052 L
.90383 .49525 L
.90735 .4894 L
.90974 .4833 L
.91097 .47723 L
.91109 .47151 L
.91019 .46642 L
.9084 .46223 L
Mistroke
.90593 .45914 L
.90299 .45732 L
.89984 .45684 L
.89672 .45775 L
.8939 .45998 L
.89162 .46343 L
.8901 .46793 L
.8895 .47324 L
.88996 .47911 L
.89156 .48522 L
.89431 .49128 L
.89817 .49697 L
.90306 .50202 L
.90881 .50615 L
.91524 .50918 L
.92212 .51094 L
.92921 .51134 L
.93624 .51036 L
.94297 .50806 L
.94914 .50455 L
.95455 .5 L
Mfstroke
gsave
.81818 .54296 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
[ .005 .03 ] 0 setdash
newpath
.5 .54091 .18636 192.68 347.32 arc
s
.47273 .35455 m
.52727 .33636 L
.52727 .37273 L
F
gsave
.5 .31158 -63 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.5 .45909 .18636 12.6804 167.32 arc
s
.52727 .64545 m
.47273 .66364 L
.47273 .62727 L
F
gsave
.5 .68842 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -64.9688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.562 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.75 -3.46945e-18 1 0.25 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.0454545 0.0454545 0.0454545 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.31818 .5 m
.31277 .49545 L
.3066 .49194 L
.29988 .48964 L
.29285 .48866 L
.28576 .48906 L
.27887 .49082 L
.27244 .49385 L
.26669 .49798 L
.26181 .50303 L
.25795 .50872 L
.2552 .51478 L
.2536 .52089 L
.25314 .52676 L
.25373 .53207 L
.25526 .53657 L
.25754 .54002 L
.26036 .54225 L
.26347 .54316 L
.26663 .54268 L
.26957 .54086 L
.27204 .53777 L
.27382 .53358 L
.27473 .52849 L
.27461 .52277 L
.27337 .5167 L
.27098 .5106 L
.26746 .50475 L
.26289 .49948 L
.25739 .49503 L
.25115 .49164 L
.24438 .48947 L
.23733 .48864 L
.23025 .48918 L
.22341 .49108 L
.21704 .49422 L
.21137 .49847 L
.20659 .50359 L
.20284 .50934 L
.20021 .51542 L
.19873 .52152 L
.19838 .52734 L
.19908 .53258 L
.2007 .53698 L
.20304 .54031 L
.2059 .54241 L
.20904 .54317 L
.21218 .54255 L
.21508 .54059 L
.21749 .53738 L
Mistroke
.21919 .53308 L
.22 .52792 L
.21977 .52215 L
.21841 .51606 L
.2159 .50996 L
.21226 .50417 L
.20758 .49897 L
.202 .49462 L
.19569 .49135 L
.18888 .48932 L
.18182 .48863 L
.17475 .48932 L
.16794 .49135 L
.16164 .49462 L
.15605 .49897 L
.15137 .50417 L
.14774 .50996 L
.14523 .51606 L
.14387 .52215 L
.14364 .52792 L
.14444 .53308 L
.14614 .53738 L
.14855 .54059 L
.15145 .54255 L
.1546 .54317 L
.15773 .54241 L
.16059 .54031 L
.16294 .53698 L
.16455 .53258 L
.16525 .52734 L
.16491 .52152 L
.16343 .51542 L
.1608 .50934 L
.15705 .50359 L
.15227 .49847 L
.1466 .49422 L
.14023 .49108 L
.13338 .48918 L
.1263 .48864 L
.11925 .48947 L
.11249 .49164 L
.10625 .49503 L
.10075 .49948 L
.09617 .50475 L
.09265 .5106 L
.09026 .5167 L
.08903 .52277 L
.08891 .52849 L
.08981 .53358 L
.0916 .53777 L
Mistroke
.09407 .54086 L
.09701 .54268 L
.10016 .54316 L
.10328 .54225 L
.1061 .54002 L
.10838 .53657 L
.1099 .53207 L
.1105 .52676 L
.11004 .52089 L
.10844 .51478 L
.10569 .50872 L
.10183 .50303 L
.09694 .49798 L
.09119 .49385 L
.08476 .49082 L
.07788 .48906 L
.07079 .48866 L
.06376 .48964 L
.05703 .49194 L
.05086 .49545 L
.04545 .5 L
Mfstroke
gsave
.18182 .45704 -63 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.68723 .50455 L
.6934 .50806 L
.70012 .51036 L
.70715 .51134 L
.71424 .51094 L
.72113 .50918 L
.72756 .50615 L
.73331 .50202 L
.73819 .49697 L
.74205 .49128 L
.7448 .48522 L
.7464 .47911 L
.74686 .47324 L
.74627 .46793 L
.74474 .46343 L
.74246 .45998 L
.73964 .45775 L
.73653 .45684 L
.73337 .45732 L
.73043 .45914 L
.72796 .46223 L
.72618 .46642 L
.72527 .47151 L
.72539 .47723 L
.72663 .4833 L
.72902 .4894 L
.73254 .49525 L
.73711 .50052 L
.74261 .50497 L
.74885 .50836 L
.75562 .51053 L
.76267 .51136 L
.76975 .51082 L
.77659 .50892 L
.78296 .50578 L
.78863 .50153 L
.79341 .49641 L
.79716 .49066 L
.79979 .48458 L
.80127 .47848 L
.80162 .47266 L
.80092 .46742 L
.7993 .46302 L
.79696 .45969 L
.7941 .45759 L
.79096 .45683 L
.78782 .45745 L
.78492 .45941 L
.78251 .46262 L
Mistroke
.78081 .46692 L
.78 .47208 L
.78023 .47785 L
.78159 .48394 L
.7841 .49004 L
.78774 .49583 L
.79242 .50103 L
.798 .50538 L
.80431 .50865 L
.81112 .51068 L
.81818 .51137 L
.82525 .51068 L
.83206 .50865 L
.83836 .50538 L
.84395 .50103 L
.84863 .49583 L
.85226 .49004 L
.85477 .48394 L
.85613 .47785 L
.85636 .47208 L
.85556 .46692 L
.85386 .46262 L
.85145 .45941 L
.84855 .45745 L
.8454 .45683 L
.84227 .45759 L
.83941 .45969 L
.83706 .46302 L
.83545 .46742 L
.83475 .47266 L
.83509 .47848 L
.83657 .48458 L
.8392 .49066 L
.84295 .49641 L
.84773 .50153 L
.8534 .50578 L
.85977 .50892 L
.86662 .51082 L
.8737 .51136 L
.88075 .51053 L
.88751 .50836 L
.89375 .50497 L
.89925 .50052 L
.90383 .49525 L
.90735 .4894 L
.90974 .4833 L
.91097 .47723 L
.91109 .47151 L
.91019 .46642 L
.9084 .46223 L
Mistroke
.90593 .45914 L
.90299 .45732 L
.89984 .45684 L
.89672 .45775 L
.8939 .45998 L
.89162 .46343 L
.8901 .46793 L
.8895 .47324 L
.88996 .47911 L
.89156 .48522 L
.89431 .49128 L
.89817 .49697 L
.90306 .50202 L
.90881 .50615 L
.91524 .50918 L
.92212 .51094 L
.92921 .51134 L
.93624 .51036 L
.94297 .50806 L
.94914 .50455 L
.95455 .5 L
Mfstroke
gsave
.81818 .54296 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.68469 .49385 L
.68633 .48708 L
.6866 .47997 L
.68544 .47285 L
.68289 .46606 L
.67907 .45993 L
.67417 .45474 L
.66846 .45072 L
.66223 .44797 L
.65577 .44652 L
.64938 .44631 L
.64329 .4472 L
.63771 .44899 L
.63283 .45144 L
.62875 .45431 L
.62558 .45736 L
.62339 .46036 L
.6222 .46312 L
.62204 .46549 L
.62289 .46733 L
.6247 .46856 L
.62738 .46909 L
.6308 .46886 L
.6348 .46781 L
.63916 .46589 L
.64363 .46307 L
.64795 .45934 L
.65182 .4547 L
.65497 .44924 L
.65715 .44307 L
.65813 .43641 L
.65777 .4295 L
.65602 .42264 L
.65289 .41616 L
.64851 .41039 L
.64308 .4056 L
.63688 .40201 L
.63022 .39976 L
.62341 .3989 L
.61676 .39937 L
.61052 .40103 L
.60489 .40369 L
.60002 .40709 L
.596 .41097 L
.59289 .41503 L
.59068 .41903 L
.58938 .42271 L
.58896 .42587 L
.58939 .42836 L
Mistroke
.59061 .43004 L
.59255 .43084 L
.59511 .43069 L
.59815 .42959 L
.60151 .42751 L
.60499 .42449 L
.60833 .42057 L
.61129 .4158 L
.6136 .41031 L
.61501 .40423 L
.61531 .39776 L
.61435 .39114 L
.61205 .38466 L
.60844 .37863 L
.60361 .37333 L
.59776 .36905 L
.59119 .366 L
.5842 .36432 L
.57713 .36407 L
.57032 .36519 L
.56403 .36756 L
.55848 .37099 L
.55382 .37521 L
.55012 .37996 L
.54738 .38495 L
.54557 .38988 L
.54462 .39451 L
.54444 .39859 L
.54495 .40194 L
.54604 .40439 L
.54763 .40585 L
.54963 .40624 L
.55194 .40553 L
.55441 .40375 L
.55691 .40093 L
.55924 .39716 L
.56121 .39254 L
.56259 .38722 L
.56317 .38137 L
.56275 .37521 L
.56118 .36899 L
.55839 .36298 L
.55437 .35746 L
.54921 .35274 L
.5431 .34905 L
.53629 .34662 L
.52911 .34557 L
.52191 .34596 L
.51503 .34774 L
.50878 .35078 L
Mistroke
.50339 .35489 L
.49902 .3598 L
.49576 .36525 L
.49358 .37095 L
.49242 .37662 L
.49216 .38199 L
.49265 .38684 L
.49372 .39097 L
.49523 .39421 L
.49702 .39645 L
.49899 .39758 L
.50101 .39758 L
.50298 .39645 L
.50477 .39421 L
.50628 .39097 L
.50735 .38684 L
.50784 .38199 L
.50758 .37662 L
.50642 .37095 L
.50424 .36525 L
.50098 .3598 L
.49661 .35489 L
.49122 .35078 L
.48497 .34774 L
.47809 .34596 L
.47089 .34557 L
.46371 .34662 L
.4569 .34905 L
.45079 .35274 L
.44563 .35746 L
.44161 .36298 L
.43882 .36899 L
.43725 .37521 L
.43683 .38137 L
.43741 .38722 L
.43879 .39254 L
.44076 .39716 L
.44309 .40093 L
.44559 .40375 L
.44806 .40553 L
.45037 .40624 L
.45237 .40585 L
.45396 .40439 L
.45505 .40194 L
.45556 .39859 L
.45538 .39451 L
.45443 .38988 L
.45262 .38495 L
.44988 .37996 L
.44618 .37521 L
Mistroke
.44152 .37099 L
.43597 .36756 L
.42968 .36519 L
.42287 .36407 L
.4158 .36432 L
.40881 .366 L
.40224 .36905 L
.39639 .37333 L
.39156 .37863 L
.38795 .38466 L
.38565 .39114 L
.38469 .39776 L
.38499 .40423 L
.3864 .41031 L
.38871 .4158 L
.39167 .42057 L
.39501 .42449 L
.39849 .42751 L
.40185 .42959 L
.40489 .43069 L
.40745 .43084 L
.40939 .43004 L
.41061 .42836 L
.41104 .42587 L
.41062 .42271 L
.40932 .41903 L
.40711 .41503 L
.404 .41097 L
.39998 .40709 L
.39511 .40369 L
.38948 .40103 L
.38324 .39937 L
.37659 .3989 L
.36978 .39976 L
.36312 .40201 L
.35692 .4056 L
.35149 .41039 L
.34711 .41616 L
.34398 .42264 L
.34223 .4295 L
.34187 .43641 L
.34285 .44307 L
.34503 .44924 L
.34818 .4547 L
.35205 .45934 L
.35637 .46307 L
.36084 .46589 L
.3652 .46781 L
.3692 .46886 L
.37262 .46909 L
Mistroke
.3753 .46856 L
.37711 .46733 L
.37796 .46549 L
.3778 .46312 L
.37661 .46036 L
.37442 .45736 L
.37125 .45431 L
.36717 .45144 L
.36229 .44899 L
.35671 .4472 L
.35062 .44631 L
.34423 .44652 L
.33777 .44797 L
.33154 .45072 L
.32583 .45474 L
.32093 .45993 L
.31711 .46606 L
.31456 .47285 L
.3134 .47997 L
.31367 .48708 L
.31531 .49385 L
.31818 .5 L
Mfstroke
gsave
.5 .31158 -63 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68182 .5 m
.68469 .50615 L
.68633 .51292 L
.6866 .52003 L
.68544 .52715 L
.68289 .53394 L
.67907 .54007 L
.67417 .54526 L
.66846 .54928 L
.66223 .55203 L
.65577 .55348 L
.64938 .55369 L
.64329 .5528 L
.63771 .55101 L
.63283 .54856 L
.62875 .54569 L
.62558 .54264 L
.62339 .53964 L
.6222 .53688 L
.62204 .53451 L
.62289 .53267 L
.6247 .53144 L
.62738 .53091 L
.6308 .53114 L
.6348 .53219 L
.63916 .53411 L
.64363 .53693 L
.64795 .54066 L
.65182 .5453 L
.65497 .55076 L
.65715 .55693 L
.65813 .56359 L
.65777 .5705 L
.65602 .57736 L
.65289 .58384 L
.64851 .58961 L
.64308 .5944 L
.63688 .59799 L
.63022 .60024 L
.62341 .6011 L
.61676 .60063 L
.61052 .59897 L
.60489 .59631 L
.60002 .59291 L
.596 .58903 L
.59289 .58497 L
.59068 .58097 L
.58938 .57729 L
.58896 .57413 L
.58939 .57164 L
Mistroke
.59061 .56996 L
.59255 .56916 L
.59511 .56931 L
.59815 .57041 L
.60151 .57249 L
.60499 .57551 L
.60833 .57943 L
.61129 .5842 L
.6136 .58969 L
.61501 .59577 L
.61531 .60224 L
.61435 .60886 L
.61205 .61534 L
.60844 .62137 L
.60361 .62667 L
.59776 .63095 L
.59119 .634 L
.5842 .63568 L
.57713 .63593 L
.57032 .63481 L
.56403 .63244 L
.55848 .62901 L
.55382 .62479 L
.55012 .62004 L
.54738 .61505 L
.54557 .61012 L
.54462 .60549 L
.54444 .60141 L
.54495 .59806 L
.54604 .59561 L
.54763 .59415 L
.54963 .59376 L
.55194 .59447 L
.55441 .59625 L
.55691 .59907 L
.55924 .60284 L
.56121 .60746 L
.56259 .61278 L
.56317 .61863 L
.56275 .62479 L
.56118 .63101 L
.55839 .63702 L
.55437 .64254 L
.54921 .64726 L
.5431 .65095 L
.53629 .65338 L
.52911 .65443 L
.52191 .65404 L
.51503 .65226 L
.50878 .64922 L
Mistroke
.50339 .64511 L
.49902 .6402 L
.49576 .63475 L
.49358 .62905 L
.49242 .62338 L
.49216 .61801 L
.49265 .61316 L
.49372 .60903 L
.49523 .60579 L
.49702 .60355 L
.49899 .60242 L
.50101 .60242 L
.50298 .60355 L
.50477 .60579 L
.50628 .60903 L
.50735 .61316 L
.50784 .61801 L
.50758 .62338 L
.50642 .62905 L
.50424 .63475 L
.50098 .6402 L
.49661 .64511 L
.49122 .64922 L
.48497 .65226 L
.47809 .65404 L
.47089 .65443 L
.46371 .65338 L
.4569 .65095 L
.45079 .64726 L
.44563 .64254 L
.44161 .63702 L
.43882 .63101 L
.43725 .62479 L
.43683 .61863 L
.43741 .61278 L
.43879 .60746 L
.44076 .60284 L
.44309 .59907 L
.44559 .59625 L
.44806 .59447 L
.45037 .59376 L
.45237 .59415 L
.45396 .59561 L
.45505 .59806 L
.45556 .60141 L
.45538 .60549 L
.45443 .61012 L
.45262 .61505 L
.44988 .62004 L
.44618 .62479 L
Mistroke
.44152 .62901 L
.43597 .63244 L
.42968 .63481 L
.42287 .63593 L
.4158 .63568 L
.40881 .634 L
.40224 .63095 L
.39639 .62667 L
.39156 .62137 L
.38795 .61534 L
.38565 .60886 L
.38469 .60224 L
.38499 .59577 L
.3864 .58969 L
.38871 .5842 L
.39167 .57943 L
.39501 .57551 L
.39849 .57249 L
.40185 .57041 L
.40489 .56931 L
.40745 .56916 L
.40939 .56996 L
.41061 .57164 L
.41104 .57413 L
.41062 .57729 L
.40932 .58097 L
.40711 .58497 L
.404 .58903 L
.39998 .59291 L
.39511 .59631 L
.38948 .59897 L
.38324 .60063 L
.37659 .6011 L
.36978 .60024 L
.36312 .59799 L
.35692 .5944 L
.35149 .58961 L
.34711 .58384 L
.34398 .57736 L
.34223 .5705 L
.34187 .56359 L
.34285 .55693 L
.34503 .55076 L
.34818 .5453 L
.35205 .54066 L
.35637 .53693 L
.36084 .53411 L
.3652 .53219 L
.3692 .53114 L
.37262 .53091 L
Mistroke
.3753 .53144 L
.37711 .53267 L
.37796 .53451 L
.3778 .53688 L
.37661 .53964 L
.37442 .54264 L
.37125 .54569 L
.36717 .54856 L
.36229 .55101 L
.35671 .5528 L
.35062 .55369 L
.34423 .55348 L
.33777 .55203 L
.33154 .54928 L
.32583 .54526 L
.32093 .54007 L
.31711 .53394 L
.31456 .52715 L
.3134 .52003 L
.31367 .51292 L
.31531 .50615 L
.31818 .5 L
Mfstroke
gsave
.5 .68842 -63 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 8.188 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04 w
.31818 .5 Mdot
.68182 .5 Mdot
gsave
.5 .02273 -64.9688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.562 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 72},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000B2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00903oool3000004<0oooo100000140?ooo`<00000A03oool3000002@0oooo000U0?ooo`03
0000003oool0oooo04<0oooo0P0000170?ooo`030000003oool0oooo0440oooo1000000T0?ooo`00
9@3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0
@P3oool00`000000oooo0000000U0?ooo`009@3oool00`000000oooo0?ooo`130?ooo`<00000A03o
ool3000004@0oooo0P00000U0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00K03oool00`000000oooo0?ooo`140?ooo`030000003oool0
oooo0400oooo2000000R0?ooo`00I`3oool:00000400oooo0`00000o0?ooo`@000000P3oool20000
0080oooo1000000O0?ooo`00I@3oool2000000X0oooo0P00000j0?ooo`800000203oool2000003T0
oooo0P0000000`3oool00000000000020?ooo`8000000P3oool2000000030?ooo`000000000001h0
oooo001T0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0N`3oool200000080oooo
0P0000020?ooo`8000000P3oool200000080oooo0P00000M0?ooo`00H`3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0`0?ooo`@000000P3oool200000080oooo0P0000020?ooo`8000000P3oool4000001/0oooo001R
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo0300oooo00<000000?ooo`0000000P00000<0?ooo`<0000000<0oooo
0000003oool06P3oool00640oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`1e0?oo
o`040000003oool0oooo0?ooo`800000303oool2000000<0oooo00<000000?ooo`3oool0603oool0
0600oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`1d0?ooo`<000004P3oool30000
01X0oooo000X0?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080
oooo0P0000020?ooo`8000007@3oool00`000000oooo0?ooo`0F0?ooo`040000003oool0oooo0?oo
o`8000000P3oool2000000050?ooo`00000000000000003oool00P00000N0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool00P3oool200000080oooo0P0000001@3oool0000000000000
0000oooo008000007@3oool00`000000oooo0000000200000100oooo0`0000000`3oool000000?oo
o`020?ooo`8000000P3oool2000000050?ooo`00000000000000003oool00P0000090?ooo`00:03o
ool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3o
ool00`000000oooo0000000L0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00`00
0000303oool000000?ooo`000000oooo0000003oool000000?ooo`000000oooo000001`0oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`030000000<0?ooo`000000oooo0000003oool0
00000?ooo`000000oooo0000003oool000006`3oool200000080oooo0P00000@0?ooo`8000000P3o
ool20000000@0?ooo`00000000000000003oool000000?ooo`000000oooo0000003oool000000?oo
o`000000oooo000000P0oooo00050?ooo`<0000000D0oooo00000000000000000?ooo`0300000004
0?ooo`000000000000000080oooo1P000000103oool000000000000000020?ooo`<0000000<0oooo
0000000000000P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool2
00000080oooo0`0000090?ooo`<0000000D0oooo00000000000000000?ooo`03000000050?ooo`00
000000000000003oool01000000H0?ooo`040000003oool0oooo0?ooo`80000000D0oooo00000000
000000000?ooo`03000000040?ooo`0000000000000000T0oooo0`0000001@3oool0000000000000
0000oooo00<0000000D0oooo00000000000000000?ooo`03000001d0oooo0P0000001@3oool00000
000000000000oooo00<0000000@0oooo00000000000000002@3oool3000000050?ooo`0000000000
0000003oool00`0000001@3oool00000000000000000oooo00<000006P3oool00`000000oooo0?oo
o`02000000050?ooo`00000000000000003oool00`000000103oool000000000000000080?ooo`00
103oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000
0P3oool200000080oooo0`000000103oool000000000003oool300000080oooo0P0000020?ooo`80
00000P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000050?ooo`80
000000D0oooo00000000000000000?ooo`0200000080oooo0P0000020?ooo`8000000P3oool20000
01P0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000001@3oool00000000000000000
oooo008000001@3oool2000000050?ooo`00000000000000003oool00P0000020?ooo`8000000P3o
ool200000080oooo0P00000H0?ooo`8000000P3oool200000080oooo0P0000020?ooo`80000000D0
oooo00000000000000000?ooo`02000000D0oooo0P0000001@3oool00000000000000000oooo0080
00000P3oool200000080oooo0P0000020?ooo`800000603oool200000080oooo0P0000020?ooo`80
00000P3oool2000000050?ooo`00000000000000003oool00P0000050?ooo`00203oool200000080
oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`H000000`3oool800000003
0?ooo`000000000000@000000P3oool3000000050?ooo`00000000000000003oool00`000000103o
ool000000000000000090?ooo`<0000000D0oooo00000000000000000?ooo`03000000030?ooo`00
0000000000<0oooo00<000000?ooo`3oool05P3oool4000000050?ooo`00000000000000003oool0
0`0000001@3oool00000000000000000oooo00<000002@3oool3000000050?ooo`00000000000000
003oool00`0000000`3oool00000000000030?ooo`030000003oool0oooo01L0oooo0`0000001@3o
ool00000000000000000oooo00<0000000D0oooo00000000000000000?ooo`03000000T0oooo0`00
00001@3oool00000000000000000oooo00<0000000<0oooo0000000000000P3oool2000001T0oooo
0`0000001@3oool00000000000000000oooo00<0000000D0oooo00000000000000000?ooo`030000
00H0oooo00070?ooo`030000003oool000000080oooo0P0000020?ooo`8000000P3oool200000080
oooo0P0000020?ooo`<0000000@0oooo0000000000000000103oool3000000030?ooo`000000oooo
0240oooo00`000000?ooo`000000oooo0000003oool000000?ooo`000000oooo0000003oool30000
0080oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0J0?ooo`0<0000003oool00000
0?ooo`000000oooo0000003oool000000?ooo`000000oooo0`0000020?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool06P3oool030000000oooo0000003oool000000?ooo`000000oooo
0000003oool000000?ooo`<0000000<0oooo0000000000000P3oool200000100oooo0P0000020?oo
o`800000603oool000P0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`80
00000P3oool200000080oooo0`0000040?ooo`8000000`3oool00`000000oooo0?ooo`0P0?ooo`80
000000D0oooo00000000000000000?ooo`0200000080oooo0P0000040?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0703oool2000000050?ooo`00000000000000003oool00P000002
0?ooo`800000103oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01`0oooo0P000000
1@3oool00000000000000000oooo008000000P3oool2000000<0oooo1@00000@0?ooo`D000006@3o
ool001d0oooo0P0000020?ooo`800000103oool200000080oooo0P00000c0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0M03oool300000180oooo0`00000J0?ooo`00703oool40000
00X0oooo1000000c0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0M@3oool01000
0000oooo0?ooo`3oool2000000`0oooo0P0000030?ooo`030000003oool0oooo01P0oooo000K0?oo
o`030000003oool0oooo00<00000203oool300000080oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0<03oool00`00
0000oooo00000002000000`0oooo0`0000000`3oool000000?ooo`0J0?ooo`006`3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`150?ooo`030000003oool0oooo0300oooo100000020?ooo`8000000P3oool200000080
oooo0P0000020?ooo`@000006`3oool001/0oooo1000000<0?ooo`@00000=@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo07/0oooo0P0000020?ooo`8000000P3oool200000080oooo
0P0000020?ooo`8000007@3oool001`0oooo1000000:0?ooo`D00000=P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo03P0oooo0P0000080?ooo`800000>@3oool2000000030?ooo`00
000000000080oooo0P0000020?ooo`80000000<0oooo0000000000007P3oool001/0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0e0?ooo``00000?`3oool3000003l0oooo10000002
0?ooo`8000000P3oool4000001l0oooo000K0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0>@3oool2000004D0oooo0P0000130?ooo`P000008P3oool001/0oooo0P0000000`3oool0
00000000000:0?ooo`80000000<0oooo000000000000l@3oool001`0oooo1000000:0?ooo`@00000
lP3oool001d0oooo00@000000?ooo`3oool0oooo0P0000040?ooo`8000000`3oool00`000000oooo
0?ooo`3a0?ooo`007@3oool00`000000oooo0?ooo`03000000040?ooo`00000000000?ooo`<00000
0P3oool00`000000oooo0?ooo`3a0?ooo`007P3oool400000080oooo0P0000020?ooo`@00000m03o
ool00200oooo0P0000020?ooo`8000000P3oool200000?H0oooo000Q0?ooo`P00000m`3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {71, 0}} -> {-0.465235, -0.000110001, \
0.309863, 0.309863}, {{1.5, 72.5}, {71, 0}} -> {-1.4649, -1.00011, 0.309863, \
0.309863}, {{72.5, 143.5}, {71, 0}} -> {-23.4651, -1.00011, 0.309863, \
0.309863}, {{143.5, 214.5}, {71, 0}} -> {-45.4654, -1.00011, 0.309863, \
0.309863}, {{214.5, 285.5}, {71, 0}} -> {-67.4656, -1.00011, 0.309863, \
0.309863}}]
}, Open  ]],

Cell["\<\
Inserting the analytical expressions. The momentum flowing into the \
loop is p, since the outgoing momentum is k1 and by definition from the Model \
file p1+k1=0 we have to replace k1 by -p. The loop momentum is q and the \
Lorentz indices of the external gluons are \[Mu] and \[Nu].\
\>", "Text"],

Cell[BoxData[
    \(\(amps = \ \(\(CreateFeynAmp[inserts, Truncated \[Rule] True, 
                PreFactor \[Rule] 1, 
                AmplitudeLevel \[Rule] {Classes}] /. {p1 \[RuleDelayed] p, 
                q1 \[RuleDelayed] q, li1 \[RuleDelayed] \[Mu], 
                li2 \[RuleDelayed] \[Nu]}\) /. 
            FeynAmpList[__] \[RuleDelayed] List\)\  /. \ 
          FeynAmp[_, _, x_] \[RuleDelayed] x;\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculating the bare 2-loop on-shell gluon selfenergy \
diagrams\
\>", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[amps]\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              
              RowBox[{\(1\/2\), " ", \(\(\[CapitalPi]\_g\%\(li3  li4\)\)(q)\),
                 " ", 
                
                RowBox[{\(V\_\(ci1  ci2  ci4  ci4\)\%\(\[Mu]  \[Nu]  li3  
                        li4\)\), "(", 
                  RowBox[{"p", \(\(,\)\(\ \)\), 
                    FormBox[\(-p\),
                      "TraditionalForm"], \(\(,\)\(\ \)\), 
                    FormBox[\(-q\),
                      "TraditionalForm"], \(\(,\)\(\ \)\), "q"}], ")"}]}]},
            {
              RowBox[{"-", 
                RowBox[{"tr", "(", 
                  FormBox[
                    RowBox[{"2", " ", \(N\_f\), " ", \(T\_f\), " ", 
                      RowBox[{\(\(\[CapitalPi]\_q\)(q)\), ".", 
                        SubscriptBox["T", 
                          FormBox["ci2",
                            "TraditionalForm"]], ".", \(Q\^\[Nu]\), ".", 
                        RowBox[{\(\[CapitalPi]\_q\), "(", 
                          FormBox[\(q - p\),
                            "TraditionalForm"], ")"}], ".", 
                        SubscriptBox["T", 
                          FormBox["ci1",
                            "TraditionalForm"]], ".", \(Q\^\[Mu]\)}]}],
                    "TraditionalForm"], ")"}]}]},
            {
              RowBox[{\(-\(\(\[CapitalPi]\_u\)(q)\)\), " ", 
                RowBox[{\(\[CapitalPi]\_u\), "(", 
                  FormBox[\(q - p\),
                    "TraditionalForm"], ")"}], 
                " ", \(\(\(\[CapitalLambda]\&~\)\^\[Nu]\)(q)\), " ", 
                RowBox[{\(\(\[CapitalLambda]\&~\)\^\[Mu]\), "(", 
                  FormBox[\(q - p\),
                    "TraditionalForm"], ")"}], " ", \(f\_\(ci3  ci5  ci2\)\), 
                " ", \(f\_\(ci5  ci3  ci1\)\)}]},
            {
              RowBox[{\(1\/2\), " ", 
                RowBox[{\(\[CapitalPi]\_g\%\(li5  li6\)\), "(", 
                  FormBox[\(p - q\),
                    "TraditionalForm"], ")"}], 
                " ", \(\(\[CapitalPi]\_g\%\(li3  li4\)\)(q)\), " ", 
                RowBox[{\(V\^\(\[Nu]  li4  li6\)\), "(", 
                  RowBox[{
                    FormBox[\(-p\),
                      "TraditionalForm"], \(\(,\)\(\ \)\), 
                    "q", \(\(,\)\(\ \)\), 
                    FormBox[\(p - q\),
                      "TraditionalForm"]}], ")"}], " ", 
                RowBox[{\(V\^\(\[Mu]  li3  li5\)\), "(", 
                  RowBox[{"p", \(\(,\)\(\ \)\), 
                    FormBox[\(-q\),
                      "TraditionalForm"], \(\(,\)\(\ \)\), 
                    FormBox[\(q - p\),
                      "TraditionalForm"]}], ")"}], 
                " ", \(f\_\(ci1  ci4  ci6\)\), 
                " ", \(f\_\(ci2  ci4  ci6\)\)}]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {
          Times[ 
            Rational[ 1, 2], 
            GluonPropagator[ q, {li3}, {li4}], 
            GluonVertex[ {p, \[Mu], ci1}, {
              Times[ -1, p], \[Nu], ci2}, {
              Times[ -1, q], li3, ci4}, {q, li4, ci4}]], 
          Times[ -1, 
            DiracTrace[ 
              Times[ 2, Nf, Tf, 
                Dot[ 
                  QuarkPropagator[ {q, QuarkMass}], 
                  SUNT[ ci2], 
                  QuarkGluonVertex[ \[Nu]], 
                  QuarkPropagator[ {
                    Plus[ 
                      Times[ -1, p], q], QuarkMass}], 
                  SUNT[ ci1], 
                  QuarkGluonVertex[ \[Mu]]]]]], 
          Times[ -1, 
            GhostPropagator[ q], 
            GhostPropagator[ 
              Plus[ 
                Times[ -1, p], q]], 
            GluonGhostVertex[ q, \[Nu]], 
            GluonGhostVertex[ 
              Plus[ 
                Times[ -1, p], q], \[Mu]], 
            SUNF[ ci3, ci5, ci2], 
            SUNF[ ci5, ci3, ci1]], 
          Times[ 
            Rational[ 1, 2], 
            GluonPropagator[ 
              Plus[ p, 
                Times[ -1, q]], {li5}, {li6}], 
            GluonPropagator[ q, {li3}, {li4}], 
            GluonVertex[ {
              Times[ -1, p], \[Nu]}, {q, li4}, {
              Plus[ p, 
                Times[ -1, q]], li6}], 
            GluonVertex[ {p, \[Mu]}, {
              Times[ -1, q], li3}, {
              Plus[ 
                Times[ -1, p], q], li5}], 
            SUNF[ ci1, ci4, ci6], 
            SUNF[ ci2, ci4, ci6]]}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
We recognize the combinatorical factors and minus signs provided by \
FeynArts.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The ghost loop", "Subsection"],

Cell["\<\
Explicitly inserting the Feynman rules for a general gauge and \
summing the amplitudes.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gh1\  = amps[\([3]\)]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(-\(\(\[CapitalPi]\_u\)(q)\)\), " ", 
        RowBox[{\(\[CapitalPi]\_u\), "(", 
          FormBox[\(q - p\),
            "TraditionalForm"], ")"}], 
        " ", \(\(\(\[CapitalLambda]\&~\)\^\[Nu]\)(q)\), " ", 
        RowBox[{\(\(\[CapitalLambda]\&~\)\^\[Mu]\), "(", 
          FormBox[\(q - p\),
            "TraditionalForm"], ")"}], " ", \(f\_\(ci3  ci5  ci2\)\), 
        " ", \(f\_\(ci5  ci3  ci1\)\)}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gh2 = SUNSimplify[Explicit[gh1, Dimension \[Rule] D]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        FractionBox[
          RowBox[{\(C\_A\), " ", \(g\_s\%2\), " ", 
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox[
                  FormBox["q",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], "-", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], ")"}], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SubscriptBox["\[Delta]", 
              RowBox[{
                FormBox[
                  FormBox["ci1",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["ci2",
                    "TraditionalForm"],
                  "TraditionalForm"]}]]}], \(q\^2\ \((q - p)\)\^2\)]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gh3 = \(\(Collect2[Contract[gh2], \[Xi]] /. CA \[Rule] 1\) /. 
          Gstrong \[Rule] 1\) /. SUNDelta[__] \[RuleDelayed] 1\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], \(q\^2\ \((q - p)\)\^2\)], "-", 
        FractionBox[
          RowBox[{
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], \(q\^2\ \((q - p)\)\^2\)]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
Do a tensor integral decomposition by using the function TID.\
\>", \
"Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gh4 = TID[gh3, q]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                FractionBox[
                  RowBox[{"D", " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Nu]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], 
                  RowBox[{\((1 - D)\), " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "4"]}]], "-", 
                FractionBox[\(g\^\(\[Mu]  \[Nu]\)\), 
                  RowBox[{\((1 - D)\), " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}]]}], ")"}], " ", 
            SuperscriptBox[
              FormBox[
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}],
                "TraditionalForm"], "2"]}], \(q\^2 . \((q - p)\)\^2\)], "+", 
        FractionBox[
          RowBox[{
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], 
          RowBox[{\(q\^2 . \((q - p)\)\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}]], "+", 
        FractionBox[
          RowBox[{
            RowBox[{"(", 
              RowBox[{\(g\^\(\[Mu]  \[Nu]\)\/\(1 - D\)\), "-", 
                FractionBox[
                  RowBox[{
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Nu]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], 
                  RowBox[{\((1 - D)\), " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}]]}], ")"}], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(q\^2 . \((q - p)\)\^2\)]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ToFI\)\)], "Input"],

Cell[BoxData[
    \("ToFI[expr, {q1, q2}, {p}] translates all non-tensorial  loop integrals \
in expr into TFI notation from Tarcer.  ToFI[expr, {q}, {p}] introduces TBI \
B0-like integrals. ToFI can be extended to more external particles and more \
loops if needed."\)], "Print",
  CellTags->"Info3288437846-1512755"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ghostloop = ToFI[gh4, {q}, {p}] // Factor2\)], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          RowBox[{"(", 
            
            RowBox[{\(\(-D\)\ p\^\[Mu]\ p\^\[Nu]\), 
              "+", \(2\ p\^\[Mu]\ p\^\[Nu]\), "-", 
              RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"]}]}], ")"}], " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["B",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\({1, 0}\),
                  "TraditionalForm"], 
                FormBox[\({1, 0}\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["D",
                  "TraditionalForm"], ")"}]],
            TBI[ D, 
              SPD[ p, p], {{1, 0}, {1, 0}}],
            Editable->True]}], \(4\ \((1 - D)\)\)], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% // InputForm\)], "Input"],

Cell["\<\
((2*FVD[p, \[Mu]]*FVD[p, \[Nu]] - D*FVD[p, \[Mu]]*FVD[p, \[Nu]] - \
MTD[\[Mu], \[Nu]]*SPD[p, p])*
  TBI[D, SPD[p, p], {{1, 0}, {1, 0}}])/(4*(1 - D))\
\>", "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The gluon loop", "Subsection"],

Cell["\<\
Explicitly inserting the Feynman rules for a general gauge and \
summing the amplitudes.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gl1\  = amps[\([4]\)]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(1\/2\), " ", 
        RowBox[{\(\[CapitalPi]\_g\%\(li5  li6\)\), "(", 
          FormBox[\(p - q\),
            "TraditionalForm"], ")"}], 
        " ", \(\(\[CapitalPi]\_g\%\(li3  li4\)\)(q)\), " ", 
        RowBox[{\(V\^\(\[Nu]  li4  li6\)\), "(", 
          RowBox[{
            FormBox[\(-p\),
              "TraditionalForm"], \(\(,\)\(\ \)\), "q", \(\(,\)\(\ \)\), 
            FormBox[\(p - q\),
              "TraditionalForm"]}], ")"}], " ", 
        RowBox[{\(V\^\(\[Mu]  li3  li5\)\), "(", 
          RowBox[{"p", \(\(,\)\(\ \)\), 
            FormBox[\(-q\),
              "TraditionalForm"], \(\(,\)\(\ \)\), 
            FormBox[\(q - p\),
              "TraditionalForm"]}], ")"}], " ", \(f\_\(ci1  ci4  ci6\)\), 
        " ", \(f\_\(ci2  ci4  ci6\)\)}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gl2 = 
      SUNSimplify[
        Explicit[gl1, Gauge \[Rule] 1 - \[Xi], 
          Dimension \[Rule] D]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{\(1\/\(2\ \((p - q)\)\^2\ q\^2\)\), 
          RowBox[{"(", 
            RowBox[{\(C\_A\), " ", \(g\_s\%2\), " ", 
              RowBox[{"(", 
                RowBox[{
                  FractionBox[
                    RowBox[{"\[Xi]", " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["li3",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["li4",
                            "TraditionalForm"],
                          "TraditionalForm"]]}], \(q\^2\)], 
                  "-", \(g\^\(li3  li4\)\)}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  FractionBox[
                    RowBox[{"\[Xi]", " ", 
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox[
                            FormBox["p",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["li5",
                                "TraditionalForm"],
                              "TraditionalForm"]], "-", 
                          SuperscriptBox[
                            FormBox["q",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["li5",
                                "TraditionalForm"],
                              "TraditionalForm"]]}], ")"}], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox[
                            FormBox["p",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["li6",
                                "TraditionalForm"],
                              "TraditionalForm"]], "-", 
                          SuperscriptBox[
                            FormBox["q",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["li6",
                                "TraditionalForm"],
                              "TraditionalForm"]]}], 
                        ")"}]}], \(\((p - q)\)\^2\)], 
                  "-", \(g\^\(li5  li6\)\)}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        SuperscriptBox[
                          FormBox["q",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["li3",
                              "TraditionalForm"],
                            "TraditionalForm"]], "-", 
                        RowBox[{"2", " ", 
                          SuperscriptBox[
                            FormBox["p",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["li3",
                                "TraditionalForm"],
                              "TraditionalForm"]]}]}], ")"}], 
                    " ", \(g\^\(li5  \[Mu]\)\)}], "+", 
                  RowBox[{\(g\^\(li3  \[Mu]\)\), " ", 
                    RowBox[{"(", 
                      RowBox[{
                        SuperscriptBox[
                          FormBox["p",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["li5",
                              "TraditionalForm"],
                            "TraditionalForm"]], "+", 
                        SuperscriptBox[
                          FormBox["q",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["li5",
                              "TraditionalForm"],
                            "TraditionalForm"]]}], ")"}]}], "+", 
                  RowBox[{\(g\^\(li3  li5\)\), " ", 
                    RowBox[{"(", 
                      RowBox[{
                        SuperscriptBox[
                          FormBox["p",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"]], "-", 
                        RowBox[{"2", " ", 
                          SuperscriptBox[
                            FormBox["q",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["\[Mu]",
                                "TraditionalForm"],
                              "TraditionalForm"]]}]}], ")"}]}]}], ")"}], " ", 
              
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"2", " ", 
                          SuperscriptBox[
                            FormBox["p",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["li4",
                                "TraditionalForm"],
                              "TraditionalForm"]]}], "-", 
                        SuperscriptBox[
                          FormBox["q",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["li4",
                              "TraditionalForm"],
                            "TraditionalForm"]]}], ")"}], 
                    " ", \(g\^\(li6  \[Nu]\)\)}], "+", 
                  RowBox[{\(g\^\(li4  \[Nu]\)\), " ", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"-", 
                          SuperscriptBox[
                            FormBox["p",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["li6",
                                "TraditionalForm"],
                              "TraditionalForm"]]}], "-", 
                        SuperscriptBox[
                          FormBox["q",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["li6",
                              "TraditionalForm"],
                            "TraditionalForm"]]}], ")"}]}], "+", 
                  RowBox[{\(g\^\(li4  li6\)\), " ", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"2", " ", 
                          SuperscriptBox[
                            FormBox["q",
                              "TraditionalForm"], 
                            FormBox[
                              FormBox["\[Nu]",
                                "TraditionalForm"],
                              "TraditionalForm"]]}], "-", 
                        SuperscriptBox[
                          FormBox["p",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]]}], ")"}]}]}], ")"}], " ", 
              SubscriptBox["\[Delta]", 
                RowBox[{
                  FormBox[
                    FormBox["ci1",
                      "TraditionalForm"],
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["ci2",
                      "TraditionalForm"],
                    "TraditionalForm"]}]]}], ")"}]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gl3 = \(\(Collect2[Contract[gl2], \[Xi]] /. CA \[Rule] 1\) /. 
          Gstrong \[Rule] 1\) /. SUNDelta[__] \[RuleDelayed] 1\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(1\/2\), " ", \(\[Xi]\^2\), 
          " ", \(\((1\/\((p - q)\)\^2)\)\^2\), " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SuperscriptBox[
                  FormBox["q",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "2"]}], "-", 
              RowBox[{
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], " ", 
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}]}]}], ")"}], " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SuperscriptBox[
                  FormBox["q",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "2"]}], "-", 
              RowBox[{
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], " ", 
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}]}]}], ")"}], 
          " ", \(\((1\/q\^2)\)\^2\)}], "-", 
        FractionBox[
          RowBox[{
            RowBox[{\(-D\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{"6", " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{"2", " ", "D", " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{"3", " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{"2", " ", "D", " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{"3", " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{"4", " ", "D", " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{"6", " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{"5", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}], "+", 
            RowBox[{"2", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
              RowBox[{
                FormBox["p",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}], "-", 
            RowBox[{"2", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], "2"]}]}], \(2\ \((p - q)\)\^2\ q\^2\)], 
        "+", 
        RowBox[{\(1\/\(2\ \((p - q)\)\^2\ q\^2\)\), 
          RowBox[{"(", 
            RowBox[{"\[Xi]", " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"-", 
                    FractionBox[
                      RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                        SuperscriptBox[
                          FormBox["p",
                            "TraditionalForm"], "4"]}], \(\((p - q)\)\^2\)]}],
                   "+", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], "2"]}], \(\((p - q)\)\^2\)], 
                  "-", 
                  FractionBox[
                    RowBox[{"2", " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], "2"]}], \(\((p - q)\)\^2\)], 
                  "-", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], "2"]}], \(q\^2\)], "+", 
                  FractionBox[
                    RowBox[{"2", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], "2"], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], \(\((p - q)\)\^2\)], 
                  "-", 
                  FractionBox[
                    RowBox[{"4", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                      SuperscriptBox[
                        FormBox[
                          RowBox[{
                            FormBox["p",
                              "TraditionalForm"], "\[CenterDot]", 
                            FormBox["q",
                              "TraditionalForm"]}],
                          "TraditionalForm"], "2"]}], \(q\^2\)], "-", 
                  FractionBox[
                    RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "4"]}], \(\((p - q)\)\^2\)], 
                  "-", 
                  FractionBox[
                    RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "4"]}], \(q\^2\)], "+", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      RowBox[{
                        FormBox["p",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}]}], \(\((p - q)\)\^2\)], "+", 
                  FractionBox[
                    RowBox[{"3", " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      RowBox[{
                        FormBox["p",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}]}], \(q\^2\)], "+", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      RowBox[{
                        FormBox["p",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}]}], \(\((p - q)\)\^2\)], "+", 
                  FractionBox[
                    RowBox[{"3", " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      RowBox[{
                        FormBox["p",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}]}], \(q\^2\)], "-", 
                  FractionBox[
                    RowBox[{"2", " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      RowBox[{
                        FormBox["p",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}]}], \(q\^2\)], "-", 
                  FractionBox[
                    RowBox[{"2", " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], \(\((p - q)\)\^2\)], 
                  "-", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], \(q\^2\)], "-", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], \(q\^2\)], "-", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], \(q\^2\)], "+", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], \(\((p - q)\)\^2\)], 
                  "+", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Mu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], 
                        FormBox[
                          FormBox["\[Nu]",
                            "TraditionalForm"],
                          "TraditionalForm"]], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], \(q\^2\)], "+", 
                  FractionBox[
                    RowBox[{"4", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                      RowBox[{
                        FormBox["p",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}], " ", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], \(q\^2\)]}], ")"}]}], 
            ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This is the ",
  Cell[BoxData[
      \(TraditionalForm\`A\_\[Mu]\[Nu]\)]],
  "in eq. (A.3) from T.Muta's book \"Foundation of Quantum Chromodynamics\"."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Collect2[\(2\ Coefficient[gl3, \[Xi], 0] /. p \[Rule] \((\(-k\))\)\) /. 
        FeynAmpDenominator[__] \[RuleDelayed] 1, LorentzIndex, 
      Factoring \[Rule] False]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\((D - 6)\), " ", 
          SuperscriptBox[
            FormBox["k",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SuperscriptBox[
            FormBox["k",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{\((2\ D - 3)\), " ", 
          SuperscriptBox[
            FormBox["q",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SuperscriptBox[
            FormBox["k",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{\((2\ D - 3)\), " ", 
          SuperscriptBox[
            FormBox["k",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SuperscriptBox[
            FormBox["q",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{\((4\ D - 6)\), " ", 
          SuperscriptBox[
            FormBox["q",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SuperscriptBox[
            FormBox["q",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], "+", 
        RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"5", " ", 
                SuperscriptBox[
                  FormBox["k",
                    "TraditionalForm"], "2"]}], "+", 
              RowBox[{"2", " ", 
                RowBox[{
                  FormBox["k",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}]}], "+", 
              RowBox[{"2", " ", 
                SuperscriptBox[
                  FormBox["q",
                    "TraditionalForm"], "2"]}]}], ")"}]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "This should be the ",
  Cell[BoxData[
      \(TraditionalForm\`B\_\[Mu]\[Nu]\)]],
  "in eq. (A.4) from T.Muta's book \"Foundation of Quantum Chromodynamics\"."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(bmunu = 
      Collect2[FCI[
          FCE[FDS[Coefficient[2\ gl3, \[Xi], 1], q] /. 
              p \[Rule] \((\(-k\))\)]], {\[Mu], \[Nu]}]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox[
            RowBox[{"2", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"2", " ", 
                      RowBox[{
                        FormBox["k",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}]}], "+", 
                    SuperscriptBox[
                      FormBox["q",
                        "TraditionalForm"], "2"]}], ")"}], "2"]}], \(q\^2 . 
              q\^2 . \((k + q)\)\^2\)]}], "-", 
        FractionBox[
          RowBox[{"2", " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox[
                  FormBox["k",
                    "TraditionalForm"], "2"], "-", 
                RowBox[{"2", " ", 
                  RowBox[{
                    FormBox["k",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["q",
                      "TraditionalForm"]}]}], "-", 
                SuperscriptBox[
                  FormBox["q",
                    "TraditionalForm"], "2"]}], ")"}]}], \(q\^2 . 
            q\^2 . \((k + q)\)\^2\)], "-", 
        FractionBox[
          RowBox[{"2", " ", 
            SuperscriptBox[
              FormBox["k",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["k",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(q\^2 . q\^2 . \((k + q)\)\^2\)],
         "+", 
        FractionBox[
          RowBox[{"2", " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["k",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"3", " ", 
                  RowBox[{
                    FormBox["k",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["q",
                      "TraditionalForm"]}]}], "+", 
                SuperscriptBox[
                  FormBox["q",
                    "TraditionalForm"], "2"]}], ")"}]}], \(q\^2 . 
            q\^2 . \((k + q)\)\^2\)], "+", 
        FractionBox[
          RowBox[{"2", " ", 
            SuperscriptBox[
              FormBox["k",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"3", " ", 
                  RowBox[{
                    FormBox["k",
                      "TraditionalForm"], "\[CenterDot]", 
                    FormBox["q",
                      "TraditionalForm"]}]}], "+", 
                SuperscriptBox[
                  FormBox["q",
                    "TraditionalForm"], "2"]}], ")"}]}], \(q\^2 . 
            q\^2 . \((k + q)\)\^2\)]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
However, it is not evident that it is really the same. Therefore we \
enter eq. (A.4) and subtract it from the above.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mutabmunu1 = 
      FAD[q, q + 
            k]\  . \((\(-FAD[q]\) \((SPD[q] + 2  SPD[k, q])\)^2 
               MTD[\[Mu], \[Nu]]\  + \[IndentingNewLine]FAD[q] FVD[q, \[Nu]] 
              FVD[q, \[Mu]] \((SPD[q] + 2  SPD[k, q] - 
                  SPD[k])\) + \[IndentingNewLine]FAD[
                q] \((SPD[q] + 
                  3  SPD[k, q])\) \((FVD[q, \[Mu]] FVD[k, \[Nu]] + 
                  FVD[q, \[Nu]] FVD[k, \[Mu]])\) - \[IndentingNewLine]FVD[
                k, \[Mu]] FVD[k, \[Nu]])\)\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          FractionBox["1", 
            RowBox[{
              RowBox[{"(", 
                
                InterpretationBox[\("["\[InvisibleSpace]q\^2\[InvisibleSpace]\
"]"\),
                  SequenceForm[ "[", 
                    Power[ q, 2], "]"],
                  Editable->False], ")"}], " ", 
              RowBox[{"(", 
                
                InterpretationBox[\("["\[InvisibleSpace]\((k + q)\)\^2\
\[InvisibleSpace]"]"\),
                  SequenceForm[ "[", 
                    Power[ 
                      Plus[ k, q], 2], "]"],
                  Editable->False], ")"}]}]],
          "TraditionalForm"], ".", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              RowBox[{"-", 
                FormBox[
                  FractionBox["1", 
                    
                    InterpretationBox[\("["\[InvisibleSpace]q\^2\
\[InvisibleSpace]"]"\),
                      SequenceForm[ "[", 
                        Power[ q, 2], "]"],
                      Editable->False]],
                  "TraditionalForm"]}], " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{"2", " ", 
                      FormBox[
                        RowBox[{
                          FormBox["k",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}],
                        "TraditionalForm"]}], "+", 
                    FormBox[
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"],
                      "TraditionalForm"]}], ")"}], "2"]}], 
            "-", \(k\^\[Mu]\ k\^\[Nu]\), "+", 
            RowBox[{
              FormBox[
                FractionBox["1", 
                  
                  InterpretationBox[\("["\[InvisibleSpace]q\^2\
\[InvisibleSpace]"]"\),
                    SequenceForm[ "[", 
                      Power[ q, 2], "]"],
                    Editable->False]],
                "TraditionalForm"], " ", \(q\^\[Mu]\), " ", \(q\^\[Nu]\), " ",
               
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"-", 
                    FormBox[
                      SuperscriptBox[
                        FormBox["k",
                          "TraditionalForm"], "2"],
                      "TraditionalForm"]}], "+", 
                  RowBox[{"2", " ", 
                    FormBox[
                      RowBox[{
                        FormBox["k",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}],
                      "TraditionalForm"]}], "+", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["q",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"]}], ")"}]}], "+", 
            RowBox[{
              FormBox[
                FractionBox["1", 
                  
                  InterpretationBox[\("["\[InvisibleSpace]q\^2\
\[InvisibleSpace]"]"\),
                    SequenceForm[ "[", 
                      Power[ q, 2], "]"],
                    Editable->False]],
                "TraditionalForm"], 
              " ", \((k\^\[Nu]\ q\^\[Mu] + k\^\[Mu]\ q\^\[Nu])\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"3", " ", 
                    FormBox[
                      RowBox[{
                        FormBox["k",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}],
                      "TraditionalForm"]}], "+", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["q",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"]}], ")"}]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mutabmunu = 
      FCI[mutabmunu1 + \ \((mutabmunu1 /. {q :> \((q + k)\), 
                k \[RuleDelayed] \(-k\)})\)]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(1\/q\^2 . \((k + q)\)\^2\), ".", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                FractionBox[
                  RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{"2", " ", 
                            RowBox[{
                              FormBox["k",
                                "TraditionalForm"], "\[CenterDot]", 
                              FormBox["q",
                                "TraditionalForm"]}]}], "+", 
                          SuperscriptBox[
                            FormBox["q",
                              "TraditionalForm"], "2"]}], ")"}], 
                      "2"]}], \(q\^2\)]}], "-", 
              RowBox[{
                SuperscriptBox[
                  FormBox["k",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], " ", 
                SuperscriptBox[
                  FormBox["k",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], "+", 
              FractionBox[
                RowBox[{
                  SuperscriptBox[
                    FormBox["q",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["q",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", 
                        SuperscriptBox[
                          FormBox["k",
                            "TraditionalForm"], "2"]}], "+", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], ")"}]}], \(q\^2\)], "+",
               
              FractionBox[
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        SuperscriptBox[
                          FormBox["q",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"]], " ", 
                        SuperscriptBox[
                          FormBox["k",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]]}], "+", 
                      RowBox[{
                        SuperscriptBox[
                          FormBox["k",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"]], " ", 
                        SuperscriptBox[
                          FormBox["q",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]]}]}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"3", " ", 
                        RowBox[{
                          FormBox["k",
                            "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q",
                            "TraditionalForm"]}]}], "+", 
                      SuperscriptBox[
                        FormBox["q",
                          "TraditionalForm"], "2"]}], ")"}]}], \(q\^2\)]}], 
            ")"}]}], "+", 
        RowBox[{\(1\/\((k + q)\)\^2 . q\^2\), ".", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"-", 
                FractionBox[
                  RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox[
                            RowBox[{"(", 
                              FormBox[\(k + q\),
                                "TraditionalForm"], ")"}], "2"], "-", 
                          RowBox[{"2", " ", 
                            RowBox[{
                              FormBox["k",
                                "TraditionalForm"], "\[CenterDot]", "(", 
                              FormBox[\(k + q\),
                                "TraditionalForm"], ")"}]}]}], ")"}], 
                      "2"]}], \(\((k + q)\)\^2\)]}], "-", 
              RowBox[{
                SuperscriptBox[
                  FormBox["k",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], " ", 
                SuperscriptBox[
                  FormBox["k",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]]}], "+", 
              FractionBox[
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"-", 
                          SuperscriptBox[
                            RowBox[{"(", 
                              FormBox[\(k + q\),
                                "TraditionalForm"], ")"}], 
                            FormBox[
                              FormBox["\[Mu]",
                                "TraditionalForm"],
                              "TraditionalForm"]]}], " ", 
                        SuperscriptBox[
                          FormBox["k",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]]}], "-", 
                      RowBox[{
                        SuperscriptBox[
                          FormBox["k",
                            "TraditionalForm"], 
                          FormBox[
                            FormBox["\[Mu]",
                              "TraditionalForm"],
                            "TraditionalForm"]], " ", 
                        SuperscriptBox[
                          RowBox[{"(", 
                            FormBox[\(k + q\),
                              "TraditionalForm"], ")"}], 
                          FormBox[
                            FormBox["\[Nu]",
                              "TraditionalForm"],
                            "TraditionalForm"]]}]}], ")"}], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          FormBox[\(k + q\),
                            "TraditionalForm"], ")"}], "2"], "-", 
                      RowBox[{"3", " ", 
                        RowBox[{
                          FormBox["k",
                            "TraditionalForm"], "\[CenterDot]", "(", 
                          FormBox[\(k + q\),
                            "TraditionalForm"], ")"}]}]}], 
                    ")"}]}], \(\((k + q)\)\^2\)], "+", 
              FractionBox[
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      FormBox[\(k + q\),
                        "TraditionalForm"], ")"}], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      FormBox[\(k + q\),
                        "TraditionalForm"], ")"}], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"-", 
                        SuperscriptBox[
                          FormBox["k",
                            "TraditionalForm"], "2"]}], "-", 
                      RowBox[{"2", " ", 
                        RowBox[{
                          FormBox["k",
                            "TraditionalForm"], "\[CenterDot]", "(", 
                          FormBox[\(k + q\),
                            "TraditionalForm"], ")"}]}], "+", 
                      SuperscriptBox[
                        RowBox[{"(", 
                          FormBox[\(k + q\),
                            "TraditionalForm"], ")"}], "2"]}], 
                    ")"}]}], \(\((k + q)\)\^2\)]}], ")"}]}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Collect2[
      ScalarProductCancel@
        FeynAmpDenominatorSimplify[Calc[mutabmunu - \ bmunu], q], 
      q]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`0\)], "Output"]
}, Open  ]],

Cell["This proves that bmunu is equivalent to (A.4) of T. Muta.", "Text"],

Cell[TextData[{
  "Project out  the ",
  Cell[BoxData[
      \(TraditionalForm\`C\_\[Mu]\[Nu]\)]],
  "in eq. (A.5) from T.Muta's book."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FCI[
      FCE[Coefficient[\ 2\ gl3, \[Xi], 2] /. p \[Rule] \((\(-k\))\)] /. 
        FAD[q, q, q + k, q + k] \[RuleDelayed] FAD[q, q + k]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\((1\/\((\(-k\) - q)\)\^2)\)\^2\), " ", \(\((1\/q\^2)\)\^2\), 
        " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["k",
                  "TraditionalForm"], "2"]}], "-", 
            RowBox[{
              SuperscriptBox[
                FormBox["k",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                FormBox["k",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}]}], ")"}], " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              SuperscriptBox[
                FormBox["q",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["k",
                  "TraditionalForm"], "2"]}], "-", 
            RowBox[{
              SuperscriptBox[
                FormBox["k",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                FormBox["k",
                  "TraditionalForm"], "\[CenterDot]", 
                FormBox["q",
                  "TraditionalForm"]}]}]}], ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gl4 = Collect2[FeynAmpDenominatorSimplify[gl3, q], q]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{\(\[Xi]\^2\), " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "4"]}], \(2\ q\^2 . 
              q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)], "+", 
        FractionBox[
          RowBox[{\(\[Xi]\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox[
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}],
                "TraditionalForm"], "2"]}], \(2\ q\^2 . 
              q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)], "-", 
        FractionBox[
          RowBox[{\(\[Xi]\^2\), " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"], " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], \(2\ q\^2 . 
              q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)], "-", 
        FractionBox[
          RowBox[{\(\[Xi]\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"], " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], \(2\ q\^2 . 
              q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)], "-", 
        FractionBox[
          RowBox[{"4", " ", "\[Xi]", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
            SuperscriptBox[
              FormBox[
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}],
                "TraditionalForm"], "2"]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)],
         "-", 
        FractionBox[
          RowBox[{"\[Xi]", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "4"]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)],
         "-", 
        FractionBox[
          RowBox[{"\[Xi]", " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)],
         "+", 
        FractionBox[
          RowBox[{"3", " ", "\[Xi]", " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)], 
        "+", 
        FractionBox[
          RowBox[{"3", " ", "\[Xi]", " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)], 
        "-", 
        FractionBox[
          RowBox[{"2", " ", "\[Xi]", " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)], 
        "-", 
        FractionBox[
          RowBox[{"\[Xi]", " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)],
         "-", 
        FractionBox[
          RowBox[{"\[Xi]", " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)],
         "-", 
        FractionBox[
          RowBox[{"\[Xi]", " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)],
         "+", 
        FractionBox[
          RowBox[{"\[Xi]", " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)],
         "+", 
        FractionBox[
          RowBox[{"4", " ", "\[Xi]", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)],
         "+", 
        FractionBox[
          RowBox[{\((3 - 2\ D)\), " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], \(2\ q\^2 . \((q - p)\)\^2\)], "+", 
        FractionBox[
          RowBox[{\((3 - 2\ D)\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], \(2\ q\^2 . \((q - p)\)\^2\)], "-", 
        FractionBox[
          RowBox[{\((3 - 2\ D)\), " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], \(q\^2 . \((q - p)\)\^2\)], "-", 
        FractionBox[
          RowBox[{
            RowBox[{\(-D\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{"6", " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{"5", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}]}], \(2\ q\^2 . \((q - p)\)\^2\)],
         "-", 
        FractionBox[
          RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], \(q\^2 . \((q - p)\)\^2\)], "+", 
        FractionBox[
          RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(q\^2 . \((q - p)\)\^2\)]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?TID\)\)], "Input"],

Cell[BoxData[
    \("TID[amp, q] does a 1-loop tensor integral decomposition, transforming \
the Lorentz indices away from the integration momentum q."\)], "Print",
  CellTags->"Info3288437852-5670548"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gl4[\([1]\)]\)], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{\((3 - 2\ D)\), " ", 
          SuperscriptBox[
            FormBox["q",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Mu]",
                "TraditionalForm"],
              "TraditionalForm"]], " ", 
          SuperscriptBox[
            FormBox["p",
              "TraditionalForm"], 
            FormBox[
              FormBox["\[Nu]",
                "TraditionalForm"],
              "TraditionalForm"]]}], \(2\ q\^2 . \((q - p)\)\^2\)], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gl4 // Length\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`21\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(gl4[\([11]\)] // FCE\) // InputForm\)], "Input"],

Cell["\<\
-(\[Xi]^2*FAD[q, q, -p + q, -p + q]*FVD[p, \[Nu]]*FVD[q, \
\[Mu]]*SPD[p, p]*SPD[p, q])/2\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gl5 = Collect2[TID[gl4, q], q]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{"2", " ", "\[Xi]", " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"D", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox[
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}],
                "TraditionalForm"], "3"]}], 
          RowBox[{\((1 - D)\), " ", \(q\^2 . q\^2 . \((q - p)\)\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "4"]}]], "-", 
        FractionBox[
          RowBox[{\(\[Xi]\^2\), " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox[
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}],
                "TraditionalForm"], "2"]}], \(2\ \((1 - D)\)\ q\^2 . 
              q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)], "+", 
        FractionBox[
          RowBox[{\((3 - 2\ D)\), " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"D", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox[
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}],
                "TraditionalForm"], "2"]}], 
          RowBox[{\((1 - D)\), " ", \(q\^2 . \((q - p)\)\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "4"]}]], "+", 
        FractionBox[
          RowBox[{"\[Xi]", " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-5\), " ", "D", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"6", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"4", " ", "D", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}], "-", 
                RowBox[{"5", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox[
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}],
                "TraditionalForm"], "2"]}], 
          RowBox[{\((1 - D)\), " ", \(q\^2 . q\^2 . \((q - p)\)\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}]], "-", 
        FractionBox[
          RowBox[{"\[Xi]", " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"D", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox[
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}],
                "TraditionalForm"], "2"], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], 
          RowBox[{\((1 - D)\), " ", \(q\^2 . q\^2 . \((q - p)\)\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "4"]}]], "+", 
        FractionBox[
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-2\), " ", "D", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], 
          RowBox[{\(q\^2 . \((q - p)\)\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}]], "-", 
        FractionBox[
          RowBox[{"2", " ", "\[Xi]", " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-D\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"2", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"2", " ", "D", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}], "-", 
                RowBox[{"3", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], 
          RowBox[{\((1 - D)\), " ", \(q\^2 . q\^2 . \((q - p)\)\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}]], "+", 
        FractionBox[
          RowBox[{"\[Xi]", " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"D", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}], "-", 
                RowBox[{"2", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "4"]}], 
          RowBox[{\((1 - D)\), " ", \(q\^2 . q\^2 . \((q - p)\)\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}]], "-", 
        FractionBox[
          RowBox[{
            RowBox[{\(-D\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "+", 
            RowBox[{"6", " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]]}], "-", 
            RowBox[{"5", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}]}], \(2\ q\^2 . \((q - p)\)\^2\)],
         "+", 
        FractionBox[
          RowBox[{\(\[Xi]\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(2\ \((1 - D)\)\ q\^2 . 
              q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)], "-", 
        FractionBox[
          RowBox[{"\[Xi]", " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-D\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"2", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], \(\((1 - D)\)\ q\^2 . 
              q\^2 . \((q - p)\)\^2\)], "-", 
        FractionBox[
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-2\), " ", "D", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"3", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"3", " ", "D", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}], "-", 
                RowBox[{"4", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], 
          RowBox[{\((1 - D)\), " ", \(q\^2 . \((q - p)\)\^2\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gl6 = \(ToFI[gl5, {q}, {p}] // FCE\) // Factor2\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{\(1\/\(8\ \((1 - D)\)\)\), 
          RowBox[{"(", 
            RowBox[{
              RowBox[{\(-\[Xi]\^2\), " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({2, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({2, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{2, 0}, {2, 0}}],
                  Editable->True], " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "6"]}], "+", 
              RowBox[{
              "4", " ", \(\[Xi]\^2\), " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({2, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{2, 0}, {1, 0}}],
                  Editable->True], " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "4"]}], "-", 
              RowBox[{
              "8", " ", "D", " ", "\[Xi]", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({2, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{2, 0}, {1, 0}}],
                  Editable->True], " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "4"]}], "+", 
              RowBox[{"12", " ", "\[Xi]", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({2, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{2, 0}, {1, 0}}],
                  Editable->True], " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "4"]}], "+", 
              
              RowBox[{\(\[Xi]\^2\), " ", \(p\^\[Mu]\), " ", \(p\^\[Nu]\), " ",
                 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({2, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({2, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{2, 0}, {2, 0}}],
                  Editable->True], " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "4"]}], "+", 
              RowBox[{
              "2", " ", \(\[Xi]\^2\), " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({1, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{1, 0}, {1, 0}}],
                  Editable->True], " ", 
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"]}], "+", 
              RowBox[{"12", " ", "D", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({1, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{1, 0}, {1, 0}}],
                  Editable->True], " ", 
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"]}], "-", 
              RowBox[{"8", " ", "\[Xi]", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({1, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{1, 0}, {1, 0}}],
                  Editable->True], " ", 
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"]}], "-", 
              RowBox[{"10", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({1, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{1, 0}, {1, 0}}],
                  Editable->True], " ", 
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"]}], "-", 
              RowBox[{
              "4", " ", \(\[Xi]\^2\), " ", \(p\^\[Mu]\), " ", \(p\^\[Nu]\), 
                " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({2, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{2, 0}, {1, 0}}],
                  Editable->True], " ", 
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"]}], "+", 
              RowBox[{
              "8", " ", "D", " ", "\[Xi]", " ", \(p\^\[Mu]\), 
                " ", \(p\^\[Nu]\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({2, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{2, 0}, {1, 0}}],
                  Editable->True], " ", 
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"]}], "-", 
              RowBox[{
              "12", " ", "\[Xi]", " ", \(p\^\[Mu]\), " ", \(p\^\[Nu]\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({2, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{2, 0}, {1, 0}}],
                  Editable->True], " ", 
                FormBox[
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"],
                  "TraditionalForm"]}], "-", 
              RowBox[{
              "2", " ", \(\[Xi]\^2\), " ", \(p\^\[Mu]\), " ", \(p\^\[Nu]\), 
                " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({1, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{1, 0}, {1, 0}}],
                  Editable->True]}], "-", 
              RowBox[{
              "14", " ", "D", " ", \(p\^\[Mu]\), " ", \(p\^\[Nu]\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({1, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{1, 0}, {1, 0}}],
                  Editable->True]}], "+", 
              RowBox[{
              "8", " ", "\[Xi]", " ", \(p\^\[Mu]\), " ", \(p\^\[Nu]\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({1, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{1, 0}, {1, 0}}],
                  Editable->True]}], "+", 
              RowBox[{"12", " ", \(p\^\[Mu]\), " ", \(p\^\[Nu]\), " ", 
                InterpretationBox[
                  SubsuperscriptBox[
                    StyleBox["B",
                      SingleLetterItalics->False,
                      FontWeight->"Bold"], 
                    RowBox[{
                      FormBox[\({1, 0}\),
                        "TraditionalForm"], 
                      FormBox[\({1, 0}\),
                        "TraditionalForm"]}], 
                    RowBox[{"(", 
                      FormBox["D",
                        "TraditionalForm"], ")"}]],
                  TBI[ D, 
                    SPD[ p, p], {{1, 0}, {1, 0}}],
                  Editable->True]}]}], ")"}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gluonloop = 
      Collect2[TarcerRecurse[gl6], {\[Mu], \[Nu]}] /. 
        a_Plus \[RuleDelayed] Collect2[a, \[Xi]] /; FreeQ[a, TBI]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          
          RowBox[{\((\((1 - D)\)\ \((4 - D)\)\ \[Xi]\^2 - 
                4\ \((7 - 2\ D)\)\ \((1 - D)\)\ \[Xi] + 2\ \((5 - 6\ D)\))\), 
            " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
            FormBox[
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"],
              "TraditionalForm"], " ", 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["D",
                    "TraditionalForm"], ")"}]],
              TBI[ D, 
                SPD[ p, p], {{1, 0}, {1, 0}}],
              Editable->True]}], \(8\ \((1 - D)\)\)], "-", 
        FractionBox[
          
          RowBox[{\((\((1 - D)\)\ \((4 - D)\)\ \[Xi]\^2 - 
                4\ \((7 - 2\ D)\)\ \((1 - D)\)\ \[Xi] + 2\ \((6 - 7\ D)\))\), 
            " ", \(p\^\[Mu]\), " ", \(p\^\[Nu]\), " ", 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["D",
                    "TraditionalForm"], ")"}]],
              TBI[ D, 
                SPD[ p, p], {{1, 0}, {1, 0}}],
              Editable->True]}], \(8\ \((1 - D)\)\)]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
Only by adding the ghost contribution transversality is restored.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nonfermionicresult = 
      Factor2[gluonloop + ghostloop] /. 
        h_Plus \[RuleDelayed] Collect2[h, \[Xi]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        FractionBox[
          
          RowBox[{\((\((1 - D)\)\ \((4 - D)\)\ \[Xi]\^2 - 
                4\ \((7 - 2\ D)\)\ \((1 - D)\)\ \[Xi] + 4\ \((2 - 3\ D)\))\), 
            " ", 
            RowBox[{"(", 
              RowBox[{\(p\^\[Mu]\ p\^\[Nu]\), "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"]}]}], ")"}], " ", 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["D",
                    "TraditionalForm"], ")"}]],
              TBI[ D, 
                SPD[ p, p], {{1, 0}, {1, 0}}],
              Editable->True]}], \(8\ \((1 - D)\)\)]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Contract[FVD[p, \[Mu]]\ nonfermionicresult]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`0\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The fermion loop", "Subsection"],

Cell["\<\
Explicitly inserting the Feynman rules for a general gauge and \
summing the amplitudes.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fl1 = amps\[LeftDoubleBracket]2\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        RowBox[{"tr", "(", 
          FormBox[
            RowBox[{"2", " ", \(N\_f\), " ", \(T\_f\), " ", 
              RowBox[{\(\(\[CapitalPi]\_q\)(q)\), ".", 
                SubscriptBox["T", 
                  FormBox["ci2",
                    "TraditionalForm"]], ".", \(Q\^\[Nu]\), ".", 
                RowBox[{\(\[CapitalPi]\_q\), "(", 
                  FormBox[\(q - p\),
                    "TraditionalForm"], ")"}], ".", 
                SubscriptBox["T", 
                  FormBox["ci1",
                    "TraditionalForm"]], ".", \(Q\^\[Mu]\)}]}],
            "TraditionalForm"], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
Replace the \"QuarkMass\" variable from the FCQCDLorentz Model file \
by \"M\".\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fl2 = 
      SUNSimplify[Explicit[fl1, Dimension \[Rule] D]] /. 
        QuarkMass\  \[Rule] \ M\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        FractionBox[
          RowBox[{\(g\_s\%2\), " ", \(N\_f\), " ", \(T\_f\), " ", 
            RowBox[{"tr", "(", 
              FormBox[
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"M", "+", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q",
                          "TraditionalForm"]}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], ".", 
                  RowBox[{"(", 
                    RowBox[{"M", "-", 
                      RowBox[{
                        FormBox["\<\"\[Gamma]\"\>",
                          "TraditionalForm"], "\[CenterDot]", "(", 
                        FormBox[\(p - q\),
                          "TraditionalForm"], ")"}]}], ")"}], ".", 
                  SuperscriptBox["\[Gamma]", 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}],
                "TraditionalForm"], ")"}], " ", 
            SubscriptBox["\[Delta]", 
              RowBox[{
                FormBox[
                  FormBox["ci1",
                    "TraditionalForm"],
                  "TraditionalForm"], 
                FormBox[
                  FormBox["ci2",
                    "TraditionalForm"],
                  "TraditionalForm"]}]]}], \(\((q\^2 - 
                M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\)]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fl3 = \(\(Contract[
              fl2 /. \[InvisibleSpace]DiracTrace \[Rule] 
                  TR] /. \[InvisibleSpace]CA \[Rule] 
              1\) /. \[InvisibleSpace]Gstrong \[Rule] 
            1\) /. \[InvisibleSpace]SUNDelta[__] \[RuleDelayed] 1\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(-\(\(4\ M\^2\ N\_f\ T\_f\ g\^\(\[Mu]  \[Nu]\)\)\/\((q\^2 - 
                    M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\)\), "+", 
        FractionBox[
          RowBox[{"4", " ", \(N\_f\), " ", \(T\_f\), " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], \(\((q\^2 - 
                M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\)], "+", 
        FractionBox[
          RowBox[{"4", " ", \(N\_f\), " ", \(T\_f\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], \(\((q\^2 - 
                M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\)], "-", 
        FractionBox[
          RowBox[{"8", " ", \(N\_f\), " ", \(T\_f\), " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Mu]",
                  "TraditionalForm"],
                "TraditionalForm"]], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              FormBox[
                FormBox["\[Nu]",
                  "TraditionalForm"],
                "TraditionalForm"]]}], \(\((q\^2 - 
                M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\)], "-", 
        FractionBox[
          RowBox[{
          "4", " ", \(N\_f\), " ", \(T\_f\), " ", \(g\^\(\[Mu]  \[Nu]\)\), 
            " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], \(\((q\^2 - 
                M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\)], "+", 
        FractionBox[
          RowBox[{
          "4", " ", \(N\_f\), " ", \(T\_f\), " ", \(g\^\(\[Mu]  \[Nu]\)\), 
            " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], 
              "2"]}], \(\((q\^2 - M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\)]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fl4 = Collect2[TID[fl3, q], q]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{\(-\(\(4\ M\^2\ N\_f\ T\_f\ g\^\(\[Mu]  \[Nu]\)\)\/\((q\^2 - 
                    M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\)\), "+", 
        FractionBox[
          RowBox[{"8", " ", \(N\_f\), " ", \(T\_f\), " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"D", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox[
                RowBox[{
                  FormBox["p",
                    "TraditionalForm"], "\[CenterDot]", 
                  FormBox["q",
                    "TraditionalForm"]}],
                "TraditionalForm"], "2"]}], 
          
          RowBox[{\((1 - D)\), 
            " ", \(\((q\^2 - M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "4"]}]], "+", 
        FractionBox[
          RowBox[{"4", " ", \(N\_f\), " ", \(T\_f\), " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"2", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            RowBox[{
              FormBox["p",
                "TraditionalForm"], "\[CenterDot]", 
              FormBox["q",
                "TraditionalForm"]}]}], 
          RowBox[{\(\((q\^2 - M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}]], "-", 
        FractionBox[
          RowBox[{"4", " ", \(N\_f\), " ", \(T\_f\), " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"2", " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "+", 
                RowBox[{"D", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}], "-", 
                RowBox[{"3", " ", \(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}], " ", 
            SuperscriptBox[
              FormBox["q",
                "TraditionalForm"], "2"]}], 
          
          RowBox[{\((1 - D)\), 
            " ", \(\((q\^2 - M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cc = 
      Collect2[SPC[SPC[fl4, q, FDS \[Rule] True], q, FDS \[Rule] True], 
        q]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox[
            RowBox[{"2", " ", \(N\_f\), " ", \(T\_f\), " ", 
              RowBox[{"(", 
                RowBox[{\(4\ M\^2\), "+", 
                  RowBox[{"D", " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}], "-", 
                  RowBox[{"2", " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}]}], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Mu]",
                          "TraditionalForm"],
                        "TraditionalForm"]], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], 
                      FormBox[
                        FormBox["\[Nu]",
                          "TraditionalForm"],
                        "TraditionalForm"]]}], "-", 
                  RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}]}], ")"}]}], 
            
            RowBox[{\((1 - D)\), 
              " ", \(\((q\^2 - M\^2)\) . \((\((q - p)\)\^2 - M\^2)\)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}]]}], "-", 
        FractionBox[
          RowBox[{"4", " ", \((2 - D)\), " ", \(N\_f\), " ", \(T\_f\), " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Mu]",
                        "TraditionalForm"],
                      "TraditionalForm"]], " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], 
                    FormBox[
                      FormBox["\[Nu]",
                        "TraditionalForm"],
                      "TraditionalForm"]]}], "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  SuperscriptBox[
                    FormBox["p",
                      "TraditionalForm"], "2"]}]}], ")"}]}], 
          RowBox[{\((1 - D)\), " ", \((q\^2 - M\^2)\), " ", 
            SuperscriptBox[
              FormBox["p",
                "TraditionalForm"], "2"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fermionloop = Factor2[ToTFI[fl4, q, p]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"-", 
        FractionBox[
          RowBox[{"2", " ", \(N\_f\), " ", \(T\_f\), " ", 
            RowBox[{"(", 
              RowBox[{\(p\^\[Mu]\ p\^\[Nu]\), "-", 
                RowBox[{\(g\^\(\[Mu]  \[Nu]\)\), " ", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"]}]}], ")"}], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"4", " ", 
                  InterpretationBox[
                    SubsuperscriptBox[
                      StyleBox["B",
                        SingleLetterItalics->False,
                        FontWeight->"Bold"], 
                      RowBox[{
                        FormBox[\({1, M}\),
                          "TraditionalForm"], 
                        FormBox[\({1, M}\),
                          "TraditionalForm"]}], 
                      RowBox[{"(", 
                        FormBox["D",
                          "TraditionalForm"], ")"}]],
                    TBI[ D, 
                      SPD[ p, p], {{1, M}, {1, M}}],
                    Editable->True], " ", \(M\^2\)}], "-", 
                RowBox[{"2", " ", "D", " ", 
                  InterpretationBox[
                    SubsuperscriptBox[
                      StyleBox["A",
                        SingleLetterItalics->False,
                        FontWeight->"Bold"], 
                      FormBox[\({1, M}\),
                        "TraditionalForm"], 
                      RowBox[{"(", 
                        FormBox["D",
                          "TraditionalForm"], ")"}]],
                    TAI[ D, 0, {{1, M}}],
                    Editable->True]}], "+", 
                RowBox[{"4", " ", 
                  InterpretationBox[
                    SubsuperscriptBox[
                      StyleBox["A",
                        SingleLetterItalics->False,
                        FontWeight->"Bold"], 
                      FormBox[\({1, M}\),
                        "TraditionalForm"], 
                      RowBox[{"(", 
                        FormBox["D",
                          "TraditionalForm"], ")"}]],
                    TAI[ D, 0, {{1, M}}],
                    Editable->True]}], "+", 
                RowBox[{"D", " ", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], " ", 
                  InterpretationBox[
                    SubsuperscriptBox[
                      StyleBox["B",
                        SingleLetterItalics->False,
                        FontWeight->"Bold"], 
                      RowBox[{
                        FormBox[\({1, M}\),
                          "TraditionalForm"], 
                        FormBox[\({1, M}\),
                          "TraditionalForm"]}], 
                      RowBox[{"(", 
                        FormBox["D",
                          "TraditionalForm"], ")"}]],
                    TBI[ D, 
                      SPD[ p, p], {{1, M}, {1, M}}],
                    Editable->True]}], "-", 
                RowBox[{"2", " ", 
                  FormBox[
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"],
                    "TraditionalForm"], " ", 
                  InterpretationBox[
                    SubsuperscriptBox[
                      StyleBox["B",
                        SingleLetterItalics->False,
                        FontWeight->"Bold"], 
                      RowBox[{
                        FormBox[\({1, M}\),
                          "TraditionalForm"], 
                        FormBox[\({1, M}\),
                          "TraditionalForm"]}], 
                      RowBox[{"(", 
                        FormBox["D",
                          "TraditionalForm"], ")"}]],
                    TBI[ D, 
                      SPD[ p, p], {{1, M}, {1, M}}],
                    Editable->True]}]}], ")"}]}], 
          RowBox[{\((1 - D)\), " ", 
            FormBox[
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"],
              "TraditionalForm"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TimeUsed[]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`17.11`\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1400}, {0, 1050}},
WindowSize->{853, 832},
WindowMargins->{{68, Automatic}, {Automatic, 18}},
Magnification->1
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3288437846-1512755"->{
    Cell[75939, 3405, 318, 5, 55, "Print",
      CellTags->"Info3288437846-1512755"]},
  "Info3288437852-5670548"->{
    Cell[147195, 5340, 202, 3, 39, "Print",
      CellTags->"Info3288437852-5670548"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3288437846-1512755", 203734, 6869},
  {"Info3288437852-5670548", 203851, 6872}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 61, 0, 38, "Subsection"],
Cell[1840, 55, 63, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[1928, 60, 35, 0, 28, "Subsubsection"],
Cell[1966, 62, 147, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[2138, 69, 430, 9, 59, "Input"],
Cell[2571, 80, 60461, 2944, 80, 51726, 2831, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[63047, 3027, 308, 5, 50, "Text"],
Cell[63358, 3034, 427, 7, 59, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[63822, 3046, 97, 3, 28, "Subsubsection"],

Cell[CellGroupData[{
Cell[63944, 3053, 48, 1, 27, "Input"],
Cell[63995, 3056, 4609, 112, 120, "Output"]
}, Open  ]],
Cell[68619, 3171, 103, 3, 32, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[68771, 3180, 36, 0, 38, "Subsection"],
Cell[68810, 3182, 112, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[68947, 3189, 54, 1, 27, "Input"],
Cell[69004, 3192, 481, 10, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69522, 3207, 86, 1, 27, "Input"],
Cell[69611, 3210, 1324, 38, 50, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[70972, 3253, 158, 2, 27, "Input"],
Cell[71133, 3257, 1127, 35, 49, "Output"]
}, Open  ]],
Cell[72275, 3295, 87, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[72387, 3302, 50, 1, 27, "Input"],
Cell[72440, 3305, 3417, 92, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75894, 3402, 42, 1, 27, "Input"],
Cell[75939, 3405, 318, 5, 55, "Print",
  CellTags->"Info3288437846-1512755"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76294, 3415, 75, 1, 27, "Input"],
Cell[76372, 3418, 1054, 30, 52, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77463, 3453, 47, 1, 27, "Input"],
Cell[77513, 3456, 174, 4, 55, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[77736, 3466, 36, 0, 38, "Subsection"],
Cell[77775, 3468, 112, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[77912, 3475, 54, 1, 27, "Input"],
Cell[77969, 3478, 841, 19, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78847, 3502, 138, 4, 27, "Input"],
Cell[78988, 3508, 8049, 187, 102, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87074, 3700, 158, 2, 27, "Input"],
Cell[87235, 3704, 21159, 527, 178, "Output"]
}, Open  ]],
Cell[108409, 4234, 183, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[108617, 4243, 200, 3, 43, "Input"],
Cell[108820, 4248, 2580, 80, 29, "Output"]
}, Open  ]],
Cell[111415, 4331, 190, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[111630, 4340, 173, 4, 27, "Input"],
Cell[111806, 4346, 4400, 125, 51, "Output"]
}, Open  ]],
Cell[116221, 4474, 141, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[116387, 4481, 535, 10, 75, "Input"],
Cell[116925, 4493, 4137, 110, 48, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[121099, 4608, 152, 3, 27, "Input"],
Cell[121254, 4613, 9774, 235, 148, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[131065, 4853, 145, 4, 27, "Input"],
Cell[131213, 4859, 52, 1, 28, "Output"]
}, Open  ]],
Cell[131280, 4863, 73, 0, 32, "Text"],
Cell[131356, 4865, 147, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[131528, 4874, 172, 3, 27, "Input"],
Cell[131703, 4879, 1897, 56, 49, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[133637, 4940, 86, 1, 27, "Input"],
Cell[133726, 4943, 13388, 389, 179, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[147151, 5337, 41, 1, 27, "Input"],
Cell[147195, 5340, 202, 3, 39, "Print",
  CellTags->"Info3288437852-5670548"]
}, Open  ]],

Cell[CellGroupData[{
Cell[147434, 5348, 45, 1, 27, "Input"],
Cell[147482, 5351, 576, 18, 49, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[148095, 5374, 46, 1, 27, "Input"],
Cell[148144, 5377, 53, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[148234, 5383, 70, 1, 27, "Input"],
Cell[148307, 5386, 114, 3, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[148458, 5394, 63, 1, 27, "Input"],
Cell[148524, 5397, 18779, 489, 179, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[167340, 5891, 80, 1, 27, "Input"],
Cell[167423, 5894, 13918, 342, 114, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[181378, 6241, 166, 3, 27, "Input"],
Cell[181547, 6246, 1889, 50, 98, "Output"]
}, Open  ]],
Cell[183451, 6299, 91, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[183567, 6306, 144, 3, 27, "Input"],
Cell[183714, 6311, 1208, 32, 52, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[184959, 6348, 76, 1, 27, "Input"],
Cell[185038, 6351, 52, 1, 28, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[185139, 6358, 38, 0, 38, "Subsection"],
Cell[185180, 6360, 112, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[185317, 6367, 85, 1, 27, "Input"],
Cell[185405, 6370, 687, 16, 30, "Output"]
}, Open  ]],
Cell[186107, 6389, 103, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[186235, 6396, 129, 3, 27, "Input"],
Cell[186367, 6401, 1771, 44, 50, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[188175, 6450, 285, 5, 27, "Input"],
Cell[188463, 6457, 2723, 73, 94, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[191223, 6535, 63, 1, 27, "Input"],
Cell[191289, 6538, 4263, 108, 94, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[195589, 6651, 122, 3, 27, "Input"],
Cell[195714, 6656, 2734, 69, 50, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[198485, 6730, 72, 1, 27, "Input"],
Cell[198560, 6733, 4395, 107, 53, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[202992, 6845, 43, 1, 27, "Input"],
Cell[203038, 6848, 57, 1, 28, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

