(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     88366,       2313]*)
(*NotebookOutlinePosition[     89960,       2361]*)
(*  CellTagsIndexPosition[     89742,       2352]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Doing a difficult with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and FeynCalc tools"
}], "Section"],

Cell[BoxData[
    \(<< HighEnergyPhysics`FeynCalc`\)], "Input"],

Cell["\<\
Performing multidimensional Feynman paramater integrals is \
sometimes a nontrivial task. This is augmented by the absence of algorithms \
for certain integrals with end point singularities.
The following integral shows up in research related to massless 4-partice \
phase space and was solved together with Prof. T. Gehrmann from the \
University of Z\[UDoubleDot]rich.
Integration from 0 to 1 is assumed for the parameters u,z and t.
What one is after is the expansion up to order Epsilon.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(integral = 
      HoldForm[\[Integral]\_0\%1\(\[Integral]\_0\%1\(\[Integral]\_0\%1\(\( \
z\^\(\(-1\) - Epsilon\)\ \((1 - z)\)\^\(\(-2\)\ Epsilon\)\ u\^\(\(-Epsilon\) \
- 1\)\ t\^\(\(-1\) - Epsilon\)\ \((1 - t)\)\^\(\(-1\) - Epsilon\)\)\/\(1 + \
\(u\ z\ t\)\/\(1 - t\)\)\) \[DifferentialD]z \[DifferentialD]u \
\[DifferentialD]t\)\)]\)], "Input"],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{\(\[Integral]\_0\%1\), 
          RowBox[{\(\[Integral]\_0\%1\), 
            RowBox[{\(\[Integral]\_0\%1\), 
              RowBox[{
                FractionBox[
                  RowBox[{
                    SuperscriptBox["z", 
                      RowBox[{
                        RowBox[{"-", 
                          TagBox["\[CurlyEpsilon]",
                            TraditionalForm]}], "-", "1"}]], " ", 
                    SuperscriptBox[\((1 - z)\), 
                      RowBox[{\(-2\), " ", 
                        TagBox["\[CurlyEpsilon]",
                          TraditionalForm]}]], " ", 
                    SuperscriptBox["u", 
                      RowBox[{
                        RowBox[{"-", 
                          TagBox["\[CurlyEpsilon]",
                            TraditionalForm]}], "-", "1"}]], " ", 
                    SuperscriptBox["t", 
                      RowBox[{
                        RowBox[{"-", 
                          TagBox["\[CurlyEpsilon]",
                            TraditionalForm]}], "-", "1"}]], " ", 
                    SuperscriptBox[\((1 - t)\), 
                      RowBox[{
                        RowBox[{"-", 
                          TagBox["\[CurlyEpsilon]",
                            TraditionalForm]}], "-", 
                        "1"}]]}], \(\(t\ u\ z\)\/\(1 - t\) + 
                    1\)], \(\[DifferentialD]z\), \(\[DifferentialD]u\), \(\
\[DifferentialD]t\)}]}]}]}],
        HoldForm], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(integrand = integral[\([1, 1]\)]\)], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          SuperscriptBox[\((1 - t)\), 
            RowBox[{
              RowBox[{"-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], "-", "1"}]], " ", 
          SuperscriptBox["t", 
            RowBox[{
              RowBox[{"-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], "-", "1"}]], " ", 
          SuperscriptBox["u", 
            RowBox[{
              RowBox[{"-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], "-", "1"}]], " ", 
          SuperscriptBox[\((1 - z)\), 
            RowBox[{\(-2\), " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}]], " ", 
          SuperscriptBox["z", 
            RowBox[{
              RowBox[{"-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], "-", 
              "1"}]]}], \(\(t\ u\ z\)\/\(1 - t\) + 1\)], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
  "We set various assumptions which will help ",
  StyleBox["Mathematica's ",
    FontSlant->"Italic"],
  "Integrate",
  StyleBox[" ",
    FontSlant->"Italic"],
  "function",
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(SetOptions[Integrate, 
        Assumptions \[Rule] {Re[Epsilon] < 0 && \ 
              0 \[LessEqual] u \[LessEqual] 1 && \ 
              0 \[LessEqual] z \[LessEqual] 1 && Im[u] \[Equal] 0 && \ 
              Re[1/\((u\ z - 1)\)] + 1 < 0}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tint = \[Integral]\_0\%1 integrand \[DifferentialD]t\)], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          SuperscriptBox["4", 
            TagBox["\[CurlyEpsilon]",
              TraditionalForm]], " ", \(\@\[Pi]\), " ", 
          SuperscriptBox[\((1 - z)\), 
            RowBox[{\(-2\), " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}]], " ", 
          SuperscriptBox[\((u\ z)\), 
            RowBox[{
              RowBox[{"-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], "-", "1"}]], " ", 
          RowBox[{"\[CapitalGamma]", "(", 
            RowBox[{"-", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}], ")"}], " ", 
          TagBox[
            TagBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["\[InvisiblePrefixScriptBase]", 
                    FormBox["2",
                      "TraditionalForm"]], 
                  SubscriptBox["F", 
                    FormBox["1",
                      "TraditionalForm"]]}], "\[InvisibleApplication]", 
                RowBox[{"(", 
                  RowBox[{
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox["1",
                            Hypergeometric2F1,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            Hypergeometric2F1,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      Hypergeometric2F1,
                      Editable->False], ";", 
                    TagBox[
                      TagBox[
                        TagBox[
                          RowBox[{"1", "-", 
                            RowBox[{"2", " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}]}],
                          Hypergeometric2F1,
                          Editable->True],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      Hypergeometric2F1,
                      Editable->False], ";", 
                    TagBox[\(1 - u\ z\),
                      Hypergeometric2F1,
                      Editable->True]}], ")"}]}],
              InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
              Editable->False],
            Hypergeometric2F1]}], 
        RowBox[{"\[CapitalGamma]", "(", 
          RowBox[{\(1\/2\), "-", 
            TagBox["\[CurlyEpsilon]",
              TraditionalForm]}], ")"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(tint2 = PowerSimplify[tint]\)], "Input"],

Cell[BoxData[
    FormBox[
      FractionBox[
        RowBox[{
          SuperscriptBox["4", 
            TagBox["\[CurlyEpsilon]",
              TraditionalForm]], " ", \(\@\[Pi]\), " ", 
          SuperscriptBox["u", 
            RowBox[{
              RowBox[{"-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], "-", "1"}]], " ", 
          SuperscriptBox[\((1 - z)\), 
            RowBox[{\(-2\), " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}]], " ", 
          SuperscriptBox["z", 
            RowBox[{
              RowBox[{"-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], "-", "1"}]], " ", 
          RowBox[{"\[CapitalGamma]", "(", 
            RowBox[{"-", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}], ")"}], " ", 
          TagBox[
            TagBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["\[InvisiblePrefixScriptBase]", 
                    FormBox["2",
                      "TraditionalForm"]], 
                  SubscriptBox["F", 
                    FormBox["1",
                      "TraditionalForm"]]}], "\[InvisibleApplication]", 
                RowBox[{"(", 
                  RowBox[{
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox["1",
                            Hypergeometric2F1,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            Hypergeometric2F1,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      Hypergeometric2F1,
                      Editable->False], ";", 
                    TagBox[
                      TagBox[
                        TagBox[
                          RowBox[{"1", "-", 
                            RowBox[{"2", " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}]}],
                          Hypergeometric2F1,
                          Editable->True],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      Hypergeometric2F1,
                      Editable->False], ";", 
                    TagBox[\(1 - u\ z\),
                      Hypergeometric2F1,
                      Editable->True]}], ")"}]}],
              InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
              Editable->False],
            Hypergeometric2F1]}], 
        RowBox[{"\[CapitalGamma]", "(", 
          RowBox[{\(1\/2\), "-", 
            TagBox["\[CurlyEpsilon]",
              TraditionalForm]}], ")"}]], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?PowerSimplify\)\)], "Input"],

Cell[BoxData[
    \("PowerSimplify[exp]  simplifies (-x)^a to (-1)^a x^a and (y-x)^n to \
(-1)^n (x-y)^n; thus assuming that the exponent is an integer (even if it is \
symbolic). Furthermore (-1)^(a+n) and I^(a+n) are expanded and (I)^(2 m) -> \
(-1)^m and (-1)^(n_Integer?EvenQ m) -> 1 and (-1)^(n_Integer?OddQ m) -> \
(-1)^m and (-1)^(-n) -> (-1)^n and Exp[I m Pi] -> (-1)^m."\)], "Print",
  CellTags->"Info3277485402-1628141"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(uint = Expand[\[Integral]\_0\%1 tint2 \[DifferentialD]u]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{"\[Pi]", " ", 
            SuperscriptBox[\((1 - z)\), 
              RowBox[{\(-2\), " ", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}]], " ", 
            RowBox[{
              SubscriptBox[
                InterpretationBox["\[CapitalBeta]",
                  Beta,
                  Editable->False,
                  Selectable->False], "z"], "(", 
              RowBox[{
                RowBox[{\(-2\), " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], ",", 
                RowBox[{
                  RowBox[{"2", " ", 
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm]}], "+", "1"}]}], ")"}], " ", 
            RowBox[{"csc", "(", 
              RowBox[{
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm], " ", "\[Pi]"}], ")"}]}], "z"], "-", 
        FractionBox[
          RowBox[{
            SuperscriptBox["2", 
              RowBox[{
                RowBox[{"2", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], "+", "1"}]], " ", \(\@\[Pi]\), " ", 
            SuperscriptBox[\((1 - z)\), 
              RowBox[{\(-2\), " ", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}]], " ", 
            SuperscriptBox["z", 
              RowBox[{
                RowBox[{"-", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], "-", "1"}]], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{"-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], ")"}], " ", 
            TagBox[
              TagBox[
                RowBox[{
                  RowBox[{
                    SubscriptBox["\[InvisiblePrefixScriptBase]", 
                      FormBox["3",
                        "TraditionalForm"]], 
                    SubscriptBox["F", 
                      FormBox["2",
                        "TraditionalForm"]]}], "\[InvisibleApplication]", 
                  RowBox[{"(", 
                    RowBox[{
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox["1",
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{"1", "-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm], "+", "1"}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox["z",
                        HypergeometricPFQ,
                        Editable->True]}], ")"}]}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
                Editable->False],
              HypergeometricPFQ]}], 
          RowBox[{
            TagBox["\[CurlyEpsilon]",
              TraditionalForm], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{\(1\/2\), "-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], ")"}]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
Replace the incomplete  Beta-function in terms of a hypergeometric \
function:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nint = 
      uint /. \[InvisibleSpace]Beta[z, p_, 
            q_] \[RuleDelayed] \(z\^p\ Hypergeometric2F1[p, 1 - q, p + 1, \
z]\)\/p\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox[
            RowBox[{"\[Pi]", " ", 
              SuperscriptBox[\((1 - z)\), 
                RowBox[{\(-2\), " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}]], " ", 
              RowBox[{"csc", "(", 
                RowBox[{
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm], " ", "\[Pi]"}], ")"}], " ", 
              TagBox[
                TagBox[
                  RowBox[{
                    RowBox[{
                      SubscriptBox["\[InvisiblePrefixScriptBase]", 
                        FormBox["2",
                          "TraditionalForm"]], 
                      SubscriptBox["F", 
                        FormBox["1",
                          "TraditionalForm"]]}], "\[InvisibleApplication]", 
                    RowBox[{"(", 
                      RowBox[{
                        TagBox[
                          TagBox[
                            RowBox[{
                              TagBox[
                                RowBox[{\(-2\), " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}],
                                Hypergeometric2F1,
                                Editable->True], ",", 
                              TagBox[
                                RowBox[{\(-2\), " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}],
                                Hypergeometric2F1,
                                Editable->True]}],
                            InterpretTemplate[ {
                              SlotSequence[ 1]}&]],
                          Hypergeometric2F1,
                          Editable->False], ";", 
                        TagBox[
                          TagBox[
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"2", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              Hypergeometric2F1,
                              Editable->True],
                            InterpretTemplate[ {
                              SlotSequence[ 1]}&]],
                          Hypergeometric2F1,
                          Editable->False], ";", 
                        TagBox["z",
                          Hypergeometric2F1,
                          Editable->True]}], ")"}]}],
                  InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
                  Editable->False],
                Hypergeometric2F1], " ", 
              SuperscriptBox["z", 
                RowBox[{
                  RowBox[{\(-2\), " ", 
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm]}], "-", "1"}]]}], 
            RowBox[{"2", " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}]]}], "-", 
        FractionBox[
          RowBox[{
            SuperscriptBox["2", 
              RowBox[{
                RowBox[{"2", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], "+", "1"}]], " ", \(\@\[Pi]\), " ", 
            SuperscriptBox[\((1 - z)\), 
              RowBox[{\(-2\), " ", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}]], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{"-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], ")"}], " ", 
            TagBox[
              TagBox[
                RowBox[{
                  RowBox[{
                    SubscriptBox["\[InvisiblePrefixScriptBase]", 
                      FormBox["3",
                        "TraditionalForm"]], 
                    SubscriptBox["F", 
                      FormBox["2",
                        "TraditionalForm"]]}], "\[InvisibleApplication]", 
                  RowBox[{"(", 
                    RowBox[{
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox["1",
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{"1", "-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm], "+", "1"}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox["z",
                        HypergeometricPFQ,
                        Editable->True]}], ")"}]}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
                Editable->False],
              HypergeometricPFQ], " ", 
            SuperscriptBox["z", 
              RowBox[{
                RowBox[{"-", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], "-", "1"}]]}], 
          RowBox[{
            TagBox["\[CurlyEpsilon]",
              TraditionalForm], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{\(1\/2\), "-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], ")"}]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\ \)\(Hypergeometric2F1[p, 1 - q, p + 1, z] // 
      FunctionExpand\)\)\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"p", " ", \(z\^\(-p\)\), " ", 
        RowBox[{
          SubscriptBox[
            InterpretationBox["\[CapitalBeta]",
              Beta,
              Editable->False,
              Selectable->False], "z"], "(", \(p, q\), ")"}]}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell["Perform the z - integration:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rint = \[Integral]\_0\%1 nint \[DifferentialD]z\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{"\[Pi]", " ", 
            RowBox[{"csc", "(", 
              RowBox[{
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm], " ", "\[Pi]"}], ")"}], " ", 
            SuperscriptBox[
              RowBox[{"\[CapitalGamma]", "(", 
                RowBox[{\(-2\), " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], ")"}], "2"], " ", 
            TagBox[
              TagBox[
                RowBox[{
                  RowBox[{
                    SubscriptBox["\[InvisiblePrefixScriptBase]", 
                      FormBox["3",
                        "TraditionalForm"]], 
                    SubscriptBox["F", 
                      FormBox["2",
                        "TraditionalForm"]]}], "\[InvisibleApplication]", 
                  RowBox[{"(", 
                    RowBox[{
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{\(-2\), " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{\(-2\), " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{\(-2\), " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"4", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"2", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox["1",
                        HypergeometricPFQ,
                        Editable->True]}], ")"}]}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
                Editable->False],
              HypergeometricPFQ]}], 
          RowBox[{"\[CapitalGamma]", "(", 
            RowBox[{"1", "-", 
              RowBox[{"4", " ", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}]}], ")"}]], "-", 
        FractionBox[
          RowBox[{
            SuperscriptBox["2", 
              RowBox[{
                RowBox[{"2", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], "+", "1"}]], " ", \(\@\[Pi]\), " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{"1", "-", 
                RowBox[{"2", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}]}], ")"}], " ", 
            SuperscriptBox[
              RowBox[{"\[CapitalGamma]", "(", 
                RowBox[{"-", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], ")"}], "2"], " ", 
            TagBox[
              TagBox[
                RowBox[{
                  RowBox[{
                    SubscriptBox["\[InvisiblePrefixScriptBase]", 
                      FormBox["4",
                        "TraditionalForm"]], 
                    SubscriptBox["F", 
                      FormBox["3",
                        "TraditionalForm"]]}], "\[InvisibleApplication]", 
                  RowBox[{"(", 
                    RowBox[{
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox["1",
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"3", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"1", "-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm], "+", "1"}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox["1",
                        HypergeometricPFQ,
                        Editable->True]}], ")"}]}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
                Editable->False],
              HypergeometricPFQ]}], 
          RowBox[{
            TagBox["\[CurlyEpsilon]",
              TraditionalForm], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{"1", "-", 
                RowBox[{"3", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}]}], ")"}], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{\(1\/2\), "-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], ")"}]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(hy = Cases2[rint, HypergeometricPFQ]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          TagBox[
            TagBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["\[InvisiblePrefixScriptBase]", 
                    FormBox["3",
                      "TraditionalForm"]], 
                  SubscriptBox["F", 
                    FormBox["2",
                      "TraditionalForm"]]}], "\[InvisibleApplication]", 
                RowBox[{"(", 
                  RowBox[{
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[
                            RowBox[{\(-2\), " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{\(-2\), " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{\(-2\), " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[
                            RowBox[{"1", "-", 
                              RowBox[{"4", " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"1", "-", 
                              RowBox[{"2", " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}]}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox["1",
                      HypergeometricPFQ,
                      Editable->True]}], ")"}]}],
              InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
              Editable->False],
            HypergeometricPFQ], ",", 
          TagBox[
            TagBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["\[InvisiblePrefixScriptBase]", 
                    FormBox["4",
                      "TraditionalForm"]], 
                  SubscriptBox["F", 
                    FormBox["3",
                      "TraditionalForm"]]}], "\[InvisibleApplication]", 
                RowBox[{"(", 
                  RowBox[{
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox["1",
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[
                            RowBox[{"1", "-", 
                              RowBox[{"3", " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"1", "-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm], "+", "1"}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox["1",
                      HypergeometricPFQ,
                      Editable->True]}], ")"}]}],
              InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
              Editable->False],
            HypergeometricPFQ]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(hn = HypergeometricSE[hy, \[Nu]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          FractionBox[
            RowBox[{"2", " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm], " ", 
              RowBox[{"\[CapitalGamma]", "(", 
                RowBox[{"1", "-", 
                  RowBox[{"4", " ", 
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm]}]}], ")"}], " ", 
              SuperscriptBox[
                RowBox[{"\[CapitalGamma]", "(", 
                  RowBox[{"\[Nu]", "-", 
                    RowBox[{"2", " ", 
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm]}]}], ")"}], "2"]}], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"2", " ", 
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm]}], "-", "\[Nu]"}], ")"}], " ", 
              SuperscriptBox[
                RowBox[{"\[CapitalGamma]", "(", 
                  RowBox[{\(-2\), " ", 
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm]}], ")"}], "2"], 
              " ", \(\[CapitalGamma](\[Nu] + 1)\), " ", 
              RowBox[{"\[CapitalGamma]", "(", 
                RowBox[{
                  RowBox[{\(-4\), " ", 
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm]}], "+", "\[Nu]", "+", "1"}], ")"}]}]], 
          ",", 
          RowBox[{"-", 
            FractionBox[
              RowBox[{
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm], " ", "\[Pi]", " ", 
                RowBox[{"csc", "(", 
                  RowBox[{
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm], " ", "\[Pi]"}], ")"}], " ", 
                RowBox[{"\[CapitalGamma]", "(", 
                  RowBox[{"1", "-", 
                    RowBox[{"3", " ", 
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm]}]}], ")"}], " ", 
                SuperscriptBox[
                  RowBox[{"\[CapitalGamma]", "(", 
                    RowBox[{"\[Nu]", "-", 
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm]}], ")"}], "2"]}], 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm], "-", "\[Nu]"}], ")"}], " ", 
                SuperscriptBox[
                  RowBox[{"\[CapitalGamma]", "(", 
                    RowBox[{"-", 
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm]}], ")"}], "3"], " ", 
                RowBox[{"\[CapitalGamma]", "(", 
                  RowBox[{
                    RowBox[{\(-3\), " ", 
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm]}], "+", "\[Nu]", "+", "1"}], ")"}], 
                " ", 
                RowBox[{"\[CapitalGamma]", "(", 
                  RowBox[{
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm], "+", "\[Nu]", "+", "1"}], 
                  ")"}]}]]}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?HypergeometricSE\)\)], "Input"],

Cell[BoxData[
    \("HypergeometricSE[exp, nu] expresses Hypergeometric functions by their \
series expansion in terms of a sum (the Sum is omitted and nu, running from 0 \
to Infinity is the summation index)."\)], "Print",
  CellTags->"Info3277485417-1053833"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(FunctionExpand[\[Sum]\+\(\[Nu] = 0\)\%\[Infinity] #] &\) /@ 
      hn\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          TagBox[
            TagBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["\[InvisiblePrefixScriptBase]", 
                    FormBox["3",
                      "TraditionalForm"]], 
                  SubscriptBox["F", 
                    FormBox["2",
                      "TraditionalForm"]]}], "\[InvisibleApplication]", 
                RowBox[{"(", 
                  RowBox[{
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[
                            RowBox[{\(-2\), " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{\(-2\), " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{\(-2\), " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[
                            RowBox[{"1", "-", 
                              RowBox[{"4", " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"1", "-", 
                              RowBox[{"2", " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}]}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox["1",
                      HypergeometricPFQ,
                      Editable->True]}], ")"}]}],
              InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
              Editable->False],
            HypergeometricPFQ], ",", 
          TagBox[
            TagBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["\[InvisiblePrefixScriptBase]", 
                    FormBox["4",
                      "TraditionalForm"]], 
                  SubscriptBox["F", 
                    FormBox["3",
                      "TraditionalForm"]]}], "\[InvisibleApplication]", 
                RowBox[{"(", 
                  RowBox[{
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox["1",
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[
                            RowBox[{"1", "-", 
                              RowBox[{"3", " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"1", "-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm], "+", "1"}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox["1",
                      HypergeometricPFQ,
                      Editable->True]}], ")"}]}],
              InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
              Editable->False],
            HypergeometricPFQ]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionExpand[hn /. \[Nu] \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{1, 1}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Do a series expansion up to order ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          TagBox["\[CurlyEpsilon]",
            TraditionalForm], "4"], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(hnexp\  = \ Series2[hn, Epsilon, 4]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              FractionBox[
                RowBox[{"48", " ", 
                  SuperscriptBox[
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm], "4"]}], \(\[Nu]\^4\)]}], "-", 
            FractionBox[
              RowBox[{"8", " ", 
                SuperscriptBox[
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm], "3"]}], \(\[Nu]\^3\)]}], ",", 
          RowBox[{
            RowBox[{"-", 
              FractionBox[
                RowBox[{"3", " ", 
                  SuperscriptBox[
                    TagBox["\[CurlyEpsilon]",
                      TraditionalForm], "4"]}], \(\[Nu]\^4\)]}], "-", 
            FractionBox[
              SuperscriptBox[
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm], "3"], \(\[Nu]\^3\)]}]}], "}"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Series2\)\)], "Input"],

Cell[BoxData[
    \("Series2 performs a series expansion around 0. Series2 is similar to \
Series, except that it applies Normal on the result and that some Series bugs \
are fixed. Series2[f, e, n] is equivalent to  Series2[f, {e, 0, n}] is \
equivalent to Series[f, {e, 0, n}]."\)], "Print",
  CellTags->"Info3277485426-5534220"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(hypexp = 
      1 + \((\(Sum[#, {\[Nu], 1, \[Infinity]}] &\) /@ hnexp)\)\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"1", "-", 
            RowBox[{\(8\/15\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(\[Pi]\^4\), " ", 
                    SuperscriptBox[
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm], "4"]}], "+", 
                  RowBox[{"15", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          Zeta,
                          Editable->True], ")"}],
                      InterpretTemplate[ 
                        Function[ BoxForm`e$, 
                          Zeta[ BoxForm`e$]]]], " ", 
                    SuperscriptBox[
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm], "3"]}]}], ")"}]}]}], ",", 
          RowBox[{
            RowBox[{\(1\/30\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(-\[Pi]\^4\), " ", 
                    SuperscriptBox[
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm], "4"]}], "-", 
                  RowBox[{"30", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          Zeta,
                          Editable->True], ")"}],
                      InterpretTemplate[ 
                        Function[ BoxForm`e$, 
                          Zeta[ BoxForm`e$]]]], " ", 
                    SuperscriptBox[
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm], "3"]}]}], ")"}]}], "+", "1"}]}], 
        "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((hy - hypexp)\) /. Epsilon \[Rule] 0.01\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{\(-2.5024271775047247`*^-8\), \
\(-1.1627923049411867`*^-9\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((hy - hypexp)\) /. Epsilon \[Rule] 0.001\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{\(-2.4058671518051877`*^-13\), \
\(-1.1197113505744332`*^-14\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(hy\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          TagBox[
            TagBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["\[InvisiblePrefixScriptBase]", 
                    FormBox["3",
                      "TraditionalForm"]], 
                  SubscriptBox["F", 
                    FormBox["2",
                      "TraditionalForm"]]}], "\[InvisibleApplication]", 
                RowBox[{"(", 
                  RowBox[{
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[
                            RowBox[{\(-2\), " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{\(-2\), " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{\(-2\), " ", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[
                            RowBox[{"1", "-", 
                              RowBox[{"4", " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"1", "-", 
                              RowBox[{"2", " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}]}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox["1",
                      HypergeometricPFQ,
                      Editable->True]}], ")"}]}],
              InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
              Editable->False],
            HypergeometricPFQ], ",", 
          TagBox[
            TagBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["\[InvisiblePrefixScriptBase]", 
                    FormBox["4",
                      "TraditionalForm"]], 
                  SubscriptBox["F", 
                    FormBox["3",
                      "TraditionalForm"]]}], "\[InvisibleApplication]", 
                RowBox[{"(", 
                  RowBox[{
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox["1",
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[
                            RowBox[{"1", "-", 
                              RowBox[{"3", " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{"1", "-", 
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm]}],
                            HypergeometricPFQ,
                            Editable->True], ",", 
                          TagBox[
                            RowBox[{
                              TagBox["\[CurlyEpsilon]",
                                TraditionalForm], "+", "1"}],
                            HypergeometricPFQ,
                            Editable->True]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      HypergeometricPFQ,
                      Editable->False], ";", 
                    TagBox["1",
                      HypergeometricPFQ,
                      Editable->True]}], ")"}]}],
              InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
              Editable->False],
            HypergeometricPFQ]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(hypexp\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{"1", "-", 
            RowBox[{\(8\/15\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(\[Pi]\^4\), " ", 
                    SuperscriptBox[
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm], "4"]}], "+", 
                  RowBox[{"15", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          Zeta,
                          Editable->True], ")"}],
                      InterpretTemplate[ 
                        Function[ BoxForm`e$, 
                          Zeta[ BoxForm`e$]]]], " ", 
                    SuperscriptBox[
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm], "3"]}]}], ")"}]}]}], ",", 
          RowBox[{
            RowBox[{\(1\/30\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(-\[Pi]\^4\), " ", 
                    SuperscriptBox[
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm], "4"]}], "-", 
                  RowBox[{"30", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          Zeta,
                          Editable->True], ")"}],
                      InterpretTemplate[ 
                        Function[ BoxForm`e$, 
                          Zeta[ BoxForm`e$]]]], " ", 
                    SuperscriptBox[
                      TagBox["\[CurlyEpsilon]",
                        TraditionalForm], "3"]}]}], ")"}]}], "+", "1"}]}], 
        "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[InvisibleSpace]\)\(Thread[hy \[Rule] hypexp]\)\)\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            TagBox[
              TagBox[
                RowBox[{
                  RowBox[{
                    SubscriptBox["\[InvisiblePrefixScriptBase]", 
                      FormBox["3",
                        "TraditionalForm"]], 
                    SubscriptBox["F", 
                      FormBox["2",
                        "TraditionalForm"]]}], "\[InvisibleApplication]", 
                  RowBox[{"(", 
                    RowBox[{
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{\(-2\), " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{\(-2\), " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{\(-2\), " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"4", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"2", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox["1",
                        HypergeometricPFQ,
                        Editable->True]}], ")"}]}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
                Editable->False],
              HypergeometricPFQ], "\[Rule]", 
            RowBox[{"1", "-", 
              RowBox[{\(8\/15\), " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{\(\[Pi]\^4\), " ", 
                      SuperscriptBox[
                        TagBox["\[CurlyEpsilon]",
                          TraditionalForm], "4"]}], "+", 
                    RowBox[{"15", " ", 
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            Zeta,
                            Editable->True], ")"}],
                        InterpretTemplate[ 
                          Function[ BoxForm`e$, 
                            Zeta[ BoxForm`e$]]]], " ", 
                      SuperscriptBox[
                        TagBox["\[CurlyEpsilon]",
                          TraditionalForm], "3"]}]}], ")"}]}]}]}], ",", 
          RowBox[{
            TagBox[
              TagBox[
                RowBox[{
                  RowBox[{
                    SubscriptBox["\[InvisiblePrefixScriptBase]", 
                      FormBox["4",
                        "TraditionalForm"]], 
                    SubscriptBox["F", 
                      FormBox["3",
                        "TraditionalForm"]]}], "\[InvisibleApplication]", 
                  RowBox[{"(", 
                    RowBox[{
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox["1",
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"3", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"1", "-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm], "+", "1"}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox["1",
                        HypergeometricPFQ,
                        Editable->True]}], ")"}]}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
                Editable->False],
              HypergeometricPFQ], "\[Rule]", 
            RowBox[{
              RowBox[{\(1\/30\), " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{\(-\[Pi]\^4\), " ", 
                      SuperscriptBox[
                        TagBox["\[CurlyEpsilon]",
                          TraditionalForm], "4"]}], "-", 
                    RowBox[{"30", " ", 
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            Zeta,
                            Editable->True], ")"}],
                        InterpretTemplate[ 
                          Function[ BoxForm`e$, 
                            Zeta[ BoxForm`e$]]]], " ", 
                      SuperscriptBox[
                        TagBox["\[CurlyEpsilon]",
                          TraditionalForm], "3"]}]}], ")"}]}], "+", "1"}]}]}],
         "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(rint\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{"\[Pi]", " ", 
            RowBox[{"csc", "(", 
              RowBox[{
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm], " ", "\[Pi]"}], ")"}], " ", 
            SuperscriptBox[
              RowBox[{"\[CapitalGamma]", "(", 
                RowBox[{\(-2\), " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], ")"}], "2"], " ", 
            TagBox[
              TagBox[
                RowBox[{
                  RowBox[{
                    SubscriptBox["\[InvisiblePrefixScriptBase]", 
                      FormBox["3",
                        "TraditionalForm"]], 
                    SubscriptBox["F", 
                      FormBox["2",
                        "TraditionalForm"]]}], "\[InvisibleApplication]", 
                  RowBox[{"(", 
                    RowBox[{
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{\(-2\), " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{\(-2\), " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{\(-2\), " ", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"4", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"2", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox["1",
                        HypergeometricPFQ,
                        Editable->True]}], ")"}]}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
                Editable->False],
              HypergeometricPFQ]}], 
          RowBox[{"\[CapitalGamma]", "(", 
            RowBox[{"1", "-", 
              RowBox[{"4", " ", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}]}], ")"}]], "-", 
        FractionBox[
          RowBox[{
            SuperscriptBox["2", 
              RowBox[{
                RowBox[{"2", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], "+", "1"}]], " ", \(\@\[Pi]\), " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{"1", "-", 
                RowBox[{"2", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}]}], ")"}], " ", 
            SuperscriptBox[
              RowBox[{"\[CapitalGamma]", "(", 
                RowBox[{"-", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], ")"}], "2"], " ", 
            TagBox[
              TagBox[
                RowBox[{
                  RowBox[{
                    SubscriptBox["\[InvisiblePrefixScriptBase]", 
                      FormBox["4",
                        "TraditionalForm"]], 
                    SubscriptBox["F", 
                      FormBox["3",
                        "TraditionalForm"]]}], "\[InvisibleApplication]", 
                  RowBox[{"(", 
                    RowBox[{
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox["1",
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox[
                        TagBox[
                          RowBox[{
                            TagBox[
                              RowBox[{"1", "-", 
                                RowBox[{"3", " ", 
                                  TagBox["\[CurlyEpsilon]",
                                    TraditionalForm]}]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{"1", "-", 
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm]}],
                              HypergeometricPFQ,
                              Editable->True], ",", 
                            TagBox[
                              RowBox[{
                                TagBox["\[CurlyEpsilon]",
                                  TraditionalForm], "+", "1"}],
                              HypergeometricPFQ,
                              Editable->True]}],
                          InterpretTemplate[ {
                            SlotSequence[ 1]}&]],
                        HypergeometricPFQ,
                        Editable->False], ";", 
                      TagBox["1",
                        HypergeometricPFQ,
                        Editable->True]}], ")"}]}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&],
                Editable->False],
              HypergeometricPFQ]}], 
          RowBox[{
            TagBox["\[CurlyEpsilon]",
              TraditionalForm], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{"1", "-", 
                RowBox[{"3", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}]}], ")"}], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{\(1\/2\), "-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], ")"}]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(rint /. \[InvisibleSpace]Thread[hy \[Rule] hypexp]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FractionBox[
          RowBox[{"\[Pi]", " ", 
            RowBox[{"csc", "(", 
              RowBox[{
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm], " ", "\[Pi]"}], ")"}], " ", 
            SuperscriptBox[
              RowBox[{"\[CapitalGamma]", "(", 
                RowBox[{\(-2\), " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], ")"}], "2"], " ", 
            RowBox[{"(", 
              RowBox[{"1", "-", 
                RowBox[{\(8\/15\), " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Pi]\^4\), " ", 
                        SuperscriptBox[
                          TagBox["\[CurlyEpsilon]",
                            TraditionalForm], "4"]}], "+", 
                      RowBox[{"15", " ", 
                        TagBox[
                          RowBox[{"\[Zeta]", "(", 
                            TagBox["3",
                              Zeta,
                              Editable->True], ")"}],
                          InterpretTemplate[ 
                            Function[ BoxForm`e$, 
                              Zeta[ BoxForm`e$]]]], " ", 
                        SuperscriptBox[
                          TagBox["\[CurlyEpsilon]",
                            TraditionalForm], "3"]}]}], ")"}]}]}], ")"}]}], 
          RowBox[{"\[CapitalGamma]", "(", 
            RowBox[{"1", "-", 
              RowBox[{"4", " ", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}]}], ")"}]], "-", 
        FractionBox[
          RowBox[{
            SuperscriptBox["2", 
              RowBox[{
                RowBox[{"2", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], "+", "1"}]], " ", \(\@\[Pi]\), " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{"1", "-", 
                RowBox[{"2", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}]}], ")"}], " ", 
            SuperscriptBox[
              RowBox[{"\[CapitalGamma]", "(", 
                RowBox[{"-", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}], ")"}], "2"], " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(1\/30\), " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(-\[Pi]\^4\), " ", 
                        SuperscriptBox[
                          TagBox["\[CurlyEpsilon]",
                            TraditionalForm], "4"]}], "-", 
                      RowBox[{"30", " ", 
                        TagBox[
                          RowBox[{"\[Zeta]", "(", 
                            TagBox["3",
                              Zeta,
                              Editable->True], ")"}],
                          InterpretTemplate[ 
                            Function[ BoxForm`e$, 
                              Zeta[ BoxForm`e$]]]], " ", 
                        SuperscriptBox[
                          TagBox["\[CurlyEpsilon]",
                            TraditionalForm], "3"]}]}], ")"}]}], "+", "1"}], 
              ")"}]}], 
          RowBox[{
            TagBox["\[CurlyEpsilon]",
              TraditionalForm], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{"1", "-", 
                RowBox[{"3", " ", 
                  TagBox["\[CurlyEpsilon]",
                    TraditionalForm]}]}], ")"}], " ", 
            RowBox[{"\[CapitalGamma]", "(", 
              RowBox[{\(1\/2\), "-", 
                TagBox["\[CurlyEpsilon]",
                  TraditionalForm]}], ")"}]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series2[%, Epsilon, 1]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox[
            RowBox[{\(\[Pi]\^4\), " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}], "160"]}], "+", 
        RowBox[{"12", " ", 
          TagBox[
            RowBox[{"\[Zeta]", "(", 
              TagBox["3",
                Zeta,
                Editable->True], ")"}],
            InterpretTemplate[ 
              Function[ BoxForm`e$, 
                Zeta[ BoxForm`e$]]]]}], "+", 
        FractionBox[\(21\ \(\[Zeta](2)\)\), 
          RowBox[{"4", " ", 
            TagBox["\[CurlyEpsilon]",
              TraditionalForm]}]], "-", 
        FractionBox["7", 
          RowBox[{"4", " ", 
            SuperscriptBox[
              TagBox["\[CurlyEpsilon]",
                TraditionalForm], "3"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[%]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox[
            RowBox[{\(\[Pi]\^4\), " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}], "160"]}], "+", 
        RowBox[{"12", " ", 
          TagBox[
            RowBox[{"\[Zeta]", "(", 
              TagBox["3",
                Zeta,
                Editable->True], ")"}],
            InterpretTemplate[ 
              Function[ BoxForm`e$, 
                Zeta[ BoxForm`e$]]]]}], "+", 
        FractionBox[\(21\ \(\[Zeta](2)\)\), 
          RowBox[{"4", " ", 
            TagBox["\[CurlyEpsilon]",
              TraditionalForm]}]], "-", 
        FractionBox["7", 
          RowBox[{"4", " ", 
            SuperscriptBox[
              TagBox["\[CurlyEpsilon]",
                TraditionalForm], "3"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SimplifyPolyLog[%]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox[
            RowBox[{\(\[Pi]\^4\), " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}], "160"]}], "+", 
        RowBox[{"12", " ", 
          TagBox[
            RowBox[{"\[Zeta]", "(", 
              TagBox["3",
                Zeta,
                Editable->True], ")"}],
            InterpretTemplate[ 
              Function[ BoxForm`e$, 
                Zeta[ BoxForm`e$]]]]}], "+", 
        FractionBox[\(63\ \(\[Zeta](2)\)\), 
          RowBox[{"2", " ", 
            TagBox["\[CurlyEpsilon]",
              TraditionalForm]}]], "-", 
        FractionBox["7", 
          RowBox[{"4", " ", 
            SuperscriptBox[
              TagBox["\[CurlyEpsilon]",
                TraditionalForm], "3"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SimplifyPolyLog\)\)], "Input"],

Cell[BoxData[
    \("SimplifyPolyLog[y] performs several simplifications assuming  that the \
variables  occuring in the Log and PolyLog functions are between 0 and 1. The \
simplifications will in general not  be valid if the arguments are complex or \
outside the range between 0 and 1."\)], "Print",
  CellTags->"Info3277485428-7347271"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(total = 
      Expand[SimplifyPolyLog[
          Series2[rint /. \[InvisibleSpace]Thread[hy \[Rule] hypexp], 
            Epsilon, 1]]]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox[
            RowBox[{\(\[Pi]\^4\), " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}], "160"]}], "+", 
        RowBox[{"12", " ", 
          TagBox[
            RowBox[{"\[Zeta]", "(", 
              TagBox["3",
                Zeta,
                Editable->True], ")"}],
            InterpretTemplate[ 
              Function[ BoxForm`e$, 
                Zeta[ BoxForm`e$]]]]}], "+", 
        FractionBox[\(63\ \(\[Zeta](2)\)\), 
          RowBox[{"2", " ", 
            TagBox["\[CurlyEpsilon]",
              TraditionalForm]}]], "-", 
        FractionBox["7", 
          RowBox[{"4", " ", 
            SuperscriptBox[
              TagBox["\[CurlyEpsilon]",
                TraditionalForm], "3"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(epsdat = 
      Table[{x, rint /. Epsilon\  \[Rule] \ x}, {x, 1/1000, 1/100, 1/1000}] // 
        N\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0.001`", \(-1.749991349672133`*^9\)},
            {"0.002`", \(-2.1874566762484592`*^8\)},
            {"0.003`", \(-6.481192175787556`*^7\)},
            {"0.004`", \(-2.7341576602742467`*^7\)},
            {"0.005`", \(-1.3998258399084933`*^7\)},
            {"0.006`", \(-8.100398115672059`*^6\)},
            {"0.007`", \(-5.100792698303607`*^6\)},
            {"0.008`", \(-3.4168748460705876`*^6\)},
            {"0.009`", \(-2.399574737676905`*^6\)},
            {"0.01`", \(-1.7491219971002743`*^6\)}
            },
          ColumnAlignments->{Decimal}], "\[NoBreak]", ")"}], 
      TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fit[epsdat, {x, 1, 1/x, 1/x^2, 1/x^3, 1/x^4}, x]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-2.344086992142816`\)\ x + \(\(14.443443394100994`\)\
\(\[InvisibleSpace]\)\) + 8.635806938762258`\/x + 
      2.5110892342126944`*^-7\/x\^2 - 1.7500000003062979`\/x\^3 + 
      1.350181130143507`*^-13\/x\^4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(-7\)/4. \)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(-1.75`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(21\ Zeta[2]/4. \)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`8.635903850953188`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(total\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"-", 
          FractionBox[
            RowBox[{\(\[Pi]\^4\), " ", 
              TagBox["\[CurlyEpsilon]",
                TraditionalForm]}], "160"]}], "+", 
        RowBox[{"12", " ", 
          TagBox[
            RowBox[{"\[Zeta]", "(", 
              TagBox["3",
                Zeta,
                Editable->True], ")"}],
            InterpretTemplate[ 
              Function[ BoxForm`e$, 
                Zeta[ BoxForm`e$]]]]}], "+", 
        FractionBox[\(63\ \(\[Zeta](2)\)\), 
          RowBox[{"2", " ", 
            TagBox["\[CurlyEpsilon]",
              TraditionalForm]}]], "-", 
        FractionBox["7", 
          RowBox[{"4", " ", 
            SuperscriptBox[
              TagBox["\[CurlyEpsilon]",
                TraditionalForm], "3"]}]]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TimeUsed[]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`35.77`\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1400}, {0, 1050}},
WindowSize->{1272, 938},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{597.562, 842.375},
"PaperOrientation"->"Portrait",
"PostScriptOutputFile":>FrontEnd`FileName[{$RootDirectory, "home", "rolfm"}, \
"denksport3.ps", CharacterEncoding -> "iso8859-1"],
"Magnification"->1},
ShowSelection->True,
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3277485402-1628141"->{
    Cell[12217, 345, 430, 6, 123, "Print",
      CellTags->"Info3277485402-1628141"]},
  "Info3277485417-1053833"->{
    Cell[42640, 1094, 261, 4, 78, "Print",
      CellTags->"Info3277485417-1053833"]},
  "Info3277485426-5534220"->{
    Cell[50599, 1308, 331, 5, 100, "Print",
      CellTags->"Info3277485426-5534220"]},
  "Info3277485428-7347271"->{
    Cell[84306, 2171, 340, 5, 100, "Print",
      CellTags->"Info3277485428-7347271"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3277485402-1628141", 89277, 2336},
  {"Info3277485417-1053833", 89394, 2339},
  {"Info3277485426-5534220", 89511, 2342},
  {"Info3277485428-7347271", 89629, 2345}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 135, 5, 114, "Section"],
Cell[1914, 60, 63, 1, 39, "Input"],
Cell[1980, 63, 515, 9, 171, "Text"],

Cell[CellGroupData[{
Cell[2520, 76, 365, 6, 91, "Input"],
Cell[2888, 84, 1567, 36, 78, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4492, 125, 65, 1, 39, "Input"],
Cell[4560, 128, 1022, 29, 78, "Output"]
}, Open  ]],
Cell[5597, 160, 243, 10, 46, "Text"],
Cell[5843, 172, 280, 5, 62, "Input"],

Cell[CellGroupData[{
Cell[6148, 181, 85, 1, 63, "Input"],
Cell[6236, 184, 2809, 70, 80, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9082, 259, 60, 1, 39, "Input"],
Cell[9145, 262, 2981, 75, 80, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12163, 342, 51, 1, 39, "Input"],
Cell[12217, 345, 430, 6, 123, "Print",
  CellTags->"Info3277485402-1628141"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12684, 356, 89, 1, 63, "Input"],
Cell[12776, 359, 4647, 112, 77, "Output"]
}, Open  ]],
Cell[17438, 474, 102, 3, 45, "Text"],

Cell[CellGroupData[{
Cell[17565, 481, 168, 4, 67, "Input"],
Cell[17736, 487, 6756, 157, 131, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24529, 649, 109, 2, 39, "Input"],
Cell[24641, 653, 311, 9, 59, "Output"]
}, Open  ]],
Cell[24967, 665, 44, 0, 45, "Text"],

Cell[CellGroupData[{
Cell[25036, 669, 80, 1, 63, "Input"],
Cell[25119, 672, 8018, 183, 153, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33174, 860, 69, 1, 39, "Input"],
Cell[33246, 863, 5987, 139, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39270, 1007, 65, 1, 39, "Input"],
Cell[39338, 1010, 3208, 76, 85, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42583, 1091, 54, 1, 39, "Input"],
Cell[42640, 1094, 261, 4, 78, "Print",
  CellTags->"Info3277485417-1053833"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42938, 1103, 104, 2, 72, "Input"],
Cell[43045, 1107, 5987, 139, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49069, 1251, 70, 1, 39, "Input"],
Cell[49142, 1254, 57, 1, 59, "Output"]
}, Open  ]],
Cell[49214, 1258, 220, 8, 45, "Text"],

Cell[CellGroupData[{
Cell[49459, 1270, 68, 1, 39, "Input"],
Cell[49530, 1273, 984, 27, 82, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50551, 1305, 45, 1, 39, "Input"],
Cell[50599, 1308, 331, 5, 100, "Print",
  CellTags->"Info3277485426-5534220"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50967, 1318, 105, 2, 39, "Input"],
Cell[51075, 1322, 1769, 44, 78, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52881, 1371, 74, 1, 39, "Input"],
Cell[52958, 1374, 113, 2, 64, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53108, 1381, 75, 1, 39, "Input"],
Cell[53186, 1384, 115, 2, 64, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53338, 1391, 35, 1, 39, "Input"],
Cell[53376, 1394, 5987, 139, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59400, 1538, 39, 1, 39, "Input"],
Cell[59442, 1541, 1769, 44, 78, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[61248, 1590, 87, 1, 39, "Input"],
Cell[61338, 1593, 8067, 182, 125, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69442, 1780, 37, 1, 39, "Input"],
Cell[69482, 1783, 8018, 183, 153, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77537, 1971, 83, 1, 39, "Input"],
Cell[77623, 1974, 3760, 90, 165, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[81420, 2069, 55, 1, 39, "Input"],
Cell[81478, 2072, 854, 25, 82, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82369, 2102, 42, 1, 39, "Input"],
Cell[82414, 2105, 854, 25, 82, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[83305, 2135, 51, 1, 39, "Input"],
Cell[83359, 2138, 854, 25, 82, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84250, 2168, 53, 1, 39, "Input"],
Cell[84306, 2171, 340, 5, 100, "Print",
  CellTags->"Info3277485428-7347271"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84683, 2181, 168, 4, 61, "Input"],
Cell[84854, 2187, 854, 25, 82, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85745, 2217, 132, 3, 39, "Input"],
Cell[85880, 2222, 704, 15, 331, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[86621, 2242, 81, 1, 39, "Input"],
Cell[86705, 2245, 260, 4, 82, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87002, 2254, 43, 1, 39, "Input"],
Cell[87048, 2257, 61, 1, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87146, 2263, 48, 1, 39, "Input"],
Cell[87197, 2266, 69, 1, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87303, 2272, 38, 1, 39, "Input"],
Cell[87344, 2275, 854, 25, 82, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88235, 2305, 43, 1, 39, "Input"],
Cell[88281, 2308, 57, 1, 59, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

