(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    637933,      17214]*)
(*NotebookOutlinePosition[    661673,      17961]*)
(*  CellTagsIndexPosition[    655897,      17776]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["TARCER 1.995", "Title",
  TextAlignment->Center,
  CellTags->"T1.1"],

Cell[TextData[{
  "A ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " program for the reduction of two-loop propagator integrals "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Rolf Mertig\n",
  ButtonBox["Mertig Research & Consulting\n",
    ButtonData:>{
      URL[ "http://www.mertig.com"], None},
    ButtonStyle->"Hyperlink"],
  "and\nRainer Scharf\n",
  ButtonBox["Universit\[ADoubleDot]t Leipzig",
    ButtonData:>{
      URL[ "http://www.physik.uni-leipzig.de/~scharf/"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Editable->False,
  TextAlignment->Center,
  CellTags->"T1.2"],

Cell["14th March, 2004", "Text",
  TextAlignment->Center],

Cell["\<\
COMMENTS (RM 14.3..2004) uncommented a global variable \
assignement.changed default setting of $RankLimit to {2,5}.\
\>", "Text"],

Cell["\<\
COMMENTS (RM 31.10.2003) Change default settings of TarcerExpand, \
modify $BasisIntegras for massless integrals,
changed default setting of $RankLimit to {1,6}.\
\>", "Text"],

Cell["\<\
COMMENTS (RM 28.10.2003) Fixed a bug in TarcerExpand (only \
introduced recently),
changed default setting of $RankLimit to {1,5}.\
\>", "Text"],

Cell["\<\
COMMENTS (RM 24.9.2003) Relaxed a condition in equation (61) and \
(6153)\
\>", "Text"],

Cell["\<\
COMMENTS (RM 18.9.2003): Fixed things for 5.0, eliminated a TVI \
symmetry (causing infinite recursion) and added
TFI decomposition into products of TAI's (was somehow missing but shows up \
in, e.g., the 2-loop Higss selfenergy).
Putting TFI back into the Tarcer context, because the fcloops context created \
trouble ...
Changed default of $Comment to False.\
\>", "Text"],

Cell["\<\
COMMENTS (FO 8.9.2002.): Changed context of TFI to \
HighEnergyPhysics`fcloops`TFI` and updated other HighEnergyPhysics`* \
contexts.\
\>", "Text"],

Cell["\<\
COMMENTS (FO 15.3.2001.): Changed PreFactor into Prefactor1 to \
avoid conflict with FeynArts and FeynCalc.\
\>", "Text"],

Cell["\<\
COMMENTS (FO 15.3.2001.): Changed context of Zeta2 and made \
definition dependent on not having loaded FeynCalc.\
\>", "Text"],

Cell[TextData[{
  "COMMENTS (RM 25.4.): ",
  ButtonBox["TFISimplify",
    ButtonData:>"T1.7.1.1",
    ButtonStyle->"Hyperlink"],
  " (like TFIRecurse, but without trule[9])."
}], "Text"],

Cell[TextData[{
  "COMMENTS (RM 23.4.): bug fixed in ",
  ButtonBox["tlrule[17]",
    ButtonData:>"tlrule17",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell[TextData[{
  "COMMENTS (RM 6.4.):  ",
  ButtonBox["special TVR relations",
    ButtonData:>"specialTVR",
    ButtonStyle->"Hyperlink"],
  " added to TVR."
}], "Text"],

Cell[TextData[{
  "COMMENTS (RM 22.3.):  ",
  ButtonBox["TVI Symmetry",
    ButtonData:>"Tsymmetry",
    ButtonStyle->"Hyperlink"],
  " added to TVR."
}], "Text"],

Cell[TextData[{
  "COMMENTS (RM 18.3.): More rules added to ",
  ButtonBox["$TTable",
    ButtonData:>"$TTable",
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text"],

Cell[TextData[{
  "COMMENTS (RM 18.2.): More rules added to ",
  ButtonBox["$TTable",
    ButtonData:>"$TTable",
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text"],

Cell[TextData[{
  "COMMENTS (RM 21.2.): Included ",
  ButtonBox["$TTable",
    ButtonData:>"$TTable",
    ButtonStyle->"Hyperlink"],
  ". added tlrule[25]"
}], "Text"],

Cell["\<\
COMMENTS (RM 20.2.): $RankLimit = {0,6} ;  Changed TarcerRecurse \
such that special TJR and TVR (reducing D -> D-2) are used first.\
\>", "Text"],

Cell["\<\
COMMENTS (RM 15.2.): $RankLimit = {0,8} ;  
                                              The following test now works:
                                              
                                                 Print[\"test 1 :  TFI[D, pp, \
{0, 0, 0, 1, 3}, {{1, MW}, {1, MZ}, {0, 0}, {1, MZ}, {1,MW}}] = \",
                                                            Timing[t1 \
=TarcerRecurse[TFI[D, pp, {0, 0, 0, 1, 3}, {{1, MW}, {1, MZ}, {0, 0}, {1, \
MZ}, {1,MW}}]]
                                                                       ] // \
InputForm
                                                         ]

                                                  Print[\"test 2 :  TFI[d, \
pp, 0, {0, 0, 0, 0, 4},{{1, m1}, {1, m2}, 0, 0, 0}] = \",
                                                           Timing[t2 \
=TarcerRecurse[TFI[D, pp,  0, {0, 0, 0, 0, 4},{{1, m1}, {1, m2}, 0, 0, 0}]];
                                                                       ] // \
InputForm
                                                          ]
\
\>", "Text"],

Cell["\<\
COMMENTS (RM 13.2.): tlrule[11] and trule[12] made more \
restrictive: inhibiting thus a recursion if {n5,m5} equals {0,0}.\
\>", "Text"],

Cell["\<\
COMMENTS (RM 12.2.): tlrule[15] made safer (in order to not get   0 \
:> 0 );
                                             TFIRecurse made safer (to not \
get into a recursion);
                                                  There is still something \
wrong with the tlrule's ; since 
                                         TFIRecurse[TFI[D, pp, {0, 0, 0, 1, \
3}, {{1, MW}, {1, MZ}, {0, 0}, {1, MZ}, {1,   MW}}]]
                                         doesn't work ..\
\>", "Text"],

Cell["\<\
COMMENTS (RM 5.2.): tlrule[10] slightly changed to cover more \
cases.\
\>", "Text"],

Cell["\<\
COMMENTS (RM 2.2.):  FunctionExpand added in tlrule[9]. Option \
TimeConstraint added to TarcerRecurse (because TimeConstrained is buggy under \
Linux).\
\>", "Text"],

Cell[TextData[{
  "COMMENTS (RM 1.2.):  Changed TarcerRecurse. New TLR ",
  ButtonBox["definition",
    ButtonData:>"TLRdef",
    ButtonStyle->"Hyperlink"],
  ". \n                          default $RankLimit={0,6};"
}], "Text"],

Cell[BoxData[
    \(\($Remember = True;\)\)], "Input"],

Cell["\<\
COMMENTS (RM 19.1.):   changes are:  tlrule[22] and tlrule[23], \
minor efficiency changes (Expand3 = Identity) and other small programming \
optimizations.\
\>", "Text"],

Cell["\<\
COMMENTS (RM 22.1.):   changes are: bug in tlrule[23] fixed, new \
tlrule[24], new option Factor to TarcerReduce (doesn't change anything by \
default, but allows for improved Factor-ing).\
\>", "Text"],

Cell[TextData[{
  "See also: ",
  ButtonBox["hep-ph/9801383",
    ButtonData:>{
      URL[ "http://xxx.lanl.gov/abs/hep-ph/9801383"], None},
    ButtonStyle->"Hyperlink"],
  ", published in Comput. Phys. Commun. 111 (1998) 265-273"
}], "Text",
  Editable->False],

Cell[CellGroupData[{

Cell["Table of contents", "Section",
  CellDingbat->"\[FilledSmallCircle]"],

Cell[TextData[ButtonBox["Preliminaries",
  ButtonData:>"T1.1.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Usages",
  ButtonData:>"T1.2.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Creating the tarcerij.mx file",
  ButtonData:>"T1.2.1.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Prologue (setting of $RankLimit)",
  ButtonData:>"T1.3.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Typesetting rules",
  ButtonData:>"T1.3.1.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["The Palettes",
  ButtonData:>"T1.3.2.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["OperatorApply",
  ButtonData:>"T1.3.3.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MassDerivative",
  ButtonData:>"T1.3.4.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["TarasovT",
  ButtonData:>"T1.3.5.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["ApplyTarasovT",
  ButtonData:>"T1.3.6.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Misc",
  ButtonData:>"T1.3.7.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Colors",
  ButtonData:>"T1.3.7.1.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["PQ",
  ButtonData:>"T1.3.7.2.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["PNQ",
  ButtonData:>"T1.3.7.3.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["FactorC",
  ButtonData:>"T1.3.7.4.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["TFI",
  ButtonData:>"T1.3.7.5.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["TJI",
  ButtonData:>"T1.3.7.6.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["TBI",
  ButtonData:>"T1.3.7.7.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["TAI",
  ButtonData:>"T1.3.7.8.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["Definitions and notation",
  ButtonData:>"T1.4.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[StyleBox[ButtonBox["ToArgs",
  ButtonData:>"T1.4.1.1",
  ButtonStyle->"Hyperlink"],
  FontColor->RGBColor[0.2, 0.6, 1]]], "Text"],

Cell[TextData[StyleBox[ButtonBox["Cayley",
  ButtonData:>"T1.4.2.1",
  ButtonStyle->"Hyperlink"],
  FontColor->RGBColor[1, 0, 0.4]]], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            RowBox[{
              StyleBox["Cayley",
                FontColor->RGBColor[1, 0, 0.4]], "[", "i", "]"}], 
            "=", \(\[CapitalDelta]\_i\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.4.3.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TextForm]]]], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            RowBox[{
              StyleBox["CayleyD",
                FontColor->RGBColor[1, 0.2, 1]], "[", "i", "]"}], 
            "=", \(\[CapitalDelta]\_i/\[CapitalDelta]\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.4.4.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TextForm]]]], "Text"],

Cell[TextData[ButtonBox["Utility Functions",
  ButtonData:>"T1.5.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun and friends",
  ButtonData:>"T1.5.1.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Interchange",
  ButtonData:>"T1.5.1.1.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[{
  ButtonBox["\[Nu]",
    ButtonData:>"T1.5.2.1",
    ButtonStyle->"Hyperlink"],
  ButtonBox["explicit",
    ButtonData:>"T1.5.2.1",
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell[TextData[ButtonBox["TA",
  ButtonData:>"T1.5.2.1.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["CheckRecursion",
  ButtonData:>"T1.5.3.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["CheckTVIRecursion",
  ButtonData:>"T1.5.3.1.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["CheckTJIRecursion",
  ButtonData:>"T1.5.3.2.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["Recurrence Relations Input and Recursion Function \
Generation",
  ButtonData:>"T1.6.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (35)",
  ButtonData:>"T1.6.1.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (35)",
  ButtonData:>"T1.6.2.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            FormBox[\(1\^\(\(+\)\(\ \)\)\),
              "TraditionalForm"], \(\(\ \)\((\(35  _\) 1)\)\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.6.2.1.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "SmallText"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            FormBox[\(2\^\(\(+\)\(\ \)\)\),
              "TraditionalForm"], \(\(\ \)\((\(35  _\) 2)\)\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.6.2.2.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "SmallText"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            FormBox[\(3\^\(\(+\)\(\ \)\)\),
              "TraditionalForm"], \(\(\ \)\((\(35  _\) 3)\)\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.6.2.3.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "SmallText"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            FormBox[\(4\^\(\(+\)\(\ \)\)\),
              "TraditionalForm"], \(\(\ \)\((\(35  _\) 4)\)\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.6.2.4.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "SmallText"],

Cell[TextData[ButtonBox["Input (3501)",
  ButtonData:>"T1.6.3.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          
          RowBox[{\(\(MakeFun\ \((3501)\)\ \[CapitalDelta]\)\(=\)\(0\)\(\ \
\)\), 
            FormBox[\((p\^2 = m\^2)\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.6.4.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Text"],

Cell[TextData[ButtonBox["Input (3502)",
  ButtonData:>"T1.6.5.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          
          RowBox[{\(\(MakeFun\ \((3502)\)\ \[CapitalDelta]\)\(=\)\(0\)\(\ \
\)\), 
            FormBox[\((p\^2 = m\^2)\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.6.6.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          
          RowBox[{\(\(MakeFun\ \((3503)\)\ \[CapitalDelta]\)\(=\)\(0\)\(\ \
\)\), 
            FormBox[\((p\^2 = m\^2)\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.6.7.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          
          RowBox[{\(\(MakeFun\ \((3504)\)\ \[CapitalDelta]\)\(=\)\(0\)\(\ \
\)\), 
            FormBox[\((p\^2 = m\^2)\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>"T1.6.8.1",
        Active->True,
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Text"],

Cell[TextData[ButtonBox["Input (41)",
  ButtonData:>"T1.6.9.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (41)",
  ButtonData:>"T1.6.10.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (43)",
  ButtonData:>"T1.6.11.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (44)",
  ButtonData:>"T1.6.12.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (45)",
  ButtonData:>"T1.6.13.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (43) and (44)",
  ButtonData:>"T1.6.14.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (50)",
  ButtonData:>"T1.6.15.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (51)",
  ButtonData:>"T1.6.16.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (51)",
  ButtonData:>"T1.6.17.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (52)",
  ButtonData:>"T1.6.18.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (52)",
  ButtonData:>"T1.6.19.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (53)",
  ButtonData:>"T1.6.20.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (54)",
  ButtonData:>"T1.6.21.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (54)",
  ButtonData:>"T1.6.22.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (55)",
  ButtonData:>"T1.6.23.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (55)",
  ButtonData:>"T1.6.24.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (56)",
  ButtonData:>"T1.6.25.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (56)",
  ButtonData:>"T1.6.26.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (59)",
  ButtonData:>"T1.6.27.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (59)",
  ButtonData:>"T1.6.28.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (60)",
  ButtonData:>"T1.6.29.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (60)",
  ButtonData:>"T1.6.30.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (61)",
  ButtonData:>"T1.6.31.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (61)",
  ButtonData:>"T1.6.32.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (6153)",
  ButtonData:>"T1.6.33.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (62)",
  ButtonData:>"T1.6.34.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (62)",
  ButtonData:>"T1.6.35.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (63)",
  ButtonData:>"T1.6.36.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (63)",
  ButtonData:>"T1.6.37.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (6552)",
  ButtonData:>"T1.6.38.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (6552)",
  ButtonData:>"T1.6.39.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (6553)",
  ButtonData:>"T1.6.40.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (66)",
  ButtonData:>"T1.6.41.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (66)",
  ButtonData:>"T1.6.42.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (alternative67)",
  ButtonData:>"T1.6.43.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (67)",
  ButtonData:>"T1.6.44.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (67)",
  ButtonData:>"T1.6.45.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (6713)",
  ButtonData:>"T1.6.46.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (68)",
  ButtonData:>"T1.6.47.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (68)",
  ButtonData:>"T1.6.48.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (6813)",
  ButtonData:>"T1.6.49.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (70)",
  ButtonData:>"T1.6.50.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (70)",
  ButtonData:>"T1.6.51.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (71)",
  ButtonData:>"T1.6.52.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (71)",
  ButtonData:>"T1.6.53.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (7123)",
  ButtonData:>"T1.6.54.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (7113)",
  ButtonData:>"T1.6.55.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (78)",
  ButtonData:>"T1.6.56.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (78)",
  ButtonData:>"T1.6.57.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (80)",
  ButtonData:>"T1.6.58.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (80)",
  ButtonData:>"T1.6.59.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (81)",
  ButtonData:>"T1.6.60.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (81)",
  ButtonData:>"T1.6.61.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (8123)",
  ButtonData:>"T1.6.62.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (8113)",
  ButtonData:>"T1.6.63.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (82)",
  ButtonData:>"T1.6.64.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (82)",
  ButtonData:>"T1.6.65.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (8213)",
  ButtonData:>"T1.6.66.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (8212)",
  ButtonData:>"T1.6.67.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (83)",
  ButtonData:>"T1.6.68.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (83)",
  ButtonData:>"T1.6.69.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (87)",
  ButtonData:>"T1.6.70.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["(88)",
  ButtonData:>"T1.6.70.1.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["(89)",
  ButtonData:>"T1.6.70.2.1",
  ButtonStyle->"Hyperlink"]], "SmallText"],

Cell[TextData[ButtonBox["MakeFun (87)",
  ButtonData:>"T1.6.71.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (90)",
  ButtonData:>"T1.6.72.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (90)",
  ButtonData:>"T1.6.73.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (91)",
  ButtonData:>"T1.6.74.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (911)",
  ButtonData:>"T1.6.75.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (912)",
  ButtonData:>"T1.6.76.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (913)",
  ButtonData:>"T1.6.77.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (914)",
  ButtonData:>"T1.6.78.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (92)",
  ButtonData:>"T1.6.79.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (93)",
  ButtonData:>"T1.6.80.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (93)",
  ButtonData:>"T1.6.81.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (94)",
  ButtonData:>"T1.6.82.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (94)",
  ButtonData:>"T1.6.83.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (9401)",
  ButtonData:>"T1.6.84.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (9402)",
  ButtonData:>"T1.6.85.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (95)",
  ButtonData:>"T1.6.86.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (95)",
  ButtonData:>"T1.6.87.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (96)",
  ButtonData:>"T1.6.88.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (96)",
  ButtonData:>"T1.6.89.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (97)",
  ButtonData:>"T1.6.90.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (97)",
  ButtonData:>"T1.6.91.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (98)",
  ButtonData:>"T1.6.92.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (98)",
  ButtonData:>"T1.6.93.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (99)",
  ButtonData:>"T1.6.94.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (99)",
  ButtonData:>"T1.6.95.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (9912)",
  ButtonData:>"T1.6.96.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (9913)",
  ButtonData:>"T1.6.97.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (100)",
  ButtonData:>"T1.6.98.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (100)",
  ButtonData:>"T1.6.99.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (1002)",
  ButtonData:>"T1.6.100.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (1003)",
  ButtonData:>"T1.6.101.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (1004)",
  ButtonData:>"T1.6.102.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (1005)",
  ButtonData:>"T1.6.103.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (1006)",
  ButtonData:>"T1.6.104.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (150)",
  ButtonData:>"T1.6.105.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (150)",
  ButtonData:>"T1.6.106.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (151)",
  ButtonData:>"T1.6.107.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (151)",
  ButtonData:>"T1.6.108.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (152)",
  ButtonData:>"T1.6.109.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (152)",
  ButtonData:>"T1.6.110.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (153)",
  ButtonData:>"T1.6.111.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (153)",
  ButtonData:>"T1.6.112.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (200)",
  ButtonData:>"T1.6.113.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (200)",
  ButtonData:>"T1.6.114.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (201)",
  ButtonData:>"T1.6.115.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (202)",
  ButtonData:>"T1.6.116.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (203)",
  ButtonData:>"T1.6.117.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (204)",
  ButtonData:>"T1.6.118.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["MakeFun (205)",
  ButtonData:>"T1.6.119.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Input (1xxxx)",
  ButtonData:>"T1.6.120.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["five -> four",
  ButtonData:>"T1.6.121.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["four -> three",
  ButtonData:>"T1.6.122.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["three -> two",
  ButtonData:>"T1.6.123.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["two -> one",
  ButtonData:>"T1.6.124.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["TarcerRecurse and TFIRecurse",
  ButtonData:>"T1.7.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["TFIRecurse",
  ButtonData:>"T1.7.1.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["T*IS",
  ButtonData:>"T1.7.2.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["TComment",
  ButtonData:>"T1.7.3.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["TarcerRecurse",
  ButtonData:>"T1.7.4.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["TarcerExpand",
  ButtonData:>"T1.8.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Construct T's",
  ButtonData:>"T1.9.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["$BasisIntegrals",
  ButtonData:>"T1.10.1",
  ButtonStyle->"Hyperlink"]], "Text"],

Cell[TextData[ButtonBox["Save",
  ButtonData:>"T1.9.1",
  ButtonStyle->"Hyperlink"]], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.1.1"],

Cell[TextData[{
  "This is free software.\nYou may use it, distribute it, change it, improve \
it, etc..\nIf you have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " questions, ask them to support@wolfram.com or to your local ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reseller."
}], "SmallText",
  Editable->False],

Cell["\<\
 We consider the following type of integrals, where a,b,u,v,r,s,t \
are non-negative integers.\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\(\(TFI\)\([\)\(d, 
        p\^2, \[CapitalDelta]p, {a, b}, {u, v, r, s, t}\)\)\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      FormBox[\({{\[Nu]\_1, m\_1}, {\(\[Nu]\_2\)\(,\)\),
                        "TraditionalForm"], \(m\_2\)}], "}"}], 
                  ",", \({\[Nu]\_3, m\_3}\), ",", \({\[Nu]\_4, m\_4}\), 
                  ",", \({\[Nu]\_5, m\_5}\)}], "}"}], "]"}], " ", "="}], 
          " "}], TraditionalForm]]],
  "\n\n",
  Cell[BoxData[
      \(TraditionalForm\`1\/\[Pi]\^d\)]],
  "\[Integral] \[Integral] ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{
            
            FormBox[\(\(d\^d\) k\_1\ \(d\^d\) 
                k\_2\ \(\((\[CapitalDelta]\[CenterDot]
                        k\_1)\)\^a\) \((\[CapitalDelta]\[CenterDot]k\_1)\)\^b\
\),
              
              "TraditionalForm"], \(\((k\_1\%2)\)\^u\), \(\((k\_2\%2)\)\^v\), \
\(\((p\[CenterDot]k\_1)\)\^r\), \(\((p\[CenterDot]
                    k\_2)\)\^s\), \(\((k\_1\[CenterDot]
                    k\_2)\)\^t\)}], \(\(\(\(\(\(\([\)\(k\_1\%2 - 
                                        m\_1\%2\)\(]\)\)\^\[Nu]\_1\)[
                                  k\_2\%2 - 
                                    m\_2\%2]\^\[Nu]\_2\)[\((k\_1 - p)\)\^2 - 
                              m\_3\%2]\^\[Nu]\_3\)[\((k\_2 - p)\)\^2 - 
                        m\_4\%2]\^\[Nu]\_4\)[\((k\_1 - k\_2)\)\^2 - 
                  m\_5\%2]\^\[Nu]\_5\)], TraditionalForm]]]
}], "Text"],

Cell["\<\
Putting the        $Post = (#;)&;       instruction after   
Unset[$Post]   suppresses all output cells.
Putting Unset[$Post] behind  $Post=(#:)&;
will produce a lot of typsetted reduction formulae.\
\>", "Text"],

Cell[BoxData[
    \(\(Unset[$Post];\)\)], "Input"],

Cell[BoxData[
    \(\($Post\  = \ \((\(#;\))\) &;\)\)], "Input"],

Cell[BoxData[
    \(\(If[$Notebooks =!= True, $Post\  = \ \((\(#;\))\) &];\)\)], "Input"],

Cell[BoxData[
    \(\($HistoryLength = 0;\)\)], "Input"],

Cell["\<\
This determines the directory into which the resulting file \
tarcer.mx is written.\
\>", "Text"],

Cell[BoxData[
    \(If[$Notebooks, 
      SetDirectory[
        ToFileName[
          First["\<FileName\>" /. 
              NotebookInformation[InputNotebook[]]]]]]\)], "Input"],

Cell[TextData[{
  "Somehow ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " crashes on my (R.M.) good old NeXTStation if I don't open all cells first \
...; this opens all cells automatically:"
}], "SmallText"],

Cell[BoxData[
    \(If[$System === "\<NeXT\>", 
      SelectionMove[EvaluationNotebook[], All, Notebook]; 
      FrontEndExecute[{FrontEnd`FrontEndToken[
            EvaluationNotebook[], "\<SelectionOpenAllGroups\>"]}]]\)], "Input"],

Cell[BoxData[
    \(\(Off[General::spell];\)\)], "Input"],

Cell[BoxData[
    \(\(Off[General::spell1];\)\)], "Input"],

Cell[CellGroupData[{

Cell["Creating the tarcerij.mx file", "Subsubsection",
  CellTags->"T1.2.1.1"],

Cell[TextData[{
  "Running this notebook will produce a tarcerij.mx file where ij will be \
replaced by \nthe two number set by the variable $RankLimit (default 33). \n\
In the same directory as this notebook which can be loaded  into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by    <<tarcer33.mx,\nor, when running in Terminal mode, on Unix systems, \
already when starting ",
  StyleBox["Mathematica, ",
    FontSlant->"Italic"],
  "as \nmyshellprompt>  math -initfile tarcer33.mx"
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Usages", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.2.1"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\(BeginPackage["\<HighEnergyPhysics`Tarcer`\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(TarcerRecurse::usage = "\<TarcerRecurse[expr] applies recurrence \
relations for all TFI's (and TVI, TJI, TBI, TAI) in expr. For evaluation and \
Laurent expansion of the resulting basis integrals use \
TarcerExpand.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(TarcerExpand::usage = "\<TarcerExpand[expr, d -> (4+e), order] or \
TarcerExpand[epxr, d -> (4-e), order] or TarcerExpand[expr, d -> (4 - 2 \
om)substitutes integrals as specified by the option TarcerRules, and does a \
Laurent expansion in the variable around 0 at the right hand side of the \
second argument (i.e., you can use whatever convention you like ...). The \
same effect as TarcerExpand[TarcerRecurse[expr], ...] can be achieved by \
setting the option TarcerRecurse of TarcerExpand to True. TarcerExpand[expr, \
d -> (4+e)] is equivalent to TarcerExpand[expr, d -> (4+e), 0].\>";\)\)], \
"Input"],

Cell[BoxData[
    \(\(TarcerReduce::usage = "\<TarcerReduce is an option to TarcerExpand. \
It should be set to a list of basic integrals.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(Cayley::usage = "\<Cayley[m1,m2,m3,m4,m5,Sqrt[pp]] is the Cayley \
determinant.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(Cayleyu::usage = "\<Cayleyu are the sub-Cayley-determinants as \
described in Tarasov's paper.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(CayleyD::usage = "\<CayleyD are the sub-Cayley-determinants as \
described in Tarasov's paper.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(Prefactor1::usage = "\<Prefactor1[expr] may be used to prohibit \
TarcerExpand from Taylor-expanding expr.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(SEpsilon::usage = "\<Sepsilon[d] is an abbreviation for Exp[(d-4)/2 \
EulerGamma].\>";\)\)], "Input"],

Cell["\<\
TFI::\"usage\" =
\"TFI[d, pp, {{n1,m1},{n2,m2},{n3,m3},{n4,m4},{n5,m5}}] is
the 2-loop d-dimensional integral
1/( (q1^2 - m1^2)^n1  (q2^2 - m2^2)^n2 ((q1-p)^2 - m3^2)^n3 *
    ((q2-p)^2 - m4^2)^n4  ((q1-q2)^2 - m5^2)^n5 ) .

 TFI[d, pp, {x,y,z,v,w}, {{n1,m1},{n2,m2},{n3,m3},{n4,m4},{n5,m5}}]
has as additional factors in the numerator (q1^2)^x*(q2^2)^y*(q1.p)^z*
(q2.p)^v*(q1.q2)^w .

 TFI[d, pp, dp, {a,b}, {{n1,m1},{n2,m2},{n3,m3},{n4,m4},{n5,m5}}]
has as additional factors in the numerator  (OPEDelta.q1)^a * \
(OPEDelta.q2)^b;
dp is (OPEDelta.p).\";\
\>", "Input"],

Cell[BoxData[
    \(\(TFIRecurse::usage = "\<TFIRecurse[expr] applies the recursion \
algorithm implemented in TARCER.nb (following Tarasov) to TFI's (and TVI's, \
TJI's, TBI's, TAI's in expr.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(TFISimplify::usage = "\<TFISimplify[expr] applies the recursion \
algorithm implemented in TARCER.nb (following Tarasov) to TFI's (and TVI's, \
TJI's, TBI's, TAI's in expr, except k1.k2.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(TVI::usage = "\<TVI[d,pp,{ {n1,m1},{n2,m2},{n3,m3},{n4,m4}}] is the \
massive 2-loop integral with four propagators in d dimensions. \>";\)\)], \
"Input"],

Cell[BoxData[
    \(\(TJI::usage = "\<TJI[d, pp, { {n1,m1},{n2,m2},{n3,m3} }] is the \
massive 2-loop integral with three propagators in d dimensions. \>";\)\)], \
"Input"],

Cell[BoxData[
    \(\(TKI::usage = "\<TKI[d, 0, { {n1,m1},{n2,m2},{n3,m3} }] is the bubble \
massive 2-loop selfenergy type integral with three propagators in d \
dimensions. \>";\)\)], "Input"],

Cell[BoxData[
    \(\(TBI::usage = "\<TBI[d, pp, { {n1,m1},{n2,m2} }] is the massive 1-loop \
selfenergy type integral with two propagators in d dimensions.\>";\)\)], \
"Input"],

Cell[BoxData[
    \(\(TAI::usage = "\<TAI[d, pp, { {n1,m1} }] is the massive 1-loop \
selfenergy type integral with one propagator in d dimensions.\>";\)\)], \
"Input"],

Cell[BoxData[
    \(\(TFR::usage = "\<TFR is similar in syntax to TFI but applies once the \
recurrence relations derived for TFI.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(TVR::usage = "\<TVR is similar in syntax to TVI but applies once the \
recurrence relations derived for TVI.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(TJR::usage = "\<TJR is similar in syntax to TJI but applies once the \
recurrence relations derived for TJI.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(TBR::usage = "\<TBR is similar in syntax to TBI but applies once the \
recurrence relations derived for TBI.\>";\)\)], "Input"],

Cell[BoxData[
    \(\(TAR::usage = "\<TAR is similar in syntax to TAI but applies once the \
recurrence relations derived for TAI.\>";\)\)], "Input"],

Cell[BoxData[
    \(\($RankLimit::usage = "\<$RankLimit is the list of integers specifying \
the highest possible sums of exponents of scalar products; i.e., {a+b, r+s} \
means that at most (Delta.k1)^a * (Delta.k2)^2 * (p.k1)^r * (p.k2)^s in the \
numerator will be calculated (a,b,r,s have to be non-negative integares). \
$RankLimit has to be set in the TARCER.nb notebook. In the tarcer.mx file \
this is not possible anymore.\>";\)\)], "Input"],

Cell[BoxData[
    \(\($TarcerRecursed::usage = "\<If $Comment is set to True all integrals\n\
\t\twhich are reduced are collected in the global variable \
$TarcerRecured.\>";\)\)], "Input"],

Cell[BoxData[
    \(\($BasisIntegrals::usage = "\<$BasisIntegrals is a list of some basis \
integrals. It is the default setting of TarcerReduce of \
TarcerExpand.\>";\)\)], "Input"],

Cell[BoxData[
    \(\($Comment::usage = "\<$Comment can be set to True or False. If set to \
False no comments are generated.\>";\)\)], "Input"],

Cell[BoxData[
    \(\($CommentNotebook::usage = "\<$Comment can be set to True or False. \
Setting it to True will generate a separate notebook (if and only if $Comment \
is True) where the used recursion relations are displayed.\>";\)\)], "Input"],

Cell[BoxData[
    \(\($RecursionStop::usage = "\<$RecursionStop sets an upper limit on the \
total number of recursion levels. Its purpose is to inhibit erroneous \
infinite recursions.\>";\)\)], "Input"],

Cell[BoxData[
    \(\($TTable::usage = "\<$TTable is a list of precomputed reductions. \
$TTable is the default setting of the option Table of TarcerRecurse. \
\>";\)\)], "Input"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(Expand3 = Identity;\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Prologue (setting of $RankLimit)", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.3.1"],

Cell[TextData[{
  "This sets the limit up to which the ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  "-operators are constructed automatically, i.e., $RankLimit = {a+b, r+s} , \
concerning: ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\((\[CapitalDelta]\[CenterDot]
              k\_1)\)\^a\)\(\ \)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\((\[CapitalDelta]\[CenterDot]k\_2)\)\^b\)]],
  " ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            FormBox[\(p\[CenterDot]k\_1\),
              "TraditionalForm"], ")"}], "r"], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            FormBox[\(p\[CenterDot]k\_2\),
              "TraditionalForm"], ")"}], "s"], TraditionalForm]]]
}], "Text"],

Cell[BoxData[
    \(\($RankLimit = {0, 6};\)\)], "Input"],

Cell[BoxData[{
    \(\($RankLimit = {1, 6};\)\), "\[IndentingNewLine]", 
    \(\($RankLimit = {2, 5};\)\)}], "Input"],

Cell["Check recursion relations by changing False to True here:", "Text"],

Cell[BoxData[
    \(\($CheckRecursion = False;\)\)], "Input"],

Cell["\<\
Change False to True for getting the input palettes for entering \
new recursion relations.\
\>", "Text"],

Cell[BoxData[
    \(\($PutPalettes = False;\)\)], "Input"],

Cell[TextData[{
  "Notice:  Instead of using shift operators",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{"  ", 
              StyleBox[\(1\^+\),
                FontWeight->"Bold"]}],
            "TraditionalForm"], ",", 
          StyleBox[\(2\^+\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " etc. the \[Nu]-indices are colored blue; instead of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{"  ", 
              StyleBox[\(1\^-\),
                FontWeight->"Bold"]}],
            "TraditionalForm"], ",", 
          StyleBox[\(2\^-\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " etc. the \[Nu]-indices are colored red."
}], "Text"],

Cell[CellGroupData[{

Cell["Typesetting rules", "Subsection",
  CellTags->"T1.3.1.1"],

Cell[BoxData[
    \(\(atime = AbsoluteTime[];\)\)], "Input"],

Cell[BoxData[
    \(SEpsilon /: MakeBoxes[SEpsilon[d_], fmt_] := 
      InterpretationBox @@ {StyleBox[
            SubscriptBox["\<S\>", First[Variables[d]]], 
            FontWeight \[Rule] "\<Bold\>"], SEpsilon[d], 
          Editable \[Rule] False}\)], "Input"],

Cell[BoxData[
    \(MakeBoxes[SEpsilon[d_]\^n_, fmt_] := 
      InterpretationBox @@ {StyleBox[
            SubsuperscriptBox["\<S\>", First[Variables[d]], n], 
            FontWeight \[Rule] "\<Bold\>"], SEpsilon[d], 
          Editable \[Rule] False}\)], "Input"],

Cell[BoxData[
    \(Prefactor1 /: MakeBoxes[Prefactor1[d_], fmt_] := 
      InterpretationBox @@ {MakeBoxes[d, fmt], Prefactor1[d], 
          Editable -> False}\)], "Input"],

Cell["\<\
Don't mess with the InterpretationBox's !! (important for the \
palette and OperatorApply).\
\>", "Text"],

Cell[BoxData[
    \(MakeBoxes[Schiebe[i_, pm_String]\ , fmt_] := 
      InterpretationBox[
        StyleBox[SuperscriptBox[i, pm], FontWeight -> "\<Bold\>"], 
        Schiebe[i, pm], Editable -> True]\)], "Input"],

Cell[BoxData[
    \(\(CayleyD /: MakeBoxes[\(CayleyD[i_Integer]\)[args_], fmt_] := 
        FractionBox[
          SubscriptBox["\<\[CapitalDelta]\>", \ 
            i], "\<\[CapitalDelta]\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(CayleyD /: MakeBoxes[\(CayleyD[i_Integer, j_Integer]\)[args_], fmt_] := 
        FractionBox[
          SubscriptBox["\<\[CapitalDelta]\>", 
            10\ i + j], "\<\[CapitalDelta]\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(CayleyD /: 
        MakeBoxes[\(CayleyD[i_Integer, j_Integer, k_Integer]\)[args_], fmt_] := 
        FractionBox[
          SubscriptBox["\<\[CapitalDelta]\>", 
            100\ \ i + 10  j + k], "\<\[CapitalDelta]\>"];\)\)], "Input"],

Cell[BoxData[
    \(\(Cayley /: MakeBoxes[\(Cayley[i_Integer]\)[args_], fmt_] := 
        SubscriptBox["\<\[CapitalDelta]\>", \ i];\)\)], "Input"],

Cell[BoxData[
    \(\(Cayley /: MakeBoxes[\(Cayley[i_Integer, j_Integer]\)[args_], fmt_] := 
        SubscriptBox["\<\[CapitalDelta]\>", 10\ i + j];\)\)], "Input"],

Cell[BoxData[
    \(\(Cayley /: 
        MakeBoxes[\(Cayley[i_Integer, j_Integer, k_Integer]\)[args_], fmt_] := 
        SubscriptBox["\<\[CapitalDelta]\>", 
          100\ \ i + 10  j + k];\)\)], "Input"],

Cell[BoxData[
    \(\(Cayleyu /: 
        MakeBoxes[\(Cayleyu[i_Integer, j_Integer, k_Integer]\)[args_], fmt_] := 
        SubscriptBox["\<u\>", 100\ \ i + 10  j + k];\)\)], "Input"],

Cell["\<\
MakeBoxes[PP, fm_] := InterpretationBox[SuperscriptBox[p, 2], PP]; 
MakeBoxes[m1^(p_), _] := InterpretationBox[SubsuperscriptBox[m, 1, p], m1^p]; \

MakeBoxes[m2^(p_), _] := InterpretationBox[SubsuperscriptBox[m, 2, p], m2^p]; \

MakeBoxes[m3^(p_), _] := InterpretationBox[SubsuperscriptBox[m, 3, p], m3^p]; \

MakeBoxes[m4^(p_), _] := InterpretationBox[SubsuperscriptBox[m, 4, p], m4^p]; \

MakeBoxes[m5^(p_), _] := InterpretationBox[SubsuperscriptBox[m, 5, p], m5^p]; \

m6 = Sqrt[PP]; \
\>", "Input"],

Cell[BoxData[
    \(\(MakeBoxes[m1, _] := 
        InterpretationBox[SubscriptBox[m, 1], m1];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[m2, _] := 
        InterpretationBox[SubscriptBox[m, 2], m2];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[m3, _] := 
        InterpretationBox[SubscriptBox[m, 3], m3];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[m4, _] := 
        InterpretationBox[SubscriptBox[m, 4], m4];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[m5, _] := 
        InterpretationBox[SubscriptBox[m, 5], m5];\)\)], "Input"],

Cell[BoxData[
    \(\(mbt[z_] := ToBoxes[z, TraditionalForm];\)\)], "Input"],

Cell[BoxData[
    \(\(redblue[z_ /; Head[z] =!= Plus] := mbt[z];\)\)], "Input"],

Cell[BoxData[
    \(\(redblue[z_ - 1] := 
        StyleBox[mbt[z], FontColor \[Rule] RGBColor[1, 0, 0]];\)\)], "Input"],

Cell[BoxData[
    \(\(redblue[z_Subscript - 2] := 
        StyleBox[
          SubscriptBox[
            OverscriptBox[
              z\[LeftDoubleBracket]1\[RightDoubleBracket], "\<_\>"], 
            z\[LeftDoubleBracket]2\[RightDoubleBracket]], 
          FontColor \[Rule] RGBColor[1, 0, 0]];\)\)], "Input"],

Cell[BoxData[
    \(\(redblue[z_ - 2] := 
        StyleBox[OverscriptBox[mbt[z], "\<_\>"], 
          FontColor \[Rule] RGBColor[1, 0, 0]];\)\)], "Input"],

Cell[BoxData[
    \(\(redblue[z_ - 3] := 
        StyleBox[UnderscriptBox[OverscriptBox[mbt[z], "\<_\>"], "\<_\>"], 
          FontColor \[Rule] RGBColor[1, 0, 0]];\)\)], "Input"],

Cell[BoxData[
    \(\(redblue[z_ + 1] := 
        StyleBox[mbt[z], FontColor \[Rule] RGBColor[0, 0, 1]];\)\)], "Input"],

Cell[BoxData[
    \(\(redblue[z_ + 2] := 
        StyleBox[OverscriptBox[mbt[z], "\<_\>"], 
          FontColor \[Rule] RGBColor[0, 0, 1]];\)\)], "Input"],

Cell[BoxData[
    \(\(redblue[z_Subscript + 2] := 
        StyleBox[
          SubscriptBox[
            OverscriptBox[
              z\[LeftDoubleBracket]1\[RightDoubleBracket], "\<_\>"], 
            z\[LeftDoubleBracket]2\[RightDoubleBracket]], 
          FontColor \[Rule] RGBColor[0, 0, 1]];\)\)], "Input"],

Cell[BoxData[
    \(\(TFI /: 
        MakeBoxes[TFI[d_, pp_, {ur__}, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<F\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>", "\< \>", 
                      ur}]], \n\t\tTFI[d, pp, {ur}, {den}], 
                Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TFI /: 
        MakeBoxes[TFI[d_, pp_, dp_, any__, {den__}], 
          fmt_] := \n\t\(\((InterpretationBox @@ {SubsuperscriptBox[
                    StyleBox["\<F\>", SingleLetterItalics -> False, 
                      FontWeight -> "\<Bold\>"], 
                    RowBox @@ {\((redblue /@ {den})\)}, 
                    RowBox[{"\<(\>", 
                        ToBoxes[d, TraditionalForm], "\<)\>", "\< \>", 
                        Apply[Sequence, Flatten[{any}]]}]], \n\t\tTFI[d, pp, 
                    dp, any, {den}], Editable -> True})\) /; 
            MemberQ[{StandardForm, TraditionalForm}, fmt]\) /; 
          Head[dp] =!= List;\)\)], "Input"],

Cell[BoxData[
    \(\(TFI /: 
        MakeBoxes[TFI[dpp__, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<F\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[First[{dpp}], 
                        TraditionalForm], "\<)\>"}]], \n\t\tTFI[dpp, {den}], 
                Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt] && 
            Head[Last[{dpp}]] =!= List;\)\)], "Input"],

Cell[BoxData[
    \(\(TVI /: 
        MakeBoxes[TVI[dpp__, {den__}], 
          fmt_] := \n\((\t\((InterpretationBox @@ {SubsuperscriptBox[
                      StyleBox["\<V\>", SingleLetterItalics -> False, 
                        FontWeight -> "\<Bold\>"], 
                      RowBox @@ {\((redblue /@ {den})\)}, 
                      RowBox[{"\<(\>", 
                          ToBoxes[{dpp}[\([1]\)], 
                            TraditionalForm], "\<)\>"}]], \n\t\(Hold[TVI]\)[
                      dpp, {den}], Editable -> True})\) /. 
              Hold[TVI] -> TVI)\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt] && 
            Head[Last[{dpp}]] =!= List;\)\)], "Input"],

Cell[BoxData[
    \({TVI[d, {\[Alpha], \[Beta], \[Gamma], \[Delta]}], 
      TVI[d, {\[Alpha] + 1, \[Beta], \[Gamma], \[Delta]}], 
      TVI[d, {\[Alpha] - 1, \[Beta], \[Gamma], \[Delta]}]}\)], "Input"],

Cell[BoxData[
    \(TJI /: 
      MakeBoxes[TJI[d_, 0, {den__}], 
        fmt_] := \t\((\n\((\((InterpretationBox @@ {SubsuperscriptBox[
                        StyleBox["\<K\>", SingleLetterItalics -> False, 
                          FontWeight -> "\<Bold\>"], 
                        RowBox @@ {\((redblue /@ {den})\)}, 
                        RowBox[{"\<(\>", 
                            ToBoxes[d, 
                              TraditionalForm], "\<)\>"}]], \n\t\t\(Hold[
                          TJI]\)[d, 0, {den}], Editable -> True})\) /. 
                Hold[TJI] -> TJI)\) /; 
            MemberQ[{StandardForm, TraditionalForm}, fmt]\n\t)\) /; 
        MemberQ[{StandardForm, TraditionalForm}, fmt]\)], "Input"],

Cell[BoxData[
    \(TJI /: 
      MakeBoxes[TJI[dpp__, {den__}], 
        fmt_] := \t\((\((InterpretationBox @@ {SubsuperscriptBox[
                    StyleBox["\<J\>", SingleLetterItalics -> False, 
                      FontWeight -> "\<Bold\>"], 
                    RowBox @@ {\((redblue /@ {den})\)}, 
                    RowBox[{"\<(\>", 
                        ToBoxes[{dpp}[\([1]\)], 
                          TraditionalForm], "\<)\>"}]], \n\t\t\(Hold[TJI]\)[
                    dpp, {den}], Editable -> True})\) /. Hold[TJI] -> TJI)\) /; 
        MemberQ[{StandardForm, TraditionalForm}, fmt]\)], "Input"],

Cell[BoxData[
    \(\(TKI /: 
        MakeBoxes[TKI[d_, pp___, {den__}], 
          fmt_] := \n\t\((SubsuperscriptBox[
              StyleBox["\<K\>", SingleLetterItalics -> False, 
                FontWeight -> "\<Bold\>"], 
              RowBox @@ {\((redblue /@ {den})\)}, 
              RowBox[{"\<(\>", ToBoxes[d, TraditionalForm], "\<)\>"}]])\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(TKI /: 
      MakeBoxes[TKI[dpp__, {den__}], 
        fmt_] := \t\((\((InterpretationBox @@ {SubsuperscriptBox[
                    StyleBox["\<K\>", SingleLetterItalics -> False, 
                      FontWeight -> "\<Bold\>"], 
                    RowBox @@ {\((redblue /@ {den})\)}, 
                    RowBox[{"\<(\>", 
                        ToBoxes[{dpp}[\([1]\)], 
                          TraditionalForm], "\<)\>"}]], \n\t\t\(Hold[TKI]\)[
                    dpp, {den}], Editable -> True})\) /. Hold[TKI] -> TKI)\) /; 
        MemberQ[{StandardForm, TraditionalForm}, fmt]\)], "Input"],

Cell[BoxData[
    \({TKI[d, {\[Alpha], \[Beta], \[Gamma]}], 
      TKI[d, {\[Alpha] + 1, \[Beta], \[Gamma]}], 
      TKI[d, {\[Alpha] - 1, \[Beta], \[Gamma]}]}\)], "Input"],

Cell[BoxData[
    \(\(TBI /: 
        MakeBoxes[TBI[d_, pp___, {den__}], 
          fmt_] := \n\t\((SubsuperscriptBox[
              StyleBox["\<B\>", SingleLetterItalics -> False, 
                FontWeight -> "\<Bold\>"], 
              RowBox @@ {\((redblue /@ {den})\)}, 
              RowBox[{"\<(\>", ToBoxes[d, TraditionalForm], "\<)\>"}]])\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TBI /: 
        MakeBoxes[TBI[d_, pp___, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<B\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>"}]], \n\t\tTBI[d, 
                  pp, {den}], Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \({TBI[d, {\[Alpha], \[Beta]}], TBI[d, {\[Alpha] + 1, \[Beta]}], 
      TBI[d, {\[Alpha] - 1, \[Beta]}]}\)], "Input"],

Cell[BoxData[
    \(\(TAI /: 
        MakeBoxes[TAI[d_, pp___, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<A\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>"}]], \n\t\tTAI[
                  d, {den}], Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \({TAI[d, {\[Alpha]}], TAI[d, {\[Alpha] + 1}], 
      TAI[d, {\[Alpha] - 1}]}\)], "Input"],

Cell["\<\
T*IC are just like T*I , but used only for commentary in the 
recursion (TComment).\
\>", "Text"],

Cell[BoxData[
    \(\(TFIC /: 
        MakeBoxes[TFIC[d_, pp_, {0, 0, i_, 0, 0}, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<F\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>", "\< \>", 
                      i, "\<0\>"}]], \n\t\tTFIC[d, 
                  pp, {0, 0, i, 0, 0}, {den}], Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TFIC /: 
        MakeBoxes[TFIC[d_, pp_, {0, 0, 0, i_, 0}, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<F\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>", "\< \>", "\<0\>", 
                      i}]], \n\t\tTFIC[d, pp, {0, 0, 0, i, 0}, {den}], 
                Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TFIC /: 
        MakeBoxes[TFIC[dpp__, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<F\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[First[{dpp}], 
                        TraditionalForm], "\<)\>"}]], \n\t\tTFIC[dpp, {den}], 
                Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt] && 
            Head[Last[{dpp}]] =!= List;\)\)], "Input"],

Cell[BoxData[
    \(\(TVIC /: 
        MakeBoxes[TVIC[dpp__, {den__}], 
          fmt_] := \n\((\t\((InterpretationBox @@ {SubsuperscriptBox[
                      StyleBox["\<V\>", SingleLetterItalics -> False, 
                        FontWeight -> "\<Bold\>"], 
                      RowBox @@ {\((redblue /@ {den})\)}, 
                      RowBox[{"\<(\>", 
                          ToBoxes[{dpp}[\([1]\)], 
                            TraditionalForm], "\<)\>"}]], \n\t\(Hold[TVIC]\)[
                      dpp, {den}], Editable -> True})\) /. 
              Hold[TVIC] -> TVIC)\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt] && 
            Head[Last[{dpp}]] =!= List;\)\)], "Input"],

Cell[BoxData[
    \(TJIC /: 
      MakeBoxes[TJIC[d_, 0, {den__}], 
        fmt_] := \t\((\n\((\((InterpretationBox @@ {SubsuperscriptBox[
                        StyleBox["\<K\>", SingleLetterItalics -> False, 
                          FontWeight -> "\<Bold\>"], 
                        RowBox @@ {\((redblue /@ {den})\)}, 
                        RowBox[{"\<(\>", 
                            ToBoxes[d, 
                              TraditionalForm], "\<)\>"}]], \n\t\t\(Hold[
                          TJIC]\)[d, 0, {den}], Editable -> True})\) /. 
                Hold[TJIC] -> TJIC)\) /; 
            MemberQ[{StandardForm, TraditionalForm}, fmt]\n\t)\) /; 
        MemberQ[{StandardForm, TraditionalForm}, fmt]\)], "Input"],

Cell[BoxData[
    \(TJIC /: 
      MakeBoxes[TJIC[dpp__, {den__}], 
        fmt_] := \t\((\((InterpretationBox @@ {SubsuperscriptBox[
                    StyleBox["\<J\>", SingleLetterItalics -> False, 
                      FontWeight -> "\<Bold\>"], 
                    RowBox @@ {\((redblue /@ {den})\)}, 
                    RowBox[{"\<(\>", 
                        ToBoxes[{dpp}[\([1]\)], 
                          TraditionalForm], "\<)\>"}]], \n\t\t\(Hold[TJIC]\)[
                    dpp, {den}], Editable -> True})\) /. 
            Hold[TJIC] -> TJIC)\) /; 
        MemberQ[{StandardForm, TraditionalForm}, fmt]\)], "Input"],

Cell[BoxData[
    \(\(TBIC /: 
        MakeBoxes[TBIC[d_, pp___, {den__}], 
          fmt_] := \n\t\((SubsuperscriptBox[
              StyleBox["\<B\>", SingleLetterItalics -> False, 
                FontWeight -> "\<Bold\>"], 
              RowBox @@ {\((redblue /@ {den})\)}, 
              RowBox[{"\<(\>", ToBoxes[d, TraditionalForm], "\<)\>"}]])\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TBIC /: 
        MakeBoxes[TBIC[d_, pp___, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<B\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>"}]], \n\t\tTBIC[d, 
                  pp, {den}], Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TAIC /: 
        MakeBoxes[TAIC[d_, pp___, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<A\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>"}]], \n\t\tTAIC[
                  d, {den}], Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TFR /: 
        MakeBoxes[TFR[d_, pp_, {0, 0, i_, 0, 0}, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<F\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>", "\< \>", 
                      i, "\<0\>"}]], \n\t\tTFR[d, 
                  pp, {0, 0, i, 0, 0}, {den}], Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TFR /: 
        MakeBoxes[TFR[d_, pp_, {0, 0, 0, i_, 0}, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<F\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>", "\< \>", "\<0\>", 
                      i}]], \n\t\tTFR[d, pp, {0, 0, 0, i, 0}, {den}], 
                Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TFR /: 
        MakeBoxes[TFR[dpp__, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<F\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[First[{dpp}], 
                        TraditionalForm], "\<)\>"}]], \n\t\tTFR[dpp, {den}], 
                Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt] && 
            Head[Last[{dpp}]] =!= List;\)\)], "Input"],

Cell[BoxData[
    \(\(TVR /: 
        MakeBoxes[TVR[dpp__, {den__}], 
          fmt_] := \n\((\t\((InterpretationBox @@ {SubsuperscriptBox[
                      StyleBox["\<V\>", SingleLetterItalics -> False, 
                        FontWeight -> "\<Bold\>"], 
                      RowBox @@ {\((redblue /@ {den})\)}, 
                      RowBox[{"\<(\>", 
                          ToBoxes[{dpp}[\([1]\)], 
                            TraditionalForm], "\<)\>"}]], \n\t\(Hold[TVR]\)[
                      dpp, {den}], Editable -> True})\) /. 
              Hold[TVR] -> TVR)\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt] && 
            Head[Last[{dpp}]] =!= List;\)\)], "Input"],

Cell[BoxData[
    \(TJR /: 
      MakeBoxes[TJR[d_, 0, {den__}], 
        fmt_] := \t\((\n\((\((InterpretationBox @@ {SubsuperscriptBox[
                        StyleBox["\<K\>", SingleLetterItalics -> False, 
                          FontWeight -> "\<Bold\>"], 
                        RowBox @@ {\((redblue /@ {den})\)}, 
                        RowBox[{"\<(\>", 
                            ToBoxes[d, 
                              TraditionalForm], "\<)\>"}]], \n\t\t\(Hold[
                          TJR]\)[d, 0, {den}], Editable -> True})\) /. 
                Hold[TJR] -> TJR)\) /; 
            MemberQ[{StandardForm, TraditionalForm}, fmt]\n\t)\) /; 
        MemberQ[{StandardForm, TraditionalForm}, fmt]\)], "Input"],

Cell[BoxData[
    \(TJR /: 
      MakeBoxes[TJR[dpp__, {den__}], 
        fmt_] := \t\((\((InterpretationBox @@ {SubsuperscriptBox[
                    StyleBox["\<J\>", SingleLetterItalics -> False, 
                      FontWeight -> "\<Bold\>"], 
                    RowBox @@ {\((redblue /@ {den})\)}, 
                    RowBox[{"\<(\>", 
                        ToBoxes[{dpp}[\([1]\)], 
                          TraditionalForm], "\<)\>"}]], \n\t\t\(Hold[TJR]\)[
                    dpp, {den}], Editable -> True})\) /. Hold[TJR] -> TJR)\) /; 
        MemberQ[{StandardForm, TraditionalForm}, fmt]\)], "Input"],

Cell[BoxData[
    \(\(TBR /: 
        MakeBoxes[TBR[d_, pp___, {den__}], 
          fmt_] := \n\t\((SubsuperscriptBox[
              StyleBox["\<B\>", SingleLetterItalics -> False, 
                FontWeight -> "\<Bold\>"], 
              RowBox @@ {\((redblue /@ {den})\)}, 
              RowBox[{"\<(\>", ToBoxes[d, TraditionalForm], "\<)\>"}]])\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TBR /: 
        MakeBoxes[TBR[d_, pp___, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<B\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>"}]], \n\t\tTBR[d, 
                  pp, {den}], Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(TAR /: 
        MakeBoxes[TAR[d_, pp___, {den__}], 
          fmt_] := \n\t\((InterpretationBox @@ {SubsuperscriptBox[
                  StyleBox["\<A\>", SingleLetterItalics -> False, 
                    FontWeight -> "\<Bold\>"], 
                  RowBox @@ {\((redblue /@ {den})\)}, 
                  RowBox[{"\<(\>", 
                      ToBoxes[d, TraditionalForm], "\<)\>"}]], \n\t\tTAR[
                  d, {den}], Editable -> True})\) /; 
          MemberQ[{StandardForm, TraditionalForm}, fmt];\)\)], "Input"],

Cell[BoxData[
    \(\(n1 /: MakeBoxes[n1, TraditionalForm] := 
        SubscriptBox["\<\[Nu]\>", 1];\)\)], "Input"],

Cell[BoxData[
    \(\(n2 /: MakeBoxes[n2, TraditionalForm] := 
        SubscriptBox["\<\[Nu]\>", 2];\)\)], "Input"],

Cell[BoxData[
    \(\(n3 /: MakeBoxes[n3, TraditionalForm] := 
        SubscriptBox["\<\[Nu]\>", 3];\)\)], "Input"],

Cell[BoxData[
    \(\(n4 /: MakeBoxes[n4, TraditionalForm] := 
        SubscriptBox["\<\[Nu]\>", 4];\)\)], "Input"],

Cell[BoxData[
    \(\(n5 /: MakeBoxes[n5, TraditionalForm] := 
        SubscriptBox["\<\[Nu]\>", 5];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[ParD[i_]\^j_, TraditionalForm] := 
        SubsuperscriptBox["\<\[PartialD]\>", i, j];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[ParD[i_], TraditionalForm] ^= 
        SubscriptBox["\<\[PartialD]\>", i];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[DPlus, TraditionalForm] := 
        StyleBox[SuperscriptBox["\<d\>", "\<+\>"], 
          FontWeight \[Rule] "\<Bold\>", 
          SingleLetterItalics \[Rule] False];\)\)], "Input"],

Cell[BoxData[
    \(MakeBoxes[TpD[_, b_], TraditionalForm] := 
      MakeBoxes[b, TraditionalForm]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Palettes", "Subsection",
  CellTags->"T1.3.2.1"],

Cell[BoxData[
    \(\(If[$PutPalettes === 
          True, \n\t\(\(tobut[a_]\  := \ 
            ButtonBox[ToBoxes[a, StandardForm], \ 
              ButtonStyle -> "\<Paste\>"];\)\n
        \ \(If[Head[pal1] === NotebookObject, \n\tNotebookClose[pal1]];\)\n
        \t\(pal1 = 
            NotebookPut[
              Notebook[{Cell[
                    BoxData[
                      GridBox[\n\t\t\t\t\t\t\tJoin[
                          Transpose@{\n\t\t\t\t\t\t\t\t\tTable[
                                tobut@\(m\_j\^2\), {j, 
                                  5}], \n\t\t\t\t\t\t\t\t\tTable[
                                tobut@\[Nu]\_j, {j, 
                                  5}], \n\t\t\t\t\t\t\t\t\tTable[
                                tobut@Schiebe[i, "\<+\>"], {i, 
                                  5}], \n\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
Table[tobut@Schiebe[i, "\<-\>"], {i, 5}]}, \n\t\t\t\t\t\t\t\(\({\t
                            tobut /@ {PP, \[CapitalDelta]\_\[Placeholder], 
                                u\_\[Placeholder], \[ScriptCapitalC]\ }}\)\(\n\
\)
                          \)\t\t\t\t\t\t\t], 
                        RowSpacings -> 0, \n\ \ \ \ \ \ ColumnSpacings -> 
                          0]], NotebookDefault]}, \n\tEditable -> True, \n
                WindowToolbars -> {}, \nWindowSize -> {Fit, \ Fit}, \n
                WindowMargins -> {{0, \ Automatic}, \ {0, Automatic}}, \n
                WindowFrame -> "\<Palette\>", \nWindowElements -> {}, \n
                WindowFrameElements -> "\<CloseBox\>", \n
                WindowClickSelect -> False, \n
                ScrollingOptions -> {"\<PagewiseScrolling\>" -> True}, \n
                ShowCellBracket -> False, \n
                CellMargins -> {{0, \ 0}, \ {0, \ 0}}, \nActive -> True, \n
                CellOpen -> True, \nShowCellLabel -> False, \n
                ShowCellTags -> False, \n
                ImageMargins -> {{0, \ 0}, \ {0, \ 0}}, \nMagnification -> 2, 
                Visible -> True]];\)\n
        \(SetOptions[pal1, 
            WindowMargins -> {{0, Automatic}, {Automatic, 0}}];\)\n
        \(SetOptions[pal1, Visible -> True, WindowSize -> {Fit, Fit}];\)\n
        \ \(If[Head[pal2] === NotebookObject, \n\tNotebookClose[pal2]];\)\n
        \t\(pal2 = 
            NotebookPut[
              Notebook[{Cell[
                    BoxData[
                      GridBox[\n\t\t\t\t\t\t\tJJJ = 
                          Join[{tobut /@ {TFI[
                                    d + 2, {\[Nu]\_1, \[Nu]\_2, \[Nu]\_3, \
\[Nu]\_4, \[Nu]\_5}], TVI[d + 2, {\[Nu]\_1, \[Nu]\_2, \[Nu]\_3, \[Nu]\_4}], 
                                  TJI[d + 2, {\[Nu]\_1, \[Nu]\_2, \[Nu]\_3}], 
                                  TKI[d, {\[Nu]\_1, \[Nu]\_2, \[Nu]\_3}], 
                                  TBI[d, {\[Nu]\_1, \[Nu]\_2}], 
                                  TAI[d, {\[Nu]\_1}]}}, \n\t\t\t\t\t\t\t\t\
\(\({tobut /@ {TFI[d, {\[Nu]\_1, \[Nu]\_2, \[Nu]\_3, \[Nu]\_4, \[Nu]\_5}], 
                                  TVI[d, {\[Nu]\_1, \[Nu]\_2, \[Nu]\_3, \[Nu]\
\_4}], TJI[d, {\[Nu]\_1, \[Nu]\_2, \[Nu]\_3}], 
                                  TKI[d - 2, {\[Nu]\_1, \[Nu]\_2, \[Nu]\_3}], 
                                  TBI[d - 2, {\[Nu]\_1, \[Nu]\_2}], 
                                  TAI[d - 2, {\[Nu]\_1}]}}\)\(\n\)
                            \)\t\t\t\t\t\t\t], 
                        RowSpacings -> 0, \n\ \ \ \ \ \ ColumnSpacings -> 
                          0]], NotebookDefault]}, \n\tEditable -> True, \n
                WindowToolbars -> {}, \nWindowSize -> {FitAll, \ FitAll}, \n
                WindowMargins -> {{0, Automatic}, \ {0, Automatic}}, \n
                WindowFrame -> "\<Palette\>", \nWindowElements -> {}, \n
                WindowFrameElements -> "\<CloseBox\>", \n
                WindowClickSelect -> False, \n
                ScrollingOptions -> {"\<PagewiseScrolling\>" -> True}, \n
                ShowCellBracket -> False, \n
                CellMargins -> {{0, 0}, \ {0, 0}}, \nActive -> True, \n
                CellOpen -> True, \nShowCellLabel -> False, \n
                ShowCellTags -> False, \n
                ImageMargins -> {{0, 0}, \ {0, \ 0}}, \nMagnification -> 2, 
                Visible -> True]];\)\n
        \(SetOptions[pal2, 
            WindowMargins -> {{Automatic, 15}, {Automatic, 4}}];\)\n
        \(SetOptions[pal2, Visible -> True, WindowSize -> {Fit, Fit}];\)\n
        \tSetOptions[pal2, WindowSize -> {Fit, Fit}]\n
        \)\t];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["OperatorApply", "Subsection",
  CellTags->"T1.3.3.1"],

Cell[BoxData[
    \(\(OperatorApplyF[x_ == y_] := 
        Block[{sch}, \n\t\tsch\  = \ {Schiebe[i_, "\<+\>"]\^ni_. \ TFI[
                    d_, {n15__}] :> \n\t\t\t\t\tTFI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] + ni, 
                    i]], \n\t\t\t\t\(\(Schiebe[i_, "\<-\>"]\^ni_. \ TFI[
                    d_, {n15__}] :> \n\t\t\t\t\tTFI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] - ni, i]]\)\(\n\)
              \)\t\t\t}; 
          Map[Collect[Expand[#] //. sch, TFI[__], Factor] &, \n\t\t\tx == 
              y]];\)\)], "Input"],

Cell[BoxData[
    \(\(OperatorApplyV[x_ == y_] := 
        Block[{sch}, \n\t\tsch\  = \ {Schiebe[i_, "\<+\>"]\^ni_. \ TVI[
                    d_, {n15__}] :> \n\t\t\t\t\tTVI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] + ni, 
                    i]], \n\t\t\t\t\(\(Schiebe[i_, "\<-\>"]\^ni_. \ TVI[
                    d_, {n15__}] :> \n\t\t\t\t\tTVI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] - ni, i]]\)\(\n\)
              \)\t\t\t}; 
          Map[Collect[Expand[#] //. sch, TVI[__], Factor] &, \n\t\t\tx == 
              y]];\)\)], "Input"],

Cell[BoxData[
    \(\(OperatorApplyJ[x_ == y_] := 
        Block[{sch}, \n\t\tsch\  = \ {Schiebe[i_, "\<+\>"]\^ni_. \ TJI[
                    d_, {n15__}] :> \n\t\t\t\t\tTJI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] + ni, 
                    i]], \n\t\t\t\t\(\(Schiebe[i_, "\<-\>"]\^ni_. \ TJI[
                    d_, {n15__}] :> \n\t\t\t\t\tTJI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] - ni, i]]\)\(\n\)
              \)\t\t\t}; 
          Map[Collect[Expand[#] //. sch, TJI[__], Factor] &, \n\t\t\tx == 
              y]];\)\)], "Input"],

Cell[BoxData[
    \(\(OperatorApplyK[x_ == y_] := 
        Block[{sch}, \n\t\tsch\  = \ {Schiebe[i_, "\<+\>"]\^ni_. \ TKI[
                    d_, {n15__}] :> \n\t\t\t\t\tTKI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] + ni, 
                    i]], \n\t\t\t\t\(\(Schiebe[i_, "\<-\>"]\^ni_. \ TKI[
                    d_, {n15__}] :> \n\t\t\t\t\tTKI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] - ni, i]]\)\(\n\)
              \)\t\t\t}; 
          Map[Collect[Expand[#] //. sch, TKI[__], Factor] &, \n\t\t\tx == 
              y]];\)\)], "Input"],

Cell[BoxData[
    \(\(OperatorApplyK[x_ == y_] := 
        Block[{sch}, \n\t\tsch\  = \ {Schiebe[i_, "\<+\>"]\^ni_. \ TKI[
                    d_, {n15__}] :> \n\t\t\t\t\tTKI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] + ni, 
                    i]], \n\t\t\t\t\(\(Schiebe[i_, "\<-\>"]\^ni_. \ TKI[
                    d_, {n15__}] :> \n\t\t\t\t\tTKI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] - ni, i]]\)\(\n\)
              \)\t\t\t}; 
          Map[Collect[Expand[#] //. sch, TKI[__], Factor] &, \n\t\t\tx == 
              y]];\)\)], "Input"],

Cell[BoxData[
    \(\(OperatorApplyB[x_ == y_] := 
        Block[{sch}, \n\t\tsch\  = \ {Schiebe[i_, "\<+\>"]\^ni_. \ TBI[
                    d_, {n15__}] :> \n\t\t\t\t\tTBI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] + ni, 
                    i]], \n\t\t\t\t\(\(Schiebe[i_, "\<-\>"]\^ni_. \ TBI[
                    d_, {n15__}] :> \n\t\t\t\t\tTBI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] - ni, i]]\)\(\n\)
              \)\t\t\t}; 
          Map[Collect[Expand[#] //. sch, TBI[__], Factor] &, \n\t\t\tx == 
              y]];\)\)], "Input"],

Cell[BoxData[
    \(\(OperatorApplyA[x_ == y_] := 
        Block[{sch}, \n\t\tsch\  = \ {Schiebe[i_, "\<+\>"]\^ni_. \ TAI[
                    d_, {n15__}] :> \n\t\t\t\t\tTAI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] + ni, 
                    i]], \n\t\t\t\t\(\(Schiebe[i_, "\<-\>"]\^ni_. \ TAI[
                    d_, {n15__}] :> \n\t\t\t\t\tTAI[d, 
                  ReplacePart[{n15}, {n15}[\([i]\)] - ni, i]]\)\(\n\)
              \)\t\t\t}; 
          Map[Collect[Expand[#] //. sch, TAI[__], Factor] &, \n\t\t\tx == 
              y]];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MassDerivative", "Subsection",
  CellTags->"T1.3.4.1"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(MassDerivative[
          STLI[any__, {\n\ \ \ \ \ \ \ {al_, m1_}, {be_, m2_}, {ga_, 
                m3_}, {de_, m4_}, {ep_, m5_}}], {{0, d1_}, {0, d2_}, \ {0, 
              d3_}, \ {0, d4_}, \ {0, d5_}}]\), 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox[":=",
          FontWeight->"Plain"], 
        "\n", \(\((\ \(Pochhammer[al, d1]\ Pochhammer[be, d2]\ Pochhammer[ga, 
                  d3]\)*\n\ \ Pochhammer[de, d4]\ Pochhammer[ep, 
                d5]\ )\)\ *\n\ 
          STLI[any, {{al + d1, m1}, \ {be + d2, m2}, \ {ga + d3, 
                m3}, \ {de + d4, m4}, \ {ep + d5, m5}}]\)}], ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TarasovT", "Subsection",
  CellTags->"T1.3.5.1"],

Cell["\<\
TarasovT[abrs__, qq_ /; Head[qq] =!= List] := 
  TarasovT[abrs, qq, {\"g\", \"g\", \"g\", \"g\", \"g\"}]\
\>", "Input"],

Cell[BoxData[
    \(\(TarasovT[r_, \ s_, \ 
          qq_, \ {alp1_, alp2_, \ alp3_, alp4_, alp5_}]\  := \n
        Block[{\ al1, al2, al3, al4, al5, alrul, new, Q1, Q11, Q12, Q2, Q22, 
            dum1, dum2}, \n\ \(If[alp1\  === \ 0, \ al1\  = \ 0]; \ 
            If[alp2\  === \ 0, \ 
              al2\  = \ 0];\)\n\ \(If[alp3\  === \ 0, \ al3\  = \ 0];\)\n\(If[
              alp4\  === \ 0, \ al4\  = \ 0]; \ 
            If[alp5\  === \ 0, \ 
              al5\  = \ 0];\)\n\ \(alrul\  = \ 
                Select[{al1 :> I\ ParD[1], \ al2 :> I\ ParD[2], \ 
                    al3 :> I\ ParD[
                          3], \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ al4 :> 
                      I\ ParD[4], \ 
                    al5 :> I\ ParD[5]}, \ \(! MatchQ[#, \ 
                        0 :> _]\) &];\)\n\ \(Q1\  = \ 
                al3\ al5\  + \ al4\ al5\  + \ al2\ al3\  + \ 
                  al3\ al4;\)\n\ \(Q2\  = \ 
                al4\ al5\  + \ al3\ al5\  + \ al1\ al4\  + \ 
                  al3\ al4;\)\n\ \(Q11\  = 
                1/\((\(-4\))\)\ \((\ 
                    al2\  + \ al4\  + \ al5\ )\);\)\n\ \(Q22\  = 
                1/\((\(-4\))\)\ \((\ 
                    al1\  + \ al3\  + \ al5\ )\);\)\n\ \(Q12\  = 
                1/\((\(-2\))\)\ al5;\)\n\t\t\(new = \n\ 
              I^\((\(-r\) - s)\) \((\ 
                    D[\ Exp[\ 
                        I\ qq\ \((\n\ \ \ \ be1\ Q1\  + \ be2\ Q2\  + 
                              be1^2\ Q11\  + be2^2\ Q22\  + \ 
                              be1\ be2\ Q12\n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ )\)\ rho\ ], {be1, r}, {be2, 
                        s}\n\t\t\t\t]\ )\) /. \n\ \((\ 
                  Join[alrul, \ {be1\  :> \ 0, be2\  :> \ 0, \ 
                      rho\  :> \ \(-Pi^2\)/
                            Pi^2\ DPlus\ }])\); \(\(Map[\((Select[#, \
\((FreeQ[#, ParD] && FreeQ[#, DPlus])\) &]\ TpD[qq, 
                        Select[#, \((\(! \((FreeQ[#, ParD] && 
                                    FreeQ[#, 
                                      DPlus])\)\))\) &]])\) &, \(\((Expand[
                      new, ParD] + \ dum1\ dum2)\)\(\n\)
                \)\t\t] /. {dum1 :> 0, dum2 :> 0}\)\(\n\)
            \)\)\t\t];\)\)], "Input"],

Cell[BoxData[
    \(\(\(\n\)\(TarasovT[r_, \ s_, \ pp_, \ dp_ /; Head[dp] =!= List]\  := \ 
      TarasovT[r, s, pp, 
        dp, {"\<g\>", "\<g\>", "\<g\>", "\<g\>", "\<g\>"}]\)\)\)], "Input"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\((\[CapitalDelta]\ q\_1)\)\^a\)]],
  Cell[BoxData[
      \(TraditionalForm\`\((\[CapitalDelta]\ q\_2)\)\^b\)]],
  Cell[BoxData[
      \(TraditionalForm\`\((p\ q\_1)\)\^r\)]],
  Cell[BoxData[
      \(TraditionalForm\`\((p\ q\_2)\)\^s\)]]
}], "Text"],

Cell[BoxData[
    \(\(\(\n\)\(TarasovT[a_, b_, r_, s_, pp_, 
          dp_, {alp1_, alp2_, alp3_, alp4_, alp5_}] := 
        Block[{al1, al2, al3, al4, al5, alrul, new, Q1, Q11, Q12, Q2, Q22, 
            dum1, dum2}, If[alp1 === 0, al1 = 0]; If[alp2 === 0, al2 = 0]; 
          If[alp3 === 0, al3 = 0]; If[alp4 === 0, al4 = 0]; 
          If[alp5 === 0, al5 = 0]; 
          alrul = Select[{al1 \[RuleDelayed] I\ ParD[1], 
                al2 \[RuleDelayed] I\ ParD[2], al3 \[RuleDelayed] I\ ParD[3], 
                al4 \[RuleDelayed] I\ ParD[4], 
                al5 \[RuleDelayed] 
                  I\ ParD[5]}, \(\(\[InvisibleSpace]\)\(! \((MatchQ[#1, 
                      0 \[RuleDelayed] _])\)\)\) &]; 
          Q1 = al3\ al5 + al4\ al5 + al2\ al3 + al3\ al4; 
          Q2 = al4\ al5 + al3\ al5 + al1\ al4 + al3\ al4; 
          Q11 = \(-\(1\/4\)\)\ \((al2 + al4 + al5)\); 
          Q22 = \(-\(1\/4\)\)\ \((al1 + al3 + al5)\); Q12 = \(-\(al5\/2\)\); 
          new = I\^\(\(-r\) - s - a - b\)\ \[PartialD]\_\({be1, r}, {be2, s}, \
{ga1, a}, {ga2, b}\)Exp[
                    I\ \((\((be1\ pp + ga1\ dp)\)\ Q1 + \((be2\ pp + 
                                ga2\ dp)\)\ Q2 + 
                          be1\ \((be1\ pp + 2\ ga1\ dp)\)\ Q11 + 
                          be2\ \((be2\ pp + 
                                2\ ga2\ dp)\)\ Q22 + \((be1\ be2\ pp + \((be1\
\ ga2 + be2\ ga1)\)\ dp)\)\ Q12)\)\ rho] /. 
              Join[alrul, {be1 \[RuleDelayed] 0, be2 \[RuleDelayed] 0, 
                  ga1 :> 0, ga2 :> 0, 
                  rho \[RuleDelayed] \(-\(\(\[Pi]\^2\ \
DPlus\)\/\[Pi]\^2\)\)}]; \((Select[#1, 
                      FreeQ[#1, ParD] && FreeQ[#1, DPlus] &]\ TpD[pp, 
                      Select[#1, \(\(\[InvisibleSpace]\)\(! \((FreeQ[#1, 
                                  ParD] && 
                                FreeQ[#1, DPlus])\)\)\) &]] &)\) /@ \((Expand[
                    new] + dum1\ dum2)\) /. {dum1 \[RuleDelayed] 0, 
              dum2 \[RuleDelayed] 0}];\)\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ApplyTarasovT", "Subsection",
  CellTags->"T1.3.6.1"],

Cell[BoxData[
    \(ApplyTarasovT[tij_, \ exp_] := 
      Block[{dump}, \n\t\tdump = 
          Product[ParD[j]^dummy, {j, 5}]; \n\t\tExpand[
            tij\ exp] /. \n\((STLI[de_, pp_, pe__List]\ TpD[tpp_, 
                  DPlus^i_. \ t_])\) :> \n\t
            MassDerivative[
              STLI[\ de /. de :> \((de\  + \ 2\ i)\), pp, 
                pe], \n\t\t\t\t\t\t\t\(\(t\ dump\  /. Times -> List\) /. 
                  Power[_, n_] :> {0, n}\) /. dummy -> 0]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Misc", "Subsection",
  CellTags->"T1.3.7.1"],

Cell[BoxData[
    \(Prefactor1 /: \t\tPrefactor1[a_]^n_ := Prefactor1[a^n]\)], "Input"],

Cell[CellGroupData[{

Cell["Colors", "Subsubsection",
  CellTags->"T1.3.7.1.1"],

Cell[TextData[{
  StyleBox["TFI",
    FontColor->RGBColor[1, 0.6, 0]],
  " ",
  StyleBox["TVI ",
    FontColor->RGBColor[0.2, 0.4, 0.8]],
  StyleBox["TFR ",
    FontColor->RGBColor[0, 0.6, 0]],
  StyleBox["TVR ",
    FontColor->RGBColor[0.2, 0.8, 1]],
  StyleBox["MakeFun ",
    FontColor->RGBColor[1, 0.6, 0.6]],
  StyleBox["Cayley ",
    FontColor->RGBColor[1, 0, 0.4]],
  StyleBox["CayleyD ",
    FontColor->RGBColor[1, 0.2, 1]],
  StyleBox["Cayleyu",
    FontColor->RGBColor[0.8, 0.8, 0.4]],
  StyleBox[" ",
    FontColor->RGBColor[1, 0.2, 1]],
  StyleBox["IFF ",
    FontColor->RGBColor[0.6, 0.4, 1]],
  StyleBox["ToArgs ",
    FontColor->RGBColor[0.2, 0.6, 1]],
  StyleBox["Block",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0.2, 0.2]]
}], "Text"],

Cell[BoxData[
    \(\(MakeBoxes[Block, StandardForm] := 
        StyleBox["\<Block\>", FontSize \[Rule] 16, 
          FontWeight \[Rule] "\<Bold\>", 
          FontColor \[Rule] RGBColor[1, 0.2, 0.2]];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[Cayley, StandardForm] := 
        StyleBox["\<Cayley\>", 
          FontColor \[Rule] RGBColor[1, 0, 0.4]];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[CayleyD, StandardForm] := 
        StyleBox["\<CayleyD\>", 
          FontColor \[Rule] RGBColor[1, 0.2, 1]];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[Cayleyu, StandardForm] := 
        StyleBox["\<Cayleyu\>", 
          FontColor \[Rule] RGBColor[0.8, 0.8, 0.4]];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[IFF, StandardForm] := 
        StyleBox["\<IFF\>", 
          FontColor \[Rule] RGBColor[0.6, 0.4, 1]];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[MakeFun, StandardForm] := 
        StyleBox["\<MakeFun\>", 
          FontColor \[Rule] RGBColor[1, 0.6, 0.6]];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[TFI, StandardForm] := 
        StyleBox["\<TFI\>", 
          FontColor \[Rule] RGBColor[1, 0.6, 0]];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[TFR, StandardForm] := 
        StyleBox["\<TFR\>", 
          FontColor \[Rule] RGBColor[0, 0.6, 0]];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[ToArgs, StandardForm] := 
        StyleBox["\<ToArgs\>", 
          FontColor \[Rule] RGBColor[0.2, 0.6, 1]];\)\)], "Input"],

Cell[BoxData[
    \(\(MakeBoxes[TVI, StandardForm] := 
        StyleBox["\<TVI\>", 
          FontColor \[Rule] RGBColor[0.2, 0.4, 0.8]];\)\)], "Input"],

Cell[BoxData[
    \(MakeBoxes[TVR, StandardForm] := 
      StyleBox["\<TVR\>", FontColor \[Rule] RGBColor[0.2, 0.8, 1]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PQ", "Subsubsection",
  CellTags->"T1.3.7.2.1"],

Cell[BoxData[
    \(\(PQ[_Integer?Positive]\  := \ True;\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PNQ", "Subsubsection",
  CellTags->"T1.3.7.3.1"],

Cell[BoxData[
    \(\(PNQ[0] = True;\)\)], "Input"],

Cell[BoxData[
    \(\(PNQ[_Integer?Positive]\  := \ True;\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FactorC", "Subsubsection",
  CellTags->"T1.3.7.4.1"],

Cell[BoxData[
    \(FactorC[z_] := \(FactorC[z] = Factor[z]\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TFI", "Subsubsection",
  CellTags->"T1.3.7.5.1"],

Cell["\<\

TFI[depp__,{a___,b_Integer,c___}]:=TFI[depp,{a,{b,0},c}];
TFI[depp__,{a___,{0,m_/;m=!=0},b___}]:=TFI[depp,{a,{0,0},b}];
TFI[a__,{0,0},b__List]:=TFI[a,b];
TFI[d_,pp_,dp_,{0,0},{x1_,x2_,x3_,x4_,x5_},list_List]:=
    TFI[d,pp,{x1,x2,x3,x4,x5},list];
TFI[d_,pp_,dp_,{a_,b_},{0,0,0,0,0},list_List]:=TFI[d,pp,dp,{a,b},list];
TFI[d_,pp_,dp_/;Head[dp]=!=List,{0,0,0,0,0},list_List]:=TFI[d,pp,list];
TFI[d_,pp_,dp_/;Head[dp]=!=List,list_List]:=TFI[d,pp,list];
TFI[d_,pp_,dp_/;Head[dp]=!=List,{x1_,x2_,x3_,x4_,x5_},list_List]:=
    TFI[d,pp,{x1,x2,x3,x4,x5},list];
TFI[__,{{_,_},{0,0},{_,_},{0,0},{_,0}}]:=0;
TFI[__,{{0,0},{_,_},{0,0},{_,_},{_,0}}]:=0;
TFI[__,{{0,0},{_,_},{_,0},{_,_},{0,0}}]:=0;
TFI[__,{{_,0},{_,_},{0,0},{_,_},{0,0}}]:=0;
TFI[__,{{_,_},{_,0},{_,_},{0,0},{0,0}}]:=0;
TFI[__,{{_,_},{0,0},{_,_},{_,0},{0,0}}]:=0;
TFI[__,{{0,0},{0,0},{0,0},{_,0},{_,_}}]:=0;
TFI[__,{{0,0},{0,0},{_,0},{0,0},{_,_}}]:=0;
TFI[__,{{0,0},{_,0},{0,0},{0,0},{_,_}}]:=0;
TFI[__,{{_,0},{0,0},{0,0},{0,0},{_,_}}]:=0;
TFI[__,{{_,_},{_,0},{0,0},{0,0},{0,0}}]:=0;
TFI[__,{{_,0},{_,_},{0,0},{0,0},{0,0}}]:=0;
TFI[__,{{_,_},{0,0},{0,0},{_,0},{0,0}}]:=0;
TFI[__,{{_,0},{0,0},{0,0},{_,_},{0,0}}]:=0;
TFI[__,{{0,0},{_,0},{_,_},{0,0},{0,0}}]:=0;
TFI[__,{{0,0},{_,_},{_,0},{0,0},{0,0}}]:=0;
TFI[__,{{0,0},{0,0},{_,_},{_,0},{0,0}}]:=0;
TFI[__,{{0,0},{0,0},{_,0},{_,_},{0,0}}]:=0;

If[$Notebooks,

mbt[z_] := ToBoxes[z, TraditionalForm];
  redblue[z_ /; Head[z] =!= Plus] := mbt[z];
  redblue[(z_) - 1] := StyleBox[mbt[z], FontColor -> RGBColor[1, 0, 0]];
  redblue[(z_Subscript) - 2] :=
   StyleBox[SubscriptBox[OverscriptBox[z[[1]], \"_\"], z[[2]]],
    FontColor -> RGBColor[1, 0, 0]];
  redblue[(z_) - 2] :=
   StyleBox[OverscriptBox[mbt[z], \"_\"], FontColor -> RGBColor[1, 0, 0]];
  redblue[(z_) - 3] :=
   StyleBox[UnderscriptBox[OverscriptBox[mbt[z], \"_\"], \"_\"],
    FontColor -> RGBColor[1, 0, 0]];
  redblue[(z_) + 1] := StyleBox[mbt[z], FontColor -> RGBColor[0, 0, 1]];
  redblue[(z_) + 2] :=
   StyleBox[OverscriptBox[mbt[z], \"_\"], FontColor -> RGBColor[0, 0, 1]];
  redblue[(z_Subscript) + 2] :=
   StyleBox[SubscriptBox[OverscriptBox[z[[1]], \"_\"], z[[2]]],
    FontColor -> RGBColor[0, 0, 1]];

  TFI/: MakeBoxes[TFI[d_, pp_, {ur__}, {den__}], TraditionalForm] :=
    InterpretationBox @@
      {SubsuperscriptBox[StyleBox[\"F\", Rule[SingleLetterItalics, False],
         Rule[FontWeight, \"Bold\"]], RowBox @@ {redblue /@ {den}},
        RowBox[{\"(\", ToBoxes[d, TraditionalForm], \")\", \" \", ur}]],
       TFI[d, pp, {ur}, {den}], Editable -> True} /;
     MemberQ[{StandardForm, TraditionalForm}, TraditionalForm];

  TFI/: MakeBoxes[TFI[d_, pp_, dp_, any__, {den__}], TraditionalForm] :=
    (InterpretationBox @@
       {SubsuperscriptBox[StyleBox[\"F\",
          Rule[SingleLetterItalics, False], Rule[FontWeight, \"Bold\"]],
         RowBox @@ {redblue /@ {den}},
         RowBox[{\"(\", ToBoxes[d, TraditionalForm], \")\", \" \",
           Sequence @@ Flatten[{any}]}]], TFI[d, pp, dp, any, {den}],
        Editable -> True}) /; Head[dp] =!= List;

TFI/:
   MakeBoxes[TFI[dpp__, {den__}], TraditionalForm] :=
    InterpretationBox @@
      {SubsuperscriptBox[StyleBox[\"F\", Rule[SingleLetterItalics, False],
         Rule[FontWeight, \"Bold\"]], RowBox @@ {redblue /@ {den}},
        RowBox[{\"(\", ToBoxes[First[{dpp}], TraditionalForm], \")\"}]],
       TFI[dpp, {den}], Editable -> True} /;
     MemberQ[{StandardForm, TraditionalForm}, TraditionalForm] &&
      Head[Last[{dpp}]] =!= List;

];\
\>", "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TJI", "Subsubsection",
  CellTags->"T1.3.7.6.1"],

Cell[BoxData[
    \(TJI[de_, 
        pp_, {{n1_Integer, m1_}, {n2_Integer, m2_}, {n3_Integer, 
            m3_}}] := \((TJI[de, pp, {{n1, m1}, {n2, m2}, {n3, m3}}] = 
            TJI[de, pp, 
              Reverse[Sort[{{n1, m1}, {n2, m2}, {n3, 
                      m3}}]]])\) /; \(\(\[InvisibleSpace]\)\(! \
\((OrderedQ[{{n3, m3}, {n2, m2}, {n1, m1}}])\)\)\)\)], "Input"],

Cell[BoxData[
    \(TJI[d, pp, {{1, m1}, {1, m2}, {1, m3}}]\)], "Input"],

Cell[BoxData[
    \(TJI[d_, 0, {{_, 0}, {_, 0}, {_, 0}}] := 0\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TBI", "Subsubsection",
  CellTags->"T1.3.7.7.1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["TBI",
          FontColor->RGBColor[1, 0.6, 0]], "[", \(de_, 
        pp_, {{n1_Integer, m1_}, {n2_Integer, m2_}}\), "]"}], ":=", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{\(TJI[de, pp, {{n1, m1}, {n2, m2}}]\), "=", 
            RowBox[{
              StyleBox["TBI",
                FontColor->RGBColor[1, 0.6, 0]], "[", \(de, pp, 
              Reverse@\(Sort@{{n1, m1}, {n2, m2}}\)\), "]"}]}], ")"}], "/;", 
        "\[InvisibleSpace]", \(! \((OrderedQ[{{n2, m2}, {n1, 
                  m1}}])\)\)}]}]], "Input"],

Cell[BoxData[
    \(TBI[d_, 0, {{_, 0}, {_, 0}}] := 0\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TAI", "Subsubsection",
  CellTags->"T1.3.7.8.1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["TAI",
            FontColor->RGBColor[1, 0.6, 0]], "[", \(de_, 
          pp_, {{n1_Integer, 0}}\), "]"}], ":=", "0"}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definitions and notation", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.4.1"],

Cell[BoxData[
    RowBox[{
      RowBox[{"\[CapitalDelta]\[ScriptCapitalC]", "=", 
        RowBox[{\(-\(1\/2\)\), 
          RowBox[{"Det", "[", " ", 
            RowBox[{"(", GridBox[{
                  {"0", "1", "1", "1", "1"},
                  {"1", "0", \(\[Mu]\_6\), \(\[Mu]\_4\), \(\[Mu]\_3\)},
                  {"1", \(\[Mu]\_6\), "0", \(\[Mu]\_2\), \(\[Mu]\_1\)},
                  {"1", \(\[Mu]\_4\), \(\[Mu]\_2\), "0", \(\[Mu]\_5\)},
                  {"1", \(\[Mu]\_3\), \(\[Mu]\_1\), \(\[Mu]\_5\), "0"}
                  }], ")"}], "]"}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(\(checkli\  = \ {\n\t\t\[ScriptCapitalC] -> \[CapitalDelta]\
\[ScriptCapitalC], \n\[CapitalDelta]\_i_ :> \[PartialD]\_\(\[Mu]\_i\)\
\[CapitalDelta]\[ScriptCapitalC], \n\t\t\[Mu]\_6 :> PP, \[Mu]\_i_ :> 
            ToExpression["\<m\>" <> ToString[i]]^2, \n\t\tm\_1 :> \@m1\^2, 
          m\_2 :> \@m2\^2, m\_3 :> \@m3\^2, m\_4 :> \@m4\^2, 
          m\_5 :> \@m5\^2, \n\[CapitalDelta]\_\(i_, j_, k_\) :> \[Mu]\_i\%2 + \
\[Mu]\_j\%2 + \[Mu]\_k\%2 - 
              2 \((\(\[Mu]\_i\) \[Mu]\_j + \(\[Mu]\_j\) \[Mu]\_k + \(\[Mu]\_k\
\) \[Mu]\_i)\), \n
          u\_\(i_, j_, k_\) :> \[Mu]\_i - \[Mu]\_j - \[Mu]\_k, \n\
\[CapitalSigma]\_i_ :> 
            3\ d\  - 2\ \((\[Sum]\_\(j = 1\)\%i \[Nu]\_j)\) - 
              2, \n\t\[Nu]\_1 \[RuleDelayed] n1, \[Nu]\_2 \[RuleDelayed] 
            n2, \[Nu]\_3 \[RuleDelayed] n3, \[Nu]\_4 \[RuleDelayed] 
            n4, \[Nu]\_5 \[RuleDelayed] n5};\)\)], "Input"],

Cell[TextData[{
  "Define symmetry property for ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_\(i, j, k\)\)]]
}], "Text"],

Cell[BoxData[
    \(\[CapitalDelta]\_\(i_, j_, k_\) := \[CapitalDelta]\_\(Sequence @@ \
Sort[{i, j, k}]\) /; \(! OrderedQ[{i, j, k}]\)\)], "Input"],

Cell[BoxData[
    \(\[CapitalDelta]\_\(3, 1, 2\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox["ToArgs",
      FontColor->RGBColor[0.2, 0.6, 1]]], "Subsection",
  CellTags->"T1.4.1.1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["ToArgs",
            FontColor->RGBColor[0.2, 0.6, 1]], "[", "z_", "]"}], 
        ":=", \(Expand[z //. checkli]\)}], ";"}]], "Input"],

Cell[BoxData[
    \(ToArgs[\[CapitalSigma]\_4] // InputForm\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox["Cayley",
      FontColor->RGBColor[1, 0, 0.4]]], "Subsection",
  CellTags->"T1.4.2.1"],

Cell[TextData[{
  "This is (40).  ( p = ",
  Cell[BoxData[
      \(TraditionalForm\`\@p\^2\)]],
  ")"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"setd", "[", 
        RowBox[{
          RowBox[{"hCayley", "[", 
            RowBox[{
              RowBox[{
                InterpretationBox[\(m\_1\),
                  m1], ":", "_"}], ",", 
              RowBox[{
                InterpretationBox[\(m\_2\),
                  m2], ":", "_"}], ",", 
              RowBox[{
                InterpretationBox[\(m\_3\),
                  m3], ":", "_"}], ",", 
              RowBox[{
                InterpretationBox[\(m\_4\),
                  m4], ":", "_"}], ",", 
              RowBox[{
                InterpretationBox[\(m\_5\),
                  m5], ":", "_"}], ",", "p_"}], "]"}], ",", 
          RowBox[{"set", "[", 
            RowBox[{
              RowBox[{"hCayley", "[", 
                RowBox[{
                  InterpretationBox[\(m\_1\),
                    m1], ",", 
                  InterpretationBox[\(m\_2\),
                    m2], ",", 
                  InterpretationBox[\(m\_3\),
                    m3], ",", 
                  InterpretationBox[\(m\_4\),
                    m4], ",", 
                  InterpretationBox[\(m\_5\),
                    m5], ",", "p"}], "]"}], ",", 
              RowBox[{"factor", "[", 
                RowBox[{
                  RowBox[{
                    StyleBox["ToArgs",
                      FontColor->RGBColor[0.2, 0.6, 1]], "[", 
                    "\[ScriptCapitalC]", "]"}], "/.", 
                  RowBox[{
                    InterpretationBox[\(p\^2\),
                      PP], "\[Rule]", \(p\^2\)}]}], "]"}]}], "]"}]}], "]"}], "/.",
       
      RowBox[{"{", 
        RowBox[{
          RowBox[{"hCayley", "\[RuleDelayed]", 
            StyleBox["Cayley",
              FontColor->RGBColor[1, 0, 0.4]]}], 
          ",", \(setd \[RuleDelayed] SetDelayed\), 
          ",", \(set \[RuleDelayed] Set\), 
          ",", \(factor \[RuleDelayed] Factor\)}], "}"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["Cayley",
          FontColor->RGBColor[1, 0, 0.4]], "[", "i", "]"}], 
      "=", \(\[CapitalDelta]\_i\)}]], "Subsection",
  CellTags->"T1.4.3.1"],

Cell[BoxData[
    RowBox[{"Do", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"setd", "[", 
            RowBox[{
              RowBox[{\(hCayley[i]\), "[", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      InterpretationBox[\(m\_1\),
                        m1], ":", "_"}], ",", 
                    RowBox[{
                      InterpretationBox[\(m\_2\),
                        m2], ":", "_"}], ",", 
                    RowBox[{
                      InterpretationBox[\(m\_3\),
                        m3], ":", "_"}], ",", 
                    RowBox[{
                      InterpretationBox[\(m\_4\),
                        m4], ":", "_"}], ",", 
                    RowBox[{
                      InterpretationBox[\(m\_5\),
                        m5], ":", "_"}], ",", "p_"}], "}"}], "]"}], ",", 
              RowBox[{"set", "[", 
                RowBox[{
                  RowBox[{\(hCayley[i]\), "[", 
                    RowBox[{"{", 
                      RowBox[{
                        InterpretationBox[\(m\_1\),
                          m1], ",", 
                        InterpretationBox[\(m\_2\),
                          m2], ",", 
                        InterpretationBox[\(m\_3\),
                          m3], ",", 
                        InterpretationBox[\(m\_4\),
                          m4], ",", 
                        InterpretationBox[\(m\_5\),
                          m5], ",", "p"}], "}"}], "]"}], ",", 
                  RowBox[{"factor", "[", 
                    RowBox[{
                      RowBox[{
                        StyleBox["ToArgs",
                          FontColor->RGBColor[0.2, 0.6, 1]], 
                        "[", \(\[CapitalDelta]\_i\), "]"}], "/.", 
                      RowBox[{
                        InterpretationBox[\(p\^2\),
                          PP], "\[Rule]", \(p\^2\)}]}], "]"}]}], "]"}]}], 
            "]"}], "/.", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"hCayley", "\[RuleDelayed]", 
                StyleBox["Cayley",
                  FontColor->RGBColor[1, 0, 0.4]]}], 
              ",", \(setd \[RuleDelayed] SetDelayed\), 
              ",", \(set \[RuleDelayed] Set\), 
              ",", \(factor \[RuleDelayed] Factor\)}], "}"}]}], 
        ",", \({i, 6}\)}], "]"}]], "Input"],

Cell[BoxData[
    RowBox[{
      StyleBox["ToArgs",
        FontColor->RGBColor[0.2, 0.6, 1]], 
      "[", \(\[CapitalDelta]\_\(1, 2, 6\)\), "]"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["Cayley",
              FontColor->RGBColor[1, 0, 0.4]], "[", \(i_, j_, k_\), "]"}], 
          "[", "m_List", "]"}], ":=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["Cayley",
                FontColor->RGBColor[1, 0, 0.4]], "[", \(i, j, k\), "]"}], "[",
             "m", "]"}], 
          "=", \(Block[{mm = m}, \n\t\t\tWhile[Length[mm] < 7, 
              AppendTo[mm, Last[mm]]]; \n\t\t\tFactorC[
              mm\[LeftDoubleBracket]i\[RightDoubleBracket]\^4 - 
                2\ mm\[LeftDoubleBracket]j\[RightDoubleBracket]\^2\ mm\
\[LeftDoubleBracket]i\[RightDoubleBracket]\^2 - 
                2\ mm\[LeftDoubleBracket]k\[RightDoubleBracket]\^2\ mm\
\[LeftDoubleBracket]i\[RightDoubleBracket]\^2 + 
                mm\[LeftDoubleBracket]j\[RightDoubleBracket]\^4 + 
                mm\[LeftDoubleBracket]k\[RightDoubleBracket]\^4 - 
                2\ mm\[LeftDoubleBracket]j\[RightDoubleBracket]\^2\ mm\
\[LeftDoubleBracket]k\[RightDoubleBracket]\^2]]\)}]}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["Cayleyu",
              FontColor->RGBColor[0.8, 0.8, 0.4]], "[", \(i_, j_, k_\), "]"}],
           "[", "m_List", "]"}], ":=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["Cayleyu",
                FontColor->RGBColor[0.8, 0.8, 0.4]], "[", \(i, j, k\), "]"}], 
            "[", "mm", "]"}], 
          "=", \(Block[{mm = m}, \n\t\t\t\t\tWhile[Length[mm] < 7, 
              AppendTo[mm, Last[mm]]]; 
            FactorC[mm\[LeftDoubleBracket]i\[RightDoubleBracket]\^2 - 
                mm\[LeftDoubleBracket]j\[RightDoubleBracket]\^2 - 
                mm\[LeftDoubleBracket]k\[RightDoubleBracket]\^2]]\)}]}], 
      ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["CayleyD",
          FontColor->RGBColor[1, 0.2, 1]], "[", "i", "]"}], 
      "=", \(\[CapitalDelta]\_i\/\[CapitalDelta]\)}]], "Subsection",
  CellTags->"T1.4.4.1"],

Cell[BoxData[
    RowBox[{"Do", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"setd", "[", 
            RowBox[{
              RowBox[{\(hCayleyD[i]\), "[", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      InterpretationBox[\(m\_1\),
                        m1], ":", "_"}], ",", 
                    RowBox[{
                      InterpretationBox[\(m\_2\),
                        m2], ":", "_"}], ",", 
                    RowBox[{
                      InterpretationBox[\(m\_3\),
                        m3], ":", "_"}], ",", 
                    RowBox[{
                      InterpretationBox[\(m\_4\),
                        m4], ":", "_"}], ",", 
                    RowBox[{
                      InterpretationBox[\(m\_5\),
                        m5], ":", "_"}], ",", "p_"}], "}"}], "]"}], ",", 
              RowBox[{"set", "[", 
                RowBox[{
                  RowBox[{\(hCayleyD[i]\), "[", 
                    RowBox[{"{", 
                      RowBox[{
                        InterpretationBox[\(m\_1\),
                          m1], ",", 
                        InterpretationBox[\(m\_2\),
                          m2], ",", 
                        InterpretationBox[\(m\_3\),
                          m3], ",", 
                        InterpretationBox[\(m\_4\),
                          m4], ",", 
                        InterpretationBox[\(m\_5\),
                          m5], ",", "p"}], "}"}], "]"}], ",", 
                  RowBox[{"factor", "[", 
                    FractionBox[
                      RowBox[{
                        RowBox[{
                          StyleBox["ToArgs",
                            FontColor->RGBColor[0.2, 0.6, 1]], 
                          "[", \(\[CapitalDelta]\_i\), "]"}], "/.", 
                        RowBox[{
                          InterpretationBox[\(p\^2\),
                            PP], "\[Rule]", \(p\^2\)}]}], 
                      RowBox[{"\[ScriptCapitalC]", "[", 
                        RowBox[{
                          InterpretationBox[\(m\_1\),
                            m1], ",", 
                          InterpretationBox[\(m\_2\),
                            m2], ",", 
                          InterpretationBox[\(m\_3\),
                            m3], ",", 
                          InterpretationBox[\(m\_4\),
                            m4], ",", 
                          InterpretationBox[\(m\_5\),
                            m5], ",", "p"}], "]"}]], "]"}]}], "]"}]}], "]"}], 
          "/.", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"hCayleyD", "\[RuleDelayed]", 
                StyleBox["CayleyD",
                  FontColor->RGBColor[1, 0.2, 1]]}], 
              ",", \(setd \[RuleDelayed] SetDelayed\), 
              ",", \(set \[RuleDelayed] Set\), 
              ",", \(factor \[RuleDelayed] Factor\), ",", 
              RowBox[{"\[ScriptCapitalC]", "\[RuleDelayed]", 
                StyleBox["Cayley",
                  FontColor->RGBColor[1, 0, 0.4]]}]}], "}"}]}], 
        ",", \({i, 6}\)}], "]"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"setd", "[", 
        RowBox[{
          RowBox[{\(hCayleyD[1, 2, 5]\), "[", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  InterpretationBox[\(m\_1\),
                    m1], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_2\),
                    m2], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_3\),
                    m3], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_4\),
                    m4], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_5\),
                    m5], ":", "_"}], ",", "p_"}], "}"}], "]"}], ",", 
          RowBox[{"set", "[", 
            RowBox[{
              RowBox[{\(hCayleyD[1, 2, 5]\), "[", 
                RowBox[{"{", 
                  RowBox[{
                    InterpretationBox[\(m\_1\),
                      m1], ",", 
                    InterpretationBox[\(m\_2\),
                      m2], ",", 
                    InterpretationBox[\(m\_3\),
                      m3], ",", 
                    InterpretationBox[\(m\_4\),
                      m4], ",", 
                    InterpretationBox[\(m\_5\),
                      m5], ",", "p"}], "}"}], "]"}], ",", 
              RowBox[{"factor", "[", 
                FractionBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["ToArgs",
                        FontColor->RGBColor[0.2, 0.6, 1]], 
                      "[", \(\[CapitalDelta]\_\(1, 2, 5\)\), "]"}], "/.", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "\[Rule]", \(p\^2\)}]}], 
                  RowBox[{"\[ScriptCapitalC]", "[", 
                    RowBox[{
                      InterpretationBox[\(m\_1\),
                        m1], ",", 
                      InterpretationBox[\(m\_2\),
                        m2], ",", 
                      InterpretationBox[\(m\_3\),
                        m3], ",", 
                      InterpretationBox[\(m\_4\),
                        m4], ",", 
                      InterpretationBox[\(m\_5\),
                        m5], ",", "p"}], "]"}]], "]"}]}], "]"}]}], "]"}], "/.",
       
      RowBox[{"{", 
        RowBox[{
          RowBox[{"hCayleyD", "\[RuleDelayed]", 
            StyleBox["CayleyD",
              FontColor->RGBColor[1, 0.2, 1]]}], 
          ",", \(setd \[RuleDelayed] SetDelayed\), 
          ",", \(set \[RuleDelayed] Set\), 
          ",", \(factor \[RuleDelayed] Factor\), ",", 
          RowBox[{"\[ScriptCapitalC]", "\[RuleDelayed]", 
            StyleBox["Cayley",
              FontColor->RGBColor[1, 0, 0.4]]}]}], "}"}]}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"setd", "[", 
        RowBox[{
          RowBox[{\(hCayleyD[1, 3, 6]\), "[", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  InterpretationBox[\(m\_1\),
                    m1], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_2\),
                    m2], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_3\),
                    m3], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_4\),
                    m4], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_5\),
                    m5], ":", "_"}], ",", "p_"}], "}"}], "]"}], ",", 
          RowBox[{"set", "[", 
            RowBox[{
              RowBox[{\(hCayleyD[1, 3, 6]\), "[", 
                RowBox[{"{", 
                  RowBox[{
                    InterpretationBox[\(m\_1\),
                      m1], ",", 
                    InterpretationBox[\(m\_2\),
                      m2], ",", 
                    InterpretationBox[\(m\_3\),
                      m3], ",", 
                    InterpretationBox[\(m\_4\),
                      m4], ",", 
                    InterpretationBox[\(m\_5\),
                      m5], ",", "p"}], "}"}], "]"}], ",", 
              RowBox[{"factor", "[", 
                FractionBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["ToArgs",
                        FontColor->RGBColor[0.2, 0.6, 1]], 
                      "[", \(\[CapitalDelta]\_\(1, 3, 6\)\), "]"}], "/.", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "\[Rule]", \(p\^2\)}]}], 
                  RowBox[{"\[ScriptCapitalC]", "[", 
                    RowBox[{
                      InterpretationBox[\(m\_1\),
                        m1], ",", 
                      InterpretationBox[\(m\_2\),
                        m2], ",", 
                      InterpretationBox[\(m\_3\),
                        m3], ",", 
                      InterpretationBox[\(m\_4\),
                        m4], ",", 
                      InterpretationBox[\(m\_5\),
                        m5], ",", "p"}], "]"}]], "]"}]}], "]"}]}], "]"}], "/.",
       
      RowBox[{"{", 
        RowBox[{
          RowBox[{"hCayleyD", "\[RuleDelayed]", 
            StyleBox["CayleyD",
              FontColor->RGBColor[1, 0.2, 1]]}], 
          ",", \(setd \[RuleDelayed] SetDelayed\), 
          ",", \(set \[RuleDelayed] Set\), 
          ",", \(factor \[RuleDelayed] Factor\), ",", 
          RowBox[{"\[ScriptCapitalC]", "\[RuleDelayed]", 
            StyleBox["Cayley",
              FontColor->RGBColor[1, 0, 0.4]]}]}], "}"}]}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"setd", "[", 
        RowBox[{
          RowBox[{\(hCayleyD[3, 4, 5]\), "[", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  InterpretationBox[\(m\_1\),
                    m1], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_2\),
                    m2], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_3\),
                    m3], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_4\),
                    m4], ":", "_"}], ",", 
                RowBox[{
                  InterpretationBox[\(m\_5\),
                    m5], ":", "_"}], ",", "p_"}], "}"}], "]"}], ",", 
          RowBox[{"set", "[", 
            RowBox[{
              RowBox[{\(hCayleyD[3, 4, 5]\), "[", 
                RowBox[{"{", 
                  RowBox[{
                    InterpretationBox[\(m\_1\),
                      m1], ",", 
                    InterpretationBox[\(m\_2\),
                      m2], ",", 
                    InterpretationBox[\(m\_3\),
                      m3], ",", 
                    InterpretationBox[\(m\_4\),
                      m4], ",", 
                    InterpretationBox[\(m\_5\),
                      m5], ",", "p"}], "}"}], "]"}], ",", 
              RowBox[{"factor", "[", 
                FractionBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["ToArgs",
                        FontColor->RGBColor[0.2, 0.6, 1]], 
                      "[", \(\[CapitalDelta]\_\(3, 4, 5\)\), "]"}], "/.", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "\[Rule]", \(p\^2\)}]}], 
                  RowBox[{"\[ScriptCapitalC]", "[", 
                    RowBox[{
                      InterpretationBox[\(m\_1\),
                        m1], ",", 
                      InterpretationBox[\(m\_2\),
                        m2], ",", 
                      InterpretationBox[\(m\_3\),
                        m3], ",", 
                      InterpretationBox[\(m\_4\),
                        m4], ",", 
                      InterpretationBox[\(m\_5\),
                        m5], ",", "p"}], "]"}]], "]"}]}], "]"}]}], "]"}], "/.",
       
      RowBox[{"{", 
        RowBox[{
          RowBox[{"hCayleyD", "\[RuleDelayed]", 
            StyleBox["CayleyD",
              FontColor->RGBColor[1, 0.2, 1]]}], 
          ",", \(setd \[RuleDelayed] SetDelayed\), 
          ",", \(set \[RuleDelayed] Set\), 
          ",", \(factor \[RuleDelayed] Factor\), ",", 
          RowBox[{"\[ScriptCapitalC]", "\[RuleDelayed]", 
            StyleBox["Cayley",
              FontColor->RGBColor[1, 0, 0.4]]}]}], "}"}]}]], "Input"],

Cell[BoxData[
    RowBox[{
      StyleBox["ToArgs",
        FontColor->RGBColor[0.2, 0.6, 1]], 
      "[", \(\[CapitalDelta]\_\(i, j, k\)\), "]"}]], "Input"],

Cell[BoxData[
    RowBox[{
      StyleBox["ToArgs",
        FontColor->RGBColor[0.2, 0.6, 1]], 
      "[", \(\[CapitalDelta]\_\(1, 2, 6\)\), "]"}]], "Input"],

Cell[BoxData[
    RowBox[{
      StyleBox["ToArgs",
        FontColor->RGBColor[0.2, 0.6, 1]], "[", \(u\_\(i, j, k\)\), 
      "]"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Utility Functions", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.5.1"],

Cell[CellGroupData[{

Cell["MakeFun and friends", "Subsection",
  CellTags->"T1.5.1.1"],

Cell["\<\
This function generates the recursion function definitions for 
TARCER starting from the entered relations.\
\>", "Text"],

Cell["The idea is to recurse TFR into TFI's step by step.", "Text"],

Cell[TextData[{
  "Define: S cD[ijk__] := ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[ScriptCapitalC]\^\(-1\)\) \
\[CapitalDelta]\_ijk\)]]
}], "Text"],

Cell[BoxData[
    \(\(nutonand\[CapitalDelta]u[w_, 
          5] := \(w /. {\[Nu]\_1 \[RuleDelayed] n1, \[Nu]\_2 \[RuleDelayed] 
                n2, \[Nu]\_3 \[RuleDelayed] n3, \[Nu]\_4 \[RuleDelayed] 
                n4, \[Nu]\_5 \[RuleDelayed] 
                n5, \[CapitalDelta]\_ijk__ \[RuleDelayed] \[ScriptCapitalC]\ \
cD[ijk], u\_ijk__ \[RuleDelayed] cu[ijk], \n\t\tD\_ijk__ :> 
                TA[D, ijk], \[Rho]\_ijk__ :> 
                TA[\[Rho], ijk], \[Phi]\_\(\(ijk__\)\(\ \)\) :> 
                TA[\[Phi], ijk], \n\t\t\t\[Sigma]\_\(i_, j_, k_\) :> 
                TA[\[Sigma], d, i, j, k, \[Nu]\_i, \[Nu]\_j, \[Nu]\_k], 
              h\_\(i_, j_, k_\) :> 
                TA[h, d, i, j, k, \[Nu]\_i, \[Nu]\_j, \[Nu]\_k], 
              S\_\(i_, j_, k_\) :> 
                TA[S, d, i, j, 
                  k, \[Nu]\_i, \[Nu]\_j, \[Nu]\_k], \n\t\t\t\(\(\
\[CapitalSigma]\_i_ :> ToArgs[\[CapitalSigma]\_i]\)\(\n\)
              \)\t\t}\) /. {\t\[Nu]\_1 \[RuleDelayed] 
              n1, \[Nu]\_2 \[RuleDelayed] n2, \[Nu]\_3 \[RuleDelayed] 
              n3, \[Nu]\_4 \[RuleDelayed] n4, \[Nu]\_5 \[RuleDelayed] n5, 
            m\_1 :> m1, m\_2 :> m2, m\_3 :> m3, m\_4 :> m4, 
            m\_5 :> m5};\)\)], "Input"],

Cell[BoxData[
    \(\(nutonand\[CapitalDelta]u[
          w_] := \(w /. {\[Nu]\_1 \[RuleDelayed] n1, \[Nu]\_2 \[RuleDelayed] 
                n2, \[Nu]\_3 \[RuleDelayed] n3, \[Nu]\_4 \[RuleDelayed] 
                n4, \[Nu]\_5 \[RuleDelayed] 
                n5, \[CapitalDelta]\_ijk__ \[RuleDelayed] cD[ijk], 
              u\_ijk__ \[RuleDelayed] cu[ijk], 
              D\_ijk__ \[RuleDelayed] 
                TA[D, ijk], \[Rho]\_ijk__ \[RuleDelayed] 
                TA[\[Rho], ijk], \[Phi]\_ijk__ \[RuleDelayed] 
                TA[\[Phi], ijk], \[Sigma]\_\(i_, j_, k_\) \[RuleDelayed] 
                TA[\[Sigma], d, i, j, k, \[Nu]\_i, \[Nu]\_j, \[Nu]\_k], 
              h\_\(i_, j_, k_\) \[RuleDelayed] 
                TA[h, d, i, j, k, \[Nu]\_i, \[Nu]\_j, \[Nu]\_k], 
              S\_\(i_, j_, k_\) \[RuleDelayed] 
                TA[S, d, i, j, 
                  k, \[Nu]\_i, \[Nu]\_j, \[Nu]\_k], \[CapitalSigma]\_i_ \
\[RuleDelayed] ToArgs[\[CapitalSigma]\_i]}\) /. {\[Nu]\_1 \[RuleDelayed] 
              n1, \[Nu]\_2 \[RuleDelayed] n2, \[Nu]\_3 \[RuleDelayed] 
              n3, \[Nu]\_4 \[RuleDelayed] n4, \[Nu]\_5 \[RuleDelayed] n5, 
            m\_1 \[RuleDelayed] m1, m\_2 \[RuleDelayed] m2, 
            m\_3 \[RuleDelayed] m3, m\_4 \[RuleDelayed] m4, 
            m\_5 \[RuleDelayed] m5};\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TFR[d_, pp_, li1_, rest_]] := 
        TFR[d, pp, li1, rest];\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TFI[d_, pp_, li1_List]] := TFI[d, pp, li1];\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TFR[d_, pp_, dp_Symbol, li1_, rest_]] := 
        TFR[d, pp, dp, li1, rest];\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TFI[d_, pp_, dp_Symbol, li1_List]] := 
        TFI[d, pp, dp, li1];\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TVI[d_, pp_, li1_List]] := TVI[d, pp, li1];\)\)], "Input"],

Cell[BoxData[
    \(nnnnnaddPeP[any_[d_, pp_, li1_List, rest__List]] := 
      any[d, pp, li1, rest] /; any =!= List\)], "Input"],

Cell[BoxData[
    \(\(addPeP[z_List] := Append[z, \@PP];\)\)], "Input"],

Cell["addPeP[TFI[d_, z_List]] := TFI[d, PP, z]; ", "Input"],

Cell[BoxData[
    \(\(addPeP[TVI[d_, z_List]] := TVI[d, PP, z];\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TJI[d_, z_List]] := TJI[d, PP, z];\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TFR[d_, z_List]] := TFR[d, PP_, z];\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TFR[d_, pl_List, z_List]] := TFR[d, PP_, pl, z];\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TVR[d_, z__List]] := TVR[d, PP_, z];\)\)], "Input"],

Cell[BoxData[
    \(\(addPeP[TJR[d_, z__List]] := TJR[d, PP_, z];\)\)], "Input"],

Cell[BoxData[
    \(\(nutomass[
          w_] := \(\(w /. {\[Nu]\_1 + i1_.  \[RuleDelayed] {n1 + i1, 
                    m1}, \[Nu]\_2 + i2_.  \[RuleDelayed] {n2 + i2, 
                    m2}, \[Nu]\_3 + i3_.  \[RuleDelayed] {n3 + i3, 
                    m3}, \[Nu]\_4 + i4_.  \[RuleDelayed] {n4 + i4, 
                    m4}, \[Nu]\_5 + i5_.  \[RuleDelayed] {n5 + i5, 
                    m5}}\) /. {in1_Integer, in2_Integer, in3_Integer, 
                in4_Integer} \[RuleDelayed] {{in1, m1}, {in2, m2}, {in3, 
                  m3}, {in4, m4}}\) /. {in1_Integer, in2_Integer, 
              in3_Integer} \[RuleDelayed] {{in1, m1}, {in2, m2}, {in3, 
                m3}};\)\)], "Input"],

Cell[BoxData[
    \(\(Clear[maybeF];\)\)], "Input"],

Cell[BoxData[
    \(\(maybeF[z_Times] := 
        FactorC[z] /; 
          FreeQ[z, TFI] && FreeQ[z, TVI] && FreeQ[z, TJI] && 
            Length[Cases[z, cD[__], \(-1\)]] > 1;\)\)], "Input"],

Cell[BoxData[
    \(maybeF[z_] := z; SetAttributes[top, Listable];\)], "Input"],

Cell["This is the function for the information of side conditions.", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"SetAttributes", "[", 
        RowBox[{
          StyleBox["IFF",
            FontColor->RGBColor[0.6, 0.4, 1]], ",", "HoldAll"}], "]"}], 
      ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", 
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "]"}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["MakeFun",
            FontColor->RGBColor[1, 0.6, 0.6]], "[", 
          RowBox[{
            RowBox[{
              RowBox[{"c_.", " ", 
                RowBox[{
                  StyleBox["TFI",
                    FontColor->RGBColor[1, 0.6, 0]], "[", "t__", "]"}]}], "==",
               "rhs_"}], ",", "eqn_String", ",", 
            RowBox[{
              StyleBox["IFF",
                FontColor->RGBColor[0.6, 0.4, 1]], "[", "conds_", "]"}], 
            ",", \(mrel_ : {}\)}], "]"}], ":=", 
        RowBox[{
          StyleBox["Block",
            CellFrame->True,
            FontSize->16,
            FontWeight->"Bold",
            FontColor->RGBColor[1, 0.2, 0.2]], "[", 
          RowBox[{\({nm}\), ",", 
            
            RowBox[{\(nmrel = Select[Flatten[{mrel}], FreeQ[#1, Factor] &]\), 
              ";", 
              RowBox[{
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  RowBox[{
                                    RowBox[{"HoldForm", "@@", 
                                      RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"setdel", "[", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"addPeP", "[", 
                                        RowBox[{
                                        StyleBox["TFR",
                                        FontColor->RGBColor[0, 0.6, 0]], 
                                        "@@", \(top /@ nutomass[{t}]\)}], 
                                        "]"}], "/.", "nmrel"}], ",", 
                                        RowBox[{\(Hold[Condition]\), "[", 
                                        RowBox[{
                                        
                                        RowBox[{\(Hold[CompoundExpression]\), 
                                        "[", "\t", 
                                        
                                        RowBox[{\(\(Hold[TComment]\)[
                                        eqn, \(\(\(addPeP[nutomass[TFR[t]]] /. 
                                        TFR -> TFIC\) /. {Pattern :> pat, 
                                        Blank :> blank}\) /. pat[PP, 
                                        blank[]] :> PP\) /. nmrel]\), ",", 
                                        RowBox[{
                                        RowBox[{"Collect", "[", 
                                        RowBox[{
                                        RowBox[{"TT", "=", 
                                        RowBox[{"Expand3", "[", 
                                        RowBox[{
                                        "nutonand\[CapitalDelta]u", "[", 
                                        RowBox[{
                                        RowBox[{\(1\/c\), 
                                        RowBox[{"(", 
                                        RowBox[{"rhs", "/.", 
                                        RowBox[{
                                        RowBox[{
                                        StyleBox["TFI",
                                        FontColor->RGBColor[1, 0.6, 0]], "[", 
                                        "te__", "]"}], "\[RuleDelayed]", 
                                        RowBox[{"addPeP", "[", 
                                        RowBox[{"nutomass", "[", 
                                        RowBox[{
                                        StyleBox["TFI",
                                        FontColor->RGBColor[1, 0.6, 0]], "[", 
                                        "te", "]"}], "]"}], "]"}]}]}], 
                                        ")"}]}], ",", "5"}], "]"}], "]"}]}], 
                                        ",", 
                                        RowBox[{
                                        StyleBox["TFI",
                                        FontColor->RGBColor[1, 0.6, 0]], "[", 
                                        "__", "]"}], 
                                        ",", \(maybeF[\((Collect[
                                        Numerator[#1], cD[__], 
                                        Factor]/Collect[Denominator[#1], 
                                        cD[__], Factor] &)\) /@ 
                                        Factor[#1]] &\)}], "]"}], "/.", 
                                        "nmrel"}]}], "]"}], ",", 
                                        RowBox[{
                                        "nutonand\[CapitalDelta]u", "[", 
                                        RowBox[{
                                        RowBox[{
                                        StyleBox["IFF",
                                        FontColor->RGBColor[0.6, 0.4, 1]], 
                                        "[", "conds", "]"}], ",", "5"}], 
                                        "]"}]}], "]"}]}], "]"}], 
                                        "/.", \(top[i_Integer] \[Rule] i\)}], 
                                        "/.", \(top \[RuleDelayed] \
\((patternTest[pattern[#1, blank[]], PQ] &)\)\)}], "/.", 
                                        RowBox[{
                                        RowBox[{"patternTest", "[", 
                                        RowBox[{
                                        RowBox[{"pattern", "[", 
                                        RowBox[{
                                        RowBox[{"dm_", "/;", 
                                        RowBox[{"MemberQ", "[", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{"d", ",", 
                                        InterpretationBox[\(p\^2\),
                                        PP], ",", "DP", ",", 
                                        InterpretationBox[\(m\_1\),
                                        m1], ",", 
                                        InterpretationBox[\(m\_2\),
                                        m2], ",", 
                                        InterpretationBox[\(m\_3\),
                                        m3], ",", 
                                        InterpretationBox[\(m\_4\),
                                        m4], ",", 
                                        InterpretationBox[\(m\_5\),
                                        m5]}], "}"}], ",", "dm"}], "]"}]}], 
                                        ",", \(blank[]\)}], "]"}], ",", "_"}],
                                         "]"}], 
                                        "\[RuleDelayed]", \(pattern[dm, 
                                        blank[]]\)}]}], "/.", "\n", 
                                        "\t\t\t\t\t", \({blank \[RuleDelayed] 
                                        Blank, 
                                        pattern \[RuleDelayed] Pattern, 
                                        patternTest \[RuleDelayed] 
                                        PatternTest}\)}], "}"}]}], "/.", 
                                    RowBox[{\(cD[ijk__]\), "\[Rule]", 
                                      RowBox[{
                                        RowBox[{"Hold", "[", 
                                        RowBox[{
                                        StyleBox["CayleyD",
                                        FontColor->RGBColor[1, 0.2, 1]], "[", 
                                        "ijk", "]"}], "]"}], 
                                        "[", \(addPeP[
                                        BLA = \(nutomass[Last[{t}]] /. 
                                        nmrel\) /. {nuu_, ma_} \[RuleDelayed] 
                                        ma]\), "]"}]}]}], 
                                  "/.", \(addPeP -> Identity\)}], 
                                "/.", \(Hold[CompoundExpression] \[Rule] 
                                  CompoundExpression\)}], "/.", 
                              RowBox[{
                                RowBox[{\(Hold[Condition]\), "[", 
                                  RowBox[{"a_", ",", 
                                    RowBox[{
                                      StyleBox["IFF",
                                        FontColor->RGBColor[0.6, 0.4, 1]], 
                                      "[", "b_", "]"}]}], "]"}], 
                                "\[Rule]", \(a /; b\)}]}], 
                            "/.", \(Hold[Set] \[Rule] Set\)}], 
                          "/.", \(Hold[TComment] -> TComment\)}], "/.", 
                        RowBox[{
                          RowBox[{"Hold", "[", 
                            RowBox[{
                              StyleBox["CayleyD",
                                FontColor->RGBColor[1, 0.2, 1]], "[", "ijk__",
                               "]"}], "]"}], "\[Rule]", 
                          RowBox[{
                            StyleBox["CayleyD",
                              FontColor->RGBColor[1, 0.2, 1]], "[", "ijk", 
                            "]"}]}]}], 
                      "/.", \({setdel \[RuleDelayed] SetDelayed}\)}], ")"}], 
                  "/.", \(Identity -> identit\)}], 
                "/.", \(identit[a_] -> a\)}]}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["MakeFun",
            FontColor->RGBColor[1, 0.6, 0.6]], "[", 
          RowBox[{
            RowBox[{
              RowBox[{"c_.", " ", 
                RowBox[{
                  StyleBox["TFI",
                    FontColor->RGBColor[1, 0.6, 0]], "[", "t__", "]"}]}], "==",
               "rhs_"}], ",", "eqn_String", ",", \(mrel_ : {}\)}], "]"}], ":=",
         
        RowBox[{
          RowBox[{
            StyleBox["Block",
              CellFrame->True,
              FontSize->16,
              FontWeight->"Bold",
              FontColor->RGBColor[1, 0.2, 0.2]], "[", 
            RowBox[{\({nm}\), ",", 
              
              RowBox[{\(nmrel = 
                  Select[Flatten[{mrel}], FreeQ[#1, Factor] &]\), ";", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{"HoldForm", "@@", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"setdel", "[", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"addPeP", "[", 
                                        RowBox[{
                                        StyleBox["TFR",
                                        FontColor->RGBColor[0, 0.6, 0]], 
                                        "@@", \(top /@ nutomass[{t}]\)}], 
                                        "]"}], "/.", "nmrel"}], ",", 
                                        
                                        RowBox[{\(Hold[CompoundExpression]\), 
                                        "[", 
                                        
                                        RowBox[{\(\(Hold[TComment]\)[
                                        eqn, \(\(\(addPeP[nutomass[TFR[t]]] /. 
                                        TFR -> TFIC\) /. {Pattern :> pat, 
                                        Blank :> blank}\) /. pat[PP, 
                                        blank[]] :> PP\) /. nmrel]\), ",", 
                                        RowBox[{
                                        RowBox[{"Collect", "[", 
                                        RowBox[{
                                        RowBox[{"TT", "=", 
                                        RowBox[{"Expand3", "[", 
                                        RowBox[{
                                        "nutonand\[CapitalDelta]u", "[", 
                                        RowBox[{\(1\/c\), 
                                        RowBox[{"(", 
                                        RowBox[{"rhs", "/.", 
                                        RowBox[{
                                        RowBox[{
                                        StyleBox["TFI",
                                        FontColor->RGBColor[1, 0.6, 0]], "[", 
                                        "te__", "]"}], "\[RuleDelayed]", 
                                        RowBox[{"addPeP", "[", 
                                        RowBox[{"nutomass", "[", 
                                        RowBox[{
                                        StyleBox["TFI",
                                        FontColor->RGBColor[1, 0.6, 0]], "[", 
                                        "te", "]"}], "]"}], "]"}]}]}], 
                                        ")"}]}], "]"}], "]"}]}], ",", 
                                        RowBox[{
                                        StyleBox["TFI",
                                        FontColor->RGBColor[1, 0.6, 0]], "[", 
                                        "__", "]"}], 
                                        ",", \(maybeF[\((Collect[
                                        Numerator[#1], cD[__], 
                                        Factor]/Collect[Denominator[#1], 
                                        cD[__], Factor] &)\) /@ 
                                        Factor[#1]] &\)}], "]"}], "/.", 
                                        "nmrel"}]}], "]"}]}], "]"}], 
                                        "/.", \(top[i_Integer] \[Rule] i\)}], 
                                        "/.", \(top \[RuleDelayed] \
\((patternTest[pattern[#1, blank[]], PQ] &)\)\)}], "/.", 
                                        RowBox[{
                                        RowBox[{"patternTest", "[", 
                                        RowBox[{
                                        RowBox[{"pattern", "[", 
                                        RowBox[{
                                        RowBox[{"dm_", "/;", 
                                        RowBox[{"MemberQ", "[", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{"d", ",", 
                                        InterpretationBox[\(p\^2\),
                                        PP], ",", "DP", ",", 
                                        InterpretationBox[\(m\_1\),
                                        m1], ",", 
                                        InterpretationBox[\(m\_2\),
                                        m2], ",", 
                                        InterpretationBox[\(m\_3\),
                                        m3], ",", 
                                        InterpretationBox[\(m\_4\),
                                        m4], ",", 
                                        InterpretationBox[\(m\_5\),
                                        m5]}], "}"}], ",", "dm"}], "]"}]}], 
                                        ",", \(blank[]\)}], "]"}], ",", "_"}],
                                         "]"}], "\[RuleDelayed]", \(pattern[
                                        dm, blank[]]\)}]}], "/.", 
                                        "\t", \({blank \[RuleDelayed] Blank, 
                                        pattern \[RuleDelayed] Pattern, 
                                        patternTest \[RuleDelayed] 
                                        PatternTest}\)}], "}"}]}], "/.", 
                                      RowBox[{\(cD[ijk__]\), "\[Rule]", 
                                        RowBox[{
                                        RowBox[{"Hold", "[", 
                                        RowBox[{
                                        StyleBox["CayleyD",
                                        FontColor->RGBColor[1, 0.2, 1]], "[", 
                                        "ijk", "]"}], "]"}], 
                                        "[", \(addPeP[\(\(nutomass[
                                        Last[{t}]] /. addPeP -> Identity\) /. 
                                        nmrel\) /. {nuu_, ma_} \[RuleDelayed] 
                                        ma]\), "]"}]}]}], 
                                    "/.", \(Hold[CompoundExpression] \[Rule] 
                                      CompoundExpression\)}], "/.", 
                                  RowBox[{
                                    RowBox[{\(Hold[Condition]\), "[", 
                                      RowBox[{"a_", ",", 
                                        RowBox[{
                                        StyleBox["IFF",
                                        FontColor->RGBColor[0.6, 0.4, 1]], 
                                        "[", "b_", "]"}]}], "]"}], 
                                    "\[Rule]", \(a /; b\)}]}], 
                                "/.", \(Hold[Set] \[Rule] Set\)}], 
                              "/.", \(Hold[TComment] -> TComment\)}], "/.", 
                            RowBox[{
                              RowBox[{"Hold", "[", 
                                RowBox[{
                                  StyleBox["CayleyD",
                                    FontColor->RGBColor[1, 0.2, 1]], "[", 
                                  "ijk__", "]"}], "]"}], "\[Rule]", 
                              RowBox[{
                                StyleBox["CayleyD",
                                  FontColor->RGBColor[1, 0.2, 1]], "[", "ijk",
                                 "]"}]}]}], 
                          "/.", \({setdel \[RuleDelayed] SetDelayed}\)}], 
                        ")"}], "/.", \(addPeP -> Identity\)}], 
                    "/.", \(Identity -> identit\)}], 
                  "/.", \(identit[a_] -> a\)}]}]}], "]"}], "/;", 
          RowBox[{\(Head[mrel]\), "=!=", 
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["MakeFun",
            FontColor->RGBColor[1, 0.6, 0.6]], "[", 
          RowBox[{
            RowBox[{
              RowBox[{"c_.", " ", 
                RowBox[{
                  StyleBox["TVI",
                    FontColor->RGBColor[0.2, 0.4, 0.8]], "[", "t__", "]"}]}], 
              "==", "rhs_"}], ",", "eqn_String", ",", 
            RowBox[{
              StyleBox["IFF",
                FontColor->RGBColor[0.6, 0.4, 1]], "[", "conds_", "]"}], 
            ",", \(mrel_ : {}\)}], "]"}], ":=", 
        RowBox[{
          StyleBox["Block",
            FontSize->16,
            FontWeight->"Bold",
            FontColor->RGBColor[1, 0.2, 0.2]], "[", 
          RowBox[{\({nm}\), ",", 
            
            RowBox[{\(nmrel = Select[Flatten[{mrel}], FreeQ[#1, Factor] &]\), 
              ";", 
              RowBox[{"nmrel", "=", 
                RowBox[{"Join", "[", 
                  RowBox[{"nmrel", ",", 
                    RowBox[{"{", 
                      RowBox[{
                        RowBox[{\(m\_1\), "\[RuleDelayed]", 
                          InterpretationBox[\(m\_1\),
                            m1]}], ",", 
                        RowBox[{\(m\_2\), "\[RuleDelayed]", 
                          InterpretationBox[\(m\_2\),
                            m2]}], ",", 
                        RowBox[{\(m\_3\), "\[RuleDelayed]", 
                          InterpretationBox[\(m\_3\),
                            m3]}], ",", 
                        RowBox[{\(m\_4\), "\[RuleDelayed]", 
                          InterpretationBox[\(m\_4\),
                            m4]}], 
                        ",", \(\[CapitalSigma]\_i_ :> 
                          ToArgs[\[CapitalSigma]\_i]\)}], "}"}]}], "]"}]}], 
              ";", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{
                                        RowBox[{
                                        RowBox[{"HoldForm", "@@", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"setdel", "[", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"addPeP", "[", 
                                        RowBox[{
                                        StyleBox["TVR",
                                        FontColor->RGBColor[0.2, 0.8, 1]], 
                                        "@@", \(top /@ nutomass[{t}]\)}], 
                                        "]"}], "/.", "nmrel"}], ",", 
                                        RowBox[{\(Hold[Condition]\), "[", 
                                        RowBox[{
                                        
                                        RowBox[{\(Hold[CompoundExpression]\), 
                                        "[", 
                                        
                                        RowBox[{\(\(Hold[TComment]\)[
                                        eqn, \(\(\(addPeP[nutomass[TVR[t]]] /. 
                                        TVR -> TVIC\) /. {Pattern :> pat, 
                                        Blank :> blank}\) /. pat[PP, 
                                        blank[]] :> PP\) /. nmrel]\), ",", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"Collect", "[", 
                                        RowBox[{
                                        RowBox[{"TT", "=", 
                                        RowBox[{"Expand3", "[", 
                                        RowBox[{"nutonand\[CapitalDelta]u", 
                                        "[", 
                                        RowBox[{\(1\/c\), 
                                        RowBox[{"(", 
                                        RowBox[{"rhs", "/.", 
                                        RowBox[{
                                        RowBox[{
                                        StyleBox["TVI",
                                        FontColor->RGBColor[0.2, 0.4, 0.8]], 
                                        "[", "te__", "]"}], "\[RuleDelayed]", 
                                        
                                        RowBox[{"addPeP", "[", 
                                        RowBox[{"nutomass", "[", 
                                        RowBox[{
                                        StyleBox["TVI",
                                        FontColor->RGBColor[0.2, 0.4, 0.8]], 
                                        "[", "te", "]"}], "]"}], "]"}]}]}], 
                                        ")"}]}], "]"}], "]"}]}], ",", 
                                        RowBox[{
                                        StyleBox["TVI",
                                        FontColor->RGBColor[0.2, 0.4, 0.8]], 
                                        "[", "__", "]"}], 
                                        ",", \(maybeF[\((Collect[
                                        Numerator[#1], cu[__], 
                                        Factor]/Collect[Denominator[#1], 
                                        cu[__], Factor] &)\) /@ 
                                        Factor[#1]] &\)}], "]"}], 
                                        "/.", \(\[ScriptCapitalC] -> 1\)}], "/.",
                                         "nmrel"}]}], "]"}], ",", 
                                        RowBox[{
                                        "nutonand\[CapitalDelta]u", "[", 
                                        RowBox[{
                                        StyleBox["IFF",
                                        FontColor->RGBColor[0.6, 0.4, 1]], 
                                        "[", "conds", "]"}], "]"}]}], "]"}]}],
                                         "]"}], "/.", \(top[
                                        i_Integer] \[Rule] i\)}], 
                                        "/.", \(top \[RuleDelayed] \
\((patternTest[pattern[#1, blank[]], PQ] &)\)\)}], "/.", 
                                        RowBox[{
                                        RowBox[{"patternTest", "[", 
                                        RowBox[{
                                        RowBox[{"pattern", "[", 
                                        RowBox[{
                                        RowBox[{"dm_", "/;", 
                                        RowBox[{"MemberQ", "[", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{"d", ",", 
                                        InterpretationBox[\(p\^2\),
                                        PP], ",", 
                                        InterpretationBox[\(m\_1\),
                                        m1], ",", 
                                        InterpretationBox[\(m\_2\),
                                        m2], ",", 
                                        InterpretationBox[\(m\_3\),
                                        m3], ",", 
                                        InterpretationBox[\(m\_4\),
                                        m4]}], "}"}], ",", "dm"}], "]"}]}], 
                                        ",", \(blank[]\)}], "]"}], ",", "_"}],
                                         "]"}], "\[RuleDelayed]", \(pattern[
                                        dm, blank[]]\)}]}], "/.", 
                                        "\t", \({blank \[RuleDelayed] Blank, 
                                        pattern \[RuleDelayed] Pattern, 
                                        patternTest \[RuleDelayed] 
                                        PatternTest}\)}], "}"}]}], "/.", "\n",
                                         "\t\t\t", \(HoldPattern[
                                        TA[aijk__]] \[Rule] \(Hold[
                                        TA[aijk]]\)[
                                        addPeP[\(nutomass[Last[{t}]] /. 
                                        nmrel\) /. {nuu_, ma_} \[RuleDelayed] 
                                        ma]]\)}], "/.", "\n", 
                                        "\t\t\t", \(cD[
                                        ijk__] \[Rule] \(Hold[Cayley[ijk]]\)[
                                        addPeP[\(nutomass[Last[{t}]] /. 
                                        nmrel\) /. {nuu_, ma_} \[RuleDelayed] 
                                        ma]]\)}], "/.", 
                                      RowBox[{\(cu[ijk__]\), "\[Rule]", 
                                        RowBox[{
                                        RowBox[{"Hold", "[", 
                                        RowBox[{
                                        StyleBox["Cayleyu",
                                        FontColor->RGBColor[0.8, 0.8, 0.4]], 
                                        "[", "ijk", "]"}], "]"}], 
                                        "[", \(addPeP[\(\(nutomass[
                                        Last[{t}]] /. addPeP -> Identity\) /. 
                                        nmrel\) /. {nuu_, ma_} \[RuleDelayed] 
                                        ma]\), "]"}]}]}], 
                                    "/.", \(Hold[CompoundExpression] \[Rule] 
                                      CompoundExpression\)}], "/.", 
                                  RowBox[{
                                    RowBox[{\(Hold[Condition]\), "[", 
                                      RowBox[{"a_", ",", 
                                        RowBox[{
                                        StyleBox["IFF",
                                        FontColor->RGBColor[0.6, 0.4, 1]], 
                                        "[", "b_", "]"}]}], "]"}], 
                                    "\[Rule]", \(a /; b\)}]}], 
                                "/.", \(Hold[Set] \[Rule] Set\)}], 
                              "/.", \(Hold[TComment] -> TComment\)}], 
                            "/.", \(addPeP -> Identity\)}], "/.", 
                          RowBox[{
                            RowBox[{"Hold", "[", 
                              RowBox[{
                                StyleBox["Cayleyu",
                                  FontColor->RGBColor[0.8, 0.8, 0.4]], "[", 
                                "ijk__", "]"}], "]"}], "\[Rule]", 
                            RowBox[{
                              StyleBox["Cayleyu",
                                FontColor->RGBColor[0.8, 0.8, 0.4]], "[", 
                              "ijk", "]"}]}]}], "/.", 
                        RowBox[{
                          RowBox[{"Hold", "[", 
                            RowBox[{
                              StyleBox["Cayley",
                                FontColor->RGBColor[1, 0.2, 1]], "[", "ijk__",
                               "]"}], "]"}], "\[Rule]", 
                          RowBox[{
                            StyleBox["Cayley",
                              FontColor->RGBColor[1, 0.2, 1]], "[", "ijk", 
                            "]"}]}]}], "/.", "\n", 
                      "\t\t\t", \(Hold[TA] -> TA\)}], 
                    "/.", \({setdel \[RuleDelayed] SetDelayed}\)}], 
                  "/.", \(Identity -> identit\)}], 
                "/.", \(identit[a_] -> a\)}]}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["MakeFun",
            FontColor->RGBColor[1, 0.6, 0.6]], "[", 
          RowBox[{
            RowBox[{
              RowBox[{"c_.", " ", 
                RowBox[{
                  StyleBox["TVI",
                    FontColor->RGBColor[0.2, 0.4, 0.8]], "[", "t__", "]"}]}], 
              "==", "rhs_"}], ",", "eqn_String", ",", \(mrel_ : {}\)}], "]"}],
         ":=", 
        RowBox[{
          RowBox[{
            StyleBox["Block",
              FontSize->16,
              FontWeight->"Bold",
              FontColor->RGBColor[1, 0.2, 0.2]], "[", 
            RowBox[{\({nm}\), ",", 
              
              RowBox[{\(nmrel = 
                  Select[Flatten[{mrel}], FreeQ[#1, Factor] &]\), ";", 
                RowBox[{"nmrel", "=", 
                  RowBox[{"Join", "[", 
                    RowBox[{"nmrel", ",", 
                      RowBox[{"{", 
                        RowBox[{
                          RowBox[{\(m\_1\), "\[RuleDelayed]", 
                            InterpretationBox[\(m\_1\),
                              m1]}], ",", 
                          RowBox[{\(m\_2\), "\[RuleDelayed]", 
                            InterpretationBox[\(m\_2\),
                              m2]}], ",", 
                          RowBox[{\(m\_3\), "\[RuleDelayed]", 
                            InterpretationBox[\(m\_3\),
                              m3]}], ",", 
                          RowBox[{\(m\_4\), "\[RuleDelayed]", 
                            InterpretationBox[\(m\_4\),
                              m4]}], ",", 
                          RowBox[{\(\[CapitalSigma]\_i_\), "\[RuleDelayed]", 
                            RowBox[{
                              StyleBox["ToArgs",
                                FontColor->RGBColor[0.2, 0.6, 1]], 
                              "[", \(\[CapitalSigma]\_i\), "]"}]}]}], "}"}]}],
                     "]"}]}], ";", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{"HoldForm", "@@", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"setdel", "[", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"addPeP", "[", 
                                        RowBox[{
                                        StyleBox["TVR",
                                        FontColor->RGBColor[0.2, 0.8, 1]], 
                                        "@@", \(top /@ nutomass[{t}]\)}], 
                                        "]"}], "/.", "nmrel"}], ",", 
                                        
                                        RowBox[{\(Hold[CompoundExpression]\), 
                                        "[", 
                                        
                                        RowBox[{\(\(Hold[TComment]\)[
                                        eqn, \(\(\(addPeP[nutomass[TVR[t]]] /. 
                                        TVR -> TVIC\) /. {Pattern :> pat, 
                                        Blank :> blank}\) /. pat[PP, 
                                        blank[]] :> PP\) /. nmrel]\), "\n", 
                                        "\t\t\t\t\t\t", ",", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"Collect", "[", 
                                        RowBox[{
                                        RowBox[{"TT", "=", 
                                        RowBox[{"Expand3", "[", 
                                        RowBox[{
                                        "nutonand\[CapitalDelta]u", "[", 
                                        RowBox[{\(1\/c\), 
                                        RowBox[{"(", 
                                        RowBox[{"rhs", "/.", 
                                        RowBox[{
                                        RowBox[{
                                        StyleBox["TVI",
                                        FontColor->RGBColor[0.2, 0.4, 0.8]], 
                                        "[", "te__", "]"}], "\[RuleDelayed]", 
                                        
                                        RowBox[{"addPeP", "[", 
                                        RowBox[{"nutomass", "[", 
                                        RowBox[{
                                        StyleBox["TVI",
                                        FontColor->RGBColor[0.2, 0.4, 0.8]], 
                                        "[", "te", "]"}], "]"}], "]"}]}]}], 
                                        ")"}]}], "]"}], "]"}]}], ",", 
                                        RowBox[{
                                        StyleBox["TVI",
                                        FontColor->RGBColor[0.2, 0.4, 0.8]], 
                                        "[", "__", "]"}], 
                                        ",", \(maybeF[\((Collect[
                                        Numerator[#1], cu[__], 
                                        Factor]/Collect[Denominator[#1], 
                                        cu[__], Factor] &)\) /@ 
                                        Factor[#1]] &\)}], "]"}], "/.", 
                                        "nmrel"}], 
                                        "/.", \(\[ScriptCapitalC] \[Rule] 
                                        1\)}]}], "]"}]}], "]"}], 
                                        "/.", \(top[i_Integer] \[Rule] i\)}], 
                                        "/.", \(top \[RuleDelayed] \
\((patternTest[pattern[#1, blank[]], PQ] &)\)\)}], "/.", 
                                        RowBox[{
                                        RowBox[{"patternTest", "[", 
                                        RowBox[{
                                        RowBox[{"pattern", "[", 
                                        RowBox[{
                                        RowBox[{"dm_", "/;", 
                                        RowBox[{"MemberQ", "[", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{"d", ",", 
                                        InterpretationBox[\(p\^2\),
                                        PP], ",", 
                                        InterpretationBox[\(m\_1\),
                                        m1], ",", 
                                        InterpretationBox[\(m\_2\),
                                        m2], ",", 
                                        InterpretationBox[\(m\_3\),
                                        m3], ",", 
                                        InterpretationBox[\(m\_4\),
                                        m4]}], "}"}], ",", "dm"}], "]"}]}], 
                                        ",", \(blank[]\)}], "]"}], ",", "_"}],
                                         "]"}], "\[RuleDelayed]", \(pattern[
                                        dm, blank[]]\)}]}], 
                                        "/.", \({blank \[RuleDelayed] Blank, 
                                        pattern \[RuleDelayed] Pattern, 
                                        patternTest \[RuleDelayed] 
                                        PatternTest}\)}], "}"}]}], "/.", 
                                      RowBox[{\(cD[ijk__]\), "\[Rule]", 
                                        RowBox[{
                                        RowBox[{"Hold", "[", 
                                        RowBox[{
                                        StyleBox["Cayley",
                                        FontColor->RGBColor[1, 0, 0.4]], "[", 
                                        "ijk", "]"}], "]"}], 
                                        "[", \(addPeP[\(nutomass[Last[{t}]] /. 
                                        nmrel\) /. {nuu_, 
                                        ma_Symbol} \[RuleDelayed] ma]\), 
                                        "]"}]}]}], "/.", 
                                    RowBox[{\(cu[ijk__]\), "\[Rule]", 
                                      RowBox[{
                                        RowBox[{"Hold", "[", 
                                        RowBox[{
                                        StyleBox["Cayleyu",
                                        FontColor->RGBColor[0.8, 0.8, 0.4]], 
                                        "[", "ijk", "]"}], "]"}], 
                                        "[", \(addPeP[\(nutomass[Last[{t}]] /. 
                                        nmrel\) /. {nuu_, 
                                        ma_Symbol} \[RuleDelayed] ma]\), 
                                        "]"}]}]}], 
                                  "/.", \(Hold[CompoundExpression] \[Rule] 
                                    CompoundExpression\)}], 
                                "/.", \(Hold[Set] \[Rule] Set\)}], 
                              "/.", \(Hold[TComment] -> TComment\)}], 
                            "/.", \(addPeP -> Identity\)}], "/.", 
                          RowBox[{
                            RowBox[{"Hold", "[", 
                              RowBox[{
                                StyleBox["Cayleyu",
                                  FontColor->RGBColor[0.8, 0.8, 0.4]], "[", 
                                "ijk__", "]"}], "]"}], "\[Rule]", 
                            RowBox[{
                              StyleBox["Cayleyu",
                                FontColor->RGBColor[0.8, 0.8, 0.4]], "[", 
                              "ijk", "]"}]}]}], "/.", 
                        RowBox[{
                          RowBox[{"Hold", "[", 
                            RowBox[{
                              StyleBox["Cayley",
                                FontColor->RGBColor[1, 0, 0.4]], "[", "ijk__",
                               "]"}], "]"}], "\[Rule]", 
                          RowBox[{
                            StyleBox["Cayley",
                              FontColor->RGBColor[1, 0, 0.4]], "[", "ijk", 
                            "]"}]}]}], 
                      "/.", \({setdel \[RuleDelayed] SetDelayed}\)}], 
                    "/.", \(Identity -> identit\)}], 
                  "/.", \(identit[a_] -> a\)}]}]}], "]"}], "/;", 
          RowBox[{\(Head[mrel]\), "=!=", 
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["MakeFun",
            FontColor->RGBColor[1, 0.6, 0.6]], "[", 
          RowBox[{\(c_. \ TJI[t__] == rhs_\), ",", "eqn_String", ",", 
            RowBox[{
              StyleBox["IFF",
                FontColor->RGBColor[0.6, 0.4, 1]], "[", "conds_", "]"}], 
            ",", \(mrel_ : {}\)}], "]"}], ":=", 
        RowBox[{
          StyleBox["Block",
            FontSize->16,
            FontWeight->"Bold",
            FontColor->RGBColor[1, 0.2, 0.2]], "[", 
          RowBox[{\({nm, nmrel, \ result}\), ",", 
            
            RowBox[{\(\[ScriptCapitalC] = 1\), 
              ";", \(nmrel = Select[Flatten[{mrel}], FreeQ[#1, Factor] &]\), 
              ";", 
              RowBox[{"nmrel", "=", 
                RowBox[{"Join", "[", 
                  RowBox[{"nmrel", ",", 
                    RowBox[{"{", 
                      RowBox[{
                        RowBox[{\(m\_1\), "\[RuleDelayed]", 
                          InterpretationBox[\(m\_1\),
                            m1]}], ",", 
                        RowBox[{\(m\_2\), "\[RuleDelayed]", 
                          InterpretationBox[\(m\_2\),
                            m2]}], ",", 
                        RowBox[{\(m\_3\), "\[RuleDelayed]", 
                          InterpretationBox[\(m\_3\),
                            m3]}], ",", 
                        RowBox[{\(m\_4\), "\[RuleDelayed]", 
                          InterpretationBox[\(m\_4\),
                            m4]}], ",", 
                        RowBox[{\(\[CapitalSigma]\_i_\), "\[RuleDelayed]", 
                          RowBox[{
                            StyleBox["ToArgs",
                              FontColor->RGBColor[0.2, 0.6, 1]], 
                            "[", \(\[CapitalSigma]\_i\), "]"}]}]}], "}"}]}], 
                  "]"}]}], ";", "\n", "\t\t", 
              RowBox[{"result", " ", "=", " ", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{"HoldForm", "@@", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"setdel", "[", 
                                        
                                        RowBox[{\(addPeP[TJR @@ \(top /@ 
                                        nutomass[{tT = t}]\)] /. nmrel\), ",",
                                         
                                        RowBox[{\(Hold[Condition]\), "[", 
                                        
                                        RowBox[{\(\(Hold[
                                        CompoundExpression]\)[\(Hold[
                                        TComment]\)[eqn, \(\(\(addPeP[
                                        nutomass[TJR[t]]] /. TJR -> 
                                        TJIC\) /. {Pattern :> pat, Blank :> 
                                        blank}\) /. pat[PP, blank[]] :> PP\) /. 
                                        nmrel]\t, TJ = \(Collect[TT = Expand3[
                                        nutonand\[CapitalDelta]u[\(1\/c\) \
\((rhs /. TJI[te__] \[RuleDelayed] addPeP[nutomass[TJI[te]]])\)]], TJI[__], 
                                        maybeF[\((Collect[Numerator[#1], 
                                        cu[__], 
                                        Factor]/Collect[Denominator[#1], 
                                        cu[__], Factor] &)\) /@ 
                                        Factor[#1]] &] /. \[ScriptCapitalC] \
\[Rule] 1\) /. nmrel]\), ",", 
                                        RowBox[{
                                        "nutonand\[CapitalDelta]u", "[", 
                                        RowBox[{
                                        StyleBox["IFF",
                                        FontColor->RGBColor[0.6, 0.4, 1]], 
                                        "[", "conds", "]"}], "]"}]}], "]"}]}],
                                         "]"}], "/.", \(top[
                                        i_Integer] \[Rule] i\)}], 
                                        "/.", \(top \[RuleDelayed] \
\((patternTest[pattern[#1, blank[]], PQ] &)\)\)}], "/.", 
                                        RowBox[{
                                        RowBox[{"patternTest", "[", 
                                        RowBox[{
                                        RowBox[{"pattern", "[", 
                                        RowBox[{
                                        RowBox[{"dm_", "/;", 
                                        RowBox[{"MemberQ", "[", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{"d", ",", 
                                        InterpretationBox[\(p\^2\),
                                        PP], ",", 
                                        InterpretationBox[\(m\_1\),
                                        m1], ",", 
                                        InterpretationBox[\(m\_2\),
                                        m2], ",", 
                                        InterpretationBox[\(m\_3\),
                                        m3], ",", 
                                        InterpretationBox[\(m\_4\),
                                        m4]}], "}"}], ",", "dm"}], "]"}]}], 
                                        ",", \(blank[]\)}], "]"}], ",", "_"}],
                                         "]"}], "\[RuleDelayed]", \(pattern[
                                        dm, blank[]]\)}]}], 
                                        "/.", \({blank \[RuleDelayed] Blank, 
                                        pattern \[RuleDelayed] Pattern, 
                                        patternTest \[RuleDelayed] 
                                        PatternTest}\)}], "}"}]}], 
                                      "/.", \(HoldPattern[
                                        TA[aijk__]] \[Rule] \(\(Hold[TA]\)[
                                        aijk]\)[
                                        addPeP[\(nutomass[Last[{t}]] /. 
                                        nmrel\) /. {nuu_, ma_} \[RuleDelayed] 
                                        ma]]\)}], "/.", 
                                    RowBox[{\(cD[ijk__]\), "\[Rule]", 
                                      RowBox[{
                                        RowBox[{"Hold", "[", 
                                        RowBox[{
                                        StyleBox["Cayley",
                                        FontColor->RGBColor[1, 0, 0.4]], "[", 
                                        "ijk", "]"}], "]"}], 
                                        "[", \(addPeP[\(nutomass[Last[{t}]] /. 
                                        nmrel\) /. {nuu_, 
                                        ma_Symbol} \[RuleDelayed] ma]\), 
                                        "]"}]}]}], "/.", 
                                  RowBox[{\(cu[ijk__]\), "\[Rule]", 
                                    RowBox[{
                                      RowBox[{"Hold", "[", 
                                        RowBox[{
                                        StyleBox["Cayleyu",
                                        FontColor->RGBColor[0.8, 0.8, 0.4]], 
                                        "[", "ijk", "]"}], "]"}], 
                                      "[", \(addPeP[\(nutomass[Last[{t}]] /. 
                                        nmrel\) /. {nuu_, 
                                        ma_Symbol} \[RuleDelayed] ma]\), 
                                      "]"}]}]}], 
                                "/.", \(Hold[CompoundExpression] \[Rule] 
                                  CompoundExpression\)}], "/.", 
                              RowBox[{
                                RowBox[{\(Hold[Condition]\), "[", 
                                  RowBox[{"a_", ",", 
                                    RowBox[{
                                      StyleBox["IFF",
                                        FontColor->RGBColor[0.6, 0.4, 1]], 
                                      "[", "b_", "]"}]}], "]"}], 
                                "\[Rule]", \(a /; b\)}]}], 
                            "/.", \(Hold[Set] \[Rule] Set\)}], 
                          "/.", \(Hold[TComment] -> TComment\)}], "/.", 
                        RowBox[{
                          RowBox[{"Hold", "[", 
                            RowBox[{
                              StyleBox["Cayleyu",
                                FontColor->RGBColor[0.8, 0.8, 0.4]], "[", 
                              "ijk__", "]"}], "]"}], "\[Rule]", 
                          RowBox[{
                            StyleBox["Cayleyu",
                              FontColor->RGBColor[0.8, 0.8, 0.4]], "[", "ijk",
                             "]"}]}]}], "/.", 
                      RowBox[{
                        RowBox[{"Hold", "[", 
                          RowBox[{
                            StyleBox["Cayley",
                              FontColor->RGBColor[1, 0, 0.4]], "[", "ijk__", 
                            "]"}], "]"}], "\[Rule]", 
                        RowBox[{
                          StyleBox["Cayley",
                            FontColor->RGBColor[1, 0, 0.4]], "[", "ijk", 
                          "]"}]}]}], "/.", \(Hold[TA] \[Rule] TA\)}], 
                  "/.", \({setdel \[RuleDelayed] SetDelayed}\)}]}], 
              ";", \(\[ScriptCapitalC] =  . \), ";", " ", "result"}]}], 
          "]"}]}], ";"}]], "Input"],

Cell[BoxData[
    \(\(SetAttributes[paTT, HoldFirst];\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{
          RowBox[{
            RowBox[{"c_.", " ", 
              RowBox[{
                StyleBox["TKI",
                  FontColor->RGBColor[0.2, 0.4, 0.8]], "[", "t__", "]"}]}], "==",
             "rhs_"}], ",", "eqn_String", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", "conds_", "]"}], 
          ",", \(mrel_ : {}\)}], "]"}], ":=", 
      " ", \(\(\(\(MakeFun[c\ TJI[t] == rhs /. TKI -> TJI, eqn, IFF[conds], 
                mrel] /. {PP :> 0, Sqrt[PP] :> 0, Pattern :> paTT}\) /. 
            paTT[0, _] -> 0\) /. paTT -> Pattern\) /. 
        TJIC[d_, li_List] :> TJIC[d, 0, li]\)}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["MakeFun",
            FontColor->RGBColor[1, 0.6, 0.6]], "[", 
          RowBox[{
            RowBox[{
              RowBox[{"c_.", " ", 
                RowBox[{
                  StyleBox["TBI",
                    FontColor->RGBColor[0.2, 0.4, 0.8]], "[", "t__", "]"}]}], 
              "==", "rhs_"}], ",", "eqn_String", ",", 
            RowBox[{
              StyleBox["IFF",
                FontColor->RGBColor[0.6, 0.4, 1]], "[", "conds_", "]"}], 
            ",", \(mrel_ : {}\)}], "]"}], ":=", 
        " ", \(MakeFun[c\ TJI[t] == rhs /. TBI -> TJI, eqn, IFF[conds], 
            mrel] /. {\n\t\t\tTJI :> TBI, TJR :> TBR, TJIC :> TBIC}\)}], 
      ";"}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["MakeFun",
            FontColor->RGBColor[1, 0.6, 0.6]], "[", 
          RowBox[{
            RowBox[{
              RowBox[{"c_.", " ", 
                RowBox[{
                  StyleBox["TAI",
                    FontColor->RGBColor[0.2, 0.4, 0.8]], "[", "t__", "]"}]}], 
              "==", "rhs_"}], ",", "eqn_String", ",", 
            RowBox[{
              StyleBox["IFF",
                FontColor->RGBColor[0.6, 0.4, 1]], "[", "conds_", "]"}], 
            ",", \(mrel_ : {}\)}], "]"}], ":=", 
        " ", \(MakeFun[c\ TJI[t] == rhs /. TAI -> TJI, eqn, IFF[conds], 
            mrel] /. {\n\t\t\tTJI :> TAI, TJR :> TAR, TJIC :> TAIC}\)}], 
      ";"}]], "Input"],

Cell[CellGroupData[{

Cell["Interchange", "Subsubsection",
  CellTags->"T1.5.1.1.1"],

Cell[BoxData[
    RowBox[{\(Interchange[z_, i_ \[LeftRightArrow] j_]\), ":=", 
      RowBox[{\(\[Nu]explicit[
            z] /. {\[Nu]\_i :> \[Nu]\_j, \[Nu]\_j :> \[Nu]\_i, m\_i :> m\_j, 
            m\_j :> m\_i, \[CapitalDelta]\_ij__ :> \((\[CapitalDelta]\_ij /. \
{i :> j, j :> i})\), 
            u\_ij__ :> \((u\_ij /. {i :> j, 
                    j :> i})\), \n\t\th\_ij__ :> \((h\_ij /. {i :> j, 
                    j :> i})\), \[Phi]\_ij__ :> \((\[Phi]\_ij /. {i :> j, 
                    j :> i})\), \[Rho]\_ij__ :> \((\[Rho]\_ij /. {i :> j, 
                    j :> i})\), \[Sigma]\_ij__ :> \((\[Sigma]\_ij /. {i :> j, 
                    j :> i})\), D\_ij__ :> \((D\_ij /. {i :> j, j :> i})\)}\),
         "/.", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["TFI",
                  FontColor->RGBColor[1, 0.6, 0]], "[", \(depp__, args_List\),
                 "]"}], ":>", 
              RowBox[{
                RowBox[{
                  StyleBox["TFI",
                    FontColor->RGBColor[1, 0.6, 0]], "[", \(depp, 
                  Sort[args]\), "]"}], "/;", 
                "\[InvisibleSpace]", \(! \((OrderedQ[args])\)\)}]}], ",", 
            "\n", "\t", 
            RowBox[{
              RowBox[{
                StyleBox["TVI",
                  FontColor->RGBColor[1, 0.6, 0]], "[", \(depp__, args_List\),
                 "]"}], ":>", 
              RowBox[{
                RowBox[{
                  StyleBox["TVI",
                    FontColor->RGBColor[1, 0.6, 0]], "[", \(depp, 
                  Sort[args]\), "]"}], "/;", 
                "\[InvisibleSpace]", \(! \((OrderedQ[args])\)\)}]}], ",", 
            "\n", "\t", 
            RowBox[{
              RowBox[{
                StyleBox["TJI",
                  FontColor->RGBColor[1, 0.6, 0]], "[", \(depp__, args_List\),
                 "]"}], ":>", 
              RowBox[{
                RowBox[{
                  StyleBox["TJI",
                    FontColor->RGBColor[1, 0.6, 0]], "[", \(depp, 
                  Sort[args]\), "]"}], "/;", 
                "\[InvisibleSpace]", \(! \((OrderedQ[args])\)\)}]}], ",", 
            "\n", "\t\t\t", 
            RowBox[{
              RowBox[{
                StyleBox["TBI",
                  FontColor->RGBColor[1, 0.6, 0]], "[", \(depp__, args_List\),
                 "]"}], ":>", 
              RowBox[{
                RowBox[{
                  StyleBox["TBI",
                    FontColor->RGBColor[1, 0.6, 0]], "[", \(depp, 
                  Sort[args]\), "]"}], "/;", 
                "\[InvisibleSpace]", \(! \((OrderedQ[args])\)\)}]}]}], 
          "}"}]}]}]], "Input"],

Cell[BoxData[
    \(\(Interchange[z_, i_ \[LeftRightArrow] j_, vw__] := 
        Interchange[Interchange[z, i \[LeftRightArrow] j], vw];\)\)], "Input"],

Cell[BoxData[
    \(\(Interchange[z_, {i_ \[LeftRightArrow] j_}] := 
        Interchange[Interchange[z, i \[LeftRightArrow] j]];\)\)], "Input"],

Cell[BoxData[
    \(\(Interchange[z_, {i_ \[LeftRightArrow] j_, vw__}] := 
        Interchange[Interchange[z, i \[LeftRightArrow] j], vw];\)\)], "Input"],

Cell[BoxData[
    \(Interchange[
      test[\[CapitalDelta]\_\(x, b, y\), \[Nu]\_x, \[Nu]\_y, \[Nu]\_a, \
\[Nu]\_b, m\_x], \ x \[LeftRightArrow] y, a \[LeftRightArrow] b]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[Nu]explicit", "Subsection",
  CellTags->"T1.5.2.1"],

Cell[BoxData[
    \(\[Nu]explicit[
        z_] := \(z /. \[CapitalSigma]\_i_ :> \((Expand[
                3\ d\  - 2\  - 
                  2\ \(\[Sum]\_\(j = 1\)\%i \[Nu]\_j\)])\)\) /. \n\t{\t\
\[Sigma]\_\(i_, j_, k_\) :> \(-\(1\/4\)\) \((d - \[Nu]\_i - 
                    2  \[Nu]\_j)\) \[Phi]\_\(i, j, k\) - \(1\/4\) \((d - 
                    2  \[Nu]\_i - \[Nu]\_j)\) \[Phi]\_\(j, i, k\) - \n\t\t\t\t\
\t\(1\/4\) \((2  d - 2  \[Nu]\_i - 2  \[Nu]\_j - \[Nu]\_k - 
                    1)\) \[Phi]\_\(k, i, j\), \n\t\t\t\
h\_\(\(i_\)\(,\)\(j_\)\(,\)\(k_\)\(\ \)\) :> \n\t\t\t\t\(-\(1\/2\)\) \((d - 
                    2  \[Nu]\_j - \[Nu]\_k)\) \(m\_k\^2\) \[Phi]\_\(i, j, k\) \
- \(1\/2\) \((2  d - \[Nu]\_i - 2  \[Nu]\_j - 2  \[Nu]\_k - 
                    1)\) \(m\_i\^2\) \[Phi]\_\(k, i, j\) + \n\t\t\t\t\t\((d - \
\[Nu]\_j - 2\ \[Nu]\_k)\) \[Rho]\_\(i, j, k\), \n
          S\_\(\(i_\)\(,\)\(j_\)\(,\)\(k_\)\(\ \)\) :> \n\t\t\t\t\(-\((d - 
                      2  \[Nu]\_j - \[Nu]\_k)\)\) \(m\_k\^2\) \[Phi]\_\(j, i, \
k\)\  - \((d - \[Nu]\_j - 
                    2  \[Nu]\_k)\) \(m\_j\^2\) \[Phi]\_\(k, i, j\) + \n\t\t\t\
\t\t2 \((2  d - \[Nu]\_i - 2  \[Nu]\_j - 2  \[Nu]\_k - 
                    1)\) \[Rho]\_\(i, j, k\)}\)], "Input"],

Cell[CellGroupData[{

Cell["TA", "Subsubsection",
  CellTags->"T1.5.2.1.1"],

Cell[BoxData[
    \(MakeBoxes[\(TA[a_, d___Symbol, ijk___Integer]\)[__], fmt_] := 
      SubscriptBox[a, RowBox[{ijk}]]\)], "Input"],

Cell[BoxData[
    \(MakeBoxes[\(TA[a_, d___Symbol, ijk___Integer, ___Symbol]\)[__], fmt_] := 
      SubscriptBox[a, RowBox[{ijk}]]\)], "Input"],

Cell[BoxData[
    \(\(\(TA[args__]\)[
          mar_List] := \((\(TA[args]\)[mar] = \(ta[args]\)[
              mar])\);\)\)], "Input"],

Cell[TextData[{
  "Assume that the last argument of {em__} is always p =",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          RowBox[{" ", 
            FormBox[\(p\^2\),
              "TraditionalForm"]}]], TraditionalForm]]],
  "."
}], "Text"],

Cell["(72)", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\(ta[D, i_Integer, j_Integer, k_Integer]\)[{em__}]\), ":=", 
        RowBox[{"With", "[", 
          
          RowBox[{\({q = Last[{em}], 
              mi = {em}\[LeftDoubleBracket]i\[RightDoubleBracket], 
              mj = {em}\[LeftDoubleBracket]j\[RightDoubleBracket], 
              mk = {em}\[LeftDoubleBracket]k\[RightDoubleBracket]}\), ",", 
            RowBox[{"Factor", "[", 
              
              RowBox[{\(q\^8\), "-", \(4\ q\^6\ \((mi\^2 + mj\^2 + mk\^2)\)\),
                 "+", \(q\^4\ \((6\ \((mi\^4 + mj\^4 + mk\^4)\) + 
                      4\ \((mi\^2\ mj\^2 + mk\^2\ mi\^2 + 
                            mk\^2\ mj\^2)\))\)\), 
                "-", \(4\ q\^2\ \((mi\^6 + mj\^6 + mk\^6 - 
                      mi\^2\ \((mj\^4 + mk\^4)\) - 
                      mj\^2\ \((mi\^4 + mk\^4)\) - 
                      mk\^2\ \((mi\^4 + mj\^4)\) + 
                      10\ mi\^2\ mj\^2\ mk\^2)\)\), "+", 
                SuperscriptBox[
                  RowBox[{
                    RowBox[{
                      StyleBox["Cayley",
                        FontColor->RGBColor[1, 0, 0.4]], "[", \(i, j, k\), 
                      "]"}], "[", \({em}\), "]"}], "2"]}], "]"}]}], "]"}]}], 
      ";"}]], "Input"],

Cell["(73)", "Text"],

Cell[BoxData[
    \(\(\(ta[\[Rho], i_Integer, j_Integer, k_Integer]\)[{em__}] := 
        With[{q = Last[{em}], 
            mi = {em}\[LeftDoubleBracket]i\[RightDoubleBracket], 
            mj = {em}\[LeftDoubleBracket]j\[RightDoubleBracket], 
            mk = {em}\[LeftDoubleBracket]k\[RightDoubleBracket]}, 
          Factor[\(-q\^6\) + 3\ q\^4\ \((mi\^2 + mj\^2 + mk\^2)\) - 
              q\^2\ \((3\ \((mi\^4 + mj\^4 + mk\^4)\) + 
                    2\ \((mi\^2\ mj\^2 + mk\^2\ mi\^2 + 
                          mk\^2\ mj\^2)\))\) + \ \((mi\^6 + mj\^6 + mk\^6 - 
                  mi\^2\ \((mj\^4 + mk\^4)\) - mj\^2\ \((mi\^4 + mk\^4)\) - 
                  mk\^2\ \((mi\^4 + mj\^4)\) + 
                  10\ mi\^2\ mj\^2\ mk\^2)\)]];\)\)], "Input"],

Cell["(74)", "Text"],

Cell[BoxData[
    \(\(\(ta[\[Phi], i_Integer, j_Integer, k_Integer]\)[{em__}] := 
        With[{q = Last[{em}], 
            mi = {em}\[LeftDoubleBracket]i\[RightDoubleBracket], 
            mj = {em}\[LeftDoubleBracket]j\[RightDoubleBracket], 
            mk = {em}\[LeftDoubleBracket]k\[RightDoubleBracket]}, 
          4  Factor[
              q\^4\  + 
                2 \( q\^2\) \((mi\^2 - mj\^2 - 
                      mk\^2)\) + \((mj\^2 - mk\^2)\)\^2 + \(mi\^2\) \((2 
                         mj\^2 + 2  mk\^2 - 3  mi\^2)\)]];\)\)], "Input"],

Cell["(75)", "Text"],

Cell[BoxData[
    \(\(\(ta[\[Sigma], d_, i_Integer, j_Integer, 
            k_Integer, \[Nu]i_Integer, \[Nu]j_Integer, \
\[Nu]k_Integer]\)[{em__}] := 
        Factor[\(\(-\(1\/4\)\) \((d - \[Nu]i - 2  \[Nu]j)\) \(TA[\[Phi], i, 
                    j, k]\)[{em}]\)\ \(-\(\(1\/4\) \((d - 
                      2  \[Nu]i - \[Nu]j)\) \(TA[\[Phi], j, i, 
                      k]\)[{em}]\)\) - \(\(1\/4\) \((2  d - 2  \[Nu]i - 
                  2  \[Nu]j - \[Nu]k - 1)\) \(\(TA[\[Phi], k, i, 
                  j]\)[{em}]\)\(\ \)\)\ \ ];\)\)], "Input"],

Cell["(76)", "Text"],

Cell[BoxData[
    \(\(\(ta[h, d_, i_Integer, j_Integer, 
            k_Integer, \[Nu]i_Integer, \[Nu]j_Integer, \
\[Nu]k_Integer]\)[{em__}] := \n\t
        With[{q = Last[{em}], 
            mi = {em}\[LeftDoubleBracket]i\[RightDoubleBracket], 
            mj = {em}\[LeftDoubleBracket]j\[RightDoubleBracket], 
            mk = {em}\[LeftDoubleBracket]k\[RightDoubleBracket]}, 
          Factor[\(-\(1\/2\)\) \((d - 
                    2  \[Nu]j - \[Nu]k)\) \(mk\^2\) \(TA[\[Phi], i, j, 
                    k]\)[{em}] - \(1\/2\) \((2  d - \[Nu]i - 2  \[Nu]j - 
                    2  \[Nu]k - 1)\) \(mi\^2\) \(TA[\[Phi], k, i, 
                    j]\)[{em}] + \(\((d - \[Nu]j - 
                    2\ \[Nu]k)\) \(\(TA[\[Rho], i, j, 
                    k]\)[{em}]\)\(\ \)\)\ \ ]];\)\)], "Input"],

Cell["(79)", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\(ta[S, d_, i_Integer, j_Integer, 
            k_Integer, \[Nu]i_Integer, \[Nu]j_Integer, \
\[Nu]k_Integer]\)[{em__}]\), ":=", "\n", "\t\t", 
        RowBox[{"With", "[", 
          
          RowBox[{\({q = Last[{em}], 
              mi = {em}\[LeftDoubleBracket]i\[RightDoubleBracket], 
              mj = {em}\[LeftDoubleBracket]j\[RightDoubleBracket], 
              mk = {em}\[LeftDoubleBracket]k\[RightDoubleBracket]}\), ",", 
            RowBox[{"Factor", "[", 
              
              RowBox[{\(\(-\((d - 
                        2  \[Nu]j - \[Nu]k)\)\) \(mk\^2\) \(TA[\[Phi], j, i, 
                      k]\)[{em}]\), " ", "-", 
                
                RowBox[{\((d - \[Nu]j - 
                      2  \[Nu]k)\), \(mj\^2\), \(\(TA[\[Phi], k, i, 
                      j]\)[{em}]\), "test", "\n", 
                  FormBox["test",
                    "TraditionalForm"], 
                  "2", \((2  d - \[Nu]i - 2  \[Nu]j - 2  \[Nu]k - 
                      1)\), \(\(TA[\[Rho], i, j, k]\)[{em}]\)}]}], "   ", 
              "]"}]}], "]"}]}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CheckRecursion", "Subsection",
  CellTags->"T1.5.3.1"],

Cell["\<\
The following functions check the recurrence relations for J and V \
(using the final form as generated by MakeFun) via their Mellin-Integral \
Kernels.\
\>", "Text"],

Cell["\<\
This test is applicable in the general case  and if some of the 
masses vanish, but not for other special cases !!!\
\>", "Text"],

Cell[CellGroupData[{

Cell["CheckTVIRecursion", "Subsubsection",
  CellTags->"T1.5.3.1.1"],

Cell[BoxData[
    \(\(TVIKernel[d_, PP, \ 
          lis_] := \n\(\((\(-PP\))\)\^\(d - n1 - n2 - n3 - 
                n4\)\) \(\((m1\^2\/\(-PP\))\)\^s1\) \
\(\((m2\^2\/\(-PP\))\)\^s2\) \(\((m3\^2\/\(-PP\))\)\^s3\) \
\((m4\^2\/\(-PP\))\)\^s4*
          TVIpsi\ [
            d, \ \((lis /. {m1 -> s1, m2 -> s2, m3 -> s3, 
                  m4 -> s4})\)];\)\)], "Input"],

Cell[BoxData[
    \(\(TVIPsi[
          d_, \n\t{{n1_, \ s1_}, \ {n2_, s2_}, {n3_, s3_}, {n4_, 
              s4_}}] := \(\((\(-1\))\)\^\(n1 + n2 + n3 + n4 + 
                1\)\) \(\(gamma[\(-s1\)] gamma[d/2 - n1 - s1]\)\/gamma[
                n1]\) \(\(gamma[\(-s2\)] gamma[d/2 - n2 - s2]\)\/gamma[
                n2]\) \(\(gamma[\(-s3\)] gamma[d/2 - n3 - s3]\)\/gamma[
                n3]\) \(\(gamma[\(-s4\)] gamma[n4 + s4]\)\/gamma[n4]\) 
          gamma[n1 + n2 + n3 + n4 + s1 + s2 + s3 + s4 - d]/
            gamma[3  d/2 - n1 - n2 - n3 - n4 - s1 - s2 - s3 - s4] \(gamma[
                n1 + n3 + s1 + s3 - d/2]\/gamma[
                n1 + n3 + n4 + s1 + s3 + s4 - d/2]\) 
          gamma[d - n1 - n3 - n4 - s1 - s3 - s4]\/gamma[d - n1 - n3 - s1 - \
s3];\)\)], "Input"],

Cell[BoxData[
    \(CheckTVIRecursion[expr_] := \ 
      If[\ $CheckRecursion === True, \n\t
        Block[{rel, kern, \ nkern}, \n
          rel = \((\((Extract[
                    expr /. TVIC -> TVIkernel, {1, 2, 1, 1, 2}])\) - 
                Extract[expr /. TVI -> TVIkernel, {1, 2, 1, 2}])\); \n
          If[\ {TVIkernel} === 
              Union[Head /@ 
                  Cases[rel, ff_[__] /; Context[ff] =!= "\<System`\>", 
                    4]], \t\n
            rel = Collect[Numerator[Together[rel]], \ TVI[__], Factor]; \n
            kern = rel /. TVIkernel -> TVIKernel; \n
            kern = kern /. {PP -> \(-1\), m1 -> Sqrt[z1], m2 -> Sqrt[z2], 
                  m3 -> Sqrt[z3], m4 -> Sqrt[z4]}; \n
            kern = PowerExpand[kern]; \nkern = Expand[kern]; \n
            kern = kern /. {\(z1\^\(s1 + w1_. \)\) \(z2\^\(s2 + 
                            w2_. \)\) \(z3\^\(s3 + w3_. \)\) \(z4\^\(s4 + 
                            w4_. \)\) 
                      fac_ :> \((fac /. {s1 -> s1 - w1, s2 -> s2 - w2, 
                          s3 -> s3 - w3, s4 -> s4 - w4})\)}\ ; \n
            kern = \(\(kern /. 
                    TVIpsi -> TVIPsi\) /. {gamma[zz_] :> 
                      gamma[Expand[zz]]}\) /. {gamma[zz_ + nn_Integer] :> 
                    gamma[zz] Pochhammer[zz, nn]}; \n\t\t\t\tKERN = kern; \n
            kern = kern /. {gamma[zz_] :> 1}; \n
            kern = \(kern /. {\((\(-1\))\)\^\(nn_ + ww_Integer\) :> \
\((\(-1\))\)\^ww}\) /. {\((\(-1\))\)\^nn_ :> 1}; \n
            nkern = Table[\n\t\t\tkern /. 
                  Thread[{d, \ n1, \ n2, \ n3, n4, s1, s2, \ s3, s4} -> 
                      Table[Random[], {9}]], {3}]; \n
            nkern\ \ , \n\t\tPrint["\<Matching Error\>"]\ ]\ ], \n\t\t\
If[$Notebooks, Print["\<Off\>"]]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CheckTJIRecursion", "Subsubsection",
  CellTags->"T1.5.3.2.1"],

Cell[BoxData[
    \(\(TJIKernel[d_, PP, \ 
          lis_] := \n\(\((\(-PP\))\)\^\(d - n1 - n2 - 
                n3\)\) \(\((m1\^2\/\(-PP\))\)\^s1\) \
\(\((m2\^2\/\(-PP\))\)\^s2\) \((m3\^2\/\(-PP\))\)\^s3*
          TJIpsi\ [
            d, \ \((lis /. {m1 -> s1, m2 -> s2, m3 -> s3})\)];\)\)], "Input"],

Cell[BoxData[
    \(TJIPsi\ [d_, {{n1_, \ s1_}, \ {n2_, s2_}, {n3_, s3_}}] := 
      Evaluate[TVIPsi[d, \n\t{{n1, \ s1}, \ {n2, s2}, {n3, s3}, {0, 0}}]/
          gamma[0]]\)], "Input"],

Cell[BoxData[
    \(\(Clear[CheckTJIRecursion];\)\)], "Input"],

Cell[BoxData[
    \(CheckTJIRecursion[expr_] := \ 
      If[\ $CheckRecursion === True, \n\t
        Block[{rel, kern, nkern}, \n
          rel = \((\((Extract[
                    expr /. TJIC -> TJIkernel, {1, 2, 1, 1, 2}])\) - 
                Extract[
                  expr /. TJI -> TJIkernel, {1, 2, 1, 2}])\); \n\t\t\tREL = 
            rel; \t\t\t\n
          If[{TJIkernel} === 
              Union[Head /@ 
                  Cases[rel, ff_[__] /; Context[ff] =!= "\<System`\>", 
                    4]]\ , \t\t\t\n
            rel = Collect[Numerator[Together[rel]], \ TJI[__], Factor]; \n
            kern = rel /. TJIkernel -> TJIKernel; \n
            kern = kern /. {PP -> \(-1\), m1 -> Sqrt[z1], m2 -> Sqrt[z2], 
                  m3 -> Sqrt[z3]}; \nkern = PowerExpand[kern]; \n
            kern = Expand[kern]; \n
            kern = kern /. {\(z1\^\(s1 + w1_. \)\) \(z2\^\(s2 + 
                            w2_. \)\) \(z3\^\(s3 + w3_. \)\) 
                      fac_ :> \((fac /. {s1 -> s1 - w1, s2 -> s2 - w2, 
                          s3 -> s3 - w3})\)}; \ \n
            kern = \(\(kern /. 
                    TJIpsi -> TJIPsi\) /. {gamma[zz_] :> 
                      gamma[Expand[zz]]}\) /. {gamma[zz_ + nn_Integer] :> 
                    gamma[zz] Pochhammer[zz, nn]}; \n\ \ \ \ \ \ KERN = 
              kern; \nkern = kern /. {gamma[zz_] :> 1}; \n
            kern = \(kern /. {\((\(-1\))\)\^\(nn_ + ww_Integer\) :> \
\((\(-1\))\)\^ww}\) /. {\((\(-1\))\)\^nn_ :> 1}; \n
            nkern = Table[\n\t\t\tkern /. 
                  Thread[{d, \ n1, \ n2, \ n3, s1, s2, \ s3} -> 
                      Table[Random[], {7}]], {3}]; \n
            nkern\ \ , \n\t\tPrint["\<Matching Error\>"]\ ]\ ], \n\t\t\
If[$Notebooks, Print["\<Off\>"]]]\)], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Recurrence Relations Input and Recursion Function Generation", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.6.1"],

Cell[BoxData[
    \(TFR[d_, pp_, {{n1_, m1_}, {n2_, m2_}, {0, 0}, {0, 0}, {0, 0}}] := 
      TAI[d, pp, {{n1, m1}}]\ TAI[d, {{n2, m2}}]\)], "Input"],

Cell[TextData[{
  "Most ",
  Cell[BoxData[
      \(TraditionalForm\`e\_\(\(...\)\(\ \)\)\)]],
  "equations below were entered by the palettes which show up when \
$PutPalettes is set to True.\nExamples of alternative (hand) input are  (50) \
, (201) -- (205)."
}], "Text"],

Cell[CellGroupData[{

Cell["Input (35)", "Subsection",
  CellTags->"T1.6.1.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_35\), "=", "\n", 
        RowBox[{
          RowBox[{"2", \(\[Nu]\_1\), "\[ScriptCapitalC]", " ", 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}], "\[Equal]", " ", 
          RowBox[{
            RowBox[{"(", 
              
              RowBox[{\(\((d - 
                      2  \[Nu]\_1 - \[Nu]\_3 - \[Nu]\_5)\) \[CapitalDelta]\_1\
\), "+", 
                RowBox[{\(\[CapitalDelta]\_\(3, 4, 5\)\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_5\), 
                        InterpretationBox[
                          StyleBox[\(5\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 5, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(2\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 2, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(1\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 1, "-"],
                              Editable->True]}], ")"}]}], "-", 
                      RowBox[{\(\[Nu]\_3\), 
                        InterpretationBox[
                          StyleBox[\(3\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(1\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "-"],
                          Editable->True]}]}], ")"}]}], "+", 
                RowBox[{\(\[CapitalDelta]\_2\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_1\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(5\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 5, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(2\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 2, "-"],
                              Editable->True]}], ")"}]}], "+", 
                      RowBox[{\(\[Nu]\_3\), 
                        InterpretationBox[
                          StyleBox[\(3\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(5\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 5, "-"]], "-", 
                            InterpretationBox[
                              StyleBox[\(4\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 4, "-"],
                              Editable->True]}], ")"}]}], "+", \(\[Nu]\_5\), 
                      "-", \(\[Nu]\_1\)}], ")"}]}], "+", "\n", "\t\t\t\t", 
                RowBox[{\(\[CapitalDelta]\_6\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_1\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(3\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "-"],
                          Editable->True]}], "+", 
                      RowBox[{\(\[Nu]\_5\), 
                        InterpretationBox[
                          StyleBox[\(5\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 5, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(3\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 3, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(4\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 4, "-"],
                              Editable->True]}], ")"}]}], "+", \(\[Nu]\_3\), 
                      "-", \(\[Nu]\_1\)}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_35 = OperatorApplyF[e\_35]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (35)", "Subsection",
  CellTags->"T1.6.2.1"],

Cell[BoxData[
    \(h\_351 = s\_35 /. \[Nu]\_1 -> \((\[Nu]\_1 - 1)\)\)], "Input"],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`1\^\(\(+\)\(\ \)\)\)]],
  " (35_1)"
}], "Subsubsection",
  CellTags->"T1.6.2.1.1"],

Cell[BoxData[
    RowBox[{\(f\_351\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_351\), ",", "\"\<(35_1)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{\(\[Nu]\_1 > 1\), "&&", 
              RowBox[{
                RowBox[{
                  StyleBox["Cayley",
                    FontColor->RGBColor[1, 0, 0.4]], "[", 
                  RowBox[{
                    InterpretationBox[\(m\_1\),
                      m1], ",", 
                    InterpretationBox[\(m\_2\),
                      m2], ",", 
                    InterpretationBox[\(m\_3\),
                      m3], ",", 
                    InterpretationBox[\(m\_4\),
                      m4], ",", 
                    InterpretationBox[\(m\_5\),
                      m5], ",", 
                    SqrtBox[
                      InterpretationBox[\(p\^2\),
                        PP]]}], "]"}], "=!=", "0"}]}], "]"}]}], 
        "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`2\^\(\(+\)\(\ \)\)\)]],
  " (35_2)"
}], "Subsubsection",
  CellTags->"T1.6.2.2.1"],

Cell[BoxData[
    RowBox[{\(f\_352\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(Interchange[h\_351, 1 \[LeftRightArrow] 2, 
            3 \[LeftRightArrow] 4]\), ",", "\"\<(35_2)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{\(\[Nu]\_2 > 1\), "&&", 
              RowBox[{
                RowBox[{
                  StyleBox["Cayley",
                    FontColor->RGBColor[1, 0, 0.4]], "[", 
                  RowBox[{
                    InterpretationBox[\(m\_1\),
                      m1], ",", 
                    InterpretationBox[\(m\_2\),
                      m2], ",", 
                    InterpretationBox[\(m\_3\),
                      m3], ",", 
                    InterpretationBox[\(m\_4\),
                      m4], ",", 
                    InterpretationBox[\(m\_5\),
                      m5], ",", 
                    SqrtBox[
                      InterpretationBox[\(p\^2\),
                        PP]]}], "]"}], "=!=", "0"}]}], "]"}]}], 
        "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`3\^\(\(+\)\(\ \)\)\)]],
  " (35_3)"
}], "Subsubsection",
  CellTags->"T1.6.2.3.1"],

Cell[BoxData[
    RowBox[{\(f\_353\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(Interchange[h\_351, 1 \[LeftRightArrow] 3, 
            2 \[LeftRightArrow] 4]\), ",", "\"\<(35_3)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{\(\[Nu]\_3 > 1\), "&&", 
              RowBox[{
                RowBox[{
                  StyleBox["Cayley",
                    FontColor->RGBColor[1, 0, 0.4]], "[", 
                  RowBox[{
                    InterpretationBox[\(m\_1\),
                      m1], ",", 
                    InterpretationBox[\(m\_2\),
                      m2], ",", 
                    InterpretationBox[\(m\_3\),
                      m3], ",", 
                    InterpretationBox[\(m\_4\),
                      m4], ",", 
                    InterpretationBox[\(m\_5\),
                      m5], ",", 
                    SqrtBox[
                      InterpretationBox[\(p\^2\),
                        PP]]}], "]"}], "=!=", "0"}]}], "]"}]}], 
        "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`4\^\(\(+\)\(\ \)\)\)]],
  " (35_4)"
}], "Subsubsection",
  CellTags->"T1.6.2.4.1"],

Cell[BoxData[
    RowBox[{\(f\_354\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(Interchange[h\_351, 1 \[LeftRightArrow] 4, 
            2 \[LeftRightArrow] 3]\), ",", "\"\<(35_4)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{\(\[Nu]\_4 > 1\), "&&", 
              RowBox[{
                RowBox[{
                  StyleBox["Cayley",
                    FontColor->RGBColor[1, 0, 0.4]], "[", 
                  RowBox[{
                    InterpretationBox[\(m\_1\),
                      m1], ",", 
                    InterpretationBox[\(m\_2\),
                      m2], ",", 
                    InterpretationBox[\(m\_3\),
                      m3], ",", 
                    InterpretationBox[\(m\_4\),
                      m4], ",", 
                    InterpretationBox[\(m\_5\),
                      m5], ",", 
                    SqrtBox[
                      InterpretationBox[\(p\^2\),
                        PP]]}], "]"}], "=!=", "0"}]}], "]"}]}], 
        "]"}]}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (3501)", "Subsection",
  CellTags->"T1.6.3.1"],

Cell[BoxData[
    \(Cayley[m1, m5, m5, m4, m5, m5] // Factor\)], "Input"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`m\_1 = 0\ \ ; \ \ m\_2 = \(m\_3 = m\_5\); \ \ \ p\^2 = 
      m\_5\%2\)]]], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_3501\), "=", 
        RowBox[{
          RowBox[{\((d - 2  \[Nu]\_1 - \[Nu]\_3 - \[Nu]\_5)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", " ", 
              RowBox[{
                RowBox[{\(\[Nu]\_5\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True]}], ")"}], 
                  InterpretationBox[
                    StyleBox[\(5\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 5, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(1\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "-"],
                    Editable->True], 
                  InterpretationBox[
                    RowBox[{
                      StyleBox[\(3\^+\),
                        FontWeight->"Bold"], " "}],
                    Schiebe[ 3, "+"],
                    Editable->True]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_3501 = OperatorApplyF[e\_3501]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "MakeFun (3501) \[CapitalDelta]=0 ",
  Cell[BoxData[
      \(TraditionalForm\`\((p\^2 = m\^2)\)\)]]
}], "Subsection",
  CellTags->"T1.6.4.1"],

Cell[BoxData[
    \(h\_3501 = s\_3501\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_3501\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(s\_3501\), ",", "\"\<(3501)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", \(PP === m5^2\), "]"}], 
          ",", \({m1 :> 0, m2 :> m5, m3 :> m5}\)}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (3502)", "Subsection",
  CellTags->"T1.6.5.1"],

Cell[BoxData[
    \(Cayley[m1, m5, m5, m4, m5, m5] // Factor\)], "Input"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`m\_4 = 0\ \ ; \ \ m\_2 = \(m\_3 = m\_5\); \ \ \ p\^2 = 
      m\_5\%2\)]]], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_3502\), "=", 
        RowBox[{
          RowBox[{\((d - 2  \[Nu]\_1 - \[Nu]\_3 - \[Nu]\_5)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", " ", 
              RowBox[{
                RowBox[{\(\[Nu]\_5\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True]}], ")"}], 
                  InterpretationBox[
                    StyleBox[\(5\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 5, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(1\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "-"],
                    Editable->True], 
                  InterpretationBox[
                    RowBox[{
                      StyleBox[\(3\^+\),
                        FontWeight->"Bold"], " "}],
                    Schiebe[ 3, "+"],
                    Editable->True]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_3502 = OperatorApplyF[e\_3502]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "MakeFun (3502) \[CapitalDelta]=0 ",
  Cell[BoxData[
      \(TraditionalForm\`\((p\^2 = m\^2)\)\)]]
}], "Subsection",
  CellTags->"T1.6.6.1"],

Cell[BoxData[
    \(h\_3502 = s\_3502\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_3502\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_3502\), ",", "\"\<(3502)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", \(PP === m5^2\), "]"}], 
          ",", \({m4 :> 0, m2 :> m5, m3 :> m5}\)}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "MakeFun (3503) \[CapitalDelta]=0 ",
  Cell[BoxData[
      \(TraditionalForm\`\((p\^2 = m\^2)\)\)]]
}], "Subsection",
  CellTags->"T1.6.7.1"],

Cell[BoxData[
    \(Cayley[m5, 0, m3, m5, m5, m5]\)], "Input"],

Cell[BoxData[
    \(h\_3503 = 
      Interchange[s\_3502, 1 \[LeftRightArrow] 2, \ 
        3 \[LeftRightArrow] 4]\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_3503\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_3503\), ",", "\"\<(3503)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", \(PP === m5^2\), "]"}], 
          ",", \({m2 :> 0, m1 :> m5, m4 :> m5}\)}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "MakeFun (3504) \[CapitalDelta]=0 ",
  Cell[BoxData[
      \(TraditionalForm\`\((p\^2 = m\^2)\)\)]]
}], "Subsection",
  CellTags->"T1.6.8.1"],

Cell[BoxData[
    \(Cayley[m5, m2, 0, m5, m5, m5]\)], "Input"],

Cell[BoxData[
    \(h\_3504 = 
      Interchange[s\_3502, 1 \[LeftRightArrow] 3, \ 
        2 \[LeftRightArrow] 4]\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_3504\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_3504\), ",", "\"\<(3504)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", \(PP === m5^2\), "]"}], 
          ",", \({m3 :> 0, m1 :> m5, m4 :> m5}\)}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (41)", "Subsection",
  CellTags->"T1.6.9.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_41\), "=", "\n", 
        RowBox[{
          RowBox[{"2", \(\[Nu]\_5\), " ", "\[ScriptCapitalC]", " ", 
            InterpretationBox[
              StyleBox[\(5\^+\),
                FontWeight->"Bold"],
              Schiebe[ 5, "+"]], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}]]}], " ", "\[Equal]", " ", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(\[CapitalDelta]\_\(1, 3, 6\)\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_3\), 
                        InterpretationBox[
                          StyleBox[\(3\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "+"]], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(4\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 4, "-"]], "-", 
                            InterpretationBox[
                              StyleBox[\(5\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 5, "-"]]}], ")"}]}], "+", 
                      RowBox[{\(\[Nu]\_1\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"]], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(2\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 2, "-"]], "-", 
                            InterpretationBox[
                              StyleBox[\(5\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 5, "-"]]}], ")"}]}]}], ")"}]}], 
                "+", \(\((d - \[Nu]\_1 - \[Nu]\_3 - 
                      2  \[Nu]\_5)\) \[CapitalDelta]\_5\), "+", 
                RowBox[{\(\[CapitalDelta]\_2\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_5\), 
                        InterpretationBox[
                          StyleBox[\(5\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 5, "+"]], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(1\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 1, "-"]], "-", 
                            InterpretationBox[
                              StyleBox[\(2\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 2, "-"]]}], ")"}]}], "+", 
                      RowBox[{\(\[Nu]\_3\), 
                        InterpretationBox[
                          StyleBox[\(3\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "+"]], 
                        InterpretationBox[
                          StyleBox[\(1\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "-"]]}], "+", \(\[Nu]\_1\), 
                      "-", \(\[Nu]\_5\)}], ")"}]}], "+", 
                RowBox[{\(\[CapitalDelta]\_4\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_1\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"]], 
                        InterpretationBox[
                          StyleBox[\(3\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "-"]]}], "+", 
                      RowBox[{\(\[Nu]\_5\), 
                        InterpretationBox[
                          StyleBox[\(5\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 5, "+"]], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(3\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 3, "-"]], "-", 
                            InterpretationBox[
                              StyleBox[\(4\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 4, "-"]]}], ")"}]}], "+", \(\[Nu]\_3\),
                       "-", \(\[Nu]\_5\)}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}]]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_41 = OperatorApplyF[e\_41]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (41)", "Subsection",
  CellTags->"T1.6.10.1"],

Cell[BoxData[
    \(h\_41 = s\_41 /. \[Nu]\_5 \[Rule] \[Nu]\_5 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_41\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_41\), ",", "\"\<(41)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{\(\[Nu]\_5 > 1\), "&&", 
              RowBox[{
                RowBox[{
                  StyleBox["Cayley",
                    FontColor->RGBColor[1, 0, 0.4]], "[", 
                  RowBox[{
                    InterpretationBox[\(m\_1\),
                      m1], ",", 
                    InterpretationBox[\(m\_2\),
                      m2], ",", 
                    InterpretationBox[\(m\_3\),
                      m3], ",", 
                    InterpretationBox[\(m\_4\),
                      m4], ",", 
                    InterpretationBox[\(m\_5\),
                      m5], ",", 
                    SqrtBox[
                      InterpretationBox[\(p\^2\),
                        PP]]}], "]"}], "=!=", "0"}]}], "]"}]}], 
        "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (43)", "Subsection",
  CellTags->"T1.6.11.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(p\^2\)]],
  " and ( ",
  Cell[BoxData[
      \(TraditionalForm\`m\_5\%2 == 0\)]],
  "  &&  ",
  Cell[BoxData[
      \(TraditionalForm\`m\_1\%2\)]],
  "==",
  Cell[BoxData[
      \(TraditionalForm\`m\_2\%2\)]],
  " && ",
  Cell[BoxData[
      \(TraditionalForm\`m\_3\%2\)]],
  "== ",
  Cell[BoxData[
      \(TraditionalForm\`m\_4\%2\)]],
  " ) \[DoubleLongRightArrow] \[CapitalDelta] == 0"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_43\), "=", 
        RowBox[{
          RowBox[{\((d - \[Nu]\_1 - \[Nu]\_3 - 2  \[Nu]\_5)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}], "\[Equal]", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(5\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 5, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True]}], ")"}]}], "+", 
                RowBox[{\(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(5\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 5, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True]}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_43 = OperatorApplyF[e\_43]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (44)", "Subsection",
  CellTags->"T1.6.12.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(p\^2\)]],
  " and ( ",
  Cell[BoxData[
      \(TraditionalForm\`m\_5\%2 == 0\)]],
  "  &&  ",
  Cell[BoxData[
      \(TraditionalForm\`m\_1\%2\)]],
  "==",
  Cell[BoxData[
      \(TraditionalForm\`m\_2\%2\)]],
  " && ",
  Cell[BoxData[
      \(TraditionalForm\`m\_3\%2\)]],
  "== ",
  Cell[BoxData[
      \(TraditionalForm\`m\_4\%2\)]],
  " ) \[DoubleLongRightArrow] \[CapitalDelta] == 0"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_44\), "=", 
        RowBox[{
          RowBox[{\((d - \[Nu]\_2 - \[Nu]\_4 - 2  \[Nu]\_5)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}], "\[Equal]", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(5\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 5, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True]}], ")"}]}], "+", 
                RowBox[{\(\[Nu]\_4\), 
                  InterpretationBox[
                    StyleBox[\(4\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(5\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 5, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True]}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_44 = OperatorApplyF[e\_44]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (45)", "Subsection",
  CellTags->"T1.6.13.1"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_45\), "=", " ", 
        RowBox[{
          RowBox[{\(\[CapitalDelta]\_\(1, 3, 6\)\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}], "\[Equal]", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(u\_\(6, 1, 3\)\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_1\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(3\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "-"],
                          Editable->True]}], "+", 
                      RowBox[{\(\[Nu]\_5\), 
                        InterpretationBox[
                          StyleBox[\(5\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 5, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(3\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 3, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(4\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 4, "-"],
                              Editable->True]}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{"2", \(u\_\(1, 3, 6\)\), 
                  RowBox[{"(", " ", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_2\), 
                        InterpretationBox[
                          StyleBox[\(2\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 2, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(5\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 5, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(1\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 1, "-"],
                              Editable->True]}], ")"}]}], "+", " ", 
                      RowBox[{\(\[Nu]\_4\), 
                        InterpretationBox[
                          StyleBox[\(4\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 4, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(5\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 5, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(3\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 3, "-"],
                              Editable->True]}], ")"}]}], 
                      "+", \(-\[CapitalSigma]\_5\), "-", \(\[Nu]\_1\), 
                      "+", \(3  \[Nu]\_3\)}], ")"}]}], "+", 
                RowBox[{"2", \(m\_3\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_5\), 
                        InterpretationBox[
                          StyleBox[\(5\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 5, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(1\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 1, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(2\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 2, "-"],
                              Editable->True]}], ")"}]}], "+", 
                      RowBox[{\(\[Nu]\_3\), 
                        InterpretationBox[
                          StyleBox[\(3\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(1\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "-"],
                          Editable->True]}], "+", \(\[Nu]\_1\), 
                      "-", \(\[Nu]\_3\)}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["F",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_5\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TFI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4], 
                Subscript[ \[Nu], 5]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_45 = OperatorApplyF[e\_45]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (43) and (44)", "Subsection",
  CellTags->"T1.6.14.1"],

Cell[BoxData[
    \(f\_43 = 
      MakeFun[s\_43, "\<(43)\>", 
        IFF[\[Nu]\_1 + \[Nu]\_3 + 2  \[Nu]\_5 - \((d /. dd_Symbol :> 4)\) =!= 
            0], {m5 :> 0, m4 :> m3, m2 :> m1}]\)], "Input"],

Cell[BoxData[
    \(f\_44 = 
      MakeFun[s\_44, "\<(44)\>", {m5 :> 0, m4 :> m3, m2 :> m1}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (50)", "Subsection",
  CellTags->"T1.6.15.1"],

Cell["\<\
Subscript[f, 50] = 
   HoldForm[TFR[d_, PP_, 
      {{(n1_)?PQ, m1_}, {(n2_)?PQ, m2_}, {(n3_)?PQ, m3_}, 
       {(n4_)?PQ, m4_}, {(n5_)?PQ, m5_}}] := 
     (TComment[\"(50)\", TFIC[d, PP, 
          {{n1, m1}, {n2, m2}, {n3, m3}, {n4, m4}, 
           {n5, m5}}]]; 
        Block[{r1 = 3 - d, r2 = 4 - d, 
          r3 = 
           -(m1^2*m2^2*m3^2) + m2^4*m3^2 + m2^2*m3^4 + 
            m1^4*m4^2 - m1^2*m2^2*m4^2 - 
            m1^2*m3^2*m4^2 - m2^2*m3^2*m4^2 + 
            m1^2*m4^4 + m1^2*m2^2*m5^2 - 
            m2^2*m3^2*m5^2 - m1^2*m4^2*m5^2 + 
            m3^2*m4^2*m5^2 + m1^2*m3^2*PP - 
            m2^2*m3^2*PP - m1^2*m4^2*PP + m2^2*m4^2*PP - 
            m1^2*m5^2*PP - m2^2*m5^2*PP - m3^2*m5^2*PP - 
            m4^2*m5^2*PP + m5^4*PP + m5^2*PP^2, 
          r4 = -4 + d, r5 = -3 + d, r6 = -7 + 2*d, 
          r7 = -(m2^2*r4) + m3^2*r5 - m5^2*r5 + m4^2*r6, 
          r8 = -10 + 3*d, r9 = -m3^2 + m4^2, 
          r10 = -11 + 3*d, 
          r11 = -(m4^2*r10) - 3*m5^2*r5 + m3^2*r6, 
          r12 = 
           m2^2*r11 + m5^4*r5 + m2^4*r8 + m4^2*r4*r9 + 
            m5^2*r5*r9, r13 = -6 + d, 
          r14 = -(m4^2*r13) + m5^2*r5, 
          r15 = -3*m3^2 - m4^2*r10 + m5^2*r5, 
          r16 = 
           m3^2*r14 + m2^2*r15 + m2^4*r4 - 2*m3^4*r5 - 
            3*m4^2*m5^2*r5 + m5^4*r5 + m4^4*r8, 
          r17 = m3^2 + 2*m4^2, r18 = -1 + d, 
          r19 = -(m3^2*r13) - 2*m4^2*r18 + 2*m5^2*r5, 
          r20 = 
           2*m2^4 - 3*m3^4 + d*m3^4 - 3*m3^2*m4^2 + 
            2*m4^4 + m2^2*r19 - 2*m5^4*r5 + m5^2*r17*r5, 
          r21 = 2 + d, r22 = 
           2*m5^2 - m4^2*r21 + m2^2*r4 - m3^2*r4, 
          r23 = -7 + d, r24 = 6*m4^2 - 4*m5^2, 
          r25 = 3*m3^2 + m4^2*r18 + m5^2*r23, 
          r26 = 
           -6*m4^4 - 2*m4^2*m5^2*r23 + m3^2*r24 + 
            2*m2^2*r25 - 2*m2^4*r4 - m3^4*r4, 
          r27 = m3^4 + m3^2*m4^2 - 2*m4^4, 
          r28 = m3^2 + m4^2*r23, 
          r29 = -2*m4^2*r18 + m3^2*r21 + 2*m5^2*r23, 
          r30 = -6*m2^4 + 2*m5^2*r28 - m2^2*r29 + r27*r4, 
          r31 = m1^4*r22 + m1^2*r26 + m3^2*r30 + m1^6*r4, 
          r32 = m3 - m4, r33 = m3 + m4, 
          r34 = 2*m3^2 + m4^2, r35 = -17 + 3*d, 
          r36 = m3^2*r23 + m4^2*r35, r37 = -9 + d, 
          r38 = 17 - 3*d, 
          r39 = 5*m3^2 + m4^2*r37 + m5^2*r38, 
          r40 = 1 + d, r41 = 
           5*m4^2 - m5^2*r23 + m2^2*r4 - m3^2*r40, 
          r42 = 
           m5^4*r35 - m5^2*r36 + m2^2*r39 - 2*m1^4*r4 + 
            m2^4*r4 - r32*r33*r34*r4 + m1^2*r41, 
          r43 = m1^2 - m2^2 + m3^2 - m4^2, 
          r44 = 2*m5^2*r13 + r4*r43, 
          r45 = 
           m3^4*r12 + m1^4*r16 + m1^2*m3^2*r20 + 
            PP*r31 + PP^2*r42 + PP^3*r44 + m1^6*r7, 
          r46 = m2^2 + m4^2, r47 = 13 - 3*d, 
          r48 = m4^2*r47 - m5^2*r5 + m3^2*r6, 
          r49 = m5^4*r5 + m5^2*r32*r33*r5 + m4^2*r4*r9, 
          r50 = -18 + 4*d, r51 = -(m4^2*r13) - 3*m5^2*r5, 
          r52 = 
           2*m3^4*r5 + m4^2*m5^2*r5 + m5^4*r5 + 
            m4^4*r50 + m3^2*r51, 
          r53 = -3*m4^2 + 2*m5^2*r5, 
          r54 = 
           m4^4*r47 + 2*m3^4*r5 + m4^2*m5^2*r5 - 
            2*m5^4*r5 + m3^2*r53, 
          r55 = m4^2*r13 + 6*m3^2*r5 - 2*m5^2*r5, 
          r56 = 3*m4^2 + m3^2*r5 - m5^2*r5, 
          r57 = 7 - 2*d, 
          r58 = m3^2*r5 + 3*m5^2*r5 + m4^2*r57, 
          r59 = 
           m2^6*r4 + m2^2*m4^2*r55 + m2^4*r56 + m4^4*r58, 
          r60 = m4^2 - m3^2*r5, r61 = 10 - 3*d, 
          r62 = 2*m5^2 + 3*m4^2*r4 + m3^2*r61, 
          r63 = m4^2 + m5^2*r5, 
          r64 = 
           -4*m4^2*m5^2 + 3*m4^4*r4 - 2*m3^4*r5 + 
            2*m3^2*r63, r65 = m4^2 + m3^2*r5 - m5^2*r5, 
          r66 = 2*m3^2*r5 + 2*m5^2*r5 + m4^2*r61, 
          r67 = 3*m2^4*r4 + 2*m2^2*r65 + m4^2*r66, 
          r68 = 
           -3*m2^6*r4 - 2*m1^4*m4^2*r5 + 
            2*m4^2*m5^2*r60 + m2^4*r62 + m2^2*r64 + 
            m1^2*r67 - 3*m4^4*r4*r9, r69 = -13 + 3*d, 
          r70 = m3^2*r5 + m4^2*r69, 
          r71 = m4^2 - 3*m2^2*r4 - m3^2*r5 + m5^2*r5, 
          r72 = -5 + d, r73 = m3^2 + m5^2*r69 + m4^2*r72, 
          r74 = 
           3*m2^4*r4 - m5^4*r5 + m5^2*r70 + m1^2*r71 + 
            m2^2*r73 + 3*m4^2*r4*r9, 
          r75 = m1^2 - m2^2 + m3^2 - m4^2 - 2*m5^2, 
          r76 = 
           m2^8*r4 + m2^6*r48 + m4^4*r49 + 
            2*m1^4*m4^2*r46*r5 + m2^4*r52 + 
            m2^2*m4^2*r54 - m1^2*r59 + PP*r68 + 
            PP^2*r74 + PP^3*r4*r75, 
          r77 = m3^2 - m4^2 + m5^2, 
          r78 = -2*m2^2 + m4^2 + m5^2, 
          r79 = -2*m1^2 - m3^2 - m4^2 + m5^2, 
          r80 = 
           m1^4 + PP^2 - m1^2*r77 + m3^2*r78 + PP*r79, 
          r81 = m3^2 + m4^2, r82 = m3^2 + m4^2 + m5^2, 
          r83 = m1^2 + m3^2 - m5^2, 
          r84 = 
           m1^4 + 2*m3^2*m4^2 - m4^4 + PP^2 - m2^2*r77 + 
            m5^2*r81 - m1^2*r82 - 2*PP*r83, 
          r85 = m1 - m3, r86 = -PP + r85^2, 
          r87 = m1 + m3, r88 = -PP + r87^2, 
          r89 = m2 - m4, r90 = m2 + m4, 
          r91 = -m1^2 - m2^2 - m3^2 - m4^2 + 2*m5^2, 
          r92 = PP^2 + r85*r87*r89*r90 + PP*r91, 
          r93 = m2^2 - 3*m4^2, r94 = m4 - m5, 
          r95 = m4 + m5, r96 = 2*m3^2 - m4^2 + m5^2, 
          r97 = -m1^2 - m2^2 - 2*m3^2 + 3*m5^2, 
          r98 = 
           PP^2 + m1^2*r93 + m2^2*r94*r95 + m4^2*r96 + 
            PP*r97, r99 = -2 + d, r100 = -m1^2 + m2^2, 
          r101 = m2^2 + m1^2*r72, 
          r102 = m3^2*r101 - 2*m3^4*r4 + m2^2*r100*r4, 
          r103 = 9 - 2*d, r104 = m2^2*r23 + m3^2*r72, 
          r105 = 
           2*m1^4 + m2^4*r103 + m1^2*r104 + m2^2*m3^2*r5, 
          r106 = -9 + 2*d, r107 = m1 - m2, 
          r108 = m1 + m2, 
          r109 = -(r106*r107*r108) + m3^2*r4, 
          r110 = 
           m2^2*r102 + m4^2*r105 + m4^4*r109 - m4^6*r4, 
          r111 = m1^2 + m2^2, 
          r112 = m2^2*r4 - 2*m1^2*r72, r113 = -19 + 5*d, 
          r114 = m3^2*r112 + m3^4*r113 + m2^2*r111*r4, 
          r115 = m3^2*r5 + m2^2*r6, 
          r116 = 
           2*m1^4 + 2*m1^2*r115 + m2^4*r13 + m3^4*r72 - 
            2*m2^2*m3^2*r99, 
          r117 = m2^2*r106 + m3^2*r4 - m1^2*r99, 
          r118 = 
           m2^2*r114 - m4^2*r116 + m4^4*r117 - m4^6*r6, 
          r119 = -(m2^2*r5) + 2*m3^2*r57 + m1^2*r72, 
          r120 = m1^2*r18 + 2*m3^2*r4 - m2^2*r5, 
          r121 = m2^2*r119 + m4^2*r120 + 2*m4^4*r5, 
          r122 = m3^2*r5 + m4^2*r72, 
          r123 = -2*m2^2*r4 - m4^2*r69 + m3^2*r72, 
          r124 = 
           m2^2*r122 + m1^2*r123 + 2*m2^4*r4 + 
            2*m4^2*r32*r33*r4, 
          r125 = -3*m4^2 + m2^2*r4 - m3^2*r72, 
          r126 = m3^2 - m4^2*r72, 
          r127 = 
           -2*m3^2*m4^2 - 2*m1^2*r125 - 2*m2^2*r126 + 
            m4^4*r18 - 4*m2^4*r4 + m3^4*r72, 
          r128 = 
           -(m2^2*r18) + 2*m4^2*r5 + m1^2*r72 + 
            2*m3^2*r72, 
          r129 = 
           m5^2*r127 - m5^4*r128 - r124*r32*r33 + 
            m5^6*r72, r130 = -m1^2 + m2^2 + m3^2 - m4^2, 
          r131 = -14 + 3*d, 
          r132 = 
           -(m3^2*r13) + m4^2*r131 + m1^2*r4 + 5*m2^2*r4, 
          r133 = -2*m5^4 + m5^2*r132 + r130*r32*r33*r4, 
          r134 = 
           m5^2*r118 + m5^4*r121 + PP*r129 + PP^2*r133 + 
            r110*r32*r33 - 2*m5^2*PP^3*r4 + 
            m5^6*r5*r89*r90, r135 = m3 - m4 - m5, 
          r136 = m3 + m4 - m5, r137 = m3 - m4 + m5, 
          r138 = m3 + m4 + m5, r139 = -10 + d, 
          r140 = 13 - 2*d, r141 = d*m4^2 + 2*m3^2*r5, 
          r142 = -8 + d, 
          r143 = m4^2*r142 - m3^2*r99 + m5^2*r99, 
          r144 = 
           m3^2*m4^2*r139 + m4^4*r140 - m5^2*r141 + 
            m2^2*r143 + m3^4*r5 + m5^4*r5, 
          r145 = 3*m3^4 - 12*m3^2*m4^2 + 7*m4^4, 
          r146 = 3*m3^2 + 4*m4^2, r147 = m3^2 - 11*m4^2, 
          r148 = 
           7*m3^4 + 10*m3^2*m4^2 - 17*m4^4 - 5*m5^4 - 
            2*m5^2*r147, r149 = m2^2 + 2*m3^2 + m4^2, 
          r150 = 
           -m2^4 + m2^2*m3^2 + m3^4 + 3*m2^2*m4^2 + 
            m3^2*m4^2 - m4^4 + m5^4 - m5^2*r149, 
          r151 = 
           3*m3^6 + 6*m3^4*m4^2 - 17*m3^2*m4^4 + 
            8*m4^6 + 3*m5^6 - m5^2*r145 - m5^4*r146 + 
            m2^2*r148 - d*r150*r77 + 6*m2^4*r94*r95, 
          r152 = -(m3^2*m4) + m4^3, r153 = 11 - 2*d, 
          r154 = -(d*m3^2*m4^2) + m4^4*r153 + m3^4*r5, 
          r155 = m4^2 + m3^2*r5, 
          r156 = r142*r32*r33 + m5^2*r99, 
          r157 = 11 - 3*d, r158 = -8 + 3*d, 
          r159 = m5^2*r158 + m4^2*r21, 
          r160 = 
           -3*m3^4 + 2*m4^2*m5^2*r106 + m5^4*r157 + 
            m3^2*r159 - m4^4*r18, 
          r161 = 
           -2*m2^6 + m5^2*r154 - 2*m5^4*r155 + 
            m2^4*r156 + m2^2*r160 + r152^2*r4 + m5^6*r5, 
          r162 = m4^2*r23 - 3*m3^2*r72, 
          r163 = -4*m2^2 + m4^2*r18 + m3^2*r23, 
          r164 = -m3^4 + m4^4, 
          r165 = 
           -(m2^4*r13) + m2^2*r162 + m1^2*r163 + 
            r164*r4 + m1^4*r99, r166 = -19 + 4*d, 
          r167 = m4^2 + m3^2*r72, r168 = m3^2 + m4^2*r69, 
          r169 = -2*r168 + 4*m2^2*r4, 
          r170 = 
           -m3^4 + m2^4*r13 - m4^4*r166 + 2*m2^2*r167 + 
            m1^2*r169 + 2*m3^2*m4^2*r72 + m1^4*r99, 
          r171 = m1^2 - m2^2 + 4*m4^2, 
          r172 = 
           -(m5^2*r170) + r165*r32*r33 + m5^6*r72 - 
            m5^4*r171*r72, r173 = m2^2 + m3^2, 
          r174 = -(m4^2*r13) + r131*r173 + m1^2*r8, 
          r175 = m5^2*r174 - 2*m5^4*r4 + r130*r32*r33*r4, 
          r176 = 
           2*m1^6*m4^2 + m1^4*r144 + m1^2*r151 + 
            m3^2*r161 + PP*r172 + PP^2*r175 - 
            2*m5^2*PP^3*r4, r177 = m3^2 + m4^2 - m5^2, 
          r178 = -2*m1^2 + m3^2 - m4^2 + m5^2, 
          r179 = -m3^2 + m4^2 + m5^2, 
          r180 = m2^2*r177 + m4^2*r178 + PP*r179, 
          r181 = -2*m2^2 - m3^2 + m4^2 + m5^2, 
          r182 = m1^2*r177 + m3^2*r181 + PP*r77, 
          r183 = -(m2^2*r13) - 2*m3^2*r5, 
          r184 = 
           m1^2*r183 - 2*m3^4*r4 + m2^4*r57 + m1^4*r72 - 
            m2^2*m3^2*r99, r185 = 3*m2^2*r4 + m3^2*r72, 
          r186 = 
           m2^4*r106 + 2*m1^2*r185 + m1^4*r40 - 
            2*m2^2*m3^2*r6, r187 = r111*r13 - m3^2*r4, 
          r188 = 
           m2^2*r184 + m4^2*r186 - m4^4*r187 + m4^6*r4, 
          r189 = 2*m1^2 + m3^2*r10 + 2*m2^2*r5, 
          r190 = m2^2*r5 + m3^2*r72 + 2*m1^2*r99, 
          r191 = m2^2*r189 - m4^2*r190 - m4^4*r5, 
          r192 = -(m3^2*r5) - m4^2*r72, 
          r193 = 2*m2^2*r4 + m4^2*r69 - m3^2*r72, 
          r194 = 
           m2^2*r192 + m1^2*r193 - 2*m2^4*r4 + 
            2*m4^2*r4*r9, r195 = m2^2 + m4^2 + m3^2*r72, 
          r196 = -(m3^2*r6) - m4^2*r72, 
          r197 = 
           m2^4*r157 + 2*m1^2*r195 + 2*m2^2*r196 + 
            2*m4^2*r17*r4 + m1^4*r72, 
          r198 = 
           m4^2*r10 - 2*m2^2*r5 + 2*m1^2*r72 + m3^2*r72, 
          r199 = 
           r107*r108*r194 + m5^2*r197 - m5^4*r198 + 
            m5^6*r72, r200 = m1^2 - m2^2 - m3^2 + m4^2, 
          r201 = m1^2 + m2^2 + m3^2 + 5*m4^2, 
          r202 = 2*m5^4 - r107*r108*r200 - m5^2*r201, 
          r203 = 
           r107*r108*r110 - m5^2*r188 - m5^4*r191 + 
            PP*r199 + 2*m5^2*PP^3*r4 + PP^2*r202*r4 + 
            m5^6*r5*r89*r90, r204 = m4^2 + m5^2, 
          r205 = -2*m5^2*r5 + m4^2*r99, r206 = 18 - 5*d, 
          r207 = m4^2*r206 + m5^2*r8 - 2*m3^2*r99, 
          r208 = 
           m2^2*r207 + 2*m2^4*r4 - m3^4*r5 - 
            m3^2*r204*r5 + r205*r94*r95, 
          r209 = 2*m3^2*m4^2 + m4^4*r142 + 2*m3^4*r5, 
          r210 = -(m4^2*r18) + m3^2*r5, r211 = 3 - 2*d, 
          r212 = m5^2 + m4^2*r157 + m3^2*r211, 
          r213 = m4^2*r106 + m3^2*r4, 
          r214 = 
           -(d*m3^4) + 10*m3^2*m4^2 - 2*d*m3^2*m4^2 - 
            2*m4^4 + d*m4^4 + 2*m5^2*r213 - 2*m5^4*r4, 
          r215 = 
           d*m3^2*m4^4 - 2*m4^6 - m5^2*r209 + 
            m5^4*r210 + m2^4*r212 + m2^2*r214 + 
            m2^6*r4 + m5^6*r5 - m3^4*m4^2*r99, 
          r216 = m4^2*r13 + m3^2*r99, 
          r217 = m3^2*r5 - m4^2*r72, r218 = 13 - 4*d, 
          r219 = 3*m3^2 + m5^2*r218 + m4^2*r23, 
          r220 = m4^2*r142 + m5^2*r61, 
          r221 = 
           2*m3^4 + 2*m4^2*m5^2 - m4^4*r13 + m3^2*r220 + 
            2*m5^4*r6, r222 = 
           m4^2*m5^2*r216 + m5^4*r217 + m2^4*r219 + 
            m2^2*r221 - m5^6*r5 + m2^6*r99, 
          r223 = -(m3^2*r10) + m4^2*r5, 
          r224 = 
           4*m3^2*m4^2 + m1^2*r122 + m4^4*r13 + 
            m2^2*r223 + m1^4*r4 - m2^4*r4 - m3^4*r99, 
          r225 = -m3^2 + m2^2*r72 - m4^2*r72, 
          r226 = -2*m4^2*r106 + 2*m3^2*r69, 
          r227 = 
           m1^4*r106 + m2^4*r106 - m4^4*r13 - 
            2*m1^2*r225 + m2^2*r226 - 4*m3^2*m4^2*r4 - 
            m3^4*r99, r228 = m3^2 + 3*m4^2, 
          r229 = 
           r107*r108*r224 - m5^2*r227 + m5^6*r72 - 
            m5^4*r228*r72, 
          r230 = m4^2*r131 + m1^2*r4 + m2^2*r4 + m3^2*r8, 
          r231 = 
           2*m5^4*r106 - m5^2*r230 - r107*r108*r200*r4, 
          r232 = 
           m1^4*r208 - m1^2*r215 - m3^2*r222 + PP*r229 + 
            PP^2*r231 + 2*m5^2*PP^3*r4 + m1^6*r7, 
          r233 = -2*m3^2 + m4^2, 
          r234 = -m2^2 + m4^2 - 2*m5^2, 
          r235 = -m1^2 + m2^2 + m5^2, 
          r236 = 
           m1^4 + m5^4 + m2^2*r233 + m1^2*r234 + 
            PP*r235 - m5^2*r46, r237 = -m2^2 + m5^2, 
          r238 = m2^2 + m3^2 - 2*m4^2 + m5^2, 
          r239 = -m1^2 + m2^2 - m5^2, 
          r240 = m1^4 + m3^2*r237 - m1^2*r238 + PP*r239, 
          r241 = m3^2 + 3*m4^2 - m5^2, 
          r242 = -3*m3^2 - m4^2 + m5^2, 
          r243 = 
           m5^4 - m5^2*r228 + m1^2*r241 + m2^2*r242 + 
            2*PP*r32*r33 + 2*m4^2*r9, 
          r244 = 2*m1^2 + m2^2 + m4^2, 
          r245 = -2*m1^2 - m3^2 - m4^2 + 3*m5^2, 
          r246 = 
           m1^4 - 3*m2^2*m3^2 + m5^4 + PP^2 + 
            m4^2*r173 - m5^2*r244 + PP*r245, 
          r247 = -2*m3^2 + m4^2 + m5^2, 
          r248 = 
           -m2^4 - m4^2*m5^2 + PP*r235 + m2^2*r247 + 
            m1^2*r46, r249 = m2^2*r153 + m1^2*r5, 
          r250 = 2*m1^2 + m2^2*r4, 
          r251 = m2^2*r13 + m1^2*r139, 
          r252 = r107*r108*r250 + m3^2*r251 - m3^4*r4, 
          r253 = m1^2*r140 + 2*m3^2*r4 + m2^2*r72, 
          r254 = 
           m3^4*r249 + m4^2*r252 + m4^4*r253 - m4^6*r4 + 
            m2^2*m3^2*r100*r99, r255 = 2*m3^2 + m4^2*r13, 
          r256 = -2*m3^2*r5 + m2^2*r99 - m4^2*r99, 
          r257 = -11 + 2*d, 
          r258 = 
           -(m4^4*r106) + 2*m3^2*m4^2*r23 - m3^4*r257, 
          r259 = 4*m4^2 + m3^2*r13, 
          r260 = 
           -2*m2^4 + 6*m3^2*m4^2 + 2*m2^2*r259 + 
            m4^4*r37 + m3^4*r5, 
          r261 = 
           -5*m3^4*m4^2 + m2^4*r255 + m1^4*r256 + 
            m2^2*r258 + m1^2*r260 - m2^6*r4 + m3^6*r5 + 
            m4^6*r6 - 3*m3^2*m4^4*r72, 
          r262 = m3^4 + m3^2*m4^2 + m4^4, 
          r263 = 
           m1^4 + m2^4 - 2*r262 + m1^2*r81 + m2^2*r81, 
          r264 = m1^2 + m2^2 - m3^2 - m4^2, 
          r265 = -(r13*r32*r33) + m2^2*r99, 
          r266 = 
           -2*m1^2*r265 - r32^2*r33^2*r4 + 
            2*m2^2*r13*r9 + m1^4*r99 + m2^4*r99, 
          r267 = m3^2*r13 + m4^2*r4, r268 = -16 + 3*d, 
          r269 = m3^2*r13 - m4^2*r268 + m2^2*r4, 
          r270 = 
           2*m2^2*r267 + 2*m1^2*r269 + 
            r13*r228*r32*r33 + m2^4*r61 + m1^4*r99, 
          r271 = 2*m2^2 + m4^2*r23 - m3^2*r72, 
          r272 = 
           -(m5^2*r270) - 2*m5^4*r271 + r266*r32*r33, 
          r273 = 2*m3^2 - 2*m4^2 - m5^2, 
          r274 = m1^2*r5 - m2^2*r5 + r273*r72, 
          r275 = 
           r200*r254 + m5^2*r261 + PP*r272 + 
            2*m5^2*PP^2*r274 + m5^4*r263*r5 - 
            m5^6*r264*r5, 
          r276 = 
           -2*m2^2*m3^2 - 2*m3^4 + 3*m3^2*m4^2 - m4^4 + 
            3*m3^2*m5^2 + 2*m4^2*m5^2 - m5^4 + 
            m1^2*r177 + PP*r77, 
          r277 = -(m4^2*r106) + m2^2*r4 - m3^2*r5, 
          r278 = 
           -2*m3^4 - m3^2*m4^2*r13 + m2^2*r196 + 
            m2^4*r4 + m4^4*r4, 
          r279 = m4^2*r131 + m3^2*r8, 
          r280 = 
           m2^2*r279 - 2*m2^4*r4 + m4^2*r32*r33*r99, 
          r281 = m1^4*r277 + m2^2*r278 + m1^2*r280, 
          r282 = 11*m3^2 - 3*d*m3^2 + 9*m4^2 - 2*d*m4^2, 
          r283 = 15 - 4*d, 
          r284 = m4^2*r106 + m2^2*r283 + m3^2*r5, 
          r285 = m4^4*r13 + 4*m3^2*m4^2*r5 - m3^4*r99, 
          r286 = -m4^2 + m3^2*r5, 
          r287 = -(m4^2*r5) + m3^2*r6, 
          r288 = 2*m2^2*r287 + m2^4*r72 - 2*r286*r81, 
          r289 = 
           -2*m3^2*m4^4 + m2^4*r282 + m1^4*r284 + 
            m2^2*r285 + m1^2*r288 - m4^6*r4 + m1^6*r5 + 
            m2^6*r6 + m3^4*m4^2*r99, 
          r290 = 2*m2^2 - m3^2 - m4^2, 
          r291 = 
           2*m1^4 + 2*m2^4 - m3^4 - m4^4 + m1^2*r290 - 
            m2^2*r81, r292 = m2^2 - m3^2 + m4^2, 
          r293 = 
           m1^4*r4 + m2^4*r4 - 2*m1^2*r292*r4 + 
            2*m2^2*r4*r9 - r32^2*r33^2*r99, 
          r294 = m3^2*r13 - m4^2*r131, 
          r295 = m2^2*r13 - r4*r81, 
          r296 = 
           m1^4*r131 + 2*m2^2*r294 - 2*m1^2*r295 - 
            2*m3^2*m4^2*r4 + m4^4*r8 - m2^4*r99 - 
            m3^4*r99, r297 = 2*m4^2 - m2^2*r5 + m1^2*r72, 
          r298 = 
           r107*r108*r293 - m5^2*r296 + 2*m5^4*r297, 
          r299 = -2*m5^2*r32*r33*r5 + 2*m5^4*r72, 
          r300 = 
           r130*r281 - m5^2*r289 + PP*r298 + PP^2*r299 - 
            m5^6*r264*r5 + m5^4*r291*r5, 
          r301 = 
           -2*m2^2*m3^2 - m3^2*m4^2 + m4^4 + m5^4 - 
            m5^2*r17 + m1^2*r177 + PP*r77, 
          r302 = m2^2 + 2*m3^2 - 3*m4^2, 
          r303 = -m1^2 + m2^2 - 3*m5^2, 
          r304 = 
           m1^4 - m2^2*m4^2 - m5^4 + m5^2*r149 - 
            m1^2*r302 + PP*r303, 
          r305 = 
           -((r45*TBI[d, PP, {{1, m4}, {1, m2}}]*
                 TBI[d, PP, {{2, m1}, {1, m3}}])/(4*r3)) 
+ (r76*TBI[d, PP, {{1, m3}, {1, m1}}]*
               TBI[d, PP, {{2, m2}, {1, m4}}])/(4*r3) - 
            (r80*TBI[d, PP, {{2, m1}, {1, m3}}]*
               TBI[d, PP, {{2, m2}, {1, m4}}])/2 - 
            (r45*TBI[d, PP, {{1, m4}, {1, m2}}]*
               TBI[d, PP, {{2, m3}, {1, m1}}])/(4*r3) - 
            (r84*TBI[d, PP, {{2, m2}, {1, m4}}]*
               TBI[d, PP, {{2, m3}, {1, m1}}])/2 - 
            r86*r88*TBI[d, PP, {{1, m4}, {1, m2}}]*
             TBI[d, PP, {{2, m3}, {2, m1}}] + 
            (r76*TBI[d, PP, {{1, m3}, {1, m1}}]*
               TBI[d, PP, {{2, m4}, {1, m2}}])/(4*r3) - 
            (r92*TBI[d, PP, {{2, m1}, {1, m3}}]*
               TBI[d, PP, {{2, m4}, {1, m2}}])/2 - 
            (r98*TBI[d, PP, {{2, m3}, {1, m1}}]*
               TBI[d, PP, {{2, m4}, {1, m2}}])/2 - 
            r86*r88*TBI[d, PP, {{1, m4}, {1, m2}}]*
             TBI[d, PP, {{3, m1}, {1, m3}}] - 
            r86*r88*TBI[d, PP, {{1, m4}, {1, m2}}]*
             TBI[d, PP, {{3, m3}, {1, m1}}] - 
            r3*TFI[r99, PP, 
              {{1, m1}, {1, m2}, {1, m3}, {1, m4}, 
               {1, m5}}] - 
            (r134*TVI[d, PP, 
                {{1, m5}, {1, m1}, {2, m4}, {1, m3}}])/
             (4*r3) - (r135*r136*r137*r138*
               TVI[d, PP, 
                {{1, m5}, {1, m1}, {2, m4}, {2, m3}}])/2 
- (r176*TVI[d, PP, {{1, m5}, {1, m2}, {2, m3}, 
                 {1, m4}}])/(4*r3) + 
            (r180*TVI[d, PP, 
                {{1, m5}, {1, m2}, {2, m3}, {2, m4}}])/2 
- r182*TVI[d, PP, {{1, m5}, {1, m2}, {3, m3}, 
               {1, m4}}] + 
            (r203*TVI[d, PP, 
                {{1, m5}, {1, m3}, {2, m2}, {1, m1}}])/
             (4*r3) + (r232*
               TVI[d, PP, 
                {{1, m5}, {1, m4}, {2, m1}, {1, m2}}])/
             (4*r3) + (r236*
               TVI[d, PP, 
                {{1, m5}, {1, m4}, {2, m1}, {2, m2}}])/2 
+ r240*TVI[d, PP, {{1, m5}, {1, m4}, {3, m1}, 
               {1, m2}}] + 
            (r45*TVI[d, PP, 
                {{1, m5}, {2, m1}, {1, m4}, {1, m3}}])/
             (4*r3) + (r86*r88*
               TVI[d, PP, 
                {{1, m5}, {2, m1}, {1, m4}, {2, m3}}])/2 
+ (r92*TVI[d, PP, {{1, m5}, {2, m1}, {2, m4}, 
                 {1, m3}}])/2 - 
            (r76*TVI[d, PP, 
                {{1, m5}, {2, m2}, {1, m3}, {1, m4}}])/
             (4*r3) - (r243*
               TVI[d, PP, 
                {{1, m5}, {2, m2}, {2, m3}, {1, m4}}])/2 
+ (r45*TVI[d, PP, {{1, m5}, {2, m3}, {1, m2}, 
                 {1, m1}}])/(4*r3) + 
            (r86*r88*TVI[d, PP, 
                {{1, m5}, {2, m3}, {1, m2}, {2, m1}}])/2 
+ (r246*TVI[d, PP, {{1, m5}, {2, m3}, {2, m2}, 
                 {1, m1}}])/2 - 
            (r76*TVI[d, PP, 
                {{1, m5}, {2, m4}, {1, m1}, {1, m2}}])/
             (4*r3) + (r248*
               TVI[d, PP, 
                {{1, m5}, {2, m4}, {2, m1}, {1, m2}}])/2 
+ r86*r88*TVI[d, PP, {{1, m5}, {3, m1}, {1, m4}, 
               {1, m3}}] + 
            r86*r88*TVI[d, PP, 
              {{1, m5}, {3, m3}, {1, m2}, {1, m1}}] + 
            (r275*TVI[d, PP, 
                {{2, m5}, {1, m1}, {1, m4}, {1, m3}}])/
             (4*r3) + (r276*
               TVI[d, PP, 
                {{2, m5}, {1, m1}, {1, m4}, {2, m3}}])/2 
- (r180*TVI[d, PP, {{2, m5}, {1, m1}, {2, m4}, 
                 {1, m3}}])/2 - 
            (r275*TVI[d, PP, 
                {{2, m5}, {1, m2}, {1, m3}, {1, m4}}])/
             (4*r3) + (r180*
               TVI[d, PP, 
                {{2, m5}, {1, m2}, {1, m3}, {2, m4}}])/2 
- (r276*TVI[d, PP, {{2, m5}, {1, m2}, {2, m3}, 
                 {1, m4}}])/2 - 
            (r300*TVI[d, PP, 
                {{2, m5}, {1, m3}, {1, m2}, {1, m1}}])/
             (4*r3) - (r240*
               TVI[d, PP, 
                {{2, m5}, {1, m3}, {1, m2}, {2, m1}}])/2 
- (r236*TVI[d, PP, {{2, m5}, {1, m3}, {2, m2}, 
                 {1, m1}}])/2 + 
            (r300*TVI[d, PP, 
                {{2, m5}, {1, m4}, {1, m1}, {1, m2}}])/
             (4*r3) + (r236*
               TVI[d, PP, 
                {{2, m5}, {1, m4}, {1, m1}, {2, m2}}])/2 
+ (r240*TVI[d, PP, {{2, m5}, {1, m4}, {2, m1}, 
                 {1, m2}}])/2 + 
            (r182*TVI[d, PP, 
                {{2, m5}, {2, m1}, {1, m4}, {1, m3}}])/2 
- (r301*TVI[d, PP, {{2, m5}, {2, m2}, {1, m3}, 
                 {1, m4}}])/2 - 
            (r304*TVI[d, PP, 
                {{2, m5}, {2, m3}, {1, m2}, {1, m1}}])/2 
+ (r248*TVI[d, PP, {{2, m5}, {2, m4}, {1, m1}, 
                 {1, m2}}])/2, r306}, 
         r306 = Factor /@ r305/(PP*r1*r2); r306]) /; 
         n1 === 1 && n2 === 1 && n3 === 1 && n4 === 1 && n5 === 1 &&  
       MatchQ[d, _Symbol + _Integer?Positive] && PP =!= 0 &&
       Cayley[m1, m2, m3, m4, m5, Sqrt[PP]] =!= 0]; \
\>", "Input",
  Editable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (51)", "Subsection",
  CellTags->"T1.6.16.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_51\), "=", 
        RowBox[{
          RowBox[{\(\[CapitalDelta]\_\(1, 3, 4\)\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{"2", \(m\_3\%2\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True]}], ")"}]}], "+", 
                RowBox[{\(u\_\(4, 1, 3\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True]}], ")"}]}], 
                "+", \(\(u\_\(1, 3, 4\)\) \((d - \[Nu]\_1 - 2  \[Nu]\_3)\)\), 
                "+", \(2 \( m\_3\%2\) \((\[Nu]\_1 - \[Nu]\_3)\)\)}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_51 = OperatorApplyV[e\_51]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (51)", "Subsection",
  CellTags->"T1.6.17.1"],

Cell[BoxData[
    \(s\_51\)], "Input"],

Cell[BoxData[
    \(h\_51 = s\_51 /. \[Nu]\_1 \[Rule] \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_51\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_51\), ",", "\"\<(51)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\[Nu]\_1 > 1 && \[CapitalDelta]\_\(1, 3, 4\) =!= 0\), 
            "]"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_51]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (52)", "Subsection",
  CellTags->"T1.6.18.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_52\), "=", 
        RowBox[{
          RowBox[{\(\[CapitalDelta]\_\(2, 4, 6\)\), \(\[Nu]\_2\), 
            InterpretationBox[
              StyleBox[\(2\^+\),
                FontWeight->"Bold"],
              Schiebe[ 2, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{"2", \(m\_1\%2\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True]}], ")"}]}], "+", 
                RowBox[{"2", \(m\_3\%2\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True]}], ")"}]}], "-", 
                RowBox[{"2", \(m\_4\%2\), \(\[Nu]\_4\), 
                  InterpretationBox[
                    StyleBox[\(4\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(2\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "-"],
                    Editable->True]}], "+", 
                RowBox[{\((2  m\_2\%2 - u\_\(4, 2, 6\))\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(4\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "-"],
                    Editable->True]}], "-", 
                RowBox[{\((\[CapitalSigma]\_4 + 2)\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True]}], ")"}]}], 
                "+", \(\(u\_\(2, 4, 6\)\) \((d - 3  \[Nu]\_2)\)\), 
                "+", \(2 \( m\_4\%2\) \((\[Nu]\_4 - \[Nu]\_2)\)\)}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_52 = OperatorApplyV[e\_52]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (52)", "Subsection",
  CellTags->"T1.6.19.1"],

Cell[BoxData[
    \(h\_52 = \[Nu]explicit[
          s\_52] /. \[Nu]\_2 \[Rule] \[Nu]\_2 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_52\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_52\), ",", "\"\<(52)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\[Nu]\_2 > 1 && \[CapitalDelta]\_\(2, 4, 6\) =!= 0\), 
            "]"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_52]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (53)", "Subsection",
  CellTags->"T1.6.20.1"],

Cell[BoxData[
    \(h\_53 = 
      Interchange[s\_51, 
          1 \[LeftRightArrow] 3] /. \[Nu]\_3 \[Rule] \[Nu]\_3 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_53\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_53\), ",", "\"\<(53)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\[Nu]\_3 > 1 && \[CapitalDelta]\_\(3, 1, 4\) =!= 0\), 
            "]"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_53]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (54)", "Subsection",
  CellTags->"T1.6.21.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_54\), "=", 
        RowBox[{
          RowBox[{"2", \(m\_3\%2\), \(\[Nu]\_3\), 
            InterpretationBox[
              StyleBox[\(3\^+\),
                FontWeight->"Bold"],
              Schiebe[ 3, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(u\_\(4, 1, 3\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True]}], ")"}]}], "+", "\n", 
                "\t\t\t\t", \((d - \[Nu]\_1 - 2  \[Nu]\_3)\)}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_54 = OperatorApplyV[e\_54]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (54)", "Subsection",
  CellTags->"T1.6.22.1"],

Cell[BoxData[
    \(h\_54 = s\_54 /. \[Nu]\_3 \[Rule] \[Nu]\_3 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_54\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_54\), ",", "\"\<(54)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            " ", \(\[Nu]\_3 > 1 && \ m3 =!= 0\), "]"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_54]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (55)", "Subsection",
  CellTags->"T1.6.23.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_55\), "=", 
        RowBox[{
          RowBox[{"2", " ", \(m\_4\%2\), \(\[Nu]\_4\), 
            InterpretationBox[
              StyleBox[\(4\^+\),
                FontWeight->"Bold"],
              Schiebe[ 4, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(u\_\(3, 1, 4\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(u\_\(6, 2, 4\)\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "+", "\n", "\t\t\t\t", 
                RowBox[{\(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True]}], ")"}]}], "-", 
                RowBox[{\(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(4\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "-"],
                    Editable->True]}], 
                "+", \((d - \[Nu]\_1 - \[Nu]\_2 - 2  \[Nu]\_4)\)}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_55 = OperatorApplyV[e\_55]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (55)", "Subsection",
  CellTags->"T1.6.24.1"],

Cell[BoxData[
    \(h\_55 = s\_55 /. \[Nu]\_4 \[Rule] \[Nu]\_4 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_55\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_55\), ",", "\"\<(55)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\[Nu]\_4 > 1 && \ m4 =!= 0\  && \ \[Nu]\_3 > 1\), "]"}]}], 
        "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_55]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (56)", "Subsection",
  CellTags->"T1.6.25.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_56\), "=", 
        RowBox[{
          RowBox[{"2", " ", \(m\_4\%2\), \(\[Nu]\_4\), 
            InterpretationBox[
              StyleBox[\(4\^+\),
                FontWeight->"Bold"],
              Schiebe[ 4, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-2\), \(m\_1\%2\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(u\_\(6, 2, 4\)\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "-", 
                RowBox[{"2", \(m\_3\%2\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "-", "\n", "\t\t\t\t", 
                RowBox[{\(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(4\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "-"],
                    Editable->True]}], 
                "+", \((2  d - 2  \[Nu]\_1 - \[Nu]\_2 - 2  \[Nu]\_3 - 
                    2  \[Nu]\_4)\)}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_56 = OperatorApplyV[e\_56]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (56)", "Subsection",
  CellTags->"T1.6.26.1"],

Cell[BoxData[
    \(h\_56 = s\_56 /. \[Nu]\_4 \[Rule] \[Nu]\_4 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_56\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_56\), ",", "\"\<(56)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\[Nu]\_4 > 1 && \ m4 =!= 0\  && \ \[Nu]\_3 === 1\), 
            "]"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_56]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (59)", "Subsection",
  CellTags->"T1.6.27.1"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_\(1, 3, 4\)\)]],
  "== 0 but all  ",
  Cell[BoxData[
      \(m\_i\%2\)]],
  " != 0"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_59\), "=", 
        RowBox[{
          
          RowBox[{\((2 \( m\_1\%2\) \(u\_\(1, 3, 4\)\) \((d - \[Nu]\_1 - 
                      2  \[Nu]\_3)\) + \((\[Nu]\_3 - 1)\) 
                  u\_\(4, 1, 3\)\%2 + \n\t
                4 \( m\_1\%2\) \(m\_3\%2\) \((\[Nu]\_1 - \[Nu]\_3)\))\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(u\_\(4, 1, 3\)\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(4\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "-"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True]}], ")"}]}], "-", "\n", "\t", 
                RowBox[{"4", \(m\_1\%2\), \(m\_3\%2\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(1\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "-"],
                    Editable->True]}], "+", 
                
                RowBox[{\((4 \( m\_1\%2\) m\_3\%2 + 
                      u\_\(4, 1, 3\)\%2)\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(4\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "-"],
                    Editable->True]}], "+", 
                RowBox[{\(u\_\(4, 1, 3\)\), \((\[Nu]\_3 - 1)\), 
                  InterpretationBox[
                    StyleBox[\(1\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "-"],
                    Editable->True]}], "-", "\n", "\t\t", 
                
                RowBox[{\((d - 2  \[Nu]\_1 - \[Nu]\_3 + 1)\), \(u\_\(4, 1, 
                      3\)\), 
                  InterpretationBox[
                    StyleBox[\(3\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "-"],
                    Editable->True]}], "+", 
                
                RowBox[{\((d - 2  \[Nu]\_1 - 2  \[Nu]\_3 + 1)\), \(u\_\(4, 1, 
                      3\)\), 
                  InterpretationBox[
                    StyleBox[\(4\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "-"],
                    Editable->True]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_59 = OperatorApplyV[e\_59]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (59)", "Subsection",
  CellTags->"T1.6.28.1"],

Cell[BoxData[
    \(h\_59 = s\_59\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_59\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_59\), ",", "\"\<(59)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\[CapitalDelta]\_\(1, 3, 4\) == 
                0 && \((4\ m\_3\%2\ m\_1\%2 - 4\ m\_3\%2\ \[Nu]\_3\ m\_1\%2 + 
                    2\ d\ u\_\(1, 3, 4\)\ m\_1\%2 - 
                    4\ \[Nu]\_3\ u\_\(1, 3, 4\)\ m\_1\%2 - 
                    2\ u\_\(1, 3, 4\)\ m\_1\%2 + \[Nu]\_3\ u\_\(4, 1, 3\)\%2 \
- u\_\(4, 1, 3\)\%2)\)\ \  =!= 0 && n1\  === \ 1 && \ n2\  === \ 1 && \ 
              n4\  === \ 1 && MatchQ[d, _Integer]\), "]"}]}], 
        "]"}]}]], "Input"],

Cell["CheckTVIRecursion not applicable .", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (60) ", "Subsection",
  CellTags->"T1.6.29.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_60\), "=", 
        RowBox[{
          RowBox[{"2", \(m\_1\%2\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(u\_\(4, 1, 3\)\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True]}], ")"}]}], "+", "\n", 
                "\t\t\t\t", \((d - \[Nu]\_3 - 2  \[Nu]\_1)\)}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_60 = OperatorApplyV[e\_60]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (60)", "Subsection",
  CellTags->"T1.6.30.1"],

Cell[BoxData[
    \(h\_60 = s\_60 /. \[Nu]\_1 \[Rule] \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(notnecessaryf\_60\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_60\), ",", "\"\<(60)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\[Nu]\_1 > 1 && \ m1 =!= 0\), "]"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[notnecessaryf\_60]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (61) ", "Subsection",
  CellTags->"T1.6.31.1"],

Cell[TextData[{
  " ( ",
  Cell[BoxData[
      \(m\_1\%2\)]],
  "== 0 && ",
  Cell[BoxData[
      \(m\_4\%2\)]],
  "== ",
  Cell[BoxData[
      \(m\_3\%2\)]],
  " )  \[DoubleLongRightArrow] ( ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_\(1, 3, 4\)\)]],
  "== 0 )"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_61\), "=", 
        RowBox[{
          RowBox[{\((d - 2  \[Nu]\_1 - \[Nu]\_3)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{\(\[Nu]\_3\), 
            InterpretationBox[
              StyleBox[\(3\^+\),
                FontWeight->"Bold"],
              Schiebe[ 3, "+"],
              Editable->True], 
            RowBox[{"(", 
              RowBox[{
                InterpretationBox[
                  StyleBox[\(1\^-\),
                    FontWeight->"Bold"],
                  Schiebe[ 1, "-"],
                  Editable->True], "-", 
                InterpretationBox[
                  StyleBox[\(4\^-\),
                    FontWeight->"Bold"],
                  Schiebe[ 4, "-"],
                  Editable->True]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_61 = OperatorApplyV[e\_61]\)], "Input"],

Cell[TextData[{
  "For  ( ",
  Cell[BoxData[
      \(m\_3\%2\)]],
  "== 0 && ",
  Cell[BoxData[
      \(m\_4\%2\)]],
  "== ",
  Cell[BoxData[
      \(m\_1\%2\)]],
  " )  \[DoubleLongRightArrow] ( ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_\(1, 3, 4\)\)]],
  "== 0 )\nuse ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["V",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox[\(\[Nu]\_1\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_2\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_3\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_4\),
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TVI[ d, {
                  Subscript[ \[Nu], 1], 
                  Subscript[ \[Nu], 2], 
                  Subscript[ \[Nu], 3], 
                  Subscript[ \[Nu], 4]}],
                Editable->True], "==", 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["V",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox[\(\[Nu]\_3\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_2\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_1\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_4\),
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TVI[ d, {
                  Subscript[ \[Nu], 1], 
                  Subscript[ \[Nu], 2], 
                  Subscript[ \[Nu], 3], 
                  Subscript[ \[Nu], 4]}],
                Editable->True]}], ")"}], " "}], TextForm]]],
  " and switch the masses accordingly."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (61)", "Subsection",
  CellTags->"T1.6.32.1"],

Cell[TextData[{
  "( ",
  Cell[BoxData[
      \(m\_1\%2\)]],
  "== 0 && ",
  Cell[BoxData[
      \(m\_4\%2\)]],
  "== ",
  Cell[BoxData[
      \(m\_3\%2\)]],
  " )  \[DoubleLongRightArrow] ( ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_\(1, 3, 4\)\)]],
  "== 0 )"
}], "Text"],

Cell[BoxData[
    \(h\_61 = s\_61\)], "Input"],

Cell["\<\
Don't need the restriction to n1=1 and n4=1 (I hope ...). Changed \
September 24th 2003.\
\>", "SmallText"],

Cell[BoxData[
    RowBox[{\(f\_61\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_61\), ",", "\<\"(61)\"\>", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{
              RowBox[{
                InterpretationBox[\(m\_1\),
                  m1], "===", "0"}], "&&", 
              RowBox[{
                InterpretationBox[\(m\_3\),
                  m3], "===", 
                InterpretationBox[\(m\_4\),
                  m4]}]}], "]"}], ",", \({n1 :> 1, n4 :> 1}\)}], 
        "]"}]}]], "SmallText"],

Cell[BoxData[
    RowBox[{\(f\_61\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_61\), ",", "\"\<(61)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{
              RowBox[{
                InterpretationBox[\(m\_1\),
                  m1], "===", "0"}], "&&", 
              RowBox[{
                InterpretationBox[\(m\_3\),
                  m3], "===", 
                InterpretationBox[\(m\_4\),
                  m4]}]}], "]"}]}], "]"}]}]], "Input"],

Cell["CheckTVIRecursion not applicable .", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (6153)", "Subsection",
  CellTags->"T1.6.33.1"],

Cell[TextData[{
  " ( ",
  Cell[BoxData[
      \(m\_3\%2\)]],
  "== 0 && ",
  Cell[BoxData[
      \(m\_4\%2\)]],
  "== ",
  Cell[BoxData[
      \(m\_1\%2\)]],
  ")  \[DoubleLongRightArrow] ( ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_\(1, 3, 4\)\)]],
  "== 0 )"
}], "Text"],

Cell[BoxData[
    \(h\_6153 = Interchange[s\_61, 1 \[LeftRightArrow] 3]\)], "Input"],

Cell["\<\
Don't need the restriction to n1=1 and n4=1 (I hope ...). Changed \
September 24th 2003.\
\>", "SmallText"],

Cell[BoxData[
    RowBox[{\(f\_6153\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_6153\), ",", "\<\"(6153)\"\>", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{
              RowBox[{
                InterpretationBox[\(m\_3\),
                  m3], "===", "0"}], "&&", 
              RowBox[{
                InterpretationBox[\(m\_1\),
                  m1], "===", 
                InterpretationBox[\(m\_4\),
                  m4]}]}], "]"}], ",", \({n3 :> 1, n4 :> 1}\)}], 
        "]"}]}]], "SmallText"],

Cell[BoxData[
    RowBox[{\(f\_6153\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_6153\), ",", "\"\<(6153)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{
              RowBox[{
                InterpretationBox[\(m\_3\),
                  m3], "===", "0"}], "&&", 
              RowBox[{
                InterpretationBox[\(m\_1\),
                  m1], "===", 
                InterpretationBox[\(m\_4\),
                  m4]}]}], "]"}]}], "]"}]}]], "Input"],

Cell["CheckTVIRecursion not applicable .", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (62) ", "Subsection",
  CellTags->"T1.6.34.1"],

Cell[TextData[{
  "( ",
  Cell[BoxData[
      \(m\_4\%2\)]],
  "== 0 && ",
  Cell[BoxData[
      \(m\_1\%2\)]],
  "== ",
  Cell[BoxData[
      \(m\_3\%2\)]],
  " ) \[DoubleLongRightArrow] (",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[CapitalDelta]\_\(1, 3, 4\)\)\)\)]],
  "== 0 )\nlower ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_2\)]],
  " via (52) to one first"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_62\), "=", 
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                InterpretationBox[\(p\^2\),
                  PP], "-", \(m\_2\%2\)}], 
              ")"}], \((\[Nu]\_1 - 2  \[Nu]\_2 + 2  \[Nu]\_4 + 2)\), 
            InterpretationBox[
              StyleBox[\(4\^+\),
                FontWeight->"Bold"],
              Schiebe[ 4, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", "\n", "\t\t", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\((m\_1\%2 - u\_\(6, 1, 2\))\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{"4", \(m\_2\%2\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "+", 
                RowBox[{"2", \(m\_1\%2\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "+", "\n", "\t\t\t\t", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{\(\[CapitalSigma]\_4\), "-", 
                      RowBox[{"2", \(m\_1\%2\), \(\[Nu]\_1\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True]}], "-", 
                      RowBox[{"2", \(m\_1\%2\), \(\[Nu]\_3\), 
                        InterpretationBox[
                          StyleBox[\(3\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "+"],
                          Editable->True]}]}], ")"}], 
                  InterpretationBox[
                    StyleBox[\(2\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "-"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(4\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "+"],
                    Editable->True]}], "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "-", \(m\_2\%2\)}], ")"}], \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(4\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(3\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "-"],
                    Editable->True]}], "-", "\n", 
                "\t\t\t\t", \(\[CapitalSigma]\_4\)}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_62 = OperatorApplyV[e\_62]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (62)", "Subsection",
  CellTags->"T1.6.35.1"],

Cell[BoxData[
    \(h\_62 = \[Nu]explicit[
          s\_62] /. \[Nu]\_4 \[Rule] \[Nu]\_4 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_62\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_62\), ",", "\"\<(62)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{
              RowBox[{
                InterpretationBox[\(p\^2\),
                  PP], "=!=", 
                InterpretationBox[\(m\_2\%2\),
                  Power[ m2, 2]]}], 
              "&&", \(\[Nu]\_1 - 2\ \[Nu]\_2 + 2\ \[Nu]\_4 =!= 0\)}], "]"}], 
          ",", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                InterpretationBox[\(m\_4\),
                  m4], "\[RuleDelayed]", "0"}], ",", 
              RowBox[{
                InterpretationBox[\(m\_3\),
                  m3], "\[RuleDelayed]", 
                InterpretationBox[\(m\_1\),
                  m1]}], ",", \(n2 \[RuleDelayed] 1\)}], "}"}]}], 
        "]"}]}]], "Input"],

Cell["CheckTVIRecursion not applicable .", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (63) ", "Subsection",
  CellTags->"T1.6.36.1"],

Cell[TextData[{
  Cell[BoxData[
      \(m\_4\%2\)]],
  "== 0  && ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[CapitalDelta]\_\(1, 3, 4\)\)\)\)]],
  " != 0\nreplace (55) by the following"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_63\), "=", 
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                InterpretationBox[\(p\^2\),
                  PP], "-", \(m\_2\%2\)}], 
              ")"}], \((\((m\_3\%2 - m\_1\%2)\) \((d - 2  \[Nu]\_2 - 
                      2  \[Nu]\_3 + 2  \[Nu]\_4)\) + 
                2 \( m\_3\%2\) \((\[Nu]\_3 - \[Nu]\_1)\))\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", "\n", "\t\t", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\((m\_1\%2 - m\_3\%2)\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{"2", \(m\_1\%2\), \(\[Nu]\_1\), 
                              InterpretationBox[
                                StyleBox[\(1\^+\),
                                  FontWeight->"Bold"],
                                Schiebe[ 1, "+"],
                                Editable->True]}], "+", 
                            RowBox[{"2", \(m\_3\%2\), \(\[Nu]\_3\), 
                              InterpretationBox[
                                StyleBox[\(3\^+\),
                                  FontWeight->"Bold"],
                                Schiebe[ 3, "+"],
                                Editable->True]}], 
                            "-", \(\[CapitalSigma]\_4\), "-", "2"}], ")"}], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(2\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 2, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(4\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 4, "-"],
                              Editable->True]}], ")"}]}], "-", 
                      RowBox[{"4", \(m\_2\%2\), \(\[Nu]\_2\), 
                        InterpretationBox[
                          StyleBox[\(2\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 2, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(4\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 4, "-"],
                          Editable->True]}]}], ")"}]}], "+", "\n", "\t\t\t\t",
                 
                RowBox[{"2", 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "-", \(m\_2\%2\)}], ")"}], 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(m\_3\%2\), \(\[Nu]\_3\), 
                        InterpretationBox[
                          StyleBox[\(3\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(1\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 1, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(4\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 4, "-"],
                              Editable->True]}], ")"}]}], "+", 
                      RowBox[{\(m\_1\%2\), \(\[Nu]\_1\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True], 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[
                              StyleBox[\(4\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 4, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(3\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 3, "-"],
                              Editable->True]}], ")"}]}]}], ")"}]}]}], ")"}], 
            
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_63 = OperatorApplyV[e\_63]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (63)", "Subsection",
  CellTags->"T1.6.37.1"],

Cell[TextData[{
  Cell[BoxData[
      \(m\_4\%2\)]],
  "== 0  && ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[CapitalDelta]\_\(1, 3, 4\)\)\)\)]],
  " != 0"
}], "Text"],

Cell[BoxData[
    \(h\_63 = \[Nu]explicit[s\_63]\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_63\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_63\), ",", "\"\<(63)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(PP\  =!= \ m2^2 && \(Cayley[1, 3, 4]\)[{m1, m2, m3, m4}] =!= 
                0\), "]"}], ",", 
          RowBox[{"{", 
            RowBox[{
              InterpretationBox[\(m\_4\),
                m4], "\[RuleDelayed]", "0"}], "}"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_63]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]],

Cell[BoxData[
    RowBox[{\(f\_63\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_63\), ",", "\"\<(63)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(PP\  =!= \ m2^2 && \(Cayley[1, 3, 4]\)[{m1, m2, m3, m4}] =!= 
                0\), "]"}], ",", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                InterpretationBox[\(m\_4\),
                  m4], "\[RuleDelayed]", "0"}], ",", \(n1 :> 1\), 
              ",", \(n3 :> 1\)}], "}"}]}], "]"}]}]], "Input"],

Cell["\<\

CheckTVIRecursion not applicable for special indices since A's and 
B's appear .
\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (6552)", "Subsection",
  CellTags->"T1.6.38.1"],

Cell[BoxData[
    \(r\_6552 = \[Nu]explicit[e\_52] /. \[CapitalDelta]\_\(2, 4, 6\) -> 
          0\)], "Input"],

Cell[BoxData[
    RowBox[{"formal", "=", 
      RowBox[{
        RowBox[{
          RowBox[{"Solve", "[", 
            RowBox[{\(e\_55 /. TVI[__] -> 1\), ",", 
              InterpretationBox[
                StyleBox[\(4\^+\),
                  FontWeight->"Bold"],
                Schiebe[ 4, "+"],
                Editable->True]}], "]"}], "[", \([1, 1]\), "]"}], 
        "/.", \(\[Nu]\_2 -> \[Nu]\_2 - 1\)}]}]], "Input"],

Cell[BoxData[
    \(r\_6552 /. formal\)], "Input"],

Cell[BoxData[
    \(n\_6552 = OperatorApplyV[r\_6552 /. formal]\)], "Input"],

Cell[BoxData[
    \(n\_6552[\([2, 4]\)]\)], "Input"],

Cell[BoxData[
    \(s\_6552 = \(-n\_6552[\([2, 4]\)]\) == \((n\_6552[\([2]\)] - 
            n\_6552[\([2, 4]\)])\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_6552\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(s\_6552\), ",", "\"\<(6552)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], "[", 
            RowBox[{\(\[CapitalDelta]\_\(2, 4, 6\) === 0\), "&&", 
              RowBox[{
                RowBox[{"Expand", "[", 
                  RowBox[{
                    RowBox[{"2", " ", \((\[Nu]\_2 - \[Nu]\_4)\), " ", 
                      InterpretationBox[\(m\_4\%2\),
                        Power[ m4, 2]]}], 
                    "+", \(\((3\ \[Nu]\_2 - d)\)\ u\_\(2, 4, 6\)\), 
                    "+", \(\[Nu]\_2\ u\_\(6, 2, 4\)\)}], "]"}], "=!=", 
                "0"}]}], "]"}]}], "]"}]}]], "Input"],

Cell["CheckTVIRecursion not applicable .", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (6552)", "Subsection",
  CellTags->"T1.6.39.1"],

Cell[BoxData[
    \(r\_6552 = \[Nu]explicit[e\_52] /. \[CapitalDelta]\_\(2, 4, 6\) -> 
          0\)], "Input"],

Cell[BoxData[
    \(n\_6552 = OperatorApplyV[r\_6552]\)], "Input"],

Cell[BoxData[
    \(n\_6552[\([2, 5]\)]\)], "Input"],

Cell[BoxData[
    \(s\_6552 = \(-n\_6552[\([2, 5]\)]\) == \((n\_6552[\([2]\)] - 
            n\_6552[\([2, 5]\)])\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_6552\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(s\_6552\), ",", "\"\<(6552)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\[CapitalDelta]\_\(2, 4, 6\) === 0 && 
              Expand[\((\(-2\)\ \[Nu]\_2\ m\_4\%2 + 2\ \[Nu]\_4\ m\_4\%2 + 
                      d\ u\_\(2, 4, 6\) - 3\ \[Nu]\_2\ u\_\(2, 4, 6\))\)] =!= 
                0\), "]"}]}], "]"}]}]], "Input"],

Cell["CheckTVIRecursion not applicable .", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (6553)", "Subsection",
  CellTags->"T1.6.40.1"],

Cell[BoxData[
    \(r\_6553 = \(\(\[Nu]explicit[s\_55] /. u\_\(3, 1, 4\) -> 0\) /. 
          u\_\(6, 2, 4\) -> 0\) /. m\_4 -> 0\)], "Input"],

Cell[BoxData[
    \(h\_6553 = \(-r\_6553[\([2, 1]\)]\) == \((r\_6553[\([2]\)] - 
            r\_6553[\([2, 1]\)])\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_6553\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_6553\), ",", "\"\<(6553)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(u\_\(6, 2, 4\) === 0 && u\_\(1, 3, 4\) === 0\), "]"}], 
          ",", \(m4 :> 0\)}], "]"}]}]], "Input"],

Cell["CheckTVIRecursion not applicable .", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (66) ", "Subsection",
  CellTags->"T1.6.41.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_66\), "=", 
        RowBox[{
          RowBox[{"4", 
            InterpretationBox[\(p\^2\),
              PP], \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], \(\[Nu]\_2\), 
            InterpretationBox[
              StyleBox[\(2\^+\),
                FontWeight->"Bold"],
              Schiebe[ 2, "+"],
              Editable->True], \(\[Nu]\_3\), 
            InterpretationBox[
              StyleBox[\(3\^+\),
                FontWeight->"Bold"],
              Schiebe[ 3, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d + 2\),
                    "TraditionalForm"], ")"}]],
              TVI[ 
                Plus[ 2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"(", 
                    
                    RowBox[{\(6  d\), "-", \(6  \[Nu]\_1\), 
                      "-", \(5  \[Nu]\_2\), "-", \(6  \[Nu]\_3\), 
                      "-", \(4  \[Nu]\_4\), "-", 
                      RowBox[{"6", \(m\_1\%2\), \(\[Nu]\_1\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True]}]}], ")"}], "+", 
                  RowBox[{\((u\_\(6, 2, 4\) - 4  m\_2\%2)\), \(\[Nu]\_2\), 
                    InterpretationBox[
                      StyleBox[\(2\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 2, "+"],
                      Editable->True]}], "-", 
                  RowBox[{"6", \(m\_3\%2\), \(\[Nu]\_3\), 
                    InterpretationBox[
                      StyleBox[\(3\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 3, "+"],
                      Editable->True]}], "+", 
                  RowBox[{"2", \((u\_\(6, 2, 4\) - m\_4\%2)\), \(\[Nu]\_4\), 
                    InterpretationBox[
                      StyleBox[\(4\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 4, "+"],
                      Editable->True]}], "-", 
                  RowBox[{\(\[Nu]\_2\), 
                    InterpretationBox[
                      StyleBox[\(2\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 2, "+"],
                      Editable->True], 
                    InterpretationBox[
                      StyleBox[\(4\^-\),
                        FontWeight->"Bold"],
                      Schiebe[ 4, "-"],
                      Editable->True]}], "-", 
                  RowBox[{"2", \(\[Nu]\_4\), 
                    InterpretationBox[
                      StyleBox[\(4\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 4, "+"],
                      Editable->True], 
                    InterpretationBox[
                      StyleBox[\(2\^-\),
                        FontWeight->"Bold"],
                      Schiebe[ 2, "-"],
                      Editable->True]}]}], ")"}]}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_66 = OperatorApplyV[e\_66]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (66)", "Subsection",
  CellTags->"T1.6.42.1"],

Cell[BoxData[
    \(h\_66 = 
      s\_66 /. {\[Nu]\_1 :> \[Nu]\_1 - 1, \[Nu]\_2 :> \[Nu]\_2 - 
              1, \[Nu]\_3 :> \[Nu]\_3 - 1, d :> d - 2}\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_66\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_66\), ",", "\"\<(66)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(PP =!= 0 && \[Nu]\_1 > 1 && \[Nu]\_2 > 1 && \[Nu]\_3 > 1 && 
              MatchQ[d, _Symbol + _Integer?Positive]\), "]"}]}], 
        "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_66]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (alternative67)", "Subsection",
  CellTags->"T1.6.43.1"],

Cell["\<\
we dereived an alternative formula for Tarasov's (67), but do not \
save it by default.\
\>", "Text"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_67\), "=", 
        RowBox[{
          RowBox[{"4", 
            InterpretationBox[\(p\^2\),
              PP], \(\[Nu]\_1\), \((\[Nu]\_1 + 1)\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], \(\[Nu]\_2\), 
            InterpretationBox[
              StyleBox[\(2\^+\),
                FontWeight->"Bold"],
              Schiebe[ 2, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d + 2\),
                    "TraditionalForm"], ")"}]],
              TVI[ 
                Plus[ 2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], " ", "==", 
          RowBox[{
            RowBox[{"(", 
              
              RowBox[{\((6  d - 6  \[Nu]\_1 - 5  \[Nu]\_2 - 6  \[Nu]\_3 - 
                    4  \[Nu]\_4)\), "-", 
                RowBox[{
                "2", \((u\_\(2, 4, 6\) + 3  m\_1\%2)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\((u\_\(6, 2, 4\) - 4  m\_2\%2)\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "-", 
                RowBox[{"6", \(m\_3\%2\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "+", 
                RowBox[{"2", \((u\_\(6, 2, 4\) - m\_4\%2)\), \(\[Nu]\_4\), 
                  InterpretationBox[
                    StyleBox[\(4\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "+"],
                    Editable->True]}], "+", 
                RowBox[{"2", \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True]}], ")"}]}], "-", 
                RowBox[{\(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(4\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "-"],
                    Editable->True]}], "-", 
                RowBox[{"2", \(\[Nu]\_4\), 
                  InterpretationBox[
                    StyleBox[\(4\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(2\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "-"],
                    Editable->True]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_67 = OperatorApplyV[e\_67]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (67)", "Subsection",
  CellTags->"T1.6.44.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_67\), "=", 
        RowBox[{
          RowBox[{"4", 
            InterpretationBox[\(p\^2\),
              PP], \(\[Nu]\_1\), \((\[Nu]\_1 + 1)\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], \(\[Nu]\_2\), 
            InterpretationBox[
              StyleBox[\(2\^+\),
                FontWeight->"Bold"],
              Schiebe[ 2, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d + 2\),
                    "TraditionalForm"], ")"}]],
              TVI[ 
                Plus[ 2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], " ", "==", 
          RowBox[{
            RowBox[{"(", 
              
              RowBox[{\(2 \((2  d - 2  \[Nu]\_1 - 2  \[Nu]\_2 - 
                      2  \[Nu]\_3 - \[Nu]\_4)\)\), "-", 
                RowBox[{
                "2", \((u\_\(2, 4, 6\) + 2  m\_1\%2)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(-4\), \(m\_2\%2\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "-", 
                RowBox[{"4", \(m\_3\%2\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "+", 
                RowBox[{"2", \(u\_\(6, 2, 4\)\), \(\[Nu]\_4\), 
                  InterpretationBox[
                    StyleBox[\(4\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "+"],
                    Editable->True]}], "+", 
                RowBox[{"2", \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(4\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 4, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True]}], ")"}]}], "-", 
                RowBox[{"2", \(\[Nu]\_4\), 
                  InterpretationBox[
                    StyleBox[\(4\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 4, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(2\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "-"],
                    Editable->True]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(-4\), " ", \(\[Nu]\_2\), " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["V",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                StyleBox[
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_4\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TVI[ d, {
              Subscript[ \[Nu], 1], 
              Plus[ 1, 
                Subscript[ \[Nu], 2]], 
              Subscript[ \[Nu], 3], 
              Subscript[ \[Nu], 4]}],
            Editable->True], " ", \(m\_2\%2\)}], "-", 
        RowBox[{"2", " ", \(\[Nu]\_4\), " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["V",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                StyleBox[
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"],
                  FontColor->RGBColor[1, 0, 0]], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"], 
                StyleBox[
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TVI[ d, {
              Subscript[ \[Nu], 1], 
              Plus[ -1, 
                Subscript[ \[Nu], 2]], 
              Subscript[ \[Nu], 3], 
              Plus[ 1, 
                Subscript[ \[Nu], 4]]}],
            Editable->True]}], "+", 
        RowBox[{
        "2", " ", \((2\ d - 2\ \[Nu]\_1 - 2\ \[Nu]\_2 - 
              2\ \[Nu]\_3 - \[Nu]\_4)\), " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["V",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_2\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_4\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TVI[ d, {
              Subscript[ \[Nu], 1], 
              Subscript[ \[Nu], 2], 
              Subscript[ \[Nu], 3], 
              Subscript[ \[Nu], 4]}],
            Editable->True]}], "-", 
        RowBox[{
        "2", " ", \((m\_2\%2 + m\_4\%2 - p\^2)\), " ", \(\[Nu]\_4\), " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["V",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_2\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"], 
                StyleBox[
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TVI[ d, {
              Subscript[ \[Nu], 1], 
              Subscript[ \[Nu], 2], 
              Subscript[ \[Nu], 3], 
              Plus[ 1, 
                Subscript[ \[Nu], 4]]}],
            Editable->True]}], "-", 
        RowBox[{"4", " ", \(m\_3\%2\), " ", \(\[Nu]\_3\), " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["V",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_2\),
                  "TraditionalForm"], 
                StyleBox[
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]], 
                FormBox[\(\[Nu]\_4\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TVI[ d, {
              Subscript[ \[Nu], 1], 
              Subscript[ \[Nu], 2], 
              Plus[ 1, 
                Subscript[ \[Nu], 3]], 
              Subscript[ \[Nu], 4]}],
            Editable->True]}], "-", 
        RowBox[{"2", " ", \(\[Nu]\_1\), " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["V",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"],
                  FontColor->RGBColor[1, 0, 0]], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_4\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TVI[ d, {
              Plus[ 1, 
                Subscript[ \[Nu], 1]], 
              Plus[ -1, 
                Subscript[ \[Nu], 2]], 
              Subscript[ \[Nu], 3], 
              Subscript[ \[Nu], 4]}],
            Editable->True]}], "+", 
        RowBox[{"2", " ", \(\[Nu]\_1\), " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["V",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]], 
                FormBox[\(\[Nu]\_2\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"], 
                StyleBox[
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"],
                  FontColor->RGBColor[1, 0, 0]]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TVI[ d, {
              Plus[ 1, 
                Subscript[ \[Nu], 1]], 
              Subscript[ \[Nu], 2], 
              Subscript[ \[Nu], 3], 
              Plus[ -1, 
                Subscript[ \[Nu], 4]]}],
            Editable->True]}], "-", 
        RowBox[{
        "2", " ", \((2\ m\_1\%2 + m\_2\%2 - m\_4\%2 - p\^2)\), 
          " ", \(\[Nu]\_1\), " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["V",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]], 
                FormBox[\(\[Nu]\_2\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_4\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TVI[ d, {
              Plus[ 1, 
                Subscript[ \[Nu], 1]], 
              Subscript[ \[Nu], 2], 
              Subscript[ \[Nu], 3], 
              Subscript[ \[Nu], 4]}],
            Editable->True]}], "-", 
        RowBox[{
        "4", " ", \(p\^2\), " ", \(\[Nu]\_1\), " ", \((\[Nu]\_1 + 1)\), 
          " ", \(\[Nu]\_2\), " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["V",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"],
                  FontWeight->"Bold",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_4\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox[\(d + 2\),
                  "TraditionalForm"], ")"}]],
            TVI[ 
              Plus[ 2, d], {
              Plus[ 2, 
                Subscript[ \[Nu], 1]], 
              Plus[ 1, 
                Subscript[ \[Nu], 2]], 
              Subscript[ \[Nu], 3], 
              Subscript[ \[Nu], 4]}],
            Editable->True]}]}], TraditionalForm]]]], "Text"],

Cell[BoxData[
    \(s\_67 = OperatorApplyV[e\_67]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (67)", "Subsection",
  CellTags->"T1.6.45.1"],

Cell[BoxData[
    \(h\_67 = 
      s\_67 /. {\[Nu]\_1 :> \[Nu]\_1 - 2, \[Nu]\_2 :> \[Nu]\_2 - 1, 
          d :> d - 2}\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_67\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_67\), ",", "\"\<(67)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(PP =!= 0 && \[Nu]\_1 > 2 && \[Nu]\_2 > 1 && 
              MatchQ[d, _Symbol + _Integer?Positive]\), "]"}]}], 
        "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_67]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (6713)", "Subsection",
  CellTags->"T1.6.46.1"],

Cell[BoxData[
    \(h\_6713 = 
      Interchange[s\_67, 
          1 \[LeftRightArrow] 
            3] /. {\[Nu]\_3 :> \[Nu]\_3 - 2, \[Nu]\_2 :> \[Nu]\_2 - 1, 
          d :> d - 2}\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_6713\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_6713\), ",", "\"\<(6713)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(PP =!= 0 && \[Nu]\_3 > 2 && \[Nu]\_2 > 1 && 
              MatchQ[d, _Symbol + _Integer?Positive]\), "]"}]}], 
        "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_6713]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (68)", "Subsection",
  CellTags->"T1.6.47.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_68\), "=", 
        RowBox[{
          RowBox[{"4", 
            InterpretationBox[\(p\^2\),
              PP], \(m\_4\%2\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], \(\[Nu]\_2\), \((\[Nu]\_2 + 1)\), 
            InterpretationBox[
              StyleBox[\(2\^+\),
                FontWeight->"Bold"],
              Schiebe[ 2, "+"],
              Editable->True], 
            InterpretationBox[
              StyleBox[\(2\^+\),
                FontWeight->"Bold"],
              Schiebe[ 2, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d + 2\),
                    "TraditionalForm"], ")"}]],
              TVI[ 
                Plus[ 2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                
                RowBox[{\((\((m\_1\%2 - m\_3\%2)\) \((2  d - 
                            2  \[Nu]\_1 - \[Nu]\_2 - 2  \[Nu]\_3 - 
                            2  \[Nu]\_4)\) + \(m\_4\%2\) \((2  \[Nu]\_1 + \
\[Nu]\_2 - 2  \[Nu]\_3)\))\), "-", 
                  RowBox[{\(u\_\(1, 3, 4\)\), 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"2", \(m\_1\%2\), \(\[Nu]\_1\), 
                          InterpretationBox[
                            StyleBox[\(1\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 1, "+"],
                            Editable->True]}], "+", 
                        RowBox[{\(u\_\(2, 4, 6\)\), \(\[Nu]\_2\), 
                          InterpretationBox[
                            StyleBox[\(2\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 2, "+"],
                            Editable->True]}]}], ")"}]}], "+", 
                  RowBox[{\(u\_\(3, 1, 4\)\), 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"2", \(m\_3\%2\), \(\[Nu]\_3\), 
                          InterpretationBox[
                            StyleBox[\(3\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 3, "+"],
                            Editable->True]}], "+", 
                        RowBox[{\(\[Nu]\_2\), 
                          InterpretationBox[
                            StyleBox[\(2\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 2, "+"],
                            Editable->True], 
                          InterpretationBox[
                            StyleBox[\(4\^-\),
                              FontWeight->"Bold"],
                            Schiebe[ 4, "-"],
                            Editable->True]}]}], ")"}]}], "-", 
                  RowBox[{"2", \(m\_4\%2\), 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{\(\[Nu]\_2\), 
                          InterpretationBox[
                            StyleBox[\(2\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 2, "+"],
                            Editable->True]}], "+", 
                        RowBox[{\(\[Nu]\_4\), 
                          InterpretationBox[
                            StyleBox[\(4\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 4, "+"],
                            Editable->True]}]}], ")"}], 
                    RowBox[{"(", 
                      RowBox[{
                        InterpretationBox[
                          StyleBox[\(3\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "-"],
                          Editable->True], "-", 
                        InterpretationBox[
                          StyleBox[\(1\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "-"],
                          Editable->True]}], ")"}]}]}], ")"}]}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_4\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3], 
                Subscript[ \[Nu], 4]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_68 = OperatorApplyV[e\_68]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (68)", "Subsection",
  CellTags->"T1.6.48.1"],

Cell[BoxData[
    \(h\_68 = 
      s\_68 /. {\[Nu]\_1 :> \[Nu]\_1 - 1, \[Nu]\_2 :> \[Nu]\_2 - 2, 
          d :> d - 2}\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_68\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_68\), ",", "\"\<(68)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(PP =!= 0 && m4 =!= 0 && \[Nu]\_1 > 1 && \[Nu]\_2 > 2 && 
              MatchQ[d, _Symbol + _Integer?Positive]\), "]"}]}], 
        "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_68]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (6813)", "Subsection",
  CellTags->"T1.6.49.1"],

Cell[BoxData[
    \(h\_6813 = 
      Interchange[s\_68, 
          1 \[LeftRightArrow] 
            3] /. {\[Nu]\_2 :> \[Nu]\_2 - 2, \[Nu]\_3 :> \[Nu]\_3 - 1, 
          d :> d - 2}\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_6813\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_6813\), ",", "\"\<(6813)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\(PP =!= 0 && m4 =!= 0\) && \[Nu]\_2 > 2 && \[Nu]\_3 > 1 && 
              MatchQ[d, _Symbol + _Integer?Positive]\), "]"}]}], 
        "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTVIRecursion[f\_6813]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (70)", "Subsection",
  CellTags->"T1.6.50.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_70\), "=", 
        RowBox[{
          RowBox[{\((3  d - 10)\), \(\((d - 3)\)\^2\), \(m\_4\%2\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["V",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TVI[ d, {1, 1, 1, 1}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{
              FractionBox["1", 
                RowBox[{"4", 
                  InterpretationBox[\(p\^2\),
                    PP]}]], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\((3  d - 10)\), \(\[CapitalDelta]\_\(1, 3, 4\)\), 
                    RowBox[{"(", 
                      RowBox[{\(\[CapitalDelta]\_\(2, 4, 6\)\), "+", 
                        RowBox[{\(u\_\(2, 4, 6\)\), 
                          RowBox[{"(", 
                            RowBox[{
                              InterpretationBox[
                                StyleBox[\(2\^-\),
                                  FontWeight->"Bold"],
                                Schiebe[ 2, "-"],
                                Editable->True], "-", 
                              InterpretationBox[
                                StyleBox[\(4\^-\),
                                  FontWeight->"Bold"],
                                Schiebe[ 4, "-"],
                                Editable->True]}], ")"}]}]}], ")"}]}], "-", 
                  RowBox[{"8", \(\((d - 4)\)\^2\), 
                    InterpretationBox[\(p\^2\),
                      PP], \(m\_3\%2\), \(m\_4\%2\), 
                    InterpretationBox[
                      StyleBox[\(4\^-\),
                        FontWeight->"Bold"],
                      Schiebe[ 4, "-"],
                      Editable->True]}]}], ")"}], 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["V",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox[\(d - 2\),
                      "TraditionalForm"], ")"}]],
                TVI[ 
                  Plus[ -2, d], {1, 1, 1, 1}],
                Editable->True]}], "+", "\n", "\t\t\t", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\((d - 3)\), \(m\_4\%2\), 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{"4", \(m\_1\%2\), \((d - 4)\), 
                          InterpretationBox[
                            StyleBox[\(1\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 1, "+"],
                            Editable->True], 
                          InterpretationBox[
                            StyleBox[\(1\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 1, "+"],
                            Editable->True]}], "-", 
                        RowBox[{"8", \((d - 3)\), \(m\_2\%2\), 
                          InterpretationBox[
                            StyleBox[\(2\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 2, "+"],
                            Editable->True], 
                          InterpretationBox[
                            StyleBox[\(2\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 2, "+"],
                            Editable->True]}], "+", 
                        RowBox[{\((3  d - 10)\), \((d - 3)\), 
                          InterpretationBox[
                            StyleBox[\(2\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 2, "+"],
                            Editable->True]}]}], ")"}]}], "+", 
                  RowBox[{\(u\_\(6, 2, 4\)\), 
                    RowBox[{"(", 
                      RowBox[{
                        
                        RowBox[{\(1\/2\), \((3  d - 10)\), \(u\_\(1, 3, 4\)\),
                           
                          RowBox[{"(", 
                            RowBox[{
                              InterpretationBox[
                                StyleBox[\(1\^+\),
                                  FontWeight->"Bold"],
                                Schiebe[ 1, "+"],
                                Editable->True], "-", 
                              InterpretationBox[
                                StyleBox[\(3\^+\),
                                  FontWeight->"Bold"],
                                Schiebe[ 3, "+"],
                                Editable->True]}], ")"}]}], "+", 
                        RowBox[{\((d - 2)\), \((d - 3)\), \(m\_4\%2\), 
                          InterpretationBox[
                            StyleBox[\(1\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 1, "+"],
                            Editable->True]}]}], ")"}], 
                    InterpretationBox[
                      StyleBox[\(2\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 2, "+"],
                      Editable->True]}], "-", 
                  RowBox[{\(m\_4\%2\), 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{\(\((d - 4)\)\^2\), \(u\_\(1, 3, 4\)\), 
                          InterpretationBox[
                            StyleBox[\(2\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 2, "+"],
                            Editable->True]}], "+", 
                        RowBox[{\((3  d - 10)\), \(u\_\(4, 1, 3\)\), 
                          InterpretationBox[
                            StyleBox[\(3\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 3, "+"],
                            Editable->True]}]}], ")"}], 
                    InterpretationBox[
                      StyleBox[\(1\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 1, "+"],
                      Editable->True]}]}], ")"}], 
              InterpretationBox[
                StyleBox[\(4\^-\),
                  FontWeight->"Bold"],
                Schiebe[ 4, "-"],
                Editable->True], 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["V",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TVI[ d, {1, 1, 1, 1}],
                Editable->True]}], "-", 
            RowBox[{\((d - 3)\), \(m\_4\%2\), 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"4", \((d - 4)\), \(m\_1\%2\), 
                    InterpretationBox[
                      StyleBox[\(1\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 1, "+"],
                      Editable->True]}], "+", 
                  RowBox[{\((d - 2)\), 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{\(u\_\(6, 2, 4\)\), 
                          InterpretationBox[
                            StyleBox[\(2\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 2, "+"],
                            Editable->True]}], "-", 
                        RowBox[{"2", \(m\_4\%2\), 
                          InterpretationBox[
                            StyleBox[\(4\^+\),
                              FontWeight->"Bold"],
                            Schiebe[ 4, "+"],
                            Editable->True]}]}], ")"}]}]}], ")"}], 
              InterpretationBox[
                StyleBox[\(1\^+\),
                  FontWeight->"Bold"],
                Schiebe[ 1, "+"],
                Editable->True], 
              InterpretationBox[
                StyleBox[\(3\^-\),
                  FontWeight->"Bold"],
                Schiebe[ 3, "-"],
                Editable->True], 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["V",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TVI[ d, {1, 1, 1, 1}],
                Editable->True]}], "+", 
            RowBox[{\(1\/2\), \((3  d - 10)\), \(u\_\(1, 3, 4\)\), 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(u\_\(6, 2, 4\)\), 
                    InterpretationBox[
                      StyleBox[\(2\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 2, "+"],
                      Editable->True]}], "-", 
                  RowBox[{"2", \(m\_4\%2\), 
                    InterpretationBox[
                      StyleBox[\(4\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 4, "+"],
                      Editable->True]}]}], ")"}], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    InterpretationBox[
                      StyleBox[\(3\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 3, "+"],
                      Editable->True], 
                    InterpretationBox[
                      StyleBox[\(1\^-\),
                        FontWeight->"Bold"],
                      Schiebe[ 1, "-"],
                      Editable->True]}], "-", 
                  RowBox[{
                    InterpretationBox[
                      StyleBox[\(1\^+\),
                        FontWeight->"Bold"],
                      Schiebe[ 1, "+"],
                      Editable->True], 
                    InterpretationBox[
                      StyleBox[\(3\^-\),
                        FontWeight->"Bold"],
                      Schiebe[ 3, "-"],
                      Editable->True]}]}], ")"}], 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["V",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"], 
                    FormBox["1",
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TVI[ d, {1, 1, 1, 1}],
                Editable->True]}]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_70 = OperatorApplyV[e\_70]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (70)", "Subsection",
  CellTags->"T1.6.51.1"],

Cell[BoxData[
    \(h\_70 = s\_70\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_70\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_70\), ",", "\"\<(70)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\(m4 =!= 0\  && \ PP =!= 0\) && 
              MatchQ[d, _Symbol + _Integer?Positive]\), "]"}]}], 
        "]"}]}]], "Input"],

Cell["\<\
CheckTVIRecursion not applicable for special indices since A's and 
B's appear .\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (71)", "Subsection",
  CellTags->"T1.6.52.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_1, \[Nu]\_2 > 0\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_71\), "=", 
        RowBox[{
          RowBox[{"2", \(D\_\(1, 2, 3\)\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], \(\[Nu]\_2\), 
            InterpretationBox[
              StyleBox[\(2\^+\),
                FontWeight->"Bold"],
              Schiebe[ 2, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{"2", \(h\_\(1, 2, 3\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{"2", \(h\_\(2, 1, 3\)\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "+", 
                RowBox[{
                "4", \(m\_3\%2\), \(\[Sigma]\_\(1, 2, 3\)\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(m\_3\%2\), \(\[Phi]\_\(2, 1, 3\)\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(1\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "-"],
                    Editable->True]}], "+", 
                RowBox[{\(m\_3\%2\), \(\[Phi]\_\(1, 2, 3\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(2\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "-"],
                    Editable->True]}], "-", 
                RowBox[{"2", \(\[Rho]\_\(1, 2, 3\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(3\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "-"],
                    Editable->True]}], 
                "+", \(\(1\/2\) \(\[CapitalSigma]\_3\) \((d - \[Nu]\_1 - \
\[Nu]\_2 - \[Nu]\_3)\) \[Phi]\_\(3, 2, 1\)\)}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_71 = OperatorApplyJ[e\_71]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (71)", "Subsection",
  CellTags->"T1.6.53.1"],

Cell[BoxData[
    \(h\_71 = \(\[Nu]explicit[
            s\_71] /. \[Nu]\_1 -> \[Nu]\_1 - 1\) /. \[Nu]\_2 -> \[Nu]\_2 - 
            1\)], "Input"],

Cell[BoxData[
    \(f\_71 = 
      MakeFun[h\_71, "\<(71)\>", 
        IFF[\[Nu]\_1 > 1 && \[Nu]\_2 > 1 && D\_\(1, 2, 3\) =!= 0]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_71]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (7123)", "Subsection",
  CellTags->"T1.6.54.1"],

Cell[BoxData[
    \(h\_7123 = \(Interchange[s\_71, 
            2 \[LeftRightArrow] 3] /. \[Nu]\_1 -> \[Nu]\_1 - 
              1\) /. \[Nu]\_3 -> \[Nu]\_3 - 1\)], "Input"],

Cell[BoxData[
    \(f\_7123 = 
      MakeFun[h\_7123, "\<(7123)\>", 
        IFF[\[Nu]\_1 > 1 && \[Nu]\_3 > 1 && D\_\(1, 3, 2\) =!= 0]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_7123]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (7113)", "Subsection",
  CellTags->"T1.6.55.1"],

Cell[BoxData[
    \(h\_7113 = \(Interchange[s\_71, 
            1 \[LeftRightArrow] 3] /. \[Nu]\_2 -> \[Nu]\_2 - 
              1\) /. \[Nu]\_3 -> \[Nu]\_3 - 1\)], "Input"],

Cell[BoxData[
    \(f\_7113 = 
      MakeFun[h\_7113, "\<(7113)\>", 
        IFF[\[Nu]\_2 > 1 && \[Nu]\_3 > 1 && D\_\(3, 2, 1\) =!= 0]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_7113]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (78)", "Subsection",
  CellTags->"T1.6.56.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_1 > 0\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_78\), "=", 
        RowBox[{
          RowBox[{
          "2", \(m\_1\%2\), 
            " ", \(D\_\(1, 2, 3\)\), \(\[Nu]\_1\), \((\[Nu]\_1 + 1)\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              
              RowBox[{\(\(-\[CapitalSigma]\_3\) \((d - \[Nu]\_1 - \[Nu]\_2 - \
\[Nu]\_3)\) \[Rho]\_\(1, 2, 3\)\), "+", 
                
                RowBox[{\(m\_2\%2\), \(m\_3\%2\), \(\[Phi]\_\(1, 2, 
                      3\)\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(1\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "-"],
                    Editable->True]}], "+", 
                
                RowBox[{\(m\_1\%2\), \(m\_3\%2\), \(\[Phi]\_\(2, 1, 
                      3\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(2\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "-"],
                    Editable->True]}], "+", 
                
                RowBox[{\(m\_1\%2\), \(m\_2\%2\), \(\[Phi]\_\(3, 1, 
                      2\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(3\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "-"],
                    Editable->True]}], "+", 
                
                RowBox[{\((d - 2 - 2  \[Nu]\_1)\), \(D\_\(1, 2, 
                      3\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(m\_1\%2\), \(S\_\(1, 2, 3\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(m\_2\%2\), \(S\_\(2, 1, 3\)\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(m\_3\%2\), \(S\_\(3, 1, 2\)\), \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_78 = OperatorApplyJ[e\_78]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (78)", "Subsection",
  CellTags->"T1.6.57.1"],

Cell[BoxData[
    \(h\_78 = \[Nu]explicit[s\_78] /. \[Nu]\_1 -> \[Nu]\_1 - 2\)], "Input"],

Cell[BoxData[
    \(f\_78 = 
      MakeFun[h\_78, "\<(78)\>", 
        IFF[\(\[Nu]\_1 > 2 && m1 =!= 0\) && D\_\(1, 2, 3\) =!= 0]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_78]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (80)", "Subsection",
  CellTags->"T1.6.58.1"],

Cell[TextData[{
  Cell[BoxData[
      \(m\_1\%2 == 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_1 > 0\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_80\), "=", 
        RowBox[{
          
          RowBox[{\(\[Nu]\_1\), 
            " ", \((d - 2\ \[Nu]\_1 - 2)\), \(\[CapitalDelta]\_\(2, 3, 6\)\), 
            
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-4\), \(m\_2\%2\), \(m\_3\%2\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(1\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "-"],
                    Editable->True]}], "+", "\n", "\t\t\t\t", 
                RowBox[{"2", \(m\_2\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[\(p\^2\),
                              PP], "-", \(m\_2\%2\)}], 
                          ")"}], \((2  d - 2  \[Nu]\_1 - \[Nu]\_2 - 
                            2  \[Nu]\_3 - 1)\)}], 
                      "-", \(\(m\_3\%2\) \((2  \[Nu]\_1 - \[Nu]\_2 - 1)\)\)}],
                     ")"}], \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "+", "\n", "\t\t\t  ", 
                RowBox[{"2", " ", \(m\_3\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[\(p\^2\),
                              PP], "-", \(m\_3\%2\)}], 
                          ")"}], \((2  d - 2  \[Nu]\_1 - 
                            2  \[Nu]\_2 - \[Nu]\_3 - 1)\)}], 
                      "-", \(\(m\_2\%2\) \((2  \[Nu]\_1 - \[Nu]\_3 - 1)\)\)}],
                     ")"}], \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "-", "\n", 
                "\t\t\t\t", \(\(\[CapitalSigma]\_3\) \((d - \[Nu]\_1 - \
\[Nu]\_2 - \[Nu]\_3)\) u\_\(6, 2, 3\)\)}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_80 = OperatorApplyJ[e\_80]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (80)", "Subsection",
  CellTags->"T1.6.59.1"],

Cell[BoxData[
    \(h\_80 = \[Nu]explicit[
          s\_80] /. \[Nu]\_1 \[Rule] \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    \(f\_80 = 
      MakeFun[h\_80, "\<(80)\>", 
        IFF[\[Nu]\_1 > 1 && \[CapitalDelta]\_\(2, 3, 6\) =!= 0], 
        m1 :> 0]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_80]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (81)", "Subsection",
  CellTags->"T1.6.60.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_1, \[Nu]\_2 > 0\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_81\), "=", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(p\^2\),
              PP], \((\[CapitalSigma]\_3 + 2)\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], \(\[Nu]\_2\), 
            InterpretationBox[
              StyleBox[\(2\^+\),
                FontWeight->"Bold"],
              Schiebe[ 2, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d + 2\),
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Plus[ 2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  InterpretationBox[\(p\^2\),
                    PP], \((d - 2  \[Nu]\_3)\)}], 
                "+", \(\(m\_1\%2\) \((d - \[Nu]\_1 - 2  \[Nu]\_2)\)\), 
                "+", \(\(m\_2\%2\) \((d - 2  \[Nu]\_1 - \[Nu]\_2)\)\), 
                "-", \(2 \( 
                      m\_3\%2\) \((d - \[Nu]\_1 - \[Nu]\_2 - \[Nu]\_3)\)\), 
                "-", 
                RowBox[{"2", \(m\_3\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "-", \(m\_3\%2\)}], ")"}], \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(m\_1\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "-", \(m\_1\%2\), "-", \(3  m\_2\%2\), 
                      "+", \(3  m\_3\%2\), "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True], "+", 
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True]}], ")"}], \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(m\_2\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "-", \(3  m\_1\%2\), "-", \(m\_2\%2\), 
                      "+", \(3  m\_3\%2\), "-", 
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True], "+", 
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True]}], ")"}], \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_81 = OperatorApplyJ[e\_81]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (81)", "Subsection",
  CellTags->"T1.6.61.1"],

Cell[BoxData[
    \(h\_81 = \(\(\[Nu]explicit[
              s\_81] /. \[Nu]\_1 -> \[Nu]\_1 - 1\) /. \[Nu]\_2 -> \[Nu]\_2 - 
              1\) /. d -> d - 2\)], "Input"],

Cell[BoxData[
    \(f\_81 = 
      MakeFun[h\_81, "\<(81)\>", 
        IFF[PP =!= 0 && \[Nu]\_1 > 1 && \[Nu]\_2 > 1 && 
            MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_81]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (8123)", "Subsection",
  CellTags->"T1.6.62.1"],

Cell[BoxData[
    \(h\_8123 = \(\(Interchange[s\_81, 
              2 \[LeftRightArrow] 3] /. \[Nu]\_1 -> \[Nu]\_1 - 
                1\) /. \[Nu]\_3 -> \[Nu]\_3 - 1\) /. d -> d - 2\)], "Input"],

Cell[BoxData[
    \(f\_8123 = 
      MakeFun[h\_8123, "\<(8123)\>", 
        IFF[PP =!= 0 && \[Nu]\_1 > 1 && \[Nu]\_3 > 1 && 
            MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_8123]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (8113)", "Subsection",
  CellTags->"T1.6.63.1"],

Cell[BoxData[
    \(h\_8113 = \(\(Interchange[s\_81, 
              1 \[LeftRightArrow] 3] /. \[Nu]\_2 \[Rule] \[Nu]\_2 - 
                1\) /. \[Nu]\_3 \[Rule] \[Nu]\_3 - 1\) /. 
        d \[Rule] d - 2\)], "Input"],

Cell[BoxData[
    \(f\_8113 = 
      MakeFun[h\_8113, "\<(8113)\>", 
        IFF[PP =!= 0 && \[Nu]\_2 > 1 && \[Nu]\_3 > 1 && 
            MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_8113]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (82)", "Subsection",
  CellTags->"T1.6.64.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_1 > 0\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_82\), "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"-", 
                InterpretationBox[\(p\^2\),
                  PP]}], \(m\_1\%2\), \((\[CapitalSigma]\_3 + 
                  2)\), \(\[Nu]\_1\), \((\[Nu]\_1 + 1)\), 
              InterpretationBox[
                StyleBox[\(1\^+\),
                  FontWeight->"Bold"],
                Schiebe[ 1, "+"],
                Editable->True], 
              InterpretationBox[
                StyleBox[\(1\^+\),
                  FontWeight->"Bold"],
                Schiebe[ 1, "+"],
                Editable->True], 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["J",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox[\(\[Nu]\_1\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_2\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_3\),
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox[\(d + 2\),
                      "TraditionalForm"], ")"}]],
                TJI[ 
                  Plus[ 2, d], {
                  Subscript[ \[Nu], 1], 
                  Subscript[ \[Nu], 2], 
                  Subscript[ \[Nu], 3]}],
                Editable->True]}], "+", 
            RowBox[{\(1\/2\), 
              InterpretationBox[\(p\^2\),
                
                PP], \((\[CapitalSigma]\_3 + 2)\), \((\[CapitalSigma]\_3 + 
                  4)\), \(\[Nu]\_1\), 
              InterpretationBox[
                StyleBox[\(1\^+\),
                  FontWeight->"Bold"],
                Schiebe[ 1, "+"],
                Editable->True], 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["J",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox[\(\[Nu]\_1\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_2\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_3\),
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox[\(d + 2\),
                      "TraditionalForm"], ")"}]],
                TJI[ 
                  Plus[ 2, d], {
                  Subscript[ \[Nu], 1], 
                  Subscript[ \[Nu], 2], 
                  Subscript[ \[Nu], 3]}],
                Editable->True]}]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-\(1\/2\)\), 
                  SuperscriptBox[
                    RowBox[{"(", 
                      InterpretationBox[\(p\^2\),
                        PP], ")"}], 
                    "2"], \((d + 2  \[Nu]\_1 - 2  \[Nu]\_2 - 2  \[Nu]\_3)\)}],
                 "+", 
                RowBox[{\(1\/2\), 
                  InterpretationBox[\(p\^2\),
                    
                    PP], \((\(m\_1\%2\) \((6  \[Nu]\_1 + 6  \[Nu]\_2 + 
                            6  \[Nu]\_3 - 7  d)\) + \(m\_2\%2\) \((7  d - 
                            2  \[Nu]\_1 - 4  \[Nu]\_2 - 
                            10  \[Nu]\_3)\) + \(m\_3\%2\) \((7  d - 
                            2  \[Nu]\_1 - 10  \[Nu]\_2 - 4  \[Nu]\_3)\))\)}], 
                "+", \(\(\((m\_2\%2)\)\^2\) \((d - 
                      2  \[Nu]\_1 - \[Nu]\_2)\)\), 
                "+", \(\(\((m\_3\%2)\)\^2\) \((d - 
                      2  \[Nu]\_1 - \[Nu]\_3)\)\), 
                "+", \(\(m\_1\%2\) \(m\_2\%2\) \((d - \[Nu]\_1 - 
                      2  \[Nu]\_2)\)\), 
                "+", \(\(m\_1\%2\) \(m\_3\%2\) \((d - \[Nu]\_1 - 
                      2  \[Nu]\_3)\)\), 
                "-", \(4 \( 
                      m\_2\%2\) \(m\_3\%2\) \((d - \[Nu]\_1 - \[Nu]\_2 - \
\[Nu]\_3)\)\), "-", 
                RowBox[{\(m\_1\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{"2", 
                        SuperscriptBox[
                          RowBox[{"(", 
                            InterpretationBox[\(p\^2\),
                              PP], ")"}], "2"]}], "-", 
                      RowBox[{
                        InterpretationBox[\(p\^2\),
                          PP], \((2  m\_1\%2 + m\_2\%2 + m\_3\%2)\)}], 
                      "+", \(\(m\_1\%2\) \((m\_2\%2 + m\_3\%2)\)\), 
                      "+", \(3 \((m\_2\%2 - m\_3\%2)\)\^2\)}], 
                    ")"}], \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(m\_2\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          InterpretationBox[\(p\^2\),
                            PP], ")"}], "2"], "+", 
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[\(p\^2\),
                              PP], "-", \(m\_2\%2\)}], ")"}], 
                        RowBox[{"(", 
                          RowBox[{\(3  m\_1\%2\), "-", \(5  m\_3\%2\), "+", 
                            InterpretationBox[
                              StyleBox[\(1\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 1, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(3\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 3, "-"],
                              Editable->True]}], ")"}]}], 
                      "-", \(\((m\_2\%2)\)\^2\)}], ")"}], \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(m\_3\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          InterpretationBox[\(p\^2\),
                            PP], ")"}], "2"], "+", 
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[\(p\^2\),
                              PP], "-", \(m\_3\%2\)}], ")"}], 
                        RowBox[{"(", 
                          RowBox[{\(3  m\_1\%2\), "-", \(5  m\_2\%2\), "+", 
                            InterpretationBox[
                              StyleBox[\(1\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 1, "-"],
                              Editable->True], "-", 
                            InterpretationBox[
                              StyleBox[\(2\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 2, "-"],
                              Editable->True]}], ")"}]}], 
                      "-", \(\((m\_3\%2)\)\^2\)}], ")"}], \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "-", 
                RowBox[{\(1\/2\), 
                  InterpretationBox[\(p\^2\),
                    PP], \((\[CapitalSigma]\_3 + 2)\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True]}], ")"}]}], "-", 
                RowBox[{\(m\_1\%2\), \((m\_2\%2 - m\_3\%2)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True]}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(r\_82 = OperatorApplyJ[e\_82]\)], "Input"],

Cell[BoxData[
    \(r\_82[\([1, 1]\)]\)], "Input"],

Cell[BoxData[
    \(\(s\_82 = \((r\_82[\([1, 2]\)] == \(-r\_82[\([1, 1]\)]\) + 
              r\_82[\([2]\)])\);\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (82)", "Subsection",
  CellTags->"T1.6.65.1"],

Cell[BoxData[
    \(h\_82 = \(\[Nu]explicit[s\_82] /. \[Nu]\_1 -> \[Nu]\_1 - 2\) /. 
        d -> d - 2\)], "Input"],

Cell[BoxData[
    \(f\_82 = 
      MakeFun[h\_82, "\<(82)\>", 
        IFF[\(PP =!= 0 && \[Nu]\_1 > 2 && m1 =!= 0\) && 
            MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_82]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (8213)", "Subsection",
  CellTags->"T1.6.66.1"],

Cell[BoxData[
    \(h\_8213 = \(Interchange[s\_82, 
            1 \[LeftRightArrow] 3] /. \[Nu]\_3 -> \[Nu]\_3 - 2\) /. 
        d -> d - 2\)], "Input"],

Cell[BoxData[
    \(f\_8213 = 
      MakeFun[h\_8213, "\<(8213)\>", 
        IFF[\(PP =!= 0 && m3 =!= 0\) && \[Nu]\_3 > 2 && 
            MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_8213]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (8212)", "Subsection",
  CellTags->"T1.6.67.1"],

Cell[BoxData[
    \(h\_8212 = \(Interchange[s\_82, 
            1 \[LeftRightArrow] 2] /. \[Nu]\_2 -> \[Nu]\_2 - 2\) /. 
        d -> d - 2\)], "Input"],

Cell[BoxData[
    \(f\_8212 = 
      MakeFun[h\_8212, "\<(8212)\>", 
        IFF[\(PP =!= 0 && \[Nu]\_2 > 2 && m2 =!= 0\) && 
            MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_8212]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (83)", "Subsection",
  CellTags->"T1.6.68.1"],

Cell[TextData[{
  Cell[BoxData[
      \(m\_1\%2 == 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Nu]\_1 > 0\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_83\), "=", 
        RowBox[{
          RowBox[{
            InterpretationBox[\(p\^2\),
              
              PP], \((\[CapitalSigma]\_3 + 2)\), \((\[CapitalSigma]\_3 + 
                4)\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d + 2\),
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Plus[ 2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  RowBox[{"-", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        InterpretationBox[\(p\^2\),
                          PP], ")"}], "2"]}], \((d + 2  \[Nu]\_1 - 
                      2  \[Nu]\_2 - 2  \[Nu]\_3)\)}], "+", 
                RowBox[{
                  InterpretationBox[\(p\^2\),
                    
                    PP], \((\(m\_2\%2\) \((7  d - 2  \[Nu]\_1 - 4  \[Nu]\_2 - 
                            10  \[Nu]\_3)\) + \(m\_3\%2\) \((7  d - 
                            2  \[Nu]\_1 - 10  \[Nu]\_2 - 4  \[Nu]\_3)\))\)}], 
                "+", \(2 \(\((m\_2\%2)\)\^2\) \((d - 
                      2  \[Nu]\_1 - \[Nu]\_2)\)\), 
                "+", \(2 \(\((m\_3\%2)\)\^2\) \((d - 
                      2  \[Nu]\_1 - \[Nu]\_3)\)\), 
                "-", \(8 \( 
                      m\_2\%2\) \(m\_3\%2\) \((d - \[Nu]\_1 - \[Nu]\_2 - \
\[Nu]\_3)\)\), "+", 
                RowBox[{"2", \(m\_2\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          InterpretationBox[\(p\^2\),
                            PP], ")"}], "2"], "-", 
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[\(p\^2\),
                              PP], "-", \(m\_2\%2\)}], ")"}], 
                        RowBox[{"(", 
                          RowBox[{\(5  m\_3\%2\), "-", 
                            InterpretationBox[
                              StyleBox[\(1\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 1, "-"],
                              Editable->True], "+", 
                            InterpretationBox[
                              StyleBox[\(3\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 3, "-"],
                              Editable->True]}], ")"}]}], 
                      "-", \(\((m\_2\%2)\)\^2\)}], ")"}], \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "+", 
                RowBox[{"2", \(m\_3\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      SuperscriptBox[
                        RowBox[{"(", 
                          InterpretationBox[\(p\^2\),
                            PP], ")"}], "2"], "-", 
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[\(p\^2\),
                              PP], "-", \(m\_3\%2\)}], ")"}], 
                        RowBox[{"(", 
                          RowBox[{\(5  m\_2\%2\), "-", 
                            InterpretationBox[
                              StyleBox[\(1\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 1, "-"],
                              Editable->True], "+", 
                            InterpretationBox[
                              StyleBox[\(2\^-\),
                                FontWeight->"Bold"],
                              Schiebe[ 2, "-"],
                              Editable->True]}], ")"}]}], 
                      "-", \(\((m\_3\%2)\)\^2\)}], ")"}], \(\[Nu]\_3\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "-", 
                RowBox[{
                  InterpretationBox[\(p\^2\),
                    PP], \((\[CapitalSigma]\_3 + 2)\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True]}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_83 = OperatorApplyJ[e\_83]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (83)", "Subsection",
  CellTags->"T1.6.69.1"],

Cell[BoxData[
    \(h\_83 = \(\[Nu]explicit[s\_83] /. \[Nu]\_1 -> \[Nu]\_1 - 1\) /. 
        d -> d - 2\)], "Input"],

Cell[BoxData[
    \(f\_83 = 
      MakeFun[h\_83, "\<(83)\>", 
        IFF[PP =!= 0 && \[Nu]\_1 > 1 && 
            MatchQ[d, _Symbol + _Integer?Positive]], m1 :> 0]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_83]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (87)", "Subsection",
  CellTags->"T1.6.70.1"],

Cell[CellGroupData[{

Cell["(88)", "Subsubsection",
  CellTags->"T1.6.70.1.1"],

Cell[BoxData[
    \(\(t\_1 = m\_1\%2 + m\_2\%2 + m\_3\%2;\)\)], "Input"],

Cell[BoxData[
    \(\(t\_2 = 
        3 \((m\_1\%4 + m\_2\%4 + m\_3\%4)\) + 
          2 \((\(m\_1\%2\) m\_2\%2 + \(m\_1\%2\) m\_3\%2 + \(m\_2\%2\) 
                  m\_3\%2)\);\)\)], "Input"],

Cell[BoxData[
    \(\(t\_3 = \(m\_1\%2\) \((m\_1\%4 - m\_2\%4 - 
                m\_3\%4)\) + \(m\_2\%2\) \((m\_2\%4 - m\_1\%4 - 
                m\_3\%4)\) + \(m\_3\%2\) \((m\_3\%4 - m\_1\%4 - m\_2\%4)\) + 
          10 \( m\_1\%2\) \(m\_2\%2\) m\_3\%2;\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(f[\[Mu]1_, \[Mu]2_, \ \[Mu]3_]\), ":=", 
        RowBox[{"\[Mu]1", 
          RowBox[{"(", 
            RowBox[{
              InterpretationBox[\(p\^2\),
                PP], "-", "\[Mu]1"}], ")"}], 
          RowBox[{"(", 
            RowBox[{
              RowBox[{\(-2\), \((d - 4)\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    InterpretationBox[\(p\^2\),
                      PP], ")"}], "2"]}], "+", 
              RowBox[{
                InterpretationBox[\(p\^2\),
                  
                  PP], \((4 \( t\_1\) \((5  d - 18)\) - 
                    24  \[Mu]1 \((2  d - 7)\))\)}], 
              "-", \(2 \((4  d - 13)\) t\_1\^2\), 
              "+", \(2 \((9  d - 31)\) t\_2\), 
              "-", \(24  \[Mu]2\ \[Mu]3 \((4  d - 13)\)\), 
              "-", \(24\ \(\[Mu]1\^2\) \((2  d - 7)\)\)}], ")"}]}]}], 
      ";"}]], "Input"],

Cell[BoxData[
    \(\(f\_\(1, 2, 3\) = f[m\_1\%2, m\_2\%2, m\_3\%2];\)\)], "Input"],

Cell[BoxData[
    \(\(f\_\(2, 1, 3\) = f[m\_2\%2, m\_1\%2, m\_3\%2];\)\)], "Input"],

Cell[BoxData[
    \(\(f\_\(3, 2, 1\) = f[m\_3\%2, m\_2\%2, m\_1\%2];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["(89)", "Subsubsection",
  CellTags->"T1.6.70.2.1"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(g[\[Mu]1_, \[Mu]2_, \ \[Mu]3_]\), ":=", 
        RowBox[{\(\(\[Mu]1\ \[Mu]2\)\/\(d - 4\)\), 
          RowBox[{"(", 
            RowBox[{
              RowBox[{"4", \((d - 4)\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    InterpretationBox[\(p\^2\),
                      PP], ")"}], "2"]}], "-", 
              RowBox[{"4", \((7  d - 24)\), 
                InterpretationBox[\(p\^2\),
                  PP], \((3  \[Mu]3 - 2  t\_1)\)}], 
              "-", \(\(t\_1\^2\) \((23  d - 80)\)\), 
              "+", \(\(t\_2\) \((9  d - 32)\)\), 
              "-", \(12 \( \[Mu]3\^2\) \((d - 4)\)\), 
              "+", \(12  \[Mu]1\ \[Mu]2\ \((7  d - 24)\)\)}], ")"}]}]}], 
      ";"}]], "Input"],

Cell[BoxData[
    \(\(g\_\(1, 2, 3\) = g[m\_1\%2, m\_2\%2, m\_3\%2];\)\)], "Input"],

Cell[BoxData[
    \(\(g\_\(1, 3, 2\) = g[m\_1\%2, m\_3\%2, m\_2\%2];\)\)], "Input"],

Cell[BoxData[
    \(\(g\_\(2, 3, 1\) = g[m\_2\%2, m\_3\%2, m\_1\%2];\)\)], "Input"],

Cell[BoxData[
    \(g\_\(1, 2, 3\)\)], "Input"],

Cell[TextData[{
  "general  ",
  Cell[BoxData[
      \(m\_i\%2\)]],
  " "
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_87\), "=", 
        RowBox[{
          RowBox[{"3", 
            InterpretationBox[\(p\^2\),
              PP], \((d - 3)\), \((d - 4)\), \((3  d - 8)\), \((3  d - 10)\), 
            
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {1, 1, 1}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(\((d - 4)\)\^2\), 
                  SuperscriptBox[
                    RowBox[{"(", 
                      InterpretationBox[\(p\^2\),
                        PP], ")"}], "3"]}], "-", 
                RowBox[{"2", 
                  SuperscriptBox[
                    RowBox[{"(", 
                      InterpretationBox[\(p\^2\),
                        PP], ")"}], 
                    "2"], \(t\_1\), \((d - 4)\), \((6  d - 23)\)}], "+", 
                RowBox[{
                  InterpretationBox[\(p\^2\),
                    
                    PP], \((5 \( t\_1\^2\) \((15  d\^2 - 117  d + 
                            224)\) - \(t\_2\) \((42  d\^2 - 331  d + 
                            640)\))\)}], 
                "-", \(\(1\/4\) \((d - 
                      5)\) \((\(t\_3\) \((27  d - 
                            90)\) - \(t\_1\) \(t\_2\) \((3  d - 2)\) - 
                      2 \( t\_1\^3\) \((5  d - 26)\))\)\), "+", 
                RowBox[{\(f\_\(1, 2, 3\)\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(f\_\(2, 1, 3\)\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(f\_\(3, 2, 1\)\), 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(g\_\(1, 2, 3\)\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(3\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "-"],
                    Editable->True]}], "+", 
                RowBox[{\(g\_\(1, 3, 2\)\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(2\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "-"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "+", 
                RowBox[{\(g\_\(2, 3, 1\)\), 
                  InterpretationBox[
                    StyleBox[\(1\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "-"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d - 2\),
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Plus[ -2, d], {1, 1, 1}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_87 = OperatorApplyJ[e\_87]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (87)", "Subsection",
  CellTags->"T1.6.71.1"],

Cell[BoxData[
    \(h\_87 = s\_87\)], "Input"],

Cell[BoxData[
    \(\(f\_87 = 
        MakeFun[h\_87, "\<(87)\>", 
          IFF[PP =!= 0 && 
              MatchQ[d, _Symbol + _Integer?Positive]]];\)\)], "Input"],

Cell["CheckTJIRecursion not applicable.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (90)", "Subsection",
  CellTags->"T1.6.72.1"],

Cell[TextData[{
  "general  ",
  Cell[BoxData[
      \(m\_i\%2\)]],
  " "
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_90\), "=", 
        RowBox[{
          RowBox[{"3", 
            InterpretationBox[\(p\^2\),
              PP], \((d - 3)\), \((d - 4)\), \((3  d - 10)\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {1, 1, 1}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-m\_1\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        SuperscriptBox[
                          RowBox[{"(", 
                            InterpretationBox[\(p\^2\),
                              PP], ")"}], "2"], \((7  d - 24)\)}], "-", 
                      RowBox[{"2", 
                        InterpretationBox[\(p\^2\),
                          
                          PP], \((\((4  d - 15)\) t\_1 - \((d - 5)\) 
                              m\_1\%2)\)}], 
                      "+", \(\(3\/2\) \((d - 5)\) t\_1\^2\), 
                      "+", \(\(5\/2\) \((d - 3)\) t\_2\), 
                      "-", \(2 \((5  d - 17)\) \((m\_1\%2)\)\^2\), 
                      "-", \(2 \((13  d - 45)\) \(m\_2\%2\) m\_3\%2\)}], 
                    ")"}], 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", "\n", "\t\t\t\t", 
                RowBox[{"2", \(m\_2\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "-", \(m\_2\%2\)}], ")"}], 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\((d - 3)\), 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[\(p\^2\),
                              PP], "+", \(m\_2\%2\), "-", \(5  m\_3\%2\)}], 
                          ")"}]}], "+", \(\((7  d - 25)\) m\_1\%2\)}], ")"}], 
                  
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True]}], "+", "\n", "\t\t\t\t", 
                RowBox[{"2", \(m\_3\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[\(p\^2\),
                        PP], "-", \(m\_3\%2\)}], ")"}], 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\((d - 3)\), 
                        RowBox[{"(", 
                          RowBox[{
                            InterpretationBox[\(p\^2\),
                              PP], "-", \(5  m\_2\%2\), "+", \(m\_3\%2\)}], 
                          ")"}]}], "+", \(\((7  d - 25)\) m\_1\%2\)}], ")"}], 
                  
                  InterpretationBox[
                    StyleBox[\(3\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 3, "+"],
                    Editable->True]}], "-", "\n", "\t\t\t\t", 
                RowBox[{\((d - 3)\), \((d - 4)\), 
                  SuperscriptBox[
                    RowBox[{"(", 
                      InterpretationBox[\(p\^2\),
                        PP], ")"}], "2"]}], "+", 
                RowBox[{
                  InterpretationBox[\(p\^2\),
                    
                    PP], \((\((7  d - 30)\) \((d - 3)\) 
                        t\_1 - \((7  d - 31)\) \((3  d - 10)\) m\_1\%2)\)}], 
                "+", \(\(1\/4\) \((d - 
                      5)\) \((\((17  d - 66)\) t\_1\^2 - \((3  d - 14)\) 
                        t\_2 - 
                      4 \((3  d - 10)\) \((\((m\_1\%2)\)\^2 + 
                            5 \( m\_2\%2\) m\_3\%2)\))\)\), "+", "\t", 
                RowBox[{\(2\/\(d - 4\)\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              RowBox[{"(", 
                                RowBox[{
                                  InterpretationBox[\(p\^2\),
                                    PP], "+", \(m\_2\%2\)}], 
                                ")"}], \((7  d - 24)\)}], 
                            "+", \(\((d - 4)\) m\_1\%2\), 
                            "-", \(\((5  d - 18)\) m\_3\%2\)}], 
                          ")"}], \(m\_1\%2\), \(m\_2\%2\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(2\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 2, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(3\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "-"],
                          Editable->True]}], "+", "\n", "\t\t\t\t\t\t", 
                      RowBox[{
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              RowBox[{"(", 
                                RowBox[{
                                  InterpretationBox[\(p\^2\),
                                    PP], "+", \(m\_3\%2\)}], 
                                ")"}], \((7  d - 24)\)}], 
                            "+", \(\((d - 4)\) m\_1\%2\), 
                            "-", \(\((5  d - 18)\) m\_2\%2\)}], 
                          ")"}], \(m\_1\%2\), \(m\_3\%2\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(2\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 2, "-"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(3\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "+"],
                          Editable->True]}], "-", "\n", "\t\t\t\t\t\t", 
                      RowBox[{"2", 
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              RowBox[{"(", 
                                RowBox[{
                                  InterpretationBox[\(p\^2\),
                                    PP], "+", \(m\_2\%2\), "+", \(m\_3\%2\)}],
                                 ")"}], \((d - 3)\)}], 
                            "+", \(\((d - 4)\) m\_1\%2\)}], 
                          ")"}], \(m\_2\%2\), \(m\_3\%2\), 
                        InterpretationBox[
                          StyleBox[\(1\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "-"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(2\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 2, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(3\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "+"],
                          Editable->True]}]}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"], 
                  FormBox["1",
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d - 2\),
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Plus[ -2, d], {1, 1, 1}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_90 = OperatorApplyJ[e\_90]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (90)", "Subsection",
  CellTags->"T1.6.73.1"],

Cell[BoxData[
    \(\(h\_90 = s\_90;\)\)], "Input"],

Cell[BoxData[
    \(f\_90 = 
      MakeFun[h\_90, "\<(90)\>", 
        IFF[PP =!= 0 && MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"],

Cell["CheckTJIRecursion not applicable.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (91)", "Subsection",
  CellTags->"T1.6.74.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_91.1\), "=", " ", 
        RowBox[{
          RowBox[{\((d - 2)\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TKI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{\(-u\_\(1, 2, 3\)\), "-", 
                InterpretationBox[
                  StyleBox[\(1\^-\),
                    FontWeight->"Bold"],
                  Schiebe[ 1, "-"],
                  Editable->True], "+", 
                InterpretationBox[
                  StyleBox[\(2\^-\),
                    FontWeight->"Bold"],
                  Schiebe[ 2, "-"],
                  Editable->True], "+", 
                InterpretationBox[
                  StyleBox[\(3\^-\),
                    FontWeight->"Bold"],
                  Schiebe[ 3, "-"],
                  Editable->True]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d - 2\),
                    "TraditionalForm"], ")"}]],
              TKI[ 
                Plus[ -2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_91.1 = OperatorApplyK[e\_91.1]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_91.2\), "=", 
        RowBox[{
          RowBox[{\((d - 2)\), \(\[Nu]\_2\), 
            InterpretationBox[
              StyleBox[\(2\^+\),
                FontWeight->"Bold"],
              Schiebe[ 2, "+"],
              Editable->True], \(\[Nu]\_3\), 
            InterpretationBox[
              StyleBox[\(3\^+\),
                FontWeight->"Bold"],
              Schiebe[ 3, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TKI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(-2\), \(m\_1\%2\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True]}], "+", \((d - 2 - 2  \[Nu]\_1)\)}], 
              ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d - 2\),
                    "TraditionalForm"], ")"}]],
              TKI[ 
                Plus[ -2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_91.2 = OperatorApplyK[e\_91.2]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_91.3\), "=", 
        RowBox[{
          RowBox[{\((d - 2)\), \((d - \[Nu]\_1 - \[Nu]\_2 - \[Nu]\_3)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TKI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{"(", 
                RowBox[{\(\[CapitalDelta]\_\(1, 2, 3\)\), "+", 
                  RowBox[{\(u\_\(1, 2, 3\)\), 
                    InterpretationBox[
                      StyleBox[\(1\^-\),
                        FontWeight->"Bold"],
                      Schiebe[ 1, "-"],
                      Editable->True]}], "+", 
                  RowBox[{\(u\_\(2, 1, 3\)\), 
                    InterpretationBox[
                      StyleBox[\(2\^-\),
                        FontWeight->"Bold"],
                      Schiebe[ 2, "-"],
                      Editable->True]}], "+", 
                  RowBox[{\(u\_\(3, 1, 2\)\), 
                    InterpretationBox[
                      StyleBox[\(3\^-\),
                        FontWeight->"Bold"],
                      Schiebe[ 3, "-"],
                      Editable->True]}]}], ")"}]}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d - 2\),
                    "TraditionalForm"], ")"}]],
              TKI[ 
                Plus[ -2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_91.3 = OperatorApplyK[e\_91.3]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_91.4\), "=", 
        RowBox[{
          RowBox[{\(\[CapitalDelta]\_\(1, 2, 3\)\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TKI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              
              RowBox[{\(\(u\_\(1, 2, 3\)\) \((d - \[Nu]\_1 - 2  \[Nu]\_2)\)\),
                 "+", \(2 \( m\_2\%2\) \((\[Nu]\_1 - \[Nu]\_2)\)\), "+", 
                RowBox[{\(u\_\(3, 1, 2\)\), \(\[Nu]\_1\), 
                  InterpretationBox[
                    StyleBox[\(1\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(2\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 2, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True]}], ")"}]}], "+", 
                RowBox[{"2", \(m\_2\%2\), \(\[Nu]\_2\), 
                  InterpretationBox[
                    StyleBox[\(2\^+\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "+"],
                    Editable->True], 
                  RowBox[{"(", 
                    RowBox[{
                      InterpretationBox[
                        StyleBox[\(1\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 1, "-"],
                        Editable->True], "-", 
                      InterpretationBox[
                        StyleBox[\(3\^-\),
                          FontWeight->"Bold"],
                        Schiebe[ 3, "-"],
                        Editable->True]}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TKI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_91.4 = OperatorApplyK[e\_91.4]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (911)", "Subsection",
  CellTags->"T1.6.75.1"],

Cell[BoxData[
    \(h\_911 = s\_91.1 /. \[Nu]\_1 -> \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    \(f\_911 = 
      MakeFun[h\_911, "\<(911)\>", 
        IFF[\[Nu]\_1 > 1 && 
            MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"],

Cell["CheckTJIRecursion not applicable.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (912)", "Subsection",
  CellTags->"T1.6.76.1"],

Cell[BoxData[
    \(h\_912 = \(s\_91.2 /. \[Nu]\_2 -> \[Nu]\_2 - 
              1\) /. \[Nu]\_3 -> \[Nu]\_3 - 1\)], "Input"],

Cell[BoxData[
    \(f\_912 = 
      MakeFun[h\_912, "\<(912)\>", 
        IFF[\[Nu]\_2 > 1 && \[Nu]\_3 > 1 && 
            MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"],

Cell["CheckTJIRecursion not applicable.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (913)", "Subsection",
  CellTags->"T1.6.77.1"],

Cell[BoxData[
    \(h\_913 = s\_91.3\)], "Input"],

Cell[BoxData[
    \(f\_913 = 
      MakeFun[h\_913, "\<(913)\>", 
        IFF[\((n2 === 1\  || \ n3 === 1)\) && 
            MatchQ[d, _Symbol + _Integer?Positive]], n1 :> 1]\)], "Input"],

Cell["CheckTJIRecursion not applicable.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (914)", "Subsection",
  CellTags->"T1.6.78.1"],

Cell[BoxData[
    \(h\_914 = s\_91.4 /. \[Nu]\_1 -> \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    \(f\_914 = 
      MakeFun[h\_914, "\<(914)\>", 
        IFF[\[CapitalDelta]\_\(1, 2, 3\) =!= 0 && \((\[Nu]\_1\  > \ 1\ )\) && 
            MatchQ[d, _Symbol]]]\)], "Input"],

Cell["CheckTJIRecursion not applicable.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (92)", "Subsection",
  CellTags->"T1.6.79.1"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_\(1, 2, 3\)\)]],
  " = Cayley[1,2,3][{m1,m2,m3}]"
}], "Text"],

Cell[BoxData[
    \(\(Cayley[1, 2, 3]\)[{m1, m2, m3}]\)], "Input"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\((\ 
        m\_1\%2 == \((m\_2 + m\_3)\)\^2\ )\)\ \[DoubleLongRightArrow]\ \((\ \
\[CapitalDelta]\_\(1, 2, 3\) == 0\ )\)\)]]], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_92\), "=", 
        RowBox[{
          RowBox[{
          "2", \(m\_2\), \(m\_3\), \((m\_2 + m\_3)\), \((d - 2  \[Nu]\_1 - 
                2  \[Nu]\_2 - 2  \[Nu]\_3 - 1)\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TKI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(m\_2\), 
                  RowBox[{"(", 
                    RowBox[{
                      
                      RowBox[{\((d - \[Nu]\_1 - \[Nu]\_2 - 2  \[Nu]\_3 - 1)\),
                         
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              InterpretationBox[
                                StyleBox[\(1\^+\),
                                  FontWeight->"Bold"],
                                Schiebe[ 1, "+"],
                                Editable->True], 
                              InterpretationBox[
                                StyleBox[\(2\^-\),
                                  FontWeight->"Bold"],
                                Schiebe[ 2, "-"],
                                Editable->True]}], "-", "1"}], ")"}]}], "+", 
                      RowBox[{\((\[Nu]\_1 - \[Nu]\_2 + 1)\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(3\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 3, "-"],
                          Editable->True]}]}], ")"}]}], "+", "\n", "\t\t\t", 
                RowBox[{\(m\_3\), 
                  RowBox[{"(", 
                    RowBox[{
                      
                      RowBox[{\((d - \[Nu]\_1 - 2  \[Nu]\_2 - \[Nu]\_3 - 1)\),
                         
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              InterpretationBox[
                                StyleBox[\(1\^+\),
                                  FontWeight->"Bold"],
                                Schiebe[ 1, "+"],
                                Editable->True], 
                              InterpretationBox[
                                StyleBox[\(3\^-\),
                                  FontWeight->"Bold"],
                                Schiebe[ 3, "-"],
                                Editable->True]}], "-", "1"}], ")"}]}], "+", 
                      RowBox[{\((\[Nu]\_1 - \[Nu]\_3 + 1)\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(2\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 2, "-"],
                          Editable->True]}]}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TKI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_92 = OperatorApplyK[e\_92]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (93)", "Subsection",
  CellTags->"T1.6.80.1"],

Cell[TextData[{
  "( ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\((m\_1 == 0)\)\  && \ \((m\_2 == 
                m\_3)\)\)\(\ \)\(\ \)\()\)\)\ \[DoubleLongRightArrow]\ \((\ \
\[CapitalDelta]\_\(1, 2, 3\) == 0\ )\)\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_93\), "=", 
        RowBox[{
          RowBox[{
          "2", \(m\_2\%2\), \((d - 2  \[Nu]\_1 - 2)\), \((d - 
                2  \[Nu]\_1 - \[Nu]\_2 - \[Nu]\_3 - 1)\), \((d - 
                2  \[Nu]\_1 - \[Nu]\_2 - \[Nu]\_3)\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TKI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          
          RowBox[{\((d - 2  \[Nu]\_1 - 2  \[Nu]\_3)\), \((d - 2  \[Nu]\_1 - 
                2  \[Nu]\_2)\), \((d - \[Nu]\_1 - \[Nu]\_2 - \[Nu]\_3)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TKI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_93 = OperatorApplyK[e\_93]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (93)", "Subsection",
  CellTags->"T1.6.81.1"],

Cell[BoxData[
    \(h\_93 = s\_93 /. \[Nu]\_1 -> \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    \(f\_93 = 
      MakeFun[h\_93, "\<(93)\>", 
        IFF[\[Nu]\_1 > 1 && m\_2 =!= 0], {m1 :> 0, m3 :> m2}]\)], "Input"],

Cell["CheckTJIRecursion not applicable.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (94)", "Subsection",
  CellTags->"T1.6.82.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_94\), "=", 
        RowBox[{
          RowBox[{\(\[CapitalDelta]\_\(1, 2, 6\)\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TBI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                RowBox[{\(u\_\(6, 1, 2\)\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_1\), 
                        InterpretationBox[
                          StyleBox[\(1\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(2\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 2, "-"],
                          Editable->True]}], "-", "d", "+", \(\[Nu]\_1\), 
                      "+", \(2  \[Nu]\_2\)}], ")"}]}], "+", 
                RowBox[{"2", \(m\_2\%2\), 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(\[Nu]\_2\), 
                        InterpretationBox[
                          StyleBox[\(2\^+\),
                            FontWeight->"Bold"],
                          Schiebe[ 2, "+"],
                          Editable->True], 
                        InterpretationBox[
                          StyleBox[\(1\^-\),
                            FontWeight->"Bold"],
                          Schiebe[ 1, "-"],
                          Editable->True]}], "-", "d", "+", \(2  \[Nu]\_1\), 
                      "+", \(\[Nu]\_2\)}], ")"}]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TBI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_94 = OperatorApplyB[e\_94]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (94)", "Subsection",
  CellTags->"T1.6.83.1"],

Cell[BoxData[
    \(h\_94 = s\_94 /. \[Nu]\_1 -> \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    \(f\_94 = 
      MakeFun[h\_94, "\<(94)\>", 
        IFF[\[CapitalDelta]\_\(1, 2, 6\) =!= 0 && \[Nu]\_1 > 1]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (9401)", "Subsection",
  CellTags->"T1.6.84.1"],

Cell[BoxData[
    \(n\_9401 = \(s\_94 /. \[CapitalDelta]\_\(1, 2, 6\) -> 0\) /. 
        u\_\(6, 1, 2\) -> 0\)], "Input"],

Cell[BoxData[
    \(h\_9401 = \(-n\_9401[\([2, 2]\)]\) == n\_9401[\([2, 1]\)]\)], "Input"],

Cell[BoxData[
    \(f\_9401 = 
      MakeFun[h\_9401, "\<(9401)\>", 
        IFF[\[CapitalDelta]\_\(1, 2, 6\) === 0 && u\_\(6, 1, 2\) === 0 && 
            m2 =!= 0]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (9402)", "Subsection",
  CellTags->"T1.6.85.1"],

Cell[BoxData[
    \(n\_9402 = 
      Interchange[\(s\_94 /. \[CapitalDelta]\_\(1, 2, 6\) -> 0\) /. 
          u\_\(6, 1, 2\) -> 0, 1 \[LeftRightArrow] 2]\)], "Input"],

Cell[BoxData[
    \(h\_9402 = \(-n\_9402[\([2, 1]\)]\) == n\_9402[\([2, 2]\)]\)], "Input"],

Cell[BoxData[
    \(f\_9402 = 
      MakeFun[h\_9402, "\<(9402)\>", 
        IFF[\[CapitalDelta]\_\(1, 2, 6\) === 0 && u\_\(6, 1, 2\) === 0 && 
            m1 =!= 0]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (95)", "Subsection",
  CellTags->"T1.6.86.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_95\), "=", 
        RowBox[{
          RowBox[{"2", 
            InterpretationBox[\(p\^2\),
              PP], \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TBI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{\(u\_\(1, 2, 6\)\), "+", 
                InterpretationBox[
                  StyleBox[\(1\^-\),
                    FontWeight->"Bold"],
                  Schiebe[ 1, "-"],
                  Editable->True], "-", 
                InterpretationBox[
                  StyleBox[\(2\^-\),
                    FontWeight->"Bold"],
                  Schiebe[ 2, "-"],
                  Editable->True]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d - 2\),
                    "TraditionalForm"], ")"}]],
              TBI[ 
                Plus[ -2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_95 = OperatorApplyB[e\_95]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (95)", "Subsection",
  CellTags->"T1.6.87.1"],

Cell[BoxData[
    \(h\_95 = s\_95 /. \[Nu]\_1 -> \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    \(f\_95 = 
      MakeFun[h\_95, "\<(95)\>", 
        IFF[\[Nu]\_1 > 1\  && \ 
            MatchQ[d, _Symbol + _Integer?Positive]]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (96)", "Subsection",
  CellTags->"T1.6.88.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_96\), "=", 
        RowBox[{
          RowBox[{"2", 
            InterpretationBox[\(p\^2\),
              PP], \((d - \[Nu]\_1 - \[Nu]\_2 - 1)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TBI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2]}],
              Editable->True]}], "==", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{\(\[CapitalDelta]\_\(1, 2, 6\)\), "+", 
                RowBox[{\(u\_\(1, 2, 6\)\), 
                  InterpretationBox[
                    StyleBox[\(1\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 1, "-"],
                    Editable->True]}], "+", 
                RowBox[{\(u\_\(2, 1, 6\)\), 
                  InterpretationBox[
                    StyleBox[\(2\^-\),
                      FontWeight->"Bold"],
                    Schiebe[ 2, "-"],
                    Editable->True]}]}], ")"}], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox[\(d - 2\),
                    "TraditionalForm"], ")"}]],
              TBI[ 
                Plus[ -2, d], {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_96 = OperatorApplyB[e\_96]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (96)", "Subsection",
  CellTags->"T1.6.89.1"],

Cell[BoxData[
    \(h\_96 = s\_96\)], "Input"],

Cell[BoxData[
    \(f\_96 = 
      MakeFun[h\_96, "\<(96)\>", 
        IFF[\ MatchQ[d, _Symbol + _Integer\ ?Positive]], n1 :> 1]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (97)", "Subsection",
  CellTags->"T1.6.90.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_97\), "=", 
        RowBox[{
          RowBox[{"2", \(m\_1\%2\), \(\[Nu]\_1\), 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["A",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TAI[ d, {
                Subscript[ \[Nu], 1]}],
              Editable->True]}], "==", 
          RowBox[{\((d - 2  \[Nu]\_1)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["A",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TAI[ d, {
                Subscript[ \[Nu], 1]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_97 = OperatorApplyA[e\_97]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (97)", "Subsection",
  CellTags->"T1.6.91.1"],

Cell[BoxData[
    \(h\_97 = s\_97 /. \[Nu]\_1 -> \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    \(f\_97 = 
      MakeFun[h\_97, "\<(97)\>", 
        IFF[\[Nu]\_1 > 1 && \ MatchQ[d, _Symbol\ ]]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (98)", "Subsection",
  CellTags->"T1.6.92.1"],

Cell[TextData[{
  "general ",
  Cell[BoxData[
      \(m\_i\%2\)]]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(e\_98\), "=", 
        RowBox[{
          RowBox[{\((d - 2  \[Nu]\_1)\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["A",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TAI[ d, {
                Subscript[ \[Nu], 1]}],
              Editable->True]}], "==", 
          RowBox[{\(-2\), \(m\_1\%2\), 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["A",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                RowBox[{"(", 
                  FormBox[\(d - 2\),
                    "TraditionalForm"], ")"}]],
              TAI[ 
                Plus[ -2, d], {
                Subscript[ \[Nu], 1]}],
              Editable->True]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(s\_98 = OperatorApplyA[e\_98]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (98)", "Subsection",
  CellTags->"T1.6.93.1"],

Cell[BoxData[
    \(h\_98 = s\_98\)], "Input"],

Cell[BoxData[
    \(f\_98 = 
      MakeFun[h\_98, "\<(98)\>", 
        IFF[MatchQ[d, _Symbol\  + _Integer?Positive]]]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (99)", "Subsection",
  CellTags->"T1.6.94.1"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`m\_1 = M, \ p\^2 = M\^2, 
    m\_2 = \(m\_3 = 0\)\)]]], "Text"],

Cell[TextData[{
  "Herleitung in three.nb ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          
          RowBox[{\(-\[Nu]\_1\), " ", \((d - 2\ \[Nu]\_2 - 2\ \[Nu]\_3)\), 
            " ", \((d - \[Nu]\_2 - \[Nu]\_3 - 1)\), " ", 
            SubsuperscriptBox[
              StyleBox["J",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox[
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]], 
                FormBox[\(\[Nu]\_2\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]]}], "==", 
          
          RowBox[{\(\[Nu]\_2\), " ", \((\(-d\) + 2\ \[Nu]\_2 + 2)\), 
            " ", \((\(-2\)\ d + \[Nu]\_1 + 2\ \[Nu]\_2 + 2\ \[Nu]\_3 + 2)\), 
            " ", 
            SubsuperscriptBox[
              StyleBox["J",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                StyleBox[
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]]}]}], TraditionalForm]]]
}], "Text"],

Cell[BoxData[
    RowBox[{\(e\_99\), "=", 
      RowBox[{
        RowBox[{\(\[Nu]\_1\), " ", \((d - 2\ \[Nu]\_2 - 2\ \[Nu]\_3)\), 
          " ", \((d - \[Nu]\_2 - \[Nu]\_3 - 1)\), " ", 
          InterpretationBox[
            StyleBox[\(1\^+\),
              FontWeight->"Bold"],
            Schiebe[ 1, "+"],
            Editable->True], 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["J",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_2\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TJI[ d, {
              Subscript[ \[Nu], 1], 
              Subscript[ \[Nu], 2], 
              Subscript[ \[Nu], 3]}],
            Editable->True]}], "==", 
        RowBox[{\(-\[Nu]\_2\), " ", \((\(-d\) + 2\ \[Nu]\_2 + 2)\), 
          " ", \((\(-2\)\ d + \[Nu]\_1 + 2\ \[Nu]\_2 + 2\ \[Nu]\_3 + 2)\), 
          InterpretationBox[
            StyleBox[\(2\^+\),
              FontWeight->"Bold"],
            Schiebe[ 2, "+"],
            Editable->True], 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["J",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_2\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TJI[ d, {
              Subscript[ \[Nu], 1], 
              Subscript[ \[Nu], 2], 
              Subscript[ \[Nu], 3]}],
            Editable->True]}]}]}]], "Input"],

Cell[BoxData[
    \(s\_99 = OperatorApplyJ[e\_99]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (99)", "Subsection",
  CellTags->"T1.6.95.1"],

Cell[BoxData[
    \(h\_99 = s\_99 /. \[Nu]\_1 -> \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    \(f\_99 = 
      MakeFun[h\_99, "\<(99)\>", 
        IFF[m1^2 === PP && \[Nu]\_1 > 1], {m2 :> 0, m3 :> 0}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (9912)", "Subsection",
  CellTags->"T1.6.96.1"],

Cell[BoxData[
    \(h\_9912 = 
      Interchange[s\_99 /. \[Nu]\_1 -> \[Nu]\_1 - 1, 
        1 \[LeftRightArrow] 2]\)], "Input"],

Cell[BoxData[
    \(f\_9912 = 
      MakeFun[h\_9912, "\<(9912)\>", 
        IFF[m2^2 === PP && \[Nu]\_2 > 1], {m1 :> 0, m3 :> 0}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (9913)", "Subsection",
  CellTags->"T1.6.97.1"],

Cell[BoxData[
    \(h\_9913 = 
      Interchange[s\_99 /. \[Nu]\_1 -> \[Nu]\_1 - 1, 
        1 \[LeftRightArrow] 3]\)], "Input"],

Cell[BoxData[
    \(f\_9913 = 
      MakeFun[h\_9913, "\<(9913)\>", 
        IFF[m3^2 === PP && \[Nu]\_3 > 1], {m1 :> 0, m2 :> 0}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (100)", "Subsection",
  CellTags->"T1.6.98.1"],

Cell["Herleitung in three.nb ", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
        "2", " ", \(m\_2\%2\), " ", \((1 - \[Nu]\_2)\), " ", \(\[Nu]\_2\), 
          " ", 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["J",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                StyleBox[
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"],
                  FontColor->RGBColor[0, 0, 1]], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TJI[ d, {
              Subscript[ \[Nu], 1], 
              Plus[ 1, 
                Subscript[ \[Nu], 2]], 
              Subscript[ \[Nu], 3]}],
            Editable->True]}], "==", 
        RowBox[{
          RowBox[{\((d - 2\ \[Nu]\_2)\), " ", \((1 - \[Nu]\_2)\), " ", 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "-", 
          RowBox[{\(\[Nu]\_1\), " ", \((\(-d\) + 2\ \[Nu]\_1 + 2)\), " ", 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox[
                    FormBox[\(\[Nu]\_1\),
                      "TraditionalForm"],
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox[
                    FormBox[\(\[Nu]\_2\),
                      "TraditionalForm"],
                    FontColor->RGBColor[1, 0, 0]], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Plus[ 1, 
                  Subscript[ \[Nu], 1]], 
                Plus[ -1, 
                  Subscript[ \[Nu], 2]], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}], TraditionalForm]], "Input"]], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`m\_1 = 0\)]]], "Text"],

Cell[BoxData[
    RowBox[{\(e\_100\), "=", 
      RowBox[{
        RowBox[{
        "2", " ", \(m\_2\%2\), " ", \((1 - \[Nu]\_2)\), " ", \(\[Nu]\_2\), 
          " ", 
          InterpretationBox[
            StyleBox[\(2\^+\),
              FontWeight->"Bold"],
            Schiebe[ 2, "+"],
            Editable->True], 
          InterpretationBox[
            SubsuperscriptBox[
              StyleBox["J",
                SingleLetterItalics->False,
                FontWeight->"Bold"], 
              RowBox[{
                FormBox[\(\[Nu]\_1\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_2\),
                  "TraditionalForm"], 
                FormBox[\(\[Nu]\_3\),
                  "TraditionalForm"]}], 
              RowBox[{"(", 
                FormBox["d",
                  "TraditionalForm"], ")"}]],
            TJI[ d, {
              Subscript[ \[Nu], 1], 
              Subscript[ \[Nu], 2], 
              Subscript[ \[Nu], 3]}],
            Editable->True]}], "==", 
        RowBox[{
          RowBox[{\((d - 2\ \[Nu]\_2)\), " ", \((1 - \[Nu]\_2)\), " ", 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "-", 
          RowBox[{\(\[Nu]\_1\), " ", \((\(-d\) + 2\ \[Nu]\_1 + 2)\), " ", 
            InterpretationBox[
              StyleBox[\(1\^+\),
                FontWeight->"Bold"],
              Schiebe[ 1, "+"],
              Editable->True], 
            InterpretationBox[
              StyleBox[\(2\^-\),
                FontWeight->"Bold"],
              Schiebe[ 2, "-"],
              Editable->True], 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\(\[Nu]\_1\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Subscript[ \[Nu], 1], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}]}]}]}]], "Input"],

Cell[BoxData[
    \(s\_100 = OperatorApplyJ[e\_100]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (100)", "Subsection",
  CellTags->"T1.6.99.1"],

Cell[BoxData[
    \(h\_100 = s\_100\)], "Input"],

Cell[BoxData[
    \(f\_100 = 
      MakeFun[h\_100 /. \[Nu]\_2 -> \[Nu]\_2 - 1, "\<(100)\>", 
        IFF[\[Nu]\_2 > 2 && m2 =!= 0], m1 :> 0]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_100]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (1002)", "Subsection",
  CellTags->"T1.6.100.1"],

Cell[BoxData[
    \(h\_1002 = Interchange[s\_100, 1 \[LeftRightArrow] 3]\)], "Input"],

Cell[BoxData[
    \(f\_1002 = 
      MakeFun[h\_1002 /. \[Nu]\_2 -> \[Nu]\_2 - 1, "\<(1002)\>", 
        IFF[\[Nu]\_2 > 2 && m2 =!= 0], m3 :> 0]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_1002]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (1003)", "Subsection",
  CellTags->"T1.6.101.1"],

Cell[BoxData[
    \(h\_1003 = 
      Interchange[s\_100, 1 \[LeftRightArrow] 3, 
        1 \[LeftRightArrow] 2]\)], "Input"],

Cell[BoxData[
    \(f\_1003 = 
      MakeFun[h\_1003 /. \[Nu]\_1 -> \[Nu]\_1 - 1, "\<(1003)\>", 
        IFF[\[Nu]\_1 > 2 && m1 =!= 0], m3 :> 0]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_1003]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (1004)", "Subsection",
  CellTags->"T1.6.102.1"],

Cell[BoxData[
    \(h\_1004 = Interchange[s\_100, 1 \[LeftRightArrow] 2]\)], "Input"],

Cell[BoxData[
    \(f\_1004 = 
      MakeFun[h\_1004 /. \[Nu]\_1 -> \[Nu]\_1 - 1, "\<(1004)\>", 
        IFF[\[Nu]\_1 > 2 && m1 =!= 0], m2 :> 0]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_1004]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (1005)", "Subsection",
  CellTags->"T1.6.103.1"],

Cell[BoxData[
    \(h\_1005 = Interchange[s\_100, 2 \[LeftRightArrow] 3]\)], "Input"],

Cell[BoxData[
    \(f\_1005 = 
      MakeFun[h\_1005 /. \[Nu]\_3 -> \[Nu]\_3 - 1, "\<(1005)\>", 
        IFF[\[Nu]\_3 > 2 && m3 =!= 0], m1 :> 0]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_1005]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (1006)", "Subsection",
  CellTags->"T1.6.104.1"],

Cell[BoxData[
    \(h\_1006 = 
      Interchange[s\_100, 2 \[LeftRightArrow] 3, 
        1 \[LeftRightArrow] 2]\)], "Input"],

Cell[BoxData[
    \(f\_1006 = 
      MakeFun[h\_1006 /. \[Nu]\_3 -> \[Nu]\_3 - 1, "\<(1006)\>", 
        IFF[\[Nu]\_3 > 2 && m3 =!= 0], m2 :> 0]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CheckTJIRecursion[f\_1006]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"Off"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (150)", "Subsection",
  CellTags->"T1.6.105.1"],

Cell[BoxData[
    \(TextForm\`\[Nu]\_4 = \(-1\)\)], "Text"],

Cell[BoxData[
    \(TextForm\`\((q\_2 - p\ )\)\^2 - m\_4\%2 = \ 
      q\_2\%2 - m\_2\%2 - 2  p\ q\_2 + p\^2 + m\_2\%2 - m\_4\%2\)], "Text"],

Cell[BoxData[
    \(s\_150 = 
      TFI[d, PP, {{n1, m1}, {n2, m2}, {n3, m3}, {\(-1\), m4}, {n5, m5}}] == 
        TFI[d, PP, {{n1, m1}, {n2 - 1, m2}, {n3, m3}, {0, 0}, {n5, m5}}] - 
          2  TFI[d, 
              PP, {0, 0, 0, 1, 
                0}, {{n1, m1}, {n2, m2}, {n3, m3}, {0, 0}, {n5, 
                  m5}}] + \((PP + m2^2 - m4^2)\) 
            TFI[d, PP, {{n1, m1}, {n2, m2}, {n3, m3}, {0, 0}, {n5, 
                  m5}}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (150)", "Subsection",
  CellTags->"T1.6.106.1"],

Cell[BoxData[
    \(h\_150 = s\_150\)], "Input"],

Cell[BoxData[
    \(f\_150 = MakeFun[h\_150, "\<(150)\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (151)", "Subsection",
  CellTags->"T1.6.107.1"],

Cell[BoxData[
    \(TextForm\`\[Nu]\_4 = \(-1\)\)], "Text"],

Cell[BoxData[
    \(TextForm\`\((q\_2 - p\ )\)\^2 - m\_4\%2 = \ 
      q\_2\%2 - m\_2\%2 - 2  p\ q\_2 + p\^2 + m\_2\%2 - m\_4\%2\)], "Text"],

Cell[BoxData[
    \(s\_151 = 
      TFI[d, PP, 
          DP, {a, b}, {{n1, m1}, {n2, m2}, {n3, m3}, {\(-1\), m4}, {n5, 
              m5}}] == TFI[d, PP, 
            DP, {a, b}, {{n1, m1}, {n2 - 1, m2}, {n3, m3}, {0, 0}, {n5, 
                m5}}] - 
          2  TFI[d, PP, 
              DP, {a, b}, {0, 0, 0, 1, 
                0}, {{n1, m1}, {n2, m2}, {n3, m3}, {0, 0}, {n5, 
                  m5}}] + \((PP + m2^2 - m4^2)\) 
            TFI[d, PP, 
              DP, {a, b}, {{n1, m1}, {n2, m2}, {n3, m3}, {0, 0}, {n5, 
                  m5}}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (151)", "Subsection",
  CellTags->"T1.6.108.1"],

Cell[BoxData[
    \(h\_151 = s\_151\)], "Input"],

Cell[BoxData[
    \(f\_151 = 
      ReplacePart[
        MakeFun[h\_151, "\<(151)\>"], {a_, b_}, {1, 1, 4}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (152)", "Subsection",
  CellTags->"T1.6.109.1"],

Cell[BoxData[
    \(TextForm\`\[Nu]\_4 = \(-1\)\)], "Text"],

Cell[BoxData[
    \(TextForm\`\((q\_2 - p\ )\)\^2 - m\_4\%2 = \ 
      q\_2\%2 - m\_2\%2 - 2  p\ q\_2 + p\^2 + m\_2\%2 - m\_4\%2\)], "Text"],

Cell[BoxData[
    \(s\_152 = 
      TVI[d, PP, {{n1, m1}, {n2, m2}, {n3, m3}, {\(-1\), m4}}] == 
        TVI[d, PP, {{n1, m1}, {n2 - 1, m2}, {n3, m3}, {0, 0}}] - 
          2  TFI[d, 
              PP, {0, 0, 0, 1, 
                0}, {{0, 0}, {n2, m2}, {n3, m3}, {0, 0}, {n1, m1}}] + \((PP + 
                m2^2 - m4^2)\) 
            TVI[d, PP, {{n1, m1}, {n2, m2}, {n3, m3}, {0, 0}}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (152)", "Subsection",
  CellTags->"T1.6.110.1"],

Cell[BoxData[
    \(h\_152 = s\_152\)], "Input"],

Cell[BoxData[
    \(f\_152 = MakeFun[h\_152, "\<(152)\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (153)", "Subsection",
  CellTags->"T1.6.111.1"],

Cell[BoxData[
    \(TextForm\`\[Nu]\_2 = \(-1\)\)], "Text"],

Cell[BoxData[
    \(s\_153 = 
      TVI[d, PP, {{n1, m1}, {\(-1\), m2}, {n3, m3}, {n4, m4}}] == \n\t\tTFI[
            d, \ PP, {0, 1, 0, 0, 
              0}, \ {{0, 0}, {0, 0}, {n3, m3}, {n4, m4}, {n1, m1}}] + 
          m2^2\ TVI[d, \ 
              PP, \ {{n1, m1}, {0, 0}, {n3, m3}, {n4, m4}}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (153)", "Subsection",
  CellTags->"T1.6.112.1"],

Cell[BoxData[
    \(h\_153 = s\_153\)], "Input"],

Cell[BoxData[
    \(f\_153 = MakeFun[h\_153, "\<(153)\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (200)", "Subsection",
  CellTags->"T1.6.113.1"],

Cell["Derivation in TJRspecial.nb", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`m\_3 = \(m\_2 = m\_1\), \ p\^2 = m\_1\%2\)]]], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(s\_200\), "=", 
        RowBox[{
          RowBox[{
          "16", " ", \(m\_1\%2\), " ", \(\[Nu]\_1\), 
            " ", \((d - \[Nu]\_1 - \[Nu]\_2 - \[Nu]\_3)\), " ", 
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox[
                    FormBox[\(\[Nu]\_1\),
                      "TraditionalForm"],
                    FontColor->RGBColor[0, 0, 1]], 
                  FormBox[\(\[Nu]\_2\),
                    "TraditionalForm"], 
                  FormBox[\(\[Nu]\_3\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d",
                    "TraditionalForm"], ")"}]],
              TJI[ d, {
                Plus[ 1, 
                  Subscript[ \[Nu], 1]], 
                Subscript[ \[Nu], 2], 
                Subscript[ \[Nu], 3]}],
              Editable->True]}], "==", 
          RowBox[{
            
            RowBox[{\(-\((1 + 3\ d - 3\ \[Nu]\_1 - 4\ \[Nu]\_2)\)\), 
              " ", \(\[Nu]\_3\), " ", 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["J",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox[
                      FormBox[\(\[Nu]\_1\),
                        "TraditionalForm"],
                      FontColor->RGBColor[1, 0, 0]], 
                    FormBox[\(\[Nu]\_2\),
                      "TraditionalForm"], 
                    StyleBox[
                      FormBox[\(\[Nu]\_3\),
                        "TraditionalForm"],
                      FontColor->RGBColor[0, 0, 1]]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TJI[ d, {
                  Plus[ -1, 
                    Subscript[ \[Nu], 1]], 
                  Subscript[ \[Nu], 2], 
                  Plus[ 1, 
                    Subscript[ \[Nu], 3]]}],
                Editable->True]}], "-", 
            
            RowBox[{\(\[Nu]\_2\), 
              " ", \((1 + 3\ d - 3\ \[Nu]\_1 - 4\ \[Nu]\_3)\), " ", 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["J",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox[
                      FormBox[\(\[Nu]\_1\),
                        "TraditionalForm"],
                      FontColor->RGBColor[1, 0, 0]], 
                    StyleBox[
                      FormBox[\(\[Nu]\_2\),
                        "TraditionalForm"],
                      FontColor->RGBColor[0, 0, 1]], 
                    FormBox[\(\[Nu]\_3\),
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TJI[ d, {
                  Plus[ -1, 
                    Subscript[ \[Nu], 1]], 
                  Plus[ 1, 
                    Subscript[ \[Nu], 2]], 
                  Subscript[ \[Nu], 3]}],
                Editable->True]}], "+", 
            
            RowBox[{\((\(-1\) + 2\ d - \[Nu]\_1 - 2\ \[Nu]\_2)\), 
              " ", \(\[Nu]\_3\), " ", 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["J",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox[\(\[Nu]\_1\),
                      "TraditionalForm"], 
                    StyleBox[
                      FormBox[\(\[Nu]\_2\),
                        "TraditionalForm"],
                      FontColor->RGBColor[1, 0, 0]], 
                    StyleBox[
                      FormBox[\(\[Nu]\_3\),
                        "TraditionalForm"],
                      FontColor->RGBColor[0, 0, 1]]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TJI[ d, {
                  Subscript[ \[Nu], 1], 
                  Plus[ -1, 
                    Subscript[ \[Nu], 2]], 
                  Plus[ 1, 
                    Subscript[ \[Nu], 3]]}],
                Editable->True]}], "-", 
            
            RowBox[{\((\(-6\)\ d\^2 + 22\ d\ \[Nu]\_1 - 
                  16\ \[Nu]\_1\%2 - \[Nu]\_2 + 6\ d\ \[Nu]\_2 - 
                  13\ \[Nu]\_1\ \[Nu]\_2 - \[Nu]\_3 + 6\ d\ \[Nu]\_3 - 
                  13\ \[Nu]\_1\ \[Nu]\_3 - 4\ \[Nu]\_2\ \[Nu]\_3)\), " ", 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["J",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox[\(\[Nu]\_1\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_2\),
                      "TraditionalForm"], 
                    FormBox[\(\[Nu]\_3\),
                      "TraditionalForm"]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TJI[ d, {
                  Subscript[ \[Nu], 1], 
                  Subscript[ \[Nu], 2], 
                  Subscript[ \[Nu], 3]}],
                Editable->True]}], "+", 
            
            RowBox[{\(\[Nu]\_2\), 
              " ", \((\(-1\) + 2\ d - \[Nu]\_1 - 2\ \[Nu]\_3)\), " ", 
              InterpretationBox[
                SubsuperscriptBox[
                  StyleBox["J",
                    SingleLetterItalics->False,
                    FontWeight->"Bold"], 
                  RowBox[{
                    FormBox[\(\[Nu]\_1\),
                      "TraditionalForm"], 
                    StyleBox[
                      FormBox[\(\[Nu]\_2\),
                        "TraditionalForm"],
                      FontColor->RGBColor[0, 0, 1]], 
                    StyleBox[
                      FormBox[\(\[Nu]\_3\),
                        "TraditionalForm"],
                      FontColor->RGBColor[1, 0, 0]]}], 
                  RowBox[{"(", 
                    FormBox["d",
                      "TraditionalForm"], ")"}]],
                TJI[ d, {
                  Subscript[ \[Nu], 1], 
                  Plus[ 1, 
                    Subscript[ \[Nu], 2]], 
                  Plus[ -1, 
                    Subscript[ \[Nu], 3]]}],
                Editable->True]}]}]}]}], ";"}]], "Input"],

Cell[BoxData[
    \(TextForm\`Due\ to\ sorting\ \ \[Nu]\_1 \[GreaterSlantEqual] \[Nu]\_2 \
\[GreaterSlantEqual] \[Nu]\_3\ \ by\ TJI\ only\ this\ rule\ is\ \(\(necessary\
\)\(.\)\)\)], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (200)", "Subsection",
  CellTags->"T1.6.114.1"],

Cell[BoxData[
    \(h\_200 = s\_200 /. \[Nu]\_1 -> \[Nu]\_1 - 1\)], "Input"],

Cell[BoxData[
    RowBox[{\(f\_200\), "=", 
      RowBox[{
        StyleBox["MakeFun",
          FontColor->RGBColor[1, 0.6, 0.6]], "[", 
        RowBox[{\(h\_200\), ",", "\"\<(200)\>\"", ",", 
          RowBox[{
            StyleBox["IFF",
              FontColor->RGBColor[0.6, 0.4, 1]], 
            "[", \(\[Nu]\_1 > 1 && m1 =!= 0 && PP === m1^2\), "]"}], 
          ",", \({m2 :> m1, m3 :> m1}\)}], "]"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (201)", "Subsection",
  CellTags->"T1.6.115.1"],

Cell["\<\
Subscript[f, 201] = 
  HoldForm[TJR[d_, PP_, 
     {{(n1_)?PQ, 0}, 
      {(n2_)?PQ, 0}, 
      {(n3_)?PQ, m3_}}] := 
    (TComment[\"(201)\", 
        TJIC[d, 
         {{n1, 0}, {n2, 0}, 
          {n3, m3}}]]; 
       -(((d - n1 - n2)*
          (-2 - d + 
         2*n1 + 2*n2)*
          (3*d - 2*n1 - 
         2*n2 - 2*n3)*
          (-1 - d + n1 + 
          n2 + n3)*
          TJI[d, PP, 
          {{-1 + n1, 0}, 
          {n2, 0}, {n3, m3}}]
)/(2*m3^2*(d - 2*n1)*
          (-1 + n1)*
          (2*d - 2*n1 - 
          2*n2 - n3)*
          (1 + 2*d - 2*n1 - 
          2*n2 - n3)))) /; 
     n1 > 1 && m3 =!= 0 && 
      PP === m3^2]\
\>", "Input",
  Editable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["MakeFun (202)", "Subsection",
  CellTags->"T1.6.116.1"],

Cell["\<\
Subscript[f, 202] = 
  HoldForm[TJR[d_, PP_, 
     {{(n1_)?PQ, 0}, 
      {(n3_)?PQ, m3_}, 
      {(n2_)?PQ, 0}}] := 
    (TComment[\"(202)\", 
        TJIC[d, 
         {{n1, 0}, {n2, 0}, 
          {n3, m3}}]]; 
       -(((d - n1 - n2)*
          (-2 - d + 2*n1 + 
          2*n2)*
          (3*d - 2*n1 - 
          2*n2 - 2*n3)*
          (-1 - d + n1 + 
          n2 + n3)*
          TJI[d, m3^2, 
          {{-1 + n1, 0}, 
          {n2, 0}, {n3, m3}}
])/(2*m3^2*(d - 2*n1)*
          (-1 + n1)*
          (2*d - 2*n1 - 
          2*n2 - n3)*
          (1 + 2*d - 2*n1 - 
          2*n2 - n3)))) /; 
     n1 > 1 && m3 =!= 0 && 
      PP === m3^2]\
\>", "Input",
  Editable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[" MakeFun (203)", "Subsection",
  CellTags->"T1.6.117.1"],

Cell[BoxData[
    \(Subscript[f, \ 203]\  = 
      HoldForm[\n\t\t\ TJR[d_, \ 
            0, \ {{\((n1_)\)?PQ, \ 0}, \ {\((n2_)\)?PQ, \ 
                m2_}, \ \n\ \ \ \ {\((n3_)\)?PQ, \ 
                m2_}}]\  := \((\n\t\t\t\t\ TComment["\<(203)\>", \ \n\ \ \ \ \
\ \ \ \ TJIC[d, 
                0, \ {{n1, \ 0}, \ {n2, \ m2}, \ {n3, \ 
                    m2}}]]; \ \n\t\t\t\t\((\((d\  - \ 
                      2*\((\(-1\)\  + \ n1\  + \ 
                            n2)\))\)*\n\ \ \ \ \ \((1\  + \ d\  - \ n1\  - \ 
                      n2\  - \ n3)\)*\n\ \ \ \ \ \((d\  - \ 
                      2*\((\(-1\)\  + \ n1\  + \ n3)\))\)*\n\ \ \ \ \ TJR[
                    d, \ 0, \ {{\(-1\)\  + \ n1, \ 0}, \ {n2, \ 
                        m2}, \ \n\ \ \ \ \ \ \ {n3, \ m2}}])\)/\n\ \ \ \((2*
                  m2^2*\((d\  - \ 2*n1)\)*\n\ \ \ \ \ \((1\  + \ d\  - \ 
                      2*n1\  - \ n2\  - \ n3)\)*\n\ \ \ \ \ \((2\  + \ 
                      d\  - \ 2*n1\  - \ n2\  - \ 
                      n3)\))\)\n\t\t\t\n\t\t\t)\)]\)], "Input",
  Editable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[" MakeFun (204)", "Subsection",
  CellTags->"T1.6.118.1"],

Cell[BoxData[
    \(Subscript[f, \ 204]\  = 
      HoldForm[\n\t\t\ TJR[d_, \ 
            0, \ {\ {\((n2_)\)?PQ, \ m2_}, \ {\((n1_)\)?PQ, \ 
                0}, \n\ \ \ \ {\((n3_)\)?PQ, \ 
                m2_}}]\  := \((\n\t\ TComment["\<(204)\>", \ \n\ \ \ \ \ \ \ \
\ TJIC[d, 0, \ {\ {n2, \ m2}, \ {n1, \ 0}, {n3, \ 
                    m2}}]]; \ \n\t\((\((d\  - \ 
                      2*\((\(-1\)\  + \ n1\  + \ 
                            n2)\))\)*\n\ \ \ \ \ \((1\  + \ d\  - \ n1\  - \ 
                      n2\  - \ n3)\)*\n\ \ \ \ \ \((d\  - \ 
                      2*\((\(-1\)\  + \ n1\  + \ n3)\))\)*\n\ \ \ \ \ TJR[
                    d, \ 0, \ {{\(-1\)\  + \ n1, \ 0}, \ {n2, \ 
                        m2}, \ \n\ \ \ \ \ \ \ {n3, \ m2}}])\)/\n\ \ \ \((2*
                  m2^2*\((d\  - \ 2*n1)\)*\n\ \ \ \ \ \((1\  + \ d\  - \ 
                      2*n1\  - \ n2\  - \ n3)\)*\n\ \ \ \ \ \((2\  + \ 
                      d\  - \ 2*n1\  - \ n2\  - \ 
                      n3)\))\)\n\t\t\t)\)]\)], "Input",
  Editable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[" MakeFun (205)", "Subsection",
  CellTags->"T1.6.119.1"],

Cell[BoxData[
    \(Subscript[f, \ 205]\  = 
      HoldForm[\n\t\t\ TJR[d_, \ 
            0, \ {\ {\((n2_)\)?PQ, \ m2_}, \n\ \ \ \ {\((n3_)\)?PQ, \ 
                m2_}, \ {\((n1_)\)?PQ, \ 
                0}}]\  := \((\n\t\ TComment["\<(205)\>", \ \n\ \ \ \ \ \ \ \ \
TJIC[d, 0, \ {\ {n2, \ m2}, {n3, \ m2}, \ {n1, \ 
                    0}}]]; \ \n\((\((d\  - \ 
                      2*\((\(-1\)\  + \ n1\  + \ 
                            n2)\))\)*\n\ \ \ \ \ \((1\  + \ d\  - \ n1\  - \ 
                      n2\  - \ n3)\)*\n\ \ \ \ \ \((d\  - \ 
                      2*\((\(-1\)\  + \ n1\  + \ n3)\))\)*\n\ \ \ \ \ TJR[
                    d, \ 0, \ {{\(-1\)\  + \ n1, \ 0}, \ {n2, \ 
                        m2}, \ \n\ \ \ \ \ \ \ {n3, \ m2}}])\)/\n\ \ \ \((2*
                  m2^2*\((d\  - \ 2*n1)\)*\n\ \ \ \ \ \((1\  + \ d\  - \ 
                      2*n1\  - \ n2\  - \ n3)\)*\n\ \ \ \ \ \((2\  + \ 
                      d\  - \ 2*n1\  - \ n2\  - \ 
                      n3)\))\)\n\t\t\t)\)]\)], "Input",
  Editable->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input (1xxxx)", "Subsection",
  CellTags->"T1.6.120.1"],

Cell["\<\
If[MatchQ[$RankLimit, {_Integer?NonNegative, 
     _Integer?NonNegative}], 
   $TarasovTdeltaplimit = $RankLimit[[1]]; 
    ($TarasovTplimit = $RankLimit[[2]]; ), 
   $TarasovTdeltaplimit = 2; $TarasovTplimit = 2]; \
\>", "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"tarti", "=", 
      RowBox[{"Timing", "[", 
        RowBox[{"Do", "[", 
          RowBox[{
            RowBox[{"If", "[", 
              RowBox[{\(0 < a + b + r + es\), ",", 
                RowBox[{\(WriteString["\<stdout\>", {a, b, r, es}]\), ";", 
                  RowBox[{"Set", "@@", 
                    RowBox[{"{", 
                      
                      RowBox[{\(s\_\(10\^4 + 1000\ a + 100\ b + 10\ r + 
                              es\)\), ",", 
                        RowBox[{
                          RowBox[{
                            RowBox[{
                              StyleBox["TFI",
                                FontColor->RGBColor[1, 0.6, 0]], "[", 
                              RowBox[{"d", ",", 
                                InterpretationBox[\(p\^2\),
                                  PP], ",", "DP", ",", \({a, b}\), 
                                ",", \({0, 0, r, es, 0}\), ",", 
                                RowBox[{"{", 
                                  RowBox[{
                                    RowBox[{"{", 
                                      RowBox[{"n1", ",", 
                                        InterpretationBox[\(m\_1\),
                                        m1]}], "}"}], ",", 
                                    RowBox[{"{", 
                                      RowBox[{"n2", ",", 
                                        InterpretationBox[\(m\_2\),
                                        m2]}], "}"}], ",", 
                                    RowBox[{"{", 
                                      RowBox[{"n3", ",", 
                                        InterpretationBox[\(m\_3\),
                                        m3]}], "}"}], ",", 
                                    RowBox[{"{", 
                                      RowBox[{"n4", ",", 
                                        InterpretationBox[\(m\_4\),
                                        m4]}], "}"}], ",", 
                                    RowBox[{"{", 
                                      RowBox[{"n5", ",", 
                                        InterpretationBox[\(m\_5\),
                                        m5]}], "}"}]}], "}"}]}], "]"}], "==", 
                            
                            RowBox[{"ApplyTarasovT", "[", 
                              RowBox[{
                                RowBox[{"TarasovT", "[", 
                                  RowBox[{
                                  "a", ",", "b", ",", "r", ",", "es", ",", 
                                    InterpretationBox[\(p\^2\),
                                      PP], ",", "DP"}], "]"}], ",", 
                                RowBox[{"STLI", "[", 
                                  RowBox[{"d", ",", 
                                    InterpretationBox[\(p\^2\),
                                      PP], ",", 
                                    RowBox[{"{", 
                                      RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{"n1", ",", 
                                        InterpretationBox[\(m\_1\),
                                        m1]}], "}"}], ",", 
                                        RowBox[{"{", 
                                        RowBox[{"n2", ",", 
                                        InterpretationBox[\(m\_2\),
                                        m2]}], "}"}], ",", 
                                        RowBox[{"{", 
                                        RowBox[{"n3", ",", 
                                        InterpretationBox[\(m\_3\),
                                        m3]}], "}"}], ",", 
                                        RowBox[{"{", 
                                        RowBox[{"n4", ",", 
                                        InterpretationBox[\(m\_4\),
                                        m4]}], "}"}], ",", 
                                        RowBox[{"{", 
                                        RowBox[{"n5", ",", 
                                        InterpretationBox[\(m\_5\),
                                        m5]}], "}"}]}], "}"}]}], "]"}]}], 
                              "]"}]}], "/.", 
                          RowBox[{"STLI", "\[Rule]", 
                            StyleBox["TFI",
                              FontColor->RGBColor[1, 0.6, 0]]}]}]}], 
                      "}"}]}]}]}], "]"}], 
            ",", \({a, 0, $TarasovTdeltaplimit}\), 
            ",", \({b, 0, $TarasovTdeltaplimit - a}\), 
            ",", \({r, 0, $TarasovTplimit}\), 
            ",", \({es, 0, $TarasovTplimit - r}\)}], "]"}], "]"}]}]], "Input"],

Cell["\<\
{0, 0, 0, 1}{0, 0, 0, 2}{0, 0, 0, 3}{0, 0, 0, 4}{0, 0, 0, 5}{0, 0, \
1, 0}{0, 0, 1, 1}{0, 0, 1, 2}{0, 0, 1, 3}{0, 0, 1, 4}{0, 0, 2, 0}{0, 0, 2, \
1}{0, 0, 2, 2}{0, 0, 2, 3}{0, 0, 3, 0}{0, 0, 3, 1}{0, 0, 3, 2}{0, 0, 4, 0}{0, \
0, 4, 1}{0, 0, 5, 0}{0, 1, 0, 0}{0, 1, 0, 1}{0, 1, 0, 2}{0, 1, 0, 3}{0, 1, 0, \
4}{0, 1, 0, 5}{0, 1, 1, 0}{0, 1, 1, 1}{0, 1, 1, 2}{0, 1, 1, 3}{0, 1, 1, 4}{0, \
1, 2, 0}{0, 1, 2, 1}{0, 1, 2, 2}{0, 1, 2, 3}{0, 1, 3, 0}{0, 1, 3, 1}{0, 1, 3, \
2}{0, 1, 4, 0}{0, 1, 4, 1}{0, 1, 5, 0}{0, 2, 0, 0}{0, 2, 0, 1}{0, 2, 0, 2}{0, \
2, 0, 3}{0, 2, 0, 4}{0, 2, 0, 5}{0, 2, 1, 0}{0, 2, 1, 1}{0, 2, 1, 2}{0, 2, 1, \
3}{0, 2, 1, 4}{0, 2, 2, 0}{0, 2, 2, 1}{0, 2, 2, 2}{0, 2, 2, 3}{0, 2, 3, 0}{0, \
2, 3, 1}{0, 2, 3, 2}{0, 2, 4, 0}{0, 2, 4, 1}{0, 2, 5, 0}{1, 0, 0, 0}{1, 0, 0, \
1}{1, 0, 0, 2}{1, 0, 0, 3}{1, 0, 0, 4}{1, 0, 0, 5}{1, 0, 1, 0}{1, 0, 1, 1}{1, \
0, 1, 2}{1, 0, 1, 3}{1, 0, 1, 4}{1, 0, 2, 0}{1, 0, 2, 1}{1, 0, 2, 2}{1, 0, 2, \
3}{1, 0, 3, 0}{1, 0, 3, 1}{1, 0, 3, 2}{1, 0, 4, 0}{1, 0, 4, 1}{1, 0, 5, 0}{1, \
1, 0, 0}{1, 1, 0, 1}{1, 1, 0, 2}{1, 1, 0, 3}{1, 1, 0, 4}{1, 1, 0, 5}{1, 1, 1, \
0}{1, 1, 1, 1}{1, 1, 1, 2}{1, 1, 1, 3}{1, 1, 1, 4}{1, 1, 2, 0}{1, 1, 2, 1}{1, \
1, 2, 2}{1, 1, 2, 3}{1, 1, 3, 0}{1, 1, 3, 1}{1, 1, 3, 2}{1, 1, 4, 0}{1, 1, 4, \
1}{1, 1, 5, 0}{2, 0, 0, 0}{2, 0, 0, 1}{2, 0, 0, 2}{2, 0, 0, 3}{2, 0, 0, 4}{2, \
0, 0, 5}{2, 0, 1, 0}{2, 0, 1, 1}{2, 0, 1, 2}{2, 0, 1, 3}{2, 0, 1, 4}{2, 0, 2, \
0}{2, 0, 2, 1}{2, 0, 2, 2}{2, 0, 2, 3}{2, 0, 3, 0}{2, 0, 3, 1}{2, 0, 3, 2}{2, \
0, 4, 0}{2, 0, 4, 1}{2, 0, 5, 0}\
\>", "Print"]
}, Open  ]],

Cell["Share[]", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(matarti = 
      Timing[Do[
          If[0 < ia + ib + ir + es, 
            WriteString["\<stdout\>", {ia, ib, ir, es}]; 
            Set[f\_\(10\^4 + 1000\ ia + 100\ ib + 10\ ir + es\), 
              MakeFun[s\_\(10\^4 + 1000\ ia + 100\ ib + 10\ ir + es\), \
"\<(1\>" <> ToString[ia] <> ToString[ib] <> ToString[ir] <> 
                    ToString[es] <> "\<)\>"] /. PQ :> PNQ]], {ia, 
            0, \ $TarasovTdeltaplimit}, {ib, 
            0, $TarasovTdeltaplimit - ia}, {ir, 0, \ \ $TarasovTplimit}, {es, 
            0, $TarasovTplimit - ir}]]\)], "Input"],

Cell["\<\
{0, 0, 0, 1}{0, 0, 0, 2}{0, 0, 0, 3}{0, 0, 0, 4}{0, 0, 0, 5}{0, 0, \
1, 0}{0, 0, 1, 1}{0, 0, 1, 2}{0, 0, 1, 3}{0, 0, 1, 4}{0, 0, 2, 0}{0, 0, 2, \
1}{0, 0, 2, 2}{0, 0, 2, 3}{0, 0, 3, 0}{0, 0, 3, 1}{0, 0, 3, 2}{0, 0, 4, 0}{0, \
0, 4, 1}{0, 0, 5, 0}{0, 1, 0, 0}{0, 1, 0, 1}{0, 1, 0, 2}{0, 1, 0, 3}{0, 1, 0, \
4}{0, 1, 0, 5}{0, 1, 1, 0}{0, 1, 1, 1}{0, 1, 1, 2}{0, 1, 1, 3}{0, 1, 1, 4}{0, \
1, 2, 0}{0, 1, 2, 1}{0, 1, 2, 2}{0, 1, 2, 3}{0, 1, 3, 0}{0, 1, 3, 1}{0, 1, 3, \
2}{0, 1, 4, 0}{0, 1, 4, 1}{0, 1, 5, 0}{0, 2, 0, 0}{0, 2, 0, 1}{0, 2, 0, 2}{0, \
2, 0, 3}{0, 2, 0, 4}{0, 2, 0, 5}{0, 2, 1, 0}{0, 2, 1, 1}{0, 2, 1, 2}{0, 2, 1, \
3}{0, 2, 1, 4}{0, 2, 2, 0}{0, 2, 2, 1}{0, 2, 2, 2}{0, 2, 2, 3}{0, 2, 3, 0}{0, \
2, 3, 1}{0, 2, 3, 2}{0, 2, 4, 0}{0, 2, 4, 1}{0, 2, 5, 0}{1, 0, 0, 0}{1, 0, 0, \
1}{1, 0, 0, 2}{1, 0, 0, 3}{1, 0, 0, 4}{1, 0, 0, 5}{1, 0, 1, 0}{1, 0, 1, 1}{1, \
0, 1, 2}{1, 0, 1, 3}{1, 0, 1, 4}{1, 0, 2, 0}{1, 0, 2, 1}{1, 0, 2, 2}{1, 0, 2, \
3}{1, 0, 3, 0}{1, 0, 3, 1}{1, 0, 3, 2}{1, 0, 4, 0}{1, 0, 4, 1}{1, 0, 5, 0}{1, \
1, 0, 0}{1, 1, 0, 1}{1, 1, 0, 2}{1, 1, 0, 3}{1, 1, 0, 4}{1, 1, 0, 5}{1, 1, 1, \
0}{1, 1, 1, 1}{1, 1, 1, 2}{1, 1, 1, 3}{1, 1, 1, 4}{1, 1, 2, 0}{1, 1, 2, 1}{1, \
1, 2, 2}{1, 1, 2, 3}{1, 1, 3, 0}{1, 1, 3, 1}{1, 1, 3, 2}{1, 1, 4, 0}{1, 1, 4, \
1}{1, 1, 5, 0}{2, 0, 0, 0}{2, 0, 0, 1}{2, 0, 0, 2}{2, 0, 0, 3}{2, 0, 0, 4}{2, \
0, 0, 5}{2, 0, 1, 0}{2, 0, 1, 1}{2, 0, 1, 2}{2, 0, 1, 3}{2, 0, 1, 4}{2, 0, 2, \
0}{2, 0, 2, 1}{2, 0, 2, 2}{2, 0, 2, 3}{2, 0, 3, 0}{2, 0, 3, 1}{2, 0, 3, 2}{2, \
0, 4, 0}{2, 0, 4, 1}{2, 0, 5, 0}\
\>", "Print"]
}, Open  ]],

Cell[BoxData[
    \(Share[]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["symmetry", "Subsection",
  CellTags->"Tsymmetry"],

Cell["Uncomment this ...", "Text"],

Cell["\<\
TVR[d_, pp_, {a_, b_, c_, z_}] := 
  TVR[d, pp, {c, b, a, z}] /;  !OrderedQ[{a, c}]\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["special TVR reductions", "Subsection",
  CellTags->"specialTVR"],

Cell["\<\
TVR[2 + d_Symbol, pp_, {{1, m1_}, {1, m1_}, {2, 0}, {1, m1_}}] := 
   ((-6*m1^2 + 2*d*m1^2 + 3*pp)*TAI[d, 0, {{1, m1}}]^2)/
      (12*(-3 + d)*(-1 + d)*m1^2*pp) + 
     ((4*m1^2 - pp)*TAI[d, 0, {{1, m1}}]*TBI[d, pp, {{1, m1}, {1, m1}}])/
      (4*(-3 + d)*(-1 + d)*m1^2) - 
     ((6*m1^2 - 2*d*m1^2 - 7*pp + 2*d*pp)*
        TJI[d, pp, {{1, m1}, {1, m1}, {1, 0}}])/(6*(-2 + d)*(-1 + d)*pp) + 
     ((-4*m1^2 + pp)*(-6*m1^2 + 2*d*m1^2 + 3*pp)*
        TJI[d, pp, {{2, m1}, {1, m1}, {1, 0}}])/
      (6*(-3 + d)*(-2 + d)*(-1 + d)*pp) /; (m1=!=0)&&(pp=!=0);\
\>", "Input"],

Cell["\<\
TVR[4 + d_Symbol, pp_, {{1, m1_}, {1, m1_}, {2, 0}, {1, m1_}}] := 
   -((-96*d*m1^6 + 352*d^2*m1^6 - 384*d^3*m1^6 + 128*d^4*m1^6 - 
           192*m1^4*pp + 1008*d*m1^4*pp - 1632*d^2*m1^4*pp + 
           912*d^3*m1^4*pp - 144*d^4*m1^4*pp + 288*m1^2*pp^2 - 
           1536*d*m1^2*pp^2 + 2316*d^2*m1^2*pp^2 - 1086*d^3*m1^2*pp^2 + 
           66*d^4*m1^2*pp^2 + 72*d*pp^3 - 166*d^2*pp^3 + 81*d^3*pp^3 + 
           4*d^4*pp^3)*TAI[d, 0, {{1, m1}}]^2)/
      (36*(-1 + d)^2*d^2*(1 + d)*(-4 + 3*d)*(-2 + 3*d)*pp^2) + 
     ((4*m1^2 - pp)^2*TAI[d, 0, {{1, m1}}]*TBI[d, pp, {{1, m1}, {1, m1}}])/
      (4*(-1 + d)^2*d*(1 + d)) - 
     ((288*m1^8 - 1152*d*m1^8 + 1504*d^2*m1^8 - 768*d^3*m1^8 + 
          128*d^4*m1^8 - 816*m1^6*pp + 2480*d*m1^6*pp - 
          2224*d^2*m1^6*pp + 736*d^3*m1^6*pp - 80*d^4*m1^6*pp + 
          864*m1^4*pp^2 - 2196*d*m1^4*pp^2 + 1446*d^2*m1^4*pp^2 - 
          252*d^3*m1^4*pp^2 - 6*d^4*m1^4*pp^2 - 432*m1^2*pp^3 + 
          1086*d*m1^2*pp^3 - 895*d^2*m1^2*pp^3 + 315*d^3*m1^2*pp^3 - 
          44*d^4*m1^2*pp^3 + 4*d*pp^4 - 2*d^2*pp^4 - 4*d^3*pp^4 + 
          2*d^4*pp^4)*TJI[d, pp, {{1, m1}, {1, m1}, {1, 0}}])/
      (18*(-2 + d)*(-1 + d)^2*d*(1 + d)*(-4 + 3*d)*(-2 + 3*d)*pp^2) + 
     (m1^2*(4*m1^2 - pp)*(-96*m1^6 + 352*d*m1^6 - 384*d^2*m1^6 + 
          128*d^3*m1^6 + 240*m1^4*pp - 624*d*m1^4*pp + 384*d^2*m1^4*pp - 
          48*d^3*m1^4*pp - 192*m1^2*pp^2 + 420*d*m1^2*pp^2 - 
          162*d^2*m1^2*pp^2 - 18*d^3*m1^2*pp^2 + 72*pp^3 - 154*d*pp^3 + 
          81*d^2*pp^3 - 8*d^3*pp^3)*TJI[d, pp, {{2, m1}, {1, m1}, {1, 0}}])/
      (18*(-2 + d)*(-1 + d)^2*d*(1 + d)*(-4 + 3*d)*(-2 + 3*d)*pp^2) /; \
(m1=!=0)&&(pp=!=0);\
\>", "Input"],

Cell["\<\
TVR[4 + d_Symbol, pp_, {{1, m1_}, {1, m1_}, {3, 0}, {1, m1_}}] := 
   ((-72*d^2*m1^6 + 144*d^3*m1^6 - 88*d^4*m1^6 + 16*d^5*m1^6 - 
          240*d*m1^4*pp + 572*d^2*m1^4*pp - 398*d^3*m1^4*pp + 
          84*d^4*m1^4*pp - 2*d^5*m1^4*pp - 96*m1^2*pp^2 + 
          480*d*m1^2*pp^2 - 744*d^2*m1^2*pp^2 + 390*d^3*m1^2*pp^2 - 
          50*d^4*m1^2*pp^2 + 4*d^5*m1^2*pp^2 - 24*d*pp^3 + 54*d^2*pp^3 - 
          27*d^3*pp^3)*TAI[d, 0, {{1, m1}}]^2)/
      (24*(-3 + d)*(-1 + d)^2*d*(1 + d)*(-4 + 3*d)*(-2 + 3*d)*m1^2*pp^2) + 
     ((4*m1^2 - pp)^2*TAI[d, 0, {{1, m1}}]*TBI[d, pp, {{1, m1}, {1, m1}}])/
      (8*(-3 + d)*(-1 + d)^2*(1 + d)*m1^2) + 
     ((-72*d*m1^6 + 144*d^2*m1^6 - 88*d^3*m1^6 + 16*d^4*m1^6 - 
          96*m1^4*pp + 260*d*m1^4*pp - 166*d^2*m1^4*pp + 
          12*d^3*m1^4*pp + 6*d^4*m1^4*pp + 160*m1^2*pp^2 - 
          300*d*m1^2*pp^2 + 50*d^2*m1^2*pp^2 + 90*d^3*m1^2*pp^2 - 
          24*d^4*m1^2*pp^2 - 48*pp^3 + 114*d*pp^3 - 67*d^2*pp^3 + 
          4*d^3*pp^3 + 2*d^4*pp^3)*TJI[d, pp, {{1, m1}, {1, m1}, {1, 0}}])/
      (12*(-2 + d)*(-1 + d)^2*(1 + d)*(-4 + 3*d)*(-2 + 3*d)*pp^2) - 
     ((-4*m1^2 + pp)*(72*d*m1^6 - 144*d^2*m1^6 + 88*d^3*m1^6 - 
          16*d^4*m1^6 + 96*m1^4*pp - 236*d*m1^4*pp + 122*d^2*m1^4*pp + 
          12*d^3*m1^4*pp - 10*d^4*m1^4*pp - 96*m1^2*pp^2 + 
          180*d*m1^2*pp^2 - 30*d^2*m1^2*pp^2 - 46*d^3*m1^2*pp^2 + 
          8*d^4*m1^2*pp^2 + 24*pp^3 - 54*d*pp^3 + 27*d^2*pp^3)*
        TJI[d, pp, {{2, m1}, {1, m1}, {1, 0}}])/
(12*(-3 + d)*(-2 + d)*(-1 + d)^2*(1 + d)*(-4 + 3*d)*(-2 + 3*d)*pp^2) /; \
(m1=!=0)&&(pp=!=0);\
\>", "Input"],

Cell["\<\
TVR[6 + d_Symbol, pp_, 
    {{1, m1_}, {1, m1_}, {4, 0}, {1, m1_}}] := 
   ((2304*d*m1^10 - 4608*d^2*m1^10 - 3520*d^3*m1^10 + 6976*d^4*m1^10 + 
          1472*d^5*m1^10 - 2624*d^6*m1^10 - 256*d^7*m1^10 + 
          256*d^8*m1^10 + 4608*m1^8*pp - 9600*d*m1^8*pp - 
          7680*d^2*m1^8*pp + 9312*d^3*m1^8*pp + 11680*d^4*m1^8*pp - 
          6560*d^5*m1^8*pp - 2880*d^6*m1^8*pp + 1088*d^7*m1^8*pp + 
          32*d^8*m1^8*pp + 6912*m1^6*pp^2 - 35712*d*m1^6*pp^2 + 
          1056*d^2*m1^6*pp^2 + 85296*d^3*m1^6*pp^2 - 
          37032*d^4*m1^6*pp^2 - 20484*d^5*m1^6*pp^2 + 
          8700*d^6*m1^6*pp^2 - 12*d^7*m1^6*pp^2 - 84*d^8*m1^6*pp^2 - 
          20736*m1^4*pp^3 + 58752*d*m1^4*pp^3 + 40560*d^2*m1^4*pp^3 - 
          150536*d^3*m1^4*pp^3 + 18980*d^4*m1^4*pp^3 + 
          48946*d^5*m1^4*pp^3 - 6748*d^6*m1^4*pp^3 - 146*d^7*m1^4*pp^3 + 
          128*d^8*m1^4*pp^3 + 3456*m1^2*pp^4 - 13824*d*m1^2*pp^4 - 
          4176*d^2*m1^2*pp^4 + 35784*d^3*m1^2*pp^4 - 
          8332*d^4*m1^2*pp^4 - 10162*d^5*m1^2*pp^4 + 
          1122*d^6*m1^2*pp^4 - 80*d^7*m1^2*pp^4 - 8*d^8*m1^2*pp^4 + 
          864*d*pp^5 - 216*d^2*pp^5 - 2268*d^3*pp^5 + 486*d^4*pp^5 + 
          729*d^5*pp^5)*TAI[d, 0, {{1, m1}}]^2)/
      (432*(-3 + d)*(-1 + d)^2*d^2*(1 + d)*(2 + d)*(3 + d)*(-4 + 3*d)*
        (-2 + 3*d)*(2 + 3*d)*m1^2*pp^3) + 
     ((4*m1^2 - pp)^3*TAI[d, 0, {{1, m1}}]*TBI[d, pp, {{1, m1}, {1, m1}}])/
      (16*(-3 + d)*(-1 + d)^2*d*(1 + d)*(3 + d)*m1^2) - 
     ((-1152*m1^10 + 2880*d*m1^10 + 320*d^2*m1^10 - 3648*d^3*m1^10 + 
          1088*d^4*m1^10 + 768*d^5*m1^10 - 256*d^6*m1^10 - 192*m1^8*pp + 
          1312*d*m1^8*pp + 2080*d^2*m1^8*pp - 6880*d^3*m1^8*pp + 
          4032*d^4*m1^8*pp - 192*d^5*m1^8*pp - 160*d^6*m1^8*pp + 
          6336*m1^6*pp^2 - 6960*d*m1^6*pp^2 - 16960*d^2*m1^6*pp^2 + 
          17292*d^3*m1^6*pp^2 - 1828*d^4*m1^6*pp^2 - 828*d^5*m1^6*pp^2 + 
          68*d^6*m1^6*pp^2 - 9504*m1^4*pp^3 + 3624*d*m1^4*pp^3 + 
          26104*d^2*m1^4*pp^3 - 10938*d^3*m1^4*pp^3 - 
          4976*d^4*m1^4*pp^3 + 330*d^5*m1^4*pp^3 + 400*d^6*m1^4*pp^3 + 
          6336*m1^2*pp^4 - 3640*d*m1^2*pp^4 - 14584*d^2*m1^2*pp^4 + 
          9190*d^3*m1^2*pp^4 + 1374*d^4*m1^2*pp^4 - 600*d^5*m1^2*pp^4 - 
          56*d^6*m1^2*pp^4 - 864*pp^5 + 732*d*pp^5 + 1864*d^2*pp^5 - 
          1695*d^3*pp^5 + 148*d^4*pp^5 + 36*d^5*pp^5 + 4*d^6*pp^5)*
        TJI[d, pp, {{1, m1}, {1, m1}, {1, 0}}])/
      (216*(-2 + d)*(-1 + d)^2*d*(1 + d)*(3 + d)*(-4 + 3*d)*(-2 + 3*d)*
        (2 + 3*d)*pp^3) + ((-4*m1^2 + pp)*
        (1152*m1^10 - 2880*d*m1^10 - 320*d^2*m1^10 + 3648*d^3*m1^10 - 
          1088*d^4*m1^10 - 768*d^5*m1^10 + 256*d^6*m1^10 + 576*m1^8*pp - 
          2208*d*m1^8*pp - 2304*d^2*m1^8*pp + 8000*d^3*m1^8*pp - 
          4256*d^4*m1^8*pp - 32*d^5*m1^8*pp + 224*d^6*m1^8*pp - 
          6336*m1^6*pp^2 + 6288*d*m1^6*pp^2 + 16320*d^2*m1^6*pp^2 - 
          14868*d^3*m1^6*pp^2 + 684*d^4*m1^6*pp^2 + 804*d^5*m1^6*pp^2 - 
          12*d^6*m1^6*pp^2 + 6912*m1^4*pp^3 - 3192*d*m1^4*pp^3 - 
          18160*d^2*m1^4*pp^3 + 7950*d^3*m1^4*pp^3 + 3128*d^4*m1^4*pp^3 - 
          78*d^5*m1^4*pp^3 - 160*d^6*m1^4*pp^3 - 3456*m1^2*pp^4 + 
          1800*d*m1^2*pp^4 + 8136*d^2*m1^2*pp^4 - 4322*d^3*m1^2*pp^4 - 
          1042*d^4*m1^2*pp^4 + 128*d^5*m1^2*pp^4 + 16*d^6*m1^2*pp^4 + 
          432*pp^5 - 324*d*pp^5 - 972*d^2*pp^5 + 729*d^3*pp^5)*
        TJI[d, pp, {{2, m1}, {1, m1}, {1, 0}}])/
      (216*(-3 + d)*(-2 + d)*(-1 + d)^2*d*(1 + d)*(3 + d)*(-4 + 3*d)*
        (-2 + 3*d)*(2 + 3*d)*pp^3) /; (m1=!=0)&&(pp=!=0);\
\>", "Input"],

Cell["\<\
 TVR[6 + d_Symbol, pp_, {{2, m1_}, {1, m1_}, {3, 0}, {1, m1_}}] := 
   -((-1536*d*m1^10 + 2560*d^2*m1^10 + 3200*d^3*m1^10 - 3584*d^4*m1^10 - 
           2176*d^5*m1^10 + 1024*d^6*m1^10 + 512*d^7*m1^10 - 
           3072*m1^8*pp + 6528*d*m1^8*pp + 5376*d^2*m1^8*pp - 
           7520*d^3*m1^8*pp - 5568*d^4*m1^8*pp + 3232*d^5*m1^8*pp + 
           1344*d^6*m1^8*pp - 320*d^7*m1^8*pp - 2304*m1^6*pp^2 + 
           13824*d*m1^6*pp^2 + 192*d^2*m1^6*pp^2 - 31584*d^3*m1^6*pp^2 + 
           11232*d^4*m1^6*pp^2 + 8088*d^5*m1^6*pp^2 - 
           2304*d^6*m1^6*pp^2 - 24*d^7*m1^6*pp^2 + 6912*m1^4*pp^3 - 
           19584*d*m1^4*pp^3 - 12688*d^2*m1^4*pp^3 + 
           50584*d^3*m1^4*pp^3 - 7516*d^4*m1^4*pp^3 - 
           16982*d^5*m1^4*pp^3 + 2564*d^6*m1^4*pp^3 + 310*d^7*m1^4*pp^3 - 
           1152*m1^2*pp^4 + 4608*d*m1^2*pp^4 + 1392*d^2*m1^2*pp^4 - 
           11896*d^3*m1^2*pp^4 + 2820*d^4*m1^2*pp^4 + 
           3374*d^5*m1^2*pp^4 - 414*d^6*m1^2*pp^4 + 8*d^7*m1^2*pp^4 - 
           288*d*pp^5 + 72*d^2*pp^5 + 756*d^3*pp^5 - 162*d^4*pp^5 - 
           243*d^5*pp^5)*TAI[d, 0, {{1, m1}}]^2)/
      (144*(-1 + d)^2*d^2*(1 + d)*(2 + d)*(3 + d)*(-4 + 3*d)*(-2 + 3*d)*
        (2 + 3*d)*m1^2*pp^3) + 
     ((4*m1^2 - pp)^3*TAI[d, 0, {{1, m1}}]*TBI[d, pp, {{1, m1}, {1, m1}}])/
      (16*(-1 + d)^2*d*(1 + d)*(3 + d)*m1^2) - 
     ((2304*m1^10 - 5760*d*m1^10 - 640*d^2*m1^10 + 7296*d^3*m1^10 - 
          2176*d^4*m1^10 - 1536*d^5*m1^10 + 512*d^6*m1^10 - 
          1344*m1^8*pp + 1120*d*m1^8*pp - 1376*d^2*m1^8*pp + 
          5280*d^3*m1^8*pp - 4896*d^4*m1^8*pp + 1280*d^5*m1^8*pp - 
          64*d^6*m1^8*pp - 5184*m1^6*pp^2 + 7584*d*m1^6*pp^2 + 
          14800*d^2*m1^6*pp^2 - 21496*d^3*m1^6*pp^2 + 
          6120*d^4*m1^6*pp^2 + 280*d^5*m1^6*pp^2 - 184*d^6*m1^6*pp^2 + 
          9504*m1^4*pp^3 - 3720*d*m1^4*pp^3 - 27296*d^2*m1^4*pp^3 + 
          15378*d^3*m1^4*pp^3 + 4114*d^4*m1^4*pp^3 - 666*d^5*m1^4*pp^3 - 
          674*d^6*m1^4*pp^3 - 6336*m1^2*pp^4 + 5720*d*m1^2*pp^4 + 
          13712*d^2*m1^2*pp^4 - 13926*d^3*m1^2*pp^4 + 
          1284*d^4*m1^2*pp^4 + 946*d^5*m1^2*pp^4 - 80*d^6*m1^2*pp^4 + 
          864*pp^5 - 1020*d*pp^5 - 1636*d^2*pp^5 + 2311*d^3*pp^5 - 
          693*d^4*pp^5 + 20*d^5*pp^5 + 4*d^6*pp^5)*
        TJI[d, pp, {{1, m1}, {1, m1}, {1, 0}}])/
      (72*(-2 + d)*(-1 + d)^2*d*(1 + d)*(3 + d)*(-4 + 3*d)*(-2 + 3*d)*
        (2 + 3*d)*pp^3) + ((4*m1^2 - pp)*
        (-768*m1^10 + 1664*d*m1^10 + 768*d^2*m1^10 - 2176*d^3*m1^10 + 
          512*d^5*m1^10 + 192*m1^8*pp + 288*d*m1^8*pp + 704*d^2*m1^8*pp - 
          2272*d^3*m1^8*pp + 1024*d^4*m1^8*pp + 64*d^5*m1^8*pp + 
          1920*m1^6*pp^2 - 1824*d*m1^6*pp^2 - 5472*d^2*m1^6*pp^2 + 
          4584*d^3*m1^6*pp^2 - 168*d^5*m1^6*pp^2 - 2304*m1^4*pp^3 + 
          616*d*m1^4*pp^3 + 6192*d^2*m1^4*pp^3 - 1946*d^3*m1^4*pp^3 - 
          1128*d^4*m1^4*pp^3 - 230*d^5*m1^4*pp^3 + 1152*m1^2*pp^4 - 
          600*d*m1^2*pp^4 - 2744*d^2*m1^2*pp^4 + 1414*d^3*m1^2*pp^4 + 
          374*d^4*m1^2*pp^4 - 16*d^5*m1^2*pp^4 - 144*pp^5 + 108*d*pp^5 + 
          324*d^2*pp^5 - 243*d^3*pp^5)*
        TJI[d, pp, {{2, m1}, {1, m1}, {1, 0}}])/
      (72*(-2 + d)*(-1 + d)^2*d*(1 + d)*(3 + d)*(-4 + 3*d)*(-2 + 3*d)*
        (2 + 3*d)*pp^3) /; (m1=!=0)&&(pp=!=0);\
\>", "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["five -> four", "Subsection",
  CellTags->"T1.6.121.1"],

Cell["\<\
TFI[d_, PP_/;Head[PP]=!=List,{ {0, m1_}, {n2_, m2_}, 
                               {n3_, m3_}, {n4_, m4_}, 
                               {n5_, m5_} }] := 
TVI[d,PP, {{n5,m5}, {n2,m2}, {n3,m3}, {n4,m4}}]\
\>", "Text"],

Cell[BoxData[
    \(TFR[d_, \ 
        PP_ /; Head[PP] =!= List, {\ {0, \ m1_}, \ {n2_, \ 
            m2_}, \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ {n3_, \ m3_}, \ {n4_, \ 
            m4_}, \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ {n5_, \ m5_}\ }]\  := \ \n
      TVI[d, PP, \ {{n5, m5}, \ {n2, m2}, \ {n3, m3}, \ {n4, m4}}]\)], "Input"],

Cell["\<\
TFI[d_,  PP_/;Head[PP]=!=List,{ {(n2_), m2_},{0, m1_},
                               {(n4_), m4_}, {(n3_), m3_}, 
                               {(n5_), m5_} }] := 
TVI[d,PP, {{n5,m5}, {n2,m2}, {n3,m3}, {n4,m4}}]\
\>", "Text"],

Cell[BoxData[
    \(TFR[
        d_, \ \ PP_ /; 
          Head[PP] =!= List, {\ {\((n2_)\), \ m2_}, {0, \ 
            m1_}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ {\((n4_)\), \ m4_}, \ {\((n3_)\), \ 
            m3_}, \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ {\((n5_)\), \ m5_}\ }]\  := \ \n
      TVI[d, PP, \ {{n5, m5}, \ {n2, m2}, \ {n3, m3}, \ {n4, m4}}]\)], "Input"],

Cell["\<\
TFI[d_,   PP_/;Head[PP]=!=List,{ {(n3_), m3_}, {(n4_), m4_},
\t\t                           {0, m1_}, {(n2_), m2_}, 
                               {(n5_), m5_} }] := 
TVI[d,PP, {{n5,m5}, {n2,m2}, {n3,m3}, {n4,m4}}]\
\>", "Text"],

Cell[BoxData[
    \(TFR[
        d_, \ \ \ PP_ /; 
          Head[PP] =!= List, {\ {\((n3_)\), \ m3_}, \ {\((n4_)\), \ 
            m4_}, \n\t\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
{0, \ m1_}, \ {\((n2_)\), \ 
            m2_}, \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ {\((n5_)\), \ m5_}\ }]\  := \ \n
      TVI[d, PP, \ {{n5, m5}, \ {n2, m2}, \ {n3, m3}, \ {n4, m4}}]\)], "Input"],

Cell["\<\
TFI[d_,   PP_/;Head[PP]=!=List,{ {(n4_), m4_},{(n3_), m3_},
\t\t                           {(n2_), m2_}, {0, m1_}, 
                               {(n5_), m5_} }] := 
TVI[d,PP, {{n5,m5}, {n2,m2}, {n3,m3}, {n4,m4}}]\
\>", "Text"],

Cell[BoxData[
    \(TFR[
        d_, \ \ \ PP_ /; 
          Head[PP] =!= List, {\ {\((n4_)\), \ m4_}, {\((n3_)\), \ 
            m3_}, \n\t\t\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
{\((n2_)\), \ m2_}, \ {0, \ 
            m1_}, \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ {\((n5_)\), \ m5_}\ }]\  := \ \n
      TVI[d, PP, \ {{n5, m5}, \ {n2, m2}, \ {n3, m3}, \ {n4, m4}}]\)], "Input"],

Cell["\<\

TFI[d_,  PP_/;Head[PP]=!=List,{{(n1_), m1_}, 

    {(n2_), m2_}, 

    {(n3_), m3_}, 

    {(n4_), m4_}, {0, m5_}}] := 

  TBI[d, PP, {{n1, m1}, {n3, m3}}]*

   TBI[d, PP, {{n2, m2}, {n4, m4}}]
\
\>", "Text"],

Cell["\<\
TFR[d_, PP_ /; Head[PP] =!= List, 
   {{n1_, m1_}, {n2_, m2_}, {n3_, m3_}, {n4_, m4_}, 
    {0, m5_}}] := TBI[d, PP, {{n1, m1}, {n3, m3}}]*
   TBI[d, PP, {{n2, m2}, {n4, m4}}]\
\>", "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["four -> three", "Subsection",
  CellTags->"T1.6.122.1"],

Cell[BoxData[
    \(TVI[d_, \ 
        PP_, {\ {0, \ m1_}, \ {n2_, \ 
            m2_}, \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ {n3_, \ m3_}, \ {n4_, \ m4_}\ }]\  := \ \n
      TAI[d, 0, {{n3, m3}}]\ TBI[d, PP, {{n2, m2}, {n4, m4}}]\)], "Input"],

Cell[BoxData[
    \(TVI[d_, \ 
        PP_, {\ {n1_, \ m1_}, \ {n2_, \ 
            m2_}, \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ {0, \ m3_}, \ {n4_, \ m4_}\ }]\  := \ \n
      TAI[d, 0, {{n1, m1}}]\ TBI[d, PP, {{n2, m2}, {n4, m4}}]\)], "Input"],

Cell["\<\
TVI[d_, PP_, {{n1_, m1_}, {0, m2_}, {n3_, m3_}, {n4_, m4_}}] := 
  TJI[d, 0, {{n1, m1}, {n3, m3}, {n4, m4}}]\
\>", "Input"],

Cell[BoxData[
    \(TVI[d_, \ 
        PP_, {\ {n1_, \ m1_}, \ {n2_, \ 
            m2_}, \ \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ {n3_, \ m3_}, \ {0, \ m4_}\ }]\  := \ \n
      TJI[d, PP, \ {{n2, m2}, {n1, m1}, {n3, m3}\ }]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["three -> two", "Subsection",
  CellTags->"T1.6.123.1"],

Cell[BoxData[
    \(TJI[d_, \ 
        PP_, {\ {0, \ m1_}, \ {\((n2_)\), \ m2_}, \ {\((n3_)\), \ 
            m3_}\ }]\  := \ \n
      TAI[d, 0, {{n2, m2}}]\ \ TAI[d, 0, {{n3, m3}}]\)], "Input"],

Cell[BoxData[
    \(TJI[d_, \ 
        PP_, {\ {\((n1_)\), \ m1_}, \ {0, \ m2_}, \ {\((n3_)\), \ 
            m3_}\ }]\  := \ \n
      TAI[d, 0, {{n1, m1}}]\ \ TAI[d, 0, {{n3, m3}}]\)], "Input"],

Cell[BoxData[
    \(TJI[d_, \ 
        PP_, {\ {\((n1_)\), \ m1_}, \ {\((n2_)\), \ m2_}, \ {0, \ 
            m3_}\ }]\  := \ \n
      TAI[d, 0, {{n1, m1}}]\ \ TAI[d, 0, {{n2, m2}}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["two -> one", "Subsection",
  CellTags->"T1.6.124.1"],

Cell[BoxData[
    \(\(\(\(TBI[d_, \ 
        PP_, {\ {0, \ m1_}, \ {\((n2_)\), \ 
            m2_}\ }]\)\(\ \)\)\(:=\)\(\ \)\(\n\)\(TAI[d, 
        0, {{n2, m2}}]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(TBI[d_, \ 
        PP_, {\ {\((n1_)\), \ m1_}, \ {0, \ 
            m2_}\ }]\)\(\ \)\)\(:=\)\(\ \)\(\n\)\(TAI[d, 
        0, {{n1, m1}}]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(TAI[d_, {{n_Integer, m_}}] := TAI[d, 0, {{n, m}}];\)\)], "Input"],

Cell[BoxData[
    \(\(TAI[d_, {n_Integer, m_}] := TAI[d, 0, {{n, m}}];\)\)], "Input"],

Cell[BoxData[
    \(\(TAI[d_, 0, {n_Integer, m_}] := TAI[d, 0, {{n, m}}];\)\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TarcerRecurse and TFIRecurse", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.7.1"],

Cell[CellGroupData[{

Cell["TFIRecurse & TFISimplify", "Subsection",
  CellTags->"T1.7.1.1"],

Cell["This cancels scalar products.", "Text"],

Cell[BoxData[
    \(\($TLRComment = False;\)\)], "Input"],

Cell[BoxData[
    \(\(TLRComment[s_String] := 
        WriteString["\<stdout\>", s, "\< \>"] /; $TLRComment === 
            True;\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(applytlrules[y_, fun_]\), " ", ":=", 
        RowBox[{"fun", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"y", " ", "/.", 
                RowBox[{
                  StyleBox["TFI",
                    FontColor->RGBColor[1, 0.6, 0]], "->", "TLR"}]}], "/.", 
              "TLRules"}], "/.", 
            RowBox[{"TLR", "->", 
              StyleBox["TFI",
                FontColor->RGBColor[1, 0.6, 0]]}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
    \(\(TFIRecurse[z_, f_ : Identity]\  := \ 
        FixedPoint[\ applytlrules[#, f] &, z, 1000];\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(applytlrules2[y_, fun_]\), " ", ":=", 
        RowBox[{"fun", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"y", " ", "/.", 
                RowBox[{
                  StyleBox["TFI",
                    FontColor->RGBColor[1, 0.6, 0]], "->", "TLR"}]}], "/.", 
              "TLRules2"}], "/.", 
            RowBox[{"TLR", "->", 
              StyleBox["TFI",
                FontColor->RGBColor[1, 0.6, 0]]}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
    \(\(TFISimplify[z_, f_ : Identity]\  := \ 
        FixedPoint[\ applytlrules2[#, f] &, z, 1000];\)\)], "Input"],

Cell["\<\
TFIRecurse[z_]:=z/.TFI\[Rule]TLR//.TLRules/.TLR\[Rule]TFI;\
\>", \
"Text"],

Cell[BoxData[
    \(\(ExpandMaybe = Identity;\)\)], "Input"],

Cell[BoxData[
    \(\(fN[li_List] := \(fN[li] = 
          li /. {0, _} \[RuleDelayed] {0, 0}\);\)\)], "Input"],

Cell["\<\
RM: new Feb. 1999  
need TLR[ ...]:= rule;
(copy from TFI definition) (in order to get e.g. 
TarcerRecurse[TFI[D,pp,{1,1,1,1,1},{{1,0},{1,M},{0,0},{1,m},{1,M}}]]
to work)\
\>", "Text",
  CellTags->"TLRdef"],

Cell[BoxData[
    \(\(TLR[depp__, {a___, b_Integer, c___}] := 
        TLR[depp, {a, {b, 0}, c}];\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(tlrule[1]\), "=", 
        RowBox[{\(TLR[d_, pp_, {0, 0, 0, 0, 0}, pr_]\), "\[RuleDelayed]", 
          RowBox[{"(", 
            RowBox[{\(NoTLRComment["\<tlrule1\>"]\), ";", 
              RowBox[{
                StyleBox["TFI",
                  FontColor->RGBColor[1, 0.6, 0]], "[", \(d, pp, 
                pr /. {0, _} \[RuleDelayed] {0, 0}\), "]"}]}], ")"}]}]}], 
      ";"}]], "Input"],

Cell["(* q1^2 *)", "Text"],

Cell[BoxData[
    \(\(tlrule[2] = 
        TLR[dpp__, {v_?PQ, w_, x_, y_, z_}, {{n1_?PQ, m1_}, nm2_, nm3_, nm4_, 
              nm5_}] \[RuleDelayed] \((TLRComment["\<tlrule2\>"]; 
            ExpandMaybe[
              If[v \[LessEqual] n1, 
                If[m1 === 0, 
                  TLR[dpp, {0, w, x, y, z}, {{n1 - v, 0}, nm2, nm3, nm4, 
                      nm5}], \[Sum]\+\(i = 0\)\%v Binomial[v, i]\ TLR[
                        dpp, \ {0, w, x, y, z}, {fN[{n1 - i, m1}], nm2, nm3, 
                          nm4, nm5}]\ \((m1\^2)\)\^\(v - i\)], 
                If[m1 === 0, 
                  TLR[dpp, {v - n1, w, x, y, z}, {{0, 0}, nm2, nm3, nm4, 
                      nm5}], \[Sum]\+\(i = 0\)\%n1 Binomial[n1, i]\ TLR[
                        dpp, {v - n1, w, x, y, z}, {fN[{n1 - i, m1}], nm2, 
                          nm3, nm4, 
                          nm5}]\ \((m1\^2)\)\^\(n1 - i\)]]])\);\)\)], "Input"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`q\_2\%2\)]]], "Text"],

Cell[BoxData[
    \(\(tlrule[3] = 
        TLR[dpp__, {v_, w_?PQ, x_, y_, z_}, {nm1_, {n2_?PQ, m2_}, nm3_, nm4_, 
              nm5_}] \[RuleDelayed] \((TLRComment["\<tlrule3\>"]; 
            ExpandMaybe[
              If[w \[LessEqual] n2, 
                If[m2 === 0, 
                  TLR[dpp, {v, 0, x, y, z}, {nm1, {n2 - w, 0}, nm3, nm4, 
                      nm5}], \[Sum]\+\(i = 0\)\%w Binomial[w, i]\ TLR[
                        dpp, {v, 0, x, y, z}, {nm1, fN[{n2 - i, m2}], nm3, 
                          nm4, nm5}]\ \((m2\^2)\)\^\(w - i\)], 
                If[m2 === 0, 
                  TLR[dpp, {v, w - n2, x, y, z}, {nm1, {0, 0}, nm3, nm4, 
                      nm5}], \[Sum]\+\(i = 0\)\%n2 Binomial[n2, i]\ TLR[
                        dpp, {v, w - n2, x, y, z}, {nm1, fN[{n2 - i, m2}], 
                          nm3, nm4, 
                          nm5}]\ \((m2\^2)\)\^\(n2 - i\)]]])\);\)\)], "Input"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`p\[CenterDot]q\_1\)]]], "Text"],

Cell[BoxData[
    \(\(tlrule[4] = 
        TLR[dpp__, {v_, w_, x_?PQ, y_, z_}, {{n1_?PQ, m1_}, 
              nm2_, {n3_?PQ, m3_}, nm4_, 
              nm5_}] \[RuleDelayed] \((TLRComment["\<tlrule4\>"]; 
            ExpandMaybe[
              1\/2\ TLR[
                    dpp, {v + 1, w, x - 1, y, z}, {{n1, m1}, nm2, {n3, m3}, 
                      nm4, nm5}] - 
                1\/2\ TLR[
                    dpp, {v, w, x - 1, y, z}, {{n1, m1}, nm2, 
                      fN[{n3 - 1, m3}], nm4, nm5}] + 
                1\/2\ \(({dpp}\[LeftDoubleBracket]2\[RightDoubleBracket] - 
                      m3\^2)\)\ TLR[
                    dpp, {v, w, x - 1, y, z}, {{n1, m1}, nm2, {n3, m3}, nm4, 
                      nm5}]])\);\)\)], "Input"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`p\[CenterDot]q\_2\)]]], "Text"],

Cell[BoxData[
    \(\(tlrule[5] = 
        TLR[dpp__, {v_, w_, x_, y_?PQ, z_}, {{n1_, m1_}, {n2_?PQ, m2_}, 
              nm3_, {n4_?PQ, m4_}, 
              nm5_}] \[RuleDelayed] \((TLRComment["\<tlrule5\>"]; 
            ExpandMaybe[
              1\/2\ TLR[
                    dpp, {v, w + 1, x, y - 1, z}, {{n1, m1}, {n2, m2}, 
                      nm3, {n4, m4}, nm5}] - 
                1\/2\ TLR[
                    dpp, {v, w, x, y - 1, z}, {{n1, m1}, {n2, m2}, nm3, 
                      fN[{n4 - 1, m4}], nm5}] + 
                1\/2\ \(({dpp}\[LeftDoubleBracket]2\[RightDoubleBracket] - 
                      m4\^2)\)\ TLR[
                    dpp, {v, w, x, y - 1, z}, {{n1, m1}, {n2, m2}, 
                      nm3, {n4, m4}, nm5}]])\);\)\)], "Input"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`q\_1\[CenterDot]q\_2\)]]], "Text"],

Cell[BoxData[
    \(\(tlrule[6] = 
        TLR[dpp__, {v_, w_, x_, y_, z_?PQ}, {{n1_, m1_}, {n2_, m2_}, nm3_, 
              nm4_, {n5_?PQ, 
                m5_}}] \[RuleDelayed] \((TLRComment["\<tlrule6\>"]; 
            ExpandMaybe[
              1\/2\ TLR[
                    dpp, {v + 1, w, x, y, z - 1}, {{n1, m1}, {n2, m2}, nm3, 
                      nm4, {n5, m5}}] - 
                1\/2\ TLR[
                    dpp, {v, w, x, y, z - 1}, {{n1, m1}, {n2, m2}, nm3, nm4, 
                      fN[{n5 - 1, m5}]}] + 
                1\/2\ TLR[
                    dpp, {v, w + 1, x, y, z - 1}, {{n1, m1}, {n2, m2}, nm3, 
                      nm4, {n5, m5}}] - 
                1\/2\ m5\^2\ TLR[
                    dpp, {v, w, x, y, z - 1}, {{n1, m1}, {n2, m2}, nm3, 
                      nm4, {n5, m5}}]])\);\)\)], "Input"],

Cell["(* q1.q1  --> q1.p *)", "Text"],

Cell[BoxData[
    \(\(tlrule[7] = 
        TLR[d_, pp_, 
            dp___, {v_?PQ, w_, x_, y_, z_}, {{0, _}, nm2_, {n3_?PQ, m3_}, 
              nm4_, nm5_}] \[RuleDelayed] \((TLRComment["\<tlrule7\>"]; 
            ExpandMaybe[
              TLR[d, pp, 
                  dp, {v - 1, w, x, y, z}, {{0, 0}, nm2, fN[{n3 - 1, m3}], 
                    nm4, nm5}] + 
                2\ TLR[d, pp, 
                    dp, {v - 1, w, x + 1, y, z}, {{0, 0}, nm2, {n3, m3}, nm4, 
                      nm5}] - \((pp - m3\^2)\)\ TLR[d, pp, 
                    dp, {v - 1, w, x, y, z}, {{0, 0}, nm2, {n3, m3}, nm4, 
                      nm5}]])\);\)\)], "Input"],

Cell["(* q2.q2  --> q2.p *)", "Text"],

Cell[BoxData[
    \(\(tlrule[8] = 
        TLR[d_, pp_, 
            dp___, {v_, w_?PQ, x_, y_, z_}, {nm1_, {0, _}, 
              nm3_, {n4_?PQ, m4_}, 
              nm5_}] \[RuleDelayed] \((TLRComment["\<tlrule8\>"]; 
            ExpandMaybe[
              TLR[d, pp, 
                  dp, {v, w - 1, x, y, z}, {nm1, {0, 0}, nm3, 
                    fN[{n4 - 1, m4}], nm5}] + 
                2\ TLR[d, pp, 
                    dp, {v, w - 1, x, y + 1, z}, {nm1, {0, 0}, nm3, {n4, m4}, 
                      nm5}] - \((pp - m4\^2)\)\ TLR[d, pp, 
                    dp, {v, w - 1, x, y, z}, {nm1, {0, 0}, nm3, {n4, m4}, 
                      nm5}]])\);\)\)], "Input"],

Cell["(* eq. (3) - (5) *)", "Text"],

Cell[BoxData[
    \(\(tlrule[9] = 
        TLR[d_, pp_, {v_, w_, x_, y_, z_?PQ}, {nm1_, nm2_, nm3_, 
              nm4_, {0, _}}] \[RuleDelayed] \((TLRComment["\<tlrule9\>"]; 
            FunctionExpand[
              ExpandMaybe[\[Sum]\+\(k = 0\)\%\(Floor[z\/2]\)\(\[Sum]\+\(i = 0\
\)\%k\(\[Sum]\+\(j = 0\)\%k\((Gamma[k + 1\/2]\ Gamma[d\/2 - 1\/2]\ Binomial[
                              z, 2\ k]\ Binomial[k, i]\ Binomial[k, 
                              j]\ \((\(-1\))\)\^\(i + j\)\ pp\^\(i + j - z\)\ \
TLR[d, pp, {v + i, w + j, x + z - 2\ i, y + z - 2\ j, 0}, {nm1, nm2, nm3, 
                                nm4, {0, 0}}])\)/\((Gamma[1\/2]\ Gamma[
                              k + d\/2 - 1\/2])\)\)\)]])\);\)\)], "Input"],

Cell[" OLD trule[10]:", "Text"],

Cell["\<\
tlrule[10] = 
(* (9) and (10) *)
TLR[d_, pp_, {v_,w_,x_?PQ,y_?PQ,z_}, {{n1_?PQ,m1_},{n2_?PQ,m2_}, 
                                {0,_},{0,_},nm5_}] :>  
( TLRComment[\"tlrule10\"]; 0 /; OddQ[x+y] );\
\>", "Text"],

Cell["New tlrule[10]:", "Text"],

Cell["\<\
tlrule[10] = 
   TLR[d_, pp_, {v_, w_, (x_)?PNQ, (y_)?PNQ, z_}, 
     {{(n1_)?PQ, m1_}, {(n2_)?PQ, m2_}, {0, _}, {0, _}, nm5_}] :> \
(TLRComment[\"tlrule10\"]; 0 /; OddQ[x + y]); \
\>", "Input"],

Cell["\<\
Bug in  tlrule[11] and tlrule[12] fixed on Feb. 26th 1998 by \
R.Scharf 
with thanks to York Schroeder for locating the bug.\
\>", "Text"],

Cell["\<\

tlrule[11] = 
TLR[d_, pp_, {v_,w_,x_?PQ,y_?PQ,z_}, {nm1_,nm2_,{0,_},{0,_},{(n5_)?PQ, m5_}}] \
:> 
(
TLRComment[\"tlrule11\"];
 ExpandMaybe[
 pp/(d+x+y-2)( (x-1) TLR[d, pp, {v+1,w,x-2,y,z}, 
                         {{n1,m1},{n2,m2},{0,0},{0,0},{n5,m5}}] +
                   y TLR[d, pp, {v,w,x-1,y-1,z+1}, 
                         {nm1,nm2,{0,0},{0,0},{n5,m5}}]
             )
           ] /; EvenQ[x+y] && x > 1
);\
\>", "Input"],

Cell["\<\

tlrule[12] = 
TLR[d_, pp_, {v_,w_,x_?PQ,y_?PQ,z_}, {nm1_,nm2_,{0,_},{0,_},{(n5_)?PQ, m5_}}] \
:> 
(
TLRComment[\"tlrule12\"];
 ExpandMaybe[
 pp/(d+x+y-2)( (y-1) TLR[d, pp, {v,w+1,x,y-2,z}, 
                         {{n1,m1},{n2,m2},{0,0},{0,0},{n5,m5}}] +
                   x TLR[d, pp, {v,w,x-1,y-1,z+1}, 
                         {nm1,nm2,{0,0},{0,0},{n5,m5}}]
             )
           ] /; EvenQ[x+y] && y > 1
);\
\>", "Input"],

Cell["(*symm.   1 <-> 3  &&  2 <-> 4 *)", "Text"],

Cell[BoxData[
    \(\(tlrule[13] = 
        TLR[d_, pp_, {0, 0, 0, y_?PQ, 0}, {nm1_, {0, 0}, nm3_, {n4_?PQ, m4_}, 
              nm5_}] \[RuleDelayed] \((TLRComment["\<tlrule13\>"]; \
\[Sum]\+\(i = 0\)\%y Binomial[y, i]\ pp\^\(y - i\)\ \((\(-1\))\)\^i\ TLR[d, 
                  pp, {0, 0, 0, i, 0}, {nm3, {n4, m4}, nm1, {0, 0}, 
                    nm5}])\);\)\)], "Input"],

Cell["(*symm.   1 <-> 3  &&  2 <-> 4 *)", "Text"],

Cell[BoxData[
    \(\(tlrule[14] = 
        TLR[d_, pp_, {0, 0, x_?PQ, 0, 0}, {{0, 0}, nm2_, {n3_?PQ, m3_}, nm4_, 
              nm5_}] \[RuleDelayed] \((TLRComment["\<tlrule14\>"]; \
\[Sum]\+\(i = 0\)\%x Binomial[x, i]\ pp\^\(x - i\)\ \((\(-1\))\)\^i\ TLR[d, 
                  pp, {0, 0, i, 0, 0}, {{n3, m3}, nm4, {0, 0}, nm2, 
                    nm5}])\);\)\)], "Input"],

Cell["(* 0's *)", "Text"],

Cell[BoxData[
    \(\(tlrule[15] = 
        HoldPattern[
            TLR[d_, pp_, {v_, w_, x_, y_, 
                z_}, {{n1_, 0}, {n2_, 
                  0}, {0, _}, {0, _}, {0, _}}]] \[RuleDelayed] \
\((TLRComment["\<tlrule15\>"]; 0)\);\)\)], "Input"],

Cell[BoxData[
    \(\(tlrule[16] = 
        TLR[d_, pp_, {0, 0, x_?PQ, y_?PQ, 
              0}, {{n1_, _}, {n2_, _}, {0, _}, {0, _}, {0, _}}] \
\[RuleDelayed] \((TLRComment["\<tlrule16\>"]; 
            0 /; OddQ[x] || OddQ[y])\);\)\)], "Input"],

Cell["bug in tlrule[17] fixedApril 23rd 1999", "Text",
  CellTags->"tlrule17"],

Cell[BoxData[
    \(\(tlrule[17] = 
        TLR[d_, pp_, {a_?PQ, b_, 0, de_, 
              0}, {{0, _}, {n2_, m2_}, {0, _}, {n4_, m4_}, {n5_, 
                m5_}}] \[RuleDelayed] \((TLRComment["\<tlrule17\>"]; \[Sum]\+\
\(i = 0\)\%a\(\[Sum]\+\(j = 0\)\%i Binomial[a, i]\ Binomial[i, 
                    j]\ \((1 + \((\(-1\))\)\^j)\)\ 2\^\(j - 1\)\ TLR[d, 
                    pp, {a - i, b + i - j, 0, de, 
                      j}, {{n5, m5}, {n2, m2}, {0, 0}, {n4, m4}, {0, 
                        0}}]\))\);\)\)], "Input"],

Cell[BoxData[
    \(\(tlrule[18] = 
        TLR[d_, pp_, 
            dp_, {a_?PNQ, b_?PNQ}, {1, 0, 0, 0, 
              0}, {{0, 0}, {n2_, m2_}, {n3_, m3_}, {n4_, m4_}, {n5_, 
                m5_}}] \[RuleDelayed] \((TLRComment["\<tlrule18\>"]; \[Sum]\+\
\(i = 0\)\%a\(\[Sum]\+\(j = 0\)\%b Binomial[a, i]\ Binomial[b, 
                    j]\ \((\((pp + m3\^2)\)\ TLR[d, pp, 
                          dp, {i, 
                            j}, {{n3, m3}, {n4, m4}, {0, 0}, {n2, m2}, {n5, 
                              m5}}] + 
                      TLR[d, pp, 
                        dp, {i, 
                          j}, {{n3 - 1, m3}, {n4, m4}, {0, 0}, {n2, m2}, {n5, 
                            m5}}] - 
                      2\ TLR[d, pp, 
                          dp, {i, j}, {0, 0, 1, 0, 
                            0}, {{n3, m3}, {n4, m4}, {0, 0}, {n2, m2}, {n5, 
                              m5}}])\)\ \((\(-1\))\)\^\(i + j\)\ dp\^\(a + b \
- i - j\)\))\);\)\)], "Input"],

Cell[BoxData[
    \(\(tlrule[19] = 
        TLR[d_, pp_, 
            dp_, {a_?PNQ, b_?PNQ}, {0, 1, 0, 0, 
              0}, {{n1_, m1_}, {0, 0}, {n3_, m3_}, {n4_, m4_}, {n5_, 
                m5_}}] \[RuleDelayed] \((TLRComment["\<tlrule18\>"]; \[Sum]\+\
\(i = 0\)\%a\(\[Sum]\+\(j = 0\)\%b Binomial[a, i]\ Binomial[b, 
                    j]\ \((\((pp + m4\^2)\)\ TLR[d, pp, 
                          dp, {i, 
                            j}, {{n3, m3}, {n4, m4}, {n1, m1}, {0, 0}, {n5, 
                              m5}}] + 
                      TLR[d, pp, 
                        dp, {i, 
                          j}, {{n3, m3}, {n4 - 1, m4}, {n1, m1}, {0, 0}, {n5, 
                            m5}}] - 
                      2\ TLR[d, pp, 
                          dp, {i, j}, {0, 0, 0, 1, 
                            0}, {{n3, m3}, {n4, m4}, {n1, m1}, {0, 0}, {n5, 
                              m5}}])\)\ \((\(-1\))\)\^\(i + j\)\ dp\^\(a + b \
- i - j\)\))\);\)\)], "Input"],

Cell["(* q1.q1  --> q1.p *)", "Text"],

Cell[BoxData[
    \(\(tlrule[20] = 
        TLR[d_, pp_, {v_?PQ, w_, x_, y_, 0}, {{0, _}, nm2_, {0, _}, 
              nm4_, {n5_?PQ, 
                m5_}}] \[RuleDelayed] \((TLRComment["\<tlrule20\>"]; \[Sum]\+\
\(j = 0\)\%x\(\[Sum]\+\(i = 0\)\%v\(\[Sum]\+\(r = 0\)\%i Binomial[i, 
                      r]\ Binomial[v, i]\ Binomial[x, j]\ 2\^r\ TLR[d, 
                      pp, {v - i, \(-r\) + i + w, j, x - j + y, 
                        r}, {{n5, m5}, nm2, 0, nm4, 0}]\)\))\);\)\)], "Input"],

Cell[BoxData[
    \(\(tlrule[21] = 
        TLR[d_, pp_, {v_, w_?PQ, x_, y_, 0}, {nm1_, {0, _}, nm3_, {0, _}, 
              nm5_}] \[RuleDelayed] \((TLRComment["\<tlrule21\>"]; 
            TLR[d, pp, {w, v, y, x, 0}, {{0, 0}, nm1, {0, 0}, nm3, 
                nm5}])\);\)\)], "Input"],

Cell[BoxData[
    \(\(tlrule[22] = 
        TLR[d_, pp_, 
            dp_, {0, b_?PNQ}, {0, w_?PNQ, 0, y_?PNQ, 1}, {nm1_, nm2_, nm3_, 
              nm4_, {0, 
                0}}] \[RuleDelayed] \((TLRComment["\<tlrule22\>"]; \(1\/pp\) \
\((TLR[d, pp, dp, {0, b}, {0, w, 1, y + 1, 0}, {nm1, nm2, nm3, 
                    nm4, {0, 0}}])\))\);\)\)], "Input"],

Cell[TextData[{
  "Using  FeynCalc : \n\n",
  Cell[BoxData[
      \(TIDL[{{k1, \[Mu]}, {k1, \[Nu]}}, {p}]\)], "Input"],
  "\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["p",
                            "TraditionalForm"]}],
                        "TraditionalForm"], ")"}], "2"], "-", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}]}], ")"}]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}]], "-", 
          FractionBox[
            RowBox[{
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"D", " ", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        FormBox[
                          RowBox[{
                            FormBox["k1",
                              "TraditionalForm"], "\[NoBreak]", 
                            "\[CenterDot]", "\[NoBreak]", 
                            FormBox["p",
                              "TraditionalForm"]}],
                          "TraditionalForm"], ")"}], "2"]}], "-", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}]}], ")"}]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "4"]}]]}], TraditionalForm]], 
    "Output"],
  "\n",
  Cell[BoxData[
      \(Collect2[Calc[\ FVD[OPEDelta, \[Mu]] FVD[k2, \[Nu]] %], {k1, k2}]\)], 
    "Input"],
  "\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            RowBox[{
              RowBox[{
                FormBox["k2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}], " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p",
                        "TraditionalForm"]}],
                    "TraditionalForm"], ")"}], "2"]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}]], "-", 
          FractionBox[
            RowBox[{"D", " ", 
              RowBox[{
                FormBox["k2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p",
                        "TraditionalForm"]}],
                    "TraditionalForm"], ")"}], "2"]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "4"]}]], "-", 
          FractionBox[
            RowBox[{
              SuperscriptBox[
                FormBox["k1",
                  "TraditionalForm"], "2"], " ", 
              RowBox[{
                FormBox["k2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}]}], \(1 - D\)], "+", 
          FractionBox[
            RowBox[{
              SuperscriptBox[
                FormBox["k1",
                  "TraditionalForm"], "2"], " ", 
              RowBox[{
                FormBox["k2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}]]}], TraditionalForm]], 
    "Output"],
  "\n"
}], "Text"],

Cell[BoxData[
    \(\(tlrule[23] = 
        TLR[d_, pp_, 
            dp_, {1, b_?PNQ}, {0, w_?PNQ, 0, y_?PNQ, 1}, {nm1_, nm2_, nm3_, 
              nm4_, {0, 
                0}}] \[RuleDelayed] \((TLRComment["\<tlrule23\>"]; \
\(1\/\(\((1 - d)\) pp\)\) \((TLR[d, pp, 
                    dp, {0, b + 1}, {0, w, 2, y, 0}, {nm1, nm2, nm3, 
                      nm4, {0, 0}}])\) - \(\(d\ \ dp\)\/\(\((1 - d)\) 
                      pp\^2\)\) \((TLR[d, pp, 
                    dp, {0, b}, {0, w, 2, y + 1, 0}, {nm1, nm2, nm3, 
                      nm4, {0, 0}}])\) - \(1\/\(1 - d\)\) 
                TLR[d, pp, 
                  dp, {0, b + 1}, {1, w, 0, y, 0}, {nm1, nm2, nm3, 
                    nm4, {0, 0}}] + \(dp\/\(\((1 - d)\) pp\)\) 
                TLR[d, pp, 
                  dp, {0, b}, {1, w, 0, y + 1, 0}, {nm1, nm2, nm3, 
                    nm4, {0, 0}}])\);\)\)], "Input"],

Cell[TextData[{
  Cell[BoxData[
      \(TIDL[{{k1, \[Mu]}, {k1, \[Nu]}, {k1, \[Rho]}}, {p}]\)], "Input"],
  "\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              RowBox[{
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]], " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]], " ", 
                RowBox[{
                  FormBox["k1",
                    "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                  "\[NoBreak]", 
                  FormBox["p",
                    "TraditionalForm"]}], " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{\((D + 2)\), " ", 
                      SuperscriptBox[
                        RowBox[{"(", 
                          FormBox[
                            RowBox[{
                              FormBox["k1",
                                "TraditionalForm"], "\[NoBreak]", 
                              "\[CenterDot]", "\[NoBreak]", 
                              FormBox["p",
                                "TraditionalForm"]}],
                            "TraditionalForm"], ")"}], "2"]}], "-", 
                    RowBox[{"3", " ", 
                      SuperscriptBox[
                        FormBox["k1",
                          "TraditionalForm"], "2"], " ", 
                      SuperscriptBox[
                        FormBox["p",
                          "TraditionalForm"], "2"]}]}], ")"}]}], 
              RowBox[{\((1 - D)\), " ", 
                SuperscriptBox[
                  FormBox["p",
                    "TraditionalForm"], "6"]}]]}], "+", 
          FractionBox[
            RowBox[{
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Mu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["p",
                            "TraditionalForm"]}],
                        "TraditionalForm"], ")"}], "2"], "-", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}]}], ")"}]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "4"]}]], "+", 
          FractionBox[
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["\[Rho]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Nu]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["p",
                            "TraditionalForm"]}],
                        "TraditionalForm"], ")"}], "2"], "-", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}]}], ")"}]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "4"]}]], "+", 
          FractionBox[
            RowBox[{
              SuperscriptBox["g", 
                RowBox[{
                  FormBox[
                    FormBox["\[Mu]",
                      "TraditionalForm"],
                    "TraditionalForm"], "\[NoBreak]", 
                  FormBox[
                    FormBox["\[Nu]",
                      "TraditionalForm"],
                    "TraditionalForm"]}]], " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], 
                FormBox[
                  FormBox["\[Rho]",
                    "TraditionalForm"],
                  "TraditionalForm"]], " ", 
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{"(", 
                RowBox[{
                  SuperscriptBox[
                    RowBox[{"(", 
                      FormBox[
                        RowBox[{
                          FormBox["k1",
                            "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                          "\[NoBreak]", 
                          FormBox["p",
                            "TraditionalForm"]}],
                        "TraditionalForm"], ")"}], "2"], "-", 
                  RowBox[{
                    SuperscriptBox[
                      FormBox["k1",
                        "TraditionalForm"], "2"], " ", 
                    SuperscriptBox[
                      FormBox["p",
                        "TraditionalForm"], "2"]}]}], ")"}]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "4"]}]]}], TraditionalForm]], 
    "Output"],
  "\n",
  Cell[BoxData[
      \(Collect2[
        Calc[\ FVD[OPEDelta, \[Mu]] FVD[OPEDelta, \[Nu]] 
            FVD[k2, \[Rho]] %], {k1, k2}]\)], "Input"],
  "\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FractionBox[
            RowBox[{"2", " ", 
              RowBox[{
                FormBox["k2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p",
                        "TraditionalForm"]}],
                    "TraditionalForm"], ")"}], "3"]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "4"]}]], "-", 
          FractionBox[
            RowBox[{\((D + 2)\), " ", 
              RowBox[{
                FormBox["k2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox["\[CapitalDelta]",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p",
                        "TraditionalForm"]}],
                    "TraditionalForm"], ")"}], "2"], " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox["k1",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p",
                        "TraditionalForm"]}],
                    "TraditionalForm"], ")"}], "3"]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "6"]}]], "-", 
          FractionBox[
            RowBox[{"2", " ", 
              SuperscriptBox[
                FormBox["k1",
                  "TraditionalForm"], "2"], " ", 
              RowBox[{
                FormBox["k2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["\[CapitalDelta]",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "2"]}]], "+", 
          FractionBox[
            RowBox[{"3", " ", 
              SuperscriptBox[
                FormBox["k1",
                  "TraditionalForm"], "2"], " ", 
              RowBox[{
                FormBox["k2",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}], " ", 
              SuperscriptBox[
                RowBox[{"(", 
                  FormBox[
                    RowBox[{
                      FormBox["\[CapitalDelta]",
                        "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                      "\[NoBreak]", 
                      FormBox["p",
                        "TraditionalForm"]}],
                    "TraditionalForm"], ")"}], "2"], " ", 
              RowBox[{
                FormBox["k1",
                  "TraditionalForm"], "\[NoBreak]", "\[CenterDot]", 
                "\[NoBreak]", 
                FormBox["p",
                  "TraditionalForm"]}]}], 
            RowBox[{\((1 - D)\), " ", 
              SuperscriptBox[
                FormBox["p",
                  "TraditionalForm"], "4"]}]]}], TraditionalForm]], "Output"]
}], "Text"],

Cell[BoxData[
    \(\(tlrule[24] = 
        TLR[d_, pp_, 
            dp_, {2, b_?PNQ}, {0, w_?PNQ, 0, y_?PNQ, 1}, {nm1_, nm2_, nm3_, 
              nm4_, {0, 0}}] \[RuleDelayed] \((TLRComment["\<tlrule24\>"]; 
            2  dp \(\( 1\/\(\((1 - d)\) pp\^2\)\) \((TLR[d, pp, 
                      dp, {0, b + 1}, {0, w, 3, y, 0}, {nm1, nm2, nm3, 
                        nm4, {0, 0}}])\)\) - \(\(\((d + 
                          2)\)\ \ dp\^2\)\/\(\((1 - d)\) pp\^3\)\) \((TLR[d, 
                    pp, dp, {0, b}, {0, w, 3, y + 1, 0}, {nm1, nm2, nm3, 
                      nm4, {0, 0}}])\) - \(\(2  dp\)\/\(\((1 - d)\) pp\)\) 
                TLR[d, pp, 
                  dp, {0, b + 1}, {1, w, 1, y, 0}, {nm1, nm2, nm3, 
                    nm4, {0, 0}}] + \(\(3  dp\^2\)\/\(\((1 - d)\) pp\^2\)\) 
                TLR[d, pp, 
                  dp, {0, b}, {1, w, 1, y + 1, 0}, {nm1, nm2, nm3, 
                    nm4, {0, 0}}])\);\)\)], "Input"],

Cell["Symmetry 1 <--> 2; added February 21 1999 by R.M.", "Text"],

Cell[BoxData[
    \(\(\(tlrule[25] = 
        TLR[dim_, 
            pp_, \ {a_, \ b_, \ \((c_)\)?PNQ, \ \((d_)\)?PQ, \ 
              0}, \ \(\({nm1_, \ nm2_, \ nm3_, \ {0, \ _}, \ nm5_}\)\(\n\)
            \)\ \ \ ]\  :> \((TLRComment["\<tlrule25\>"]; \ 
              TLR[dim, \ 
                pp, \ {b, a, \ d, \ c, \ 0}, \ {nm2, \ nm1, \ {0, 0}, \ 
                  nm3, \ nm5}])\)\  /; \ d\  > \ c;\)\(\n\)
    \)\)], "Input"],

Cell[BoxData[
    \(\(TLRules = Array[tlrule, 25];\)\)], "Input"],

Cell[BoxData[
    \(\(TLRules2 = Drop[TLRules, {9, 9}];\)\)], "Input"],

Cell[BoxData[
    \(\(TLR[__, {{_, _}, {0, _}, {_, _}, {0, _}, {_, 0}}] := 0;\)\)], "Input"],

Cell[BoxData[
    \(\(TLR[__, {{0, _}, {_, _}, {0, _}, {_, _}, {_, 0}}] := 0;\)\)], "Input"],

Cell[BoxData[
    \(\(TLR[__, {{0, _}, {_, _}, {_, 0}, {_, _}, {0, _}}] := 0;\)\)], "Input"],

Cell[BoxData[
    \(\(TLR[__, {{_, 0}, {_, _}, {0, _}, {_, _}, {0, _}}] := 0;\)\)], "Input"],

Cell[BoxData[
    \(\(TLR[__, {{_, _}, {_, 0}, {_, _}, {0, _}, {0, _}}] := 0;\)\)], "Input"],

Cell[BoxData[
    \(\(TLR[__, {{_, _}, {0, _}, {_, _}, {_, 0}, {0, _}}] := 0;\)\)], "Input"],

Cell[BoxData[
    \(\(SetAttributes[seeetDelayed, HoldAll];\)\)], "Input"],

Cell[BoxData[
    \(seeetDelayed[TLR[a__], b_] := SetDelayed @@ {TLR[a], b}\)], "Input"],

Cell[BoxData[
    \(\(lis1 = 
        Permutations[{{0, _}, {0, _}, {0, _}, {_, _}, {_, 0}}];\)\)], "Input"],

Cell[BoxData[
    \(\(lis2 = 
        Table[TLR[__, 
                lis1\[LeftDoubleBracket]
                  i\[RightDoubleBracket]] \[RuleDelayed] 0, {i, 
              Length[lis1]}] /. 
          RuleDelayed \[Rule] seeetDelayed;\)\)], "Input"],

Cell[BoxData[
    \(\(Clear[lis1, lis2];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["T*IS", "Subsection",
  CellTags->"T1.7.2.1"],

Cell["\<\
These functions below are never used.
They can serve as tests.\
\>", "Text"],

Cell[BoxData[
    \(TJIS[d_, 
        Power[M_, \ 
          2], \ {{\[Alpha]_, 0}, {\[Beta]_, 0}, {\[Gamma]_, 
            0}}] := \(\(\(SMu\^2\) \((\(\((\(-1\))\)\^\(\[Alpha] + \[Beta] + \
\[Gamma] + 1\)\/\((\(-\ M\^2\))\)\^\(\[Alpha] + \[Beta] + \[Gamma] - 4\)\) 
            Exp[\(-I\)\ Pi\ \((d - 
                    4)\)]\ \(Gamma[\[Alpha] + \[Beta] + \[Gamma] - 
                    d]\/Gamma[\(3\/2\) 
                      d - \[Alpha] - \[Beta] - \[Gamma]]\) \(Gamma[
                  d\/2 - \[Alpha]]\/Gamma[\[Alpha]]\) \(Gamma[
                  d\/2 - \[Beta]]\/Gamma[\[Beta]]\) 
            Gamma[d\/2 - \[Gamma]]\/Gamma[\[Gamma]])\)\)\(\n\)
      \)\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 
        Power[M_, \ 
          2], \ {{\[Beta]_, 0}, {\[Gamma]_, 0}, {\[Alpha]_, M_}}] := \n\t
      TJIS[d, M^2, {{\[Alpha], M}, {\[Beta], 0}, {\[Gamma], 0}}]\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 
        Power[M_, \ 
          2], \ {{\[Beta]_, 0}, {\[Alpha]_, M_}, {\[Gamma]_, 0}}] := \n\t
      TJIS[d, M^2, {{\[Alpha], M}, {\[Beta], 0}, {\[Gamma], 0}}]\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 
        Power[M_, \ 
          2], \ {{\[Alpha]_, M_}, {\[Beta]_, 0}, {\[Gamma]_, 
            0}}] := \n\(SMu\^2\/\((M\^2)\)\^\(\[Alpha] + \[Beta] + \[Gamma] - \
4\)\) \(\((\(-1\))\)\^\(\[Alpha] + \[Beta] + \[Gamma] + 
              1\)\) \(Gamma[\[Alpha] + \[Beta] + \[Gamma] - 
                d]\/\(Gamma[\[Alpha]] Gamma[\[Beta]] 
              Gamma[\[Gamma]]\)\) \(\(Gamma[d\/2 - \[Gamma]] 
              Gamma[d\/2 - \[Beta]]\)\/Gamma[
              d - \[Beta] - \[Gamma]]\) \(Gamma[\[Beta] + \[Gamma] - d\/2] \
Gamma[2\ d - \[Alpha] - 2  \[Beta] - 2  \[Gamma]]\)\/Gamma[\(3  d\)\/2 - \
\[Alpha] - \[Beta] - \[Gamma]]\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 0, \ {{\[Beta]_, 0}, {\[Alpha]_, M_}, {\[Gamma]_, 0}}] := 
      TJIS[d, 0, {{\[Alpha], M}, {\[Beta], 0}, {\[Gamma], 0}}]\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 0, \ {{\[Beta]_, 0}, {\[Gamma]_, 0}, {\[Alpha]_, M_}}] := 
      TJIS[d, 0, {{\[Alpha], M}, {\[Beta], 0}, {\[Gamma], 0}}]\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 
        0, \ {{\[Alpha]_, M_}, {\[Beta]_, 0}, {\[Gamma]_, 
            0}}] := \n\(SMu\^2\/\((M\^2)\)\^\(\[Alpha] + \[Beta] + \[Gamma] - \
4\)\) \(\((\(-1\))\)\^\(\[Alpha] + \[Beta] + \[Gamma] + 
              1\)\) \(Gamma[\[Alpha] + \[Beta] + \[Gamma] - 
                d]\/\(Gamma[\[Alpha]] Gamma[\[Beta]] 
              Gamma[\[Gamma]]\)\) \((Gamma[\[Beta] + \[Gamma] - d/2] 
              Gamma[d/2 - \[Beta]] Gamma[d/2 - \[Gamma]])\)/
          Gamma[d/2]\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 0, \ {{\[Beta]_, M_}, {\[Alpha]_, 0}, {\[Gamma]_, M_}}] := 
      TJIS[d, 0, {{\[Alpha], 0}, {\[Beta], M}, {\[Gamma], M}}]\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 0, \ {{\[Beta]_, M_}, {\[Gamma]_, M_}, {\[Alpha]_, 0}}] := 
      TJIS[d, 0, {{\[Alpha], 0}, {\[Beta], M}, {\[Gamma], M}}]\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 
        0, \ {{\[Alpha]_, 0}, {\[Beta]_, M_}, {\[Gamma]_, 
            M_}}] := \n\(SMu\^2\/\((M\^2)\)\^\(\[Alpha] + \[Beta] + \[Gamma] \
- 4\)\) \(\((\(-1\))\)\^\(\[Alpha] + \[Beta] + \[Gamma] + 
              1\)\) \(Gamma[\[Alpha] + \[Beta] + \[Gamma] - 
                d]\/\(Gamma[\[Beta]] Gamma[\[Gamma]]\)\) \(Gamma[
              d\/2 - \[Alpha]]\/Gamma[
              d\/2]\) \(Gamma[\[Alpha] + \[Gamma] - d\/2] Gamma[\[Alpha] + \
\[Beta] - d\/2]\)\/Gamma[2  \[Alpha] + \[Beta] + \[Gamma] - d]\)], "Input"],

Cell[BoxData[
    \(TJIS[d_, 
        0, {{\[Alpha]_, 0}, {\[Beta]_, M_}, {\[Gamma]_, 
            M_}}] := \((SMu\^2\ \((\(-1\))\)\^\(\[Alpha] + \[Beta] + \[Gamma] \
+ 1\)\ Gamma[\[Alpha] + \[Beta] + \[Gamma] - d]\ Gamma[
              d\/2 - \[Alpha]]\ \((Gamma[\[Alpha] + \[Gamma] - 
                    d\/2]\ Gamma[\[Alpha] + \[Beta] - 
                    d\/2])\))\)/\((\((M\^2)\)\^\(\[Alpha] + \[Beta] + \
\[Gamma] - 4\)\ \((Gamma[\[Beta]]\ Gamma[\[Gamma]])\)\ Gamma[d\/2]\ Gamma[
              2\ \[Alpha] + \[Beta] + \[Gamma] - d])\)\)], "Input"],

Cell["(2.65)", "Text"],

Cell[BoxData[
    \(TAIS[d_, 
        0, {{1, M_}}] := \ \(-I\)\ \ M\^2\ \ SMu\ Gamma[\((4 - d)\)/2 - 
            1]\)], "Input"],

Cell[BoxData[
    \(\(TBIS[d_, 0, {{\[Alpha]_, 0}, {\[Beta]_, 0}}] := 0;\)\)], "Input"],

Cell[BoxData[
    \(TBIS[d_, 
        Power[M_, \ 
          2], {{\[Alpha]_, 0}, {\[Beta]_, 0}}] := \(\(\(\(I\)\(\ \)\) 
        SMu\ *\((\(\((\(-1\))\)\^\(\[Alpha] + \[Beta]\)\/\((\(-\ \
M\^2\))\)\^\(\[Alpha] + \[Beta] - 2\)\) 
            Exp[\(-I\)\ Pi\ \((d - 4)\)/
                  2]\ \(Gamma[\[Alpha] + \[Beta] - d/2]\/\(Gamma[\[Alpha]] 
                  Gamma[\[Beta]]\)\) \(Gamma[d/2 - \[Alpha]] Gamma[d/2 - \
\[Beta]]\)\/Gamma[d - \[Alpha] - \[Beta]])\)\)\(\n\)
      \)\)], "Input"],

Cell[BoxData[
    \(TJIS[d_Symbol, M_\^2, {{1, M_}, {1, M_}, {1, M_}}] := 
      M\^2\ SMu\^2\ \((\(-\(6\/\((\(-4\) + d)\)\^2\)\) + 
            17\/\(2\ \((\(-4\) + d)\)\) + 
            1\/8\ \((\(-59\) - 
                  2\ \[Pi]\^2)\) + \((\(-4\) + d)\)\^3\ TJI111e + \(1\/1920\) \
\((\((\(-4\) + d)\)\^2\ \((16755 - 4750\ \[Pi]\^2 - 14\ \[Pi]\^4 + 
                      3840\ \[Pi]\^2\ Log[2] - 12080\ Zeta[3])\))\) + 
            1\/96\ \((\(-4\) + d)\)\ \((195 + 98\ \[Pi]\^2 - 
                  48\ Zeta[3])\))\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TComment", "Subsection",
  CellTags->"T1.7.3.1"],

Cell[BoxData[
    \(\($CommentNotebook = True;\)\)], "Input"],

Cell[BoxData[
    \(TComment[s_String, b_] := 
      If[If[\(\(\[InvisibleSpace]\)\(! \((ValueQ[$TarcerRecursed])\)\)\), \
$TarcerRecursed = {}]; \(\(\[InvisibleSpace]\)\(! \((MemberQ[$TarcerRecursed, \
{s, b}])\)\)\), AppendTo[$TarcerRecursed, {s, b}]; 
          If[$Notebooks && $CommentNotebook === True, 
            If[$commentnb === False, $commentnb = True; $cnb = 
                NotebookCreate[
                  StyleDefinitions \[Rule] "\<NaturalColor.nb\>", 
                  Magnification \[Rule] 1.5]; 
              SetOptions[$cnb, 
                WindowMargins \[Rule] {{0, Automatic}, {Automatic, 0}}]; 
              SetOptions[$cnb, WindowSize \[Rule] {500, 300}]; 
              NotebookWrite[$cnb, 
                Cell[BoxData[
                    ToBoxes[b /. TFIC \[Rule] TFI, 
                      StandardForm]], "\<Input\>", 
                  CellDingbat \[Rule] s <> "\< \>"]], 
              NotebookWrite[$cnb, 
                Cell[BoxData[
                    ToBoxes[b /. TFIC \[Rule] TFI, 
                      StandardForm]], "\<Input\>", 
                  CellDingbat \[Rule] s <> "\< \>"]]], 
            Print[s, 
              b /. {TFIC \[RuleDelayed] TFI, TVIC \[RuleDelayed] TVI, 
                  TJIC \[RuleDelayed] TJI, TBIC \[RuleDelayed] TBI, 
                  TAIC \[RuleDelayed] TAI}]]] /; $Comment === True\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["$TTable", "Subsection",
  CellTags->"$TTable"],

Cell[BoxData[
    \(\($TTable = {};\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TarcerRecurse", "Subsection",
  CellTags->"T1.7.4.1"],

Cell[BoxData[
    \(\(FEPrint[a__String] := 
        Print[a]\  /; \ $Notebooks === False;\)\)], "Input"],

Cell[BoxData[
    \(\(FEPrint[a__String] := 
        If[Head[$cnb] === NotebookObject, \n\t\tNotebookWrite[$cnb, 
              Cell[StringJoin @@ {a}, "\<SmallText\>"]]; \n\t
            SelectionMove[$cnb, After, Cell]] /; $Notebooks === 
            True;\)\)], "Input"],

Cell[BoxData[
    \(\(Options[TarcerRecurse] = {Factor \[Rule] Factor, 
          TimeConstraint -> Infinity, Table :> $TTable, Together -> Together, 
          Replace -> {}};\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(TarcerRecurse[z_, opts___]\), ":=", 
        RowBox[{"Catch", "[", 
          RowBox[{
            StyleBox["Block",
              FontSize->16,
              FontWeight->"Bold",
              FontColor->RGBColor[1, 0.2, 0.2]], "[", 
            
            RowBox[{\({basisdone, factorfun, fertig, dummm1, dummm2, getvars, 
                te, time, cutoff, tog, ttable, facfun, nexp, oldexpr, rec, 
                special, sti, tl, tcheck, tjrd, tvrd, together, 
                vars, $cc = 0, $cv}\), ",", "\n", "\t\t\t", 
              
              RowBox[{\(time\  = \ AbsoluteTime[]\), ";", "\n", 
                "\t\t\t", \(ttable = \(Table /. {opts}\) /. 
                    Options[TarcerRecurse]\), ";", "\n", 
                "\t\t\t", \(If[\(! MatchQ[ttable, {__RuleDelayed}]\), 
                  ttable = {}]\), ";", "\n", 
                "\t\t\t", \(special = \(Replace /. {opts}\) /. 
                    Options[TarcerRecurse]\), ";", "\n", 
                "\t\t\t", \(cutoff = \(TimeConstraint /. {opts}\) /. 
                    Options[TarcerRecurse]\), ";", "\n", 
                "\t\t\t", \(together = \(Together /. {opts}\) /. 
                    Options[TarcerRecurse]\), 
                ";", \(factorfun = \(Factor /. {opts}\) /. 
                    Options[TarcerRecurse]\), ";", \($commentnb = False\), 
                ";", \(tog = \((\((If[#1 > 1001, 
                              If[$Comment, 
                                FEPrint["\<coefficient # \>" <> 
                                    If[ValueQ[$cv], ToString[$cc], "\<\>"] <> 
                                    If[ValueQ[$cv], "\< (\>" <> 
                                        ToString[$cv] <> "\<)\>", "\<\>"] <> \
"\< simplified, \>", ToString[#1]]]]; #2)\) &)\)[LeafCount[#1], \($cc++\); 
                      together[#1]] &\), 
                ";", \(If[\(\(\[InvisibleSpace]\)\(! \
\((ValueQ[$TarcerRecursed])\)\)\), $TarcerRecursed = {}]\), 
                ";", \($TarcerRecursed = {}\), ";", 
                RowBox[{"If", "[", "\[InvisibleSpace]", 
                  
                  RowBox[{\(! \((MemberQ[$ContextPath, \
"\<HighEnergyPhysics`fcloops`ToTFi`\>"])\)\), ",", \(t0 = z\), ",", 
                    RowBox[{"t0", "=", 
                      
                      RowBox[{\(HighEnergyPhysics`fcloops`ToTFi`ToTFi[z]\), "/.",
                         
                        RowBox[{"{", 
                          RowBox[{
                            RowBox[{
                            "HighEnergyPhysics`fcloops`TFi`TFi", 
                              "\[RuleDelayed]", 
                              StyleBox["TFI",
                                FontColor->RGBColor[1, 0.6, 0]]}], 
                            ",", \(HighEnergyPhysics`fcloops`ToTFi`ToTFi \
\[RuleDelayed] Identity\)}], "}"}]}]}]}], "]"}], ";", "\n", 
                "\t\t\t", \(If[ttable =!= {}, t0 = t0 /. ttable]\), ";", "\n",
                 "\t\t\t", 
                RowBox[{"getvars", "=", 
                  RowBox[{
                    RowBox[{"Select", "[", 
                      RowBox[{\(Variables[#1]\), ",", 
                        RowBox[{
                          RowBox[{"MatchQ", "[", 
                            RowBox[{"#1", ",", 
                              RowBox[{
                                RowBox[{
                                  StyleBox["TFI",
                                    FontColor->RGBColor[1, 0.6, 0]], "[", 
                                  "__", "]"}], "|", 
                                RowBox[{
                                  StyleBox["TVI",
                                    FontColor->RGBColor[0.2, 0.4, 0.8]], "[", 
                                  "__", "]"}], "|", \(TJI[__]\), 
                                "|", \(TBI[__]\), "|", \(TAI[__]\)}]}], "]"}],
                           "&"}]}], "]"}], "&"}]}], ";", "\n", 
                "\t\t\t", \(If[\(! FreeQ[t0, TFI]\), 
                  t0 = Collect[t0 = TFIRecurse[t0] /. ttable, getvars[t0], 
                      tog]]\), ";", "\n", 
                "\t\t\t", \(If[\(! FreeQ[t0, 
                      TVI[_Plus, __]]\), \n\t\t\ttvrd = 
                    Select[DownValues[
                          TVR], \(! FreeQ[#, TVI[_ - 2, __]]\) &] /. 
                      TVR -> TVI; \n\t\t\t\tt0 = 
                    Collect[
                      t0 = \(\(\(t0 /. tvrd\) /. tvrd\) /. tvrd\) /. tvrd, 
                      getvars[t0], 
                      tog]; \n\t\t\t\tIf[\(! FreeQ[t0, TVI[_Plus, __]]\), \t
                    t0 = Collect[t0 = t0 //. tvrd, getvars[t0], tog]]]\), ";",
                 "\n", "\t\t\t\t", "\n", 
                "\t\t\t", \(tjrd = 
                  Select[DownValues[TJR], \(! FreeQ[#, TJI[_ - 2, __]]\) &] /. 
                    TJR -> TJI\), ";", "\n", "\t\t\t", "\n", 
                "\t\t\t", \(If[\(! FreeQ[t0, 
                      TJI[_Plus, __]]\), \n\t\t\ttjrd = 
                    Select[DownValues[
                          TJR], \(! FreeQ[#, TJI[_ - 2, __]]\) &] /. 
                      TJR -> TJI; \n\t\t\t\tt0 = 
                    Collect[
                      t0 = \(\(\(t0 /. tjrd\) /. tjrd\) /. tjrd\) /. tjrd, 
                      getvars[t0], 
                      tog]; \n\t\t\t\tIf[\(! FreeQ[t0, TJI[_Plus, __]]\), \t
                    t0 = Collect[t0 = t0 //. tjrd, getvars[t0], tog]]]\), ";",
                 "\n", "\t\t\t", "\n", 
                "\t\t\t", \(rec[expr_, {ti_, tr_}] := \((sti = ToString[ti]; 
                    If[FreeQ[expr, ti], expr, nexp = expr; 
                      If[$Comment, \((If[#1 === 1, 
                                FEPrint[
                                  sti <> "\< level, there is 1 \>" <> sti], 
                                FEPrint[sti <> "\< level, there are \>", 
                                  ToString[#1], "\< \>" <> 
                                    sti <> "\<'s \>"]] &)\)[
                          Count[nexp, 
                            ti[__], \(-1\)]]]; \n\t\t\t\t\n\t\t\t\t\t\tnexp = \
\(nexp /. ti \[Rule] tr\) /. 
                          tr \[Rule] ti; \n\t\t\t\t\t\t\tIf[\(! FreeQ[nexp, 
                            TJI[_Plus, __]]\), 
                        nexp = 
                          nexp //. tjrd]; \n\t\t\t\t\t\t\n\t\t\t\t\t\ttvars = 
                        getvars[nexp]; $cc = 0; $cv = Length[tvars]; 
                      nexp = Collect[nexp, tvars, 
                          tog]; \[IndentingNewLine]\n\t\t\t\t\t\tIf[
                        cutoff =!= Infinity, 
                        If[AbsoluteTime[] - time > cutoff, 
                          Throw[$Failed]]]; \n\t\t\t\t\t\tnexp])\)\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(basisdone = 0\), ";", 
                RowBox[{"tl", "=", 
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox["TFI",
                            FontColor->RGBColor[1, 0.6, 0]], ",", 
                          StyleBox["TFR",
                            FontColor->RGBColor[0, 0.6, 0]]}], "}"}], ",", 
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox["TVI",
                            FontColor->RGBColor[0.2, 0.4, 0.8]], ",", 
                          StyleBox["TVR",
                            FontColor->RGBColor[0.2, 0.8, 1]]}], "}"}], 
                      ",", \({TJI, TJR}\), ",", \({TBI, TBR}\), 
                      ",", \({TAI, TAR}\)}], "}"}]}], 
                ";", \(Do[t0 = \ FixedPoint[rec[#, tl[\([i]\)]] &, t0, 100]; 
                  If[Head[t0] === Plus, 
                    fertig = 
                      Select[t0, \(\(\[InvisibleSpace]\)\(! \((FreeQ[#1, 
                              tl\[LeftDoubleBracket]i, 
                                1\[RightDoubleBracket]])\)\)\)]; 
                    basisdone = basisdone + fertig; t0 = t0 - fertig], {i, 
                    Length[tl]}]\), ";", \(t0 = t0 + basisdone\), 
                ";", \($cv =  . \), 
                ";", \(t0 = 
                  Collect[
                    t0, {TAI[__], TAI[a1__]\ TAI[a2__], TAI[__], TBI[__], 
                      TJI[__], TVI[__], TFI[__]}, factorfun]\), 
                ";", \(If[$Comment, 
                  FEPrint["\<the result has \>", 
                    ToString[
                      Length[t0 + dummm1 + dummm2] - 2], "\< terms\>"]]\), 
                ";", \(If[$Notebooks, 
                  SetSelectedNotebook[EvaluationNotebook[]]]\), ";", "t0"}]}],
             "]"}], "]"}]}], ";"}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TarcerExpand", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.8.1"],

Cell[BoxData[
    \(\(Options[TarcerExpand] = {\n\t\tTarcerReduce :> $BasisIntegrals, \n\t
          TarcerRecurse -> False, Zeta -> True, 
          Replace \[Rule] {Prefactor1 \[Rule] Identity, 
              EulerGamma\  \[Rule] 0}};\)\)], "Input"],

Cell[BoxData[
    \(\(TarcerExpand[expr_, d_Symbol -> fe_ /; Length[Variables[fe]] === 1, 
          ru___Rule] := TarcerExpand[expr, d\  -> fe, 0, ru];\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(TarcerExpand[expr_, d_Symbol \[Rule] fe_, 
        order_Integer?NonNegative, opts___Rule]\), ":=", 
      RowBox[{
        RowBox[{
          StyleBox["Block",
            FontSize->16,
            FontWeight->"Bold",
            FontColor->RGBColor[1, 0.2, 0.2]], "[", 
          
          RowBox[{\({t1, t2, t3, t4, numfa, z2rule, restfa, ta0, 
              tarcNumericalFactor, tarcFactor1, 
              eeps (*\(,\)\(extracoll\)*) }\), ",", "\[IndentingNewLine]", 
            
            RowBox[{\(eeps = \(Variables[fe]\)[\([1]\)]\), ";", 
              "\[IndentingNewLine]", \(tarcNumericalFactor[x_] := 
                If[NumberQ[x], x, 
                  If[Head[x] === Times, If[NumberQ[First[x]], First[x], 1], 
                    1]]\), ";", 
              "\n", \(tarcFactor1[x_] := 
                Block[{factor1t1, factor1t2, factor1t3, mt, mi, m1, mp1, 
                    nx = x, iIii}, 
                  mt = \(\(\(\(#1 /. \[InvisibleSpace]Plus \[Rule] 
                                  mi\) /. \[InvisibleSpace]mi \[Rule] 
                                Plus\) /. \[InvisibleSpace]m1 \[Rule] \
\(-1\)\) /. \[InvisibleSpace]mp1 \[Rule] \((\(-\((\(+##1\))\)\) &)\)\) \
/. \[InvisibleSpace]iIii \[Rule] \[ImaginaryI] &; 
                  mi[y_, z__] := 
                    m1\ mp1[y, 
                          z] /; \((If[Head[#1] === Complex, False, 
                              If[#1 < 0, True, False]] &)\)[
                        tarcNumericalFactor[y]]; 
                  nx = x /. \[InvisibleSpace]Complex[0, b_] \[Rule] b\ iIii; 
                  If[Head[nx] =!= Plus, 
                    mt[nx /. \[InvisibleSpace]Plus \[Rule] \
\((Factor1[\(+##1\)] &)\)], 
                    factor1t1 = 
                      List @@ \(\((#1 /. \[InvisibleSpace]Plus \[Rule] 
                                  factor1t3 &)\) /@ nx\); 
                    factor1t2 = 
                      PolynomialGCD @@ 
                          factor1t1 /. \[InvisibleSpace]factor1t3 \[Rule] 
                          Plus; mt[
                      factor1t2\ Plus @@ \(\((\(#1 \
/. \[InvisibleSpace]factor1t3 \[Rule] Plus\)\/factor1t2 &)\) /@ 
                            factor1t1\)]]]\), ";", 
              RowBox[{"Catch", "[", 
                
                RowBox[{\(e = eeps\), 
                  ";", \({ints, recurse, 
                      zeta2replace} = {TarcerReduce, TarcerRecurse, Zeta} /. 
                      Flatten[{opts, Options[TarcerExpand]}]\), 
                  ";", \(If[
                    zeta2replace =!= True && 
                      MemberQ[$ContextPath, \
"\<HighEnergyPhysics`general`Zeta2`\>"], z2rule = {}, 
                    z2rule = \[Pi]\^2 \[RuleDelayed] 
                        
                        6\ ToExpression["\<HighEnergyPhysics`general`Zeta2`\
Zeta2\>"]]\), ";", \(ints = Flatten[ints]\), 
                  ";", \(If[recurse =!= True, ta0 = expr, 
                    ta0 = TarcerRecurse[expr]]\), 
                  ";", \(t1 = \(ta0 /. 
                        ints\) /. {SEpsilon[de_] \[RuleDelayed] 
                          SEpsilon[
                            ToString[d]], \[IndentingNewLine]Prefactor1[
                            de_] \[RuleDelayed] 
                          Prefactor1[\ 
                            ToString[de, InputForm]]\[IndentingNewLine]}\), 
                  ";", \(vars = Select[Variables[t1], Length[#1] > 0 &]\), 
                  ";", 
                  RowBox[{"If", "[", 
                    RowBox[{
                      RowBox[{"\[InvisibleSpace]", "!", 
                        RowBox[{"(", 
                          RowBox[{"FreeQ", "[", 
                            RowBox[{"vars", ",", 
                              RowBox[{
                                StyleBox["TFI",
                                  FontColor->RGBColor[1, 0.6, 0]], "|", 
                                StyleBox["TVI",
                                  FontColor->RGBColor[0.2, 0.4, 0.8]], "|", 
                                "TJI", "|", "TKI", "|", "TBI", "|", "TAI"}]}],
                             "]"}], ")"}]}], ",", 
                      
                      RowBox[{\(Print["\<Returning the list of remaining \
integrals.\>"]\), ";", 
                        RowBox[{"Throw", "[", 
                          RowBox[{"Select", "[", 
                            RowBox[{"vars", ",", 
                              RowBox[{
                                RowBox[{"\[InvisibleSpace]", "!", 
                                  RowBox[{"(", 
                                    RowBox[{"FreeQ", "[", 
                                      RowBox[{"#1", ",", 
                                        RowBox[{
                                        StyleBox["TFI",
                                        FontColor->RGBColor[1, 0.6, 0]], "|", 
                                        
                                        StyleBox["TVI",
                                        FontColor->RGBColor[0.2, 0.4, 0.8]], 
                                        "|", "TJI", "|", "TKI", "|", "TBI", 
                                        "|", "TAI"}]}], "]"}], ")"}]}], 
                                "&"}]}], "]"}], "]"}]}]}], "]"}], 
                  ";", \(t1 = t1 /. d \[Rule] fe\), 
                  ";", \(polygafu[2, 1] = \(-2\)\ Zeta[3]\), 
                  ";", \(polygafu[2, 2] = 2 - 2\ Zeta[3]\), 
                  ";", \(polygafu[x_, y_] := \(polygafu[x, y] = 
                      FunctionExpand[PolyGamma[x, y]]\)\), 
                  ";", \(t2 = \(Normal[t1 + O[e]\^\(order + 1\)] /. 
                        PolyGamma \[Rule] 
                          polygafu\) /. \[IndentingNewLine]\((\(Replace /. \
{opts}\) /. Options[TarcerExpand])\)\), 
                  ";", \(t3 = Collect[t2, e, \((Expand[#1] /. z2rule)\) &]\), 
                  ";", "\[IndentingNewLine]", \(t3 = 
                    t2 /. ToString[d] \[RuleDelayed] \((fe)\)\), ";", 
                  "\[IndentingNewLine]", \( (*\(Global`T3 = t3;\)*) \), 
                  "\[IndentingNewLine]", \(t4 = \(\(\(\(tarcFactor1[
                                Expand[
                                  t3]] //. \((pre : \((Prefactor1 | 
                                        SEpsilon)\)[a_]\ Prefactor1[
                                        b_])\) \[RuleDelayed] 
                                Prefactor1[a\ b]\) /. 
                            Prefactor1[1] \[RuleDelayed] 1\) /. 
                          Prefactor1[xy_] \[RuleDelayed] 
                            Prefactor1[
                              xy /. st_String \[RuleDelayed] 
                                  ToExpression[st]]\) /. \((Prefactor1[
                                m_^e\ xx_] m_^any_\ )\) \[RuleDelayed] 
                          Prefactor1[m^\((e + any)\) xx]\) /. z2rule\), ";", 
                  "\[IndentingNewLine]", \( (*\(Global`t4 = t4;\)*) \), 
                  "\[IndentingNewLine]", \(\(\(If[
                          Head[t4] === Times, \[IndentingNewLine]numfa = 
                            tarcNumericalFactor[
                              t4]; \[IndentingNewLine]restfa\  = \ 
                            Select[t4, 
                              FreeQ[#, 
                                  eeps | Log | 
                                    Zeta] &]; \[IndentingNewLine] (*Global`RR \
= restfa; \[IndentingNewLine]Global`NN = 
                              numfa;*) \[IndentingNewLine]extracoll[z_, e] := 
                            Block[{}, 
                              If[Head[z] === Plus, \(extracoll[#, e] &\) /@ 
                                  z, z /. 
                                  xy_Plus \[RuleDelayed] 
                                    If[Length[Variables[xy]] === 0, xy, 
                                      Collect[xy, 
                                        Complement[
                                        Variables[
                                        xy], {e}]]]]\ ]; \
\[IndentingNewLine]\((Select[t4, \(! FreeQ[#, 
                                        Prefactor1]\) &] \((restfa\/numfa)\))\
\) . extracoll[\ 
                              Collect[
                                Expand[\(numfa\ \ Select[\ t4, FreeQ[#, \
Prefactor1] &]\)\/\(\(restfa\)\(\ \)\)], e], e], t4] /. 
                        s_String \[RuleDelayed] ToExpression[s]\) /. 
                      d \[Rule] fe\) /. \((\(Replace /. {opts}\) /. 
                        Options[TarcerExpand])\)\)}], "\[IndentingNewLine]", 
                "]"}]}]}], "]"}], 
        "/;", \(Length[Variables[fe]] === 1\)}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Construct T's", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.9.1"],

Cell[CellGroupData[{

Cell["remember", "Subsection",
  CellTags->"T1.9.1.1"],

Cell["The function remember is not used by default.", "Text"],

Cell[BoxData[
    \(\(tfch = {TFR :> Hold[TFR], TVR :> Hold[TVR], TJR :> Hold[TJR], 
          TBR :> Hold[TBR], TAR :> Hold[TAR], 
          TComment :> Hold[TComment]};\)\)], "Input"],

Cell[BoxData[
    \(\(rtfch = Map[Reverse, tfch];\)\)], "Input"],

Cell[BoxData[
    \(\(SetAttributes[condrest, HoldRest];\)\)], "Input"],

Cell[BoxData[
    \(\(Clear[remember];\)\)], "Input"],

Cell[BoxData[
    \(\(remember[zi_HoldForm] := 
        Block[{z = zi /. tfch}, 
          If[\(\(\[InvisibleSpace]\)\(! \((FreeQ[z, 
                  Condition])\)\)\), \(\(\(\(Hold[
                        HoldForm]\)[\(Hold[SetDelayed]\)[
                        z\[LeftDoubleBracket]1, 1\[RightDoubleBracket], 
                        ReplacePart[
                          z\[LeftDoubleBracket]1, 2\[RightDoubleBracket], 
                          Prepend[
                            Extract[z, {1, 2, 1}, 
                              Hold], \(\(\(z\[LeftDoubleBracket]1, 
                                      1\[RightDoubleBracket] /. 
                                    PatternTest \[Rule] pt\) /. 
                                  pt[a_, b_] \[RuleDelayed] a\) /. 
                                Pattern \[Rule] pat\) /. 
                              pat[a_, b_] \[RuleDelayed] a], 1]]] /. 
                    Hold[HoldForm] \[Rule] HoldForm\) /. rtfch\) /. 
                Hold[SetDelayed] \[Rule] SetDelayed\) /. 
              Hold \[Rule] 
                Set, \(\(\(\(Hold[HoldForm]\)[\(Hold[SetDelayed]\)[
                        z\[LeftDoubleBracket]1, 1\[RightDoubleBracket], 
                        Prepend[
                          Extract[z, {1, 2}, 
                            Hold], \(\(\(z\[LeftDoubleBracket]1, 
                                    1\[RightDoubleBracket] /. 
                                  PatternTest \[Rule] pt\) /. 
                                pt[a_, b_] \[RuleDelayed] a\) /. 
                              Pattern \[Rule] pat\) /. 
                            pat[a_, b_] \[RuleDelayed] a]]] /. 
                    Hold[HoldForm] \[Rule] HoldForm\) /. rtfch\) /. 
                Hold[SetDelayed] \[Rule] SetDelayed\) /. 
              Hold \[Rule] Set]];\)\)], "Input"],

Cell[BoxData[
    \($TarasovTdeltaplimit\)], "Input"],

Cell[BoxData[
    \(\(aa2\  = \ 
        Array[f\_# &, \ 
          10000 + \(($TarasovTdeltaplimit + 1)\)\ 1000];\)\)], "Input"],

Cell[BoxData[
    \(\(bb12 = Select[aa2, Head[#] =!= Subscript &];\)\)], "Input"],

Cell[BoxData[
    \(\(Clear[aa2];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Print["\<there are \>", 
      Length[bb12], "\< recursion equations for $RankLimit = \>", $RankLimit]\
\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[\("there are "\[InvisibleSpace]201\[InvisibleSpace]" \
recursion equations for $RankLimit = "\[InvisibleSpace]{2, 5}\),
        SequenceForm[ 
        "there are ", 201, " recursion equations for $RankLimit = ", {2, 5}],
        Editable->False], TraditionalForm]], "Print"]
}, Open  ]],

Cell[BoxData[
    \(\(If[Global`$Remember\  === \ True, Global`RCHECK = True; \ 
        nb\  = Map[remember, bb12], nb = bb12];\)\)], "Input"],

Cell[BoxData[
    \(\(Clear[bb12];\)\)], "Input"],

Cell[BoxData[
    \(Unset[$Post]\)], "Input"],

Cell[BoxData[
    \(\(ReleaseHold[nb];\)\)], "Input"],

Cell[BoxData[
    \(\($Comment = False;\)\)], "Input"],

Cell[BoxData[
    \(\(End[];\)\)], "Input"],

Cell[BoxData[
    \(\(EndPackage[];\)\)], "Input"],

Cell[BoxData[
    \(\(If[\(! ValueQ[HighEnergyPhysics`FeynCalc`$FeynCalcDirectory]\), 
        BeginPackage["\<HighEnergyPhysics`general`Zeta2`\>"]];\)\)], "Input"],

Cell[BoxData[
    \(\(Zeta2::usage = \n"\<Zeta2 denotes Zeta[2].\>";\)\)], "Input"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"];\)\)], "Input"],

Cell[BoxData[{
    \(\(Zeta2\  /: \ N[Zeta2]\  = \ N[Zeta[2]];\)\), "\n", 
    \(\(Zeta2 /: MakeBoxes[Zeta2, fmt_] := 
        InterpretationBox @@ {\ \ RowBox[{"\<\[Zeta]\>", "\<(\>", 
                2, "\<)\>"}], Zeta2, Editable -> False};\)\)}], "Input"],

Cell[BoxData[
    \(\(End[];\)\)], "Input"],

Cell[BoxData[
    \(\(\(\ \)\(EndPackage[];\)\)\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$BasisIntegrals", "Section",
  CellDingbat->"\[EmptySmallCircle]",
  CellTags->"T1.10.1"],

Cell["\<\
This is a (incomplete) set of basis integrals. You can add your \
favorite integrals here.\
\>", "Text"],

Cell["eta=Gamma[d/2-1]/Gamma[d-3]Gamma[3-d/2];", "Text"],

Cell[CellGroupData[{

Cell["\<\
$BasisIntegrals =
  {TAI[d_, 0, {{1, M_}}] -> 
    -I*E^(1/2*(4 - d)*EulerGamma)*M^2*
     Gamma[-1 + (4 - d)/2]*
     Prefactor1[(M^2)^(1/2*(-4 + d))*
       SEpsilon[d]], 
       
       TBI[d_, pp_, {{1, 0},{1, 0}}] -> 
   (I*E^(((4 - d)*EulerGamma)/2)*Gamma[2 - d/2]*
      Gamma[-1 + d/2]^2*
      Prefactor1[ (-pp)^((-4 + d)/2)*
        SEpsilon[d]])/Gamma[-2 + d],
        
        TJI[d_, pp_, {{1,0},{1,0},{1,0}}] ->-((pp*Gamma[3 - d]*Gamma[-1 + \
d/2]^3*
    E^((4 - d)*EulerGamma)*  Prefactor1[ 
        (-pp)^(-4 + d)*SEpsilon[d]^2])/
    (Gamma[-3 + (3*d)/2] )
),
    
          TJI[d_, M_^2, {{1,M_},{1,0},{1,0}}] ->(M^2*Gamma[3 - d]*Gamma[2 - \
d/2]*
    Gamma[-1 + d/2]^2*Gamma[-5 + 2*d]*E^((4 - d)*EulerGamma)*
    Prefactor1[
      (M^2)^(-4 + d)*SEpsilon[d]^2])/
  (Gamma[-2 + d]*Gamma[-3 + (3*d)/2]),
  
  TJI[d_Symbol, (M_)^2, 
  {{1, M_}, {1, M_}, {1, M_}}]->M^2*Prefactor1[
    (M^2)^(-4 + d)*SEpsilon[d]^2]*
  (-6/(-4 + d)^2 + 17/(2*(-4 + d)) + 
    (-59 - 2*Pi^2)/8 + 
    (-4 + d)^3*TJI111e + 
    ((-4 + d)^2*(16755 - 4750*Pi^2 - 
         14*Pi^4 + 3840*Pi^2*Log[2] - 
         12080*Zeta[3]))/1920 + 
    ((-4 + d)*(195 + 98*Pi^2 - 
         48*Zeta[3]))/96),
         
         TJI[d_, 0, {{1, M_}, {1, M_}, {1, 0}}]->(M^2*Gamma[3 - d]*Gamma[2 - \
d/2]^2*
    Gamma[-1 + d/2]*E^((4 - d)*EulerGamma)*
    Prefactor1[
      (M^2)^(-4 + d)*SEpsilon[d]^2])/
  (Gamma[4 - d]*Gamma[d/2]),
  
  TJI[d_, 0, {{1,M_},{1,0},{1,0}}] ->(M^2*Gamma[3 - d]*Gamma[2 - d/2]*
    Gamma[-1 + d/2]^2*E^((4 - d)*EulerGamma)*
    Prefactor1[
      (M^2)^(-4 + d)*SEpsilon[d]^2])/
  Gamma[d/2]
        }\
\>", "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["A",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                FormBox[\({1, M_}\),
                  "TraditionalForm"], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TAI[ 
                Pattern[ d, 
                  Blank[ ]], 0, {{1, 
                Pattern[ M, 
                  Blank[ ]]}}],
              Editable->True], "\[Rule]", 
            RowBox[{\(-\[ImaginaryI]\), " ", 
              SuperscriptBox["\[ExponentialE]", 
                RowBox[{\(1\/2\), " ", \((4 - d)\), " ", 
                  TagBox["\[DoubledGamma]",
                    (EulerGamma&)]}]], " ", \(M\^2\), 
              " ", \(\[CapitalGamma](\(4 - d\)\/2 - 1)\), " ", 
              RowBox[{"(", 
                InterpretationBox[
                  RowBox[{\(\((M\^2)\)\^\(\(d - 4\)\/2\)\), " ", 
                    InterpretationBox[
                      StyleBox[\(S\_d\),
                        FontWeight->"Bold"],
                      SEpsilon[ d],
                      Editable->False]}],
                  Prefactor1[ 
                    Times[ 
                      Power[ 
                        Power[ M, 2], 
                        Times[ 
                          Rational[ 1, 2], 
                          Plus[ -4, d]]], 
                      SEpsilon[ d]]],
                  Editable->False], ")"}]}]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TBI[ 
                Pattern[ d, 
                  Blank[ ]], 
                Pattern[ pp, 
                  Blank[ ]], {{1, 0}, {1, 0}}],
              Editable->True], "\[Rule]", 
            FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox["\[ExponentialE]", 
                  RowBox[{\(1\/2\), " ", \((4 - d)\), " ", 
                    TagBox["\[DoubledGamma]",
                      (EulerGamma&)]}]], " ", \(\[CapitalGamma](2 - d\/2)\), 
                " ", \(\(\[CapitalGamma](d\/2 - 1)\)\^2\), " ", 
                RowBox[{"(", 
                  InterpretationBox[
                    RowBox[{\(\((\(-pp\))\)\^\(\(d - 4\)\/2\)\), " ", 
                      InterpretationBox[
                        StyleBox[\(S\_d\),
                          FontWeight->"Bold"],
                        SEpsilon[ d],
                        Editable->False]}],
                    Prefactor1[ 
                      Times[ 
                        Power[ 
                          Times[ -1, pp], 
                          Times[ 
                            Rational[ 1, 2], 
                            Plus[ -4, d]]], 
                        SEpsilon[ d]]],
                    Editable->False], ")"}]}], \(\[CapitalGamma](d - 2)\)]}], 
          ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ ]], 
                Pattern[ pp, 
                  Blank[ ]], {{1, 0}, {1, 0}, {1, 0}}],
              Editable->True], "\[Rule]", 
            RowBox[{"-", 
              FractionBox[
                RowBox[{
                  SuperscriptBox["\[ExponentialE]", 
                    RowBox[{\((4 - d)\), " ", 
                      TagBox["\[DoubledGamma]",
                        (EulerGamma&)]}]], " ", "pp", 
                  " ", \(\[CapitalGamma](3 - d)\), 
                  " ", \(\(\[CapitalGamma](d\/2 - 1)\)\^3\), " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{\(\((\(-pp\))\)\^\(d - 4\)\), " ", 
                        InterpretationBox[
                          StyleBox[\(S\_d\%2\),
                            FontWeight->"Bold"],
                          SEpsilon[ d],
                          Editable->False]}],
                      Prefactor1[ 
                        Times[ 
                          Power[ 
                            Times[ -1, pp], 
                            Plus[ -4, d]], 
                          Power[ 
                            SEpsilon[ d], 2]]],
                      Editable->False], 
                    ")"}]}], \(\[CapitalGamma](\(3\ d\)\/2 - 3)\)]}]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ ]], 
                Power[ 
                  Pattern[ M, 
                    Blank[ ]], 2], {{1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 0}, {1, 0}}],
              Editable->True], "\[Rule]", 
            FractionBox[
              RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                  RowBox[{\((4 - d)\), " ", 
                    TagBox["\[DoubledGamma]",
                      (EulerGamma&)]}]], " ", \(M\^2\), 
                " ", \(\[CapitalGamma](3 - d)\), 
                " ", \(\[CapitalGamma](2 - d\/2)\), 
                " ", \(\(\[CapitalGamma](d\/2 - 1)\)\^2\), 
                " ", \(\[CapitalGamma](2\ d - 5)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[
                    RowBox[{\(\((M\^2)\)\^\(d - 4\)\), " ", 
                      InterpretationBox[
                        StyleBox[\(S\_d\%2\),
                          FontWeight->"Bold"],
                        SEpsilon[ d],
                        Editable->False]}],
                    Prefactor1[ 
                      Times[ 
                        Power[ 
                          Power[ M, 2], 
                          Plus[ -4, d]], 
                        Power[ 
                          SEpsilon[ d], 2]]],
                    Editable->False], ")"}]}], \(\(\[CapitalGamma](
                  d - 2)\)\ \(\[CapitalGamma](\(3\ d\)\/2 - 3)\)\)]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, M_}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_Symbol",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ Symbol]], 
                Power[ 
                  Pattern[ M, 
                    Blank[ ]], 2], {{1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 
                Pattern[ M, 
                  Blank[ ]]}}],
              Editable->True], "\[Rule]", 
            RowBox[{\(M\^2\), " ", 
              RowBox[{"(", 
                InterpretationBox[
                  RowBox[{\(\((M\^2)\)\^\(d - 4\)\), " ", 
                    InterpretationBox[
                      StyleBox[\(S\_d\%2\),
                        FontWeight->"Bold"],
                      SEpsilon[ d],
                      Editable->False]}],
                  Prefactor1[ 
                    Times[ 
                      Power[ 
                        Power[ M, 2], 
                        Plus[ -4, d]], 
                      Power[ 
                        SEpsilon[ d], 2]]],
                  Editable->False], ")"}], " ", 
              RowBox[{"(", 
                RowBox[{\(TJI111e\ \((d - 4)\)\^3\), "+", 
                  FractionBox[
                    RowBox[{
                      RowBox[{"(", 
                        RowBox[{
                        "16755", "-", \(4750\ \[Pi]\^2\), 
                          "-", \(14\ \[Pi]\^4\), 
                          "+", \(3840\ \[Pi]\^2\ \(log(2)\)\), "-", 
                          RowBox[{"12080", " ", 
                            TagBox[
                              RowBox[{"\[Zeta]", "(", 
                                TagBox["3",
                                  (Editable -> True)], ")"}],
                              InterpretTemplate[ 
                                Function[ BoxForm`e$, 
                                  Zeta[ BoxForm`e$]]]]}]}], ")"}], 
                      " ", \(\((d - 4)\)\^2\)}], "1920"], "+", 
                  RowBox[{\(1\/96\), " ", 
                    RowBox[{"(", 
                      RowBox[{"195", "+", \(98\ \[Pi]\^2\), "-", 
                        RowBox[{"48", " ", 
                          TagBox[
                            RowBox[{"\[Zeta]", "(", 
                              TagBox["3",
                                (Editable -> True)], ")"}],
                            InterpretTemplate[ 
                              Function[ BoxForm`e$, 
                                Zeta[ BoxForm`e$]]]]}]}], ")"}], 
                    " ", \((d - 4)\)}], 
                  "+", \(1\/8\ \((\(-59\) - 2\ \[Pi]\^2)\)\), 
                  "+", \(17\/\(2\ \((d - 4)\)\)\), 
                  "-", \(6\/\((d - 4)\)\^2\)}], ")"}]}]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ ]], 0, {{1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 0}}],
              Editable->True], "\[Rule]", 
            FractionBox[
              RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                  RowBox[{\((4 - d)\), " ", 
                    TagBox["\[DoubledGamma]",
                      (EulerGamma&)]}]], " ", \(M\^2\), 
                " ", \(\[CapitalGamma](3 - d)\), 
                " ", \(\(\[CapitalGamma](2 - d\/2)\)\^2\), 
                " ", \(\[CapitalGamma](d\/2 - 1)\), " ", 
                RowBox[{"(", 
                  InterpretationBox[
                    RowBox[{\(\((M\^2)\)\^\(d - 4\)\), " ", 
                      InterpretationBox[
                        StyleBox[\(S\_d\%2\),
                          FontWeight->"Bold"],
                        SEpsilon[ d],
                        Editable->False]}],
                    Prefactor1[ 
                      Times[ 
                        Power[ 
                          Power[ M, 2], 
                          Plus[ -4, d]], 
                        Power[ 
                          SEpsilon[ d], 2]]],
                    Editable->False], ")"}]}], \(\(\[CapitalGamma](
                  4 - d)\)\ \(\[CapitalGamma](d\/2)\)\)]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ ]], 0, {{1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 0}, {1, 0}}],
              Editable->True], "\[Rule]", 
            FractionBox[
              RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                  RowBox[{\((4 - d)\), " ", 
                    TagBox["\[DoubledGamma]",
                      (EulerGamma&)]}]], " ", \(M\^2\), 
                " ", \(\[CapitalGamma](3 - d)\), 
                " ", \(\[CapitalGamma](2 - d\/2)\), 
                " ", \(\(\[CapitalGamma](d\/2 - 1)\)\^2\), " ", 
                RowBox[{"(", 
                  InterpretationBox[
                    RowBox[{\(\((M\^2)\)\^\(d - 4\)\), " ", 
                      InterpretationBox[
                        StyleBox[\(S\_d\%2\),
                          FontWeight->"Bold"],
                        SEpsilon[ d],
                        Editable->False]}],
                    Prefactor1[ 
                      Times[ 
                        Power[ 
                          Power[ M, 2], 
                          Plus[ -4, d]], 
                        Power[ 
                          SEpsilon[ d], 2]]],
                    Editable->False], ")"}]}], \(\[CapitalGamma](d\/2)\)]}]}],
         "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell["\<\
$BasisIntegrals = 
  {TAI[d_, 0, {{1, M_}}] :> 
    -I*E^(1/2*(4 - d)*EulerGamma)*M^2*
     Gamma[-1 + (4 - d)/2]*
     Prefactor1[(M^2)^(1/2*(-4 + d))*
       SEpsilon[d]], 
       
       TBI[d_, pp_, {{1, 0},{1, 0}}] :> 
   (I*E^(((4 - d)*EulerGamma)/2 - 
         I/2*(-4 + d)*Pi)*Gamma[2 - d/2]*
      Gamma[-1 + d/2]^2*
      Prefactor1[(pp)^((-4 + d)/2)*
        SEpsilon[d]])/Gamma[-2 + d],
        
        TJI[d_, pp_, {{1,0},{1,0},{1,0}}] :>-((pp*Gamma[3 - d]*Gamma[-1 + \
d/2]^3*
    E^((4 - d)*EulerGamma)*  Prefactor1[
        (pp)^(-4 + d)*SEpsilon[d]^2])/
    (E^(I*(-4 + d)*Pi)*Gamma[-3 + (3*d)/2])
),
    
          TJI[d_, M_^2, {{1,M_},{1,0},{1,0}}] :>(M^2*Gamma[3 - d]*Gamma[2 - \
d/2]*
    Gamma[-1 + d/2]^2*Gamma[-5 + 2*d]*E^((4 - d)*EulerGamma)*
    Prefactor1[
      (M^2)^(-4 + d)*SEpsilon[d]^2])/
  (Gamma[-2 + d]*Gamma[-3 + (3*d)/2]),
  
  TJI[d_Symbol, (M_)^2, 
  {{1, M_}, {1, M_}, {1, M_}}]:>M^2*Prefactor1[
    (M^2)^(-4 + d)*SEpsilon[d]^2]*
  (-6/(-4 + d)^2 + 17/(2*(-4 + d)) + 
    (-59 - 2*Pi^2)/8 + 
    (-4 + d)^3*TJI111e + 
    ((-4 + d)^2*(16755 - 4750*Pi^2 - 
         14*Pi^4 + 3840*Pi^2*Log[2] - 
         12080*Zeta[3]))/1920 + 
    ((-4 + d)*(195 + 98*Pi^2 - 
         48*Zeta[3]))/96),
         
         TJI[d_, 0, {{1, M_}, {1, M_}, {1, 0}}]:>(M^2*Gamma[3 - d]*Gamma[2 - \
d/2]^2*
    Gamma[-1 + d/2]*E^((4 - d)*EulerGamma)*
    Prefactor1[
      (M^2)^(-4 + d)*SEpsilon[d]^2])/
  (Gamma[4 - d]*Gamma[d/2]),
  
  TJI[d_, 0, {{1,M_},{1,0},{1,0}}] :>(M^2*Gamma[3 - d]*Gamma[2 - d/2]*
    Gamma[-1 + d/2]^2*E^((4 - d)*EulerGamma)*
    Prefactor1[
      (M^2)^(-4 + d)*SEpsilon[d]^2])/
  Gamma[d/2]
        }\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["A",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                FormBox[\({1, M_}\),
                  "TraditionalForm"], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TAI[ 
                Pattern[ d, 
                  Blank[ ]], 0, {{1, 
                Pattern[ M, 
                  Blank[ ]]}}],
              Editable->True], "\[RuleDelayed]", 
            RowBox[{\(-\[ImaginaryI]\), " ", 
              SuperscriptBox["\[ExponentialE]", 
                RowBox[{\(1\/2\), " ", \((4 - d)\), " ", 
                  TagBox["\[DoubledGamma]",
                    Function[ {}, EulerGamma]]}]], " ", \(M\^2\), 
              " ", \(\[CapitalGamma](\(4 - d\)\/2 - 1)\), " ", 
              RowBox[{"(", 
                InterpretationBox[
                  RowBox[{\(\((M\^2)\)\^\(\(d - 4\)\/2\)\), " ", 
                    InterpretationBox[
                      StyleBox[\(S\_d\),
                        FontWeight->"Bold"],
                      SEpsilon[ d],
                      Editable->False]}],
                  Prefactor1[ 
                    Times[ 
                      Power[ 
                        Power[ M, 2], 
                        Times[ 
                          Rational[ 1, 2], 
                          Plus[ -4, d]]], 
                      SEpsilon[ d]]],
                  Editable->False], ")"}]}]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["B",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TBI[ 
                Pattern[ d, 
                  Blank[ ]], 
                Pattern[ pp, 
                  Blank[ ]], {{1, 0}, {1, 0}}],
              Editable->True], "\[RuleDelayed]", 
            FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                    RowBox[{\(1\/2\), " ", \((4 - d)\), " ", 
                      TagBox["\[DoubledGamma]",
                        Function[ {}, EulerGamma]]}], 
                    "-", \(1\/2\ \[ImaginaryI]\ \((d - 4)\)\ \[Pi]\)}]], 
                " ", \(\[CapitalGamma](2 - d\/2)\), 
                " ", \(\(\[CapitalGamma](d\/2 - 1)\)\^2\), " ", 
                RowBox[{"(", 
                  InterpretationBox[
                    RowBox[{\(pp\^\(\(d - 4\)\/2\)\), " ", 
                      InterpretationBox[
                        StyleBox[\(S\_d\),
                          FontWeight->"Bold"],
                        SEpsilon[ d],
                        Editable->False]}],
                    Prefactor1[ 
                      Times[ 
                        Power[ pp, 
                          Times[ 
                            Rational[ 1, 2], 
                            Plus[ -4, d]]], 
                        SEpsilon[ d]]],
                    Editable->False], ")"}]}], \(\[CapitalGamma](d - 2)\)]}], 
          ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ ]], 
                Pattern[ pp, 
                  Blank[ ]], {{1, 0}, {1, 0}, {1, 0}}],
              Editable->True], "\[RuleDelayed]", 
            RowBox[{"-", 
              FractionBox[
                RowBox[{
                "pp", " ", \(\[CapitalGamma](3 - d)\), 
                  " ", \(\(\[CapitalGamma](d\/2 - 1)\)\^3\), " ", 
                  SuperscriptBox["\[ExponentialE]", 
                    RowBox[{\((4 - d)\), " ", 
                      TagBox["\[DoubledGamma]",
                        Function[ {}, EulerGamma]]}]], " ", 
                  RowBox[{"(", 
                    InterpretationBox[
                      RowBox[{\(pp\^\(d - 4\)\), " ", 
                        InterpretationBox[
                          StyleBox[\(S\_d\%2\),
                            FontWeight->"Bold"],
                          SEpsilon[ d],
                          Editable->False]}],
                      Prefactor1[ 
                        Times[ 
                          Power[ pp, 
                            Plus[ -4, d]], 
                          Power[ 
                            SEpsilon[ d], 2]]],
                      Editable->False], 
                    ")"}]}], \(\[ExponentialE]\^\(\[ImaginaryI]\ \((d - 4)\)\ \
\[Pi]\)\ \(\[CapitalGamma](\(3\ d\)\/2 - 3)\)\)]}]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ ]], 
                Power[ 
                  Pattern[ M, 
                    Blank[ ]], 2], {{1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 0}, {1, 0}}],
              Editable->True], "\[RuleDelayed]", 
            FractionBox[
              
              RowBox[{\(M\^2\), " ", \(\[CapitalGamma](3 - d)\), 
                " ", \(\[CapitalGamma](2 - d\/2)\), 
                " ", \(\(\[CapitalGamma](d\/2 - 1)\)\^2\), 
                " ", \(\[CapitalGamma](2\ d - 5)\), " ", 
                SuperscriptBox["\[ExponentialE]", 
                  RowBox[{\((4 - d)\), " ", 
                    TagBox["\[DoubledGamma]",
                      Function[ {}, EulerGamma]]}]], " ", 
                RowBox[{"(", 
                  InterpretationBox[
                    RowBox[{\(\((M\^2)\)\^\(d - 4\)\), " ", 
                      InterpretationBox[
                        StyleBox[\(S\_d\%2\),
                          FontWeight->"Bold"],
                        SEpsilon[ d],
                        Editable->False]}],
                    Prefactor1[ 
                      Times[ 
                        Power[ 
                          Power[ M, 2], 
                          Plus[ -4, d]], 
                        Power[ 
                          SEpsilon[ d], 2]]],
                    Editable->False], ")"}]}], \(\(\[CapitalGamma](
                  d - 2)\)\ \(\[CapitalGamma](\(3\ d\)\/2 - 3)\)\)]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["J",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, M_}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_Symbol",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ Symbol]], 
                Power[ 
                  Pattern[ M, 
                    Blank[ ]], 2], {{1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 
                Pattern[ M, 
                  Blank[ ]]}}],
              Editable->True], "\[RuleDelayed]", 
            RowBox[{\(M\^2\), " ", 
              RowBox[{"(", 
                InterpretationBox[
                  RowBox[{\(\((M\^2)\)\^\(d - 4\)\), " ", 
                    InterpretationBox[
                      StyleBox[\(S\_d\%2\),
                        FontWeight->"Bold"],
                      SEpsilon[ d],
                      Editable->False]}],
                  Prefactor1[ 
                    Times[ 
                      Power[ 
                        Power[ M, 2], 
                        Plus[ -4, d]], 
                      Power[ 
                        SEpsilon[ d], 2]]],
                  Editable->False], ")"}], " ", 
              RowBox[{"(", 
                
                RowBox[{\(TJI111e\ \((d - 4)\)\^3\), 
                  "+", \(1\/8\ \((\(-59\) - 2\ \[Pi]\^2)\)\), "+", 
                  RowBox[{\(1\/96\), " ", \((d - 4)\), " ", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{\(-48\), " ", 
                          TagBox[
                            RowBox[{"\[Zeta]", "(", 
                              TagBox["3",
                                Zeta,
                                Editable->True], ")"}],
                            InterpretTemplate[ 
                              Function[ BoxForm`e$, 
                                Zeta[ BoxForm`e$]]]]}], "+", \(98\ \[Pi]\^2\),
                         "+", "195"}], ")"}]}], "+", 
                  FractionBox[
                    RowBox[{\(\((d - 4)\)\^2\), " ", 
                      RowBox[{"(", 
                        
                        RowBox[{\(3840\ \[Pi]\^2\ \(log(2)\)\), 
                          "-", \(14\ \[Pi]\^4\), "-", \(4750\ \[Pi]\^2\), "-",
                           
                          RowBox[{"12080", " ", 
                            TagBox[
                              RowBox[{"\[Zeta]", "(", 
                                TagBox["3",
                                  Zeta,
                                  Editable->True], ")"}],
                              InterpretTemplate[ 
                                Function[ BoxForm`e$, 
                                  Zeta[ BoxForm`e$]]]]}], "+", "16755"}], 
                        ")"}]}], "1920"], "+", \(17\/\(2\ \((d - 4)\)\)\), 
                  "-", \(6\/\((d - 4)\)\^2\)}], ")"}]}]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ ]], 0, {{1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 0}}],
              Editable->True], "\[RuleDelayed]", 
            FractionBox[
              
              RowBox[{\(M\^2\), " ", \(\[CapitalGamma](3 - d)\), 
                " ", \(\(\[CapitalGamma](2 - d\/2)\)\^2\), 
                " ", \(\[CapitalGamma](d\/2 - 1)\), " ", 
                SuperscriptBox["\[ExponentialE]", 
                  RowBox[{\((4 - d)\), " ", 
                    TagBox["\[DoubledGamma]",
                      Function[ {}, EulerGamma]]}]], " ", 
                RowBox[{"(", 
                  InterpretationBox[
                    RowBox[{\(\((M\^2)\)\^\(d - 4\)\), " ", 
                      InterpretationBox[
                        StyleBox[\(S\_d\%2\),
                          FontWeight->"Bold"],
                        SEpsilon[ d],
                        Editable->False]}],
                    Prefactor1[ 
                      Times[ 
                        Power[ 
                          Power[ M, 2], 
                          Plus[ -4, d]], 
                        Power[ 
                          SEpsilon[ d], 2]]],
                    Editable->False], ")"}]}], \(\(\[CapitalGamma](
                  4 - d)\)\ \(\[CapitalGamma](d\/2)\)\)]}], ",", 
          RowBox[{
            InterpretationBox[
              SubsuperscriptBox[
                StyleBox["K",
                  SingleLetterItalics->False,
                  FontWeight->"Bold"], 
                RowBox[{
                  FormBox[\({1, M_}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"], 
                  FormBox[\({1, 0}\),
                    "TraditionalForm"]}], 
                RowBox[{"(", 
                  FormBox["d_",
                    "TraditionalForm"], ")"}]],
              TJI[ 
                Pattern[ d, 
                  Blank[ ]], 0, {{1, 
                Pattern[ M, 
                  Blank[ ]]}, {1, 0}, {1, 0}}],
              Editable->True], "\[RuleDelayed]", 
            FractionBox[
              
              RowBox[{\(M\^2\), " ", \(\[CapitalGamma](3 - d)\), 
                " ", \(\[CapitalGamma](2 - d\/2)\), 
                " ", \(\(\[CapitalGamma](d\/2 - 1)\)\^2\), " ", 
                SuperscriptBox["\[ExponentialE]", 
                  RowBox[{\((4 - d)\), " ", 
                    TagBox["\[DoubledGamma]",
                      Function[ {}, EulerGamma]]}]], " ", 
                RowBox[{"(", 
                  InterpretationBox[
                    RowBox[{\(\((M\^2)\)\^\(d - 4\)\), " ", 
                      InterpretationBox[
                        StyleBox[\(S\_d\%2\),
                          FontWeight->"Bold"],
                        SEpsilon[ d],
                        Editable->False]}],
                    Prefactor1[ 
                      Times[ 
                        Power[ 
                          Power[ M, 2], 
                          Plus[ -4, d]], 
                        Power[ 
                          SEpsilon[ d], 2]]],
                    Editable->False], ")"}]}], \(\[CapitalGamma](d\/2)\)]}]}],
         "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Save tarcer*.mx file", "Section",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"T1.11.1"],

Cell[BoxData[
    \(\(Share[];\)\)], "Input"],

Cell["\<\
DumpSave[StringJoin[\"tarcer\", StringJoin @@ 
     ToString /@ $RankLimit, \".mx\"], 
   {$ContextPath, HighEnergyPhysics`Tarcer`Cayley, 
    HighEnergyPhysics`Tarcer`CayleyD, 
    HighEnergyPhysics`Tarcer`Cayleyu, 
    HighEnergyPhysics`Tarcer`Prefactor1, 
    HighEnergyPhysics`Tarcer`TarcerRecurse, 
    HighEnergyPhysics`Tarcer`TFIRecurse, 
    HighEnergyPhysics`Tarcer`TFISimplify, 
    HighEnergyPhysics`Tarcer`SEpsilon, 
    HighEnergyPhysics`Tarcer`TarcerExpand, 
    HighEnergyPhysics`Tarcer`TarcerReduce, 
    HighEnergyPhysics`Tarcer`TAI, 
    HighEnergyPhysics`Tarcer`TAR, 
    HighEnergyPhysics`Tarcer`TBI, 
    HighEnergyPhysics`Tarcer`TBR, 
    HighEnergyPhysics`Tarcer`TFI, 
    HighEnergyPhysics`Tarcer`TFR, 
    HighEnergyPhysics`Tarcer`TJI, 
    HighEnergyPhysics`Tarcer`TJR, 
    HighEnergyPhysics`Tarcer`TKI, 
    HighEnergyPhysics`Tarcer`TVI, 
    HighEnergyPhysics`Tarcer`TVR, 
    HighEnergyPhysics`Tarcer`$BasisIntegrals, 
    HighEnergyPhysics`Tarcer`$Comment, 
    HighEnergyPhysics`Tarcer`$CommentNotebook, 
    HighEnergyPhysics`Tarcer`$RankLimit, 
    HighEnergyPhysics`Tarcer`$RecursionStop, 
    HighEnergyPhysics`Tarcer`$TTable, 
    HighEnergyPhysics`Tarcer`Private`applytlrules, 
    HighEnergyPhysics`Tarcer`Private`applytlrules2,
    HighEnergyPhysics`Tarcer`Private`ExpandMaybe, 
    HighEnergyPhysics`Tarcer`Private`FactorC, 
    HighEnergyPhysics`Tarcer`Private`FEPrint, 
    HighEnergyPhysics`Tarcer`Private`fN, 
    HighEnergyPhysics`Tarcer`Private`mbt, 
    HighEnergyPhysics`Tarcer`Private`PNQ, 
    HighEnergyPhysics`Tarcer`Private`PQ, 
    HighEnergyPhysics`Tarcer`Private`ta, 
    HighEnergyPhysics`Tarcer`Private`TA, 
    HighEnergyPhysics`Tarcer`Private`TAIC, 
    HighEnergyPhysics`Tarcer`Private`TBIC, 
    HighEnergyPhysics`Tarcer`Private`TComment, 
    HighEnergyPhysics`Tarcer`Private`TLRComment, 
    HighEnergyPhysics`Tarcer`Private`TFIC, 
    HighEnergyPhysics`Tarcer`Private`TJIC, 
    HighEnergyPhysics`Tarcer`Private`TLR, 
    HighEnergyPhysics`Tarcer`Private`tlrule, 
    HighEnergyPhysics`Tarcer`Private`redblue, 
    HighEnergyPhysics`Tarcer`Private`TLRules, 
    HighEnergyPhysics`Tarcer`Private`TLRules2, 
    HighEnergyPhysics`Tarcer`Private`TVIC, 
    HighEnergyPhysics`Tarcer`Private`$TLRComment, 
    HighEnergyPhysics`general`Zeta2`Zeta2}]; \
\>", "Input",
  Editable->True],

Cell[BoxData[
    \(\($HistoryLength = \[Infinity];\)\)], "Input"],

Cell["\<\
This gives the absolute time (in minutes) to run this \
notebook.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Round[AbsoluteTime[] - HighEnergyPhysics`Tarcer`Private`atime]/
        60. \ min\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`7.166666666666667`\ min\)], "Output"]
}, Open  ]],

Cell["Display the size of the generated file:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(filename\  = \ "\<tarcer\>" <> \((Apply[StringJoin, 
            ToString /@ $RankLimit])\) <> "\<.mx\>"\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"tarcer25.mx"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileByteCount[filename]\ Byte\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`5180332\ Byte\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Directory[]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`"/opt/cvs/HighEnergyPhysics/Tarcer"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MaxMemoryUsed[]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`35630472\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryInUse[]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`12322008\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TimeUsed[]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`349.21`\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for X",
ScreenRectangle->{{0, 1400}, {0, 1050}},
WindowToolbars->"EditBar",
WindowSize->{1030, 725},
WindowMargins->{{39, Automatic}, {Automatic, 0}},
CellLabelAutoDelete->True,
Magnification->1
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "T1.1"->{
    Cell[1776, 53, 74, 2, 120, "Title",
      CellTags->"T1.1"]},
  "T1.2"->{
    Cell[2033, 65, 434, 14, 104, "Text",
      CellTags->"T1.2"]},
  "T1.1.1"->{
    Cell[31112, 1103, 93, 2, 61, "Section",
      CellTags->"T1.1.1"]},
  "T1.2.1.1"->{
    Cell[34769, 1222, 78, 1, 42, "Subsubsection",
      CellTags->"T1.2.1.1"]},
  "T1.2.1"->{
    Cell[35411, 1242, 86, 2, 61, "Section",
      CellTags->"T1.2.1"]},
  "T1.3.1"->{
    Cell[41805, 1410, 112, 2, 61, "Section",
      CellTags->"T1.3.1"]},
  "T1.3.1.1"->{
    Cell[43999, 1488, 63, 1, 45, "Subsection",
      CellTags->"T1.3.1.1"]},
  "T1.3.2.1"->{
    Cell[68674, 2084, 58, 1, 45, "Subsection",
      CellTags->"T1.3.2.1"]},
  "T1.3.3.1"->{
    Cell[73306, 2170, 59, 1, 45, "Subsection",
      CellTags->"T1.3.3.1"]},
  "T1.3.4.1"->{
    Cell[77420, 2260, 60, 1, 45, "Subsection",
      CellTags->"T1.3.4.1"]},
  "T1.3.5.1"->{
    Cell[78205, 2282, 54, 1, 45, "Subsection",
      CellTags->"T1.3.5.1"]},
  "T1.3.6.1"->{
    Cell[83240, 2388, 59, 1, 45, "Subsection",
      CellTags->"T1.3.6.1"]},
  "T1.3.7.1"->{
    Cell[83825, 2405, 50, 1, 45, "Subsection",
      CellTags->"T1.3.7.1"]},
  "T1.3.7.1.1"->{
    Cell[83990, 2413, 57, 1, 42, "Subsubsection",
      CellTags->"T1.3.7.1.1"]},
  "T1.3.7.2.1"->{
    Cell[86630, 2504, 53, 1, 42, "Subsubsection",
      CellTags->"T1.3.7.2.1"]},
  "T1.3.7.3.1"->{
    Cell[86794, 2513, 54, 1, 42, "Subsubsection",
      CellTags->"T1.3.7.3.1"]},
  "T1.3.7.4.1"->{
    Cell[87014, 2525, 58, 1, 42, "Subsubsection",
      CellTags->"T1.3.7.4.1"]},
  "T1.3.7.5.1"->{
    Cell[87186, 2534, 54, 1, 42, "Subsubsection",
      CellTags->"T1.3.7.5.1"]},
  "T1.3.7.6.1"->{
    Cell[90806, 2621, 54, 1, 42, "Subsubsection",
      CellTags->"T1.3.7.6.1"]},
  "T1.3.7.7.1"->{
    Cell[91427, 2642, 54, 1, 42, "Subsubsection",
      CellTags->"T1.3.7.7.1"]},
  "T1.3.7.8.1"->{
    Cell[92180, 2667, 54, 1, 42, "Subsubsection",
      CellTags->"T1.3.7.8.1"]},
  "T1.4.1"->{
    Cell[92513, 2683, 104, 2, 61, "Section",
      CellTags->"T1.4.1"]},
  "T1.4.1.1"->{
    Cell[94498, 2732, 116, 3, 45, "Subsection",
      CellTags->"T1.4.1.1"]},
  "T1.4.2.1"->{
    Cell[94942, 2751, 114, 3, 45, "Subsection",
      CellTags->"T1.4.2.1"]},
  "T1.4.3.1"->{
    Cell[97164, 2820, 205, 6, 45, "Subsection",
      CellTags->"T1.4.3.1"]},
  "T1.4.4.1"->{
    Cell[101851, 2943, 223, 6, 61, "Subsection",
      CellTags->"T1.4.4.1"]},
  "T1.5.1"->{
    Cell[114237, 3264, 97, 2, 61, "Section",
      CellTags->"T1.5.1"]},
  "T1.5.1.1"->{
    Cell[114359, 3270, 65, 1, 45, "Subsection",
      CellTags->"T1.5.1.1"]},
  "T1.5.1.1.1"->{
    Cell[174786, 4437, 62, 1, 42, "Subsubsection",
      CellTags->"T1.5.1.1.1"]},
  "T1.5.2.1"->{
    Cell[178242, 4525, 59, 1, 45, "Subsection",
      CellTags->"T1.5.2.1"]},
  "T1.5.2.1.1"->{
    Cell[179581, 4552, 53, 1, 42, "Subsubsection",
      CellTags->"T1.5.2.1.1"]},
  "T1.5.3.1"->{
    Cell[185582, 4702, 60, 1, 45, "Subsection",
      CellTags->"T1.5.3.1"]},
  "T1.5.3.1.1"->{
    Cell[185988, 4718, 68, 1, 42, "Subsubsection",
      CellTags->"T1.5.3.1.1"]},
  "T1.5.3.2.1"->{
    Cell[189058, 4783, 68, 1, 42, "Subsubsection",
      CellTags->"T1.5.3.2.1"]},
  "T1.6.1"->{
    Cell[191530, 4842, 140, 2, 61, "Section",
      CellTags->"T1.6.1"]},
  "T1.6.1.1"->{
    Cell[192121, 4861, 56, 1, 45, "Subsection",
      CellTags->"T1.6.1.1"]},
  "T1.6.2.1"->{
    Cell[199730, 5049, 58, 1, 45, "Subsection",
      CellTags->"T1.6.2.1"]},
  "T1.6.2.1.1"->{
    Cell[199897, 5057, 139, 5, 42, "Subsubsection",
      CellTags->"T1.6.2.1.1"]},
  "T1.6.2.2.1"->{
    Cell[201164, 5097, 139, 5, 42, "Subsubsection",
      CellTags->"T1.6.2.2.1"]},
  "T1.6.2.3.1"->{
    Cell[202503, 5138, 139, 5, 42, "Subsubsection",
      CellTags->"T1.6.2.3.1"]},
  "T1.6.2.4.1"->{
    Cell[203842, 5179, 139, 5, 42, "Subsubsection",
      CellTags->"T1.6.2.4.1"]},
  "T1.6.3.1"->{
    Cell[205193, 5221, 58, 1, 45, "Subsection",
      CellTags->"T1.6.3.1"]},
  "T1.6.4.1"->{
    Cell[208988, 5328, 159, 5, 45, "Subsection",
      CellTags->"T1.6.4.1"]},
  "T1.6.5.1"->{
    Cell[209633, 5352, 58, 1, 45, "Subsection",
      CellTags->"T1.6.5.1"]},
  "T1.6.6.1"->{
    Cell[213428, 5459, 159, 5, 45, "Subsection",
      CellTags->"T1.6.6.1"]},
  "T1.6.7.1"->{
    Cell[214073, 5483, 159, 5, 45, "Subsection",
      CellTags->"T1.6.7.1"]},
  "T1.6.8.1"->{
    Cell[214860, 5512, 159, 5, 45, "Subsection",
      CellTags->"T1.6.8.1"]},
  "T1.6.9.1"->{
    Cell[215647, 5541, 56, 1, 45, "Subsection",
      CellTags->"T1.6.9.1"]},
  "T1.6.10.1"->{
    Cell[222500, 5710, 59, 1, 45, "Subsection",
      CellTags->"T1.6.10.1"]},
  "T1.6.11.1"->{
    Cell[223765, 5749, 57, 1, 45, "Subsection",
      CellTags->"T1.6.11.1"]},
  "T1.6.12.1"->{
    Cell[228068, 5877, 57, 1, 45, "Subsection",
      CellTags->"T1.6.12.1"]},
  "T1.6.13.1"->{
    Cell[232371, 6005, 57, 1, 45, "Subsection",
      CellTags->"T1.6.13.1"]},
  "T1.6.14.1"->{
    Cell[239846, 6186, 68, 1, 45, "Subsection",
      CellTags->"T1.6.14.1"]},
  "T1.6.15.1"->{
    Cell[240263, 6202, 59, 1, 45, "Subsection",
      CellTags->"T1.6.15.1"]},
  "T1.6.16.1"->{
    Cell[263017, 6746, 57, 1, 45, "Subsection",
      CellTags->"T1.6.16.1"]},
  "T1.6.17.1"->{
    Cell[267050, 6859, 59, 1, 45, "Subsection",
      CellTags->"T1.6.17.1"]},
  "T1.6.18.1"->{
    Cell[267825, 6892, 57, 1, 45, "Subsection",
      CellTags->"T1.6.18.1"]},
  "T1.6.19.1"->{
    Cell[273337, 7040, 59, 1, 45, "Subsection",
      CellTags->"T1.6.19.1"]},
  "T1.6.20.1"->{
    Cell[274097, 7071, 59, 1, 45, "Subsection",
      CellTags->"T1.6.20.1"]},
  "T1.6.21.1"->{
    Cell[274885, 7103, 57, 1, 45, "Subsection",
      CellTags->"T1.6.21.1"]},
  "T1.6.22.1"->{
    Cell[278306, 7203, 59, 1, 45, "Subsection",
      CellTags->"T1.6.22.1"]},
  "T1.6.23.1"->{
    Cell[279008, 7232, 57, 1, 45, "Subsection",
      CellTags->"T1.6.23.1"]},
  "T1.6.24.1"->{
    Cell[283142, 7349, 59, 1, 45, "Subsection",
      CellTags->"T1.6.24.1"]},
  "T1.6.25.1"->{
    Cell[283868, 7379, 57, 1, 45, "Subsection",
      CellTags->"T1.6.25.1"]},
  "T1.6.26.1"->{
    Cell[287557, 7485, 59, 1, 45, "Subsection",
      CellTags->"T1.6.26.1"]},
  "T1.6.27.1"->{
    Cell[288289, 7515, 57, 1, 45, "Subsection",
      CellTags->"T1.6.27.1"]},
  "T1.6.28.1"->{
    Cell[293666, 7661, 59, 1, 45, "Subsection",
      CellTags->"T1.6.28.1"]},
  "T1.6.29.1"->{
    Cell[294640, 7690, 58, 1, 45, "Subsection",
      CellTags->"T1.6.29.1"]},
  "T1.6.30.1"->{
    Cell[298062, 7790, 59, 1, 45, "Subsection",
      CellTags->"T1.6.30.1"]},
  "T1.6.31.1"->{
    Cell[298783, 7819, 58, 1, 45, "Subsection",
      CellTags->"T1.6.31.1"]},
  "T1.6.32.1"->{
    Cell[304006, 7982, 59, 1, 45, "Subsection",
      CellTags->"T1.6.32.1"]},
  "T1.6.33.1"->{
    Cell[305908, 8053, 61, 1, 45, "Subsection",
      CellTags->"T1.6.33.1"]},
  "T1.6.34.1"->{
    Cell[307862, 8124, 58, 1, 45, "Subsection",
      CellTags->"T1.6.34.1"]},
  "T1.6.35.1"->{
    Cell[313487, 8281, 59, 1, 45, "Subsection",
      CellTags->"T1.6.35.1"]},
  "T1.6.36.1"->{
    Cell[314749, 8322, 58, 1, 45, "Subsection",
      CellTags->"T1.6.36.1"]},
  "T1.6.37.1"->{
    Cell[321478, 8489, 59, 1, 45, "Subsection",
      CellTags->"T1.6.37.1"]},
  "T1.6.38.1"->{
    Cell[323292, 8557, 61, 1, 45, "Subsection",
      CellTags->"T1.6.38.1"]},
  "T1.6.39.1"->{
    Cell[325122, 8615, 61, 1, 45, "Subsection",
      CellTags->"T1.6.39.1"]},
  "T1.6.40.1"->{
    Cell[326200, 8651, 61, 1, 45, "Subsection",
      CellTags->"T1.6.40.1"]},
  "T1.6.41.1"->{
    Cell[327046, 8679, 58, 1, 45, "Subsection",
      CellTags->"T1.6.41.1"]},
  "T1.6.42.1"->{
    Cell[332162, 8819, 59, 1, 45, "Subsection",
      CellTags->"T1.6.42.1"]},
  "T1.6.43.1"->{
    Cell[333038, 8852, 68, 1, 45, "Subsection",
      CellTags->"T1.6.43.1"]},
  "T1.6.44.1"->{
    Cell[338800, 9012, 57, 1, 45, "Subsection",
      CellTags->"T1.6.44.1"]},
  "T1.6.45.1"->{
    Cell[353456, 9421, 59, 1, 45, "Subsection",
      CellTags->"T1.6.45.1"]},
  "T1.6.46.1"->{
    Cell[354286, 9454, 61, 1, 45, "Subsection",
      CellTags->"T1.6.46.1"]},
  "T1.6.47.1"->{
    Cell[355188, 9489, 57, 1, 45, "Subsection",
      CellTags->"T1.6.47.1"]},
  "T1.6.48.1"->{
    Cell[361172, 9644, 59, 1, 45, "Subsection",
      CellTags->"T1.6.48.1"]},
  "T1.6.49.1"->{
    Cell[362014, 9677, 61, 1, 45, "Subsection",
      CellTags->"T1.6.49.1"]},
  "T1.6.50.1"->{
    Cell[362932, 9712, 57, 1, 45, "Subsection",
      CellTags->"T1.6.50.1"]},
  "T1.6.51.1"->{
    Cell[375506, 10022, 59, 1, 45, "Subsection",
      CellTags->"T1.6.51.1"]},
  "T1.6.52.1"->{
    Cell[376193, 10049, 57, 1, 45, "Subsection",
      CellTags->"T1.6.52.1"]},
  "T1.6.53.1"->{
    Cell[381557, 10195, 59, 1, 45, "Subsection",
      CellTags->"T1.6.53.1"]},
  "T1.6.54.1"->{
    Cell[382100, 10220, 61, 1, 45, "Subsection",
      CellTags->"T1.6.54.1"]},
  "T1.6.55.1"->{
    Cell[382678, 10245, 61, 1, 45, "Subsection",
      CellTags->"T1.6.55.1"]},
  "T1.6.56.1"->{
    Cell[383256, 10270, 57, 1, 45, "Subsection",
      CellTags->"T1.6.56.1"]},
  "T1.6.57.1"->{
    Cell[389130, 10431, 59, 1, 45, "Subsection",
      CellTags->"T1.6.57.1"]},
  "T1.6.58.1"->{
    Cell[389615, 10454, 57, 1, 45, "Subsection",
      CellTags->"T1.6.58.1"]},
  "T1.6.59.1"->{
    Cell[394235, 10580, 59, 1, 45, "Subsection",
      CellTags->"T1.6.59.1"]},
  "T1.6.60.1"->{
    Cell[394752, 10605, 57, 1, 45, "Subsection",
      CellTags->"T1.6.60.1"]},
  "T1.6.61.1"->{
    Cell[399890, 10745, 59, 1, 45, "Subsection",
      CellTags->"T1.6.61.1"]},
  "T1.6.62.1"->{
    Cell[400498, 10771, 61, 1, 45, "Subsection",
      CellTags->"T1.6.62.1"]},
  "T1.6.63.1"->{
    Cell[401141, 10797, 61, 1, 45, "Subsection",
      CellTags->"T1.6.63.1"]},
  "T1.6.64.1"->{
    Cell[401808, 10824, 57, 1, 45, "Subsection",
      CellTags->"T1.6.64.1"]},
  "T1.6.65.1"->{
    Cell[412410, 11088, 59, 1, 45, "Subsection",
      CellTags->"T1.6.65.1"]},
  "T1.6.66.1"->{
    Cell[412965, 11113, 61, 1, 45, "Subsection",
      CellTags->"T1.6.66.1"]},
  "T1.6.67.1"->{
    Cell[413566, 11139, 61, 1, 45, "Subsection",
      CellTags->"T1.6.67.1"]},
  "T1.6.68.1"->{
    Cell[414167, 11165, 57, 1, 45, "Subsection",
      CellTags->"T1.6.68.1"]},
  "T1.6.69.1"->{
    Cell[421087, 11341, 59, 1, 45, "Subsection",
      CellTags->"T1.6.69.1"]},
  "T1.6.70.1"->{
    Cell[421635, 11366, 57, 1, 45, "Subsection",
      CellTags->"T1.6.70.1"]},
  "T1.6.70.1.1"->{
    Cell[421717, 11371, 56, 1, 42, "Subsubsection",
      CellTags->"T1.6.70.1.1"]},
  "T1.6.70.2.1"->{
    Cell[423555, 11427, 56, 1, 42, "Subsubsection",
      CellTags->"T1.6.70.2.1"]},
  "T1.6.71.1"->{
    Cell[430091, 11610, 59, 1, 45, "Subsection",
      CellTags->"T1.6.71.1"]},
  "T1.6.72.1"->{
    Cell[430455, 11627, 57, 1, 45, "Subsection",
      CellTags->"T1.6.72.1"]},
  "T1.6.73.1"->{
    Cell[439831, 11853, 59, 1, 45, "Subsection",
      CellTags->"T1.6.73.1"]},
  "T1.6.74.1"->{
    Cell[440176, 11869, 57, 1, 45, "Subsection",
      CellTags->"T1.6.74.1"]},
  "T1.6.75.1"->{
    Cell[451656, 12191, 60, 1, 45, "Subsection",
      CellTags->"T1.6.75.1"]},
  "T1.6.76.1"->{
    Cell[452048, 12208, 60, 1, 45, "Subsection",
      CellTags->"T1.6.76.1"]},
  "T1.6.77.1"->{
    Cell[452503, 12226, 60, 1, 45, "Subsection",
      CellTags->"T1.6.77.1"]},
  "T1.6.78.1"->{
    Cell[452894, 12243, 60, 1, 45, "Subsection",
      CellTags->"T1.6.78.1"]},
  "T1.6.79.1"->{
    Cell[453316, 12260, 57, 1, 45, "Subsection",
      CellTags->"T1.6.79.1"]},
  "T1.6.80.1"->{
    Cell[458648, 12399, 57, 1, 45, "Subsection",
      CellTags->"T1.6.80.1"]},
  "T1.6.81.1"->{
    Cell[461150, 12473, 59, 1, 45, "Subsection",
      CellTags->"T1.6.81.1"]},
  "T1.6.82.1"->{
    Cell[461515, 12489, 57, 1, 45, "Subsection",
      CellTags->"T1.6.82.1"]},
  "T1.6.83.1"->{
    Cell[464775, 12582, 59, 1, 45, "Subsection",
      CellTags->"T1.6.83.1"]},
  "T1.6.84.1"->{
    Cell[465091, 12596, 61, 1, 45, "Subsection",
      CellTags->"T1.6.84.1"]},
  "T1.6.85.1"->{
    Cell[465588, 12615, 61, 1, 45, "Subsection",
      CellTags->"T1.6.85.1"]},
  "T1.6.86.1"->{
    Cell[466130, 12635, 57, 1, 45, "Subsection",
      CellTags->"T1.6.86.1"]},
  "T1.6.87.1"->{
    Cell[468476, 12711, 59, 1, 45, "Subsection",
      CellTags->"T1.6.87.1"]},
  "T1.6.88.1"->{
    Cell[468813, 12726, 57, 1, 45, "Subsection",
      CellTags->"T1.6.88.1"]},
  "T1.6.89.1"->{
    Cell[471143, 12799, 59, 1, 45, "Subsection",
      CellTags->"T1.6.89.1"]},
  "T1.6.90.1"->{
    Cell[471432, 12813, 57, 1, 45, "Subsection",
      CellTags->"T1.6.90.1"]},
  "T1.6.91.1"->{
    Cell[472960, 12866, 59, 1, 45, "Subsection",
      CellTags->"T1.6.91.1"]},
  "T1.6.92.1"->{
    Cell[473264, 12880, 57, 1, 45, "Subsection",
      CellTags->"T1.6.92.1"]},
  "T1.6.93.1"->{
    Cell[474650, 12929, 59, 1, 45, "Subsection",
      CellTags->"T1.6.93.1"]},
  "T1.6.94.1"->{
    Cell[474928, 12943, 57, 1, 45, "Subsection",
      CellTags->"T1.6.94.1"]},
  "T1.6.95.1"->{
    Cell[478876, 13060, 59, 1, 45, "Subsection",
      CellTags->"T1.6.95.1"]},
  "T1.6.96.1"->{
    Cell[479189, 13074, 61, 1, 45, "Subsection",
      CellTags->"T1.6.96.1"]},
  "T1.6.97.1"->{
    Cell[479564, 13090, 61, 1, 45, "Subsection",
      CellTags->"T1.6.97.1"]},
  "T1.6.98.1"->{
    Cell[479939, 13106, 58, 1, 45, "Subsection",
      CellTags->"T1.6.98.1"]},
  "T1.6.99.1"->{
    Cell[486108, 13284, 60, 1, 45, "Subsection",
      CellTags->"T1.6.99.1"]},
  "T1.6.100.1"->{
    Cell[486566, 13307, 62, 1, 45, "Subsection",
      CellTags->"T1.6.100.1"]},
  "T1.6.101.1"->{
    Cell[487067, 13330, 62, 1, 45, "Subsection",
      CellTags->"T1.6.101.1"]},
  "T1.6.102.1"->{
    Cell[487607, 13355, 62, 1, 45, "Subsection",
      CellTags->"T1.6.102.1"]},
  "T1.6.103.1"->{
    Cell[488108, 13378, 62, 1, 45, "Subsection",
      CellTags->"T1.6.103.1"]},
  "T1.6.104.1"->{
    Cell[488609, 13401, 62, 1, 45, "Subsection",
      CellTags->"T1.6.104.1"]},
  "T1.6.105.1"->{
    Cell[489149, 13426, 59, 1, 45, "Subsection",
      CellTags->"T1.6.105.1"]},
  "T1.6.106.1"->{
    Cell[489908, 13450, 61, 1, 45, "Subsection",
      CellTags->"T1.6.106.1"]},
  "T1.6.107.1"->{
    Cell[490130, 13462, 59, 1, 45, "Subsection",
      CellTags->"T1.6.107.1"]},
  "T1.6.108.1"->{
    Cell[490999, 13490, 61, 1, 45, "Subsection",
      CellTags->"T1.6.108.1"]},
  "T1.6.109.1"->{
    Cell[491271, 13504, 59, 1, 45, "Subsection",
      CellTags->"T1.6.109.1"]},
  "T1.6.110.1"->{
    Cell[491977, 13527, 61, 1, 45, "Subsection",
      CellTags->"T1.6.110.1"]},
  "T1.6.111.1"->{
    Cell[492199, 13539, 59, 1, 45, "Subsection",
      CellTags->"T1.6.111.1"]},
  "T1.6.112.1"->{
    Cell[492671, 13556, 61, 1, 45, "Subsection",
      CellTags->"T1.6.112.1"]},
  "T1.6.113.1"->{
    Cell[492893, 13568, 59, 1, 45, "Subsection",
      CellTags->"T1.6.113.1"]},
  "T1.6.114.1"->{
    Cell[500049, 13757, 61, 1, 45, "Subsection",
      CellTags->"T1.6.114.1"]},
  "T1.6.115.1"->{
    Cell[500651, 13778, 61, 1, 45, "Subsection",
      CellTags->"T1.6.115.1"]},
  "T1.6.116.1"->{
    Cell[501444, 13815, 61, 1, 45, "Subsection",
      CellTags->"T1.6.116.1"]},
  "T1.6.117.1"->{
    Cell[502241, 13852, 62, 1, 45, "Subsection",
      CellTags->"T1.6.117.1"]},
  "T1.6.118.1"->{
    Cell[503426, 13879, 62, 1, 45, "Subsection",
      CellTags->"T1.6.118.1"]},
  "T1.6.119.1"->{
    Cell[504574, 13905, 62, 1, 45, "Subsection",
      CellTags->"T1.6.119.1"]},
  "T1.6.120.1"->{
    Cell[505720, 13931, 61, 1, 45, "Subsection",
      CellTags->"T1.6.120.1"]},
  "Tsymmetry"->{
    Cell[514635, 14103, 55, 1, 45, "Subsection",
      CellTags->"Tsymmetry"]},
  "specialTVR"->{
    Cell[514874, 14116, 70, 1, 45, "Subsection",
      CellTags->"specialTVR"]},
  "T1.6.121.1"->{
    Cell[525663, 14304, 60, 1, 45, "Subsection",
      CellTags->"T1.6.121.1"]},
  "T1.6.122.1"->{
    Cell[528826, 14400, 61, 1, 45, "Subsection",
      CellTags->"T1.6.122.1"]},
  "T1.6.123.1"->{
    Cell[529879, 14432, 60, 1, 45, "Subsection",
      CellTags->"T1.6.123.1"]},
  "T1.6.124.1"->{
    Cell[530567, 14456, 58, 1, 45, "Subsection",
      CellTags->"T1.6.124.1"]},
  "T1.7.1"->{
    Cell[531319, 14484, 108, 2, 61, "Section",
      CellTags->"T1.7.1"]},
  "T1.7.1.1"->{
    Cell[531452, 14490, 70, 1, 45, "Subsection",
      CellTags->"T1.7.1.1"]},
  "TLRdef"->{
    Cell[533317, 14553, 216, 7, 104, "Text",
      CellTags->"TLRdef"]},
  "tlrule17"->{
    Cell[543806, 14827, 78, 1, 32, "Text",
      CellTags->"tlrule17"]},
  "T1.7.2.1"->{
    Cell[570337, 15522, 50, 1, 45, "Subsection",
      CellTags->"T1.7.2.1"]},
  "T1.7.3.1"->{
    Cell[575844, 15656, 54, 1, 45, "Subsection",
      CellTags->"T1.7.3.1"]},
  "$TTable"->{
    Cell[577382, 15693, 52, 1, 45, "Subsection",
      CellTags->"$TTable"]},
  "T1.7.4.1"->{
    Cell[577524, 15702, 59, 1, 45, "Subsection",
      CellTags->"T1.7.4.1"]},
  "T1.8.1"->{
    Cell[586983, 15890, 92, 2, 61, "Section",
      CellTags->"T1.8.1"]},
  "T1.9.1"->{
    Cell[596221, 16069, 93, 2, 61, "Section",
      CellTags->"T1.9.1"]},
  "T1.9.1.1"->{
    Cell[596339, 16075, 54, 1, 45, "Subsection",
      CellTags->"T1.9.1.1"]},
  "T1.10.1"->{
    Cell[600699, 16206, 95, 2, 61, "Section",
      CellTags->"T1.10.1"]},
  "T1.11.1"->{
    Cell[633941, 17072, 101, 2, 61, "Section",
      CellTags->"T1.11.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"T1.1", 638580, 17232},
  {"T1.2", 638658, 17235},
  {"T1.1.1", 638739, 17238},
  {"T1.2.1.1", 638827, 17241},
  {"T1.2.1", 638921, 17244},
  {"T1.3.1", 639007, 17247},
  {"T1.3.1.1", 639096, 17250},
  {"T1.3.2.1", 639189, 17253},
  {"T1.3.3.1", 639282, 17256},
  {"T1.3.4.1", 639375, 17259},
  {"T1.3.5.1", 639468, 17262},
  {"T1.3.6.1", 639561, 17265},
  {"T1.3.7.1", 639654, 17268},
  {"T1.3.7.1.1", 639749, 17271},
  {"T1.3.7.2.1", 639849, 17274},
  {"T1.3.7.3.1", 639949, 17277},
  {"T1.3.7.4.1", 640049, 17280},
  {"T1.3.7.5.1", 640149, 17283},
  {"T1.3.7.6.1", 640249, 17286},
  {"T1.3.7.7.1", 640349, 17289},
  {"T1.3.7.8.1", 640449, 17292},
  {"T1.4.1", 640545, 17295},
  {"T1.4.1.1", 640634, 17298},
  {"T1.4.2.1", 640728, 17301},
  {"T1.4.3.1", 640822, 17304},
  {"T1.4.4.1", 640916, 17307},
  {"T1.5.1", 641009, 17310},
  {"T1.5.1.1", 641098, 17313},
  {"T1.5.1.1.1", 641194, 17316},
  {"T1.5.2.1", 641293, 17319},
  {"T1.5.2.1.1", 641389, 17322},
  {"T1.5.3.1", 641488, 17325},
  {"T1.5.3.1.1", 641584, 17328},
  {"T1.5.3.2.1", 641685, 17331},
  {"T1.6.1", 641782, 17334},
  {"T1.6.1.1", 641872, 17337},
  {"T1.6.2.1", 641966, 17340},
  {"T1.6.2.1.1", 642062, 17343},
  {"T1.6.2.2.1", 642164, 17346},
  {"T1.6.2.3.1", 642266, 17349},
  {"T1.6.2.4.1", 642368, 17352},
  {"T1.6.3.1", 642468, 17355},
  {"T1.6.4.1", 642562, 17358},
  {"T1.6.5.1", 642657, 17361},
  {"T1.6.6.1", 642751, 17364},
  {"T1.6.7.1", 642846, 17367},
  {"T1.6.8.1", 642941, 17370},
  {"T1.6.9.1", 643036, 17373},
  {"T1.6.10.1", 643131, 17376},
  {"T1.6.11.1", 643227, 17379},
  {"T1.6.12.1", 643323, 17382},
  {"T1.6.13.1", 643419, 17385},
  {"T1.6.14.1", 643515, 17388},
  {"T1.6.15.1", 643611, 17391},
  {"T1.6.16.1", 643707, 17394},
  {"T1.6.17.1", 643803, 17397},
  {"T1.6.18.1", 643899, 17400},
  {"T1.6.19.1", 643995, 17403},
  {"T1.6.20.1", 644091, 17406},
  {"T1.6.21.1", 644187, 17409},
  {"T1.6.22.1", 644283, 17412},
  {"T1.6.23.1", 644379, 17415},
  {"T1.6.24.1", 644475, 17418},
  {"T1.6.25.1", 644571, 17421},
  {"T1.6.26.1", 644667, 17424},
  {"T1.6.27.1", 644763, 17427},
  {"T1.6.28.1", 644859, 17430},
  {"T1.6.29.1", 644955, 17433},
  {"T1.6.30.1", 645051, 17436},
  {"T1.6.31.1", 645147, 17439},
  {"T1.6.32.1", 645243, 17442},
  {"T1.6.33.1", 645339, 17445},
  {"T1.6.34.1", 645435, 17448},
  {"T1.6.35.1", 645531, 17451},
  {"T1.6.36.1", 645627, 17454},
  {"T1.6.37.1", 645723, 17457},
  {"T1.6.38.1", 645819, 17460},
  {"T1.6.39.1", 645915, 17463},
  {"T1.6.40.1", 646011, 17466},
  {"T1.6.41.1", 646107, 17469},
  {"T1.6.42.1", 646203, 17472},
  {"T1.6.43.1", 646299, 17475},
  {"T1.6.44.1", 646395, 17478},
  {"T1.6.45.1", 646491, 17481},
  {"T1.6.46.1", 646587, 17484},
  {"T1.6.47.1", 646683, 17487},
  {"T1.6.48.1", 646779, 17490},
  {"T1.6.49.1", 646875, 17493},
  {"T1.6.50.1", 646971, 17496},
  {"T1.6.51.1", 647067, 17499},
  {"T1.6.52.1", 647164, 17502},
  {"T1.6.53.1", 647261, 17505},
  {"T1.6.54.1", 647358, 17508},
  {"T1.6.55.1", 647455, 17511},
  {"T1.6.56.1", 647552, 17514},
  {"T1.6.57.1", 647649, 17517},
  {"T1.6.58.1", 647746, 17520},
  {"T1.6.59.1", 647843, 17523},
  {"T1.6.60.1", 647940, 17526},
  {"T1.6.61.1", 648037, 17529},
  {"T1.6.62.1", 648134, 17532},
  {"T1.6.63.1", 648231, 17535},
  {"T1.6.64.1", 648328, 17538},
  {"T1.6.65.1", 648425, 17541},
  {"T1.6.66.1", 648522, 17544},
  {"T1.6.67.1", 648619, 17547},
  {"T1.6.68.1", 648716, 17550},
  {"T1.6.69.1", 648813, 17553},
  {"T1.6.70.1", 648910, 17556},
  {"T1.6.70.1.1", 649009, 17559},
  {"T1.6.70.2.1", 649113, 17562},
  {"T1.6.71.1", 649215, 17565},
  {"T1.6.72.1", 649312, 17568},
  {"T1.6.73.1", 649409, 17571},
  {"T1.6.74.1", 649506, 17574},
  {"T1.6.75.1", 649603, 17577},
  {"T1.6.76.1", 649700, 17580},
  {"T1.6.77.1", 649797, 17583},
  {"T1.6.78.1", 649894, 17586},
  {"T1.6.79.1", 649991, 17589},
  {"T1.6.80.1", 650088, 17592},
  {"T1.6.81.1", 650185, 17595},
  {"T1.6.82.1", 650282, 17598},
  {"T1.6.83.1", 650379, 17601},
  {"T1.6.84.1", 650476, 17604},
  {"T1.6.85.1", 650573, 17607},
  {"T1.6.86.1", 650670, 17610},
  {"T1.6.87.1", 650767, 17613},
  {"T1.6.88.1", 650864, 17616},
  {"T1.6.89.1", 650961, 17619},
  {"T1.6.90.1", 651058, 17622},
  {"T1.6.91.1", 651155, 17625},
  {"T1.6.92.1", 651252, 17628},
  {"T1.6.93.1", 651349, 17631},
  {"T1.6.94.1", 651446, 17634},
  {"T1.6.95.1", 651543, 17637},
  {"T1.6.96.1", 651640, 17640},
  {"T1.6.97.1", 651737, 17643},
  {"T1.6.98.1", 651834, 17646},
  {"T1.6.99.1", 651931, 17649},
  {"T1.6.100.1", 652029, 17652},
  {"T1.6.101.1", 652128, 17655},
  {"T1.6.102.1", 652227, 17658},
  {"T1.6.103.1", 652326, 17661},
  {"T1.6.104.1", 652425, 17664},
  {"T1.6.105.1", 652524, 17667},
  {"T1.6.106.1", 652623, 17670},
  {"T1.6.107.1", 652722, 17673},
  {"T1.6.108.1", 652821, 17676},
  {"T1.6.109.1", 652920, 17679},
  {"T1.6.110.1", 653019, 17682},
  {"T1.6.111.1", 653118, 17685},
  {"T1.6.112.1", 653217, 17688},
  {"T1.6.113.1", 653316, 17691},
  {"T1.6.114.1", 653415, 17694},
  {"T1.6.115.1", 653514, 17697},
  {"T1.6.116.1", 653613, 17700},
  {"T1.6.117.1", 653712, 17703},
  {"T1.6.118.1", 653811, 17706},
  {"T1.6.119.1", 653910, 17709},
  {"T1.6.120.1", 654009, 17712},
  {"Tsymmetry", 654107, 17715},
  {"specialTVR", 654205, 17718},
  {"T1.6.121.1", 654304, 17721},
  {"T1.6.122.1", 654403, 17724},
  {"T1.6.123.1", 654502, 17727},
  {"T1.6.124.1", 654601, 17730},
  {"T1.7.1", 654696, 17733},
  {"T1.7.1.1", 654787, 17736},
  {"TLRdef", 654880, 17739},
  {"tlrule17", 654969, 17742},
  {"T1.7.2.1", 655058, 17745},
  {"T1.7.3.1", 655153, 17748},
  {"$TTable", 655247, 17751},
  {"T1.7.4.1", 655341, 17754},
  {"T1.8.1", 655434, 17757},
  {"T1.9.1", 655522, 17760},
  {"T1.9.1.1", 655612, 17763},
  {"T1.10.1", 655706, 17766},
  {"T1.11.1", 655796, 17769}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 74, 2, 120, "Title",
  CellTags->"T1.1"],
Cell[1853, 57, 177, 6, 32, "Text"],
Cell[2033, 65, 434, 14, 104, "Text",
  CellTags->"T1.2"],
Cell[2470, 81, 57, 1, 32, "Text"],
Cell[2530, 84, 140, 3, 32, "Text"],
Cell[2673, 89, 185, 4, 50, "Text"],
Cell[2861, 95, 154, 4, 50, "Text"],
Cell[3018, 101, 97, 3, 32, "Text"],
Cell[3118, 106, 384, 8, 86, "Text"],
Cell[3505, 116, 157, 4, 32, "Text"],
Cell[3665, 122, 131, 3, 32, "Text"],
Cell[3799, 127, 137, 3, 32, "Text"],
Cell[3939, 132, 186, 6, 32, "Text"],
Cell[4128, 140, 158, 6, 32, "Text"],
Cell[4289, 148, 171, 6, 32, "Text"],
Cell[4463, 156, 162, 6, 32, "Text"],
Cell[4628, 164, 162, 6, 32, "Text"],
Cell[4793, 172, 162, 6, 32, "Text"],
Cell[4958, 180, 167, 6, 32, "Text"],
Cell[5128, 188, 156, 3, 32, "Text"],
Cell[5287, 193, 1081, 21, 248, "Text"],
Cell[6371, 216, 147, 3, 32, "Text"],
Cell[6521, 221, 499, 10, 104, "Text"],
Cell[7023, 233, 94, 3, 32, "Text"],
Cell[7120, 238, 176, 4, 32, "Text"],
Cell[7299, 244, 228, 6, 50, "Text"],
Cell[7530, 252, 54, 1, 27, "Input"],
Cell[7587, 255, 180, 4, 32, "Text"],
Cell[7770, 261, 212, 4, 32, "Text"],
Cell[7985, 267, 262, 8, 32, "Text"],

Cell[CellGroupData[{
Cell[8272, 279, 75, 1, 61, "Section"],
Cell[8350, 282, 102, 2, 32, "Text"],
Cell[8455, 286, 95, 2, 32, "Text"],
Cell[8553, 290, 120, 2, 32, "Text"],
Cell[8676, 294, 121, 2, 32, "Text"],
Cell[8800, 298, 108, 2, 32, "Text"],
Cell[8911, 302, 103, 2, 32, "Text"],
Cell[9017, 306, 104, 2, 32, "Text"],
Cell[9124, 310, 105, 2, 32, "Text"],
Cell[9232, 314, 99, 2, 32, "Text"],
Cell[9334, 318, 104, 2, 32, "Text"],
Cell[9441, 322, 95, 2, 32, "Text"],
Cell[9539, 326, 104, 2, 27, "SmallText"],
Cell[9646, 330, 100, 2, 27, "SmallText"],
Cell[9749, 334, 101, 2, 27, "SmallText"],
Cell[9853, 338, 105, 2, 27, "SmallText"],
Cell[9961, 342, 101, 2, 27, "SmallText"],
Cell[10065, 346, 101, 2, 27, "SmallText"],
Cell[10169, 350, 101, 2, 27, "SmallText"],
Cell[10273, 354, 101, 2, 27, "SmallText"],
Cell[10377, 358, 113, 2, 32, "Text"],
Cell[10493, 362, 143, 3, 32, "Text"],
Cell[10639, 367, 141, 3, 32, "Text"],
Cell[10783, 372, 530, 15, 36, "Text"],
Cell[11316, 389, 547, 15, 36, "Text"],
Cell[11866, 406, 106, 2, 32, "Text"],
Cell[11975, 410, 110, 2, 32, "Text"],
Cell[12088, 414, 109, 2, 27, "SmallText"],
Cell[12200, 418, 189, 7, 32, "Text"],
Cell[12392, 427, 100, 2, 27, "SmallText"],
Cell[12495, 431, 105, 2, 32, "Text"],
Cell[12603, 435, 115, 2, 27, "SmallText"],
Cell[12721, 439, 115, 2, 27, "SmallText"],
Cell[12839, 443, 151, 3, 32, "Text"],
Cell[12993, 448, 101, 2, 32, "Text"],
Cell[13097, 452, 103, 2, 32, "Text"],
Cell[13203, 456, 489, 13, 33, "SmallText"],
Cell[13695, 471, 489, 13, 33, "SmallText"],
Cell[14187, 486, 489, 13, 33, "SmallText"],
Cell[14679, 501, 489, 13, 33, "SmallText"],
Cell[15171, 516, 103, 2, 32, "Text"],
Cell[15277, 520, 523, 15, 38, "Text"],
Cell[15803, 537, 103, 2, 32, "Text"],
Cell[15909, 541, 523, 15, 38, "Text"],
Cell[16435, 558, 523, 15, 38, "Text"],
Cell[16961, 575, 523, 15, 38, "Text"],
Cell[17487, 592, 101, 2, 32, "Text"],
Cell[17591, 596, 104, 2, 32, "Text"],
Cell[17698, 600, 102, 2, 32, "Text"],
Cell[17803, 604, 102, 2, 32, "Text"],
Cell[17908, 608, 102, 2, 32, "Text"],
Cell[18013, 612, 113, 2, 32, "Text"],
Cell[18129, 616, 104, 2, 32, "Text"],
Cell[18236, 620, 102, 2, 32, "Text"],
Cell[18341, 624, 104, 2, 32, "Text"],
Cell[18448, 628, 102, 2, 32, "Text"],
Cell[18553, 632, 104, 2, 32, "Text"],
Cell[18660, 636, 104, 2, 32, "Text"],
Cell[18767, 640, 102, 2, 32, "Text"],
Cell[18872, 644, 104, 2, 32, "Text"],
Cell[18979, 648, 102, 2, 32, "Text"],
Cell[19084, 652, 104, 2, 32, "Text"],
Cell[19191, 656, 102, 2, 32, "Text"],
Cell[19296, 660, 104, 2, 32, "Text"],
Cell[19403, 664, 102, 2, 32, "Text"],
Cell[19508, 668, 104, 2, 32, "Text"],
Cell[19615, 672, 102, 2, 32, "Text"],
Cell[19720, 676, 104, 2, 32, "Text"],
Cell[19827, 680, 102, 2, 32, "Text"],
Cell[19932, 684, 104, 2, 32, "Text"],
Cell[20039, 688, 106, 2, 32, "Text"],
Cell[20148, 692, 102, 2, 32, "Text"],
Cell[20253, 696, 104, 2, 32, "Text"],
Cell[20360, 700, 102, 2, 32, "Text"],
Cell[20465, 704, 104, 2, 32, "Text"],
Cell[20572, 708, 106, 2, 32, "Text"],
Cell[20681, 712, 106, 2, 32, "Text"],
Cell[20790, 716, 106, 2, 32, "Text"],
Cell[20899, 720, 102, 2, 32, "Text"],
Cell[21004, 724, 104, 2, 32, "Text"],
Cell[21111, 728, 113, 2, 32, "Text"],
Cell[21227, 732, 102, 2, 32, "Text"],
Cell[21332, 736, 104, 2, 32, "Text"],
Cell[21439, 740, 106, 2, 32, "Text"],
Cell[21548, 744, 102, 2, 32, "Text"],
Cell[21653, 748, 104, 2, 32, "Text"],
Cell[21760, 752, 106, 2, 32, "Text"],
Cell[21869, 756, 102, 2, 32, "Text"],
Cell[21974, 760, 104, 2, 32, "Text"],
Cell[22081, 764, 102, 2, 32, "Text"],
Cell[22186, 768, 104, 2, 32, "Text"],
Cell[22293, 772, 106, 2, 32, "Text"],
Cell[22402, 776, 106, 2, 32, "Text"],
Cell[22511, 780, 102, 2, 32, "Text"],
Cell[22616, 784, 104, 2, 32, "Text"],
Cell[22723, 788, 102, 2, 32, "Text"],
Cell[22828, 792, 104, 2, 32, "Text"],
Cell[22935, 796, 102, 2, 32, "Text"],
Cell[23040, 800, 104, 2, 32, "Text"],
Cell[23147, 804, 106, 2, 32, "Text"],
Cell[23256, 808, 106, 2, 32, "Text"],
Cell[23365, 812, 102, 2, 32, "Text"],
Cell[23470, 816, 104, 2, 32, "Text"],
Cell[23577, 820, 106, 2, 32, "Text"],
Cell[23686, 824, 106, 2, 32, "Text"],
Cell[23795, 828, 102, 2, 32, "Text"],
Cell[23900, 832, 104, 2, 32, "Text"],
Cell[24007, 836, 102, 2, 32, "Text"],
Cell[24112, 840, 103, 2, 27, "SmallText"],
Cell[24218, 844, 103, 2, 27, "SmallText"],
Cell[24324, 848, 104, 2, 32, "Text"],
Cell[24431, 852, 102, 2, 32, "Text"],
Cell[24536, 856, 104, 2, 32, "Text"],
Cell[24643, 860, 102, 2, 32, "Text"],
Cell[24748, 864, 105, 2, 32, "Text"],
Cell[24856, 868, 105, 2, 32, "Text"],
Cell[24964, 872, 105, 2, 32, "Text"],
Cell[25072, 876, 105, 2, 32, "Text"],
Cell[25180, 880, 102, 2, 32, "Text"],
Cell[25285, 884, 102, 2, 32, "Text"],
Cell[25390, 888, 104, 2, 32, "Text"],
Cell[25497, 892, 102, 2, 32, "Text"],
Cell[25602, 896, 104, 2, 32, "Text"],
Cell[25709, 900, 106, 2, 32, "Text"],
Cell[25818, 904, 106, 2, 32, "Text"],
Cell[25927, 908, 102, 2, 32, "Text"],
Cell[26032, 912, 104, 2, 32, "Text"],
Cell[26139, 916, 102, 2, 32, "Text"],
Cell[26244, 920, 104, 2, 32, "Text"],
Cell[26351, 924, 102, 2, 32, "Text"],
Cell[26456, 928, 104, 2, 32, "Text"],
Cell[26563, 932, 102, 2, 32, "Text"],
Cell[26668, 936, 104, 2, 32, "Text"],
Cell[26775, 940, 102, 2, 32, "Text"],
Cell[26880, 944, 104, 2, 32, "Text"],
Cell[26987, 948, 106, 2, 32, "Text"],
Cell[27096, 952, 106, 2, 32, "Text"],
Cell[27205, 956, 103, 2, 32, "Text"],
Cell[27311, 960, 105, 2, 32, "Text"],
Cell[27419, 964, 107, 2, 32, "Text"],
Cell[27529, 968, 107, 2, 32, "Text"],
Cell[27639, 972, 107, 2, 32, "Text"],
Cell[27749, 976, 107, 2, 32, "Text"],
Cell[27859, 980, 107, 2, 32, "Text"],
Cell[27969, 984, 104, 2, 32, "Text"],
Cell[28076, 988, 106, 2, 32, "Text"],
Cell[28185, 992, 104, 2, 32, "Text"],
Cell[28292, 996, 106, 2, 32, "Text"],
Cell[28401, 1000, 104, 2, 32, "Text"],
Cell[28508, 1004, 106, 2, 32, "Text"],
Cell[28617, 1008, 104, 2, 32, "Text"],
Cell[28724, 1012, 106, 2, 32, "Text"],
Cell[28833, 1016, 104, 2, 32, "Text"],
Cell[28940, 1020, 106, 2, 32, "Text"],
Cell[29049, 1024, 106, 2, 32, "Text"],
Cell[29158, 1028, 106, 2, 32, "Text"],
Cell[29267, 1032, 106, 2, 32, "Text"],
Cell[29376, 1036, 106, 2, 32, "Text"],
Cell[29485, 1040, 106, 2, 32, "Text"],
Cell[29594, 1044, 106, 2, 32, "Text"],
Cell[29703, 1048, 105, 2, 32, "Text"],
Cell[29811, 1052, 106, 2, 32, "Text"],
Cell[29920, 1056, 105, 2, 32, "Text"],
Cell[30028, 1060, 103, 2, 32, "Text"],
Cell[30134, 1064, 117, 2, 32, "Text"],
Cell[30254, 1068, 101, 2, 32, "Text"],
Cell[30358, 1072, 95, 2, 32, "Text"],
Cell[30456, 1076, 99, 2, 32, "Text"],
Cell[30558, 1080, 104, 2, 32, "Text"],
Cell[30665, 1084, 101, 2, 32, "Text"],
Cell[30769, 1088, 102, 2, 32, "Text"],
Cell[30874, 1092, 105, 2, 32, "Text"],
Cell[30982, 1096, 93, 2, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31112, 1103, 93, 2, 61, "Section",
  CellTags->"T1.1.1"],
Cell[31208, 1107, 342, 10, 58, "SmallText"],
Cell[31553, 1119, 118, 3, 32, "Text"],
Cell[31674, 1124, 1703, 43, 84, "Text"],
Cell[33380, 1169, 222, 5, 86, "Text"],
Cell[33605, 1176, 50, 1, 27, "Input"],
Cell[33658, 1179, 64, 1, 27, "Input"],
Cell[33725, 1182, 89, 1, 27, "Input"],
Cell[33817, 1185, 56, 1, 27, "Input"],
Cell[33876, 1188, 107, 3, 32, "Text"],
Cell[33986, 1193, 178, 5, 27, "Input"],
Cell[34167, 1200, 220, 6, 28, "SmallText"],
Cell[34390, 1208, 233, 4, 43, "Input"],
Cell[34626, 1214, 57, 1, 27, "Input"],
Cell[34686, 1217, 58, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[34769, 1222, 78, 1, 42, "Subsubsection",
  CellTags->"T1.2.1.1"],
Cell[34850, 1225, 512, 11, 104, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35411, 1242, 86, 2, 61, "Section",
  CellTags->"T1.2.1"],
Cell[35500, 1246, 26, 0, 27, "Input"],
Cell[35529, 1248, 83, 1, 27, "Input"],
Cell[35615, 1251, 257, 4, 59, "Input"],
Cell[35875, 1257, 631, 9, 107, "Input"],
Cell[36509, 1268, 157, 2, 27, "Input"],
Cell[36669, 1272, 120, 2, 27, "Input"],
Cell[36792, 1276, 135, 2, 27, "Input"],
Cell[36930, 1280, 135, 2, 27, "Input"],
Cell[37068, 1284, 147, 2, 27, "Input"],
Cell[37218, 1288, 123, 2, 27, "Input"],
Cell[37344, 1292, 580, 15, 207, "Input"],
Cell[37927, 1309, 211, 3, 59, "Input"],
Cell[38141, 1314, 227, 3, 59, "Input"],
Cell[38371, 1319, 176, 3, 27, "Input"],
Cell[38550, 1324, 172, 3, 27, "Input"],
Cell[38725, 1329, 194, 3, 43, "Input"],
Cell[38922, 1334, 177, 3, 27, "Input"],
Cell[39102, 1339, 168, 3, 27, "Input"],
Cell[39273, 1344, 149, 2, 27, "Input"],
Cell[39425, 1348, 149, 2, 27, "Input"],
Cell[39577, 1352, 149, 2, 27, "Input"],
Cell[39729, 1356, 149, 2, 27, "Input"],
Cell[39881, 1360, 149, 2, 27, "Input"],
Cell[40033, 1364, 449, 6, 91, "Input"],
Cell[40485, 1372, 189, 3, 43, "Input"],
Cell[40677, 1377, 182, 3, 43, "Input"],
Cell[40862, 1382, 144, 2, 27, "Input"],
Cell[41009, 1386, 248, 3, 59, "Input"],
Cell[41260, 1391, 204, 3, 59, "Input"],
Cell[41467, 1396, 179, 3, 43, "Input"],
Cell[41649, 1401, 60, 1, 27, "Input"],
Cell[41712, 1404, 56, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41805, 1410, 112, 2, 61, "Section",
  CellTags->"T1.3.1"],
Cell[41920, 1414, 798, 24, 32, "Text"],
Cell[42721, 1440, 57, 1, 27, "Input"],
Cell[42781, 1443, 117, 2, 43, "Input"],
Cell[42901, 1447, 73, 0, 32, "Text"],
Cell[42977, 1449, 61, 1, 27, "Input"],
Cell[43041, 1452, 115, 3, 32, "Text"],
Cell[43159, 1457, 58, 1, 27, "Input"],
Cell[43220, 1460, 754, 24, 32, "Text"],

Cell[CellGroupData[{
Cell[43999, 1488, 63, 1, 45, "Subsection",
  CellTags->"T1.3.1.1"],
Cell[44065, 1491, 60, 1, 27, "Input"],
Cell[44128, 1494, 265, 5, 43, "Input"],
Cell[44396, 1501, 265, 5, 43, "Input"],
Cell[44664, 1508, 174, 3, 27, "Input"],
Cell[44841, 1513, 115, 3, 32, "Text"],
Cell[44959, 1518, 213, 4, 43, "Input"],
Cell[45175, 1524, 208, 4, 27, "Input"],
Cell[45386, 1530, 225, 4, 27, "Input"],
Cell[45614, 1536, 256, 5, 27, "Input"],
Cell[45873, 1543, 146, 2, 27, "Input"],
Cell[46022, 1547, 163, 2, 27, "Input"],
Cell[46188, 1551, 205, 4, 27, "Input"],
Cell[46396, 1557, 182, 3, 27, "Input"],
Cell[46581, 1562, 513, 13, 117, "Input"],
Cell[47097, 1577, 108, 2, 27, "Input"],
Cell[47208, 1581, 108, 2, 27, "Input"],
Cell[47319, 1585, 108, 2, 27, "Input"],
Cell[47430, 1589, 108, 2, 27, "Input"],
Cell[47541, 1593, 108, 2, 27, "Input"],
Cell[47652, 1597, 76, 1, 27, "Input"],
Cell[47731, 1600, 79, 1, 27, "Input"],
Cell[47813, 1603, 119, 2, 27, "Input"],
Cell[47935, 1607, 311, 7, 27, "Input"],
Cell[48249, 1616, 154, 3, 27, "Input"],
Cell[48406, 1621, 179, 3, 27, "Input"],
Cell[48588, 1626, 119, 2, 27, "Input"],
Cell[48710, 1630, 154, 3, 27, "Input"],
Cell[48867, 1635, 311, 7, 27, "Input"],
Cell[49181, 1644, 596, 11, 75, "Input"],
Cell[49780, 1657, 686, 12, 75, "Input"],
Cell[50469, 1671, 621, 12, 75, "Input"],
Cell[51093, 1685, 702, 13, 91, "Input"],
Cell[51798, 1700, 202, 3, 27, "Input"],
Cell[52003, 1705, 728, 13, 91, "Input"],
Cell[52734, 1720, 619, 11, 75, "Input"],
Cell[53356, 1733, 426, 8, 59, "Input"],
Cell[53785, 1743, 619, 11, 75, "Input"],
Cell[54407, 1756, 172, 3, 27, "Input"],
Cell[54582, 1761, 426, 8, 59, "Input"],
Cell[55011, 1771, 550, 10, 75, "Input"],
Cell[55564, 1783, 135, 2, 27, "Input"],
Cell[55702, 1787, 546, 10, 75, "Input"],
Cell[56251, 1799, 108, 2, 27, "Input"],
Cell[56362, 1803, 107, 3, 50, "Text"],
Cell[56472, 1808, 630, 11, 75, "Input"],
Cell[57105, 1821, 628, 11, 75, "Input"],
Cell[57736, 1834, 624, 12, 75, "Input"],
Cell[58363, 1848, 707, 13, 91, "Input"],
Cell[59073, 1863, 733, 13, 91, "Input"],
Cell[59809, 1878, 637, 12, 75, "Input"],
Cell[60449, 1892, 428, 8, 59, "Input"],
Cell[60880, 1902, 553, 10, 75, "Input"],
Cell[61436, 1914, 549, 10, 75, "Input"],
Cell[61988, 1926, 627, 11, 75, "Input"],
Cell[62618, 1939, 625, 11, 75, "Input"],
Cell[63246, 1952, 621, 12, 75, "Input"],
Cell[63870, 1966, 702, 13, 91, "Input"],
Cell[64575, 1981, 728, 13, 91, "Input"],
Cell[65306, 1996, 619, 11, 75, "Input"],
Cell[65928, 2009, 426, 8, 59, "Input"],
Cell[66357, 2019, 550, 10, 75, "Input"],
Cell[66910, 2031, 546, 10, 75, "Input"],
Cell[67459, 2043, 115, 2, 27, "Input"],
Cell[67577, 2047, 115, 2, 27, "Input"],
Cell[67695, 2051, 115, 2, 27, "Input"],
Cell[67813, 2055, 115, 2, 27, "Input"],
Cell[67931, 2059, 115, 2, 27, "Input"],
Cell[68049, 2063, 133, 2, 31, "Input"],
Cell[68185, 2067, 121, 2, 27, "Input"],
Cell[68309, 2071, 214, 4, 27, "Input"],
Cell[68526, 2077, 111, 2, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[68674, 2084, 58, 1, 45, "Subsection",
  CellTags->"T1.3.2.1"],
Cell[68735, 2087, 4534, 78, 1051, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[73306, 2170, 59, 1, 45, "Subsection",
  CellTags->"T1.3.3.1"],
Cell[73368, 2173, 571, 10, 138, "Input"],
Cell[73942, 2185, 571, 10, 138, "Input"],
Cell[74516, 2197, 571, 10, 138, "Input"],
Cell[75090, 2209, 571, 10, 138, "Input"],
Cell[75664, 2221, 571, 10, 138, "Input"],
Cell[76238, 2233, 571, 10, 138, "Input"],
Cell[76812, 2245, 571, 10, 138, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77420, 2260, 60, 1, 45, "Subsection",
  CellTags->"T1.3.4.1"],
Cell[77483, 2263, 685, 14, 91, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78205, 2282, 54, 1, 45, "Subsection",
  CellTags->"T1.3.5.1"],
Cell[78262, 2285, 129, 3, 42, "Input"],
Cell[78394, 2290, 2277, 41, 363, "Input"],
Cell[80674, 2333, 193, 3, 43, "Input"],
Cell[80870, 2338, 306, 9, 29, "Text"],
Cell[81179, 2349, 2024, 34, 310, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[83240, 2388, 59, 1, 45, "Subsection",
  CellTags->"T1.3.6.1"],
Cell[83302, 2391, 486, 9, 107, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[83825, 2405, 50, 1, 45, "Subsection",
  CellTags->"T1.3.7.1"],
Cell[83878, 2408, 87, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[83990, 2413, 57, 1, 42, "Subsubsection",
  CellTags->"T1.3.7.1.1"],
Cell[84050, 2416, 779, 28, 40, "Text"],
Cell[84832, 2446, 217, 4, 27, "Input"],
Cell[85052, 2452, 154, 3, 27, "Input"],
Cell[85209, 2457, 156, 3, 27, "Input"],
Cell[85368, 2462, 160, 3, 27, "Input"],
Cell[85531, 2467, 150, 3, 27, "Input"],
Cell[85684, 2472, 158, 3, 27, "Input"],
Cell[85845, 2477, 148, 3, 27, "Input"],
Cell[85996, 2482, 148, 3, 27, "Input"],
Cell[86147, 2487, 156, 3, 27, "Input"],
Cell[86306, 2492, 152, 3, 27, "Input"],
Cell[86461, 2497, 132, 2, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[86630, 2504, 53, 1, 42, "Subsubsection",
  CellTags->"T1.3.7.2.1"],
Cell[86686, 2507, 71, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[86794, 2513, 54, 1, 42, "Subsubsection",
  CellTags->"T1.3.7.3.1"],
Cell[86851, 2516, 51, 1, 27, "Input"],
Cell[86905, 2519, 72, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87014, 2525, 58, 1, 42, "Subsubsection",
  CellTags->"T1.3.7.4.1"],
Cell[87075, 2528, 74, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87186, 2534, 54, 1, 42, "Subsubsection",
  CellTags->"T1.3.7.5.1"],
Cell[87243, 2537, 3526, 79, 1182, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[90806, 2621, 54, 1, 42, "Subsubsection",
  CellTags->"T1.3.7.6.1"],
Cell[90863, 2624, 375, 7, 59, "Input"],
Cell[91241, 2633, 72, 1, 27, "Input"],
Cell[91316, 2636, 74, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[91427, 2642, 54, 1, 42, "Subsubsection",
  CellTags->"T1.3.7.7.1"],
Cell[91484, 2645, 590, 14, 43, "Input"],
Cell[92077, 2661, 66, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[92180, 2667, 54, 1, 42, "Subsubsection",
  CellTags->"T1.3.7.8.1"],
Cell[92237, 2670, 215, 6, 27, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[92513, 2683, 104, 2, 61, "Section",
  CellTags->"T1.4.1"],
Cell[92620, 2687, 574, 11, 99, "Input"],
Cell[93197, 2700, 923, 15, 187, "Input"],
Cell[94123, 2717, 136, 4, 32, "Text"],
Cell[94262, 2723, 147, 2, 28, "Input"],
Cell[94412, 2727, 61, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[94498, 2732, 116, 3, 45, "Subsection",
  CellTags->"T1.4.1.1"],
Cell[94617, 2737, 213, 6, 27, "Input"],
Cell[94833, 2745, 72, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[94942, 2751, 114, 3, 45, "Subsection",
  CellTags->"T1.4.2.1"],
Cell[95059, 2756, 113, 5, 33, "Text"],
Cell[95175, 2763, 1952, 52, 48, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[97164, 2820, 205, 6, 45, "Subsection",
  CellTags->"T1.4.3.1"],
Cell[97372, 2828, 2381, 57, 50, "Input"],
Cell[99756, 2887, 157, 4, 27, "Input"],
Cell[99916, 2893, 1123, 24, 66, "Input"],
Cell[101042, 2919, 772, 19, 49, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[101851, 2943, 223, 6, 61, "Subsection",
  CellTags->"T1.4.4.1"],
Cell[102077, 2951, 3158, 73, 70, "Input"],
Cell[105238, 3026, 2826, 70, 87, "Input"],
Cell[108067, 3098, 2826, 70, 87, "Input"],
Cell[110896, 3170, 2826, 70, 87, "Input"],
Cell[113725, 3242, 157, 4, 27, "Input"],
Cell[113885, 3248, 157, 4, 27, "Input"],
Cell[114045, 3254, 143, 4, 27, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114237, 3264, 97, 2, 61, "Section",
  CellTags->"T1.5.1"],

Cell[CellGroupData[{
Cell[114359, 3270, 65, 1, 45, "Subsection",
  CellTags->"T1.5.1.1"],
Cell[114427, 3273, 131, 3, 50, "Text"],
Cell[114561, 3278, 67, 0, 32, "Text"],
Cell[114631, 3280, 154, 5, 32, "Text"],
Cell[114788, 3287, 1236, 21, 91, "Input"],
Cell[116027, 3310, 1328, 22, 91, "Input"],
Cell[117358, 3334, 105, 2, 27, "Input"],
Cell[117466, 3338, 87, 1, 27, "Input"],
Cell[117556, 3341, 120, 2, 27, "Input"],
Cell[117679, 3345, 111, 2, 27, "Input"],
Cell[117793, 3349, 87, 1, 27, "Input"],
Cell[117883, 3352, 129, 2, 27, "Input"],
Cell[118015, 3356, 71, 1, 33, "Input"],
Cell[118089, 3359, 59, 0, 27, "Input"],
Cell[118151, 3361, 78, 1, 27, "Input"],
Cell[118232, 3364, 78, 1, 27, "Input"],
Cell[118313, 3367, 79, 1, 27, "Input"],
Cell[118395, 3370, 92, 1, 27, "Input"],
Cell[118490, 3373, 80, 1, 27, "Input"],
Cell[118573, 3376, 80, 1, 27, "Input"],
Cell[118656, 3379, 694, 11, 59, "Input"],
Cell[119353, 3392, 51, 1, 27, "Input"],
Cell[119407, 3395, 191, 4, 27, "Input"],
Cell[119601, 3401, 79, 1, 27, "Input"],
Cell[119683, 3404, 76, 0, 32, "Text"],
Cell[119762, 3406, 202, 6, 27, "Input"],
Cell[119967, 3414, 152, 4, 27, "Input"],
Cell[120122, 3420, 9785, 176, 316, "Input"],
Cell[129910, 3598, 9131, 163, 316, "Input"],
Cell[139044, 3763, 12045, 216, 363, "Input"],
Cell[151092, 3981, 11116, 201, 295, "Input"],
Cell[162211, 4184, 10160, 183, 360, "Input"],
Cell[172374, 4369, 68, 1, 27, "Input"],
Cell[172445, 4372, 804, 19, 59, "Input"],
Cell[173252, 4393, 753, 19, 43, "Input"],
Cell[174008, 4414, 753, 19, 43, "Input"],

Cell[CellGroupData[{
Cell[174786, 4437, 62, 1, 42, "Subsubsection",
  CellTags->"T1.5.1.1.1"],
Cell[174851, 4440, 2700, 62, 123, "Input"],
Cell[177554, 4504, 151, 2, 27, "Input"],
Cell[177708, 4508, 143, 2, 27, "Input"],
Cell[177854, 4512, 153, 2, 27, "Input"],
Cell[178010, 4516, 183, 3, 27, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[178242, 4525, 59, 1, 45, "Subsection",
  CellTags->"T1.5.2.1"],
Cell[178304, 4528, 1252, 20, 231, "Input"],

Cell[CellGroupData[{
Cell[179581, 4552, 53, 1, 42, "Subsubsection",
  CellTags->"T1.5.2.1.1"],
Cell[179637, 4555, 132, 2, 27, "Input"],
Cell[179772, 4559, 143, 2, 27, "Input"],
Cell[179918, 4563, 135, 3, 27, "Input"],
Cell[180056, 4568, 251, 9, 33, "Text"],
Cell[180310, 4579, 20, 0, 32, "Text"],
Cell[180333, 4581, 1281, 26, 86, "Input"],
Cell[181617, 4609, 20, 0, 32, "Text"],
Cell[181640, 4611, 759, 12, 86, "Input"],
Cell[182402, 4625, 20, 0, 32, "Text"],
Cell[182425, 4627, 552, 10, 48, "Input"],
Cell[182980, 4639, 20, 0, 32, "Text"],
Cell[183003, 4641, 549, 9, 62, "Input"],
Cell[183555, 4652, 20, 0, 32, "Text"],
Cell[183578, 4654, 799, 14, 81, "Input"],
Cell[184380, 4670, 20, 0, 32, "Text"],
Cell[184403, 4672, 1130, 24, 85, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[185582, 4702, 60, 1, 45, "Subsection",
  CellTags->"T1.5.3.1"],
Cell[185645, 4705, 176, 4, 32, "Text"],
Cell[185824, 4711, 139, 3, 50, "Text"],

Cell[CellGroupData[{
Cell[185988, 4718, 68, 1, 42, "Subsubsection",
  CellTags->"T1.5.3.1.1"],
Cell[186059, 4721, 369, 8, 71, "Input"],
Cell[186431, 4731, 781, 13, 161, "Input"],
Cell[187215, 4746, 1806, 32, 337, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[189058, 4783, 68, 1, 42, "Subsubsection",
  CellTags->"T1.5.3.2.1"],
Cell[189129, 4786, 304, 6, 71, "Input"],
Cell[189436, 4794, 185, 3, 43, "Input"],
Cell[189624, 4799, 62, 1, 27, "Input"],
Cell[189689, 4802, 1780, 33, 353, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[191530, 4842, 140, 2, 61, "Section",
  CellTags->"T1.6.1"],
Cell[191673, 4846, 148, 2, 27, "Input"],
Cell[191824, 4850, 272, 7, 50, "Text"],

Cell[CellGroupData[{
Cell[192121, 4861, 56, 1, 45, "Subsection",
  CellTags->"T1.6.1.1"],
Cell[192180, 4864, 77, 4, 32, "Text"],
Cell[192260, 4870, 7368, 171, 71, "Input"],
Cell[199631, 5043, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[199730, 5049, 58, 1, 45, "Subsection",
  CellTags->"T1.6.2.1"],
Cell[199791, 5052, 81, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[199897, 5057, 139, 5, 42, "Subsubsection",
  CellTags->"T1.6.2.1.1"],
Cell[200039, 5064, 1088, 28, 36, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[201164, 5097, 139, 5, 42, "Subsubsection",
  CellTags->"T1.6.2.2.1"],
Cell[201306, 5104, 1160, 29, 36, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[202503, 5138, 139, 5, 42, "Subsubsection",
  CellTags->"T1.6.2.3.1"],
Cell[202645, 5145, 1160, 29, 36, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[203842, 5179, 139, 5, 42, "Subsubsection",
  CellTags->"T1.6.2.4.1"],
Cell[203984, 5186, 1160, 29, 36, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[205193, 5221, 58, 1, 45, "Subsection",
  CellTags->"T1.6.3.1"],
Cell[205254, 5224, 73, 1, 27, "Input"],
Cell[205330, 5227, 134, 2, 29, "Text"],
Cell[205467, 5231, 3415, 89, 32, "Input"],
Cell[208885, 5322, 66, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[208988, 5328, 159, 5, 45, "Subsection",
  CellTags->"T1.6.4.1"],
Cell[209150, 5335, 50, 1, 27, "Input"],
Cell[209203, 5338, 393, 9, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[209633, 5352, 58, 1, 45, "Subsection",
  CellTags->"T1.6.5.1"],
Cell[209694, 5355, 73, 1, 27, "Input"],
Cell[209770, 5358, 134, 2, 29, "Text"],
Cell[209907, 5362, 3415, 89, 32, "Input"],
Cell[213325, 5453, 66, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[213428, 5459, 159, 5, 45, "Subsection",
  CellTags->"T1.6.6.1"],
Cell[213590, 5466, 50, 1, 27, "Input"],
Cell[213643, 5469, 393, 9, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[214073, 5483, 159, 5, 45, "Subsection",
  CellTags->"T1.6.7.1"],
Cell[214235, 5490, 62, 1, 27, "Input"],
Cell[214300, 5493, 127, 3, 27, "Input"],
Cell[214430, 5498, 393, 9, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[214860, 5512, 159, 5, 45, "Subsection",
  CellTags->"T1.6.8.1"],
Cell[215022, 5519, 62, 1, 27, "Input"],
Cell[215087, 5522, 127, 3, 27, "Input"],
Cell[215217, 5527, 393, 9, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[215647, 5541, 56, 1, 45, "Subsection",
  CellTags->"T1.6.9.1"],
Cell[215706, 5544, 77, 4, 32, "Text"],
Cell[215786, 5550, 6612, 152, 71, "Input"],
Cell[222401, 5704, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[222500, 5710, 59, 1, 45, "Subsection",
  CellTags->"T1.6.10.1"],
Cell[222562, 5713, 79, 1, 27, "Input"],
Cell[222644, 5716, 1084, 28, 36, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[223765, 5749, 57, 1, 45, "Subsection",
  CellTags->"T1.6.11.1"],
Cell[223825, 5752, 454, 20, 32, "Text"],
Cell[224282, 5774, 3684, 95, 32, "Input"],
Cell[227969, 5871, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[228068, 5877, 57, 1, 45, "Subsection",
  CellTags->"T1.6.12.1"],
Cell[228128, 5880, 454, 20, 32, "Text"],
Cell[228585, 5902, 3684, 95, 32, "Input"],
Cell[232272, 5999, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[232371, 6005, 57, 1, 45, "Subsection",
  CellTags->"T1.6.13.1"],
Cell[232431, 6008, 7313, 170, 71, "Input"],
Cell[239747, 6180, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[239846, 6186, 68, 1, 45, "Subsection",
  CellTags->"T1.6.14.1"],
Cell[239917, 6189, 201, 4, 27, "Input"],
Cell[240121, 6195, 105, 2, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[240263, 6202, 59, 1, 45, "Subsection",
  CellTags->"T1.6.15.1"],
Cell[240325, 6205, 22655, 536, 8022, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[263017, 6746, 57, 1, 45, "Subsection",
  CellTags->"T1.6.16.1"],
Cell[263077, 6749, 77, 4, 32, "Text"],
Cell[263157, 6755, 3791, 96, 32, "Input"],
Cell[266951, 6853, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[267050, 6859, 59, 1, 45, "Subsection",
  CellTags->"T1.6.17.1"],
Cell[267112, 6862, 38, 1, 27, "Input"],
Cell[267153, 6865, 79, 1, 27, "Input"],
Cell[267235, 6868, 401, 10, 27, "Input"],

Cell[CellGroupData[{
Cell[267661, 6882, 57, 1, 27, "Input"],
Cell[267721, 6885, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[267825, 6892, 57, 1, 45, "Subsection",
  CellTags->"T1.6.18.1"],
Cell[267885, 6895, 77, 4, 32, "Text"],
Cell[267965, 6901, 5270, 131, 71, "Input"],
Cell[273238, 7034, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[273337, 7040, 59, 1, 45, "Subsection",
  CellTags->"T1.6.19.1"],
Cell[273399, 7043, 105, 2, 27, "Input"],
Cell[273507, 7047, 401, 10, 27, "Input"],

Cell[CellGroupData[{
Cell[273933, 7061, 57, 1, 27, "Input"],
Cell[273993, 7064, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[274097, 7071, 59, 1, 45, "Subsection",
  CellTags->"T1.6.20.1"],
Cell[274159, 7074, 133, 3, 27, "Input"],
Cell[274295, 7079, 401, 10, 27, "Input"],

Cell[CellGroupData[{
Cell[274721, 7093, 57, 1, 27, "Input"],
Cell[274781, 7096, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[274885, 7103, 57, 1, 45, "Subsection",
  CellTags->"T1.6.21.1"],
Cell[274945, 7106, 77, 4, 32, "Text"],
Cell[275025, 7112, 3179, 83, 54, "Input"],
Cell[278207, 7197, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[278306, 7203, 59, 1, 45, "Subsection",
  CellTags->"T1.6.22.1"],
Cell[278368, 7206, 79, 1, 27, "Input"],
Cell[278450, 7209, 369, 9, 27, "Input"],

Cell[CellGroupData[{
Cell[278844, 7222, 57, 1, 27, "Input"],
Cell[278904, 7225, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[279008, 7232, 57, 1, 45, "Subsection",
  CellTags->"T1.6.23.1"],
Cell[279068, 7235, 77, 4, 32, "Text"],
Cell[279148, 7241, 3892, 100, 54, "Input"],
Cell[283043, 7343, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[283142, 7349, 59, 1, 45, "Subsection",
  CellTags->"T1.6.24.1"],
Cell[283204, 7352, 79, 1, 27, "Input"],
Cell[283286, 7355, 393, 10, 27, "Input"],

Cell[CellGroupData[{
Cell[283704, 7369, 57, 1, 27, "Input"],
Cell[283764, 7372, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[283868, 7379, 57, 1, 45, "Subsection",
  CellTags->"T1.6.25.1"],
Cell[283928, 7382, 77, 4, 32, "Text"],
Cell[284008, 7388, 3447, 89, 54, "Input"],
Cell[287458, 7479, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[287557, 7485, 59, 1, 45, "Subsection",
  CellTags->"T1.6.26.1"],
Cell[287619, 7488, 79, 1, 27, "Input"],
Cell[287701, 7491, 399, 10, 27, "Input"],

Cell[CellGroupData[{
Cell[288125, 7505, 57, 1, 27, "Input"],
Cell[288185, 7508, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[288289, 7515, 57, 1, 45, "Subsection",
  CellTags->"T1.6.27.1"],
Cell[288349, 7518, 169, 7, 32, "Text"],
Cell[288521, 7527, 5043, 126, 96, "Input"],
Cell[293567, 7655, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[293666, 7661, 59, 1, 45, "Subsection",
  CellTags->"T1.6.28.1"],
Cell[293728, 7664, 46, 1, 27, "Input"],
Cell[293777, 7667, 773, 16, 85, "Input"],
Cell[294553, 7685, 50, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[294640, 7690, 58, 1, 45, "Subsection",
  CellTags->"T1.6.29.1"],
Cell[294701, 7693, 77, 4, 32, "Text"],
Cell[294781, 7699, 3179, 83, 54, "Input"],
Cell[297963, 7784, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[298062, 7790, 59, 1, 45, "Subsection",
  CellTags->"T1.6.30.1"],
Cell[298124, 7793, 79, 1, 27, "Input"],
Cell[298206, 7796, 376, 9, 29, "Input"],

Cell[CellGroupData[{
Cell[298607, 7809, 69, 1, 29, "Input"],
Cell[298679, 7812, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[298783, 7819, 58, 1, 45, "Subsection",
  CellTags->"T1.6.31.1"],
Cell[298844, 7822, 292, 14, 32, "Text"],
Cell[299139, 7838, 2494, 68, 32, "Input"],
Cell[301636, 7908, 62, 1, 27, "Input"],
Cell[301701, 7911, 2268, 66, 52, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[304006, 7982, 59, 1, 45, "Subsection",
  CellTags->"T1.6.32.1"],
Cell[304068, 7985, 291, 14, 32, "Text"],
Cell[304362, 8001, 46, 1, 27, "Input"],
Cell[304411, 8004, 117, 3, 27, "SmallText"],
Cell[304531, 8009, 663, 18, 25, "SmallText"],
Cell[305197, 8029, 621, 17, 27, "Input"],
Cell[305821, 8048, 50, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[305908, 8053, 61, 1, 45, "Subsection",
  CellTags->"T1.6.33.1"],
Cell[305972, 8056, 291, 14, 32, "Text"],
Cell[306266, 8072, 84, 1, 27, "Input"],
Cell[306353, 8075, 117, 3, 27, "SmallText"],
Cell[306473, 8080, 669, 18, 25, "SmallText"],
Cell[307145, 8100, 627, 17, 27, "Input"],
Cell[307775, 8119, 50, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[307862, 8124, 58, 1, 45, "Subsection",
  CellTags->"T1.6.34.1"],
Cell[307923, 8127, 394, 17, 50, "Text"],
Cell[308320, 8146, 5065, 127, 95, "Input"],
Cell[313388, 8275, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[313487, 8281, 59, 1, 45, "Subsection",
  CellTags->"T1.6.35.1"],
Cell[313549, 8284, 105, 2, 27, "Input"],
Cell[313657, 8288, 1002, 27, 31, "Input"],
Cell[314662, 8317, 50, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[314749, 8322, 58, 1, 45, "Subsection",
  CellTags->"T1.6.36.1"],
Cell[314810, 8325, 209, 7, 50, "Text"],
Cell[315022, 8334, 6354, 147, 75, "Input"],
Cell[321379, 8483, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[321478, 8489, 59, 1, 45, "Subsection",
  CellTags->"T1.6.37.1"],
Cell[321540, 8492, 178, 7, 32, "Text"],
Cell[321721, 8501, 61, 1, 27, "Input"],
Cell[321785, 8504, 563, 14, 27, "Input"],

Cell[CellGroupData[{
Cell[322373, 8522, 57, 1, 27, "Input"],
Cell[322433, 8525, 55, 1, 24, "Print"]
}, Open  ]],
Cell[322503, 8529, 643, 16, 27, "Input"],
Cell[323149, 8547, 106, 5, 86, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[323292, 8557, 61, 1, 45, "Subsection",
  CellTags->"T1.6.38.1"],
Cell[323356, 8560, 111, 2, 27, "Input"],
Cell[323470, 8564, 425, 11, 27, "Input"],
Cell[323898, 8577, 50, 1, 27, "Input"],
Cell[323951, 8580, 76, 1, 27, "Input"],
Cell[324030, 8583, 52, 1, 27, "Input"],
Cell[324085, 8586, 128, 2, 27, "Input"],
Cell[324216, 8590, 816, 18, 31, "Input"],
Cell[325035, 8610, 50, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[325122, 8615, 61, 1, 45, "Subsection",
  CellTags->"T1.6.39.1"],
Cell[325186, 8618, 111, 2, 27, "Input"],
Cell[325300, 8622, 66, 1, 27, "Input"],
Cell[325369, 8625, 52, 1, 27, "Input"],
Cell[325424, 8628, 128, 2, 27, "Input"],
Cell[325555, 8632, 555, 12, 31, "Input"],
Cell[326113, 8646, 50, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[326200, 8651, 61, 1, 45, "Subsection",
  CellTags->"T1.6.40.1"],
Cell[326264, 8654, 141, 2, 27, "Input"],
Cell[326408, 8658, 128, 2, 27, "Input"],
Cell[326539, 8662, 417, 10, 27, "Input"],
Cell[326959, 8674, 50, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[327046, 8679, 58, 1, 45, "Subsection",
  CellTags->"T1.6.41.1"],
Cell[327107, 8682, 77, 4, 32, "Text"],
Cell[327187, 8688, 4873, 123, 54, "Input"],
Cell[332063, 8813, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[332162, 8819, 59, 1, 45, "Subsection",
  CellTags->"T1.6.42.1"],
Cell[332224, 8822, 162, 3, 27, "Input"],
Cell[332389, 8827, 460, 11, 27, "Input"],

Cell[CellGroupData[{
Cell[332874, 8842, 57, 1, 27, "Input"],
Cell[332934, 8845, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[333038, 8852, 68, 1, 45, "Subsection",
  CellTags->"T1.6.43.1"],
Cell[333109, 8855, 111, 3, 32, "Text"],
Cell[333223, 8860, 77, 4, 32, "Text"],
Cell[333303, 8866, 5395, 138, 54, "Input"],
Cell[338701, 9006, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[338800, 9012, 57, 1, 45, "Subsection",
  CellTags->"T1.6.44.1"],
Cell[338860, 9015, 77, 4, 32, "Text"],
Cell[338940, 9021, 4938, 127, 54, "Input"],
Cell[343881, 9150, 9473, 263, 56, "Text"],
Cell[353357, 9415, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[353456, 9421, 59, 1, 45, "Subsection",
  CellTags->"T1.6.45.1"],
Cell[353518, 9424, 132, 3, 27, "Input"],
Cell[353653, 9429, 444, 11, 27, "Input"],

Cell[CellGroupData[{
Cell[354122, 9444, 57, 1, 27, "Input"],
Cell[354182, 9447, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[354286, 9454, 61, 1, 45, "Subsection",
  CellTags->"T1.6.46.1"],
Cell[354350, 9457, 194, 5, 27, "Input"],
Cell[354547, 9464, 450, 11, 27, "Input"],

Cell[CellGroupData[{
Cell[355022, 9479, 59, 1, 27, "Input"],
Cell[355084, 9482, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[355188, 9489, 57, 1, 45, "Subsection",
  CellTags->"T1.6.47.1"],
Cell[355248, 9492, 77, 4, 32, "Text"],
Cell[355328, 9498, 5742, 138, 74, "Input"],
Cell[361073, 9638, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[361172, 9644, 59, 1, 45, "Subsection",
  CellTags->"T1.6.48.1"],
Cell[361234, 9647, 132, 3, 27, "Input"],
Cell[361369, 9652, 456, 11, 27, "Input"],

Cell[CellGroupData[{
Cell[361850, 9667, 57, 1, 27, "Input"],
Cell[361910, 9670, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[362014, 9677, 61, 1, 45, "Subsection",
  CellTags->"T1.6.49.1"],
Cell[362078, 9680, 194, 5, 27, "Input"],
Cell[362275, 9687, 466, 11, 27, "Input"],

Cell[CellGroupData[{
Cell[362766, 9702, 59, 1, 27, "Input"],
Cell[362828, 9705, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[362932, 9712, 57, 1, 45, "Subsection",
  CellTags->"T1.6.50.1"],
Cell[362992, 9715, 77, 4, 32, "Text"],
Cell[363072, 9721, 12332, 293, 155, "Input"],
Cell[375407, 10016, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[375506, 10022, 59, 1, 45, "Subsection",
  CellTags->"T1.6.51.1"],
Cell[375568, 10025, 46, 1, 27, "Input"],
Cell[375617, 10028, 432, 11, 27, "Input"],
Cell[376052, 10041, 104, 3, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[376193, 10049, 57, 1, 45, "Subsection",
  CellTags->"T1.6.52.1"],
Cell[376253, 10052, 157, 7, 32, "Text"],
Cell[376413, 10061, 5042, 126, 84, "Input"],
Cell[381458, 10189, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[381557, 10195, 59, 1, 45, "Subsection",
  CellTags->"T1.6.53.1"],
Cell[381619, 10198, 147, 3, 27, "Input"],
Cell[381769, 10203, 142, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[381936, 10210, 57, 1, 27, "Input"],
Cell[381996, 10213, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[382100, 10220, 61, 1, 45, "Subsection",
  CellTags->"T1.6.54.1"],
Cell[382164, 10223, 172, 3, 27, "Input"],
Cell[382339, 10228, 148, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[382512, 10235, 59, 1, 27, "Input"],
Cell[382574, 10238, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[382678, 10245, 61, 1, 45, "Subsection",
  CellTags->"T1.6.55.1"],
Cell[382742, 10248, 172, 3, 27, "Input"],
Cell[382917, 10253, 148, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[383090, 10260, 59, 1, 27, "Input"],
Cell[383152, 10263, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[383256, 10270, 57, 1, 45, "Subsection",
  CellTags->"T1.6.56.1"],
Cell[383316, 10273, 147, 7, 32, "Text"],
Cell[383466, 10282, 5562, 141, 74, "Input"],
Cell[389031, 10425, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[389130, 10431, 59, 1, 45, "Subsection",
  CellTags->"T1.6.57.1"],
Cell[389192, 10434, 89, 1, 27, "Input"],
Cell[389284, 10437, 142, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[389451, 10444, 57, 1, 27, "Input"],
Cell[389511, 10447, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[389615, 10454, 57, 1, 45, "Subsection",
  CellTags->"T1.6.58.1"],
Cell[389675, 10457, 138, 6, 32, "Text"],
Cell[389816, 10465, 4317, 107, 95, "Input"],
Cell[394136, 10574, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[394235, 10580, 59, 1, 45, "Subsection",
  CellTags->"T1.6.59.1"],
Cell[394297, 10583, 105, 2, 27, "Input"],
Cell[394405, 10587, 158, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[394588, 10595, 57, 1, 27, "Input"],
Cell[394648, 10598, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[394752, 10605, 57, 1, 45, "Subsection",
  CellTags->"T1.6.60.1"],
Cell[394812, 10608, 156, 7, 32, "Text"],
Cell[394971, 10617, 4817, 120, 91, "Input"],
Cell[399791, 10739, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[399890, 10745, 59, 1, 45, "Subsection",
  CellTags->"T1.6.61.1"],
Cell[399952, 10748, 169, 3, 27, "Input"],
Cell[400124, 10753, 185, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[400334, 10761, 57, 1, 27, "Input"],
Cell[400394, 10764, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[400498, 10771, 61, 1, 45, "Subsection",
  CellTags->"T1.6.62.1"],
Cell[400562, 10774, 194, 3, 27, "Input"],
Cell[400759, 10779, 191, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[400975, 10787, 59, 1, 27, "Input"],
Cell[401037, 10790, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[401141, 10797, 61, 1, 45, "Subsection",
  CellTags->"T1.6.63.1"],
Cell[401205, 10800, 218, 4, 27, "Input"],
Cell[401426, 10806, 191, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[401642, 10814, 59, 1, 27, "Input"],
Cell[401704, 10817, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[401808, 10824, 57, 1, 45, "Subsection",
  CellTags->"T1.6.64.1"],
Cell[401868, 10827, 146, 7, 32, "Text"],
Cell[402017, 10836, 10108, 237, 173, "Input"],
Cell[412128, 11075, 62, 1, 27, "Input"],
Cell[412193, 11078, 50, 1, 27, "Input"],
Cell[412246, 11081, 127, 2, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[412410, 11088, 59, 1, 45, "Subsection",
  CellTags->"T1.6.65.1"],
Cell[412472, 11091, 116, 2, 27, "Input"],
Cell[412591, 11095, 185, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[412801, 11103, 57, 1, 27, "Input"],
Cell[412861, 11106, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[412965, 11113, 61, 1, 45, "Subsection",
  CellTags->"T1.6.66.1"],
Cell[413029, 11116, 152, 3, 27, "Input"],
Cell[413184, 11121, 191, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[413400, 11129, 59, 1, 27, "Input"],
Cell[413462, 11132, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[413566, 11139, 61, 1, 45, "Subsection",
  CellTags->"T1.6.67.1"],
Cell[413630, 11142, 152, 3, 27, "Input"],
Cell[413785, 11147, 191, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[414001, 11155, 59, 1, 27, "Input"],
Cell[414063, 11158, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[414167, 11165, 57, 1, 45, "Subsection",
  CellTags->"T1.6.68.1"],
Cell[414227, 11168, 138, 6, 32, "Text"],
Cell[414368, 11176, 6617, 157, 97, "Input"],
Cell[420988, 11335, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[421087, 11341, 59, 1, 45, "Subsection",
  CellTags->"T1.6.69.1"],
Cell[421149, 11344, 116, 2, 27, "Input"],
Cell[421268, 11348, 178, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[421471, 11356, 57, 1, 27, "Input"],
Cell[421531, 11359, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[421635, 11366, 57, 1, 45, "Subsection",
  CellTags->"T1.6.70.1"],

Cell[CellGroupData[{
Cell[421717, 11371, 56, 1, 42, "Subsubsection",
  CellTags->"T1.6.70.1.1"],
Cell[421776, 11374, 72, 1, 29, "Input"],
Cell[421851, 11377, 193, 4, 31, "Input"],
Cell[422047, 11383, 269, 4, 31, "Input"],
Cell[422319, 11389, 941, 24, 48, "Input"],
Cell[423263, 11415, 83, 1, 31, "Input"],
Cell[423349, 11418, 83, 1, 31, "Input"],
Cell[423435, 11421, 83, 1, 31, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[423555, 11427, 56, 1, 42, "Subsubsection",
  CellTags->"T1.6.70.2.1"],
Cell[423614, 11430, 779, 18, 44, "Input"],
Cell[424396, 11450, 83, 1, 31, "Input"],
Cell[424482, 11453, 83, 1, 31, "Input"],
Cell[424568, 11456, 83, 1, 31, "Input"],
Cell[424654, 11459, 47, 1, 27, "Input"],
Cell[424704, 11462, 85, 5, 32, "Text"],
Cell[424792, 11469, 5185, 132, 100, "Input"],
Cell[429980, 11603, 62, 1, 27, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[430091, 11610, 59, 1, 45, "Subsection",
  CellTags->"T1.6.71.1"],
Cell[430153, 11613, 46, 1, 27, "Input"],
Cell[430202, 11616, 164, 4, 27, "Input"],
Cell[430369, 11622, 49, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[430455, 11627, 57, 1, 45, "Subsection",
  CellTags->"T1.6.72.1"],
Cell[430515, 11630, 85, 5, 32, "Text"],
Cell[430603, 11637, 9126, 208, 219, "Input"],
Cell[439732, 11847, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[439831, 11853, 59, 1, 45, "Subsection",
  CellTags->"T1.6.73.1"],
Cell[439893, 11856, 51, 1, 27, "Input"],
Cell[439947, 11859, 140, 3, 27, "Input"],
Cell[440090, 11864, 49, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[440176, 11869, 57, 1, 45, "Subsection",
  CellTags->"T1.6.74.1"],
Cell[440236, 11872, 77, 4, 32, "Text"],
Cell[440316, 11878, 2490, 68, 32, "Input"],
Cell[442809, 11948, 66, 1, 27, "Input"],
Cell[442878, 11951, 2377, 65, 32, "Input"],
Cell[445258, 12018, 66, 1, 27, "Input"],
Cell[445327, 12021, 2600, 67, 32, "Input"],
Cell[447930, 12090, 66, 1, 27, "Input"],
Cell[447999, 12093, 3551, 90, 32, "Input"],
Cell[451553, 12185, 66, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[451656, 12191, 60, 1, 45, "Subsection",
  CellTags->"T1.6.75.1"],
Cell[451719, 12194, 77, 1, 27, "Input"],
Cell[451799, 12197, 160, 4, 27, "Input"],
Cell[451962, 12203, 49, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[452048, 12208, 60, 1, 45, "Subsection",
  CellTags->"T1.6.76.1"],
Cell[452111, 12211, 124, 2, 27, "Input"],
Cell[452238, 12215, 176, 4, 27, "Input"],
Cell[452417, 12221, 49, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[452503, 12226, 60, 1, 45, "Subsection",
  CellTags->"T1.6.77.1"],
Cell[452566, 12229, 49, 1, 27, "Input"],
Cell[452618, 12232, 187, 4, 27, "Input"],
Cell[452808, 12238, 49, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[452894, 12243, 60, 1, 45, "Subsection",
  CellTags->"T1.6.78.1"],
Cell[452957, 12246, 77, 1, 27, "Input"],
Cell[453037, 12249, 190, 4, 27, "Input"],
Cell[453230, 12255, 49, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[453316, 12260, 57, 1, 45, "Subsection",
  CellTags->"T1.6.79.1"],
Cell[453376, 12263, 135, 4, 32, "Text"],
Cell[453514, 12269, 66, 1, 27, "Input"],
Cell[453583, 12272, 187, 3, 30, "Text"],
Cell[453773, 12277, 4773, 114, 54, "Input"],
Cell[458549, 12393, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[458648, 12399, 57, 1, 45, "Subsection",
  CellTags->"T1.6.80.1"],
Cell[458708, 12402, 236, 6, 32, "Text"],
Cell[458947, 12410, 2101, 55, 32, "Input"],
Cell[461051, 12467, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[461150, 12473, 59, 1, 45, "Subsection",
  CellTags->"T1.6.81.1"],
Cell[461212, 12476, 74, 1, 27, "Input"],
Cell[461289, 12479, 137, 3, 27, "Input"],
Cell[461429, 12484, 49, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[461515, 12489, 57, 1, 45, "Subsection",
  CellTags->"T1.6.82.1"],
Cell[461575, 12492, 77, 4, 32, "Text"],
Cell[461655, 12498, 3018, 76, 32, "Input"],
Cell[464676, 12576, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[464775, 12582, 59, 1, 45, "Subsection",
  CellTags->"T1.6.83.1"],
Cell[464837, 12585, 74, 1, 27, "Input"],
Cell[464914, 12588, 140, 3, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[465091, 12596, 61, 1, 45, "Subsection",
  CellTags->"T1.6.84.1"],
Cell[465155, 12599, 121, 2, 27, "Input"],
Cell[465279, 12603, 90, 1, 27, "Input"],
Cell[465372, 12606, 179, 4, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[465588, 12615, 61, 1, 45, "Subsection",
  CellTags->"T1.6.85.1"],
Cell[465652, 12618, 166, 3, 27, "Input"],
Cell[465821, 12623, 90, 1, 27, "Input"],
Cell[465914, 12626, 179, 4, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[466130, 12635, 57, 1, 45, "Subsection",
  CellTags->"T1.6.86.1"],
Cell[466190, 12638, 77, 4, 32, "Text"],
Cell[466270, 12644, 2104, 59, 32, "Input"],
Cell[468377, 12705, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[468476, 12711, 59, 1, 45, "Subsection",
  CellTags->"T1.6.87.1"],
Cell[468538, 12714, 74, 1, 27, "Input"],
Cell[468615, 12717, 161, 4, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[468813, 12726, 57, 1, 45, "Subsection",
  CellTags->"T1.6.88.1"],
Cell[468873, 12729, 77, 4, 32, "Text"],
Cell[468953, 12735, 2088, 56, 32, "Input"],
Cell[471044, 12793, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[471143, 12799, 59, 1, 45, "Subsection",
  CellTags->"T1.6.89.1"],
Cell[471205, 12802, 46, 1, 27, "Input"],
Cell[471254, 12805, 141, 3, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[471432, 12813, 57, 1, 45, "Subsection",
  CellTags->"T1.6.90.1"],
Cell[471492, 12816, 77, 4, 32, "Text"],
Cell[471572, 12822, 1286, 36, 32, "Input"],
Cell[472861, 12860, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[472960, 12866, 59, 1, 45, "Subsection",
  CellTags->"T1.6.91.1"],
Cell[473022, 12869, 74, 1, 27, "Input"],
Cell[473099, 12872, 128, 3, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[473264, 12880, 57, 1, 45, "Subsection",
  CellTags->"T1.6.92.1"],
Cell[473324, 12883, 77, 4, 32, "Text"],
Cell[473404, 12889, 1144, 32, 32, "Input"],
Cell[474551, 12923, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[474650, 12929, 59, 1, 45, "Subsection",
  CellTags->"T1.6.93.1"],
Cell[474712, 12932, 46, 1, 27, "Input"],
Cell[474761, 12935, 130, 3, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[474928, 12943, 57, 1, 45, "Subsection",
  CellTags->"T1.6.94.1"],
Cell[474988, 12946, 114, 2, 28, "Text"],
Cell[475105, 12950, 1616, 44, 34, "Text"],
Cell[476724, 12996, 2050, 56, 32, "Input"],
Cell[478777, 13054, 62, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[478876, 13060, 59, 1, 45, "Subsection",
  CellTags->"T1.6.95.1"],
Cell[478938, 13063, 74, 1, 27, "Input"],
Cell[479015, 13066, 137, 3, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[479189, 13074, 61, 1, 45, "Subsection",
  CellTags->"T1.6.96.1"],
Cell[479253, 13077, 128, 3, 27, "Input"],
Cell[479384, 13082, 143, 3, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[479564, 13090, 61, 1, 45, "Subsection",
  CellTags->"T1.6.97.1"],
Cell[479628, 13093, 128, 3, 27, "Input"],
Cell[479759, 13098, 143, 3, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[479939, 13106, 58, 1, 45, "Subsection",
  CellTags->"T1.6.98.1"],
Cell[480000, 13109, 39, 0, 32, "Text"],
Cell[480042, 13111, 2876, 77, 32, "Text"],
Cell[482921, 13190, 73, 1, 28, "Text"],
Cell[482997, 13193, 3007, 83, 32, "Input"],
Cell[486007, 13278, 64, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[486108, 13284, 60, 1, 45, "Subsection",
  CellTags->"T1.6.99.1"],
Cell[486171, 13287, 48, 1, 27, "Input"],
Cell[486222, 13290, 154, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[486401, 13297, 58, 1, 27, "Input"],
Cell[486462, 13300, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[486566, 13307, 62, 1, 45, "Subsection",
  CellTags->"T1.6.100.1"],
Cell[486631, 13310, 85, 1, 27, "Input"],
Cell[486719, 13313, 157, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[486901, 13320, 59, 1, 27, "Input"],
Cell[486963, 13323, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[487067, 13330, 62, 1, 45, "Subsection",
  CellTags->"T1.6.101.1"],
Cell[487132, 13333, 124, 3, 27, "Input"],
Cell[487259, 13338, 157, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[487441, 13345, 59, 1, 27, "Input"],
Cell[487503, 13348, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[487607, 13355, 62, 1, 45, "Subsection",
  CellTags->"T1.6.102.1"],
Cell[487672, 13358, 85, 1, 27, "Input"],
Cell[487760, 13361, 157, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[487942, 13368, 59, 1, 27, "Input"],
Cell[488004, 13371, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[488108, 13378, 62, 1, 45, "Subsection",
  CellTags->"T1.6.103.1"],
Cell[488173, 13381, 85, 1, 27, "Input"],
Cell[488261, 13384, 157, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[488443, 13391, 59, 1, 27, "Input"],
Cell[488505, 13394, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[488609, 13401, 62, 1, 45, "Subsection",
  CellTags->"T1.6.104.1"],
Cell[488674, 13404, 124, 3, 27, "Input"],
Cell[488801, 13409, 157, 3, 27, "Input"],

Cell[CellGroupData[{
Cell[488983, 13416, 59, 1, 27, "Input"],
Cell[489045, 13419, 55, 1, 24, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[489149, 13426, 59, 1, 45, "Subsection",
  CellTags->"T1.6.105.1"],
Cell[489211, 13429, 59, 1, 30, "Text"],
Cell[489273, 13432, 140, 2, 31, "Text"],
Cell[489416, 13436, 455, 9, 59, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[489908, 13450, 61, 1, 45, "Subsection",
  CellTags->"T1.6.106.1"],
Cell[489972, 13453, 48, 1, 27, "Input"],
Cell[490023, 13456, 70, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[490130, 13462, 59, 1, 45, "Subsection",
  CellTags->"T1.6.107.1"],
Cell[490192, 13465, 59, 1, 30, "Text"],
Cell[490254, 13468, 140, 2, 31, "Text"],
Cell[490397, 13472, 565, 13, 75, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[490999, 13490, 61, 1, 45, "Subsection",
  CellTags->"T1.6.108.1"],
Cell[491063, 13493, 48, 1, 27, "Input"],
Cell[491114, 13496, 120, 3, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[491271, 13504, 59, 1, 45, "Subsection",
  CellTags->"T1.6.109.1"],
Cell[491333, 13507, 59, 1, 30, "Text"],
Cell[491395, 13510, 140, 2, 31, "Text"],
Cell[491538, 13514, 402, 8, 59, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[491977, 13527, 61, 1, 45, "Subsection",
  CellTags->"T1.6.110.1"],
Cell[492041, 13530, 48, 1, 27, "Input"],
Cell[492092, 13533, 70, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[492199, 13539, 59, 1, 45, "Subsection",
  CellTags->"T1.6.111.1"],
Cell[492261, 13542, 59, 1, 30, "Text"],
Cell[492323, 13545, 311, 6, 43, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[492671, 13556, 61, 1, 45, "Subsection",
  CellTags->"T1.6.112.1"],
Cell[492735, 13559, 48, 1, 27, "Input"],
Cell[492786, 13562, 70, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[492893, 13568, 59, 1, 45, "Subsection",
  CellTags->"T1.6.113.1"],
Cell[492955, 13571, 43, 0, 32, "Text"],
Cell[493001, 13573, 105, 1, 29, "Text"],
Cell[493109, 13576, 6709, 171, 54, "Input"],
Cell[499821, 13749, 191, 3, 30, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[500049, 13757, 61, 1, 45, "Subsection",
  CellTags->"T1.6.114.1"],
Cell[500113, 13760, 76, 1, 27, "Input"],
Cell[500192, 13763, 422, 10, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[500651, 13778, 61, 1, 45, "Subsection",
  CellTags->"T1.6.115.1"],
Cell[500715, 13781, 692, 29, 417, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[501444, 13815, 61, 1, 45, "Subsection",
  CellTags->"T1.6.116.1"],
Cell[501508, 13818, 696, 29, 417, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[502241, 13852, 62, 1, 45, "Subsection",
  CellTags->"T1.6.117.1"],
Cell[502306, 13855, 1083, 19, 251, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[503426, 13879, 62, 1, 45, "Subsection",
  CellTags->"T1.6.118.1"],
Cell[503491, 13882, 1046, 18, 235, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[504574, 13905, 62, 1, 45, "Subsection",
  CellTags->"T1.6.119.1"],
Cell[504639, 13908, 1044, 18, 235, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[505720, 13931, 61, 1, 45, "Subsection",
  CellTags->"T1.6.120.1"],
Cell[505784, 13934, 240, 6, 87, "Input"],

Cell[CellGroupData[{
Cell[506049, 13944, 4713, 86, 125, "Input"],
Cell[510765, 14032, 1563, 21, 188, "Print"]
}, Open  ]],
Cell[512343, 14056, 23, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[512391, 14060, 586, 11, 98, "Input"],
Cell[512980, 14073, 1563, 21, 188, "Print"]
}, Open  ]],
Cell[514558, 14097, 40, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[514635, 14103, 55, 1, 45, "Subsection",
  CellTags->"Tsymmetry"],
Cell[514693, 14106, 34, 0, 32, "Text"],
Cell[514730, 14108, 107, 3, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[514874, 14116, 70, 1, 45, "Subsection",
  CellTags->"specialTVR"],
Cell[514947, 14119, 579, 11, 162, "Input"],
Cell[515529, 14132, 1683, 27, 387, "Input"],
Cell[517215, 14161, 1597, 26, 372, "Input"],
Cell[518815, 14189, 3547, 56, 837, "Input"],
Cell[522365, 14247, 3261, 52, 777, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[525663, 14304, 60, 1, 45, "Subsection",
  CellTags->"T1.6.121.1"],
Cell[525726, 14307, 230, 5, 86, "Text"],
Cell[525959, 14314, 394, 7, 75, "Input"],
Cell[526356, 14323, 237, 5, 86, "Text"],
Cell[526596, 14330, 427, 8, 75, "Input"],
Cell[527026, 14340, 239, 5, 86, "Text"],
Cell[527268, 14347, 427, 8, 75, "Input"],
Cell[527698, 14357, 238, 5, 86, "Text"],
Cell[527939, 14364, 425, 8, 75, "Input"],
Cell[528367, 14374, 219, 14, 248, "Text"],
Cell[528589, 14390, 200, 5, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[528826, 14400, 61, 1, 45, "Subsection",
  CellTags->"T1.6.122.1"],
Cell[528890, 14403, 273, 5, 59, "Input"],
Cell[529166, 14410, 273, 5, 59, "Input"],
Cell[529442, 14417, 133, 3, 42, "Input"],
Cell[529578, 14422, 264, 5, 59, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[529879, 14432, 60, 1, 45, "Subsection",
  CellTags->"T1.6.123.1"],
Cell[529942, 14435, 194, 4, 43, "Input"],
Cell[530139, 14441, 194, 4, 43, "Input"],
Cell[530336, 14447, 194, 4, 43, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[530567, 14456, 58, 1, 45, "Subsection",
  CellTags->"T1.6.124.1"],
Cell[530628, 14459, 185, 4, 43, "Input"],
Cell[530816, 14465, 185, 4, 43, "Input"],
Cell[531004, 14471, 87, 1, 27, "Input"],
Cell[531094, 14474, 85, 1, 27, "Input"],
Cell[531182, 14477, 88, 1, 27, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[531319, 14484, 108, 2, 61, "Section",
  CellTags->"T1.7.1"],

Cell[CellGroupData[{
Cell[531452, 14490, 70, 1, 45, "Subsection",
  CellTags->"T1.7.1.1"],
Cell[531525, 14493, 45, 0, 32, "Text"],
Cell[531573, 14495, 57, 1, 27, "Input"],
Cell[531633, 14498, 145, 3, 27, "Input"],
Cell[531781, 14503, 501, 13, 27, "Input"],
Cell[532285, 14518, 127, 2, 27, "Input"],
Cell[532415, 14522, 503, 13, 27, "Input"],
Cell[532921, 14537, 129, 2, 27, "Input"],
Cell[533053, 14541, 84, 3, 32, "Text"],
Cell[533140, 14546, 60, 1, 27, "Input"],
Cell[533203, 14549, 111, 2, 27, "Input"],
Cell[533317, 14553, 216, 7, 104, "Text",
  CellTags->"TLRdef"],
Cell[533536, 14562, 112, 2, 27, "Input"],
Cell[533651, 14566, 438, 10, 27, "Input"],
Cell[534092, 14578, 26, 0, 32, "Text"],
Cell[534121, 14580, 928, 16, 197, "Input"],
Cell[535052, 14598, 72, 1, 28, "Text"],
Cell[535127, 14601, 926, 16, 197, "Input"],
Cell[536056, 14619, 82, 1, 28, "Text"],
Cell[536141, 14622, 750, 15, 168, "Input"],
Cell[536894, 14639, 82, 1, 28, "Text"],
Cell[536979, 14642, 771, 15, 168, "Input"],
Cell[537753, 14659, 85, 1, 28, "Text"],
Cell[537841, 14662, 836, 17, 204, "Input"],
Cell[538680, 14681, 37, 0, 32, "Text"],
Cell[538720, 14683, 658, 13, 102, "Input"],
Cell[539381, 14698, 37, 0, 32, "Text"],
Cell[539421, 14700, 673, 14, 102, "Input"],
Cell[540097, 14716, 35, 0, 32, "Text"],
Cell[540135, 14718, 730, 11, 271, "Input"],
Cell[540868, 14731, 31, 0, 32, "Text"],
Cell[540902, 14733, 224, 6, 104, "Text"],
Cell[541129, 14741, 31, 0, 32, "Text"],
Cell[541163, 14743, 204, 5, 57, "Input"],
Cell[541370, 14750, 148, 4, 50, "Text"],
Cell[541521, 14756, 443, 15, 207, "Input"],
Cell[541967, 14773, 443, 15, 207, "Input"],
Cell[542413, 14790, 49, 0, 32, "Text"],
Cell[542465, 14792, 374, 6, 69, "Input"],
Cell[542842, 14800, 49, 0, 32, "Text"],
Cell[542894, 14802, 374, 6, 69, "Input"],
Cell[543271, 14810, 25, 0, 32, "Text"],
Cell[543299, 14812, 255, 6, 27, "Input"],
Cell[543557, 14820, 246, 5, 43, "Input"],
Cell[543806, 14827, 78, 1, 32, "Text",
  CellTags->"tlrule17"],
Cell[543887, 14830, 530, 9, 118, "Input"],
Cell[544420, 14841, 986, 19, 180, "Input"],
Cell[545409, 14862, 986, 19, 180, "Input"],
Cell[546398, 14883, 37, 0, 32, "Text"],
Cell[546438, 14885, 499, 8, 118, "Input"],
Cell[546940, 14895, 287, 5, 43, "Input"],
Cell[547230, 14902, 358, 7, 65, "Input"],
Cell[547591, 14911, 6408, 176, 149, "Text"],
Cell[554002, 15089, 895, 17, 182, "Input"],
Cell[554900, 15108, 12636, 333, 95, "Text"],
Cell[567539, 15443, 954, 16, 195, "Input"],
Cell[568496, 15461, 65, 0, 32, "Text"],
Cell[568564, 15463, 435, 9, 59, "Input"],
Cell[569002, 15474, 65, 1, 27, "Input"],
Cell[569070, 15477, 70, 1, 27, "Input"],
Cell[569143, 15480, 92, 1, 27, "Input"],
Cell[569238, 15483, 92, 1, 27, "Input"],
Cell[569333, 15486, 92, 1, 27, "Input"],
Cell[569428, 15489, 92, 1, 27, "Input"],
Cell[569523, 15492, 92, 1, 27, "Input"],
Cell[569618, 15495, 92, 1, 27, "Input"],
Cell[569713, 15498, 74, 1, 27, "Input"],
Cell[569790, 15501, 88, 1, 27, "Input"],
Cell[569881, 15504, 108, 2, 27, "Input"],
Cell[569992, 15508, 250, 6, 27, "Input"],
Cell[570245, 15516, 55, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[570337, 15522, 50, 1, 45, "Subsection",
  CellTags->"T1.7.2.1"],
Cell[570390, 15525, 86, 3, 50, "Text"],
Cell[570479, 15530, 679, 13, 99, "Input"],
Cell[571161, 15545, 202, 4, 43, "Input"],
Cell[571366, 15551, 202, 4, 43, "Input"],
Cell[571571, 15557, 668, 12, 79, "Input"],
Cell[572242, 15571, 163, 2, 27, "Input"],
Cell[572408, 15575, 163, 2, 27, "Input"],
Cell[572574, 15579, 505, 9, 67, "Input"],
Cell[573082, 15590, 164, 2, 27, "Input"],
Cell[573249, 15594, 164, 2, 27, "Input"],
Cell[573416, 15598, 545, 9, 79, "Input"],
Cell[573964, 15609, 556, 9, 99, "Input"],
Cell[574523, 15620, 22, 0, 32, "Text"],
Cell[574548, 15622, 130, 3, 29, "Input"],
Cell[574681, 15627, 87, 1, 27, "Input"],
Cell[574771, 15630, 496, 10, 70, "Input"],
Cell[575270, 15642, 537, 9, 105, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[575844, 15656, 54, 1, 45, "Subsection",
  CellTags->"T1.7.3.1"],
Cell[575901, 15659, 61, 1, 27, "Input"],
Cell[575965, 15662, 1380, 26, 139, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[577382, 15693, 52, 1, 45, "Subsection",
  CellTags->"$TTable"],
Cell[577437, 15696, 50, 1, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[577524, 15702, 59, 1, 45, "Subsection",
  CellTags->"T1.7.4.1"],
Cell[577586, 15705, 105, 2, 27, "Input"],
Cell[577694, 15709, 273, 5, 59, "Input"],
Cell[577970, 15716, 191, 3, 27, "Input"],
Cell[578164, 15721, 8770, 163, 867, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[586983, 15890, 92, 2, 61, "Section",
  CellTags->"T1.8.1"],
Cell[587078, 15894, 251, 4, 59, "Input"],
Cell[587332, 15900, 167, 2, 27, "Input"],
Cell[587502, 15904, 8682, 160, 700, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[596221, 16069, 93, 2, 61, "Section",
  CellTags->"T1.9.1"],

Cell[CellGroupData[{
Cell[596339, 16075, 54, 1, 45, "Subsection",
  CellTags->"T1.9.1.1"],
Cell[596396, 16078, 61, 0, 32, "Text"],
Cell[596460, 16080, 185, 3, 27, "Input"],
Cell[596648, 16085, 64, 1, 27, "Input"],
Cell[596715, 16088, 71, 1, 27, "Input"],
Cell[596789, 16091, 53, 1, 27, "Input"],
Cell[596845, 16094, 1836, 32, 155, "Input"],
Cell[598684, 16128, 53, 1, 27, "Input"],
Cell[598740, 16131, 129, 3, 27, "Input"],
Cell[598872, 16136, 81, 1, 27, "Input"],
Cell[598956, 16139, 48, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[599029, 16144, 137, 3, 27, "Input"],
Cell[599169, 16149, 325, 6, 24, "Print"]
}, Open  ]],
Cell[599509, 16158, 143, 2, 27, "Input"],
Cell[599655, 16162, 49, 1, 27, "Input"],
Cell[599707, 16165, 45, 1, 27, "Input"],
Cell[599755, 16168, 53, 1, 27, "Input"],
Cell[599811, 16171, 54, 1, 27, "Input"],
Cell[599868, 16174, 43, 1, 27, "Input"],
Cell[599914, 16177, 50, 1, 27, "Input"],
Cell[599967, 16180, 164, 2, 27, "Input"],
Cell[600134, 16184, 83, 1, 43, "Input"],
Cell[600220, 16187, 60, 1, 27, "Input"],
Cell[600283, 16190, 258, 4, 43, "Input"],
Cell[600544, 16196, 43, 1, 27, "Input"],
Cell[600590, 16199, 60, 1, 27, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[600699, 16206, 95, 2, 61, "Section",
  CellTags->"T1.10.1"],
Cell[600797, 16210, 114, 3, 32, "Text"],
Cell[600914, 16215, 56, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[600995, 16219, 1634, 53, 747, "Input"],
Cell[602632, 16274, 14653, 365, 282, "Output"]
}, Open  ]],
Cell[617300, 16642, 1675, 54, 914, "Text"],
Cell[618978, 16698, 14926, 369, 282, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[633941, 17072, 101, 2, 61, "Section",
  CellTags->"T1.11.1"],
Cell[634045, 17076, 45, 1, 27, "Input"],
Cell[634093, 17079, 2355, 56, 822, "Input"],
Cell[636451, 17137, 66, 1, 27, "Input"],
Cell[636520, 17140, 89, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[636634, 17147, 114, 2, 27, "Input"],
Cell[636751, 17151, 74, 1, 28, "Output"]
}, Open  ]],
Cell[636840, 17155, 55, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[636920, 17159, 137, 2, 27, "Input"],
Cell[637060, 17163, 64, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[637161, 17169, 62, 1, 27, "Input"],
Cell[637226, 17172, 64, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[637327, 17178, 44, 1, 27, "Input"],
Cell[637374, 17181, 86, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[637497, 17187, 48, 1, 27, "Input"],
Cell[637548, 17190, 59, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[637644, 17196, 46, 1, 27, "Input"],
Cell[637693, 17199, 59, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[637789, 17205, 43, 1, 27, "Input"],
Cell[637835, 17208, 58, 1, 28, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

