(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     30862,        993]*)
(*NotebookOutlinePosition[     35249,       1144]*)
(*  CellTagsIndexPosition[     35205,       1140]*)
(*WindowFrame->Palette*)



Notebook[{

Cell[CellGroupData[{
Cell["Basic objects", "Section"],

Cell[CellGroupData[{

Cell["Constants", "Subsection"],

Cell["\<\
Different types of constants have different heads.\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  Hyphenation->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(ParticleMass[\[SelectionPlaceholder]]\)]},
        {
          
          ButtonBox[
            \(CouplingConstant[\[SelectionPlaceholder], \[Placeholder]]\)]},
        {
          ButtonBox[\(DecayConstant[\[SelectionPlaceholder]]\)]}},
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"],

Cell["\<\
An argument with head RenormalizationState may be given. The convention \
is that 0 correponds to unrenormalized quantities, 1 to one-loop renormalized \
quantities, etc.\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  Hyphenation->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(RenormalizationState[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["QuantumField and possible arguments", "Subsection"],

Cell[TextData[{
  "A possible space-time (or momentum) variable is to be given as the outer (last) argument."
}], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  Hyphenation->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(\(QuantumField[
                Particle[\[SelectionPlaceholder]]]\)[\[Placeholder]]\)]},
        {
          ButtonBox[GridBox[{
                {
                  ButtonBox[\(PartialD[\[SelectionPlaceholder]]\)]},
                {
                  ButtonBox[\(SUNIndex[\[SelectionPlaceholder]]\)]},
                {
                  ButtonBox[\(LorentzIndex[\[SelectionPlaceholder]]\)]}
                },
              RowSpacings->0,
              ColumnSpacings->0,
              GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Iso-vectors and iso-matrices", "Subsection"],

Cell["\<\
IsoVector's can be anything, but often are QuantumField's, in which \
case the space-time argument should not be given to QuantumField, but instead \
to IsoVector.\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  Hyphenation->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(\(IsoVector[\[SelectionPlaceholder]]\)[\[Placeholder]]\)\
]},
        {
          ButtonBox[\(UMatrix[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(UVector[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Operators", "Subsection"],

Cell[TextData[{
  "NM is to be used as non-commutative multiplication for PHI \
  objects like UMatrix[..]. IsoDot, IsoCross and IsoSymmetricCross is to be \
used for vector products of IsoVector[..] objects. DOT for \"sandwiching\" \
matrices between UVector[..] objects (tuplets of spinors)."
}], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(NM[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(IsoDot[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(IsoCross[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(IsoSymmetricCross[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Adjoint[\[SelectionPlaceholder], \[Placeholder]]\)]},
        {
          
          ButtonBox[\(FieldDerivative[\[SelectionPlaceholder], \
\[Placeholder], \[Placeholder]]\)]},
        {
          
          ButtonBox[\(CovariantFieldDerivative[\[SelectionPlaceholder], \
\[Placeholder], \[Placeholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Composite objects"], "Subsection"],

Cell[TextData[{
  "PHI comes with some objects constructed from the above building blocks. E.g."
}], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(MM[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(UChiMatrix[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(UQuarkMassMatrix[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(UQuarkChargeMatrix[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Construction of lagrangians"], "Subsection"],

Cell["\<\
Once a lagrangian is contructed, a unique name should be \
chosen and the renormalization of the coupling constants should be specified.\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],


Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(Lagrangian[\[SelectionPlaceholder]] := \
\[Placeholder]\)]},
        {
          
          ButtonBox[\(RenormalizationCoefficients[\[SelectionPlaceholder]] := \
{\[Placeholder]}\)]},
        {""}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Options in configuration files", "Subsection"],

Cell["\<\
A configuration file for a family of lagrangians, must define at \
least the following objects:\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  Hyphenation->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["$ParticlesInUse"]},
        {
          ButtonBox["$PropagatorMassesStates"]},
        {
          ButtonBox["$CouplingIsoIndicesSpecifications"]},
        {
          ButtonBox["$InsertOnly"]},
        {
          ButtonBox["$MixingFields"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]]
}, Closed]],


(* ********************************************************************************** *)


Cell[CellGroupData[{

Cell["Generation of coupling vectors from lagrangians", "Section"],

Cell[CellGroupData[{

Cell["Expansion of (\[Chi]PT) lagrangians", "Subsection"],

Cell["\<\
A lagrangian can be composed of objects written in a abbreviated \
notation (see ?ArgumentsSupply). This is usefull in \[Chi]PT. To work with \
such a lagrangian, it is necessary to supply some arguments and options and \
expand the abbreviated objects.\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell["\<\
ArgumentsSupply[lag,x,opts] supplies the space-time argument x and \
the options opts to all relevant objects in lag.  DiscardTerms[lag,opts] \
discards products of fields in lag with more fields than specified in the \
options opts.\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell["\<\
With complicated \[Chi]PT lagrangians, instead of ArgumentsSupply \
and DiscardTerms, UNMSplit should be used. UNMSplit[lag,opts] expands the \
pion/meson fields in a more clever fashion, giving huge speed gains.\
\>", \
NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  Hyphenation->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  CounterIncrements->"Text"],

Cell["\<\
ExpandU[lag,opts]  recursively expands products involving dot \
products of iso-vectors with \"iso-vectors\" of generator matrices (Pauli or \
Gell-Mann), leaving at most one matrix in each term. CommutatorReduce[lag] \
applies a set of commutation rules repeatedly to lag. IsoIndicesSupply \
supplies iso-indices to the various \"iso-dot\" products and UIndicesSupply \
supplies indices to any tuplets of spinors \"sandwiching\" \
\"iso-matrices\".\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(ArgumentsSupply[\[SelectionPlaceholder], \
\[Placeholder]]\)]},
        {
          ButtonBox[\(DiscardTerms[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(UNMSplit[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(ExpandU[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(CommutatorReduce[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(IsoIndicesSupply[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(UIndicesSupply[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Iso-spin manipulations", "Subsection"],

Cell["\<\
Applying ExpandU and IsoIndicesSupply will often produce \
untransparent expressions on which the application of one or more iso-spin \
manipulation functions may help.\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell["\<\
With complicated lagrangians, it is often more convenient to not \
apply ExpandU and IsoIndicesSupply, but instead leave the matrices and traces \
unevaluated. Later, WriteOutIsoVectors and WriteOutUMatrices can then be \
applied.\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(IsoIndicesTogether[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(SUNReduce[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(WriteOutIsoVectors[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(WriteOutUMatrices[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      RowLines->{
        False, False, False, False, True, False, True, False, False, False, 
          False, True, False}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Feynman rules", "Subsection"],

Cell["\<\
FeynRule[lag,{f}] and FunctionalD[lag,{f}] can be applied directly \
with lag being a lagrangian lag and fields {f} as decribed above.\
\>", \
NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(FeynRule[\[SelectionPlaceholder], \
{\[Placeholder]}]\)]},
        {
          
          ButtonBox[\(FunctionalD[\[SelectionPlaceholder], \
{\[Placeholder]}]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["Extraction of coupling vectors", "Subsection"],

Cell[TextData[{
  "To generate ",
  StyleBox["FeynArts",
    FontSlant->"Italic"],
  " coupling vectors, the momenta and masses of the amplitude must be \
collected. This is done by MomentaCollect (with the right setting of \
options). GenericCoupling and ClassesCoupling generate the generic and model \
coupling vectors that are loaded by the ",
  StyleBox["FeynArts",
    FontSlant->"Italic"],
  " model file \"Automatic.m\". Notice that MomentaCollect has its \
limitations, and often it is necessary or much faster to do the Collecting \
using standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Expand and Collect."
}], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {""},
        {
          ButtonBox[\(MomentaCollect[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(GenericCoupling[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(ClassesCoupling[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      RowLines->{
        False, False, False, False, True, False, True, False, False, False, 
          False, True, False}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]]
}, Closed]],


(* ********************************************************************************** *)


Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["FeynArts",
    FontSlant->"Italic"],
  " and the model file \"Automatic.m\""
}], "Section"],

Cell[CellGroupData[{

Cell["Topologies and field insertion", "Subsection"],

Cell[TextData[{
  "CreateTopologies is a ",
  StyleBox["FeynArts",
    FontSlant->"Italic"],
  " function for generating all topologies with a specified number of \
incoming and outgoing particles and loops. $VerticesSpecifications is a PHI \
varible which must be set to a list of the options one wishes \
\"Automatic.m\" to use. InsertFields is a ",
  StyleBox["FeynArts",
    FontSlant->"Italic"],
  " function for generating Feynman diagrams from a set of topologies, sets \
of incoming and outgoing particles and a model (\"Automatic.m\" in this \
case). Paint is a ",
  StyleBox["FeynArts",
    FontSlant->"Italic"],
  " function for drawing topologies and Feynman diagrams."
}], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(CreateTopologies[\[SelectionPlaceholder], \
\[Placeholder]]\)]},
        {
          ButtonBox["$VerticesSpecifications"]},
        {
          
          ButtonBox[\(InsertFields[\[SelectionPlaceholder], \
\[Placeholder]]\)]},
        {
          ButtonBox[\(Paint[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      RowLines->{
        False, False, False, False, True, False, True, False, False, False, 
          False, True, False}]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell["$VerticesSpecifications", "Subsection"],

Cell[TextData[{
  "The list $VerticesSpecifications must be a list of lists of options - one \
list for each vertex. VertexFields hould be set to a list of valid PHI \
particle names with an extra argument (usually 0), e.g. Electron[0]. \
PhiModel should be set to a valid PHI model, e.g. \"QED\". PerturbationOrder \
to a list of the counter term \
orders one wants and has defined lagrangian files for. E.g. {1,2}, \
corresponding to model files \"QED1.m\" and \"QED2.m\". Also SUNN, \
CouplingSign and XFileName may be set."
}], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(VertexFields \[Rule] \[SelectionPlaceholder]\)]},
        {
          ButtonBox[\(PhiModel \[Rule] \[SelectionPlaceholder]\)]},
        {
          ButtonBox[\(PerturbationOrder \[Rule] \[SelectionPlaceholder]\)]},
        {
          ButtonBox[\(SUNN \[Rule] \[SelectionPlaceholder]\)]},
        {
          ButtonBox[\(CouplingSign \[Rule] \[SelectionPlaceholder]\)]},
        {
          ButtonBox[\(XFileName \[Rule] \[SelectionPlaceholder]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generation of amplitudes", "Section"],

Cell[TextData[{
  "The amplitude is created simply by applying CreateFCAmp to the output of \
InsertFields. This will most probably produce a gigantic and untransparent \
expression. For manipulating such expressions, a number of utility functions \
are provided by ", StyleBox["FeynCalc", FontSlant->"Italic"],
  ". OneLoopSimplify[int,q] simplify a one-loop integrand int with internal \
momentum q. OneLoop[q,int] expresses the one-loop integral of int with \
respect to q in terms of standard Passarino-Veltman integrals. \
PaVeReduce[expr] reduces all Passarino-Veltman integrals (i.e. all PaVe's) in \
expr down to scalar A0, B0, C0 and D0. After that, further more customized reduction \
is most likely necessary."
}], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(CreateFCAmp[\[SelectionPlaceholder]]\)]},
        {
          
          ButtonBox[\(OneLoopSimplify[\[SelectionPlaceholder], \
\[Placeholder]]\)]},
        {
          ButtonBox[\(OneLoop[\[Placeholder], \[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(PaVeReduce[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]],


Cell[CellGroupData[{

Cell["Reduction of amplitudes", "Section"],

Cell["\<\
SetMandelstam[s, t, u, p1, p2, p3, p4, m1, m2, m3, m4] sets \
products of momenta in terms of Mandelstam variables and automatically \
substitutes Mandelstam variables whenever the specified momenta are \
encountered. This can speed up things. To simplify without automatic \
substitution: MandelstamReduce[amp,opts] substitutes products of momenta in \
amp with Mandelstam variables according to the setting of the options opts.\
\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[\(SetMandelstam[\[SelectionPlaceholder], \[Placeholder], \
\[Placeholder], \[Placeholder], \[Placeholder], \[Placeholder], \
\[Placeholder], \[Placeholder], \[Placeholder], \[Placeholder], \
\[Placeholder]]\)]},
        {
          ButtonBox[\(MandelstamReduce[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"],

Cell["\<\
VeltmanExpand[amp] expands the Passarino-Veltman B0 and C0 \
functions in the number of dimensions (minus 4). ExpandGammas does the same \
for the gamma functions. Renormalize attempts to reexpres the coupling \
constants absorbing infinities according to the setting of various options.\
\
\>", NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {7, Inherited}},
  PageBreakAbove->True,
  LineSpacing->{1, 3},
  ScriptMinSize->9,
  SingleLetterItalics->False,
  CounterIncrements->"Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(VeltmanExpand[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(ExpandGammas[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Renormalize[\[SelectionPlaceholder]]\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  SingleLetterItalics->False,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
}, Closed]]
},
ScreenRectangle->{{0, 1152}, {0, 850}},
NotebookAutoSave->False,
AutoGeneratedPackage->None,
Editable->True,
WindowToolbars->{},
WindowSize->{420, 500},
WindowMargins->{{290, Automatic}, {Automatic, 36}},
WindowFrame->"Palette",
WindowElements->"VerticalScrollBar",
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
WindowTitle->None,
ShowCellBracket->False,
Active->True,
StyleDefinitions -> Notebook[{
  Cell["\<\
          Prototypes for the BasicCalculations Palette. This \
abbreviated style sheet is used to reduce the size of the notebook as a whole \
while still allowing the styles to be easily modifed. Remember that all other \
styles will be adopted from the default style sheet.          \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->None,
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{19, Inherited}, {3, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{24, Inherited}, {Inherited, 20}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, 20}},
    FontSize->14],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->None,
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{25, Inherited}, {Inherited, 8}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{24, Inherited}, {Inherited, 15}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, 15}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    ShowCellBracket->False,
    CellMargins->{{6, Inherited}, {0, Inherited}},
    FontFamily->"Times"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, Inherited}, {10, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{14, Inherited}, {0, Inherited}},
    FontSize->10],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{4, Inherited}, {0, 2}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    ShowCellBracket->False,
    CellMargins->{{5, Inherited}, {Inherited, Inherited}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{45, Inherited}, {20, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{30, Inherited}, {10, Inherited}},
    FontSize->10],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->10]
  }, Closed]]
  }]
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1732, 51, 32, 0, 37, "Section"],
Cell[1767, 53, 835, 21, 110, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],

Cell[CellGroupData[{
Cell[2627, 78, 31, 0, 27, "Subsection"],
Cell[2661, 80, 313, 9, 43, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[2977, 91, 1125, 34, 76, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4139, 130, 57, 0, 23, "Subsection"],
Cell[4199, 132, 1137, 35, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5373, 172, 35, 0, 23, "Subsection"],
Cell[5411, 174, 1199, 35, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[6647, 214, 31, 0, 23, "Subsection"],
Cell[6681, 216, 1449, 44, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[8167, 265, 67, 0, 23, "Subsection"],
Cell[8237, 267, 299, 9, 70, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[8539, 278, 1582, 49, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[10124, 329, 1577, 52, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[11738, 386, 52, 0, 23, "Subsection"],
Cell[11793, 388, 1049, 34, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12891, 428, 63, 0, 23, "Section"],

Cell[CellGroupData[{
Cell[12979, 432, 43, 0, 70, "Subsection"],
Cell[13025, 434, 376, 10, 70, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[13404, 446, 846, 16, 70, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[14253, 464, 1318, 40, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[15608, 509, 44, 0, 70, "Subsection"],
Cell[15655, 511, 409, 10, 70, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[16067, 523, 1121, 33, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[17225, 561, 39, 0, 70, "Subsection"],
Cell[17267, 563, 642, 19, 70, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[17912, 584, 1044, 31, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[18993, 620, 49, 0, 70, "Subsection"],
Cell[19045, 622, 863, 26, 70, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[19911, 650, 1117, 33, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21077, 689, 131, 5, 23, "Section"],

Cell[CellGroupData[{
Cell[21233, 698, 52, 0, 70, "Subsection"],
Cell[21288, 700, 1035, 27, 70, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[22326, 729, 1248, 39, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[23611, 773, 53, 0, 70, "Subsection"],
Cell[23667, 775, 797, 19, 70, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[24467, 796, 1259, 36, 70, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[25775, 838, 53, 0, 23, "Section"],
Cell[25831, 840, 804, 19, 124, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[26638, 861, 1049, 32, 60, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[27690, 895, 476, 12, 75, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[28169, 909, 1155, 33, 44, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[29327, 944, 505, 12, 75, NotebookDefault,
  PageBreakAbove->True,
  CounterIncrements->"Text"],
Cell[29835, 958, 996, 30, 60, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"],
Cell[30834, 990, 12, 0, 22, InheritFromParent]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

