(* ************************************************************************* *)
(*                                                                           *)
(*                             Automatic.mod                                 *)
(*                                                                           *)
(* ************************************************************************* *)

(* 
   Author:              Frederik Orellana 1997

   Summary:             Classes model for FeynArts
   
   Mathematica Version: 3.0 

   Requirements:        FeynArts > 2, PHI, FeynCalc > 3

   Description:         The coupling vectors are loaded from 
                        files generated by PHI   
*)

(* ************************************************************************* *)

(* The minuses for outgoing particles are kept *)

$VerticesSpecifications2:=($VerticesSpecifications/.
                           -qu_[q__]->HoldMinus[qu][q]);

(* ************************************************************************* *)

$ScreenSymbolFont = "Symbol";

(*
  A table is generated with settings for the function isoindexx 
  to be called later on.
  isovar[fi,j] is the base j'th iso-spin variable of the field fi
  isovarii[fi,j,i] is Index[IsoSpin[isovar[fi,j]],i]
  isorange[fi,j] is the range of the j'th iso-spin variable of the
  field fi.
  The result is that e.g. isoindexx[Pion[0],1,1] returns I1, 
  isoindexx[Pion[0],1,2] returns I2, ..., because 'I' is set to be
  the first (and only) iso-index string of Pion[0] in
  $CouplingIsoIndicesSpecifications.
  isoindexxx[Pion[0],1] returns {I1}, but had Pion[0] had another
  isospin index 'J'( e.g. Pion[0]->{{IsoRange->{1,2,3},IsoIndicesString->"I"},
  {IsoRange->{1,2},IsoIndicesString->"J"}} ), it would have returned {I1,J1}
*)


Clear[iistr,iiran,isovar,isovarii,isorange,isovars,isoindexx,isoindexxx];

Table[

Table[

    iistr=$CouplingIsoIndicesSpecifications[[rep,2,indexnr,2,2]];
    iiran=$CouplingIsoIndicesSpecifications[[rep,2,indexnr,1,2]];

    isovar[$CouplingIsoIndicesSpecifications[[rep,1]],indexnr]=
    Index[IsoSpin[ToExpression[iistr]]];
   
    isovarii[$CouplingIsoIndicesSpecifications[[rep,1]],indexnr,iii_]=
    Index[IsoSpin[ToExpression[iistr]],iii];

    isorange[$CouplingIsoIndicesSpecifications[[rep,1]],indexnr]=
    iiran;
 
    setd[isoindexx[$CouplingIsoIndicesSpecifications[[rep,1]],indexnr,i_],
    {stringj[iistr,tostr[i]]}],

{indexnr,Length[$CouplingIsoIndicesSpecifications[[rep,2]]]}],

{rep,Length[$CouplingIsoIndicesSpecifications]}]/.
          
setd->SetDelayed;  


isovar[(a:$ParticleHeads)[___],_]:={};

isovars[(a:$ParticleHeads)[i_]]:=
Flatten[Table[isovar[a[i],indexnr],{indexnr,Length[
a[i]/.$CouplingIsoIndicesSpecifications]}]];

isovars[(a:$ParticleHeads)[___],_]:={};

isoindexx[(a:$ParticleHeads)[___],_,_]:={"seq[]"};

isoindexxx[(a:$ParticleHeads)[nr_],i_]:=
Flatten[Table[isoindexx[a[nr],indexnr,i],{indexnr,
Length[a[nr]/.$CouplingIsoIndicesSpecifications]}]];

isoindexxx[(a:$ParticleHeads)[___],_,_]:={"seq[]"};

(* ************************************************************************* *)

(* All fields in $VerticesSpecifications *)
(* Change 20/3-1999 - mixing fields must also be included in this list *)

allfieldstot=
Union[
Flatten[Transpose[Transpose[
$VerticesSpecifications1][[1]]/.Rule->List][[2]]],
If[Length[$MixingFields]>0,Transpose[$MixingFields/.Rule->List][[1]],{}]];

(* The actual setting of the ranges of the iso-spin variables *)

Do[

Do[

  IndexRange[ isovar[$CouplingIsoIndicesSpecifications[[reps,1]],indexnr] ] = 

  Evaluate[isorange[$CouplingIsoIndicesSpecifications[[reps,1]],indexnr]];
            
  Appearance[ 
     isovarii[$CouplingIsoIndicesSpecifications[[reps,1]],indexnr,i5_]
            ] = ""
     (*Uncomment the following and comment '' to have
       indices displayed*)(*{((isoindexx[
     $CouplingIsoIndicesSpecifications[[reps,1]],indexnr,reps])/.
     tostr->ToString/.stringj->StringJoin)[[1]]," ","("," ",
     i5,")"}*);,
            
{indexnr,Length[$CouplingIsoIndicesSpecifications[[reps,2]]]}],

{reps,Length[$CouplingIsoIndicesSpecifications]}];

(* ************************************************************************* *)
                                                               
(* The appearance for particles in $FAParticlesInUse is set.
   FALabel gives the appearance, but is defined only for some particles *)

Appearance[iii_]  := ToString[iii];

(Appearance[#]=FALabel[Particle[#[0]][[1]],0])&/@$FAParticlesInUse;

(* ************************************************************************* *)

(*
  The particle mass can have argument RenormalizationState[j],
  where j is an integer specifying the order of renormalization.
  This must be specified in $PropagatorMassesStates.
  Notice that e.g. ParticleMass[PseudoScalar[2][0]] is
  ParticleMass[PseudoScalar[2]], whereas ParticleMass[PseudoScalar[2][i]]
  is just ParticleMass[PseudoScalar[2][i]] for i!=0.
*)

FAParticleMass[(a:$ParticleHeads)[i_]]:=
  ParticleMass[a[i],##]&@@(
      a[i]/.$PropagatorMassesStates/.(aa:$ParticleHeads)[_]->{});

(* The particles can have mixing partners.  This should be specified
   in $MixingFields *)

mixps[(a:$ParticleHeads)[i_]]/;!FreeQ[$MixingFields,a[i]]:=
a[i]/.$MixingFields;

mixps[(a:$ParticleHeads)[_]]:={};

(* The particle may propagate only on a certain class of propagators.
   This should be specified in $InsertOnly *)

inso[(a:$ParticleHeads)[i_]]/;!FreeQ[$InsertOnly,a[i]]:=
a[i]/.$InsertOnly;

inso[(a:$ParticleHeads)[_]]:={};

(*
  descr[p[i]] returns the description for the particle p[i].
  Apart from the iso-spins, standard definitions are used for the
  three types of particles.
  All three types can have iso-spin indices.
  (Only vectors have kinematical indices - see Automatic.gen.)
  The propagator label is again given by FALabel.
*)

                (*The Sequence below inserted because of changes
                from FA2.1 to FA2.2 - after advise by Thomas Hahn*) 

(* Change 20/3-1999 - allow specification of SelfConjugate *)

descr[(a:$VectorHeads)[i_]]:=
          a[i]  == {
          SelfConjugate ->
          If[MemberQ[
          {True,False},SelfConjugation[a[i]]],SelfConjugation[a[i]],True], 
                Indices -> isovars[a[i]],
                Mass -> FAParticleMass[a[i]], 
                PropagatorLabel -> (*We use that Particle[aN][0]=Particle[a[N]]. For i=!=0 FALabel definitions must be modified*)
                ComposedChar[Sequence@@Join[{FALabel[Particle[a[i]][[1]],i]},
                isovars[a[i]]]], 
                PropagatorType -> Sine, 
                PropagatorArrow -> None,
                MixingPartners -> mixps[a[i]],
                InsertOnly -> inso[a[i]] };

descr[(a:$FermionHeads)[i_]]:=
          a[i]  == {
          SelfConjugate ->
          If[MemberQ[
          {True,False},SelfConjugation[a[i]]],SelfConjugation[a[i]],False], 
                Indices -> isovars[a[i]], 
                Mass -> FAParticleMass[a[i]], 
                PropagatorLabel -> 
                ComposedChar[Sequence@@Join[{FALabel[Particle[a[i]][[1]],i]},
                isovars[a[i]]]],
                (*PropagatorType -> Dashing[{0.003,0.006}],*)
								PropagatorType -> ScalarDash,
                PropagatorArrow -> Forward,
                MixingPartners -> mixps[a[i]],
                InsertOnly -> inso[a[i]] };

descr[(a:$ScalarHeads)[i_]]:=
          a[i] == {
          SelfConjugate ->
          If[MemberQ[
          {True,False},SelfConjugation[a[i]]],SelfConjugation[a[i]],True], 
          Indices -> isovars[a[i]], 
                Mass -> FAParticleMass[a[i]], 
                PropagatorLabel -> 
                ComposedChar[Sequence@@Join[{FALabel[Particle[a[i]][[1]],i]},
                isovars[a[i]]]],
                PropagatorType -> Straight,
                PropagatorArrow -> None,
                MixingPartners -> mixps[a[i]],
                InsertOnly -> inso[a[i]] };

(* ************************************************************************* *)

(* The function descr is used to create descriptions for all particles *)

M$ClassesDescription = (descr/@allfieldstot/.
{(Indices->{}):>Sequence[],(MixingPartners->{}):>Sequence[],
(InsertOnly->{}):>Sequence[]});

(* ************************************************************************* *)

(*
  The coupling vectors are read from the files specified in
  $VerticesSpecifications.  The left-hand side (classesfields) of the 
  defintion is created with the fields from $VerticesSpecifications
*)

olddir=Directory[];
SetDirectory[$HEPDir];
SetDirectory["HighEnergyPhysics"];
SetDirectory["Phi"];
SetDirectory["CouplingVectors"];

Do[

Do[

(* The coupling vectors are loaded into an array *)

cloadfile[filenr] = XName[listrepl[
$VerticesSpecifications1[[repp]],filenr]]<>".Mod";

VerbosePrint[1,repp," ",filenr,
" Loading classes coupling from ",cloadfile[filenr]];

classescouplingvector[repp,filenr] = (Get[cloadfile[filenr]]),

{filenr,Length[PerturbationOrder/.
$VerticesSpecifications1[[repp]]]}];

(*
  The array is parsed into a list of coupling vectors
  with counterterm entries (if there are any couterterms).
  Each coupling vector has the length of the flattened
  array, and each element of each coupling vector is a
  list of length Length[PerturbationOrder].  E.g. for
  PerturbationOrder={2,4}, a classes coupling vector
  corresponding to e.g. a generic coupling vector of the
  form {m^2,p1^2,p1*p2,...,m^4,e^4,p1^4,...} would have the
  form {{a1,0},{a2,0},{a3,0},...,{0,b1},{0,b2},...}
*)

(* The list of zeros into which we will insert the coupling of
   the right counterterm order, e.g. {0,0} becomes {a1,0} or
   {0,b1} *)

zerolist=Table[0,{Length[PerturbationOrder/.
$VerticesSpecifications1[[repp]]]}];

(* A temporary array of the form outerlist[innerlist[a1,a2,...],
   innerlist[b1,b2,...],...] *)

templist=outerlist@@innerlist/@Table[classescouplingvector[repp,filerep],
  {filerep,Length[PerturbationOrder/.
$VerticesSpecifications1[[repp]]]}]/.innerlist[{ga__}]:>innerlist@@Join[ga];

(* Transforming the above array into the array we need *)

(*zeroreplacerules=(
        Table[templist[[pos]]->(
        ReplacePart[zerolist,#,pos]&/@(
        templist[[pos]]/.innerlist->List)),{pos,Length[templist]}]);

classescouplingvector[repp] =
Join@@(templist/.zeroreplacerules);*)

classescouplingvector[repp]=
        Join@@Table[
        ReplacePart[zerolist,#,pos]&/@(
        templist[[pos]]/.innerlist->List),{pos,Length[templist]}];

(* The list of in/out fields is extracted from $VerticesSpecifications *)  

classesfields[repp] = Table[ 
           $VerticesSpecifications2[[repp,1,2,rep,0]][
           $VerticesSpecifications1[[repp,1,2,rep,1]],
           ToExpression[
           isoindexxx[$VerticesSpecifications1[[repp,1,2,rep]],rep]/.
           tostr->ToString/.stringj->StringJoin]/.{{seq[]}->Sequence[],
           {seq[],___}->Sequence[]}], 
                 {rep,1,Length[$VerticesSpecifications1[[repp,1,2]]]} ]/.
                 HoldMinus[a_][b__]:>-a[b];,
                                             
{repp,Length[$VerticesSpecifications1]}];

SetDirectory[olddir];

(* ************************************************************************* *)

(* The coupling vectors and the list of in/out fields are used
   for constructing the coupling definitions *)

M$CouplingMatrices =

Table[
   
  C@@(classesfields[repp])==classescouplingvector[repp],

{repp,Length[$VerticesSpecifications1]}];

(* Merge coupling vectors belonging to the same vertex *)

multVertPosC = Position[M$CouplingMatrices,#[[1]]]& /@ M$CouplingMatrices;

multVertsC = (Extract[M$CouplingMatrices, #[[1]]] & /@ #) & /@ multVertPosC;

M$CouplingMatrices = Union[(#[[1, 1]] == Join @@ ((#[[2]]) & /@ #)) & /@ multVertsC];

FixCouplingIndices;

(* ************************************************************************* *)

extraLastRuls={HoldPattern[IndexDelta[i_Integer,i_Integer]] -> 1,
                         IndexDelta[i_Integer,j_Integer] -> 0};

M$LastModelRules = If[ListQ[M$LastModelRules ],
 Union[M$LastModelRules, extraLastRuls,$LastModelRules ],
 Union[extraLastRuls,$LastModelRules ]
 ];

(**)
