(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   3624648,     136362]
NotebookOptionsPosition[   2644537,     106069]
NotebookOutlinePosition[   3116790,     119133]
CellTagsIndexPosition[   3100425,     118655]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["FeynCalc 6.0", "Title",
 TextAlignment->Center],

Cell["Tools for quantum field theory calculations", "Subtitle",
 TextAlignment->Center],

Cell[TextData[StyleBox["Reference Guide",
 FontWeight->"Bold"]], "Subtitle",
 PageBreakBelow->True,
 TextAlignment->Center],

Cell["Rolf Mertig and Frederik Orellana", "Subsubtitle",
 TextAlignment->Center],

Cell[TextData[{
 "HTML version: ",
 ButtonBox["http://www.feyncalc.org/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feyncalc.org/"], None},
  ButtonNote->"http://www.feyncalc.org/"]
}], "Subsubtitle",
 TextAlignment->Center],

Cell[BoxData[
 ButtonBox[
  RowBox[{
  "Click", " ", "to", " ", "save", " ", "this", " ", "notebook", " ", 
   "without", " ", "cache", " ", "and", " ", "FrontEndVersion", " ", "info"}],
  
  ButtonFunction:>(Module[{fn}, SetDirectory[
      DirectoryName[fn = ToFileName[
         ReplaceAll["FileName", 
          NotebookInformation[
           InputNotebook[]]]]]]; 
    newfn = StringReplace[fn, ".nb" -> "NoCache.nb"]; 
    If[FileNames[newfn] =!= {}, 
      DeleteFile[newfn]]; Put[
      ReplaceAll[
       NotebookGet[
        InputNotebook[]], Condition[FrontEndVersion -> Pattern[v, 
           Blank[]], Head[v] == String] :> Sequence[]], "fcr.nb"]; 
    CopyFile["fcr.nb", newfn]; DeleteFile["fcr.nb"]]),
  Evaluator->Automatic]], NotebookDefault,
 Active->True,
 CellTags->"ClickSave"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$Version", ",", 
   RowBox[{"Date", "[", "]"}], ",", "$UserName"}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"\<\"6.0 for Linux x86 (64-bit) (March 26, 2007)\"\>", ",", 
    RowBox[{"{", 
     RowBox[{
     "2007", ",", "5", ",", "9", ",", "15", ",", "4", ",", 
      "13.672289`7.888416215386728"}], "}"}], ",", "\<\"rolfm\"\>"}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions", "Section",
 CellTags->"Functions"],

Cell["Evaluation time and memory usage", "Commentary"],

Cell["\<\
This is only for timing purposes and can be omitted in general.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"absolutestarttime", "=", 
  RowBox[{"AbsoluteTime", "[", "]"}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FormBox["3.387711853789883`16.282481452911043*^9", 
  TraditionalForm]], "Output",
 CellLabel->"Out[2]="]
}, Open  ]],

Cell["<<HighEnergyPhysics`FeynCalc`", "Input",
 CellLabel->"In[3]:="],

Cell["Abbreviation", "ObjectName",
 PageBreakAbove->True,
 CellTags->"Abbreviation"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Abbreviation"],

Cell["\<\
Abbreviation is a function used by OneLoop and PaVeReduce for generating \
smaller files when saving results to the hard disk. The convention is that a \
definition like GP = GluonPropagator should be accompanied by the definition \
Abbreviation[GluonPropagator] = HoldForm[GP].\
\>", "Text",
 CellTags->"Abbreviation"],

Cell[TextData[{
 "See also:  ",
 ButtonBox["$Abbreviations",
  BaseStyle->"AddOnsLink",
  ButtonData:>"$Abbreviations",
  ButtonNote->"$Abbreviations"],
 ", ",
 ButtonBox["OneLoop",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoop",
  ButtonNote->"OneLoop"],
 ", ",
 ButtonBox["PaVeReduce",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVeReduce",
  ButtonNote->"PaVeReduce"],
 ", ",
 ButtonBox["WriteOut",
  BaseStyle->"AddOnsLink",
  ButtonData:>"WriteOut",
  ButtonNote->"WriteOut"],
 ", ",
 ButtonBox["WriteOutPaVe",
  BaseStyle->"AddOnsLink",
  ButtonData:>"WriteOutPaVe",
  ButtonNote->"WriteOutPaVe"],
 ", ",
 ButtonBox["GluonPropagator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GluonPropagator",
  ButtonNote->"GluonPropagator"],
 ", ",
 ButtonBox["GluonVertex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GluonVertex",
  ButtonNote->"GluonVertex"],
 ", ",
 ButtonBox["QuarkPropagator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"QuarkPropagator",
  ButtonNote->"QuarkPropagator"],
 "."
}], "Text",
 CellTags->"Abbreviation"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Abbreviation"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GP", "[", 
  RowBox[{"p", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", ",", " ", "a"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Nu]", ",", " ", "b"}], "}"}]}], "]"}]], "Input",
 CellTags->"Abbreviation",
 CellLabel->"In[4]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[CapitalPi]", 
    RowBox[{"a", "b"}], 
    RowBox[{"\[Mu]", "\[Nu]"}]], "(", "p", ")"}], TraditionalForm]], "Output",\

 CellTags->"Abbreviation",
 CellLabel->"Out[4]="]
}, Open  ]]
}, Open  ]],

Cell["Amplitude", "ObjectName",
 CellTags->"Amplitude"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Amplitude"],

Cell["\<\
Amplitude is a database of Feynman amplitudes. Amplitude[\"name\"] returns \
the amplitude corresponding to the string \"name\". A list of all defined \
names is obtained with Amplitude[]. New amplitudes can be added to the file \
\"Amplitude.m\". It is strongly recommended to use names that reflect the \
process. The option Gauge \[Rule] 1 means `t Hooft Feynman gauge; \
Polarization \[Rule] 0 gives unpolarized OPE-type amplitudes, Polarization \
\[Rule] 1 the polarized ones.\
\>", "Text",
 CellTags->"Amplitude"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Amplitude", "]"}]], "Input",
 CellTags->"Amplitude",
 CellLabel->"In[5]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dimension", "\[Rule]", "D"}], ",", 
    RowBox[{"Gauge", "\[Rule]", "1"}], ",", 
    RowBox[{"QuarkMass", "\[Rule]", "0"}], ",", 
    RowBox[{"Polarization", "\[Rule]", "1"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"Amplitude",
 CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynAmp",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmp",
  ButtonNote->"FeynAmp"],
 "."
}], "Text",
 CellTags->"Amplitude"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Amplitude"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Amplitude", "[", "]"}], "//", "Length"}]], "Input",
 CellTags->"Amplitude",
 CellLabel->"In[6]:="],

Cell[BoxData[
 FormBox["98", TraditionalForm]], "Output",
 CellTags->"Amplitude",
 CellLabel->"Out[6]="]
}, Open  ]],

Cell["This is the amplitude of a gluon self-energy diagram.", "Text",
 CellTags->"Amplitude"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Amplitude", "[", "\"\<se1g1\>\"", "]"}]], "Input",
 CellTags->"Amplitude",
 CellLabel->"In[7]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[CapitalPi]", 
     RowBox[{"c", "d"}], 
     RowBox[{"\[Alpha]", "\[Rho]"}]], "(", 
    FormBox[
     RowBox[{"p", "-", "q"}],
     TraditionalForm], ")"}], " ", 
   RowBox[{
    SubsuperscriptBox["\[CapitalPi]", 
     RowBox[{"e", "f"}], 
     RowBox[{"\[Beta]", "\[Sigma]"}]], "(", "q", ")"}], " ", 
   RowBox[{
    SuperscriptBox["V", 
     RowBox[{
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}]], "(", 
    RowBox[{
     FormBox[
      RowBox[{"-", "p"}],
      TraditionalForm], 
     RowBox[{",", " "}], 
     FormBox[
      RowBox[{"p", "-", "q"}],
      TraditionalForm], 
     RowBox[{",", " "}], 
     FormBox["q",
      TraditionalForm]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["V", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Alpha]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Beta]",
        TraditionalForm],
       TraditionalForm]}]], "(", 
    RowBox[{
     FormBox["p",
      TraditionalForm], 
     RowBox[{",", " "}], 
     FormBox[
      RowBox[{"q", "-", "p"}],
      TraditionalForm], 
     RowBox[{",", " "}], 
     FormBox[
      RowBox[{"-", "q"}],
      TraditionalForm]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]}]], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["d",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["f",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"Amplitude",
 CellLabel->"Out[7]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Explicit", "[", "%", "]"}]], "Input",
 CellTags->"Amplitude",
 CellLabel->"In[8]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SubsuperscriptBox["g", "s", "2"], " ", 
     SuperscriptBox["g", 
      RowBox[{"\[Alpha]", "\[Rho]"}]], " ", 
     SuperscriptBox["g", 
      RowBox[{"\[Beta]", "\[Sigma]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            FormBox["p",
             TraditionalForm], 
            FormBox[
             FormBox["\[Alpha]",
              TraditionalForm],
             TraditionalForm]]}], "-", 
          SuperscriptBox[
           FormBox["q",
            TraditionalForm], 
           FormBox[
            FormBox["\[Alpha]",
             TraditionalForm],
            TraditionalForm]]}], ")"}], " ", 
        SuperscriptBox["g", 
         RowBox[{"\[Beta]", "\[Mu]"}]]}], "+", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"\[Alpha]", "\[Mu]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            FormBox["p",
             TraditionalForm], 
            FormBox[
             FormBox["\[Beta]",
              TraditionalForm],
             TraditionalForm]]}], "-", 
          SuperscriptBox[
           FormBox["q",
            TraditionalForm], 
           FormBox[
            FormBox["\[Beta]",
             TraditionalForm],
            TraditionalForm]]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"\[Alpha]", "\[Beta]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox[
            FormBox["q",
             TraditionalForm], 
            FormBox[
             FormBox["\[Mu]",
              TraditionalForm],
             TraditionalForm]]}], "-", 
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], 
           FormBox[
            FormBox["\[Mu]",
             TraditionalForm],
            TraditionalForm]]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], 
           FormBox[
            FormBox["\[Nu]",
             TraditionalForm],
            TraditionalForm]], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            FormBox["q",
             TraditionalForm], 
            FormBox[
             FormBox["\[Nu]",
              TraditionalForm],
             TraditionalForm]]}]}], ")"}], " ", 
        SuperscriptBox["g", 
         RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], 
           FormBox[
            FormBox["\[Rho]",
             TraditionalForm],
            TraditionalForm]], "+", 
          SuperscriptBox[
           FormBox["q",
            TraditionalForm], 
           FormBox[
            FormBox["\[Rho]",
             TraditionalForm],
            TraditionalForm]]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           FormBox["q",
            TraditionalForm], 
           FormBox[
            FormBox["\[Sigma]",
             TraditionalForm],
            TraditionalForm]], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            FormBox["p",
             TraditionalForm], 
            FormBox[
             FormBox["\[Sigma]",
              TraditionalForm],
             TraditionalForm]]}]}], ")"}]}]}], ")"}], " ", 
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        FormBox["c",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["d",
         TraditionalForm],
        TraditionalForm]}]], " ", 
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        FormBox["e",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["f",
         TraditionalForm],
        TraditionalForm]}]], " ", 
     SubscriptBox["f", 
      RowBox[{
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["c",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["e",
         TraditionalForm],
        TraditionalForm]}]], " ", 
     SubscriptBox["f", 
      RowBox[{
       FormBox[
        FormBox["b",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["d",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["f",
         TraditionalForm],
        TraditionalForm]}]]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"p", "-", "q"}], ")"}], "2"], " ", 
     SuperscriptBox["q", "2"]}]]}], TraditionalForm]], "Output",
 CellTags->"Amplitude",
 CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
 "This is the amplitude for graph 6.2 from the paper Z.Phys C ",
 StyleBox["70:",
  FontWeight->"Bold"],
 "637-654, 1996",
 StyleBox[".",
  FontWeight->"Bold"]
}], "Text",
 CellTags->"Amplitude"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmp", "[", 
  RowBox[{"q1", ",", "q2", ",", 
   RowBox[{"EpsEvaluate", "[", 
    RowBox[{"Trick", "[", 
     RowBox[{"Explicit", "[", 
      RowBox[{"Amplitude", "[", "\"\<gg2\>\"", "]"}], "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"Amplitude",
 CellLabel->"In[9]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"Global`OverVector", "::", "\<\"shdw\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"Symbol \\!\\(TraditionalForm\\`\\\"OverVector\\\"\\) \
appears in multiple contexts \\!\\(TraditionalForm\\`\\({\\\"Global`\\\", \
\\\"System`\\\"}\\)\\); definitions in context \
\\!\\(TraditionalForm\\`\\\"Global`\\\"\\) may shadow or be shadowed by other \
definitions. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/shdw\\\", ButtonNote -> \
\\\"Global`OverVector::shdw\\\"]\\)\"\>"}], TraditionalForm]], "Message", \
"MSG",
 CellTags->"Amplitude"],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Integral]", 
   RowBox[{
    StyleBox[
     RowBox[{
      SuperscriptBox["\[DifferentialD]", "D"], "q1"}],
     ZeroWidthTimes->True], "\[Integral]", 
    RowBox[{
     SuperscriptBox["\[DifferentialD]", "D"], "q2"}]}], "(", 
   FormBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubsuperscriptBox["g", "s", "4"], " ", 
       SuperscriptBox["\[Epsilon]", 
        RowBox[{
         FormBox[
          FormBox[
           SubscriptBox["\[Lambda]", "1"],
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           SubscriptBox["\[Lambda]", "5"],
           TraditionalForm],
          TraditionalForm], 
         FormBox["\[CapitalDelta]",
          TraditionalForm], 
         FormBox["q2",
          TraditionalForm]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox[
              FormBox["q1",
               TraditionalForm], 
              FormBox[
               FormBox["\[Nu]",
                TraditionalForm],
               TraditionalForm]]}], "-", 
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], 
             FormBox[
              FormBox["\[Nu]",
               TraditionalForm],
              TraditionalForm]]}], ")"}], " ", 
          SuperscriptBox["g", 
           RowBox[{
            SubscriptBox["\[Lambda]", "7"], 
            SubscriptBox["\[Lambda]", "10"]}]]}], "+", 
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{"\[Nu]", 
            SubscriptBox["\[Lambda]", "10"]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox[
              FormBox["p",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "7"],
                TraditionalForm],
               TraditionalForm]]}], "-", 
            SuperscriptBox[
             FormBox["q1",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "7"],
               TraditionalForm],
              TraditionalForm]]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{"\[Nu]", 
            SubscriptBox["\[Lambda]", "7"]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox[
              FormBox["p",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "10"],
                TraditionalForm],
               TraditionalForm]]}], "-", 
            SuperscriptBox[
             FormBox["q1",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "10"],
               TraditionalForm],
              TraditionalForm]]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], 
             FormBox[
              FormBox["\[Mu]",
               TraditionalForm],
              TraditionalForm]], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              FormBox["q2",
               TraditionalForm], 
              FormBox[
               FormBox["\[Mu]",
                TraditionalForm],
               TraditionalForm]]}]}], ")"}], " ", 
          SuperscriptBox["g", 
           RowBox[{
            SubscriptBox["\[Lambda]", "1"], 
            SubscriptBox["\[Lambda]", "11"]}]]}], "+", 
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{"\[Mu]", 
            SubscriptBox["\[Lambda]", "11"]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             FormBox["q2",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "1"],
               TraditionalForm],
              TraditionalForm]], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              FormBox["p",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "1"],
                TraditionalForm],
               TraditionalForm]]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{"\[Mu]", 
            SubscriptBox["\[Lambda]", "1"]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "11"],
               TraditionalForm],
              TraditionalForm]], "+", 
            SuperscriptBox[
             FormBox["q2",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "11"],
               TraditionalForm],
              TraditionalForm]]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox[
              FormBox["p",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "10"],
                TraditionalForm],
               TraditionalForm]]}], "-", 
            SuperscriptBox[
             FormBox["q1",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "10"],
               TraditionalForm],
              TraditionalForm]], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              FormBox["q2",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "10"],
                TraditionalForm],
               TraditionalForm]]}]}], ")"}], " ", 
          SuperscriptBox["g", 
           RowBox[{
            SubscriptBox["\[Lambda]", "11"], 
            SubscriptBox["\[Lambda]", "12"]}]]}], "+", 
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{
            SubscriptBox["\[Lambda]", "10"], 
            SubscriptBox["\[Lambda]", "12"]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox[
              FormBox["p",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "11"],
                TraditionalForm],
               TraditionalForm]]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              FormBox["q1",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "11"],
                TraditionalForm],
               TraditionalForm]]}], "-", 
            SuperscriptBox[
             FormBox["q2",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "11"],
               TraditionalForm],
              TraditionalForm]]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{
            SubscriptBox["\[Lambda]", "10"], 
            SubscriptBox["\[Lambda]", "11"]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox[
              FormBox["p",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "12"],
                TraditionalForm],
               TraditionalForm]]}], "-", 
            SuperscriptBox[
             FormBox["q1",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "12"],
               TraditionalForm],
              TraditionalForm]], "-", 
            SuperscriptBox[
             FormBox["q2",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "12"],
               TraditionalForm],
              TraditionalForm]]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             FormBox["q2",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "5"],
               TraditionalForm],
              TraditionalForm]], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              FormBox["q1",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "5"],
                TraditionalForm],
               TraditionalForm]]}]}], ")"}], " ", 
          SuperscriptBox["g", 
           RowBox[{
            SubscriptBox["\[Lambda]", "7"], 
            SubscriptBox["\[Lambda]", "12"]}]]}], "+", 
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{
            SubscriptBox["\[Lambda]", "5"], 
            SubscriptBox["\[Lambda]", "12"]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             FormBox["q1",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "7"],
               TraditionalForm],
              TraditionalForm]], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox[
              FormBox["q2",
               TraditionalForm], 
              FormBox[
               FormBox[
                SubscriptBox["\[Lambda]", "7"],
                TraditionalForm],
               TraditionalForm]]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{
            SubscriptBox["\[Lambda]", "5"], 
            SubscriptBox["\[Lambda]", "7"]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             FormBox["q1",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "12"],
               TraditionalForm],
              TraditionalForm]], "+", 
            SuperscriptBox[
             FormBox["q2",
              TraditionalForm], 
             FormBox[
              FormBox[
               SubscriptBox["\[Lambda]", "12"],
               TraditionalForm],
              TraditionalForm]]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FormBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "m"],
          TraditionalForm]}], ")"}], " ", 
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q2",
            TraditionalForm]}], ")"}], 
         RowBox[{"m", "-", "1"}]],
        TraditionalForm], " ", 
       SubscriptBox["f", 
        RowBox[{
         FormBox[
          FormBox["a",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "5"],
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "11"],
           TraditionalForm],
          TraditionalForm]}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "7"],
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "10"],
           TraditionalForm],
          TraditionalForm]}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "5"],
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "7"],
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "12"],
           TraditionalForm],
          TraditionalForm]}]], " ", 
       SubscriptBox["f", 
        RowBox[{
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "10"],
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "11"],
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox[
           SubscriptBox["\<\"c\"\>", "12"],
           TraditionalForm],
          TraditionalForm]}]]}], ")"}], "/", 
     RowBox[{
      SuperscriptBox["q1", "2"], ".", 
      SuperscriptBox["q2", "2"], ".", 
      SuperscriptBox["q2", "2"], ".", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q2", "-", "p"}], ")"}], "2"], ".", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q1", "-", "q2"}], ")"}], "2"], ".", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q1", "-", "p"}], ")"}], "2"]}]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"Amplitude",
 CellLabel->"Out[9]="]
}, Open  ]]
}, Open  ]],

Cell["Amputate", "ObjectName",
 CellTags->"Amputate"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Amputate"],

Cell["\<\
Amputate[exp,q1,q2,...] amputates Eps and DiracGamma. Amputate[exp,q1,q2,Pair\
\[Rule]{p}] amputates also p.q1 and p.q2; Pair\[Rule]All amputates all except \
OPEDelta.\
\>", "Text",
 CellTags->"Amputate"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Amputate", "]"}]], "Input",
 CellTags->"Amputate",
 CellLabel->"In[10]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dimension", "\[Rule]", "D"}], ",", 
    RowBox[{"Pair", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"Unique", "\[Rule]", "True"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"Amputate",
 CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
 "See also:  ",
 ButtonBox["DiracGamma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGamma",
  ButtonNote->"DiracGamma"],
 ", ",
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix",
  ButtonNote->"DiracMatrix"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DiracSlash",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSlash",
  ButtonNote->"DiracSlash"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 "."
}], "Text",
 CellTags->"Amputate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Amputate"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracSlash", "[", "p", "]"}], ".", 
  RowBox[{"DiracSlash", "[", "q", "]"}]}]], "Input",
 CellTags->"Amputate",
 CellLabel->"In[11]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Amputate",
 CellLabel->"Out[11]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Amputate", "[", 
  RowBox[{"%", ",", "q"}], "]"}]], "Input",
 CellTags->"Amputate",
 CellLabel->"In[12]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p",
       TraditionalForm]}], ")"}], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox[
       RowBox[{"$AL$165", "\[InvisibleApplication]", 
        RowBox[{"(", "1", ")"}]}],
       TraditionalForm],
      TraditionalForm]]}], " ", 
   SuperscriptBox[
    FormBox["q",
     TraditionalForm], 
    FormBox[
     FormBox[
      RowBox[{"$AL$165", "\[InvisibleApplication]", 
       RowBox[{"(", "1", ")"}]}],
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Amputate",
 CellLabel->"Out[12]="]
}, Open  ]]
}, Open  ]],

Cell["AnomalousDimension", "ObjectName",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"AnomalousDimension"],

Cell["\<\
AnomalousDimension[name] is a database of anomalous dimensions of twist 2 \
operators.\
\>", "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "AnomalousDimension", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[13]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Polarization", "\[Rule]", "1"}], ",", 
    RowBox[{"Simplify", "\[Rule]", "FullSimplify"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[13]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 ButtonBox["SplittingFunction",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SplittingFunction",
  ButtonNote->"SplittingFunction"],
 ", ",
 ButtonBox["SumS",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SumS",
  ButtonNote->"SumS"],
 ", ",
 ButtonBox["SumT",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SumT",
  ButtonNote->"SumT"],
 "."
}], "Text",
 CellTags->"AnomalousDimension"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"AnomalousDimension"],

Cell["Polarized case", "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", " ", 
  RowBox[{"AnomalousDimension", ",", 
   RowBox[{"Polarization", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[14]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Polarization", "\[Rule]", "1"}], ",", 
    RowBox[{"Simplify", "\[Rule]", "FullSimplify"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[14]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"NS", ",", "qq", " "}], 
    RowBox[{
     RowBox[{"(", "0", ")"}], " "}]], TraditionalForm]]],
 "polarized"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "gnsqq0", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[15]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["C", "F"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"8", " ", 
      RowBox[{
       SubscriptBox["S", "1"], "(", 
       FormBox[
        RowBox[{"m", "-", "1"}],
        TraditionalForm], ")"}]}], "+", 
     FractionBox["4", "m"], "+", 
     FractionBox["4", 
      RowBox[{"m", "+", "1"}]], "-", "6"}], ")"}]}], 
  TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[15]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"S", ",", "qg", " "}], 
    RowBox[{
     RowBox[{"(", "0", ")"}], " "}]], TraditionalForm]]],
 "polarized"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "gsqg0", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[16]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["8", "m"], "-", 
     FractionBox["16", 
      RowBox[{"m", "+", "1"}]]}], ")"}], " ", 
   SubscriptBox["T", "f"]}], TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[16]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"S", ",", "gq", " "}], 
    RowBox[{
     RowBox[{"(", "0", ")"}], " "}]], TraditionalForm]]],
 "polarized"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "gsgq0", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[17]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["C", "F"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["4", 
      RowBox[{"m", "+", "1"}]], "-", 
     FractionBox["8", "m"]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[17]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"S", ",", "gg", " "}], 
    RowBox[{
     RowBox[{"(", "0", ")"}], " "}]], TraditionalForm]]],
 "polarized"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "gsgg0", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[18]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"8", " ", 
     SubscriptBox["T", "f"]}], "3"], "+", 
   RowBox[{
    SubscriptBox["C", "A"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", 
       RowBox[{
        SubscriptBox["S", "1"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      FractionBox["8", "m"], "+", 
      FractionBox["16", 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox["22", "3"]}], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[18]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"PS", ",", "qq", " "}], 
    RowBox[{
     RowBox[{"(", "0", ")"}], " "}]], TraditionalForm]]],
 "polarized"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "gpsqq1", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[19]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"16", " ", 
   SubscriptBox["C", "F"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"m", "+", "1"}]], "+", 
     FractionBox["3", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
     FractionBox["2", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "3"]], "-", 
     FractionBox["1", "m"], "-", 
     FractionBox["1", 
      SuperscriptBox["m", "2"]], "+", 
     FractionBox["2", 
      SuperscriptBox["m", "3"]]}], ")"}], " ", 
   SubscriptBox["T", "f"]}], TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[19]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"NS", ",", "qq", " "}], 
    RowBox[{
     RowBox[{"(", "1", ")"}], " "}]], TraditionalForm]]],
 "polarized"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "gnsqq1", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[20]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"16", " ", 
         RowBox[{
          SubscriptBox["S", "1"], "(", 
          FormBox[
           RowBox[{"m", "-", "1"}],
           TraditionalForm], ")"}]}], 
        SuperscriptBox["m", "2"]], "+", 
       FractionBox[
        RowBox[{"16", " ", 
         RowBox[{
          SubscriptBox["S", "1"], "(", 
          FormBox[
           RowBox[{"m", "-", "1"}],
           TraditionalForm], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
       FractionBox[
        RowBox[{"16", " ", 
         RowBox[{
          SubscriptBox["S", "2"], "(", 
          FormBox[
           RowBox[{"m", "-", "1"}],
           TraditionalForm], ")"}]}], "m"], "+", 
       FractionBox[
        RowBox[{"16", " ", 
         RowBox[{
          SubscriptBox["S", "2"], "(", 
          FormBox[
           RowBox[{"m", "-", "1"}],
           TraditionalForm], ")"}]}], 
        RowBox[{"m", "+", "1"}]], "-", 
       RowBox[{"24", " ", 
        RowBox[{
         SubscriptBox["S", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "+", 
       RowBox[{"32", " ", 
        RowBox[{
         SubscriptBox["S", "12"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "+", 
       RowBox[{"32", " ", 
        RowBox[{
         SubscriptBox["S", "21"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "+", 
       FractionBox[
        RowBox[{"32", " ", 
         RowBox[{
          SubscriptBox[
           OverscriptBox["S", "~"], "2"], "(", 
          FormBox[
           RowBox[{"m", "-", "1"}],
           TraditionalForm], ")"}]}], "m"], "+", 
       FractionBox[
        RowBox[{"32", " ", 
         RowBox[{
          SubscriptBox[
           OverscriptBox["S", "~"], "2"], "(", 
          FormBox[
           RowBox[{"m", "-", "1"}],
           TraditionalForm], ")"}]}], 
        RowBox[{"m", "+", "1"}]], "-", 
       RowBox[{"32", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "3"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "+", 
       RowBox[{"64", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "12"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "-", 
       FractionBox["40", "m"], "+", 
       FractionBox["40", 
        RowBox[{"m", "+", "1"}]], "+", 
       FractionBox["16", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
       FractionBox["8", 
        SuperscriptBox["m", "3"]], "+", 
       FractionBox["40", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "3"]], "+", "3"}], ")"}]}], " ", 
    SubsuperscriptBox["C", "F", "2"]}], "-", 
   RowBox[{
    SubscriptBox["N", "f"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["80", "9"], " ", 
       RowBox[{
        SubscriptBox["S", "1"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      RowBox[{
       FractionBox["16", "3"], " ", 
       RowBox[{
        SubscriptBox["S", "2"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      FractionBox["8", 
       RowBox[{"9", " ", "m"}]], "+", 
      FractionBox["88", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]], "-", 
      FractionBox["8", 
       RowBox[{"3", " ", 
        SuperscriptBox["m", "2"]}]], "-", 
      FractionBox["8", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
      FractionBox["2", "3"]}], ")"}], " ", 
    SubscriptBox["C", "F"]}], "-", 
   RowBox[{
    SubscriptBox["C", "A"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["536", "9"]}], " ", 
       RowBox[{
        SubscriptBox["S", "1"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "+", 
      RowBox[{
       FractionBox["88", "3"], " ", 
       RowBox[{
        SubscriptBox["S", "2"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      RowBox[{"16", " ", 
       RowBox[{
        SubscriptBox["S", "3"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      FractionBox[
       RowBox[{"16", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "-", 
      FractionBox[
       RowBox[{"16", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "+", 
      RowBox[{"16", " ", 
       RowBox[{
        SubscriptBox[
         OverscriptBox["S", "~"], "3"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      RowBox[{"32", " ", 
       RowBox[{
        SubscriptBox[
         OverscriptBox["S", "~"], "12"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "+", 
      FractionBox["212", 
       RowBox[{"9", " ", "m"}]], "-", 
      FractionBox["748", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
      FractionBox["44", 
       RowBox[{"3", " ", 
        SuperscriptBox["m", "2"]}]], "-", 
      FractionBox["4", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
      FractionBox["16", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "3"]], "+", 
      FractionBox["17", "3"]}], ")"}], " ", 
    SubscriptBox["C", "F"]}]}], TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[20]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"S", ",", "qg", " "}], 
    RowBox[{
     RowBox[{"(", "1", ")"}], " "}]], TraditionalForm]]],
 "polarized"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "gsqg1", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[21]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"8", " ", 
    SubscriptBox["C", "F"], " ", 
    SubscriptBox["T", "f"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubsuperscriptBox["S", "1", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{
         SubsuperscriptBox["S", "1", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["S", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{
         SubscriptBox["S", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "+", 
      FractionBox["14", "m"], "-", 
      FractionBox["19", 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox["1", 
       SuperscriptBox["m", "2"]], "-", 
      FractionBox["8", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "2"]], "-", 
      FractionBox["2", 
       SuperscriptBox["m", "3"]], "+", 
      FractionBox["4", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "3"]]}], ")"}]}], "+", 
   RowBox[{"16", " ", 
    SubscriptBox["C", "A"], " ", 
    SubscriptBox["T", "f"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SubsuperscriptBox["S", "1", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}], "m"]}], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubsuperscriptBox["S", "1", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       SuperscriptBox["m", "2"]], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "2"]], "-", 
      FractionBox[
       RowBox[{
        SubscriptBox["S", "2"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}], "m"], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["S", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox["4", "m"], "+", 
      FractionBox["3", 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox["3", 
       SuperscriptBox["m", "2"]], "+", 
      FractionBox["8", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
      FractionBox["2", 
       SuperscriptBox["m", "3"]], "+", 
      FractionBox["12", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "3"]]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[21]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"S", ",", "gq", " "}], 
    RowBox[{
     RowBox[{"(", "1", ")"}], " "}]], TraditionalForm]]],
 "polarized"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "gsgq1", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[22]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{
         SubsuperscriptBox["S", "1", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubsuperscriptBox["S", "1", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox[
       RowBox[{"8", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "+", 
      FractionBox[
       RowBox[{"8", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       SuperscriptBox["m", "2"]], "-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{
         SubscriptBox["S", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["S", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "+", 
      FractionBox["15", "m"], "-", 
      FractionBox["6", 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox["12", 
       SuperscriptBox["m", "2"]], "+", 
      FractionBox["3", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
      FractionBox["4", 
       SuperscriptBox["m", "3"]], "-", 
      FractionBox["2", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "3"]]}], ")"}], " ", 
    SubsuperscriptBox["C", "F", "2"]}], "+", 
   RowBox[{"32", " ", 
    SubscriptBox["T", "f"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{
          SubscriptBox["S", "1"], "(", 
          FormBox[
           RowBox[{"m", "-", "1"}],
           TraditionalForm], ")"}]}], 
        RowBox[{"3", " ", "m"}]]}], "+", 
      FractionBox[
       RowBox[{
        SubscriptBox["S", "1"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}], 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
      FractionBox["7", 
       RowBox[{"9", " ", "m"}]], "-", 
      FractionBox["2", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]], "-", 
      FractionBox["2", 
       RowBox[{"3", " ", 
        SuperscriptBox["m", "2"]}]], "+", 
      FractionBox["1", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}], ")"}], " ", 
    SubscriptBox["C", "F"]}], "+", 
   RowBox[{"8", " ", 
    SubscriptBox["C", "A"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{
          SubsuperscriptBox["S", "1", "2"], "(", 
          FormBox[
           RowBox[{"m", "-", "1"}],
           TraditionalForm], ")"}]}], "m"]}], "+", 
      FractionBox[
       RowBox[{
        SubsuperscriptBox["S", "1", "2"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}], 
       RowBox[{"m", "+", "1"}]], "+", 
      FractionBox[
       RowBox[{"16", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"3", " ", "m"}]], "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox["S", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "-", 
      FractionBox[
       RowBox[{
        SubscriptBox["S", "2"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}], 
       RowBox[{"m", "+", "1"}]], "+", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "-", 
      FractionBox["56", 
       RowBox[{"9", " ", "m"}]], "-", 
      FractionBox["20", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
      FractionBox["28", 
       RowBox[{"3", " ", 
        SuperscriptBox["m", "2"]}]], "-", 
      FractionBox["38", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
      FractionBox["4", 
       SuperscriptBox["m", "3"]], "-", 
      FractionBox["6", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "3"]]}], ")"}], " ", 
    SubscriptBox["C", "F"]}]}], TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[22]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"S", ",", "gg", " "}], 
    RowBox[{
     RowBox[{"(", "1", ")"}], " "}]], TraditionalForm]]],
 "polarized"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "gsgg1", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[23]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"8", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       SuperscriptBox["m", "2"]], "-", 
      FractionBox[
       RowBox[{"16", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
      RowBox[{
       FractionBox["134", "9"], " ", 
       RowBox[{
        SubscriptBox["S", "1"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "+", 
      FractionBox[
       RowBox[{"8", " ", 
        RowBox[{
         SubscriptBox["S", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "-", 
      FractionBox[
       RowBox[{"16", " ", 
        RowBox[{
         SubscriptBox["S", "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "+", 
      RowBox[{"4", " ", 
       RowBox[{
        SubscriptBox["S", "3"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      RowBox[{"8", " ", 
       RowBox[{
        SubscriptBox["S", "12"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      RowBox[{"8", " ", 
       RowBox[{
        SubscriptBox["S", "21"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "+", 
      FractionBox[
       RowBox[{"8", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], "m"], "-", 
      FractionBox[
       RowBox[{"16", " ", 
        RowBox[{
         SubscriptBox[
          OverscriptBox["S", "~"], "2"], "(", 
         FormBox[
          RowBox[{"m", "-", "1"}],
          TraditionalForm], ")"}]}], 
       RowBox[{"m", "+", "1"}]], "+", 
      RowBox[{"4", " ", 
       RowBox[{
        SubscriptBox[
         OverscriptBox["S", "~"], "3"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      RowBox[{"8", " ", 
       RowBox[{
        SubscriptBox[
         OverscriptBox["S", "~"], "12"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "-", 
      FractionBox["107", 
       RowBox[{"9", " ", "m"}]], "+", 
      FractionBox["241", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
      FractionBox["58", 
       RowBox[{"3", " ", 
        SuperscriptBox["m", "2"]}]], "-", 
      FractionBox["86", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
      FractionBox["8", 
       SuperscriptBox["m", "3"]], "-", 
      FractionBox["48", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "3"]], "-", 
      FractionBox["16", "3"]}], ")"}], " ", 
    SubsuperscriptBox["C", "A", "2"]}], "+", 
   RowBox[{"32", " ", 
    SubscriptBox["T", "f"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["5", "9"]}], " ", 
       RowBox[{
        SubscriptBox["S", "1"], "(", 
        FormBox[
         RowBox[{"m", "-", "1"}],
         TraditionalForm], ")"}]}], "+", 
      FractionBox["14", 
       RowBox[{"9", " ", "m"}]], "-", 
      FractionBox["19", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]], "-", 
      FractionBox["1", 
       RowBox[{"3", " ", 
        SuperscriptBox["m", "2"]}]], "-", 
      FractionBox["1", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "+", 
      FractionBox["1", "3"]}], ")"}], " ", 
    SubscriptBox["C", "A"]}], "+", 
   RowBox[{"8", " ", 
    SubscriptBox["C", "F"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["10", 
        RowBox[{"m", "+", "1"}]]}], "+", 
      FractionBox["2", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "2"]], "+", 
      FractionBox["4", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "3"]], "+", "1", "+", 
      FractionBox["10", "m"], "-", 
      FractionBox["10", 
       SuperscriptBox["m", "2"]], "+", 
      FractionBox["4", 
       SuperscriptBox["m", "3"]]}], ")"}], " ", 
    SubscriptBox["T", "f"]}]}], TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[23]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["\[Gamma]", 
    RowBox[{"S", ",", "gg", " "}], 
    RowBox[{
     RowBox[{"(", "1", ")"}], " "}]], TraditionalForm]]],
 "polarized (different representation)"
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AnomalousDimension", "[", "GSGG1", "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[24]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"m", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"m", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"m", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"48", " ", "m", " ", 
                    RowBox[{"(", 
                    RowBox[{"m", "+", "3"}], ")"}]}], "+", "469"}], ")"}]}], 
                  "+", "698"}], ")"}]}], "+", "7"}], ")"}]}], "+", "258"}], 
           ")"}]}], "+", "144"}], 
        RowBox[{"9", " ", 
         SuperscriptBox["m", "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "3"]}]]}], "+", 
      FractionBox[
       RowBox[{"8", " ", 
        RowBox[{
         SubsuperscriptBox["S", "2", "'"], "\[NoBreak]", "(", "\[NoBreak]", 
         FormBox[
          FractionBox["m", "2"],
          TraditionalForm], "\[NoBreak]", ")"}]}], 
       RowBox[{"m", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]], "-", 
      RowBox[{
       SubsuperscriptBox["S", "3", "'"], "\[NoBreak]", "(", "\[NoBreak]", 
       FormBox[
        FractionBox["m", "2"],
        TraditionalForm], "\[NoBreak]", ")"}], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"67", " ", "m", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}], "2"]}], "+", "144"}], ")"}]}],
           "+", "72"}], ")"}], " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox["m",
          TraditionalForm], ")"}]}], 
       RowBox[{"9", " ", 
        SuperscriptBox["m", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
      RowBox[{"4", " ", 
       RowBox[{
        SubsuperscriptBox["S", "2", "'"], "\[NoBreak]", "(", "\[NoBreak]", 
        FormBox[
         FractionBox["m", "2"],
         TraditionalForm], "\[NoBreak]", ")"}], " ", 
       RowBox[{
        SubscriptBox["S", "1"], "(", 
        FormBox["m",
         TraditionalForm], ")"}]}], "+", 
      RowBox[{"8", " ", 
       RowBox[{
        OverscriptBox["S", "~"], "(", 
        FormBox["m",
         TraditionalForm], ")"}]}]}], ")"}], " ", 
    SubsuperscriptBox["C", "A", "2"]}], "+", 
   RowBox[{"32", " ", 
    SubscriptBox["T", "f"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"m", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "m", " ", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "+", "13"}], ")"}]}], "-", 
        "3"}], 
       RowBox[{"9", " ", 
        SuperscriptBox["m", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{
         SubscriptBox["S", "1"], "(", 
         FormBox["m",
          TraditionalForm], ")"}]}], "9"]}], ")"}], " ", 
    SubscriptBox["C", "A"]}], "+", 
   FractionBox[
    RowBox[{"8", " ", 
     SubscriptBox["C", "F"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"m", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"m", " ", 
                    RowBox[{"(", 
                    RowBox[{"m", "+", "3"}], ")"}]}], "+", "5"}], ")"}]}], 
                "+", "1"}], ")"}]}], "-", "8"}], ")"}]}], "+", "2"}], ")"}]}],
        "+", "4"}], ")"}], " ", 
     SubscriptBox["T", "f"]}], 
    RowBox[{
     SuperscriptBox["m", "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "3"]}]]}], TraditionalForm]], "Output",\

 CellTags->"AnomalousDimension",
 CellLabel->"Out[24]="]
}, Open  ]],

Cell[TextData[{
 "Check that all odd moments give the same for the two representations of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Gamma]", 
     RowBox[{"S", ",", "gg", " "}], 
     RowBox[{
      RowBox[{"(", "1", ")"}], " "}]], "."}], TraditionalForm]]]
}], "Text",
 CellTags->"AnomalousDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"%", "-", "%%"}], "/.", 
    RowBox[{"OPEm", "\[Rule]", "ij"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"ij", ",", "1", ",", "17", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"AnomalousDimension",
 CellLabel->"In[25]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
    ",", "0"}], "}"}], TraditionalForm]], "Output",
 CellTags->"AnomalousDimension",
 CellLabel->"Out[25]="]
}, Open  ]]
}, Open  ]],

Cell["AntiCommutator", "ObjectName",
 CellTags->"AntiCommutator"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"AntiCommutator"],

Cell["\<\
AntiCommutator[x, y] = c defines the anti-commutator of the non commuting \
objects x and y.\
\>", "Text",
 CellTags->"AntiCommutator"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Commutator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Commutator",
  ButtonNote->"Commutator"],
 ", ",
 ButtonBox["CommutatorExplicit",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CommutatorExplicit",
  ButtonNote->"CommutatorExplicit"],
 ", ",
 ButtonBox["DeclareNonCommutative",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DeclareNonCommutative",
  ButtonNote->"DeclareNonCommutative"],
 ", ",
 ButtonBox["DotSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DotSimplify",
  ButtonNote->"DotSimplify"],
 "."
}], "Text",
 CellTags->"AntiCommutator"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"AntiCommutator"],

Cell[TextData[{
 "This declares ",
 StyleBox["a",
  FontFamily->"Courier"],
 " and ",
 StyleBox["b",
  FontFamily->"Courier"],
 " as noncommutative variables."
}], "Text",
 CellTags->"AntiCommutator"],

Cell[BoxData[
 RowBox[{"DeclareNonCommutative", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[26]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AntiCommutator", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[27]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", "a", ",", "\[MediumSpace]", "b", "}"}], 
  TraditionalForm]], "Output",
 CellTags->"AntiCommutator",
 CellLabel->"Out[27]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommutatorExplicit", "[", "%", "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[28]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "b"}], "+", 
   RowBox[{"b", ".", "a"}]}], TraditionalForm]], "Output",
 CellTags->"AntiCommutator",
 CellLabel->"Out[28]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommutatorExplicit", "[", 
  RowBox[{"AntiCommutator", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"a", "-", 
     RowBox[{"2", "b"}]}]}], " ", "]"}], "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[29]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", 
      RowBox[{"2", " ", "b"}]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{"a", "-", 
      RowBox[{"2", " ", "b"}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"AntiCommutator",
 CellLabel->"Out[29]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", 
  RowBox[{"AntiCommutator", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"a", "-", 
     RowBox[{"2", "b"}]}]}], " ", "]"}], "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[30]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"a", ".", "a"}]}], "-", 
   RowBox[{"a", ".", "b"}], "-", 
   RowBox[{"b", ".", "a"}], "-", 
   RowBox[{"4", " ", 
    RowBox[{"b", ".", "b"}]}]}], TraditionalForm]], "Output",
 CellTags->"AntiCommutator",
 CellLabel->"Out[30]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DeclareNonCommutative", "[", 
  RowBox[{"c", ",", "d", ",", 
   OverscriptBox["c", "~"], ",", 
   OverscriptBox["d", "~"]}], "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[31]:="],

Cell["Defining {c,d} = z results in replacements of c.d by z-d.c.", "Text",
 CellTags->"AntiCommutator"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AntiCommutator", "[", 
   RowBox[{"c", ",", "d"}], "]"}], " ", "=", " ", "z"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[32]:="],

Cell[BoxData[
 FormBox["z", TraditionalForm]], "Output",
 CellTags->"AntiCommutator",
 CellLabel->"Out[32]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", " ", 
  RowBox[{"d", " ", ".", " ", "c", " ", ".", " ", "d"}], " ", "]"}]], "Input",\

 CellTags->"AntiCommutator",
 CellLabel->"In[33]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"d", " ", "z"}], "-", 
   RowBox[{"d", ".", "d", ".", "c"}]}], TraditionalForm]], "Output",
 CellTags->"AntiCommutator",
 CellLabel->"Out[33]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AntiCommutator", "[", 
   RowBox[{
    OverscriptBox["d", "~"], ",", 
    OverscriptBox["c", "~"]}], "]"}], " ", "=", " ", 
  OverscriptBox["z", "~"]}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[34]:="],

Cell[BoxData[
 FormBox[
  OverscriptBox["z", "~"], TraditionalForm]], "Output",
 CellTags->"AntiCommutator",
 CellLabel->"Out[34]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", " ", 
  RowBox[{
   OverscriptBox["d", "~"], " ", ".", " ", 
   OverscriptBox["c", "~"], " ", ".", " ", 
   OverscriptBox["d", "~"]}], " ", "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[35]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    OverscriptBox["d", "~"], " ", 
    OverscriptBox["z", "~"]}], "-", 
   RowBox[{
    OverscriptBox["c", "~"], ".", 
    OverscriptBox["d", "~"], ".", 
    OverscriptBox["d", "~"]}]}], TraditionalForm]], "Output",
 CellTags->"AntiCommutator",
 CellLabel->"Out[35]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"UnDeclareNonCommutative", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", 
   OverscriptBox["c", "~"], ",", 
   OverscriptBox["d", "~"]}], "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[36]:="],

Cell[BoxData[
 RowBox[{"Unset", "[", 
  RowBox[{"AntiCommutator", "[", 
   RowBox[{"c", ",", "d"}], "]"}], "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[37]:="],

Cell[BoxData[
 RowBox[{"Unset", "[", 
  RowBox[{"AntiCommutator", "[", 
   RowBox[{
    OverscriptBox["d", "~"], ",", 
    OverscriptBox["c", "~"]}], "]"}], "]"}]], "Input",
 CellTags->"AntiCommutator",
 CellLabel->"In[38]:="]
}, Open  ]],

Cell["AntiQuarkField", "ObjectName",
 CellTags->"AntiQuarkField"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"AntiQuarkField"],

Cell["\<\
AntiQuarkField is the name of a fermionic field. AntiQuarkField is just a \
name with no functional properties. Only typeset rules are attached.\
\>", "Text",
 CellTags->"AntiQuarkField"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["QuantumField",
  BaseStyle->"AddOnsLink",
  ButtonData:>"QuantumField",
  ButtonNote->"QuantumField"],
 ", ",
 ButtonBox["QuarkField",
  BaseStyle->"AddOnsLink",
  ButtonData:>"QuarkField",
  ButtonNote->"QuarkField"],
 "."
}], "Text",
 CellTags->"AntiQuarkField"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"AntiQuarkField"],

Cell[CellGroupData[{

Cell[BoxData["AntiQuarkField"], "Input",
 CellTags->"AntiQuarkField",
 CellLabel->"In[39]:="],

Cell[BoxData[
 FormBox[
  OverscriptBox["\[Psi]", "_"], TraditionalForm]], "Output",
 CellTags->"AntiQuarkField",
 CellLabel->"Out[39]="]
}, Open  ]]
}, Open  ]],

Cell["AntiSymmetrize", "ObjectName",
 CellTags->"AntiSymmetrize"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"AntiSymmetrize"],

Cell["\<\
AntiSymmetrize[expr, {a1, a2, ...}] antisymmetrizes expr with respect to the \
variables a1,a2, ... \
\>", "Text",
 CellTags->"AntiSymmetrize"],

Cell[TextData[{
 "See also: ",
 ButtonBox["Symmetrize",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Symmetrize",
  ButtonNote->"Symmetrize"],
 "."
}], "Text",
 CellTags->"AntiSymmetrize"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"AntiSymmetrize"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AntiSymmetrize", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellTags->"AntiSymmetrize",
 CellLabel->"In[40]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"a", ",", "b"}], ")"}], "-", 
     RowBox[{"f", "(", 
      RowBox[{"b", ",", "a"}], ")"}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"AntiSymmetrize",
 CellLabel->"Out[40]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AntiSymmetrize", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellTags->"AntiSymmetrize",
 CellLabel->"In[41]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"x", ",", "y", ",", "z"}], ")"}], "-", 
     RowBox[{"f", "(", 
      RowBox[{"x", ",", "z", ",", "y"}], ")"}], "-", 
     RowBox[{"f", "(", 
      RowBox[{"y", ",", "x", ",", "z"}], ")"}], "+", 
     RowBox[{"f", "(", 
      RowBox[{"y", ",", "z", ",", "x"}], ")"}], "+", 
     RowBox[{"f", "(", 
      RowBox[{"z", ",", "x", ",", "y"}], ")"}], "-", 
     RowBox[{"f", "(", 
      RowBox[{"z", ",", "y", ",", "x"}], ")"}]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellTags->"AntiSymmetrize",
 CellLabel->"Out[41]="]
}, Open  ]]
}, Open  ]],

Cell["Anti5", "ObjectName",
 CellTags->"Anti5"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Anti5"],

Cell[TextData[{
 "Anti5[exp] anticommutes all ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 "in exp to the right. Anti5[exp, n] anticommutes all ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", 
    RowBox[{"5", " "}]], TraditionalForm]]],
 "n times to the right. Anti5[exp, -n] anticommutes all ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 " n times to the left."
}], "Text",
 CellTags->"Anti5"],

Cell[TextData[{
 "The naive ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 "scheme is used."
}], "Text",
 CellTags->"Anti5"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracOrder",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracOrder",
  ButtonNote->"DiracOrder"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 "."
}], "Text",
 CellTags->"Anti5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Anti5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracMatrix", "[", 
   RowBox[{"5", ",", "\[Mu]"}], "]"}], " "}]], "Input",
 CellTags->"Anti5",
 CellLabel->"In[42]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"Anti5",
 CellLabel->"Out[42]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Anti5", "[", "%", "]"}]], "Input",
 CellTags->"Anti5",
 CellLabel->"In[43]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", "5"]}]}], TraditionalForm]], "Output",
 CellTags->"Anti5",
 CellLabel->"Out[43]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Anti5", "[", 
  RowBox[{"%", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellTags->"Anti5",
 CellLabel->"In[44]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Anti5",
 CellLabel->"Out[44]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracMatrix", "[", 
  RowBox[{
  "5", ",", "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", ",", "\[Delta]"}], 
  "]"}]], "Input",
 CellTags->"Anti5",
 CellLabel->"In[45]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], 
   SuperscriptBox["\[Gamma]", "\[Alpha]"], 
   SuperscriptBox["\[Gamma]", "\[Beta]"], 
   SuperscriptBox["\[Gamma]", "\[Gamma]"], 
   SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output",
 CellTags->"Anti5",
 CellLabel->"Out[45]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Anti5", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellTags->"Anti5",
 CellLabel->"In[46]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], 
   SuperscriptBox["\[Gamma]", "\[Alpha]"], 
   SuperscriptBox["\[Gamma]", "\[Beta]"], 
   SuperscriptBox["\[Gamma]", "\[Gamma]"], 
   SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output",
 CellTags->"Anti5",
 CellLabel->"Out[46]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Anti5", "[", 
  RowBox[{"%%", ",", "Infinity"}], "]"}]], "Input",
 CellTags->"Anti5",
 CellLabel->"In[47]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], 
   SuperscriptBox["\[Gamma]", "\[Alpha]"], 
   SuperscriptBox["\[Gamma]", "\[Beta]"], 
   SuperscriptBox["\[Gamma]", "\[Gamma]"], 
   SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output",
 CellTags->"Anti5",
 CellLabel->"Out[47]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Anti5", "[", 
  RowBox[{"%", ",", 
   RowBox[{"-", "Infinity"}]}], "]"}]], "Input",
 CellTags->"Anti5",
 CellLabel->"In[48]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], 
   SuperscriptBox["\[Gamma]", "\[Alpha]"], 
   SuperscriptBox["\[Gamma]", "\[Beta]"], 
   SuperscriptBox["\[Gamma]", "\[Gamma]"], 
   SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output",
 CellTags->"Anti5",
 CellLabel->"Out[48]="]
}, Open  ]],

Cell[TextData[{
 "In the naive ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 "- scheme D-dimensional ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 "-matrices anticommute with ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"Anti5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GAD", "[", 
  RowBox[{"5", ",", "\[Mu]"}], "]"}]], "Input",
 CellTags->"Anti5",
 CellLabel->"In[49]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"Anti5",
 CellLabel->"Out[49]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Anti5", "[", "%", "]"}]], "Input",
 CellTags->"Anti5",
 CellLabel->"In[50]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", "5"]}]}], TraditionalForm]], "Output",
 CellTags->"Anti5",
 CellLabel->"Out[50]="]
}, Open  ]]
}, Open  ]],

Cell["Apart2", "ObjectName",
 CellTags->"Apart2"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Apart2"],

Cell["\<\
Apart2[expr] partial fractions FeynAmpDenominators (and FAD's).\
\>", "Text",
 CellTags->"Apart2"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FAD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FAD",
  ButtonNote->"FAD"],
 ", ",
 ButtonBox["FeynAmpDenominator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmpDenominator",
  ButtonNote->"FeynAmpDenominator"],
 "."
}], "Text",
 CellTags->"Apart2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Apart2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FAD", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"q", ",", "m"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "M"}], "}"}], ",", 
   RowBox[{"q", "-", "p"}]}], "]"}]], "Input",
 CellTags->"Apart2",
 CellLabel->"In[51]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"q", "-", "p"}], ")"}], "2"], 
       "\[InvisibleSpace]", "\<\"]\"\>"}],
      SequenceForm["[", (-$CellContext`p + $CellContext`q)^2, "]"],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
       SuperscriptBox["q", "2"], "\[InvisibleSpace]", "\<\"-\"\>", 
       "\[InvisibleSpace]", 
       SuperscriptBox["m", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
      SequenceForm["[", $CellContext`q^2, "-", $CellContext`m^2, "]"],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
       SuperscriptBox["q", "2"], "\[InvisibleSpace]", "\<\"-\"\>", 
       "\[InvisibleSpace]", 
       SuperscriptBox["M", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
      SequenceForm["[", $CellContext`q^2, "-", $CellContext`M^2, "]"],
      Editable->False], ")"}]}]], TraditionalForm]], "Output",
 CellTags->"Apart2",
 CellLabel->"Out[51]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart2", "[", "%", "]"}]], "Input",
 CellTags->"Apart2",
 CellLabel->"In[52]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["q", "2"], "-", 
        SuperscriptBox["m", "2"]}], ")"}], ".", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["q", "2"], "-", 
        SuperscriptBox["M", "2"]}], ")"}], ".", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q", "-", "p"}], ")"}], "2"]}]]}], 
   RowBox[{
    SuperscriptBox["m", "2"], "-", 
    SuperscriptBox["M", "2"]}]], TraditionalForm]], "Output",
 CellTags->"Apart2",
 CellLabel->"Out[52]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"FCE", "[", "%", "]"}], "]"}]], "Input",
 CellTags->"Apart2",
 CellLabel->"In[53]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"FAD", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", ",", "m"}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "p"}], "+", "q"}]}], "]"}], "-", 
   RowBox[{"FAD", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", ",", "M"}], "}"}], ",", 
     RowBox[{
      RowBox[{"-", "p"}], "+", "q"}]}], "]"}]}], 
  RowBox[{
   SuperscriptBox["m", "2"], "-", 
   SuperscriptBox["M", "2"]}]]], "Output",
 CellTags->"Apart2",
 CellLabel->"Out[53]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["A0", "ObjectName",
 PageBreakAbove->True,
 CellTags->"A0"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"A0"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"A0", "[", 
    SuperscriptBox["m", "2"], "]"}], TraditionalForm]]],
 "is the Passarino-Veltman one-point integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["A", "0"], "."}], TraditionalForm]]]
}], "Text",
 CellTags->"A0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", " ", "A0", "]"}]], "Input",
 CellTags->"A0",
 CellLabel->"In[54]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"A0ToB0", "\[Rule]", "False"}], "}"}], TraditionalForm]], "Output",\

 CellTags->"A0",
 CellLabel->"Out[54]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 ", ",
 ButtonBox["C0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"C0",
  ButtonNote->"C0"],
 ", ",
 ButtonBox["D0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"D0",
  ButtonNote->"D0"],
 ", ",
 ButtonBox["PaVe",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVe",
  ButtonNote->"PaVe"],
 "."
}], "Text",
 CellTags->"A0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"A0"],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "0"], TraditionalForm]]],
 " is not expressed in terms of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "0"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"A0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A0", "[", 
  SuperscriptBox["m", "2"], "]"}]], "Input",
 CellTags->"A0",
 CellLabel->"In[55]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
    TraditionalForm], "(", 
   FormBox[
    SuperscriptBox["m", "2"],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"A0",
 CellLabel->"Out[55]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"A0", ",", 
    RowBox[{"A0ToB0", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellTags->"A0",
 CellLabel->"In[56]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A0", "[", 
  SuperscriptBox["m", "2"], "]"}]], "Input",
 CellTags->"A0",
 CellLabel->"In[57]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["B", "0"], "(", "0", ",", 
     SuperscriptBox["m", "2"], ",", 
     SuperscriptBox["m", "2"], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   SuperscriptBox["m", "2"]}], TraditionalForm]], "Output",
 CellTags->"A0",
 CellLabel->"Out[57]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"A0", ",", 
    RowBox[{"A0ToB0", "\[Rule]", "False"}]}], "]"}], ";"}]], "Input",
 CellTags->"A0",
 CellLabel->"In[58]:="],

Cell[TextData[{
 "According to the rules of dimensional regularization ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["A", "0"], "(", "0", ")"}], TraditionalForm]]],
 " is set to 0."
}], "Text",
 CellTags->"A0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A0", "[", "0", "]"}]], "Input",
 CellTags->"A0",
 CellLabel->"In[59]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"A0",
 CellLabel->"Out[59]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A0", "[", 
  RowBox[{"SmallVariable", "[", 
   RowBox[{"M", "^", "2"}], "]"}], "]"}]], "Input",
 CellTags->"A0",
 CellLabel->"In[60]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"A0",
 CellLabel->"Out[60]="]
}, Open  ]]
}, Open  ]],

Cell["A0ToB0", "ObjectName",
 PageBreakAbove->True,
 CellTags->"A0ToB0"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"A0ToB0"],

Cell[TextData[{
 "A0ToB0 is an option for A0. If set to True, A0[",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["m",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 "] is expressed by (1 + B0[0, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["m",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["m",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 "]) ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["m",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"A0ToB0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", " ", "A0", "]"}]], "Input",
 CellTags->"A0ToB0",
 CellLabel->"In[61]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"A0ToB0", "\[Rule]", "False"}], "}"}], TraditionalForm]], "Output",\

 CellTags->"A0ToB0",
 CellLabel->"Out[61]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["A0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"A0",
  ButtonNote->"A0"],
 ", ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 ", ",
 ButtonBox["C0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"C0",
  ButtonNote->"C0"],
 ", ",
 ButtonBox["D0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"D0",
  ButtonNote->"D0"],
 ", ",
 ButtonBox["PaVe",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVe",
  ButtonNote->"PaVe"],
 "."
}], "Text",
 CellTags->"A0ToB0"]
}, Open  ]],

Cell["BackgroundGluonVertex", "ObjectName",
 CellTags->"BackgroundGluonVertex"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"BackgroundGluonVertex"],

Cell[TextData[{
 "BackgroundGluonVertex[{p,mu,a}, {q,nu,b}, {k,la,c}] or \
BackgroundGluonVertex[ p,mu,a , q,nu,b , k,la,c ] yields the 3-gluon vertex \
in the background field gauge, where the first set of arguments corresponds \
to the external background field. BackgroundGluonVertex[{p,mu,a}, {q,nu,b}, \
{k,la,c}, {s,si,d}] or BackgroundGluonVertex[{mu,a}, {nu,b}, {la,c}, {",
 "si",
 ",d}] or BackgroundGluonVertex[p,mu,a , q,nu,b , k,la,c , s,si,d] or \
BackgroundGluonVertex[ mu,a , nu,b , la,c , si,d ] yields the 4-gluon vertex, \
with {p,mu,a} and {k,la,c} denoting the external background fields. The \
gauge, dimension and the name of the coupling constant are determined by the \
options Gauge, Dimension and CouplingConstant. The Feynman rules are taken \
from L.Abbot ",
 StyleBox["NPB ",
  FontWeight->"Bold"],
 "185 (1981), 189-203; except that all momenta are incoming. Note that Abbots \
coupling constant convention is consistent with the default setting of \
GluonVertex."
}], "Text",
 CellTags->"BackgroundGluonVertex"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "BackgroundGluonVertex", "]"}]], "Input",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"In[62]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dimension", "\[Rule]", "D"}], ",", 
    RowBox[{"CouplingConstant", "\[Rule]", 
     SubscriptBox["g", "s"]}], ",", 
    RowBox[{"Gauge", "\[Rule]", "1"}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"Out[62]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["GluonVertex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GluonVertex",
  ButtonNote->"GluonVertex"],
 "."
}], "Text",
 CellTags->"BackgroundGluonVertex"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"BackgroundGluonVertex"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BackgroundGluonVertex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "\[Lambda]", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"In[63]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FormBox[
         RowBox[{"p", "-", "k", "-", "q"}],
         TraditionalForm], ")"}], 
       FormBox[
        FormBox["\[Lambda]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Lambda]", "\[Nu]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FormBox[
         RowBox[{"q", "-", "k"}],
         TraditionalForm], ")"}], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Lambda]", "\[Mu]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FormBox[
         RowBox[{"k", "-", "p", "+", "q"}],
         TraditionalForm], ")"}], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]]}]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"Out[63]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BackgroundGluonVertex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "\[Lambda]", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "\[Sigma]", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"In[64]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", 
   SubsuperscriptBox["g", "s", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Sigma]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Nu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Sigma]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Mu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Nu]", "\[Sigma]"}]]}]}], ")"}], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u6",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u6",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Sigma]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Nu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Sigma]"}]]}]}], ")"}], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u6",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u6",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Sigma]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Nu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Sigma]"}]]}], "+", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Mu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Nu]", "\[Sigma]"}]]}]}], ")"}], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u6",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u6",
          TraditionalForm],
         TraditionalForm]}]]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"Out[64]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BackgroundGluonVertex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "\[Lambda]", ",", "c"}], "}"}], ",", 
   RowBox[{"Gauge", "\[Rule]", "\[Alpha]"}]}], "]"}]], "Input",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"In[65]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FormBox[
         RowBox[{"p", "-", 
          FractionBox["k", "\[Alpha]"], "-", "q"}],
         TraditionalForm], ")"}], 
       FormBox[
        FormBox["\[Lambda]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Lambda]", "\[Nu]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FormBox[
         RowBox[{"q", "-", "k"}],
         TraditionalForm], ")"}], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Lambda]", "\[Mu]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FormBox[
         RowBox[{"k", "-", "p", "+", 
          FractionBox["q", "\[Alpha]"]}],
         TraditionalForm], ")"}], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]]}]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"Out[65]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BackgroundGluonVertex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "\[Lambda]", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "\[Sigma]", ",", "d"}], "}"}], ",", 
   RowBox[{"Gauge", "\[Rule]", "\[Alpha]"}]}], "]"}]], "Input",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"In[66]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", 
   SubsuperscriptBox["g", "s", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Sigma]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{"\[Lambda]", "\[Nu]"}]], " ", 
          SuperscriptBox["g", 
           RowBox[{"\[Mu]", "\[Sigma]"}]]}], "\[Alpha]"], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Mu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Nu]", "\[Sigma]"}]]}]}], ")"}], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u7",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u7",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Sigma]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Nu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Sigma]"}]]}]}], ")"}], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u7",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u7",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["g", 
           RowBox[{"\[Lambda]", "\[Sigma]"}]], " ", 
          SuperscriptBox["g", 
           RowBox[{"\[Mu]", "\[Nu]"}]]}], "\[Alpha]"], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Nu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Sigma]"}]]}], "+", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Lambda]", "\[Mu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Nu]", "\[Sigma]"}]]}]}], ")"}], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u7",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u7",
          TraditionalForm],
         TraditionalForm]}]]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"BackgroundGluonVertex",
 CellLabel->"Out[66]="]
}, Open  ]]
}, Open  ]],

Cell["Bracket", "ObjectName",
 CellTags->"Bracket"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Bracket"],

Cell["Bracket is an option of Convolute.", "Text",
 CellTags->"Bracket"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Convolute",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Convolute",
  ButtonNote->"Convolute"],
 "."
}], "Text",
 CellTags->"Bracket"]
}, Open  ]],

Cell["BReduce", "ObjectName",
 PageBreakAbove->True,
 CellTags->"BReduce"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"BReduce"],

Cell["\<\
BReduce is an option for B0, B00, B1, B11 determining whether reductions to \
A0 and B0 will be done. \
\>", "Text",
 CellTags->"BReduce"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["A0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"A0",
  ButtonNote->"A0"],
 ", ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 ", ",
 ButtonBox["B00",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B00",
  ButtonNote->"B00"],
 ", ",
 ButtonBox["B1",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B1",
  ButtonNote->"B1"],
 ", ",
 ButtonBox["B11",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B11",
  ButtonNote->"B11"],
 "."
}], "Text",
 CellTags->"BReduce"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"BReduce"],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "0"], TraditionalForm]]],
 " is not expressed in terms of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "0"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"BReduce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"0", ",", "s", ",", "s"}], "]"}]], "Input",
 CellTags->"BReduce",
 CellLabel->"In[67]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["B", "0"], "(", "0", ",", "s", ",", "s", ")"}], 
  TraditionalForm]], "Output",
 CellTags->"BReduce",
 CellLabel->"Out[67]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "//", "Options"}]], "Input",
 CellLabel->"In[68]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BReduce", "\[Rule]", "False"}], ",", 
    RowBox[{"B0Unique", "\[Rule]", "False"}], ",", 
    RowBox[{"B0Real", "\[Rule]", "False"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[68]="]
}, Open  ]],

Cell["\<\
With BReduce\[Rule]True, transformation is done.\
\>", "Text",
 CellTags->"BReduce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"0", ",", "s", ",", "s", ",", 
   RowBox[{"BReduce", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"BReduce",
 CellLabel->"In[69]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     FormBox[
      SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
      TraditionalForm], "(", "s", ")"}], "s"], "-", "1"}], 
  TraditionalForm]], "Output",
 CellTags->"BReduce",
 CellLabel->"Out[69]="]
}, Open  ]]
}, Open  ]],

Cell["B0", "ObjectName",
 CellTags->"B0"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"B0"],

Cell[TextData[{
 "B0[pp, ma^2, mb^2] is the Passarino-Veltman two-point integral ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "0"], TraditionalForm]]],
 ". All arguments are scalars and have dimension mass^2. If the option \
BReduce is set to True certain B0's are reduced to A0's. Setting the option \
B0Unique to True simplifies B0[a,0,a] and B0[0,0,a]."
}], "Text",
 CellTags->"B0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "B0", "]"}]], "Input",
 CellTags->"B0",
 CellLabel->"In[70]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BReduce", "\[Rule]", "False"}], ",", 
    RowBox[{"B0Unique", "\[Rule]", "False"}], ",", 
    RowBox[{"B0Real", "\[Rule]", "False"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"B0",
 CellLabel->"Out[70]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["B1",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B1",
  ButtonNote->"B1"],
 ", ",
 ButtonBox["B00",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B00",
  ButtonNote->"B00"],
 ", ",
 ButtonBox["B11",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B11",
  ButtonNote->"B11"],
 ", ",
 ButtonBox["PaVe",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVe",
  ButtonNote->"PaVe"],
 "."
}], "Text",
 CellTags->"B0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"B0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "p"}], "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B0",
 CellLabel->"In[71]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["B", "0"], "(", 
   FormBox[
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"],
    TraditionalForm], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"], ")"}], TraditionalForm]], "Output",
 CellTags->"B0",
 CellLabel->"Out[71]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"B0", ",", 
    RowBox[{"B0Unique", "\[Rule]", "True"}], ",", 
    RowBox[{"B0Real", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellTags->"B0",
 CellLabel->"In[72]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"0", ",", "0", ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B0",
 CellLabel->"In[73]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["B", "0"], "(", "0", ",", 
    SuperscriptBox["m", "2"], ",", 
    SuperscriptBox["m", "2"], ")"}], "+", "1"}], TraditionalForm]], "Output",
 CellTags->"B0",
 CellLabel->"Out[73]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{
   SuperscriptBox["m", "2"], ",", "0", ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B0",
 CellLabel->"In[74]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["B", "0"], "(", "0", ",", 
    SuperscriptBox["m", "2"], ",", 
    SuperscriptBox["m", "2"], ")"}], "+", "2"}], TraditionalForm]], "Output",
 CellTags->"B0",
 CellLabel->"Out[74]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"0", ",", 
   RowBox[{"m", "^", "2"}], ",", 
   RowBox[{"m", "^", "2"}]}], "]"}]], "Input",
 CellTags->"B0",
 CellLabel->"In[75]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["B", "0"], "(", "0", ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"], ")"}], TraditionalForm]], "Output",
 CellTags->"B0",
 CellLabel->"Out[75]="]
}, Open  ]]
}, Open  ]],

Cell["B0Real", "ObjectName",
 PageBreakAbove->True,
 CellTags->"B0Real"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"B0Real"],

Cell["\<\
B0Real is an option of B0 (default False). If set to True, B0 is assumed to \
be real and the relation B0[a,0,a] = 2 + B0[0,a,a]  is applied.\
\>", "Text",
 CellTags->"B0Real"],

Cell[TextData[{
 "See also: ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 "."
}], "Text",
 CellTags->"B0Real"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"B0Real"],

Cell["By default the arguments are not assumed real.", "Text",
 CellTags->"B0Real"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"s", ",", "0", ",", "s"}], "]"}]], "Input",
 CellTags->"B0Real",
 CellLabel->"In[76]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["B", "0"], "(", "0", ",", "s", ",", "s", ")"}], "+", "2"}], 
  TraditionalForm]], "Output",
 CellTags->"B0Real",
 CellLabel->"Out[76]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "//", "Options"}]], "Input",
 CellTags->"B0Real",
 CellLabel->"In[77]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BReduce", "\[Rule]", "False"}], ",", 
    RowBox[{"B0Unique", "\[Rule]", "True"}], ",", 
    RowBox[{"B0Real", "\[Rule]", "True"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"B0Real",
 CellLabel->"Out[77]="]
}, Open  ]],

Cell["\<\
With B0Real\[Rule]True, transformation is done.\
\>", "Text",
 CellTags->"B0Real"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"s", ",", "0", ",", "s", ",", 
   RowBox[{"B0Real", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"B0Real",
 CellLabel->"In[78]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["B", "0"], "(", "0", ",", "s", ",", "s", ")"}], "+", "2"}], 
  TraditionalForm]], "Output",
 CellTags->"B0Real",
 CellLabel->"Out[78]="]
}, Open  ]]
}, Open  ]],

Cell["B0Unique", "ObjectName",
 PageBreakAbove->True,
 CellTags->"B0Unique"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"B0Unique"],

Cell["\<\
B0Unique is an option of B0. If set to True, B0[0,0,m2] is replaced with \
(B0[0,m2,m2]+1) and B0[m2,0,m2] simplifies to (B0[0,m2,m2]+2).\
\>", "Text",
 CellTags->"B0Unique"],

Cell[TextData[{
 "See also: ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 "."
}], "Text",
 CellTags->"B0Unique"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"B0Unique"],

Cell["By default transformation is done.", "Text",
 CellTags->"B0Unique"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"0", ",", "0", ",", "s"}], "]"}]], "Input",
 CellTags->"B0Unique",
 CellLabel->"In[79]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["B", "0"], "(", "0", ",", "s", ",", "s", ")"}], "+", "1"}], 
  TraditionalForm]], "Output",
 CellTags->"B0Unique",
 CellLabel->"Out[79]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "//", "Options"}]], "Input",
 CellTags->"B0Unique",
 CellLabel->"In[80]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"BReduce", "\[Rule]", "False"}], ",", 
    RowBox[{"B0Unique", "\[Rule]", "True"}], ",", 
    RowBox[{"B0Real", "\[Rule]", "True"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"B0Unique",
 CellLabel->"Out[80]="]
}, Open  ]],

Cell["\<\
With B0Real\[Rule]False, nothing happens.\
\>", "Text",
 CellTags->"B0Unique"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"0", ",", "0", ",", "s", ",", 
   RowBox[{"B0Unique", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"B0Unique",
 CellLabel->"In[81]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["B", "0"], "(", "0", ",", "0", ",", "s", ")"}], 
  TraditionalForm]], "Output",
 CellTags->"B0Unique",
 CellLabel->"Out[81]="]
}, Open  ]]
}, Open  ]],

Cell["B00", "ObjectName",
 CellTags->"B00"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"B00"],

Cell[TextData[{
 "B00[pp, ma^2,mb^2] is the Passarino-Veltman ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "00"], TraditionalForm]]],
 "-function, i.e., the coefficient function of the metric tensor. All \
arguments are scalars and have dimension mass^2."
}], "Text",
 CellTags->"B00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "B00", "]"}]], "Input",
 CellTags->"B00",
 CellLabel->"In[82]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"BReduce", "\[Rule]", "True"}], "}"}], TraditionalForm]], "Output",\

 CellTags->"B00",
 CellLabel->"Out[82]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 ", ",
 ButtonBox["B1",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B1",
  ButtonNote->"B1"],
 ", ",
 ButtonBox["PaVe",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVe",
  ButtonNote->"PaVe"],
 "."
}], "Text",
 CellTags->"B00"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"B00"],

Cell[TextData[{
 "Remember that SP[p] is a short hand input for ScalarProduct[p,p], i.e., ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["p", "2"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"B00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SP", "[", "p", "]"}]], "Input",
 CellTags->"B00",
 CellLabel->"In[83]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox["p",
    TraditionalForm], "2"], TraditionalForm]], "Output",
 CellTags->"B00",
 CellLabel->"Out[83]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B00", "[", 
  RowBox[{
   RowBox[{"SP", "[", "p", "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["M", "2"]}], "]"}]], "Input",
 CellTags->"B00",
 CellLabel->"In[84]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{
     SubscriptBox["B", "0"], "(", 
     FormBox[
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], "2"],
      TraditionalForm], ",", 
     SuperscriptBox["m", "2"], ",", 
     SuperscriptBox["M", "2"], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "18"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["m", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["M", "2"]}], "-", 
      FormBox[
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"],
       TraditionalForm]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
        TraditionalForm], "(", 
       FormBox[
        SuperscriptBox["M", "2"],
        TraditionalForm], ")"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["M", "2"], "-", 
             SuperscriptBox["m", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["B", "0"], "(", 
              FormBox[
               SuperscriptBox[
                FormBox["p",
                 TraditionalForm], "2"],
               TraditionalForm], ",", 
              SuperscriptBox["m", "2"], ",", 
              SuperscriptBox["M", "2"], ")"}], "-", 
             RowBox[{
              SubscriptBox["B", "0"], "(", "0", ",", 
              SuperscriptBox["m", "2"], ",", 
              SuperscriptBox["M", "2"], ")"}]}], ")"}]}], 
          RowBox[{"2", " ", 
           FormBox[
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], "2"],
            TraditionalForm]}]], "-", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{
           SubscriptBox["B", "0"], "(", 
           FormBox[
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], "2"],
            TraditionalForm], ",", 
           SuperscriptBox["m", "2"], ",", 
           SuperscriptBox["M", "2"], ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["m", "2"], "-", 
         SuperscriptBox["M", "2"], "+", 
         FormBox[
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], "2"],
          TraditionalForm]}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellTags->"B00",
 CellLabel->"Out[84]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B00", "[", 
  RowBox[{
   RowBox[{"SP", "[", "p", "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B00",
 CellLabel->"In[85]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{
     SubscriptBox["B", "0"], "(", 
     FormBox[
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], "2"],
      TraditionalForm], ",", 
     SuperscriptBox["m", "2"], ",", 
     SuperscriptBox["m", "2"], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "18"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["m", "2"]}], "-", 
      FormBox[
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"],
       TraditionalForm]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
        TraditionalForm], "(", 
       FormBox[
        SuperscriptBox["m", "2"],
        TraditionalForm], ")"}], "-", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        FormBox[
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"],
         TraditionalForm], ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["m", "2"], ")"}], " ", 
       FormBox[
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"],
        TraditionalForm]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"B00",
 CellLabel->"Out[85]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B00", "[", 
  RowBox[{
   RowBox[{"SP", "[", "p", "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["M", "2"], ",", 
   RowBox[{"BReduce", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"B00",
 CellLabel->"In[86]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\<\"B\"\>", "\<\"00\"\>"],
    TraditionalForm], "(", 
   FormBox[
    FormBox[
     SuperscriptBox[
      FormBox["p",
       TraditionalForm], "2"],
     TraditionalForm],
    TraditionalForm], 
   RowBox[{",", " "}], 
   FormBox[
    SuperscriptBox["m", "2"],
    TraditionalForm], 
   RowBox[{",", " "}], 
   FormBox[
    SuperscriptBox["M", "2"],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"B00",
 CellLabel->"Out[86]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B00", "[", 
  RowBox[{"0", ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B00",
 CellLabel->"In[87]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{
     SubscriptBox["B", "0"], "(", "0", ",", 
     SuperscriptBox["m", "2"], ",", 
     SuperscriptBox["m", "2"], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   FractionBox[
    SuperscriptBox["m", "2"], "3"], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{
     FormBox[
      SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
      TraditionalForm], "(", 
     FormBox[
      SuperscriptBox["m", "2"],
      TraditionalForm], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"B00",
 CellLabel->"Out[87]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B00", "[", 
  RowBox[{
   RowBox[{"SmallVariable", "[", 
    SuperscriptBox["M", "2"], "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B00",
 CellLabel->"In[88]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{
     SubscriptBox["B", "0"], "(", 
     SuperscriptBox["M", "2"], ",", 
     SuperscriptBox["m", "2"], ",", 
     SuperscriptBox["m", "2"], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   FractionBox[
    SuperscriptBox["m", "2"], "3"], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{
     FormBox[
      SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
      TraditionalForm], "(", 
     FormBox[
      SuperscriptBox["m", "2"],
      TraditionalForm], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"B00",
 CellLabel->"Out[88]="]
}, Open  ]]
}, Open  ]],

Cell["B1", "ObjectName",
 CellTags->"B1"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"B1"],

Cell[TextData[{
 "B1[pp, ma^2, mb^2] the Passarino-Veltman ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "1"], TraditionalForm]]],
 "-function. All arguments are scalars and have dimension mass^2."
}], "Text",
 CellTags->"B1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "B1", "]"}]], "Input",
 CellTags->"B1",
 CellLabel->"In[89]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"BReduce", "\[Rule]", "True"}], "}"}], TraditionalForm]], "Output",\

 CellTags->"B1",
 CellLabel->"Out[89]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 ", ",
 ButtonBox["B00",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B00",
  ButtonNote->"B00"],
 ", ",
 ButtonBox["B11",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B11",
  ButtonNote->"B11"],
 ", ",
 ButtonBox["PaVe",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVe",
  ButtonNote->"PaVe"],
 ", ",
 ButtonBox["PaVeReduce",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVeReduce",
  ButtonNote->"PaVeReduce"],
 "."
}], "Text",
 CellTags->"B1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"B1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B1", "[", 
  RowBox[{
   RowBox[{"SP", "[", "p", "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["M", "2"]}], "]"}]], "Input",
 CellTags->"B1",
 CellLabel->"In[90]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["M", "2"], "-", 
       SuperscriptBox["m", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        FormBox[
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"],
         TraditionalForm], ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}], "-", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}]}], ")"}]}], 
    RowBox[{"2", " ", 
     FormBox[
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], "2"],
      TraditionalForm]}]], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{
     SubscriptBox["B", "0"], "(", 
     FormBox[
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], "2"],
      TraditionalForm], ",", 
     SuperscriptBox["m", "2"], ",", 
     SuperscriptBox["M", "2"], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"B1",
 CellLabel->"Out[90]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B1", "[", 
  RowBox[{
   RowBox[{"SP", "[", "p", "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["M", "2"], ",", 
   RowBox[{"BReduce", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"B1",
 CellLabel->"In[91]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["B", "1"], "(", 
   FormBox[
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"],
    TraditionalForm], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["M", "2"], ")"}], TraditionalForm]], "Output",
 CellTags->"B1",
 CellLabel->"Out[91]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"B1", ",", 
    RowBox[{"BReduce", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellTags->"B1",
 CellLabel->"In[92]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B1", "[", 
  RowBox[{
   RowBox[{"SP", "[", "p", "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B1",
 CellLabel->"In[93]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{
    SubscriptBox["B", "0"], "(", 
    FormBox[
     SuperscriptBox[
      FormBox["p",
       TraditionalForm], "2"],
     TraditionalForm], ",", 
    SuperscriptBox["m", "2"], ",", 
    SuperscriptBox["m", "2"], ")"}]}], TraditionalForm]], "Output",
 CellTags->"B1",
 CellLabel->"Out[93]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B1", "[", 
  RowBox[{
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"], ",", "0"}], "]"}]], "Input",
 CellTags->"B1",
 CellLabel->"In[94]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["m", "2"], ")"}]}], "-", "2"}], ")"}]}], "-", 
   FractionBox["1", "2"]}], TraditionalForm]], "Output",
 CellTags->"B1",
 CellLabel->"Out[94]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B1", "[", 
  RowBox[{"0", ",", "0", ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B1",
 CellLabel->"In[95]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["m", "2"], ")"}]}], "-", "1"}], ")"}]}], "+", 
   FractionBox["1", "4"]}], TraditionalForm]], "Output",
 CellTags->"B1",
 CellLabel->"Out[95]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B1", "[", 
  RowBox[{"pp", ",", 
   RowBox[{"SmallVariable", "[", 
    SubsuperscriptBox["m", "e", "2"], "]"}], ",", 
   SubsuperscriptBox["m", "2", "2"]}], "]"}]], "Input",
 CellTags->"B1",
 CellLabel->"In[96]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["B", "0"], "(", "pp", ",", 
        SubsuperscriptBox["m", "e", "2"], ",", 
        SubsuperscriptBox["m", "2", "2"], ")"}], "-", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SubsuperscriptBox["m", "e", "2"], ",", 
        SubsuperscriptBox["m", "2", "2"], ")"}]}], ")"}], " ", 
     SubsuperscriptBox["m", "2", "2"]}], 
    RowBox[{"2", " ", "pp"}]], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{
     SubscriptBox["B", "0"], "(", "pp", ",", 
     SubsuperscriptBox["m", "e", "2"], ",", 
     SubsuperscriptBox["m", "2", "2"], ")"}]}]}], TraditionalForm]], "Output",\

 CellTags->"B1",
 CellLabel->"Out[96]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B1", "[", 
  RowBox[{
   RowBox[{"SmallVariable", "[", 
    SubsuperscriptBox["m", "e", "2"], "]"}], ",", 
   RowBox[{"SmallVariable", "[", 
    SubsuperscriptBox["m", "e", "2"], "]"}], ",", "0"}], "]"}]], "Input",
 CellTags->"B1",
 CellLabel->"In[97]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SubsuperscriptBox["m", "e", "2"], ",", 
        SubsuperscriptBox["m", "e", "2"], ")"}]}], "-", "2"}], ")"}]}], "-", 
   FractionBox["1", "2"]}], TraditionalForm]], "Output",
 CellTags->"B1",
 CellLabel->"Out[97]="]
}, Open  ]]
}, Open  ]],

Cell["B11", "ObjectName",
 CellTags->"B11"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"B11"],

Cell[TextData[{
 "B11[pp, ma^2, mb^2] is the Passarino-Veltman ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "11"], TraditionalForm]]],
 "-function, i.e., the coefficient function of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["p", "\[Mu]"], " ", 
    SuperscriptBox["p", "\[Nu]"]}], TraditionalForm]]],
 ". All arguments are scalars and have dimension mass",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "2"], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"B11"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "B11", "]"}]], "Input",
 CellTags->"B11",
 CellLabel->"In[98]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"BReduce", "\[Rule]", "True"}], "}"}], TraditionalForm]], "Output",\

 CellTags->"B11",
 CellLabel->"Out[98]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 ", ",
 ButtonBox["B00",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B00",
  ButtonNote->"B00"],
 ", ",
 ButtonBox["B1",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B1",
  ButtonNote->"B1"],
 ", ",
 ButtonBox["PaVe",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVe",
  ButtonNote->"PaVe"],
 "."
}], "Text",
 CellTags->"B11"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"B11"],

Cell[TextData[{
 "Remember that SP[p] is a short hand input for ScalarProduct[p,p], i.e. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["p", "2"], "."}], TraditionalForm]]]
}], "Text",
 CellTags->"B11"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SP", "[", "p", "]"}]], "Input",
 CellTags->"B11",
 CellLabel->"In[99]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox["p",
    TraditionalForm], "2"], TraditionalForm]], "Output",
 CellTags->"B11",
 CellLabel->"Out[99]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B11", "[", 
  RowBox[{
   RowBox[{"SP", "[", "p", "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["M", "2"]}], "]"}]], "Input",
 CellTags->"B11",
 CellLabel->"In[100]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["B", "0"], "(", 
       FormBox[
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"],
        TraditionalForm], ",", 
       SuperscriptBox["m", "2"], ",", 
       SuperscriptBox["M", "2"], ")"}]}], " ", 
     SuperscriptBox["m", "2"]}], "+", 
    RowBox[{
     FormBox[
      SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
      TraditionalForm], "(", 
     FormBox[
      SuperscriptBox["M", "2"],
      TraditionalForm], ")"}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["m", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["M", "2"]}], "+", 
       FormBox[
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"],
        TraditionalForm]}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["M", "2"], "-", 
           SuperscriptBox["m", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubscriptBox["B", "0"], "(", 
            FormBox[
             SuperscriptBox[
              FormBox["p",
               TraditionalForm], "2"],
             TraditionalForm], ",", 
            SuperscriptBox["m", "2"], ",", 
            SuperscriptBox["M", "2"], ")"}], "-", 
           RowBox[{
            SubscriptBox["B", "0"], "(", "0", ",", 
            SuperscriptBox["m", "2"], ",", 
            SuperscriptBox["M", "2"], ")"}]}], ")"}]}], 
        RowBox[{"2", " ", 
         FormBox[
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], "2"],
          TraditionalForm]}]], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{
         SubscriptBox["B", "0"], "(", 
         FormBox[
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], "2"],
          TraditionalForm], ",", 
         SuperscriptBox["m", "2"], ",", 
         SuperscriptBox["M", "2"], ")"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["m", "2"], "-", 
       SuperscriptBox["M", "2"], "+", 
       FormBox[
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"],
        TraditionalForm]}], ")"}]}]}], 
   RowBox[{"3", " ", 
    FormBox[
     SuperscriptBox[
      FormBox["p",
       TraditionalForm], "2"],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"B11",
 CellLabel->"Out[100]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B11", "[", 
  RowBox[{
   RowBox[{"SP", "[", "p", "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B11",
 CellLabel->"In[101]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
      TraditionalForm], "(", 
     FormBox[
      SuperscriptBox["m", "2"],
      TraditionalForm], ")"}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       FormBox[
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"],
        TraditionalForm], "-", 
       RowBox[{"6", " ", 
        SuperscriptBox["m", "2"]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["B", "0"], "(", 
      FormBox[
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"],
       TraditionalForm], ",", 
      SuperscriptBox["m", "2"], ",", 
      SuperscriptBox["m", "2"], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       FormBox[
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"],
        TraditionalForm], "-", 
       SuperscriptBox["m", "2"]}], ")"}]}]}], 
   RowBox[{"3", " ", 
    FormBox[
     SuperscriptBox[
      FormBox["p",
       TraditionalForm], "2"],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"B11",
 CellLabel->"Out[101]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"B11", ",", 
   RowBox[{"BReduce", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"B11",
 CellLabel->"In[102]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"BReduce", "\[Rule]", "False"}], "}"}], TraditionalForm]], "Output",\

 CellTags->"B11",
 CellLabel->"Out[102]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B11", "[", 
  RowBox[{
   RowBox[{"SP", "[", "p", "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["M", "2"]}], "]"}]], "Input",
 CellTags->"B11",
 CellLabel->"In[103]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\<\"B\"\>", "\<\"11\"\>"],
    TraditionalForm], "(", 
   FormBox[
    FormBox[
     SuperscriptBox[
      FormBox["p",
       TraditionalForm], "2"],
     TraditionalForm],
    TraditionalForm], 
   RowBox[{",", " "}], 
   FormBox[
    SuperscriptBox["m", "2"],
    TraditionalForm], 
   RowBox[{",", " "}], 
   FormBox[
    SuperscriptBox["M", "2"],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"B11",
 CellLabel->"Out[103]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"B11", ",", 
   RowBox[{"BReduce", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"B11",
 CellLabel->"In[104]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"BReduce", "\[Rule]", "True"}], "}"}], TraditionalForm]], "Output",\

 CellTags->"B11",
 CellLabel->"Out[104]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B11", "[", 
  RowBox[{"0", ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B11",
 CellLabel->"In[105]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{
    SubscriptBox["B", "0"], "(", "0", ",", 
    SuperscriptBox["m", "2"], ",", 
    SuperscriptBox["m", "2"], ")"}]}], TraditionalForm]], "Output",
 CellTags->"B11",
 CellLabel->"Out[105]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B11", "[", 
  RowBox[{
   RowBox[{"SmallVariable", "[", 
    SuperscriptBox["M", "2"], "]"}], ",", 
   SuperscriptBox["m", "2"], ",", 
   SuperscriptBox["m", "2"]}], "]"}]], "Input",
 CellTags->"B11",
 CellLabel->"In[106]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{
    SubscriptBox["B", "0"], "(", 
    SuperscriptBox["M", "2"], ",", 
    SuperscriptBox["m", "2"], ",", 
    SuperscriptBox["m", "2"], ")"}]}], TraditionalForm]], "Output",
 CellTags->"B11",
 CellLabel->"Out[106]="]
}, Open  ]]
}, Open  ]],

Cell["CA", "ObjectName",
 CellTags->"CA"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CA"],

Cell[TextData[{
 "CA is one of the Casimir operator eigenvalues of SU(",
 StyleBox["N",
  FontSlant->"Italic"],
 ") (CA = ",
 StyleBox["N",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellTags->"CA"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["CF",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CF",
  ButtonNote->"CF"],
 ", ",
 ButtonBox["SUNSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNSimplify",
  ButtonNote->"SUNSimplify"],
 "."
}], "Text",
 CellTags->"CA"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CA"],

Cell[CellGroupData[{

Cell[BoxData["CA"], "Input",
 CellTags->"CA",
 CellLabel->"In[107]:="],

Cell[BoxData[
 FormBox[
  SubscriptBox["C", "A"], TraditionalForm]], "Output",
 CellTags->"CA",
 CellLabel->"Out[107]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SUNSimplify", "[", 
  RowBox[{"CA", ",", 
   RowBox[{"SUNNToCACF", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"CA",
 CellLabel->"In[108]:="],

Cell[BoxData[
 FormBox["N", TraditionalForm]], "Output",
 CellTags->"CA",
 CellLabel->"Out[108]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["SUNN"], "Input",
 CellTags->"CA",
 CellLabel->"In[109]:="],

Cell[BoxData[
 FormBox["N", TraditionalForm]], "Output",
 CellTags->"CA",
 CellLabel->"Out[109]="]
}, Open  ]]
}, Open  ]],

Cell["Calc", "ObjectName",
 CellTags->"Calc"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Calc"],

Cell["\<\
Calc[exp] performs several basic simplifications. Calc[exp] is the same as \
DotSimplify[DiracSimplify[Contract[DiracSimplify[Explicit[ \
SUNSimplify[Trick[exp], Explicit\[Rule]False] ]]]]].\
\>", "Text",
 CellTags->"Calc"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 ", ",
 ButtonBox["Trick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Trick",
  ButtonNote->"Trick"],
 "."
}], "Text",
 CellTags->"Calc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Examples"], "Subsubsection",
 CellTags->"Calc"],

Cell[TextData[{
 "This calculates ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], 
    SubscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]]],
 " in 4 dimensions and ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["g", "\[Nu]", "\[Nu]"], TraditionalForm]]],
 " in D dimensions."
}], "Text",
 CellTags->"Calc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"GA", "[", 
     RowBox[{"\[Mu]", ",", "\[Mu]"}], "]"}], ",", " ", 
    RowBox[{"MTD", "[", 
     RowBox[{"\[Nu]", ",", "\[Nu]"}], "]"}]}], "}"}], "]"}]], "Input",
 CellTags->"Calc",
 CellLabel->"In[110]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"4", ",", "D"}], "}"}], TraditionalForm]], "Output",
 CellTags->"Calc",
 CellLabel->"Out[110]="]
}, Open  ]],

Cell[TextData[{
 "This simplifies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "abc"], " ", 
    RowBox[{
     SubscriptBox["f", "abe"], "."}]}], TraditionalForm]]]
}], "Text",
 CellTags->"Calc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{
   RowBox[{"SUNF", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], " ", 
   RowBox[{"SUNF", "[", 
    RowBox[{"a", ",", "b", ",", "e"}], "]"}]}], "]"}]], "Input",
 CellTags->"Calc",
 CellLabel->"In[111]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["C", "A"], " ", 
   SubscriptBox["\[Delta]", 
    RowBox[{
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"Calc",
 CellLabel->"Out[111]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FV", "[", 
   RowBox[{
    RowBox[{"p", "+", "r"}], ",", "\[Mu]"}], "]"}], " ", 
  RowBox[{"MT", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
  RowBox[{"FV", "[", 
   RowBox[{
    RowBox[{"q", "-", "p"}], ",", "\[Nu]"}], "]"}]}]], "Input",
 CellTags->"Calc",
 CellLabel->"In[112]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    SuperscriptBox[
     FormBox[
      RowBox[{"q", "-", "p"}],
      TraditionalForm], "\[Nu]"], ")"}], " ", 
   RowBox[{"(", 
    SuperscriptBox[
     FormBox[
      RowBox[{"p", "+", "r"}],
      TraditionalForm], "\[Mu]"], ")"}], " ", 
   SuperscriptBox["g", 
    RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output",
 CellTags->"Calc",
 CellLabel->"Out[112]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", "%", "]"}]], "Input",
 CellTags->"Calc",
 CellLabel->"In[113]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"]}], "+", 
   RowBox[{
    FormBox["p",
     TraditionalForm], "\[CenterDot]", 
    FormBox["q",
     TraditionalForm]}], "-", 
   RowBox[{
    FormBox["p",
     TraditionalForm], "\[CenterDot]", 
    FormBox["r",
     TraditionalForm]}], "+", 
   RowBox[{
    FormBox["q",
     TraditionalForm], "\[CenterDot]", 
    FormBox["r",
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellTags->"Calc",
 CellLabel->"Out[113]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GluonVertex", "[", 
  RowBox[{"p", ",", "1", ",", "q", ",", "2", ",", 
   RowBox[{
    RowBox[{"-", "p"}], "-", "q"}], ",", "3"}], "]"}]], "Input",
 CellTags->"Calc",
 CellLabel->"In[114]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["V", 
     RowBox[{
      FormBox[
       FormBox["li1",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["li2",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["li3",
        TraditionalForm],
       TraditionalForm]}]], "(", 
    RowBox[{
     FormBox["p",
      TraditionalForm], 
     RowBox[{",", " "}], 
     FormBox["q",
      TraditionalForm], 
     RowBox[{",", " "}], 
     FormBox[
      RowBox[{
       RowBox[{"-", "p"}], "-", "q"}],
      TraditionalForm]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["ci1",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["ci2",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["ci3",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"Calc",
 CellLabel->"Out[114]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{
   RowBox[{"%", " ", 
    RowBox[{"FVD", "[", 
     RowBox[{"p", ",", "li1"}], "]"}]}], " ", 
   RowBox[{"FVD", "[", 
    RowBox[{"q", ",", "li2"}], "]"}], " ", 
   RowBox[{"FVD", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "p"}], "-", "q"}], ",", "li3"}], "]"}]}], "]"}]], "Input",
 CellTags->"Calc",
 CellLabel->"In[115]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"Calc",
 CellLabel->"Out[115]="]
}, Open  ]]
}, Open  ]],

Cell["CalcColorFactor", "ObjectName",
 CellTags->"CalcColorFactor"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CalcColorFactor"],

Cell["\<\
CalcColorFactor[expr] calculates the color factor of expr.  CalcColorFactor \
is useful for application on FeynArts produced amplitudes. CalcColorFactor is \
just a macro function for CalcColorFactor[x_] := 
If[FreeQ2[FeynCalcInternal[x], SUNIndex],  x, 
                    SUNSimplify[SUNSimplify[  (If[ !FreeQ[#1, DiracGamma], \
DiracTrick[#1], #1] & )[  SUNSimplify[x]], Explicit -> False], Explicit -> \
True]].\
\>", "Text",
 CellTags->"CalcColorFactor"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["SUNSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNSimplify",
  ButtonNote->"SUNSimplify"],
 "."
}], "Text",
 CellTags->"CalcColorFactor"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalcColorFactor", "[", 
  RowBox[{
   RowBox[{"SUNF", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], " ", 
   RowBox[{"SUNF", "[", 
    RowBox[{"a", ",", "b", ",", "d"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[116]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["C", "A"], " ", 
   SubscriptBox["\[Delta]", 
    RowBox[{
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["d",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellLabel->"Out[116]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Amplitude", "[", "\"\<q2se2\>\"", "]"}]], "Input",
 CellLabel->"In[117]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"tr", "(", 
     FormBox[
      RowBox[{"2", " ", 
       SubscriptBox["T", "f"], " ", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[CapitalPi]", "q"], "(", 
         FormBox[
          RowBox[{"-", "q1"}],
          TraditionalForm], ")"}], ".", 
        SubsuperscriptBox["Q", 
         SubscriptBox["c", "9"], 
         SubscriptBox["\[Lambda]", "9"]], ".", 
        RowBox[{
         SubscriptBox["\[CapitalPi]", "q"], "(", 
         FormBox[
          RowBox[{"q2", "-", "q1"}],
          TraditionalForm], ")"}], ".", 
        SubsuperscriptBox["Q", 
         SubscriptBox["c", "3"], 
         SubscriptBox["\[Lambda]", "3"]]}]}],
      TraditionalForm], ")"}]}], " ", 
   RowBox[{
    SubsuperscriptBox["Q", 
     SubscriptBox["c", "11"], 
     SubscriptBox["\[Lambda]", "11"]], ".", 
    RowBox[{
     SubscriptBox["\[CapitalPi]", "q"], "(", 
     FormBox[
      RowBox[{"p", "-", "q2"}],
      TraditionalForm], ")"}], ".", 
    SubsuperscriptBox["Q", 
     SubscriptBox["c", "1"], 
     SubscriptBox["\[Lambda]", "1"]]}], " ", 
   RowBox[{
    SubsuperscriptBox["\[CapitalPi]", 
     RowBox[{
      SubscriptBox["c", "1"], 
      SubscriptBox["c", "3"]}], 
     RowBox[{
      SubscriptBox["\[Lambda]", "1"], 
      SubscriptBox["\[Lambda]", "3"]}]], "(", "q2", ")"}], " ", 
   RowBox[{
    SubsuperscriptBox["\[CapitalPi]", 
     RowBox[{
      SubscriptBox["c", "9"], 
      SubscriptBox["c", "11"]}], 
     RowBox[{
      SubscriptBox["\[Lambda]", "9"], 
      SubscriptBox["\[Lambda]", "11"]}]], "(", "q2", ")"}]}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[117]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CalcColorFactor", "@", 
  RowBox[{"Explicit", "@", "%"}]}]], "Input",
 CellLabel->"In[118]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["C", "F"], " ", 
    SubsuperscriptBox["g", "s", "4"], " ", 
    SubscriptBox["T", "f"], " ", 
    RowBox[{"tr", "(", 
     FormBox[
      RowBox[{"-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
           TraditionalForm], "\[CenterDot]", 
          FormBox["q1",
           TraditionalForm]}], ")"}], ".", 
        SuperscriptBox["\[Gamma]", 
         FormBox[
          FormBox[
           SubscriptBox["\[Lambda]", "9"],
           TraditionalForm],
          TraditionalForm]], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox["\<\"\[Gamma]\"\>",
           TraditionalForm], "\[CenterDot]", "(", 
          FormBox[
           RowBox[{"q1", "-", "q2"}],
           TraditionalForm], ")"}], ")"}], ".", 
        SuperscriptBox["\[Gamma]", 
         FormBox[
          FormBox[
           SubscriptBox["\[Lambda]", "3"],
           TraditionalForm],
          TraditionalForm]]}]}],
      TraditionalForm], ")"}], " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Lambda]", "11"],
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", "(", 
       FormBox[
        RowBox[{"p", "-", "q2"}],
        TraditionalForm], ")"}], ")"}], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Lambda]", "1"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", 
       SuperscriptBox["q2", "2"]], ")"}], "2"], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Lambda]", "1"], 
      SubscriptBox["\[Lambda]", "3"]}]], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Lambda]", "9"], 
      SubscriptBox["\[Lambda]", "11"]}]]}], 
   RowBox[{
    SuperscriptBox["q1", "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"p", "-", "q2"}], ")"}], "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q2", "-", "q1"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellLabel->"Out[118]="]
}, Open  ]],

Cell[TextData[{
 "See also:  ",
 ButtonBox["ScalarProductCancel",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ScalarProductCancel",
  ButtonNote->"ScalarProductCancel"],
 ", ",
 ButtonBox["Series2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Series2",
  ButtonNote->"Series2"],
 ", ",
 ButtonBox["TID",
  BaseStyle->"AddOnsLink",
  ButtonData:>"TID",
  ButtonNote->"TID"],
 "."
}], "Text",
 CellTags->"Collecting"]
}, Open  ]],

Cell["CalculateCounterTerm ***unfinished***", "ObjectName",
 CellTags->"CalculateCounterTerm"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CalculateCounterTerm"],

Cell["CalculateCounterTerm[exp, k] calculates the residue of exp.", "Text",
 CellTags->"CalculateCounterTerm"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Examples"], "Subsubsection",
 CellTags->"CalculateCounterTerm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "CalculateCounterTerm"}]], "Input",
 CellTags->"CalculateCounterTerm",
 CellLabel->"In[119]:="],

Cell[BoxData[
 StyleBox["\<\"CalculateCounterTerm[exp, k] calculates the residue of \
exp.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->{"CalculateCounterTerm", "Info3387711865-3148101"}]
}, Open  ]]
}, Open  ]],

Cell["CancelQP", "ObjectName",
 CellTags->"CancelQP"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CancelQP"],

Cell[TextData[{
 "CancelQP is an option for OneLoop. If set to True, cancelation of all ",
 StyleBox["q",
  FontSlant->"Italic"],
 ".",
 StyleBox["p",
  FontSlant->"Italic"],
 "'s and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["q", "2"], TraditionalForm]]],
 " is performed."
}], "Text",
 CellTags->"CancelQP"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Examples"], "Subsubsection",
 CellTags->"CancelQP"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"SPD", "[", 
     RowBox[{
      RowBox[{"p", "+", 
       RowBox[{"2", "q2"}]}], ",", 
      RowBox[{"p", "+", "q2"}]}], "]"}], " ", 
    RowBox[{"FAD", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q2", "-", "p"}], ",", "m"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"q2", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"q2", ",", "M"}], "}"}]}], "]"}]}], "//", "FCI"}]}]], "Input",
 CellTags->"CancelQP",
 CellLabel->"In[120]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"(", 
    FormBox[
     RowBox[{"p", "+", "q2"}],
     TraditionalForm], ")", "\[CenterDot]", "(", 
    FormBox[
     RowBox[{"p", "+", 
      RowBox[{"2", " ", "q2"}]}],
     TraditionalForm], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q2", "-", "p"}], ")"}], "2"], "-", 
      SuperscriptBox["m", "2"]}], ")"}], ".", 
    SuperscriptBox["q2", "2"], ".", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["q2", "2"], "-", 
      SuperscriptBox["M", "2"]}], ")"}]}]], TraditionalForm]], "Output",
 CellTags->"CancelQP",
 CellLabel->"Out[120]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OneLoop", "[", 
  RowBox[{"q2", ",", "t", ",", 
   RowBox[{"CancelQP", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"CancelQP",
 CellLabel->"In[121]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox["\[Pi]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", "0", ",", 
        SuperscriptBox["m", "2"], ")"}], " ", 
       SuperscriptBox["m", "2"]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["M", "2"]}]], "-", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
         TraditionalForm], "(", 
        FormBox[
         SuperscriptBox["M", "2"],
         TraditionalForm], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["M", "2"]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["m", "2"]}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["M", "2"]}]}], ")"}], " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["M", "2"]}]], "-", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", "0", ",", 
        SuperscriptBox["m", "2"], ")"}], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["M", "2"]}]], "+", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["M", "2"]}]]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"CancelQP",
 CellLabel->"Out[121]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OneLoop", "[", 
  RowBox[{"q2", ",", "t", ",", 
   RowBox[{"CancelQP", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"CancelQP",
 CellLabel->"In[122]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox["\[Pi]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["m", "2"], ")"}], " ", 
       SuperscriptBox["m", "4"]}], 
      RowBox[{"3", " ", 
       SuperscriptBox["M", "2"], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"]}]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", "0", ",", 
        SuperscriptBox["m", "2"], ")"}], " ", 
       SuperscriptBox["m", "4"]}], 
      RowBox[{"3", " ", 
       SuperscriptBox["M", "2"], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"]}]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["m", "4"]}], 
      RowBox[{"3", " ", 
       SuperscriptBox["M", "2"], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"]}]], "-", 
     FractionBox[
      RowBox[{"13", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["m", "2"], ")"}], " ", 
       SuperscriptBox["m", "2"]}], 
      RowBox[{"6", " ", 
       SuperscriptBox["M", "2"]}]], "+", 
     FractionBox[
      RowBox[{"17", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}], " ", 
       SuperscriptBox["m", "2"]}], 
      RowBox[{"6", " ", 
       SuperscriptBox["M", "2"]}]], "+", 
     FractionBox[
      RowBox[{"17", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", "0", ",", 
        SuperscriptBox["m", "2"], ")"}], " ", 
       SuperscriptBox["m", "2"]}], 
      RowBox[{"6", " ", 
       SuperscriptBox["M", "2"]}]], "-", 
     FractionBox[
      RowBox[{"13", " ", 
       SuperscriptBox["m", "2"]}], 
      RowBox[{"6", " ", 
       SuperscriptBox["M", "2"]}]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
         TraditionalForm], "(", 
        FormBox[
         SuperscriptBox["m", "2"],
         TraditionalForm], ")"}]}], 
      RowBox[{"3", " ", 
       SuperscriptBox["M", "2"]}]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{
        FormBox[
         SubscriptBox["\<\"A\"\>", "\<\"0\"\>"],
         TraditionalForm], "(", 
        FormBox[
         SuperscriptBox["M", "2"],
         TraditionalForm], ")"}]}], 
      RowBox[{"3", " ", 
       SuperscriptBox["M", "2"]}]], "-", 
     RowBox[{
      FractionBox["17", "6"], " ", 
      RowBox[{
       SubscriptBox["B", "0"], "(", "0", ",", 
       SuperscriptBox["m", "2"], ",", 
       SuperscriptBox["M", "2"], ")"}]}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"17", " ", 
          SuperscriptBox["m", "2"]}], "-", 
         RowBox[{"13", " ", 
          SuperscriptBox["M", "2"]}]}], ")"}], " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}]}], 
      RowBox[{"6", " ", 
       SuperscriptBox["M", "2"]}]], "-", 
     FractionBox[
      RowBox[{"19", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", "0", ",", 
        SuperscriptBox["m", "2"], ")"}], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"]}], 
      RowBox[{"6", " ", 
       SuperscriptBox["M", "2"]}]], "+", 
     FractionBox[
      RowBox[{"19", " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"]}], 
      RowBox[{"6", " ", 
       SuperscriptBox["M", "2"]}]], "-", 
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"PaVe", "(", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"{", 
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], "2"], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           SuperscriptBox["m", "2"]}], "}"}]}], ")"}]}], 
      SuperscriptBox["M", "2"]], "+", 
     FractionBox[
      RowBox[{"8", " ", 
       RowBox[{"PaVe", "(", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"{", 
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], "2"], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox["m", "2"], ",", 
           SuperscriptBox["M", "2"]}], "}"}]}], ")"}]}], 
      SuperscriptBox["M", "2"]], "-", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["m", "2"], "-", 
          SuperscriptBox["M", "2"]}], ")"}], "2"], " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}]}], 
      RowBox[{"3", " ", 
       SuperscriptBox["M", "2"], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"]}]], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["m", "2"], "-", 
          SuperscriptBox["M", "2"]}], ")"}], "2"], " ", 
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], "2"], ",", 
        SuperscriptBox["m", "2"], ",", 
        SuperscriptBox["M", "2"], ")"}]}], 
      RowBox[{"3", " ", 
       SuperscriptBox["M", "2"], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"]}]], "-", 
     FractionBox["4", "3"]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"CancelQP",
 CellLabel->"Out[122]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"SPD", "[", 
     RowBox[{"q2", ",", "p"}], "]"}], 
    RowBox[{"SPD", "[", 
     RowBox[{"q1", ",", "p"}], "]"}], " ", 
    RowBox[{"FAD", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "m"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"q2", ",", "m"}], "}"}], ",", 
      RowBox[{"q1", "-", "p"}], ",", 
      RowBox[{"q2", "-", "p"}], ",", 
      RowBox[{"q2", "-", "q1"}]}], "]"}]}], "//", "FCI"}]}]], "Input",
 CellTags->"CancelQP",
 CellLabel->"In[123]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{
     FormBox["p",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q1",
      TraditionalForm]}], " ", 
    RowBox[{
     FormBox["p",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q2",
      TraditionalForm]}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["q1", "2"], "-", 
      SuperscriptBox["m", "2"]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["q2", "2"], "-", 
      SuperscriptBox["m", "2"]}], ")"}], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "p"}], ")"}], "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q2", "-", "p"}], ")"}], "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q2", "-", "q1"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellTags->"CancelQP",
 CellLabel->"Out[123]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OneLoop", "[", 
  RowBox[{"q2", ",", "t", ",", 
   RowBox[{"CancelQP", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"CancelQP",
 CellLabel->"In[124]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox["\[Pi]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         FormBox[
          SubscriptBox["\<\"C\"\>", "\<\"0\"\>"],
          TraditionalForm], "(", 
         FormBox[
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], "2"],
          TraditionalForm], ",", 
         FormBox[
          SuperscriptBox[
           FormBox["q1",
            TraditionalForm], "2"],
          TraditionalForm], ",", 
         FormBox[
          RowBox[{
           SuperscriptBox[
            FormBox["p",
             TraditionalForm], "2"], "-", 
           RowBox[{"2", " ", 
            RowBox[{
             FormBox["p",
              TraditionalForm], "\[CenterDot]", 
             FormBox["q1",
              TraditionalForm]}]}], "+", 
           SuperscriptBox[
            FormBox["q1",
             TraditionalForm], "2"]}],
          TraditionalForm], ",", 
         FormBox["0",
          TraditionalForm], ",", 
         FormBox[
          SuperscriptBox["m", "2"],
          TraditionalForm], ",", 
         FormBox["0",
          TraditionalForm], ")"}], " ", 
        RowBox[{
         FormBox["p",
          TraditionalForm], "\[CenterDot]", 
         FormBox["q1",
          TraditionalForm]}], " ", 
        SuperscriptBox["m", "2"]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["m", "2"], "-", 
          SuperscriptBox[
           FormBox["q1",
            TraditionalForm], "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], "2"], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            FormBox["p",
             TraditionalForm], "\[CenterDot]", 
            FormBox["q1",
             TraditionalForm]}]}], "+", 
          SuperscriptBox[
           FormBox["q1",
            TraditionalForm], "2"]}], ")"}]}]]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SuperscriptBox[
         FormBox["q1",
          TraditionalForm], "2"], ",", "0", ",", 
        SuperscriptBox["m", "2"], ")"}], " ", 
       RowBox[{
        FormBox["p",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q1",
         TraditionalForm]}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["m", "2"], "-", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           FormBox["p",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q1",
            TraditionalForm]}]}], "+", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        RowBox[{
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           FormBox["p",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q1",
            TraditionalForm]}]}], "+", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ",", "0", ",", "0", ")"}], " ", 
       RowBox[{
        FormBox["p",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q1",
         TraditionalForm]}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["m", "2"], "-", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           FormBox["p",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q1",
            TraditionalForm]}]}], "+", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{
        FormBox[
         SubscriptBox["\<\"C\"\>", "\<\"0\"\>"],
         TraditionalForm], "(", 
        FormBox[
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"],
         TraditionalForm], ",", 
        FormBox[
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"],
         TraditionalForm], ",", 
        FormBox[
         RowBox[{
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], "2"], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            FormBox["p",
             TraditionalForm], "\[CenterDot]", 
            FormBox["q1",
             TraditionalForm]}]}], "+", 
          SuperscriptBox[
           FormBox["q1",
            TraditionalForm], "2"]}],
         TraditionalForm], ",", 
        FormBox["0",
         TraditionalForm], ",", 
        FormBox[
         SuperscriptBox["m", "2"],
         TraditionalForm], ",", 
        FormBox["0",
         TraditionalForm], ")"}], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"], " ", 
       RowBox[{
        FormBox["p",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q1",
         TraditionalForm]}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["m", "2"], "-", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           FormBox["p",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q1",
            TraditionalForm]}]}], "+", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}]}]]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellTags->"CancelQP",
 CellLabel->"Out[124]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OneLoop", "[", 
  RowBox[{"q2", ",", "t", ",", 
   RowBox[{"CancelQP", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"CancelQP",
 CellLabel->"In[125]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox["\[Pi]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"PaVe", "(", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox[
            FormBox["p",
             TraditionalForm], "2"], ",", 
           SuperscriptBox[
            FormBox["q1",
             TraditionalForm], "2"], ",", 
           RowBox[{
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], "2"], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              FormBox["p",
               TraditionalForm], "\[CenterDot]", 
              FormBox["q1",
               TraditionalForm]}]}], "+", 
            SuperscriptBox[
             FormBox["q1",
              TraditionalForm], "2"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           SuperscriptBox["m", "2"], ",", "0"}], "}"}]}], ")"}], " ", 
       SuperscriptBox[
        FormBox[
         RowBox[{
          FormBox["p",
           TraditionalForm], "\[CenterDot]", 
          FormBox["q1",
           TraditionalForm]}],
         TraditionalForm], "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["m", "2"], "-", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           FormBox["p",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q1",
            TraditionalForm]}]}], "+", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}]}]], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"], " ", 
       RowBox[{"PaVe", "(", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox[
            FormBox["p",
             TraditionalForm], "2"], ",", 
           SuperscriptBox[
            FormBox["q1",
             TraditionalForm], "2"], ",", 
           RowBox[{
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], "2"], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              FormBox["p",
               TraditionalForm], "\[CenterDot]", 
              FormBox["q1",
               TraditionalForm]}]}], "+", 
            SuperscriptBox[
             FormBox["q1",
              TraditionalForm], "2"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           SuperscriptBox["m", "2"], ",", "0"}], "}"}]}], ")"}], " ", 
       RowBox[{
        FormBox["p",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q1",
         TraditionalForm]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["m", "2"], "-", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           FormBox["p",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q1",
            TraditionalForm]}]}], "+", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}]}]], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"], " ", 
       RowBox[{"PaVe", "(", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{
           SuperscriptBox[
            FormBox["p",
             TraditionalForm], "2"], ",", 
           SuperscriptBox[
            FormBox["q1",
             TraditionalForm], "2"], ",", 
           RowBox[{
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], "2"], "-", 
            RowBox[{"2", " ", 
             RowBox[{
              FormBox["p",
               TraditionalForm], "\[CenterDot]", 
              FormBox["q1",
               TraditionalForm]}]}], "+", 
            SuperscriptBox[
             FormBox["q1",
              TraditionalForm], "2"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           SuperscriptBox["m", "2"], ",", "0"}], "}"}]}], ")"}], " ", 
       RowBox[{
        FormBox["p",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q1",
         TraditionalForm]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["m", "2"], "-", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           FormBox["p",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q1",
            TraditionalForm]}]}], "+", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}]}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{
        FormBox[
         SubscriptBox["\<\"C\"\>", "\<\"0\"\>"],
         TraditionalForm], "(", 
        FormBox[
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"],
         TraditionalForm], ",", 
        FormBox[
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"],
         TraditionalForm], ",", 
        FormBox[
         RowBox[{
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], "2"], "-", 
          RowBox[{"2", " ", 
           RowBox[{
            FormBox["p",
             TraditionalForm], "\[CenterDot]", 
            FormBox["q1",
             TraditionalForm]}]}], "+", 
          SuperscriptBox[
           FormBox["q1",
            TraditionalForm], "2"]}],
         TraditionalForm], ",", 
        FormBox["0",
         TraditionalForm], ",", 
        FormBox[
         SuperscriptBox["m", "2"],
         TraditionalForm], ",", 
        FormBox["0",
         TraditionalForm], ")"}], " ", 
       SuperscriptBox[
        FormBox["p",
         TraditionalForm], "2"], " ", 
       RowBox[{
        FormBox["p",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q1",
         TraditionalForm]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["m", "2"], "-", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], "2"], "-", 
         RowBox[{"2", " ", 
          RowBox[{
           FormBox["p",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q1",
            TraditionalForm]}]}], "+", 
         SuperscriptBox[
          FormBox["q1",
           TraditionalForm], "2"]}], ")"}]}]]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellTags->"CancelQP",
 CellLabel->"Out[125]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "t", "]"}]], "Input",
 CellTags->"CancelQP",
 CellLabel->"In[126]:="]
}, Open  ]],

Cell["Cases2", "ObjectName",
 CellTags->"Cases2"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Cases2"],

Cell["\<\
Cases2[expr, f] returns a list of all objects in expr with head f. \
Cases2[expr,f] is equivalent to Cases2[{expr},f[___],Infinity]//Union. \
Cases2[expr, f, g, ...] or Cases2[expr, {f,g, ...}] is equivalent to \
Cases[{expr},f[___] | g[___] ...] .\
\>", "Text",
 CellTags->"Cases2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Examples"], "Subsubsection",
 CellTags->"Cases2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], "+", 
    SuperscriptBox[
     RowBox[{"f", "[", "b", "]"}], "2"], "+", 
    RowBox[{"f", "[", 
     RowBox[{"c", ",", "d"}], "]"}]}], ",", "f"}], "]"}]], "Input",
 CellTags->"Cases2",
 CellLabel->"In[127]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "(", "a", ")"}], ",", 
    RowBox[{"f", "(", "b", ")"}], ",", 
    RowBox[{"f", "(", 
     RowBox[{"c", ",", "d"}], ")"}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"Cases2",
 CellLabel->"Out[127]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"y", "-", "z"}], "]"}]}], "+", 
    RowBox[{"g", "[", "y", "]"}]}], ",", "Sin", ",", "g"}], "]"}]], "Input",
 CellTags->"Cases2",
 CellLabel->"In[128]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"g", "(", "y", ")"}], ",", 
    RowBox[{"sin", "(", "x", ")"}], ",", 
    RowBox[{"sin", "(", 
     RowBox[{"y", "-", "z"}], ")"}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"Cases2",
 CellLabel->"Out[128]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"y", "-", "z"}], "]"}]}], "+", 
    RowBox[{"g", "[", "x", "]"}], "+", 
    RowBox[{"g", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"Sin", ",", "g"}], "}"}]}], "]"}]], "Input",
 CellTags->"Cases2",
 CellLabel->"In[129]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"g", "(", "x", ")"}], ",", 
    RowBox[{"g", "(", 
     RowBox[{"a", ",", "b", ",", "c"}], ")"}], ",", 
    RowBox[{"sin", "(", "x", ")"}], ",", 
    RowBox[{"sin", "(", 
     RowBox[{"y", "-", "z"}], ")"}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"Cases2",
 CellLabel->"Out[129]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DiracSlash", "[", "p", "]"}], ".", 
     RowBox[{"DiracSlash", "[", "q", "]"}]}], "+", 
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"p", ",", "p"}], "]"}]}], ",", "Dot"}], "]"}]], "Input",
 CellTags->"Cases2",
 CellLabel->"In[130]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p",
       TraditionalForm]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}], ")"}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"Cases2",
 CellLabel->"Out[130]="]
}, Open  ]]
}, Open  ]],

Cell["CF", "ObjectName",
 CellTags->"CF"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CF"],

Cell[TextData[{
 "CF is one of the Casimir operator eigenvalues of SU(",
 StyleBox["N",
  FontSlant->"Italic"],
 ") (CF = (",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["N", "2"], TraditionalForm]]],
 "-1)/(2 ",
 StyleBox["N",
  FontSlant->"Italic"],
 "))."
}], "Text",
 CellTags->"CF"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["CA",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CA",
  ButtonNote->"CA"],
 ", ",
 ButtonBox["SUNSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNSimplify",
  ButtonNote->"SUNSimplify"],
 "."
}], "Text",
 CellTags->"CF"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CF"],

Cell[CellGroupData[{

Cell[BoxData["CF"], "Input",
 CellTags->"CF",
 CellLabel->"In[131]:="],

Cell[BoxData[
 FormBox[
  SubscriptBox["C", "F"], TraditionalForm]], "Output",
 CellTags->"CF",
 CellLabel->"Out[131]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SUNSimplify", "[", 
  RowBox[{"CF", ",", " ", 
   RowBox[{"SUNNToCACF", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"CF",
 CellLabel->"In[132]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["N", "2"], "-", "1"}], 
   RowBox[{"2", " ", "N"}]], TraditionalForm]], "Output",
 CellTags->"CF",
 CellLabel->"Out[132]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[133]:="],

Cell["(-1 + SUNN^2)/(2*SUNN)", "Output",
 CellLabel->"Out[133]//InputForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["SUNN"], "Input",
 CellTags->"CF",
 CellLabel->"In[134]:="],

Cell[BoxData[
 FormBox["N", TraditionalForm]], "Output",
 CellTags->"CF",
 CellLabel->"Out[134]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SUNSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SUNN", "^", "2"}], "-", "1"}], ",", " ", 
   RowBox[{"SUNNToCACF", " ", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"CF",
 CellLabel->"In[135]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"2", " ", 
   SubscriptBox["C", "A"], " ", 
   SubscriptBox["C", "F"]}], TraditionalForm]], "Output",
 CellTags->"CF",
 CellLabel->"Out[135]="]
}, Open  ]]
}, Open  ]],

Cell["ChangeDimension", "ObjectName",
 CellTags->"ChangeDimension"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ChangeDimension"],

Cell["\<\
ChangeDimension[exp, dim] changes all LorentzIndex and Momenta in exp to \
dimension dim (and also Levi-Civita-tensors, Dirac slashes and Dirac \
matrices).\
\>", "Text",
 CellTags->"ChangeDimension"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["LorentzIndex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LorentzIndex",
  ButtonNote->"LorentzIndex"],
 ", ",
 ButtonBox["Momentum",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Momentum",
  ButtonNote->"Momentum"],
 ", ",
 ButtonBox["DiracGamma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGamma",
  ButtonNote->"DiracGamma"],
 ", ",
 ButtonBox["Eps",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Eps",
  ButtonNote->"Eps"],
 "."
}], "Text",
 CellTags->"ChangeDimension"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ChangeDimension"],

Cell["\<\
Remember that LorentzIndex[mu, 4] is simplified to LorentzIndex[mu] and \
Momentum[p, 4] to Momentum[p]. Thus the fullowing objects are defined in four \
dimensions.\
\>", "Text",
 CellTags->"ChangeDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", " ", 
   RowBox[{"Momentum", "[", "p", "]"}]}], "}"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[136]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    FormBox["\[Mu]",
     TraditionalForm], ",", "p"}], "}"}], TraditionalForm]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[136]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeDimension", "[", 
  RowBox[{"%", ",", " ", "D"}], "]"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[137]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    FormBox["\[Mu]",
     TraditionalForm], ",", "p"}], "}"}], TraditionalForm]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[137]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[138]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", 
    RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", 
   RowBox[{"Momentum", "[", 
    RowBox[{"p", ",", "D"}], "]"}]}], "}"}]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[138]//StandardForm="]
}, Open  ]],

Cell["\<\
This changes all non-4-dimensional objects to 4-dimensional ones.\
\>", "Text",
 CellTags->"ChangeDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ChangeDimension", "[", 
   RowBox[{"%%", ",", " ", "4"}], "]"}], " ", "//", " ", 
  "StandardForm"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[139]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"Momentum", "[", "p", "]"}]}], "}"}]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[139]//StandardForm="]
}, Open  ]],

Cell["Consider the following list of 4- and D-dimensional object.", "Text",
 CellTags->"ChangeDimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"GA", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
    RowBox[{"MT", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}], ",", " ", 
   RowBox[{
    RowBox[{"GAD", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
    RowBox[{"MTD", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
    RowBox[{"f", "[", "D", "]"}]}]}], "}"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[140]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
      SuperscriptBox["\[Gamma]", "\[Nu]"]}], " ", 
     SuperscriptBox["g", 
      RowBox[{"\[Mu]", "\[Nu]"}]]}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
      SuperscriptBox["\[Gamma]", "\[Nu]"]}], " ", 
     RowBox[{"f", "(", "D", ")"}], " ", 
     SuperscriptBox["g", 
      RowBox[{"\[Mu]", "\[Nu]"}]]}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[140]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrick", "[", 
  RowBox[{"Contract", "[", "%", "]"}], "]"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[141]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]]}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], ".", 
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]]}], " ", 
     RowBox[{"f", "(", "D", ")"}]}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[141]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrick", "[", 
  RowBox[{"Contract", "[", 
   RowBox[{"ChangeDimension", "[", 
    RowBox[{"%%", ",", "n"}], "]"}], "]"}], "]"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[142]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]]}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], ".", 
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]]}], " ", 
     RowBox[{"f", "(", "D", ")"}]}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[142]="]
}, Open  ]],

Cell["\<\
Any explicit occurence of D (like in f(D)) is not replaced by \
ChangeDimension.\
\>", "Text",
 CellTags->"ChangeDimension"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"LeviCivita", ",", 
    RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], ";"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[143]:="],

Cell["\<\
The option Dimension of Eps must be changed too, since with the default \
setting Dimension\[Rule]4 the arguments of Eps are automatically changed to 4 \
dimensions.\
\>", "Text",
 CellTags->"ChangeDimension"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Eps", ",", 
    RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], ";"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[144]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a1", " ", "=", " ", 
  RowBox[{"LeviCivita", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
   "]"}]}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[145]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[145]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a2", " ", "=", " ", 
  RowBox[{"ChangeDimension", "[", 
   RowBox[{"a1", ",", "4"}], "]"}]}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[146]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[146]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor2", "[", 
  RowBox[{"Contract", "[", 
   SuperscriptBox["a1", "2"], "]"}], "]"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[147]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "D"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "-", "D"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"3", "-", "D"}], ")"}], " ", "D"}], TraditionalForm]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[147]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", 
  SuperscriptBox["a2", "2"], "]"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[148]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", "24"}], TraditionalForm]], "Output",
 CellTags->"ChangeDimension",
 CellLabel->"Out[148]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Eps", ",", 
    RowBox[{"Dimension", "\[Rule]", "4"}]}], "]"}], ";"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[149]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"a1", ",", "a2"}], "]"}], ";"}]], "Input",
 CellTags->"ChangeDimension",
 CellLabel->"In[150]:="]
}, Open  ]],

Cell["ChargeConjugationMatrix", "ObjectName",
 CellTags->"ChargeConjugationMatrix"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ChargeConjugationMatrix"],

Cell[TextData[{
 "ChargeConjugationMatrix denotes the charge conjugation matrix ",
 StyleBox["C",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"ChargeConjugationMatrix"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["ChargeConjugationMatrixInv",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ChargeConjugationMatrixInv",
  ButtonNote->"ChargeConjugationMatrixInv"],
 "."
}], "Text",
 CellTags->"ChargeConjugationMatrix"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ChargeConjugationMatrix"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChargeConjugationMatrix", ".", 
  RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], ".", 
  "ChargeConjugationMatrixInv"}]], "Input",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"In[151]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"C", ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"(", 
    RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"Out[151]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", "%", "]"}]], "Input",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"In[152]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   SubsuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], "T"]}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"Out[152]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChargeConjugationMatrix", ".", 
  RowBox[{"DiracGamma", "[", "5", "]"}], ".", 
  "ChargeConjugationMatrixInv"}]], "Input",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"In[153]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"C", ".", 
   SuperscriptBox["\[Gamma]", "5"], ".", 
   RowBox[{"(", 
    RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"Out[153]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", "%", "]"}]], "Input",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"In[154]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["\[Gamma]", 
   FormBox["5",
    TraditionalForm], "T"], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"Out[154]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChargeConjugationMatrix", "^", "2"}]], "Input",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"In[155]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", "1"}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrix",
 CellLabel->"Out[155]="]
}, Open  ]]
}, Open  ]],

Cell["ChargeConjugationMatrixInv", "ObjectName",
 CellTags->"ChargeConjugationMatrixInv"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ChargeConjugationMatrixInv"],

Cell["\<\
ChargeConjugationMatrixInv is the inverse of ChargeConjugationMatrix. It is \
substituted immediately by -ChargeConjugationMatrix.\
\>", "Text",
 CellTags->"ChargeConjugationMatrixInv"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["ChargeConjugationMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ChargeConjugationMatrix",
  ButtonNote->"ChargeConjugationMatrix"],
 "."
}], "Text",
 CellTags->"ChargeConjugationMatrixInv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ChargeConjugationMatrixInv"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChargeConjugationMatrix", ".", 
  RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], ".", 
  "ChargeConjugationMatrixInv"}]], "Input",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"In[156]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"C", ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"(", 
    RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"Out[156]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", "%", "]"}]], "Input",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"In[157]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   SubsuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], "T"]}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"Out[157]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChargeConjugationMatrix", ".", 
  RowBox[{"DiracGamma", "[", "5", "]"}], ".", 
  "ChargeConjugationMatrixInv"}]], "Input",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"In[158]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"C", ".", 
   SuperscriptBox["\[Gamma]", "5"], ".", 
   RowBox[{"(", 
    RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"Out[158]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", "%", "]"}]], "Input",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"In[159]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["\[Gamma]", 
   FormBox["5",
    TraditionalForm], "T"], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"Out[159]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChargeConjugationMatrix", ".", 
  "ChargeConjugationMatrixInv"}]], "Input",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"In[160]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"C", ".", 
   RowBox[{"(", 
    RowBox[{"-", "C"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"Out[160]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Calc"}]], "Input",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"In[161]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{"C", ".", "C"}]}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"Out[161]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChargeConjugationMatrixInv", "^", "2"}]], "Input",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"In[162]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", "1"}], TraditionalForm]], "Output",
 CellTags->"ChargeConjugationMatrixInv",
 CellLabel->"Out[162]="]
}, Open  ]]
}, Open  ]],

Cell["CheckContext", "ObjectName",
 CellTags->"CheckContext"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CheckContext"],

Cell["\<\
CheckContext[string] yields True if the packaged associated with string is \
already loaded, and False otherwise.\
\>", "Text",
 CellTags->"CheckContext"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["MakeContext",
  BaseStyle->"AddOnsLink",
  ButtonData:>"MakeContext",
  ButtonNote->"MakeContext"],
 ", ",
 ButtonBox["$FeynCalcStuff",
  BaseStyle->"AddOnsLink",
  ButtonData:>"$FeynCalcStuff",
  ButtonNote->"$FeynCalcStuff"],
 "."
}], "Text",
 CellTags->"CheckContext"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CheckContext"],

Cell["\<\
If a FeynCalc symbol has not been used, the corresponding subpackage has not \
been loaded:\
\>", "Text",
 CellTags->"CheckContext"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckContext", "[", "\"\<CompleteSquare\>\"", "]"}]], "Input",
 CellTags->"CheckContext",
 CellLabel->"In[163]:="],

Cell[BoxData[
 FormBox["False", TraditionalForm]], "Output",
 CellTags->"CheckContext",
 CellLabel->"Out[163]="]
}, Open  ]],

Cell["Using it makes FeynCalc load the subpackage:", "Text",
 CellTags->"CheckContext"],

Cell[CellGroupData[{

Cell[BoxData["CompleteSquare"], "Input",
 CellTags->"CheckContext",
 CellLabel->"In[164]:="],

Cell[BoxData[
 FormBox["CompleteSquare", TraditionalForm]], "Output",
 CellTags->"CheckContext",
 CellLabel->"Out[164]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckContext", "[", "\"\<CompleteSquare\>\"", "]"}]], "Input",
 CellTags->"CheckContext",
 CellLabel->"In[165]:="],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellTags->"CheckContext",
 CellLabel->"Out[165]="]
}, Open  ]]
}, Open  ]],

Cell["CheckDB", "ObjectName",
 CellTags->"CheckDB"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellTags->"CheckDB"],

Cell["\<\
CheckDB[exp, fil] saves [with Put] or retrieves [with Get] exp from a file \
fil. It checks if the setting of the option Directory is a valid directory \
name and if fil is a valid file name and does exist. If it does, Get[fil] is \
executed. If fil does not exist, exp gets evaluated and saved to  fil. Saving \
and evaluating can be further controlled with the options ForceSave and \
NoSave. If the option Check is set to False  the return value is what is \
evaluated [see above]. If Check is set to True the return value is True or \
False depending on whether the evaluation of exp agrees with what is loaded \
from fil or fil does not exist.  Default value of Check : False. NOTICE : If \
fil ends with \".Gen\" or \".Mod\", the   setting of Directory is ignored and \
fil is  saved in the \"CouplingVectors\"  subdirectory of \"Phi\". If fil \
ends with  \".Fac\", the setting of Directory is  ignored and fil is saved in \
the \"Factors\" subdirectory of \"Phi\". If fil is a file   name with full \
path, the setting of  Directory is also ignored.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "CheckDB", "]"}]], "Input",
 CellTags->"CheckDB",
 CellLabel->"In[166]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Directory", "\[RuleDelayed]", 
     RowBox[{"ToFileName", "[", 
      RowBox[{
       RowBox[{"{", "$FeynCalcDirectory", "}"}], ",", "\<\"fcdb\"\>"}], 
      "]"}]}], ",", 
    RowBox[{"ForceSave", "\[Rule]", "False"}], ",", 
    RowBox[{"NoSave", "\[Rule]", "False"}], ",", 
    RowBox[{"Check", "\[Rule]", "False"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"CheckDB",
 CellLabel->"Out[166]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "CheckDB", "]"}]], "Input",
 CellTags->"CheckDB",
 CellLabel->"In[167]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", "HoldFirst", "}"}], TraditionalForm]], "Output",
 CellTags->"CheckDB",
 CellLabel->"Out[167]="]
}, Open  ]],

Cell["\<\
The first time the Table function is evaluated and the result saved into the \
test.s file.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckDB", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"\"\<test \>\"", ",", "i"}], "]"}], ";", "i"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2"}], "}"}]}], "]"}], ",", "\"\<test.s\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[168]:="],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"test \"\>", "\[InvisibleSpace]", "1"}],
   SequenceForm["test ", 1],
   Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"test \"\>", "\[InvisibleSpace]", "2"}],
   SequenceForm["test ", 2],
   Editable->False], TraditionalForm]], "Print"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], TraditionalForm]], "Output",
 CellLabel->"Out[168]="]
}, Open  ]],

Cell["\<\
Executing the same a second time will just load the result from test.s and \
not evaluate the Table function.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckDB", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"WriteString", "[", 
       RowBox[{"\"\<stdout\>\"", ",", "\"\<test\>\""}], "]"}], ";", "i"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2"}], "}"}]}], "]"}], ",", "\"\<test.s\>\""}], 
  "]"}]], "Input",
 CellTags->"CheckDB",
 CellLabel->"In[169]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], TraditionalForm]], "Output",
 CellTags->"CheckDB",
 CellLabel->"Out[169]="]
}, Open  ]],

Cell["This shows the actual saved value of test.s.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
   RowBox[{"ToFileName", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$FeynCalcDirectory", ",", "\"\<fcdb\>\""}], "}"}], ",", 
     "\"\<test.s\>\""}], "]"}], ",", "\"\<Text\>\""}], "]"}]], "Input",
 CellTags->"CheckDB",
 CellLabel->"In[170]:="],

Cell[BoxData[
 FormBox["\<\"{1, 2}\\n\"\>", TraditionalForm]], "Output",
 CellTags->"CheckDB",
 CellLabel->"Out[170]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", 
  RowBox[{"ToFileName", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$FeynCalcDirectory", ",", "\"\<fcdb\>\""}], "}"}], ",", 
    "\"\<test.s\>\""}], "]"}], "]"}]], "Input",
 CellTags->"CheckDB",
 CellLabel->"In[171]:="]
}, Open  ]],

Cell["ChiralityProjector", "ObjectName",
 CellTags->"ChiralityProjector"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ChiralityProjector"],

Cell[TextData[{
 "ChiralityProjector[+1] denotes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[Gamma]", "5"]}], ")"}]}], TraditionalForm]]],
 ". ChiralityProjector[-1] denotes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[Gamma]", "5"]}], ")"}]}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"ChiralityProjector"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracGamma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGamma",
  ButtonNote->"DiracGamma"],
 ", ",
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix",
  ButtonNote->"DiracMatrix"],
 ", ",
 ButtonBox["FCI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCI",
  ButtonNote->"FCI"],
 "."
}], "Text",
 CellTags->"ChiralityProjector"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ChiralityProjector"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ChiralityProjector", "[", 
    RowBox[{"+", "1"}], "]"}], ",", 
   RowBox[{"ChiralityProjector", "[", 
    RowBox[{"-", "1"}], "]"}]}], "}"}]], "Input",
 CellTags->"ChiralityProjector",
 CellLabel->"In[172]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "6"], ",", 
    SuperscriptBox["\[Gamma]", "7"]}], "}"}], TraditionalForm]], "Output",
 CellTags->"ChiralityProjector",
 CellLabel->"Out[172]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FCI", "[", "%", "]"}]], "Input",
 CellTags->"ChiralityProjector",
 CellLabel->"In[173]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "6"], ",", 
    SuperscriptBox["\[Gamma]", "7"]}], "}"}], TraditionalForm]], "Output",
 CellTags->"ChiralityProjector",
 CellLabel->"Out[173]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{"DiracSubstitute67", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"ChiralityProjector",
 CellLabel->"In[174]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox[
      SuperscriptBox["\[Gamma]", "5"], "2"], "+", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      SuperscriptBox["\[Gamma]", "5"], "2"]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"ChiralityProjector",
 CellLabel->"Out[174]="]
}, Open  ]]
}, Open  ]],

Cell["Chisholm", "ObjectName",
 CellTags->"Chisholm"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Chisholm"],

Cell["\<\
Chisholm[x] substitutes products of three Dirac matrices or slashes by the \
Chisholm identity.\
\>", "Text",
 CellTags->"Chisholm"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["EpsChisholm",
  BaseStyle->"AddOnsLink",
  ButtonData:>"EpsChisholm",
  ButtonNote->"EpsChisholm"],
 ", ",
 ButtonBox["ChisholmSpinor",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ChisholmSpinor",
  ButtonNote->"ChisholmSpinor"],
 "."
}], "Text",
 CellTags->"Chisholm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Chisholm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chisholm", "[", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Mu]", ",", "\[Nu]"}], "]"}], 
  "]"}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[175]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$305",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Alpha]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Beta]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$305",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Beta]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Mu]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Alpha]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Beta]", "\[Mu]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[175]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{"DiracMatrix", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]"}], "]"}]}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[176]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], 
   SuperscriptBox["\[Gamma]", "\[Nu]"], 
   SuperscriptBox["\[Gamma]", "\[Rho]"]}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[176]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", " ", "=", 
  RowBox[{"Chisholm", "[", "t1", "]"}]}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[177]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$327",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$327",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]]}], "+", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[177]="]
}, Open  ]],

Cell["The $MU$ variables are unique indices.", "Text",
 CellTags->"Chisholm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{"t1", ".", "t1"}], "]"}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[178]:="],

Cell[BoxData[
 FormBox["16", TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[178]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", " ", "=", 
  RowBox[{"Chisholm", "[", "t1", "]"}]}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[179]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$346",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$346",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]]}], "+", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[179]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{"t2", ".", "t3"}], "]"}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[180]:="],

Cell[BoxData[
 FormBox["16", TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[180]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t4", "=", 
  RowBox[{"DiracSlash", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}]}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[181]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["a",
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["b",
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["c",
      TraditionalForm]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[181]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chisholm", "[", "t4", "]"}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[182]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$373",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["$MU$373",
        TraditionalForm],
       TraditionalForm], 
      FormBox["a",
       TraditionalForm], 
      FormBox["b",
       TraditionalForm], 
      FormBox["c",
       TraditionalForm]}]]}], "+", 
   RowBox[{
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["c",
      TraditionalForm]}], " ", 
    RowBox[{
     FormBox["a",
      TraditionalForm], "\[CenterDot]", 
     FormBox["b",
      TraditionalForm]}]}], "-", 
   RowBox[{
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["b",
      TraditionalForm]}], " ", 
    RowBox[{
     FormBox["a",
      TraditionalForm], "\[CenterDot]", 
     FormBox["c",
      TraditionalForm]}]}], "+", 
   RowBox[{
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["a",
      TraditionalForm]}], " ", 
    RowBox[{
     FormBox["b",
      TraditionalForm], "\[CenterDot]", 
     FormBox["c",
      TraditionalForm]}]}]}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[182]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a1", "=", 
  RowBox[{"GA", "[", 
   RowBox[{
   "\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]", ",", "\[Tau]", ",", 
    "\[Kappa]"}], "]"}]}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[183]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Rho]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Sigma]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Tau]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Kappa]"]}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[183]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a2", " ", "=", 
  RowBox[{"Chisholm", "[", "a1", "]"}]}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[184]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$404",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$404",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$415",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$415",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$426",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$426",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Tau]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Tau]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Tau]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Tau]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$382",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$382",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Sigma]", "\[Tau]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Sigma]", "\[Tau]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Sigma]", "\[Tau]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Sigma]", "\[Tau]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[184]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a3", " ", "=", 
  RowBox[{"Chisholm", "[", "a1", "]"}]}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[185]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$487",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$487",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$498",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$498",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$509",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$509",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Tau]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Tau]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Tau]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Tau]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Tau]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Tau]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$465",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$465",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Sigma]", "\[Tau]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Sigma]", "\[Tau]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Sigma]", "\[Tau]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Kappa]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Sigma]", "\[Tau]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[185]="]
}, Open  ]],

Cell["Check that both a1.a1 and a2.a3 give the same.", "Text",
 CellTags->"Chisholm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{"a1", ".", "a1"}], "]"}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[186]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", "2048"}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[186]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{"a2", ".", "a3"}], "]"}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[187]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", "2048"}], TraditionalForm]], "Output",
 CellTags->"Chisholm",
 CellLabel->"Out[187]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "t1", ",", "t2", ",", "t3", ",", "t4", ",", "a1", ",", "a2", ",", "a3"}], 
  "]"}]], "Input",
 CellTags->"Chisholm",
 CellLabel->"In[188]:="]
}, Open  ]],

Cell["ChisholmSpinor", "ObjectName",
 CellTags->"ChisholmSpinor"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ChisholmSpinor"],

Cell["\<\
ChisholmSpinor[x] uses the Chisholm identity on a DiraGamma between spinors. \
As an optional second argument 1 or 2 may be given, indicating that \
ChisholmSpinor should only act on the first resp. second part of a product of \
spinor chains.\
\>", "Text",
 CellTags->"ChisholmSpinor"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["EpsChisholm",
  BaseStyle->"AddOnsLink",
  ButtonData:>"EpsChisholm",
  ButtonNote->"EpsChisholm"],
 ", ",
 ButtonBox["Chisholm",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Chisholm",
  ButtonNote->"Chisholm"],
 "."
}], "Text",
 CellTags->"ChisholmSpinor"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ChisholmSpinor"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Spinor", "[", 
   RowBox[{"p1", ",", "m1"}], "]"}], ".", 
  RowBox[{"DiracGamma", "[", 
   RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], ".", 
  RowBox[{"Spinor", "[", 
   RowBox[{"p2", ",", "m2"}], "]"}]}]], "Input",
 CellTags->"ChisholmSpinor",
 CellLabel->"In[189]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CurlyPhi]", "(", 
    FormBox["p1",
     TraditionalForm], ",", "m1", ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"\[CurlyPhi]", "(", 
    FormBox["p2",
     TraditionalForm], ",", "m2", ")"}]}], TraditionalForm]], "Output",
 CellTags->"ChisholmSpinor",
 CellLabel->"Out[189]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ChisholmSpinor"}]], "Input",
 CellTags->"ChisholmSpinor",
 CellLabel->"In[190]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"m1", " ", "m2", " ", 
      RowBox[{
       RowBox[{"\[CurlyPhi]", "(", 
        FormBox["p1",
         TraditionalForm], ",", "m1", ")"}], ".", 
       SuperscriptBox["\[Gamma]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], ".", 
       RowBox[{"\[CurlyPhi]", "(", 
        FormBox["p2",
         TraditionalForm], ",", "m2", ")"}]}]}], 
     RowBox[{
      FormBox["p1",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p2",
       TraditionalForm]}]]}], "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{
      RowBox[{"\[CurlyPhi]", "(", 
       FormBox["p1",
        TraditionalForm], ",", "m1", ")"}], ".", 
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["alpha1",
         TraditionalForm],
        TraditionalForm]], ".", 
      SuperscriptBox["\[Gamma]", "5"], ".", 
      RowBox[{"\[CurlyPhi]", "(", 
       FormBox["p2",
        TraditionalForm], ",", "m2", ")"}]}], " ", 
     SuperscriptBox["\[Epsilon]", 
      RowBox[{
       FormBox[
        FormBox["alpha1",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox["p1",
        TraditionalForm], 
       FormBox["p2",
        TraditionalForm]}]]}], 
    RowBox[{
     FormBox["p1",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p2",
      TraditionalForm]}]], "+", 
   FractionBox[
    RowBox[{"m2", " ", 
     RowBox[{
      RowBox[{"\[CurlyPhi]", "(", 
       FormBox["p1",
        TraditionalForm], ",", "m1", ")"}], ".", 
      RowBox[{"\[CurlyPhi]", "(", 
       FormBox["p2",
        TraditionalForm], ",", "m2", ")"}]}], " ", 
     SuperscriptBox[
      FormBox["p1",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]]}], 
    RowBox[{
     FormBox["p1",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p2",
      TraditionalForm]}]], "+", 
   FractionBox[
    RowBox[{"m1", " ", 
     RowBox[{
      RowBox[{"\[CurlyPhi]", "(", 
       FormBox["p1",
        TraditionalForm], ",", "m1", ")"}], ".", 
      RowBox[{"\[CurlyPhi]", "(", 
       FormBox["p2",
        TraditionalForm], ",", "m2", ")"}]}], " ", 
     SuperscriptBox[
      FormBox["p2",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]]}], 
    RowBox[{
     FormBox["p1",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p2",
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"ChisholmSpinor",
 CellLabel->"Out[190]="]
}, Open  ]]
}, Open  ]],

Cell["ClearScalarProducts", "ObjectName",
 CellTags->"ClearScalarProducts"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ClearScalarProducts"],

Cell["\<\
ClearScalarProducts removes all user-performed specific settings for \
ScalarProduct's.\
\>", "Text",
 CellTags->"ClearScalarProducts"],

Cell[TextData[{
 "See also: ",
 ButtonBox["ScalarProduct",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ScalarProduct",
  ButtonNote->"ScalarProduct"],
 ", ",
 ButtonBox["Pair",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Pair",
  ButtonNote->"Pair"],
 ", ",
 ButtonBox["SP",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SP",
  ButtonNote->"SP"],
 ", ",
 ButtonBox["SPD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SPD",
  ButtonNote->"SPD"],
 "."
}], "Text",
 CellTags->"ClearScalarProducts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ClearScalarProducts"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ScalarProduct", "[", 
   RowBox[{"p", ",", "p"}], "]"}], "=", 
  RowBox[{"m", "^", "2"}]}]], "Input",
 CellTags->"ClearScalarProducts",
 CellLabel->"In[191]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["m", "2"], TraditionalForm]], "Output",
 CellTags->"ClearScalarProducts",
 CellLabel->"Out[191]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pair", "[", 
  RowBox[{
   RowBox[{"Momentum", "[", "p", "]"}], ",", 
   RowBox[{"Momentum", "[", "p", "]"}]}], "]"}]], "Input",
 CellTags->"ClearScalarProducts",
 CellLabel->"In[192]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["m", "2"], TraditionalForm]], "Output",
 CellTags->"ClearScalarProducts",
 CellLabel->"Out[192]="]
}, Open  ]],

Cell[BoxData["ClearScalarProducts"], "Input",
 CellTags->"ClearScalarProducts",
 CellLabel->"In[193]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pair", "[", 
  RowBox[{
   RowBox[{"Momentum", "[", "p", "]"}], ",", 
   RowBox[{"Momentum", "[", "p", "]"}]}], "]"}]], "Input",
 CellTags->"ClearScalarProducts",
 CellLabel->"In[194]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox["p",
    TraditionalForm], "2"], TraditionalForm]], "Output",
 CellTags->"ClearScalarProducts",
 CellLabel->"Out[194]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalarProduct", "[", 
  RowBox[{"p", ",", "p"}], "]"}]], "Input",
 CellTags->"ClearScalarProducts",
 CellLabel->"In[195]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox["p",
    TraditionalForm], "2"], TraditionalForm]], "Output",
 CellTags->"ClearScalarProducts",
 CellLabel->"Out[195]="]
}, Open  ]]
}, Open  ]],

Cell["Collecting", "ObjectName",
 CellTags->"Collecting"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Collecting"],

Cell["\<\
Collecting is an option of ScalarProductCancel, Series2, TID and related \
functions. Setting it to True will trigger some kind of collecting of the \
result.\
\>", "Text",
 CellTags->"Collecting"],

Cell[TextData[{
 "See also:  ",
 ButtonBox["ScalarProductCancel",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ScalarProductCancel",
  ButtonNote->"ScalarProductCancel"],
 ", ",
 ButtonBox["Series2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Series2",
  ButtonNote->"Series2"],
 ", ",
 ButtonBox["TID",
  BaseStyle->"AddOnsLink",
  ButtonData:>"TID",
  ButtonNote->"TID"],
 "."
}], "Text",
 CellTags->"Collecting"]
}, Open  ]],

Cell["Collect2", "ObjectName",
 CellTags->"Collect2"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Collect2"],

Cell["\<\
Collect2[expr, x] collects together terms which are not free of any \
occurrence of x. Collect2[expr, {x1, x2, ...}] (or also Collect2[expr, x1, \
x2, ...]) collects together terms which are not free of any occurrence of x1, \
x2, .... The coefficients are put over a common denominator. If expr is \
expanded before collecting depends on the option Factoring, which may be set \
to Factor, Factor2, or any other function, which is applied to the \
coefficients. If expr is already expanded with respect to x (x1,x2, ...), the \
option Expanding can be set to False.\
\>", "Text",
 CellTags->"Collect2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Collect2", "]"}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[196]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Denominator", "\[Rule]", "False"}], ",", 
    RowBox[{"Dot", "\[Rule]", "False"}], ",", 
    RowBox[{"Expanding", "\[Rule]", "True"}], ",", 
    RowBox[{"Factoring", "\[Rule]", "Factor2"}], ",", 
    RowBox[{"IsolateNames", "\[Rule]", "False"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"Collect2",
 CellLabel->"Out[196]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Isolate",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Isolate",
  ButtonNote->"Isolate"],
 "."
}], "Text",
 CellTags->"Collect2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Collect2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect2", "[", 
  RowBox[{
   RowBox[{"t1", "=", 
    RowBox[{"a", "+", 
     RowBox[{"r", " ", "a"}], "+", 
     RowBox[{
      SuperscriptBox["k", "2"], " ", 
      RowBox[{"f", "[", "a", "]"}]}], "-", 
     RowBox[{"k", " ", 
      RowBox[{"f", "[", "a", "]"}]}], "+", 
     FractionBox["x", "2"], "-", 
     FractionBox["y", "w"]}]}], ",", "a"}], "]"}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[197]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"r", "+", "1"}], ")"}]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"w", " ", "x"}], "-", 
     RowBox[{"2", " ", "y"}]}], 
    RowBox[{"2", " ", "w"}]], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "k"}], ")"}], " ", "k", " ", 
    RowBox[{"f", "(", "a", ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"Collect2",
 CellLabel->"Out[197]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect2", "[", 
  RowBox[{"t1", ",", "a", ",", 
   RowBox[{"Factoring", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[198]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"r", "+", "1"}], ")"}]}], "+", 
   FractionBox["x", "2"], "-", 
   FractionBox["y", "w"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["k", "2"], "-", "k"}], ")"}], " ", 
    RowBox[{"f", "(", "a", ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"Collect2",
 CellLabel->"Out[198]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect2", "[", 
  RowBox[{"t1", ",", "a", ",", 
   RowBox[{"Factoring", "\[Rule]", "Factor"}]}], "]"}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[199]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"r", "+", "1"}], ")"}]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"w", " ", "x"}], "-", 
     RowBox[{"2", " ", "y"}]}], 
    RowBox[{"2", " ", "w"}]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"k", "-", "1"}], ")"}], " ", "k", " ", 
    RowBox[{"f", "(", "a", ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"Collect2",
 CellLabel->"Out[199]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "-", "a"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"h", "-", "1"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"e", " ", "a"}], "-", "c"}], ")"}]}], "+", 
    SuperscriptBox["b", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[200]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "h"}], ")"}], " ", 
    SuperscriptBox["a", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "e", " ", "a"}], "-", 
   RowBox[{"2", " ", "b", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "h"}], ")"}], " ", "a"}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", "1"}], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"Collect2",
 CellLabel->"Out[200]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect2", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "b", "-", "c", "-", "d"}], ")"}], "5"], "]"}], ",", 
   "a", ",", 
   RowBox[{"IsolateNames", "\[Rule]", "L"}]}], "]"}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[201]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["a", "5"], "-", 
   RowBox[{"5", " ", 
    TagBox[
     RowBox[{"L", "(", "1", ")"}],
     HoldForm], " ", 
    SuperscriptBox["a", "4"]}], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox[
     TagBox[
      RowBox[{"L", "(", "1", ")"}],
      HoldForm], "2"], " ", 
    SuperscriptBox["a", "3"]}], "-", 
   RowBox[{"10", " ", 
    SuperscriptBox[
     TagBox[
      RowBox[{"L", "(", "1", ")"}],
      HoldForm], "3"], " ", 
    SuperscriptBox["a", "2"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox[
     TagBox[
      RowBox[{"L", "(", "1", ")"}],
      HoldForm], "4"], " ", "a"}], "-", 
   SuperscriptBox[
    TagBox[
     RowBox[{"L", "(", "1", ")"}],
     HoldForm], "5"]}], TraditionalForm]], "Output",
 CellTags->"Collect2",
 CellLabel->"Out[201]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[202]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["a", "5"], "-", 
   RowBox[{"5", " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c", "+", "d"}], ")"}], " ", 
    SuperscriptBox["a", "4"]}], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "c", "+", "d"}], ")"}], "2"], " ", 
    SuperscriptBox["a", "3"]}], "-", 
   RowBox[{"10", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "c", "+", "d"}], ")"}], "3"], " ", 
    SuperscriptBox["a", "2"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "c", "+", "d"}], ")"}], "4"], " ", "a"}], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", "c", "+", "d"}], ")"}], "5"]}], 
  TraditionalForm]], "Output",
 CellTags->"Collect2",
 CellLabel->"Out[202]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"t1", ",", "L"}], "]"}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[203]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect2", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "b", "-", "c"}], ")"}], "3"], "]"}], ",", "a", ",", 
   RowBox[{"Factoring", "\[Rule]", "fun"}]}], "]"}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[204]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"fun", "(", "1", ")"}], " ", 
    SuperscriptBox["a", "3"]}], "+", 
   RowBox[{
    RowBox[{"fun", "(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "b"}], "-", 
      RowBox[{"3", " ", "c"}]}], ")"}], " ", 
    SuperscriptBox["a", "2"]}], "+", 
   RowBox[{
    RowBox[{"fun", "(", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"6", " ", "c", " ", "b"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"]}]}], ")"}], " ", "a"}], "+", 
   RowBox[{"fun", "(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["b", "3"]}], "-", 
     RowBox[{"3", " ", "c", " ", 
      SuperscriptBox["b", "2"]}], "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["c", "2"], " ", "b"}], "-", 
     SuperscriptBox["c", "3"]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Collect2",
 CellLabel->"Out[204]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "/.", " ", 
  RowBox[{"fun", "\[Rule]", "FactorTerms"}]}]], "Input",
 CellTags->"Collect2",
 CellLabel->"In[205]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["a", "3"], "-", 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}], " ", 
    SuperscriptBox["a", "2"]}], "+", 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "+", 
      RowBox[{"2", " ", "c", " ", "b"}], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "a"}], "-", 
   SuperscriptBox["b", "3"], "-", 
   SuperscriptBox["c", "3"], "-", 
   RowBox[{"3", " ", "b", " ", 
    SuperscriptBox["c", "2"]}], "-", 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "2"], " ", "c"}]}], TraditionalForm]], "Output",
 CellTags->"Collect2",
 CellLabel->"Out[205]="]
}, Open  ]]
}, Open  ]],

Cell["Collect3", "ObjectName",
 CellTags->"Collect3"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Collect3"],

Cell[TextData[{
 "Collect3[expr, {x, y, ...}] collects terms involving the same powers of \
monomials ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["x",
     FontSlant->"Plain"], 
    SubscriptBox[
     StyleBox["n",
      FontSlant->"Plain"], "1"]], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["y",
     FontSlant->"Plain"], 
    SubscriptBox[
     StyleBox["n",
      FontSlant->"Plain"], "2"]], TraditionalForm]]],
 " ... An option Factor \[Rule] True/False can be  given, which factors the \
coefficients. The option Head (default Plus) determines the applied function \
to the list of monomials  mulitplied by their coefficients."
}], "Text",
 CellTags->"Collect3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Collect3", "]"}]], "Input",
 CellTags->"Collect3",
 CellLabel->"In[206]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
    RowBox[{"Head", "\[Rule]", "Plus"}]}], "}"}], TraditionalForm]], "Output",\

 CellTags->"Collect3",
 CellLabel->"Out[206]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Collect2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Collect2",
  ButtonNote->"Collect2"],
 ", ",
 ButtonBox["Isolate",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Isolate",
  ButtonNote->"Isolate"],
 "."
}], "Text",
 CellTags->"Collect3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Collect3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect3", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"b", "-", "a"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"h", "-", "1"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"e", " ", "a"}], "-", "c"}], ")"}]}], "+", 
    SuperscriptBox["b", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellTags->"Collect3",
 CellLabel->"In[207]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"List", "+", 
   RowBox[{"Internal`DistributedTermsList", "(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "e"}], "-", "c"}], ")"}]}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      RowBox[{"2", " ", "a", " ", 
       RowBox[{"(", 
        RowBox[{"b", "-", "a"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"h", "-", "1"}], ")"}]}]}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"CoefficientDomain", "\[Rule]", "RationalFunctions"}]}], ")"}]}],
   TraditionalForm]], "Output",
 CellTags->"Collect3",
 CellLabel->"Out[207]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect3", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "b", "-", "c", "-", "d"}], ")"}], "5"], "]"}], ",", 
   RowBox[{"{", "a", "}"}]}], "]"}]], "Input",
 CellTags->"Collect3",
 CellLabel->"In[208]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"List", "+", 
   RowBox[{"Internal`DistributedTermsList", "(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "5"], "-", 
      RowBox[{"5", " ", "b", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"5", " ", "c", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"5", " ", "d", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{"20", " ", "b", " ", "c", " ", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{"20", " ", "b", " ", "d", " ", 
       SuperscriptBox["a", "3"]}], "+", 
      RowBox[{"20", " ", "c", " ", "d", " ", 
       SuperscriptBox["a", "3"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["c", "3"], " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["d", "3"], " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"30", " ", "b", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"30", " ", "b", " ", 
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"30", " ", "c", " ", 
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["b", "2"], " ", "c", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["b", "2"], " ", "d", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["c", "2"], " ", "d", " ", 
       SuperscriptBox["a", "2"]}], "-", 
      RowBox[{"60", " ", "b", " ", "c", " ", "d", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "4"], " ", "a"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"], " ", "a"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["d", "4"], " ", "a"}], "+", 
      RowBox[{"20", " ", "b", " ", 
       SuperscriptBox["c", "3"], " ", "a"}], "+", 
      RowBox[{"20", " ", "b", " ", 
       SuperscriptBox["d", "3"], " ", "a"}], "+", 
      RowBox[{"20", " ", "c", " ", 
       SuperscriptBox["d", "3"], " ", "a"}], "+", 
      RowBox[{"30", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "a"}], "+", 
      RowBox[{"30", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["d", "2"], " ", "a"}], "+", 
      RowBox[{"30", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["d", "2"], " ", "a"}], "+", 
      RowBox[{"60", " ", "b", " ", "c", " ", 
       SuperscriptBox["d", "2"], " ", "a"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["b", "3"], " ", "c", " ", "a"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["b", "3"], " ", "d", " ", "a"}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["c", "3"], " ", "d", " ", "a"}], "+", 
      RowBox[{"60", " ", "b", " ", 
       SuperscriptBox["c", "2"], " ", "d", " ", "a"}], "+", 
      RowBox[{"60", " ", 
       SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", "a"}], "-", 
      SuperscriptBox["b", "5"], "-", 
      SuperscriptBox["c", "5"], "-", 
      SuperscriptBox["d", "5"], "-", 
      RowBox[{"5", " ", "b", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{"5", " ", "b", " ", 
       SuperscriptBox["d", "4"]}], "-", 
      RowBox[{"5", " ", "c", " ", 
       SuperscriptBox["d", "4"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["d", "3"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["d", "3"]}], "-", 
      RowBox[{"20", " ", "b", " ", "c", " ", 
       SuperscriptBox["d", "3"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["b", "3"], " ", 
       SuperscriptBox["d", "2"]}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["c", "3"], " ", 
       SuperscriptBox["d", "2"]}], "-", 
      RowBox[{"30", " ", "b", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["d", "2"]}], "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["b", "2"], " ", "c", " ", 
       SuperscriptBox["d", "2"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "4"], " ", "c"}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "4"], " ", "d"}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"], " ", "d"}], "-", 
      RowBox[{"20", " ", "b", " ", 
       SuperscriptBox["c", "3"], " ", "d"}], "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "d"}], "-", 
      RowBox[{"20", " ", 
       SuperscriptBox["b", "3"], " ", "c", " ", "d"}]}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"CoefficientDomain", "\[Rule]", "RationalFunctions"}]}], ")"}]}],
   TraditionalForm]], "Output",
 CellTags->"Collect3",
 CellLabel->"Out[208]="]
}, Open  ]]
}, Open  ]],

Cell["Combine", "ObjectName",
 CellTags->"Combine"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Combine"],

Cell["\<\
Combine[expr]puts terms in a sum over a common denominator,and cancels \
factors in the result. Combine is similar to Together, but accepts the option \
Expanding and works usually better than Together for polynomials involving \
rationals with sums in the denominator.\
\>", "Text",
 CellTags->"Combine"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Combine", "]"}]], "Input",
 CellTags->"Combine",
 CellLabel->"In[209]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"Expanding", "\[Rule]", "False"}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"Combine",
 CellLabel->"Out[209]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Factor2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Factor2",
  ButtonNote->"Factor2"],
 "."
}], "Text",
 CellTags->"Combine"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Combine"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Combine", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"c", "-", "d"}], ")"}]}], "e"], "+", "g"}], "]"}]], "Input",
 CellTags->"Combine",
 CellLabel->"In[210]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"c", "-", "d"}], ")"}]}], "+", 
    RowBox[{"e", " ", "g"}]}], "e"], TraditionalForm]], "Output",
 CellTags->"Combine",
 CellLabel->"Out[210]="]
}, Open  ]],

Cell["\<\
Here the result from Together where the numerator is automatically expanded.\
\>", "Text",
 CellTags->"Combine"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"c", "-", "d"}], ")"}]}], "e"], "+", "g"}], "]"}]], "Input",
 CellTags->"Combine",
 CellLabel->"In[211]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{"a", " ", "c"}], "-", 
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}], "+", 
    RowBox[{"b", " ", "d"}], "+", 
    RowBox[{"e", " ", "g"}]}], "e"], TraditionalForm]], "Output",
 CellTags->"Combine",
 CellLabel->"Out[211]="]
}, Open  ]],

Cell["\<\
If the option Expanding is set to True, the result of Combine is the same as \
Together, but uses a slightly different algorithm.\
\>", "Text",
 CellTags->"Combine"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Combine", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "-", "d"}], ")"}]}], "e"], "+", "g"}], ",", 
   RowBox[{"Expanding", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"Combine",
 CellLabel->"In[212]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{"a", " ", "c"}], "-", 
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}], "+", 
    RowBox[{"b", " ", "d"}], "+", 
    RowBox[{"e", " ", "g"}]}], "e"], TraditionalForm]], "Output",
 CellTags->"Combine",
 CellLabel->"Out[212]="]
}, Open  ]]
}, Open  ]],

Cell["CombineGraphs", "ObjectName",
 CellTags->"CombineGraphs"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CombineGraphs"],

Cell["CombineGraphs is an option for OneLoopSum.", "Text",
 CellTags->"CombineGraphs"],

Cell[TextData[{
 "See also:  ",
 ButtonBox["OneLoopSum",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoopSum",
  ButtonNote->"OneLoopSum"],
 "."
}], "Text",
 CellTags->"CombineGraphs"]
}, Open  ]],

Cell["Commutator", "ObjectName",
 CellTags->"Commutator"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Commutator"],

Cell["\<\
Commutator[x, y] = c defines the commutator between the non-commuting objects \
x and y. \
\>", "Text",
 CellTags->"Commutator"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["AntiCommutator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"AntiCommutator",
  ButtonNote->"AntiCommutator"],
 ", ",
 ButtonBox["CommutatorExplicit",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CommutatorExplicit",
  ButtonNote->"CommutatorExplicit"],
 ", ",
 ButtonBox["DeclareNonCommutative",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DeclareNonCommutative",
  ButtonNote->"DeclareNonCommutative"],
 ", ",
 ButtonBox["DotSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DotSimplify",
  ButtonNote->"DotSimplify"],
 "."
}], "Text",
 CellTags->"Commutator"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Commutator"],

Cell[BoxData[
 RowBox[{"DeclareNonCommutative", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[213]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Commutator", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[214]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"[", "\[NoBreak]", "a", "\[NoBreak]", ",", "b", "\[NoBreak]", "]"}],
   TraditionalForm]], "Output",
 CellTags->"Commutator",
 CellLabel->"Out[214]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommutatorExplicit", "[", "%", "]"}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[215]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "b"}], "-", 
   RowBox[{"b", ".", "a"}]}], TraditionalForm]], "Output",
 CellTags->"Commutator",
 CellLabel->"Out[215]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DotSimplify", "[", 
   RowBox[{"Commutator", "[", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ",", 
     RowBox[{"c", "+", "d"}]}], "]"}], "]"}], " "}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[216]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "c"}], "+", 
   RowBox[{"a", ".", "d"}], "+", 
   RowBox[{"b", ".", "c"}], "+", 
   RowBox[{"b", ".", "d"}], "-", 
   RowBox[{"c", ".", "a"}], "-", 
   RowBox[{"c", ".", "b"}], "-", 
   RowBox[{"d", ".", "a"}], "-", 
   RowBox[{"d", ".", "b"}]}], TraditionalForm]], "Output",
 CellTags->"Commutator",
 CellLabel->"Out[216]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"UnDeclareNonCommutative", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[217]:="],

Cell["Verify the Jacobi identity.", "Text",
 CellTags->"Commutator"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Chi]", "=", "Commutator"}], ";", " ", 
  RowBox[{"DeclareNonCommutative", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], ";"}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[218]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Chi]", "[", 
   RowBox[{"x", ",", 
    RowBox[{"\[Chi]", "[", 
     RowBox[{"y", ",", "z"}], "]"}]}], "]"}], "+", 
  RowBox[{"\[Chi]", "[", 
   RowBox[{"y", ",", 
    RowBox[{"\[Chi]", "[", 
     RowBox[{"z", ",", "x"}], "]"}]}], "]"}], "+", 
  RowBox[{"\[Chi]", "[", 
   RowBox[{"z", ",", 
    RowBox[{"\[Chi]", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], "]"}]}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[219]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"[", "\[NoBreak]", "x", "\[NoBreak]", ",", 
    FormBox[
     RowBox[{
     "[", "\[NoBreak]", "y", "\[NoBreak]", ",", "z", "\[NoBreak]", "]"}],
     TraditionalForm], "\[NoBreak]", "]"}], "+", 
   RowBox[{"[", "\[NoBreak]", "y", "\[NoBreak]", ",", 
    FormBox[
     RowBox[{
     "[", "\[NoBreak]", "z", "\[NoBreak]", ",", "x", "\[NoBreak]", "]"}],
     TraditionalForm], "\[NoBreak]", "]"}], "+", 
   RowBox[{"[", "\[NoBreak]", "z", "\[NoBreak]", ",", 
    FormBox[
     RowBox[{
     "[", "\[NoBreak]", "x", "\[NoBreak]", ",", "y", "\[NoBreak]", "]"}],
     TraditionalForm], "\[NoBreak]", "]"}]}], TraditionalForm]], "Output",
 CellTags->"Commutator",
 CellLabel->"Out[219]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", "%", "]"}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[220]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"Commutator",
 CellLabel->"Out[220]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "\[Chi]", "]"}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[221]:="],

Cell[BoxData[
 RowBox[{"UnDeclareNonCommutative", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellTags->"Commutator",
 CellLabel->"In[222]:="]
}, Open  ]],

Cell["CommutatorExplicit", "ObjectName",
 CellTags->"CommutatorExplicit"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CommutatorExplicit"],

Cell["\<\
CommutatorExplicit[exp] substitutes any Commutator and AntiCommutator in exp \
by their definitions.\
\>", "Text",
 CellTags->"CommutatorExplicit"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Calc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Calc",
  ButtonNote->"Calc"],
 ", ",
 ButtonBox["DotSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DotSimplify",
  ButtonNote->"DotSimplify"],
 "."
}], "Text",
 CellTags->"CommutatorExplicit"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CommutatorExplicit"],

Cell[BoxData[
 RowBox[{"DeclareNonCommutative", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellTags->"CommutatorExplicit",
 CellLabel->"In[223]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Commutator", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellTags->"CommutatorExplicit",
 CellLabel->"In[224]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"[", "\[NoBreak]", "a", "\[NoBreak]", ",", "b", "\[NoBreak]", "]"}],
   TraditionalForm]], "Output",
 CellTags->"CommutatorExplicit",
 CellLabel->"Out[224]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommutatorExplicit", "[", "%", "]"}]], "Input",
 CellTags->"CommutatorExplicit",
 CellLabel->"In[225]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "b"}], "-", 
   RowBox[{"b", ".", "a"}]}], TraditionalForm]], "Output",
 CellTags->"CommutatorExplicit",
 CellLabel->"Out[225]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AntiCommutator", "[", 
  RowBox[{
   RowBox[{"a", "-", "c"}], ",", 
   RowBox[{"b", "-", "d"}]}], "]"}]], "Input",
 CellTags->"CommutatorExplicit",
 CellLabel->"In[226]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   FormBox[
    RowBox[{"a", "-", "c"}],
    TraditionalForm], ",", "\[MediumSpace]", 
   FormBox[
    RowBox[{"b", "-", "d"}],
    TraditionalForm], "}"}], TraditionalForm]], "Output",
 CellTags->"CommutatorExplicit",
 CellLabel->"Out[226]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommutatorExplicit", "[", "%", "]"}]], "Input",
 CellTags->"CommutatorExplicit",
 CellLabel->"In[227]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "c"}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{"b", "-", "d"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "-", "d"}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{"a", "-", "c"}], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"CommutatorExplicit",
 CellLabel->"Out[227]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CommutatorExplicit", "[", "%%", "]"}], "//", 
  "DotSimplify"}]], "Input",
 CellTags->"CommutatorExplicit",
 CellLabel->"In[228]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "b"}], "-", 
   RowBox[{"a", ".", "d"}], "+", 
   RowBox[{"b", ".", "a"}], "-", 
   RowBox[{"b", ".", "c"}], "-", 
   RowBox[{"c", ".", "b"}], "+", 
   RowBox[{"c", ".", "d"}], "-", 
   RowBox[{"d", ".", "a"}], "+", 
   RowBox[{"d", ".", "c"}]}], TraditionalForm]], "Output",
 CellTags->"CommutatorExplicit",
 CellLabel->"Out[228]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"UnDeclareNonCommutative", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellTags->"CommutatorExplicit",
 CellLabel->"In[229]:="]
}, Open  ]],

Cell["CompleteSquare", "ObjectName",
 CellTags->"CompleteSquare"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CompleteSquare"],

Cell[TextData[{
 "Completes the square of a second order polynomial in the momentum x. \
CompleteSquare[",
 "a",
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 "+",
 "b",
 " ",
 "p",
 "+",
 "c",
 ", ",
 "p",
 "] \[Rule] -",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["b",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 "/(4 ",
 "a",
 ")+",
 "c",
 "+",
 "a",
 " (",
 "b",
 "/(2 ",
 "a",
 ")+",
 "x",
 ")^2. CompleteSquare[",
 "a",
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 "+",
 "b",
 " ",
 "p",
 "+",
 "c",
 ", ",
 "p",
 ", ",
 "q",
 "] \[Rule] {-",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["b",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 "/(4 ",
 "a",
 ")+",
 "c",
 "+",
 "a",
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["q",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 ", ",
 "q",
 "\[Rule]",
 "b",
 "/(2 ",
 "a",
 ")+",
 "p",
 "}."
}], "Text",
 CellTags->"CompleteSquare"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CompleteSquare"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{
   RowBox[{"5", 
    RowBox[{"SP", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "p"}], "+", 
       RowBox[{"3", "r"}]}], ",", 
      RowBox[{"p", "+", "r"}]}], "]"}]}], "//", "FCI"}]}]], "Input",
 CellLabel->"In[230]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"5", " ", 
   RowBox[{"(", 
    FormBox[
     RowBox[{"p", "+", "r"}],
     TraditionalForm], ")", "\[CenterDot]", "(", 
    FormBox[
     RowBox[{
      RowBox[{"2", " ", "p"}], "+", 
      RowBox[{"3", " ", "r"}]}],
     TraditionalForm], ")"}]}], TraditionalForm]], "Output",
 CellLabel->"Out[230]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"CompleteSquare", "[", 
   RowBox[{"t1", ",", "p"}], "]"}]}]], "Input",
 CellTags->"CompleteSquare",
 CellLabel->"In[231]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"10", " ", 
    RowBox[{"(", 
     TagBox[
      FormBox[
       RowBox[{"p", "+", 
        FractionBox[
         RowBox[{"5", " ", "r"}], "4"]}],
       TraditionalForm],
      TraditionalForm,
      Editable->True], ")", ".", "(", 
     TagBox[
      FormBox[
       RowBox[{"p", "+", 
        FractionBox[
         RowBox[{"5", " ", "r"}], "4"]}],
       TraditionalForm],
      TraditionalForm,
      Editable->True], ")"}]}], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      FormBox["r",
       TraditionalForm], "2"]}], "8"]}], TraditionalForm]], "Output",
 CellTags->"CompleteSquare",
 CellLabel->"Out[231]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"t1", "-", "t2"}], "//", "ScalarProductExpand"}], "//", 
  "Expand"}]], "Input",
 CellTags->"CompleteSquare",
 CellLabel->"In[232]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"CompleteSquare",
 CellLabel->"Out[232]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompleteSquare", "[", 
  RowBox[{"t1", ",", "p", ",", "q"}], "]"}]], "Input",
 CellTags->"CompleteSquare",
 CellLabel->"In[233]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"10", " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], "2"]}], "-", 
     FractionBox[
      RowBox[{"5", " ", 
       SuperscriptBox[
        FormBox["r",
         TraditionalForm], "2"]}], "8"]}], ",", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{"p", "+", 
      FractionBox[
       RowBox[{"5", " ", "r"}], "4"]}]}]}], "}"}], TraditionalForm]], "Output",\

 CellTags->"CompleteSquare",
 CellLabel->"Out[233]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"t1", ",", "t2"}], "]"}]], "Input",
 CellTags->"CompleteSquare",
 CellLabel->"In[234]:="]
}, Open  ]],

Cell["ComplexConjugate", "ObjectName",
 CellTags->"ComplexConjugate"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ComplexConjugate"],

Cell["\<\
ComplexConjugate[expr] complex conjugates expr. It operates on fermion lines, \
i.e., products of Spinor[..] .DiracMatrix[..] . Spinor[..], and changes all \
occuring LorentzIndex[mu] into LorentzIndex[ComplexIndex[mu]]. For taking the \
spin sum (i.e. constructing the traces) use FermionSpinSum. WARNING: In expr \
should be NO explicit I's in denominators!\
\>", "Text",
 CellTags->"ComplexConjugate"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["ComplexIndex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ComplexIndex",
  ButtonNote->"ComplexIndex"],
 ", ",
 ButtonBox["FermionSpinSum",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FermionSpinSum",
  ButtonNote->"FermionSpinSum"],
 ", ",
 ButtonBox["LorentzIndex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LorentzIndex",
  ButtonNote->"LorentzIndex"],
 "."
}], "Text",
 CellTags->"ComplexConjugate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ComplexConjugate"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexConjugate", "[", 
  RowBox[{"MetricTensor", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[235]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["g", 
   RowBox[{"\[Mu]", "\[Nu]"}]], TraditionalForm]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[235]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", "%", "]"}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[236]:="],

Cell[BoxData[
 RowBox[{"Pair", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}]}], "]"}]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[236]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GA", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]", ",", "5"}], "]"}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[237]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "5"]}], TraditionalForm]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[237]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexConjugate", "[", "%", "]"}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[238]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "5"], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]]}]}], TraditionalForm]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[238]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SUNTrace", "[", 
  RowBox[{"SUNT", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[239]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"tr", "(", 
   FormBox[
    RowBox[{
     SubscriptBox["T", 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubscriptBox["T", 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubscriptBox["T", 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[239]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexConjugate", "[", "%", "]"}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[240]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"tr", "(", 
   FormBox[
    RowBox[{
     SubscriptBox["T", 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubscriptBox["T", 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubscriptBox["T", 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[240]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexConjugate", "[", 
  RowBox[{"SUNF", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[241]:="],

Cell[BoxData[
 FormBox[
  SubscriptBox["f", 
   RowBox[{
    FormBox[
     FormBox["a",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["b",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["c",
      TraditionalForm],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[241]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"FCE", "[", 
   RowBox[{"ComplexConjugate", "[", 
    RowBox[{"MetricTensor", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}], "]"}], "]"}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[242]:="],

Cell[BoxData[
 RowBox[{"MT", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[242]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SpinorUBar", "[", 
   RowBox[{"k1", ",", "m"}], "]"}], ".", 
  RowBox[{"GA", "[", "\[Lambda]", "]"}], ".", 
  RowBox[{"SpinorU", "[", 
   RowBox[{"p1", ",", "m"}], "]"}]}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[243]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FormBox[
     OverscriptBox["\<\"u\"\>", "_"],
     TraditionalForm], "(", "k1", ",", "m", ")"}], ".", 
   SuperscriptBox["\[Gamma]", "\[Lambda]"], ".", 
   RowBox[{"u", "(", "p1", ",", "m", ")"}]}], TraditionalForm]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[243]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexConjugate", "[", "%", "]"}]], "Input",
 CellTags->"ComplexConjugate",
 CellLabel->"In[244]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CurlyPhi]", "(", 
    FormBox["p1",
     TraditionalForm], ",", "m", ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Lambda]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"\[CurlyPhi]", "(", 
    FormBox["k1",
     TraditionalForm], ",", "m", ")"}]}], TraditionalForm]], "Output",
 CellTags->"ComplexConjugate",
 CellLabel->"Out[244]="]
}, Open  ]],

Cell["\<\
Notice that SpinorUBar and SpinorU are only input functions. Internally they \
are converted to Spinor objects.\
\>", "Text",
 CellTags->"ComplexConjugate"]
}, Open  ]],

Cell["Contract", "ObjectName",
 CellTags->"Contract"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Contract"],

Cell["\<\
Contract[expr] contracts pairs of Lorentz indices of metric tensors, \
four-vectors and (depending on the optionEpsContract) of Levi-Civita tensors \
in expr. For the contraction of Dirac matrices with each other use \
DiracSimplify. Contract[exp1, exp2] contracts (exp1*exp2), where exp1 and \
exp2 may be larger products of sums of metric tensors and 4-vectors. \
\>", "Text",
 CellTags->"Contract"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Contract", "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[245]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Collecting", "\[Rule]", "True"}], ",", 
    RowBox[{"Contract3", "\[Rule]", "True"}], ",", 
    RowBox[{"EpsContract", "\[Rule]", "True"}], ",", 
    RowBox[{"Expanding", "\[Rule]", "True"}], ",", 
    RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
    RowBox[{"FeynCalcInternal", "\[Rule]", "True"}], ",", 
    RowBox[{"MomentumCombine", "\[Rule]", "True"}], ",", 
    RowBox[{"Rename", "\[Rule]", "False"}], ",", 
    RowBox[{"Schouten", "\[Rule]", "0"}]}], "}"}], TraditionalForm]], "Output",\

 CellTags->"Contract",
 CellLabel->"Out[245]="]
}, Open  ]],

Cell["\<\
The option setting Contract3 can be set to True resulting in a faster \
algorithm to contract products of tensors.\
\>", "Text"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Pair",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Pair",
  ButtonNote->"Pair"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["MomentumCombine",
  BaseStyle->"AddOnsLink",
  ButtonData:>"MomentumCombine",
  ButtonNote->"MomentumCombine"],
 "."
}], "Text",
 CellTags->"Contract"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Contract"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MetricTensor", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", 
  RowBox[{"FourVector", "[", 
   RowBox[{"p", ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[246]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["g", 
    RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
   SuperscriptBox[
    FormBox["p",
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[246]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", "%", "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[247]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox["p",
    TraditionalForm], 
   FormBox[
    FormBox["\[Nu]",
     TraditionalForm],
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[247]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourVector", "[", 
   RowBox[{"p", ",", "\[Mu]"}], "]"}], 
  RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}]}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[248]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], " ", 
   SuperscriptBox[
    FormBox["p",
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[248]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", "%", "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[249]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["\<\"\[Gamma]\"\>",
    TraditionalForm], "\[CenterDot]", 
   FormBox["p",
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[249]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetricTensor", "[", 
  RowBox[{"\[Mu]", ",", "\[Mu]"}], "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[250]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["g", 
   RowBox[{"\[Mu]", "\[Mu]"}]], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[250]="]
}, Open  ]],

Cell["The default dimension for MetricTensor is 4.", "Text",
 CellTags->"Contract"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", "%", "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[251]:="],

Cell[BoxData[
 FormBox["4", TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[251]="]
}, Open  ]],

Cell["\<\
A short way to enter D-dimensional metric tensors is given by MTD. The \".\" \
as multiplication operator is not necessary but just convenient for \
typesetting.\
\>", "Text",
 CellTags->"Contract"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MTD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", ".", " ", 
  RowBox[{"MTD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[252]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["g", 
    RowBox[{"\[Mu]", "\[Nu]"}]], ".", 
   SuperscriptBox["g", 
    RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[252]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", "%", "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[253]:="],

Cell[BoxData[
 FormBox["D", TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[253]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MTD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], " ", ".", " ", 
  RowBox[{"MTD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[254]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["g", 
    RowBox[{"\[Mu]", "\[Nu]"}]], ".", 
   SuperscriptBox["g", 
    RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[254]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourVector", "[", 
   RowBox[{"p", ",", "\[Mu]"}], "]"}], " ", 
  RowBox[{"FourVector", "[", 
   RowBox[{"q", ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[255]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    FormBox["p",
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], " ", 
   SuperscriptBox[
    FormBox["q",
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[255]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", "%", " ", "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[256]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["p",
    TraditionalForm], "\[CenterDot]", 
   FormBox["q",
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[256]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourVector", "[", 
   RowBox[{
    RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}], " ", 
  RowBox[{"FourVector", "[", 
   RowBox[{
    RowBox[{"a", "-", "b"}], ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[257]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FormBox[
      RowBox[{"a", "-", "b"}],
      TraditionalForm], ")"}], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FormBox[
      RowBox[{"p", "-", "q"}],
      TraditionalForm], ")"}], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[257]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", "%", "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[258]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FormBox["a",
     TraditionalForm], "\[CenterDot]", 
    FormBox["p",
     TraditionalForm]}], "-", 
   RowBox[{
    FormBox["a",
     TraditionalForm], "\[CenterDot]", 
    FormBox["q",
     TraditionalForm]}], "-", 
   RowBox[{
    FormBox["b",
     TraditionalForm], "\[CenterDot]", 
    FormBox["p",
     TraditionalForm]}], "+", 
   RowBox[{
    FormBox["b",
     TraditionalForm], "\[CenterDot]", 
    FormBox["q",
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[258]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LeviCivita", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Sigma]"}], "]"}], 
  " ", 
  RowBox[{"FourVector", "[", 
   RowBox[{"p", ",", "\[Sigma]"}], "]"}]}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[259]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", 
    RowBox[{
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm]}]], " ", 
   SuperscriptBox[
    FormBox["p",
     TraditionalForm], 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[259]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", "%", "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[260]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox[
     FormBox["\[Alpha]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox["p",
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[260]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LeviCivita", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Beta]"}], "]"}], 
  " ", 
  RowBox[{"LeviCivita", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Sigma]"}], "]"}], 
  " "}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[261]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", 
    RowBox[{
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Beta]",
       TraditionalForm],
      TraditionalForm]}]], " ", 
   SuperscriptBox["\[Epsilon]", 
    RowBox[{
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[261]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", "%", "]"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[262]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "6"}], " ", 
   SuperscriptBox["g", 
    RowBox[{"\[Beta]", "\[Sigma]"}]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[262]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Eps", ",", 
    RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], ";", 
  RowBox[{
   RowBox[{"LCD", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Beta]"}], "]"}], 
   " ", 
   RowBox[{"LCD", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Alpha]", ",", "\[Sigma]"}], 
    "]"}]}]}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[263]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", 
    RowBox[{"\[Mu]", "\[Nu]", "\[Alpha]", "\[Beta]"}]], " ", 
   SuperscriptBox["\[Epsilon]", 
    RowBox[{"\[Mu]", "\[Nu]", "\[Alpha]", "\[Sigma]"}]]}], 
  TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[263]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Contract", "[", "%", "]"}], "//", "Factor2"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[264]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "D"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "-", "D"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"3", "-", "D"}], ")"}], " ", 
   SuperscriptBox["g", 
    RowBox[{"\[Beta]", "\[Sigma]"}]]}], TraditionalForm]], "Output",
 CellTags->"Contract",
 CellLabel->"Out[264]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Eps", ",", 
    RowBox[{"Dimension", "\[Rule]", "4"}]}], "]"}], ";"}]], "Input",
 CellTags->"Contract",
 CellLabel->"In[265]:="]
}, Open  ]],

Cell["Contract1", "ObjectName",
 CellTags->"Contract1"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Contract1"],

Cell["\<\
For covariant calculations it is not necessary to distinguish between co- and \
contravariant indices (except for the Levi-Civita tensor).
Therefore normally no distinction is made between upper and lower indices.
Howere, if needed, one can use Upper and Lower and then a distuction is made:
Contract1[exp] contracts Upper and Lower indices. Neither Upper and Upper nor \
Lower and Lower indices are contracted.\
\>", "Text",
 CellTags->"Contract1"],

Cell[TextData[{
 "See also:  ",
 ButtonBox["LorentzIndex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LorentzIndex",
  ButtonNote->"LorentzIndex"],
 ", ",
 ButtonBox["Lower",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Lower",
  ButtonNote->"Lower"],
 ", ",
 ButtonBox["Upper",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Upper",
  ButtonNote->"Upper"],
 "."
}], "Text",
 CellTags->"Contract1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Contract1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FV", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Lower", "[", "\[Mu]", "]"}]}], "]"}], 
    RowBox[{"FV", "[", 
     RowBox[{"q", ",", 
      RowBox[{"Upper", "[", "\[Mu]", "]"}]}], "]"}]}], "//", "FCI"}], "//", 
  "Contract1"}]], "Input",
 CellTags->"Contract1",
 CellLabel->"In[266]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["p",
    TraditionalForm], "\[CenterDot]", 
   FormBox["q",
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"Contract1",
 CellLabel->"Out[266]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FV", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Upper", "[", "\[Mu]", "]"}]}], "]"}], 
    RowBox[{"FV", "[", 
     RowBox[{"q", ",", 
      RowBox[{"Upper", "[", "\[Mu]", "]"}]}], "]"}]}], "//", "FCI"}], "//", 
  "Contract1"}]], "Input",
 CellTags->"Contract1",
 CellLabel->"In[267]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    FormBox["p",
     TraditionalForm], 
    FormBox[
     FormBox[
      RowBox[{"Upper", "(", "\[Mu]", ")"}],
      TraditionalForm],
     TraditionalForm]], " ", 
   SuperscriptBox[
    FormBox["q",
     TraditionalForm], 
    FormBox[
     FormBox[
      RowBox[{"Upper", "(", "\[Mu]", ")"}],
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Contract1",
 CellLabel->"Out[267]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{
     RowBox[{"Lower", "[", "\[Mu]", "]"}], ",", 
     RowBox[{"Upper", "[", "\[Mu]", "]"}]}], "]"}], "//", "FCI"}], "//", 
  "Contract1"}]], "Input",
 CellTags->"Contract1",
 CellLabel->"In[268]:="],

Cell[BoxData[
 FormBox["4", TraditionalForm]], "Output",
 CellTags->"Contract1",
 CellLabel->"Out[268]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MT", "[", 
    RowBox[{
     RowBox[{"Upper", "[", "\[Mu]", "]"}], ",", 
     RowBox[{"Upper", "[", "\[Mu]", "]"}]}], "]"}], "//", "FCI"}], "//", 
  "Contract1"}]], "Input",
 CellTags->"Contract1",
 CellLabel->"In[269]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["g", 
   RowBox[{
    FormBox[
     RowBox[{"Upper", "(", "\[Mu]", ")"}],
     TraditionalForm], 
    FormBox[
     RowBox[{"Upper", "(", "\[Mu]", ")"}],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"Contract1",
 CellLabel->"Out[269]="]
}, Open  ]]
}, Open  ]],

Cell["Convolute", "ObjectName",
 CellTags->"Convolute"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Convolute"],

Cell[TextData[{
 "Convolute[f, g, x] convolutes ",
 StyleBox["f",
  FontSlant->"Italic"],
 "(",
 StyleBox["x",
  FontSlant->"Italic"],
 ") and ",
 StyleBox["g",
  FontSlant->"Italic"],
 "(",
 StyleBox["x",
  FontSlant->"Italic"],
 "), i.e., ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     SubscriptBox[
      StyleBox[
       RowBox[{
        StyleBox["d",
         FontSlant->"Plain"], 
        StyleBox["x",
         FontSlant->"Italic"]}]], "1"], " ", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{
       SubscriptBox[
        StyleBox[
         RowBox[{
          StyleBox["d",
           FontSlant->"Plain"], "x"}]], "2"], " ", 
       RowBox[{"\[Delta]", "(", 
        RowBox[{"x", " ", "-", " ", 
         RowBox[{
          SubscriptBox["x", "1"], " ", 
          SubscriptBox["x", "2"]}]}], ")"}], " ", 
       RowBox[{"f", "(", 
        SubscriptBox["x", "1"], ")"}], " ", 
       RowBox[{
        RowBox[{"g", "(", 
         SubscriptBox["x", "2"], ")"}], " ", "."}]}]}]}]}], 
   TraditionalForm]]],
 " Convolute[f, g] is equivalent to Convolute[f, g, x]. Convolute[exp, {x1, \
x2}] assumes that exp is polynomial in x1 and x2. Convolute uses \
table-look-up and does not do any integral calculations, only linear \
algebra."
}], "Text",
 CellTags->"Convolute"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Convolute", "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[270]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Bracket", "\[Rule]", 
     RowBox[{"{", 
      TagBox["\[CurlyEpsilon]",
       TraditionalForm], "}"}]}], ",", 
    RowBox[{"FinalSubstitutions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"PlusDistribution", "\[Rule]", "Identity"}], "}"}]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[270]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["PlusDistribution",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PlusDistribution",
  ButtonNote->"PlusDistribution"],
 ", ",
 ButtonBox["ConvoluteTable",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ConvoluteTable",
  ButtonNote->"ConvoluteTable"],
 "."
}], "Text",
 CellTags->"Convolute"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Convolute"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[271]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[271]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"x", ",", "x"}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[272]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "x"}], " ", 
   RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[272]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", "x"}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[273]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"1", "-", "x"}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[273]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", 
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[274]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"log", "(", 
    RowBox[{"1", "-", "x"}], ")"}], "-", 
   RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[274]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", 
   RowBox[{"PlusDistribution", "[", 
    FractionBox["1", 
     RowBox[{"1", "-", "x"}]], "]"}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[275]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"log", "(", 
    RowBox[{"1", "-", "x"}], ")"}], "-", 
   RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[275]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", "x"}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[276]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}], " ", "x"}], "-", 
   RowBox[{
    RowBox[{"log", "(", "x", ")"}], " ", "x"}], "-", "x", "+", "1"}], 
  TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[276]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[277]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"\[Zeta]", "(", "2", ")"}]}], " ", 
    RowBox[{"\[Delta]", "(", 
     FormBox[
      RowBox[{"1", "-", "x"}],
      TraditionalForm], ")"}]}], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"log", "(", 
      RowBox[{"1", "-", "x"}], ")"}]}], 
    RowBox[{"1", "-", "x"}]], "-", 
   FractionBox[
    RowBox[{"log", "(", "x", ")"}], 
    RowBox[{"1", "-", "x"}]]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[277]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[278]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"log", "(", 
      RowBox[{"1", "-", "x"}], ")"}]}], " ", 
    RowBox[{"log", "(", "x", ")"}]}], "-", 
   RowBox[{
    SubscriptBox[
     InterpretationBox["Li",
      PolyLog,
      Editable->False,
      Selectable->False], "2"], "(", 
    RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[278]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", 
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[279]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "-", "1"}], TraditionalForm]], "Output",\

 CellTags->"Convolute",
 CellLabel->"Out[279]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[280]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["log", "2"], "(", 
    RowBox[{"1", "-", "x"}], ")"}], "-", 
   RowBox[{
    RowBox[{"log", "(", "x", ")"}], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "-", 
   RowBox[{"\[Zeta]", "(", "2", ")"}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[280]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", 
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[281]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{
     SuperscriptBox["log", "2"], "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"log", "(", "x", ")"}], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "+", "x", "-", 
   RowBox[{"x", " ", 
    RowBox[{"\[Zeta]", "(", "2", ")"}]}], "-", "1"}], 
  TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[281]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], 
    RowBox[{"1", "-", "x"}]], ",", "x"}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[282]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "x", " ", 
    RowBox[{
     SuperscriptBox["log", "2"], "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"log", "(", "x", ")"}], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"log", "(", "x", ")"}]}], "-", 
   RowBox[{"x", " ", 
    RowBox[{
     SubscriptBox[
      InterpretationBox["Li",
       PolyLog,
       Editable->False,
       Selectable->False], "2"], "(", 
     RowBox[{"1", "-", "x"}], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[282]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", 
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[283]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"log", "(", "x", ")"}]}], " ", "x"}], "+", "x", "-", "1"}], 
  TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[283]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[284]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"log", "(", "x", ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[284]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    RowBox[{"1", "-", "x"}]]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[285]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"log", "(", 
      RowBox[{"1", "-", "x"}], ")"}], " ", 
     RowBox[{"log", "(", "x", ")"}]}], 
    RowBox[{"1", "-", "x"}]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["log", "2"], "(", "x", ")"}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}]]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[285]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", 
   RowBox[{"Log", "[", "x", "]"}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[286]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{
    SuperscriptBox["log", "2"], "(", "x", ")"}]}], TraditionalForm]], "Output",\

 CellTags->"Convolute",
 CellLabel->"Out[286]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"x", ",", " ", 
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[287]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", "x", " ", 
   RowBox[{
    SuperscriptBox["log", "2"], "(", "x", ")"}]}], TraditionalForm]], "Output",\

 CellTags->"Convolute",
 CellLabel->"Out[287]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", 
   RowBox[{"Log", "[", "x", "]"}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[288]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{
     SuperscriptBox["log", "2"], "(", "x", ")"}]}], "+", 
   RowBox[{
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}], " ", 
    RowBox[{"log", "(", "x", ")"}]}], "+", 
   RowBox[{
    SubscriptBox[
     InterpretationBox["Li",
      PolyLog,
      Editable->False,
      Selectable->False], "2"], "(", 
    RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[288]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    RowBox[{"1", "-", "x"}]]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[289]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{
     SuperscriptBox["log", "2"], "(", "x", ")"}]}], "-", 
   RowBox[{
    SubscriptBox[
     InterpretationBox["Li",
      PolyLog,
      Editable->False,
      Selectable->False], "2"], "(", 
    RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[289]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", 
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[290]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", "x", " ", 
    RowBox[{
     SuperscriptBox["log", "2"], "(", "x", ")"}]}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"log", "(", "x", ")"}]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}], " ", 
    RowBox[{"log", "(", "x", ")"}]}], "+", "x", "+", 
   RowBox[{"x", " ", 
    RowBox[{
     SubscriptBox[
      InterpretationBox["Li",
       PolyLog,
       Editable->False,
       Selectable->False], "2"], "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "-", "1"}], TraditionalForm]], "Output",\

 CellTags->"Convolute",
 CellLabel->"Out[290]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    RowBox[{"1", "-", "x"}]], ",", "x"}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[291]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", "x", " ", 
    RowBox[{
     SuperscriptBox["log", "2"], "(", "x", ")"}]}], "+", 
   RowBox[{"log", "(", "x", ")"}], "-", "x", "-", 
   RowBox[{"x", " ", 
    RowBox[{
     SubscriptBox[
      InterpretationBox["Li",
       PolyLog,
       Editable->False,
       Selectable->False], "2"], "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "+", "1"}], TraditionalForm]], "Output",\

 CellTags->"Convolute",
 CellLabel->"Out[291]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{"1", ",", 
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[292]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"log", "(", "x", ")"}]}], " ", "x"}], "+", "x", "-", "1"}], 
  TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[292]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[293]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"log", "(", "x", ")"}], "+", "1"}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[293]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], 
    RowBox[{"1", "-", "x"}]]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[294]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{
      SuperscriptBox["log", "2"], "(", 
      RowBox[{"1", "-", "x"}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"log", "(", "x", ")"}], " ", 
     RowBox[{"log", "(", 
      RowBox[{"1", "-", "x"}], ")"}]}], 
    RowBox[{"1", "-", "x"}]], "-", 
   FractionBox[
    RowBox[{"\[Zeta]", "(", "2", ")"}], 
    RowBox[{"1", "-", "x"}]], "+", 
   RowBox[{
    RowBox[{"\[Delta]", "(", 
     FormBox[
      RowBox[{"1", "-", "x"}],
      TraditionalForm], ")"}], " ", 
    TagBox[
     RowBox[{"\[Zeta]", "(", 
      TagBox["3",
       Zeta,
       Editable->True,
       Selectable->True], ")"}],
     InterpretTemplate[
      Function[BoxForm`e$, 
       Zeta[BoxForm`e$]]],
     Editable->False,
     Selectable->False]}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[294]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], 
    RowBox[{"1", "-", "x"}]], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[295]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{
     SuperscriptBox["log", "3"], "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"log", "(", "x", ")"}], " ", 
    RowBox[{
     SuperscriptBox["log", "2"], "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["log", "2"], "(", "x", ")"}], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"\[Zeta]", "(", "2", ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"log", "(", 
       RowBox[{"1", "-", "x"}], ")"}], "+", 
      RowBox[{"log", "(", "x", ")"}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"log", "(", "x", ")"}], "-", 
      RowBox[{"log", "(", 
       RowBox[{"1", "-", "x"}], ")"}]}], ")"}], " ", 
    RowBox[{
     SubscriptBox[
      InterpretationBox["Li",
       PolyLog,
       Editable->False,
       Selectable->False], "2"], "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "+", 
   RowBox[{
    SubscriptBox[
     InterpretationBox["Li",
      PolyLog,
      Editable->False,
      Selectable->False], "3"], "(", 
    RowBox[{"1", "-", "x"}], ")"}], "+", 
   RowBox[{"2", " ", 
    RowBox[{
     SubscriptBox[
      InterpretationBox["Li",
       PolyLog,
       Editable->False,
       Selectable->False], "3"], "(", "x", ")"}]}], "-", 
   TagBox[
    RowBox[{"\[Zeta]", "(", 
     TagBox["3",
      Zeta,
      Editable->True,
      Selectable->True], ")"}],
    InterpretTemplate[
     Function[BoxForm`e$, 
      Zeta[BoxForm`e$]]],
    Editable->False,
    Selectable->False]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[295]="]
}, Open  ]]
}, Open  ]],

Cell["ConvoluteTable ", "ObjectName",
 CellTags->"ConvoluteTable"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ConvoluteTable"],

Cell["\<\
ConvoluteTable[f, g, x] yields the convolution of f and g. ConvoluteTable is \
called by Convolute.\
\>", "Text",
 CellTags->"ConvoluteTable"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Convolute", "]"}]], "Input",
 CellTags->"ConvoluteTable",
 CellLabel->"In[296]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Bracket", "\[Rule]", 
     RowBox[{"{", 
      TagBox["\[CurlyEpsilon]",
       TraditionalForm], "}"}]}], ",", 
    RowBox[{"FinalSubstitutions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"PlusDistribution", "\[Rule]", "Identity"}], "}"}]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"ConvoluteTable",
 CellLabel->"Out[296]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["PlusDistribution",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PlusDistribution",
  ButtonNote->"PlusDistribution"],
 ", ",
 ButtonBox["Convolute",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Convolute",
  ButtonNote->"Convolute"],
 "."
}], "Text",
 CellTags->"ConvoluteTable"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ConvoluteTable"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvoluteTable", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Input",
 CellTags->"ConvoluteTable",
 CellLabel->"In[297]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output",
 CellTags->"ConvoluteTable",
 CellLabel->"Out[297]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvoluteTable", "[", 
  RowBox[{"x", ",", "x"}], "]"}]], "Input",
 CellTags->"ConvoluteTable",
 CellLabel->"In[298]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "x"}], " ", 
   RowBox[{"log", "(", "x", ")"}]}], TraditionalForm]], "Output",
 CellTags->"ConvoluteTable",
 CellLabel->"Out[298]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvoluteTable", "[", 
  RowBox[{"1", ",", "x"}], "]"}]], "Input",
 CellTags->"ConvoluteTable",
 CellLabel->"In[299]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"1", "-", "x"}], TraditionalForm]], "Output",
 CellTags->"ConvoluteTable",
 CellLabel->"Out[299]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConvoluteTable", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}], 
    RowBox[{"1", "-", "x"}]], ",", "1"}], "]"}]], "Input",
 CellTags->"Convolute",
 CellLabel->"In[300]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{
     SuperscriptBox["log", "2"], "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"log", "(", "x", ")"}], " ", 
    RowBox[{"log", "(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "-", 
   RowBox[{
    SubscriptBox[
     InterpretationBox["Li",
      PolyLog,
      Editable->False,
      Selectable->False], "2"], "(", 
    RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Convolute",
 CellLabel->"Out[300]="]
}, Open  ]]
}, Open  ]],

Cell["CovariantFieldDerivative", "ObjectName",
 CellTags->"CovariantFieldDerivative"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CovariantFieldDerivative"],

Cell["\<\
CovariantFieldDerivative[f[x],x,{li1,li2,...},opts] is a covariant derivative \
of f[x] with respect to space-time variables x and with Lorentz indices li1, \
li2,... CovariantFieldDerivative has only typesetting definitions by default. \
The user is must supply his/her own definition of the actual function.\
\>", "Text",
 CellTags->"CovariantFieldDerivative"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["CovariantD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CovariantD",
  ButtonNote->"CovariantD"],
 ", ",
 ButtonBox["ExpandPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ExpandPartialD",
  ButtonNote->"ExpandPartialD"],
 ", ",
 ButtonBox["FieldDerivative",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FieldDerivative",
  ButtonNote->"FieldDerivative"],
 "."
}], "Text",
 CellTags->"CovariantFieldDerivative"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CovariantFieldDerivative"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantFieldDerivative", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"QuantumField", "[", 
     RowBox[{"A", ",", 
      RowBox[{"{", "\[Mu]", "}"}]}], "]"}], "[", "x", "]"}], ",", "x", ",", 
   RowBox[{"{", "\[Mu]", "}"}]}], "]"}]], "Input",
 CellTags->"CovariantFieldDerivative",
 CellLabel->"In[301]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    TagBox[
     StyleBox["\<\"\[ScriptCapitalD]\"\>",
      FontSlant->"Italic"],
     StyleForm[#, FontSlant -> "Italic"]& ], 
    TagBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm,
     Editable->True]], "(", 
   TagBox[
    FormBox[
     RowBox[{
      SubscriptBox["A", "\[Mu]"], "(", "x", ")"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ")"}], TraditionalForm]], "Output",
 CellTags->"CovariantFieldDerivative",
 CellLabel->"Out[301]="]
}, Open  ]]
}, Open  ]],

Cell["CounterT", "ObjectName",
 CellTags->"CounterT"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CounterT"],

Cell["\<\
CounterT is a factor used by GluonPropagator and QuarkPropagator when \
CounterTerms is set to All.\
\>", "Text",
 CellTags->"CounterT"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["CounterTerm",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CounterTerm",
  ButtonNote->"CounterTerm"],
 ", ",
 ButtonBox["GluonPropagator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GluonPropagator",
  ButtonNote->"GluonPropagator"],
 ", ",
 ButtonBox["QuarkPropagator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"QuarkPropagator",
  ButtonNote->"QuarkPropagator"],
 "."
}], "Text",
 CellTags->"CounterT"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CounterT"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GluonPropagator", "[", 
  RowBox[{"p", ",", "\[Mu]", ",", "a", ",", "\[Nu]", ",", "b", ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}], ",", 
   RowBox[{"CounterTerm", "\[Rule]", " ", "All"}]}], "]"}]], "Input",
 CellTags->"CounterT",
 CellLabel->"In[302]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"CounterT", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["C", "A"], " ", 
        SubscriptBox["S", "n"], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"10", " ", 
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], 
             FormBox[
              FormBox["\[Mu]",
               TraditionalForm],
              TraditionalForm]], " ", 
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], 
             FormBox[
              FormBox["\[Nu]",
               TraditionalForm],
              TraditionalForm]]}], "3"], "-", 
          RowBox[{
           FractionBox["10", "3"], " ", 
           SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
           SuperscriptBox[
            FormBox["p",
             TraditionalForm], "2"]}]}], ")"}], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], 
       TagBox["\[CurlyEpsilon]",
        TraditionalForm]], "+", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["S", "n"], " ", 
        SubscriptBox["T", "f"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox["4", "3"], " ", 
           SuperscriptBox["g", 
            RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
           SuperscriptBox[
            FormBox["p",
             TraditionalForm], "2"]}], "-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], 
             FormBox[
              FormBox["\[Mu]",
               TraditionalForm],
              TraditionalForm]], " ", 
            SuperscriptBox[
             FormBox["p",
              TraditionalForm], 
             FormBox[
              FormBox["\[Nu]",
               TraditionalForm],
              TraditionalForm]]}], "3"]}], ")"}], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm]}]], " ", 
        SubsuperscriptBox["g", "s", "2"]}], 
       TagBox["\[CurlyEpsilon]",
        TraditionalForm]]}], ")"}]}], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["g", 
      RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["b",
         TraditionalForm],
        TraditionalForm]}]]}], 
    SuperscriptBox["p", "2"]]}], TraditionalForm]], "Output",
 CellTags->"CounterT",
 CellLabel->"Out[302]="]
}, Open  ]]
}, Open  ]],

Cell["CounterTerm", "ObjectName",
 CellTags->"CounterTerm"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CounterTerm"],

Cell["\<\
CounterTerm[name] is a database of counter terms. CounterTerm is also an \
option for the Feynman rule functions QuarkGluonVertex, GluonPropagator, \
QuarkPropagator.\
\>", "Text",
 CellTags->"CounterTerm"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["CounterT",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CounterT",
  ButtonNote->"CounterT"],
 ", ",
 ButtonBox["QuarkGluonVertex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"QuarkGluonVertex",
  ButtonNote->"QuarkGluonVertex"],
 ", ",
 ButtonBox["GluonPropagator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GluonPropagator",
  ButtonNote->"GluonPropagator"],
 ", ",
 ButtonBox["QuarkPropagator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"QuarkPropagator",
  ButtonNote->"QuarkPropagator"],
 "."
}], "Text",
 CellTags->"CounterTerm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CounterTerm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CounterTerm", "[", "Zm", "]"}]], "Input",
 CellTags->"CounterTerm",
 CellLabel->"In[303]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     SubscriptBox["C", "F"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"11", " ", 
             SubscriptBox["C", "A"]}], "2"], "+", 
           FractionBox[
            RowBox[{"9", " ", 
             SubscriptBox["C", "F"]}], "2"], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["N", "f"], " ", 
            SubscriptBox["T", "f"]}]}], ")"}]}], 
        SuperscriptBox[
         TagBox["\[CurlyEpsilon]",
          TraditionalForm], "2"]], "+", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"97", " ", 
             SubscriptBox["C", "A"]}], "12"], "+", 
           FractionBox[
            RowBox[{"3", " ", 
             SubscriptBox["C", "F"]}], "4"], "-", 
           FractionBox[
            RowBox[{"5", " ", 
             SubscriptBox["N", "f"], " ", 
             SubscriptBox["T", "f"]}], "3"]}], ")"}]}], 
        TagBox["\[CurlyEpsilon]",
         TraditionalForm]]}], ")"}], " ", 
     SubsuperscriptBox["g", "s", "4"]}], 
    RowBox[{"256", " ", 
     SuperscriptBox["\[Pi]", "4"]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SubscriptBox["C", "F"], " ", 
     SubsuperscriptBox["g", "s", "2"]}], 
    RowBox[{"8", " ", 
     TagBox["\[CurlyEpsilon]",
      TraditionalForm], " ", 
     SuperscriptBox["\[Pi]", "2"]}]], "+", "1"}], TraditionalForm]], "Output",\

 CellTags->"CounterTerm",
 CellLabel->"Out[303]="]
}, Open  ]]
}, Open  ]],

Cell["CouplingConstant", "ObjectName",
 CellTags->"CouplingConstant"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CouplingConstant"],

Cell["\<\
In general, CouplingConstant is an option for several Feynman rule functions \
and for CovariantD and FieldStrength.
In the convention of the subpackage PHI, CouplingConstant is also the head of \
coupling constants.  CouplingConstant takes three extra optional arguments, \
with head RenormalizationState, RenormalizationScheme and ExpansionState \
respectively.  E.g. CouplingConstant[QED[1]] is the unit charge, \
CouplingConstant[ChPT2[4],1] is the first of the coupling constants of the \
lagrangian ChPT2[4].  CouplingConstant[a_,b_,c___][i_] := \
CouplingConstant[a,b,RenormalizationState[i],c].\
\>", "Text",
 CellTags->"CouplingConstant"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["CovariantD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CovariantD",
  ButtonNote->"CovariantD"],
 ", ",
 ButtonBox["FieldStrength",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FieldStrength",
  ButtonNote->"FieldStrength"],
 "."
}], "Text",
 CellTags->"CouplingConstant"]
}, Open  ]],

Cell["CovariantD", "ObjectName",
 CellTags->"CovariantD"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CovariantD"],

Cell["\<\
CovariantD[mu] is a generic covariant derivative with Lorentz index mu. With \
the option-setting Explicit \[Rule] True, an explicit expression for a \
fermionic field is returned, depending on the setting on the other options.
CovariantD[x, mu] is a generic covariant derivative with respect to x^mu.
CovariantD[mu, a, b] is a covariant derivative for a bosonic field; acting on \
QuantumField[f,{},{a,b}], where f is some field name and a and b are two \
SU(N) indices. Again, with the option-setting Explicit \[Rule] True, an \
explicit expression is returned, depending on the setting on the other \
options.
CovariantD[OPEDelta, a, b] is a short form for  \
CovariantD[mu,a,b]*FourVector[OPEDelta, mu]. CovariantD[{OPEDelta, a, b}, \
{n}] yields the product of n operators, where n is an integer.  \
CovariantD[OPEDelta, a, b, {m, n}]  gives the expanded form of \
CovariantD[OPEDelta, a, b]^m up to order g^n for the gluon, where n is an \
integer and g the coupling constant  indicated by the setting of the option \
CouplingConstant. CovariantD[OPEDelta, {m, n}] gives the expanded form of  \
CovariantD[OPEDelta]^m up to order g^n of the fermionic field.\
\>", "Text",
 CellTags->"CovariantD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "CovariantD", "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[304]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CouplingConstant", "\[Rule]", 
     SubscriptBox["g", "s"]}], ",", 
    RowBox[{"DummyIndex", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"Explicit", "\[Rule]", "False"}], ",", 
    RowBox[{"PartialD", "\[Rule]", "RightPartialD"}], ",", 
    RowBox[{"QuantumField", "\[Rule]", "A"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[304]="]
}, Open  ]],

Cell["\<\
 Possible settings of PartialD are: LeftPartialD, LeftRigthPartialD, \
RightPartialD. The default setting of QuantumField is GaugeField.\
\>", "Text",
 CellTags->"CovariantD"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["LeftPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LeftPartialD",
  ButtonNote->"LeftPartialD"],
 ", ",
 ButtonBox["LeftRightPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LeftRightPartialD",
  ButtonNote->"LeftRightPartialD"],
 ", ",
 ButtonBox["RightPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"RightPartialD",
  ButtonNote->"RightPartialD"],
 "."
}], "Text",
 CellTags->"CovariantD"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CovariantD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", "\[Mu]", "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[305]:="],

Cell[BoxData[
 FormBox[
  SubscriptBox["D", "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[305]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"\[Mu]", ",", "a", ",", "b"}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[306]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["D", "\[Mu]", 
   RowBox[{"a", "b"}]], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[306]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"\[Mu]", ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[307]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    OverscriptBox["\[PartialD]", "\[RightArrow]"], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["g", "s"], " ", 
    RowBox[{
     SubscriptBox["T", 
      FormBox[
       FormBox[
        InterpretationBox[
         SubscriptBox["c", "1"],
         Subscripted[
          $CellContext`c[1]],
         Editable->False],
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox[
        InterpretationBox[
         SubscriptBox["c", "1"],
         Subscripted[
          $CellContext`c[1]],
         Editable->False],
        TraditionalForm],
       TraditionalForm]]}]}]}], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[307]="]
}, Open  ]],

Cell["\<\
The first argument of CovariantD is intepreted as type LorentzIndex, except \
for OPEDelta, which is type Momentum.\
\>", "Text",
 CellTags->"CovariantD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", "OPEDelta", "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[308]:="],

Cell[BoxData[
 FormBox[
  SubscriptBox["D", 
   FormBox["\[CapitalDelta]",
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[308]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"OPEDelta", ",", "a", ",", "b"}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[309]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["D", 
   FormBox["\[CapitalDelta]",
    TraditionalForm], 
   RowBox[{"a", "b"}]], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[309]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[310]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox["\[CapitalDelta]",
      TraditionalForm]], " ", 
    SubscriptBox["\[Delta]", 
     RowBox[{"a", "b"}]]}], "-", 
   RowBox[{
    SubscriptBox["g", "s"], " ", 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox["\[CapitalDelta]",
      TraditionalForm], 
     FormBox[
      FormBox[
       InterpretationBox[
        SubscriptBox["c", "2"],
        Subscripted[
         $CellContext`c[2]],
        Editable->False],
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{"a", "b", 
      FormBox[
       InterpretationBox[
        SubscriptBox["c", "2"],
        Subscripted[
         $CellContext`c[2]],
        Editable->False],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[310]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"OPEDelta", ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[311]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    OverscriptBox["\[PartialD]", "\[RightArrow]"], 
    FormBox["\[CapitalDelta]",
     TraditionalForm]], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["g", "s"], " ", 
    RowBox[{
     SubscriptBox["T", 
      FormBox[
       FormBox[
        InterpretationBox[
         SubscriptBox["c", "3"],
         Subscripted[
          $CellContext`c[3]],
         Editable->False],
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox["\[CapitalDelta]",
       TraditionalForm], 
      FormBox[
       FormBox[
        InterpretationBox[
         SubscriptBox["c", "3"],
         Subscripted[
          $CellContext`c[3]],
         Editable->False],
        TraditionalForm],
       TraditionalForm]]}]}]}], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[311]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[312]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[PartialD]", "\[RightArrow]"], 
       FormBox["\[CapitalDelta]",
        TraditionalForm]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{"a", "c14"}]]}], "-", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubsuperscriptBox[
       FormBox["A",
        TraditionalForm], 
       FormBox["\[CapitalDelta]",
        TraditionalForm], 
       FormBox[
        FormBox["e1",
         TraditionalForm],
        TraditionalForm]], " ", 
      SubscriptBox["f", 
       RowBox[{"a", "c14", "e1"}]]}]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[PartialD]", "\[RightArrow]"], 
       FormBox["\[CapitalDelta]",
        TraditionalForm]], " ", 
      SubscriptBox["\[Delta]", 
       RowBox[{"b", "c14"}]]}], "-", 
     RowBox[{
      SubscriptBox["g", "s"], " ", 
      SubsuperscriptBox[
       FormBox["A",
        TraditionalForm], 
       FormBox["\[CapitalDelta]",
        TraditionalForm], 
       FormBox[
        FormBox["e2",
         TraditionalForm],
        TraditionalForm]], " ", 
      SubscriptBox["f", 
       RowBox[{"c14", "b", "e2"}]]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[312]="]
}, Open  ]],

Cell[TextData[{
 "This gives",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"m", " ", "times", " ", 
      SubscriptBox[
       OverscriptBox["\[PartialD]", "\[RightArrow]"], "\[CapitalDelta]"]}], 
     ",", " "}]}], TraditionalForm]]],
 "the partial derivative ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["\[PartialD]", "\[RightArrow]"], 
    RowBox[{"\[Mu]", " "}]], TraditionalForm]]],
 "contracted with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[CapitalDelta]", "\[Mu]"], "."}], TraditionalForm]]]
}], "Text",
 CellTags->"CovariantD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
   RowBox[{"{", 
    RowBox[{"OPEm", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[313]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[RightArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], ")"}], "m"], " ", 
   SubscriptBox["\[Delta]", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[313]="]
}, Open  ]],

Cell[TextData[{
 "The expansion up to first order in the coupling constant ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "s"], " ", 
    RowBox[{
     RowBox[{"(", "thesumistheFeynCalcOPESum", ")"}], "."}]}], 
   TraditionalForm]]]
}], "Text",
 CellTags->"CovariantD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
   RowBox[{"{", 
    RowBox[{"OPEm", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[314]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SubscriptBox[
       OverscriptBox["\[PartialD]", "\[RightArrow]"], 
       FormBox["\[CapitalDelta]",
        TraditionalForm]], ")"}], "m"], " ", 
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubscriptBox["g", "s"], " ", 
    FormBox[
     TagBox[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], 
        RowBox[{"m", "-", "1"}]], 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox["\[CapitalDelta]",
             TraditionalForm]], ")"}], "i"], ".", 
         SubsuperscriptBox[
          FormBox["A",
           TraditionalForm], 
          FormBox["\[CapitalDelta]",
           TraditionalForm], 
          FormBox[
           FormBox[
            InterpretationBox[
             SubscriptBox["c", "1"],
             Subscripted[
              $CellContext`c[1]],
             Editable->False],
            TraditionalForm],
           TraditionalForm]], ".", 
         SuperscriptBox[
          RowBox[{"(", 
           SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox["\[CapitalDelta]",
             TraditionalForm]], ")"}], 
          RowBox[{
           RowBox[{"-", "i"}], "+", "m", "-", "1"}]]}], " ", 
        SubscriptBox["f", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            InterpretationBox[
             SubscriptBox["c", "1"],
             Subscripted[
              $CellContext`c[1]],
             Editable->False],
            TraditionalForm],
           TraditionalForm]}]]}]}],
      HoldForm],
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[314]="]
}, Open  ]],

Cell[TextData[{
 "The expansion up to second order in the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["g", "s"], "."}], TraditionalForm]]]
}], "Text",
 CellTags->"CovariantD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"OPEDelta", ",", "a", ",", "b", ",", 
   RowBox[{"{", 
    RowBox[{"OPEm", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[315]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SubscriptBox[
       OverscriptBox["\[PartialD]", "\[RightArrow]"], 
       FormBox["\[CapitalDelta]",
        TraditionalForm]], ")"}], "m"]}], "-", 
   RowBox[{
    SubsuperscriptBox["g", "s", "2"], " ", 
    FormBox[
     TagBox[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"j", "=", "0"}], 
        RowBox[{"m", "-", "2"}]], 
       FormBox[
        TagBox[
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"i", "=", "0"}], "j"], 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              SubscriptBox[
               OverscriptBox["\[PartialD]", "\[RightArrow]"], 
               FormBox["\[CapitalDelta]",
                TraditionalForm]], ")"}], "i"], ".", 
            SubsuperscriptBox[
             FormBox["A",
              TraditionalForm], 
             FormBox["\[CapitalDelta]",
              TraditionalForm], 
             FormBox[
              FormBox[
               InterpretationBox[
                SubscriptBox["c", "1"],
                Subscripted[
                 $CellContext`c[1]],
                Editable->False],
               TraditionalForm],
              TraditionalForm]], ".", 
            SuperscriptBox[
             RowBox[{"(", 
              SubscriptBox[
               OverscriptBox["\[PartialD]", "\[RightArrow]"], 
               FormBox["\[CapitalDelta]",
                TraditionalForm]], ")"}], 
             RowBox[{"j", "-", "i"}]], ".", 
            SubsuperscriptBox[
             FormBox["A",
              TraditionalForm], 
             FormBox["\[CapitalDelta]",
              TraditionalForm], 
             FormBox[
              FormBox[
               InterpretationBox[
                SubscriptBox["c", "2"],
                Subscripted[
                 $CellContext`c[2]],
                Editable->False],
               TraditionalForm],
              TraditionalForm]], ".", 
            SuperscriptBox[
             RowBox[{"(", 
              SubscriptBox[
               OverscriptBox["\[PartialD]", "\[RightArrow]"], 
               FormBox["\[CapitalDelta]",
                TraditionalForm]], ")"}], 
             RowBox[{
              RowBox[{"-", "j"}], "+", "m", "-", "2"}]]}], " ", 
           SubscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["a",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               InterpretationBox[
                SubscriptBox["c", "1"],
                Subscripted[
                 $CellContext`c[1]],
                Editable->False],
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               InterpretationBox[
                SubscriptBox["e", "1"],
                Subscripted[
                 $CellContext`e[1]],
                Editable->False],
               TraditionalForm],
              TraditionalForm]}]], " ", 
           SubscriptBox["f", 
            RowBox[{
             FormBox[
              FormBox["b",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               InterpretationBox[
                SubscriptBox["c", "2"],
                Subscripted[
                 $CellContext`c[2]],
                Editable->False],
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox[
               InterpretationBox[
                SubscriptBox["e", "1"],
                Subscripted[
                 $CellContext`e[1]],
                Editable->False],
               TraditionalForm],
              TraditionalForm]}]]}]}],
         HoldForm],
        TraditionalForm]}],
      HoldForm],
     TraditionalForm]}], "-", 
   RowBox[{
    SubscriptBox["g", "s"], " ", 
    FormBox[
     TagBox[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], 
        RowBox[{"m", "-", "1"}]], 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox["\[CapitalDelta]",
             TraditionalForm]], ")"}], "i"], ".", 
         SubsuperscriptBox[
          FormBox["A",
           TraditionalForm], 
          FormBox["\[CapitalDelta]",
           TraditionalForm], 
          FormBox[
           FormBox[
            InterpretationBox[
             SubscriptBox["c", "1"],
             Subscripted[
              $CellContext`c[1]],
             Editable->False],
            TraditionalForm],
           TraditionalForm]], ".", 
         SuperscriptBox[
          RowBox[{"(", 
           SubscriptBox[
            OverscriptBox["\[PartialD]", "\[RightArrow]"], 
            FormBox["\[CapitalDelta]",
             TraditionalForm]], ")"}], 
          RowBox[{
           RowBox[{"-", "i"}], "+", "m", "-", "1"}]]}], " ", 
        SubscriptBox["f", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox[
            InterpretationBox[
             SubscriptBox["c", "1"],
             Subscripted[
              $CellContext`c[1]],
             Editable->False],
            TraditionalForm],
           TraditionalForm]}]]}]}],
      HoldForm],
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[315]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"CovariantD", "[", 
   RowBox[{"OPEDelta", ",", "a", ",", "b"}], "]"}], "OPEm"]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[316]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   RowBox[{"(", 
    SubsuperscriptBox["D", 
     FormBox["\[CapitalDelta]",
      TraditionalForm], 
     RowBox[{"a", "b"}]], ")"}], "m"], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[316]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CovariantD", "[", 
  RowBox[{"OPEDelta", ",", 
   RowBox[{"{", 
    RowBox[{"OPEm", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[317]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[RightArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], ")"}], "m"], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SubscriptBox["g", "s"], " ", 
    FormBox[
     TagBox[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "0"}], 
        RowBox[{"m", "-", "1"}]], 
       RowBox[{
        SubscriptBox["T", 
         FormBox[
          FormBox[
           InterpretationBox[
            SubscriptBox["c", "1"],
            Subscripted[
             $CellContext`c[1]],
            Editable->False],
           TraditionalForm],
          TraditionalForm]], ".", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox[
           OverscriptBox["\[PartialD]", "\[RightArrow]"], 
           FormBox["\[CapitalDelta]",
            TraditionalForm]], ")"}], "i"], ".", 
        SubsuperscriptBox[
         FormBox["A",
          TraditionalForm], 
         FormBox["\[CapitalDelta]",
          TraditionalForm], 
         FormBox[
          FormBox[
           InterpretationBox[
            SubscriptBox["c", "1"],
            Subscripted[
             $CellContext`c[1]],
            Editable->False],
           TraditionalForm],
          TraditionalForm]], ".", 
        SuperscriptBox[
         RowBox[{"(", 
          SubscriptBox[
           OverscriptBox["\[PartialD]", "\[RightArrow]"], 
           FormBox["\[CapitalDelta]",
            TraditionalForm]], ")"}], 
         RowBox[{
          RowBox[{"-", "i"}], "+", "m", "-", "1"}]]}]}],
      HoldForm],
     TraditionalForm]}], "-", 
   RowBox[{
    SubsuperscriptBox["g", "s", "2"], " ", 
    FormBox[
     TagBox[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"j", "=", "0"}], 
        RowBox[{"m", "-", "2"}]], 
       FormBox[
        TagBox[
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"i", "=", "0"}], "j"], 
          RowBox[{
           SubscriptBox["T", 
            FormBox[
             FormBox[
              InterpretationBox[
               SubscriptBox["c", "1"],
               Subscripted[
                $CellContext`c[1]],
               Editable->False],
              TraditionalForm],
             TraditionalForm]], ".", 
           SubscriptBox["T", 
            FormBox[
             FormBox[
              InterpretationBox[
               SubscriptBox["c", "2"],
               Subscripted[
                $CellContext`c[2]],
               Editable->False],
              TraditionalForm],
             TraditionalForm]], ".", 
           SuperscriptBox[
            RowBox[{"(", 
             SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox["\[CapitalDelta]",
               TraditionalForm]], ")"}], "i"], ".", 
           SubsuperscriptBox[
            FormBox["A",
             TraditionalForm], 
            FormBox["\[CapitalDelta]",
             TraditionalForm], 
            FormBox[
             FormBox[
              InterpretationBox[
               SubscriptBox["c", "1"],
               Subscripted[
                $CellContext`c[1]],
               Editable->False],
              TraditionalForm],
             TraditionalForm]], ".", 
           SuperscriptBox[
            RowBox[{"(", 
             SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox["\[CapitalDelta]",
               TraditionalForm]], ")"}], 
            RowBox[{"j", "-", "i"}]], ".", 
           SubsuperscriptBox[
            FormBox["A",
             TraditionalForm], 
            FormBox["\[CapitalDelta]",
             TraditionalForm], 
            FormBox[
             FormBox[
              InterpretationBox[
               SubscriptBox["c", "2"],
               Subscripted[
                $CellContext`c[2]],
               Editable->False],
              TraditionalForm],
             TraditionalForm]], ".", 
           SuperscriptBox[
            RowBox[{"(", 
             SubscriptBox[
              OverscriptBox["\[PartialD]", "\[RightArrow]"], 
              FormBox["\[CapitalDelta]",
               TraditionalForm]], ")"}], 
            RowBox[{
             RowBox[{"-", "j"}], "+", "m", "-", "2"}]]}]}],
         HoldForm],
        TraditionalForm]}],
      HoldForm],
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[317]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CovariantD", "[", 
   RowBox[{"OPEDelta", ",", 
    RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[318]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", "Gstrong", " ", 
   RowBox[{
    RowBox[{"SUNT", "[", 
     RowBox[{"SUNIndex", "[", 
      InterpretationBox[
       SubscriptBox["c", "4"],
       Subscripted[
        $CellContext`c[4]],
       Editable->False], "]"}], "]"}], ".", 
    RowBox[{"QuantumField", "[", 
     RowBox[{"GaugeField", ",", 
      RowBox[{"Momentum", "[", "OPEDelta", "]"}], ",", 
      RowBox[{"SUNIndex", "[", 
       InterpretationBox[
        SubscriptBox["c", "4"],
        Subscripted[
         $CellContext`c[4]],
        Editable->False], "]"}]}], "]"}]}]}], "+", 
  RowBox[{"RightPartialD", "[", 
   RowBox[{"Momentum", "[", "OPEDelta", "]"}], "]"}]}]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[318]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CovariantD", "[", 
   RowBox[{"\[Mu]", ",", "a", ",", "b", ",", 
    RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"CovariantD",
 CellLabel->"In[319]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RightPartialD", "[", 
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], " ", 
   RowBox[{"SUNDelta", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], "-", 
  RowBox[{"Gstrong", " ", 
   RowBox[{"QuantumField", "[", 
    RowBox[{"GaugeField", ",", 
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
     RowBox[{"SUNIndex", "[", 
      InterpretationBox[
       SubscriptBox["c", "5"],
       Subscripted[
        $CellContext`c[5]],
       Editable->False], "]"}]}], "]"}], " ", 
   RowBox[{"SUNF", "[", 
    RowBox[{"a", ",", "b", ",", 
     InterpretationBox[
      SubscriptBox["c", "5"],
      Subscripted[
       $CellContext`c[5]],
      Editable->False]}], "]"}]}]}]], "Output",
 CellTags->"CovariantD",
 CellLabel->"Out[319]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["CrossProduct", "ObjectName",
 CellTags->"CrossProduct"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"CrossProduct"],

Cell["\<\
CrossProduct[a, b] denotes the three-dimensional cross-product of the \
three-vectors a and b.\
\>", "Text",
 CellTags->"CrossProduct"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DotProduct",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DotProduct",
  ButtonNote->"DotProduct"],
 ", ",
 ButtonBox["ThreeVector",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ThreeVector",
  ButtonNote->"ThreeVector"],
 "."
}], "Text",
 CellTags->"CrossProduct"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"CrossProduct"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CrossProduct", "[", 
  RowBox[{
   RowBox[{"ThreeVector", "[", "a", "]"}], ",", 
   RowBox[{"CrossProduct", "[", 
    RowBox[{
     RowBox[{"ThreeVector", "[", "b", "]"}], ",", 
     RowBox[{"ThreeVector", "[", "c", "]"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"CrossProduct",
 CellLabel->"In[320]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FormBox[
      OverscriptBox["a", "\[RightVector]"],
      TraditionalForm], "\[CenterDot]", 
     FormBox[
      OverscriptBox["c", "\[RightVector]"],
      TraditionalForm]}], " ", 
    OverscriptBox["b", "\[RightVector]"]}], "-", 
   RowBox[{
    RowBox[{
     FormBox[
      OverscriptBox["a", "\[RightVector]"],
      TraditionalForm], "\[CenterDot]", 
     FormBox[
      OverscriptBox["b", "\[RightVector]"],
      TraditionalForm]}], " ", 
    OverscriptBox["c", "\[RightVector]"]}]}], TraditionalForm]], "Output",
 CellTags->"CrossProduct",
 CellLabel->"Out[320]="]
}, Open  ]]
}, Open  ]],

Cell["C0", "ObjectName",
 CellTags->"C0"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"C0"],

Cell[TextData[{
 "C0[p10, p12, p20, m1^2, m2^2, m3^2] is the scalar Passarino-Veltman ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "0"], TraditionalForm]]],
 "function. The convention for the arguments is that if the denominator of \
the integrand has the form ([q^2-m1^2] [(q+p1)^2-m2^2] [(q+p2)^2-m3^2]), the \
first three arguments of C0 are the scalar products p10 = p1^2, p12 = \
(p1-p2).(p1-p2), p20 = p2^2."
}], "Text",
 CellTags->"C0"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 ", ",
 ButtonBox["D0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"D0",
  ButtonNote->"D0"],
 ", ",
 ButtonBox["PaVe",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVe",
  ButtonNote->"PaVe"],
 ", ",
 ButtonBox["PaVeOrder",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVeOrder",
  ButtonNote->"PaVeOrder"],
 "."
}], "Text",
 CellTags->"C0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"C0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"C0", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", " ", "m12", ",", "m22", ",", "m32"}], 
  "]"}]], "Input",
 CellTags->"C0",
 CellLabel->"In[321]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\<\"C\"\>", "\<\"0\"\>"],
    TraditionalForm], "(", "a", ",", "b", ",", "c", ",", "m12", ",", "m22", 
   ",", "m32", ")"}], TraditionalForm]], "Output",
 CellTags->"C0",
 CellLabel->"Out[321]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"C0", "[", 
   RowBox[{"b", ",", "a", ",", "c", ",", "m32", ",", "m22", ",", "m12"}], 
   "]"}], "//", "PaVeOrder"}]], "Input",
 CellTags->"C0",
 CellLabel->"In[322]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\<\"C\"\>", "\<\"0\"\>"],
    TraditionalForm], "(", "a", ",", "b", ",", "c", ",", "m12", ",", "m22", 
   ",", "m32", ")"}], TraditionalForm]], "Output",
 CellTags->"C0",
 CellLabel->"Out[322]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaVeOrder", "[", 
  RowBox[{
   RowBox[{"C0", "[", 
    RowBox[{"b", ",", "a", ",", "c", ",", "m32", ",", "m22", ",", "m12"}], 
    "]"}], ",", 
   RowBox[{"PaVeOrderList", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"c", ",", "a"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"C0",
 CellLabel->"In[323]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\<\"C\"\>", "\<\"0\"\>"],
    TraditionalForm], "(", "b", ",", "c", ",", "a", ",", "m22", ",", "m32", 
   ",", "m12", ")"}], TraditionalForm]], "Output",
 CellTags->"C0",
 CellLabel->"Out[323]="]
}, Open  ]]
}, Open  ]],

Cell["DataType", "ObjectName",
 CellTags->"DataType"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DataType"],

Cell["\<\
DataType[exp, type] = True defines the object exp to have data-type type. \
DataType[exp1, exp2, ..., type] defines the objects exp1, exp2, ...to have \
data-type type. The default setting is DataType[__, _] := False. To assign a \
certain data-type, do, e.g., DataType[x, PositiveInteger] = True.\
\>", "Text",
 CellTags->"DataType"],

Cell[TextData[{
 "Currently used DataTypes: ",
 ButtonBox["NonCommutative",
  BaseStyle->"AddOnsLink",
  ButtonData:>"NonCommutative",
  ButtonNote->"NonCommutative"],
 ", ",
 ButtonBox["PositiveInteger",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PositiveInteger",
  ButtonNote->"PositiveInteger"],
 ", ",
 ButtonBox["NegativeInteger",
  BaseStyle->"AddOnsLink",
  ButtonData:>"NegativeInteger",
  ButtonNote->"NegativeInteger"],
 ", ",
 ButtonBox["PositiveNumber",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PositiveNumber",
  ButtonNote->"PositiveNumber"],
 ", ",
 ButtonBox["FreeIndex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FreeIndex",
  ButtonNote->"FreeIndex"],
 ", ",
 ButtonBox["GrassmannParity",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GrassmannParity",
  ButtonNote->"GrassmannParity"]
}], "Text",
 CellTags->"DataType"],

Cell[TextData[{
 "PHI adds the DataTypes: ",
 ButtonBox["UMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"UMatrix",
  ButtonNote->"UMatrix"],
 ", ",
 ButtonBox["UScalar",
  BaseStyle->"AddOnsLink",
  ButtonData:>"UScalar",
  ButtonNote->"UScalar"],
 "."
}], "Text",
 CellTags->"DataType"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DeclareNonCommutative",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DeclareNonCommutative",
  ButtonNote->"DeclareNonCommutative"],
 "."
}], "Text",
 CellTags->"DataType"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DataType"],

Cell["NonCommutative is just a data-type.", "Text",
 CellTags->"DataType"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataType", "[", 
    RowBox[{"f", ",", "g", ",", " ", "NonCommutative"}], "]"}], " ", "=", " ",
    "True"}], ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[324]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"f", ".", "g"}], "-", 
   RowBox[{"g", ".", 
    RowBox[{"(", 
     RowBox[{"2", "a"}], ")"}], ".", "f"}]}]}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[325]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", ".", "g"}], "-", 
   RowBox[{"g", ".", 
    RowBox[{"(", 
     RowBox[{"2", " ", "a"}], ")"}], ".", "f"}]}], TraditionalForm]], "Output",\

 CellTags->"DataType",
 CellLabel->"Out[325]="]
}, Open  ]],

Cell["\<\
Since \"f \"and \"g\" have DataType NonCommutative the function DotSimplify \
extracts only \"a\" out of the noncommutative product.\
\>", "Text",
 CellTags->"DataType"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", "t", "]"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[326]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", ".", "g"}], "-", 
   RowBox[{"2", " ", "a", " ", 
    RowBox[{"g", ".", "f"}]}]}], TraditionalForm]], "Output",
 CellTags->"DataType",
 CellLabel->"Out[326]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataType", "[", 
    RowBox[{"m", ",", "odd"}], "]"}], "=", 
   RowBox[{
    RowBox[{"DataType", "[", 
     RowBox[{"a", ",", "even"}], "]"}], "=", "True"}]}], ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[327]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ptest1", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "/.", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n_"], "/;", 
      RowBox[{"DataType", "[", 
       RowBox[{"n", ",", "odd"}], "]"}]}], "\[RuleDelayed]", 
     RowBox[{"-", "1"}]}]}]}], ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[328]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ptest2", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "/.", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n_"], "/;", 
      RowBox[{"DataType", "[", 
       RowBox[{"n", ",", "even"}], "]"}]}], "\[RuleDelayed]", "1"}]}]}], 
  ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[329]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", "m"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", "a"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", "z"}]}]}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[330]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "a"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "m"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "z"]}], TraditionalForm]], "Output",
 CellTags->"DataType",
 CellLabel->"Out[330]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptest1", "[", "t", "]"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[331]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "a"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "z"]}], TraditionalForm]], "Output",
 CellTags->"DataType",
 CellLabel->"Out[331]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptest2", "[", "%", "]"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[332]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "z"], TraditionalForm]], "Output",
 CellTags->"DataType",
 CellLabel->"Out[332]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"ptest1", ",", "ptest2", ",", "t", ",", "a", ",", "m"}], "]"}], 
  ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[333]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataType", "[", 
    RowBox[{"m", ",", "ganzeZahl"}], "]"}], "=", "True"}], ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[334]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", "p_"}], "/;", 
       RowBox[{"DataType", "[", 
        RowBox[{"p", ",", "ganzeZahl"}], "]"}]}], "\[RuleDelayed]", "1"}], 
     "}"}]}]}], ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[335]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"test", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", "m"}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", "n"}], " ", "x"}]}]}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[336]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "n"], " ", "x"}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "m"]}], TraditionalForm]], "Output",
 CellTags->"DataType",
 CellLabel->"Out[336]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "test", "]"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[337]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "n"], " ", "x"}], "+", "1"}], 
  TraditionalForm]], "Output",
 CellTags->"DataType",
 CellLabel->"Out[337]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "test"}], "]"}], ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[338]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataType", "[", 
    RowBox[{"f", ",", "g", ",", " ", "NonCommutative"}], "]"}], " ", "=", " ",
    "False"}], ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[339]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DataType", "[", 
    RowBox[{"m", ",", "odd"}], "]"}], "=", 
   RowBox[{
    RowBox[{"DataType", "[", 
     RowBox[{"a", ",", "even"}], "]"}], "=", "False"}]}], ";"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[340]:="],

Cell["\<\
Certain FeynCalc objects have DataType PositiveInteger set to True.\
\>", "Text",
 CellTags->"DataType"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataType", "[", 
  RowBox[{"OPEm", ",", "PositiveInteger"}], "]"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[341]:="],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellTags->"DataType",
 CellLabel->"Out[341]="]
}, Open  ]],

Cell["PowerSimplify uses the DataType information.", "Text",
 CellTags->"DataType"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerSimplify", "[", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{"2", "OPEm"}], ")"}]}], "]"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[342]:="],

Cell[BoxData[
 FormBox["1", TraditionalForm]], "Output",
 CellTags->"DataType",
 CellLabel->"Out[342]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerSimplify", "[", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", " ", 
     RowBox[{"SO", "[", "q", "]"}]}], ")"}], "^", "OPEm"}], "]"}]], "Input",
 CellTags->"DataType",
 CellLabel->"In[343]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[CapitalDelta]\"\>",
       TraditionalForm], 
      FormBox["\<\"\[CenterDot]\"\>",
       TraditionalForm], 
      FormBox["q",
       TraditionalForm]}], ")"}], "m"]}], TraditionalForm]], "Output",
 CellTags->"DataType",
 CellLabel->"Out[343]="]
}, Open  ]]
}, Open  ]],

Cell["DB0", "ObjectName",
 CellTags->"DB0"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DB0"],

Cell["\<\
DB0[p2, m1^2, m2^2] is the derivative of the two-point function B0[p2, m1^2, \
m2^2] with respect to p2.\
\>", "Text",
 CellTags->"DB0"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 "."
}], "Text",
 CellTags->"DB0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DB0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"B0", "[", 
    RowBox[{
     SubscriptBox["p", "2"], ",", 
     SuperscriptBox[
      SubscriptBox["m", "1"], "2"], ",", 
     SuperscriptBox[
      SubscriptBox["m", "2"], "2"]}], "]"}], ",", 
   SubscriptBox["p", "2"]}], "]"}]], "Input",
 CellTags->"DB0",
 CellLabel->"In[344]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"DB0", "(", 
   RowBox[{
    SubscriptBox["p", "2"], ",", 
    SubsuperscriptBox["m", "1", "2"], ",", 
    SubsuperscriptBox["m", "2", "2"]}], ")"}], TraditionalForm]], "Output",
 CellTags->"DB0",
 CellLabel->"Out[344]="]
}, Open  ]]
}, Open  ]],

Cell["DB1", "ObjectName",
 CellTags->"DB1"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DB1"],

Cell["\<\
DB1[p2,m1^2,m2^2] is the derivative of B1[p2,m1^2,m2^2] with respect to p2.\
\>", "Text",
 CellTags->"DB1"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["B1",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B1",
  ButtonNote->"B1"],
 "."
}], "Text",
 CellTags->"DB1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DB1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"B1", "[", 
    RowBox[{
     SubscriptBox["p", "2"], ",", 
     SuperscriptBox[
      SubscriptBox["m", "1"], "2"], ",", 
     SuperscriptBox[
      SubscriptBox["m", "2"], "2"]}], "]"}], ",", 
   SubscriptBox["p", "2"]}], "]"}]], "Input",
 CellTags->"DB1",
 CellLabel->"In[345]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubsuperscriptBox["m", "2", "2"], "-", 
       SubsuperscriptBox["m", "1", "2"]}], ")"}], " ", 
     RowBox[{"DB0", "(", 
      RowBox[{
       SubscriptBox["p", "2"], ",", 
       SubsuperscriptBox["m", "1", "2"], ",", 
       SubsuperscriptBox["m", "2", "2"]}], ")"}]}], 
    RowBox[{"2", " ", 
     SubscriptBox["p", "2"]}]], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"DB0", "(", 
     RowBox[{
      SubscriptBox["p", "2"], ",", 
      SubsuperscriptBox["m", "1", "2"], ",", 
      SubsuperscriptBox["m", "2", "2"]}], ")"}]}], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["B", "0"], "(", 
        SubscriptBox["p", "2"], ",", 
        SubsuperscriptBox["m", "1", "2"], ",", 
        SubsuperscriptBox["m", "2", "2"], ")"}], "-", 
       RowBox[{
        SubscriptBox["B", "0"], "(", "0", ",", 
        SubsuperscriptBox["m", "1", "2"], ",", 
        SubsuperscriptBox["m", "2", "2"], ")"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SubsuperscriptBox["m", "2", "2"], "-", 
       SubsuperscriptBox["m", "1", "2"]}], ")"}]}], 
    RowBox[{"2", " ", 
     SubsuperscriptBox["p", "2", "2"]}]]}], TraditionalForm]], "Output",
 CellTags->"DB1",
 CellLabel->"Out[345]="]
}, Open  ]]
}, Open  ]],

Cell["DeclareNonCommutative", "ObjectName",
 CellTags->"DeclareNonCommutative"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DeclareNonCommutative"],

Cell["\<\
DeclareNonCommutative[a, b, ...] declares a,b, ... to be non-commutative, \
i.e., DataType[a,b, ..., NonCommutative] is set to True.\
\>", "Text",
 CellTags->"DeclareNonCommutative"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DataType",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DataType",
  ButtonNote->"DataType"],
 ", ",
 ButtonBox["UnDeclareNonCommutative",
  BaseStyle->"AddOnsLink",
  ButtonData:>"UnDeclareNonCommutative",
  ButtonNote->"UnDeclareNonCommutative"],
 "."
}], "Text",
 CellTags->"DeclareNonCommutative"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DeclareNonCommutative"],

Cell[BoxData[
 RowBox[{"DeclareNonCommutative", "[", "x", "]"}]], "Input",
 CellTags->"DeclareNonCommutative",
 CellLabel->"In[346]:="],

Cell["\<\
As a side effect of DeclareNonCommutative x is declared to be of data type \
NonCommutative.\
\>", "Text",
 CellTags->"DeclareNonCommutative"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataType", "[", 
  RowBox[{"x", ",", "NonCommutative"}], "]"}]], "Input",
 CellTags->"DeclareNonCommutative",
 CellLabel->"In[347]:="],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellTags->"DeclareNonCommutative",
 CellLabel->"Out[347]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DeclareNonCommutative", "[", 
  RowBox[{"y", ",", "z"}], "]"}]], "Input",
 CellTags->"DeclareNonCommutative",
 CellLabel->"In[348]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataType", "[", 
  RowBox[{"a", ",", "x", ",", "y", ",", "z", ",", "NonCommutative"}], 
  "]"}]], "Input",
 CellTags->"DeclareNonCommutative",
 CellLabel->"In[349]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"DeclareNonCommutative",
 CellLabel->"Out[349]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"UnDeclareNonCommutative", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellTags->"DeclareNonCommutative",
 CellLabel->"In[350]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DataType", "[", 
  RowBox[{"a", ",", "x", ",", "y", ",", "z", ",", "NonCommutative"}], 
  "]"}]], "Input",
 CellTags->"DeclareNonCommutative",
 CellLabel->"In[351]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"DeclareNonCommutative",
 CellLabel->"Out[351]="]
}, Open  ]]
}, Open  ]],

Cell["DeltaFunction", "ObjectName",
 CellTags->"DeltaFunction"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DeltaFunction"],

Cell[TextData[{
 " DeltaFunction[x] is the Dirac delta-function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", "(", "x", ")"}], TraditionalForm]]],
 ".\n*** After version 4 of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", there is a built-in function, DiracDelta, with comparable properties. \
***"
}], "Text",
 CellTags->"DeltaFunction"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Convolute",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Convolute",
  ButtonNote->"Convolute"],
 ", ",
 ButtonBox["DeltaFunctionPrime",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DeltaFunctionPrime",
  ButtonNote->"DeltaFunctionPrime"],
 ", ",
 ButtonBox["Integrate2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Integrate2",
  ButtonNote->"Integrate2"],
 ", ",
 ButtonBox["SimplifyDeltaFunction",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SimplifyDeltaFunction",
  ButtonNote->"SimplifyDeltaFunction"],
 "."
}], "Text",
 CellTags->"DeltaFunction"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DeltaFunction"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeltaFunction", "[", 
  RowBox[{"1", "-", "x"}], "]"}]], "Input",
 CellTags->"DeltaFunction",
 CellLabel->"In[352]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Delta]", "(", 
   FormBox[
    RowBox[{"1", "-", "x"}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"DeltaFunction",
 CellLabel->"Out[352]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DeltaFunction", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"DeltaFunction",
 CellLabel->"In[353]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"f", "(", "1", ")"}], TraditionalForm]], "Output",
 CellTags->"DeltaFunction",
 CellLabel->"Out[353]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DeltaFunction", "[", "x", "]"}], " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"DeltaFunction",
 CellLabel->"In[354]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"f", "(", "0", ")"}], TraditionalForm]], "Output",
 CellTags->"DeltaFunction",
 CellLabel->"Out[354]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DeltaFunction", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"DeltaFunction",
 CellLabel->"In[355]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"f", "(", "1", ")"}], TraditionalForm]], "Output",
 CellTags->"DeltaFunction",
 CellLabel->"Out[355]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convolute", "[", 
  RowBox[{
   RowBox[{"DeltaFunction", "[", 
    RowBox[{"1", "-", "x"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"DeltaFunction",
 CellLabel->"In[356]:="],

Cell[BoxData[
 FormBox["x", TraditionalForm]], "Output",
 CellTags->"DeltaFunction",
 CellLabel->"Out[356]="]
}, Open  ]]
}, Open  ]],

Cell["DeltaFunctionDoublePrime", "ObjectName",
 CellTags->"DeltaFunctionDoublePrime"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DeltaFunctionDoublePrime"],

Cell[TextData[{
 " DeltaFunctionDoublePrime[1-x] is the second derivative of the Dirac \
delta-function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", "(", "x", ")"}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"DeltaFunctionDoublePrime"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DeltaFunctionPrime",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DeltaFunctionPrime",
  ButtonNote->"DeltaFunctionPrime"],
 "."
}], "Text",
 CellTags->"DeltaFunctionDoublePrime"]
}, Open  ]],

Cell["DeltaFunctionPrime", "ObjectName",
 CellTags->"DeltaFunctionPrime"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DeltaFunctionPrime"],

Cell[TextData[{
 " DeltaFunctionPrime[1-x] is the derivative of the Dirac delta-function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", "(", "x", ")"}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"DeltaFunctionPrime"],

Cell[TextData[{
 "See also: ",
 ButtonBox["Convolute",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Convolute",
  ButtonNote->"Convolute"],
 ", ",
 ButtonBox["DeltaFunction",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DeltaFunction",
  ButtonNote->"DeltaFunction"],
 ", ",
 ButtonBox["Integrate2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Integrate2",
  ButtonNote->"Integrate2"],
 ", ",
 ButtonBox["SimplifyDeltaFunction",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SimplifyDeltaFunction",
  ButtonNote->"SimplifyDeltaFunction"],
 "."
}], "Text",
 CellTags->"DeltaFunctionPrime"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DeltaFunctionPrime"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeltaFunctionPrime", "[", 
  RowBox[{"1", "-", "x"}], "]"}]], "Input",
 CellTags->"DeltaFunctionPrime",
 CellLabel->"In[357]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Delta]", "\[Prime]"], "(", 
   FormBox[
    RowBox[{"1", "-", "x"}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"DeltaFunctionPrime",
 CellLabel->"Out[357]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DeltaFunctionPrime", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"DeltaFunctionPrime",
 CellLabel->"In[358]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "(", "1", ")"}], TraditionalForm]], "Output",
 CellTags->"DeltaFunctionPrime",
 CellLabel->"Out[358]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"DeltaFunctionPrime", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"DeltaFunctionPrime",
 CellLabel->"In[359]:="],

Cell[BoxData[
 FormBox["2", TraditionalForm]], "Output",
 CellTags->"DeltaFunctionPrime",
 CellLabel->"Out[359]="]
}, Open  ]]
}, Open  ]],

Cell["DenominatorOrder", "ObjectName",
 CellTags->"DenominatorOrder"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DenominatorOrder"],

Cell["\<\
DenominatorOrder is an option for OneLoop, if set to True the \
PropagatorDenominator will be ordered in a standard way.\
\>", "Text",
 CellTags->"DenominatorOrder"],

Cell[TextData[{
 "See also: ",
 ButtonBox["OneLoop",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoop",
  ButtonNote->"OneLoop"],
 ", ",
 ButtonBox["PropagatorDenominator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PropagatorDenominator",
  ButtonNote->"PropagatorDenominator"],
 "."
}], "Text",
 CellTags->"DenominatorOrder"]
}, Open  ]],

Cell["Dimension", "ObjectName",
 CellTags->"Dimension"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Dimension"],

Cell["\<\
Dimension is an option of several functions and denotes the number of \
space-time dimensions. Possible settings are: 4, n, d, D, ... ,the variable \
does not matter, but it should have Head Symbol.\
\>", "Text",
 CellTags->"Dimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "MetricTensor", "]"}]], "Input",
 CellTags->"Dimension",
 CellLabel->"In[360]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dimension", "\[Rule]", "4"}], ",", 
    RowBox[{"FeynCalcInternal", "\[Rule]", "True"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"Dimension",
 CellLabel->"Out[360]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MetricTensor", "[", 
   RowBox[{"m", ",", "n", ",", 
    RowBox[{"Dimension", "\[Rule]", "d"}]}], "]"}], 
  RowBox[{"DiracMatrix", "[", 
   RowBox[{"\[Alpha]", ",", 
    RowBox[{"Dimension", "\[Rule]", "d"}]}], "]"}]}]], "Input",
 CellTags->"Dimension",
 CellLabel->"In[361]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Alpha]",
      TraditionalForm],
     TraditionalForm]], " ", 
   SuperscriptBox["g", 
    RowBox[{"m", "n"}]]}], TraditionalForm]], "Output",
 CellTags->"Dimension",
 CellLabel->"Out[361]="]
}, Open  ]],

Cell["\<\
The dimension of the indices is not shown by default but can be inspected \
easily.\
\>", "Text",
 CellTags->"Dimension"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MetricTensor", "[", 
    RowBox[{"m", ",", "n", ",", 
     RowBox[{"Dimension", "\[Rule]", "d"}]}], "]"}], 
   RowBox[{"DiracMatrix", "[", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"Dimension", "\[Rule]", "d"}]}], "]"}]}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"Dimension",
 CellLabel->"In[362]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracGamma", "[", 
   RowBox[{
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Alpha]", ",", "d"}], "]"}], ",", "d"}], "]"}], " ", 
  RowBox[{"Pair", "[", 
   RowBox[{
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"m", ",", "d"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"n", ",", "d"}], "]"}]}], "]"}]}]], "Output",
 CellTags->"Dimension",
 CellLabel->"Out[362]//StandardForm="]
}, Open  ]],

Cell["\<\
Setting the global variable $LorentzIndices to True will display the \
dimension (if different from 4) as a subscript.\
\>", "Text",
 CellTags->"Dimension"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$LorentzIndices", "=", "True"}], ";"}]], "Input",
 CellTags->"Dimension",
 CellLabel->"In[363]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MetricTensor", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]", ",", 
    RowBox[{"Dimension", "\[Rule]", "n"}]}], "]"}], 
  RowBox[{"DiracMatrix", "[", 
   RowBox[{"\[Alpha]", ",", 
    RowBox[{"Dimension", "\[Rule]", "n"}]}], "]"}]}]], "Input",
 CellTags->"Dimension",
 CellLabel->"In[364]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     SubscriptBox[
      FormBox["\[Alpha]",
       TraditionalForm], 
      FormBox["n",
       TraditionalForm]],
     TraditionalForm]], " ", 
   SuperscriptBox["g", 
    RowBox[{
     FormBox[
      SubscriptBox[
       FormBox["\[Alpha]",
        TraditionalForm], 
       FormBox["n",
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox[
       FormBox["\[Beta]",
        TraditionalForm], 
       FormBox["n",
        TraditionalForm]],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"Dimension",
 CellLabel->"Out[364]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"Dimension",
 CellLabel->"In[365]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracGamma", "[", 
   RowBox[{
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Alpha]", ",", "n"}], "]"}], ",", "n"}], "]"}], " ", 
  RowBox[{"Pair", "[", 
   RowBox[{
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Alpha]", ",", "n"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Beta]", ",", "n"}], "]"}]}], "]"}]}]], "Output",
 CellTags->"Dimension",
 CellLabel->"Out[365]//StandardForm="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$LorentzIndices", "=", "False"}], ";"}]], "Input",
 CellTags->"Dimension",
 CellLabel->"In[366]:="]
}, Open  ]],

Cell["DimensionalReduction", "ObjectName",
 CellTags->"DimensionalReduction"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DimensionalReduction"],

Cell["\<\
DimensionalReduction is an option for TID and OneLoopSimplify.\
\>", "Text",
 CellTags->"DimensionalReduction"],

Cell[TextData[{
 "See also: ",
 ButtonBox["TID",
  BaseStyle->"AddOnsLink",
  ButtonData:>"TID",
  ButtonNote->"TID"],
 ", ",
 ButtonBox["OneLoopSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoopSimplify",
  ButtonNote->"OneLoopSimplify"],
 "."
}], "Text",
 CellTags->"DimensionalReduction"]
}, Open  ]],

Cell["DiracBasis", "ObjectName",
 CellTags->"DiracBasis"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracBasis"],

Cell["\<\
DiracBasis[any] is a head which is wrapped around Dirac structures (and the \
1) as a result of the function DiracReduce. Eventually you want to substitute \
DiracBasis by Identity (or set: DiracBasis[1] = S; \
DiracBasis[DiracMatrix[mu]] = P; etc.).\
\>", "Text",
 CellTags->"DiracBasis"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DiracReduce",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracReduce",
  ButtonNote->"DiracReduce"],
 "."
}], "Text",
 CellTags->"DiracBasis"]
}, Open  ]],

Cell["DiracCanonical", "ObjectName",
 CellTags->"DiracCanonical"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracCanonical"],

Cell["\<\
DiracCanonical is an option for DiracSimplify. If set to True DiracSimplify \
uses the function DiracOrder internally.\
\>", "Text",
 CellTags->"DiracCanonical"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 "."
}], "Text",
 CellTags->"DiracCanonical"]
}, Open  ]],

Cell["DiracEquation", "ObjectName",
 CellTags->"DiracEquation"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracEquation"],

Cell["\<\
DiracEquation[exp] applies the Dirac equation without expanding exp. If that \
is needed, use DiracSimplify.\
\>", "Text",
 CellTags->"DiracEquation"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 "."
}], "Text",
 CellTags->"DiracEquation"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracEquation"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Spinor", "[", 
   RowBox[{
    RowBox[{"Momentum", "[", "p", "]"}], ",", "m", ",", "1"}], "]"}], ".", 
  RowBox[{"DiracGamma", "[", 
   RowBox[{"Momentum", "[", "p", "]"}], "]"}]}]], "Input",
 CellTags->"DiracEquation",
 CellLabel->"In[367]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CurlyPhi]", "(", 
    FormBox["p",
     TraditionalForm], ",", "m", ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracEquation",
 CellLabel->"Out[367]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracEquation", "[", "%", "]"}]], "Input",
 CellTags->"DiracEquation",
 CellLabel->"In[368]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"m", " ", 
   RowBox[{"\[CurlyPhi]", "(", 
    FormBox["p",
     TraditionalForm], ",", "m", ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracEquation",
 CellLabel->"Out[368]="]
}, Open  ]]
}, Open  ]],

Cell["DiracGamma", "ObjectName",
 CellTags->"DiracGamma"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracGamma"],

Cell[TextData[{
 "DiracGamma[x, dim] is the head of all Dirac matrices and slashes (in the \
internal representation). Use DiracMatrix (or GA, GAD) and DiracSlash (or GS, \
GSD) for manual (short) input. DiracGamma[x, 4] simplifies to DiracGamma[x]. \
DiracGamma[5] is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 ". DiracGamma[6] is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[Gamma]", "5"]}], ")"}], "/", "2."}], 
   TraditionalForm]]],
 " DiracGamma[7] is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[Gamma]", "5"]}], ")"}], "/", "2."}], 
   TraditionalForm]]]
}], "Text",
 CellTags->"DiracGamma"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracGammaExpand",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGammaExpand",
  ButtonNote->"DiracGammaExpand"],
 ", ",
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix",
  ButtonNote->"DiracMatrix"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DiracSlash",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSlash",
  ButtonNote->"DiracSlash"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 "."
}], "Text",
 CellTags->"DiracGamma"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracGamma"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracGamma", "[", "5", "]"}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[369]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Gamma]", "5"], TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[369]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracGamma", "[", 
  RowBox[{"LorentzIndex", "[", "\[Alpha]", "]"}], "]"}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[370]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Gamma]", 
   FormBox[
    FormBox["\[Alpha]",
     TraditionalForm],
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[370]="]
}, Open  ]],

Cell[TextData[{
 "A Dirac-slash, i.e., ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], 
    SubscriptBox["q", "\[Mu]"]}], TraditionalForm]]],
 ", is displayed as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", "\[CenterDot]", "q"}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"DiracGamma"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracGamma", "[", 
   RowBox[{"Momentum", "[", "q", "]"}], "]"}], " "}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[371]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["\<\"\[Gamma]\"\>",
    TraditionalForm], "\[CenterDot]", 
   FormBox["q",
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[371]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracGamma", "[", 
   RowBox[{"Momentum", "[", "q", "]"}], "]"}], " ", ".", " ", 
  RowBox[{"DiracGamma", "[", 
   RowBox[{"Momentum", "[", 
    RowBox[{"p", "-", "q"}], "]"}], "]"}]}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[372]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"p", "-", "q"}],
      TraditionalForm], ")"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[372]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracGamma", "[", 
   RowBox[{
    RowBox[{"Momentum", "[", 
     RowBox[{"q", ",", "D"}], "]"}], ",", "D"}], "]"}], " "}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[373]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["\<\"\[Gamma]\"\>",
    TraditionalForm], "\[CenterDot]", 
   FormBox["q",
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[373]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a1", "=", 
  RowBox[{
   RowBox[{"GS", "[", 
    RowBox[{"p", "-", "q"}], "]"}], ".", 
   RowBox[{"GS", "[", "p", "]"}]}]}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[374]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"p", "-", "q"}],
      TraditionalForm], ")"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}]}], 
  TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[374]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a2", "=", 
  RowBox[{"DiracGammaExpand", "[", "a1", "]"}]}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[375]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p",
       TraditionalForm]}], "-", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[375]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a3", "=", 
  RowBox[{
   RowBox[{"GAD", "[", "\[Mu]", "]"}], ".", 
   RowBox[{"GSD", "[", 
    RowBox[{"p", "-", "q"}], "]"}], ".", 
   RowBox[{"GSD", "[", "q", "]"}], ".", 
   RowBox[{"GAD", "[", "\[Mu]", "]"}]}]}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[376]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"p", "-", "q"}],
      TraditionalForm], ")"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "q"}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[376]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a4", "=", 
  RowBox[{"DiracTrick", "[", "a3", "]"}]}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[377]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"p", "-", "q"}],
      TraditionalForm], ")"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "q"}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[377]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a5", "=", 
  RowBox[{"DiracSimplify", "[", "a4", "]"}]}]], "Input",
 CellTags->"DiracGamma",
 CellLabel->"In[378]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"D", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["q",
        TraditionalForm]}], ")"}]}]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["q",
        TraditionalForm]}], ")"}]}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     FormBox["p",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}]}], "-", 
   RowBox[{"D", " ", 
    SuperscriptBox[
     FormBox["q",
      TraditionalForm], "2"]}]}], TraditionalForm]], "Output",
 CellTags->"DiracGamma",
 CellLabel->"Out[378]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"a1", ",", "a2", ",", "a3", ",", "a4", ",", "a5"}], "]"}]], "Input",\

 CellTags->"DiracGamma",
 CellLabel->"In[379]:="]
}, Open  ]],

Cell["DiracGammaCombine", "ObjectName",
 CellTags->"DiracGammaCombine"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracGammaCombine"],

Cell["\<\
DiracGammaCombine[exp] is (nearly) the inverse operation to DiracGammaExpand.\
\
\>", "Text",
 CellTags->"DiracGammaCombine"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracGamma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGamma",
  ButtonNote->"DiracGamma"],
 ", ",
 ButtonBox["DiracGammaExpand",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGammaExpand",
  ButtonNote->"DiracGammaExpand"],
 ", ",
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix",
  ButtonNote->"DiracMatrix"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DiracSlash",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSlash",
  ButtonNote->"DiracSlash"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 "."
}], "Text",
 CellTags->"DiracGammaCombine"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracGammaCombine"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracGammaCombine", "[", 
  RowBox[{
   RowBox[{"GS", "[", "p", "]"}], " ", "+", " ", 
   RowBox[{"GS", "[", "q", "]"}]}], "]"}]], "Input",
 CellTags->"DiracGammaCombine",
 CellLabel->"In[380]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["\<\"\[Gamma]\"\>",
    TraditionalForm], "\[CenterDot]", "(", 
   FormBox[
    RowBox[{"p", "+", "q"}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"DiracGammaCombine",
 CellLabel->"Out[380]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", "%", "]"}]], "Input",
 CellTags->"DiracGammaCombine",
 CellLabel->"In[381]:="],

Cell[BoxData[
 RowBox[{"DiracGamma", "[", 
  RowBox[{"Momentum", "[", 
   RowBox[{"p", "+", "q"}], "]"}], "]"}]], "Output",
 CellTags->"DiracGammaCombine",
 CellLabel->"Out[381]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracGammaCombine", "[", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"GS", "[", "p", "]"}]}], " ", "-", " ", 
   RowBox[{"2", " ", 
    RowBox[{"GS", "[", "q", "]"}]}]}], "]"}]], "Input",
 CellTags->"DiracGammaCombine",
 CellLabel->"In[382]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["\<\"\[Gamma]\"\>",
    TraditionalForm], "\[CenterDot]", "(", 
   FormBox[
    RowBox[{
     RowBox[{"2", " ", "p"}], "-", 
     RowBox[{"2", " ", "q"}]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"DiracGammaCombine",
 CellLabel->"Out[382]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", "%", "]"}]], "Input",
 CellTags->"DiracGammaCombine",
 CellLabel->"In[383]:="],

Cell[BoxData[
 RowBox[{"DiracGamma", "[", 
  RowBox[{"Momentum", "[", 
   RowBox[{
    RowBox[{"2", " ", "p"}], "-", 
    RowBox[{"2", " ", "q"}]}], "]"}], "]"}]], "Output",
 CellTags->"DiracGammaCombine",
 CellLabel->"Out[383]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracGammaExpand", "[", "%%", "]"}]], "Input",
 CellTags->"DiracGammaCombine",
 CellLabel->"In[384]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}]}], "-", 
   RowBox[{"2", " ", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}]}]}], TraditionalForm]], "Output",
 CellTags->"DiracGammaCombine",
 CellLabel->"Out[384]="]
}, Open  ]]
}, Open  ]],

Cell["DiracGammaExpand", "ObjectName",
 CellTags->"DiracGammaExpand"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracGammaExpand"],

Cell["\<\
DiracGammaExpand[exp] expands all DiracGamma[Momentum[a+b+..]] in exp into \
(DiracGamma[Momentum[a]] + DiracGamma[Momentum[b]] + ...).\
\>", "Text",
 CellTags->"DiracGammaExpand"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracGamma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGamma",
  ButtonNote->"DiracGamma"],
 ", ",
 ButtonBox["DiracGammaCombine",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGammaCombine",
  ButtonNote->"DiracGammaCombine"],
 ", ",
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix",
  ButtonNote->"DiracMatrix"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DiracSlash",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSlash",
  ButtonNote->"DiracSlash"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 "."
}], "Text",
 CellTags->"DiracGammaExpand"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracGammaExpand"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"DiracGamma", "[", 
    RowBox[{"Momentum", "[", "q", "]"}], "]"}], " ", ".", " ", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{"Momentum", "[", 
     RowBox[{"p", "-", "q"}], "]"}], "]"}]}]}]], "Input",
 CellTags->"DiracGammaExpand",
 CellLabel->"In[385]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"p", "-", "q"}],
      TraditionalForm], ")"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracGammaExpand",
 CellLabel->"Out[385]="]
}, Open  ]],

Cell["\<\
Momentum is the head of p-q, i.e., it is treated as one four-momentum.\
\>", "Text",
 CellTags->"DiracGammaExpand"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", "t", "]"}]], "Input",
 CellTags->"DiracGammaExpand",
 CellLabel->"In[386]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracGamma", "[", 
   RowBox[{"Momentum", "[", "q", "]"}], "]"}], ".", 
  RowBox[{"DiracGamma", "[", 
   RowBox[{"Momentum", "[", 
    RowBox[{"p", "-", "q"}], "]"}], "]"}]}]], "Output",
 CellTags->"DiracGammaExpand",
 CellLabel->"Out[386]//StandardForm="]
}, Open  ]],

Cell["With DiracGammaExpand the Momentum[p-q] gets expanded.", "Text",
 CellTags->"DiracGammaExpand"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracGammaExpand", "[", "t", "]"}]], "Input",
 CellTags->"DiracGammaExpand",
 CellLabel->"In[387]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p",
       TraditionalForm]}], "-", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracGammaExpand",
 CellLabel->"Out[387]="]
}, Open  ]],

Cell["The inverse operation is DiracGammaCombine.", "Text",
 CellTags->"DiracGammaExpand"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"DiracGammaCombine", "[", 
   RowBox[{"DiracGammaExpand", "[", "t", "]"}], "]"}], "]"}]], "Input",
 CellTags->"DiracGammaExpand",
 CellLabel->"In[388]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracGamma", "[", 
   RowBox[{"Momentum", "[", "q", "]"}], "]"}], ".", 
  RowBox[{"DiracGamma", "[", 
   RowBox[{"Momentum", "[", 
    RowBox[{"p", "-", "q"}], "]"}], "]"}]}]], "Output",
 CellTags->"DiracGammaExpand",
 CellLabel->"Out[388]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"DiracGammaExpand", "[", "t", "]"}], "]"}]], "Input",
 CellTags->"DiracGammaExpand",
 CellLabel->"In[389]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracGamma", "[", 
   RowBox[{"Momentum", "[", "q", "]"}], "]"}], ".", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"DiracGamma", "[", 
     RowBox[{"Momentum", "[", "p", "]"}], "]"}], "-", 
    RowBox[{"DiracGamma", "[", 
     RowBox[{"Momentum", "[", "q", "]"}], "]"}]}], ")"}]}]], "Output",
 CellTags->"DiracGammaExpand",
 CellLabel->"Out[389]//StandardForm="]
}, Open  ]],

Cell["In order to do non-commutative expansion use DiracSimplify.", "Text",
 CellTags->"DiracGammaExpand"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", "t", "]"}]], "Input",
 CellTags->"DiracGammaExpand",
 CellLabel->"In[390]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p",
       TraditionalForm]}], ")"}]}], "-", 
   SuperscriptBox[
    FormBox["q",
     TraditionalForm], "2"]}], TraditionalForm]], "Output",
 CellTags->"DiracGammaExpand",
 CellLabel->"Out[390]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "t", "]"}]], "Input",
 CellTags->"DiracGammaExpand",
 CellLabel->"In[391]:="]
}, Open  ]],

Cell["DiracGammaT", "ObjectName",
 CellTags->"DiracGammaT"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracGammaT"],

Cell["\<\
DiracGammaT[x] denotes the transpose of DiracGamma[x]. \
Transpose[DiracGammaT[x]] gives DiracGamma[x]. Note that x must have Head \
LorentzIndex or Momentum.\
\>", "Text",
 CellTags->"DiracGammaT"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracGamma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGamma",
  ButtonNote->"DiracGamma"],
 "."
}], "Text",
 CellTags->"DiracGammaT"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracGammaT"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracGammaT", "[", 
  RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}]], "Input",
 CellTags->"DiracGammaT",
 CellLabel->"In[392]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["\[Gamma]", 
   FormBox[
    FormBox["\[Mu]",
     TraditionalForm],
    TraditionalForm], "T"], TraditionalForm]], "Output",
 CellTags->"DiracGammaT",
 CellLabel->"Out[392]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", "%", "]"}]], "Input",
 CellTags->"DiracGammaT",
 CellLabel->"In[393]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Gamma]", 
   FormBox[
    FormBox["\[Mu]",
     TraditionalForm],
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"DiracGammaT",
 CellLabel->"Out[393]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GS", "[", "p", "]"}], "//", "FCI"}], "//", "Transpose"}]], "Input",\

 CellTags->"DiracGammaT",
 CellLabel->"In[394]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   RowBox[{"(", "\[Gamma]", "\[CenterDot]", 
    FormBox["p",
     TraditionalForm], ")"}], "T"], TraditionalForm]], "Output",
 CellTags->"DiracGammaT",
 CellLabel->"Out[394]="]
}, Open  ]]
}, Open  ]],

Cell["DiracMatrix", "ObjectName",
 CellTags->"DiracMatrix"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracMatrix"],

Cell[TextData[{
 "DiracMatrix[",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "] denotes a Dirac gamma matrix with Lorentz index ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 ". DiracMatrix[",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Mu]", ",", "\[Nu]", ","}], " "}], TraditionalForm]]],
 "...] is a product of ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]]],
 " matrices with Lorentz indices ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Mu]", ",", " ", "\[Nu]", ",", " ", "..."}], TraditionalForm]]],
 " DiracMatrix[5] is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 ". DiracMatrix[6] is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "2"}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"+", " ", 
      SuperscriptBox["\[Gamma]", "5"]}], "/", "2"}]}], TraditionalForm]]],
 ". DiracMatrix[7] is",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"1", "/", "2"}]}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{"-", " ", 
      SuperscriptBox["\[Gamma]", "5"]}], "/", "2"}]}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"DiracMatrix"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracGammaExpand",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGammaExpand",
  ButtonNote->"DiracGammaExpand"],
 ", ",
 ButtonBox["DiracGamma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGamma",
  ButtonNote->"DiracGamma"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DiracSlash",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSlash",
  ButtonNote->"DiracSlash"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 ", ",
 ButtonBox["GA",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GA",
  ButtonNote->"GA"],
 ", ",
 ButtonBox["GAD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GAD",
  ButtonNote->"GAD"],
 ", ",
 ButtonBox["GS",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GS",
  ButtonNote->"GS"],
 ", ",
 ButtonBox["GSD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GSD",
  ButtonNote->"GSD"],
 "."
}], "Text",
 CellTags->"DiracMatrix"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracMatrix"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[395]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Gamma]", 
   FormBox[
    FormBox["\[Mu]",
     TraditionalForm],
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[395]="]
}, Open  ]],

Cell[TextData[{
 "This is how to enter the non-commutative product of two ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]]}], TraditionalForm]]],
 ". The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Dot \".\" is used as non-commutative multiplication operator."
}], "Text",
 CellTags->"DiracMatrix"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], ".", 
  RowBox[{"DiracMatrix", "[", "\[Nu]", "]"}]}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[396]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[396]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracMatrix", "[", "\[Alpha]", "]"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[397]:="],

Cell[BoxData[
 RowBox[{"DiracGamma", "[", 
  RowBox[{"LorentzIndex", "[", "\[Alpha]", "]"}], "]"}]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[397]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], "//", "FCE"}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[398]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[398]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[399]:="],

Cell[BoxData[
 RowBox[{"GA", "[", "\[Mu]", "]"}]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[399]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GAD", "[", "\[Mu]", "]"}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[400]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[400]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "FCI"}], "//", "StandardForm"}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[401]:="],

Cell[BoxData[
 RowBox[{"DiracGamma", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", 
    RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", "D"}], "]"}]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[401]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GA", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]"}], "]"}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[402]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Rho]"]}], TraditionalForm]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[402]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GA", "[", 
   RowBox[{"a", " ", ".", " ", "b"}], "]"}], "//", "FCI"}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[403]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["a",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["b",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[403]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"DiracMatrix",
 CellLabel->"In[404]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracGamma", "[", 
   RowBox[{"LorentzIndex", "[", "a", "]"}], "]"}], ".", 
  RowBox[{"DiracGamma", "[", 
   RowBox[{"LorentzIndex", "[", "b", "]"}], "]"}]}]], "Output",
 CellTags->"DiracMatrix",
 CellLabel->"Out[404]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["DiracOrder", "ObjectName",
 CellTags->"DiracOrder"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracOrder"],

Cell["\<\
DiracOrder[expr] orders the Dirac matrices in expr alphabetically. \
DiracOrder[expr,orderlist] orders the Dirac matrices in expr according to \
orderlist.\
\>", "Text",
 CellTags->"DiracOrder"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 "."
}], "Text",
 CellTags->"DiracOrder"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracOrder"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", " ", "=", " ", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Beta]", ",", "\[Alpha]"}], "]"}]}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[405]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Beta]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Alpha]"]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[405]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracOrder", "[", "t1", "]"}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[406]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]]}], "-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Beta]",
       TraditionalForm],
      TraditionalForm]]}]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[406]="]
}, Open  ]],

Cell["This is a string of Dirac matrices in D dimensions. ", "Text",
 CellTags->"DiracOrder"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"GAD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[407]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[407]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracOrder", "[", "t1", "]"}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[408]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]]}], "-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Beta]",
       TraditionalForm],
      TraditionalForm]]}]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[408]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", "=", 
  RowBox[{"GA", "[", 
   RowBox[{"5", ",", "\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[409]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[409]="]
}, Open  ]],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", 
    RowBox[{"5", " "}]], TraditionalForm]]],
 "is moved to the right."
}], "Text",
 CellTags->"DiracOrder"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracOrder", "[", "t3", "]"}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[410]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", "5"]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[410]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t4", "=", 
  RowBox[{"GA", "[", 
   RowBox[{"6", ",", "\[Mu]", ",", "7"}], "]"}]}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[411]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "6"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[411]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracOrder", "[", "t4", "]"}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[412]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[412]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t5", "=", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Delta]"}], "]"}]}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[413]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Alpha]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Beta]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[413]="]
}, Open  ]],

Cell[TextData[{
 "This orders the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Alpha]"], 
    SuperscriptBox["\[Gamma]", "\[Beta]"], 
    SuperscriptBox["\[Gamma]", "\[Delta]"]}], TraditionalForm]]],
 " in reverse order."
}], "Text",
 CellTags->"DiracOrder"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracOrder", "[", 
  RowBox[{"t5", ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "\[Beta]", ",", "\[Alpha]"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[414]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Delta]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Beta]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Alpha]",
        TraditionalForm],
       TraditionalForm]]}]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Delta]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]]}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Beta]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Delta]"}]]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Beta]", "\[Delta]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[414]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracOrder", "[", "%", "]"}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[415]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Alpha]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Beta]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Delta]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"DiracOrder",
 CellLabel->"Out[415]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"t1", ",", "t2", ",", "t3", ",", "t4", ",", "t5"}], "]"}], 
  ";"}]], "Input",
 CellTags->"DiracOrder",
 CellLabel->"In[416]:="]
}, Open  ]],

Cell["DiracReduce", "ObjectName",
 CellTags->"DiracReduce"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracReduce"],

Cell["\<\
DiracReduce[exp] reduces all four-dimensional Dirac matrices in exp to the \
standard basis (S,P,V,A,T) using the Chisholm identity (see Chisholm). In the \
result the basic Dirac structures are wrapped with a head DiracBasis. I.e., S \
corresponds to DiracBasis[1], P : DiracBasis[DiracMatrix[5]], V: \
DiracBasis[DiracMatrix[mu]], A: DiracBasis[DiracMatrix[mu, 5]], T: \
DiracBasis[DiracSigma[DiracMatrix[mu, nu]]]. By default DiracBasis is \
substituted to Identity. Notice that the result of DiracReduce is given in \
the FeynCalcExternal-way, i.e.,evtl. you may have to use FeynCalcInternal on \
the result.\
\>", "Text",
 CellTags->"DiracReduce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DiracReduce", "]"}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[417]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
    RowBox[{"FinalSubstitutions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"DiracBasis", "\[Rule]", "Identity"}], "}"}]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"DiracReduce",
 CellLabel->"Out[417]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 "."
}], "Text",
 CellTags->"DiracReduce"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracReduce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", " ", "=", " ", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[418]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracReduce",
 CellLabel->"Out[418]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracReduce", "[", "t1", "]"}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[419]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["g", 
    RowBox[{"\[Mu]", "\[Nu]"}]], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Sigma]", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"DiracReduce",
 CellLabel->"Out[419]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"DiracMatrix", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]"}], "]"}]}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[420]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], 
   SuperscriptBox["\[Gamma]", "\[Nu]"], 
   SuperscriptBox["\[Gamma]", "\[Rho]"]}], TraditionalForm]], "Output",
 CellTags->"DiracReduce",
 CellLabel->"Out[420]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracReduce", "[", "t2", "]"}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[421]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      RowBox[{"$MU", "\[InvisibleApplication]", 
       RowBox[{"(", "1", ")"}]}]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{"\[Mu]", "\[Nu]", "\[Rho]", 
      FormBox[
       RowBox[{"$MU", "\[InvisibleApplication]", 
        RowBox[{"(", "1", ")"}]}],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Rho]"], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Nu]"], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]]}], "+", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"DiracReduce",
 CellLabel->"Out[421]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", "=", 
  RowBox[{"DiracMatrix", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
   "]"}]}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[422]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], 
   SuperscriptBox["\[Gamma]", "\[Nu]"], 
   SuperscriptBox["\[Gamma]", "\[Rho]"], 
   SuperscriptBox["\[Gamma]", "\[Sigma]"]}], TraditionalForm]], "Output",
 CellTags->"DiracReduce",
 CellLabel->"Out[422]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t4", "=", 
  RowBox[{"DiracReduce", "[", "t3", "]"}]}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[423]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    SuperscriptBox["\[Gamma]", "5"], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{"\[Mu]", "\[Nu]", "\[Rho]", "\[Sigma]"}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Sigma]", 
     RowBox[{"\[Rho]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Sigma]", 
     RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Sigma]", 
     RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Sigma]", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Sigma]", 
     RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]]}], "-", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]]}], "-", 
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Sigma]", 
     RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"DiracReduce",
 CellLabel->"Out[423]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t5", " ", "=", 
  RowBox[{"Calc", "[", 
   RowBox[{"DiracSimplify", "[", 
    RowBox[{"DiracSigmaExplicit", "[", 
     RowBox[{"t4", ".", "t4"}], "]"}], "]"}], "]"}]}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[424]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", "128"}], TraditionalForm]], "Output",
 CellTags->"DiracReduce",
 CellLabel->"Out[424]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{"t4", ".", "t4"}], "]"}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[425]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", "128"}], TraditionalForm]], "Output",
 CellTags->"DiracReduce",
 CellLabel->"Out[425]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"t1", ",", "t2", ",", "t3", ",", "t4"}], "]"}]], "Input",
 CellTags->"DiracReduce",
 CellLabel->"In[426]:="]
}, Open  ]],

Cell["DiracSigma", "ObjectName",
 CellTags->"DiracSigma"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracSigma"],

Cell["\<\
DiracSigma[a, b] stands for i/2*(a . b - b . a) in 4 dimensions. a and b must \
have Head DiracGamma, DiracMatrix or DiracSlash. Only antisymmetry is \
implemented.\
\>", "Text",
 CellTags->"DiracSigma"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracSigmaExplicit",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSigmaExplicit",
  ButtonNote->"DiracSigmaExplicit"],
 "."
}], "Text",
 CellTags->"DiracSigma"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracSigma"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{"DiracSigma", "[", 
   RowBox[{
    RowBox[{"GA", "[", "\[Alpha]", "]"}], ",", 
    RowBox[{"GA", "[", "\[Beta]", "]"}]}], "]"}]}]], "Input",
 CellTags->"DiracSigma",
 CellLabel->"In[427]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Sigma]", 
   RowBox[{"\[Alpha]", "\[Beta]"}]], TraditionalForm]], "Output",
 CellTags->"DiracSigma",
 CellLabel->"Out[427]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSigmaExplicit", "[", "t1", "]"}]], "Input",
 CellTags->"DiracSigma",
 CellLabel->"In[428]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Alpha]",
         TraditionalForm],
        TraditionalForm]], ".", 
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Beta]",
         TraditionalForm],
        TraditionalForm]]}], "-", 
     RowBox[{
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Beta]",
         TraditionalForm],
        TraditionalForm]], ".", 
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Alpha]",
         TraditionalForm],
        TraditionalForm]]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracSigma",
 CellLabel->"Out[428]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"DiracSigma", "[", 
   RowBox[{
    RowBox[{"GA", "[", "\[Beta]", "]"}], ",", 
    RowBox[{"GA", "[", "\[Alpha]", "]"}]}], "]"}]}]], "Input",
 CellTags->"DiracSigma",
 CellLabel->"In[429]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   SuperscriptBox["\[Sigma]", 
    RowBox[{"\[Alpha]", "\[Beta]"}]]}], TraditionalForm]], "Output",
 CellTags->"DiracSigma",
 CellLabel->"Out[429]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", "=", 
  RowBox[{"DiracSigma", "[", 
   RowBox[{
    RowBox[{"GS", "[", "p", "]"}], ",", 
    RowBox[{"GS", "[", "q", "]"}]}], "]"}]}]], "Input",
 CellTags->"DiracSigma",
 CellLabel->"In[430]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Sigma]", 
   RowBox[{"p", "q"}]], TraditionalForm]], "Output",
 CellTags->"DiracSigma",
 CellLabel->"Out[430]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSigmaExplicit", "[", "t3", "]"}]], "Input",
 CellTags->"DiracSigma",
 CellLabel->"In[431]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
         TraditionalForm], "\[CenterDot]", 
        FormBox["p",
         TraditionalForm]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
         TraditionalForm], "\[CenterDot]", 
        FormBox["p",
         TraditionalForm]}], ")"}]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracSigma",
 CellLabel->"Out[431]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"t1", ",", "t2", ",", "t3"}], "]"}]], "Input",
 CellTags->"DiracSigma",
 CellLabel->"In[432]:="]
}, Open  ]],

Cell["DiracSigmaExplicit", "ObjectName",
 CellTags->"DiracSigmaExplicit"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracSigmaExplicit"],

Cell["\<\
DiracSigmaExplicit[exp] inserts in exp for all DiracSigma its definition. \
DiracSigmaExplict is also an option of DiracSimplify.\
\>", "Text",
 CellTags->"DiracSigmaExplicit"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracSigma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSigma",
  ButtonNote->"DiracSigma"],
 "."
}], "Text",
 CellTags->"DiracSigmaExplicit"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracSigmaExplicit"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSigma", "[", 
  RowBox[{
   RowBox[{"GA", "[", "\[Alpha]", "]"}], ",", 
   RowBox[{"GA", "[", "\[Beta]", "]"}]}], "]"}]], "Input",
 CellTags->"DiracSigmaExplicit",
 CellLabel->"In[433]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Sigma]", 
   RowBox[{"\[Alpha]", "\[Beta]"}]], TraditionalForm]], "Output",
 CellTags->"DiracSigmaExplicit",
 CellLabel->"Out[433]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSigmaExplicit", "[", "%", "]"}]], "Input",
 CellTags->"DiracSigmaExplicit",
 CellLabel->"In[434]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Alpha]",
         TraditionalForm],
        TraditionalForm]], ".", 
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Beta]",
         TraditionalForm],
        TraditionalForm]]}], "-", 
     RowBox[{
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Beta]",
         TraditionalForm],
        TraditionalForm]], ".", 
      SuperscriptBox["\[Gamma]", 
       FormBox[
        FormBox["\[Alpha]",
         TraditionalForm],
        TraditionalForm]]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracSigmaExplicit",
 CellLabel->"Out[434]="]
}, Open  ]]
}, Open  ]],

Cell["DiracSimpCombine", "ObjectName",
 CellTags->"DiracSimpCombine"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracSimpCombine"],

Cell["\<\
DiracSimpCombine is an option for DiracSimplify. If set to True, sums of \
DiracGamma's will be merged as much as possible in DiracGamma[ .. + .. + ]'s.\
\
\>", "Text",
 CellTags->"DiracSimpCombine"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 "."
}], "Text",
 CellTags->"DiracSimpCombine"]
}, Open  ]],

Cell["DiracSimplify", "ObjectName",
 CellTags->"DiracSimplify"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracSimplify"],

Cell["\<\
DiracSimplify[expr] simplifies products of Dirac matrices in expr and expands \
non-commutative products. Double Lorentz indices and four vectors are \
contracted. The Dirac equation is applied. All DiracMatrix[5], DiracMatrix[6] \
and DiracMatrix[7] are moved to the right. The order of the other Dirac \
matrices is not changed.\
\>", "Text",
 CellTags->"DiracSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DiracSimplify", "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[435]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"DiracCanonical", "\[Rule]", "False"}], ",", 
    RowBox[{"DiracSigmaExplicit", "\[Rule]", "True"}], ",", 
    RowBox[{"DiracSimpCombine", "\[Rule]", "False"}], ",", 
    RowBox[{"DiracSubstitute67", "\[Rule]", "False"}], ",", 
    RowBox[{"Expanding", "\[Rule]", "True"}], ",", 
    RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
    RowBox[{"FeynCalcInternal", "\[Rule]", "False"}], ",", 
    RowBox[{"InsideDiracTrace", "\[Rule]", "False"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[435]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Calc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Calc",
  ButtonNote->"Calc"],
 ", ",
 ButtonBox["DiracGammaExpand",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGammaExpand",
  ButtonNote->"DiracGammaExpand"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 "."
}], "Text",
 CellTags->"DiracSimplify"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracSimplify"],

Cell["This is a string of Dirac matrices in four dimensions. ", "Text",
 CellTags->"DiracSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[436]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[436]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", "t1", "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[437]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[437]="]
}, Open  ]],

Cell["This is a string of Dirac matrices in D dimensions. ", "Text",
 CellTags->"DiracSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"GAD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[438]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[438]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", "t1", "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[439]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[439]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", "=", 
  RowBox[{"GA", "[", 
   RowBox[{"5", ",", "\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[440]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[440]="]
}, Open  ]],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 "is moved to the right."
}], "Text",
 CellTags->"DiracSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", "t3", "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[441]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", "5"]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[441]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t4", "=", 
  RowBox[{"GA", "[", 
   RowBox[{"6", ",", "\[Mu]", ",", "7"}], "]"}]}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[442]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "6"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[442]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", "t4", "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[443]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[443]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t5", "=", 
  RowBox[{
   RowBox[{"GS", "[", 
    RowBox[{"a", "+", "b"}], "]"}], " ", ".", " ", 
   RowBox[{"GS", "[", "p", "]"}], ".", 
   RowBox[{"GS", "[", "p", "]"}], ".", 
   RowBox[{"GS", "[", 
    RowBox[{"c", "+", "d"}], "]"}]}]}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[444]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"a", "+", "b"}],
      TraditionalForm], ")"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"c", "+", "d"}],
      TraditionalForm], ")"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[444]="]
}, Open  ]],

Cell["\<\
Contrary to DiracTrick DiracSimplify does non-commutative expansion.\
\>", "Text",
 CellTags->"DiracSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", "t5", "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[445]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["a",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["c",
        TraditionalForm]}], ")"}]}], " ", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["a",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["d",
        TraditionalForm]}], ")"}]}], " ", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["b",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["c",
        TraditionalForm]}], ")"}]}], " ", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["b",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["d",
        TraditionalForm]}], ")"}]}], " ", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"]}]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[445]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrick", "[", "t5", "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[446]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"a", "+", "b"}],
      TraditionalForm], ")"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"c", "+", "d"}],
      TraditionalForm], ")"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[446]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t6", " ", "=", " ", 
  RowBox[{
   RowBox[{"SpinorVBar", "[", "p", "]"}], " ", ".", " ", 
   RowBox[{"GS", "[", "p", "]"}], " ", ".", " ", 
   RowBox[{"SpinorUBar", "[", "q", "]"}]}]}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[447]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FormBox[
     OverscriptBox["\<\"v\"\>", "_"],
     TraditionalForm], "(", "p", ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
   RowBox[{
    FormBox[
     OverscriptBox["\<\"u\"\>", "_"],
     TraditionalForm], "(", "q", ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[447]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", "t6", "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[448]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[448]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GAD", "@@", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"{", "\[Mu]", "}"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["\[Nu]", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", "\[Mu]", "}"}]}], "]"}]}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[449]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "1"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "2"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "3"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "4"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "5"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "6"]], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[449]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", "%", "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[450]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"D", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}]}], "-", 
   RowBox[{"12", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "1"], 
      SubscriptBox["\[Nu]", "2"]}]]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "1"], 
      SubscriptBox["\[Nu]", "3"]}]]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "1"], 
      SubscriptBox["\[Nu]", "4"]}]]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "1"], 
      SubscriptBox["\[Nu]", "5"]}]]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "1"], 
      SubscriptBox["\[Nu]", "6"]}]]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "2"], 
      SubscriptBox["\[Nu]", "3"]}]]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "2"], 
      SubscriptBox["\[Nu]", "4"]}]]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "2"], 
      SubscriptBox["\[Nu]", "5"]}]]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "2"], 
      SubscriptBox["\[Nu]", "6"]}]]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "3"], 
      SubscriptBox["\[Nu]", "4"]}]]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "3"], 
      SubscriptBox["\[Nu]", "5"]}]]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "3"], 
      SubscriptBox["\[Nu]", "6"]}]]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "6"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "4"], 
      SubscriptBox["\[Nu]", "5"]}]]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "5"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "4"], 
      SubscriptBox["\[Nu]", "6"]}]]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "1"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "2"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "3"],
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox[
        SubscriptBox["\[Nu]", "4"],
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["\[Nu]", "5"], 
      SubscriptBox["\[Nu]", "6"]}]]}]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[450]="]
}, Open  ]],

Cell["\<\
 With the option DiracCanonical an alphabetic ordering is done.\
\>", "Text",
 CellTags->"DiracSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", 
  RowBox[{
   RowBox[{"GA", "[", 
    RowBox[{"\[Nu]", ",", "\[Mu]"}], "]"}], ",", 
   RowBox[{"DiracCanonical", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[451]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]]}]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[451]="]
}, Open  ]],

Cell["\<\
Setting InsideDiracTrace\[Rule]True assumes that a trace is still to be taken \
later on.\
\>", "Text",
 CellTags->"DiracSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", 
  RowBox[{
   RowBox[{"GA", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], "]"}], 
   ",", 
   RowBox[{"InsideDiracTrace", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[452]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[452]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify", "[", 
  RowBox[{
   RowBox[{"GA", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]"}], "]"}], ",", 
   RowBox[{"InsideDiracTrace", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[453]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"DiracSimplify",
 CellLabel->"Out[453]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"t1", ",", "t2", ",", "t3", ",", "t4", ",", "t5", ",", "t6"}], 
  "]"}]], "Input",
 CellTags->"DiracSimplify",
 CellLabel->"In[454]:="]
}, Open  ]],

Cell["DiracSimplify2", "ObjectName",
 CellTags->"DiracSimplify2"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracSimplify2"],

Cell[TextData[{
 "DiracSimplify2[exp] simplifies the Dirac structure but leaves any ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 " untouched."
}], "Text",
 CellTags->"DiracSimplify2"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 "."
}], "Text",
 CellTags->"DiracSimplify2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracSimplify2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GAD", "[", 
  RowBox[{
  "\[Mu]", ",", "\[Nu]", ",", "\[Mu]", ",", "5", ",", "\[Alpha]", ",", 
   "\[Beta]", ",", "\[Alpha]"}], "]"}]], "Input",
 CellTags->"DiracSimplify2",
 CellLabel->"In[455]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "5"], ".", 
   SuperscriptBox["\[Gamma]", "\[Alpha]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Beta]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Alpha]"]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify2",
 CellLabel->"Out[455]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSimplify2", "[", "%", "]"}]], "Input",
 CellTags->"DiracSimplify2",
 CellLabel->"In[456]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", "5"], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Alpha]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Beta]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Alpha]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"DiracSimplify2",
 CellLabel->"Out[456]="]
}, Open  ]]
}, Open  ]],

Cell["DiracSlash", "ObjectName",
 CellTags->"DiracSlash"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracSlash"],

Cell[TextData[{
 "DiracSlash[p] is the contraction ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["p", "\[Mu]"], 
    SubscriptBox["\[Gamma]", 
     RowBox[{"\[Mu]", " "}]]}], TraditionalForm]]],
 "(FourVector[p, ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "] DiracMatrix[",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "]). Products of those can be entered in the form DiracSlash[p1, p2, ...]."
}], "Text",
 CellTags->"DiracSlash"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DiracSlash", "]"}]], "Input",
 CellTags->"DiracSlash",
 CellLabel->"In[457]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dimension", "\[Rule]", "4"}], ",", 
    RowBox[{"FeynCalcInternal", "\[Rule]", "True"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"DiracSlash",
 CellLabel->"Out[457]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracGammaExpand",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGammaExpand",
  ButtonNote->"DiracGammaExpand"],
 ", ",
 ButtonBox["DiracGamma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGamma",
  ButtonNote->"DiracGamma"],
 ", ",
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix",
  ButtonNote->"DiracMatrix"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick",
  ButtonNote->"DiracTrick"],
 ", ",
 ButtonBox["GS",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GS",
  ButtonNote->"GS"],
 ", ",
 ButtonBox["GSD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GSD",
  ButtonNote->"GSD"],
 "."
}], "Text",
 CellTags->"DiracSlash"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracSlash"],

Cell[TextData[{
 "This is q-slash, i.e., ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], 
    RowBox[{
     SubscriptBox["q", "\[Mu]"], "."}]}], TraditionalForm]]]
}], "Text",
 CellTags->"DiracSlash"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSlash", "[", "q", "]"}]], "Input",
 CellTags->"DiracSlash",
 CellLabel->"In[458]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["\<\"\[Gamma]\"\>",
    TraditionalForm], "\[CenterDot]", 
   FormBox["q",
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"DiracSlash",
 CellLabel->"Out[458]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracSlash", "[", "p", "]"}], ".", 
  RowBox[{"DiracSlash", "[", "q", "]"}]}]], "Input",
 CellTags->"DiracSlash",
 CellLabel->"In[459]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracSlash",
 CellLabel->"Out[459]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracSlash", "[", 
  RowBox[{"p", ",", "q"}], "]"}]], "Input",
 CellTags->"DiracSlash",
 CellLabel->"In[460]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracSlash",
 CellLabel->"Out[460]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GS", "[", "p", "]"}]], "Input",
 CellTags->"DiracSlash",
 CellLabel->"In[461]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], TraditionalForm]], "Output",
 CellTags->"DiracSlash",
 CellLabel->"Out[461]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracSlash", "[", "q", "]"}], "//", "StandardForm"}]], "Input",
 CellTags->"DiracSlash",
 CellLabel->"In[462]:="],

Cell[BoxData[
 RowBox[{"DiracGamma", "[", 
  RowBox[{"Momentum", "[", "q", "]"}], "]"}]], "Output",
 CellTags->"DiracSlash",
 CellLabel->"Out[462]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracSlash", "[", 
   RowBox[{"q", ",", 
    RowBox[{"Dimension", "\[Rule]", "n"}]}], "]"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"DiracSlash",
 CellLabel->"In[463]:="],

Cell[BoxData[
 RowBox[{"DiracGamma", "[", 
  RowBox[{
   RowBox[{"Momentum", "[", 
    RowBox[{"q", ",", "n"}], "]"}], ",", "n"}], "]"}]], "Output",
 CellTags->"DiracSlash",
 CellLabel->"Out[463]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["DiracSpinor", "ObjectName",
 CellTags->"DiracSpinor"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracSpinor"],

Cell["\<\
DiracSpinor is simply a quantity defined as noncommutative (with \
DeclareNonCommutative[DiracSpinor]). The convention intended is that \
DiracSpinor[p, m, ind] is a Dirac spinor for a fermion with momentum p and \
mass m and indices ind.\
\>", "Text",
 CellTags->"DiracSpinor"],

Cell[TextData[{
 "See also: ",
 ButtonBox["Spinor",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Spinor",
  ButtonNote->"Spinor"],
 "."
}], "Text",
 CellTags->"DiracSpinor"]
}, Open  ]],

Cell["DiracSubstitute67", "ObjectName",
 CellTags->"DiracSubstitute67"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracSubstitute67"],

Cell["\<\
DiracSubstitute67 is an option for DiracSimplify. If set to True the \
chirality-projectors DiracGamma[6] and DiracGamma[7] are substituted by their \
definitions.\
\>", "Text",
 CellTags->"DiracSubstitute67"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DiracGamma",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGamma",
  ButtonNote->"DiracGamma"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 "."
}], "Text",
 CellTags->"DiracSubstitute67"]
}, Open  ]],

Cell["DiracTrace", "ObjectName",
 CellTags->"DiracTrace"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracTrace"],

Cell["\<\
DiracTrace[expr] is the head of Dirac traces. Whether the trace is evaluated \
depends on the option DiracTraceEvaluate. Direct trace evaluation should be \
performed with TR (or Tr). The argument expr may be a product of Dirac \
matrices or slashes separated by the Mathematica Dot (.).\
\>", "Text",
 CellTags->"DiracTrace"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DiracTrace", "]"}]], "Input",
 CellTags->"DiracTrace",
 CellLabel->"In[464]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EpsContract", "\[Rule]", "False"}], ",", 
    RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
    RowBox[{"FeynCalcExternal", "\[Rule]", "False"}], ",", 
    RowBox[{"Mandelstam", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"PairCollect", "\[Rule]", "True"}], ",", 
    RowBox[{"DiracTraceEvaluate", "\[Rule]", "False"}], ",", 
    RowBox[{"Schouten", "\[Rule]", "0"}], ",", 
    RowBox[{"LeviCivitaSign", "\[RuleDelayed]", "$LeviCivitaSign"}], ",", 
    RowBox[{"TraceOfOne", "\[Rule]", "4"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"DiracTrace",
 CellLabel->"Out[464]="]
}, Open  ]],

Cell[TextData[{
 "For comments regarding ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 "schemes see the notes for ",
 ButtonBox["TR",
  BaseStyle->"AddOnsLink",
  ButtonData:>"TR",
  ButtonNote->"TR"],
 "."
}], "Text",
 CellTags->"DiracTrace"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["TR",
  BaseStyle->"AddOnsLink",
  ButtonData:>"TR",
  ButtonNote->"TR"],
 "."
}], "Text",
 CellTags->"DiracTrace"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracTrace"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrace", "[", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}]], "Input",
 CellTags->"DiracTrace",
 CellLabel->"In[465]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"tr", "(", 
   FormBox[
    RowBox[{
     SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
     SuperscriptBox["\[Gamma]", "\[Nu]"]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"DiracTrace",
 CellLabel->"Out[465]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrace", "[", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], "]"}], 
  "]"}]], "Input",
 CellTags->"DiracTrace",
 CellLabel->"In[466]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"tr", "(", 
   FormBox[
    RowBox[{
     SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
     SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
     SuperscriptBox["\[Gamma]", "\[Rho]"], ".", 
     SuperscriptBox["\[Gamma]", "\[Sigma]"]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"DiracTrace",
 CellLabel->"Out[466]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "/.", " ", 
  RowBox[{"DiracTrace", "\[Rule]", "Tr"}]}]], "Input",
 CellTags->"DiracTrace",
 CellLabel->"In[467]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Sigma]"}]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellTags->"DiracTrace",
 CellLabel->"Out[467]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrace", "[", 
  RowBox[{
   RowBox[{"GA", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]", ",", "5"}],
     "]"}], ",", 
   RowBox[{"DiracTraceEvaluate", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"DiracTrace",
 CellLabel->"In[468]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[Epsilon]", 
    RowBox[{
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"DiracTrace",
 CellLabel->"Out[468]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrace", "[", 
  RowBox[{
   RowBox[{"GA", "[", 
    RowBox[{
    "\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]", ",", "\[Delta]", 
     ",", "\[Tau]", ",", "5"}], "]"}], ",", 
   RowBox[{"DiracTraceEvaluate", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"DiracTrace",
 CellLabel->"In[469]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Delta]", "\[Mu]"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Delta]", "\[Nu]"}]]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Delta]", "\[Rho]"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Delta]", "\[Sigma]"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Delta]", "\[Tau]"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Sigma]"}]]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Tau]"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Sigma]"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Tau]"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Tau]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Rho]", "\[Tau]"}]]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Epsilon]", 
       RowBox[{
        FormBox[
         FormBox["\[Delta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Sigma]", "\[Tau]"}]]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellTags->"DiracTrace",
 CellLabel->"Out[469]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrace", "[", 
  RowBox[{"GS", "[", 
   RowBox[{"p", ",", "q", ",", "r", ",", "s"}], "]"}], "]"}]], "Input",
 CellTags->"DiracTrace",
 CellLabel->"In[470]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"tr", "(", 
   FormBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{"\[Gamma]", "\[CenterDot]", "q"}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{"\[Gamma]", "\[CenterDot]", "r"}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{"\[Gamma]", "\[CenterDot]", "s"}], ")"}]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"DiracTrace",
 CellLabel->"Out[470]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrace", "[", 
  RowBox[{
   RowBox[{"GA", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], ",", 
   RowBox[{"DiracTraceEvaluate", "\[Rule]", "True"}], ",", 
   RowBox[{"FCE", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"DiracTrace",
 CellLabel->"In[471]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", 
   SuperscriptBox["g", 
    RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output",
 CellTags->"DiracTrace",
 CellLabel->"Out[471]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"DiracTrace",
 CellLabel->"In[472]:="],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{"MT", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Output",
 CellTags->"DiracTrace",
 CellLabel->"Out[472]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["DiracTraceEvaluate", "ObjectName",
 CellTags->"DiracTraceEvaluate"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracTraceEvaluate"],

Cell["\<\
DiracTraceEvaluate is an option for DiracTrace and Tr. If set to False, \
DiracTrace remains unevaluated.\
\>", "Text",
 CellTags->"DiracTraceEvaluate"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DiracTrace",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrace",
  ButtonNote->"DiracTrace"],
 ", ",
 ButtonBox["TR",
  BaseStyle->"AddOnsLink",
  ButtonData:>"TR",
  ButtonNote->"TR"],
 "."
}], "Text",
 CellTags->"DiracTraceEvaluate"]
}, Open  ]],

Cell["DiracTrick", "ObjectName",
 CellTags->"DiracTrick"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DiracTrick"],

Cell["\<\
DiracTrick[exp] contracts gamma matrices with each other and performs several \
simplifications, but no expansion, use Calc or DiracSimplify for \
non-commutative expansion.\
\>", "Text",
 CellTags->"DiracTrick"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DiracTrick", "]"}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[473]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"Expanding", "\[Rule]", "False"}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[473]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Calc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Calc",
  ButtonNote->"Calc"],
 ", ",
 ButtonBox["DiracGammaExpand",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracGammaExpand",
  ButtonNote->"DiracGammaExpand"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 "."
}], "Text",
 CellTags->"DiracTrick"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DiracTrick"],

Cell["This is a string of Dirac matrices in four dimensions. ", "Text",
 CellTags->"DiracTrick"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[474]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[474]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrick", "[", "t1", "]"}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[475]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[475]="]
}, Open  ]],

Cell["This is a string of Dirac matrices in D dimensions. ", "Text",
 CellTags->"DiracTrick"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"GAD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[476]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[476]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrick", "[", "t2", "]"}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[477]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[477]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", "=", 
  RowBox[{"GA", "[", 
   RowBox[{"5", ",", "\[Mu]", ",", "\[Nu]"}], "]"}]}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[478]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[478]="]
}, Open  ]],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 "is moved to the right."
}], "Text",
 CellTags->"DiracTrick"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrick", "[", "t3", "]"}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[479]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "5"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[479]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t4", "=", 
  RowBox[{"GA", "[", 
   RowBox[{"6", ",", "\[Mu]", ",", "7"}], "]"}]}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[480]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "6"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[480]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrick", "[", "t4", "]"}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[481]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "6"], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "7"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[481]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t5", "=", 
  RowBox[{
   RowBox[{"GS", "[", 
    RowBox[{"a", "+", "b"}], "]"}], " ", ".", " ", 
   RowBox[{"GS", "[", "p", "]"}], ".", 
   RowBox[{"GS", "[", "p", "]"}], ".", 
   RowBox[{"GS", "[", 
    RowBox[{"c", "+", "d"}], "]"}]}]}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[482]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"a", "+", "b"}],
      TraditionalForm], ")"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"c", "+", "d"}],
      TraditionalForm], ")"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[482]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrick", "[", "t5", "]"}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[483]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"a", "+", "b"}],
      TraditionalForm], ")"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ")"}], ".", 
   RowBox[{"(", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
     FormBox[
      RowBox[{"c", "+", "d"}],
      TraditionalForm], ")"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[483]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", "t5", "]"}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[484]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["a",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["c",
        TraditionalForm]}], ")"}]}], " ", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["a",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["d",
        TraditionalForm]}], ")"}]}], " ", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["b",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["c",
        TraditionalForm]}], ")"}]}], " ", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["b",
        TraditionalForm]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["d",
        TraditionalForm]}], ")"}]}], " ", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], "2"]}]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[484]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GAD", "@@", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"{", "\[Mu]", "}"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      SubscriptBox["\[Nu]", "i"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "6"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", "\[Mu]", "}"}]}], "]"}]}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[485]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "1"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "2"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "3"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "4"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "5"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "6"]], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[485]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrick", "[", "%", "]"}]], "Input",
 CellTags->"DiracTrick",
 CellLabel->"In[486]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "1"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "2"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "3"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "4"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "5"]], ".", 
   SuperscriptBox["\[Gamma]", 
    SubscriptBox["\[Nu]", "6"]], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"]}], TraditionalForm]], "Output",
 CellTags->"DiracTrick",
 CellLabel->"Out[486]="]
}, Open  ]]
}, Open  ]],

Cell["Divideout", "ObjectName",
 CellTags->"Divideout"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Divideout"],

Cell["\<\
Divideout is an option for OPEInt and OPEInsert. The setting is divided out \
at the end.\
\>", "Text",
 CellTags->"Divideout"],

Cell[TextData[{
 "See also: ",
 ButtonBox["OPEInt",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OPEInt",
  ButtonNote->"OPEInt"],
 ", ",
 ButtonBox["OPEInsert",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OPEInsert",
  ButtonNote->"OPEInsert"],
 "."
}], "Text",
 CellTags->"Divideout"]
}, Open  ]],

Cell["DOT", "ObjectName",
 CellTags->"DOT"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DOT"],

Cell["\<\
DOT[a, b, ...] is the FeynCalc function for non-commutative multiplication. \
By default it is set to the Mathematica Dot functions. By setting
DOT=.
this can be disabled. Note that then non-commutative products should to be \
entered like DOT[ DiracMatrix[mu], m + DiracSlash[p], DiracMatrix[mu] ], etc.\
\
\>", "Text",
 CellTags->"DOT"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DotSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DotSimplify",
  ButtonNote->"DotSimplify"],
 "."
}], "Text",
 CellTags->"DOT"]
}, Open  ]],

Cell["DotExpand", "ObjectName",
 CellTags->"DotExpand"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DotExpand"],

Cell["DotExpand[expr] expands DOT products in expr.", "Text",
 CellTags->"DotExpand"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DOT",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DOT",
  ButtonNote->"DOT"],
 ", ",
 ButtonBox["DotSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DotSimplify",
  ButtonNote->"DotSimplify"],
 ", ",
 ButtonBox["DeclareNonCommutative",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DeclareNonCommutative",
  ButtonNote->"DeclareNonCommutative"],
 ", ",
 ButtonBox["UnDeclareNonCommutative",
  BaseStyle->"AddOnsLink",
  ButtonData:>"UnDeclareNonCommutative",
  ButtonNote->"UnDeclareNonCommutative"],
 "."
}], "Text",
 CellTags->"DotExpand"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DotExpand"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotExpand", "[", 
  RowBox[{"DOT", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"b", " ", "y"}], "+", 
     RowBox[{"c", " ", "z"}]}], ",", 
    RowBox[{"d", "+", "e", "+", "f"}]}], "]"}], "]"}]], "Input",
 CellTags->"DotExpand",
 CellLabel->"In[487]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", " ", "d", " ", "x"}], "+", 
   RowBox[{"a", " ", "e", " ", "x"}], "+", 
   RowBox[{"a", " ", "f", " ", "x"}], "+", 
   RowBox[{"b", " ", "d", " ", "y"}], "+", 
   RowBox[{"b", " ", "e", " ", "y"}], "+", 
   RowBox[{"b", " ", "f", " ", "y"}], "+", 
   RowBox[{"c", " ", "d", " ", "z"}], "+", 
   RowBox[{"c", " ", "e", " ", "z"}], "+", 
   RowBox[{"c", " ", "f", " ", "z"}]}], TraditionalForm]], "Output",
 CellTags->"DotExpand",
 CellLabel->"Out[487]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DeclareNonCommutative", "/@", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  ";"}]], "Input",
 CellTags->"DotExpand",
 CellLabel->"In[488]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotExpand", "[", 
  RowBox[{"DOT", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"b", " ", "y"}], "+", 
     RowBox[{"c", " ", "z"}]}], ",", 
    RowBox[{"d", "+", "e", "+", "f"}]}], "]"}], "]"}]], "Input",
 CellTags->"DotExpand",
 CellLabel->"In[489]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"a", ".", "d"}]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"a", ".", "e"}]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"a", ".", "f"}]}], "+", 
   RowBox[{"y", " ", 
    RowBox[{"b", ".", "d"}]}], "+", 
   RowBox[{"y", " ", 
    RowBox[{"b", ".", "e"}]}], "+", 
   RowBox[{"y", " ", 
    RowBox[{"b", ".", "f"}]}], "+", 
   RowBox[{"z", " ", 
    RowBox[{"c", ".", "d"}]}], "+", 
   RowBox[{"z", " ", 
    RowBox[{"c", ".", "e"}]}], "+", 
   RowBox[{"z", " ", 
    RowBox[{"c", ".", "f"}]}]}], TraditionalForm]], "Output",
 CellTags->"DotExpand",
 CellLabel->"Out[489]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnDeclareNonCommutative", "/@", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  ";"}]], "Input",
 CellTags->"DotExpand",
 CellLabel->"In[490]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotExpand", "[", 
  RowBox[{"DOT", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"b", " ", "y"}], "+", 
     RowBox[{"c", " ", "z"}]}], ",", 
    RowBox[{"d", "+", "e", "+", "f"}]}], "]"}], "]"}]], "Input",
 CellTags->"DotExpand",
 CellLabel->"In[491]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", " ", "d", " ", "x"}], "+", 
   RowBox[{"a", " ", "e", " ", "x"}], "+", 
   RowBox[{"a", " ", "f", " ", "x"}], "+", 
   RowBox[{"b", " ", "d", " ", "y"}], "+", 
   RowBox[{"b", " ", "e", " ", "y"}], "+", 
   RowBox[{"b", " ", "f", " ", "y"}], "+", 
   RowBox[{"c", " ", "d", " ", "z"}], "+", 
   RowBox[{"c", " ", "e", " ", "z"}], "+", 
   RowBox[{"c", " ", "f", " ", "z"}]}], TraditionalForm]], "Output",
 CellTags->"DotExpand",
 CellLabel->"Out[491]="]
}, Open  ]]
}, Open  ]],

Cell["DotPower", "ObjectName",
 CellTags->"DotPower"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DotPower"],

Cell["\<\
DotPower is an option for DotSimplify. It determines whether non-commutative \
powers are represented by succesive multiplication or by Power.\
\>", "Text",
 CellTags->"DotPower"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DotSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DotSimplify",
  ButtonNote->"DotSimplify"],
 "."
}], "Text",
 CellTags->"DotPower"]
}, Open  ]],

Cell["DotProduct", "ObjectName",
 CellTags->"DotProduct"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DotProduct"],

Cell["\<\
DotProduct[x, y] denotes the three-dimensional dot-product. If x and y have \
Head List, DotProduct[x, a] (where a is a vector) performs Sum[ x[[k]] \
a[[k]], {k, 0, 3}].\
\>", "Text",
 CellTags->"DotProduct"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["CrossProduct",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CrossProduct",
  ButtonNote->"CrossProduct"],
 ", ",
 ButtonBox["ThreeVector",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ThreeVector",
  ButtonNote->"ThreeVector"],
 "."
}], "Text",
 CellTags->"DotProduct"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DotProduct"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotProduct", "[", 
  RowBox[{
   RowBox[{"ThreeVector", "[", "a", "]"}], ",", 
   RowBox[{"3", 
    RowBox[{"ThreeVector", "[", "b", "]"}]}]}], "]"}]], "Input",
 CellTags->"DotProduct",
 CellLabel->"In[492]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"3", " ", 
   RowBox[{
    FormBox[
     OverscriptBox["a", "\[RightVector]"],
     TraditionalForm], "\[CenterDot]", 
    FormBox[
     OverscriptBox["b", "\[RightVector]"],
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellTags->"DotProduct",
 CellLabel->"Out[492]="]
}, Open  ]]
}, Open  ]],

Cell["DotSimplifyRelations", "ObjectName",
 CellTags->"DotSimplifyRelations"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DotSimplifyRelations"],

Cell["\<\
DotSimplifyRelations is an option for DotSimplify. Its setting may be a list \
of substitution rules of the form DotSimplifyRelations \[Rule] {a . b \[Rule] \
c, b^2 \[Rule] 0, ...}.\
\>", "Text",
 CellTags->"DotSimplifyRelations"],

Cell[TextData[{
 "See also: ",
 ButtonBox["DotSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DotSimplify",
  ButtonNote->"DotSimplify"],
 "."
}], "Text",
 CellTags->"DotSimplifyRelations"]
}, Open  ]],

Cell["DotSimplify", "ObjectName",
 CellTags->"DotSimplify"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DotSimplify"],

Cell["\<\
DotSimplify[expr] expands and reorders noncommutative terms in expr. \
Simplifying relations may be specified by the option DotSimplifyRelations or \
by Commutator and AntiCommutator definitions. Whether expr is expanded \
noncommutatively depends on the option Expanding.\
\>", "Text",
 CellTags->"DotSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DotSimplify", "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[493]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Expanding", "\[Rule]", "True"}], ",", 
    RowBox[{"DotSimplifyRelations", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"DotPower", "\[Rule]", "False"}], ",", 
    RowBox[{"FeynCalcInternal", "\[Rule]", "True"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[493]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["AntiCommutator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"AntiCommutator",
  ButtonNote->"AntiCommutator"],
 ", ",
 ButtonBox["Commutator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Commutator",
  ButtonNote->"Commutator"],
 ", ",
 ButtonBox["Calc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Calc",
  ButtonNote->"Calc"],
 "."
}], "Text",
 CellTags->"DotSimplify"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"DotSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ".", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"GS", "[", "p", "]"}]}], "-", 
     RowBox[{"GS", "[", "q", "]"}]}], ")"}], ".", 
   RowBox[{"GA", "[", "\[Nu]", "]"}]}]}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[494]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"\[Gamma]", "\[CenterDot]", "p"}]}], "-", 
     RowBox[{"\[Gamma]", "\[CenterDot]", "q"}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"]}], TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[494]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", "t1", "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[495]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p",
        TraditionalForm]}], ")"}], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]]}]}], "-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}], ")"}], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]]}]}], TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[495]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DeclareNonCommutative", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[496]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"a", ".", 
   RowBox[{"(", 
    RowBox[{"b", "-", 
     RowBox[{"z", " ", "c"}]}], ")"}], ".", "a"}]}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[497]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"a", ".", 
   RowBox[{"(", 
    RowBox[{"b", "-", 
     RowBox[{"c", " ", "z"}]}], ")"}], ".", "a"}], TraditionalForm]], "Output",\

 CellTags->"DotSimplify",
 CellLabel->"Out[497]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", "t2", "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[498]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "b", ".", "a"}], "-", 
   RowBox[{"z", " ", 
    RowBox[{"a", ".", "c", ".", "a"}]}]}], TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[498]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Commutator", "[", 
   RowBox[{"a", ",", "c"}], "]"}], "=", "1"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[499]:="],

Cell[BoxData[
 FormBox["1", TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[499]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", "t2", "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[500]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "b", ".", "a"}], "-", 
   RowBox[{"z", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"c", ".", "a", ".", "a"}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[500]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Commutator", "[", 
   RowBox[{"a", ",", "c"}], "]"}], "=", "."}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[501]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", "t2", "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[502]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "b", ".", "a"}], "-", 
   RowBox[{"z", " ", 
    RowBox[{"a", ".", "c", ".", "a"}]}]}], TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[502]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AntiCommutator", "[", 
   RowBox[{"b", ",", "a"}], "]"}], "=", "c"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[503]:="],

Cell[BoxData[
 FormBox["c", TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[503]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", "t2", "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[504]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "c"}], "-", 
   RowBox[{"a", ".", "a", ".", "b"}], "-", 
   RowBox[{"z", " ", 
    RowBox[{"a", ".", "c", ".", "a"}]}]}], TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[504]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"AntiCommutator", "[", 
   RowBox[{"b", ",", "a"}], "]"}], "=", "."}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[505]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", 
  RowBox[{"t2", ",", 
   RowBox[{"DotSimplifyRelations", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", ".", "c"}], "\[Rule]", 
      RowBox[{"1", "/", "z"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[506]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"a", ".", "b", ".", "a"}], "-", "a"}], TraditionalForm]], "Output",\

 CellTags->"DotSimplify",
 CellLabel->"Out[506]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DeclareNonCommutative", "[", "x", "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[507]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", 
  RowBox[{"x", ".", "x", ".", "x"}], "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[508]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"x", ".", "x", ".", "x"}], TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[508]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DotSimplify", "[", 
  RowBox[{
   RowBox[{"x", ".", "x", ".", "x"}], ",", 
   RowBox[{"DotPower", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[509]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"x", ".", "x", ".", "x"}], TraditionalForm]], "Output",
 CellTags->"DotSimplify",
 CellLabel->"Out[509]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"UnDeclareNonCommutative", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}]], "Input",
 CellTags->"DotSimplify",
 CellLabel->"In[510]:="]
}, Open  ]],

Cell["DummyIndex", "ObjectName",
 CellTags->"DummyIndex"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"DummyIndex"],

Cell["\<\
DummyIndex is an option of CovariantD specifying an index to use as dummy \
summation index. If set to Automatic, unique indices are generated\
\>", "Text",
 CellTags->"DummyIndex"],

Cell[TextData[{
 "See also: ",
 ButtonBox["CovariantD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CovariantD",
  ButtonNote->"CovariantD"],
 "."
}], "Text",
 CellTags->"DummyIndex"]
}, Open  ]],

Cell["D0", "ObjectName",
 CellTags->"D0"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"D0"],

Cell[TextData[{
 "D0[ p10, p12, p23, p30, p20, p13, m1^2, m2^2, m3^2, m4^2 ] is the \
Passarino-Veltman ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", "0"], TraditionalForm]]],
 " function. The convention for the arguments is that if the denominator of \
the integrand has the form ([q^2-m1^2] [(q+p1)^2-m2^2] [(q+p2)^2-m3^2] \
[(q+p3)^2-m4^2] ), the first six arguments of D0 are the scalar products p10 \
= p1^2, p12 = (p1-p2)^2, p23 = (p2-p3)^2, p30 = p3^2, p20 = p2^2, p13 = \
(p1-p3)^2."
}], "Text",
 CellTags->"D0"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["B0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"B0",
  ButtonNote->"B0"],
 ", ",
 ButtonBox["C0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"C0",
  ButtonNote->"C0"],
 ", ",
 ButtonBox["PaVe",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVe",
  ButtonNote->"PaVe"],
 ", ",
 ButtonBox["PaVeOrder",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVeOrder",
  ButtonNote->"PaVeOrder"],
 "."
}], "Text",
 CellTags->"D0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"D0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D0", "[", 
  RowBox[{
  "p10", ",", "p12", ",", "p23", ",", "p30", ",", "p20", ",", "p13", ",", 
   RowBox[{"m1", "^", "2"}], ",", 
   RowBox[{"m2", "^", "2"}], ",", 
   RowBox[{"m3", "^", "2"}], ",", 
   RowBox[{"m4", "^", "2"}]}], "]"}]], "Input",
 CellTags->"D0",
 CellLabel->"In[511]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\<\"D\"\>", "\<\"0\"\>"],
    TraditionalForm], "(", "p10", ",", "p12", ",", "p23", ",", "p30", ",", 
   "p20", ",", "p13", ",", 
   FormBox[
    SuperscriptBox["m1", "2"],
    TraditionalForm], ",", 
   FormBox[
    SuperscriptBox["m2", "2"],
    TraditionalForm], ",", 
   FormBox[
    SuperscriptBox["m3", "2"],
    TraditionalForm], ",", 
   FormBox[
    SuperscriptBox["m4", "2"],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"D0",
 CellLabel->"Out[511]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaVeOrder", "[", 
  RowBox[{
   RowBox[{"D0", "[", 
    RowBox[{
    "p10", ",", "p12", ",", "p23", ",", "p30", ",", "p20", ",", "p13", ",", 
     RowBox[{"m1", "^", "2"}], ",", 
     RowBox[{"m2", "^", "2"}], ",", 
     RowBox[{"m3", "^", "2"}], ",", 
     RowBox[{"m4", "^", "2"}]}], "]"}], ",", 
   RowBox[{"PaVeOrderList", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"p13", ",", "p20"}], "}"}]}]}], "]"}]], "Input",
 CellTags->"D0",
 CellLabel->"In[512]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\<\"D\"\>", "\<\"0\"\>"],
    TraditionalForm], "(", "p10", ",", "p30", ",", "p23", ",", "p12", ",", 
   "p13", ",", "p20", ",", 
   FormBox[
    SuperscriptBox["m2", "2"],
    TraditionalForm], ",", 
   FormBox[
    SuperscriptBox["m1", "2"],
    TraditionalForm], ",", 
   FormBox[
    SuperscriptBox["m4", "2"],
    TraditionalForm], ",", 
   FormBox[
    SuperscriptBox["m3", "2"],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"D0",
 CellLabel->"Out[512]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaVeOrder", "[", "%", "]"}]], "Input",
 CellTags->"D0",
 CellLabel->"In[513]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    SubscriptBox["\<\"D\"\>", "\<\"0\"\>"],
    TraditionalForm], "(", "p10", ",", "p12", ",", "p23", ",", "p30", ",", 
   "p20", ",", "p13", ",", 
   FormBox[
    SuperscriptBox["m1", "2"],
    TraditionalForm], ",", 
   FormBox[
    SuperscriptBox["m2", "2"],
    TraditionalForm], ",", 
   FormBox[
    SuperscriptBox["m3", "2"],
    TraditionalForm], ",", 
   FormBox[
    SuperscriptBox["m4", "2"],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"D0",
 CellLabel->"Out[513]="]
}, Open  ]]
}, Open  ]],

Cell["D0Convention", "ObjectName",
 CellTags->"D0Convention"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"D0Convention"],

Cell["\<\
D0Convention is an option for Write2. If set to 1, the convention for the \
arguments of D0 is changed when writing a Fortran file with Write2: The fifth \
and sixth argument of D0 are interchanged and the square root is taken of the \
last four arguments.\
\>", "Text",
 CellTags->"D0Convention"],

Cell[TextData[{
 "See also: ",
 ButtonBox["D0",
  BaseStyle->"AddOnsLink",
  ButtonData:>"D0",
  ButtonNote->"D0"],
 ", ",
 ButtonBox["Write2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Write2",
  ButtonNote->"Write2"],
 "."
}], "Text",
 CellTags->"D0Convention"]
}, Open  ]],

Cell["Eps", "ObjectName",
 CellTags->"Eps"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Eps"],

Cell[TextData[{
 "Eps[a, b, c, d] is the head of the totally antisymmetric ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "\[Epsilon]"}], TraditionalForm]]],
 " (Levi-Civita) tensor. The a,b, ... may have head LorentzIndex, Momentum or \
Integer. In case of integers the Levi-Civita tensor is evaluated immediately. \
"
}], "Text",
 CellTags->"Eps"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Eps", "]"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[514]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"Dimension", "\[Rule]", "4"}], "}"}], TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[514]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["EpsEvaluate",
  BaseStyle->"AddOnsLink",
  ButtonData:>"EpsEvaluate",
  ButtonNote->"EpsEvaluate"],
 ", ",
 ButtonBox["LC",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LC",
  ButtonNote->"LC"],
 ", ",
 ButtonBox["LCD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LCD",
  ButtonNote->"LCD"],
 ", ",
 ButtonBox["LeviCivita",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LeviCivita",
  ButtonNote->"LeviCivita"],
 "."
}], "Text",
 CellTags->"Eps"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Eps"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eps", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}], ",", 
   RowBox[{"LorentzIndex", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"LorentzIndex", "[", "\[Sigma]", "]"}]}], "]"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[515]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[515]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eps", "[", 
  RowBox[{
   RowBox[{"Momentum", "[", "p", "]"}], ",", 
   RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}], ",", 
   RowBox[{"LorentzIndex", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"LorentzIndex", "[", "\[Sigma]", "]"}]}], "]"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[516]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox["p",
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[516]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eps", "[", 
   RowBox[{"b", ",", "a", ",", "c", ",", "d"}], "]"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[517]:="],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Eps", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]}]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[517]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eps", "[", 
  RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "]"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[518]:="],

Cell[BoxData[
 FormBox["1", TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[518]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eps", "[", 
  RowBox[{"1", ",", "0", ",", "2", ",", "3"}], "]"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[519]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", "1"}], TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[519]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Eps", ",", 
    RowBox[{"Dimension", "\[Rule]", "4"}]}], "]"}], ";"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[520]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a1", " ", "=", 
  RowBox[{"Eps", "[", 
   RowBox[{
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Nu]", ",", "D"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Sigma]", ",", "D"}], "]"}]}], "]"}]}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[521]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[521]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", "a1a1", "]"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[522]:="],

Cell[BoxData[
 FormBox["a1a1", TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[522]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Eps", ",", 
    RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], ";"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[523]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a2", " ", "=", 
  RowBox[{"Eps", "[", 
   RowBox[{
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Nu]", ",", "D"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Sigma]", ",", "D"}], "]"}]}], "]"}]}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[524]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[524]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Contract", "[", "a2a2", "]"}], "//", "Factor2"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[525]:="],

Cell[BoxData[
 FormBox["a2a2", TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[525]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"LCD", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Alpha]"}], "]"}], 
   ".", 
   RowBox[{"GAD", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Alpha]"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[526]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", 
    RowBox[{"\[Mu]", "\[Nu]", "\[Rho]", "\[Alpha]"}]], ".", 
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Rho]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Alpha]"]}], TraditionalForm]], "Output",
 CellLabel->"Out[526]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FCI"}]], "Input",
 CellLabel->"In[527]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Epsilon]", 
    RowBox[{
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm]}]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Alpha]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellLabel->"Out[527]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g5", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[ImaginaryI]", "24"]}], 
    RowBox[{
     RowBox[{"LCD", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Alpha]"}], "]"}], 
     ".", 
     RowBox[{"GAD", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Alpha]"}], 
      "]"}]}]}], "//", "FCI"}]}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[528]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "24"]}], " ", "\[ImaginaryI]", " ", 
   RowBox[{
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Alpha]",
        TraditionalForm],
       TraditionalForm]}]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm]]}]}], TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[528]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g5p", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[ImaginaryI]", "24"]}], " ", 
    RowBox[{
     RowBox[{"LCD", "[", 
      RowBox[{
       SuperscriptBox["\[Mu]", "\[Prime]",
        MultilineFunction->None], ",", 
       SuperscriptBox["\[Nu]", "\[Prime]",
        MultilineFunction->None], ",", 
       SuperscriptBox["\[Rho]", "\[Prime]",
        MultilineFunction->None], ",", 
       SuperscriptBox["\[Alpha]", "\[Prime]",
        MultilineFunction->None]}], "]"}], ".", 
     RowBox[{"GAD", "[", 
      RowBox[{
       SuperscriptBox["\[Mu]", "\[Prime]",
        MultilineFunction->None], ",", 
       SuperscriptBox["\[Nu]", "\[Prime]",
        MultilineFunction->None], ",", 
       SuperscriptBox["\[Rho]", "\[Prime]",
        MultilineFunction->None], ",", 
       SuperscriptBox["\[Alpha]", "\[Prime]",
        MultilineFunction->None]}], "]"}]}]}], "//", "FCI"}]}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[529]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "24"]}], " ", "\[ImaginaryI]", " ", 
   RowBox[{
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox[
        SuperscriptBox["\[Mu]", "\[Prime]",
         MultilineFunction->None],
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox[
        SuperscriptBox["\[Nu]", "\[Prime]",
         MultilineFunction->None],
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox[
        SuperscriptBox["\[Rho]", "\[Prime]",
         MultilineFunction->None],
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox[
        SuperscriptBox["\[Alpha]", "\[Prime]",
         MultilineFunction->None],
        TraditionalForm],
       TraditionalForm]}]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox[
       SuperscriptBox["\[Mu]", "\[Prime]",
        MultilineFunction->None],
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox[
       SuperscriptBox["\[Nu]", "\[Prime]",
        MultilineFunction->None],
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox[
       SuperscriptBox["\[Rho]", "\[Prime]",
        MultilineFunction->None],
       TraditionalForm],
      TraditionalForm]], ".", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox[
       SuperscriptBox["\[Alpha]", "\[Prime]",
        MultilineFunction->None],
       TraditionalForm],
      TraditionalForm]]}]}], TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[529]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g52", "=", 
  RowBox[{"Factor2", "[", 
   RowBox[{"Calc", "[", 
    RowBox[{"g5", ".", "g5p"}], "]"}], "]"}]}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[530]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "24"]}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "D"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "-", "D"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"3", "-", "D"}], ")"}], " ", "D"}], TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[530]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g52", "/.", 
  RowBox[{"D", "\[Rule]", "4"}]}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[531]:="],

Cell[BoxData[
 FormBox["1", TraditionalForm]], "Output",
 CellTags->"Eps",
 CellLabel->"Out[531]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"a1", ",", "a2", ",", "g5", ",", "g5p", ",", "g52"}], 
  "]"}]], "Input",
 CellTags->"Eps",
 CellLabel->"In[532]:="]
}, Open  ]],

Cell["EpsChisholm", "ObjectName",
 CellTags->"EpsChisholm"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"EpsChisholm"],

Cell["\<\
EpsChisholm[expr] substitutes for a gamma matrix contracted with a \
Levi-Civita tensor (Eps) the Chisholm identity.\
\>", "Text",
 CellTags->"EpsChisholm"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Chisholm",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Chisholm",
  ButtonNote->"Chisholm"],
 "."
}], "Text",
 CellTags->"EpsChisholm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"EpsChisholm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chisholm", "[", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], "]"}], 
  "]"}]], "Input",
 CellTags->"EpsChisholm",
 CellLabel->"In[533]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["$MU$1275",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", "5"]}], " ", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["$MU$1275",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}], "-", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Rho]"}]]}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], ".", 
     SuperscriptBox["\[Gamma]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Rho]"}]]}]}], TraditionalForm]], "Output",
 CellTags->"EpsChisholm",
 CellLabel->"Out[533]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EpsChisholm", "[", "%", "]"}]], "Input",
 CellTags->"EpsChisholm",
 CellLabel->"In[534]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"EpsChisholm",
 CellLabel->"Out[534]="]
}, Open  ]]
}, Open  ]],

Cell["EpsContract", "ObjectName",
 CellTags->"EpsContract"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"EpsContract"],

Cell["\<\
EpsContract is an option of Contract specifying whether Levi-Civita tensors \
Eps[...] will be contracted, i.e., products of two  Eps are replaced via the \
determinant formula.\
\>", "Text",
 CellTags->"EpsContract"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Eps",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Eps",
  ButtonNote->"Eps"],
 ", ",
 ButtonBox["Contract",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Contract",
  ButtonNote->"Contract"],
 "."
}], "Text",
 CellTags->"EpsContract"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"EpsContract"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a1", " ", "=", 
  RowBox[{"Eps", "[", 
   RowBox[{
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Nu]", ",", "D"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", 
    RowBox[{"LorentzIndex", "[", 
     RowBox[{"\[Sigma]", ",", "D"}], "]"}]}], "]"}]}]], "Input",
 CellTags->"EpsContract",
 CellLabel->"In[535]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"EpsContract",
 CellLabel->"Out[535]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", 
  RowBox[{
   RowBox[{"a1", " ", "a1"}], ",", 
   RowBox[{"EpsContract", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellTags->"EpsContract",
 CellLabel->"In[536]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}]], ")"}], "2"], TraditionalForm]], "Output",
 CellTags->"EpsContract",
 CellLabel->"Out[536]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contract", "[", 
  RowBox[{
   RowBox[{"a1", " ", "a1"}], ",", 
   RowBox[{"EpsContract", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"EpsContract",
 CellLabel->"In[537]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["D", "4"]}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox["D", "3"]}], "-", 
   RowBox[{"11", " ", 
    SuperscriptBox["D", "2"]}], "+", 
   RowBox[{"6", " ", "D"}]}], TraditionalForm]], "Output",
 CellTags->"EpsContract",
 CellLabel->"Out[537]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "a1", "]"}]], "Input",
 CellLabel->"In[538]:="]
}, Open  ]],

Cell["EpsDiscard", "ObjectName",
 CellTags->"EpsDiscard"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"EpsDiscard"],

Cell["\<\
EpsDiscard is an option for FeynCalc2FORM. If set to True all Levi-Civita \
tensors are replaced by 0 after contraction.\
\>", "Text",
 CellTags->"EpsDiscard"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalc2FORM",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalc2FORM",
  ButtonNote->"FeynCalc2FORM"],
 "."
}], "Text",
 CellTags->"EpsDiscard"]
}, Open  ]],

Cell["EpsEvaluate", "ObjectName",
 CellTags->"EpsEvaluate"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"EpsEvaluate"],

Cell["\<\
EpsEvaluate[expr] applies total antisymmetry and linearity (w.r.t. \
Momentum's) to all Levi-Civita tensors (Eps') in expr.\
\>", "Text",
 CellTags->"EpsEvaluate"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Contract",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Contract",
  ButtonNote->"Contract"],
 ", ",
 ButtonBox["Eps",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Eps",
  ButtonNote->"Eps"],
 ", ",
 ButtonBox["LeviCivita",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LeviCivita",
  ButtonNote->"LeviCivita"],
 ", ",
 ButtonBox["Trick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Trick",
  ButtonNote->"Trick"],
 "."
}], "Text",
 CellTags->"EpsEvaluate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"EpsEvaluate"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trick", "[", 
  RowBox[{
   RowBox[{"LeviCivita", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], "]"}], 
   " ", 
   RowBox[{"FourVector", "[", 
    RowBox[{
     RowBox[{"p", "+", "q"}], ",", "\[Sigma]"}], "]"}]}], "]"}]], "Input",
 CellTags->"EpsEvaluate",
 CellLabel->"In[539]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     RowBox[{"p", "+", "q"}],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"EpsEvaluate",
 CellLabel->"Out[539]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EpsEvaluate", "[", "%", "]"}]], "Input",
 CellTags->"EpsEvaluate",
 CellLabel->"In[540]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Rho]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     RowBox[{"p", "+", "q"}],
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellTags->"EpsEvaluate",
 CellLabel->"Out[540]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", "%", "]"}]], "Input",
 CellTags->"EpsEvaluate",
 CellLabel->"In[541]:="],

Cell[BoxData[
 RowBox[{"Eps", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", 
    RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", 
   RowBox[{"LorentzIndex", "[", 
    RowBox[{"\[Nu]", ",", "D"}], "]"}], ",", 
   RowBox[{"LorentzIndex", "[", 
    RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", 
   RowBox[{"Momentum", "[", 
    RowBox[{"p", "+", "q"}], "]"}]}], "]"}]], "Output",
 CellTags->"EpsEvaluate",
 CellLabel->"Out[541]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["EpsUncontract", "ObjectName",
 CellTags->"EpsUncontract"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"EpsUncontract"],

Cell["\<\
EpsUncontract does Uncontract on scalar products involving Eps.\
\>", "Text",
 CellTags->"EpsUncontract"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Eps",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Eps",
  ButtonNote->"Eps"],
 ", ",
 ButtonBox["Uncontract",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Uncontract",
  ButtonNote->"Uncontract"],
 "."
}], "Text",
 CellTags->"EpsUncontract"]
}, Open  ]],

Cell["Epsilon", "ObjectName",
 CellTags->"Epsilon"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Epsilon"],

Cell[TextData[{
 "Epsilon is (",
 StyleBox["n",
  FontSlant->"Italic"],
 "-4), where ",
 StyleBox["n",
  FontSlant->"Italic"],
 " is the space-time dimension. Epsilon stands for a small positive number."
}], "Text",
 CellTags->"Epsilon"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Series2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Series2",
  ButtonNote->"Series2"],
 "."
}], "Text",
 CellTags->"Epsilon"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Epsilon"],

Cell[CellGroupData[{

Cell[BoxData["Epsilon"], "Input",
 CellTags->"Epsilon",
 CellLabel->"In[542]:="],

Cell[BoxData[
 FormBox[
  TagBox["\[CurlyEpsilon]",
   TraditionalForm], TraditionalForm]], "Output",
 CellTags->"Epsilon",
 CellLabel->"Out[542]="]
}, Open  ]],

Cell["\<\
Epsilon has no functional properties, but some upvalues are changed:\
\>", "Text",
 CellTags->"Epsilon"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", 
    RowBox[{"-", "4"}]}], ",", 
   RowBox[{
    RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", 
    RowBox[{"-", "3"}]}], ",", 
   RowBox[{
    RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{
    RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{
    RowBox[{"Re", "[", "Epsilon", "]"}], " ", ">", " ", "0"}]}], 
  "}"}]], "Input",
 CellTags->"Epsilon",
 CellLabel->"In[543]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
   "}"}], TraditionalForm]], "Output",
 CellTags->"Epsilon",
 CellLabel->"Out[543]="]
}, Open  ]]
}, Open  ]],

Cell["EpsilonOrder", "ObjectName",
 CellTags->"EpsilonOrder"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"EpsilonOrder"],

Cell[TextData[{
 "EpsilonOrder is an option of OPEIntDelta and RHI. The setting determines \
the order ",
 "n",
 " (",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Epsilon", 
    StyleBox["n",
     FontSlant->"Plain"]], TraditionalForm]]],
 ") which should be kept."
}], "Text",
 CellTags->"EpsilonOrder"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["OPEIntDelta",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OPEIntDelta",
  ButtonNote->"OPEIntDelta"],
 ", ",
 ButtonBox["RHI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"RHI",
  ButtonNote->"RHI"],
 "."
}], "Text",
 CellTags->"EpsilonOrder"]
}, Open  ]],

Cell["Expanding", "ObjectName",
 CellTags->"Expanding"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Expanding"],

Cell["\<\
Expanding is an option for Calc, Contract, DiracSimplify,DotSimplify, \
SUNSimplify, etc. As option for Contract it specifies whether expansion \
w.r.t. LorentzIndex is done BEFORE contraction. If set to False in \
DiracSimplify or SUNSimplify, only a limited set of simplifications \
(multiplicative linearity etc.) is performed.\
\>", "Text",
 CellTags->"Expanding"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Calc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Calc",
  ButtonNote->"Calc"],
 ", ",
 ButtonBox["Contract",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Contract",
  ButtonNote->"Contract"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify",
  ButtonNote->"DiracSimplify"],
 ", ",
 ButtonBox["DotSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DotSimplify",
  ButtonNote->"DotSimplify"],
 ", ",
 ButtonBox["SUNSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNSimplify",
  ButtonNote->"SUNSimplify"],
 "."
}], "Text",
 CellTags->"Expanding"]
}, Open  ]],

Cell["ExpandPartialD", "ObjectName",
 CellTags->"ExpandPartialD"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ExpandPartialD"],

Cell["\<\
ExpandPartialD[exp] expands all products of QuantumField's and partial \
differentiation operators in exp and applies the Leibniz rule.\
\>", "Text",
 CellTags->"ExpandPartialD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "ExpandPartialD", "]"}]], "Input",
 CellLabel->"In[544]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"PartialDRelations", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a$___", ".", 
       RowBox[{"\[PartialD]", "/", "\[PartialD]", 
        SuperscriptBox[
         FormBox["x$_",
          TraditionalForm], 
         FormBox[
          FormBox["mu$_",
           TraditionalForm],
          TraditionalForm]]}], ".", "b$___"}], "\[RuleDelayed]", 
      RowBox[{"a$", ".", 
       RowBox[{
        SubscriptBox[
         TagBox[
          StyleBox["\<\"\[PartialD]\"\>",
           FontSlant->"Italic"],
          StyleForm[#, FontSlant -> "Italic"]& ], 
         TagBox[
          FormBox[
           FormBox["mu$",
            TraditionalForm],
           TraditionalForm],
          TraditionalForm,
          Editable->True]], "(", 
        TagBox[
         FormBox[
          RowBox[{"Dot", "[", "b$", "]"}],
          TraditionalForm],
         TraditionalForm,
         Editable->True], ")"}]}]}], "}"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[544]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 ButtonBox["ExplicitPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ExplicitPartialD",
  ButtonNote->"ExplicitPartialD"],
 ", ",
 ButtonBox["LeftPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LeftPartialD",
  ButtonNote->"LeftPartialD"],
 ", ",
 ButtonBox["LeftRightPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LeftRightPartialD",
  ButtonNote->"LeftRightPartialD"],
 ", ",
 ButtonBox["PartialDRelations",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PartialDRelations",
  ButtonNote->"PartialDRelations"],
 ", ",
 ButtonBox["RightPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"RightPartialD",
  ButtonNote->"RightPartialD"],
 "."
}], "Text",
 CellTags->"ExpandPartialD"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ExpandPartialD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RightPartialD", "[", "\[Mu]", "]"}], ".", 
  RowBox[{"QuantumField", "[", 
   RowBox[{"A", ",", 
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}], ".", 
  RowBox[{"QuantumField", "[", 
   RowBox[{"A", ",", 
    RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}]}], "]"}]}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[545]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    OverscriptBox["\[PartialD]", "\[RightArrow]"], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SubscriptBox["A", "\[Mu]"], ".", 
   SubscriptBox["A", "\[Nu]"]}], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[545]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[546]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["A", "\[Mu]"], ".", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], "\[Null]"]}]}], "+", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], "\[Null]"]}], ".", 
    SubscriptBox["A", "\[Nu]"]}]}], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[546]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[547]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QuantumField", "[", 
    RowBox[{"A", ",", 
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}], ".", 
   RowBox[{"QuantumField", "[", 
    RowBox[{
     RowBox[{"PartialD", "[", 
      RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], ",", "A", ",", 
     RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"QuantumField", "[", 
    RowBox[{
     RowBox[{"PartialD", "[", 
      RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], ",", "A", ",", 
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}], ".", 
   RowBox[{"QuantumField", "[", 
    RowBox[{"A", ",", 
     RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}]}], "]"}]}]}]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[547]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LeftRightPartialD", "[", "\[Mu]", "]"}], ".", 
  RowBox[{"QuantumField", "[", 
   RowBox[{"A", ",", 
    RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}]}], "]"}]}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[548]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    OverscriptBox["\[PartialD]", "\[LeftRightArrow]"], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   SubscriptBox["A", "\[Nu]"]}], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[548]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[549]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm], "\[Null]"]}], "-", 
     RowBox[{
      SubscriptBox[
       OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], ".", 
      SubscriptBox["A", "\[Nu]"]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[549]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"QuantumField", "[", 
   RowBox[{"A", ",", 
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}], ".", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"LeftRightPartialD", "[", "OPEDelta", "]"}], "^", "2"}], ")"}], 
  ".", 
  RowBox[{"QuantumField", "[", 
   RowBox[{"A", ",", 
    RowBox[{"LorentzIndex", "[", "\[Rho]", "]"}]}], "]"}]}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[550]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["A", "\[Mu]"], ".", 
   SubsuperscriptBox[
    OverscriptBox["\[PartialD]", "\[LeftRightArrow]"], 
    FormBox["\[CapitalDelta]",
     TraditionalForm], "2"], ".", 
   SubscriptBox["A", "\[Rho]"]}], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[550]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[551]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubscriptBox["A", "\[Mu]"], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FormBox[
          SubscriptBox["\[PartialD]", 
           FormBox["\[CapitalDelta]",
            TraditionalForm]],
          TraditionalForm], 
         FormBox[
          SubscriptBox["\[PartialD]", 
           FormBox["\[CapitalDelta]",
            TraditionalForm]],
          TraditionalForm]}], 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Rho]",
           TraditionalForm],
          TraditionalForm], "\[Null]"]}], ")"}]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[PartialD]", 
         FormBox["\[CapitalDelta]",
          TraditionalForm]], 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm], "\[Null]"]}], ".", 
       RowBox[{
        SubscriptBox["\[PartialD]", 
         FormBox["\[CapitalDelta]",
          TraditionalForm]], 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Rho]",
           TraditionalForm],
          TraditionalForm], "\[Null]"]}]}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FormBox[
          SubscriptBox["\[PartialD]", 
           FormBox["\[CapitalDelta]",
            TraditionalForm]],
          TraditionalForm], 
         FormBox[
          SubscriptBox["\[PartialD]", 
           FormBox["\[CapitalDelta]",
            TraditionalForm]],
          TraditionalForm]}], 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm], "\[Null]"]}], ")"}], ".", 
      SubscriptBox["A", "\[Rho]"]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[551]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"8", " ", 
  RowBox[{
   RowBox[{"LeftRightPartialD", "[", "OPEDelta", "]"}], "^", "3"}]}]], "Input",\

 CellTags->"ExpandPartialD",
 CellLabel->"In[552]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"8", " ", 
   SubsuperscriptBox[
    OverscriptBox["\[PartialD]", "\[LeftRightArrow]"], 
    FormBox["\[CapitalDelta]",
     TraditionalForm], "3"]}], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[552]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitPartialD", "[", "%", "]"}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[553]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[RightArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], "-", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]]}], ")"}], "3"], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[553]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[554]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], ".", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], ".", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]]}]}], "+", 
   RowBox[{"3", " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], ".", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], ".", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[RightArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]]}]}], "-", 
   RowBox[{"3", " ", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], ".", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[RightArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], ".", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[RightArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]]}]}], "+", 
   RowBox[{
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox["\[CapitalDelta]",
      TraditionalForm]], ".", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox["\[CapitalDelta]",
      TraditionalForm]], ".", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox["\[CapitalDelta]",
      TraditionalForm]]}]}], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[554]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LeviCivita", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Tau]"}], "]"}], " ", 
  
  RowBox[{"RightPartialD", "[", 
   RowBox[{"\[Alpha]", ",", "\[Mu]", ",", "\[Beta]", ",", "\[Nu]"}], 
   "]"}]}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[555]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Beta]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]]}], " ", 
   SuperscriptBox["\[Epsilon]", 
    RowBox[{
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Tau]",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[555]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPartialD", "[", "%", "]"}]], "Input",
 CellTags->"ExpandPartialD",
 CellLabel->"In[556]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"ExpandPartialD",
 CellLabel->"Out[556]="]
}, Open  ]]
}, Open  ]],

Cell["ExpandScalarProduct, ScalarProductExpand", "ObjectName",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"}],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"}],

Cell["\<\
ExpandScalarProduct[expr] expands scalar products of sums of momenta in expr. \
ExpandScalarProduct does not use Expand on expr.
ScalarProductExpand=ExpandScalarProduct.\
\>", "Text",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandScalarProduct", "//", "Options"}]], "Input",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"In[557]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"FeynCalcInternal", "\[Rule]", "True"}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"Out[557]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Calc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Calc",
  ButtonNote->"Calc"],
 ", ",
 ButtonBox["MomentumExpand",
  BaseStyle->"AddOnsLink",
  ButtonData:>"MomentumExpand",
  ButtonNote->"MomentumExpand"],
 ", ",
 ButtonBox["MomentumCombine",
  BaseStyle->"AddOnsLink",
  ButtonData:>"MomentumCombine",
  ButtonNote->"MomentumCombine"],
 "."
}], "Text",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"SP", "[", 
   RowBox[{
    RowBox[{"p1", "+", "p2", "+", "p3"}], ",", 
    RowBox[{"p4", "+", "p5", "+", "p6"}]}], "]"}]}]], "Input",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"In[558]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"(", 
   FormBox[
    RowBox[{"p1", "+", "p2", "+", "p3"}],
    TraditionalForm], ")", "\[CenterDot]", "(", 
   FormBox[
    RowBox[{"p4", "+", "p5", "+", "p6"}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"Out[558]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ScalarProductExpand"}]], "Input",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"In[559]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"(", 
   FormBox[
    RowBox[{"p1", "+", "p2", "+", "p3"}],
    TraditionalForm], ")", "\[CenterDot]", "(", 
   FormBox[
    RowBox[{"p4", "+", "p5", "+", "p6"}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"Out[559]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SP", "[", 
  RowBox[{"p", ",", 
   RowBox[{"p", "-", "q"}]}], "]"}]], "Input",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"In[560]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["p",
    TraditionalForm], "\[CenterDot]", "(", 
   FormBox[
    RowBox[{"p", "-", "q"}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"Out[560]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandScalarProduct", "[", "%", "]"}]], "Input",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"In[561]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["p",
    TraditionalForm], "\[CenterDot]", "(", 
   FormBox[
    RowBox[{"p", "-", "q"}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"Out[561]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FV", "[", 
  RowBox[{
   RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "Input",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"In[562]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox[
    RowBox[{"p", "-", "q"}],
    TraditionalForm], "\[Mu]"], TraditionalForm]], "Output",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"Out[562]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandScalarProduct", "[", "%", "]"}]], "Input",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"In[563]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox[
    RowBox[{"p", "-", "q"}],
    TraditionalForm], "\[Mu]"], TraditionalForm]], "Output",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"Out[563]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SP", "[", 
   RowBox[{
    RowBox[{"p", "-", "q"}], ",", 
    RowBox[{"q", "-", "r"}]}], "]"}], "//", "FCI"}]], "Input",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"In[564]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"(", 
   FormBox[
    RowBox[{"p", "-", "q"}],
    TraditionalForm], ")", "\[CenterDot]", "(", 
   FormBox[
    RowBox[{"q", "-", "r"}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"Out[564]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"Pair", "\[Rule]", "ExpandScalarProduct"}]}]], "Input",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"In[565]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FormBox["p",
     TraditionalForm], "\[CenterDot]", 
    FormBox["q",
     TraditionalForm]}], "-", 
   RowBox[{
    FormBox["p",
     TraditionalForm], "\[CenterDot]", 
    FormBox["r",
     TraditionalForm]}], "-", 
   SuperscriptBox[
    FormBox["q",
     TraditionalForm], "2"], "+", 
   RowBox[{
    FormBox["q",
     TraditionalForm], "\[CenterDot]", 
    FormBox["r",
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellTags->{"ScalarProductCancel", "ExpandScalarProduct"},
 CellLabel->"Out[565]="]
}, Open  ]]
}, Open  ]],

Cell["Expand2", "ObjectName",
 CellTags->"Expand2"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Expand2"],

Cell["\<\
Expand2[exp, x] expands all sums containing x. Expand2[exp, {x1, x2, ...}]  \
expands all sums containing x1, x2, ....\
\>", "Text",
 CellTags->"Expand2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Expand2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand2", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x1", "+", "x2", "+", "x3"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "x1"}], "+", 
       RowBox[{"3", "x2"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y1", "+", "y2", "+", "y3"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "y1"}], "+", 
       RowBox[{"3", "y2"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellTags->"Expand2",
 CellLabel->"In[566]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["x1", "2"]}], "+", 
   RowBox[{"5", " ", "x2", " ", "x1"}], "+", 
   RowBox[{"2", " ", "x3", " ", "x1"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["x2", "2"]}], "+", 
   RowBox[{"3", " ", "x2", " ", "x3"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "y1"}], "+", 
      RowBox[{"3", " ", "y2"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"y1", "+", "y2", "+", "y3"}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellTags->"Expand2",
 CellLabel->"Out[566]="]
}, Open  ]]
}, Open  ]],

Cell["Explicit", "ObjectName",
 CellTags->"Explicit"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Explicit"],

Cell[TextData[{
 "Explicit is an option for FieldStrength, GluonVertex, SUNF, and \
Twist2GluonOperator. If set to True the full form of the operator is \
inserted. ",
 StyleBox["Explicit[exp]",
  FontVariations->{"CompatibilityType"->0}],
 " inserts explicit expressions of GluonVertex, Twist2GluonOperator, etc., in \
exp. SUNF's are replaced by SUNTrace objects."
}], "Text",
 CellTags->"Explicit"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["GluonVertex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GluonVertex",
  ButtonNote->"GluonVertex"],
 ", ",
 ButtonBox["Twist2GluonOperator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Twist2GluonOperator",
  ButtonNote->"Twist2GluonOperator"],
 "."
}], "Text",
 CellTags->"Explicit"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Explicit", "//", "Options"}]], "Input",
 CellLabel->"In[567]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CouplingConstant", "\[Rule]", 
     SubscriptBox["g", "s"]}], ",", 
    RowBox[{"Dimension", "\[Rule]", "D"}], ",", 
    RowBox[{"Gauge", "\[Rule]", "1"}], ",", 
    RowBox[{"\[CapitalOmega]", "\[Rule]", "False"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[567]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Explicit"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GluonPropagator", "[", 
  RowBox[{"p", ",", "\[Mu]", ",", "\[Nu]"}], "]"}]], "Input",
 CellLabel->"In[568]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[CapitalPi]", "g", 
    RowBox[{"\[Mu]", "\[Nu]"}]], "(", "p", ")"}], TraditionalForm]], "Output",\

 CellLabel->"Out[568]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Explicit", "[", "%", "]"}]], "Input",
 CellLabel->"In[569]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["g", 
      RowBox[{"\[Mu]", "\[Nu]"}]]}], 
    SuperscriptBox["p", "2"]]}], TraditionalForm]], "Output",
 CellLabel->"Out[569]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Explicit", "[", 
  RowBox[{
   RowBox[{"GluonPropagator", "[", 
    RowBox[{"p", ",", "\[Mu]", ",", "\[Nu]"}], "]"}], ",", 
   RowBox[{"Gauge", "\[Rule]", "\[Xi]"}]}], "]"}]], "Input",
 CellLabel->"In[570]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Xi]"}], ")"}], " ", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]], " ", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]]}], 
       SuperscriptBox["p", "2"]], "-", 
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]]}], ")"}]}], 
   SuperscriptBox["p", "2"]], TraditionalForm]], "Output",
 CellLabel->"Out[570]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GluonVertex", "[", 
  RowBox[{
  "p", ",", "\[Mu]", ",", "a", ",", " ", "q", ",", "\[Nu]", ",", "b", ",", 
   "r", ",", "\[Rho]", ",", "c"}], "]"}]], "Input",
 CellTags->"Explicit",
 CellLabel->"In[571]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["V", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm]}]], "(", 
    RowBox[{
     FormBox["p",
      TraditionalForm], 
     RowBox[{",", " "}], 
     FormBox["q",
      TraditionalForm], 
     RowBox[{",", " "}], 
     FormBox["r",
      TraditionalForm]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"Explicit",
 CellLabel->"Out[571]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Explicit", "[", "%", "]"}]], "Input",
 CellTags->"Explicit",
 CellLabel->"In[572]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         FormBox["q",
          TraditionalForm], 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]], "-", 
        SuperscriptBox[
         FormBox["r",
          TraditionalForm], 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]]}], ")"}], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         FormBox["r",
          TraditionalForm], 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]], "-", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], 
         FormBox[
          FormBox["\[Rho]",
           TraditionalForm],
          TraditionalForm]], "-", 
        SuperscriptBox[
         FormBox["q",
          TraditionalForm], 
         FormBox[
          FormBox["\[Rho]",
           TraditionalForm],
          TraditionalForm]]}], ")"}]}]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"Explicit",
 CellLabel->"Out[572]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Twist2GluonOperator", "[", 
  RowBox[{"p", ",", "\[Mu]", ",", "a", ",", "\[Nu]", ",", "b"}], 
  "]"}]], "Input",
 CellTags->"Explicit",
 CellLabel->"In[573]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FormBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "m"],
      TraditionalForm], "+", "1"}], ")"}], " ", 
   SubscriptBox["\[Delta]", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     SubsuperscriptBox["O", 
      RowBox[{
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], "\[VeryThinSpace]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]}], "G2"], "(", 
     FormBox["p",
      TraditionalForm], ")"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Explicit",
 CellLabel->"Out[573]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Explicit", "[", "%", "]"}]], "Input",
 CellTags->"Explicit",
 CellLabel->"In[574]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      SuperscriptBox[
       FormBox[
        RowBox[{
         FormBox["\[CapitalDelta]",
          TraditionalForm], "\[CenterDot]", 
         FormBox["p",
          TraditionalForm]}],
        TraditionalForm], "2"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], 
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm]], " ", 
         SuperscriptBox[
          FormBox["\[CapitalDelta]",
           TraditionalForm], 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]]}], "+", 
        RowBox[{
         SuperscriptBox[
          FormBox["\[CapitalDelta]",
           TraditionalForm], 
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm]], " ", 
         SuperscriptBox[
          FormBox["p",
           TraditionalForm], 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]]}]}], ")"}], " ", 
      RowBox[{
       FormBox["\[CapitalDelta]",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p",
        TraditionalForm]}]}], "+", 
     RowBox[{
      SuperscriptBox[
       FormBox["\[CapitalDelta]",
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["\[CapitalDelta]",
        TraditionalForm], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], "2"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FormBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "m"],
      TraditionalForm], "+", "1"}], ")"}], " ", 
   FormBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FormBox["\[CapitalDelta]",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p",
        TraditionalForm]}], ")"}], 
     RowBox[{"m", "-", "2"}]],
    TraditionalForm], " ", 
   SubscriptBox["\[Delta]", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"Explicit",
 CellLabel->"Out[574]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldStrength", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a"}], "]"}]], "Input",
 CellTags->"Explicit",
 CellLabel->"In[575]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["F", 
   RowBox[{"\[Mu]", "\[Nu]"}], "a"], TraditionalForm]], "Output",
 CellTags->"Explicit",
 CellLabel->"Out[575]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Explicit", "[", "%", "]"}]], "Input",
 CellTags->"Explicit",
 CellLabel->"In[576]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    SubscriptBox["g", "s"], " ", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b1",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c16",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b1",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c16",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"Explicit",
 CellLabel->"Out[576]="]
}, Open  ]]
}, Open  ]],

Cell["ExplicitLorentzIndex", "ObjectName",
 CellTags->"ExplicitLorentzIndex"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ExplicitLorentzIndex"],

Cell["\<\
ExplicitLorentzIndex[ind] is an explicit Lorentz index, i.e., ind is an \
integer.\
\>", "Text",
 CellTags->"ExplicitLorentzIndex"],

Cell[TextData[{
 "See also: ",
 ButtonBox["LorentzIndex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LorentzIndex",
  ButtonNote->"LorentzIndex"],
 ", ",
 ButtonBox["Pair",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Pair",
  ButtonNote->"Pair"],
 "."
}], "Text",
 CellTags->"ExplicitLorentzIndex"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ExplicitLorentzIndex"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pair", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", "1", "]"}], ",", 
   RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}]], "Input",
 CellTags->"ExplicitLorentzIndex",
 CellLabel->"In[577]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["g", 
   RowBox[{
    FormBox["1",
     TraditionalForm], "\[Mu]"}]], TraditionalForm]], "Output",
 CellTags->"ExplicitLorentzIndex",
 CellLabel->"Out[577]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"ExplicitLorentzIndex",
 CellLabel->"In[578]:="],

Cell[BoxData[
 RowBox[{"Pair", "[", 
  RowBox[{
   RowBox[{"ExplicitLorentzIndex", "[", "1", "]"}], ",", 
   RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}]], "Output",
 CellTags->"ExplicitLorentzIndex",
 CellLabel->"Out[578]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["ExplicitPartialD", "ObjectName",
 CellTags->"ExplicitPartialD"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ExplicitPartialD"],

Cell["\<\
ExplicitPartialD[exp] inserts in exp the definition for LeftRightPartialD[z] \
(and LeftRightPartialD2[z]).\
\>", "Text",
 CellTags->"ExplicitPartialD"],

Cell[TextData[{
 "See also: ",
 ButtonBox["ExpandPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ExpandPartialD",
  ButtonNote->"ExpandPartialD"],
 ", ",
 ButtonBox["LeftRightPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LeftRightPartialD",
  ButtonNote->"LeftRightPartialD"],
 ", ",
 ButtonBox["LeftRightPartialD2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LeftRightPartialD2",
  ButtonNote->"LeftRightPartialD2"],
 "."
}], "Text",
 CellTags->"ExplicitPartialD"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ExplicitPartialD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitPartialD", "[", " ", 
  RowBox[{"LeftRightPartialD", "[", "\[Mu]", "]"}], " ", "]"}]], "Input",
 CellTags->"ExplicitPartialD",
 CellLabel->"In[579]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[RightArrow]"], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], "-", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"ExplicitPartialD",
 CellLabel->"Out[579]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitPartialD", "[", " ", 
  RowBox[{"LeftRightPartialD2", "[", "\[Mu]", "]"}], " ", "]"}]], "Input",
 CellTags->"ExplicitPartialD",
 CellLabel->"In[580]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], "+", 
   SubscriptBox[
    OverscriptBox["\[PartialD]", "\[RightArrow]"], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"ExplicitPartialD",
 CellLabel->"Out[580]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitPartialD", "[", " ", 
  RowBox[{"LeftRightPartialD", "[", "OPEDelta", "]"}], " ", "]"}]], "Input",
 CellTags->"ExplicitPartialD",
 CellLabel->"In[581]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[RightArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], "-", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"ExplicitPartialD",
 CellLabel->"Out[581]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"16", " ", 
  RowBox[{
   RowBox[{"LeftRightPartialD", "[", "OPEDelta", "]"}], "^", "4"}]}]], "Input",\

 CellTags->"ExplicitPartialD",
 CellLabel->"In[582]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"16", " ", 
   SubsuperscriptBox[
    OverscriptBox["\[PartialD]", "\[LeftRightArrow]"], 
    FormBox["\[CapitalDelta]",
     TraditionalForm], "4"]}], TraditionalForm]], "Output",
 CellTags->"ExplicitPartialD",
 CellLabel->"Out[582]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitPartialD", "[", "%", "]"}]], "Input",
 CellTags->"ExplicitPartialD",
 CellLabel->"In[583]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[RightArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], "-", 
     SubscriptBox[
      OverscriptBox["\[PartialD]", "\[LeftArrow]"], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]]}], ")"}], "4"], TraditionalForm]], "Output",
 CellTags->"ExplicitPartialD",
 CellLabel->"Out[583]="]
}, Open  ]]
}, Open  ]],

Cell["ExplicitSUNIndex", "ObjectName",
 CellTags->"ExplicitSUNIndex"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ExplicitSUNIndex"],

Cell[TextData[{
 "ExplicitSUNIndex[ind] is a specific SU(",
 StyleBox["N",
  FontSlant->"Italic"],
 ") index, i.e., ind is an integer."
}], "Text",
 CellTags->"ExplicitSUNIndex"],

Cell[TextData[{
 "See also: ",
 ButtonBox["FCI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCI",
  ButtonNote->"FCI"],
 ", ",
 ButtonBox["SUNDelta",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNDelta",
  ButtonNote->"SUNDelta"],
 ", ",
 ButtonBox["SUNF",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNF",
  ButtonNote->"SUNF"],
 ", ",
 ButtonBox["SUNIndex",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNIndex",
  ButtonNote->"SUNIndex"],
 "."
}], "Text",
 CellTags->"ExplicitSUNIndex"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"ExplicitSUNIndex"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExplicitSUNIndex", "[", "1", "]"}]], "Input",
 CellTags->"ExplicitSUNIndex",
 CellLabel->"In[584]:="],

Cell[BoxData[
 FormBox["1", TraditionalForm]], "Output",
 CellTags->"ExplicitSUNIndex",
 CellLabel->"Out[584]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SUNDelta", "[", 
    RowBox[{"1", ",", "a"}], "]"}], "//", "FCI"}], "//", 
  "StandardForm"}]], "Input",
 CellLabel->"In[585]:="],

Cell[BoxData[
 RowBox[{"SUNDelta", "[", 
  RowBox[{
   RowBox[{"ExplicitSUNIndex", "[", "1", "]"}], ",", 
   RowBox[{"SUNIndex", "[", "a", "]"}]}], "]"}]], "Output",
 CellLabel->"Out[585]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["ExtraFactor", "ObjectName",
 CellTags->"ExtraFactor"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ExtraFactor"],

Cell["\<\
ExtraFactor is an option for FermionSpinSum. The setting ExtraFactor \[Rule] \
fa  multiplies the whole amplitude with the factor fa before squaring.\
\>", "Text",
 CellTags->"ExtraFactor"],

Cell[TextData[{
 "See also: ",
 ButtonBox["FermionSpinSum",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FermionSpinSum",
  ButtonNote->"FermionSpinSum"],
 "."
}], "Text",
 CellTags->"ExtraFactor"]
}, Open  ]],

Cell["ExtraVariables", "ObjectName",
 CellTags->"ExtraVariables"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"ExtraVariables"],

Cell["\<\
ExtraVariables is an option for OneLoopSum; it may be set to a list of \
variables which are also bracketed out in the result, just like B0, C0, D0 \
and  PaVe.\
\>", "Text",
 CellTags->"ExtraVariables"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["OneLoop",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoop",
  ButtonNote->"OneLoop"],
 ", ",
 ButtonBox["OneLoopSum",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoopSum",
  ButtonNote->"OneLoopSum"],
 "."
}], "Text",
 CellTags->"ExtraVariables"]
}, Open  ]],

Cell["FactorFull", "ObjectName",
 CellTags->"FactorFull"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FactorFull"],

Cell[TextData[{
 "FactorFull is an option of Factor2 (default False). If set to False, \
products like (",
 StyleBox["a",
  FontSlant->"Italic"],
 "-",
 StyleBox["b",
  FontSlant->"Italic"],
 ") (",
 StyleBox["a",
  FontSlant->"Italic"],
 "+",
 StyleBox["b",
  FontSlant->"Italic"],
 ") will be replaced by (",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["a", "2"], TraditionalForm]]],
 "-",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["b", "2"], TraditionalForm]]],
 ")."
}], "Text",
 CellTags->"FactorFull"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Factor2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Factor2",
  ButtonNote->"Factor2"],
 "."
}], "Text",
 CellTags->"FactorFull"]
}, Open  ]],

Cell["Factoring", "ObjectName",
 CellTags->"Factoring"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Factoring"],

Cell["\<\
Factoring is an option for Collect2, Contract, Tr and more functions. If set \
to True, the result will be factored, using Factor2. If set to any function \
f, this function will be used.\
\>", "Text",
 CellTags->"Factoring"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Collect2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Collect2",
  ButtonNote->"Collect2"],
 ", ",
 ButtonBox["Contract",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Contract",
  ButtonNote->"Contract"],
 ", ",
 ButtonBox["Tr",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Tr",
  ButtonNote->"Tr"],
 "."
}], "Text",
 CellTags->"Factoring"]
}, Open  ]],

Cell["Factorout", "ObjectName",
 CellTags->"Factorout"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Factorout"],

Cell["Factorout is an option for OPEInt.", "Text",
 CellTags->"Factorout"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["OPEInt",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OPEInt",
  ButtonNote->"OPEInt"],
 "."
}], "Text",
 CellTags->"Factorout"]
}, Open  ]],

Cell["FactorTime", "ObjectName",
 CellTags->"FactorTime"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FactorTime"],

Cell["\<\
FactorTime is an option for Factor2. It denotes the maximum time (in seconds) \
during which Factor2 tries to factor.\
\>", "Text",
 CellTags->"FactorTime"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Factor2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Factor2",
  ButtonNote->"Factor2"],
 "."
}], "Text",
 CellTags->"FactorTime"]
}, Open  ]],

Cell["Factor1", "ObjectName",
 CellTags->"Factor1"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Factor1"],

Cell["\<\
Factor1[poly] factorizes common terms  in the summands of poly. It uses \
basically PolynomialGCD.\
\>", "Text",
 CellTags->"Factor1"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Factor2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Factor2",
  ButtonNote->"Factor2"],
 "."
}], "Text",
 CellTags->"Factor1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Factor1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "x"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"b", "-", "x"}], ")"}]}]}]], "Input",
 CellTags->"Factor1",
 CellLabel->"In[586]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"b", "-", "x"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Factor1",
 CellLabel->"Out[586]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Factor1", "[", "t1", "]"}], ",", " ", 
    RowBox[{"Factor", "[", "t1", "]"}]}], "}"}]}]], "Input",
 CellTags->"Factor1",
 CellLabel->"In[587]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"b", "-", "x"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"a", "-", "x"}], ")"}]}], " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", "b"}], ")"}]}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"Factor1",
 CellLabel->"Out[587]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}]], "Input",
 CellTags->"Factor1",
 CellLabel->"In[588]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["a", "2"], "-", 
   SuperscriptBox["b", "2"]}], TraditionalForm]], "Output",
 CellTags->"Factor1",
 CellLabel->"Out[588]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "t3", "]"}]], "Input",
 CellTags->"Factor1",
 CellLabel->"In[589]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Factor1",
 CellLabel->"Out[589]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor1", "[", "t3", "]"}]], "Input",
 CellTags->"Factor1",
 CellLabel->"In[590]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["a", "2"], "-", 
   SuperscriptBox["b", "2"]}], TraditionalForm]], "Output",
 CellTags->"Factor1",
 CellLabel->"Out[590]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"t1", ",", "t2", ",", "t3"}], "]"}]], "Input",
 CellTags->"Factor1",
 CellLabel->"In[591]:="]
}, Open  ]],

Cell["Factor2", "ObjectName",
 CellTags->"Factor2"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"Factor2"],

Cell["\<\
Factor2[poly] factors a polynomial in a standard way. Factor2 works sometimes \
better than Factor on polynomials involving rationals with sums in the \
denominator. Factor2 uses Factor internally and is in general slower than \
Factor. There are four possible settings of the option Method (0,1,2,3). In \
general Factor will work faster than Factor2.\
\>", "Text",
 CellTags->"Factor2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "Factor2", "]"}]], "Input",
 CellTags->"Factor2",
 CellLabel->"In[592]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FactorFull", "\[Rule]", "False"}], ",", 
    RowBox[{"Method", "\[Rule]", "3"}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"Factor2",
 CellLabel->"Out[592]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Collect2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Collect2",
  ButtonNote->"Collect2"],
 "."
}], "Text",
 CellTags->"Factor2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"Factor2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "x"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"b", "-", "x"}], ")"}]}]}]], "Input",
 CellTags->"Factor2",
 CellLabel->"In[593]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"b", "-", "x"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Factor2",
 CellLabel->"Out[593]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Factor2", "[", "t1", "]"}], ",", " ", 
    RowBox[{"Factor", "[", "t1", "]"}]}], "}"}]}]], "Input",
 CellTags->"Factor2",
 CellLabel->"In[594]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"b", "-", "x"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"a", "-", "x"}], ")"}]}], " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", "b"}], ")"}]}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"Factor2",
 CellLabel->"Out[594]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}]], "Input",
 CellTags->"Factor2",
 CellLabel->"In[595]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["a", "2"], "-", 
   SuperscriptBox["b", "2"]}], TraditionalForm]], "Output",
 CellTags->"Factor2",
 CellLabel->"Out[595]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "t3", "]"}]], "Input",
 CellTags->"Factor2",
 CellLabel->"In[596]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Factor2",
 CellLabel->"Out[596]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor2", "[", "t3", "]"}]], "Input",
 CellTags->"Factor2",
 CellLabel->"In[597]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["a", "2"], "-", 
   SuperscriptBox["b", "2"]}], TraditionalForm]], "Output",
 CellTags->"Factor2",
 CellLabel->"Out[597]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor2", "[", 
  RowBox[{"t3", ",", 
   RowBox[{"FactorFull", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"Factor2",
 CellLabel->"In[598]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Factor2",
 CellLabel->"Out[598]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"t1", ",", "t2", ",", "t3"}], "]"}]], "Input",
 CellTags->"Factor2",
 CellLabel->"In[599]:="]
}, Open  ]],

Cell["FAD", "ObjectName",
 CellTags->"FAD"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FAD"],

Cell["\<\
FAD is the FeynCalc external form of FeynAmpDenominator and denotes an \
inverse propagator. FAD[q, q-p, ...] is 1/(q^2 (q-p)^2 ...). FAD[{q1,m}, \
{q1-p,m}, q2, ...] is 1/( (q1^2 - m^2) ( (q1-p)^2 - m^2 ) q2^2 ... ). \
Translation into FeynCalc internal form is performed by FeynCalcInternal.\
\>", "Text",
 CellTags->"FAD"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FAD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FAD",
  ButtonNote->"FAD"],
 ", ",
 ButtonBox["FCE",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCE",
  ButtonNote->"FCE"],
 ", ",
 ButtonBox["FCI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCI",
  ButtonNote->"FCI"],
 ", ",
 ButtonBox["FeynAmpDenominator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmpDenominator",
  ButtonNote->"FeynAmpDenominator"],
 ", ",
 ButtonBox["FeynAmpDenominatorSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmpDenominatorSimplify",
  ButtonNote->"FeynAmpDenominatorSimplify"],
 ", ",
 ButtonBox["PropagatorDenominator",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PropagatorDenominator",
  ButtonNote->"PropagatorDenominator"],
 "."
}], "Text",
 CellTags->"FAD"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FAD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FAD", "[", 
  RowBox[{"q", ",", 
   RowBox[{"p", "-", "q"}]}], "]"}]], "Input",
 CellTags->"FAD",
 CellLabel->"In[600]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"p", "-", "q"}], ")"}], "2"], 
       "\[InvisibleSpace]", "\<\"]\"\>"}],
      SequenceForm["[", ($CellContext`p - $CellContext`q)^2, "]"],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
       SuperscriptBox["q", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
      SequenceForm["[", $CellContext`q^2, "]"],
      Editable->False], ")"}]}]], TraditionalForm]], "Output",
 CellTags->"FAD",
 CellLabel->"Out[600]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FAD", "[", 
  RowBox[{"p", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "-", "q"}], ",", "m"}], "}"}]}], "]"}]], "Input",
 CellTags->"FAD",
 CellLabel->"In[601]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
       SuperscriptBox["p", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
      SequenceForm["[", $CellContext`p^2, "]"],
      Editable->False], ")"}], " ", 
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"p", "-", "q"}], ")"}], "2"], 
       "\[InvisibleSpace]", "\<\"-\"\>", "\[InvisibleSpace]", 
       SuperscriptBox["m", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
      SequenceForm[
      "[", ($CellContext`p - $CellContext`q)^2, "-", $CellContext`m^2, "]"],
      Editable->False], ")"}]}]], TraditionalForm]], "Output",
 CellTags->"FAD",
 CellLabel->"Out[601]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FAD", "[", 
     RowBox[{"q", ",", 
      RowBox[{"p", "-", "q"}]}], "]"}], "//", "FCI"}], "//", "FCE"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FAD",
 CellLabel->"In[602]:="],

Cell[BoxData[
 RowBox[{"FAD", "[", 
  RowBox[{"q", ",", 
   RowBox[{"p", "-", "q"}]}], "]"}]], "Output",
 CellTags->"FAD",
 CellLabel->"Out[602]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FAD", "[", 
    RowBox[{"q", ",", 
     RowBox[{"p", "-", "q"}]}], "]"}], "//", "FCI"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FAD",
 CellLabel->"In[603]:="],

Cell[BoxData[
 RowBox[{"FeynAmpDenominator", "[", 
  RowBox[{
   RowBox[{"PropagatorDenominator", "[", 
    RowBox[{
     RowBox[{"Momentum", "[", 
      RowBox[{"q", ",", "D"}], "]"}], ",", "0"}], "]"}], ",", 
   RowBox[{"PropagatorDenominator", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Momentum", "[", 
       RowBox[{"p", ",", "D"}], "]"}], "-", 
      RowBox[{"Momentum", "[", 
       RowBox[{"q", ",", "D"}], "]"}]}], ",", "0"}], "]"}]}], "]"}]], "Output",\

 CellTags->"FAD",
 CellLabel->"Out[603]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FAD", "[", "p", "]"}], " ", 
    RowBox[{"FAD", "[", 
     RowBox[{"p", "-", "q"}], "]"}]}], " ", "//", " ", 
   "FeynAmpDenominatorCombine"}], "//", "StandardForm"}]], "Input",
 CellTags->"FAD",
 CellLabel->"In[604]:="],

Cell[BoxData[
 RowBox[{"FeynAmpDenominator", "[", 
  RowBox[{
   RowBox[{"PropagatorDenominator", "[", 
    RowBox[{
     RowBox[{"Momentum", "[", 
      RowBox[{"p", ",", "D"}], "]"}], ",", "0"}], "]"}], ",", 
   RowBox[{"PropagatorDenominator", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Momentum", "[", 
       RowBox[{"p", ",", "D"}], "]"}], "-", 
      RowBox[{"Momentum", "[", 
       RowBox[{"q", ",", "D"}], "]"}]}], ",", "0"}], "]"}]}], "]"}]], "Output",\

 CellTags->"FAD",
 CellLabel->"Out[604]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["FC", "ObjectName",
 CellTags->"FC"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FC"],

Cell["\<\
FC changes the output format to FeynCalcForm. To change to InputForm use FI.\
\>", "Text",
 CellTags->"FC"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalcForm",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcForm",
  ButtonNote->"FeynCalcForm"],
 ", ",
 ButtonBox["FI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FI",
  ButtonNote->"FI"],
 ", ",
 ButtonBox["FeynCalcExternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcExternal",
  ButtonNote->"FeynCalcExternal"],
 ", ",
 ButtonBox["FeynCalcInternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcInternal",
  ButtonNote->"FeynCalcInternal"],
 "."
}], "Text",
 CellTags->"FC"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FC"],

Cell[BoxData["FI"], "Input",
 CellTags->"FC",
 CellLabel->"In[605]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DiracGamma", "[", "5", "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{"Momentum", "[", "p", "]"}], "]"}]}], "}"}]], "Input",
 CellTags->"FC",
 CellLabel->"In[606]:="],

Cell["{DiracGamma[5], DiracGamma[Momentum[p]]}", "Output",
 CellTags->"FC",
 CellLabel->"Out[606]="]
}, Open  ]],

Cell[BoxData["FC"], "Input",
 CellTags->"FC",
 CellLabel->"In[607]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DiracGamma", "[", "5", "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{"Momentum", "[", "p", "]"}], "]"}]}], "}"}]], "Input",
 CellTags->"FC",
 CellLabel->"In[608]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "5"], ",", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FC",
 CellLabel->"Out[608]="]
}, Open  ]]
}, Open  ]],

Cell["FCE", "ObjectName",
 CellTags->"FCE"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FCE"],

Cell["\<\
FCE[exp] translates exp from the internal FeynCalc representation to a short \
form.\
\>", "Text",
 CellTags->"FCE"],

Cell["FCE is equivalent to FeynCalcExternal.", "Text",
 CellTags->"FCE"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalcExternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcExternal",
  ButtonNote->"FeynCalcExternal"],
 ", ",
 ButtonBox["FCI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCI",
  ButtonNote->"FCI"],
 ", ",
 ButtonBox["FeynCalcInternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcInternal",
  ButtonNote->"FeynCalcInternal"],
 "."
}], "Text",
 CellTags->"FCE"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FCE"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FCE", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"DiracGamma", "[", "5", "]"}], ",", 
    RowBox[{"DiracGamma", "[", 
     RowBox[{"Momentum", "[", "p", "]"}], "]"}]}], "}"}], "]"}]], "Input",
 CellTags->"FCE",
 CellLabel->"In[609]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "5"], ",", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FCE",
 CellLabel->"Out[609]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FCE",
 CellLabel->"In[610]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "5", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}]}], "}"}]], "Output",
 CellTags->"FCE",
 CellLabel->"Out[610]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Input",
 CellTags->"FCE",
 CellLabel->"In[611]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
    SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ",", 
    FormBox[
     RowBox[{
      FormBox["p",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}],
     TraditionalForm], ",", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
    SuperscriptBox["p", "\[Mu]"]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FCE",
 CellLabel->"Out[611]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FCE",
 CellLabel->"In[612]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Output",
 CellTags->"FCE",
 CellLabel->"Out[612]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FCI"}]], "Input",
 CellTags->"FCE",
 CellLabel->"In[613]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ",", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm]], ",", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox["p",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ",", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FCE",
 CellLabel->"Out[613]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FCE",
 CellLabel->"In[614]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DiracGamma", "[", 
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", 
      RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", "D"}], "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{"Momentum", "[", "p", "]"}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"Momentum", "[", "p", "]"}], ",", 
     RowBox[{"Momentum", "[", "q", "]"}]}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", "\[Alpha]", "]"}], ",", 
     RowBox[{"LorentzIndex", "[", "\[Beta]", "]"}]}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
     RowBox[{"Momentum", "[", "p", "]"}]}], "]"}]}], "}"}]], "Output",
 CellTags->"FCE",
 CellLabel->"Out[614]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FCE", "[", "%", "]"}], "//", "StandardForm"}]], "Input",
 CellTags->"FCE",
 CellLabel->"In[615]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Output",
 CellTags->"FCE",
 CellLabel->"Out[615]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["FCI", "ObjectName",
 CellTags->"FCI"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FCI"],

Cell["\<\
FCI[exp] translates exp into the internal FeynCalc \
(datatype-)representation.FCI is equivalent to FeynCalcInternal.\
\>", "Text",
 CellTags->"FCI"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalcExternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcExternal",
  ButtonNote->"FeynCalcExternal"],
 ", ",
 ButtonBox["FeynCalcInternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcInternal",
  ButtonNote->"FeynCalcInternal"],
 ", ",
 ButtonBox["FCE",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCE",
  ButtonNote->"FCE"],
 "."
}], "Text",
 CellTags->"FCI"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FCI"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Input",
 CellTags->"FCI",
 CellLabel->"In[616]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
    SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ",", 
    FormBox[
     RowBox[{
      FormBox["p",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}],
     TraditionalForm], ",", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
    SuperscriptBox["p", "\[Mu]"]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FCI",
 CellLabel->"Out[616]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FCI",
 CellLabel->"In[617]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Output",
 CellTags->"FCI",
 CellLabel->"Out[617]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FCI"}]], "Input",
 CellTags->"FCI",
 CellLabel->"In[618]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ",", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm]], ",", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox["p",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ",", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FCI",
 CellLabel->"Out[618]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FCI",
 CellLabel->"In[619]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DiracGamma", "[", 
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", 
      RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", "D"}], "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{"Momentum", "[", "p", "]"}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"Momentum", "[", "p", "]"}], ",", 
     RowBox[{"Momentum", "[", "q", "]"}]}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", "\[Alpha]", "]"}], ",", 
     RowBox[{"LorentzIndex", "[", "\[Beta]", "]"}]}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
     RowBox[{"Momentum", "[", "p", "]"}]}], "]"}]}], "}"}]], "Output",
 CellTags->"FCI",
 CellLabel->"Out[619]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FCE", "[", "%", "]"}], "//", "StandardForm"}]], "Input",
 CellTags->"FCI",
 CellLabel->"In[620]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Output",
 CellTags->"FCI",
 CellLabel->"Out[620]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["FCIntegral", "ObjectName",
 CellTags->"FCIntegral"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FCIntegral"],

Cell["\<\
FCIntegral is the head of integrals in a setting of the option IntegralTable \
of FeynAmpDenominatorSimplify. Currently implemented only for 2-loop \
integrals.\
\>", "Text",
 CellTags->"FCIntegral"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["IntegralTable",
  BaseStyle->"AddOnsLink",
  ButtonData:>"IntegralTable",
  ButtonNote->"IntegralTable"],
 ", ",
 ButtonBox["FeynAmpDenominatorSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmpDenominatorSimplify",
  ButtonNote->"FeynAmpDenominatorSimplify"],
 "."
}], "Text",
 CellTags->"FCIntegral"]
}, Open  ]],

Cell["FCIntegrate", "ObjectName",
 CellTags->"FCIntegrate"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FCIntegrate"],

Cell["\<\
FCIntegrate is an option of certain Feynman integral related functions. It \
determines which integration function is used to evaluate analytic integrals. \
Possible settings include Integrate, NIntegrate, (Dot[Integratedx@@#2, #1] \
&).\
\>", "Text",
 CellTags->"FCIntegrate"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FCNIntegrate",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCNIntegrate",
  ButtonNote->"FCNIntegrate"],
 "."
}], "Text",
 CellTags->"FCIntegrate"]
}, Open  ]],

Cell["FCNIntegrate", "ObjectName",
 CellTags->"FCNIntegrate"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FCNIntegrate"],

Cell["\<\
FCNIntegrate is an option of certain Feynman integral related functions which \
may return output containing both integrals that can be evaluated and \
integrals that can only be evaluated numerically. It then determines which \
integration function is used to evaluate numeric integrals. Possible settings \
include NIntegrate, (0*#1)&, (Dot[Integratedx@@#2, #1] &).\
\>", "Text",
 CellTags->"FCNIntegrate"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FCIntegrate",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCIntegrate",
  ButtonNote->"FCIntegrate"],
 "."
}], "Text",
 CellTags->"FCNIntegrate"]
}, Open  ]],

Cell["FC2RHI ", "ObjectName",
 CellTags->"FC2RHI"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FC2RHI"],

Cell["\<\
FC2RHI[exp, k1, k2] transforms all 2-loop OPE-integrals in FeynAmpDenominator \
form to the RHI-integrals.  FC2RHI[exp] is equivalent to FC2RHI[exp,q1,q2]. \
The option IncludePair governs the inclusion  of scalar products p.k1, p.k2 \
and k1.k2 (setting True).\
\>", "Text",
 CellTags->"FC2RHI"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "FC2RHI", "]"}]], "Input",
 CellTags->"FC2RHI",
 CellLabel->"In[621]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dimension", "\[Rule]", "D"}], ",", 
    RowBox[{"IncludePair", "\[Rule]", "True"}], ",", 
    RowBox[{"Do", "\[Rule]", "True"}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FC2RHI",
 CellLabel->"Out[621]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"FAD", "[", 
     RowBox[{"q1", ",", 
      RowBox[{"q1", "-", "q2"}], ",", 
      RowBox[{"q2", "-", "p"}]}], "]"}], " ", 
    RowBox[{
     RowBox[{"SP", "[", 
      RowBox[{"q1", ",", "OPEDelta"}], "]"}], "^", "OPEm"}]}], "//", 
   "FCI"}]}]], "Input",
 CellLabel->"In[622]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FormBox["\[CapitalDelta]",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q1",
       TraditionalForm]}], ")"}], "m"], 
   RowBox[{
    SuperscriptBox["q1", "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "q2"}], ")"}], "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q2", "-", "p"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellLabel->"Out[622]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FC2RHI", "[", 
  RowBox[{"t", ",", "q1", ",", "q2"}], "]"}]], "Input",
 CellLabel->"In[623]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox[
   StyleBox["T",
    FontFamily->"Times",
    FontWeight->"Bold"], 
   StyleBox[
    RowBox[{"1", "0", "0", "1", "1"}],
    FontColor->RGBColor[0, 0, 1]], 
   RowBox[{
    FormBox["m",
     TraditionalForm], 
    FormBox["0",
     TraditionalForm], 
    FormBox["0",
     TraditionalForm], 
    FormBox["0",
     TraditionalForm], 
    FormBox["0",
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellLabel->"Out[623]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[624]:="],

Cell["RHI[{0, 0, OPEm, 0, 0}, {0, 1, 1, 0, 1}]", "Output",
 CellLabel->"Out[624]//InputForm="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["RHI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"RHI",
  ButtonNote->"RHI"],
 "."
}], "Text",
 CellTags->"FC2RHI"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FC2RHI"],

Cell[BoxData[""], "Input",
 CellTags->"FC2RHI",
 CellLabel->"In[625]:="]
}, Open  ]],

Cell["FC2TLI ", "ObjectName",
 CellTags->"FC2TLI"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FC2TLI"],

Cell["\<\
FC2TLI[exp, k1, k2] transforms all 2-loop OPE-integrals in FeynAmpDenominator \
form to the TLI-integrals.  The option IncludePair governs the inclusion  of \
scalar products p.k1, p.k2 and k1.k2 (setting True).\
\>", "Text",
 CellTags->"FC2TLI"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "FC2TLI", "]"}]], "Input",
 CellTags->"FC2TLI",
 CellLabel->"In[626]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dimension", "\[Rule]", "D"}], ",", 
    RowBox[{"IncludePair", "\[Rule]", "True"}], ",", 
    RowBox[{"Do", "\[Rule]", "True"}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FC2TLI",
 CellLabel->"Out[626]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "FAD"}]], "Input",
 CellLabel->"In[627]:="],

Cell[BoxData[
 StyleBox["\<\"FAD[q, q-p, ...] denotes 1/(q^2 (q-p)^2 ...).\\nFAD[{q1,m}, \
{q1-p,m}, q2, ...] is\\n1/( (q1^2 - m^2) ( (q1-p)^2 - m^2 ) q2^2 ... \
).\\n(Translation into FeynCalc internal form is performed \
by\\nFeynCalcInternal.)\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3387711966-3304885"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"FAD", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q1", ",", "m1"}], "}"}], ",", 
     RowBox[{"q2", "-", "q1"}], ",", 
     RowBox[{"q2", "-", "p"}]}], "]"}], " ", 
   RowBox[{
    RowBox[{"SP", "[", 
     RowBox[{"q1", ",", "OPEDelta"}], "]"}], "^", "OPEm"}]}]}]], "Input",
 CellLabel->"In[628]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       InterpretationBox[
        RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"q2", "-", "p"}], ")"}], "2"], 
         "\[InvisibleSpace]", "\<\"]\"\>"}],
        SequenceForm["[", (-$CellContext`p + $CellContext`q2)^2, "]"],
        Editable->False], ")"}], " ", 
      RowBox[{"(", 
       InterpretationBox[
        RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"q2", "-", "q1"}], ")"}], "2"], 
         "\[InvisibleSpace]", "\<\"]\"\>"}],
        SequenceForm["[", (-$CellContext`q1 + $CellContext`q2)^2, "]"],
        Editable->False], ")"}], " ", 
      RowBox[{"(", 
       InterpretationBox[
        RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
         SuperscriptBox["q1", "2"], "\[InvisibleSpace]", "\<\"-\"\>", 
         "\[InvisibleSpace]", 
         SuperscriptBox["m1", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
        SequenceForm["[", $CellContext`q1^2, "-", $CellContext`m1^2, "]"],
        Editable->False], ")"}]}]],
    TraditionalForm], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FormBox[
      RowBox[{
       FormBox["\[CapitalDelta]",
        TraditionalForm], "\[CenterDot]", 
       FormBox["q1",
        TraditionalForm]}],
      TraditionalForm], ")"}], "m"]}], TraditionalForm]], "Output",
 CellLabel->"Out[628]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FC2TLI", "[", 
  RowBox[{"t", ",", "q1", ",", "q2"}], "]"}]], "Input",
 CellLabel->"In[629]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox[
   StyleBox["T",
    FontFamily->"Times",
    FontWeight->"Bold"], 
   RowBox[{
    StyleBox["1",
     FontWeight->"Bold",
     FontColor->RGBColor[1, 0, 0]], 
    StyleBox["0",
     FontColor->RGBColor[0, 0, 1]], 
    StyleBox["0",
     FontColor->RGBColor[0, 0, 1]], 
    StyleBox["1",
     FontColor->RGBColor[0, 0, 1]], 
    StyleBox["1",
     FontColor->RGBColor[0, 0, 1]]}], 
   RowBox[{
    FormBox["m",
     TraditionalForm], 
    FormBox["0",
     TraditionalForm], 
    FormBox["0",
     TraditionalForm], 
    FormBox["0",
     TraditionalForm], 
    FormBox["0",
     TraditionalForm]}]], TraditionalForm]], "Output",
 CellLabel->"Out[629]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[630]:="],

Cell["TLI[{OPEm, 0, 0, 0, 0}, {{1, m1}, 0, 0, 1, 1}]", "Output",
 CellLabel->"Out[630]//InputForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TLI2FC", "[", "%", "]"}]], "Input",
 CellLabel->"In[631]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FormBox["\[CapitalDelta]",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q1",
       TraditionalForm]}], ")"}], "m"], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q2", "-", "p"}], ")"}], "2"], ".", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["q1", "2"], "-", 
      SuperscriptBox["m1", "2"]}], ")"}], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "q2"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellLabel->"Out[631]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["TLI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"TLI",
  ButtonNote->"TLI"],
 "."
}], "Text",
 CellTags->"FC2TLI"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FC2TLI"],

Cell[BoxData[""], "Input",
 CellTags->"FC2TLI",
 CellLabel->"In[632]:="]
}, Open  ]],

Cell["FDS", "ObjectName",
 CellTags->"FDS"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FDS"],

Cell["FDS is shorthand for FeynAmpDenominatorSimplify.", "Text",
 CellTags->"FDS"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynAmpDenominatorSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmpDenominatorSimplify",
  ButtonNote->"FeynAmpDenominatorSimplify"],
 "."
}], "Text",
 CellTags->"FDS"]
}, Open  ]],

Cell["FermionSpinSum", "ObjectName",
 CellTags->"FermionSpinSum"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FermionSpinSum"],

Cell["\<\
FermionSpinSum[x] constructs the Traces out of squared ampliudes.\
\>", "Text",
 CellTags->"FermionSpinSum"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "FermionSpinSum", "]"}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[633]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SpinPolarizationSum", "\[Rule]", "Identity"}], ",", 
    RowBox[{"SpinorCollect", "\[Rule]", "False"}], ",", 
    RowBox[{"ExtraFactor", "\[Rule]", "1"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[633]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Spinor",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Spinor",
  ButtonNote->"Spinor"],
 ", ",
 ButtonBox["ComplexConjugate",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ComplexConjugate",
  ButtonNote->"ComplexConjugate"],
 ", ",
 ButtonBox["DiracTrace",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrace",
  ButtonNote->"DiracTrace"],
 ", ",
 ButtonBox["Tr",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Tr",
  ButtonNote->"Tr"],
 "."
}], "Text",
 CellTags->"FermionSpinSum"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FermionSpinSum"],

Cell[TextData[{
 "Spinors of fermions of mass ",
 StyleBox["m",
  FontSlant->"Italic"],
 " are normalized to have square 2 ",
 StyleBox["m",
  FontSlant->"Italic"],
 " or -2 ",
 StyleBox["m",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"FermionSpinSum"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SpinorUBar", "[", 
   RowBox[{
    RowBox[{"Momentum", "[", "p", "]"}], ",", "m"}], "]"}], ".", 
  RowBox[{"SpinorU", "[", 
   RowBox[{
    RowBox[{"Momentum", "[", "p", "]"}], ",", "m"}], "]"}]}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[634]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FormBox[
     OverscriptBox["\<\"u\"\>", "_"],
     TraditionalForm], "(", 
    FormBox["p",
     TraditionalForm], ",", "m", ")"}], ".", 
   RowBox[{"u", "(", 
    FormBox["p",
     TraditionalForm], ",", "m", ")"}]}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[634]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "FCI"}], "//", "FermionSpinSum"}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[635]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"tr", "(", 
   FormBox[
    RowBox[{"m", "+", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p",
       TraditionalForm]}]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[635]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"DiracTrace", "\[Rule]", "TR"}]}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[636]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", "m"}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[636]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SpinorVBar", "[", 
   RowBox[{
    RowBox[{"Momentum", "[", "p", "]"}], ",", "m"}], "]"}], ".", 
  RowBox[{"SpinorV", "[", 
   RowBox[{
    RowBox[{"Momentum", "[", "p", "]"}], ",", "m"}], "]"}]}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[637]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FormBox[
     OverscriptBox["\<\"v\"\>", "_"],
     TraditionalForm], "(", 
    FormBox["p",
     TraditionalForm], ",", "m", ")"}], ".", 
   RowBox[{"v", "(", 
    FormBox["p",
     TraditionalForm], ",", "m", ")"}]}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[637]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "FCI"}], "//", "FermionSpinSum"}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[638]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"tr", "(", 
   FormBox[
    RowBox[{
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p",
       TraditionalForm]}], "-", "m"}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[638]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"DiracTrace", "\[Rule]", "TR"}]}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[639]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "4"}], " ", "m"}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[639]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"Spinor", "[", 
    RowBox[{"k1", ",", "m"}], "]"}], ".", 
   RowBox[{"DiracSlash", "[", "p", "]"}], ".", 
   RowBox[{"GA", "[", "5", "]"}], ".", 
   RowBox[{"Spinor", "[", 
    RowBox[{"p1", ",", "m"}], "]"}]}]}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[640]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CurlyPhi]", "(", 
    FormBox["k1",
     TraditionalForm], ",", "m", ")"}], ".", 
   RowBox[{"(", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", "5"], ".", 
   RowBox[{"\[CurlyPhi]", "(", 
    FormBox["p1",
     TraditionalForm], ",", "m", ")"}]}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[640]="]
}, Open  ]],

Cell["\<\
Notice that SpinorUBar and SpinorU are only input functions. Internally they \
are converted to Spinor objects.\
\>", "Text",
 CellTags->"FermionSpinSum"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ct", "=", 
  RowBox[{"ComplexConjugate", "[", "t", "]"}]}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[641]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    RowBox[{"\[CurlyPhi]", "(", 
     FormBox["p1",
      TraditionalForm], ",", "m", ")"}], ".", 
    SuperscriptBox["\[Gamma]", "5"], ".", 
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p",
       TraditionalForm]}], ")"}], ".", 
    RowBox[{"\[CurlyPhi]", "(", 
     FormBox["k1",
      TraditionalForm], ",", "m", ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[641]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FermionSpinSum", "[", 
  RowBox[{"t", " ", "ct"}], "]"}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[642]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{"tr", "(", 
    FormBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{
         FormBox["\<\"\[Gamma]\"\>",
          TraditionalForm], "\[CenterDot]", 
         FormBox["k1",
          TraditionalForm]}]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
         TraditionalForm], "\[CenterDot]", 
        FormBox["p",
         TraditionalForm]}], ")"}], ".", 
      SuperscriptBox["\[Gamma]", "5"], ".", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{
         FormBox["\<\"\[Gamma]\"\>",
          TraditionalForm], "\[CenterDot]", 
         FormBox["p1",
          TraditionalForm]}]}], ")"}], ".", 
      SuperscriptBox["\[Gamma]", "5"], ".", 
      RowBox[{"(", 
       RowBox[{
        FormBox["\<\"\[Gamma]\"\>",
         TraditionalForm], "\[CenterDot]", 
        FormBox["p",
         TraditionalForm]}], ")"}]}],
     TraditionalForm], ")"}]}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[642]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "/.", 
  RowBox[{"DiracTrace", "\[Rule]", "TR"}]}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[643]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "4"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], "2"], " ", 
      SuperscriptBox["m", "2"]}], "+", 
     RowBox[{
      RowBox[{
       FormBox["k1",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p1",
        TraditionalForm]}], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], "2"]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{
       FormBox["k1",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p",
        TraditionalForm]}], " ", 
      RowBox[{
       FormBox["p",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p1",
        TraditionalForm]}]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"FermionSpinSum",
 CellLabel->"Out[643]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"t", ",", " ", "ct"}], "]"}]], "Input",
 CellTags->"FermionSpinSum",
 CellLabel->"In[644]:="]
}, Open  ]],

Cell["FeynAmp", "ObjectName",
 CellTags->"FeynAmp"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynAmp"],

Cell["\<\
FeynAmp[q, amp] is the head of a Feynman amplitude. amp denotes the \
analytical expression for the amplitude and q is the integration variable. \
FeynAmp[q1, q2, amp] denotes a two-loop amplitude.\
\>", "Text",
 CellTags->"FeynAmp"],

Cell["\<\
FeynAmp has no functional properties and serves just as a head. There are \
however special typesetting rules attached.\
\>", "Text",
 CellTags->"FeynAmp"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Amplitude",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Amplitude",
  ButtonNote->"Amplitude"],
 "."
}], "Text",
 CellTags->"FeynAmp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynAmp"],

Cell["\<\
This is a 1-loop gluon self-energy amplitude (ignoring factors of (2 \[Pi])).\
\
\>", "Text",
 CellTags->"FeynAmp"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmp", "[", 
  RowBox[{"q", ",", 
   RowBox[{
    RowBox[{"GV", "[", 
     RowBox[{"p", ",", "\[Mu]", ",", "a", ",", " ", 
      RowBox[{"q", "-", "p"}], ",", "\[Alpha]", ",", "c", ",", " ", 
      RowBox[{"-", "q"}], ",", "\[Beta]", ",", "e"}], "]"}], " ", 
    RowBox[{"GP", "[", 
     RowBox[{
      RowBox[{"p", "-", "q"}], ",", " ", "\[Alpha]", ",", "c", ",", " ", 
      "\[Rho]", ",", "d"}], "]"}], 
    RowBox[{"GV", "[", 
     RowBox[{
      RowBox[{"-", "p"}], ",", "\[Nu]", ",", "b", ",", " ", 
      RowBox[{"p", "-", "q"}], ",", "\[Rho]", ",", "d", ",", " ", "q", ",", 
      "\[Sigma]", ",", "f"}], "]"}], " ", 
    RowBox[{"GP", "[", 
     RowBox[{
     "q", ",", " ", "\[Beta]", ",", "e", ",", " ", "\[Sigma]", ",", "f"}], 
     "]"}]}]}], "]"}]], "Input",
 CellTags->"FeynAmp",
 CellLabel->"In[645]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Integral]", 
   StyleBox[
    RowBox[{
     SuperscriptBox["\[DifferentialD]", "D"], "Global`q"}],
    ZeroWidthTimes->True], "(", 
   FormBox[
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[CapitalPi]", 
       RowBox[{"c", "d"}], 
       RowBox[{"\[Alpha]", "\[Rho]"}]], "(", 
      FormBox[
       RowBox[{"p", "-", "q"}],
       TraditionalForm], ")"}], " ", 
     RowBox[{
      SubsuperscriptBox["\[CapitalPi]", 
       RowBox[{"e", "f"}], 
       RowBox[{"\[Beta]", "\[Sigma]"}]], "(", "q", ")"}], " ", 
     RowBox[{
      SuperscriptBox["V", 
       RowBox[{
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm]}]], "(", 
      RowBox[{
       FormBox[
        RowBox[{"-", "p"}],
        TraditionalForm], 
       RowBox[{",", " "}], 
       FormBox[
        RowBox[{"p", "-", "q"}],
        TraditionalForm], 
       RowBox[{",", " "}], 
       FormBox["q",
        TraditionalForm]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["V", 
       RowBox[{
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Alpha]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["\[Beta]",
          TraditionalForm],
         TraditionalForm]}]], "(", 
      RowBox[{
       FormBox["p",
        TraditionalForm], 
       RowBox[{",", " "}], 
       FormBox[
        RowBox[{"q", "-", "p"}],
        TraditionalForm], 
       RowBox[{",", " "}], 
       FormBox[
        RowBox[{"-", "q"}],
        TraditionalForm]}], ")"}], " ", 
     SubscriptBox["f", 
      RowBox[{
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["c",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["e",
         TraditionalForm],
        TraditionalForm]}]], " ", 
     SubscriptBox["f", 
      RowBox[{
       FormBox[
        FormBox["b",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["d",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["f",
         TraditionalForm],
        TraditionalForm]}]]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"FeynAmp",
 CellLabel->"Out[645]="]
}, Open  ]],

Cell["This is a generic 2-loop amplitude.", "Text",
 CellTags->"FeynAmp"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmp", "[", 
  RowBox[{
   SubscriptBox["q", "1"], ",", 
   SubscriptBox["q", "2"], ",", "anyexpression"}], "]"}]], "Input",
 CellTags->"FeynAmp",
 CellLabel->"In[646]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Integral]", 
   RowBox[{
    StyleBox[
     RowBox[{
      SuperscriptBox["\[DifferentialD]", "D"], 
      SubscriptBox["q", "1"]}],
     ZeroWidthTimes->True], "\[Integral]", 
    RowBox[{
     SuperscriptBox["\[DifferentialD]", "D"], 
     SubscriptBox["q", "2"]}]}], "(", "anyexpression", ")"}], 
  TraditionalForm]], "Output",
 CellTags->"FeynAmp",
 CellLabel->"Out[646]="]
}, Open  ]]
}, Open  ]],

Cell["FeynAmpDenominator", "ObjectName",
 CellTags->"FeynAmpDenominator"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynAmpDenominator"],

Cell["\<\
FeynAmpDenominator[ PropagatorDenominator[ ... ], PropagatorDenominator[ ... \
], ...] is the head of the denominators of the propagators, i.e., \
FeynAmpDenominator[x] is the representation of 1/x .\
\>", "Text",
 CellTags->"FeynAmpDenominator"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FAD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FAD",
  ButtonNote->"FAD"],
 ", ",
 ButtonBox["FeynAmpDenominatorSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmpDenominatorSimplify",
  ButtonNote->"FeynAmpDenominatorSimplify"],
 "."
}], "Text",
 CellTags->"FeynAmpDenominator"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynAmpDenominator"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmpDenominator", "[", 
  RowBox[{"PropagatorDenominator", "[", 
   RowBox[{"p", ",", "m"}], "]"}], "]"}]], "Input",
 CellTags->"FeynAmpDenominator",
 CellLabel->"In[647]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["p", "2"], "-", 
    SuperscriptBox["m", "2"]}]], TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominator",
 CellLabel->"Out[647]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmpDenominator", "[", 
  RowBox[{
   RowBox[{"PropagatorDenominator", "[", 
    RowBox[{"p", ",", "m"}], "]"}], ",", 
   RowBox[{"PropagatorDenominator", "[", 
    RowBox[{
     RowBox[{"p", "-", "q"}], ",", "m"}], "]"}]}], "]"}]], "Input",
 CellTags->"FeynAmpDenominator",
 CellLabel->"In[648]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["p", "2"], "-", 
      SuperscriptBox["m", "2"]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "-", "q"}], ")"}], "2"], "-", 
      SuperscriptBox["m", "2"]}], ")"}]}]], TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominator",
 CellLabel->"Out[648]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"FeynAmpDenominator", "[", 
    RowBox[{"PropagatorDenominator", "[", 
     RowBox[{"p", ",", "m"}], "]"}], "]"}]}], ";"}]], "Input",
 CellTags->"FeynAmpDenominator",
 CellLabel->"In[649]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"t", "//", "FCI"}], "]"}]], "Input",
 CellTags->"FeynAmpDenominator",
 CellLabel->"In[650]:="],

Cell[BoxData[
 RowBox[{"FeynAmpDenominator", "[", 
  RowBox[{"PropagatorDenominator", "[", 
   RowBox[{
    RowBox[{"Momentum", "[", 
     RowBox[{"p", ",", "D"}], "]"}], ",", "m"}], "]"}], "]"}]], "Output",
 CellTags->"FeynAmpDenominator",
 CellLabel->"Out[650]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"t", "//", "FCE"}], "]"}]], "Input",
 CellTags->"FeynAmpDenominator",
 CellLabel->"In[651]:="],

Cell[BoxData[
 RowBox[{"FAD", "[", 
  RowBox[{"{", 
   RowBox[{"p", ",", "m"}], "}"}], "]"}]], "Output",
 CellTags->"FeynAmpDenominator",
 CellLabel->"Out[651]//StandardForm="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "t", "]"}], ";"}]], "Input",
 CellTags->"FeynAmpDenominator",
 CellLabel->"In[652]:="]
}, Open  ]],

Cell["FeynAmpDenominatorCombine", "ObjectName",
 CellTags->"FeynAmpDenominatorCombine"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynAmpDenominatorCombine"],

Cell["\<\
FeynAmpDenominatorCombine[expr] expands expr with respect to \
FeynAmpDenominator and combines products of FeynAmpDenominator in expr into \
one FeynAmpDenominator.\
\>", "Text",
 CellTags->"FeynAmpDenominatorCombine"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynAmpDenominatorSplit",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmpDenominatorSplit",
  ButtonNote->"FeynAmpDenominatorSplit"],
 "."
}], "Text",
 CellTags->"FeynAmpDenominatorCombine"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynAmpDenominatorCombine"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", " ", "=", " ", 
  RowBox[{
   RowBox[{"FAD", "[", "q", "]"}], " ", 
   RowBox[{"FAD", "[", 
    RowBox[{"q", "-", "p"}], "]"}]}]}]], "Input",
 CellTags->"FeynAmpDenominatorCombine",
 CellLabel->"In[653]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    FractionBox["1", 
     InterpretationBox[
      RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
       SuperscriptBox["q", "2"], "\[InvisibleSpace]", "\<\"]\"\>"}],
      SequenceForm["[", $CellContext`q^2, "]"],
      Editable->False]],
    TraditionalForm], " ", 
   FormBox[
    FractionBox["1", 
     InterpretationBox[
      RowBox[{"\<\"[\"\>", "\[InvisibleSpace]", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"q", "-", "p"}], ")"}], "2"], 
       "\[InvisibleSpace]", "\<\"]\"\>"}],
      SequenceForm["[", (-$CellContext`p + $CellContext`q)^2, "]"],
      Editable->False]],
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorCombine",
 CellLabel->"Out[653]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FeynAmpDenominatorCombine", "[", "%", "]"}], "//", "FCE"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FeynAmpDenominatorCombine",
 CellLabel->"In[654]:="],

Cell[BoxData[
 RowBox[{"FAD", "[", 
  RowBox[{"q", ",", 
   RowBox[{
    RowBox[{"-", "p"}], "+", "q"}]}], "]"}]], "Output",
 CellTags->"FeynAmpDenominatorCombine",
 CellLabel->"Out[654]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FeynAmpDenominatorSplit", "[", "%", "]"}], "//", "FCE"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FeynAmpDenominatorCombine",
 CellLabel->"In[655]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"FAD", "[", "q", "]"}], " ", 
  RowBox[{"FAD", "[", 
   RowBox[{
    RowBox[{"-", "p"}], "+", "q"}], "]"}]}]], "Output",
 CellTags->"FeynAmpDenominatorCombine",
 CellLabel->"Out[655]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["FeynAmpDenominatorSimplify", "ObjectName",
 CellTags->"FeynAmpDenominatorSimplify"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynAmpDenominatorSimplify"],

Cell["\<\
FeynAmpDenominatorSimplify[exp] tries to simplify each PropagatorDenominator \
in a canonical way. FeynAmpDenominatorSimplify[exp, q1] simplifies all \
FeynAmpDenominator's in exp in a canonical way, including some translation of \
momenta. FeynAmpDenominatorSimplify[exp, q1, q2] additionally removes \
integrals with no mass scale.\
\>", "Text",
 CellTags->"FeynAmpDenominatorSimplify"],

Cell["FDS can be used as an alias.", "Text",
 CellTags->"FeynAmpDenominatorSimplify"],

Cell[CellGroupData[{

Cell[BoxData["FDS"], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[656]:="],

Cell[BoxData[
 FormBox["FeynAmpDenominatorSimplify", TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"Out[656]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["OneLoopSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoopSimplify",
  ButtonNote->"OneLoopSimplify"],
 "."
}], "Text",
 CellTags->"FeynAmpDenominatorSimplify"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynAmpDenominatorSimplify"],

Cell[TextData[{
 "The cornerstone of dimensional regularization is that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["d", "n"], "k", " ", 
      RowBox[{
       RowBox[{"f", "(", "k", ")"}], "/", 
       SuperscriptBox["k", 
        RowBox[{"2", "m"}]]}]}]}], "=", " ", 
    RowBox[{"0", " ", "."}]}], TraditionalForm]]]
}], "Text",
 CellTags->"FeynAmpDenominatorSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmpDenominatorSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "k", "]"}], " ", 
    RowBox[{"FAD", "[", 
     RowBox[{"k", ",", "k"}], "]"}]}], ",", "k"}], "]"}]], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[657]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"Out[657]="]
}, Open  ]],

Cell[TextData[{
 "This brings ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"k", "-", 
         SubscriptBox["p", "1"]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"k", "-", 
         SubscriptBox["p", "2"]}], ")"}], "2"]}], ")"}]}], 
   TraditionalForm]]],
 " into a standard form."
}], "Text",
 CellTags->"FeynAmpDenominatorSimplify"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmpDenominatorSimplify", "[", 
  RowBox[{
   RowBox[{"FAD", "[", 
    RowBox[{
     RowBox[{"k", "-", 
      SubscriptBox["p", "1"]}], ",", 
     RowBox[{"k", "-", 
      SubscriptBox["p", "2"]}]}], "]"}], ",", "k"}], "]"}]], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[658]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["k", "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"k", "-", 
       SubscriptBox["p", "1"], "+", 
       SubscriptBox["p", "2"]}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"Out[658]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmpDenominatorSimplify", "[", 
  RowBox[{
   RowBox[{"FAD", "[", 
    RowBox[{"k", ",", "k", ",", 
     RowBox[{"k", "-", "q"}]}], "]"}], ",", "k"}], "]"}]], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[659]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["k", "2"], ".", 
    SuperscriptBox["k", "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"k", "-", "q"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"Out[659]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmpDenominatorSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "k", "]"}], 
    RowBox[{"FAD", "[", 
     RowBox[{"k", ",", 
      RowBox[{"k", "-", "q"}], ",", 
      RowBox[{"k", "-", "q"}]}], "]"}]}], ",", "k"}], "]"}]], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[660]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"f", "(", 
    RowBox[{"q", "-", "k"}], ")"}], 
   RowBox[{
    SuperscriptBox["k", "2"], ".", 
    SuperscriptBox["k", "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"k", "-", "q"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"Out[660]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"FeynAmpDenominatorSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"FAD", "[", 
      RowBox[{
       RowBox[{"k", "-", 
        SubscriptBox["p", "1"]}], ",", 
       RowBox[{"k", "-", 
        SubscriptBox["p", "2"]}]}], "]"}], " ", 
     RowBox[{"SPD", "[", 
      RowBox[{"k", ",", "k"}], "]"}]}], ",", "k"}], "]"}]}]], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[661]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     FormBox["k",
      TraditionalForm], "2"], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", 
        SubscriptBox["p", "1"], "+", 
        SubscriptBox["p", "2"]}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{
      FormBox["k",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       SubscriptBox["p", "2"],
       TraditionalForm]}]}], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", 
        SubscriptBox["p", "1"], "+", 
        SubscriptBox["p", "2"]}], ")"}], "2"]}]], "+", 
   FractionBox[
    SubsuperscriptBox["p", "2", "2"], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", 
        SubscriptBox["p", "1"], "+", 
        SubscriptBox["p", "2"]}], ")"}], "2"]}]]}], 
  TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"Out[661]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"SPC", "[", 
   RowBox[{"t", ",", "k", ",", 
    RowBox[{"FDS", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[662]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    SubsuperscriptBox["p", "2", "2"], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", 
        SubscriptBox["p", "1"], "+", 
        SubscriptBox["p", "2"]}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{
      FormBox["k",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       SubscriptBox["p", "2"],
       TraditionalForm]}]}], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "+", 
        SubscriptBox["p", "1"], "-", 
        SubscriptBox["p", "2"]}], ")"}], "2"]}]]}], 
  TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"Out[662]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OneLoopSimplify", "[", 
  RowBox[{"r", ",", "k"}], "]"}]], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[663]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{
      FormBox["k",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       SubscriptBox["p", "2"],
       TraditionalForm]}]}], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", 
        SubscriptBox["p", "1"], "+", 
        SubscriptBox["p", "2"]}], ")"}], "2"]}]], "+", 
   FractionBox[
    SubsuperscriptBox["p", "2", "2"], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", 
        SubscriptBox["p", "1"], "+", 
        SubscriptBox["p", "2"]}], ")"}], "2"]}]]}], 
  TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"Out[663]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FDS", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FAD", "[", 
     RowBox[{
      RowBox[{"k", "-", "p1"}], ",", 
      RowBox[{"k", "-", "p2"}]}], "]"}], 
    RowBox[{
     RowBox[{"SPD", "[", 
      RowBox[{"k", ",", "OPEDelta"}], "]"}], "^", "2"}]}], ",", "k"}], 
  "]"}]], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[664]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     FormBox[
      RowBox[{
       FormBox["k",
        TraditionalForm], "\[CenterDot]", 
       FormBox["\[CapitalDelta]",
        TraditionalForm]}],
      TraditionalForm], "2"], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", "p1", "+", "p2"}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{
      FormBox["k",
       TraditionalForm], "\[CenterDot]", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]}], " ", 
     RowBox[{
      FormBox["\[CapitalDelta]",
       TraditionalForm], "\[CenterDot]", 
      FormBox["p2",
       TraditionalForm]}]}], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", "p1", "+", "p2"}], ")"}], "2"]}]], "+", 
   FractionBox[
    SuperscriptBox[
     FormBox[
      RowBox[{
       FormBox["\[CapitalDelta]",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p2",
        TraditionalForm]}],
      TraditionalForm], "2"], 
    RowBox[{
     SuperscriptBox["k", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"k", "-", "p1", "+", "p2"}], ")"}], "2"]}]]}], 
  TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"Out[664]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"t", ",", "r"}], "]"}]], "Input",
 CellTags->"FeynAmpDenominatorSimplify",
 CellLabel->"In[665]:="]
}, Open  ]],

Cell["FeynAmpDenominatorSplit", "ObjectName",
 CellTags->"FeynAmpDenominatorSplit"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynAmpDenominatorSplit"],

Cell["\<\
FeynAmpDenominatorSplit[expr] splits all FeynAmpDenominator[a,b, ...] in expr \
into FeynAmpDenominator[a]*FeynAmpDenominator[b] ... . \
FeynAmpDenominatorSplit[expr, q1] splits all FeynAmpDenominator in expr into \
a product of two, one containing q1 and other momenta, the second without q1.\
\
\>", "Text",
 CellTags->"FeynAmpDenominatorSplit"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynAmpDenominatorCombine",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmpDenominatorCombine",
  ButtonNote->"FeynAmpDenominatorCombine"],
 "."
}], "Text",
 CellTags->"FeynAmpDenominatorSplit"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynAmpDenominatorSplit"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"FAD", "[", 
    RowBox[{"q1", ",", 
     RowBox[{"q1", "-", "p"}], ",", 
     RowBox[{"q1", "-", "q2"}], ",", "q2", ",", 
     RowBox[{"q2", "-", "p"}]}], "]"}], "//", "FCI"}]}]], "Input",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"In[666]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["q1", "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "p"}], ")"}], "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "q2"}], ")"}], "2"], ".", 
    SuperscriptBox["q2", "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q2", "-", "p"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"Out[666]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "//", "Head"}]], "Input",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"In[667]:="],

Cell[BoxData[
 FormBox["FeynAmpDenominator", TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"Out[667]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynAmpDenominatorSplit", "[", "t", "]"}]], "Input",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"In[668]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["q1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "p"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "q2"}], ")"}], "2"], " ", 
    SuperscriptBox["q2", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q2", "-", "p"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"Out[668]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "//", "FCE"}], "//", "StandardForm"}]], "Input",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"In[669]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"FAD", "[", "q1", "]"}], " ", 
  RowBox[{"FAD", "[", 
   RowBox[{
    RowBox[{"-", "p"}], "+", "q1"}], "]"}], " ", 
  RowBox[{"FAD", "[", 
   RowBox[{"q1", "-", "q2"}], "]"}], " ", 
  RowBox[{"FAD", "[", "q2", "]"}], " ", 
  RowBox[{"FAD", "[", 
   RowBox[{
    RowBox[{"-", "p"}], "+", "q2"}], "]"}]}]], "Output",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"Out[669]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FeynAmpDenominatorSplit", "[", 
    RowBox[{"t", ",", "q1"}], "]"}], "//", "FCE"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"In[670]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"FAD", "[", 
   RowBox[{"q2", ",", 
    RowBox[{
     RowBox[{"-", "p"}], "+", "q2"}]}], "]"}], " ", 
  RowBox[{"FAD", "[", 
   RowBox[{"q1", ",", 
    RowBox[{
     RowBox[{"-", "p"}], "+", "q1"}], ",", 
    RowBox[{"q1", "-", "q2"}]}], "]"}]}]], "Output",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"Out[670]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FeynAmpDenominatorCombine", "[", "%", "]"}], "//", "FCE"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"In[671]:="],

Cell[BoxData[
 RowBox[{"FAD", "[", 
  RowBox[{"q1", ",", "q2", ",", 
   RowBox[{"q1", "-", "q2"}], ",", 
   RowBox[{
    RowBox[{"-", "p"}], "+", "q1"}], ",", 
   RowBox[{
    RowBox[{"-", "p"}], "+", "q2"}]}], "]"}]], "Output",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"Out[671]//StandardForm="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "t", "]"}]], "Input",
 CellTags->"FeynAmpDenominatorSplit",
 CellLabel->"In[672]:="]
}, Open  ]],

Cell["FeynAmpList", "ObjectName",
 CellTags->"FeynAmpList"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynAmpList"],

Cell["\<\
FeynAmpList[info][FeynAmp[...], FeynAmp[...], ...] is a head of a list of \
Feynman amplitudes.\
\>", "Text",
 CellTags->"FeynAmpList"],

Cell["\<\
FeynAmpList has no functional properties and serves just as a head.\
\>", "Text",
 CellTags->"FeynAmpList"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynAmp",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynAmp",
  ButtonNote->"FeynAmp"],
 "."
}], "Text",
 CellTags->"FeynAmpList"]
}, Open  ]],

Cell["FeynCalc", "ObjectName",
 CellTags->"FeynCalc"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynCalc"],

Cell["FeynCalc is simply a symbol with a usage definition.", "Text",
 CellTags->"FeynCalc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "FeynCalc"}]], "Input",
 CellTags->"FeynCalc",
 CellLabel->"In[673]:="],

Cell[BoxData[
 StyleBox["\<\"For installation notes visit www.feyncalc.org\\n\\nFor a list \
of availabe objects type $FeynCalcStuff, which contains a list of all \
functions and options in StringForm. You can get on-line information by \
?function, e.g. ?Contract.\\n\\nThere are several useful functions for short \
input, type $FCS for a list of short commands. Then type, e.g., \
?GA.\\n\\n\\nTo enable/disable start-up messages, put the \
line\\n\\n$FeynCalcStartupMessages = \
True;\\n\\nor\\n\\n$FeynCalcStartupMessages = False;\\n\\n into your \
\\\"init.m\\\" file or into your \\\"FCConfig.m\\\" file.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->{"FeynCalc", "Info3387711973-8270308"}]
}, Open  ]]
}, Open  ]],

Cell["FeynCalcExternal", "ObjectName",
 CellTags->"FeynCalcExternal"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynCalcExternal"],

Cell["\<\
FeynCalcExternal[exp] translates exp from the internal FeynCalc \
representation to a shorthand form.\
\>", "Text",
 CellTags->"FeynCalcExternal"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalcInternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcInternal",
  ButtonNote->"FeynCalcInternal"],
 "."
}], "Text",
 CellTags->"FeynCalcExternal"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynCalcExternal"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynCalcExternal", "[", 
  RowBox[{"DiracGamma", "[", "5", "]"}], "]"}]], "Input",
 CellTags->"FeynCalcExternal",
 CellLabel->"In[674]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Gamma]", "5"], TraditionalForm]], "Output",
 CellTags->"FeynCalcExternal",
 CellLabel->"Out[674]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FeynCalcExternal",
 CellLabel->"In[675]:="],

Cell[BoxData[
 RowBox[{"GA", "[", "5", "]"}]], "Output",
 CellTags->"FeynCalcExternal",
 CellLabel->"Out[675]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Input",
 CellTags->"FeynCalcExternal",
 CellLabel->"In[676]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
    SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ",", 
    FormBox[
     RowBox[{
      FormBox["p",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}],
     TraditionalForm], ",", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
    SuperscriptBox["p", "\[Mu]"]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FeynCalcExternal",
 CellLabel->"Out[676]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FeynCalcExternal",
 CellLabel->"In[677]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Output",
 CellTags->"FeynCalcExternal",
 CellLabel->"Out[677]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FeynCalcInternal"}]], "Input",
 CellTags->"FeynCalcExternal",
 CellLabel->"In[678]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ",", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm]], ",", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox["p",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ",", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FeynCalcExternal",
 CellLabel->"Out[678]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FeynCalcExternal",
 CellLabel->"In[679]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DiracGamma", "[", 
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", 
      RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", "D"}], "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{"Momentum", "[", "p", "]"}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"Momentum", "[", "p", "]"}], ",", 
     RowBox[{"Momentum", "[", "q", "]"}]}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", "\[Alpha]", "]"}], ",", 
     RowBox[{"LorentzIndex", "[", "\[Beta]", "]"}]}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
     RowBox[{"Momentum", "[", "p", "]"}]}], "]"}]}], "}"}]], "Output",
 CellTags->"FeynCalcExternal",
 CellLabel->"Out[679]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynCalcExternal", "[", "%", "]"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FeynCalcExternal",
 CellLabel->"In[680]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Output",
 CellTags->"FeynCalcExternal",
 CellLabel->"Out[680]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["FeynCalcForm", "ObjectName",
 CellTags->"FeynCalcForm"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynCalcForm"],

Cell[TextData[{
 "FeynCalcForm[expr] changes the printed output to a an easy-to-read form. It \
allows a readable output also when running a terminal based ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. Whether the result of FeynCalcForm[expr] is displayed or not, \
depends on the setting of $PrePrint. $PrePrint = FeynCalcForm forces \
displaying everything after applying FeynCalcForm. In order to change to the \
normal (internal) Mathematica OutputForm, do: ($PrePrint=.)."
}], "Text",
 CellTags->"FeynCalcForm"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FC",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FC",
  ButtonNote->"FC"],
 ", ",
 ButtonBox["FeynCalcExternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcExternal",
  ButtonNote->"FeynCalcExternal"],
 ", ",
 ButtonBox["FeynCalcInternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcInternal",
  ButtonNote->"FeynCalcInternal"],
 "."
}], "Text",
 CellTags->"FeynCalcForm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynCalcForm"],

Cell["This is the normal notebook display:", "Text",
 CellTags->"FeynCalcForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SUNTrace", "[", 
  RowBox[{
   RowBox[{"SUNT", "[", "a", "]"}], ".", 
   RowBox[{"SUNT", "[", "b", "]"}], ".", 
   RowBox[{"SUNT", "[", "c", "]"}]}], "]"}]], "Input",
 CellTags->"FeynCalcForm",
 CellLabel->"In[681]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"tr", "(", 
   FormBox[
    RowBox[{
     SubscriptBox["T", 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubscriptBox["T", 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubscriptBox["T", 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"FeynCalcForm",
 CellLabel->"Out[681]="]
}, Open  ]],

Cell["\<\
This is the shorthand (terminal) display (easy-to-read form):\
\>", "Text",
 CellTags->"FeynCalcForm"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", " ", "=", " ", "FeynCalcForm"}], ";"}]], "Input",
 CellTags->"FeynCalcForm",
 CellLabel->"In[682]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"$FrontEnd", ",", 
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Options", "[", 
         RowBox[{"$FrontEnd", ",", "\"\<CommonDefaultFormatTypes\>\""}], 
         "]"}], "/.", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\"\<Output\>\"", "\[Rule]", "_"}], ")"}], "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"\"\<Output\>\"", "\[Rule]", "OutputForm"}], ")"}]}]}], 
       ")"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}], ";"}]], "Input",
 CellTags->"FeynCalcForm",
 CellLabel->"In[683]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SUNTrace", "[", 
  RowBox[{
   RowBox[{"SUNT", "[", "a", "]"}], ".", 
   RowBox[{"SUNT", "[", "b", "]"}], ".", 
   RowBox[{"SUNT", "[", "c", "]"}]}], "]"}]], "Input",
 CellTags->"FeynCalcForm",
 CellLabel->"In[684]:="],

Cell[OutputFormData["\<\
SUNTrace[SUNT[SUNIndex[a]] . SUNT[SUNIndex[b]] . SUNT[SUNIndex[c]]]\
\>", "\<\
tr[T[a] T[b] T[c]]\
\>"], "Output",
 CellTags->"FeynCalcForm",
 CellLabel->"Out[684]="]
}, Open  ]],

Cell["Reset to normal notebook display:", "Text",
 CellTags->"FeynCalcForm"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=."}], ";"}]], "Input",
 CellTags->"FeynCalcForm",
 CellLabel->"In[685]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"$FrontEnd", ",", 
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Options", "[", 
         RowBox[{"$FrontEnd", ",", "\"\<CommonDefaultFormatTypes\>\""}], 
         "]"}], "/.", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\"\<Output\>\"", "\[Rule]", "_"}], ")"}], "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"\"\<Output\>\"", "\[Rule]", "TraditionalForm"}], ")"}]}]}],
        ")"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}], ";"}]], "Input",
 CellTags->"FeynCalcForm",
 CellLabel->"In[686]:="]
}, Open  ]],

Cell["FeynCalcInternal", "ObjectName",
 CellTags->"FeynCalcInternal"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynCalcInternal"],

Cell["\<\
FeynCalcInternal[exp] translates exp into the internal FeynCalc (abstract \
data-type) representation.\
\>", "Text",
 CellTags->"FeynCalcInternal"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalcExternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcExternal",
  ButtonNote->"FeynCalcExternal"],
 ", ",
 ButtonBox["FCI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCI",
  ButtonNote->"FCI"],
 ", ",
 ButtonBox["FCE",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCE",
  ButtonNote->"FCE"],
 "."
}], "Text",
 CellTags->"FeynCalcInternal"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynCalcInternal"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Input",
 CellTags->"FeynCalcInternal",
 CellLabel->"In[687]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], ",", 
    SuperscriptBox["\[Gamma]", "\[Rho]"], ",", 
    RowBox[{"\[Gamma]", "\[CenterDot]", "p"}], ",", 
    FormBox[
     RowBox[{
      FormBox["p",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}],
     TraditionalForm], ",", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
    SuperscriptBox["p", "\[Mu]"]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FeynCalcInternal",
 CellLabel->"Out[687]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FeynCalcInternal",
 CellLabel->"In[688]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Output",
 CellTags->"FeynCalcInternal",
 CellLabel->"Out[688]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FeynCalcInternal"}]], "Input",
 CellTags->"FeynCalcInternal",
 CellLabel->"In[689]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ",", 
    SuperscriptBox["\[Gamma]", 
     FormBox[
      FormBox["\[Rho]",
       TraditionalForm],
      TraditionalForm]], ",", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox["p",
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox["p",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}], ",", 
    SuperscriptBox["g", 
     RowBox[{"\[Alpha]", "\[Beta]"}]], ",", 
    SuperscriptBox[
     FormBox["p",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FeynCalcInternal",
 CellLabel->"Out[689]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FeynCalcInternal",
 CellLabel->"In[690]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DiracGamma", "[", 
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", 
      RowBox[{"\[Rho]", ",", "D"}], "]"}], ",", "D"}], "]"}], ",", 
   RowBox[{"DiracGamma", "[", 
    RowBox[{"Momentum", "[", "p", "]"}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"Momentum", "[", "p", "]"}], ",", 
     RowBox[{"Momentum", "[", "q", "]"}]}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", "\[Alpha]", "]"}], ",", 
     RowBox[{"LorentzIndex", "[", "\[Beta]", "]"}]}], "]"}], ",", 
   RowBox[{"Pair", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
     RowBox[{"Momentum", "[", "p", "]"}]}], "]"}]}], "}"}]], "Output",
 CellTags->"FeynCalcInternal",
 CellLabel->"Out[690]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynCalcExternal", "[", "%", "]"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FeynCalcInternal",
 CellLabel->"In[691]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GA", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"GAD", "[", "\[Rho]", "]"}], ",", 
   RowBox[{"GS", "[", "p", "]"}], ",", 
   RowBox[{"SP", "[", 
    RowBox[{"p", ",", "q"}], "]"}], ",", 
   RowBox[{"MT", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}]}], "}"}]], "Output",
 CellTags->"FeynCalcInternal",
 CellLabel->"Out[691]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FCI", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SD", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"SUND", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
    RowBox[{"SUNF", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
    RowBox[{"FAD", "[", "q", "]"}], ",", 
    RowBox[{"LC", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], "]"}]}],
    "}"}], "]"}]], "Input",
 CellTags->"FeynCalcInternal",
 CellLabel->"In[692]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]}]], ",", 
    SubscriptBox["d", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]}]], ",", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]}]], ",", 
    FractionBox["1", 
     SuperscriptBox["q", "2"]], ",", 
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}]]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FeynCalcInternal",
 CellLabel->"Out[692]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FeynCalcInternal",
 CellLabel->"In[693]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SUNDelta", "[", 
    RowBox[{
     RowBox[{"SUNIndex", "[", "a", "]"}], ",", 
     RowBox[{"SUNIndex", "[", "b", "]"}]}], "]"}], ",", 
   RowBox[{"SUND", "[", 
    RowBox[{
     RowBox[{"SUNIndex", "[", "a", "]"}], ",", 
     RowBox[{"SUNIndex", "[", "b", "]"}], ",", 
     RowBox[{"SUNIndex", "[", "c", "]"}]}], "]"}], ",", 
   RowBox[{"SUNF", "[", 
    RowBox[{
     RowBox[{"SUNIndex", "[", "a", "]"}], ",", 
     RowBox[{"SUNIndex", "[", "b", "]"}], ",", 
     RowBox[{"SUNIndex", "[", "c", "]"}]}], "]"}], ",", 
   RowBox[{"FeynAmpDenominator", "[", 
    RowBox[{"PropagatorDenominator", "[", 
     RowBox[{
      RowBox[{"Momentum", "[", 
       RowBox[{"q", ",", "D"}], "]"}], ",", "0"}], "]"}], "]"}], ",", 
   RowBox[{"Eps", "[", 
    RowBox[{
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
     RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}], ",", 
     RowBox[{"LorentzIndex", "[", "\[Rho]", "]"}], ",", 
     RowBox[{"LorentzIndex", "[", "\[Sigma]", "]"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->"FeynCalcInternal",
 CellLabel->"Out[693]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["FeynCalc2FORM", "ObjectName",
 CellTags->"FeynCalc2FORM"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynCalc2FORM"],

Cell["\<\
FeynCalc2FORM[expr] displays expr in FORM syntax. FeynCalc2FORM[file, x] \
writes x in FORM syntax to a file. FeynCalc2FORM[file, x==y] writes x=y to a \
file in FORM syntax.\
\>", "Text",
 CellTags->"FeynCalc2FORM"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FORM2FeynCalc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FORM2FeynCalc",
  ButtonNote->"FORM2FeynCalc"],
 "."
}], "Text",
 CellTags->"FeynCalc2FORM"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "FeynCalc2FORM", "]"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[694]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EpsDiscard", "\[Rule]", "False"}], ",", 
    RowBox[{"FORMEpilog", "\[Rule]", "\<\"\"\>"}], ",", 
    RowBox[{"FORMProlog", "\[Rule]", "\<\"write statistics;\"\>"}], ",", 
    RowBox[{"Replace", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\<\"\\\\[Alpha]\"\>", "\[Rule]", "\<\"al\"\>"}], ",", 
       RowBox[{"\<\"\\\\[Beta]\"\>", "\[Rule]", "\<\"be\"\>"}], ",", 
       RowBox[{"\<\"\\\\[Gamma]\"\>", "\[Rule]", "\<\"ga\"\>"}], ",", 
       RowBox[{"\<\"\\\\[Delta]\"\>", "\[Rule]", "\<\"de\"\>"}], ",", 
       RowBox[{"\<\"\\\\[Mu]\"\>", "\[Rule]", "\<\"mu\"\>"}], ",", 
       RowBox[{"\<\"\\\\[Nu]\"\>", "\[Rule]", "\<\"nu\"\>"}], ",", 
       RowBox[{"\<\"\\\\[Rho]\"\>", "\[Rule]", "\<\"ro\"\>"}], ",", 
       RowBox[{"\<\"\\\\[Sigma]\"\>", "\[Rule]", "\<\"si\"\>"}]}], "}"}]}], 
    ",", 
    RowBox[{"TraceDimension", "\[Rule]", "4"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FeynCalc2FORM",
 CellLabel->"Out[694]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynCalc2FORM"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MT", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], 
  RowBox[{"FV", "[", 
   RowBox[{"p", ",", "\[Rho]"}], "]"}], " ", 
  RowBox[{
   RowBox[{"y", "^", "2"}], "/", "d"}]}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[695]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    SuperscriptBox["y", "2"], " ", 
    SuperscriptBox["p", "\[Rho]"], " ", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Nu]"}]]}], "d"], TraditionalForm]], "Output",
 CellTags->"FeynCalc2FORM",
 CellLabel->"Out[695]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynCalc2FORM", "[", "%", "]"}], ";"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[696]:="],

Cell["(y^2*d_(mu,nu)*p(ro))/d", "Print",
 CellTags->"FeynCalc2FORM"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"LC", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Delta]", ",", "\[Rho]"}], 
   "]"}]}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[697]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Epsilon]", 
   RowBox[{"\[Alpha]", "\[Beta]", "\[Delta]", "\[Rho]"}]], 
  TraditionalForm]], "Output",
 CellTags->"FeynCalc2FORM",
 CellLabel->"Out[697]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynCalc2FORM", "[", "%", "]"}], ";"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[698]:="],

Cell["(-i_)*e_(al,be,de,ro)", "Print",
 CellTags->"FeynCalc2FORM"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrace", "[", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], "]"}], 
  "]"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[699]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"tr", "(", 
   FormBox[
    RowBox[{
     SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
     SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
     SuperscriptBox["\[Gamma]", "\[Rho]"], ".", 
     SuperscriptBox["\[Gamma]", "\[Sigma]"]}],
    TraditionalForm], ")"}], TraditionalForm]], "Output",
 CellTags->"FeynCalc2FORM",
 CellLabel->"Out[699]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynCalc2FORM", "[", "%", "]"}], ";"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[700]:="],

Cell["g_(0,mu)*g_(0,nu)*g_(0,ro)*g_(0,si)", "Print",
 CellTags->"FeynCalc2FORM"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DiracTrace", "[", 
   RowBox[{"GA", "[", 
    RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "]"}], 
  RowBox[{"DiracTrace", "[", 
   RowBox[{"GA", "[", 
    RowBox[{"\[Mu]", ",", "\[Rho]"}], "]"}], "]"}]}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[701]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"tr", "(", 
    FormBox[
     RowBox[{
      SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
      SuperscriptBox["\[Gamma]", "\[Nu]"]}],
     TraditionalForm], ")"}], " ", 
   RowBox[{"tr", "(", 
    FormBox[
     RowBox[{
      SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
      SuperscriptBox["\[Gamma]", "\[Rho]"]}],
     TraditionalForm], ")"}]}], TraditionalForm]], "Output",
 CellTags->"FeynCalc2FORM",
 CellLabel->"Out[701]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynCalc2FORM", "[", "%", "]"}], ";"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[702]:="],

Cell["g_(0,mu)*g_(0,nu)*g_(1,mu)*g_(1,ro)", "Print",
 CellTags->"FeynCalc2FORM"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynCalc2FORM", "[", 
   RowBox[{"\"\<fc2ftest.f\>\"", ",", 
    RowBox[{
     RowBox[{"MT", "[", 
      RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], 
     RowBox[{"FV", "[", 
      RowBox[{"p", ",", "\[Mu]"}], "]"}]}]}], "]"}], ";"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[703]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"$OperatingSystem", "===", "\"\<MacOS\>\""}], ",", "\"\<:\>\"", 
      ",", "\"\<\>\""}], "]"}], "<>", "\"\<fc2ftest.f\>\""}], ",", "String"}],
   "]"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[704]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", "\<\"d_(mu,nu)*p(mu)\"\>", "}"}], TraditionalForm]], "Output",
 CellTags->"FeynCalc2FORM",
 CellLabel->"Out[704]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"TR", "[", 
   RowBox[{
    RowBox[{"GA", "[", 
     RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], "]"}], 
    ".", 
    RowBox[{"GS", "[", 
     RowBox[{"p", ",", "q"}], "]"}]}], "]"}]}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[705]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
     RowBox[{
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Rho]", "\[Sigma]"}]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      RowBox[{
       FormBox["p",
        TraditionalForm], "\[CenterDot]", 
       FormBox["q",
        TraditionalForm]}], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
     RowBox[{
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Rho]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Rho]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Rho]",
         TraditionalForm],
        TraditionalForm]]}], "-", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Rho]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]]}], "-", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Rho]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]]}], "-", 
     RowBox[{
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]]}], "-", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Rho]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]], " ", 
      RowBox[{
       FormBox["p",
        TraditionalForm], "\[CenterDot]", 
       FormBox["q",
        TraditionalForm]}]}], "-", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
      RowBox[{
       FormBox["p",
        TraditionalForm], "\[CenterDot]", 
       FormBox["q",
        TraditionalForm]}]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"FeynCalc2FORM",
 CellLabel->"Out[705]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynCalc2FORM", "[", 
   RowBox[{"\"\<fc2ftest.f\>\"", ",", 
    RowBox[{"L", " ", "==", "t"}]}], "]"}], ";"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[706]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"ReadList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"$OperatingSystem", "===", "\"\<MacOS\>\""}], ",", "\"\<:\>\"",
        ",", "\"\<\>\""}], "]"}], "<>", "\"\<fc2ftest.f\>\""}], ",", 
    "String"}], "]"}], "]"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[707]:="],

Cell[BoxData[
 FormBox[
  TagBox[
   TagBox[GridBox[{
      {"\<\"Indices \\\\[Mu],\\\\[Nu],\\\\[Rho],\\\\[Sigma];\"\>"},
      {"\<\"Vectors p,q;\"\>"},
      {"\<\"write statistics;\"\>"},
      {"\<\"Local L = ( \"\>"},
      {"\<\"4*(d_(mu,si)*d_(nu,ro)*q.p-d_(mu,ro)*d_(nu,si)*q.p+d_(mu,nu)*d_(\
ro,si)*q.p+\"\>"},
      {"\<\"d_(ro,si)*p(nu)*q(mu)-d_(nu,si)*p(ro)*q(mu)+d_(nu,ro)*p(si)*q(mu)-\
\"\>"},
      {"\<\"d_(ro,si)*p(mu)*q(nu)+d_(mu,si)*p(ro)*q(nu)-d_(mu,ro)*p(si)*q(nu)+\
\"\>"},
      {"\<\"d_(nu,si)*p(mu)*q(ro)-d_(mu,si)*p(nu)*q(ro)+d_(mu,nu)*p(si)*q(ro)-\
\"\>"},
      {"\<\"d_(nu,ro)*p(mu)*q(si)+d_(mu,ro)*p(nu)*q(si)-d_(mu,nu)*p(ro)*q(si))\
 ); \"\>"},
      {"\<\"   \"\>"},
      {"\<\"Print; \"\>"},
      {"\<\".end\"\>"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column],
   Function[BoxForm`e$, 
    TableForm[BoxForm`e$]]], TraditionalForm]], "Output",
 CellTags->"FeynCalc2FORM",
 CellLabel->"Out[707]//TableForm="]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"FileNames", "[", "\"\<fc2ftest.f\>\"", "]"}], "=!=", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"DeleteFile", "[", "\"\<fc2ftest.f\>\"", "]"}]}], "]"}], 
  ";"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[708]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "t", "]"}], ";"}]], "Input",
 CellTags->"FeynCalc2FORM",
 CellLabel->"In[709]:="]
}, Open  ]],

Cell["FeynCalcToLaTeX", "ObjectName",
 CellTags->"FeynCalcToLaTeX"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynCalcToLaTeX"],

Cell["\<\
FeynCalcToLaTeX[expr] generates LaTeX with line-breaking  for expr. 
FeynCalcToLaTeX[expr, 500] generates LaTeX for expr where 500 is the Window \
width  setting for the Mathematica frontend. Increasing its value will \
generate less line breaks.\
\>", "Text",
 CellTags->"FeynCalcToLaTeX"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GluonPropagator", "[", 
   RowBox[{"p", ",", "1", ",", "2"}], "]"}], "//", "Explicit"}]], "Input",
 CellLabel->"In[710]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["g", 
      RowBox[{"li1", "li2"}]], " ", 
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        FormBox["ci1",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["ci2",
         TraditionalForm],
        TraditionalForm]}]]}], 
    SuperscriptBox["p", "2"]]}], TraditionalForm]], "Output",
 CellLabel->"Out[710]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FeynCalcToLaTeX", "[", "%", "]"}]], "Input",
 CellLabel->"In[711]:="],

Cell[BoxData[
 FormBox["\<\"%% AMS-LaTeX Created by Wolfram Mathematica \
6.0\\\\documentclass{article}\\n\\\\usepackage{amsmath, amssymb, \
graphics}\\\\newcommand{\\\\mathsym}[1]{{}}\\n\\\\newcommand{\\\\unicode}{{}}\
\\\\begin{document}\\\\noindent\\\\(-\\\\frac{i \
g^{\\\\text{li1}\\\\text{li2}} \\\\delta \
_{\\\\text{ci1}\\\\text{ci2}}}{p^2}\\\\)\"\>", TraditionalForm]], "Output",
 CellLabel->"Out[711]="]
}, Open  ]]
}, Open  ]],

Cell["FeynmanParameterNames", "ObjectName",
 CellTags->"FeynmanParameterNames"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynmanParameterNames"],

Cell["\<\
FeynmanParameterNames is an option for FeynmanParametrize and \
FeynmanParametrize.\
\>", "Text",
 CellTags->"FeynmanParameterNames"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynmanParametrize",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynmanParametrize",
  ButtonNote->"FeynmanParametrize"],
 ", ",
 ButtonBox["FeynmanParametrize",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynmanParametrize",
  ButtonNote->"FeynmanParametrize"],
 "."
}], "Text",
 CellTags->"FeynmanParameterNames"]
}, Open  ]],

Cell["FeynmanParametrize ***unfinished***", "ObjectName",
 CellTags->"FeynmanParametrize"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynmanParametrize"],

Cell["\<\
FeynmanParametrize[exp,k] introduces feynman parameters for all one-loop \
integrals in exp (k = integration momentum).\
\>", "Text",
 CellTags->"FeynmanParametrize"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "FeynmanParametrize", "]"}]], "Input",
 CellTags->"FeynmanParametrize",
 CellLabel->"In[712]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"FeynmanParameterNames", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FeynmanParametrize",
 CellLabel->"Out[712]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynmanParametrize"],

Cell[BoxData[""], "Input",
 CellTags->"FeynmanParametrize",
 CellLabel->"In[713]:="]
}, Open  ]],

Cell["FeynRule", "ObjectName",
 CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FeynRule"],

Cell["\<\
FeynRule[lag, {fields}] derives the Feynman rule corresponding to the field \
configuration fields of the lagrangian lag.\
\>", "Text",
 CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "FeynRule", "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[714]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Anti5", "\[Rule]", 
     RowBox[{"-", "\[Infinity]"}]}], ",", 
    RowBox[{"Contract", "\[Rule]", "False"}], ",", 
    RowBox[{"Factor1", "\[Rule]", "False"}], ",", 
    RowBox[{"FinalSubstitutions", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"PartialD", "\[Rule]", "RightPartialD"}], ",", 
    RowBox[{"Schouten", "\[Rule]", "False"}], ",", 
    RowBox[{"ZeroMomentumInsertion", "\[Rule]", "True"}], ",", 
    RowBox[{"InitialFunction", "\[Rule]", "Identity"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[714]="]
}, Open  ]],

Cell["FeynRule does not calculate propagator Feynman rules.", "Text",
 CellTags->"FeynRule"],

Cell["\<\
The option ZeroMomentumInsertion can be used for twist-2 and higher twist \
operators.\
\>", "Text",
 CellTags->"FeynRule"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Lagrangian",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Lagrangian",
  ButtonNote->"Lagrangian"],
 "."
}], "Text",
 CellTags->"FeynRule"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gou", "=", 
  RowBox[{"Lagrangian", "[", "\"\<ogu\>\"", "]"}]}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[715]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["\[ImaginaryI]", 
    RowBox[{"m", "-", "1"}]], " ", 
   RowBox[{
    SubsuperscriptBox["F", 
     RowBox[{"\[Alpha]", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]}], "a"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      SubsuperscriptBox["D", 
       FormBox["\[CapitalDelta]",
        TraditionalForm], 
       RowBox[{"a", "b"}]], ")"}], 
     RowBox[{"m", "-", "2"}]], ".", 
    SubsuperscriptBox["F", 
     RowBox[{"\[Alpha]", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]}], "b"]}]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[715]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gop", "=", 
  RowBox[{"Lagrangian", "[", "\"\<ogp\>\"", "]"}]}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[716]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["\[ImaginaryI]", "m"], " ", 
   RowBox[{
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Alpha]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Beta]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Gamma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]}]], ".", 
    SubsuperscriptBox["F", 
     RowBox[{"\[Beta]", "\[Gamma]"}], "a"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      SubsuperscriptBox["D", 
       FormBox["\[CapitalDelta]",
        TraditionalForm], 
       RowBox[{"a", "b"}]], ")"}], 
     RowBox[{"m", "-", "2"}]], ".", 
    SubsuperscriptBox["F", 
     RowBox[{"\[Alpha]", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]}], "b"]}]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[716]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Explicit", "[", "gop", "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[717]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox["\[ImaginaryI]", "m"], " ", 
   RowBox[{
    SuperscriptBox["\[Epsilon]", 
     RowBox[{
      FormBox[
       FormBox["\[Alpha]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Beta]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Gamma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox["\[CapitalDelta]",
       TraditionalForm]}]], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Beta]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox[
        FormBox["A",
         TraditionalForm], 
        FormBox[
         FormBox["\[Gamma]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "-", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Gamma]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox[
        FormBox["A",
         TraditionalForm], 
        FormBox[
         FormBox["\[Beta]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       RowBox[{
        SubsuperscriptBox[
         FormBox["A",
          TraditionalForm], 
         FormBox[
          FormBox["\[Beta]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b2",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubsuperscriptBox[
         FormBox["A",
          TraditionalForm], 
         FormBox[
          FormBox["\[Gamma]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["c17",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       SubscriptBox["f", 
        RowBox[{
         FormBox[
          FormBox["a",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b2",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["c17",
           TraditionalForm],
          TraditionalForm]}]]}]}], ")"}], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      SubsuperscriptBox["D", 
       FormBox["\[CapitalDelta]",
        TraditionalForm], 
       RowBox[{"a", "b"}]], ")"}], 
     RowBox[{"m", "-", "2"}]], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Alpha]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       SubsuperscriptBox[
        FormBox["A",
         TraditionalForm], 
        FormBox["\[CapitalDelta]",
         TraditionalForm], 
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm]]}], "-", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox["\[CapitalDelta]",
         TraditionalForm]], 
       SubsuperscriptBox[
        FormBox["A",
         TraditionalForm], 
        FormBox[
         FormBox["\[Alpha]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm]]}], "+", 
      RowBox[{
       SubscriptBox["g", "s"], " ", 
       RowBox[{
        SubsuperscriptBox[
         FormBox["A",
          TraditionalForm], 
         FormBox[
          FormBox["\[Alpha]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b3",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubsuperscriptBox[
         FormBox["A",
          TraditionalForm], 
         FormBox["\[CapitalDelta]",
          TraditionalForm], 
         FormBox[
          FormBox["c18",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       SubscriptBox["f", 
        RowBox[{
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b3",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["c18",
           TraditionalForm],
          TraditionalForm]}]]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[717]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases2", "[", 
  RowBox[{"%", ",", "QuantumField"}], "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[718]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Alpha]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b3",
       TraditionalForm],
      TraditionalForm]], ",", 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Beta]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b2",
       TraditionalForm],
      TraditionalForm]], ",", 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Gamma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c17",
       TraditionalForm],
      TraditionalForm]], ",", 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox["\[CapitalDelta]",
      TraditionalForm], 
     FormBox[
      FormBox["c18",
       TraditionalForm],
      TraditionalForm]], ",", 
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Alpha]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox["\[CapitalDelta]",
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], ",", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Beta]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Gamma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]]}], ",", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Gamma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Beta]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]]}], ",", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Alpha]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[718]="]
}, Open  ]],

Cell["2-gluon Feynman rules (unpolarized)", "Text",
 CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fi", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Mu]", "}"}], ",", 
       RowBox[{"{", "a", "}"}]}], "]"}], "[", "p", "]"}], ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Nu]", "}"}], ",", 
       RowBox[{"{", "b", "}"}]}], "]"}], "[", "q", "]"}]}], "}"}]}]], "Input",\

 CellTags->"FeynRule",
 CellLabel->"In[719]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]], "(", "p", ")"}], ",", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], "(", "q", ")"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[719]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2u", "=", 
  RowBox[{"FullSimplify", "/@", 
   RowBox[{"Factor2", "[", 
    RowBox[{"FeynRule", "[", 
     RowBox[{"gou", ",", "fi", ",", 
      RowBox[{"ZeroMomentumInsertion", "\[Rule]", "False"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[720]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        FormBox[
         RowBox[{
          FormBox["\[CapitalDelta]",
           TraditionalForm], "\[CenterDot]", 
          FormBox["q",
           TraditionalForm]}],
         TraditionalForm], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FormBox["\[CapitalDelta]",
           TraditionalForm], "\[CenterDot]", 
          FormBox["p",
           TraditionalForm]}], ")"}], "m"]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FormBox["\[CapitalDelta]",
           TraditionalForm], "\[CenterDot]", 
          FormBox["q",
           TraditionalForm]}], ")"}], "m"], " ", 
       SuperscriptBox[
        FormBox[
         RowBox[{
          FormBox["\[CapitalDelta]",
           TraditionalForm], "\[CenterDot]", 
          FormBox["p",
           TraditionalForm]}],
         TraditionalForm], "2"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        FormBox["q",
         TraditionalForm], 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], " ", 
       SuperscriptBox[
        FormBox["\[CapitalDelta]",
         TraditionalForm], 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm]], " ", 
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["p",
         TraditionalForm]}]}], "-", 
      RowBox[{
       SuperscriptBox["g", 
        RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}], " ", 
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["p",
         TraditionalForm]}]}], "+", 
      RowBox[{
       SuperscriptBox[
        FormBox["\[CapitalDelta]",
         TraditionalForm], 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           FormBox["p",
            TraditionalForm], 
           FormBox[
            FormBox["\[Nu]",
             TraditionalForm],
            TraditionalForm]], " ", 
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q",
            TraditionalForm]}]}], "-", 
         RowBox[{
          SuperscriptBox[
           FormBox["\[CapitalDelta]",
            TraditionalForm], 
           FormBox[
            FormBox["\[Nu]",
             TraditionalForm],
            TraditionalForm]], " ", 
          RowBox[{
           FormBox["p",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q",
            TraditionalForm]}]}]}], ")"}]}]}], ")"}], " ", 
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]}]]}], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     FormBox[
      RowBox[{
       FormBox["\[CapitalDelta]",
        TraditionalForm], "\[CenterDot]", 
       FormBox["p",
        TraditionalForm]}],
      TraditionalForm], "2"], " ", 
    SuperscriptBox[
     FormBox[
      RowBox[{
       FormBox["\[CapitalDelta]",
        TraditionalForm], "\[CenterDot]", 
       FormBox["q",
        TraditionalForm]}],
      TraditionalForm], "2"]}]], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[720]="]
}, Open  ]],

Cell["2-gluon Feynman rules (polarized)", "Text",
 CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fi", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Mu]", "}"}], ",", 
       RowBox[{"{", "a", "}"}]}], "]"}], "[", "p", "]"}], ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Nu]", "}"}], ",", 
       RowBox[{"{", "b", "}"}]}], "]"}], "[", "q", "]"}]}], "}"}]}]], "Input",\

 CellTags->"FeynRule",
 CellLabel->"In[721]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]], "(", "p", ")"}], ",", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], "(", "q", ")"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[721]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2p", "=", 
  RowBox[{"FullSimplify", "/@", 
   RowBox[{"Factor2", "[", 
    RowBox[{"FeynRule", "[", 
     RowBox[{"gop", ",", "fi", ",", 
      RowBox[{"ZeroMomentumInsertion", "\[Rule]", "False"}]}], "]"}], 
    "]"}]}]}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[722]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["p",
            TraditionalForm]}], ")"}], "m"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["\[Epsilon]", 
            RowBox[{
             FormBox[
              FormBox["\[Nu]",
               TraditionalForm],
              TraditionalForm], 
             FormBox["p",
              TraditionalForm], 
             FormBox["q",
              TraditionalForm], 
             FormBox["\[CapitalDelta]",
              TraditionalForm]}]], " ", 
           SuperscriptBox[
            FormBox["\[CapitalDelta]",
             TraditionalForm], 
            FormBox[
             FormBox["\[Mu]",
              TraditionalForm],
             TraditionalForm]]}], "+", 
          RowBox[{
           SuperscriptBox["\[Epsilon]", 
            RowBox[{
             FormBox[
              FormBox["\[Mu]",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["\[Nu]",
               TraditionalForm],
              TraditionalForm], 
             FormBox["q",
              TraditionalForm], 
             FormBox["\[CapitalDelta]",
              TraditionalForm]}]], " ", 
           RowBox[{
            FormBox["\[CapitalDelta]",
             TraditionalForm], "\[CenterDot]", 
            FormBox["p",
             TraditionalForm]}]}]}], ")"}], " ", 
        SuperscriptBox[
         FormBox[
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q",
            TraditionalForm]}],
          TraditionalForm], "2"]}], "-", 
       RowBox[{
        SuperscriptBox[
         FormBox[
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["p",
            TraditionalForm]}],
          TraditionalForm], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q",
            TraditionalForm]}], ")"}], "m"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["\[Epsilon]", 
            RowBox[{
             FormBox[
              FormBox["\[Mu]",
               TraditionalForm],
              TraditionalForm], 
             FormBox["p",
              TraditionalForm], 
             FormBox["q",
              TraditionalForm], 
             FormBox["\[CapitalDelta]",
              TraditionalForm]}]], " ", 
           SuperscriptBox[
            FormBox["\[CapitalDelta]",
             TraditionalForm], 
            FormBox[
             FormBox["\[Nu]",
              TraditionalForm],
             TraditionalForm]]}], "+", 
          RowBox[{
           SuperscriptBox["\[Epsilon]", 
            RowBox[{
             FormBox[
              FormBox["\[Mu]",
               TraditionalForm],
              TraditionalForm], 
             FormBox[
              FormBox["\[Nu]",
               TraditionalForm],
              TraditionalForm], 
             FormBox["p",
              TraditionalForm], 
             FormBox["\[CapitalDelta]",
              TraditionalForm]}]], " ", 
           RowBox[{
            FormBox["\[CapitalDelta]",
             TraditionalForm], "\[CenterDot]", 
            FormBox["q",
             TraditionalForm]}]}]}], ")"}]}]}], ")"}], " ", 
     SubscriptBox["\[Delta]", 
      RowBox[{
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["b",
         TraditionalForm],
        TraditionalForm]}]]}], 
    RowBox[{
     SuperscriptBox[
      FormBox[
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["p",
         TraditionalForm]}],
       TraditionalForm], "2"], " ", 
     SuperscriptBox[
      FormBox[
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}],
       TraditionalForm], "2"]}]]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[722]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor2", "[", 
  RowBox[{"Calc", "[", 
   RowBox[{"f2p", "/.", 
    RowBox[{"p", "\[Rule]", 
     RowBox[{"-", "q"}]}]}], "]"}], "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[723]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "m"]}], ")"}], " ", 
   SuperscriptBox["\[Epsilon]", 
    RowBox[{
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox["q",
      TraditionalForm], 
     FormBox["\[CapitalDelta]",
      TraditionalForm]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FormBox["\[CapitalDelta]",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}], ")"}], 
    RowBox[{"m", "-", "1"}]], " ", 
   SubscriptBox["\[Delta]", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[723]="]
}, Open  ]],

Cell["\<\
Compare with the Feynman rule tabulated in Twist2GluonOperator.\
\>", "Text",
 CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Twist2GluonOperator", "[", 
  RowBox[{"q", ",", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Nu]", ",", "b"}], "}"}], ",", 
   RowBox[{"Polarization", "\[Rule]", "1"}], ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[724]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox["\[Epsilon]", 
    RowBox[{
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox["\[CapitalDelta]",
      TraditionalForm], 
     FormBox["q",
      TraditionalForm]}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     FormBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "m"],
      TraditionalForm]}], ")"}], " ", 
   FormBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FormBox["\[CapitalDelta]",
        TraditionalForm], "\[CenterDot]", 
       FormBox["q",
        TraditionalForm]}], ")"}], 
     RowBox[{"m", "-", "1"}]],
    TraditionalForm], " ", 
   SubscriptBox["\[Delta]", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[724]="]
}, Open  ]],

Cell["quark-quark Feynman rule (unpolarized)", "Text",
 CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"qo", "=", 
  RowBox[{"Lagrangian", "[", "\"\<oqu\>\"", "]"}]}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[725]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ImaginaryI]", "m"], " ", 
   RowBox[{
    FormBox[
     OverscriptBox["\[Psi]", "_"],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]}], ")"}], ".", 
    SuperscriptBox[
     SubscriptBox["D", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], 
     RowBox[{"m", "-", "1"}]], ".", 
    FormBox["\[Psi]",
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[725]="]
}, Open  ]],

Cell["quark-quark -gluon-gluon Feynman rule (unpolarized)", "Text",
 CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"qo", "=", 
  RowBox[{"Lagrangian", "[", "\"\<oqu\>\"", "]"}]}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[726]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ImaginaryI]", "m"], " ", 
   RowBox[{
    FormBox[
     OverscriptBox["\[Psi]", "_"],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]}], ")"}], ".", 
    SuperscriptBox[
     SubscriptBox["D", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]], 
     RowBox[{"m", "-", "1"}]], ".", 
    FormBox["\[Psi]",
     TraditionalForm]}]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[726]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"qggf", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"QuantumField", "[", "QuarkField", "]"}], "[", "p", "]"}], ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", "AntiQuarkField", "]"}], "[", "q", "]"}], 
    ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Mu]", "}"}], ",", 
       RowBox[{"{", "a", "}"}]}], "]"}], "[", "r", "]"}], ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Nu]", "}"}], ",", 
       RowBox[{"{", "b", "}"}]}], "]"}], "[", "s", "]"}]}], "}"}]}]], "Input",\

 CellTags->"FeynRule",
 CellLabel->"In[727]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FormBox["\[Psi]",
      TraditionalForm], "(", "p", ")"}], ",", 
    RowBox[{
     FormBox[
      OverscriptBox["\[Psi]", "_"],
      TraditionalForm], "(", "q", ")"}], ",", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]], "(", "r", ")"}], ",", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], "(", "s", ")"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[727]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"n4", "=", 
  RowBox[{"FeynRule", "[", 
   RowBox[{"qo", ",", "qggf", ",", 
    RowBox[{"ZeroMomentumInsertion", "\[Rule]", "True"}]}], "]"}]}]], "Input",\

 CellTags->"FeynRule",
 CellLabel->"In[728]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["g", "s", "2"], " ", 
    RowBox[{
     SubscriptBox["T", 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubscriptBox["T", 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["\[CapitalDelta]",
        TraditionalForm]}], ")"}]}], " ", 
    RowBox[{"(", 
     RowBox[{
      FormBox[
       TagBox[
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"j", "=", "0"}], 
          RowBox[{"m", "-", "3"}]], "\<\"\"\>"}],
        HoldForm],
       TraditionalForm], 
      FormBox[
       RowBox[{"\<\"\"\>", " ", 
        RowBox[{"(", 
         RowBox[{"j", "+", "1"}], ")"}]}],
       TraditionalForm], 
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "j"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["p",
            TraditionalForm]}], ")"}], 
         RowBox[{
          RowBox[{"-", "j"}], "+", "m", "-", "3"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q",
            TraditionalForm]}], ")"}], "i"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FormBox["\[CapitalDelta]",
             TraditionalForm], "\[CenterDot]", 
            FormBox["q",
             TraditionalForm]}], "+", 
           RowBox[{
            FormBox["\[CapitalDelta]",
             TraditionalForm], "\[CenterDot]", 
            FormBox["s",
             TraditionalForm]}]}], ")"}], 
         RowBox[{"j", "-", "i"}]]}],
       TraditionalForm]}], ")"}], " ", 
    SuperscriptBox[
     FormBox["\[CapitalDelta]",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox[
     FormBox["\[CapitalDelta]",
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "m"], " ", 
    SubsuperscriptBox["g", "s", "2"], " ", 
    RowBox[{
     SubscriptBox["T", 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubscriptBox["T", 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{"(", 
      RowBox[{
       FormBox["\<\"\[Gamma]\"\>",
        TraditionalForm], "\[CenterDot]", 
       FormBox["\[CapitalDelta]",
        TraditionalForm]}], ")"}]}], " ", 
    RowBox[{"(", 
     RowBox[{
      FormBox[
       TagBox[
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"j", "=", "0"}], 
          RowBox[{"m", "-", "3"}]], "\<\"\"\>"}],
        HoldForm],
       TraditionalForm], 
      FormBox[
       RowBox[{"\<\"\"\>", " ", 
        RowBox[{"(", 
         RowBox[{"j", "+", "1"}], ")"}]}],
       TraditionalForm], 
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "j"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["p",
            TraditionalForm]}], ")"}], "i"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FormBox["\[CapitalDelta]",
            TraditionalForm], "\[CenterDot]", 
           FormBox["q",
            TraditionalForm]}], ")"}], 
         RowBox[{
          RowBox[{"-", "j"}], "+", "m", "-", "3"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FormBox["\[CapitalDelta]",
             TraditionalForm], "\[CenterDot]", 
            FormBox["p",
             TraditionalForm]}], "+", 
           RowBox[{
            FormBox["\[CapitalDelta]",
             TraditionalForm], "\[CenterDot]", 
            FormBox["s",
             TraditionalForm]}]}], ")"}], 
         RowBox[{"j", "-", "i"}]]}],
       TraditionalForm]}], ")"}], " ", 
    SuperscriptBox[
     FormBox["\[CapitalDelta]",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SuperscriptBox[
     FormBox["\[CapitalDelta]",
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]]}]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[728]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t4", "=", 
  RowBox[{"Twist2QuarkOperator", "[", 
   RowBox[{
    RowBox[{"{", "p", "}"}], ",", 
    RowBox[{"{", "q", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
    RowBox[{"Polarization", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[729]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "m"]}], " ", 
   SubsuperscriptBox["g", "s", "2"], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox["\[CapitalDelta]",
       TraditionalForm]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["T", 
         FormBox[
          FormBox["a",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubscriptBox["T", 
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       RowBox[{"(", 
        RowBox[{
         FormBox[
          TagBox[
           RowBox[{
            UnderoverscriptBox["\[Sum]", 
             RowBox[{"i", "=", "0"}], 
             RowBox[{"m", "-", "3"}]], "\<\"\"\>"}],
           HoldForm],
          TraditionalForm], 
         FormBox[
          RowBox[{"\<\"\"\>", " ", 
           RowBox[{"(", 
            RowBox[{"i", "+", "1"}], ")"}]}],
          TraditionalForm], 
         FormBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                FormBox["\[CapitalDelta]",
                 TraditionalForm], "\[CenterDot]", 
                FormBox["p",
                 TraditionalForm]}], ")"}]}], ")"}], 
            RowBox[{
             RowBox[{"-", "i"}], "+", "m", "-", "3"}]], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FormBox["\[CapitalDelta]",
               TraditionalForm], "\[CenterDot]", 
              FormBox["q",
               TraditionalForm]}], ")"}], "j"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               FormBox["\[CapitalDelta]",
                TraditionalForm], "\[CenterDot]", 
               FormBox["q",
                TraditionalForm]}], "+", 
              RowBox[{
               FormBox["\[CapitalDelta]",
                TraditionalForm], "\[CenterDot]", 
               FormBox["r",
                TraditionalForm]}]}], ")"}], 
            RowBox[{"i", "-", "j"}]]}],
          TraditionalForm]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", 
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubscriptBox["T", 
         FormBox[
          FormBox["a",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       RowBox[{"(", 
        RowBox[{
         FormBox[
          TagBox[
           RowBox[{
            UnderoverscriptBox["\[Sum]", 
             RowBox[{"i", "=", "0"}], 
             RowBox[{"m", "-", "3"}]], "\<\"\"\>"}],
           HoldForm],
          TraditionalForm], 
         FormBox[
          RowBox[{"\<\"\"\>", " ", 
           RowBox[{"(", 
            RowBox[{"i", "+", "1"}], ")"}]}],
          TraditionalForm], 
         FormBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                FormBox["\[CapitalDelta]",
                 TraditionalForm], "\[CenterDot]", 
                FormBox["p",
                 TraditionalForm]}], ")"}]}], ")"}], 
            RowBox[{
             RowBox[{"-", "i"}], "+", "m", "-", "3"}]], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FormBox["\[CapitalDelta]",
               TraditionalForm], "\[CenterDot]", 
              FormBox["q",
               TraditionalForm]}], ")"}], "j"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               FormBox["\[CapitalDelta]",
                TraditionalForm], "\[CenterDot]", 
               FormBox["q",
                TraditionalForm]}], "+", 
              RowBox[{
               FormBox["\[CapitalDelta]",
                TraditionalForm], "\[CenterDot]", 
               FormBox["s",
                TraditionalForm]}]}], ")"}], 
            RowBox[{"i", "-", "j"}]]}],
          TraditionalForm]}], ")"}]}]}], ")"}]}], " ", 
   SuperscriptBox[
    FormBox["\[CapitalDelta]",
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], " ", 
   SuperscriptBox[
    FormBox["\[CapitalDelta]",
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[729]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"n4", "-", "t4"}], "/.", 
     RowBox[{"OPEm", "\[Rule]", "5"}]}], "/.", 
    RowBox[{"s", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "p"}], "-", "q", "-", "r"}]}]}], "/.", 
   RowBox[{"D", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[730]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[730]="]
}, Open  ]],

Cell["\<\
 In general equality can be shown by Timing[Factor2[ \
FCE[Calc[ChangeDimension[FCE[OPESumExplicit[n4-t4]],4]/.s\[Rule]-p-q-r]]]] \
but it is a little bit slow ...\
\>", "Text",
 CellTags->"FeynRule"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"qggf", ",", "n2", ",", "n4"}], "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[731]:="],

Cell["QCD vertices", "Text",
 CellTags->"FeynRule"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fii", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Mu]", "}"}], ",", 
       RowBox[{"{", "a", "}"}]}], "]"}], "[", "p", "]"}], ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Nu]", "}"}], ",", 
       RowBox[{"{", "b", "}"}]}], "]"}], "[", "q", "]"}], ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Rho]", "}"}], ",", 
       RowBox[{"{", "c", "}"}]}], "]"}], "[", "r", "]"}]}], "}"}]}]], "Input",\

 CellTags->"FeynRule",
 CellLabel->"In[732]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]], "(", "p", ")"}], ",", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], "(", "q", ")"}], ",", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]], "(", "r", ")"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[732]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g3", "=", 
  RowBox[{"FeynRule", "[", 
   RowBox[{
    RowBox[{"Lagrangian", "[", "\"\<QCD\>\"", "]"}], ",", "fii"}], 
   "]"}]}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[733]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         FormBox["q",
          TraditionalForm], 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]], "-", 
        SuperscriptBox[
         FormBox["r",
          TraditionalForm], 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]]}], ")"}], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]], "-", 
        SuperscriptBox[
         FormBox["r",
          TraditionalForm], 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], 
         FormBox[
          FormBox["\[Rho]",
           TraditionalForm],
          TraditionalForm]], "-", 
        SuperscriptBox[
         FormBox["q",
          TraditionalForm], 
         FormBox[
          FormBox["\[Rho]",
           TraditionalForm],
          TraditionalForm]]}], ")"}]}]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[733]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GluonVertex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Rho]", ",", "c"}], "}"}], ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[734]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FormBox[
         RowBox[{"q", "-", "r"}],
         TraditionalForm], ")"}], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FormBox[
         RowBox[{"r", "-", "p"}],
         TraditionalForm], ")"}], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FormBox[
         RowBox[{"p", "-", "q"}],
         TraditionalForm], ")"}], 
       FormBox[
        FormBox["\[Rho]",
         TraditionalForm],
        TraditionalForm]]}]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[734]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{"g3", "-", 
   RowBox[{"ChangeDimension", "[", 
    RowBox[{"%", ",", "4"}], "]"}]}], "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[735]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[735]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fi4", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Mu]", "}"}], ",", 
       RowBox[{"{", "a", "}"}]}], "]"}], "[", "p", "]"}], ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Nu]", "}"}], ",", 
       RowBox[{"{", "b", "}"}]}], "]"}], "[", "q", "]"}], ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Rho]", "}"}], ",", 
       RowBox[{"{", "c", "}"}]}], "]"}], "[", "r", "]"}], ",", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", 
       RowBox[{"{", "\[Sigma]", "}"}], ",", 
       RowBox[{"{", "d", "}"}]}], "]"}], "[", "s", "]"}]}], "}"}]}]], "Input",\

 CellTags->"FeynRule",
 CellLabel->"In[736]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]], "(", "p", ")"}], ",", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], "(", "q", ")"}], ",", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Rho]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]], "(", "r", ")"}], ",", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]], "(", "s", ")"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[736]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g4", "=", 
  RowBox[{"FeynRule", "[", 
   RowBox[{
    RowBox[{"Lagrangian", "[", "\"\<QCD\>\"", "]"}], ",", "fi4"}], 
   "]"}]}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[737]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["g", 
        RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
       SuperscriptBox["g", 
        RowBox[{"\[Nu]", "\[Sigma]"}]]}], "-", 
      RowBox[{
       SuperscriptBox["g", 
        RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
       SuperscriptBox["g", 
        RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], ")"}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["si1",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["si1",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubsuperscriptBox["g", "s", "2"]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["g", 
        RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
       SuperscriptBox["g", 
        RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
      RowBox[{
       SuperscriptBox["g", 
        RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
       SuperscriptBox["g", 
        RowBox[{"\[Rho]", "\[Sigma]"}]]}]}], ")"}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["si1",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["si1",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubsuperscriptBox["g", "s", "2"]}], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["g", 
        RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
       SuperscriptBox["g", 
        RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
      RowBox[{
       SuperscriptBox["g", 
        RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
       SuperscriptBox["g", 
        RowBox[{"\[Nu]", "\[Sigma]"}]]}]}], ")"}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["si1",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["si1",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubsuperscriptBox["g", "s", "2"]}]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[737]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GluonVertex", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "\[Mu]", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "\[Nu]", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Rho]", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "\[Sigma]", ",", "d"}], "}"}], ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[738]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", 
   SubsuperscriptBox["g", "s", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Nu]", "\[Sigma]"}]]}]}], ")"}], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u8",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u8",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Rho]", "\[Sigma]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Nu]", "\[Rho]"}]]}]}], ")"}], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u8",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u8",
          TraditionalForm],
         TraditionalForm]}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Nu]", "\[Sigma]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["g", 
          RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
         SuperscriptBox["g", 
          RowBox[{"\[Nu]", "\[Rho]"}]]}]}], ")"}], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["b",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u8",
          TraditionalForm],
         TraditionalForm]}]], " ", 
      SubscriptBox["f", 
       RowBox[{
        FormBox[
         FormBox["c",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["d",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["u8",
          TraditionalForm],
         TraditionalForm]}]]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[738]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Calc", "[", 
  RowBox[{"g4", "-", 
   RowBox[{"ChangeDimension", "[", 
    RowBox[{"%", ",", "4"}], "]"}]}], "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[739]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"FeynRule",
 CellLabel->"Out[739]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{
  "f2p", ",", "f2u", ",", "f3", ",", "f32", ",", "fi", ",", "fi4", ",", "fii",
    ",", "g3", ",", "g4", ",", "gop", ",", "gou", ",", "n3", ",", "nf3", ",", 
   "n4", ",", "np2", ",", "npf3", ",", "p33", ",", "pf3", ",", "pn3", ",", 
   "pqo", ",", "qf", ",", "qp", ",", "qgf", ",", "qo", ",", "t4"}], 
  "]"}]], "Input",
 CellTags->"FeynRule",
 CellLabel->"In[740]:="]
}, Open  ]],

Cell["FI", "ObjectName",
 CellTags->"FI"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FI"],

Cell["\<\
FI changes the output format to InputForm. This is useful to see the internal \
representation of FeynCalc objects. To change back to FeynCalcForm use FC.\
\>", "Text",
 CellTags->"FI"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalcForm",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcForm",
  ButtonNote->"FeynCalcForm"],
 ", ",
 ButtonBox["FC",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FC",
  ButtonNote->"FC"],
 ", ",
 ButtonBox["FeynCalcExternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcExternal",
  ButtonNote->"FeynCalcExternal"],
 ", ",
 ButtonBox["FeynCalcInternal",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalcInternal",
  ButtonNote->"FeynCalcInternal"],
 "."
}], "Text",
 CellTags->"FI"]
}, Open  ]],

Cell["FieldDerivative", "ObjectName",
 CellTags->"FieldDerivative"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FieldDerivative"],

Cell["\<\
FieldDerivative[f[x],x,li1,li2,...] is the derivative of f[x] with respect to \
space-time variables x and with Lorentz indices li1, li2, ..., where li1, \
li2, ... have head LorentzIndex. FieldDerivative[f[x],x,li1,li2,...] can be \
given as FieldDerivative[f[x],x,{l1,l2,...}], where l1 is li1 without the \
head, ... FieldDerivative is defined only for objects with head \
QuantumField[...]. If the space-time derivative of other objects is wanted, \
the corresponding rule must be specified.\
\>", "Text",
 CellTags->"FieldDerivative"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["PartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PartialD",
  ButtonNote->"PartialD"],
 ", ",
 ButtonBox["ExpandPartialD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ExpandPartialD",
  ButtonNote->"ExpandPartialD"],
 "."
}], "Text",
 CellTags->"FieldDerivative"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FieldDerivative"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QuantumField", "[", 
    RowBox[{"A", ",", 
     RowBox[{"{", "\[Mu]", "}"}]}], "]"}], "[", "x", "]"}], ".", 
  RowBox[{
   RowBox[{"QuantumField", "[", 
    RowBox[{"B", ",", 
     RowBox[{"{", "\[Nu]", "}"}]}], "]"}], "[", "y", "]"}], ".", 
  RowBox[{
   RowBox[{"QuantumField", "[", 
    RowBox[{"C", ",", 
     RowBox[{"{", "\[Rho]", "}"}]}], "]"}], "[", "x", "]"}], ".", 
  RowBox[{
   RowBox[{"QuantumField", "[", 
    RowBox[{"D", ",", 
     RowBox[{"{", "\[Sigma]", "}"}]}], "]"}], "[", "y", "]"}]}]], "Input",
 CellTags->"FieldDerivative",
 CellLabel->"In[741]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["A", "\[Mu]"], "(", "x", ")"}], ".", 
   RowBox[{
    SubscriptBox["B", "\[Nu]"], "(", "y", ")"}], ".", 
   RowBox[{
    SubscriptBox[
     FormBox["C",
      TraditionalForm], "\[Rho]"], "(", "x", ")"}], ".", 
   RowBox[{
    SubscriptBox[
     FormBox["D",
      TraditionalForm], "\[Sigma]"], "(", "y", ")"}]}], 
  TraditionalForm]], "Output",
 CellTags->"FieldDerivative",
 CellLabel->"Out[741]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FieldDerivative", "[", 
   RowBox[{"%", ",", "x", ",", 
    RowBox[{"{", "\[Mu]", "}"}]}], "]"}], "//", "DotExpand"}]], "Input",
 CellTags->"FieldDerivative",
 CellLabel->"In[742]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["A", "\[Mu]"], "(", "x", ")"}], ".", 
    RowBox[{
     SubscriptBox["B", "\[Nu]"], "(", "y", ")"}], ".", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox[
        FormBox["C",
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "x", ")"}]}], ".", 
    RowBox[{
     SubscriptBox[
      FormBox["D",
       TraditionalForm], "\[Sigma]"], "(", "y", ")"}]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "x", ")"}]}], ".", 
    RowBox[{
     SubscriptBox["B", "\[Nu]"], "(", "y", ")"}], ".", 
    RowBox[{
     SubscriptBox[
      FormBox["C",
       TraditionalForm], "\[Rho]"], "(", "x", ")"}], ".", 
    RowBox[{
     SubscriptBox[
      FormBox["D",
       TraditionalForm], "\[Sigma]"], "(", "y", ")"}]}]}], 
  TraditionalForm]], "Output",
 CellTags->"FieldDerivative",
 CellLabel->"Out[742]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FieldDerivative", "[", 
   RowBox[{"%", ",", "y", ",", 
    RowBox[{"{", "\[Nu]", "}"}]}], "]"}], "//", "DotExpand"}]], "Input",
 CellTags->"FieldDerivative",
 CellLabel->"In[743]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["A", "\[Mu]"], "(", "x", ")"}], ".", 
    RowBox[{
     SubscriptBox["B", "\[Nu]"], "(", "y", ")"}], ".", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox[
        FormBox["C",
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "x", ")"}]}], ".", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox[
        FormBox["D",
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "y", ")"}]}]}], "+", 
   RowBox[{
    RowBox[{
     SubscriptBox["A", "\[Mu]"], "(", "x", ")"}], ".", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["B", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "y", ")"}]}], ".", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox[
        FormBox["C",
         TraditionalForm], 
        FormBox[
         FormBox["\[Rho]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "x", ")"}]}], ".", 
    RowBox[{
     SubscriptBox[
      FormBox["D",
       TraditionalForm], "\[Sigma]"], "(", "y", ")"}]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "x", ")"}]}], ".", 
    RowBox[{
     SubscriptBox["B", "\[Nu]"], "(", "y", ")"}], ".", 
    RowBox[{
     SubscriptBox[
      FormBox["C",
       TraditionalForm], "\[Rho]"], "(", "x", ")"}], ".", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox[
        FormBox["D",
         TraditionalForm], 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "y", ")"}]}]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "x", ")"}]}], ".", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["B", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], "\[Null]"]}], ")"}], "\[InvisibleApplication]", 
     RowBox[{"(", "y", ")"}]}], ".", 
    RowBox[{
     SubscriptBox[
      FormBox["C",
       TraditionalForm], "\[Rho]"], "(", "x", ")"}], ".", 
    RowBox[{
     SubscriptBox[
      FormBox["D",
       TraditionalForm], "\[Sigma]"], "(", "y", ")"}]}]}], 
  TraditionalForm]], "Output",
 CellTags->"FieldDerivative",
 CellLabel->"Out[743]="]
}, Open  ]]
}, Open  ]],

Cell["FieldStrength", "ObjectName",
 CellTags->"FieldStrength"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FieldStrength"],

Cell[TextData[{
 "FieldStrength[\[Mu], \[Nu], a] is the field strength tensor ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "\[Mu]"], 
     SubsuperscriptBox["A", "\[Nu]", "a"]}], "-", 
    RowBox[{
     SubscriptBox["\[PartialD]", "\[Nu]"], 
     SubsuperscriptBox["A", "\[Mu]", "a"]}], "+", 
    RowBox[{
     SubscriptBox["g", "s"], " ", 
     SubsuperscriptBox["A", "\[Mu]", "b1"], 
     SubsuperscriptBox["A", "\[Nu]", "c1"]}]}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    SuperscriptBox["f", 
     RowBox[{"a", " ", "b1", " ", "c1"}]]}], TraditionalForm]]],
 ". FieldStrength[\[Mu], \[Nu]] is the field strength tensor ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "\[Mu]"], 
     SubsuperscriptBox["A", "\[Nu]", "\[Null]"]}], "-", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "\[Nu]"], 
      SubsuperscriptBox["A", "\[Mu]", "\[Null]"]}], "."}]}], 
   TraditionalForm]]],
 " The name of the field (A) and the coupling constant (g) can be set through \
the options or by additional arguments. The first two indices are interpreted \
as type LorentzIndex, except OPEDelta, which is converted to \
Momentum[OPEDelta]."
}], "Text",
 CellTags->"FieldStrength"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "FieldStrength", "]"}]], "Input",
 CellTags->"FieldStrength",
 CellLabel->"In[744]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"CouplingConstant", "\[Rule]", 
     SubscriptBox["g", "s"]}], ",", 
    RowBox[{"Explicit", "\[Rule]", "False"}], ",", 
    RowBox[{
    "HighEnergyPhysics`fctools`IndexPosition`IndexPosition", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ",", 
    RowBox[{"Symbol", "\[Rule]", "\<\"F\"\>"}], ",", 
    RowBox[{"QuantumField", "\[Rule]", "A"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FieldStrength",
 CellLabel->"Out[744]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["QuantumField",
  BaseStyle->"AddOnsLink",
  ButtonData:>"QuantumField",
  ButtonNote->"QuantumField"],
 "."
}], "Text",
 CellTags->"FieldStrength"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FieldStrength"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldStrength", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}]], "Input",
 CellTags->"FieldStrength",
 CellLabel->"In[745]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["F", 
   RowBox[{"\[Mu]", "\[Nu]"}], "\[Null]"], TraditionalForm]], "Output",
 CellTags->"FieldStrength",
 CellLabel->"Out[745]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldStrength", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a"}], "]"}]], "Input",
 CellTags->"FieldStrength",
 CellLabel->"In[746]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["F", 
   RowBox[{"\[Mu]", "\[Nu]"}], "a"], TraditionalForm]], "Output",
 CellTags->"FieldStrength",
 CellLabel->"Out[746]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldStrength", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]", ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"FieldStrength",
 CellLabel->"In[747]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], "\[Null]"]}], "-", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], "\[Null]"]}]}], TraditionalForm]], "Output",
 CellTags->"FieldStrength",
 CellLabel->"Out[747]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldStrength", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a", ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"FieldStrength",
 CellLabel->"In[748]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    SubscriptBox["g", "s"], " ", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b12",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c60",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{"a", "b12", "c60"}]]}]}], TraditionalForm]], "Output",
 CellTags->"FieldStrength",
 CellLabel->"Out[748]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"FieldStrength", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", 
    RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellTags->"FieldStrength",
 CellLabel->"In[749]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"QuantumField", "[", 
   RowBox[{
    RowBox[{"PartialD", "[", 
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], ",", "GaugeField", 
    ",", 
    RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}]}], "]"}], "-", 
  RowBox[{"QuantumField", "[", 
   RowBox[{
    RowBox[{"PartialD", "[", 
     RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}], "]"}], ",", "GaugeField", 
    ",", 
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}]}]], "Output",
 CellTags->"FieldStrength",
 CellLabel->"Out[749]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"FieldStrength", "[", 
   RowBox[{"\[Mu]", ",", "OPEDelta", ",", 
    RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellTags->"FieldStrength",
 CellLabel->"In[750]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"QuantumField", "[", 
   RowBox[{
    RowBox[{"PartialD", "[", 
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}], ",", "GaugeField", 
    ",", 
    RowBox[{"Momentum", "[", "OPEDelta", "]"}]}], "]"}], "-", 
  RowBox[{"QuantumField", "[", 
   RowBox[{
    RowBox[{"PartialD", "[", 
     RowBox[{"Momentum", "[", "OPEDelta", "]"}], "]"}], ",", "GaugeField", 
    ",", 
    RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}]}], "]"}]}]], "Output",
 CellTags->"FieldStrength",
 CellLabel->"Out[750]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldStrength", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a", ",", 
   RowBox[{"CouplingConstant", "\[Rule]", 
    RowBox[{"-", "Gstrong"}]}], ",", 
   RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"FieldStrength",
 CellLabel->"In[751]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SubscriptBox["g", "s"], " ", 
    RowBox[{
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b13",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c61",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{"a", "b13", "c61"}]]}]}], TraditionalForm]], "Output",
 CellTags->"FieldStrength",
 CellLabel->"Out[751]="]
}, Open  ]]
}, Open  ]],

Cell["FinalFunction", "ObjectName",
 CellTags->"FinalFunction"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FinalFunction"],

Cell["FinalFunction is an option for OneLoopSum.", "Text",
 CellTags->"FinalFunction"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["OneLoopSum",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoopSum",
  ButtonNote->"OneLoopSum"],
 "."
}], "Text",
 CellTags->"FinalFunction"]
}, Open  ]],

Cell["FinalSubstitutions", "ObjectName",
 CellTags->"FinalSubstitutions"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FinalSubstitutions"],

Cell["\<\
FinalSubstitutions is an option for OneLoop and OneLoopSum and Write2. All \
substitutions indicated hereby are done at the end of the calculation.\
\>", "Text",
 CellTags->"FinalSubstitutions"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["OneLoop",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoop",
  ButtonNote->"OneLoop"],
 ", ",
 ButtonBox["OneLoopSum",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoopSum",
  ButtonNote->"OneLoopSum"],
 ", ",
 ButtonBox["Write2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Write2",
  ButtonNote->"Write2"],
 "."
}], "Text",
 CellTags->"FinalSubstitutions"]
}, Open  ]],

Cell["FORM", "ObjectName",
 CellTags->"FORM"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FORM"],

Cell["\<\
FORM is an option for RHI. If set to True a FORM file is generated and run \
from Mathematica (provided R. Hamberg's FORM-program is installed correctly \
... ).\
\>", "Text",
 CellTags->"FORM"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["RHI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"RHI",
  ButtonNote->"RHI"],
 ", ",
 ButtonBox["FeynCalc2FORM",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalc2FORM",
  ButtonNote->"FeynCalc2FORM"],
 "."
}], "Text",
 CellTags->"FORM"]
}, Open  ]],

Cell["FORMEpilog", "ObjectName",
 CellTags->"FORMEpilog"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FORMEpilog"],

Cell["\<\
FORMEpilog is an option for FeynCalc2FORM. It may be set to a string which is \
put at the end of the FORM-file.\
\>", "Text",
 CellTags->"FORMEpilog"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalc2FORM",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalc2FORM",
  ButtonNote->"FeynCalc2FORM"],
 ", ",
 ButtonBox["FORMProlog",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FORMProlog",
  ButtonNote->"FORMProlog"],
 "."
}], "Text",
 CellTags->"FORMEpilog"]
}, Open  ]],

Cell["FORMProlog", "ObjectName",
 CellTags->"FORMProlog"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FORMProlog"],

Cell["\<\
FORMProlog is an option for FeynCalc2FORM. It may be set to a string which is \
put after the type declarations of the FORM-file.\
\>", "Text",
 CellTags->"FORMProlog"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalc2FORM",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalc2FORM",
  ButtonNote->"FeynCalc2FORM"],
 ", ",
 ButtonBox["FORMEpilog",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FORMEpilog",
  ButtonNote->"FORMEpilog"],
 "."
}], "Text",
 CellTags->"FORMProlog"]
}, Open  ]],

Cell["FORM2FeynCalc", "ObjectName",
 CellTags->"FORM2FeynCalc"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FORM2FeynCalc"],

Cell["\<\
FORM2FeynCalc[expr] translates the FORM expr into FeynCalc notation. \
FORM2FeynCalc[file] translates the FORM expresssions in file into \
FeynCalcnotation. FORM2FeynCalc[file, x1, x2, ...] reads in a file in \
FORM-format and translates the assignments for the variables a, b, ... into \
FeynCalc syntax. If the option Set is True, the variables x1, x2 are assigned \
to the right hand sides defined in the FORM-file.\
\>", "Text",
 CellTags->"FORM2FeynCalc"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynCalc2FORM",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalc2FORM",
  ButtonNote->"FeynCalc2FORM"],
 "."
}], "Text",
 CellTags->"FORM2FeynCalc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "FORM2FeynCalc", "]"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[752]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dimension", "\[Rule]", "4"}], ",", 
    RowBox[{"FinalSubstitutions", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"Dot", "\[Rule]", "Dot"}], ",", 
    RowBox[{"HoldForm", "\[Rule]", "True"}], ",", 
    RowBox[{"LorentzIndex", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"mu", ",", "nu", ",", "al", ",", "be"}], "}"}]}], ",", 
    RowBox[{"Set", "\[Rule]", "False"}], ",", 
    RowBox[{"Replace", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"Vectors", "\[Rule]", "Automatic"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[752]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FORM2FeynCalc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FORM2FeynCalc", "[", "\"\<p.q + 2*x m^2\>\"", "]"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[753]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"x", ".", 
     SuperscriptBox["m", "2"]}]}], "+", 
   FormBox[
    RowBox[{
     FormBox["p",
      TraditionalForm], "\[CenterDot]", 
     FormBox["q",
      TraditionalForm]}],
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[753]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[754]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"x", ".", 
    SuperscriptBox["m", "2"]}]}], "+", 
  RowBox[{"SP", "[", 
   RowBox[{"p", ",", "q"}], "]"}]}]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[754]//StandardForm="]
}, Open  ]],

Cell["\<\
Functions are automatically converted right, but bracketed expressions need \
to be substituted explicitly.\
\>", "Text",
 CellTags->"FORM2FeynCalc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FORM2FeynCalc", "[", 
  RowBox[{"\"\<x +f(z)+ log(x)^2+[li2(1-x)]\>\"", ",", 
   RowBox[{"Replace", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<[li2(1-x)]\>\"", "\[Rule]", "\"\<PolyLog[2,1-x]\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[755]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["log", "2"], "(", "x", ")"}], "+", "x", "+", 
   RowBox[{"f", "(", "z", ")"}], "+", 
   RowBox[{
    SubscriptBox[
     InterpretationBox["Li",
      PolyLog,
      Editable->False,
      Selectable->False], "2"], "(", 
    RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[755]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[756]:="],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"f", "[", "z", "]"}], "+", 
  SuperscriptBox[
   RowBox[{"Log", "[", "x", "]"}], "2"], "+", 
  RowBox[{"PolyLog", "[", 
   RowBox[{"2", ",", 
    RowBox[{"1", "-", "x"}]}], "]"}]}]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[756]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FORM2FeynCalc", "[", "\"\<x + [(1)]*y -[(-1)^m]\>\"", 
  "]"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[757]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "+", 
   RowBox[{
    RowBox[{"Hold", "[", "1", "]"}], ".", "y"}], "-", 
   RowBox[{"Hold", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "m"], "]"}]}], TraditionalForm]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[757]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[758]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "m"], "+", 
   RowBox[{"1", ".", "y"}]}], TraditionalForm]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[758]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FORM2FeynCalc", "[", "\"\<p(mu)*q(nu)+d_(mu,nu)\>\"", 
  "]"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[759]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["p", "mu"], ".", 
    SuperscriptBox["q", "nu"]}], "+", 
   SuperscriptBox["g", 
    RowBox[{"mu", "nu"}]]}], TraditionalForm]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[759]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[760]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "mu"}], "]"}], ".", 
   RowBox[{"FV", "[", 
    RowBox[{"q", ",", "nu"}], "]"}]}], "+", 
  RowBox[{"MT", "[", 
   RowBox[{"mu", ",", "nu"}], "]"}]}]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[760]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FORM2FeynCalc", "[", 
  RowBox[{"\"\<p(mu)*q(nu)+d_(mu,nu)\>\"", ",", 
   RowBox[{"Replace", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"mu", "\[Rule]", "\[Mu]"}], ",", 
      RowBox[{"nu", "\[Rule]", "\[Nu]"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[761]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["p", "\[Mu]"], ".", 
    SuperscriptBox["q", "\[Nu]"]}], "+", 
   SuperscriptBox["g", 
    RowBox[{"\[Mu]", "\[Nu]"}]]}], TraditionalForm]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[761]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FORM2FeynCalc", "[", 
  "\"\<i_*az*bz*aM^2*D1*[(1)]*b_G1 * ( 4*eperp(mu,nu)*avec.bvec*blam )\>\"", 
  "]"}]], "Input",
 CellTags->"FORM2FeynCalc",
 CellLabel->"In[762]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", " ", "\[ImaginaryI]"}], ")"}], ".", "az", ".", "bz", ".", 
   SuperscriptBox["aM", "2"], ".", "D1", ".", 
   RowBox[{"Hold", "[", "1", "]"}], ".", "b$G1", ".", 
   RowBox[{"eperp", "(", 
    RowBox[{"mu", ",", "nu"}], ")"}], ".", 
   RowBox[{"(", 
    FormBox[
     RowBox[{
      FormBox["avec",
       TraditionalForm], "\[CenterDot]", 
      FormBox["bvec",
       TraditionalForm]}],
     TraditionalForm], ")"}], ".", "blam"}], TraditionalForm]], "Output",
 CellTags->"FORM2FeynCalc",
 CellLabel->"Out[762]="]
}, Open  ]]
}, Open  ]],

Cell["FourDivergence", "ObjectName",
 CellTags->"FourDivergence"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FourDivergence"],

Cell["\<\
FourDivergence[exp, FourVector[p, mu]] calculates the partial derivative of \
exp w.r.t. p(mu). FourDivergence[exp, FourVector[p, mu], FourVector[p,nu], \
...]gives the multiple derivative.\
\>", "Text",
 CellTags->"FourDivergence"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["RussianTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"RussianTrick",
  ButtonNote->"RussianTrick"],
 "."
}], "Text",
 CellTags->"FourDivergence"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FourDivergence"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"ScalarProduct", "[", 
   RowBox[{"p", ",", "q"}], "]"}]}]], "Input",
 CellTags->"FourDivergence",
 CellLabel->"In[763]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox["p",
    TraditionalForm], "\[CenterDot]", 
   FormBox["q",
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"FourDivergence",
 CellLabel->"Out[763]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourDivergence", "[", 
  RowBox[{"t", ",", 
   RowBox[{"FourVector", "[", 
    RowBox[{"q", ",", "\[Mu]"}], "]"}]}], "]"}]], "Input",
 CellTags->"FourDivergence",
 CellLabel->"In[764]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox["p",
    TraditionalForm], 
   FormBox[
    FormBox["\[Mu]",
     TraditionalForm],
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"FourDivergence",
 CellLabel->"Out[764]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"ScalarProduct", "[", 
   RowBox[{
    RowBox[{"p", "-", "k"}], ",", "q"}], "]"}]}]], "Input",
 CellTags->"FourDivergence",
 CellLabel->"In[765]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"(", 
   FormBox[
    RowBox[{"p", "-", "k"}],
    TraditionalForm], ")", "\[CenterDot]", 
   FormBox["q",
    TraditionalForm]}], TraditionalForm]], "Output",
 CellTags->"FourDivergence",
 CellLabel->"Out[765]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourDivergence", "[", 
  RowBox[{"t", ",", 
   RowBox[{"FourVector", "[", 
    RowBox[{
     RowBox[{"k", "-", "p"}], ",", "\[Mu]"}], "]"}]}], "]"}]], "Input",
 CellTags->"FourDivergence",
 CellLabel->"In[766]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"FourDivergence",
 CellLabel->"Out[766]="]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "t", "]"}]], "Input",
 CellTags->"FourDivergence",
 CellLabel->"In[767]:="]
}, Open  ]],

Cell["FourLaplacian", "ObjectName",
 CellTags->"FourLaplacian"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FourLaplacian"],

Cell[TextData[{
 "FourLaplacian[exp, p, q] is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PartialD]", 
    RowBox[{"/", 
     RowBox[{"\[PartialD]", 
      SubscriptBox["p", "\[Mu]"]}]}], " "}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PartialD]", 
    RowBox[{"/", 
     RowBox[{"\[PartialD]", 
      SubscriptBox["q", "\[Mu]"]}]}], " "}], TraditionalForm]]],
 "exp."
}], "Text",
 CellTags->"FourLaplacian"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "FourLaplacian", "]"}]], "Input",
 CellTags->"FourLaplacian",
 CellLabel->"In[768]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"Dimension", "\[Rule]", "D"}], "}"}], TraditionalForm]], "Output",
 CellTags->"FourLaplacian",
 CellLabel->"Out[768]="]
}, Open  ]],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FourDivergence",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FourDivergence",
  ButtonNote->"FourDivergence"],
 ", ",
 ButtonBox["RussianTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"RussianTrick",
  ButtonNote->"RussianTrick"],
 "."
}], "Text",
 CellTags->"FourLaplacian"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FourLaplacian"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SP", "[", 
  RowBox[{"q", ",", "q"}], "]"}]], "Input",
 CellTags->"FourLaplacian",
 CellLabel->"In[769]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox["q",
    TraditionalForm], "2"], TraditionalForm]], "Output",
 CellTags->"FourLaplacian",
 CellLabel->"Out[769]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourLaplacian", "[", 
  RowBox[{"%", ",", "q", ",", "q"}], "]"}]], "Input",
 CellTags->"FourLaplacian",
 CellLabel->"In[770]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"2", " ", "D"}], TraditionalForm]], "Output",
 CellTags->"FourLaplacian",
 CellLabel->"Out[770]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SOD", "[", "q", "]"}], "^", "OPEm"}], 
   RowBox[{"FAD", "[", 
    RowBox[{"q", ",", 
     RowBox[{"q", "-", "p"}]}], "]"}]}], "//", "FCI"}]], "Input",
 CellTags->"FourLaplacian",
 CellLabel->"In[771]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FormBox["\[CapitalDelta]",
       TraditionalForm], "\[CenterDot]", 
      FormBox["q",
       TraditionalForm]}], ")"}], "m"], 
   RowBox[{
    SuperscriptBox["q", "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q", "-", "p"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellTags->"FourLaplacian",
 CellLabel->"Out[771]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourLaplacian", "[", 
  RowBox[{"%", ",", "q", ",", " ", "q"}], "]"}]], "Input",
 CellTags->"FourLaplacian",
 CellLabel->"In[772]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"4", " ", "m", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FormBox["\[CapitalDelta]",
          TraditionalForm], "\[CenterDot]", 
         FormBox["q",
          TraditionalForm]}], ")"}], 
       RowBox[{"m", "-", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FormBox["\[CapitalDelta]",
          TraditionalForm], "\[CenterDot]", 
         FormBox["q",
          TraditionalForm]}], "-", 
        RowBox[{
         FormBox["\[CapitalDelta]",
          TraditionalForm], "\[CenterDot]", 
         FormBox["p",
          TraditionalForm]}]}], ")"}]}], 
     RowBox[{
      SuperscriptBox["q", "2"], ".", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q", "-", "p"}], ")"}], "2"], ".", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q", "-", "p"}], ")"}], "2"]}]]}], "-", 
   FractionBox[
    RowBox[{"2", " ", "D", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}], ")"}], "m"]}], 
    RowBox[{
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{"4", " ", "m", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}], ")"}], "m"]}], 
    RowBox[{
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"12", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}], ")"}], "m"]}], 
    RowBox[{
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{"2", " ", "D", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}], ")"}], "m"]}], 
    RowBox[{
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "p"}], ")"}], "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"12", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}], ")"}], "m"]}], 
    RowBox[{
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "p"}], ")"}], "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "p"}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FormBox["\[CapitalDelta]",
         TraditionalForm], "\[CenterDot]", 
        FormBox["q",
         TraditionalForm]}], ")"}], "m"], " ", 
     SuperscriptBox[
      FormBox["p",
       TraditionalForm], "2"]}], 
    RowBox[{
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox["q", "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "p"}], ")"}], "2"], ".", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"q", "-", "p"}], ")"}], "2"]}]]}], TraditionalForm]], "Output",\

 CellTags->"FourLaplacian",
 CellLabel->"Out[772]="]
}, Open  ]]
}, Open  ]],

Cell["FourVector", "ObjectName",
 CellTags->"FourVector"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FourVector"],

Cell[TextData[{
 "FourVector[p, ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "] is the four-dimensional vector p with Lorentz index ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 ". A vector with space-time Dimension D is obtained by supplying the option \
Dimension \[Rule] D."
}], "Text",
 CellTags->"FourVector"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FV",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FV",
  ButtonNote->"FV"],
 ", ",
 ButtonBox["FVD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FVD",
  ButtonNote->"FVD"],
 ", ",
 ButtonBox["Pair",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Pair",
  ButtonNote->"Pair"],
 "."
}], "Text",
 CellTags->"FourVector"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FourVector"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourVector", "[", 
  RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Input",
 CellTags->"FourVector",
 CellLabel->"In[773]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox["p",
    TraditionalForm], 
   FormBox[
    FormBox["\[Mu]",
     TraditionalForm],
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"FourVector",
 CellLabel->"Out[773]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourVector", "[", 
  RowBox[{
   RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "Input",
 CellTags->"FourVector",
 CellLabel->"In[774]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   RowBox[{"(", 
    FormBox[
     RowBox[{"p", "-", "q"}],
     TraditionalForm], ")"}], 
   FormBox[
    FormBox["\[Mu]",
     TraditionalForm],
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"FourVector",
 CellLabel->"Out[774]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"FourVector", "[", 
   RowBox[{"p", ",", "\[Mu]"}], "]"}], "]"}]], "Input",
 CellTags->"FourVector",
 CellLabel->"In[775]:="],

Cell[BoxData[
 RowBox[{"Pair", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"Momentum", "[", "p", "]"}]}], "]"}]], "Output",
 CellTags->"FourVector",
 CellLabel->"Out[775]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"FourVector", "[", 
   RowBox[{"p", ",", "\[Mu]", ",", 
    RowBox[{"Dimension", "\[Rule]", "D"}]}], "]"}], "]"}]], "Input",
 CellTags->"FourVector",
 CellLabel->"In[776]:="],

Cell[BoxData[
 RowBox[{"Pair", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", 
    RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", 
   RowBox[{"Momentum", "[", 
    RowBox[{"p", ",", "D"}], "]"}]}], "]"}]], "Output",
 CellTags->"FourVector",
 CellLabel->"Out[776]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"FCE", "[", 
   RowBox[{"FourVector", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}], "]"}], "]"}]], "Input",
 CellTags->"FourVector",
 CellLabel->"In[777]:="],

Cell[BoxData[
 RowBox[{"FV", "[", 
  RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Output",
 CellTags->"FourVector",
 CellLabel->"Out[777]//StandardForm="]
}, Open  ]],

Cell["\<\
There is no special function to expand momenta in FourVector. Since \
FourVector is turned into Pair internally ExpandScalarProduct may be used.\
\>", "Text",
 CellTags->"FourVector"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandScalarProduct", "[", 
  RowBox[{"FourVector", "[", 
   RowBox[{
    RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}], "]"}]], "Input",
 CellTags->"FourVector",
 CellLabel->"In[778]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    FormBox["p",
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], "-", 
   SuperscriptBox[
    FormBox["q",
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"FourVector",
 CellLabel->"Out[778]="]
}, Open  ]]
}, Open  ]],

Cell["FreeIndex", "ObjectName",
 CellTags->"FreeIndex"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FreeIndex"],

Cell["\<\
FreeIndex is a datatype which is recognized by Contract. Possible use: \
DataType[mu, FreeIndex] = True.\
\>", "Text",
 CellTags->"FreeIndex"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Contract",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Contract",
  ButtonNote->"Contract"],
 ", ",
 ButtonBox["DataType",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DataType",
  ButtonNote->"DataType"],
 "."
}], "Text",
 CellTags->"FreeIndex"]
}, Open  ]],

Cell["FreeQ2", "ObjectName",
 CellTags->"FreeQ2"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FreeQ2"],

Cell["\<\
FreeQ2[expr, {form1, form2, ...}] yields True if expr does not contain any \
occurence of form1, form2, ... and False otherwise. FreeQ2[expr, form] is the \
same as FreeQ[expr, form].\
\>", "Text",
 CellTags->"FreeQ2"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["SelectFree",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SelectFree",
  ButtonNote->"SelectFree"],
 ", ",
 ButtonBox["SelectNotFree",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SelectNotFree",
  ButtonNote->"SelectNotFree"],
 "."
}], "Text",
 CellTags->"FreeQ2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FreeQ2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ2", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"f", "[", "x", "]"}], "+", "y"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellTags->"FreeQ2",
 CellLabel->"In[779]:="],

Cell[BoxData[
 FormBox["False", TraditionalForm]], "Output",
 CellTags->"FreeQ2",
 CellLabel->"Out[779]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ2", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"f", "[", "x", "]"}], "+", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellTags->"FreeQ2",
 CellLabel->"In[780]:="],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellTags->"FreeQ2",
 CellLabel->"Out[780]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ2", "[", 
  RowBox[{"x", ",", " ", "y"}], "]"}]], "Input",
 CellTags->"FreeQ2",
 CellLabel->"In[781]:="],

Cell[BoxData[
 FormBox["True", TraditionalForm]], "Output",
 CellTags->"FreeQ2",
 CellLabel->"Out[781]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ2", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", " ", "f"}], "]"}]], "Input",
 CellTags->"FreeQ2",
 CellLabel->"In[782]:="],

Cell[BoxData[
 FormBox["False", TraditionalForm]], "Output",
 CellTags->"FreeQ2",
 CellLabel->"Out[782]="]
}, Open  ]]
}, Open  ]],

Cell["FRH", "ObjectName",
 CellTags->"FRH"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FRH"],

Cell["\<\
FRH[exp_] := FixedPoint[ReleaseHold, exp], i.e., FRH removes all HoldForm and \
Hold in exp.\
\>", "Text",
 CellTags->"FRH"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Isolate",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Isolate",
  ButtonNote->"Isolate"],
 "."
}], "Text",
 CellTags->"FRH"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FRH"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "-", "1", " ", "-", " ", 
   RowBox[{"Hold", "[", 
    RowBox[{"2", "-", "2"}], "]"}]}], "]"}]], "Input",
 CellTags->"FRH",
 CellLabel->"In[783]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"Hold", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Hold", "[", 
      RowBox[{"2", "-", "2"}], "]"}]}], "+", "1", "-", "1"}], "]"}], 
  TraditionalForm]], "Output",
 CellTags->"FRH",
 CellLabel->"Out[783]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FRH", "[", "%", "]"}]], "Input",
 CellTags->"FRH",
 CellLabel->"In[784]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"FRH",
 CellLabel->"Out[784]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Isolate", "[", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "x", "-", "1"}], "==", "0"}], "]"}], ",", 
   "x", ",", 
   RowBox[{"IsolateNames", "\[Rule]", "HH"}]}], "]"}]], "Input",
 CellTags->"FRH",
 CellLabel->"In[785]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      TagBox[
       RowBox[{"HH", "(", "3", ")"}],
       HoldForm]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      TagBox[
       RowBox[{"HH", "(", "6", ")"}],
       HoldForm]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", 
      TagBox[
       RowBox[{"HH", "(", "7", ")"}],
       HoldForm]}], "}"}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"FRH",
 CellLabel->"Out[785]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FRH", "[", 
  RowBox[{"HH", "[", "3", "]"}], "]"}]], "Input",
 CellTags->"FRH",
 CellLabel->"In[786]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RadicalBox[
     RowBox[{
      FractionBox["27", "2"], "-", 
      FractionBox[
       RowBox[{"3", " ", 
        SqrtBox["69"]}], "2"]}], "3"]}], "+", 
   FractionBox[
    RadicalBox[
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"9", "+", 
        SqrtBox["69"]}], ")"}]}], "3"], 
    SuperscriptBox["3", 
     RowBox[{"2", "/", "3"}]]]}], TraditionalForm]], "Output",
 CellTags->"FRH",
 CellLabel->"Out[786]="]
}, Open  ]]
}, Open  ]],

Cell["FromTFI", "ObjectName",
 CellTags->"FromTFi"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FromTFi"],

Cell["\<\
FromTFi[expr, q1, q2, p] translates the TFi notatation from the TARCER \
package to the usual FeynCalc notation. See TFi for details on the \
conventions.\
\>", "Text",
 CellTags->"FromTFi"],

Cell[TextData[{
 "See also: ",
 ButtonBox["TFI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"TFI",
  ButtonNote->"TFI"],
 ", ",
 ButtonBox["ToTFI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ToTFI",
  ButtonNote->"ToTFI"],
 "."
}], "Text",
 CellTags->"FromTFI"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FromTFi"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToTFI", "[", 
  RowBox[{
   RowBox[{"FAD", "[", 
    RowBox[{"q1", ",", 
     RowBox[{"q1", "-", "p"}], ",", 
     RowBox[{"{", 
      RowBox[{"q2", ",", "M"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"q2", "-", "p"}], ",", "m"}], "}"}], ",", 
     RowBox[{"q1", "-", "q2"}]}], "]"}], ",", "q1", ",", "q2", ",", "p"}], 
  "]"}]], "Input",
 CellTags->"FromTFi",
 CellLabel->"In[787]:="],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   SubsuperscriptBox[
    StyleBox["F",
     SingleLetterItalics->False,
     FontWeight->"Bold"], 
    RowBox[{
     FormBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}],
      TraditionalForm], 
     FormBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "M"}], "}"}],
      TraditionalForm], 
     FormBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}],
      TraditionalForm], 
     FormBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "m"}], "}"}],
      TraditionalForm], 
     FormBox[
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}],
      TraditionalForm]}], 
    RowBox[{"(", 
     FormBox["D",
      TraditionalForm], ")"}]],
   HighEnergyPhysics`Tarcer`TFI[
   D, $CellContext`m^2, {{1, 0}, {1, $CellContext`M}, {1, 0}, {
     1, $CellContext`m}, {1, 0}}],
   Editable->True], TraditionalForm]], "Output",
 CellTags->"FromTFi",
 CellLabel->"Out[787]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromTFI", "[", 
  RowBox[{
   RowBox[{"TFI", "[", 
    RowBox[{"D", ",", 
     RowBox[{"SPD", "[", 
      RowBox[{"p", ",", "p"}], "]"}], ",", 
     RowBox[{"SOD", "[", "p", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "M"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "m"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", "q1", ",", 
   "q2", ",", "p"}], "]"}]], "Input",
 CellTags->"FromTFi",
 CellLabel->"In[788]:="],

Cell[BoxData[
 FormBox[
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["q2", "2"], ".", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q1", "-", "p"}], ")"}], "2"], "-", 
      SuperscriptBox["M", "2"]}], ")"}], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q2", "-", "p"}], ")"}], "2"], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "q2"}], ")"}], "2"], ".", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["q1", "2"], "-", 
      SuperscriptBox["m", "2"]}], ")"}]}]], TraditionalForm]], "Output",
 CellTags->"FromTFi",
 CellLabel->"Out[788]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromTFI", "[", 
  RowBox[{
   RowBox[{"TFI", "[", 
    RowBox[{"D", ",", 
     RowBox[{"SPD", "[", 
      RowBox[{"p", ",", "p"}], "]"}], ",", 
     RowBox[{"SOD", "[", "p", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "m"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "M"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "m"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", "q1", ",", 
   "q2", ",", "p"}], "]"}]], "Input",
 CellTags->"FromTFi",
 CellLabel->"In[789]:="],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{
    FormBox["\[CapitalDelta]",
     TraditionalForm], "\[CenterDot]", 
    FormBox["q2",
     TraditionalForm]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "q2"}], ")"}], "2"], ".", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["q2", "2"], "-", 
      SuperscriptBox["M", "2"]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"q2", "-", "p"}], ")"}], "2"], "-", 
      SuperscriptBox["m", "2"]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["q1", "2"], "-", 
      SuperscriptBox["m", "2"]}], ")"}], ".", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"q1", "-", "p"}], ")"}], "2"]}]], TraditionalForm]], "Output",
 CellTags->"FromTFi",
 CellLabel->"Out[789]="]
}, Open  ]]
}, Open  ]],

Cell["FUNCTION", "ObjectName",
 CellTags->"FUNCTION"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FUNCTION"],

Cell["\<\
FUNCTION[exp, string] is a head of an expression to be declared a function \
(of type string), if used in Write2.\
\>", "Text",
 CellTags->"FUNCTION"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["Write2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Write2",
  ButtonNote->"Write2"],
 "."
}], "Text",
 CellTags->"FUNCTION"]
}, Open  ]],

Cell["FunctionalD", "ObjectName",
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FunctionalD"],

Cell["\<\
FunctionalD[expr, {QuantumField[name, {mu}, {a}][p], ...}] calculates the \
functional derivative of expr with respect to the field list (with incoming \
momenta p, etc.) and does the fourier transform. FunctionalD[expr, \
{QuantumField[name, {mu},{a}], ...}] calculates the functional derivative and \
does partial integration but omits the x-space delta functions.\
\>", "Text",
 CellTags->"FunctionalD"],

Cell["FunctionalD is a low level function used in FeynRule.", "Text",
 CellTags->"FunctionalD"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FeynRule",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynRule",
  ButtonNote->"FeynRule"],
 ", ",
 ButtonBox["QuantumField",
  BaseStyle->"AddOnsLink",
  ButtonData:>"QuantumField",
  ButtonNote->"QuantumField"],
 "."
}], "Text",
 CellTags->"FunctionalD"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FunctionalD"],

Cell[TextData[{
 "Instead of the usual ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Delta]\[Phi]", "(", "x", ")"}], "/", 
     RowBox[{"\[Delta]\[Phi]", "(", "y", ")"}]}], "=", 
    RowBox[{
     SuperscriptBox["\[Delta]", 
      RowBox[{"(", "D", ")"}]], "(", 
     RowBox[{"x", "-", "y"}], ")"}]}], TraditionalForm]]],
 " the arguments and the \[Delta] function are omitted, i.e., for the program \
for simplicity: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Delta]\[Phi]", "/", "\[Delta]\[Phi]"}], "=", "1"}], 
   TraditionalForm]]]
}], "Text",
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionalD", "[", 
  RowBox[{
   RowBox[{"QuantumField", "[", "\[Phi]", "]"}], ",", 
   RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}], "]"}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[790]:="],

Cell[BoxData[
 FormBox["1", TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[790]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionalD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"QuantumField", "[", "\[Phi]", "]"}], "^", "2"}], ",", 
   RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}], "]"}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[791]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"2", " ", "\[Phi]"}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[791]="]
}, Open  ]],

Cell[TextData[{
 "Instead of the usual ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Delta]", " ", 
       RowBox[{
        SubscriptBox["\[PartialD]", "\[Mu]"], 
        RowBox[{"\[Phi]", "(", "x", ")"}]}]}], ")"}], "/", 
     RowBox[{"\[Delta]\[Phi]", "(", "y", ")"}]}], "=", 
    RowBox[{
     SubscriptBox["\[PartialD]", "\[Mu]"], 
     RowBox[{
      SuperscriptBox["\[Delta]", 
       RowBox[{"(", "D", ")"}]], "(", 
      RowBox[{"x", "-", "y"}], ")"}]}]}], TraditionalForm]]],
 " the arguments are omitted, and the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[PartialD]", "\[Mu]"], TraditionalForm]]],
 "operator is specified by default to be an integration by parts operator, \
i.e., the right hand side will be just ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FormBox[
      SubscriptBox["\[PartialD]", "\[Mu]"],
      TraditionalForm]}], ","}], TraditionalForm]]],
 " or, more precisely (by default) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]]}], TraditionalForm]]],
 "."
}], "Text",
 ZeroWidthTimes->True,
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionalD", "[", 
  RowBox[{
   RowBox[{"QuantumField", "[", 
    RowBox[{
     RowBox[{"PartialD", "[", "\[Mu]", "]"}], ",", "\[Phi]"}], "]"}], ",", 
   RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}], "]"}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[792]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   SubscriptBox[
    OverscriptBox["\[PartialD]", "\[RightArrow]"], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[792]="]
}, Open  ]],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"S", "[", "\[Phi]", "]"}], " ", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"\[Integral]", " ", 
     RowBox[{
      SuperscriptBox["d", "D"], 
      RowBox[{"x", " ", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["\[PartialD]", "\[Mu]"], 
          RowBox[{"\[Phi]", "(", "x", ")"}]}], " ", 
         RowBox[{
          SuperscriptBox["\[PartialD]", "\[Mu]"], 
          RowBox[{"\[Phi]", "(", "x", ")"}]}]}], "-", 
        RowBox[{
         SuperscriptBox["m", "2"], 
         RowBox[{"\[Phi]", "(", "x", ")"}], " ", 
         RowBox[{"\[Phi]", "(", "y", ")"}]}]}], "]"}]}]}]}]}], 
  TraditionalForm]]]], "Text",
 ZeroWidthTimes->True,
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", "\[Phi]", "]"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"QuantumField", "[", 
       RowBox[{
        RowBox[{"PartialD", "[", "\[Mu]", "]"}], ",", "\[Phi]"}], "]"}], ".", 
      
      RowBox[{"QuantumField", "[", 
       RowBox[{
        RowBox[{"PartialD", "[", "\[Mu]", "]"}], ",", "\[Phi]"}], "]"}]}], 
     "-", 
     RowBox[{
      RowBox[{"m", "^", "2"}], " ", 
      RowBox[{
       RowBox[{"QuantumField", "[", "\[Phi]", "]"}], ".", 
       RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}]}]}], ")"}], "/", 
   "2"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[793]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["\[Phi]", "\[Null]", "\[Null]"]}], ".", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["\[Phi]", "\[Null]", "\[Null]"]}]}], "-", 
     RowBox[{
      SuperscriptBox["m", "2"], " ", 
      RowBox[{"\[Phi]", ".", "\[Phi]"}]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[793]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionalD", "[", 
  RowBox[{
   RowBox[{"s", "[", "\[Phi]", "]"}], ",", 
   RowBox[{"QuantumField", "[", "\[Phi]", "]"}]}], "]"}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[794]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Phi]"}], " ", 
    SuperscriptBox["m", "2"]}], "-", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["\[Phi]", "\[Null]", "\[Null]"]}]}], 
  TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[794]="]
}, Open  ]],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"S", "[", "A", "]"}], " ", "=", " ", 
   RowBox[{"-", 
    RowBox[{"\[Integral]", " ", 
     RowBox[{
      SuperscriptBox["d", "D"], "x", " ", 
      FractionBox["1", "4"], " ", 
      RowBox[{
       SubsuperscriptBox["F", "a", "\[Mu]\[Nu]"], "(", "x", ")"}], " ", 
      RowBox[{
       SubscriptBox["F", "\[Mu]\[Nu]a"], "(", "x", ")"}]}]}]}]}], 
  TraditionalForm]]]], "Text",
 ZeroWidthTimes->True,
 CellTags->"FunctionalD"],

Cell[TextData[StyleBox["First approach",
 FontWeight->"Bold"]], "Text",
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F1", "=", 
  RowBox[{"FieldStrength", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a", ",", 
    RowBox[{"{", 
     RowBox[{"A", ",", "b", ",", "c"}], "}"}], ",", "1", ",", 
    RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[795]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{"a", "b", "c"}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[795]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F2", "=", 
  RowBox[{"FieldStrength", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "a", ",", 
    RowBox[{"{", 
     RowBox[{"A", ",", "d", ",", "e"}], "}"}], ",", "1", ",", 
    RowBox[{"Explicit", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[796]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{"a", "d", "e"}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[796]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"S", "[", "A", "]"}], "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"1", "/", "4"}]}], 
   RowBox[{"F1", ".", "F2"}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[797]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "-", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "+", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["c",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       SubscriptBox["f", 
        RowBox[{"a", "b", "c"}]]}]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "-", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "+", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["d",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["e",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       SubscriptBox["f", 
        RowBox[{"a", "d", "e"}]]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[797]="]
}, Open  ]],

Cell[TextData[{
 "In order to derive the equation of motion the functional derivative of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " with respect to ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["A", "\[Sigma]", "g"], TraditionalForm]]],
 "has to be set to zero. Bearing in mind that for FeynCalc we have to be \
precise as to where which operators (coming from the substitution of the \
derivative of the \[Delta] function) act:, act with the functional derivative \
operator on the first field strength:"
}], "Text",
 CellTags->"FunctionalD"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FormBox[
      RowBox[{
       FormBox[
        RowBox[{
         FormBox[
          RowBox[{"0", " ", "=", " ", 
           RowBox[{
            FormBox[
             RowBox[{
              RowBox[{"(", "\[Delta]S", ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"\[Delta]", 
                RowBox[{
                 SubsuperscriptBox["A", "\[Sigma]", "g"], "(", "y", ")"}]}], 
               ")"}]}],
             TraditionalForm], "=", 
            RowBox[{"-", 
             RowBox[{"2", "/", "4"}]}]}]}],
          TraditionalForm], 
         RowBox[{"\[Integral]", 
          RowBox[{
           SuperscriptBox["d", "D"], "x"}]}]}],
        TraditionalForm], " ", 
       RowBox[{"(", 
        RowBox[{"\[Delta]", "/", 
         RowBox[{"(", 
          RowBox[{"\[Delta]", 
           RowBox[{
            SubsuperscriptBox["A", "\[Sigma]", "g"], "(", "y", ")"}]}], 
          ")"}]}]}]}],
      TraditionalForm], " ", 
     RowBox[{
      SubscriptBox["F", "\[Mu]\[Nu]a"], "(", "x", ")"}]}], ")"}], 
   TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{
    FormBox[
     RowBox[{" ", 
      SubsuperscriptBox["F", "a", 
       RowBox[{",", "\[Mu]\[Nu]"}]]}],
     TraditionalForm], "(", "x", ")"}], TraditionalForm]]]
}], "Text",
 ZeroWidthTimes->True,
 CellTags->"FunctionalD"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"See", " ", "what", " ", "happens", " ", "with", " ", "just", 
   RowBox[{
    FormBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Delta]", 
        RowBox[{"S", "[", "A", "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"\[Delta]", 
        SubsuperscriptBox["A", "\[Sigma]", "g"]}], ")"}]}],
     TraditionalForm], "."}]}], TraditionalForm]]]], "Text",
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ag", "=", 
  RowBox[{"QuantumField", "[", 
   RowBox[{"A", ",", 
    RowBox[{"{", "\[Sigma]", "}"}], ",", 
    RowBox[{"{", "g", "}"}]}], "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[798]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["A", 
   FormBox[
    FormBox["\[Sigma]",
     TraditionalForm],
    TraditionalForm], 
   FormBox[
    FormBox["g",
     TraditionalForm],
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[798]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{"FunctionalD", "[", 
   RowBox[{"F1", ",", "Ag"}], "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[799]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["g", 
      RowBox[{"\[Nu]", "\[Sigma]"}]]}], " ", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[799]="]
}, Open  ]],

Cell["\<\
In order to minimize the number of dummy indices, replace b \[Rule] c.\
\>", "Text",
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", " ", "=", " ", 
  RowBox[{"t1", " ", "/.", " ", 
   RowBox[{"b", "\[Rule]", "c"}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[800]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["g", 
      RowBox[{"\[Nu]", "\[Sigma]"}]]}], " ", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["\[Delta]", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Nu]", "\[Sigma]"}]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", "\[Sigma]"}]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[800]="]
}, Open  ]],

Cell[TextData[{
 "Instead of inserting the definition for the second ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox["F", "a", "\[Mu]\[Nu]"], TraditionalForm]]],
 ", introduce a QuantumField object with antisymmetry built into the Lorentz \
indices:"
}], "Text",
 CellTags->"FunctionalD"],

Cell[BoxData[
 RowBox[{"F", "/:", " ", 
  RowBox[{"QuantumField", "[", 
   RowBox[{
   "pard___", ",", "F", ",", "\[Beta]_", ",", "\[Alpha]_", ",", "s_"}], "]"}],
   ":=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"QuantumField", "[", 
     RowBox[{"pard", ",", "F", ",", "\[Alpha]", ",", "\[Beta]", ",", "s"}], 
     "]"}]}], "/;", 
   RowBox[{"!", 
    RowBox[{"OrderedQ", "[", 
     RowBox[{"{", 
      RowBox[{"\[Beta]", ",", "\[Alpha]"}], "}"}], "]"}]}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[801]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuantumField", "[", 
  RowBox[{"F", ",", 
   RowBox[{"{", 
    RowBox[{"\[Mu]", ",", "\[Nu]"}], "}"}], ",", 
   RowBox[{"{", "a", "}"}]}], "]"}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[802]:="],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox["F", 
   RowBox[{
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]}], 
   FormBox[
    FormBox["a",
     TraditionalForm],
    TraditionalForm]], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[802]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Mu]", "\[RuleDelayed]", "\[Nu]"}], ",", 
    RowBox[{"\[Nu]", "\[RuleDelayed]", "\[Mu]"}]}], "}"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[803]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   SubsuperscriptBox["F", 
    RowBox[{
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm]}], 
    FormBox[
     FormBox["a",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[803]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{
   RowBox[{"Contract", "[", 
    RowBox[{"ExpandPartialD", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"1", "/", "2"}]}], " ", 
      RowBox[{"t1", ".", 
       RowBox[{"QuantumField", "[", 
        RowBox[{"F", ",", 
         RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
         RowBox[{"LorentzIndex", "[", "\[Nu]", "]"}], ",", 
         RowBox[{"SUNIndex", "[", "a", "]"}]}], "]"}]}]}], "]"}], "]"}], "/.",
    
   RowBox[{"Dot", "\[Rule]", "Times"}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[804]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["F", 
      RowBox[{
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]}], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]]}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["F", 
      RowBox[{
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]}], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]]}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["F", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["F", 
     RowBox[{
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[804]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", " ", "=", " ", 
  RowBox[{"t2", " ", "/.", " ", 
   RowBox[{"\[Nu]", "\[Rule]", "\[Mu]"}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[805]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox["F", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["F", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[805]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t4", "=", 
  RowBox[{
   RowBox[{"FCE", "[", "t3", "]"}], "/.", " ", 
   RowBox[{
    RowBox[{"SUNF", "[", 
     RowBox[{"a", ",", "c", ",", "g"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{"SUNF", "[", 
      RowBox[{"g", ",", "c", ",", "a"}], "]"}]}]}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[806]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox["F", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["F", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{"g", "c", "a"}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[806]="]
}, Open  ]],

Cell[TextData[{
 "Since the variational derivative vanishes t4 implies that 0 = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["D", "\[Mu]"], 
    SubsuperscriptBox["F", "g", "\[Mu]\[Sigma]"]}], TraditionalForm]]],
 " ."
}], "Text",
 CellTags->"FunctionalD"],

Cell[TextData[StyleBox["Second approach",
 FontWeight->"Bold"]], "Text",
 CellTags->"FunctionalD"],

Cell["\<\
It is of course also possible to do the functional deriviate on the S[A] with \
both field strength tensors inserted.\
\>", "Text",
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", "[", "A", "]"}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[807]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "-", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "+", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["c",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       SubscriptBox["f", 
        RowBox[{"a", "b", "c"}]]}]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "-", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Nu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "+", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["d",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["e",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       SubscriptBox["f", 
        RowBox[{"a", "d", "e"}]]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[807]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{"FunctionalD", "[", 
   RowBox[{
    RowBox[{"S", "[", "A", "]"}], ",", "Ag"}], "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[808]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Sigma]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Sigma]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm]]}]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm]]}]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm]]}]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm]]}]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm]]}], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm]]}], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm]]}], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["a",
         TraditionalForm],
        TraditionalForm]]}], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["c",
         TraditionalForm],
        TraditionalForm]]}]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["c",
         TraditionalForm],
        TraditionalForm]]}]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["b",
         TraditionalForm],
        TraditionalForm]]}], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["b",
         TraditionalForm],
        TraditionalForm]]}], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["e",
         TraditionalForm],
        TraditionalForm]]}]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]], ".", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["e",
         TraditionalForm],
        TraditionalForm]]}]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["d",
         TraditionalForm],
        TraditionalForm]]}], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["d",
         TraditionalForm],
        TraditionalForm]]}], ".", 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[808]="]
}, Open  ]],

Cell["\<\
This is just funcional derivation and partial integration and simple \
contraction of indices. No attempt is made to rename dummy indices (since \
this is difficult in general).\
\>", "Text",
 CellTags->"FunctionalD"],

Cell["\<\
With a general replacement rule only valid for commuting fields the color \
indices can be canonicalized a bit more. The idea is to use the commutative \
properties of the vector fields, and canonicalize the color indices by a \
trick. This function will work on any commuting product of fields.\
\>", "Text",
 CellTags->"FunctionalD"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "symfun", "]"}], ";"}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[809]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"symfun", "[", 
   RowBox[{"z_", ",", "fieldname_Symbol"}], "]"}], ":=", 
  RowBox[{"Expand", "[", 
   RowBox[{"SUNSimplify", "[", 
    RowBox[{"FixedPoint", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Collect2", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"DotSimplify", "[", 
            RowBox[{"#1", "/.", 
             RowBox[{"Times", "\[Rule]", "Dot"}]}], "]"}], "/.", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", "qi___", ")"}], ".", 
                RowBox[{"QuantumField", "[", 
                 RowBox[{
                 "par1___", ",", "fieldname", ",", "li1_", ",", "sui1_"}], 
                 "]"}], ".", 
                RowBox[{"QuantumField", "[", 
                 RowBox[{
                 "par2___", ",", "fieldname", ",", "li2_", ",", "sui2_"}], 
                 "]"}], ".", "qf___"}], " ", ")"}], "any_"}], ")"}], 
            "\[RuleDelayed]", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"qi", ".", 
                 RowBox[{"QuantumField", "[", 
                  RowBox[{"par1", ",", "A", ",", "li1", ",", "sui2"}], "]"}], 
                 ".", 
                 RowBox[{"QuantumField", "[", 
                  RowBox[{"par2", ",", "fieldname", ",", "li2", ",", "sui1"}],
                   "]"}], ".", "qf"}], " ", ")"}], 
               RowBox[{"(", 
                RowBox[{"any", "/.", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"sui1", "\[RuleDelayed]", "sui2"}], ",", 
                   RowBox[{"sui2", "\[RuleDelayed]", "sui1"}]}], "}"}]}], 
                ")"}]}], ")"}], "/;", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"!", 
                RowBox[{"(", 
                 RowBox[{"FreeQ2", "[", 
                  RowBox[{"any", ",", 
                   RowBox[{"{", 
                    RowBox[{"sui1", ",", "su2"}], "}"}]}], "]"}], ")"}]}], 
               ")"}], "&&", 
              RowBox[{"!", 
               RowBox[{"(", 
                RowBox[{"OrderedQ", "[", 
                 RowBox[{"{", 
                  RowBox[{"sui1", ",", "sui2"}], "}"}], "]"}], 
                ")"}]}]}]}]}]}], "/.", 
          RowBox[{"Dot", "\[Rule]", "Times"}]}], ",", "QuantumField"}], "]"}],
        "&"}], ",", "z", ",", "42"}], "]"}], "]"}], "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[810]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r2", " ", "=", " ", 
  RowBox[{"symfun", "[", 
   RowBox[{"r1", ",", "A"}], "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[811]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Sigma]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Nu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Sigma]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Nu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Nu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[811]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r3", "=", 
  RowBox[{"r2", "/.", 
   RowBox[{"\[Nu]", "\[Rule]", "\[Mu]"}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[812]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{"2", " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["3", "4"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[812]="]
}, Open  ]],

Cell[TextData[{
 "Inspection reveals that still terms are the same. Gather the terms with two \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", " "}], TraditionalForm]]],
 "'s:"
}], "Text",
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"twof", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"r3", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Count", "[", 
       RowBox[{"#", ",", 
        RowBox[{"SUNF", "[", "__", "]"}]}], "]"}], "===", "2"}], "&"}]}], 
   "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[813]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "4"]}], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[813]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"twofnew", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"twof", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
     "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"twof", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "\[RuleDelayed]", "c"}], ",", 
         RowBox[{"c", "\[RuleDelayed]", "b"}]}], "}"}]}], ")"}]}], ")"}], "/.",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[RuleDelayed]", "c"}], ",", 
     RowBox[{"c", "\[RuleDelayed]", "a"}]}], "}"}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[814]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]]}], " ", 
   SubsuperscriptBox["A", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["b",
      TraditionalForm],
     TraditionalForm]], " ", 
   SubsuperscriptBox["A", 
    FormBox[
     FormBox["\[Sigma]",
      TraditionalForm],
     TraditionalForm], 
    FormBox[
     FormBox["e",
      TraditionalForm],
     TraditionalForm]], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]}]], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[814]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r4", " ", "=", " ", 
  RowBox[{"r3", "-", "twof", "+", "twofnew"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[815]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{"2", " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[815]="]
}, Open  ]],

Cell["\<\
Check that this is now indeed the same as the t4 result from the first \
attempt.\
\>", "Text",
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData["t4"], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[816]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], 
    SubsuperscriptBox["F", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["F", 
     RowBox[{
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]}], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{"g", "c", "a"}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[816]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w0", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"RightPartialD", "[", "\[Mu]", "]"}], ".", 
    RowBox[{"FieldStrength", "[", 
     RowBox[{"\[Mu]", ",", "\[Sigma]", ",", "g", ",", 
      RowBox[{"{", 
       RowBox[{"A", ",", "a", ",", "b"}], "}"}], ",", "1"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"QuantumField", "[", 
     RowBox[{"A", ",", 
      RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
      RowBox[{"SUNIndex", "[", "c", "]"}]}], "]"}], 
    RowBox[{"FieldStrength", "[", 
     RowBox[{"\[Mu]", ",", "\[Sigma]", ",", "a", ",", 
      RowBox[{"{", 
       RowBox[{"A", ",", "b", ",", "d"}], "}"}], ",", "1"}], "]"}], 
    RowBox[{"SUNF", "[", 
     RowBox[{"g", ",", "c", ",", "a"}], "]"}]}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[817]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    SubsuperscriptBox["F", 
     RowBox[{"\[Mu]", "\[Sigma]"}], 
     RowBox[{"g", 
      FormBox[
       RowBox[{"{", 
        RowBox[{"A", ",", "a", ",", "b"}], "}"}],
       TraditionalForm], 
      FormBox["1",
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["F", 
     RowBox[{"\[Mu]", "\[Sigma]"}], 
     RowBox[{"a", 
      FormBox[
       RowBox[{"{", 
        RowBox[{"A", ",", "b", ",", "d"}], "}"}],
       TraditionalForm], 
      FormBox["1",
       TraditionalForm]}]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{"g", "c", "a"}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[817]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w1", "=", 
  RowBox[{"Explicit", "[", "w0", "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[818]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     OverscriptBox["\[PartialD]", "\[RightArrow]"], 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm]], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["g",
          TraditionalForm],
         TraditionalForm]]}], "-", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["g",
          TraditionalForm],
         TraditionalForm]]}], "+", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["a",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Sigma]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       SubscriptBox["f", 
        RowBox[{
         FormBox[
          FormBox["a",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["g",
           TraditionalForm],
          TraditionalForm]}]]}]}], ")"}]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "-", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        FormBox[
         FormBox["\[Sigma]",
          TraditionalForm],
         TraditionalForm]], 
       SubsuperscriptBox["A", 
        FormBox[
         FormBox["\[Mu]",
          TraditionalForm],
         TraditionalForm], 
        FormBox[
         FormBox["a",
          TraditionalForm],
         TraditionalForm]]}], "+", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm]], ".", 
        SubsuperscriptBox["A", 
         FormBox[
          FormBox["\[Sigma]",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["d",
           TraditionalForm],
          TraditionalForm]]}], " ", 
       SubscriptBox["f", 
        RowBox[{
         FormBox[
          FormBox["a",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["b",
           TraditionalForm],
          TraditionalForm], 
         FormBox[
          FormBox["d",
           TraditionalForm],
          TraditionalForm]}]]}]}], ")"}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[818]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w2", "=", 
  RowBox[{
   RowBox[{"ExpandPartialD", "[", "w1", "]"}], "/.", 
   RowBox[{"Dot", "\[Rule]", "Times"}]}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[819]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["d",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[819]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dif1", " ", "=", " ", 
  RowBox[{"w2", "-", "r4"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[820]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{"2", " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["d",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["e",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["e",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[820]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dif2", "=", 
  RowBox[{"symfun", "[", 
   RowBox[{"dif1", ",", "A"}], "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[821]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm], 
       FormBox[
        SubscriptBox["\[PartialD]", 
         FormBox[
          FormBox["\[Mu]",
           TraditionalForm],
          TraditionalForm]],
        TraditionalForm]}], 
      SubsuperscriptBox["A", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm], 
       FormBox[
        FormBox["g",
         TraditionalForm],
        TraditionalForm]]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "-", 
   RowBox[{
    RowBox[{
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm], 
     FormBox[
      SubscriptBox["\[PartialD]", 
       FormBox[
        FormBox["\[Sigma]",
         TraditionalForm],
        TraditionalForm]],
      TraditionalForm]}], 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["g",
       TraditionalForm],
      TraditionalForm]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{"2", " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{"2", " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["\[Sigma]",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox["A", 
      FormBox[
       FormBox["\[Mu]",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm]]}], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "+", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["d",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}], "-", 
   RowBox[{
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Mu]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubsuperscriptBox["A", 
     FormBox[
      FormBox["\[Sigma]",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["d",
       TraditionalForm],
      TraditionalForm]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["b",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["d",
        TraditionalForm],
       TraditionalForm]}]], " ", 
    SubscriptBox["f", 
     RowBox[{
      FormBox[
       FormBox["a",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["c",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["g",
        TraditionalForm],
       TraditionalForm]}]]}]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[821]="]
}, Open  ]],

Cell["quod erat demonstrandum.", "Text",
 CellTags->"FunctionalD"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unset", "[", 
   RowBox[{"s", "[", "\[Phi]", "]"}], "]"}], ";", 
  RowBox[{"Unset", "[", 
   RowBox[{"S", "[", "A", "]"}], "]"}], ";", 
  RowBox[{"Clear", "[", 
   RowBox[{
   "Ag", ",", "F1", ",", "F2", ",", "t1", ",", "t2", ",", "t3", ",", "t4", 
    ",", "F", ",", "r1", ",", "r2", ",", "r3", ",", "r4", ",", "symfun", ",", 
    "twof", ",", "twofnew", ",", "w0", ",", "w1", ",", "w2", ",", "dif1", ",",
     "dif2", ",", "dif3"}], "]"}]}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[822]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples of funcional differentiation as used in FeynRule", \
"Subsubsection",
 CellTags->"FunctionalD"],

Cell["This is a part of the QCD Lagrangian.", "Text",
 CellTags->"FunctionalD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"Gstrong", "*", 
    RowBox[{
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", " ", 
       RowBox[{"LorentzIndex", "[", "li1", "]"}], ",", "  ", 
       RowBox[{"SUNIndex", "[", "si2", "]"}]}], "]"}], ".", "  ", 
     RowBox[{"QuantumField", "[", 
      RowBox[{"GaugeField", ",", " ", 
       RowBox[{"LorentzIndex", "[", "li2", "]"}], ",", "   ", 
       RowBox[{"SUNIndex", "[", "si4", "]"}]}], "]"}], " ", ".", "  ", 
     RowBox[{"QuantumField", "[", 
      RowBox[{
       RowBox[{"PartialD", "[", 
        RowBox[{"LorentzIndex", "[", "li1", "]"}], "]"}], ",", " ", 
       "GaugeField", ",", "   ", 
       RowBox[{"LorentzIndex", "[", "li2", "]"}], ",", " ", 
       RowBox[{"SUNIndex", "[", "si1", "]"}]}], "]"}]}], "*", "  ", 
    RowBox[{"SUNF", "[", 
     RowBox[{
      RowBox[{"SUNIndex", "[", "si1", "]"}], ",", " ", 
      RowBox[{"SUNIndex", "[", "si2", "]"}], ",", " ", 
      RowBox[{"SUNIndex", "[", "si4", "]"}]}], "]"}]}], ")"}], "/", 
  "4"}]], "Input",
 CellLabel->"In[823]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "4"], " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["li1",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["si2",
       TraditionalForm],
      TraditionalForm]], ".", 
    SubsuperscriptBox[
     FormBox["A",
      TraditionalForm], 
     FormBox[
      FormBox["li2",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["si4",
       TraditionalForm],
      TraditionalForm]], ".", 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      FormBox[
       FormBox["li1",
        TraditionalForm],
       TraditionalForm]], 
     SubsuperscriptBox[
      FormBox["A",
       TraditionalForm], 
      FormBox[
       FormBox["li2",
        TraditionalForm],
       TraditionalForm], 
      FormBox[
       FormBox["si1",
        TraditionalForm],
       TraditionalForm]]}]}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["si1",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["si2",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["si4",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellLabel->"Out[823]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionalD", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"QuantumField", "[", 
       RowBox[{"GaugeField", ",", 
        RowBox[{"{", "\[Mu]", "}"}], ",", 
        RowBox[{"{", "a", "}"}]}], "]"}], "[", "p", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"QuantumField", "[", 
       RowBox[{"GaugeField", ",", 
        RowBox[{"{", "\[Nu]", "}"}], ",", 
        RowBox[{"{", "b", "}"}]}], "]"}], "[", "q", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"QuantumField", "[", 
       RowBox[{"GaugeField", ",", 
        RowBox[{"{", "\[Rho]", "}"}], ",", 
        RowBox[{"{", "c", "}"}]}], "]"}], "[", "r", "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[824]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "4"], " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li1", "\[Mu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si2",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Nu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si4",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox[
         FormBox["r",
          TraditionalForm], 
         FormBox[
          FormBox["li1",
           TraditionalForm],
          TraditionalForm]], " ", 
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Rho]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["c",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si1",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li1", "\[Mu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si2",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Rho]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["c",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si4",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox[
         FormBox["q",
          TraditionalForm], 
         FormBox[
          FormBox["li1",
           TraditionalForm],
          TraditionalForm]], " ", 
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Nu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si1",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li1", "\[Nu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si2",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Mu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si4",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox[
         FormBox["r",
          TraditionalForm], 
         FormBox[
          FormBox["li1",
           TraditionalForm],
          TraditionalForm]], " ", 
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Rho]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["c",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si1",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li1", "\[Nu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si2",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Rho]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["c",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si4",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], 
         FormBox[
          FormBox["li1",
           TraditionalForm],
          TraditionalForm]], " ", 
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Mu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si1",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li1", "\[Rho]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["c",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si2",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Mu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si4",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox[
         FormBox["q",
          TraditionalForm], 
         FormBox[
          FormBox["li1",
           TraditionalForm],
          TraditionalForm]], " ", 
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Nu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si1",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li1", "\[Rho]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["c",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si2",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Nu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["b",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si4",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox[
         FormBox["p",
          TraditionalForm], 
         FormBox[
          FormBox["li1",
           TraditionalForm],
          TraditionalForm]], " ", 
        SuperscriptBox["g", 
         RowBox[{"li2", "\[Mu]"}]], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          FormBox[
           FormBox["a",
            TraditionalForm],
           TraditionalForm], 
          FormBox[
           FormBox["si1",
            TraditionalForm],
           TraditionalForm]}]]}], ")"}]}]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["si1",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["si2",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["si4",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[824]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Calc", "[", 
   RowBox[{"%", "//", "Calc"}], "]"}], "//", "Factor"}]], "Input",
 CellTags->"FunctionalD",
 CellLabel->"In[825]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
   SubscriptBox["g", "s"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
     RowBox[{
      SuperscriptBox[
       FormBox["r",
        TraditionalForm], 
       FormBox[
        FormBox["\[Mu]",
         TraditionalForm],
        TraditionalForm]], " ", 
      SuperscriptBox["g", 
       RowBox[{"\[Nu]", "\[Rho]"}]]}], "-", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Rho]"}]], " ", 
      SuperscriptBox[
       FormBox["r",
        TraditionalForm], 
       FormBox[
        FormBox["\[Nu]",
         TraditionalForm],
        TraditionalForm]]}], "+", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      SuperscriptBox[
       FormBox["p",
        TraditionalForm], 
       FormBox[
        FormBox["\[Rho]",
         TraditionalForm],
        TraditionalForm]]}], "-", 
     RowBox[{
      SuperscriptBox["g", 
       RowBox[{"\[Mu]", "\[Nu]"}]], " ", 
      SuperscriptBox[
       FormBox["q",
        TraditionalForm], 
       FormBox[
        FormBox["\[Rho]",
         TraditionalForm],
        TraditionalForm]]}]}], ")"}], " ", 
   SubscriptBox["f", 
    RowBox[{
     FormBox[
      FormBox["a",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["b",
       TraditionalForm],
      TraditionalForm], 
     FormBox[
      FormBox["c",
       TraditionalForm],
      TraditionalForm]}]]}], TraditionalForm]], "Output",
 CellTags->"FunctionalD",
 CellLabel->"Out[825]="]
}, Open  ]]
}, Open  ]],

Cell["FV", "ObjectName",
 CellTags->"FV"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FV"],

Cell[TextData[{
 "FV[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "] is the four-dimensional vector ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["p", "\[Mu]"], TraditionalForm]]],
 ". "
}], "Text",
 CellTags->"FV"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FCE",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCE",
  ButtonNote->"FCE"],
 ", ",
 ButtonBox["FCI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCI",
  ButtonNote->"FCI"],
 ", ",
 ButtonBox["FVD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FVD",
  ButtonNote->"FVD"],
 ", ",
 ButtonBox["FourVector",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FourVector",
  ButtonNote->"FourVector"],
 ", ",
 ButtonBox["Pair",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Pair",
  ButtonNote->"Pair"],
 "."
}], "Text",
 CellTags->"FV"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FV"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FV", "[", 
  RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Input",
 CellTags->"FV",
 CellLabel->"In[826]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["p", "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"FV",
 CellLabel->"Out[826]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FV", "[", 
  RowBox[{
   RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "Input",
 CellTags->"FV",
 CellLabel->"In[827]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox[
    RowBox[{"p", "-", "q"}],
    TraditionalForm], "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"FV",
 CellLabel->"Out[827]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FV", "[", 
   RowBox[{"p", ",", "\[Mu]"}], "]"}], "//", "StandardForm"}]], "Input",
 CellTags->"FV",
 CellLabel->"In[828]:="],

Cell[BoxData[
 RowBox[{"FV", "[", 
  RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Output",
 CellTags->"FV",
 CellLabel->"Out[828]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FCI", "[", 
   RowBox[{"FV", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}], "]"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FV",
 CellLabel->"In[829]:="],

Cell[BoxData[
 RowBox[{"Pair", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], ",", 
   RowBox[{"Momentum", "[", "p", "]"}]}], "]"}]], "Output",
 CellTags->"FV",
 CellLabel->"Out[829]//StandardForm="]
}, Open  ]],

Cell["\<\
There is no special function to expand momenta in FV; ExpandScalarProduct \
does the job.\
\>", "Text",
 CellTags->"FV"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandScalarProduct", "[", 
  RowBox[{"FV", "[", 
   RowBox[{
    RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}], "]"}]], "Input",
 CellTags->"FV",
 CellLabel->"In[830]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox[
    RowBox[{"p", "-", "q"}],
    TraditionalForm], "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"FV",
 CellLabel->"Out[830]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", "%", "]"}]], "Input",
 CellTags->"FV",
 CellLabel->"In[831]:="],

Cell[BoxData[
 RowBox[{"FV", "[", 
  RowBox[{
   RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "Output",
 CellTags->"FV",
 CellLabel->"Out[831]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["FVD", "ObjectName",
 CellTags->"FVD"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"FVD"],

Cell[TextData[{
 "FVD[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "] is the D-dimensional vector ",
 StyleBox["p",
  FontSlant->"Italic"],
 " with Lorentz index ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "."
}], "Text",
 CellTags->"FVD"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["FCE",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCE",
  ButtonNote->"FCE"],
 ", ",
 ButtonBox["FCI",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FCI",
  ButtonNote->"FCI"],
 ", ",
 ButtonBox["FV",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FV",
  ButtonNote->"FV"],
 ", ",
 ButtonBox["FourVector",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FourVector",
  ButtonNote->"FourVector"],
 ", ",
 ButtonBox["Pair",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Pair",
  ButtonNote->"Pair"],
 "."
}], "Text",
 CellTags->"FVD"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"FVD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FVD", "[", 
  RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Input",
 CellTags->"FVD",
 CellLabel->"In[832]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["p", "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"FVD",
 CellLabel->"Out[832]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FVD", "[", 
  RowBox[{
   RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "Input",
 CellTags->"FVD",
 CellLabel->"In[833]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox[
    RowBox[{"p", "-", "q"}],
    TraditionalForm], "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"FVD",
 CellLabel->"Out[833]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FVD", "[", 
   RowBox[{"p", ",", "\[Mu]"}], "]"}], "//", "StandardForm"}]], "Input",
 CellTags->"FVD",
 CellLabel->"In[834]:="],

Cell[BoxData[
 RowBox[{"FVD", "[", 
  RowBox[{"p", ",", "\[Mu]"}], "]"}]], "Output",
 CellTags->"FVD",
 CellLabel->"Out[834]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FCI", "[", 
   RowBox[{"FVD", "[", 
    RowBox[{"p", ",", "\[Mu]"}], "]"}], "]"}], "//", 
  "StandardForm"}]], "Input",
 CellTags->"FVD",
 CellLabel->"In[835]:="],

Cell[BoxData[
 RowBox[{"Pair", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", 
    RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", 
   RowBox[{"Momentum", "[", 
    RowBox[{"p", ",", "D"}], "]"}]}], "]"}]], "Output",
 CellTags->"FVD",
 CellLabel->"Out[835]//StandardForm="]
}, Open  ]],

Cell["There is no special function to expand momenta in FVD.", "Text",
 CellTags->"FVD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandScalarProduct", "[", 
  RowBox[{"FVD", "[", 
   RowBox[{
    RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}], "]"}]], "Input",
 CellTags->"FVD",
 CellLabel->"In[836]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox[
   FormBox[
    RowBox[{"p", "-", "q"}],
    TraditionalForm], "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"FVD",
 CellLabel->"Out[836]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", "%", "]"}]], "Input",
 CellTags->"FVD",
 CellLabel->"In[837]:="],

Cell[BoxData[
 RowBox[{"FVD", "[", 
  RowBox[{
   RowBox[{"p", "-", "q"}], ",", "\[Mu]"}], "]"}]], "Output",
 CellTags->"FVD",
 CellLabel->"Out[837]//StandardForm="]
}, Open  ]]
}, Open  ]],

Cell["GA", "ObjectName",
 CellTags->"GA"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"GA"],

Cell[TextData[{
 "GA[",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "] can be used as input for a 4-dimensional ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    RowBox[{"\[Mu]", " "}]], TraditionalForm]]],
 "and is transformed into DiracGamma[LorentzIndex[",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "]] by FeynCalcInternal (=FCI).GA[",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Mu]", ",", "\[Nu]", ","}], TraditionalForm]]],
 " ...] is a short form for GA[",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "].GA[",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]]],
 "]. ... ."
}], "Text",
 CellTags->"GA"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix",
  ButtonNote->"DiracMatrix"],
 ", ",
 ButtonBox["GAD",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GAD",
  ButtonNote->"GAD"],
 ", ",
 ButtonBox["GS",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GS",
  ButtonNote->"GS"],
 "."
}], "Text",
 CellTags->"GA"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"GA"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GA", "[", "\[Mu]", "]"}]], "Input",
 CellTags->"GA",
 CellLabel->"In[838]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"GA",
 CellLabel->"Out[838]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GA", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "-", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"GA",
 CellLabel->"In[839]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
    SuperscriptBox["\[Gamma]", "\[Nu]"]}], "-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
    SuperscriptBox["\[Gamma]", "\[Mu]"]}]}], TraditionalForm]], "Output",
 CellTags->"GA",
 CellLabel->"Out[839]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"FCI", "[", 
   RowBox[{"GA", "[", "\[Mu]", "]"}], "]"}], "]"}]], "Input",
 CellTags->"GA",
 CellLabel->"In[840]:="],

Cell[BoxData[
 RowBox[{"DiracGamma", "[", 
  RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}]], "Output",
 CellTags->"GA",
 CellLabel->"Out[840]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GA", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
  "]"}]], "Input",
 CellTags->"GA",
 CellLabel->"In[841]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Rho]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Sigma]"]}], TraditionalForm]], "Output",
 CellTags->"GA",
 CellLabel->"Out[841]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"GA", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], "]"}], 
  "]"}]], "Input",
 CellTags->"GA",
 CellLabel->"In[842]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"GA", "[", "\[Mu]", "]"}], ".", 
  RowBox[{"GA", "[", "\[Nu]", "]"}], ".", 
  RowBox[{"GA", "[", "\[Rho]", "]"}], ".", 
  RowBox[{"GA", "[", "\[Sigma]", "]"}]}]], "Output",
 CellTags->"GA",
 CellLabel->"Out[842]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GA", "[", "\[Alpha]", "]"}], ".", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GS", "[", "p", "]"}], "+", "m"}], ")"}], ".", 
  RowBox[{"GA", "[", "\[Beta]", "]"}]}]], "Input",
 CellTags->"GA",
 CellLabel->"In[843]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Alpha]"], ".", 
   RowBox[{"(", 
    RowBox[{"m", "+", 
     RowBox[{"\[Gamma]", "\[CenterDot]", "p"}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", "\[Beta]"]}], TraditionalForm]], "Output",
 CellTags->"GA",
 CellLabel->"Out[843]="]
}, Open  ]]
}, Open  ]],

Cell["GAD", "ObjectName",
 CellTags->"GAD"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"GAD"],

Cell[TextData[{
 "GAD[",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "] can be used as input for a D-dimensional ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    RowBox[{"\[Mu]", " "}]], TraditionalForm]]],
 "and is transformed into DiracGamma[LorentzIndex[",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 ",D],D] by FeynCalcInternal (=FCI).GAD[",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", " ", "..."}], TraditionalForm]]],
 "] is a short form for GAD[",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]]],
 "].GAD[",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]]],
 "]. ... ."
}], "Text",
 CellTags->"GAD"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix",
  ButtonNote->"DiracMatrix"],
 ", ",
 ButtonBox["GA",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GA",
  ButtonNote->"GA"],
 ", ",
 ButtonBox["GS",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GS",
  ButtonNote->"GS"],
 "."
}], "Text",
 CellTags->"GAD"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"GAD"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GAD", "[", "\[Mu]", "]"}]], "Input",
 CellTags->"GAD",
 CellLabel->"In[844]:="],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[Gamma]", "\[Mu]"], TraditionalForm]], "Output",
 CellTags->"GAD",
 CellLabel->"Out[844]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GAD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]"}], "]"}], "-", 
  RowBox[{"GAD", "[", 
   RowBox[{"\[Nu]", ",", "\[Mu]"}], "]"}]}]], "Input",
 CellTags->"GAD",
 CellLabel->"In[845]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
    SuperscriptBox["\[Gamma]", "\[Nu]"]}], "-", 
   RowBox[{
    SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
    SuperscriptBox["\[Gamma]", "\[Mu]"]}]}], TraditionalForm]], "Output",
 CellTags->"GAD",
 CellLabel->"Out[845]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"FCI", "[", 
   RowBox[{"GAD", "[", "\[Mu]", "]"}], "]"}], "]"}]], "Input",
 CellTags->"GAD",
 CellLabel->"In[846]:="],

Cell[BoxData[
 RowBox[{"DiracGamma", "[", 
  RowBox[{
   RowBox[{"LorentzIndex", "[", 
    RowBox[{"\[Mu]", ",", "D"}], "]"}], ",", "D"}], "]"}]], "Output",
 CellTags->"GAD",
 CellLabel->"Out[846]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GAD", "[", 
  RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], 
  "]"}]], "Input",
 CellTags->"GAD",
 CellLabel->"In[847]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Mu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Nu]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Rho]"], ".", 
   SuperscriptBox["\[Gamma]", "\[Sigma]"]}], TraditionalForm]], "Output",
 CellTags->"GAD",
 CellLabel->"Out[847]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"GAD", "[", 
   RowBox[{"\[Mu]", ",", "\[Nu]", ",", "\[Rho]", ",", "\[Sigma]"}], "]"}], 
  "]"}]], "Input",
 CellTags->"GAD",
 CellLabel->"In[848]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"GAD", "[", "\[Mu]", "]"}], ".", 
  RowBox[{"GAD", "[", "\[Nu]", "]"}], ".", 
  RowBox[{"GAD", "[", "\[Rho]", "]"}], ".", 
  RowBox[{"GAD", "[", "\[Sigma]", "]"}]}]], "Output",
 CellTags->"GAD",
 CellLabel->"Out[848]//StandardForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GAD", "[", "\[Alpha]", "]"}], ".", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GSD", "[", "p", "]"}], "+", "m"}], ")"}], ".", 
  RowBox[{"GAD", "[", "\[Beta]", "]"}]}]], "Input",
 CellTags->"GAD",
 CellLabel->"In[849]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", "\[Alpha]"], ".", 
   RowBox[{"(", 
    RowBox[{"m", "+", 
     RowBox[{"\[Gamma]", "\[CenterDot]", "p"}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", "\[Beta]"]}], TraditionalForm]], "Output",
 CellTags->"GAD",
 CellLabel->"Out[849]="]
}, Open  ]]
}, Open  ]],

Cell["GammaEpsilon", "ObjectName",
 CellTags->"GammaEpsilon"],

Cell[CellGroupData[{

Cell["Description", "Subsubsection",
 CellTags->"GammaEpsilon"],

Cell["\<\
GammaEpsilon[exp] gives a series expansion of Gamma[exp] in Epsilon up to \
order 6 (where EulerGamma is neglected).\
\>", "Text",
 CellTags->"GammaEpsilon"],

Cell[TextData[{
 "See also: ",
 " ",
 ButtonBox["GammaExpand",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GammaExpand",
  ButtonNote->"GammaExpand"],
 ", ",
 ButtonBox["Series2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Series2",
  ButtonNote->"Series2"],
 "."
}], "Text",
 CellTags->"GammaEpsilon"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsubsection",
 CellTags->"GammaEpsilon"],

Cell["\<\
If the argument is of the form (1+a Epsilon) the result is not calculated but \
tabulated.\
\>", "Text",
 CellTags->"GammaEpsilon"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GammaEpsilon", "[", 
  RowBox[{"1", "+", 
   RowBox[{"a", " ", "Epsilon"}]}], "]"}]], "Input",
 CellTags->"GammaEpsilon",
 CellLabel->"In[850]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"C$3266", " ", 
    SuperscriptBox[
     TagBox["\[CurlyEpsilon]",
      TraditionalForm], "6"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "5"]}], " ", 
       TagBox[
        RowBox[{"\[Zeta]", "(", 
         TagBox["5",
          Zeta,
          Editable->True,
          Selectable->True], ")"}],
        InterpretTemplate[
         Function[BoxForm`e$, 
          Zeta[BoxForm`e$