Notebook[{Cell[CellGroupData[{Cell["FeynCalc 5.1", "Title", 
      TextAlignment -> Center], 
     Cell["Tools for quantum field theory calculations", "Subtitle", 
      TextAlignment -> Center], Cell[TextData[
       StyleBox["Reference Guide", Rule[FontWeight, "Bold"]]], "Subtitle", 
      PageBreakBelow -> True, TextAlignment -> Center], 
     Cell["Rolf Mertig and Frederik Orellana", "Subsubtitle", 
      TextAlignment -> Center], Cell[TextData[{"HTML version: ", 
        ButtonBox["http://www.feyncalc.org/", 
          RuleDelayed[ButtonData, List[URL["http://www.feyncalc.org/"], 
            None]], Rule[ButtonStyle, "Hyperlink"], 
          Rule[ButtonNote, "http://www.feyncalc.org/"]]}], "Subsubtitle", 
      TextAlignment -> Center], Cell[BoxData[
       ButtonBox[\(Click\ to\ save\ this\ notebook\ without\ cache\ and\ 
           FrontEndVersion\ info\), 
         RuleDelayed[ButtonFunction, 
          CompoundExpression[Module[List[fn], 
            CompoundExpression[SetDirectory[DirectoryName[Set[fn, 
                ToFileName[ReplaceAll["FileName", 
                  NotebookInformation[InputNotebook[]]]]]]], 
             Set[newfn, StringReplace[fn, Rule[".nb", "NoCache.nb"]]], 
             If[UnsameQ[FileNames[newfn], List[]], DeleteFile[newfn]], 
             Put[ReplaceAll[NotebookGet[InputNotebook[]], 
               List[RuleDelayed[Condition[Rule[FrontEndVersion, 
                   Pattern[v, Blank[]]], Equal[Head[v], String]], 
                 Sequence[]], RuleDelayed[Condition[Rule[CellLabel, 
                   Pattern[v, Blank[]]], Equal[Head[v], String]], 
                 Sequence[]]]], "fcr.nb"], CopyFile["fcr.nb", newfn], 
             DeleteFile["fcr.nb"]]]]], Rule[ButtonEvaluator, Automatic]]], 
      "NotebookDefault", Active -> True, CellTags -> "ClickSave"], 
     Cell[CellGroupData[{Cell[BoxData[\(Date[]\)], "Input"], Cell[BoxData[
          \(TraditionalForm\`\({2006, 4, 2, 23, 24, 
                35.4843872`9.302612203248454}\)\)], "Output"]}, Open]], 
     Cell[CellGroupData[{Cell["Functions", "Section", 
         CellTags -> "Functions"], Cell["Evaluation time and memory usage", 
         "Commentary"], 
        Cell["This is only for timing purposes and can be omitted in \
general.", "Text"], Cell[CellGroupData[{Cell[BoxData[
             \(absolutestarttime = \(AbsoluteTime[]\)\)], "Input"], 
           Cell[BoxData[
             \(TraditionalForm\`3.3530090755244448`17.27800971808679*^9\)], 
            "Output"]}, Open]], Cell["<<HighEnergyPhysics`FeynCalc`", 
         "Input"], Cell["Abbreviation", "ObjectName", PageBreakAbove -> True, 
         CellTags -> "Abbreviation"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Abbreviation"], 
           Cell["Abbreviation is a function used by OneLoop and PaVeReduce \
for generating smaller files when saving results to the hard disk. The \
convention is that a definition like GP = GluonPropagator should be \
accompanied by the definition Abbreviation[GluonPropagator] = HoldForm[GP].", 
            "Text", CellTags -> "Abbreviation"], 
           Cell[TextData[{"See also:  ", 
              ButtonBox["$Abbreviations", 
                RuleDelayed[ButtonData, "$Abbreviations"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "$Abbreviations"]], ", ", 
              ButtonBox["OneLoop", RuleDelayed[ButtonData, "OneLoop"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "OneLoop"]]\
, ", ", 
              ButtonBox["PaVeReduce", RuleDelayed[ButtonData, "PaVeReduce"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PaVeReduce"]], ", ", 
              ButtonBox["WriteOut", RuleDelayed[ButtonData, "WriteOut"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "WriteOut"]], ", ", 
              ButtonBox["WriteOutPaVe", 
                RuleDelayed[ButtonData, "WriteOutPaVe"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "WriteOutPaVe"]], ", ", 
              ButtonBox["GluonPropagator", 
                RuleDelayed[ButtonData, "GluonPropagator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "GluonPropagator"]], ", ", 
              ButtonBox["GluonVertex", RuleDelayed[ButtonData, 
                 "GluonVertex"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "GluonVertex"]], ", ", 
              ButtonBox["QuarkPropagator", 
                RuleDelayed[ButtonData, "QuarkPropagator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "QuarkPropagator"]], "."}], "Text", 
            CellTags -> "Abbreviation"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Abbreviation"], Cell[CellGroupData[{Cell[BoxData[
                \(GP[\(p,\ \({\[Mu],\ a}\),\ \({\[Nu],\ b}\)\)]\)], "Input", 
               CellTags -> "Abbreviation"], Cell[BoxData[
                \(TraditionalForm\`\(\[CapitalPi]\_\(ab\)\%\(\[Mu]\[Nu]\)(p)
                    \)\)], "Output", CellTags -> "Abbreviation"]}, Open]]}, 
          Open]], Cell["Amplitude", "ObjectName", CellTags -> "Amplitude"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Amplitude"], Cell["Amplitude is a database of \
Feynman amplitudes. Amplitude[\"name\"] returns the amplitude corresponding \
to the string \"name\". A list of all defined names is obtained with \
Amplitude[]. New amplitudes can be added to the file \"Amplitude.m\". It is \
strongly recommended to use names that reflect the process. The option Gauge \
\[Rule] 1 means `t Hooft Feynman gauge; Polarization \[Rule] 0 gives \
unpolarized OPE-type amplitudes, Polarization \[Rule] 1 the polarized ones.", 
            "Text", CellTags -> "Amplitude"], Cell[CellGroupData[
             {Cell[BoxData[\(Options[Amplitude]\)], "Input", CellTags -> 
                "Amplitude"], Cell[BoxData[
                \(TraditionalForm\`\({\(Dimension \[Rule] D\), 
                      \(Gauge \[Rule] 1\), \(QuarkMass \[Rule] 0\), 
                      \(Polarization \[Rule] 1\)}\)\)], "Output", CellTags -> 
                "Amplitude"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynAmp", RuleDelayed[ButtonData, "FeynAmp"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FeynAmp"]]\
, "."}], "Text", CellTags -> "Amplitude"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Amplitude"], Cell[CellGroupData[{Cell[BoxData[
                \(\(Amplitude[]\)//Length\)], "Input", CellTags -> 
                "Amplitude"], Cell[BoxData[\(TraditionalForm\`207\)], 
               "Output", CellTags -> "Amplitude"]}, Open]], 
           Cell["This is the amplitude of a gluon self-energy diagram:", 
            "Text", CellTags -> "Amplitude"], Cell[CellGroupData[
             {Cell[BoxData[\(Amplitude["se1g1"]\)], "Input", CellTags -> 
                "Amplitude"], Cell[BoxData[FormBox[RowBox[{RowBox[{
                     \(\[CapitalPi]\_\(cd\)\%\(\[Alpha]\[Rho]\)\), "(", 
                     FormBox[\(p - q\), "TraditionalForm"], ")"}], " ", 
                   \(\[CapitalPi]\_\(ef\)\%\(\[Beta]\[Sigma]\)(q)\), " ", 
                   RowBox[{SuperscriptBox["V", RowBox[{FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]}]], "(", 
                     RowBox[{FormBox[\(-p\), "TraditionalForm"], \(,\ \), 
                       FormBox[\(p - q\), "TraditionalForm"], \(,\ \), 
                       FormBox["q", "TraditionalForm"]}], ")"}], " ", 
                   RowBox[{SuperscriptBox["V", RowBox[{FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Beta]", 
                          "TraditionalForm"], "TraditionalForm"]}]], "(", 
                     RowBox[{FormBox["p", "TraditionalForm"], \(,\ \), 
                       FormBox[\(q - p\), "TraditionalForm"], \(,\ \), 
                       FormBox[\(-q\), "TraditionalForm"]}], ")"}], " ", 
                   SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["e", "TraditionalForm"], 
                       "TraditionalForm"]}]], " ", SubscriptBox["f", 
                    RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["d", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["f", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "Amplitude"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Explicit[%]\)], "Input", 
               CellTags -> "Amplitude"], Cell[BoxData[FormBox[RowBox[
                  {"-", RowBox[{\(1\/\(\((p - q)\)\^2\ q\^2\)\), RowBox[
                      {"(", RowBox[{\(g\_s\%2\), " ", 
                         \(g\^\(\[Alpha]\[Rho]\)\), " ", 
                         \(g\^\(\[Beta]\[Sigma]\)\), " ", RowBox[{"(", 
                          RowBox[{RowBox[{RowBox[{"(", RowBox[{RowBox[{"-", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", SuperscriptBox[FormBox[
                          "q", "TraditionalForm"], FormBox[FormBox[
                          "\[Alpha]", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}], " ", 
                          \(g\^\(\[Beta]\[Mu]\)\)}], "+", RowBox[{
                          \(g\^\(\[Alpha]\[Mu]\)\), " ", RowBox[{"(", RowBox[
                          {RowBox[{"2", " ", SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox["\[Beta]", 
                          "TraditionalForm"], "TraditionalForm"]]}], "-", 
                          SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Beta]", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}], "+", RowBox[{
                          \(g\^\(\[Alpha]\[Beta]\)\), " ", RowBox[{"(", 
                          RowBox[{RowBox[{"2", " ", SuperscriptBox[FormBox[
                          "q", "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]]}], "-", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}]}], ")"}], " ", 
                         RowBox[{"(", RowBox[{RowBox[{RowBox[{"(", RowBox[
                          {SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], "-", RowBox[{"2", " ", 
                          SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], ")"}], " ", 
                          \(g\^\(\[Rho]\[Sigma]\)\)}], "+", RowBox[{
                          \(g\^\(\[Nu]\[Sigma]\)\), " ", RowBox[{"(", RowBox[
                          {SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"]], "+", SuperscriptBox[FormBox[
                          "q", "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}]}], 
                          "+", RowBox[{\(g\^\(\[Nu]\[Rho]\)\), " ", RowBox[
                          {"(", RowBox[{SuperscriptBox[FormBox["q", 
                          "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]], "-", 
                          RowBox[{"2", " ", SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]]}]}], 
                          ")"}]}]}], ")"}], " ", SubscriptBox["\[Delta]", 
                          RowBox[{FormBox[FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                         SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "e", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["f", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["e", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["f", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}]}]}], 
                 TraditionalForm]], "Output", CellTags -> "Amplitude"]}, 
             Open]], Cell[TextData[
             {"This is the amplitude for graph 6.2 from the paper Z.Phys C ", 
              StyleBox["70:", Rule[FontWeight, "Bold"]], "637-654, 1996:"}], 
            "Text", CellTags -> "Amplitude"], Cell[CellGroupData[
             {Cell[BoxData[
                \(FeynAmp[\(q1, q2, \(EpsEvaluate[
                       \(Trick[\(Explicit[\(Amplitude["gg2"]\)]\)]\)]\)\)]\)]\
, "Input", CellTags -> "Amplitude"], Cell[BoxData[FormBox[RowBox[
                  {"\[Integral]", RowBox[{StyleBox[RowBox[{
                        \(\[DifferentialD]\^D\), FormBox[
                         \(\(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"]}], ZeroWidthTimes -> True], 
                     "\[Integral]", RowBox[{\(\[DifferentialD]\^D\), FormBox[
                        \(\(\*TagBox[StyleBox["\"q\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_2\), 
                        "TraditionalForm"]}]}], "(", FormBox[RowBox[
                     {RowBox[{"(", RowBox[{"2", " ", "\[ImaginaryI]", " ", 
                          \(g\_s\%4\), " ", SuperscriptBox["\[Epsilon]", 
                          RowBox[{FormBox[FormBox[\(\[Lambda]\_1\), 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox[\(\[Lambda]\_5\), "TraditionalForm"], 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"]}]], " ", RowBox[{"(", RowBox[
                          {RowBox[{RowBox[{"(", RowBox[{RowBox[{"2", " ", 
                          SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "1", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}], 
                          " ", \(g\^\(\[Lambda]\_7 \[Lambda]\_10\)\)}], "+", 
                          RowBox[{\(g\^\(\[Nu] \[Lambda]\_10\)\), " ", RowBox[
                          {"(", RowBox[{RowBox[{"2", " ", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], FormBox[FormBox[
                          \(\[Lambda]\_7\), "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "1", FormBox[
                          FormBox[\(\[Lambda]\_7\), "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}], "+", RowBox[{
                          \(g\^\(\[Nu] \[Lambda]\_7\)\), " ", RowBox[{"(", 
                          RowBox[{RowBox[{"-", SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox[
                          \(\[Lambda]\_10\), "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "1", FormBox[
                          FormBox[\(\[Lambda]\_10\), "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}]}], ")"}], " ", 
                          RowBox[{"(", RowBox[{RowBox[{RowBox[{"(", RowBox[
                          {SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "-", RowBox[{"2", " ", 
                          SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "2", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], ")"}], " ", 
                          \(g\^\(\[Lambda]\_1 \[Lambda]\_11\)\)}], "+", 
                          RowBox[{\(g\^\(\[Mu] \[Lambda]\_11\)\), " ", RowBox[
                          {"(", RowBox[{SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "2", FormBox[
                          FormBox[\(\[Lambda]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], "-", RowBox[{"2", " ", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox[\(\[Lambda]\_1\), 
                          "TraditionalForm"], "TraditionalForm"]]}]}], 
                          ")"}]}], "+", RowBox[{\(g\^\(\[Mu] \[Lambda]\_1\)\)
                          , " ", RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], FormBox[FormBox[
                          \(\[Lambda]\_11\), "TraditionalForm"], 
                          "TraditionalForm"]], "+", SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "2", FormBox[
                          FormBox[\(\[Lambda]\_11\), "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}]}], ")"}], " ", 
                          RowBox[{"(", RowBox[{RowBox[{RowBox[{"(", RowBox[
                          {RowBox[{"-", SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox[
                          \(\[Lambda]\_10\), "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "1", FormBox[
                          FormBox[\(\[Lambda]\_10\), "TraditionalForm"], 
                          "TraditionalForm"]], "+", RowBox[{"2", " ", 
                          SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "2", FormBox[
                          FormBox[\(\[Lambda]\_10\), "TraditionalForm"], 
                          "TraditionalForm"]]}]}], ")"}], " ", 
                          \(g\^\(\[Lambda]\_11 \[Lambda]\_12\)\)}], "+", 
                          RowBox[{\(g\^\(\[Lambda]\_10 \[Lambda]\_12\)\), 
                          " ", RowBox[{"(", RowBox[{RowBox[{"-", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox[\(\[Lambda]\_11\), 
                          "TraditionalForm"], "TraditionalForm"]]}], "+", 
                          RowBox[{"2", " ", SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "1", FormBox[
                          FormBox[\(\[Lambda]\_11\), "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "2", FormBox[
                          FormBox[\(\[Lambda]\_11\), "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}], "+", RowBox[{
                          \(g\^\(\[Lambda]\_10 \[Lambda]\_11\)\), " ", RowBox[
                          {"(", RowBox[{RowBox[{"2", " ", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], FormBox[FormBox[
                          \(\[Lambda]\_12\), "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "1", FormBox[
                          FormBox[\(\[Lambda]\_12\), "TraditionalForm"], 
                          "TraditionalForm"]], "-", SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "2", FormBox[
                          FormBox[\(\[Lambda]\_12\), "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}]}], ")"}], " ", 
                          RowBox[{"(", RowBox[{RowBox[{RowBox[{"(", RowBox[
                          {SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "2", FormBox[
                          FormBox[\(\[Lambda]\_5\), "TraditionalForm"], 
                          "TraditionalForm"]], "-", RowBox[{"2", " ", 
                          SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "1", FormBox[
                          FormBox[\(\[Lambda]\_5\), "TraditionalForm"], 
                          "TraditionalForm"]]}]}], ")"}], " ", 
                          \(g\^\(\[Lambda]\_7 \[Lambda]\_12\)\)}], "+", 
                          RowBox[{\(g\^\(\[Lambda]\_5 \[Lambda]\_12\)\), " ", 
                          RowBox[{"(", RowBox[{SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "1", FormBox[
                          FormBox[\(\[Lambda]\_7\), "TraditionalForm"], 
                          "TraditionalForm"]], "-", RowBox[{"2", " ", 
                          SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "2", FormBox[
                          FormBox[\(\[Lambda]\_7\), "TraditionalForm"], 
                          "TraditionalForm"]]}]}], ")"}]}], "+", RowBox[{
                          \(g\^\(\[Lambda]\_5 \[Lambda]\_7\)\), " ", RowBox[
                          {"(", RowBox[{SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "1", FormBox[
                          FormBox[\(\[Lambda]\_12\), "TraditionalForm"], 
                          "TraditionalForm"]], "+", SubsuperscriptBox[
                          TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], "2", FormBox[
                          FormBox[\(\[Lambda]\_12\), "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}]}], ")"}], " ", 
                          RowBox[{"(", RowBox[{"1", "-", FormBox[
                          \(\((\(-1\))\)\^m\), "TraditionalForm"]}], ")"}], 
                          " ", FormBox[SuperscriptBox[RowBox[{"(", RowBox[
                          {FormBox["\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"]}], ")"}], \(m - 1\)], 
                          "TraditionalForm"], " ", SubscriptBox["f", RowBox[
                          {FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox[\("c"\_5\), 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox[\("c"\_11\), "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox[\("c"\_7\), 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox[\("c"\_10\), "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox[\("c"\_5\), 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox[\("c"\_7\), "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox[\("c"\_12\), 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                          SubscriptBox["f", RowBox[{FormBox[FormBox[
                          \("c"\_10\), "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox[\("c"\_11\), 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox[\("c"\_12\), "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], "/", 
                      \(\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1\%2 . 
                         \(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2\%2 . 
                         \(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2\%2 . 
                         \((\(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_2 - p)\)\^
                          2 . \((\(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_1 - 
                             \(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_2)\)\^2 . 
                         \((\(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_1 - p)\)\^
                          2\)}], "TraditionalForm"], ")"}], 
                 TraditionalForm]], "Output", CellTags -> "Amplitude"]}, 
             Open]]}, Open]], Cell["Amputate", "ObjectName", 
         CellTags -> "Amputate"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Amputate"], 
           Cell["Amputate[exp,q1,q2,...] amputates Eps and DiracGamma. \
Amputate[exp,q1,q2,Pair\[Rule]{p}] amputates also p.q1 and p.q2; \
Pair\[Rule]All amputates all except OPEDelta.", "Text", CellTags -> 
             "Amputate"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[Amputate]\)], "Input", CellTags -> "Amputate"], 
              Cell[BoxData[
                \(TraditionalForm\`\({\(Dimension \[Rule] D\), 
                      \(Pair \[Rule] \({}\)\), \(Unique \[Rule] True\)}\)\)], 
               "Output", CellTags -> "Amputate"]}, Open]], 
           Cell[TextData[{"See also:  ", 
              ButtonBox["DiracGamma", RuleDelayed[ButtonData, "DiracGamma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGamma"]], ", ", 
              ButtonBox["DiracMatrix", RuleDelayed[ButtonData, 
                 "DiracMatrix"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracMatrix"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DiracSlash", RuleDelayed[ButtonData, "DiracSlash"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSlash"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], "."}], "Text", 
            CellTags -> "Amputate"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Amputate"], Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracSlash[p]\) . \(DiracSlash[q]\)\)], "Input", 
               CellTags -> "Amputate"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                        "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                     RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "Amputate"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Amputate[\(%, q\)]\)], "Input", CellTags -> "Amputate"], 
              Cell[BoxData[FormBox[RowBox[{RowBox[{RowBox[{"(", RowBox[
                        {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                         "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                       ")"}], ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        \($AL$20 \[InvisibleApplication] \((1)\)\), 
                        "TraditionalForm"], "TraditionalForm"]]}], " ", 
                   SuperscriptBox[FormBox["q", "TraditionalForm"], FormBox[
                     FormBox[\($AL$20 \[InvisibleApplication] \((1)\)\), 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output", CellTags -> "Amputate"]}, 
             Open]]}, Open]], Cell["AnomalousDimension", "ObjectName", 
         CellTags -> "AnomalousDimension"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "AnomalousDimension"], Cell["AnomalousDimension[name] \
is a database of anomalous dimensions of twist 2 operators.", "Text", 
            CellTags -> "AnomalousDimension"], Cell[CellGroupData[
             {Cell[BoxData[\(Options[AnomalousDimension]\)], "Input", 
               CellTags -> "AnomalousDimension"], Cell[BoxData[
                \(TraditionalForm\`\({\(Polarization \[Rule] 1\), 
                      \(Simplify \[Rule] FullSimplify\)}\)\)], "Output", 
               CellTags -> "AnomalousDimension"]}, Open]], 
           Cell[TextData[{"See also: ", 
              ButtonBox["SplittingFunction", 
                RuleDelayed[ButtonData, "SplittingFunction"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SplittingFunction"]], ", ", 
              ButtonBox["SumS", RuleDelayed[ButtonData, "SumS"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "SumS"]], 
              ", ", 
              ButtonBox["SumT", RuleDelayed[ButtonData, "SumT"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "SumT"]], 
              "."}], "Text", CellTags -> "AnomalousDimension"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "AnomalousDimension"], Cell["Polarized case:", 
            "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(SetOptions[\ \(AnomalousDimension, 
                     \(Polarization \[Rule] 1\)\)]\)], "Input", CellTags -> 
                "AnomalousDimension"], Cell[BoxData[
                \(TraditionalForm\`\({\(Polarization \[Rule] 1\), 
                      \(Simplify \[Rule] FullSimplify\)}\)\)], "Output", 
               CellTags -> "AnomalousDimension"]}, Open]], 
           Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(NS, qq\ \)\%\(\((0)\)\ \)\)]], 
              "polarized:"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[\(AnomalousDimension[gnsqq0]\)], 
               "Input", CellTags -> "AnomalousDimension"], Cell[BoxData[
                FormBox[RowBox[{\(C\_F\), " ", RowBox[{"(", RowBox[
                      {RowBox[{"8", " ", RowBox[{\(S\_1\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], "+", 
                       \(4\/m\), "+", \(4\/\(m + 1\)\), "-", "6"}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "AnomalousDimension"]}, Open]], Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(S, qg\ \)\%\(\((0)\)\ \)\)]], 
              "polarized:"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[\(AnomalousDimension[gsqg0]\)], 
               "Input", CellTags -> "AnomalousDimension"], Cell[BoxData[
                \(TraditionalForm\`\(\((8\/m - 16\/\(m + 1\))\)\ T\_f\)\)], 
               "Output", CellTags -> "AnomalousDimension"]}, Open]], 
           Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(S, gq\ \)\%\(\((0)\)\ \)\)]], 
              "polarized:"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[\(AnomalousDimension[gsgq0]\)], 
               "Input", CellTags -> "AnomalousDimension"], Cell[BoxData[
                \(TraditionalForm\`\(C\_F\ \((4\/\(m + 1\) - 8\/m)\)\)\)], 
               "Output", CellTags -> "AnomalousDimension"]}, Open]], 
           Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(S, gg\ \)\%\(\((0)\)\ \)\)]], 
              "polarized:"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[\(AnomalousDimension[gsgg0]\)], 
               "Input", CellTags -> "AnomalousDimension"], Cell[BoxData[
                FormBox[RowBox[{\(\(8\ T\_f\)\/3\), "+", RowBox[{\(C\_A\), 
                     " ", RowBox[{"(", RowBox[{RowBox[{"8", " ", RowBox[{
                          \(S\_1\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "-", \(8\/m\), "+", 
                         \(16\/\(m + 1\)\), "-", \(22\/3\)}], ")"}]}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "AnomalousDimension"]}, Open]], Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(PS, qq\ \)\%\(\((0)\)\ \)\)]], 
              "polarized:"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[\(AnomalousDimension[gpsqq1]\)], 
               "Input", CellTags -> "AnomalousDimension"], Cell[BoxData[
                \(TraditionalForm\`\(16\ C\_F\ 
                     \((1\/\(m + 1\) + 3\/\((m + 1)\)\^2 + 2\/\((m + 1)\)\^3 
                        - 1\/m - 1\/m\^2 + 2\/m\^3)\)\ T\_f\)\)], "Output", 
               CellTags -> "AnomalousDimension"]}, Open]], 
           Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(NS, qq\ \)\%\(\((1)\)\ \)\)]], 
              "polarized:"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[\(AnomalousDimension[gnsqq1]\)], 
               "Input", CellTags -> "AnomalousDimension"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{RowBox[{"-", RowBox[{"(", RowBox[
                          {FractionBox[RowBox[{"16", " ", RowBox[{\(S\_1\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], \(m\^2\)], "+", FractionBox[RowBox[{"16", 
                          " ", RowBox[{\(S\_1\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(\((m + 1)\)\^2\)], 
                          "+", FractionBox[RowBox[{"16", " ", RowBox[{\(S\_2\)
                          , "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], "m"], "+", FractionBox[RowBox[{"16", " ", 
                          RowBox[{\(S\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(m + 1\)], "-", 
                          RowBox[{"24", " ", RowBox[{\(S\_2\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], "+", 
                          RowBox[{"32", " ", RowBox[{\(S\_12\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], "+", 
                          RowBox[{"32", " ", RowBox[{\(S\_21\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], "+", 
                          FractionBox[RowBox[{"32", " ", RowBox[{
                          \(\(S\&~\)\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "m"], "+", FractionBox[
                          RowBox[{"32", " ", RowBox[{\(\(S\&~\)\_2\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                          \(m + 1\)], "-", RowBox[{"32", " ", RowBox[{
                          \(\(S\&~\)\_3\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "+", RowBox[{"64", 
                          " ", RowBox[{\(\(S\&~\)\_12\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], "-", 
                          \(40\/m\), "+", \(40\/\(m + 1\)\), "+", 
                          \(16\/\((m + 1)\)\^2\), "+", \(8\/m\^3\), "+", 
                          \(40\/\((m + 1)\)\^3\), "+", "3"}], ")"}]}], " ", 
                     \(C\_F\%2\)}], "-", RowBox[{\(N\_f\), " ", RowBox[
                      {"(", RowBox[{RowBox[{\(80\/9\), " ", RowBox[{\(S\_1\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], "-", RowBox[{\(16\/3\), " ", RowBox[{
                          \(S\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "-", \(8\/\(9\ m\)\), 
                         "+", \(88\/\(9\ \((m + 1)\)\)\), "-", 
                         \(8\/\(3\ m\^2\)\), "-", \(8\/\(3\ \((m + 1)\)\^2\)\)
                         , "-", \(2\/3\)}], ")"}], " ", \(C\_F\)}], "-", 
                   RowBox[{\(C\_A\), " ", RowBox[{"(", RowBox[{RowBox[{
                          \(-\(536\/9\)\), " ", RowBox[{\(S\_1\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                         "+", RowBox[{\(88\/3\), " ", RowBox[{\(S\_2\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                         "-", RowBox[{"16", " ", RowBox[{\(S\_3\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                         "-", FractionBox[RowBox[{"16", " ", RowBox[{
                          \(\(S\&~\)\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "m"], "-", FractionBox[
                          RowBox[{"16", " ", RowBox[{\(\(S\&~\)\_2\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                          \(m + 1\)], "+", RowBox[{"16", " ", RowBox[{
                          \(\(S\&~\)\_3\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "-", RowBox[{"32", 
                          " ", RowBox[{\(\(S\&~\)\_12\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], "+", 
                         \(212\/\(9\ m\)\), "-", \(748\/\(9\ \((m + 1)\)\)\), 
                         "+", \(44\/\(3\ m\^2\)\), "-", 
                         \(4\/\(3\ \((m + 1)\)\^2\)\), "-", 
                         \(16\/\((m + 1)\)\^3\), "+", \(17\/3\)}], ")"}], 
                     " ", \(C\_F\)}]}], TraditionalForm]], "Output", 
               CellTags -> "AnomalousDimension"]}, Open]], 
           Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(S, qg\ \)\%\(\((1)\)\ \)\)]], 
              "polarized:"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[\(AnomalousDimension[gsqg1]\)], 
               "Input", CellTags -> "AnomalousDimension"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"8", " ", \(C\_F\), " ", \(T\_f\), 
                     " ", RowBox[{"(", RowBox[{FractionBox[RowBox[{"2", " ", 
                          RowBox[{\(S\_1\%2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "m"], "-", FractionBox[
                          RowBox[{"4", " ", RowBox[{\(S\_1\%2\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], \(m + 1\)], 
                         "-", FractionBox[RowBox[{"2", " ", RowBox[{\(S\_2\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], "m"], "+", FractionBox[RowBox[{"4", " ", 
                          RowBox[{\(S\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(m + 1\)], "+", 
                         \(14\/m\), "-", \(19\/\(m + 1\)\), "-", \(1\/m\^2\), 
                         "-", \(8\/\((m + 1)\)\^2\), "-", \(2\/m\^3\), "+", 
                         \(4\/\((m + 1)\)\^3\)}], ")"}]}], "+", RowBox[
                    {"16", " ", \(C\_A\), " ", \(T\_f\), " ", RowBox[
                      {"(", RowBox[{RowBox[{"-", FractionBox[RowBox[{
                          \(S\_1\%2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}], "m"]}], "+", FractionBox[
                          RowBox[{"2", " ", RowBox[{\(S\_1\%2\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], \(m + 1\)], 
                         "-", FractionBox[RowBox[{"2", " ", RowBox[{\(S\_1\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], \(m\^2\)], "+", FractionBox[RowBox[
                          {"4", " ", RowBox[{\(S\_1\), "(", FormBox[\(m - 1\)
                          , "TraditionalForm"], ")"}]}], \(\((m + 1)\)\^2\)], 
                         "-", FractionBox[RowBox[{\(S\_2\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}], "m"], "+", 
                         FractionBox[RowBox[{"2", " ", RowBox[{\(S\_2\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                          \(m + 1\)], "-", FractionBox[RowBox[{"2", " ", 
                          RowBox[{\(\(S\&~\)\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "m"], "+", FractionBox[
                          RowBox[{"4", " ", RowBox[{\(\(S\&~\)\_2\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                          \(m + 1\)], "-", \(4\/m\), "+", \(3\/\(m + 1\)\), 
                         "-", \(3\/m\^2\), "+", \(8\/\((m + 1)\)\^2\), "+", 
                         \(2\/m\^3\), "+", \(12\/\((m + 1)\)\^3\)}], 
                       ")"}]}]}], TraditionalForm]], "Output", CellTags -> 
                "AnomalousDimension"]}, Open]], Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(S, gq\ \)\%\(\((1)\)\ \)\)]], 
              "polarized:"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[\(AnomalousDimension[gsgq1]\)], 
               "Input", CellTags -> "AnomalousDimension"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"4", " ", RowBox[{"(", RowBox[
                        {FractionBox[RowBox[{"4", " ", RowBox[{\(S\_1\%2\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], "m"], "-", FractionBox[RowBox[{"2", " ", 
                          RowBox[{\(S\_1\%2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(m + 1\)], "-", 
                         FractionBox[RowBox[{"8", " ", RowBox[{\(S\_1\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                          "m"], "+", FractionBox[RowBox[{"2", " ", RowBox[{
                          \(S\_1\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(m + 1\)], "+", 
                         FractionBox[RowBox[{"8", " ", RowBox[{\(S\_1\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                          \(m\^2\)], "-", FractionBox[RowBox[{"4", " ", 
                          RowBox[{\(S\_1\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(\((m + 1)\)\^2\)], 
                         "+", FractionBox[RowBox[{"4", " ", RowBox[{\(S\_2\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], "m"], "-", FractionBox[RowBox[{"2", " ", 
                          RowBox[{\(S\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(m + 1\)], "+", 
                         \(15\/m\), "-", \(6\/\(m + 1\)\), "-", \(12\/m\^2\), 
                         "+", \(3\/\((m + 1)\)\^2\), "+", \(4\/m\^3\), "-", 
                         \(2\/\((m + 1)\)\^3\)}], ")"}], " ", \(C\_F\%2\)}], 
                   "+", RowBox[{"32", " ", \(T\_f\), " ", RowBox[{"(", 
                       RowBox[{RowBox[{"-", FractionBox[RowBox[{"2", " ", 
                          RowBox[{\(S\_1\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(3\ m\)]}], "+", 
                         FractionBox[RowBox[{\(S\_1\), "(", FormBox[\(m - 1\)
                          , "TraditionalForm"], ")"}], \(3\ \((m + 1)\)\)], 
                         "+", \(7\/\(9\ m\)\), "-", \(2\/\(9\ \((m + 1)\)\)\)
                         , "-", \(2\/\(3\ m\^2\)\), "+", 
                         \(1\/\(3\ \((m + 1)\)\^2\)\)}], ")"}], " ", \(C\_F\)}
                     ], "+", RowBox[{"8", " ", \(C\_A\), " ", RowBox[
                      {"(", RowBox[{RowBox[{"-", FractionBox[RowBox[{"2", 
                          " ", RowBox[{\(S\_1\%2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "m"]}], "+", 
                         FractionBox[RowBox[{\(S\_1\%2\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}], \(m + 1\)], 
                         "+", FractionBox[RowBox[{"16", " ", RowBox[{\(S\_1\)
                          , "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], \(3\ m\)], "-", FractionBox[RowBox[
                          {"5", " ", RowBox[{\(S\_1\), "(", FormBox[\(m - 1\)
                          , "TraditionalForm"], ")"}]}], \(3\ \((m + 1)\)\)], 
                         "+", FractionBox[RowBox[{"2", " ", RowBox[{\(S\_2\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], "m"], "-", FractionBox[RowBox[{\(S\_2\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], ")"}], 
                          \(m + 1\)], "+", FractionBox[RowBox[{"4", " ", 
                          RowBox[{\(\(S\&~\)\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], "m"], "-", FractionBox[
                          RowBox[{"2", " ", RowBox[{\(\(S\&~\)\_2\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                          \(m + 1\)], "-", \(56\/\(9\ m\)\), "-", 
                         \(20\/\(9\ \((m + 1)\)\)\), "+", \(28\/\(3\ m\^2\)\)
                         , "-", \(38\/\(3\ \((m + 1)\)\^2\)\), "-", 
                         \(4\/m\^3\), "-", \(6\/\((m + 1)\)\^3\)}], ")"}], 
                     " ", \(C\_F\)}]}], TraditionalForm]], "Output", 
               CellTags -> "AnomalousDimension"]}, Open]], 
           Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(S, gg\ \)\%\(\((1)\)\ \)\)]], 
              "polarized:"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[\(AnomalousDimension[gsgg1]\)], 
               "Input", CellTags -> "AnomalousDimension"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"4", " ", RowBox[{"(", RowBox[
                        {FractionBox[RowBox[{"8", " ", RowBox[{\(S\_1\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                          \(m\^2\)], "-", FractionBox[RowBox[{"16", " ", 
                          RowBox[{\(S\_1\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(\((m + 1)\)\^2\)], 
                         "+", RowBox[{\(134\/9\), " ", RowBox[{\(S\_1\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                         "+", FractionBox[RowBox[{"8", " ", RowBox[{\(S\_2\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], "m"], "-", FractionBox[RowBox[{"16", " ", 
                          RowBox[{\(S\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(m + 1\)], "+", 
                         RowBox[{"4", " ", RowBox[{\(S\_3\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], "-", 
                         RowBox[{"8", " ", RowBox[{\(S\_12\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], "-", 
                         RowBox[{"8", " ", RowBox[{\(S\_21\), "(", FormBox[
                          \(m - 1\), "TraditionalForm"], ")"}]}], "+", 
                         FractionBox[RowBox[{"8", " ", RowBox[{\(\(S\&~\)\_2\)
                          , "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], "m"], "-", FractionBox[RowBox[{"16", " ", 
                          RowBox[{\(\(S\&~\)\_2\), "(", FormBox[\(m - 1\), 
                          "TraditionalForm"], ")"}]}], \(m + 1\)], "+", 
                         RowBox[{"4", " ", RowBox[{\(\(S\&~\)\_3\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                         "-", RowBox[{"8", " ", RowBox[{\(\(S\&~\)\_12\), 
                          "(", FormBox[\(m - 1\), "TraditionalForm"], 
                          ")"}]}], "-", \(107\/\(9\ m\)\), "+", 
                         \(241\/\(9\ \((m + 1)\)\)\), "+", \(58\/\(3\ m\^2\)\)
                         , "-", \(86\/\(3\ \((m + 1)\)\^2\)\), "-", 
                         \(8\/m\^3\), "-", \(48\/\((m + 1)\)\^3\), "-", 
                         \(16\/3\)}], ")"}], " ", \(C\_A\%2\)}], "+", 
                   RowBox[{"32", " ", \(T\_f\), " ", RowBox[{"(", RowBox[
                        {RowBox[{\(-\(5\/9\)\), " ", RowBox[{\(S\_1\), "(", 
                          FormBox[\(m - 1\), "TraditionalForm"], ")"}]}], 
                         "+", \(14\/\(9\ m\)\), "-", 
                         \(19\/\(9\ \((m + 1)\)\)\), "-", \(1\/\(3\ m\^2\)\), 
                         "-", \(1\/\(3\ \((m + 1)\)\^2\)\), "+", \(1\/3\)}], 
                       ")"}], " ", \(C\_A\)}], "+", 
                   \(8\ C\_F\ \((\(-\(10\/\(m + 1\)\)\) + 2\/\((m + 1)\)\^2 +
                          4\/\((m + 1)\)\^3 + 1 + 10\/m - 10\/m\^2 + 4\/m\^3)
                   \)\ T\_f\)}], TraditionalForm]], "Output", CellTags -> 
                "AnomalousDimension"]}, Open]], Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(S, gg\ \)\%\(\((1)\)\ \)\)]], 
              "polarized (different representation):"}], "Text", 
            CellTags -> "AnomalousDimension"], Cell[CellGroupData[
             {Cell[BoxData[\(AnomalousDimension[GSGG1]\)], "Input", 
               CellTags -> "AnomalousDimension"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{"4", " ", RowBox[{"(", RowBox[{
                         \(-\(\(\(m\ \((\(m\ \(
                                        (\(m\ 
                                           \((
                                           \(m\ 
                                           \((\(48\ m\ \((m + 3)\)\) + 469)\)
                         \) + 698)\)\) + 7)\)\) + 258)\)\) + 144\)\/
                              \(9\ m\^3\ \((m + 1)\)\^3\)\)\), "+", 
                         FractionBox[RowBox[{"8", " ", RowBox[{\(S\_2\%'\), 
                          "\[NoBreak]", "(", "\[NoBreak]", FormBox[\(m\/2\), 
                          "TraditionalForm"], "\[NoBreak]", ")"}]}], 
                          \(m\ \((m + 1)\)\)], "-", RowBox[{\(S\_3\%'\), 
                          "\[NoBreak]", "(", "\[NoBreak]", FormBox[\(m\/2\), 
                          "TraditionalForm"], "\[NoBreak]", ")"}], "+", 
                         FractionBox[RowBox[{"2", " ", 
                          \((\(m\ \((\(67\ m\ \((m + 1)\)\^2\) + 144)\)\) + 
                              72)\), " ", RowBox[{\(S\_1\), "(", FormBox["m", 
                          "TraditionalForm"], ")"}]}], 
                          \(9\ m\^2\ \((m + 1)\)\^2\)], "-", RowBox[{"4", 
                          " ", RowBox[{\(S\_2\%'\), "\[NoBreak]", "(", 
                          "\[NoBreak]", FormBox[\(m\/2\), "TraditionalForm"], 
                          "\[NoBreak]", ")"}], " ", RowBox[{\(S\_1\), "(", 
                          FormBox["m", "TraditionalForm"], ")"}]}], "+", 
                         RowBox[{"8", " ", RowBox[{\(S\&~\), "(", FormBox[
                          "m", "TraditionalForm"], ")"}]}]}], ")"}], " ", 
                     \(C\_A\%2\)}], "+", RowBox[{"32", " ", \(T\_f\), " ", 
                     RowBox[{"(", RowBox[{
                         \(\(\(m\ \((m + 1)\)\ 
                                \((\(3\ m\ \((m + 1)\)\) + 13)\)\) - 3\)\/
                            \(9\ m\^2\ \((m + 1)\)\^2\)\), "-", FractionBox[
                          RowBox[{"5", " ", RowBox[{\(S\_1\), "(", FormBox[
                          "m", "TraditionalForm"], ")"}]}], "9"]}], ")"}], 
                     " ", \(C\_A\)}], "+", 
                   \(\(8\ C\_F\ \((\(m\ \((
                               \(m\ \((\(m\ 
                                       \((\(m\ \((\(m\ \((m + 3)\)\) + 5)\)\)
                                        + 1)\)\) - 8)\)\) + 2)\)\) + 4)\)\ 
                        T\_f\)\/\(m\^3\ \((m + 1)\)\^3\)\)}], 
                 TraditionalForm]], "Output", CellTags -> 
                "AnomalousDimension"]}, Open]], 
           Cell[TextData[{"Check that all odd moments give the same for the \
two representations of ", Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(S, gg\ \)\%\(\((1)\)\ \)\)]], 
              ":"}], "Text", CellTags -> "AnomalousDimension"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Table[\(\(\(% - %%\)/.\(OPEm \[Rule] ij\)\), 
                     \({ij, 1, 17, 2}\)\)]\)], "Input", CellTags -> 
                "AnomalousDimension"], Cell[BoxData[
                \(TraditionalForm\`\({0, 0, 0, 0, 0, 0, 0, 0, 0}\)\)], 
               "Output", CellTags -> "AnomalousDimension"]}, Open]]}, Open]], 
        Cell["AntiCommutator", "ObjectName", CellTags -> "AntiCommutator"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "AntiCommutator"], Cell["AntiCommutator[x, y] = c \
defines the anti-commutator of the non commuting objects x and y.", "Text", 
            CellTags -> "AntiCommutator"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Commutator", RuleDelayed[ButtonData, "Commutator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Commutator"]], ", ", 
              ButtonBox["CommutatorExplicit", 
                RuleDelayed[ButtonData, "CommutatorExplicit"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "CommutatorExplicit"]], ", ", 
              ButtonBox["DeclareNonCommutative", 
                RuleDelayed[ButtonData, "DeclareNonCommutative"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DeclareNonCommutative"]], ", ", 
              ButtonBox["DotSimplify", RuleDelayed[ButtonData, 
                 "DotSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DotSimplify"]], "."}], "Text", 
            CellTags -> "AntiCommutator"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "AntiCommutator"], Cell[TextData[{"This declares ", 
              StyleBox["a", Rule[FontFamily, "Courier"]], " and ", 
              StyleBox["b", Rule[FontFamily, "Courier"]], 
              " as noncommutative variables."}], "Text", CellTags -> 
             "AntiCommutator"], Cell[BoxData[
             \(DeclareNonCommutative[\(a, b\)]\)], "Input", 
            CellTags -> "AntiCommutator"], Cell[CellGroupData[{Cell[BoxData[
                \(AntiCommutator[\(a, b\)]\)], "Input", CellTags -> 
                "AntiCommutator"], Cell[BoxData[
                \(TraditionalForm\`\({a, \[MediumSpace]b}\)\)], "Output", 
               CellTags -> "AntiCommutator"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(CommutatorExplicit[%]\)], 
               "Input", CellTags -> "AntiCommutator"], Cell[BoxData[
                \(TraditionalForm\`\(\(a . b\) + \(b . a\)\)\)], "Output", 
               CellTags -> "AntiCommutator"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(CommutatorExplicit[\(AntiCommutator[
                     \(\(a + b\), \(a - \(2b\)\ \)\)]\)]\)], "Input", 
               CellTags -> "AntiCommutator"], Cell[BoxData[
                \(TraditionalForm\`\(\(\((a - \(2\ b\))\) . \((a + b)\)\) + 
                     \(\((a + b)\) . \((a - \(2\ b\))\)\)\)\)], "Output", 
               CellTags -> "AntiCommutator"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DotSimplify[\(AntiCommutator[
                     \(\(a + b\), \(a - \(2b\)\ \)\)]\)]\)], "Input", 
               CellTags -> "AntiCommutator"], Cell[BoxData[
                \(TraditionalForm\`\(\(2\ \(a . a\)\) - \(a . b\) - \(b . a\)
                      - \(4\ \(b . b\)\)\)\)], "Output", CellTags -> 
                "AntiCommutator"]}, Open]], Cell[BoxData[
             \(DeclareNonCommutative[\(c, d, \(c\&~\), \(d\&~\)\)]\)], 
            "Input", CellTags -> "AntiCommutator"], 
           Cell[
            "Defining {c,d} = z results in replacements of c.d by z-d.c.", 
            "Text", CellTags -> "AntiCommutator"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(AntiCommutator[\(c, d\)]\)\ =\ z\)], "Input", CellTags -> 
                "AntiCommutator"], Cell[BoxData[\(TraditionalForm\`z\)], 
               "Output", CellTags -> "AntiCommutator"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DotSimplify[\ \(d\ .\ c\ .\ d\)\ ]\)], "Input", CellTags -> 
                "AntiCommutator"], Cell[BoxData[
                \(TraditionalForm\`\(\(d\ z\) - \(d . d . c\)\)\)], "Output", 
               CellTags -> "AntiCommutator"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(AntiCommutator[\(\(d\&~\), \(c\&~\)\)]\)\ =\ \(z\&~\)\)], 
               "Input", CellTags -> "AntiCommutator"], Cell[BoxData[
                \(TraditionalForm\`z\&~\)], "Output", CellTags -> 
                "AntiCommutator"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DotSimplify[\ \(\(d\&~\)\ .\ \(c\&~\)\ .\ \(d\&~\)\)\ ]\)], 
               "Input", CellTags -> "AntiCommutator"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(d\&~\)\ \(z\&~\)\) - 
                     \(\(c\&~\) . \(d\&~\) . \(d\&~\)\)\)\)], "Output", 
               CellTags -> "AntiCommutator"]}, Open]], Cell[BoxData[
             \(UnDeclareNonCommutative[\(a, b, c, d, \(c\&~\), \(d\&~\)\)]\)]\
, "Input", CellTags -> "AntiCommutator"], Cell[BoxData[
             \(Unset[\(AntiCommutator[\(c, d\)]\)]\)], "Input", 
            CellTags -> "AntiCommutator"], Cell[BoxData[
             \(Unset[\(AntiCommutator[\(\(d\&~\), \(c\&~\)\)]\)]\)], "Input", 
            CellTags -> "AntiCommutator"]}, Open]], Cell["AntiQuarkField", 
         "ObjectName", CellTags -> "AntiQuarkField"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "AntiQuarkField"], Cell["AntiQuarkField is the name \
of a fermionic field. AntiQuarkField is just a name with no functional \
properties. Only typesetting rules are attached.", "Text", 
            CellTags -> "AntiQuarkField"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["QuantumField", 
                RuleDelayed[ButtonData, "QuantumField"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "QuantumField"]], ", ", 
              ButtonBox["QuarkField", RuleDelayed[ButtonData, "QuarkField"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "QuarkField"]], "."}], "Text", 
            CellTags -> "AntiQuarkField"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "AntiQuarkField"], Cell[CellGroupData[
             {Cell[BoxData["AntiQuarkField"], "Input", CellTags -> 
                "AntiQuarkField"], Cell[BoxData[\(TraditionalForm\`\[Psi]\&_\)
                ], "Output", CellTags -> "AntiQuarkField"]}, Open]]}, Open]], 
        Cell["AntiSymmetrize", "ObjectName", CellTags -> "AntiSymmetrize"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "AntiSymmetrize"], Cell["AntiSymmetrize[expr, {a1, \
a2, ...}] antisymmetrizes expr with respect to the variables a1,a2, ... ", 
            "Text", CellTags -> "AntiSymmetrize"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["Symmetrize", RuleDelayed[ButtonData, "Symmetrize"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Symmetrize"]], "."}], "Text", 
            CellTags -> "AntiSymmetrize"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "AntiSymmetrize"], Cell[CellGroupData[{Cell[BoxData[
                \(AntiSymmetrize[\(\(f[\(a, b\)]\), \({a, b}\)\)]\)], 
               "Input", CellTags -> "AntiSymmetrize"], Cell[BoxData[
                \(TraditionalForm\`\(1\/2\ 
                     \((\(f(\(a, b\))\) - \(f(\(b, a\))\))\)\)\)], "Output", 
               CellTags -> "AntiSymmetrize"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(AntiSymmetrize[\(\(f[\(x, y, z\)]\), \({x, y, z}\)\)]\)], 
               "Input", CellTags -> "AntiSymmetrize"], Cell[BoxData[
                \(TraditionalForm\`\(1\/6\ 
                     \((\(f(\(x, y, z\))\) - \(f(\(x, z, y\))\) - 
                        \(f(\(y, x, z\))\) + \(f(\(y, z, x\))\) + 
                        \(f(\(z, x, y\))\) - \(f(\(z, y, x\))\))\)\)\)], 
               "Output", CellTags -> "AntiSymmetrize"]}, Open]]}, Open]], 
        Cell["Anti5", "ObjectName", CellTags -> "Anti5"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Anti5"], Cell[TextData[
             {"Anti5[exp] anticommutes all ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5\)\)]], 
              "in exp to the right. Anti5[exp, n] anticommutes all ", 
              Cell[BoxData[\(TraditionalForm\`\(\[Gamma]\^\(5\ \)\)\)]], 
              "n times to the right. Anti5[exp, -n] anticommutes all ", 
              Cell[BoxData[\(TraditionalForm\`\(\[Gamma]\^5\)\)]], 
              " n times to the left."}], "Text", CellTags -> "Anti5"], 
           Cell[TextData[{"The naive ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5\)\)]], "scheme is used."}], 
            "Text", CellTags -> "Anti5"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracOrder", RuleDelayed[ButtonData, "DiracOrder"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracOrder"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], "."}], "Text", 
            CellTags -> "Anti5"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Anti5"], Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracMatrix[\(5, \[Mu]\)]\)\ \)], "Input", CellTags -> 
                "Anti5"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5 \[Gamma]\^\[Mu]\)\)], 
               "Output", CellTags -> "Anti5"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Anti5[%]\)], "Input", 
               CellTags -> "Anti5"], Cell[BoxData[FormBox[RowBox[
                  {"-", RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     ".", \(\[Gamma]\^5\)}]}], TraditionalForm]], "Output", 
               CellTags -> "Anti5"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Anti5[\(%, \(-1\)\)]\)], "Input", CellTags -> 
                "Anti5"], Cell[BoxData[FormBox[RowBox[{\(\[Gamma]\^5\), ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output", CellTags -> "Anti5"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DiracMatrix[\(5, \[Alpha], \[Beta], \[Gamma], \[Delta]\)]\)]\
, "Input", CellTags -> "Anti5"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5 \[Gamma]\^\[Alpha] 
                     \[Gamma]\^\[Beta] \[Gamma]\^\[Gamma] \[Gamma]\^\[Delta]\
\)\)], "Output", CellTags -> "Anti5"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Anti5[\(%, 2\)]\)], "Input", CellTags -> 
                "Anti5"], Cell[BoxData[FormBox[RowBox[{SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Alpha]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Beta]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(\[Gamma]\^5\), ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Gamma]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Delta]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "Anti5"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Anti5[\(%%, Infinity\)]\)], "Input", CellTags -> 
                "Anti5"], Cell[BoxData[FormBox[RowBox[{SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Alpha]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Beta]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Gamma]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Delta]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(\[Gamma]\^5\)}], TraditionalForm]], "Output", 
               CellTags -> "Anti5"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Anti5[\(%, \(-Infinity\)\)]\)], "Input", 
               CellTags -> "Anti5"], Cell[BoxData[FormBox[RowBox[{
                   \(\[Gamma]\^5\), ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Beta]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Gamma]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Delta]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "Anti5"]}, Open]], 
           Cell[TextData[{"In the naive ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5\)\)]], 
              "- scheme D-dimensional ", Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\)]], 
              "-matrices anticommute with ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5\)\)]], "."}], "Text", 
            CellTags -> "Anti5"], Cell[CellGroupData[{Cell[BoxData[
                \(GAD[\(5, \[Mu]\)]\)], "Input", CellTags -> "Anti5"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5 . \[Gamma]\^\[Mu]\)\)], 
               "Output", CellTags -> "Anti5"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Anti5[%]\)], "Input", 
               CellTags -> "Anti5"], Cell[BoxData[FormBox[RowBox[
                  {"-", RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     ".", \(\[Gamma]\^5\)}]}], TraditionalForm]], "Output", 
               CellTags -> "Anti5"]}, Open]]}, Open]], 
        Cell["Apart1", "ObjectName", CellTags -> "Apart1"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Apart1"], Cell[TextData[{"Apart1[expr, x] is \
equivalent to Apart[expr, x], but it fixes a ", 
              StyleBox["Mathematica", Rule[FontSlant, "Italic"]], 
              " bug relevant when expr contains complex numbers."}], "Text", 
            CellTags -> "Apart1"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Apart3", RuleDelayed[ButtonData, "Apart3"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Apart3"]], 
              "."}], "Text", CellTags -> "Apart1"]}, Open]], 
        Cell["Apart2", "ObjectName", CellTags -> "Apart2"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Apart2"], Cell[
            "Apart2[expr] partial fractions FeynAmpDenominators (and FAD's)."\
, "Text", CellTags -> "Apart2"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[FAD]\)], "Input", CellTags -> "Apart2"], 
              Cell[BoxData[\(TraditionalForm\`\({Dimension \[Rule] D}\)\)], 
               "Output", CellTags -> "Apart2"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FAD", RuleDelayed[ButtonData, "FAD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FAD"]], 
              ", ", 
              ButtonBox["FeynAmpDenominator", 
                RuleDelayed[ButtonData, "FeynAmpDenominator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynAmpDenominator"]], "."}], "Text", 
            CellTags -> "Apart2"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Apart2"], Cell[CellGroupData[{Cell[BoxData[
                \(FAD[\(\({q, m}\), \({q, M}\), \(q - p\)\)]\)], "Input", 
               CellTags -> "Apart2"], Cell[BoxData[
                \(TraditionalForm\`\(1\/\(
                      \((\*InterpretationBox[\(
                            "["\[InvisibleSpace] \((q - p)\)\^2 
                             \[InvisibleSpace]"]"\), 
                           SequenceForm["[", 
                            Power[Plus[Times[-1, p], q], 2], "]"], 
                           Rule[Editable, False]])\)\ 
                       \((\*InterpretationBox[\(
                            "["\[InvisibleSpace] q\^2 \[InvisibleSpace]"-"
                             \[InvisibleSpace] m\^2 \[InvisibleSpace]"]"\), 
                           SequenceForm["[", Power[q, 2], "-", Power[m, 2], 
                            "]"], Rule[Editable, False]])\)\ 
                       \((\*InterpretationBox[\(
                            "["\[InvisibleSpace] q\^2 \[InvisibleSpace]"-"
                             \[InvisibleSpace] M\^2 \[InvisibleSpace]"]"\), 
                           SequenceForm["[", Power[q, 2], "-", Power[M, 2], 
                            "]"], Rule[Editable, False]])\)\)\)\)], "Output", 
               CellTags -> "Apart2"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Apart2[%]\)], "Input", CellTags -> "Apart2"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\(1\/
                        \(\((q\^2 - m\^2)\) . \((q - p)\)\^2\) - 
                       1\/\(\((q\^2 - M\^2)\) . \((q - p)\)\^2\)\)\/
                     \(m\^2 - M\^2\)\)\)], "Output", CellTags -> "Apart2"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(FCE[%]\)]\)], "Input", CellTags -> 
                "Apart2"], Cell[BoxData[
                \(\(\(FAD[\(\({q, m}\), \(\(-p\) + q\)\)]\) - 
                     \(FAD[\(\({q, M}\), \(\(-p\) + q\)\)]\)\)\/
                   \(m\^2 - M\^2\)\)], "Output", CellTags -> "Apart2"]}, 
             Open]]}, Open]], Cell["Apart3", "ObjectName", 
         CellTags -> "Apart3"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Apart3"], 
           Cell["Apart3[expr, x] is equivalent to Map2[Factor2, \
Collect2[Apart1[expr,x],x]].", "Text", CellTags -> "Apart3"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Apart1", RuleDelayed[ButtonData, "Apart1"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Apart1"]], 
              "."}], "Text", CellTags -> "Apart3"]}, Open]], 
        Cell["A0", "ObjectName", PageBreakAbove -> True, CellTags -> "A0"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "A0"], Cell[TextData[{Cell[BoxData[
                \(TraditionalForm\`\(A0[\(m\^2\)]\)\)]], 
              "is the Passarino-Veltman one-point integral ", Cell[BoxData[
                \(TraditionalForm\`\(A\_0 .\)\)]]}], "Text", 
            CellTags -> "A0"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[\ A0]\)], "Input", CellTags -> "A0"], Cell[BoxData[
                \(TraditionalForm\`\({A0ToB0 \[Rule] False}\)\)], "Output", 
               CellTags -> "A0"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              ", ", 
              ButtonBox["C0", RuleDelayed[ButtonData, "C0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "C0"]], 
              ", ", 
              ButtonBox["D0", RuleDelayed[ButtonData, "D0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "D0"]], 
              ", ", 
              ButtonBox["PaVe", RuleDelayed[ButtonData, "PaVe"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "PaVe"]], 
              "."}], "Text", CellTags -> "A0"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "A0"], Cell[TextData[{"By default ", Cell[BoxData[
                \(TraditionalForm\`A\_0\)]], 
              " is not expressed in terms of ", Cell[BoxData[
                \(TraditionalForm\`B\_0\)]], "."}], "Text", 
            CellTags -> "A0"], Cell[CellGroupData[{Cell[BoxData[
                \(A0[\(m\^2\)]\)], "Input", CellTags -> "A0"], 
              Cell[BoxData[FormBox[RowBox[{FormBox[\("A"\_"0"\), 
                    "TraditionalForm"], "(", FormBox[\(m\^2\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "A0"]}, Open]], Cell[BoxData[
             \(\(SetOptions[\(A0, \(A0ToB0 \[Rule] True\)\)]\) ;\)], "Input", 
            CellTags -> "A0"], Cell[CellGroupData[{Cell[BoxData[
                \(A0[\(m\^2\)]\)], "Input", CellTags -> "A0"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(B\_0 (0, m\^2, m\^2)\)\ m\^2\) + 
                     m\^2\)\)], "Output", CellTags -> "A0"]}, Open]], 
           Cell[BoxData[\(\(SetOptions[\(A0, \(A0ToB0 \[Rule] False\)\)]\) ;\)
             ], "Input", CellTags -> "A0"], Cell[TextData[
             {"According to the rules of dimensional regularization ", 
              Cell[BoxData[\(TraditionalForm\`\(A\_0(0)\)\)]], 
              " is set to 0."}], "Text", CellTags -> "A0"], 
           Cell[CellGroupData[{Cell[BoxData[\(A0[0]\)], "Input", CellTags -> 
                "A0"], Cell[BoxData[\(TraditionalForm\`0\)], "Output", 
               CellTags -> "A0"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(A0[\(SmallVariable[\(M^2\)]\)]\)], "Input", CellTags -> 
                "A0"], Cell[BoxData[\(TraditionalForm\`0\)], "Output", 
               CellTags -> "A0"]}, Open]]}, Open]], Cell["A0ToB0", 
         "ObjectName", PageBreakAbove -> True, CellTags -> "A0ToB0"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "A0ToB0"], Cell[TextData[
             {"A0ToB0 is an option for A0. If set to True, A0[", Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["m", 
                       Rule[FontSlant, "Plain"]]\^2\)\)]], 
              "] is expressed by (1 + B0[0, ", Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["m", 
                       Rule[FontSlant, "Plain"]]\^2\)\)]], ", ", Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["m", 
                       Rule[FontSlant, "Plain"]]\^2\)\)]], "]) ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["m", 
                       Rule[FontSlant, "Plain"]]\^2\)\)]], "."}], "Text", 
            CellTags -> "A0ToB0"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[\ A0]\)], "Input", CellTags -> "A0ToB0"], 
              Cell[BoxData[\(TraditionalForm\`\({A0ToB0 \[Rule] False}\)\)], 
               "Output", CellTags -> "A0ToB0"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["A0", RuleDelayed[ButtonData, "A0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "A0"]], 
              ", ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              ", ", 
              ButtonBox["C0", RuleDelayed[ButtonData, "C0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "C0"]], 
              ", ", 
              ButtonBox["D0", RuleDelayed[ButtonData, "D0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "D0"]], 
              ", ", 
              ButtonBox["PaVe", RuleDelayed[ButtonData, "PaVe"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "PaVe"]], 
              "."}], "Text", CellTags -> "A0ToB0"], Cell[BoxData[""], 
            "Input"]}, Open]], Cell["BackgroundGluonVertex", "ObjectName", 
         CellTags -> "BackgroundGluonVertex"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "BackgroundGluonVertex"], 
           Cell[TextData[{"BackgroundGluonVertex[{p,mu,a}, {q,nu,b}, \
{k,la,c}] or BackgroundGluonVertex[ p,mu,a , q,nu,b , k,la,c ] yields the \
3-gluon vertex in the background field gauge, where the first set of \
arguments corresponds to the external background field. \
BackgroundGluonVertex[{p,mu,a}, {q,nu,b}, {k,la,c}, {s,si,d}] or \
BackgroundGluonVertex[{mu,a}, {nu,b}, {la,c}, {", "si", ",d}] or \
BackgroundGluonVertex[p,mu,a , q,nu,b , k,la,c , s,si,d] or \
BackgroundGluonVertex[ mu,a , nu,b , la,c , si,d ] yields the 4-gluon vertex, \
with {p,mu,a} and {k,la,c} denoting the external background fields. The \
gauge, dimension and the name of the coupling constant are determined by the \
options Gauge, Dimension and CouplingConstant. The Feynman rules are taken \
from L.Abbot ", StyleBox["NPB ", Rule[FontWeight, "Bold"]], "185 (1981), \
189-203; except that all momenta are incoming. Note that Abbot's coupling \
constant convention is consistent with the default setting of GluonVertex."}]\
, "Text", CellTags -> "BackgroundGluonVertex"], Cell[CellGroupData[
             {Cell[BoxData[\(Options[BackgroundGluonVertex]\)], "Input", 
               CellTags -> "BackgroundGluonVertex"], Cell[BoxData[
                \(TraditionalForm\`\({\(Dimension \[Rule] D\), 
                      \(CouplingConstant \[Rule] g\_s\), \(Gauge \[Rule] 1\)}
                \)\)], "Output", CellTags -> "BackgroundGluonVertex"]}, 
             Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["GluonVertex", RuleDelayed[ButtonData, 
                 "GluonVertex"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "GluonVertex"]], "."}], "Text", 
            CellTags -> "BackgroundGluonVertex"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "BackgroundGluonVertex"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(BackgroundGluonVertex[\(
                    \({p, \[Mu], a}\), \({q, \[Nu], b}\), 
                     \({k, \[Lambda], c}\)\)]\)], "Input", CellTags -> 
                "BackgroundGluonVertex"], Cell[BoxData[FormBox[RowBox[{
                   \(g\_s\), " ", RowBox[{"(", RowBox[{RowBox[{SuperscriptBox[
                          RowBox[{"(", FormBox[RowBox[{"p", "-", FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", "q"}], "TraditionalForm"], 
                          ")"}], FormBox[FormBox["\[Lambda]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                         \(g\^\(\[Mu]\[Nu]\)\)}], "+", RowBox[{
                         \(g\^\(\[Lambda]\[Nu]\)\), " ", SuperscriptBox[
                          RowBox[{"(", FormBox[RowBox[{"q", "-", FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"]}], "TraditionalForm"], ")"}], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{
                         \(g\^\(\[Lambda]\[Mu]\)\), " ", SuperscriptBox[
                          RowBox[{"(", FormBox[RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", "p", "+", "q"}], 
                          "TraditionalForm"], ")"}], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]]}]}], ")"}], 
                   " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["c", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "BackgroundGluonVertex"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(BackgroundGluonVertex[\(
                    \({p, \[Mu], a}\), \({q, \[Nu], b}\), 
                     \({k, \[Lambda], c}\), \({s, \[Sigma], d}\)\)]\)], 
               "Input", CellTags -> "BackgroundGluonVertex"], 
              Cell[BoxData[FormBox[RowBox[{\(-\[ImaginaryI]\), " ", 
                   \(g\_s\%2\), " ", RowBox[{"(", RowBox[{RowBox[{
                         \((\(g\^\(\[Lambda]\[Sigma]\)\ g\^\(\[Mu]\[Nu]\)\) -
                              \(g\^\(\[Lambda]\[Nu]\)\ g\^\(\[Mu]\[Sigma]\)\)
                              - \(g\^\(\[Lambda]\[Mu]\)\ g\^\(\[Nu]\[Sigma]\)
                              \))\), " ", SubscriptBox["f", RowBox[
                          {FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["u6", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["u6", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], "+", RowBox[{
                         \((\(g\^\(\[Lambda]\[Sigma]\)\ g\^\(\[Mu]\[Nu]\)\) -
                              \(g\^\(\[Lambda]\[Nu]\)\ g\^\(\[Mu]\[Sigma]\)\)\
)\), " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["u6", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["u6", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], "+", RowBox[{
                         \((\(g\^\(\[Lambda]\[Sigma]\)\ g\^\(\[Mu]\[Nu]\)\) -
                              \(g\^\(\[Lambda]\[Nu]\)\ g\^\(\[Mu]\[Sigma]\)\)
                              + \(g\^\(\[Lambda]\[Mu]\)\ g\^\(\[Nu]\[Sigma]\)
                              \))\), " ", SubscriptBox["f", RowBox[
                          {FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["u6", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["u6", "TraditionalForm"], 
                          "TraditionalForm"]}]]}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "BackgroundGluonVertex"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(BackgroundGluonVertex[\(
                    \({p, \[Mu], a}\), \({q, \[Nu], b}\), 
                     \({k, \[Lambda], c}\), \(Gauge \[Rule] \[Alpha]\)\)]\)], 
               "Input", CellTags -> "BackgroundGluonVertex"], 
              Cell[BoxData[FormBox[RowBox[{\(g\_s\), " ", RowBox[{"(", 
                     RowBox[{RowBox[{SuperscriptBox[RowBox[{"(", FormBox[
                          RowBox[{"p", "-", FractionBox[FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "\[Alpha]"], "-", "q"}], 
                          "TraditionalForm"], ")"}], FormBox[FormBox[
                          "\[Lambda]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(\[Mu]\[Nu]\)\)}], 
                       "+", RowBox[{\(g\^\(\[Lambda]\[Nu]\)\), " ", 
                         SuperscriptBox[RowBox[{"(", FormBox[RowBox[{"q", 
                          "-", FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"]}], "TraditionalForm"], ")"}], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{
                         \(g\^\(\[Lambda]\[Mu]\)\), " ", SuperscriptBox[
                          RowBox[{"(", FormBox[RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", "p", "+", \(q\/\[Alpha]\)}]
                          , "TraditionalForm"], ")"}], FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], ")"}], " ", SubscriptBox[
                    "f", RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "BackgroundGluonVertex"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(BackgroundGluonVertex[\(
                    \({p, \[Mu], a}\), \({q, \[Nu], b}\), 
                     \({k, \[Lambda], c}\), \({s, \[Sigma], d}\), 
                     \(Gauge \[Rule] \[Alpha]\)\)]\)], "Input", CellTags -> 
                "BackgroundGluonVertex"], Cell[BoxData[FormBox[RowBox[{
                   \(-\[ImaginaryI]\), " ", \(g\_s\%2\), " ", RowBox[
                    {"(", RowBox[{RowBox[{
                         \((\(g\^\(\[Lambda]\[Sigma]\)\ g\^\(\[Mu]\[Nu]\)\) -
                              \(g\^\(\[Lambda]\[Nu]\)\ g\^\(\[Mu]\[Sigma]\)\)
                              \/\[Alpha] - \(g\^\(\[Lambda]\[Mu]\)\ 
                               g\^\(\[Nu]\[Sigma]\)\))\), " ", SubscriptBox[
                          "f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u7", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                         SubscriptBox["f", RowBox[{FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u7", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "+", 
                       RowBox[{
                         \((\(g\^\(\[Lambda]\[Sigma]\)\ g\^\(\[Mu]\[Nu]\)\) -
                              \(g\^\(\[Lambda]\[Nu]\)\ g\^\(\[Mu]\[Sigma]\)\)\
)\), " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["u7", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["u7", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], "+", RowBox[{
                         \((\(g\^\(\[Lambda]\[Sigma]\)\ g\^\(\[Mu]\[Nu]\)\)\/
                              \[Alpha] - \(g\^\(\[Lambda]\[Nu]\)\ 
                               g\^\(\[Mu]\[Sigma]\)\) + 
                             \(g\^\(\[Lambda]\[Mu]\)\ g\^\(\[Nu]\[Sigma]\)\))
                         \), " ", SubscriptBox["f", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u7", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                         SubscriptBox["f", RowBox[{FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u7", 
                          "TraditionalForm"], "TraditionalForm"]}]]}]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "BackgroundGluonVertex"]}, Open]]}, Open]], 
        Cell["Bracket", "ObjectName", CellTags -> "Bracket"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Bracket"], Cell["Bracket is an option of Convolute, \
specifying the variable with respect to which the result is collected.", 
            "Text", CellTags -> "Bracket"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Convolute", RuleDelayed[ButtonData, "Convolute"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Convolute"]], "."}], "Text", 
            CellTags -> "Bracket"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["BReduce", "ObjectName", PageBreakAbove -> True, 
         CellTags -> "BReduce"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "BReduce"], 
           Cell["BReduce is an option for B0, B00, B1, B11 determining \
whether reductions to A0 and B0 will be done. ", "Text", CellTags -> 
             "BReduce"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["A0", RuleDelayed[ButtonData, "A0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "A0"]], 
              ", ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              ", ", 
              ButtonBox["B00", RuleDelayed[ButtonData, "B00"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B00"]], 
              ", ", 
              ButtonBox["B1", RuleDelayed[ButtonData, "B1"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B1"]], 
              ", ", 
              ButtonBox["B11", RuleDelayed[ButtonData, "B11"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B11"]], 
              "."}], "Text", CellTags -> "BReduce"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "BReduce"], Cell[TextData[{"By default ", 
              Cell[BoxData[\(TraditionalForm\`B\_0\)]], 
              " is not expressed in terms of ", Cell[BoxData[
                \(TraditionalForm\`A\_0\)]], "."}], "Text", 
            CellTags -> "BReduce"], Cell[CellGroupData[{Cell[BoxData[
                \(B0[\(0, s, s\)]\)], "Input", CellTags -> "BReduce"], 
              Cell[BoxData[\(TraditionalForm\`\(B\_0 (0, s, s)\)\)], 
               "Output", CellTags -> "BReduce"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[B0]\)], "Input"], 
              Cell[BoxData[
                \(TraditionalForm\`\({\(BReduce \[Rule] False\), 
                      \(B0Unique \[Rule] True\), \(B0Real \[Rule] False\)}\)\
\)], "Output"]}, Open]], Cell[
            "With BReduce\[Rule]True, transformation is done.", "Text", 
            CellTags -> "BReduce"], Cell[CellGroupData[{Cell[BoxData[
                \(B0[\(0, s, s, \(BReduce \[Rule] True\)\)]\)], "Input", 
               CellTags -> "BReduce"], Cell[BoxData[FormBox[RowBox[
                  {FractionBox[RowBox[{FormBox[\("A"\_"0"\), 
                       "TraditionalForm"], "(", "s", ")"}], "s"], "-", "1"}], 
                 TraditionalForm]], "Output", CellTags -> "BReduce"]}, 
             Open]]}, Open]], Cell["B0", "ObjectName", CellTags -> "B0"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "B0"], Cell[TextData[
             {"B0[pp, ma^2, mb^2] is the Passarino-Veltman two-point integral \
", Cell[BoxData[\(TraditionalForm\`B\_0\)]], ". All arguments are scalars and \
have dimension mass^2. If the option BReduce is set to True, certain B0's are \
reduced to A0's. Setting the option B0Unique to True simplifies B0[a,0,a] and \
B0[0,0,a]."}], "Text", CellTags -> "B0"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[B0]\)], "Input", CellTags -> "B0"], Cell[BoxData[
                \(TraditionalForm\`\({\(BReduce \[Rule] False\), 
                      \(B0Unique \[Rule] True\), \(B0Real \[Rule] False\)}\)\
\)], "Output", CellTags -> "B0"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["B1", RuleDelayed[ButtonData, "B1"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B1"]], 
              ", ", 
              ButtonBox["B00", RuleDelayed[ButtonData, "B00"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B00"]], 
              ", ", 
              ButtonBox["B11", RuleDelayed[ButtonData, "B11"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B11"]], 
              ", ", 
              ButtonBox["PaVe", RuleDelayed[ButtonData, "PaVe"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "PaVe"]], 
              "."}], "Text", CellTags -> "B0"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "B0"], Cell[CellGroupData[{Cell[BoxData[
                \(B0[\(\(SP[\(p, p\)]\), m\^2, m\^2\)]\)], "Input", 
               CellTags -> "B0"], Cell[BoxData[FormBox[RowBox[{\(B\_0\), "(", 
                   FormBox[SuperscriptBox[FormBox["p", "TraditionalForm"], 
                     "2"], "TraditionalForm"], ",", \(m\^2\), ",", \(m\^2\), 
                   ")"}], TraditionalForm]], "Output", CellTags -> "B0"]}, 
             Open]], Cell[BoxData[
             \(\(SetOptions[\(B0, \(B0Unique \[Rule] True\), 
                    \(B0Real \[Rule] True\)\)]\) ;\)], "Input", 
            CellTags -> "B0"], Cell[CellGroupData[{Cell[BoxData[
                \(B0[\(0, 0, m\^2\)]\)], "Input", CellTags -> "B0"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\(B\_0 (0, m\^2, m\^2)\) + 1\)\)], 
               "Output", CellTags -> "B0"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B0[\(m\^2, 0, m\^2\)]\)], 
               "Input", CellTags -> "B0"], Cell[BoxData[
                \(TraditionalForm\`\(\(B\_0 (0, m\^2, m\^2)\) + 2\)\)], 
               "Output", CellTags -> "B0"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B0[\(0, \(m^2\), \(m^2\)\)]\)], 
               "Input", CellTags -> "B0"], Cell[BoxData[
                \(TraditionalForm\`\(B\_0 (0, m\^2, m\^2)\)\)], "Output", 
               CellTags -> "B0"]}, Open]]}, Open]], Cell["B0Real", 
         "ObjectName", PageBreakAbove -> True, CellTags -> "B0Real"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "B0Real"], Cell["B0Real is an option of B0 (default \
False). If set to True, B0 is assumed to be real and the relation B0[a,0,a] = \
2 + B0[0,a,a]  is applied.", "Text", CellTags -> "B0Real"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              "."}], "Text", CellTags -> "B0Real"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "B0Real"], Cell[
            "By default the arguments are not assumed real.", "Text", 
            CellTags -> "B0Real"], Cell[CellGroupData[{Cell[BoxData[
                \(B0[\(s, 0, s\)]\)], "Input", CellTags -> "B0Real"], 
              Cell[BoxData[\(TraditionalForm\`\(\(B\_0 (0, s, s)\) + 2\)\)], 
               "Output", CellTags -> "B0Real"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B0//Options\)], "Input", 
               CellTags -> "B0Real"], Cell[BoxData[
                \(TraditionalForm\`\({\(BReduce \[Rule] False\), 
                      \(B0Unique \[Rule] True\), \(B0Real \[Rule] True\)}\)\)]\
, "Output", CellTags -> "B0Real"]}, Open]], 
           Cell["With B0Real\[Rule]True, transformation is done.", "Text", 
            CellTags -> "B0Real"], Cell[CellGroupData[{Cell[BoxData[
                \(B0[\(s, 0, s, \(B0Real \[Rule] True\)\)]\)], "Input", 
               CellTags -> "B0Real"], Cell[BoxData[
                \(TraditionalForm\`\(\(B\_0 (0, s, s)\) + 2\)\)], "Output", 
               CellTags -> "B0Real"]}, Open]]}, Open]], 
        Cell["B0Unique", "ObjectName", PageBreakAbove -> True, 
         CellTags -> "B0Unique"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "B0Unique"], 
           Cell["B0Unique is an option of B0. If set to True, B0[0,0,m2] is \
replaced with (B0[0,m2,m2]+1) and B0[m2,0,m2] simplifies to (B0[0,m2,m2]+2)."\
, "Text", CellTags -> "B0Unique"], Cell[TextData[{"See also: ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              "."}], "Text", CellTags -> "B0Unique"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "B0Unique"], 
           Cell["By default transformation is done.", "Text", 
            CellTags -> "B0Unique"], Cell[CellGroupData[{Cell[BoxData[
                \(B0[\(0, 0, s\)]\)], "Input", CellTags -> "B0Unique"], 
              Cell[BoxData[\(TraditionalForm\`\(\(B\_0 (0, s, s)\) + 1\)\)], 
               "Output", CellTags -> "B0Unique"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B0//Options\)], "Input", 
               CellTags -> "B0Unique"], Cell[BoxData[
                \(TraditionalForm\`\({\(BReduce \[Rule] False\), 
                      \(B0Unique \[Rule] True\), \(B0Real \[Rule] True\)}\)\)]\
, "Output", CellTags -> "B0Unique"]}, Open]], 
           Cell["With B0Real\[Rule]False, nothing happens.", "Text", 
            CellTags -> "B0Unique"], Cell[CellGroupData[{Cell[BoxData[
                \(B0[\(0, 0, s, \(B0Unique \[Rule] False\)\)]\)], "Input", 
               CellTags -> "B0Unique"], Cell[BoxData[
                \(TraditionalForm\`\(B\_0 (0, 0, s)\)\)], "Output", 
               CellTags -> "B0Unique"]}, Open]]}, Open]], 
        Cell["B00", "ObjectName", CellTags -> "B00"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "B00"], Cell[TextData[
             {"B00[pp, ma^2,mb^2] is the Passarino-Veltman ", Cell[BoxData[
                \(TraditionalForm\`B\_00\)]], "-function, i.e., the \
coefficient function of the metric tensor. All arguments are scalars and have \
dimension mass^2."}], "Text", CellTags -> "B00"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[B00]\)], "Input", 
               CellTags -> "B00"], Cell[BoxData[
                \(TraditionalForm\`\({BReduce \[Rule] True}\)\)], "Output", 
               CellTags -> "B00"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              ", ", 
              ButtonBox["B1", RuleDelayed[ButtonData, "B1"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B1"]], 
              ", ", 
              ButtonBox["PaVe", RuleDelayed[ButtonData, "PaVe"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "PaVe"]], 
              "."}], "Text", CellTags -> "B00"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "B00"], Cell[TextData[{"Remember that SP[p] is a \
short hand input for ScalarProduct[p,p], i.e., ", Cell[BoxData[
                \(TraditionalForm\`\(p\^2\)\)]], "."}], "Text", 
            CellTags -> "B00"], Cell[CellGroupData[{Cell[BoxData[\(SP[p]\)], 
               "Input", CellTags -> "B00"], Cell[BoxData[FormBox[
                 SuperscriptBox[FormBox["p", "TraditionalForm"], "2"], 
                 TraditionalForm]], "Output", CellTags -> "B00"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B00[\(\(SP[p]\), m\^2, M\^2\)]\)
                ], "Input", CellTags -> "B00"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{\(1\/3\), " ", RowBox[{\(B\_0\), "(", 
                       FormBox[SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "TraditionalForm"], ",", 
                       \(m\^2\), ",", \(M\^2\), ")"}], " ", \(m\^2\)}], "+", 
                   RowBox[{\(1\/18\), " ", RowBox[{"(", RowBox[{\(3\ m\^2\), 
                         "+", \(3\ M\^2\), "-", FormBox[SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], 
                          "TraditionalForm"]}], ")"}]}], "+", RowBox[{\(1\/6\)
                     , " ", RowBox[{"(", RowBox[{RowBox[{FormBox[\("A"\_"0"\)
                          , "TraditionalForm"], "(", FormBox[\(M\^2\), 
                          "TraditionalForm"], ")"}], "+", RowBox[{RowBox[
                          {"(", RowBox[{FractionBox[RowBox[{\((M\^2 - m\^2)\)
                          , " ", RowBox[{"(", RowBox[{RowBox[{\(B\_0\), "(", 
                          FormBox[SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "TraditionalForm"], ",", 
                          \(m\^2\), ",", \(M\^2\), ")"}], "-", 
                          \(B\_0 (0, m\^2, M\^2)\)}], ")"}]}], RowBox[{"2", 
                          " ", FormBox[SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "TraditionalForm"]}]], 
                          "-", RowBox[{\(1\/2\), " ", RowBox[{\(B\_0\), "(", 
                          FormBox[SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "TraditionalForm"], ",", 
                          \(m\^2\), ",", \(M\^2\), ")"}]}]}], ")"}], " ", 
                          RowBox[{"(", RowBox[{\(m\^2\), "-", \(M\^2\), "+", 
                          FormBox[SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "TraditionalForm"]}], 
                          ")"}]}]}], ")"}]}]}], TraditionalForm]], "Output", 
               CellTags -> "B00"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(B00[\(\(SP[p]\), m\^2, m\^2\)]\)], "Input", CellTags -> 
                "B00"], Cell[BoxData[FormBox[RowBox[{RowBox[{\(1\/3\), " ", 
                     RowBox[{\(B\_0\), "(", FormBox[SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "TraditionalForm"], 
                       ",", \(m\^2\), ",", \(m\^2\), ")"}], " ", \(m\^2\)}], 
                   "+", RowBox[{\(1\/18\), " ", RowBox[{"(", RowBox[{
                         \(6\ m\^2\), "-", FormBox[SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], 
                          "TraditionalForm"]}], ")"}]}], "+", RowBox[{\(1\/6\)
                     , " ", RowBox[{"(", RowBox[{RowBox[{FormBox[\("A"\_"0"\)
                          , "TraditionalForm"], "(", FormBox[\(m\^2\), 
                          "TraditionalForm"], ")"}], "-", RowBox[{\(1\/2\), 
                          " ", RowBox[{\(B\_0\), "(", FormBox[SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], 
                          "TraditionalForm"], ",", \(m\^2\), ",", \(m\^2\), 
                          ")"}], " ", FormBox[SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "TraditionalForm"]}]}], 
                       ")"}]}]}], TraditionalForm]], "Output", CellTags -> 
                "B00"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(B00[\(\(SP[p]\), m\^2, M\^2, \(BReduce \[Rule] False\)\)]\)]\
, "Input", CellTags -> "B00"], Cell[BoxData[FormBox[RowBox[{FormBox[
                    \("B"\_"00"\), "TraditionalForm"], "(", FormBox[
                    FormBox[SuperscriptBox[FormBox["p", "TraditionalForm"], 
                      "2"], "TraditionalForm"], "TraditionalForm"], \(,\ \), 
                   FormBox[\(m\^2\), "TraditionalForm"], \(,\ \), FormBox[
                    \(M\^2\), "TraditionalForm"], ")"}], TraditionalForm]], 
               "Output", CellTags -> "B00"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B00[\(0, m\^2, m\^2\)]\)], 
               "Input", CellTags -> "B00"], Cell[BoxData[FormBox[RowBox[{
                   \(1\/3\ \(B\_0 (0, m\^2, m\^2)\)\ m\^2\), "+", \(m\^2\/3\)
                   , "+", RowBox[{\(1\/6\), " ", RowBox[{FormBox[\("A"\_"0"\)
                        , "TraditionalForm"], "(", FormBox[\(m\^2\), 
                        "TraditionalForm"], ")"}]}]}], TraditionalForm]], 
               "Output", CellTags -> "B00"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(B00[\(\(SmallVariable[\(M\^2\)]\), m\^2, m\^2\)]\)], 
               "Input", CellTags -> "B00"], Cell[BoxData[FormBox[RowBox[{
                   \(1\/3\ \(B\_0 (M\^2, m\^2, m\^2)\)\ m\^2\), "+", 
                   \(m\^2\/3\), "+", RowBox[{\(1\/6\), " ", RowBox[{FormBox[
                        \("A"\_"0"\), "TraditionalForm"], "(", FormBox[
                        \(m\^2\), "TraditionalForm"], ")"}]}]}], 
                 TraditionalForm]], "Output", CellTags -> "B00"]}, Open]]}, 
          Open]], Cell["B1", "ObjectName", CellTags -> "B1"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "B1"], Cell[TextData[
             {"B1[pp, ma^2, mb^2] the Passarino-Veltman ", Cell[BoxData[
                \(TraditionalForm\`B\_1\)]], "-function. All arguments are \
scalars and have dimension mass^2."}], "Text", CellTags -> "B1"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[B1]\)], "Input", 
               CellTags -> "B1"], Cell[BoxData[
                \(TraditionalForm\`\({BReduce \[Rule] True}\)\)], "Output", 
               CellTags -> "B1"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              ", ", 
              ButtonBox["B00", RuleDelayed[ButtonData, "B00"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B00"]], 
              ", ", 
              ButtonBox["B11", RuleDelayed[ButtonData, "B11"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B11"]], 
              ", ", 
              ButtonBox["PaVe", RuleDelayed[ButtonData, "PaVe"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "PaVe"]], 
              ", ", 
              ButtonBox["PaVeReduce", RuleDelayed[ButtonData, "PaVeReduce"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PaVeReduce"]], "."}], "Text", 
            CellTags -> "B1"]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "B1"], 
           Cell[CellGroupData[{Cell[BoxData[\(B1[\(\(SP[p]\), m\^2, M\^2\)]\)]
                , "Input", CellTags -> "B1"], Cell[BoxData[FormBox[
                 RowBox[{FractionBox[RowBox[{\((M\^2 - m\^2)\), " ", 
                      RowBox[{"(", RowBox[{RowBox[{\(B\_0\), "(", FormBox[
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], "TraditionalForm"], ",", \(m\^2\), ",", 
                          \(M\^2\), ")"}], "-", \(B\_0 (0, m\^2, M\^2)\)}], 
                        ")"}]}], RowBox[{"2", " ", FormBox[SuperscriptBox[
                        FormBox["p", "TraditionalForm"], "2"], 
                       "TraditionalForm"]}]], "-", RowBox[{\(1\/2\), " ", 
                     RowBox[{\(B\_0\), "(", FormBox[SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "TraditionalForm"], 
                       ",", \(m\^2\), ",", \(M\^2\), ")"}]}]}], 
                 TraditionalForm]], "Output", CellTags -> "B1"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(B1[\(\(SP[p]\), m\^2, M\^2, \(BReduce \[Rule] False\)\)]\)]\
, "Input", CellTags -> "B1"], Cell[BoxData[FormBox[RowBox[{\(B\_1\), "(", 
                   FormBox[SuperscriptBox[FormBox["p", "TraditionalForm"], 
                     "2"], "TraditionalForm"], ",", \(m\^2\), ",", \(M\^2\), 
                   ")"}], TraditionalForm]], "Output", CellTags -> "B1"]}, 
             Open]], Cell[BoxData[
             \(\(SetOptions[\(B1, \(BReduce \[Rule] True\)\)]\) ;\)], 
            "Input", CellTags -> "B1"], Cell[CellGroupData[{Cell[BoxData[
                \(B1[\(\(SP[p]\), m\^2, m\^2\)]\)], "Input", CellTags -> 
                "B1"], Cell[BoxData[FormBox[RowBox[{\(-\(1\/2\)\), " ", 
                   RowBox[{\(B\_0\), "(", FormBox[SuperscriptBox[FormBox["p", 
                        "TraditionalForm"], "2"], "TraditionalForm"], ",", 
                     \(m\^2\), ",", \(m\^2\), ")"}]}], TraditionalForm]], 
               "Output", CellTags -> "B1"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B1[\(m\^2, m\^2, 0\)]\)], 
               "Input", CellTags -> "B1"], Cell[BoxData[
                \(TraditionalForm\`\(\(1\/2\ 
                       \((\(-\(B\_0 (0, m\^2, m\^2)\)\) - 2)\)\) - 1\/2\)\)], 
               "Output", CellTags -> "B1"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B1[\(0, 0, m\^2\)]\)], "Input", 
               CellTags -> "B1"], Cell[BoxData[
                \(TraditionalForm\`\(\(1\/2\ 
                       \((\(-\(B\_0 (0, m\^2, m\^2)\)\) - 1)\)\) + 1\/4\)\)], 
               "Output", CellTags -> "B1"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(B1[\(pp, \(SmallVariable[m\_e\%2]\), m\_2\%2\)]\)], 
               "Input", CellTags -> "B1"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(
                         (\(B\_0 (pp, m\_e\%2, m\_2\%2)\) - 
                           \(B\_0 (0, m\_e\%2, m\_2\%2)\))\)\ m\_2\%2\)\/
                      \(2\ pp\) - \(1\/2\ \(B\_0 (pp, m\_e\%2, m\_2\%2)\)\)\)
                \)], "Output", CellTags -> "B1"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(B1[\(\(SmallVariable[m\_e\%2]\), \(SmallVariable[m\_e\%2]\)
                     , 0\)]\)], "Input", CellTags -> "B1"], Cell[BoxData[
                \(TraditionalForm\`\(\(1\/2\ 
                       \((\(-\(B\_0 (0, m\_e\%2, m\_e\%2)\)\) - 2)\)\) - 1\/2
                \)\)], "Output", CellTags -> "B1"]}, Open]]}, Open]], 
        Cell["B11", "ObjectName", CellTags -> "B11"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "B11"], Cell[TextData[
             {"B11[pp, ma^2, mb^2] is the Passarino-Veltman ", Cell[BoxData[
                \(TraditionalForm\`B\_11\)]], 
              "-function, i.e., the coefficient function of ", Cell[BoxData[
                \(TraditionalForm\`\(p\^\[Mu]\ p\^\[Nu]\)\)]], 
              ". All arguments are scalars and have dimension mass", 
              Cell[BoxData[\(TraditionalForm\`\(\[Null]\^2\)\)]], "."}], 
            "Text", CellTags -> "B11"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[B11]\)], "Input", CellTags -> "B11"], Cell[BoxData[
                \(TraditionalForm\`\({BReduce \[Rule] True}\)\)], "Output", 
               CellTags -> "B11"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              ", ", 
              ButtonBox["B00", RuleDelayed[ButtonData, "B00"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B00"]], 
              ", ", 
              ButtonBox["B1", RuleDelayed[ButtonData, "B1"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B1"]], 
              ", ", 
              ButtonBox["PaVe", RuleDelayed[ButtonData, "PaVe"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "PaVe"]], 
              "."}], "Text", CellTags -> "B11"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "B11"], Cell[TextData[{"Remember that SP[p] is a \
short hand input for ScalarProduct[p,p], i.e. ", Cell[BoxData[
                \(TraditionalForm\`\(p\^2 .\)\)]]}], "Text", 
            CellTags -> "B11"], Cell[CellGroupData[{Cell[BoxData[\(SP[p]\)], 
               "Input", CellTags -> "B11"], Cell[BoxData[FormBox[
                 SuperscriptBox[FormBox["p", "TraditionalForm"], "2"], 
                 TraditionalForm]], "Output", CellTags -> "B11"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B11[\(\(SP[p]\), m\^2, M\^2\)]\)
                ], "Input", CellTags -> "B11"], Cell[BoxData[FormBox[
                 RowBox[{FractionBox["1", RowBox[{"3", " ", FormBox[
                       SuperscriptBox[FormBox["p", "TraditionalForm"], "2"], 
                       "TraditionalForm"]}]], RowBox[{"(", RowBox[
                      {RowBox[{RowBox[{"-", RowBox[{\(B\_0\), "(", FormBox[
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], "TraditionalForm"], ",", \(m\^2\), ",", 
                          \(M\^2\), ")"}]}], " ", \(m\^2\)}], "+", RowBox[
                        {FormBox[\("A"\_"0"\), "TraditionalForm"], "(", 
                         FormBox[\(M\^2\), "TraditionalForm"], ")"}], "+", 
                       RowBox[{\(1\/6\), " ", RowBox[{"(", RowBox[{
                          \(\(-3\)\ m\^2\), "-", \(3\ M\^2\), "+", FormBox[
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], "TraditionalForm"]}], ")"}]}], "-", RowBox[
                        {"2", " ", RowBox[{"(", RowBox[{FractionBox[RowBox[{
                          \((M\^2 - m\^2)\), " ", RowBox[{"(", RowBox[
                          {RowBox[{\(B\_0\), "(", FormBox[SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], 
                          "TraditionalForm"], ",", \(m\^2\), ",", \(M\^2\), 
                          ")"}], "-", \(B\_0 (0, m\^2, M\^2)\)}], ")"}]}], 
                          RowBox[{"2", " ", FormBox[SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], 
                          "TraditionalForm"]}]], "-", RowBox[{\(1\/2\), " ", 
                          RowBox[{\(B\_0\), "(", FormBox[SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], 
                          "TraditionalForm"], ",", \(m\^2\), ",", \(M\^2\), 
                          ")"}]}]}], ")"}], " ", RowBox[{"(", RowBox[{\(m\^2\)
                          , "-", \(M\^2\), "+", FormBox[SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], 
                          "TraditionalForm"]}], ")"}]}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "B11"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(B11[\(\(SP[p]\), m\^2, m\^2\)]\)
                ], "Input", CellTags -> "B11"], Cell[BoxData[FormBox[
                 FractionBox[RowBox[{RowBox[{FormBox[\("A"\_"0"\), 
                       "TraditionalForm"], "(", FormBox[\(m\^2\), 
                       "TraditionalForm"], ")"}], "+", RowBox[{\(1\/6\), " ", 
                      RowBox[{"(", RowBox[{FormBox[SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "TraditionalForm"], 
                          "-", \(6\ m\^2\)}], ")"}]}], "+", RowBox[{RowBox[{
                        \(B\_0\), "(", FormBox[SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "TraditionalForm"], ",", 
                        \(m\^2\), ",", \(m\^2\), ")"}], " ", RowBox[
                       {"(", RowBox[{FormBox[SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "TraditionalForm"], "-", 
                          \(m\^2\)}], ")"}]}]}], RowBox[{"3", " ", FormBox[
                     SuperscriptBox[FormBox["p", "TraditionalForm"], "2"], 
                     "TraditionalForm"]}]], TraditionalForm]], "Output", 
               CellTags -> "B11"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(SetOptions[\(B11, \(BReduce \[Rule] False\)\)]\)], "Input", 
               CellTags -> "B11"], Cell[BoxData[
                \(TraditionalForm\`\({BReduce \[Rule] False}\)\)], "Output", 
               CellTags -> "B11"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(B11[\(\(SP[p]\), m\^2, M\^2\)]\)], "Input", CellTags -> 
                "B11"], Cell[BoxData[FormBox[RowBox[{FormBox[\("B"\_"11"\), 
                    "TraditionalForm"], "(", FormBox[FormBox[SuperscriptBox[
                      FormBox["p", "TraditionalForm"], "2"], 
                     "TraditionalForm"], "TraditionalForm"], \(,\ \), FormBox[
                    \(m\^2\), "TraditionalForm"], \(,\ \), FormBox[\(M\^2\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "B11"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(SetOptions[\(B11, \(BReduce \[Rule] True\)\)]\)], "Input", 
               CellTags -> "B11"], Cell[BoxData[
                \(TraditionalForm\`\({BReduce \[Rule] True}\)\)], "Output", 
               CellTags -> "B11"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(B11[\(0, m\^2, m\^2\)]\)], "Input", CellTags -> "B11"], 
              Cell[BoxData[
                \(TraditionalForm\`\(1\/3\ \(B\_0 (0, m\^2, m\^2)\)\)\)], 
               "Output", CellTags -> "B11"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(B11[\(\(SmallVariable[\(M\^2\)]\), m\^2, m\^2\)]\)], 
               "Input", CellTags -> "B11"], Cell[BoxData[
                \(TraditionalForm\`\(1\/3\ \(B\_0 (M\^2, m\^2, m\^2)\)\)\)], 
               "Output", CellTags -> "B11"]}, Open]]}, Open]], 
        Cell["CA", "ObjectName", CellTags -> "CA"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CA"], Cell[TextData[
             {"CA is one of the Casimir operator eigenvalues of SU(", 
              StyleBox["N", Rule[FontSlant, "Italic"]], ") (CA = ", 
              StyleBox["N", Rule[FontSlant, "Italic"]], ")."}], "Text", 
            CellTags -> "CA"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["CF", RuleDelayed[ButtonData, "CF"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "CF"]], 
              ", ", 
              ButtonBox["SUNSimplify", RuleDelayed[ButtonData, 
                 "SUNSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SUNSimplify"]], "."}], "Text", 
            CellTags -> "CA"]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "CA"], 
           Cell[CellGroupData[{Cell[BoxData["CA"], "Input", CellTags -> 
                "CA"], Cell[BoxData[\(TraditionalForm\`C\_A\)], "Output", 
               CellTags -> "CA"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(SUNSimplify[\(CA, \(SUNNToCACF \[Rule] False\)\)]\)], 
               "Input", CellTags -> "CA"], Cell[BoxData[\(TraditionalForm\`N\)
                ], "Output", CellTags -> "CA"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData["SUNN"], "Input", CellTags -> 
                "CA"], Cell[BoxData[\(TraditionalForm\`N\)], "Output", 
               CellTags -> "CA"]}, Open]]}, Open]], 
        Cell["Calc", "ObjectName", CellTags -> "Calc"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Calc"], Cell["Calc[exp] performs several basic \
simplifications. Calc[exp] is the same as \
DotSimplify[DiracSimplify[Contract[DiracSimplify[Explicit[ \
SUNSimplify[Trick[exp], Explicit\[Rule]False] ]]]]].", "Text", 
            CellTags -> "Calc"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], ", ", 
              ButtonBox["Trick", RuleDelayed[ButtonData, "Trick"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Trick"]], 
              "."}], "Text", CellTags -> "Calc"]}, Open]], 
        Cell[CellGroupData[{Cell[BoxData["Examples"], "Subsubsection", 
            CellTags -> "Calc"], Cell[TextData[{"This calculates ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] \[Gamma]\_\[Mu]\)\)]], 
              " in 4 dimensions and ", Cell[BoxData[
                \(TraditionalForm\`g\_\[Nu]\%\[Nu]\)]], 
              " in D dimensions."}], "Text", CellTags -> "Calc"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Calc[\({\(GA[\(\[Mu], \[Mu]\)]\),\ 
                      \(MTD[\(\[Nu], \[Nu]\)]\)}\)]\)], "Input", CellTags -> 
                "Calc"], Cell[BoxData[\(TraditionalForm\`\({4, D}\)\)], 
               "Output", CellTags -> "Calc"]}, Open]], 
           Cell[TextData[{"This simplifies ", Cell[BoxData[
                \(TraditionalForm\`\(f\_abc\ \(f\_abe .\)\)\)]]}], "Text", 
            CellTags -> "Calc"], Cell[CellGroupData[{Cell[BoxData[
                \(Calc[\(\(SUNF[\(a, b, c\)]\)\ \(SUNF[\(a, b, e\)]\)\)]\)], 
               "Input", CellTags -> "Calc"], Cell[BoxData[FormBox[RowBox[{
                   \(C\_A\), " ", SubscriptBox["\[Delta]", RowBox[
                     {FormBox[FormBox["c", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["e", 
                        "TraditionalForm"], "TraditionalForm"]}]]}], 
                 TraditionalForm]], "Output", CellTags -> "Calc"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(FV[\(\(p + r\), \[Mu]\)]\)\ \(MT[\(\[Mu], \[Nu]\)]\)\ 
                   \(FV[\(\(q - p\), \[Nu]\)]\)\)], "Input", CellTags -> 
                "Calc"], Cell[BoxData[FormBox[RowBox[{RowBox[{"(", 
                     SuperscriptBox[FormBox[\(q - p\), "TraditionalForm"], 
                      "\[Nu]"], ")"}], " ", RowBox[{"(", SuperscriptBox[
                      FormBox[\(p + r\), "TraditionalForm"], "\[Mu]"], ")"}], 
                   " ", \(g\^\(\[Mu]\[Nu]\)\)}], TraditionalForm]], "Output", 
               CellTags -> "Calc"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Calc[%]\)], "Input", CellTags -> "Calc"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"-", SuperscriptBox[FormBox["p", 
                       "TraditionalForm"], "2"]}], "+", RowBox[{FormBox["p", 
                      "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                      "TraditionalForm"]}], "-", RowBox[{FormBox["p", 
                      "TraditionalForm"], "\[CenterDot]", FormBox["r", 
                      "TraditionalForm"]}], "+", RowBox[{FormBox["q", 
                      "TraditionalForm"], "\[CenterDot]", FormBox["r", 
                      "TraditionalForm"]}]}], TraditionalForm]], "Output", 
               CellTags -> "Calc"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(GluonVertex[\(p, 1, q, 2, \(\(-p\) - q\), 3\)]\)], "Input", 
               CellTags -> "Calc"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{SuperscriptBox["V", RowBox[{FormBox[FormBox["li1", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["li2", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["li3", 
                          "TraditionalForm"], "TraditionalForm"]}]], "(", 
                     RowBox[{FormBox["p", "TraditionalForm"], \(,\ \), 
                       FormBox["q", "TraditionalForm"], \(,\ \), FormBox[
                        \(\(-p\) - q\), "TraditionalForm"]}], ")"}], " ", 
                   SubscriptBox["f", RowBox[{FormBox[FormBox["ci1", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["ci2", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["ci3", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "Calc"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Calc[\(\(%\ \(FVD[\(p, li1\)]\)\)\ \(FVD[\(q, li2\)]\)\ 
                     \(FVD[\(\(\(-p\) - q\), li3\)]\)\)]\)], "Input", 
               CellTags -> "Calc"], Cell[BoxData[\(TraditionalForm\`0\)], 
               "Output", CellTags -> "Calc"]}, Open]]}, Open]], 
        Cell["CalcColorFactor", "ObjectName", CellTags -> "CalcColorFactor"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CalcColorFactor"], Cell["CalcColorFactor[expr] \
calculates the color factor of expr.  CalcColorFactor is useful for \
application on FeynArts produced amplitudes. CalcColorFactor is just a macro \
function for CalcColorFactor[x_] := \nIf[FreeQ2[FeynCalcInternal[x], \
SUNIndex],  x, \n                    SUNSimplify[SUNSimplify[  (If[ \
!FreeQ[#1, DiracGamma], DiracTrick[#1], #1] & )[  SUNSimplify[x]], Explicit \
-> False], Explicit -> True]].", "Text", CellTags -> "CalcColorFactor"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["SUNSimplify", RuleDelayed[ButtonData, 
                 "SUNSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SUNSimplify"]], "."}], "Text", 
            CellTags -> "CalcColorFactor"]}, Open]], 
        Cell[CellGroupData[{Cell[BoxData["Examples"], "Subsubsection", 
            CellTags -> "CalcColorFactor"], Cell[CellGroupData[{Cell[BoxData[
                \(CalcColorFactor[\(\(SUNF[\(a, b, c\)]\)\ 
                     \(SUNF[\(a, b, d\)]\)\)]\)], "Input", CellTags -> 
                "CalcColorFactor"], Cell[BoxData[FormBox[RowBox[{\(C\_A\), 
                   " ", SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["d", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "CalcColorFactor"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Amplitude["q2se2"]\)], "Input", 
               CellTags -> "CalcColorFactor"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{"-", RowBox[{"tr", "(", FormBox[RowBox[
                         {"2", " ", \(T\_f\), " ", RowBox[{RowBox[{
                          \(\[CapitalPi]\_q\), "(", FormBox[
                          \(-\(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], ")"}], ".", 
                          \(Q\_\(c\_9\)\%\(\[Lambda]\_9\)\), ".", RowBox[{
                          \(\[CapitalPi]\_q\), "(", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_2 - 
                             \(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], ")"}], ".", 
                          \(Q\_\(c\_3\)\%\(\[Lambda]\_3\)\)}]}], 
                        "TraditionalForm"], ")"}]}], " ", RowBox[{
                     \(Q\_\(c\_11\)\%\(\[Lambda]\_11\)\), ".", RowBox[{
                       \(\[CapitalPi]\_q\), "(", FormBox[
                        \(p - \(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2\), 
                        "TraditionalForm"], ")"}], ".", 
                     \(Q\_\(c\_1\)\%\(\[Lambda]\_1\)\)}], " ", RowBox[{
                     \(\[CapitalPi]\_\(c\_1 c\_3\)\%
                        \(\[Lambda]\_1 \[Lambda]\_3\)\), "(", FormBox[
                      \(\(\*TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_2\), 
                      "TraditionalForm"], ")"}], " ", RowBox[{
                     \(\[CapitalPi]\_\(c\_9 c\_11\)\%
                        \(\[Lambda]\_9 \[Lambda]\_11\)\), "(", FormBox[
                      \(\(\*TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_2\), 
                      "TraditionalForm"], ")"}]}], TraditionalForm]], 
               "Output", CellTags -> "CalcColorFactor"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(CalcColorFactor @ \(Explicit @ %\)\)], "Input", CellTags -> 
                "CalcColorFactor"], Cell[BoxData[FormBox[FractionBox[
                  RowBox[{"\[ImaginaryI]", " ", \(C\_F\), " ", \(g\_s\%4\), 
                    " ", \(T\_f\), " ", RowBox[{"tr", "(", FormBox[RowBox[
                        {"-", RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], ")"}], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Lambda]\_9\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", "(", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_1 - 
                             \(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], ")"}], ")"}], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Lambda]\_3\), "TraditionalForm"], 
                          "TraditionalForm"]]}]}], "TraditionalForm"], ")"}], 
                    " ", RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                         \(\[Lambda]\_11\), "TraditionalForm"], 
                        "TraditionalForm"]], ".", RowBox[{"(", RowBox[
                         {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                          "\[CenterDot]", "(", FormBox[
                          \(p - \(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], ")"}], ")"}], ".", 
                      SuperscriptBox["\[Gamma]", FormBox[FormBox[
                         \(\[Lambda]\_1\), "TraditionalForm"], 
                        "TraditionalForm"]]}], " ", 
                    \(\((1\/\(\*TagBox[StyleBox["\"q\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_2\%2)\)\^2\), 
                    " ", \(g\^\(\[Lambda]\_1 \[Lambda]\_3\)\), " ", 
                    \(g\^\(\[Lambda]\_9 \[Lambda]\_11\)\)}], 
                  \(\(\*TagBox[StyleBox["\"q\"", Rule[FontSlant, "Italic"]], 
                         Function[StyleForm[Slot[1], 
                           Rule[FontSlant, "Italic"]]]]\)\_1\%2 . 
                     \((p - \(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2)\)\^2 . 
                     \((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2 - 
                         \(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1)\)\^2\)], 
                 TraditionalForm]], "Output", CellTags -> 
                "CalcColorFactor"]}, Open]]}, Open]], 
        Cell["CalculateCounterTerm ***unfinished***", "ObjectName", 
         CellTags -> "CalculateCounterTerm"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CalculateCounterTerm"], 
           Cell[
            "CalculateCounterTerm[exp, k] calculates the residue of exp.", 
            "Text", CellTags -> "CalculateCounterTerm"]}, Open]], 
        Cell[CellGroupData[{Cell[BoxData["Examples"], "Subsubsection", 
            CellTags -> "CalculateCounterTerm"], Cell[CellGroupData[
             {Cell[BoxData[\(? CalculateCounterTerm\)], "Input", CellTags -> 
                "CalculateCounterTerm"], Cell[BoxData["\"CalculateCounterTerm\
[exp, k] calculates the residue of exp.\""], "Print", CellTags -> 
                {"CalculateCounterTerm", "Info3353009088-8660148"}]}, 
             Open]]}, Open]], Cell["CancelQP", "ObjectName", 
         CellTags -> "CancelQP"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "CancelQP"], 
           Cell[TextData[{"CancelQP is an option for OneLoop. If set to True, \
cancelation of all ", StyleBox["q", Rule[FontSlant, "Italic"]], ".", 
              StyleBox["p", Rule[FontSlant, "Italic"]], "'s and ", 
              Cell[BoxData[\(TraditionalForm\`\(q\^2\)\)]], 
              " is performed."}], "Text", CellTags -> "CancelQP"]}, Open]], 
        Cell[CellGroupData[{Cell[BoxData["Examples"], "Subsubsection", 
            CellTags -> "CancelQP"], Cell[CellGroupData[{Cell[BoxData[
                \(t = \(\(\(SPD[\(\(p + \(2q2\)\), \(p + q2\)\)]\)\ 
                       \(FAD[\(\({\(q2 - p\), m}\), \({q2, 0}\), \({q2, M}\)
                          \)]\)\)//FCI\)\)], "Input", CellTags -> 
                "CancelQP"], Cell[BoxData[FormBox[FractionBox[RowBox[
                   {"(", FormBox[
                     \(p + \(\*TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_2\), 
                     "TraditionalForm"], ")", "\[CenterDot]", "(", FormBox[
                     \(p + \(2\ \(\*TagBox[StyleBox["\"q\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_2\)\), 
                     "TraditionalForm"], ")"}], 
                  \(\((\((\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2 - p)\)\^2\
 - m\^2)\) . \(\*TagBox[StyleBox["\"q\"", 
                          Rule[FontSlant, "Italic"]], 
                         Function[StyleForm[Slot[1], 
                           Rule[FontSlant, "Italic"]]]]\)\_2\%2 . 
                     \((\(\*TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_2\%2 - M\^2)\)\
\)], TraditionalForm]], "Output", CellTags -> "CancelQP"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(OneLoop[\(q2, t, \(CancelQP \[Rule] True\)\)]\)], "Input", 
               CellTags -> "CancelQP"], Cell[BoxData[FormBox[RowBox[
                  {"\[ImaginaryI]", " ", \(\[Pi]\^2\), " ", RowBox[
                    {"(", RowBox[{FractionBox[RowBox[{"3", " ", RowBox[{
                          \(B\_0\), "(", SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], ",", "0", ",", \(m\^2\), 
                          ")"}], " ", \(m\^2\)}], \(2\ M\^2\)], "-", 
                       FractionBox[RowBox[{"3", " ", RowBox[{FormBox[
                          \("A"\_"0"\), "TraditionalForm"], "(", FormBox[
                          \(M\^2\), "TraditionalForm"], ")"}]}], \(2\ M\^2\)]
                        , "-", FractionBox[RowBox[{
                          \((\(3\ m\^2\) - \(7\ M\^2\))\), " ", RowBox[{
                          \(B\_0\), "(", SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], ",", \(m\^2\), ",", 
                          \(M\^2\), ")"}]}], \(2\ M\^2\)], "-", FractionBox[
                        RowBox[{"5", " ", RowBox[{\(B\_0\), "(", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], ",", "0", ",", \(m\^2\), ")"}], " ", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"]}], \(2\ M\^2\)], "+", FractionBox[RowBox[
                         {"5", " ", RowBox[{\(B\_0\), "(", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], ",", \(m\^2\)
                          , ",", \(M\^2\), ")"}], " ", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"]}], \(2\ M\^2\)]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "CancelQP"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(OneLoop[\(q2, t, \(CancelQP \[Rule] False\)\)]\)], "Input", 
               CellTags -> "CancelQP"], Cell[BoxData[FormBox[RowBox[
                  {"\[ImaginaryI]", " ", \(\[Pi]\^2\), " ", RowBox[
                    {"(", RowBox[{
                       \(-\(\(3\ \(B\_0 (0, m\^2, m\^2)\)\ m\^2\)\/
                            \(2\ M\^2\)\)\), "+", 
                       \(\(7\ \(B\_0 (0, m\^2, M\^2)\)\ m\^2\)\/\(2\ M\^2\)\)\
, "+", FractionBox[RowBox[{"3", " ", RowBox[{\(B\_0\), "(", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], ",", "0", 
                          ",", \(m\^2\), ")"}], " ", \(m\^2\)}], \(2\ M\^2\)]
                        , "-", \(\(3\ m\^2\)\/\(2\ M\^2\)\), "-", FractionBox[
                        RowBox[{"2", " ", RowBox[{FormBox[\("A"\_"0"\), 
                          "TraditionalForm"], "(", FormBox[\(m\^2\), 
                          "TraditionalForm"], ")"}]}], \(M\^2\)], "+", 
                       FractionBox[RowBox[{"2", " ", RowBox[{FormBox[
                          \("A"\_"0"\), "TraditionalForm"], "(", FormBox[
                          \(M\^2\), "TraditionalForm"], ")"}]}], \(M\^2\)], 
                       "-", \(7\/2\ \(B\_0 (0, m\^2, M\^2)\)\), "-", 
                       FractionBox[RowBox[{\((\(3\ m\^2\) - \(7\ M\^2\))\), 
                          " ", RowBox[{\(B\_0\), "(", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], ",", \(m\^2\), ",", 
                          \(M\^2\), ")"}]}], \(2\ M\^2\)], "-", FractionBox[
                        RowBox[{"5", " ", RowBox[{\(B\_0\), "(", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], ",", "0", ",", \(m\^2\), ")"}], " ", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"]}], \(2\ M\^2\)], "+", FractionBox[RowBox[
                         {"5", " ", RowBox[{\(B\_0\), "(", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], ",", \(m\^2\)
                          , ",", \(M\^2\), ")"}], " ", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"]}], \(2\ M\^2\)]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "CancelQP"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t = \(\(\(SPD[\(q2, p\)]\) \(SPD[\(q1, p\)]\)\ 
                       \(FAD[\(\({q1, m}\), \({q2, m}\), \(q1 - p\), 
                           \(q2 - p\), \(q2 - q1\)\)]\)\)//FCI\)\)], "Input", 
               CellTags -> "CancelQP"], Cell[BoxData[FormBox[FractionBox[
                  RowBox[{RowBox[{FormBox["p", "TraditionalForm"], 
                      "\[CenterDot]", FormBox[
                       \(\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1\), 
                       "TraditionalForm"]}], " ", RowBox[{FormBox["p", 
                       "TraditionalForm"], "\[CenterDot]", FormBox[
                       \(\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2\), 
                       "TraditionalForm"]}]}], 
                  \(\((\(\*TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\%2 - m\^2)\)\
 . \((\(\*TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_2\%2 - m\^2)\)\
 . \((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1 - p)\)\^2 . 
                     \((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2 - p)\)\^2 . 
                     \((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2 - 
                         \(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1)\)\^2\)], 
                 TraditionalForm]], "Output", CellTags -> "CancelQP"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(OneLoop[\(q2, t, \(CancelQP \[Rule] True\)\)]\)], "Input", 
               CellTags -> "CancelQP"], Cell[BoxData[FormBox[RowBox[
                  {"\[ImaginaryI]", " ", \(\[Pi]\^2\), " ", RowBox[
                    {"(", RowBox[{RowBox[{"-", FractionBox[RowBox[{RowBox[
                          {FormBox[\("C"\_"0"\), "TraditionalForm"], "(", 
                          FormBox[SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "TraditionalForm"], ",", 
                          FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\), 
                          "TraditionalForm"], ",", FormBox[RowBox[
                          {SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], "-", RowBox[{"2", " ", RowBox[{FormBox["p", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          "TraditionalForm"], ",", FormBox["0", 
                          "TraditionalForm"], ",", FormBox[\(m\^2\), 
                          "TraditionalForm"], ",", FormBox["0", 
                          "TraditionalForm"], ")"}], " ", RowBox[{FormBox[
                          "p", "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}], RowBox[
                          {"2", " ", 
                          \((m\^2 - \(\*TagBox[StyleBox["\"q\"", 
                                   Rule[FontSlant, "Italic"]], 
                                  Function[StyleForm[Slot[1], 
                                    Rule[FontSlant, "Italic"]]]]\)\_1\%2)\), 
                          " ", RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "-", RowBox[{"2", 
                          " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          ")"}]}]]}], "+", FractionBox[RowBox[{
                          \(B\_0 (\(\*TagBox[StyleBox["\"q\"", 
                                  Rule[FontSlant, "Italic"]], 
                                 Function[StyleForm[Slot[1], 
                                   Rule[FontSlant, "Italic"]]]]\)\_1\%2, 0, 
                             m\^2)\), " ", RowBox[{FormBox["p", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], RowBox[{"2", " ", 
                          \((m\^2 - \(\*TagBox[StyleBox["\"q\"", 
                                   Rule[FontSlant, "Italic"]], 
                                  Function[StyleForm[Slot[1], 
                                    Rule[FontSlant, "Italic"]]]]\)\_1\%2)\), 
                          " ", RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "-", RowBox[{"2", 
                          " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          ")"}]}]], "-", FractionBox[RowBox[{RowBox[{\(B\_0\)
                          , "(", RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "-", RowBox[{"2", " ", 
                          RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          ",", "0", ",", "0", ")"}], " ", RowBox[{FormBox[
                          "p", "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], RowBox[{"2", " ", 
                          \((m\^2 - \(\*TagBox[StyleBox["\"q\"", 
                                   Rule[FontSlant, "Italic"]], 
                                  Function[StyleForm[Slot[1], 
                                    Rule[FontSlant, "Italic"]]]]\)\_1\%2)\), 
                          " ", RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "-", RowBox[{"2", 
                          " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          ")"}]}]], "-", FractionBox[RowBox[{RowBox[{FormBox[
                          \("C"\_"0"\), "TraditionalForm"], "(", FormBox[
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], "TraditionalForm"], ",", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\), 
                          "TraditionalForm"], ",", FormBox[RowBox[
                          {SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], "-", RowBox[{"2", " ", RowBox[{FormBox["p", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          "TraditionalForm"], ",", FormBox["0", 
                          "TraditionalForm"], ",", FormBox[\(m\^2\), 
                          "TraditionalForm"], ",", FormBox["0", 
                          "TraditionalForm"], ")"}], " ", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], " ", 
                          RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], RowBox[{"2", " ", 
                          \((m\^2 - \(\*TagBox[StyleBox["\"q\"", 
                                   Rule[FontSlant, "Italic"]], 
                                  Function[StyleForm[Slot[1], 
                                    Rule[FontSlant, "Italic"]]]]\)\_1\%2)\), 
                          " ", RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "-", RowBox[{"2", 
                          " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          ")"}]}]]}], ")"}]}], TraditionalForm]], "Output", 
               CellTags -> "CancelQP"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(OneLoop[\(q2, t, \(CancelQP \[Rule] False\)\)]\)]
                , "Input", CellTags -> "CancelQP"], Cell[BoxData[
                FormBox[RowBox[{"\[ImaginaryI]", " ", \(\[Pi]\^2\), " ", 
                   RowBox[{"(", RowBox[{FractionBox[RowBox[{RowBox[{"PaVe", 
                          "(", RowBox[{"2", ",", RowBox[{"{", RowBox[
                          {SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], ",", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\), 
                          ",", RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "-", RowBox[{"2", " ", 
                          RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}]}], 
                          "}"}], ",", \({0, m\^2, 0}\)}], ")"}], " ", 
                          SuperscriptBox[FormBox[RowBox[{FormBox["p", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "TraditionalForm"], "2"]}], 
                        RowBox[{
                          \((m\^2 - \(\*TagBox[StyleBox["\"q\"", 
                                   Rule[FontSlant, "Italic"]], 
                                  Function[StyleForm[Slot[1], 
                                    Rule[FontSlant, "Italic"]]]]\)\_1\%2)\), 
                          " ", RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "-", RowBox[{"2", 
                          " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          ")"}]}]], "-", FractionBox[RowBox[{SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], " ", 
                          RowBox[{"PaVe", "(", RowBox[{"1", ",", RowBox[
                          {"{", RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], ",", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\), 
                          ",", RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "-", RowBox[{"2", " ", 
                          RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}]}], 
                          "}"}], ",", \({0, m\^2, 0}\)}], ")"}], " ", 
                          RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], RowBox[{
                          \((m\^2 - \(\*TagBox[StyleBox["\"q\"", 
                                   Rule[FontSlant, "Italic"]], 
                                  Function[StyleForm[Slot[1], 
                                    Rule[FontSlant, "Italic"]]]]\)\_1\%2)\), 
                          " ", RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "-", RowBox[{"2", 
                          " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          ")"}]}]], "-", FractionBox[RowBox[{SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], " ", 
                          RowBox[{"PaVe", "(", RowBox[{"2", ",", RowBox[
                          {"{", RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], ",", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\), 
                          ",", RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], "-", RowBox[{"2", " ", 
                          RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}]}], 
                          "}"}], ",", \({0, m\^2, 0}\)}], ")"}], " ", 
                          RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], RowBox[{
                          \((m\^2 - \(\*TagBox[StyleBox["\"q\"", 
                                   Rule[FontSlant, "Italic"]], 
                                  Function[StyleForm[Slot[1], 
                                    Rule[FontSlant, "Italic"]]]]\)\_1\%2)\), 
                          " ", RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "-", RowBox[{"2", 
                          " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          ")"}]}]], "-", FractionBox[RowBox[{RowBox[{FormBox[
                          \("C"\_"0"\), "TraditionalForm"], "(", FormBox[
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], "TraditionalForm"], ",", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\), 
                          "TraditionalForm"], ",", FormBox[RowBox[
                          {SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"], "-", RowBox[{"2", " ", RowBox[{FormBox["p", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          "TraditionalForm"], ",", FormBox["0", 
                          "TraditionalForm"], ",", FormBox[\(m\^2\), 
                          "TraditionalForm"], ",", FormBox["0", 
                          "TraditionalForm"], ")"}], " ", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"], " ", 
                          RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], RowBox[{
                          \((m\^2 - \(\*TagBox[StyleBox["\"q\"", 
                                   Rule[FontSlant, "Italic"]], 
                                  Function[StyleForm[Slot[1], 
                                    Rule[FontSlant, "Italic"]]]]\)\_1\%2)\), 
                          " ", RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"], "-", RowBox[{"2", 
                          " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], "+", 
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\%2\)}], 
                          ")"}]}]]}], ")"}]}], TraditionalForm]], "Output", 
               CellTags -> "CancelQP"]}, Open]], Cell[BoxData[\(Clear[t]\)], 
            "Input", CellTags -> "CancelQP"]}, Open]], 
        Cell["Cases2", "ObjectName", CellTags -> "Cases2"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Cases2"], Cell["Cases2[expr, f] returns a list of \
all objects in expr with head f. Cases2[expr,f] is equivalent to \
Cases2[{expr},f[___],Infinity]//Union. Cases2[expr, f, g, ...] or \
Cases2[expr, {f,g, ...}] is equivalent to Cases[{expr},f[___] | g[___] ...] \
.", "Text", CellTags -> "Cases2"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[Cases2]\)], "Input", CellTags -> "Cases2"], 
              Cell[BoxData[\(TraditionalForm\`\({Heads \[Rule] False}\)\)], 
               "Output", CellTags -> "Cases2"]}, Open]]}, Open]], 
        Cell[CellGroupData[{Cell[BoxData["Examples"], "Subsubsection", 
            CellTags -> "Cases2"], Cell[CellGroupData[{Cell[BoxData[
                \(Cases2[\(\(\(f[a]\) + \(f[b]\)\^2 + \(f[\(c, d\)]\)\), f\)]
                  \)], "Input", CellTags -> "Cases2"], Cell[BoxData[
                \(TraditionalForm\`\({\(f(a)\), \(f(b)\), \(f(\(c, d\))\)}\)
                  \)], "Output", CellTags -> "Cases2"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Cases2[\(\(\(\(Sin[x]\)\ \(Sin[\(y - z\)]\)\) + \(g[y]\)\),
                      Sin, g\)]\)], "Input", CellTags -> "Cases2"], 
              Cell[BoxData[
                \(TraditionalForm\`\({\(g(y)\), \(sin(x)\), 
                      \(sin(\(y - z\))\)}\)\)], "Output", CellTags -> 
                "Cases2"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Cases2[\(\(\(\(Sin[x]\)\ \(Sin[\(y - z\)]\)\) + \(g[x]\) + 
                       \(g[\(a, b, c\)]\)\), \({Sin, g}\)\)]\)], "Input", 
               CellTags -> "Cases2"], Cell[BoxData[
                \(TraditionalForm\`\({\(g(x)\), \(g(\(a, b, c\))\), 
                      \(sin(x)\), \(sin(\(y - z\))\)}\)\)], "Output", 
               CellTags -> "Cases2"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(Cases2[\(\(\(\(DiracSlash[p]\) . \(DiracSlash[q]\)\) + 
                       \(ScalarProduct[\(p, p\)]\)\), Dot\)]\)], "Input", 
               CellTags -> "Cases2"], Cell[BoxData[FormBox[RowBox[
                  {"{", RowBox[{RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                       RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                         "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                       ")"}]}], "}"}], TraditionalForm]], "Output", 
               CellTags -> "Cases2"]}, Open]]}, Open]], 
        Cell["CF", "ObjectName", CellTags -> "CF"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CF"], Cell[TextData[
             {"CF is one of the Casimir operator eigenvalues of SU(", 
              StyleBox["N", Rule[FontSlant, "Italic"]], ") (CF = (", 
              Cell[BoxData[\(TraditionalForm\`\(N\^2\)\)]], "-1)/(2 ", 
              StyleBox["N", Rule[FontSlant, "Italic"]], "))."}], "Text", 
            CellTags -> "CF"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["CA", RuleDelayed[ButtonData, "CA"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "CA"]], 
              ", ", 
              ButtonBox["SUNSimplify", RuleDelayed[ButtonData, 
                 "SUNSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SUNSimplify"]], "."}], "Text", 
            CellTags -> "CF"]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "CF"], 
           Cell[CellGroupData[{Cell[BoxData["CF"], "Input", CellTags -> 
                "CF"], Cell[BoxData[\(TraditionalForm\`C\_F\)], "Output", 
               CellTags -> "CF"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(SUNSimplify[\(CF,\ \(SUNNToCACF \[Rule] False\)\)]\)], 
               "Input", CellTags -> "CF"], Cell[BoxData[
                \(TraditionalForm\`\(\(N\^2 - 1\)\/\(2\ N\)\)\)], "Output", 
               CellTags -> "CF"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%//InputForm\)], "Input"], Cell["(-1 + SUNN^2)/(2*SUNN)", 
               "Output"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData["SUNN"], "Input", CellTags -> "CF"], Cell[BoxData[
                \(TraditionalForm\`N\)], "Output", CellTags -> "CF"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(SUNSimplify[\(\(\(SUNN^2\) - 1\),\ 
                     \(SUNNToCACF\ \[Rule] True\)\)]\)], "Input", CellTags -> 
                "CF"], Cell[BoxData[\(TraditionalForm\`\(2\ C\_A\ C\_F\)\)], 
               "Output", CellTags -> "CF"]}, Open]]}, Open]], 
        Cell["ChangeDimension", "ObjectName", CellTags -> "ChangeDimension"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "ChangeDimension"], Cell["ChangeDimension[exp, dim] \
changes all LorentzIndex and Momenta in exp to dimension dim (and also \
Levi-Civita-tensors, Dirac slashes and Dirac matrices).", "Text", 
            CellTags -> "ChangeDimension"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["LorentzIndex", 
                RuleDelayed[ButtonData, "LorentzIndex"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LorentzIndex"]], ", ", 
              ButtonBox["Momentum", RuleDelayed[ButtonData, "Momentum"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Momentum"]], ", ", 
              ButtonBox["DiracGamma", RuleDelayed[ButtonData, "DiracGamma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGamma"]], ", ", 
              ButtonBox["Eps", RuleDelayed[ButtonData, "Eps"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Eps"]], 
              "."}], "Text", CellTags -> "ChangeDimension"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ChangeDimension"], Cell["Remember that \
LorentzIndex[mu, 4] is simplified to LorentzIndex[mu] and Momentum[p, 4] to \
Momentum[p]. Thus the fullowing objects are defined in four dimensions.", 
            "Text", CellTags -> "ChangeDimension"], 
           Cell[CellGroupData[{Cell[BoxData[
                \({\(LorentzIndex[\[Mu]]\),\ \(Momentum[p]\)}\)], "Input", 
               CellTags -> "ChangeDimension"], Cell[BoxData[FormBox[
                 RowBox[{"{", RowBox[{FormBox["\[Mu]", "TraditionalForm"], 
                     ",", "p"}], "}"}], TraditionalForm]], "Output", 
               CellTags -> "ChangeDimension"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(ChangeDimension[\(%,\ D\)]\)], 
               "Input", CellTags -> "ChangeDimension"], Cell[BoxData[
                FormBox[RowBox[{"{", RowBox[{FormBox["\[Mu]", 
                      "TraditionalForm"], ",", "p"}], "}"}], 
                 TraditionalForm]], "Output", CellTags -> 
                "ChangeDimension"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%//StandardForm\)], "Input", CellTags -> 
                "ChangeDimension"], Cell[BoxData[
                \({\(LorentzIndex[\(\[Mu], D\)]\), \(Momentum[\(p, D\)]\)}\)]\
, "Output", CellTags -> "ChangeDimension"]}, Open]], 
           Cell["This changes all non-4-dimensional objects to 4-dimensional \
ones.", "Text", CellTags -> "ChangeDimension"], Cell[CellGroupData[
             {Cell[BoxData[
                \(\(ChangeDimension[\(%%,\ 4\)]\)\ //\ StandardForm\)], 
               "Input", CellTags -> "ChangeDimension"], Cell[BoxData[
                \({\(LorentzIndex[\[Mu]]\), \(Momentum[p]\)}\)], "Output", 
               CellTags -> "ChangeDimension"]}, Open]], 
           Cell[
            "Consider the following list of 4- and D-dimensional object.", 
            "Text", CellTags -> "ChangeDimension"], 
           Cell[CellGroupData[{Cell[BoxData[
                \({\(\(GA[\(\[Mu], \[Nu]\)]\)\ \(MT[\(\[Mu], \[Nu]\)]\)\),\ 
                    \(\(GAD[\(\[Mu], \[Nu]\)]\)\ \(MTD[\(\[Mu], \[Nu]\)]\)\ 
                      \(f[D]\)\)}\)], "Input", CellTags -> 
                "ChangeDimension"], Cell[BoxData[
                \(TraditionalForm\`\({\(\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu]\)
                        \ g\^\(\[Mu]\[Nu]\)\), 
                      \(\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu]\)\ \(f(D)\)\ 
                        g\^\(\[Mu]\[Nu]\)\)}\)\)], "Output", CellTags -> 
                "ChangeDimension"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrick[\(Contract[%]\)]\)], "Input", CellTags -> 
                "ChangeDimension"], Cell[BoxData[
                \(TraditionalForm\`\({4, \(D\ \(f(D)\)\)}\)\)], "Output", 
               CellTags -> "ChangeDimension"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrick[\(Contract[\(ChangeDimension[\(%%, n\)]\)]\)]\)]\
, "Input", CellTags -> "ChangeDimension"], Cell[BoxData[
                \(TraditionalForm\`\({n, \(n\ \(f(D)\)\)}\)\)], "Output", 
               CellTags -> "ChangeDimension"]}, Open]], Cell["Any explicit \
occurence of D (like in f(D)) is not replaced by ChangeDimension.", "Text", 
            CellTags -> "ChangeDimension"], Cell[BoxData[
             \(\(SetOptions[\(LeviCivita, \(Dimension \[Rule] D\)\)]\) ;\)], 
            "Input", CellTags -> "ChangeDimension"], Cell["The option \
Dimension of Eps must be changed too, since with the default setting \
Dimension\[Rule]4 the arguments of Eps are automatically changed to 4 \
dimensions.", "Text", CellTags -> "ChangeDimension"], Cell[BoxData[
             \(\(SetOptions[\(Eps, \(Dimension \[Rule] D\)\)]\) ;\)], 
            "Input", CellTags -> "ChangeDimension"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(a1\ =\ \(LeviCivita[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\)\)]\
, "Input", CellTags -> "ChangeDimension"], Cell[BoxData[FormBox[
                 SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                      "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     FormBox["\[Sigma]", "TraditionalForm"], 
                     "TraditionalForm"]}]], TraditionalForm]], "Output", 
               CellTags -> "ChangeDimension"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(a2\ =\ \(ChangeDimension[\(a1, 4\)]\)\)], "Input", 
               CellTags -> "ChangeDimension"], Cell[BoxData[FormBox[
                 SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                      "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     FormBox["\[Sigma]", "TraditionalForm"], 
                     "TraditionalForm"]}]], TraditionalForm]], "Output", 
               CellTags -> "ChangeDimension"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Factor2[\(Contract[\(a1\^2\)]\)]\)], "Input", CellTags -> 
                "ChangeDimension"], Cell[BoxData[
                \(TraditionalForm\`\(\((1 - D)\)\ \((2 - D)\)\ \((3 - D)\)\ D
                    \)\)], "Output", CellTags -> "ChangeDimension"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Contract[\(a2\^2\)]\)], 
               "Input", CellTags -> "ChangeDimension"], Cell[BoxData[
                \(TraditionalForm\`\(-24\)\)], "Output", CellTags -> 
                "ChangeDimension"]}, Open]], Cell[BoxData[
             \(\(SetOptions[\(Eps, \(Dimension \[Rule] 4\)\)]\) ;\)], 
            "Input", CellTags -> "ChangeDimension"], Cell[BoxData[
             \(\(Clear[\(a1, a2\)]\) ;\)], "Input", CellTags -> 
             "ChangeDimension"]}, Open]], Cell["ChargeConjugationMatrix", 
         "ObjectName", CellTags -> "ChargeConjugationMatrix"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "ChargeConjugationMatrix"], 
           Cell[TextData[
             {"ChargeConjugationMatrix denotes the charge conjugation matrix \
", StyleBox["C", Rule[FontSlant, "Italic"]], "."}], "Text", 
            CellTags -> "ChargeConjugationMatrix"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["ChargeConjugationMatrixInv", 
                RuleDelayed[ButtonData, "ChargeConjugationMatrixInv"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ChargeConjugationMatrixInv"]], "."}], 
            "Text", CellTags -> "ChargeConjugationMatrix"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ChargeConjugationMatrix"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(ChargeConjugationMatrix . \(DiracMatrix[\[Mu]]\) . 
                   ChargeConjugationMatrixInv\)], "Input", CellTags -> 
                "ChargeConjugationMatrix"], Cell[BoxData[FormBox[
                 RowBox[{"C", ".", SuperscriptBox["\[Gamma]", FormBox[
                     FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", \((\(-C\))\)}], 
                 TraditionalForm]], "Output", CellTags -> 
                "ChargeConjugationMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Calc[%]\)], "Input", 
               CellTags -> "ChargeConjugationMatrix"], Cell[BoxData[
                FormBox[RowBox[{"-", SubsuperscriptBox["\[Gamma]", FormBox[
                     FormBox["\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                    "T"]}], TraditionalForm]], "Output", CellTags -> 
                "ChargeConjugationMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(ChargeConjugationMatrix . \(DiracGamma[5]\) . 
                   ChargeConjugationMatrixInv\)], "Input", CellTags -> 
                "ChargeConjugationMatrix"], Cell[BoxData[
                \(TraditionalForm\`\(C . \[Gamma]\^5 . \((\(-C\))\)\)\)], 
               "Output", CellTags -> "ChargeConjugationMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Calc[%]\)], "Input", 
               CellTags -> "ChargeConjugationMatrix"], Cell[BoxData[
                FormBox[SubsuperscriptBox["\[Gamma]", FormBox["5", 
                   "TraditionalForm"], "T"], TraditionalForm]], "Output", 
               CellTags -> "ChargeConjugationMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(ChargeConjugationMatrix^2\)], 
               "Input", CellTags -> "ChargeConjugationMatrix"], Cell[BoxData[
                \(TraditionalForm\`\(-1\)\)], "Output", CellTags -> 
                "ChargeConjugationMatrix"]}, Open]]}, Open]], 
        Cell["ChargeConjugationMatrixInv", "ObjectName", 
         CellTags -> "ChargeConjugationMatrixInv"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "ChargeConjugationMatrixInv"], Cell["ChargeConjugatio\
nMatrixInv is the inverse of ChargeConjugationMatrix. It is substituted \
immediately by -ChargeConjugationMatrix.", "Text", CellTags -> 
             "ChargeConjugationMatrixInv"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["ChargeConjugationMatrix", 
                RuleDelayed[ButtonData, "ChargeConjugationMatrix"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ChargeConjugationMatrix"]], "."}], "Text", 
            CellTags -> "ChargeConjugationMatrixInv"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ChargeConjugationMatrixInv"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(ChargeConjugationMatrix . \(DiracMatrix[\[Mu]]\) . 
                   ChargeConjugationMatrixInv\)], "Input", CellTags -> 
                "ChargeConjugationMatrixInv"], Cell[BoxData[FormBox[
                 RowBox[{"C", ".", SuperscriptBox["\[Gamma]", FormBox[
                     FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", \((\(-C\))\)}], 
                 TraditionalForm]], "Output", CellTags -> 
                "ChargeConjugationMatrixInv"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Calc[%]\)], "Input", 
               CellTags -> "ChargeConjugationMatrixInv"], Cell[BoxData[
                FormBox[RowBox[{"-", SubsuperscriptBox["\[Gamma]", FormBox[
                     FormBox["\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                    "T"]}], TraditionalForm]], "Output", CellTags -> 
                "ChargeConjugationMatrixInv"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(ChargeConjugationMatrix . \(DiracGamma[5]\) . 
                   ChargeConjugationMatrixInv\)], "Input", CellTags -> 
                "ChargeConjugationMatrixInv"], Cell[BoxData[
                \(TraditionalForm\`\(C . \[Gamma]\^5 . \((\(-C\))\)\)\)], 
               "Output", CellTags -> "ChargeConjugationMatrixInv"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Calc[%]\)], "Input", 
               CellTags -> "ChargeConjugationMatrixInv"], Cell[BoxData[
                FormBox[SubsuperscriptBox["\[Gamma]", FormBox["5", 
                   "TraditionalForm"], "T"], TraditionalForm]], "Output", 
               CellTags -> "ChargeConjugationMatrixInv"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(ChargeConjugationMatrix . ChargeConjugationMatrixInv\)], 
               "Input", CellTags -> "ChargeConjugationMatrixInv"], 
              Cell[BoxData[\(TraditionalForm\`\(C . \((\(-C\))\)\)\)], 
               "Output", CellTags -> "ChargeConjugationMatrixInv"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//Calc\)], "Input", 
               CellTags -> "ChargeConjugationMatrixInv"], Cell[BoxData[
                \(TraditionalForm\`\(-\(C . C\)\)\)], "Output", CellTags -> 
                "ChargeConjugationMatrixInv"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(ChargeConjugationMatrixInv^2\)]
                , "Input", CellTags -> "ChargeConjugationMatrixInv"], 
              Cell[BoxData[\(TraditionalForm\`\(-1\)\)], "Output", 
               CellTags -> "ChargeConjugationMatrixInv"]}, Open]]}, Open]], 
        Cell["CheckContext", "ObjectName", CellTags -> "CheckContext"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CheckContext"], Cell["CheckContext[string] yields \
True if the packaged associated with string is already loaded, and False \
otherwise.", "Text", CellTags -> "CheckContext"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["MakeContext", RuleDelayed[ButtonData, 
                 "MakeContext"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "MakeContext"]], ", ", 
              ButtonBox["$FeynCalcStuff", 
                RuleDelayed[ButtonData, "$FeynCalcStuff"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "$FeynCalcStuff"]], "."}], "Text", 
            CellTags -> "CheckContext"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "CheckContext"], Cell["If a FeynCalc symbol has not \
been used, the corresponding subpackage has not been loaded:", "Text", 
            CellTags -> "CheckContext"], Cell[CellGroupData[{Cell[BoxData[
                \(CheckContext["CompleteSquare"]\)], "Input", CellTags -> 
                "CheckContext"], Cell[BoxData[\(TraditionalForm\`False\)], 
               "Output", CellTags -> "CheckContext"]}, Open]], 
           Cell["Using it makes FeynCalc load the subpackage:", "Text", 
            CellTags -> "CheckContext"], Cell[CellGroupData[
             {Cell[BoxData["CompleteSquare"], "Input", CellTags -> 
                "CheckContext"], Cell[BoxData[
                \(TraditionalForm\`CompleteSquare\)], "Output", CellTags -> 
                "CheckContext"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(CheckContext["CompleteSquare"]\)], "Input", CellTags -> 
                "CheckContext"], Cell[BoxData[\(TraditionalForm\`True\)], 
               "Output", CellTags -> "CheckContext"]}, Open]]}, Open]], 
        Cell["CheckDB", "ObjectName", CellTags -> "CheckDB"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            GeneratedCell -> True, CellAutoOverwrite -> True, 
            CellTags -> "CheckDB"], Cell["CheckDB[exp, fil] saves [with Put] \
or retrieves [with Get] exp from a file fil. It checks if the setting of the \
option Directory is a valid directory name and if fil is a valid file name \
and does exist. If it does, Get[fil] is executed. If fil does not exist, exp \
gets evaluated and saved to  fil. Saving and evaluating can be further \
controlled with the options ForceSave and NoSave. If the option Check is set \
to False  the return value is what is evaluated [see above]. If Check is set \
to True the return value is True or False depending on whether the evaluation \
of exp agrees with what is loaded from fil or fil does not exist.  Default \
value of Check : False.\nNOTICE : If fil ends with \".Gen\" or \".Mod\", the  \
 setting of Directory is ignored and fil is  saved in the \"CouplingVectors\" \
 subdirectory of \"Phi\". If fil ends with  \".Fac\", the setting of \
Directory is  ignored and fil is saved in the \"Factors\" subdirectory of \
\"Phi\". If fil is a file   name with full path, the setting of  Directory is \
also ignored.", "Text", CellTags -> "CheckDB"], Cell[CellGroupData[
             {Cell[BoxData[\(Options[CheckDB]\)], "Input", CellTags -> 
                "CheckDB"], Cell[BoxData[
                \(TraditionalForm\`\({\(Directory \[Rule] "C:\\Program \
Files\\Wolfram \
Research\\Mathematica\\5.2\\AddOns\\Applications\\HighEnergy\
Physics\\Phi\\Storage"\), \(ForceSave \[Rule] False\), 
                      \(NoSave \[Rule] False\), \(Check \[Rule] False\)}\)\)]\
, "Output", CellTags -> "CheckDB"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Attributes[CheckDB]\)], "Input", CellTags -> "CheckDB"], 
              Cell[BoxData[\(TraditionalForm\`\({HoldFirst}\)\)], "Output", 
               CellTags -> "CheckDB"]}, Open]], Cell["The first time the \
Table function is evaluated and the result saved into the test.s file.", 
            "Text", CellTags -> "CheckDB"], Cell[CellGroupData[{Cell[BoxData[
                \(CheckDB[\(\(Table[\(\(\(WriteString[\("stdout", "test "\)]
                            \) ; i\), \({i, 2}\)\)]\), "test.s"\)]\)], 
               "Input", CellTags -> "CheckDB"], Cell["test test ", "Print", 
               CellTags -> "CheckDB"], Cell[BoxData[
                \(TraditionalForm\`\({1, 2}\)\)], "Output", CellTags -> 
                "CheckDB"]}, Open]], Cell["Executing the same a second time \
will just load the result from test.s and not evaluate the Table function.", 
            "Text", CellTags -> "CheckDB"], Cell[CellGroupData[{Cell[BoxData[
                \(CheckDB[\(\(Table[\(\(\(WriteString[\("stdout", "test "\)]
                            \) ; i\), \({i, 2}\)\)]\), "test.s"\)]\)], 
               "Input", CellTags -> "CheckDB"], Cell[BoxData[
                \(TraditionalForm\`\({1, 2}\)\)], "Output", CellTags -> 
                "CheckDB"]}, Open]], 
           Cell["This shows the actual saved value of test.s.", "Text", 
            CellTags -> "CheckDB"], Cell[CellGroupData[{Cell[BoxData[
                \(Import[\(\(ToFileName[\(
                        \(Directory/.\(Options[CheckDB]\)\), "test.s"\)]\),\
 "Text"\)]\)], "Input", CellTags -> "CheckDB"], Cell[BoxData[
                \(TraditionalForm\`"{1, 2}\n"\)], "Output", CellTags -> 
                "CheckDB"]}, Open]], Cell[BoxData[
             \(DeleteFile[\(ToFileName[
                  \(\(Directory/.\(Options[CheckDB]\)\), "test.s"\)]\)]\)], 
            "Input", CellTags -> "CheckDB"]}, Open]], 
        Cell["ChiralityProjector", "ObjectName", CellTags -> 
          "ChiralityProjector"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "ChiralityProjector"], Cell[TextData[
             {"ChiralityProjector[+1] denotes ", Cell[BoxData[
                \(TraditionalForm\`\(\(1/2\) \((1 + \[Gamma]\^5)\)\)\)]], 
              ". ChiralityProjector[-1] denotes ", Cell[BoxData[
                \(TraditionalForm\`\(\(1/2\) \((1 + \[Gamma]\^5)\)\)\)]], 
              "."}], "Text", CellTags -> "ChiralityProjector"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracGamma", RuleDelayed[ButtonData, "DiracGamma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGamma"]], ", ", 
              ButtonBox["DiracMatrix", RuleDelayed[ButtonData, 
                 "DiracMatrix"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracMatrix"]], ", ", 
              ButtonBox["FCI", RuleDelayed[ButtonData, "FCI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCI"]], 
              "."}], "Text", CellTags -> "ChiralityProjector"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ChiralityProjector"], Cell[CellGroupData[
             {Cell[BoxData[
                \({\(ChiralityProjector[\(+1\)]\), 
                    \(ChiralityProjector[\(-1\)]\)}\)], "Input", CellTags -> 
                "ChiralityProjector"], Cell[BoxData[
                \(TraditionalForm\`\({\[Gamma]\^6, \[Gamma]\^7}\)\)], 
               "Output", CellTags -> "ChiralityProjector"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(StandardForm[%]\)], "Input"], 
              Cell[BoxData[\({\(DiracGamma[6]\), \(DiracGamma[7]\)}\)], 
               "Output"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracSimplify[\(%%, \(DiracSubstitute67 \[Rule] True\)\)]\)]\
, "Input", CellTags -> "ChiralityProjector"], Cell[BoxData[
                \(TraditionalForm\`\({\(\[Gamma]\^5\/2 + 1\/2\), 
                      \(1\/2 - \[Gamma]\^5\/2\)}\)\)], "Output", CellTags -> 
                "ChiralityProjector"]}, Open]]}, Open]], 
        Cell["Chisholm", "ObjectName", CellTags -> "Chisholm"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Chisholm"], Cell["Chisholm[x] substitutes products \
of three Dirac matrices or slashes by the Chisholm identity.", "Text", 
            CellTags -> "Chisholm"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["EpsChisholm", RuleDelayed[ButtonData, 
                 "EpsChisholm"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "EpsChisholm"]], ", ", 
              ButtonBox["ChisholmSpinor", 
                RuleDelayed[ButtonData, "ChisholmSpinor"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ChisholmSpinor"]], "."}], "Text", 
            CellTags -> "Chisholm"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Chisholm"], Cell[CellGroupData[{Cell[BoxData[
                \(Chisholm[\(GA[\(\[Alpha], \[Beta], \[Mu], \[Nu]\)]\)]\)], 
               "Input", CellTags -> "Chisholm"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{\(-\[ImaginaryI]\), " ", RowBox[
                      {SuperscriptBox["\[Gamma]", FormBox[FormBox["$MU$111", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Beta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["$MU$111", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "+", 
                   RowBox[{RowBox[{SuperscriptBox["\[Gamma]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Alpha]\[Beta]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Beta]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]]}], 
                     " ", \(g\^\(\[Alpha]\[Mu]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Alpha]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Beta]\[Mu]\)\)}]
                     }], TraditionalForm]], "Output", CellTags -> 
                "Chisholm"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t1 = \(DiracMatrix[\(\[Mu], \[Nu], \[Rho]\)]\)\)], "Input", 
               CellTags -> "Chisholm"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] \[Gamma]\^\[Nu] 
                     \[Gamma]\^\[Rho]\)\)], "Output", CellTags -> 
                "Chisholm"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t2\ = \(Chisholm[t1]\)\)], "Input", CellTags -> 
                "Chisholm"], Cell[BoxData[FormBox[RowBox[{RowBox[
                    {"\[ImaginaryI]", " ", RowBox[{SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["$MU$132", "TraditionalForm"], 
                         "TraditionalForm"]], ".", \(\[Gamma]\^5\)}], " ", 
                     SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["$MU$132", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Rho]", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     \(g\^\(\[Mu]\[Nu]\)\)}], "-", RowBox[{SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     \(g\^\(\[Mu]\[Rho]\)\)}], "+", RowBox[{SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     \(g\^\(\[Nu]\[Rho]\)\)}]}], TraditionalForm]], "Output", 
               CellTags -> "Chisholm"]}, Open]], 
           Cell["The $MU$ variables are unique indices.", "Text", 
            CellTags -> "Chisholm"], Cell[CellGroupData[{Cell[BoxData[
                \(Calc[\(t1 . t1\)]\)], "Input", CellTags -> "Chisholm"], 
              Cell[BoxData[\(TraditionalForm\`16\)], "Output", CellTags -> 
                "Chisholm"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t3\ = \(Chisholm[t1]\)\)], "Input", CellTags -> 
                "Chisholm"], Cell[BoxData[FormBox[RowBox[{RowBox[
                    {"\[ImaginaryI]", " ", RowBox[{SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["$MU$151", "TraditionalForm"], 
                         "TraditionalForm"]], ".", \(\[Gamma]\^5\)}], " ", 
                     SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["$MU$151", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Rho]", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     \(g\^\(\[Mu]\[Nu]\)\)}], "-", RowBox[{SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     \(g\^\(\[Mu]\[Rho]\)\)}], "+", RowBox[{SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     \(g\^\(\[Nu]\[Rho]\)\)}]}], TraditionalForm]], "Output", 
               CellTags -> "Chisholm"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Calc[\(t2 . t3\)]\)], "Input", CellTags -> 
                "Chisholm"], Cell[BoxData[\(TraditionalForm\`16\)], "Output", 
               CellTags -> "Chisholm"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(t4 = \(DiracSlash[\(a, b, c\)]\)\)], "Input", 
               CellTags -> "Chisholm"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["a", 
                        "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                     RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["b", "TraditionalForm"]}], 
                     ")"}], ".", RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["c", 
                        "TraditionalForm"]}], ")"}]}], TraditionalForm]], 
               "Output", CellTags -> "Chisholm"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Chisholm[t4]\)], "Input", 
               CellTags -> "Chisholm"], Cell[BoxData[FormBox[RowBox[{RowBox[{
                     \(-\[ImaginaryI]\), " ", RowBox[{SuperscriptBox[
                        "\[Gamma]", FormBox[FormBox["$MU$177", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["$MU$177", "TraditionalForm"], 
                         "TraditionalForm"], FormBox["a", "TraditionalForm"], 
                        FormBox["b", "TraditionalForm"], FormBox["c", 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["c", "TraditionalForm"]}], 
                     " ", RowBox[{FormBox["a", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["b", "TraditionalForm"]}]}], 
                   "-", RowBox[{RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["b", 
                        "TraditionalForm"]}], " ", RowBox[{FormBox["a", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["c", 
                        "TraditionalForm"]}]}], "+", RowBox[{RowBox[
                      {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["a", "TraditionalForm"]}], 
                     " ", RowBox[{FormBox["b", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["c", "TraditionalForm"]}]}]}], 
                 TraditionalForm]], "Output", CellTags -> "Chisholm"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(a1 = \(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma], \[Tau], 
                       \[Kappa]\)]\)\)], "Input", CellTags -> "Chisholm"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^\[Rho] . \[Gamma]\^\[Sigma] . \[Gamma]\^\[Tau]
                      . \[Gamma]\^\[Kappa]\)\)], "Output", CellTags -> 
                "Chisholm"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(a2\ = \(Chisholm[a1]\)\)], "Input", CellTags -> 
                "Chisholm"], Cell[BoxData[FormBox[RowBox[{RowBox[{
                     \(-\[ImaginaryI]\), " ", RowBox[{SuperscriptBox[
                        "\[Gamma]", FormBox[FormBox["\[Tau]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "+", 
                   RowBox[{"\[ImaginaryI]", " ", RowBox[{SuperscriptBox[
                        "\[Gamma]", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Tau]", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "-", 
                   RowBox[{"\[ImaginaryI]", " ", RowBox[{SuperscriptBox[
                        "\[Gamma]", FormBox[FormBox["$MU$208", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Tau]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["$MU$208", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                     \(g\^\(\[Mu]\[Nu]\)\)}], "+", RowBox[{"\[ImaginaryI]", 
                     " ", RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "$MU$219", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", \(\[Gamma]\^5\)}], " ", 
                     SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Tau]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["$MU$219", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", \(g\^\(\[Mu]\[Rho]\)\)}]
                     , "-", RowBox[{"\[ImaginaryI]", " ", RowBox[
                      {SuperscriptBox["\[Gamma]", FormBox[FormBox["$MU$230", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Tau]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["$MU$230", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                     \(g\^\(\[Nu]\[Rho]\)\)}], "+", RowBox[{RowBox[
                      {SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Tau]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Mu]\[Sigma]\)\), " ", \(g\^\(\[Nu]\[Rho]\)\)}], 
                   "-", RowBox[{RowBox[{SuperscriptBox["\[Gamma]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Tau]\)\), 
                     " ", \(g\^\(\[Nu]\[Rho]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Tau]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Rho]\)\), 
                     " ", \(g\^\(\[Nu]\[Sigma]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Rho]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Tau]\)\), 
                     " ", \(g\^\(\[Nu]\[Sigma]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Rho]\)\), 
                     " ", \(g\^\(\[Nu]\[Tau]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Rho]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Sigma]\)\)
                     , " ", \(g\^\(\[Nu]\[Tau]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Tau]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Nu]\)\), 
                     " ", \(g\^\(\[Rho]\[Sigma]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Tau]\)\), 
                     " ", \(g\^\(\[Rho]\[Sigma]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Nu]\[Tau]\)\), 
                     " ", \(g\^\(\[Rho]\[Sigma]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Nu]\)\), 
                     " ", \(g\^\(\[Rho]\[Tau]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Sigma]\)\)
                     , " ", \(g\^\(\[Rho]\[Tau]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Nu]\[Sigma]\)\)
                     , " ", \(g\^\(\[Rho]\[Tau]\)\)}], "-", RowBox[
                    {"\[ImaginaryI]", " ", RowBox[{SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["$MU$186", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", \(\[Gamma]\^5\)}], " ", 
                     SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["$MU$186", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", \(g\^\(\[Sigma]\[Tau]\)\)
                     }], "+", RowBox[{RowBox[{SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Nu]\)\), 
                     " ", \(g\^\(\[Sigma]\[Tau]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Rho]\)\), 
                     " ", \(g\^\(\[Sigma]\[Tau]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Nu]\[Rho]\)\), 
                     " ", \(g\^\(\[Sigma]\[Tau]\)\)}]}], TraditionalForm]], 
               "Output", CellTags -> "Chisholm"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(a3\ = \(Chisholm[a1]\)\)], 
               "Input", CellTags -> "Chisholm"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{\(-\[ImaginaryI]\), " ", RowBox[
                      {SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Tau]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "+", 
                   RowBox[{"\[ImaginaryI]", " ", RowBox[{SuperscriptBox[
                        "\[Gamma]", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Tau]", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "-", 
                   RowBox[{"\[ImaginaryI]", " ", RowBox[{SuperscriptBox[
                        "\[Gamma]", FormBox[FormBox["$MU$290", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Tau]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["$MU$290", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                     \(g\^\(\[Mu]\[Nu]\)\)}], "+", RowBox[{"\[ImaginaryI]", 
                     " ", RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "$MU$301", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", \(\[Gamma]\^5\)}], " ", 
                     SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Tau]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["$MU$301", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", \(g\^\(\[Mu]\[Rho]\)\)}]
                     , "-", RowBox[{"\[ImaginaryI]", " ", RowBox[
                      {SuperscriptBox["\[Gamma]", FormBox[FormBox["$MU$312", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Tau]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["$MU$312", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                     \(g\^\(\[Nu]\[Rho]\)\)}], "+", RowBox[{RowBox[
                      {SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Tau]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Kappa]", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Mu]\[Sigma]\)\), " ", \(g\^\(\[Nu]\[Rho]\)\)}], 
                   "-", RowBox[{RowBox[{SuperscriptBox["\[Gamma]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Tau]\)\), 
                     " ", \(g\^\(\[Nu]\[Rho]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Tau]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Rho]\)\), 
                     " ", \(g\^\(\[Nu]\[Sigma]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Rho]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Tau]\)\), 
                     " ", \(g\^\(\[Nu]\[Sigma]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Rho]\)\), 
                     " ", \(g\^\(\[Nu]\[Tau]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Rho]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Sigma]\)\)
                     , " ", \(g\^\(\[Nu]\[Tau]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Tau]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Nu]\)\), 
                     " ", \(g\^\(\[Rho]\[Sigma]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Tau]\)\), 
                     " ", \(g\^\(\[Rho]\[Sigma]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Nu]\[Tau]\)\), 
                     " ", \(g\^\(\[Rho]\[Sigma]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Nu]\)\), 
                     " ", \(g\^\(\[Rho]\[Tau]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Sigma]\)\)
                     , " ", \(g\^\(\[Rho]\[Tau]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Nu]\[Sigma]\)\)
                     , " ", \(g\^\(\[Rho]\[Tau]\)\)}], "-", RowBox[
                    {"\[ImaginaryI]", " ", RowBox[{SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["$MU$268", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", \(\[Gamma]\^5\)}], " ", 
                     SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["$MU$268", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", \(g\^\(\[Sigma]\[Tau]\)\)
                     }], "+", RowBox[{RowBox[{SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Nu]\)\), 
                     " ", \(g\^\(\[Sigma]\[Tau]\)\)}], "-", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Rho]\)\), 
                     " ", \(g\^\(\[Sigma]\[Tau]\)\)}], "+", RowBox[
                    {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Kappa]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Nu]\[Rho]\)\), 
                     " ", \(g\^\(\[Sigma]\[Tau]\)\)}]}], TraditionalForm]], 
               "Output", CellTags -> "Chisholm"]}, Open]], 
           Cell["Check that both a1.a1 and a2.a3 give the same.", "Text", 
            CellTags -> "Chisholm"], Cell[CellGroupData[{Cell[BoxData[
                \(Calc[\(a1 . a1\)]\)], "Input", CellTags -> "Chisholm"], 
              Cell[BoxData[\(TraditionalForm\`\(-2048\)\)], "Output", 
               CellTags -> "Chisholm"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Calc[\(a2 . a3\)]\)], "Input", CellTags -> 
                "Chisholm"], Cell[BoxData[\(TraditionalForm\`\(-2048\)\)], 
               "Output", CellTags -> "Chisholm"]}, Open]], Cell[BoxData[
             \(Clear[\(t1, t2, t3, t4, a1, a2, a3\)]\)], "Input", 
            CellTags -> "Chisholm"]}, Open]], Cell["ChisholmSpinor", 
         "ObjectName", CellTags -> "ChisholmSpinor"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "ChisholmSpinor"], Cell["ChisholmSpinor[x] uses the \
Chisholm identity on a DiraGamma between spinors. As an optional second \
argument 1 or 2 may be given, indicating that ChisholmSpinor should only act \
on the first resp. second part of a product of spinor chains.", "Text", 
            CellTags -> "ChisholmSpinor"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["EpsChisholm", RuleDelayed[ButtonData, 
                 "EpsChisholm"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "EpsChisholm"]], ", ", 
              ButtonBox["Chisholm", RuleDelayed[ButtonData, "Chisholm"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Chisholm"]], "."}], "Text", 
            CellTags -> "ChisholmSpinor"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ChisholmSpinor"], Cell[CellGroupData[{Cell[BoxData[
                \(\(Spinor[\(p1, m1\)]\) . 
                   \(DiracGamma[\(LorentzIndex[\[Mu]]\)]\) . 
                   \(Spinor[\(p2, m2\)]\)\)], "Input", CellTags -> 
                "ChisholmSpinor"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"\[CurlyPhi]", "(", FormBox[
                      \(\(\*TagBox[StyleBox["\"p\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\), 
                      "TraditionalForm"], ",", "m1", ")"}], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   RowBox[{"\[CurlyPhi]", "(", FormBox[
                      \(\(\*TagBox[StyleBox["\"p\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_2\), 
                      "TraditionalForm"], ",", "m2", ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "ChisholmSpinor"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(%//ChisholmSpinor\)], 
               "Input", CellTags -> "ChisholmSpinor"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"-", FractionBox[RowBox[{"m1", " ", 
                        "m2", " ", RowBox[{RowBox[{"\[CurlyPhi]", "(", 
                          FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], ",", "m1", ")"}], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          RowBox[{"\[CurlyPhi]", "(", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], ",", "m2", ")"}]}]}], 
                      RowBox[{FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2\), 
                         "TraditionalForm"]}]]}], "+", FractionBox[
                    RowBox[{"\[ImaginaryI]", " ", RowBox[{RowBox[
                         {"\[CurlyPhi]", "(", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], ",", "m1", ")"}], ".", 
                        SuperscriptBox["\[Gamma]", FormBox[FormBox["alpha1", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                        \(\[Gamma]\^5\), ".", RowBox[{"\[CurlyPhi]", "(", 
                          FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], ",", "m2", ")"}]}], " ", 
                      SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "alpha1", "TraditionalForm"], "TraditionalForm"], 
                         FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"]}]]}], RowBox[{FormBox[
                       \(\(\*TagBox[StyleBox["\"p\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1\), 
                       "TraditionalForm"], "\[CenterDot]", FormBox[
                       \(\(\*TagBox[StyleBox["\"p\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2\), 
                       "TraditionalForm"]}]], "+", FractionBox[RowBox[
                     {"m2", " ", RowBox[{RowBox[{"\[CurlyPhi]", "(", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], ",", "m1", ")"}], ".", 
                        RowBox[{"\[CurlyPhi]", "(", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], ",", "m2", ")"}]}], " ", 
                      SubsuperscriptBox[
                       TagBox[StyleBox["\"p\"", Rule[FontSlant, "Italic"]], 
                         Function[StyleForm[Slot[1], 
                           Rule[FontSlant, "Italic"]]]], "1", FormBox[
                        FormBox["\[Mu]", "TraditionalForm"], 
                        "TraditionalForm"]]}], RowBox[{FormBox[
                       \(\(\*TagBox[StyleBox["\"p\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1\), 
                       "TraditionalForm"], "\[CenterDot]", FormBox[
                       \(\(\*TagBox[StyleBox["\"p\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2\), 
                       "TraditionalForm"]}]], "+", FractionBox[RowBox[
                     {"m1", " ", RowBox[{RowBox[{"\[CurlyPhi]", "(", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], ",", "m1", ")"}], ".", 
                        RowBox[{"\[CurlyPhi]", "(", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], ",", "m2", ")"}]}], " ", 
                      SubsuperscriptBox[
                       TagBox[StyleBox["\"p\"", Rule[FontSlant, "Italic"]], 
                         Function[StyleForm[Slot[1], 
                           Rule[FontSlant, "Italic"]]]], "2", FormBox[
                        FormBox["\[Mu]", "TraditionalForm"], 
                        "TraditionalForm"]]}], RowBox[{FormBox[
                       \(\(\*TagBox[StyleBox["\"p\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1\), 
                       "TraditionalForm"], "\[CenterDot]", FormBox[
                       \(\(\*TagBox[StyleBox["\"p\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2\), 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "ChisholmSpinor"]}, Open]]}, Open]], 
        Cell["ClearScalarProducts", "ObjectName", CellTags -> 
          "ClearScalarProducts"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "ClearScalarProducts"], Cell["ClearScalarProducts removes all \
user-performed specific settings for ScalarProduct's.", "Text", 
            CellTags -> "ClearScalarProducts"], Cell[TextData[{"See also: ", 
              ButtonBox["ScalarProduct", 
                RuleDelayed[ButtonData, "ScalarProduct"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ScalarProduct"]], ", ", 
              ButtonBox["Pair", RuleDelayed[ButtonData, "Pair"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Pair"]], 
              ", ", 
              ButtonBox["SP", RuleDelayed[ButtonData, "SP"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "SP"]], 
              ", ", 
              ButtonBox["SPD", RuleDelayed[ButtonData, "SPD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "SPD"]], 
              "."}], "Text", CellTags -> "ClearScalarProducts"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ClearScalarProducts"], Cell[CellGroupData[
             {Cell[BoxData[\(\(ScalarProduct[\(p, p\)]\) = \(m^2\)\)], 
               "Input", CellTags -> "ClearScalarProducts"], Cell[BoxData[
                \(TraditionalForm\`\(m\^2\)\)], "Output", CellTags -> 
                "ClearScalarProducts"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Pair[\(\(Momentum[p]\), \(Momentum[p]\)\)]\)], 
               "Input", CellTags -> "ClearScalarProducts"], Cell[BoxData[
                \(TraditionalForm\`\(m\^2\)\)], "Output", CellTags -> 
                "ClearScalarProducts"]}, Open]], 
           Cell[BoxData["ClearScalarProducts"], "Input", CellTags -> 
             "ClearScalarProducts"], Cell[CellGroupData[{Cell[BoxData[
                \(Pair[\(\(Momentum[p]\), \(Momentum[p]\)\)]\)], "Input", 
               CellTags -> "ClearScalarProducts"], Cell[BoxData[
                FormBox[SuperscriptBox[FormBox["p", "TraditionalForm"], "2"], 
                 TraditionalForm]], "Output", CellTags -> 
                "ClearScalarProducts"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(ScalarProduct[\(p, p\)]\)], "Input", CellTags -> 
                "ClearScalarProducts"], Cell[BoxData[FormBox[SuperscriptBox[
                  FormBox["p", "TraditionalForm"], "2"], TraditionalForm]], 
               "Output", CellTags -> "ClearScalarProducts"]}, Open]]}, 
          Open]], Cell["Collecting", "ObjectName", CellTags -> "Collecting"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Collecting"], Cell["Collecting is an option of \
ScalarProductCancel, Series2, TID and related functions. Setting it to True \
will trigger some kind of collecting of the result.", "Text", 
            CellTags -> "Collecting"], Cell[TextData[{"See also:  ", 
              ButtonBox["ScalarProductCancel", 
                RuleDelayed[ButtonData, "ScalarProductCancel"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ScalarProductCancel"]], ", ", 
              ButtonBox["Series2", RuleDelayed[ButtonData, "Series2"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Series2"]]\
, ", ", 
              ButtonBox["TID", RuleDelayed[ButtonData, "TID"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "TID"]], 
              "."}], "Text", CellTags -> "Collecting"], Cell[BoxData[""], 
            "Input"]}, Open]], Cell["Collect2", "ObjectName", 
         CellTags -> "Collect2"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Collect2"], 
           Cell["Collect2[expr, x] collects together terms which are not free \
of any occurrence of x. Collect2[expr, {x1, x2, ...}] (or also Collect2[expr, \
x1, x2, ...]) collects together terms which are not free of any occurrence of \
x1, x2, .... The coefficients are put over a common denominator. If expr is \
expanded before collecting depends on the option Factoring, which may be set \
to Factor, Factor2, or any other function, which is applied to the \
coefficients. If expr is already expanded with respect to x (x1,x2, ...), the \
option Expanding can be set to False.", "Text", CellTags -> "Collect2"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[Collect2]\)], "Input", 
               CellTags -> "Collect2"], Cell[BoxData[
                \(TraditionalForm\`\({\(Denominator \[Rule] False\), 
                      \(Dot \[Rule] False\), \(Expanding \[Rule] True\), 
                      \(Factoring \[Rule] Factor2\), 
                      \(IsolateNames \[Rule] False\)}\)\)], "Output", 
               CellTags -> "Collect2"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Isolate", RuleDelayed[ButtonData, "Isolate"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Isolate"]]\
, "."}], "Text", CellTags -> "Collect2"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Collect2"], Cell[CellGroupData[{Cell[BoxData[
                \(Collect2[\(\(t1 = \(a + \(r\ a\) + \(k\^2\ \(f[a]\)\) - 
                         \(k\ \(f[a]\)\) + x\/2 - y\/w\)\), a\)]\)], "Input", 
               CellTags -> "Collect2"], Cell[BoxData[FormBox[RowBox[{
                   \(a\ \((r + 1)\)\), "+", 
                   \(\(\(w\ x\) - \(2\ y\)\)\/\(2\ w\)\), "-", RowBox[
                    {RowBox[{"(", RowBox[{"1", "-", FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"]}], ")"}], " ", FormBox[
                      TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                        Function[StyleForm[Slot[1], 
                          Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                     " ", \(f(a)\)}]}], TraditionalForm]], "Output", 
               CellTags -> "Collect2"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(Collect2[\(t1, a, \(Factoring \[Rule] False\)\)]\)], 
               "Input", CellTags -> "Collect2"], Cell[BoxData[FormBox[RowBox[{
                   \(a\ \((r + 1)\)\), "+", \(x\/2\), "-", \(y\/w\), "+", 
                   RowBox[{RowBox[{"(", RowBox[{SuperscriptBox[FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "2"], "-", FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"]}], ")"}], " ", \(f(a)\)}]}], 
                 TraditionalForm]], "Output", CellTags -> "Collect2"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Collect2[\(t1, a, \(Factoring \[Rule] Factor\)\)]\)], 
               "Input", CellTags -> "Collect2"], Cell[BoxData[FormBox[RowBox[{
                   \(a\ \((r + 1)\)\), "+", 
                   \(\(\(w\ x\) - \(2\ y\)\)\/\(2\ w\)\), "+", RowBox[
                    {RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", "1"}], ")"}], " ", FormBox[
                      TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                        Function[StyleForm[Slot[1], 
                          Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                     " ", \(f(a)\)}]}], TraditionalForm]], "Output", 
               CellTags -> "Collect2"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(Collect2[\(\(\(2\ a\ \((b - a)\)\ \((h - 1)\)\) - 
                       \(b\^2\ \((\(e\ a\) - c)\)\) + b\^2\), \({a, b}\)\)]\)]\
, "Input", CellTags -> "Collect2"], Cell[BoxData[
                \(TraditionalForm\`\(\(2\ \((1 - h)\)\ a\^2\) - 
                     \(b\^2\ e\ a\) - \(2\ b\ \((1 - h)\)\ a\) + 
                     \(b\^2\ \((c + 1)\)\)\)\)], "Output", CellTags -> 
                "Collect2"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Collect2[\(\(Expand[\(\((a - b - c - d)\)\^5\)]\), a, 
                     \(IsolateNames \[Rule] l\)\)]\)], "Input", CellTags -> 
                "Collect2"], Cell[BoxData[
                \(TraditionalForm\`\(a\^5 - 
                     \(5\ \*TagBox[\(l(1)\), HoldForm]\ a\^4\) + 
                     \(10\ \*TagBox[\(l(1)\), HoldForm]\^2\ a\^3\) - 
                     \(10\ \*TagBox[\(l(1)\), HoldForm]\^3\ a\^2\) + 
                     \(5\ \*TagBox[\(l(1)\), HoldForm]\^4\ a\) - 
                     \*TagBox[\(l(1)\), HoldForm]\^5\)\)], "Output", 
               CellTags -> "Collect2"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(ReleaseHold[%]\)], "Input", CellTags -> 
                "Collect2"], Cell[BoxData[
                \(TraditionalForm\`\(a\^5 - \(5\ \((b + c + d)\)\ a\^4\) + 
                     \(10\ \((b + c + d)\)\^2\ a\^3\) - 
                     \(10\ \((b + c + d)\)\^3\ a\^2\) + 
                     \(5\ \((b + c + d)\)\^4\ a\) - \((b + c + d)\)\^5\)\)], 
               "Output", CellTags -> "Collect2"]}, Open]], Cell[BoxData[
             \(Clear[\(t1, l\)]\)], "Input", CellTags -> "Collect2"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Collect2[\(\(Expand[\(\((a - b - c)\)\^3\)]\), a, 
                     \(Factoring \[Rule] fun\)\)]\)], "Input", CellTags -> 
                "Collect2"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(fun(1)\)\ a\^3\) + 
                     \(\(fun(\(\(\(-3\)\ b\) - \(3\ c\)\))\)\ a\^2\) + 
                     \(\(fun(\(\(3\ b\^2\) + \(6\ c\ b\) + \(3\ c\^2\)\))\)\ 
                       a\) + \(fun(\(\(-b\^3\) - \(3\ c\ b\^2\) - 
                         \(3\ c\^2\ b\) - c\^3\))\)\)\)], "Output", 
               CellTags -> "Collect2"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(%\ /.\ \(fun \[Rule] FactorTerms\)\)], "Input", 
               CellTags -> "Collect2"], Cell[BoxData[
                \(TraditionalForm\`\(a\^3 - \(3\ \((b + c)\)\ a\^2\) + 
                     \(3\ \((b\^2 + \(2\ c\ b\) + c\^2)\)\ a\) - b\^3 - c\^3 
                     - \(3\ b\ c\^2\) - \(3\ b\^2\ c\)\)\)], "Output", 
               CellTags -> "Collect2"]}, Open]]}, Open]], 
        Cell["Collect3", "ObjectName", CellTags -> "Collect3"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Collect3"], Cell[TextData[{"Collect3[expr, {x, y, \
...}] collects terms involving the same powers of monomials ", Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["x", 
                       Rule[FontSlant, "Plain"]]\^
                     \(\(\*StyleBox["n", Rule[FontSlant, "Plain"]]\)\_1\)\)\)]\
], Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["y", 
                       Rule[FontSlant, "Plain"]]\^
                     \(\(\*StyleBox["n", Rule[FontSlant, "Plain"]]\)\_2\)\)\)]\
], " ... An option Factor \[Rule] True/False can be  given, which factors the \
coefficients. The option Head (default Plus) determines the applied function \
to the list of monomials  mulitplied by their coefficients."}], "Text", 
            CellTags -> "Collect3"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[Collect3]\)], "Input", CellTags -> "Collect3"], 
              Cell[BoxData[
                \(TraditionalForm\`\({\(Factoring \[Rule] False\), 
                      \(Head \[Rule] Plus\)}\)\)], "Output", CellTags -> 
                "Collect3"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Collect2", RuleDelayed[ButtonData, "Collect2"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Collect2"]], ", ", 
              ButtonBox["Isolate", RuleDelayed[ButtonData, "Isolate"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Isolate"]]\
, "."}], "Text", CellTags -> "Collect3"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Collect3"], Cell[CellGroupData[{Cell[BoxData[
                \(Collect3[\(\(\(2\ a\ \((b - a)\)\ \((h - 1)\)\) - 
                       \(b\^2\ \((\(e\ a\) - c)\)\) + b\^2\), \({a, b}\)\)]\)]\
, "Input", CellTags -> "Collect3"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(-2\)\ h\ a\^2\) + \(2\ a\^2\) - 
                     \(2\ b\ a\) - \(b\^2\ e\ a\) + \(2\ b\ h\ a\) + b\^2 + 
                     \(b\^2\ c\)\)\)], "Output", CellTags -> "Collect3"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Collect3[\(\(Expand[\(\((a - b - c - d)\)\^5\)]\), \({a}\)
                    \)]\)], "Input", CellTags -> "Collect3"], Cell[BoxData[
                \(TraditionalForm\`\(a\^5 - \(5\ b\ a\^4\) - \(5\ c\ a\^4\) -
                      \(5\ d\ a\^4\) + \(10\ b\^2\ a\^3\) + 
                     \(10\ c\^2\ a\^3\) + \(10\ d\^2\ a\^3\) + 
                     \(20\ b\ c\ a\^3\) + \(20\ b\ d\ a\^3\) + 
                     \(20\ c\ d\ a\^3\) - \(10\ b\^3\ a\^2\) - 
                     \(10\ c\^3\ a\^2\) - \(10\ d\^3\ a\^2\) - 
                     \(30\ b\ c\^2\ a\^2\) - \(30\ b\ d\^2\ a\^2\) - 
                     \(30\ c\ d\^2\ a\^2\) - \(30\ b\^2\ c\ a\^2\) - 
                     \(30\ b\^2\ d\ a\^2\) - \(30\ c\^2\ d\ a\^2\) - 
                     \(60\ b\ c\ d\ a\^2\) + \(5\ b\^4\ a\) + \(5\ c\^4\ a\) 
                     + \(5\ d\^4\ a\) + \(20\ b\ c\^3\ a\) + 
                     \(20\ b\ d\^3\ a\) + \(20\ c\ d\^3\ a\) + 
                     \(30\ b\^2\ c\^2\ a\) + \(30\ b\^2\ d\^2\ a\) + 
                     \(30\ c\^2\ d\^2\ a\) + \(60\ b\ c\ d\^2\ a\) + 
                     \(20\ b\^3\ c\ a\) + \(20\ b\^3\ d\ a\) + 
                     \(20\ c\^3\ d\ a\) + \(60\ b\ c\^2\ d\ a\) + 
                     \(60\ b\^2\ c\ d\ a\) - b\^5 - c\^5 - d\^5 - 
                     \(5\ b\ c\^4\) - \(5\ b\ d\^4\) - \(5\ c\ d\^4\) - 
                     \(10\ b\^2\ c\^3\) - \(10\ b\^2\ d\^3\) - 
                     \(10\ c\^2\ d\^3\) - \(20\ b\ c\ d\^3\) - 
                     \(10\ b\^3\ c\^2\) - \(10\ b\^3\ d\^2\) - 
                     \(10\ c\^3\ d\^2\) - \(30\ b\ c\^2\ d\^2\) - 
                     \(30\ b\^2\ c\ d\^2\) - \(5\ b\^4\ c\) - \(5\ b\^4\ d\) 
                     - \(5\ c\^4\ d\) - \(20\ b\ c\^3\ d\) - 
                     \(30\ b\^2\ c\^2\ d\) - \(20\ b\^3\ c\ d\)\)\)], 
               "Output", CellTags -> "Collect3"]}, Open]]}, Open]], 
        Cell["Combine", "ObjectName", CellTags -> "Combine"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Combine"], Cell["Combine[expr]puts terms in a sum \
over a common denominator,and cancels factors in the result. Combine is \
similar to Together, but accepts the option Expanding and works usually \
better than Together for polynomials involving rationals with sums in the \
denominator.", "Text", CellTags -> "Combine"], Cell[CellGroupData[
             {Cell[BoxData[\(Options[Combine]\)], "Input", CellTags -> 
                "Combine"], Cell[BoxData[
                \(TraditionalForm\`\({Expanding \[Rule] False}\)\)], 
               "Output", CellTags -> "Combine"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Factor2", RuleDelayed[ButtonData, "Factor2"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Factor2"]]\
, "."}], "Text", CellTags -> "Combine"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Combine"], Cell[CellGroupData[{Cell[BoxData[
                \(Combine[\(\(\((a - b)\)\ \((c - d)\)\)\/e + g\)]\)], 
               "Input", CellTags -> "Combine"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(\((a - b)\)\ \((c - d)\)\) + 
                       \(e\ g\)\)\/e\)\)], "Output", CellTags -> "Combine"]}, 
             Open]], Cell["Here the result from Together where the numerator \
is automatically expanded.", "Text", CellTags -> "Combine"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Together[\(\(\((a - b)\)\ \((c - d)\)\)\/e + g\)]\)], 
               "Input", CellTags -> "Combine"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(a\ c\) - \(b\ c\) - \(a\ d\) + 
                       \(b\ d\) + \(e\ g\)\)\/e\)\)], "Output", CellTags -> 
                "Combine"]}, Open]], Cell["If the option Expanding is set to \
True, the result of Combine is the same as Together, but uses a slightly \
different algorithm.", "Text", CellTags -> "Combine"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Combine[\(\(\(\((a - b)\)\ \((c - d)\)\)\/e + g\), 
                     \(Expanding \[Rule] True\)\)]\)], "Input", CellTags -> 
                "Combine"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(a\ c\) - \(b\ c\) - \(a\ d\) + 
                       \(b\ d\) + \(e\ g\)\)\/e\)\)], "Output", CellTags -> 
                "Combine"]}, Open]]}, Open]], Cell["CombineGraphs", 
         "ObjectName", CellTags -> "CombineGraphs"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CombineGraphs"], 
           Cell["CombineGraphs is an option for OneLoopSum.", "Text", 
            CellTags -> "CombineGraphs"], Cell[TextData[{"See also:  ", 
              ButtonBox["OneLoopSum", RuleDelayed[ButtonData, "OneLoopSum"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "OneLoopSum"]], "."}], "Text", 
            CellTags -> "CombineGraphs"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["Commutator", "ObjectName", CellTags -> "Commutator"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Commutator"], Cell["Commutator[x, y] = c defines the \
commutator between the (non-commuting) objects x and y. ", "Text", 
            CellTags -> "Commutator"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["AntiCommutator", 
                RuleDelayed[ButtonData, "AntiCommutator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "AntiCommutator"]], ", ", 
              ButtonBox["CommutatorExplicit", 
                RuleDelayed[ButtonData, "CommutatorExplicit"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "CommutatorExplicit"]], ", ", 
              ButtonBox["DeclareNonCommutative", 
                RuleDelayed[ButtonData, "DeclareNonCommutative"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DeclareNonCommutative"]], ", ", 
              ButtonBox["DotSimplify", RuleDelayed[ButtonData, 
                 "DotSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DotSimplify"]], "."}], "Text", 
            CellTags -> "Commutator"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Commutator"], Cell[BoxData[
             \(DeclareNonCommutative[\(a, b, c, d\)]\)], "Input", 
            CellTags -> "Commutator"], Cell[CellGroupData[{Cell[BoxData[
                \(Commutator[\(a, b\)]\)], "Input", CellTags -> 
                "Commutator"], Cell[BoxData[
                \(TraditionalForm\`\([\[NoBreak]a\[NoBreak], b\[NoBreak]]\)\)]\
, "Output", CellTags -> "Commutator"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(CommutatorExplicit[%]\)], "Input", CellTags -> 
                "Commutator"], Cell[BoxData[
                \(TraditionalForm\`\(\(a . b\) - \(b . a\)\)\)], "Output", 
               CellTags -> "Commutator"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(DotSimplify[\(Commutator[\(\(a + b\), \(c + d\)\)]\)]\)\ 
                  \)], "Input", CellTags -> "Commutator"], Cell[BoxData[
                \(TraditionalForm\`\(\(a . c\) + \(a . d\) + \(b . c\) + 
                     \(b . d\) - \(c . a\) - \(c . b\) - \(d . a\) - 
                     \(d . b\)\)\)], "Output", CellTags -> "Commutator"]}, 
             Open]], Cell[BoxData[\(UnDeclareNonCommutative[\(a, b, c, d\)]\)]
             , "Input", CellTags -> "Commutator"], 
           Cell["Verify the Jacobi identity.", "Text", CellTags -> 
             "Commutator"], Cell[BoxData[
             \(\(\[Chi] = Commutator\) ;\ 
                \(DeclareNonCommutative[\(x, y, z\)]\) ;\)], "Input", 
            CellTags -> "Commutator"], Cell[CellGroupData[{Cell[BoxData[
                \(\(\[Chi][\(x, \(\[Chi][\(y, z\)]\)\)]\) + 
                   \(\[Chi][\(y, \(\[Chi][\(z, x\)]\)\)]\) + 
                   \(\[Chi][\(z, \(\[Chi][\(x, y\)]\)\)]\)\)], "Input", 
               CellTags -> "Commutator"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"[", "\[NoBreak]", "x", "\[NoBreak]", ",", FormBox[
                      \([\[NoBreak]y\[NoBreak], z\[NoBreak]]\), 
                      "TraditionalForm"], "\[NoBreak]", "]"}], "+", 
                   RowBox[{"[", "\[NoBreak]", "y", "\[NoBreak]", ",", FormBox[
                      \([\[NoBreak]z\[NoBreak], x\[NoBreak]]\), 
                      "TraditionalForm"], "\[NoBreak]", "]"}], "+", 
                   RowBox[{"[", "\[NoBreak]", "z", "\[NoBreak]", ",", FormBox[
                      \([\[NoBreak]x\[NoBreak], y\[NoBreak]]\), 
                      "TraditionalForm"], "\[NoBreak]", "]"}]}], 
                 TraditionalForm]], "Output", CellTags -> "Commutator"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(DotSimplify[%]\)], 
               "Input", CellTags -> "Commutator"], Cell[BoxData[
                \(TraditionalForm\`0\)], "Output", CellTags -> 
                "Commutator"]}, Open]], Cell[BoxData[\(Clear[\[Chi]]\)], 
            "Input", CellTags -> "Commutator"], Cell[BoxData[
             \(UnDeclareNonCommutative[\(x, y, z\)]\)], "Input", 
            CellTags -> "Commutator"]}, Open]], Cell["CommutatorExplicit", 
         "ObjectName", CellTags -> "CommutatorExplicit"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CommutatorExplicit"], Cell["CommutatorExplicit[exp] \
substitutes any Commutator and AntiCommutator in exp by their definitions.", 
            "Text", CellTags -> "CommutatorExplicit"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Calc", RuleDelayed[ButtonData, "Calc"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Calc"]], 
              ", ", 
              ButtonBox["DotSimplify", RuleDelayed[ButtonData, 
                 "DotSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DotSimplify"]], "."}], "Text", 
            CellTags -> "CommutatorExplicit"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "CommutatorExplicit"], Cell[BoxData[
             \(DeclareNonCommutative[\(a, b, c, d\)]\)], "Input", 
            CellTags -> "CommutatorExplicit"], Cell[CellGroupData[
             {Cell[BoxData[\(Commutator[\(a, b\)]\)], "Input", CellTags -> 
                "CommutatorExplicit"], Cell[BoxData[
                \(TraditionalForm\`\([\[NoBreak]a\[NoBreak], b\[NoBreak]]\)\)]\
, "Output", CellTags -> "CommutatorExplicit"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(CommutatorExplicit[%]\)], 
               "Input", CellTags -> "CommutatorExplicit"], Cell[BoxData[
                \(TraditionalForm\`\(\(a . b\) - \(b . a\)\)\)], "Output", 
               CellTags -> "CommutatorExplicit"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(AntiCommutator[\(\(a - c\), \(b - d\)\)]\)], "Input", 
               CellTags -> "CommutatorExplicit"], Cell[BoxData[FormBox[
                 RowBox[{"{", FormBox[\(a - c\), "TraditionalForm"], ",", 
                   "\[MediumSpace]", FormBox[\(b - d\), "TraditionalForm"], 
                   "}"}], TraditionalForm]], "Output", CellTags -> 
                "CommutatorExplicit"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(CommutatorExplicit[%]\)], "Input", CellTags -> 
                "CommutatorExplicit"], Cell[BoxData[
                \(TraditionalForm\`\(\(\((a - c)\) . \((b - d)\)\) + 
                     \(\((b - d)\) . \((a - c)\)\)\)\)], "Output", 
               CellTags -> "CommutatorExplicit"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(CommutatorExplicit[%%]\)//DotSimplify\)], "Input", 
               CellTags -> "CommutatorExplicit"], Cell[BoxData[
                \(TraditionalForm\`\(\(a . b\) - \(a . d\) + \(b . a\) - 
                     \(b . c\) - \(c . b\) + \(c . d\) - \(d . a\) + 
                     \(d . c\)\)\)], "Output", CellTags -> 
                "CommutatorExplicit"]}, Open]], Cell[BoxData[
             \(UnDeclareNonCommutative[\(a, b, c, d\)]\)], "Input", 
            CellTags -> "CommutatorExplicit"]}, Open]], 
        Cell["CompleteSquare", "ObjectName", CellTags -> "CompleteSquare"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CompleteSquare"], Cell[TextData[{"Completes the \
square of a second order polynomial in the momentum x. CompleteSquare[", "a", 
              " ", Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["p", 
                       Rule[FontSlant, "Plain"]]\^2\)\)]], "+", "b", " ", 
              "p", "+", "c", ", ", "p", "] \[Rule] -", Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["b", 
                       Rule[FontSlant, "Plain"]]\^2\)\)]], "/(4 ", "a", ")+", 
              "c", "+", "a", " (", "b", "/(2 ", "a", ")+", "x", 
              ")^2. CompleteSquare[", "a", " ", Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["p", 
                       Rule[FontSlant, "Plain"]]\^2\)\)]], "+", "b", " ", 
              "p", "+", "c", ", ", "p", ", ", "q", "] \[Rule] {-", 
              Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["b", 
                       Rule[FontSlant, "Plain"]]\^2\)\)]], "/(4 ", "a", ")+", 
              "c", "+", "a", " ", Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox["q", 
                       Rule[FontSlant, "Plain"]]\^2\)\)]], ", ", "q", 
              "\[Rule]", "b", "/(2 ", "a", ")+", "p", "}."}], "Text", 
            CellTags -> "CompleteSquare"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "CompleteSquare"], Cell[CellGroupData[{Cell[BoxData[
                \(t1 = \(\(5\(SP[\(\(\(2p\) + \(3r\)\), \(p + r\)\)]\)\)//FCI
                    \)\)], "Input"], Cell[BoxData[FormBox[RowBox[{"5", " ", 
                   RowBox[{"(", FormBox[\(p + r\), "TraditionalForm"], ")", 
                     "\[CenterDot]", "(", FormBox[\(\(2\ p\) + \(3\ r\)\), 
                      "TraditionalForm"], ")"}]}], TraditionalForm]], 
               "Output"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t2 = \(CompleteSquare[\(t1, p\)]\)\)], "Input", CellTags -> 
                "CompleteSquare"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"10", " ", RowBox[{"(", TagBox[FormBox[
                         \(p + \(5\ r\)\/4\), "TraditionalForm"], 
                        TraditionalForm, Editable -> True], ")", ".", "(", 
                       TagBox[FormBox[\(p + \(5\ r\)\/4\), 
                         "TraditionalForm"], TraditionalForm, Editable -> 
                         True], ")"}]}], "-", FractionBox[RowBox[{"5", " ", 
                      SuperscriptBox[FormBox["r", "TraditionalForm"], "2"]}], 
                    "8"]}], TraditionalForm]], "Output", CellTags -> 
                "CompleteSquare"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(t1 - t2\)//ScalarProductExpand\)//Expand\)], "Input", 
               CellTags -> "CompleteSquare"], Cell[BoxData[
                \(TraditionalForm\`0\)], "Output", CellTags -> 
                "CompleteSquare"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(CompleteSquare[\(t1, p, q\)]\)], "Input", CellTags -> 
                "CompleteSquare"], Cell[BoxData[FormBox[RowBox[{"{", 
                   RowBox[{RowBox[{RowBox[{"10", " ", SuperscriptBox[FormBox[
                          "q", "TraditionalForm"], "2"]}], "-", FractionBox[
                        RowBox[{"5", " ", SuperscriptBox[FormBox["r", 
                          "TraditionalForm"], "2"]}], "8"]}], ",", 
                     \(q \[Rule] \(p + \(5\ r\)\/4\)\)}], "}"}], 
                 TraditionalForm]], "Output", CellTags -> "CompleteSquare"]}, 
             Open]], Cell[BoxData[\(Clear[\(t1, t2\)]\)], "Input", 
            CellTags -> "CompleteSquare"]}, Open]], Cell["ComplexConjugate", 
         "ObjectName", CellTags -> "ComplexConjugate"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "ComplexConjugate"], Cell["ComplexConjugate[expr] \
complex conjugates expr. It operates on fermion lines, i.e., products of \
Spinor[..] .DiracMatrix[..] . Spinor[..], and changes all occuring \
LorentzIndex[mu] into LorentzIndex[ComplexIndex[mu]]. For taking the spin sum \
(i.e. constructing the traces) use FermionSpinSum. WARNING: In expr should be \
NO explicit I's in denominators!", "Text", CellTags -> "ComplexConjugate"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["ComplexIndex", 
                RuleDelayed[ButtonData, "ComplexIndex"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ComplexIndex"]], ", ", 
              ButtonBox["FermionSpinSum", 
                RuleDelayed[ButtonData, "FermionSpinSum"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FermionSpinSum"]], ", ", 
              ButtonBox["LorentzIndex", 
                RuleDelayed[ButtonData, "LorentzIndex"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LorentzIndex"]], "."}], "Text", 
            CellTags -> "ComplexConjugate"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ComplexConjugate"], Cell[CellGroupData[{Cell[BoxData[
                \(ComplexConjugate[\(MetricTensor[\(\[Mu], \[Nu]\)]\)]\)], 
               "Input", CellTags -> "ComplexConjugate"], Cell[BoxData[
                \(TraditionalForm\`\(g\^\(\[Mu]\[Nu]\)\)\)], "Output", 
               CellTags -> "ComplexConjugate"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(StandardForm[%]\)], "Input", 
               CellTags -> "ComplexConjugate"], Cell[BoxData[
                \(Pair[\(\(LorentzIndex[\[Mu]]\), \(LorentzIndex[\[Nu]]\)\)]
                  \)], "Output", CellTags -> "ComplexConjugate"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(GA[\(\[Mu], \[Nu], 5\)]\)], 
               "Input", CellTags -> "ComplexConjugate"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^5\)\)], "Output", CellTags -> 
                "ComplexConjugate"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(ComplexConjugate[%]\)], "Input", CellTags -> 
                "ComplexConjugate"], Cell[BoxData[FormBox[RowBox[
                  {"-", RowBox[{\(\[Gamma]\^5\), ".", SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"]], ".", 
                     SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"]]}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "ComplexConjugate"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(SUNTrace[\(SUNT[\(a, b, c\)]\)]\)], "Input", 
               CellTags -> "ComplexConjugate"], Cell[BoxData[FormBox[
                 RowBox[{"tr", "(", FormBox[RowBox[{SubscriptBox["T", 
                       FormBox[FormBox["a", "TraditionalForm"], 
                        "TraditionalForm"]], ".", SubscriptBox["T", FormBox[
                        FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                      ".", SubscriptBox["T", FormBox[FormBox["c", 
                         "TraditionalForm"], "TraditionalForm"]]}], 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "ComplexConjugate"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(ComplexConjugate[%]\)], 
               "Input", CellTags -> "ComplexConjugate"], Cell[BoxData[
                FormBox[RowBox[{"tr", "(", FormBox[RowBox[{SubscriptBox["T", 
                       FormBox[FormBox["c", "TraditionalForm"], 
                        "TraditionalForm"]], ".", SubscriptBox["T", FormBox[
                        FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                      ".", SubscriptBox["T", FormBox[FormBox["a", 
                         "TraditionalForm"], "TraditionalForm"]]}], 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "ComplexConjugate"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(ComplexConjugate[\(SUNF[\(a, b, c\)]\)]\)], "Input", 
               CellTags -> "ComplexConjugate"], Cell[BoxData[FormBox[
                 SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["c", "TraditionalForm"], 
                     "TraditionalForm"]}]], TraditionalForm]], "Output", 
               CellTags -> "ComplexConjugate"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(FCE[\(ComplexConjugate[
                       \(MetricTensor[\(\[Mu], \[Nu]\)]\)]\)]\)]\)], "Input", 
               CellTags -> "ComplexConjugate"], Cell[BoxData[
                \(MT[\(\[Mu], \[Nu]\)]\)], "Output", CellTags -> 
                "ComplexConjugate"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(\(SpinorUBar[\(k1, m\)]\) . \(GA[\[Lambda]]\) . 
                   \(SpinorU[\(p1, m\)]\)\)], "Input", CellTags -> 
                "ComplexConjugate"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{FormBox[\("u"\&_\), "TraditionalForm"], "(", 
                     FormBox[
                      \(\(\*TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\), 
                      "TraditionalForm"], ",", "m", ")"}], ".", 
                   \(\[Gamma]\^\[Lambda]\), ".", RowBox[{"u", "(", FormBox[
                      \(\(\*TagBox[StyleBox["\"p\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\), 
                      "TraditionalForm"], ",", "m", ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "ComplexConjugate"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(ComplexConjugate[%]\)], "Input", CellTags -> 
                "ComplexConjugate"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"\[CurlyPhi]", "(", FormBox[
                      \(\(\*TagBox[StyleBox["\"p\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\), 
                      "TraditionalForm"], ",", "m", ")"}], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Lambda]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   RowBox[{"\[CurlyPhi]", "(", FormBox[
                      \(\(\*TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\), 
                      "TraditionalForm"], ",", "m", ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "ComplexConjugate"]}, Open]], Cell["Notice that SpinorUBar \
and SpinorU are only input functions. Internally they are converted to Spinor \
objects.", "Text", CellTags -> "ComplexConjugate"], Cell[BoxData[""], 
            "Input"]}, Open]], Cell["Contract", "ObjectName", 
         CellTags -> "Contract"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Contract"], 
           Cell["Contract[expr] contracts pairs of Lorentz indices of metric \
tensors, four-vectors and (depending on the optionEpsContract) of Levi-Civita \
tensors in expr. For the contraction of Dirac matrices with each other use \
DiracSimplify. Contract[exp1, exp2] contracts (exp1*exp2), where exp1 and \
exp2 may be larger products of sums of metric tensors and 4-vectors. ", 
            "Text", CellTags -> "Contract"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[Contract]\)], "Input", CellTags -> "Contract"], 
              Cell[BoxData[
                \(TraditionalForm\`\({\(Collecting \[Rule] True\), 
                      \(Contract3 \[Rule] True\), 
                      \(EpsContract \[Rule] True\), 
                      \(Expanding \[Rule] True\), \(Factoring \[Rule] False\)
                      , \(FeynCalcInternal \[Rule] True\), 
                      \(MomentumCombine \[Rule] True\), 
                      \(Rename \[Rule] False\), \(Schouten \[Rule] 0\)}\)\)], 
               "Output", CellTags -> "Contract"]}, Open]], 
           Cell["The option setting Contract3 can be set to True resulting in \
a faster algorithm to contract products of tensors.", "Text"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Pair", RuleDelayed[ButtonData, "Pair"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Pair"]], 
              ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["MomentumCombine", 
                RuleDelayed[ButtonData, "MomentumCombine"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "MomentumCombine"]], "."}], "Text", 
            CellTags -> "Contract"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Contract"], Cell[CellGroupData[{Cell[BoxData[
                \(\(MetricTensor[\(\[Mu], \[Nu]\)]\)\ 
                   \(FourVector[\(p, \[Mu]\)]\)\)], "Input", CellTags -> 
                "Contract"], Cell[BoxData[
                \(TraditionalForm\`\(p\_\[Mu]\ g\^\(\[Mu]\[Nu]\)\)\)], 
               "Output", CellTags -> "Contract"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Contract[%]\)], "Input", 
               CellTags -> "Contract"], Cell[BoxData[FormBox[SuperscriptBox[
                  FormBox["p", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                    "TraditionalForm"], "TraditionalForm"]], 
                 TraditionalForm]], "Output", CellTags -> "Contract"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(FourVector[\(p, \[Mu]\)]\) \(DiracMatrix[\[Mu]]\)\)], 
               "Input", CellTags -> "Contract"], Cell[BoxData[FormBox[
                 RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], " ", 
                   \(p\_\[Mu]\)}], TraditionalForm]], "Output", CellTags -> 
                "Contract"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Contract[%]\)], "Input", CellTags -> "Contract"], 
              Cell[BoxData[FormBox[RowBox[{FormBox["\"\[Gamma]\"", 
                    "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                    "TraditionalForm"]}], TraditionalForm]], "Output", 
               CellTags -> "Contract"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(MetricTensor[\(\[Mu], \[Mu]\)]\)], "Input", 
               CellTags -> "Contract"], Cell[BoxData[
                \(TraditionalForm\`\(g\^\(\[Mu]\[Mu]\)\)\)], "Output", 
               CellTags -> "Contract"]}, Open]], 
           Cell["The default dimension for MetricTensor is 4.", "Text", 
            CellTags -> "Contract"], Cell[CellGroupData[{Cell[BoxData[
                \(Contract[%]\)], "Input", CellTags -> "Contract"], 
              Cell[BoxData[\(TraditionalForm\`4\)], "Output", CellTags -> 
                "Contract"]}, Open]], Cell["A short way to enter \
D-dimensional metric tensors is given by MTD. The \".\" as multiplication \
operator is not necessary but just convenient for typesetting.", "Text", 
            CellTags -> "Contract"], Cell[CellGroupData[{Cell[BoxData[
                \(\(MTD[\(\[Mu], \[Nu]\)]\)\ .\ \(MTD[\(\[Mu], \[Nu]\)]\)\)], 
               "Input", CellTags -> "Contract"], Cell[BoxData[
                \(TraditionalForm\`\(g\^\(\[Mu]\[Nu]\) . g\^\(\[Mu]\[Nu]\)\)
                  \)], "Output", CellTags -> "Contract"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Contract[%]\)], "Input", 
               CellTags -> "Contract"], Cell[BoxData[\(TraditionalForm\`D\)], 
               "Output", CellTags -> "Contract"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(MTD[\(\[Mu], \[Nu]\)]\)\ .\ \(MTD[\(\[Mu], \[Nu]\)]\)\)], 
               "Input", CellTags -> "Contract"], Cell[BoxData[
                \(TraditionalForm\`\(g\^\(\[Mu]\[Nu]\) . g\^\(\[Mu]\[Nu]\)\)
                  \)], "Output", CellTags -> "Contract"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(FourVector[\(p, \[Mu]\)]\)\ \(FourVector[\(q, \[Mu]\)]\)
                  \)], "Input", CellTags -> "Contract"], Cell[BoxData[
                \(TraditionalForm\`\(p\_\[Mu]\ q\_\[Mu]\)\)], "Output", 
               CellTags -> "Contract"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Contract[%\ ]\)], "Input", CellTags -> 
                "Contract"], Cell[BoxData[FormBox[RowBox[{FormBox["p", 
                    "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                    "TraditionalForm"]}], TraditionalForm]], "Output", 
               CellTags -> "Contract"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(\(FourVector[\(\(p - q\), \[Mu]\)]\)\ 
                   \(FourVector[\(\(a - b\), \[Mu]\)]\)\)], "Input", 
               CellTags -> "Contract"], Cell[BoxData[FormBox[RowBox[
                  {SubscriptBox[RowBox[{"(", FormBox[
                       TagBox[\(a - b\), HoldForm], "TraditionalForm"], 
                      ")"}], "\[Mu]"], " ", SubscriptBox[RowBox[{"(", FormBox[
                       TagBox[\(p - q\), HoldForm], "TraditionalForm"], 
                      ")"}], "\[Mu]"]}], TraditionalForm]], "Output", 
               CellTags -> "Contract"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Contract[%]\)], "Input", CellTags -> 
                "Contract"], Cell[BoxData[FormBox[RowBox[{RowBox[
                    {FormBox["a", "TraditionalForm"], "\[CenterDot]", 
                     FormBox["p", "TraditionalForm"]}], "-", RowBox[
                    {FormBox["a", "TraditionalForm"], "\[CenterDot]", 
                     FormBox["q", "TraditionalForm"]}], "-", RowBox[
                    {FormBox["b", "TraditionalForm"], "\[CenterDot]", 
                     FormBox["p", "TraditionalForm"]}], "+", RowBox[
                    {FormBox["b", "TraditionalForm"], "\[CenterDot]", 
                     FormBox["q", "TraditionalForm"]}]}], TraditionalForm]], 
               "Output", CellTags -> "Contract"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(LeviCivita[\(\[Mu], \[Nu], \[Alpha], \[Sigma]\)]\)\ 
                   \(FourVector[\(p, \[Sigma]\)]\)\)], "Input", CellTags -> 
                "Contract"], Cell[BoxData[FormBox[RowBox[{SuperscriptBox[
                    "\[Epsilon]", RowBox[{FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Alpha]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"]}]], " ", \(p\_\[Sigma]\)}], 
                 TraditionalForm]], "Output", CellTags -> "Contract"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(Contract[%]\)], 
               "Input", CellTags -> "Contract"], Cell[BoxData[FormBox[
                 SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                      "\[Alpha]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox["p", 
                     "TraditionalForm"]}]], TraditionalForm]], "Output", 
               CellTags -> "Contract"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(\(LeviCivita[\(\[Mu], \[Nu], \[Alpha], \[Beta]\)]\)\ 
                   \(LeviCivita[\(\[Mu], \[Nu], \[Alpha], \[Sigma]\)]\)\ \)], 
               "Input", CellTags -> "Contract"], Cell[BoxData[FormBox[
                 RowBox[{SuperscriptBox["\[Epsilon]", RowBox[{FormBox[
                       FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["\[Alpha]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Beta]", 
                        "TraditionalForm"], "TraditionalForm"]}]], " ", 
                   SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Alpha]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "Contract"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Contract[%]\)], "Input", CellTags -> 
                "Contract"], Cell[BoxData[
                \(TraditionalForm\`\(\(-6\)\ g\^\(\[Beta]\[Sigma]\)\)\)], 
               "Output", CellTags -> "Contract"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(SetOptions[\(Eps, \(Dimension \[Rule] D\)\)]\) ; 
                   \(\(LCD[\(\[Mu], \[Nu], \[Alpha], \[Beta]\)]\)\ 
                     \(LCD[\(\[Mu], \[Nu], \[Alpha], \[Sigma]\)]\)\)\)], 
               "Input", CellTags -> "Contract"], Cell[BoxData[
                \(TraditionalForm\`\(\[Epsilon]\^
                      \(\[Mu]\[Nu]\[Alpha]\[Beta]\)\ 
                     \[Epsilon]\^\(\[Mu]\[Nu]\[Alpha]\[Sigma]\)\)\)], 
               "Output", CellTags -> "Contract"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(\(Contract[%]\)//Factor2\)], 
               "Input", CellTags -> "Contract"], Cell[BoxData[
                \(TraditionalForm\`\(\((1 - D)\)\ \((2 - D)\)\ \((3 - D)\)\ 
                     g\^\(\[Beta]\[Sigma]\)\)\)], "Output", CellTags -> 
                "Contract"]}, Open]], Cell[BoxData[
             \(\(SetOptions[\(Eps, \(Dimension \[Rule] 4\)\)]\) ;\)], 
            "Input", CellTags -> "Contract"]}, Open]], 
        Cell["Contract1", "ObjectName", CellTags -> "Contract1"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Contract1"], Cell["For covariant calculations it is \
not necessary to distinguish between co- and contravariant indices (except \
for the Levi-Civita tensor).\nTherefore normally no distinction is made \
between upper and lower indices.\nHowere, if needed, one can use Upper and \
Lower and then a distuction is made:\nContract1[exp] contracts Upper and \
Lower indices. Neither Upper and Upper nor Lower and Lower indices are \
contracted.", "Text", CellTags -> "Contract1"], Cell[TextData[{"See also:  ", 
              ButtonBox["LorentzIndex", 
                RuleDelayed[ButtonData, "LorentzIndex"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LorentzIndex"]], ", ", 
              ButtonBox["Lower", RuleDelayed[ButtonData, "Lower"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Lower"]], 
              ", ", 
              ButtonBox["Upper", RuleDelayed[ButtonData, "Upper"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Upper"]], 
              "."}], "Text", CellTags -> "Contract1"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Contract1"], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(\(FV[\(p, \(Lower[\[Mu]]\)\)]\) 
                       \(FV[\(q, \(Upper[\[Mu]]\)\)]\)\)//FCI\)//Contract1\)]\
, "Input", CellTags -> "Contract1"], Cell[BoxData[FormBox[RowBox[
                  {FormBox["p", "TraditionalForm"], "\[CenterDot]", 
                   FormBox["q", "TraditionalForm"]}], TraditionalForm]], 
               "Output", CellTags -> "Contract1"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(\(\(FV[\(p, \(Upper[\[Mu]]\)\)]\) 
                       \(FV[\(q, \(Upper[\[Mu]]\)\)]\)\)//FCI\)//Contract1\)]\
, "Input", CellTags -> "Contract1"], Cell[BoxData[FormBox[RowBox[
                  {SuperscriptBox[FormBox["p", "TraditionalForm"], FormBox[
                     FormBox[\(Upper(\[Mu])\), "TraditionalForm"], 
                     "TraditionalForm"]], " ", SuperscriptBox[FormBox["q", 
                     "TraditionalForm"], FormBox[FormBox[\(Upper(\[Mu])\), 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output", CellTags -> "Contract1"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(MT[\(\(Lower[\[Mu]]\), \(Upper[\[Mu]]\)\)]\)//FCI\)//
                   Contract1\)], "Input", CellTags -> "Contract1"], 
              Cell[BoxData[\(TraditionalForm\`4\)], "Output", CellTags -> 
                "Contract1"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(MT[\(\(Upper[\[Mu]]\), \(Upper[\[Mu]]\)\)]\)//FCI\)//
                   Contract1\)], "Input", CellTags -> "Contract1"], 
              Cell[BoxData[FormBox[SuperscriptBox["g", RowBox[{FormBox[
                     \(Upper(\[Mu])\), "TraditionalForm"], FormBox[
                     \(Upper(\[Mu])\), "TraditionalForm"]}]], 
                 TraditionalForm]], "Output", CellTags -> "Contract1"]}, 
             Open]]}, Open]], Cell["Convolute", "ObjectName", 
         CellTags -> "Convolute"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Convolute"], 
           Cell[TextData[{"Convolute[f, g, x] convolutes ", 
              StyleBox["f", Rule[FontSlant, "Italic"]], "(", 
              StyleBox["x", Rule[FontSlant, "Italic"]], ") and ", 
              StyleBox["g", Rule[FontSlant, "Italic"]], "(", 
              StyleBox["x", Rule[FontSlant, "Italic"]], "), i.e., ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\[Integral]\_0\%1 
                     \(\(\*StyleBox[\(\*StyleBox["d", 
                               Rule[FontSlant, "Plain"]]\*
                              StyleBox["x", Rule[FontSlant, "Italic"]]\)]\)\_
                        1\ \(\[Integral]\_0\%1 
                         \(\(\*StyleBox[\(
                                \*StyleBox["d", Rule[FontSlant, "Plain"]]x\)]
                \)\_2\ \(\[Delta](\(x\ -\ \(x\_1\ x\_2\)\))\)\ \(f(x\_1)\)\ 
                           \(\(g(x\_2)\)\ .\)\)\)\)\)\)]], " Convolute[f, g] \
is equivalent to Convolute[f, g, x]. Convolute[exp, {x1, x2}] assumes that \
exp is polynomial in x1 and x2. Convolute uses table-look-up and does not do \
any integral calculations, only linear algebra."}], "Text", 
            CellTags -> "Convolute"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[Convolute]\)], "Input", CellTags -> "Convolute"], 
              Cell[BoxData[
                \(TraditionalForm\`\({\(Bracket \[Rule] 
                        \({\*TagBox["\[CurlyEpsilon]", TraditionalForm]}\)\),
                       \(FinalSubstitutions \[Rule] 
                        \({PlusDistribution \[Rule] Identity}\)\)}\)\)], 
               "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["PlusDistribution", 
                RuleDelayed[ButtonData, "PlusDistribution"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PlusDistribution"]], ", ", 
              ButtonBox["ConvoluteTable", 
                RuleDelayed[ButtonData, "ConvoluteTable"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ConvoluteTable"]], "."}], "Text", 
            CellTags -> "Convolute"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Convolute"], Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1, 1\)]\)], "Input", CellTags -> "Convolute"], 
              Cell[BoxData[\(TraditionalForm\`\(-\(log(x)\)\)\)], "Output", 
               CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Convolute[\(x, x\)]\)], 
               "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(-x\)\ \(log(x)\)\)\)], "Output", 
               CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Convolute[\(1, x\)]\)], 
               "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(1 - x\)\)], "Output", CellTags -> 
                "Convolute"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1, 1\/\(1 - x\)\)]\)], "Input", CellTags -> 
                "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(log(\(1 - x\))\) - \(log(x)\)\)\)], 
               "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1, \(PlusDistribution[\(1\/\(1 - x\)\)]\)\)]\)]\
, "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(log(\(1 - x\))\) - \(log(x)\)\)\)], 
               "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Convolute[\(1\/\(1 - x\), x\)]\)
                ], "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(log(\(1 - x\))\)\ x\) - 
                     \(\(log(x)\)\ x\) - x + 1\)\)], "Output", CellTags -> 
                "Convolute"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1\/\(1 - x\), 1\/\(1 - x\)\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[FormBox[RowBox[{RowBox[{
                     \(-\(\[Zeta](2)\)\), " ", RowBox[{"\[Delta]", "(", 
                       FormBox[\(1 - x\), "TraditionalForm"], ")"}]}], "+", 
                   \(\(2\ \(log(1 - x)\)\)\/\(1 - x\)\), "-", 
                   \(\(log(x)\)\/\(1 - x\)\)}], TraditionalForm]], "Output", 
               CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1, \(Log[\(1 - x\)]\)\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(-\(log(\(1 - x\))\)\)\ \(log(x)\)\) 
                     - \(\(\*InterpretationBox["Li", PolyLog, 
                           Rule[Editable, False], Rule[Selectable, False]]\)\
\_2(\(1 - x\))\)\)\)], "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1, \(x\ \(Log[\(1 - x\)]\)\)\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(x + \(\((1 - x)\)\ \(log(\(1 - x\))\)\) 
                     - 1\)\)], "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1\/\(1 - x\), \(Log[\(1 - x\)]\)\)]\)], 
               "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(log\^2\)(\(1 - x\))\) - 
                     \(\(log(x)\)\ \(log(\(1 - x\))\)\) - \(\[Zeta](2)\)\)\)]\
, "Output", CellTags -> "Convolute"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(Convolute[\(1\/\(1 - x\), \(x\ \(Log[\(1 - x\)]\)\)\)]\)], 
               "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(x\ \(\(log\^2\)(\(1 - x\))\)\) + 
                     \(\((1 - x)\)\ \(log(\(1 - x\))\)\) - 
                     \(x\ \(log(x)\)\ \(log(\(1 - x\))\)\) + x - 
                     \(x\ \(\[Zeta](2)\)\) - 1\)\)], "Output", CellTags -> 
                "Convolute"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(\(Log[\(1 - x\)]\)\/\(1 - x\), x\)]\)], 
               "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(1\/2\ x\ \(\(log\^2\)(\(1 - x\))\)\) +
                      \(\((1 - x)\)\ \(log(\(1 - x\))\)\) - 
                     \(x\ \(log(x)\)\ \(log(\(1 - x\))\)\) + 
                     \(x\ \(log(x)\)\) - 
                     \(x\ \(\(\*InterpretationBox["Li", PolyLog, 
                             Rule[Editable, False], Rule[Selectable, False]]\
\)\_2(\(1 - x\))\)\)\)\)], "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1, \(x\ \(Log[x]\)\)\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(-\(log(x)\)\)\ x\) + x - 1\)\)], 
               "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(\(Log[\(1 - x\)]\), x\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\((1 - x)\)\ \(log(\(1 - x\))\)\) + 
                     \(x\ \(log(x)\)\)\)\)], "Output", CellTags -> 
                "Convolute"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1\/\(1 - x\), \(Log[x]\)\/\(1 - x\)\)]\)], 
               "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(log(\(1 - x\))\)\ \(log(x)\)\)\/
                      \(1 - x\) - \(\(log\^2\)(x)\)\/\(2\ \((1 - x)\)\)\)\)], 
               "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Convolute[\(1, \(Log[x]\)\)]\)]
                , "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(-\(1\/2\)\)\ \(\(log\^2\)(x)\)\)\)], 
               "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(x,\ \(x\ \(Log[x]\)\)\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(-\(1\/2\)\)\ x\ \(\(log\^2\)(x)\)\)\)]\
, "Output", CellTags -> "Convolute"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Convolute[\(1\/\(1 - x\), \(Log[x]\)\)]\)], 
               "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(-\(1\/2\)\)\ \(\(log\^2\)(x)\)\) + 
                     \(\(log(\(1 - x\))\)\ \(log(x)\)\) + 
                     \(\(\*InterpretationBox["Li", PolyLog, 
                           Rule[Editable, False], Rule[Selectable, False]]\)\
\_2(\(1 - x\))\)\)\)], "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1, \(Log[x]\)\/\(1 - x\)\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(-\(1\/2\)\)\ \(\(log\^2\)(x)\)\) - 
                     \(\(\*InterpretationBox["Li", PolyLog, 
                           Rule[Editable, False], Rule[Selectable, False]]\)\
\_2(\(1 - x\))\)\)\)], "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1\/\(1 - x\), \(x\ \(Log[x]\)\)\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(-\(1\/2\)\)\ x\ \(\(log\^2\)(x)\)\) 
                     - \(x\ \(log(x)\)\) + 
                     \(x\ \(log(\(1 - x\))\)\ \(log(x)\)\) + x + 
                     \(x\ \(\(\*InterpretationBox["Li", PolyLog, 
                             Rule[Editable, False], Rule[Selectable, False]]\
\)\_2(\(1 - x\))\)\) - 1\)\)], "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(\(Log[x]\)\/\(1 - x\), x\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(-\(1\/2\)\)\ x\ \(\(log\^2\)(x)\)\) 
                     + \(log(x)\) - x - \(
                      x\ \(\(\*InterpretationBox["Li", PolyLog, 
                             Rule[Editable, False], Rule[Selectable, False]]\
\)\_2(\(1 - x\))\)\) + 1\)\)], "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1, \(x\ \(Log[x]\)\)\)]\)], "Input", 
               CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(-\(log(x)\)\)\ x\) + x - 1\)\)], 
               "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Convolute[\(\(Log[x]\), x\)]\)]
                , "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(-x\) + \(log(x)\) + 1\)\)], "Output", 
               CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(1\/\(1 - x\), \(Log[\(1 - x\)]\)\/\(1 - x\)\)]
                  \)], "Input", CellTags -> "Convolute"], Cell[BoxData[
                FormBox[RowBox[{
                   \(\(3\ \(log\^2(1 - x)\)\)\/\(2\ \((1 - x)\)\)\), "-", 
                   \(\(\(log(x)\)\ \(log(1 - x)\)\)\/\(1 - x\)\), "-", 
                   \(\(\[Zeta](2)\)\/\(1 - x\)\), "+", RowBox[
                    {RowBox[{"\[Delta]", "(", FormBox[\(1 - x\), 
                        "TraditionalForm"], ")"}], " ", 
                     TagBox[\(\[Zeta](\*TagBox["3", Zeta, 
                           Rule[Editable, True]])\), 
                       InterpretTemplate[Function[BoxForm`e$, 
                         Zeta[BoxForm`e$]]]]}]}], TraditionalForm]], 
               "Output", CellTags -> "Convolute"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(\(Log[\(1 - x\)]\)\/\(1 - x\), 
                     \(Log[\(1 - x\)]\)\)]\)], "Input", CellTags -> 
                "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(1\/2\ \(\(log\^3\)(\(1 - x\))\)\) - 
                     \(\(log(x)\)\ \(\(log\^2\)(\(1 - x\))\)\) + 
                     \(\(\(log\^2\)(x)\)\ \(log(\(1 - x\))\)\) - 
                     \(\(\[Zeta](2)\)\ \((\(log(\(1 - x\))\) + \(log(x)\))\)
                      \) + \(\((\(log(x)\) - \(log(\(1 - x\))\))\)\ 
                       \(\(\*InterpretationBox["Li", PolyLog, 
                             Rule[Editable, False], Rule[Selectable, False]]\
\)\_2(\(1 - x\))\)\) + \(
                      \(\*InterpretationBox["Li", PolyLog, 
                           Rule[Editable, False], Rule[Selectable, False]]\)\
\_3(\(1 - x\))\) + \(2\ \(
                        \(\*InterpretationBox["Li", PolyLog, 
                             Rule[Editable, False], Rule[Selectable, False]]\
\)\_3(x)\)\) - \*TagBox[\(
                        \[Zeta](\(\*TagBox["3", Zeta, Rule[Editable, True]]
                          \))\), InterpretTemplate[Function[BoxForm`e$, 
                         Zeta[BoxForm`e$]]]]\)\)], "Output", CellTags -> 
                "Convolute"]}, Open]]}, Open]], Cell["ConvoluteTable ", 
         "ObjectName", CellTags -> "ConvoluteTable"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "ConvoluteTable"], Cell["ConvoluteTable[f, g, x] \
yields the convolution of f and g. ConvoluteTable is called by Convolute.", 
            "Text", CellTags -> "ConvoluteTable"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[Convolute]\)], "Input", 
               CellTags -> "ConvoluteTable"], Cell[BoxData[
                \(TraditionalForm\`\({\(Bracket \[Rule] 
                        \({\*TagBox["\[CurlyEpsilon]", TraditionalForm]}\)\),
                       \(FinalSubstitutions \[Rule] 
                        \({PlusDistribution \[Rule] Identity}\)\)}\)\)], 
               "Output", CellTags -> "ConvoluteTable"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["PlusDistribution", 
                RuleDelayed[ButtonData, "PlusDistribution"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PlusDistribution"]], ", ", 
              ButtonBox["Convolute", RuleDelayed[ButtonData, "Convolute"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Convolute"]], "."}], "Text", 
            CellTags -> "ConvoluteTable"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ConvoluteTable"], Cell[CellGroupData[{Cell[BoxData[
                \(ConvoluteTable[\(1, 1\)]\)], "Input", CellTags -> 
                "ConvoluteTable"], Cell[BoxData[
                \(TraditionalForm\`\(-\(log(x)\)\)\)], "Output", CellTags -> 
                "ConvoluteTable"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(ConvoluteTable[\(x, x\)]\)], "Input", CellTags -> 
                "ConvoluteTable"], Cell[BoxData[
                \(TraditionalForm\`\(\(-x\)\ \(log(x)\)\)\)], "Output", 
               CellTags -> "ConvoluteTable"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(ConvoluteTable[\(1, x\)]\)], 
               "Input", CellTags -> "ConvoluteTable"], Cell[BoxData[
                \(TraditionalForm\`\(1 - x\)\)], "Output", CellTags -> 
                "ConvoluteTable"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(ConvoluteTable[\(\(Log[\(1 - x\)]\)\/\(1 - x\), 1\)]\)], 
               "Input", CellTags -> "Convolute"], Cell[BoxData[
                \(TraditionalForm\`\(\(1\/2\ \(\(log\^2\)(\(1 - x\))\)\) - 
                     \(\(log(x)\)\ \(log(\(1 - x\))\)\) - 
                     \(\(\*InterpretationBox["Li", PolyLog, 
                           Rule[Editable, False], Rule[Selectable, False]]\)\
\_2(\(1 - x\))\)\)\)], "Output", CellTags -> "Convolute"]}, Open]]}, Open]], 
        Cell["CovariantFieldDerivative", "ObjectName", 
         CellTags -> "CovariantFieldDerivative"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CovariantFieldDerivative"], Cell["CovariantFieldDeri\
vative[f[x],x,{li1,li2,...},opts] is a covariant derivative of f[x] with \
respect to space-time variables x and with Lorentz indices li1, li2,... \
CovariantFieldDerivative has only typesetting definitions by default. The \
user is must supply his/her own definition of the actual function.", "Text", 
            CellTags -> "CovariantFieldDerivative"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["CovariantD", RuleDelayed[ButtonData, "CovariantD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "CovariantD"]], ", ", 
              ButtonBox["ExpandPartialD", 
                RuleDelayed[ButtonData, "ExpandPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ExpandPartialD"]], ", ", 
              ButtonBox["FieldDerivative", 
                RuleDelayed[ButtonData, "FieldDerivative"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FieldDerivative"]], "."}], "Text", 
            CellTags -> "CovariantFieldDerivative"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "CovariantFieldDerivative"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(CovariantFieldDerivative[
                   \(\(\(QuantumField[\(A, \({\[Mu]}\)\)]\)[x]\), x, 
                     \({\[Mu]}\)\)]\)], "Input", CellTags -> 
                "CovariantFieldDerivative"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{\(1\/2\), " ", "\[ImaginaryI]", " ", 
                     RowBox[{"(", RowBox[{RowBox[{"(", RowBox[{RowBox[
                          {OverscriptBox[TagBox[FormBox[SubscriptBox[FormBox[
                          SuperscriptBox[
                          TagBox[StyleBox["\"A\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], RowBox[{TagBox[
                          FormBox["", "TraditionalForm"], TraditionalForm, 
                          Editable -> True], TagBox[FormBox["", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]}]], "TraditionalForm"], "\[Mu]"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], TagBox["\"\[Rule]\"", StyleForm]], 
                          "\[CenterDot]", OverscriptBox[TagBox[FormBox[
                          StyleBox[TagBox[StyleBox["\"\[Sigma]\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]], 
                            Rule[SingleLetterItalics, False], 
                            Rule[FontWeight, "Bold"]], "TraditionalForm"], 
                          TraditionalForm, Editable -> True], 
                          TagBox["\"\[Rule]\"", StyleForm]]}], "+", RowBox[
                          {OverscriptBox[TagBox[FormBox[SubscriptBox[FormBox[
                          SuperscriptBox[
                          TagBox[StyleBox["\"V\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], RowBox[{TagBox[
                          FormBox["", "TraditionalForm"], TraditionalForm, 
                          Editable -> True], TagBox[FormBox["", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]}]], "TraditionalForm"], "\[Mu]"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], TagBox["\"\[Rule]\"", StyleForm]], 
                          "\[CenterDot]", OverscriptBox[TagBox[FormBox[
                          StyleBox[TagBox[StyleBox["\"\[Sigma]\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]], 
                            Rule[SingleLetterItalics, False], 
                            Rule[FontWeight, "Bold"]], "TraditionalForm"], 
                          TraditionalForm, Editable -> True], 
                          TagBox["\"\[Rule]\"", StyleForm]]}]}], ")"}], 
                         "\[SixPointedStar]", \(A\_\[Mu]\)}], ")"}]}], "-", 
                   RowBox[{\(1\/2\), " ", "\[ImaginaryI]", " ", RowBox[
                      {"(", RowBox[{\(A\_\[Mu]\), "\[SixPointedStar]", "(", 
                         RowBox[{RowBox[{OverscriptBox[TagBox[FormBox[
                          SubscriptBox[FormBox[SuperscriptBox[
                          TagBox[StyleBox["\"V\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], RowBox[{TagBox[
                          FormBox["", "TraditionalForm"], TraditionalForm, 
                          Editable -> True], TagBox[FormBox["", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]}]], "TraditionalForm"], "\[Mu]"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], TagBox["\"\[Rule]\"", StyleForm]], 
                          "\[CenterDot]", OverscriptBox[TagBox[FormBox[
                          StyleBox[TagBox[StyleBox["\"\[Sigma]\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]], 
                            Rule[SingleLetterItalics, False], 
                            Rule[FontWeight, "Bold"]], "TraditionalForm"], 
                          TraditionalForm, Editable -> True], 
                          TagBox["\"\[Rule]\"", StyleForm]]}], "-", RowBox[
                          {OverscriptBox[TagBox[FormBox[SubscriptBox[FormBox[
                          SuperscriptBox[
                          TagBox[StyleBox["\"A\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], RowBox[{TagBox[
                          FormBox["", "TraditionalForm"], TraditionalForm, 
                          Editable -> True], TagBox[FormBox["", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]}]], "TraditionalForm"], "\[Mu]"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], TagBox["\"\[Rule]\"", StyleForm]], 
                          "\[CenterDot]", OverscriptBox[TagBox[FormBox[
                          StyleBox[TagBox[StyleBox["\"\[Sigma]\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]], 
                            Rule[SingleLetterItalics, False], 
                            Rule[FontWeight, "Bold"]], "TraditionalForm"], 
                          TraditionalForm, Editable -> True], 
                          TagBox["\"\[Rule]\"", StyleForm]]}]}], ")"}], 
                       ")"}]}], "+", RowBox[{SubscriptBox["\[PartialD]", 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                       FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], "\[Null]"]}]}], TraditionalForm]], 
               "Output", CellTags -> "CovariantFieldDerivative"]}, Open]]}, 
          Open]], Cell["CounterT", "ObjectName", CellTags -> "CounterT"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CounterT"], Cell["CounterT is a factor used by \
GluonPropagator and QuarkPropagator when CounterTerms is set to All.", 
            "Text", CellTags -> "CounterT"], Cell[TextData[{"See also: ", 
              " ", 
              ButtonBox["CounterTerm", RuleDelayed[ButtonData, 
                 "CounterTerm"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "CounterTerm"]], ", ", 
              ButtonBox["GluonPropagator", 
                RuleDelayed[ButtonData, "GluonPropagator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "GluonPropagator"]], ", ", 
              ButtonBox["QuarkPropagator", 
                RuleDelayed[ButtonData, "QuarkPropagator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "QuarkPropagator"]], "."}], "Text", 
            CellTags -> "CounterT"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "CounterT"], Cell[CellGroupData[{Cell[BoxData[
                \(GluonPropagator[\(p, \[Mu], a, \[Nu], b, 
                     \(Explicit \[Rule] True\), \(CounterTerm \[Rule]\ All\)\
\)]\)], "Input", CellTags -> "CounterT"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"CounterT", " ", RowBox[{"(", RowBox[{FractionBox[
                          RowBox[{"\[ImaginaryI]", " ", \(C\_A\), " ", 
                          \(S\_n\), " ", RowBox[{"(", RowBox[{FractionBox[
                          RowBox[{"10", " ", SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "3"], "-", RowBox[{\(10\/3\)
                          , " ", \(g\^\(\[Mu]\[Nu]\)\), " ", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], "2"]}]}], ")"}], 
                          " ", SubscriptBox["\[Delta]", RowBox[{FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                          \(g\_s\%2\)}], 
                          TagBox["\[CurlyEpsilon]", TraditionalForm]], "+", 
                         FractionBox[RowBox[{"\[ImaginaryI]", " ", \(S\_n\), 
                          " ", \(T\_f\), " ", RowBox[{"(", RowBox[{RowBox[{
                          \(4\/3\), " ", \(g\^\(\[Mu]\[Nu]\)\), " ", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          "2"]}], "-", FractionBox[RowBox[{"4", " ", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]]}], "3"]}], 
                          ")"}], " ", SubscriptBox["\[Delta]", RowBox[
                          {FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                          \(g\_s\%2\)}], 
                          TagBox["\[CurlyEpsilon]", TraditionalForm]]}], 
                       ")"}]}], "-", FractionBox[RowBox[{"\[ImaginaryI]", 
                      " ", \(g\^\(\[Mu]\[Nu]\)\), " ", SubscriptBox[
                       "\[Delta]", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], \(p\^2\)]}], 
                 TraditionalForm]], "Output", CellTags -> "CounterT"]}, 
             Open]]}, Open]], Cell["CounterTerm", "ObjectName", 
         CellTags -> "CounterTerm"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "CounterTerm"], 
           Cell["CounterTerm[name] is a database of counter terms. \
CounterTerm is also an option for the Feynman rule functions \
QuarkGluonVertex, GluonPropagator, QuarkPropagator.", "Text", 
            CellTags -> "CounterTerm"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["CounterT", RuleDelayed[ButtonData, "CounterT"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "CounterT"]], ", ", 
              ButtonBox["QuarkGluonVertex", 
                RuleDelayed[ButtonData, "QuarkGluonVertex"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "QuarkGluonVertex"]], ", ", 
              ButtonBox["GluonPropagator", 
                RuleDelayed[ButtonData, "GluonPropagator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "GluonPropagator"]], ", ", 
              ButtonBox["QuarkPropagator", 
                RuleDelayed[ButtonData, "QuarkPropagator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "QuarkPropagator"]], "."}], "Text", 
            CellTags -> "CounterTerm"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "CounterTerm"], Cell[CellGroupData[{Cell[BoxData[
                \(CounterTerm[Zm]\)], "Input", CellTags -> "CounterTerm"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\(C\_F\ 
                        \((\(4\ \((\(11\ C\_A\)\/2 + \(9\ C\_F\)\/2 - 
                                 \(2\ N\_f\ T\_f\))\)\)\/
                            \*TagBox["\[CurlyEpsilon]", TraditionalForm]\^2 +
                            \(2\ \((\(97\ C\_A\)\/12 + \(3\ C\_F\)\/4 - 
                                 \(5\ N\_f\ T\_f\)\/3)\)\)\/
                            \*TagBox["\[CurlyEpsilon]", TraditionalForm])\)\ 
                        g\_s\%4\)\/\(256\ \[Pi]\^4\) + 
                     \(3\ C\_F\ g\_s\%2\)\/
                      \(8\ \*TagBox["\[CurlyEpsilon]", TraditionalForm]\ 
                        \[Pi]\^2\) + 1\)\)], "Output", CellTags -> 
                "CounterTerm"]}, Open]]}, Open]], Cell["CouplingConstant", 
         "ObjectName", CellTags -> "CouplingConstant"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CouplingConstant"], Cell["In general, \
CouplingConstant is an option for several Feynman rule functions and for \
CovariantD and FieldStrength.\nIn the convention of the subpackage PHI, \
CouplingConstant is also the head of coupling constants.  CouplingConstant \
takes three extra optional arguments, with head RenormalizationState, \
RenormalizationScheme and ExpansionState respectively.  E.g. \
CouplingConstant[QED[1]] is the unit charge, CouplingConstant[ChPT2[4],1] is \
the first of the coupling constants of the lagrangian ChPT2[4].  \
CouplingConstant[a_,b_,c___][i_] := \
CouplingConstant[a,b,RenormalizationState[i],c].", "Text", 
            CellTags -> "CouplingConstant"], Cell[TextData[{"See also: ", 
              " ", 
              ButtonBox["CovariantD", RuleDelayed[ButtonData, "CovariantD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "CovariantD"]], ", ", 
              ButtonBox["FieldStrength", 
                RuleDelayed[ButtonData, "FieldStrength"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FieldStrength"]], ", ", 
              ButtonBox["\"PHI - A Mathematica package for ChPT \
calculations\"", RuleDelayed[ButtonData, "phi"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "phi"]], 
              "."}], "Text", CellTags -> "CouplingConstant"], 
           Cell[BoxData[""], "Input"]}, Open]], Cell["CovariantD", 
         "ObjectName", CellTags -> "CovariantD"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CovariantD"], Cell["CovariantD[mu] is a generic \
covariant derivative with Lorentz index mu. With the option-setting Explicit \
\[Rule] True, an explicit expression for a fermionic field is returned, \
depending on the setting on the other options.\nCovariantD[x, mu] is a \
generic covariant derivative with respect to x^mu.\nCovariantD[mu, a, b] is a \
covariant derivative for a bosonic field; acting on QuantumField[f,{},{a,b}], \
where f is some field name and a and b are two SU(N) indices. Again, with the \
option-setting Explicit \[Rule] True, an explicit expression is returned, \
depending on the setting on the other options.\nCovariantD[OPEDelta, a, b] is \
a short form for  CovariantD[mu,a,b]*FourVector[OPEDelta, mu]. \
CovariantD[{OPEDelta, a, b}, {n}] yields the product of n operators, where n \
is an integer.  CovariantD[OPEDelta, a, b, {m, n}]  gives the expanded form \
of CovariantD[OPEDelta, a, b]^m up to order g^n for the gluon, where n is an \
integer and g the coupling constant  indicated by the setting of the option \
CouplingConstant. CovariantD[OPEDelta, {m, n}] gives the expanded form of  \
CovariantD[OPEDelta]^m up to order g^n of the fermionic field.", "Text", 
            CellTags -> "CovariantD"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[CovariantD]\)], "Input", CellTags -> "CovariantD"], 
              Cell[BoxData[
                \(TraditionalForm\`\({\(CouplingConstant \[Rule] g\_s\), 
                      \(DummyIndex \[Rule] Automatic\), 
                      \(Explicit \[Rule] False\), 
                      \(PartialD \[Rule] RightPartialD\), 
                      \(QuantumField \[Rule] A\)}\)\)], "Output", CellTags -> 
                "CovariantD"]}, Open]], Cell[" Possible settings of PartialD \
are: LeftPartialD, LeftRigthPartialD, RightPartialD. The default setting of \
QuantumField is GaugeField.", "Text", CellTags -> "CovariantD"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["LeftPartialD", 
                RuleDelayed[ButtonData, "LeftPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LeftPartialD"]], ", ", 
              ButtonBox["LeftRightPartialD", 
                RuleDelayed[ButtonData, "LeftRightPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LeftRightPartialD"]], ", ", 
              ButtonBox["RightPartialD", 
                RuleDelayed[ButtonData, "RightPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "RightPartialD"]], "."}], "Text", 
            CellTags -> "CovariantD"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "CovariantD"], Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[\[Mu]]\)], "Input", CellTags -> "CovariantD"], 
              Cell[BoxData[\(TraditionalForm\`D\_\[Mu]\)], "Output", 
               CellTags -> "CovariantD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(CovariantD[\(\[Mu], a, b\)]\)], 
               "Input", CellTags -> "CovariantD"], Cell[BoxData[
                \(TraditionalForm\`D\_\[Mu]\%\(ab\)\)], "Output", CellTags -> 
                "CovariantD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[\(\[Mu], \(Explicit \[Rule] True\)\)]\)], 
               "Input", CellTags -> "CovariantD"], Cell[BoxData[
                FormBox[RowBox[{SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                    FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]], "-", RowBox[{"\[ImaginaryI]", " ", 
                     \(g\_s\), " ", RowBox[{SubscriptBox["T", FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox[FormBox[
                         "A", "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                         "TraditionalForm"]]}]}]}], TraditionalForm]], 
               "Output", CellTags -> "CovariantD"]}, Open]], 
           Cell["The first argument of CovariantD is intepreted as type \
LorentzIndex, except for OPEDelta, which is type Momentum.", "Text", 
            CellTags -> "CovariantD"], Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[OPEDelta]\)], "Input", CellTags -> 
                "CovariantD"], Cell[BoxData[FormBox[SubscriptBox["D", 
                  FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                 TraditionalForm]], "Output", CellTags -> "CovariantD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[\(OPEDelta, a, b\)]\)], "Input", CellTags -> 
                "CovariantD"], Cell[BoxData[FormBox[SubsuperscriptBox["D", 
                  FormBox["\[CapitalDelta]", "TraditionalForm"], \(ab\)], 
                 TraditionalForm]], "Output", CellTags -> "CovariantD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[\(OPEDelta, a, b, \(Explicit \[Rule] True\)\)]\)]\
, "Input", CellTags -> "CovariantD"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                      FormBox["\[CapitalDelta]", "TraditionalForm"]], " ", 
                     \(\[Delta]\_\(ab\)\)}], "-", RowBox[{\(g\_s\), " ", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox["\[CapitalDelta]", "TraditionalForm"], 
                      FormBox[FormBox[
                        InterpretationBox[\(c\_2\), Subscripted[c[2]], 
                          Rule[Editable, False]], "TraditionalForm"], 
                       "TraditionalForm"]], " ", SubscriptBox["f", RowBox[
                       {"a", "b", FormBox[
                         InterpretationBox[\(c\_2\), Subscripted[c[2]], 
                           Rule[Editable, False]], "TraditionalForm"]}]]}]}], 
                 TraditionalForm]], "Output", CellTags -> "CovariantD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[\(OPEDelta, \(Explicit \[Rule] True\)\)]\)], 
               "Input", CellTags -> "CovariantD"], Cell[BoxData[
                FormBox[RowBox[{SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                    FormBox["\[CapitalDelta]", "TraditionalForm"]], "-", 
                   RowBox[{"\[ImaginaryI]", " ", \(g\_s\), " ", RowBox[
                      {SubscriptBox["T", FormBox[FormBox[
                          InterpretationBox[\(c\_3\), Subscripted[c[3]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox[FormBox[
                         "A", "TraditionalForm"], FormBox["\[CapitalDelta]", 
                         "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_3\), Subscripted[c[3]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                         "TraditionalForm"]]}]}]}], TraditionalForm]], 
               "Output", CellTags -> "CovariantD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[\(OPEDelta, a, b, \({2}\)\)]\)], "Input", 
               CellTags -> "CovariantD"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"(", RowBox[{RowBox[{SubscriptBox[
                          \(\[PartialD]\&\[RightArrow]\), FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]], " ", 
                         \(\[Delta]\_\(ac14\)\)}], "-", RowBox[{\(g\_s\), 
                         " ", SubsuperscriptBox[FormBox["A", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox["e1", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                         \(f\_\(ac14e1\)\)}]}], ")"}], ".", RowBox[
                    {"(", RowBox[{RowBox[{SubscriptBox[
                          \(\[PartialD]\&\[RightArrow]\), FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]], " ", 
                         \(\[Delta]\_\(bc14\)\)}], "-", RowBox[{\(g\_s\), 
                         " ", SubsuperscriptBox[FormBox["A", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox["e2", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                         \(f\_\(c14be2\)\)}]}], ")"}]}], TraditionalForm]], 
               "Output", CellTags -> "CovariantD"]}, Open]], 
           Cell[TextData[{"This gives", Cell[BoxData[
                \(TraditionalForm\`\(\ \(
                      \(m\ times\ \(\[PartialD]\&\[RightArrow]\)\_
                          \[CapitalDelta]\),\ \)\)\)]], 
              "the partial derivative ", Cell[BoxData[
                \(TraditionalForm\`\(\[PartialD]\&\[RightArrow]\)\_
                    \(\[Mu]\ \)\)]], "contracted with ", Cell[BoxData[
                \(TraditionalForm\`\(\[CapitalDelta]\^\[Mu] .\)\)]]}], 
            "Text", CellTags -> "CovariantD"], Cell[CellGroupData[
             {Cell[BoxData[\(CovariantD[\(OPEDelta, a, b, \({OPEm, 0}\)\)]\)]
                , "Input", CellTags -> "CovariantD"], Cell[BoxData[
                FormBox[RowBox[{SuperscriptBox[RowBox[{"(", SubscriptBox[
                       \(\[PartialD]\&\[RightArrow]\), FormBox[
                        "\[CapitalDelta]", "TraditionalForm"]], ")"}], "m"], 
                   " ", SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "CovariantD"]}, Open]], 
           Cell[TextData[
             {"The expansion up to first order in the coupling constant ", 
              Cell[BoxData[
                \(TraditionalForm\`\(g\_s\ 
                     \(\((thesumistheFeynCalcOPESum)\) .\)\)\)]]}], "Text", 
            CellTags -> "CovariantD"], Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[\(OPEDelta, a, b, \({OPEm, 1}\)\)]\)], "Input", 
               CellTags -> "CovariantD"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{SuperscriptBox[RowBox[{"(", SubscriptBox[
                         \(\[PartialD]\&\[RightArrow]\), FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]], ")"}], 
                      "m"], " ", SubscriptBox["\[Delta]", RowBox[
                       {FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "-", 
                   RowBox[{\(g\_s\), " ", FormBox[TagBox[RowBox[{
                         \(\[Sum]\+\(i = 0\)\%\(m - 1\)\), RowBox[
                          {RowBox[{SuperscriptBox[RowBox[{"(", SubscriptBox[
                          \(\[PartialD]\&\[RightArrow]\), FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]], ")"}], 
                          "i"], ".", SubsuperscriptBox[FormBox["A", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[RowBox[
                          {"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], \(\(-i\) + m - 1\)]}], " ", SubscriptBox[
                          "f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]}]]}]}], HoldForm], 
                      "TraditionalForm"]}]}], TraditionalForm]], "Output", 
               CellTags -> "CovariantD"]}, Open]], 
           Cell[TextData[{"The expansion up to second order in the ", 
              Cell[BoxData[\(TraditionalForm\`\(g\_s .\)\)]]}], "Text", 
            CellTags -> "CovariantD"], Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[\(OPEDelta, a, b, \({OPEm, 2}\)\)]\)], "Input", 
               CellTags -> "CovariantD"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SuperscriptBox[
                      RowBox[{"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\)
                         , FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                        ")"}], "m"]}], "-", RowBox[{\(g\_s\%2\), " ", 
                     FormBox[TagBox[RowBox[{\(\[Sum]\+\(j = 0\)\%\(m - 2\)\), 
                         FormBox[TagBox[RowBox[{\(\[Sum]\+\(i = 0\)\%j\), 
                          RowBox[{RowBox[{SuperscriptBox[RowBox[{"(", 
                          SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], "i"], ".", SubsuperscriptBox[FormBox["A", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[RowBox[
                          {"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], \(j - i\)], ".", SubsuperscriptBox[FormBox[
                          "A", "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_2\), Subscripted[c[2]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[RowBox[
                          {"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], \(\(-j\) + m - 2\)]}], " ", SubscriptBox[
                          "f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(e\_1\), Subscripted[e[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_2\), Subscripted[c[2]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(e\_1\), Subscripted[e[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]}]]}]}], HoldForm], 
                          "TraditionalForm"]}], HoldForm], 
                      "TraditionalForm"]}], "-", RowBox[{\(g\_s\), " ", 
                     FormBox[TagBox[RowBox[{\(\[Sum]\+\(i = 0\)\%\(m - 1\)\), 
                         RowBox[{RowBox[{SuperscriptBox[RowBox[{"(", 
                          SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], "i"], ".", SubsuperscriptBox[FormBox["A", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[RowBox[
                          {"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], \(\(-i\) + m - 1\)]}], " ", SubscriptBox[
                          "f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]}]]}]}], HoldForm], 
                      "TraditionalForm"]}]}], TraditionalForm]], "Output", 
               CellTags -> "CovariantD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(CovariantD[\(OPEDelta, a, b\)]\)\^OPEm\)], "Input", 
               CellTags -> "CovariantD"], Cell[BoxData[FormBox[SuperscriptBox[
                  RowBox[{"(", SubsuperscriptBox["D", FormBox[
                      "\[CapitalDelta]", "TraditionalForm"], \(ab\)], ")"}], 
                  "m"], TraditionalForm]], "Output", CellTags -> 
                "CovariantD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(CovariantD[\(OPEDelta, \({OPEm, 2}\)\)]\)], "Input", 
               CellTags -> "CovariantD"], Cell[BoxData[FormBox[RowBox[
                  {SuperscriptBox[RowBox[{"(", SubscriptBox[
                       \(\[PartialD]\&\[RightArrow]\), FormBox[
                        "\[CapitalDelta]", "TraditionalForm"]], ")"}], "m"], 
                   "-", RowBox[{"\[ImaginaryI]", " ", \(g\_s\), " ", 
                     FormBox[TagBox[RowBox[{\(\[Sum]\+\(i = 0\)\%\(m - 1\)\), 
                         RowBox[{SubscriptBox["T", FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[RowBox[
                          {"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], "i"], ".", SubsuperscriptBox[FormBox["A", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[RowBox[
                          {"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], \(\(-i\) + m - 1\)]}]}], HoldForm], 
                      "TraditionalForm"]}], "-", RowBox[{\(g\_s\%2\), " ", 
                     FormBox[TagBox[RowBox[{\(\[Sum]\+\(j = 0\)\%\(m - 2\)\), 
                         FormBox[TagBox[RowBox[{\(\[Sum]\+\(i = 0\)\%j\), 
                          RowBox[{SubscriptBox["T", FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SubscriptBox["T", FormBox[
                          FormBox[
                          InterpretationBox[\(c\_2\), Subscripted[c[2]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[RowBox[
                          {"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], "i"], ".", SubsuperscriptBox[FormBox["A", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_1\), Subscripted[c[1]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[RowBox[
                          {"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], \(j - i\)], ".", SubsuperscriptBox[FormBox[
                          "A", "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox[
                          InterpretationBox[\(c\_2\), Subscripted[c[2]], 
                            Rule[Editable, False]], "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[RowBox[
                          {"(", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          ")"}], \(\(-j\) + m - 2\)]}]}], HoldForm], 
                          "TraditionalForm"]}], HoldForm], 
                      "TraditionalForm"]}]}], TraditionalForm]], "Output", 
               CellTags -> "CovariantD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(CovariantD[\(OPEDelta, \(Explicit \[Rule] True\)\)]\)//
                   StandardForm\)], "Input", CellTags -> "CovariantD"], 
              Cell[BoxData[
                \(\(\(-\[ImaginaryI]\)\ Gstrong\ 
                     \(\(SUNT[\(SUNIndex[
                           \(\*InterpretationBox[\(c\_4\), 
                              Subscripted[c[4]], Rule[Editable, False]]\)]\)]
                \) . \(QuantumField[\(GaugeField, \(Momentum[OPEDelta]\), 
                           \(SUNIndex[\(\*
                               InterpretationBox[\(c\_4\), 
                                Subscripted[c[4]], Rule[Editable, False]]\)]\
\)\)]\)\)\) + \(RightPartialD[\(Momentum[OPEDelta]\)]\)\)], "Output", 
               CellTags -> "CovariantD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(CovariantD[\(\[Mu], a, b, \(Explicit \[Rule] True\)\)]\)
                   //StandardForm\)], "Input", CellTags -> "CovariantD"], 
              Cell[BoxData[
                \(\(\(RightPartialD[\(LorentzIndex[\[Mu]]\)]\)\ 
                     \(SUNDelta[\(a, b\)]\)\) - 
                   \(Gstrong\ \(QuantumField[
                       \(GaugeField, \(LorentzIndex[\[Mu]]\), 
                         \(SUNIndex[\(\*InterpretationBox[\(c\_5\), 
                              Subscripted[c[5]], Rule[Editable, False]]\)]\)\
\)]\)\ \(SUNF[\(a, b, \*InterpretationBox[\(c\_5\), 
                           Subscripted[c[5]], Rule[Editable, False]]\)]\)\)\)]\
, "Output", CellTags -> "CovariantD"]}, Open]]}, Open]], 
        Cell["CrossProduct", "ObjectName", CellTags -> "CrossProduct"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "CrossProduct"], Cell["CrossProduct[a, b] denotes the \
three-dimensional cross-product of the three-vectors a and b.", "Text", 
            CellTags -> "CrossProduct"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["DotProduct", RuleDelayed[ButtonData, "DotProduct"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DotProduct"]], ", ", 
              ButtonBox["ThreeVector", RuleDelayed[ButtonData, 
                 "ThreeVector"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ThreeVector"]], "."}], "Text", 
            CellTags -> "CrossProduct"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "CrossProduct"], Cell[CellGroupData[{Cell[BoxData[
                \(CrossProduct[\(\(ThreeVector[a]\), 
                     \(CrossProduct[\(\(ThreeVector[b]\), \(ThreeVector[c]\)
                        \)]\)\)]\)], "Input", CellTags -> "CrossProduct"], 
              Cell[BoxData[FormBox[RowBox[{RowBox[{RowBox[{FormBox[
                        \(a\&\[RightVector]\), "TraditionalForm"], 
                       "\[CenterDot]", FormBox[\(c\&\[RightVector]\), 
                        "TraditionalForm"]}], " ", \(b\&\[RightVector]\)}], 
                   "-", RowBox[{RowBox[{FormBox[\(a\&\[RightVector]\), 
                        "TraditionalForm"], "\[CenterDot]", FormBox[
                        \(b\&\[RightVector]\), "TraditionalForm"]}], " ", 
                     \(c\&\[RightVector]\)}]}], TraditionalForm]], "Output", 
               CellTags -> "CrossProduct"]}, Open]]}, Open]], 
        Cell["C0", "ObjectName", CellTags -> "C0"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "C0"], Cell[TextData[{"C0[p10, p12, p20, m1^2, m2^2, \
m3^2] is the scalar Passarino-Veltman ", Cell[BoxData[
                \(TraditionalForm\`C\_0\)]], "function. The convention for \
the arguments is that if the denominator of the integrand has the form \
([q^2-m1^2] [(q+p1)^2-m2^2] [(q+p2)^2-m3^2]), the first three arguments of C0 \
are the scalar products p10 = p1^2, p12 = (p1-p2).(p1-p2), p20 = p2^2."}], 
            "Text", CellTags -> "C0"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              ", ", 
              ButtonBox["D0", RuleDelayed[ButtonData, "D0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "D0"]], 
              ", ", 
              ButtonBox["PaVe", RuleDelayed[ButtonData, "PaVe"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "PaVe"]], 
              ", ", 
              ButtonBox["PaVeOrder", RuleDelayed[ButtonData, "PaVeOrder"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PaVeOrder"]], "."}], "Text", 
            CellTags -> "C0"]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "C0"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(C0[\(a, b, c,\ m12, m22, m32\)]\)], "Input", CellTags -> 
                "C0"], Cell[BoxData[FormBox[RowBox[{FormBox[\("C"\_"0"\), 
                    "TraditionalForm"], "(", "a", ",", "b", ",", "c", ",", 
                   "m12", ",", "m22", ",", "m32", ")"}], TraditionalForm]], 
               "Output", CellTags -> "C0"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(C0[\(b, a, c, m32, m22, m12\)]\)//PaVeOrder\)], "Input", 
               CellTags -> "C0"], Cell[BoxData[FormBox[RowBox[{FormBox[
                    \("C"\_"0"\), "TraditionalForm"], "(", "a", ",", "b", 
                   ",", "c", ",", "m12", ",", "m22", ",", "m32", ")"}], 
                 TraditionalForm]], "Output", CellTags -> "C0"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(PaVeOrder[\(\(C0[\(b, a, c, m32, m22, m12\)]\), 
                     \(PaVeOrderList \[Rule] \({c, a}\)\)\)]\)], "Input", 
               CellTags -> "C0"], Cell[BoxData[FormBox[RowBox[{FormBox[
                    \("C"\_"0"\), "TraditionalForm"], "(", "b", ",", "c", 
                   ",", "a", ",", "m22", ",", "m32", ",", "m12", ")"}], 
                 TraditionalForm]], "Output", CellTags -> "C0"]}, Open]]}, 
          Open]], Cell["DataType", "ObjectName", CellTags -> "DataType"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DataType"], Cell["DataType[exp, type] = True defines \
the object exp to have data-type type. DataType[exp1, exp2, ..., type] \
defines the objects exp1, exp2, ...to have data-type type. The default \
setting is DataType[__, _] := False. To assign a certain data-type, do, e.g., \
DataType[x, PositiveInteger] = True.", "Text", CellTags -> "DataType"], 
           Cell[TextData[{"Currently used DataTypes: ", 
              ButtonBox["NonCommutative", 
                RuleDelayed[ButtonData, "NonCommutative"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "NonCommutative"]], ", ", 
              ButtonBox["PositiveInteger", 
                RuleDelayed[ButtonData, "PositiveInteger"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PositiveInteger"]], ", ", 
              ButtonBox["NegativeInteger", 
                RuleDelayed[ButtonData, "NegativeInteger"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "NegativeInteger"]], ", ", 
              ButtonBox["PositiveNumber", 
                RuleDelayed[ButtonData, "PositiveNumber"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PositiveNumber"]], ", ", 
              ButtonBox["FreeIndex", RuleDelayed[ButtonData, "FreeIndex"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FreeIndex"]], ", ", 
              ButtonBox["GrassmannParity", 
                RuleDelayed[ButtonData, "GrassmannParity"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "GrassmannParity"]]}], "Text", 
            CellTags -> "DataType"], Cell[TextData[
             {"PHI adds the DataTypes: ", 
              ButtonBox["UMatrix", RuleDelayed[ButtonData, "UMatrix"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "UMatrix"]]\
, ", ", 
              ButtonBox["UScalar", RuleDelayed[ButtonData, "UScalar"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "UScalar"]]\
, "."}], "Text", CellTags -> "DataType"], Cell[TextData[{"See also:  ", 
              ButtonBox["DeclareNonCommutative", 
                RuleDelayed[ButtonData, "DeclareNonCommutative"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DeclareNonCommutative"]], ", ", 
              ButtonBox["\"PHI - A Mathematica package for ChPT \
calculations\"", RuleDelayed[ButtonData, "phi"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "phi"]], 
              "."}], "Text", CellTags -> "DataType"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DataType"], 
           Cell["NonCommutative is just a data-type.", "Text", 
            CellTags -> "DataType"], Cell[BoxData[
             \(\(\(DataType[\(f, g,\ NonCommutative\)]\)\ =\ True\) ;\)], 
            "Input", CellTags -> "DataType"], Cell[CellGroupData[
             {Cell[BoxData[\(t = \(\(f . g\) - \(g . \((2a)\) . f\)\)\)], 
               "Input", CellTags -> "DataType"], Cell[BoxData[
                \(TraditionalForm\`\(\(f . g\) - \(g . \((2\ a)\) . f\)\)\)], 
               "Output", CellTags -> "DataType"]}, Open]], 
           Cell["Since \"f \"and \"g\" have DataType NonCommutative the \
function DotSimplify extracts only \"a\" out of the noncommutative product.", 
            "Text", CellTags -> "DataType"], Cell[CellGroupData[{Cell[BoxData[
                \(DotSimplify[t]\)], "Input", CellTags -> "DataType"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\(f . g\) - \(2\ a\ \(g . f\)\)\)\)], 
               "Output", CellTags -> "DataType"]}, Open]], Cell[BoxData[
             \(\(\(DataType[\(m, odd\)]\) = 
                  \(\(DataType[\(a, even\)]\) = True\)\) ;\)], "Input", 
            CellTags -> "DataType"], Cell[BoxData[
             \(\(\(ptest1[x_]\) := \(x/.
                    \(\(\((\(-1\))\)\^n_/;\(DataType[\(n, odd\)]\)\) 
                      \[RuleDelayed] \(-1\)\)\)\) ;\)], "Input", 
            CellTags -> "DataType"], Cell[BoxData[
             \(\(\(ptest2[x_]\) := \(x/.
                    \(\(\((\(-1\))\)\^n_/;\(DataType[\(n, even\)]\)\) 
                      \[RuleDelayed] 1\)\)\) ;\)], "Input", 
            CellTags -> "DataType"], Cell[CellGroupData[{Cell[BoxData[
                \(t = \(\(\((\(-1\))\)^m\) + \(\((\(-1\))\)^a\) + 
                     \(\((\(-1\))\)^z\)\)\)], "Input", CellTags -> 
                "DataType"], Cell[BoxData[
                \(TraditionalForm\`\(\((\(-1\))\)\^a + \((\(-1\))\)\^m + 
                     \((\(-1\))\)\^z\)\)], "Output", CellTags -> 
                "DataType"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(ptest1[t]\)], "Input", CellTags -> "DataType"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\(-1\) + \((\(-1\))\)\^a + 
                     \((\(-1\))\)\^z\)\)], "Output", CellTags -> 
                "DataType"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(ptest2[%]\)], "Input", CellTags -> "DataType"], 
              Cell[BoxData[\(TraditionalForm\`\(\((\(-1\))\)\^z\)\)], 
               "Output", CellTags -> "DataType"]}, Open]], Cell[BoxData[
             \(\(Clear[\(ptest1, ptest2, t, a, m\)]\) ;\)], "Input", 
            CellTags -> "DataType"], Cell[BoxData[
             \(\(\(DataType[\(m, ganzeZahl\)]\) = True\) ;\)], "Input", 
            CellTags -> "DataType"], Cell[BoxData[
             \(\(\(f[x_]\) := \(x/.\({\(
                        \(\((\(-1\))\)^p_\)/;\(DataType[\(p, ganzeZahl\)]\)\)\
 \[RuleDelayed] 1}\)\)\) ;\)], "Input", CellTags -> "DataType"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(test = \(\(\((\(-1\))\)^m\) + \(\(\((\(-1\))\)^n\)\ x\)\)\)]\
, "Input", CellTags -> "DataType"], Cell[BoxData[
                \(TraditionalForm\`\(\(\((\(-1\))\)\^n\ x\) + \((\(-1\))\)\^m
                    \)\)], "Output", CellTags -> "DataType"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(f[test]\)], "Input", 
               CellTags -> "DataType"], Cell[BoxData[
                \(TraditionalForm\`\(\(\((\(-1\))\)\^n\ x\) + 1\)\)], 
               "Output", CellTags -> "DataType"]}, Open]], Cell[BoxData[
             \(\(Clear[\(f, test\)]\) ;\)], "Input", CellTags -> "DataType"], 
           Cell[BoxData[
             \(\(\(DataType[\(f, g,\ NonCommutative\)]\)\ =\ False\) ;\)], 
            "Input", CellTags -> "DataType"], Cell[BoxData[
             \(\(\(DataType[\(m, odd\)]\) = 
                  \(\(DataType[\(a, even\)]\) = False\)\) ;\)], "Input", 
            CellTags -> "DataType"], Cell["Certain FeynCalc objects have \
DataType PositiveInteger set to True.", "Text", CellTags -> "DataType"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DataType[\(OPEm, PositiveInteger\)]\)], "Input", 
               CellTags -> "DataType"], Cell[BoxData[\(TraditionalForm\`True\)
                ], "Output", CellTags -> "DataType"]}, Open]], 
           Cell["PowerSimplify uses the DataType information.", "Text", 
            CellTags -> "DataType"], Cell[CellGroupData[{Cell[BoxData[
                \(PowerSimplify[\ \(\((\(-1\))\)^\((2OPEm)\)\)]\)], "Input", 
               CellTags -> "DataType"], Cell[BoxData[\(TraditionalForm\`1\)], 
               "Output", CellTags -> "DataType"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(PowerSimplify[\ \(\((\(-\ \(SO[q]\)\))\)^OPEm\)]\)], 
               "Input", CellTags -> "DataType"], Cell[BoxData[FormBox[RowBox[{
                   \(\((\(-1\))\)\^m\), " ", SuperscriptBox[RowBox[
                     {"(", RowBox[{FormBox["\"\[CapitalDelta]\"", 
                         "TraditionalForm"], FormBox["\"\[CenterDot]\"", 
                         "TraditionalForm"], FormBox["q", 
                         "TraditionalForm"]}], ")"}], "m"]}], 
                 TraditionalForm]], "Output", CellTags -> "DataType"]}, 
             Open]]}, Open]], Cell["DB0", "ObjectName", CellTags -> "DB0"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DB0"], Cell["DB0[p2, m1^2, m2^2] is the derivative \
of the two-point function B0[p2, m1^2, m2^2] with respect to p2.", "Text", 
            CellTags -> "DB0"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              "."}], "Text", CellTags -> "DB0"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DB0"], Cell[CellGroupData[{Cell[BoxData[
                \(D[\(\(B0[\(p\_2, \(m\_1\)\^2, \(m\_2\)\^2\)]\), p\_2\)]\)], 
               "Input", CellTags -> "DB0"], Cell[BoxData[
                \(TraditionalForm\`\(DB0(\(p\_2, m\_1\%2, m\_2\%2\))\)\)], 
               "Output", CellTags -> "DB0"]}, Open]]}, Open]], 
        Cell["DB1", "ObjectName", CellTags -> "DB1"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DB1"], Cell["DB1[p2,m1^2,m2^2] is the derivative of \
B1[p2,m1^2,m2^2] with respect to p2.", "Text", CellTags -> "DB1"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["B1", RuleDelayed[ButtonData, "B1"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B1"]], 
              "."}], "Text", CellTags -> "DB1"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DB1"], Cell[CellGroupData[{Cell[BoxData[
                \(D[\(\(B1[\(p\_2, \(m\_1\)\^2, \(m\_2\)\^2\)]\), p\_2\)]\)], 
               "Input", CellTags -> "DB1"], Cell[BoxData[
                \(TraditionalForm\`\(\(\((m\_2\%2 - m\_1\%2)\)\ 
                        \(DB0(\(p\_2, m\_1\%2, m\_2\%2\))\)\)\/\(2\ p\_2\) - 
                     \(1\/2\ \(DB0(\(p\_2, m\_1\%2, m\_2\%2\))\)\) - 
                     \(\((\(B\_0 (p\_2, m\_1\%2, m\_2\%2)\) - 
                           \(B\_0 (0, m\_1\%2, m\_2\%2)\))\)\ 
                        \((m\_2\%2 - m\_1\%2)\)\)\/\(2\ p\_2\%2\)\)\)], 
               "Output", CellTags -> "DB1"]}, Open]]}, Open]], 
        Cell["DeclareNonCommutative", "ObjectName", CellTags -> 
          "DeclareNonCommutative"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "DeclareNonCommutative"], Cell["DeclareNonCommutative[a, b, ...] \
declares a,b, ... to be non-commutative, i.e., DataType[a,b, ..., \
NonCommutative] is set to True.", "Text", CellTags -> 
             "DeclareNonCommutative"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["DataType", RuleDelayed[ButtonData, "DataType"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DataType"]], ", ", 
              ButtonBox["UnDeclareNonCommutative", 
                RuleDelayed[ButtonData, "UnDeclareNonCommutative"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "UnDeclareNonCommutative"]], "."}], "Text", 
            CellTags -> "DeclareNonCommutative"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DeclareNonCommutative"], Cell[BoxData[
             \(DeclareNonCommutative[x]\)], "Input", CellTags -> 
             "DeclareNonCommutative"], Cell["As a side effect of \
DeclareNonCommutative x is declared to be of data type NonCommutative.", 
            "Text", CellTags -> "DeclareNonCommutative"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DataType[\(x, NonCommutative\)]\)], "Input", CellTags -> 
                "DeclareNonCommutative"], Cell[BoxData[
                \(TraditionalForm\`True\)], "Output", CellTags -> 
                "DeclareNonCommutative"]}, Open]], Cell[BoxData[
             \(DeclareNonCommutative[\(y, z\)]\)], "Input", 
            CellTags -> "DeclareNonCommutative"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DataType[\(a, x, y, z, NonCommutative\)]\)], "Input", 
               CellTags -> "DeclareNonCommutative"], Cell[BoxData[
                \(TraditionalForm\`\({True, True, True, True}\)\)], "Output", 
               CellTags -> "DeclareNonCommutative"]}, Open]], Cell[BoxData[
             \(UnDeclareNonCommutative[\(x, y, z\)]\)], "Input", 
            CellTags -> "DeclareNonCommutative"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DataType[\(a, x, y, z, NonCommutative\)]\)], "Input", 
               CellTags -> "DeclareNonCommutative"], Cell[BoxData[
                \(TraditionalForm\`\({True, True, True, True}\)\)], "Output", 
               CellTags -> "DeclareNonCommutative"]}, Open]]}, Open]], 
        Cell["DeltaFunction", "ObjectName", CellTags -> "DeltaFunction"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DeltaFunction"], Cell[TextData[
             {" DeltaFunction[x] is the Dirac delta-function ", Cell[BoxData[
                \(TraditionalForm\`\(\[Delta](x)\)\)]], 
              ".\nNOTICE: After version 4 of ", 
              StyleBox["Mathematica", Rule[FontSlant, "Italic"]], " there is \
a built-in function, DiracDelta, with comparable properties."}], "Text", 
            CellTags -> "DeltaFunction"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Convolute", RuleDelayed[ButtonData, "Convolute"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Convolute"]], ", ", 
              ButtonBox["DeltaFunctionPrime", 
                RuleDelayed[ButtonData, "DeltaFunctionPrime"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DeltaFunctionPrime"]], ", ", 
              ButtonBox["Integrate2", RuleDelayed[ButtonData, "Integrate2"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Integrate2"]], ", ", 
              ButtonBox["SimplifyDeltaFunction", 
                RuleDelayed[ButtonData, "SimplifyDeltaFunction"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SimplifyDeltaFunction"]], "."}], "Text", 
            CellTags -> "DeltaFunction"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DeltaFunction"], Cell[CellGroupData[{Cell[BoxData[
                \(DeltaFunction[\(1 - x\)]\)], "Input", CellTags -> 
                "DeltaFunction"], Cell[BoxData[FormBox[RowBox[{"\[Delta]", 
                   "(", FormBox[\(1 - x\), "TraditionalForm"], ")"}], 
                 TraditionalForm]], "Output", CellTags -> "DeltaFunction"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Integrate2[\(\(\(DeltaFunction[\(1 - x\)]\)\ \(f[x]\)\), 
                     \({x, 0, 1}\)\)]\)], "Input", CellTags -> 
                "DeltaFunction"], Cell[BoxData[\(TraditionalForm\`\(f(1)\)\)]
                , "Output", CellTags -> "DeltaFunction"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Integrate2[\(\(\(DeltaFunction[x]\)\ \(f[x]\)\), 
                     \({x, 0, 1}\)\)]\)], "Input", CellTags -> 
                "DeltaFunction"], Cell[BoxData[\(TraditionalForm\`\(f(0)\)\)]
                , "Output", CellTags -> "DeltaFunction"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Integrate2[\(\(\(DeltaFunction[\(1 - x\)]\)\ \(f[x]\)\), 
                     \({x, 0, 1}\)\)]\)], "Input", CellTags -> 
                "DeltaFunction"], Cell[BoxData[\(TraditionalForm\`\(f(1)\)\)]
                , "Output", CellTags -> "DeltaFunction"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Convolute[\(\(DeltaFunction[\(1 - x\)]\), x\)]\)], "Input", 
               CellTags -> "DeltaFunction"], Cell[BoxData[
                \(TraditionalForm\`x\)], "Output", CellTags -> 
                "DeltaFunction"]}, Open]]}, Open]], 
        Cell["DeltaFunctionDoublePrime", "ObjectName", 
         CellTags -> "DeltaFunctionDoublePrime"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DeltaFunctionDoublePrime"], 
           Cell[TextData[{" DeltaFunctionDoublePrime[1-x] is the second \
derivative of the Dirac delta-function ", Cell[BoxData[
                \(TraditionalForm\`\(\[Delta](x)\)\)]], "."}], "Text", 
            CellTags -> "DeltaFunctionDoublePrime"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["DeltaFunctionPrime", 
                RuleDelayed[ButtonData, "DeltaFunctionPrime"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DeltaFunctionPrime"]], "."}], "Text", 
            CellTags -> "DeltaFunctionDoublePrime"]}, Open]], 
        Cell["DeltaFunctionPrime", "ObjectName", CellTags -> 
          "DeltaFunctionPrime"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "DeltaFunctionPrime"], Cell[TextData[{" DeltaFunctionPrime[1-x] \
is the derivative of the Dirac delta-function ", Cell[BoxData[
                \(TraditionalForm\`\(\[Delta](x)\)\)]], "."}], "Text", 
            CellTags -> "DeltaFunctionPrime"], Cell[TextData[{"See also: ", 
              ButtonBox["Convolute", RuleDelayed[ButtonData, "Convolute"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Convolute"]], ", ", 
              ButtonBox["DeltaFunction", 
                RuleDelayed[ButtonData, "DeltaFunction"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DeltaFunction"]], ", ", 
              ButtonBox["DeltaFunctionDoublePrime", 
                RuleDelayed[ButtonData, "DeltaFunctionDoublePrime"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DeltaFunctionDoublePrime"]], ", ", 
              ButtonBox["Integrate2", RuleDelayed[ButtonData, "Integrate2"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Integrate2"]], ", ", 
              ButtonBox["SimplifyDeltaFunction", 
                RuleDelayed[ButtonData, "SimplifyDeltaFunction"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SimplifyDeltaFunction"]], "."}], "Text", 
            CellTags -> "DeltaFunctionPrime"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DeltaFunctionPrime"], Cell[CellGroupData[
             {Cell[BoxData[\(DeltaFunctionPrime[\(1 - x\)]\)], "Input", 
               CellTags -> "DeltaFunctionPrime"], Cell[BoxData[FormBox[
                 RowBox[{\(\[Delta]\^\[Prime]\), "(", FormBox[\(1 - x\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "DeltaFunctionPrime"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Integrate2[\(\(\(DeltaFunctionPrime[\(1 - x\)]\)\ \(f[x]\)
                      \), \({x, 0, 1}\)\)]\)], "Input", CellTags -> 
                "DeltaFunctionPrime"], Cell[BoxData[
                \(TraditionalForm\`\(\(\*
                       SuperscriptBox["f", "\[Prime]", 
                        Rule[MultilineFunction, None]]\)(1)\)\)], "Output", 
               CellTags -> "DeltaFunctionPrime"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Integrate2[\(\(\(DeltaFunctionPrime[\(1 - x\)]\)\ x\^2\), 
                     \({x, 0, 1}\)\)]\)], "Input", CellTags -> 
                "DeltaFunctionPrime"], Cell[BoxData[\(TraditionalForm\`2\)], 
               "Output", CellTags -> "DeltaFunctionPrime"]}, Open]]}, Open]], 
        Cell["DenominatorOrder", "ObjectName", CellTags -> 
          "DenominatorOrder"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "DenominatorOrder"], Cell["DenominatorOrder is an option for \
OneLoop, if set to True the PropagatorDenominator will be ordered in a \
standard way.", "Text", CellTags -> "DenominatorOrder"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["OneLoop", RuleDelayed[ButtonData, "OneLoop"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "OneLoop"]]\
, ", ", 
              ButtonBox["PropagatorDenominator", 
                RuleDelayed[ButtonData, "PropagatorDenominator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PropagatorDenominator"]], "."}], "Text", 
            CellTags -> "DenominatorOrder"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["Dimension", "ObjectName", CellTags -> "Dimension"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Dimension"], Cell["Dimension is an option of several \
functions and denotes the number of space-time dimensions. Possible settings \
are: 4, n, d, D, ... ,the variable does not matter, but it should have Head \
Symbol.", "Text", CellTags -> "Dimension"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[MetricTensor]\)], "Input", CellTags -> 
                "Dimension"], Cell[BoxData[
                \(TraditionalForm\`\({\(Dimension \[Rule] 4\), 
                      \(FeynCalcInternal \[Rule] False\)}\)\)], "Output", 
               CellTags -> "Dimension"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(MetricTensor[\(m, n, \(Dimension \[Rule] d\)\)]\) 
                   \(DiracMatrix[\(\[Alpha], \(Dimension \[Rule] d\)\)]\)\)], 
               "Input", CellTags -> "Dimension"], Cell[BoxData[FormBox[
                 RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                      "\[Alpha]", "TraditionalForm"], "TraditionalForm"]], 
                   " ", \(g\^\(mn\)\)}], TraditionalForm]], "Output", 
               CellTags -> "Dimension"]}, Open]], Cell["The dimension of the \
indices is not shown by default but can be inspected easily.", "Text", 
            CellTags -> "Dimension"], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(MetricTensor[\(m, n, \(Dimension \[Rule] d\)\)]\) 
                     \(DiracMatrix[\(\[Alpha], \(Dimension \[Rule] d\)\)]\)\)
                //StandardForm\)], "Input", CellTags -> "Dimension"], 
              Cell[BoxData[
                \(\(DiracGamma[\(\(LorentzIndex[\(\[Alpha], d\)]\), d\)]\)\ 
                   \(MetricTensor[\(m, n, \(Dimension \[Rule] d\)\)]\)\)], 
               "Output", CellTags -> "Dimension"]}, Open]], 
           Cell["Setting the global variable $LorentzIndices to True will \
display the dimension (if different from 4) as a subscript.", "Text", 
            CellTags -> "Dimension"], Cell[BoxData[
             \(\($LorentzIndices = True\) ;\)], "Input", CellTags -> 
             "Dimension"], Cell[CellGroupData[{Cell[BoxData[
                \(\(MetricTensor[\(\[Alpha], \[Beta], \(Dimension \[Rule] n\)
                      \)]\) \(DiracMatrix[
                     \(\[Alpha], \(Dimension \[Rule] n\)\)]\)\)], "Input", 
               CellTags -> "Dimension"], Cell[BoxData[FormBox[RowBox[
                  {SuperscriptBox["\[Gamma]", FormBox[SubscriptBox[FormBox[
                       "\[Alpha]", "TraditionalForm"], FormBox["n", 
                       "TraditionalForm"]], "TraditionalForm"]], " ", 
                   SuperscriptBox["g", RowBox[{FormBox[SubscriptBox[FormBox[
                         "\[Alpha]", "TraditionalForm"], FormBox["n", 
                         "TraditionalForm"]], "TraditionalForm"], FormBox[
                       SubscriptBox[FormBox["\[Beta]", "TraditionalForm"], 
                        FormBox["n", "TraditionalForm"]], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "Dimension"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "Dimension"], Cell[BoxData[
                \(\(DiracGamma[\(\(LorentzIndex[\(\[Alpha], n\)]\), n\)]\)\ 
                   \(MetricTensor[\(\[Alpha], \[Beta], 
                       \(Dimension \[Rule] n\)\)]\)\)], "Output", CellTags -> 
                "Dimension"]}, Open]], Cell[BoxData[
             \(\($LorentzIndices = False\) ;\)], "Input", 
            CellTags -> "Dimension"]}, Open]], Cell["DimensionalReduction", 
         "ObjectName", CellTags -> "DimensionalReduction"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DimensionalReduction"], 
           Cell[
            "DimensionalReduction is an option for TID and OneLoopSimplify.", 
            "Text", CellTags -> "DimensionalReduction"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["TID", RuleDelayed[ButtonData, "TID"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "TID"]], 
              ", ", 
              ButtonBox["OneLoopSimplify", 
                RuleDelayed[ButtonData, "OneLoopSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "OneLoopSimplify"]], "."}], "Text", 
            CellTags -> "DimensionalReduction"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["DiracBasis", "ObjectName", CellTags -> "DiracBasis"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracBasis"], Cell["DiracBasis[any] is a head which \
is wrapped around Dirac structures (and the 1) as a result of the function \
DiracReduce. Eventually you want to substitute DiracBasis by Identity (or \
set: DiracBasis[1] = S; DiracBasis[DiracMatrix[mu]] = P; etc.).", "Text", 
            CellTags -> "DiracBasis"], Cell[TextData[{"See also: ", 
              ButtonBox["DiracReduce", RuleDelayed[ButtonData, 
                 "DiracReduce"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracReduce"]], "."}], "Text", 
            CellTags -> "DiracBasis"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["DiracCanonical", "ObjectName", CellTags -> "DiracCanonical"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracCanonical"], Cell["DiracCanonical is an option \
for DiracSimplify. If set to True DiracSimplify uses the function DiracOrder \
internally.", "Text", CellTags -> "DiracCanonical"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], "."}], "Text", 
            CellTags -> "DiracCanonical"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["DiracEquation", "ObjectName", 
         CellTags -> "DiracEquation"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "DiracEquation"], 
           Cell["DiracEquation[exp] applies the Dirac equation without \
expanding exp. If that is needed, use DiracSimplify.", "Text", 
            CellTags -> "DiracEquation"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], "."}], "Text", 
            CellTags -> "DiracEquation"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracEquation"], Cell[CellGroupData[{Cell[BoxData[
                \(\(Spinor[\(\(Momentum[p]\), m, 1\)]\) . 
                   \(DiracGamma[\(Momentum[p]\)]\)\)], "Input", CellTags -> 
                "DiracEquation"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"\[CurlyPhi]", "(", FormBox["p", 
                      "TraditionalForm"], ",", "m", ")"}], ".", RowBox[
                    {"(", RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "DiracEquation"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracEquation[%]\)], "Input", CellTags -> "DiracEquation"], 
              Cell[BoxData[FormBox[RowBox[{"m", " ", RowBox[{"\[CurlyPhi]", 
                     "(", FormBox["p", "TraditionalForm"], ",", "m", ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracEquation"]}, 
             Open]]}, Open]], Cell["DiracGamma", "ObjectName", 
         CellTags -> "DiracGamma"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "DiracGamma"], 
           Cell[TextData[{"DiracGamma[x, dim] is the head of all Dirac \
matrices and slashes (in the internal representation). Use DiracMatrix (or \
GA, GAD) and DiracSlash (or GS, GSD) for manual (short) input. DiracGamma[x, \
4] simplifies to DiracGamma[x]. DiracGamma[5] is ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5\)\)]], 
              ". DiracGamma[6] is ", Cell[BoxData[
                \(TraditionalForm\`\(\((1 + \[Gamma]\^5)\)/2.\)\)]], 
              " DiracGamma[7] is ", Cell[BoxData[
                \(TraditionalForm\`\(\((1 - \[Gamma]\^5)\)/2.\)\)]]}], 
            "Text", CellTags -> "DiracGamma"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracGammaExpand", 
                RuleDelayed[ButtonData, "DiracGammaExpand"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGammaExpand"]], ", ", 
              ButtonBox["DiracMatrix", RuleDelayed[ButtonData, 
                 "DiracMatrix"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracMatrix"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DiracSlash", RuleDelayed[ButtonData, "DiracSlash"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSlash"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], "."}], "Text", 
            CellTags -> "DiracGamma"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracGamma"], Cell[CellGroupData[{Cell[BoxData[
                \(DiracGamma[5]\)], "Input", CellTags -> "DiracGamma"], 
              Cell[BoxData[\(TraditionalForm\`\(\[Gamma]\^5\)\)], "Output", 
               CellTags -> "DiracGamma"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DiracGamma[\(LorentzIndex[\[Alpha]]\)]\)], "Input", 
               CellTags -> "DiracGamma"], Cell[BoxData[FormBox[SuperscriptBox[
                  "\[Gamma]", FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                   "TraditionalForm"]], TraditionalForm]], "Output", 
               CellTags -> "DiracGamma"]}, Open]], 
           Cell[TextData[{"A Dirac-slash, i.e., ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] q\_\[Mu]\)\)]], 
              ", is displayed as ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma] \[CenterDot] q\)\)]], "."}], 
            "Text", CellTags -> "DiracGamma"], Cell[CellGroupData[
             {Cell[BoxData[\(\(DiracGamma[\(Momentum[q]\)]\)\ \)], "Input", 
               CellTags -> "DiracGamma"], Cell[BoxData[FormBox[RowBox[
                  {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                   "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracGamma"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracGamma[\(Momentum[q]\)]\)\ .\ 
                   \(DiracGamma[\(Momentum[\(p - q\)]\)]\)\)], "Input", 
               CellTags -> "DiracGamma"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                        "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                     RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", "(", FormBox[\(p - q\), 
                        "TraditionalForm"], ")"}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracGamma"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracGamma[\(\(Momentum[\(q, D\)]\), D\)]\)\ \)], 
               "Input", CellTags -> "DiracGamma"], Cell[BoxData[
                FormBox[RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                   "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracGamma"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(a1 = \(\(GS[\(p - q\)]\) . \(GS[p]\)\)\)], "Input", 
               CellTags -> "DiracGamma"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"(", RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
                       FormBox[\(p - q\), "TraditionalForm"], ")"}], ")"}], 
                   ".", \((\[Gamma] \[CenterDot] p)\)}], TraditionalForm]], 
               "Output", CellTags -> "DiracGamma"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(a2 = \(DiracGammaExpand[a1]\)\)]
                , "Input", CellTags -> "DiracGamma"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"(", RowBox[{RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         FormBox["p", "TraditionalForm"]}], "-", RowBox[
                        {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                         "\[CenterDot]", FormBox["q", "TraditionalForm"]}]}], 
                     ")"}], ".", RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                        "TraditionalForm"]}], ")"}]}], TraditionalForm]], 
               "Output", CellTags -> "DiracGamma"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(a3 = \(\(GAD[\[Mu]]\) . \(GSD[\(p - q\)]\) . \(GSD[q]\) . 
                     \(GAD[\[Mu]]\)\)\)], "Input", CellTags -> "DiracGamma"], 
              Cell[BoxData[FormBox[RowBox[{\(\[Gamma]\^\[Mu]\), ".", 
                   RowBox[{"(", RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
                       FormBox[\(p - q\), "TraditionalForm"], ")"}], ")"}], 
                   ".", \((\[Gamma] \[CenterDot] q)\), ".", 
                   \(\[Gamma]\^\[Mu]\)}], TraditionalForm]], "Output", 
               CellTags -> "DiracGamma"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(a4 = \(DiracTrick[a3]\)\)], 
               "Input", CellTags -> "DiracGamma"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{\((D - 4)\), " ", RowBox[
                      {RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", "(", FormBox[
                          \(p - q\), "TraditionalForm"], ")"}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}]}]}], "+", RowBox[
                    {"4", " ", RowBox[{"(", FormBox[\(p - q\), 
                        "TraditionalForm"], ")", "\[CenterDot]", FormBox["q", 
                        "TraditionalForm"]}]}]}], TraditionalForm]], 
               "Output", CellTags -> "DiracGamma"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(a5 = \(DiracSimplify[a4]\)\)], 
               "Input", CellTags -> "DiracGamma"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"D", " ", RowBox[{RowBox[{"(", 
                         RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                         ")"}], ".", RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q", "TraditionalForm"]}], ")"}]}]}], "-", 
                   RowBox[{"4", " ", RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["p", "TraditionalForm"]}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}]}]}], "+", RowBox[
                    {"4", " ", RowBox[{FormBox["p", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["q", "TraditionalForm"]}]}], 
                   "-", RowBox[{"D", " ", SuperscriptBox[FormBox["q", 
                       "TraditionalForm"], "2"]}]}], TraditionalForm]], 
               "Output", CellTags -> "DiracGamma"]}, Open]], Cell[BoxData[
             \(Clear[\(a1, a2, a3, a4, a5\)]\)], "Input", 
            CellTags -> "DiracGamma"]}, Open]], Cell["DiracGammaCombine", 
         "ObjectName", CellTags -> "DiracGammaCombine"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracGammaCombine"], Cell["DiracGammaCombine[exp] is \
(nearly) the inverse operation to DiracGammaExpand.", "Text", 
            CellTags -> "DiracGammaCombine"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracGamma", RuleDelayed[ButtonData, "DiracGamma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGamma"]], ", ", 
              ButtonBox["DiracGammaExpand", 
                RuleDelayed[ButtonData, "DiracGammaExpand"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGammaExpand"]], ", ", 
              ButtonBox["DiracMatrix", RuleDelayed[ButtonData, 
                 "DiracMatrix"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracMatrix"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DiracSlash", RuleDelayed[ButtonData, "DiracSlash"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSlash"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], "."}], "Text", 
            CellTags -> "DiracGammaCombine"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracGammaCombine"], Cell[CellGroupData[
             {Cell[BoxData[\(DiracGammaCombine[\(\(GS[p]\)\ +\ \(GS[q]\)\)]\)]
                , "Input", CellTags -> "DiracGammaCombine"], Cell[BoxData[
                FormBox[RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                   "\[CenterDot]", "(", FormBox[\(p + q\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "DiracGammaCombine"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(StandardForm[%]\)], "Input", 
               CellTags -> "DiracGammaCombine"], Cell[BoxData[
                \(DiracGamma[\(Momentum[\(p + q\)]\)]\)], "Output", 
               CellTags -> "DiracGammaCombine"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DiracGammaCombine[\(\(2\ \(GS[p]\)\)\ -\ \(2\ \(GS[q]\)\)\)
                   ]\)], "Input", CellTags -> "DiracGammaCombine"], 
              Cell[BoxData[FormBox[RowBox[{FormBox["\"\[Gamma]\"", 
                    "TraditionalForm"], "\[CenterDot]", "(", FormBox[
                    \(\(2\ p\) - \(2\ q\)\), "TraditionalForm"], ")"}], 
                 TraditionalForm]], "Output", CellTags -> 
                "DiracGammaCombine"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(StandardForm[%]\)], "Input", CellTags -> 
                "DiracGammaCombine"], Cell[BoxData[
                \(DiracGamma[\(Momentum[\(\(2\ p\) - \(2\ q\)\)]\)]\)], 
               "Output", CellTags -> "DiracGammaCombine"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracGammaExpand[%%]\)], 
               "Input", CellTags -> "DiracGammaCombine"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"2", " ", RowBox[{FormBox[
                        "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                       FormBox["p", "TraditionalForm"]}]}], "-", RowBox[
                    {"2", " ", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                        "TraditionalForm"]}]}]}], TraditionalForm]], 
               "Output", CellTags -> "DiracGammaCombine"]}, Open]]}, Open]], 
        Cell["DiracGammaExpand", "ObjectName", CellTags -> 
          "DiracGammaExpand"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "DiracGammaExpand"], Cell["DiracGammaExpand[exp] expands all \
DiracGamma[Momentum[a+b+..]] in exp into (DiracGamma[Momentum[a]] + \
DiracGamma[Momentum[b]] + ...).", "Text", CellTags -> "DiracGammaExpand"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracGamma", RuleDelayed[ButtonData, "DiracGamma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGamma"]], ", ", 
              ButtonBox["DiracGammaCombine", 
                RuleDelayed[ButtonData, "DiracGammaCombine"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGammaCombine"]], ", ", 
              ButtonBox["DiracMatrix", RuleDelayed[ButtonData, 
                 "DiracMatrix"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracMatrix"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DiracSlash", RuleDelayed[ButtonData, "DiracSlash"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSlash"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], "."}], "Text", 
            CellTags -> "DiracGammaExpand"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracGammaExpand"], Cell[CellGroupData[{Cell[BoxData[
                \(t = \(\(DiracGamma[\(Momentum[q]\)]\)\ .\ 
                     \(DiracGamma[\(Momentum[\(p - q\)]\)]\)\)\)], "Input", 
               CellTags -> "DiracGammaExpand"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                        "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                     RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", "(", FormBox[\(p - q\), 
                        "TraditionalForm"], ")"}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "DiracGammaExpand"]}, Open]], Cell["Momentum is the head of \
p-q, i.e., it is treated as one four-momentum.", "Text", CellTags -> 
             "DiracGammaExpand"], Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[t]\)], "Input", CellTags -> 
                "DiracGammaExpand"], Cell[BoxData[
                \(\(DiracGamma[\(Momentum[q]\)]\) . 
                   \(DiracGamma[\(Momentum[\(p - q\)]\)]\)\)], "Output", 
               CellTags -> "DiracGammaExpand"]}, Open]], 
           Cell["With DiracGammaExpand the Momentum[p-q] gets expanded.", 
            "Text", CellTags -> "DiracGammaExpand"], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracGammaExpand[t]\)], 
               "Input", CellTags -> "DiracGammaExpand"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                        "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                     RowBox[{RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], "-", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         FormBox["q", "TraditionalForm"]}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "DiracGammaExpand"]}, Open]], 
           Cell["The inverse operation is DiracGammaCombine.", "Text", 
            CellTags -> "DiracGammaExpand"], Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(DiracGammaCombine[\(DiracGammaExpand[t]\)]\)
                   ]\)], "Input", CellTags -> "DiracGammaExpand"], 
              Cell[BoxData[
                \(\(DiracGamma[\(Momentum[q]\)]\) . 
                   \(DiracGamma[\(Momentum[\(p - q\)]\)]\)\)], "Output", 
               CellTags -> "DiracGammaExpand"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(DiracGammaExpand[t]\)]\)], "Input", 
               CellTags -> "DiracGammaExpand"], Cell[BoxData[
                \(\(DiracGamma[\(Momentum[q]\)]\) . 
                   \((\(DiracGamma[\(Momentum[p]\)]\) - 
                      \(DiracGamma[\(Momentum[q]\)]\))\)\)], "Output", 
               CellTags -> "DiracGammaExpand"]}, Open]], 
           Cell[
            "In order to do non-commutative expansion use DiracSimplify.", 
            "Text", CellTags -> "DiracGammaExpand"], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracSimplify[t]\)], "Input", 
               CellTags -> "DiracGammaExpand"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                       RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                         "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                       ")"}]}], "-", SuperscriptBox[FormBox["q", 
                     "TraditionalForm"], "2"]}], TraditionalForm]], "Output", 
               CellTags -> "DiracGammaExpand"]}, Open]], Cell[BoxData[
             \(Clear[t]\)], "Input", CellTags -> "DiracGammaExpand"]}, 
          Open]], Cell["DiracGammaT", "ObjectName", CellTags -> 
          "DiracGammaT"], Cell[CellGroupData[{Cell["Description", 
            "Subsubsection", CellTags -> "DiracGammaT"], Cell["DiracGammaT[x] \
denotes the transpose of DiracGamma[x]. Transpose[DiracGammaT[x]] gives \
DiracGamma[x]. Note that x must have Head LorentzIndex or Momentum.", "Text", 
            CellTags -> "DiracGammaT"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracGamma", RuleDelayed[ButtonData, "DiracGamma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGamma"]], "."}], "Text", 
            CellTags -> "DiracGammaT"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracGammaT"], Cell[CellGroupData[{Cell[BoxData[
                \(DiracGammaT[\(LorentzIndex[\[Mu]]\)]\)], "Input", 
               CellTags -> "DiracGammaT"], Cell[BoxData[FormBox[
                 SubsuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                    "TraditionalForm"], "TraditionalForm"], "T"], 
                 TraditionalForm]], "Output", CellTags -> "DiracGammaT"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(Transpose[%]\)], 
               "Input", CellTags -> "DiracGammaT"], Cell[BoxData[
                FormBox[SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                    "TraditionalForm"], "TraditionalForm"]], 
                 TraditionalForm]], "Output", CellTags -> "DiracGammaT"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(GS[p]\)//FCI\)//Transpose\)], "Input", CellTags -> 
                "DiracGammaT"], Cell[BoxData[FormBox[SuperscriptBox[
                  RowBox[{"(", "\[Gamma]", "\[CenterDot]", FormBox["p", 
                     "TraditionalForm"], ")"}], "T"], TraditionalForm]], 
               "Output", CellTags -> "DiracGammaT"]}, Open]]}, Open]], 
        Cell["DiracMatrix", "ObjectName", CellTags -> "DiracMatrix"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracMatrix"], Cell[TextData[{"DiracMatrix[", 
              Cell[BoxData[\(TraditionalForm\`\[Mu]\)]], 
              "] denotes a Dirac gamma matrix with Lorentz index ", 
              Cell[BoxData[\(TraditionalForm\`\[Mu]\)]], ". DiracMatrix[", 
              Cell[BoxData[\(TraditionalForm\`\(\(\[Mu], \[Nu],\)\ \)\)]], 
              "...] is a product of ", Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\)]], 
              " matrices with Lorentz indices ", Cell[BoxData[
                \(TraditionalForm\`\(\[Mu],\ \[Nu],\ ...\)\)]], 
              " DiracMatrix[5] is ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5\)\)]], 
              ". DiracMatrix[6] is ", Cell[BoxData[
                \(TraditionalForm\`\(1/2\)\)]], Cell[BoxData[
                \(TraditionalForm\`\(\ \(\(+\ \[Gamma]\^5\)/2\)\)\)]], 
              ". DiracMatrix[7] is", Cell[BoxData[
                \(TraditionalForm\`\(\ \(1/2\)\)\)]], Cell[BoxData[
                \(TraditionalForm\`\(\ \(\(-\ \[Gamma]\^5\)/2\)\)\)]], "."}], 
            "Text", CellTags -> "DiracMatrix"], Cell[CellGroupData[
             {Cell[BoxData[\(Options[DiracMatrix]\)], "Input", CellTags -> 
                "DiracMatrix"], Cell[BoxData[
                \(TraditionalForm\`\({\(Dimension \[Rule] 4\), 
                      \(FeynCalcInternal \[Rule] True\)}\)\)], "Output", 
               CellTags -> "DiracMatrix"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracGammaExpand", 
                RuleDelayed[ButtonData, "DiracGammaExpand"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGammaExpand"]], ", ", 
              ButtonBox["DiracGamma", RuleDelayed[ButtonData, "DiracGamma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGamma"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DiracSlash", RuleDelayed[ButtonData, "DiracSlash"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSlash"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], ", ", 
              ButtonBox["GA", RuleDelayed[ButtonData, "GA"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "GA"]], 
              ", ", 
              ButtonBox["GAD", RuleDelayed[ButtonData, "GAD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "GAD"]], 
              ", ", 
              ButtonBox["GS", RuleDelayed[ButtonData, "GS"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "GS"]], 
              ", ", 
              ButtonBox["GSD", RuleDelayed[ButtonData, "GSD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "GSD"]], 
              "."}], "Text", CellTags -> "DiracMatrix"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracMatrix"], Cell[CellGroupData[{Cell[BoxData[
                \(DiracMatrix[\[Mu]]\)], "Input", CellTags -> "DiracMatrix"], 
              Cell[BoxData[FormBox[SuperscriptBox["\[Gamma]", FormBox[
                   FormBox["\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                 TraditionalForm]], "Output", CellTags -> "DiracMatrix"]}, 
             Open]], Cell[TextData[
             {"This is how to enter the non-commutative product of two ", 
              Cell[BoxData[FormBox[RowBox[{SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]], SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]]], ". The ", 
              StyleBox["Mathematica", Rule[FontSlant, "Italic"]], " Dot \".\" \
is used as non-commutative multiplication operator."}], "Text", 
            CellTags -> "DiracMatrix"], Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracMatrix[\[Mu]]\) . \(DiracMatrix[\[Nu]]\)\)], 
               "Input", CellTags -> "DiracMatrix"], Cell[BoxData[
                FormBox[RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                      "\[Mu]", "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracMatrix"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracMatrix[\[Alpha]]\)//StandardForm\)], "Input", 
               CellTags -> "DiracMatrix"], Cell[BoxData[
                \(DiracGamma[\(LorentzIndex[\[Alpha]]\)]\)], "Output", 
               CellTags -> "DiracMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(\(DiracMatrix[\[Mu]]\)//FCE\)], 
               "Input", CellTags -> "DiracMatrix"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu]\)\)], "Output", 
               CellTags -> "DiracMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "DiracMatrix"], Cell[BoxData[\(GA[\[Mu]]\)], 
               "Output", CellTags -> "DiracMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(GAD[\[Mu]]\)], "Input", 
               CellTags -> "DiracMatrix"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu]\)\)], "Output", 
               CellTags -> "DiracMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(\(%//FCI\)//StandardForm\)], 
               "Input", CellTags -> "DiracMatrix"], Cell[BoxData[
                \(DiracGamma[\(\(LorentzIndex[\(\[Mu], D\)]\), D\)]\)], 
               "Output", CellTags -> "DiracMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(GA[\(\[Mu], \[Nu], \[Rho]\)]\)]
                , "Input", CellTags -> "DiracMatrix"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^\[Rho]\)\)], "Output", CellTags -> 
                "DiracMatrix"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(GA[\(a\ .\ b\)]\)//FCI\)], "Input", CellTags -> 
                "DiracMatrix"], Cell[BoxData[FormBox[RowBox[{SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["a", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["b", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "DiracMatrix"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "DiracMatrix"], Cell[BoxData[
                \(\(DiracGamma[\(LorentzIndex[a]\)]\) . 
                   \(DiracGamma[\(LorentzIndex[b]\)]\)\)], "Output", 
               CellTags -> "DiracMatrix"]}, Open]]}, Open]], 
        Cell["DiracOrder", "ObjectName", CellTags -> "DiracOrder"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracOrder"], Cell["DiracOrder[expr] orders the \
Dirac matrices in expr alphabetically. DiracOrder[expr,orderlist] orders the \
Dirac matrices in expr according to orderlist.", "Text", CellTags -> 
             "DiracOrder"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], "."}], "Text", 
            CellTags -> "DiracOrder"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracOrder"], Cell[CellGroupData[{Cell[BoxData[
                \(t1\ =\ \(GA[\(\[Beta], \[Alpha]\)]\)\)], "Input", 
               CellTags -> "DiracOrder"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Beta] . \[Gamma]\^\[Alpha]\)
                  \)], "Output", CellTags -> "DiracOrder"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracOrder[t1]\)], "Input", 
               CellTags -> "DiracOrder"], Cell[BoxData[FormBox[RowBox[{
                   \(2\ g\^\(\[Alpha]\[Beta]\)\), "-", RowBox[{SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Alpha]", 
                        "TraditionalForm"], "TraditionalForm"]], ".", 
                     SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Beta]", 
                        "TraditionalForm"], "TraditionalForm"]]}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracOrder"]}, 
             Open]], Cell[
            "This is a string of Dirac matrices in D dimensions. ", "Text", 
            CellTags -> "DiracOrder"], Cell[CellGroupData[{Cell[BoxData[
                \(t2 = \(GAD[\(\[Mu], \[Nu], \[Mu]\)]\)\)], "Input", 
               CellTags -> "DiracOrder"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^\[Mu]\)\)], "Output", CellTags -> 
                "DiracOrder"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracOrder[t1]\)], "Input", CellTags -> "DiracOrder"], 
              Cell[BoxData[FormBox[RowBox[{\(2\ g\^\(\[Alpha]\[Beta]\)\), 
                   "-", RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Alpha]", "TraditionalForm"], "TraditionalForm"]], 
                     ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Beta]", "TraditionalForm"], 
                       "TraditionalForm"]]}]}], TraditionalForm]], "Output", 
               CellTags -> "DiracOrder"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t3 = \(GA[\(5, \[Mu], \[Nu]\)]\)\)], "Input", CellTags -> 
                "DiracOrder"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5 . \[Gamma]\^\[Mu] . 
                     \[Gamma]\^\[Nu]\)\)], "Output", CellTags -> 
                "DiracOrder"]}, Open]], Cell[TextData[{"By default ", 
              Cell[BoxData[\(TraditionalForm\`\(\[Gamma]\^\(5\ \)\)\)]], 
              "is moved to the right."}], "Text", CellTags -> "DiracOrder"], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracOrder[t3]\)], "Input", 
               CellTags -> "DiracOrder"], Cell[BoxData[FormBox[RowBox[
                  {SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(\[Gamma]\^5\)}], TraditionalForm]], "Output", 
               CellTags -> "DiracOrder"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(t4 = \(GA[\(6, \[Mu], 7\)]\)\)]
                , "Input", CellTags -> "DiracOrder"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^6 . \[Gamma]\^\[Mu] . 
                     \[Gamma]\^7\)\)], "Output", CellTags -> "DiracOrder"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(DiracOrder[t4]\)], 
               "Input", CellTags -> "DiracOrder"], Cell[BoxData[
                FormBox[RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                      "\[Mu]", "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(\[Gamma]\^7\)}], TraditionalForm]], "Output", 
               CellTags -> "DiracOrder"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t5 = \(GA[\(\[Alpha], \[Beta], \[Delta]\)]\)\)], "Input", 
               CellTags -> "DiracOrder"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Alpha] . \[Gamma]\^\[Beta] .
                      \[Gamma]\^\[Delta]\)\)], "Output", CellTags -> 
                "DiracOrder"]}, Open]], Cell[TextData[{"This orders the ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Alpha] \[Gamma]\^\[Beta] 
                     \[Gamma]\^\[Delta]\)\)]], " in reverse order."}], 
            "Text", CellTags -> "DiracOrder"], Cell[CellGroupData[
             {Cell[BoxData[
                \(DiracOrder[\(t5, \({\[Delta], \[Beta], \[Alpha]}\)\)]\)], 
               "Input", CellTags -> "DiracOrder"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"-", RowBox[{SuperscriptBox[
                        "\[Gamma]", FormBox[FormBox["\[Delta]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Beta]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Alpha]", 
                          "TraditionalForm"], "TraditionalForm"]]}]}], "+", 
                   RowBox[{"2", " ", SuperscriptBox["\[Gamma]", FormBox[
                       FormBox["\[Delta]", "TraditionalForm"], 
                       "TraditionalForm"]], " ", \(g\^\(\[Alpha]\[Beta]\)\)}]
                     , "-", RowBox[{"2", " ", SuperscriptBox["\[Gamma]", 
                      FormBox[FormBox["\[Beta]", "TraditionalForm"], 
                       "TraditionalForm"]], " ", \(g\^\(\[Alpha]\[Delta]\)\)}]
                     , "+", RowBox[{"2", " ", SuperscriptBox["\[Gamma]", 
                      FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                       "TraditionalForm"]], " ", \(g\^\(\[Beta]\[Delta]\)\)}]}
                     ], TraditionalForm]], "Output", CellTags -> 
                "DiracOrder"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracOrder[%]\)], "Input", CellTags -> "DiracOrder"], 
              Cell[BoxData[FormBox[RowBox[{SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Beta]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Delta]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "DiracOrder"]}, Open]], Cell[BoxData[
             \(\(Clear[\(t1, t2, t3, t4, t5\)]\) ;\)], "Input", 
            CellTags -> "DiracOrder"]}, Open]], Cell["DiracReduce", 
         "ObjectName", CellTags -> "DiracReduce"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracReduce"], Cell["DiracReduce[exp] reduces all \
four-dimensional Dirac matrices in exp to the standard basis (S,P,V,A,T) \
using the Chisholm identity (see Chisholm). In the result the basic Dirac \
structures are wrapped with a head DiracBasis. I.e., S corresponds to \
DiracBasis[1], P : DiracBasis[DiracMatrix[5]], V: \
DiracBasis[DiracMatrix[mu]], A: DiracBasis[DiracMatrix[mu, 5]], T: \
DiracBasis[DiracSigma[DiracMatrix[mu, nu]]]. By default DiracBasis is \
substituted to Identity. Notice that the result of DiracReduce is given in \
the FeynCalcExternal-way, i.e.,evtl. you may have to use FeynCalcInternal on \
the result.", "Text", CellTags -> "DiracReduce"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[DiracReduce]\)], 
               "Input", CellTags -> "DiracReduce"], Cell[BoxData[
                \(TraditionalForm\`\({\(Factoring \[Rule] False\), 
                      \(FinalSubstitutions \[Rule] 
                        \({DiracBasis \[Rule] Identity}\)\)}\)\)], "Output", 
               CellTags -> "DiracReduce"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], "."}], "Text", 
            CellTags -> "DiracReduce"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracReduce"], Cell[CellGroupData[{Cell[BoxData[
                \(t1\ =\ \(GA[\(\[Mu], \[Nu]\)]\)\)], "Input", CellTags -> 
                "DiracReduce"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu]\)\)], 
               "Output", CellTags -> "DiracReduce"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracReduce[t1]\)], "Input", 
               CellTags -> "DiracReduce"], Cell[BoxData[
                \(TraditionalForm\`\(g\^\(\[Mu]\[Nu]\) - 
                     \(\[ImaginaryI]\ \[Sigma]\^\(\[Mu]\[Nu]\)\)\)\)], 
               "Output", CellTags -> "DiracReduce"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t2 = \(DiracMatrix[\(\[Mu], \[Nu], \[Rho]\)]\)\)], "Input", 
               CellTags -> "DiracReduce"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] \[Gamma]\^\[Nu] 
                     \[Gamma]\^\[Rho]\)\)], "Output", CellTags -> 
                "DiracReduce"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracReduce[t2]\)], "Input", CellTags -> "DiracReduce"], 
              Cell[BoxData[FormBox[RowBox[{RowBox[{"\[ImaginaryI]", " ", 
                     \(\[Gamma]\^\($MU \[InvisibleApplication] \((1)\)\) . 
                        \[Gamma]\^5\), " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{"\[Mu]", "\[Nu]", "\[Rho]", FormBox[
                         \($MU \[InvisibleApplication] \((1)\)\), 
                         "TraditionalForm"]}]]}], "+", 
                   \(\[Gamma]\^\[Rho]\ g\^\(\[Mu]\[Nu]\)\), "-", 
                   \(\[Gamma]\^\[Nu]\ g\^\(\[Mu]\[Rho]\)\), "+", 
                   \(\[Gamma]\^\[Mu]\ g\^\(\[Nu]\[Rho]\)\)}], 
                 TraditionalForm]], "Output", CellTags -> "DiracReduce"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t3 = \(DiracMatrix[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\)\)]\
, "Input", CellTags -> "DiracReduce"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] \[Gamma]\^\[Nu] 
                     \[Gamma]\^\[Rho] \[Gamma]\^\[Sigma]\)\)], "Output", 
               CellTags -> "DiracReduce"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(t4 = \(DiracReduce[t3]\)\)], 
               "Input", CellTags -> "DiracReduce"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(-\[ImaginaryI]\)\ \[Gamma]\^5\ 
                       \[Epsilon]\^\(\[Mu]\[Nu]\[Rho]\[Sigma]\)\) - 
                     \(\[ImaginaryI]\ \[Sigma]\^\(\[Rho]\[Sigma]\)\ 
                       g\^\(\[Mu]\[Nu]\)\) + 
                     \(\[ImaginaryI]\ \[Sigma]\^\(\[Nu]\[Sigma]\)\ 
                       g\^\(\[Mu]\[Rho]\)\) - 
                     \(\[ImaginaryI]\ \[Sigma]\^\(\[Nu]\[Rho]\)\ 
                       g\^\(\[Mu]\[Sigma]\)\) - 
                     \(\[ImaginaryI]\ \[Sigma]\^\(\[Mu]\[Sigma]\)\ 
                       g\^\(\[Nu]\[Rho]\)\) + 
                     \(g\^\(\[Mu]\[Sigma]\)\ g\^\(\[Nu]\[Rho]\)\) + 
                     \(\[ImaginaryI]\ \[Sigma]\^\(\[Mu]\[Rho]\)\ 
                       g\^\(\[Nu]\[Sigma]\)\) - 
                     \(g\^\(\[Mu]\[Rho]\)\ g\^\(\[Nu]\[Sigma]\)\) - 
                     \(\[ImaginaryI]\ \[Sigma]\^\(\[Mu]\[Nu]\)\ 
                       g\^\(\[Rho]\[Sigma]\)\) + 
                     \(g\^\(\[Mu]\[Nu]\)\ g\^\(\[Rho]\[Sigma]\)\)\)\)], 
               "Output", CellTags -> "DiracReduce"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t5\ = \(Calc[\(DiracSimplify[
                       \(DiracSigmaExplicit[\(t4 . t4\)]\)]\)]\)\)], "Input", 
               CellTags -> "DiracReduce"], Cell[BoxData[
                \(TraditionalForm\`\(-128\)\)], "Output", CellTags -> 
                "DiracReduce"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Calc[\(t4 . t4\)]\)], "Input", CellTags -> "DiracReduce"], 
              Cell[BoxData[\(TraditionalForm\`\(-128\)\)], "Output", 
               CellTags -> "DiracReduce"]}, Open]], Cell[BoxData[
             \(Clear[\(t1, t2, t3, t4\)]\)], "Input", CellTags -> 
             "DiracReduce"]}, Open]], Cell["DiracSigma", "ObjectName", 
         CellTags -> "DiracSigma"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "DiracSigma"], 
           Cell["DiracSigma[a, b] stands for i/2*(a . b - b . a) in 4 \
dimensions. a and b must have Head DiracGamma, DiracMatrix or DiracSlash. \
Only antisymmetry is implemented.", "Text", CellTags -> "DiracSigma"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracSigmaExplicit", 
                RuleDelayed[ButtonData, "DiracSigmaExplicit"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSigmaExplicit"]], "."}], "Text", 
            CellTags -> "DiracSigma"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracSigma"], Cell[CellGroupData[{Cell[BoxData[
                \(t1 = \(DiracSigma[\(\(GA[\[Alpha]]\), \(GA[\[Beta]]\)\)]\)
                  \)], "Input", CellTags -> "DiracSigma"], Cell[BoxData[
                \(TraditionalForm\`\(\[Sigma]\^\(\[Alpha]\[Beta]\)\)\)], 
               "Output", CellTags -> "DiracSigma"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracSigmaExplicit[t1]\)], 
               "Input", CellTags -> "DiracSigma"], Cell[BoxData[
                FormBox[RowBox[{\(1\/2\), " ", "\[ImaginaryI]", " ", 
                   RowBox[{"(", RowBox[{RowBox[{SuperscriptBox["\[Gamma]", 
                          FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox["\[Beta]", 
                          "TraditionalForm"], "TraditionalForm"]]}], "-", 
                       RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Beta]", "TraditionalForm"], "TraditionalForm"]], 
                         ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Alpha]", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracSigma"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t2 = \(DiracSigma[\(\(GA[\[Beta]]\), \(GA[\[Alpha]]\)\)]\)
                  \)], "Input", CellTags -> "DiracSigma"], Cell[BoxData[
                \(TraditionalForm\`\(-\[Sigma]\^\(\[Alpha]\[Beta]\)\)\)], 
               "Output", CellTags -> "DiracSigma"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t3 = \(DiracSigma[\(\(GS[p]\), \(GS[q]\)\)]\)\)], "Input", 
               CellTags -> "DiracSigma"], Cell[BoxData[
                \(TraditionalForm\`\(\[Sigma]\^\(pq\)\)\)], "Output", 
               CellTags -> "DiracSigma"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracSigmaExplicit[t3]\)], 
               "Input", CellTags -> "DiracSigma"], Cell[BoxData[
                FormBox[RowBox[{\(1\/2\), " ", "\[ImaginaryI]", " ", 
                   RowBox[{"(", RowBox[{RowBox[{RowBox[{"(", RowBox[
                          {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                          ")"}], ".", RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q", "TraditionalForm"]}], ")"}]}], "-", 
                       RowBox[{RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                          RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                          ")"}]}]}], ")"}]}], TraditionalForm]], "Output", 
               CellTags -> "DiracSigma"]}, Open]], Cell[BoxData[
             \(Clear[\(t1, t2, t3\)]\)], "Input", CellTags -> "DiracSigma"]}, 
          Open]], Cell["DiracSigmaExplicit", "ObjectName", 
         CellTags -> "DiracSigmaExplicit"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracSigmaExplicit"], Cell["DiracSigmaExplicit[exp] \
inserts in exp for all DiracSigma its definition. DiracSigmaExplict is also \
an option of DiracSimplify.", "Text", CellTags -> "DiracSigmaExplicit"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracSigma", RuleDelayed[ButtonData, "DiracSigma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSigma"]], "."}], "Text", 
            CellTags -> "DiracSigmaExplicit"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracSigmaExplicit"], Cell[CellGroupData[
             {Cell[BoxData[
                \(DiracSigma[\(\(GA[\[Alpha]]\), \(GA[\[Beta]]\)\)]\)], 
               "Input", CellTags -> "DiracSigmaExplicit"], Cell[BoxData[
                \(TraditionalForm\`\(\[Sigma]\^\(\[Alpha]\[Beta]\)\)\)], 
               "Output", CellTags -> "DiracSigmaExplicit"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracSigmaExplicit[%]\)], 
               "Input", CellTags -> "DiracSigmaExplicit"], Cell[BoxData[
                FormBox[RowBox[{\(1\/2\), " ", "\[ImaginaryI]", " ", 
                   RowBox[{"(", RowBox[{RowBox[{SuperscriptBox["\[Gamma]", 
                          FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox["\[Beta]", 
                          "TraditionalForm"], "TraditionalForm"]]}], "-", 
                       RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Beta]", "TraditionalForm"], "TraditionalForm"]], 
                         ".", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          "\[Alpha]", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "DiracSigmaExplicit"]}, Open]]}, Open]], 
        Cell["DiracSimpCombine", "ObjectName", CellTags -> 
          "DiracSimpCombine"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "DiracSimpCombine"], Cell["DiracSimpCombine is an option for \
DiracSimplify. If set to True, sums of DiracGamma's will be merged as much as \
possible in DiracGamma[ .. + .. + ]'s.", "Text", CellTags -> 
             "DiracSimpCombine"], Cell[TextData[{"See also: ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], "."}], "Text", 
            CellTags -> "DiracSimpCombine"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["DiracSimplify", "ObjectName", 
         CellTags -> "DiracSimplify"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "DiracSimplify"], 
           Cell["DiracSimplify[expr] simplifies products of Dirac matrices in \
expr and expands non-commutative products. Double Lorentz indices and four \
vectors are contracted. The Dirac equation is applied. All DiracMatrix[5], \
DiracMatrix[6] and DiracMatrix[7] are moved to the right. The order of the \
other Dirac matrices is not changed.", "Text", CellTags -> "DiracSimplify"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[DiracSimplify]\)], 
               "Input", CellTags -> "DiracSimplify"], Cell[BoxData[
                \(TraditionalForm\`\({\(DiracCanonical \[Rule] False\), 
                      \(DiracSigmaExplicit \[Rule] True\), 
                      \(DiracSimpCombine \[Rule] False\), 
                      \(DiracSubstitute67 \[Rule] False\), 
                      \(Expanding \[Rule] True\), \(Factoring \[Rule] False\)
                      , \(FeynCalcInternal \[Rule] False\), 
                      \(InsideDiracTrace \[Rule] False\)}\)\)], "Output", 
               CellTags -> "DiracSimplify"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Calc", RuleDelayed[ButtonData, "Calc"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Calc"]], 
              ", ", 
              ButtonBox["DiracGammaExpand", 
                RuleDelayed[ButtonData, "DiracGammaExpand"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGammaExpand"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], "."}], "Text", 
            CellTags -> "DiracSimplify"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracSimplify"], 
           Cell["This is a string of Dirac matrices in four dimensions. ", 
            "Text", CellTags -> "DiracSimplify"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t1 = \(GA[\(\[Mu], \[Nu], \[Mu]\)]\)\)], "Input", 
               CellTags -> "DiracSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^\[Mu]\)\)], "Output", CellTags -> 
                "DiracSimplify"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracSimplify[t1]\)], "Input", CellTags -> 
                "DiracSimplify"], Cell[BoxData[FormBox[RowBox[{\(-2\), " ", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracSimplify"]}, 
             Open]], Cell[
            "This is a string of Dirac matrices in D dimensions. ", "Text", 
            CellTags -> "DiracSimplify"], Cell[CellGroupData[{Cell[BoxData[
                \(t2 = \(GAD[\(\[Mu], \[Nu], \[Mu]\)]\)\)], "Input", 
               CellTags -> "DiracSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^\[Mu]\)\)], "Output", CellTags -> 
                "DiracSimplify"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracSimplify[t1]\)], "Input", CellTags -> 
                "DiracSimplify"], Cell[BoxData[FormBox[RowBox[{\(-2\), " ", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracSimplify"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t3 = \(GA[\(5, \[Mu], \[Nu]\)]\)\)], "Input", CellTags -> 
                "DiracSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5 . \[Gamma]\^\[Mu] . 
                     \[Gamma]\^\[Nu]\)\)], "Output", CellTags -> 
                "DiracSimplify"]}, Open]], Cell[TextData[{"By default ", 
              Cell[BoxData[\(TraditionalForm\`\(\[Gamma]\^5\)\)]], 
              "is moved to the right."}], "Text", CellTags -> 
             "DiracSimplify"], Cell[CellGroupData[{Cell[BoxData[
                \(DiracSimplify[t3]\)], "Input", CellTags -> 
                "DiracSimplify"], Cell[BoxData[FormBox[RowBox[
                  {SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(\[Gamma]\^5\)}], TraditionalForm]], "Output", 
               CellTags -> "DiracSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(t4 = \(GA[\(6, \[Mu], 7\)]\)\)]
                , "Input", CellTags -> "DiracSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^6 . \[Gamma]\^\[Mu] . 
                     \[Gamma]\^7\)\)], "Output", CellTags -> 
                "DiracSimplify"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracSimplify[t4]\)], "Input", CellTags -> 
                "DiracSimplify"], Cell[BoxData[FormBox[RowBox[
                  {SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(\[Gamma]\^7\)}], TraditionalForm]], "Output", 
               CellTags -> "DiracSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t5 = \(\(GS[\(a + b\)]\)\ .\ \(GS[p]\) . \(GS[p]\) . 
                     \(GS[\(c + d\)]\)\)\)], "Input", CellTags -> 
                "DiracSimplify"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"(", RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
                       FormBox[\(a + b\), "TraditionalForm"], ")"}], ")"}], 
                   ".", \((\[Gamma] \[CenterDot] p)\), ".", 
                   \((\[Gamma] \[CenterDot] p)\), ".", RowBox[{"(", 
                     RowBox[{"\[Gamma]", "\[CenterDot]", "(", FormBox[
                        \(c + d\), "TraditionalForm"], ")"}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracSimplify"]}, 
             Open]], Cell["Contrary to DiracTrick DiracSimplify does \
non-commutative expansion.", "Text", CellTags -> "DiracSimplify"], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracSimplify[t5]\)], "Input", 
               CellTags -> "DiracSimplify"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["a", "TraditionalForm"]}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["c", 
                          "TraditionalForm"]}], ")"}]}], " ", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], "2"]}], "+", 
                   RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["a", "TraditionalForm"]}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["d", 
                          "TraditionalForm"]}], ")"}]}], " ", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], "2"]}], "+", 
                   RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["b", "TraditionalForm"]}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["c", 
                          "TraditionalForm"]}], ")"}]}], " ", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], "2"]}], "+", 
                   RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["b", "TraditionalForm"]}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["d", 
                          "TraditionalForm"]}], ")"}]}], " ", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], "2"]}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracSimplify"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(DiracTrick[t5]\)], 
               "Input", CellTags -> "DiracSimplify"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         "(", FormBox[\(a + b\), "TraditionalForm"], ")"}], 
                       ")"}], ".", RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         "(", FormBox[\(c + d\), "TraditionalForm"], ")"}], 
                       ")"}]}], " ", SuperscriptBox[FormBox["p", 
                     "TraditionalForm"], "2"]}], TraditionalForm]], "Output", 
               CellTags -> "DiracSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t6\ =\ \(\(SpinorVBar[p]\)\ .\ \(GS[p]\)\ .\ 
                     \(SpinorUBar[q]\)\)\)], "Input", CellTags -> 
                "DiracSimplify"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{FormBox[\("v"\&_\), "TraditionalForm"], "(", "p", 
                     ")"}], ".", \((\[Gamma] \[CenterDot] p)\), ".", 
                   RowBox[{FormBox[\("u"\&_\), "TraditionalForm"], "(", "q", 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "DiracSimplify"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracSimplify[t6]\)], "Input", CellTags -> 
                "DiracSimplify"], Cell[BoxData[\(TraditionalForm\`0\)], 
               "Output", CellTags -> "DiracSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(GAD @@ \(Join[\(\({\[Mu]}\), 
                       \(Table[\(\[Nu]\_i, \({i, 6}\)\)]\), \({\[Mu]}\)\)]\)\
\)], "Input", CellTags -> "DiracSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\(\[Nu]\_1\)
                      . \[Gamma]\^\(\[Nu]\_2\) . \[Gamma]\^\(\[Nu]\_3\) . 
                     \[Gamma]\^\(\[Nu]\_4\) . \[Gamma]\^\(\[Nu]\_5\) . 
                     \[Gamma]\^\(\[Nu]\_6\) . \[Gamma]\^\[Mu]\)\)], "Output", 
               CellTags -> "DiracSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracSimplify[%]\)], "Input", 
               CellTags -> "DiracSimplify"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{"D", " ", RowBox[{SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}]}], "-", RowBox[{"12", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}]}], "+", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_1 \[Nu]\_2\)\)}], "-", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_1 \[Nu]\_3\)\)}], "+", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_1 \[Nu]\_4\)\)}], "-", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_1 \[Nu]\_5\)\)}], "+", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_1 \[Nu]\_6\)\)}], "+", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_2 \[Nu]\_3\)\)}], "-", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_2 \[Nu]\_4\)\)}], "+", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_2 \[Nu]\_5\)\)}], "-", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_2 \[Nu]\_6\)\)}], "+", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_3 \[Nu]\_4\)\)}], "-", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_3 \[Nu]\_5\)\)}], "+", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_3 \[Nu]\_6\)\)}], "+", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_6\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_4 \[Nu]\_5\)\)}], "-", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_5\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_4 \[Nu]\_6\)\)}], "+", RowBox[{"4", " ", 
                     RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_2\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox[\(\[Nu]\_4\), "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", 
                     \(g\^\(\[Nu]\_5 \[Nu]\_6\)\)}]}], TraditionalForm]], 
               "Output", CellTags -> "DiracSimplify"]}, Open]], 
           Cell[
            " With the option DiracCanonical an alphabetic ordering is done."\
, "Text", CellTags -> "DiracSimplify"], Cell[CellGroupData[{Cell[BoxData[
                \(DiracSimplify[\(\(GA[\(\[Nu], \[Mu]\)]\), 
                     \(DiracCanonical \[Rule] True\)\)]\)], "Input", 
               CellTags -> "DiracSimplify"], Cell[BoxData[FormBox[RowBox[{
                   \(2\ g\^\(\[Mu]\[Nu]\)\), "-", RowBox[{SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"]], ".", 
                     SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"]]}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracSimplify"]}, 
             Open]], Cell["Setting InsideDiracTrace\[Rule]True assumes that a \
trace is still to be taken later on.", "Text", CellTags -> "DiracSimplify"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DiracSimplify[\(\(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\),
                      \(InsideDiracTrace \[Rule] True\)\)]\)], "Input", 
               CellTags -> "DiracSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\(g\^\(\[Mu]\[Sigma]\)\ 
                       g\^\(\[Nu]\[Rho]\)\) - 
                     \(g\^\(\[Mu]\[Rho]\)\ g\^\(\[Nu]\[Sigma]\)\) + 
                     \(g\^\(\[Mu]\[Nu]\)\ g\^\(\[Rho]\[Sigma]\)\)\)\)], 
               "Output", CellTags -> "DiracSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DiracSimplify[\(\(GA[\(\[Mu], \[Nu], \[Rho]\)]\), 
                     \(InsideDiracTrace \[Rule] True\)\)]\)], "Input", 
               CellTags -> "DiracSimplify"], Cell[BoxData[
                \(TraditionalForm\`0\)], "Output", CellTags -> 
                "DiracSimplify"]}, Open]], Cell[BoxData[
             \(Clear[\(t1, t2, t3, t4, t5, t6\)]\)], "Input", 
            CellTags -> "DiracSimplify"]}, Open]], Cell["DiracSimplify2", 
         "ObjectName", CellTags -> "DiracSimplify2"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracSimplify2"], Cell[TextData[{"DiracSimplify2[exp\
] simplifies the Dirac structure but leaves any ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5\)\)]], " untouched."}], 
            "Text", CellTags -> "DiracSimplify2"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], "."}], "Text", 
            CellTags -> "DiracSimplify2"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracSimplify2"], Cell[CellGroupData[{Cell[BoxData[
                \(GAD[\(\[Mu], \[Nu], \[Mu], 5, \[Alpha], \[Beta], \[Alpha]\)
                   ]\)], "Input", CellTags -> "DiracSimplify2"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^\[Mu] . \[Gamma]\^5 . \[Gamma]\^\[Alpha] . 
                     \[Gamma]\^\[Beta] . \[Gamma]\^\[Alpha]\)\)], "Output", 
               CellTags -> "DiracSimplify2"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracSimplify2[%]\)], "Input", 
               CellTags -> "DiracSimplify2"], Cell[BoxData[FormBox[
                 RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(\[Gamma]\^5\), ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Beta]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "DiracSimplify2"]}, Open]]}, Open]], 
        Cell["DiracSlash", "ObjectName", CellTags -> "DiracSlash"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracSlash"], Cell[TextData[
             {"DiracSlash[p] is the contraction ", Cell[BoxData[
                \(TraditionalForm\`\(p\^\[Mu] \[Gamma]\_\(\[Mu]\ \)\)\)]], 
              "(FourVector[p, ", Cell[BoxData[\(TraditionalForm\`\[Mu]\)]], 
              "] DiracMatrix[", Cell[BoxData[\(TraditionalForm\`\[Mu]\)]], "]\
). Products of those can be entered in the form DiracSlash[p1, p2, ...]."}], 
            "Text", CellTags -> "DiracSlash"], Cell[CellGroupData[
             {Cell[BoxData[\(Options[DiracSlash]\)], "Input", CellTags -> 
                "DiracSlash"], Cell[BoxData[
                \(TraditionalForm\`\({\(Dimension \[Rule] 4\), 
                      \(FeynCalcInternal \[Rule] False\)}\)\)], "Output", 
               CellTags -> "DiracSlash"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracGammaExpand", 
                RuleDelayed[ButtonData, "DiracGammaExpand"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGammaExpand"]], ", ", 
              ButtonBox["DiracGamma", RuleDelayed[ButtonData, "DiracGamma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGamma"]], ", ", 
              ButtonBox["DiracMatrix", RuleDelayed[ButtonData, 
                 "DiracMatrix"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracMatrix"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrick"]], ", ", 
              ButtonBox["GS", RuleDelayed[ButtonData, "GS"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "GS"]], 
              ", ", 
              ButtonBox["GSD", RuleDelayed[ButtonData, "GSD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "GSD"]], 
              "."}], "Text", CellTags -> "DiracSlash"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracSlash"], Cell[TextData[
             {"This is q-slash, i.e., ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] \(q\_\[Mu] .\)\)\)]]}], 
            "Text", CellTags -> "DiracSlash"], Cell[CellGroupData[
             {Cell[BoxData[\(DiracSlash[q]\)], "Input", CellTags -> 
                "DiracSlash"], Cell[BoxData[FormBox[RowBox[
                  {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                   "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracSlash"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracSlash[p]\) . \(DiracSlash[q]\)\)], "Input", 
               CellTags -> "DiracSlash"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                        "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                     RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "DiracSlash"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracSlash[\(p, q\)]\)], "Input", CellTags -> 
                "DiracSlash"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                        "TraditionalForm"]}], ")"}], ".", RowBox[{"(", 
                     RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "DiracSlash"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(GS[p]\)], "Input", CellTags -> "DiracSlash"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma] \[CenterDot] p\)\)], "Output", 
               CellTags -> "DiracSlash"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracSlash[q]\)//StandardForm\)], "Input", CellTags -> 
                "DiracSlash"], Cell[BoxData[\(DiracSlash[q]\)], "Output", 
               CellTags -> "DiracSlash"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracSlash[\(q, \(Dimension \[Rule] n\)\)]\)//
                   StandardForm\)], "Input", CellTags -> "DiracSlash"], 
              Cell[BoxData[\(DiracSlash[\(q, \(Dimension \[Rule] n\)\)]\)], 
               "Output", CellTags -> "DiracSlash"]}, Open]]}, Open]], 
        Cell["DiracSpinor", "ObjectName", CellTags -> "DiracSpinor"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracSpinor"], Cell["DiracSpinor is simply a \
quantity defined as noncommutative (with DeclareNonCommutative[DiracSpinor]). \
The convention intended is that DiracSpinor[p, m, ind] is a Dirac spinor for \
a fermion with momentum p and mass m and indices ind.", "Text", 
            CellTags -> "DiracSpinor"], Cell[TextData[{"See also: ", 
              ButtonBox["Spinor", RuleDelayed[ButtonData, "Spinor"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Spinor"]], 
              "."}], "Text", CellTags -> "DiracSpinor"], Cell[BoxData[""], 
            "Input"]}, Open]], Cell["DiracSubstitute67", "ObjectName", 
         CellTags -> "DiracSubstitute67"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracSubstitute67"], Cell["DiracSubstitute67 is an \
option for DiracSimplify. If set to True the chirality-projectors \
DiracGamma[6] and DiracGamma[7] are substituted by their definitions.", 
            "Text", CellTags -> "DiracSubstitute67"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["DiracGamma", RuleDelayed[ButtonData, "DiracGamma"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGamma"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], "."}], "Text", 
            CellTags -> "DiracSubstitute67"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["DiracTrace", "ObjectName", CellTags -> "DiracTrace"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracTrace"], Cell["DiracTrace[expr] is the head of \
Dirac traces. Whether the trace is evaluated depends on the option \
DiracTraceEvaluate. Direct trace evaluation should be performed with TR (or \
Tr). The argument expr may be a product of Dirac matrices or slashes \
separated by the Mathematica Dot (.).", "Text", CellTags -> "DiracTrace"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[DiracTrace]\)], 
               "Input", CellTags -> "DiracTrace"], Cell[BoxData[
                \(TraditionalForm\`\({\(EpsContract \[Rule] False\), 
                      \(Factoring \[Rule] False\), 
                      \(FeynCalcExternal \[Rule] False\), 
                      \(Mandelstam \[Rule] \({}\)\), 
                      \(PairCollect \[Rule] True\), 
                      \(DiracTraceEvaluate \[Rule] False\), 
                      \(Schouten \[Rule] 0\), 
                      \(LeviCivitaSign \[RuleDelayed] $LeviCivitaSign\), 
                      \(TraceOfOne \[Rule] 4\)}\)\)], "Output", CellTags -> 
                "DiracTrace"]}, Open]], Cell[TextData[
             {"For comments regarding ", Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5\)\)]], 
              "schemes see the notes for ", 
              ButtonBox["TR", RuleDelayed[ButtonData, "TR"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "TR"]], 
              "."}], "Text", CellTags -> "DiracTrace"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["TR", RuleDelayed[ButtonData, "TR"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "TR"]], 
              "."}], "Text", CellTags -> "DiracTrace"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracTrace"], Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrace[\(GA[\(\[Mu], \[Nu]\)]\)]\)], "Input", 
               CellTags -> "DiracTrace"], Cell[BoxData[FormBox[RowBox[
                  {"tr", "(", FormBox[\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu]\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "DiracTrace"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrace[\(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\)]\)], 
               "Input", CellTags -> "DiracTrace"], Cell[BoxData[
                FormBox[RowBox[{"tr", "(", FormBox[
                    \(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . \[Gamma]\^\[Rho] . 
                       \[Gamma]\^\[Sigma]\), "TraditionalForm"], ")"}], 
                 TraditionalForm]], "Output", CellTags -> "DiracTrace"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%\ /.\ \(DiracTrace \[Rule] Tr\)\)], "Input", CellTags -> 
                "DiracTrace"], Cell[BoxData[
                \(TraditionalForm\`\(4\ \(
                      (\(g\^\(\[Mu]\[Sigma]\)\ g\^\(\[Nu]\[Rho]\)\) - 
                        \(g\^\(\[Mu]\[Rho]\)\ g\^\(\[Nu]\[Sigma]\)\) + 
                        \(g\^\(\[Mu]\[Nu]\)\ g\^\(\[Rho]\[Sigma]\)\))\)\)\)], 
               "Output", CellTags -> "DiracTrace"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrace[\(\(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma], 5\)]\),
                      \(DiracTraceEvaluate \[Rule] True\)\)]\)], "Input", 
               CellTags -> "DiracTrace"], Cell[BoxData[FormBox[RowBox[{\(-4\)
                   , " ", "\[ImaginaryI]", " ", SuperscriptBox["\[Epsilon]", 
                    RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["\[Rho]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"]}]]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracTrace"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrace[\(\(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma], 
                         \[Delta], \[Tau], 5\)]\), 
                     \(DiracTraceEvaluate \[Rule] True\)\)]\)], "Input", 
               CellTags -> "DiracTrace"], Cell[BoxData[FormBox[RowBox[
                  {"4", " ", RowBox[{"(", RowBox[{RowBox[{"\[ImaginaryI]", 
                         " ", SuperscriptBox["\[Epsilon]", RowBox[{FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Tau]", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                         \(g\^\(\[Delta]\[Mu]\)\)}], "-", RowBox[
                        {"\[ImaginaryI]", " ", SuperscriptBox["\[Epsilon]", 
                          RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Tau]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", \(g\^\(\[Delta]\[Nu]\)\)
                         }], "+", RowBox[{"\[ImaginaryI]", " ", 
                         SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Tau]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", 
                         \(g\^\(\[Delta]\[Rho]\)\)}], "-", RowBox[
                        {"\[ImaginaryI]", " ", SuperscriptBox["\[Epsilon]", 
                          RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Tau]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", 
                         \(g\^\(\[Delta]\[Sigma]\)\)}], "-", RowBox[
                        {"\[ImaginaryI]", " ", SuperscriptBox["\[Epsilon]", 
                          RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", 
                         \(g\^\(\[Delta]\[Tau]\)\)}], "-", RowBox[
                        {"\[ImaginaryI]", " ", SuperscriptBox["\[Epsilon]", 
                          RowBox[{FormBox[FormBox["\[Delta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Tau]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", \(g\^\(\[Mu]\[Nu]\)\)}]
                         , "+", RowBox[{"\[ImaginaryI]", " ", SuperscriptBox[
                          "\[Epsilon]", RowBox[{FormBox[FormBox["\[Delta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Tau]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", \(g\^\(\[Mu]\[Rho]\)\)}]
                         , "-", RowBox[{"\[ImaginaryI]", " ", SuperscriptBox[
                          "\[Epsilon]", RowBox[{FormBox[FormBox["\[Delta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Tau]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", \(g\^\(\[Mu]\[Sigma]\)\)
                         }], "+", RowBox[{"\[ImaginaryI]", " ", 
                         SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Delta]", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", \(g\^\(\[Mu]\[Tau]\)\)}]
                         , "-", RowBox[{"\[ImaginaryI]", " ", SuperscriptBox[
                          "\[Epsilon]", RowBox[{FormBox[FormBox["\[Delta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Tau]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", \(g\^\(\[Nu]\[Rho]\)\)}]
                         , "+", RowBox[{"\[ImaginaryI]", " ", SuperscriptBox[
                          "\[Epsilon]", RowBox[{FormBox[FormBox["\[Delta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Tau]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", \(g\^\(\[Nu]\[Sigma]\)\)
                         }], "-", RowBox[{"\[ImaginaryI]", " ", 
                         SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Delta]", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", \(g\^\(\[Nu]\[Tau]\)\)}]
                         , "-", RowBox[{"\[ImaginaryI]", " ", SuperscriptBox[
                          "\[Epsilon]", RowBox[{FormBox[FormBox["\[Delta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Tau]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", 
                         \(g\^\(\[Rho]\[Sigma]\)\)}], "+", RowBox[
                        {"\[ImaginaryI]", " ", SuperscriptBox["\[Epsilon]", 
                          RowBox[{FormBox[FormBox["\[Delta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", \(g\^\(\[Rho]\[Tau]\)\)}
                         ], "-", RowBox[{"\[ImaginaryI]", " ", SuperscriptBox[
                          "\[Epsilon]", RowBox[{FormBox[FormBox["\[Delta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"]}]], " ", 
                         \(g\^\(\[Sigma]\[Tau]\)\)}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracTrace"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrace[\(GS[\(p, q, r, s\)]\)]\)], "Input", CellTags -> 
                "DiracTrace"], Cell[BoxData[FormBox[RowBox[{"tr", "(", 
                   FormBox[
                    \(\((\[Gamma] \[CenterDot] p)\) . 
                       \((\[Gamma] \[CenterDot] q)\) . 
                       \((\[Gamma] \[CenterDot] r)\) . 
                       \((\[Gamma] \[CenterDot] s)\)\), "TraditionalForm"], 
                   ")"}], TraditionalForm]], "Output", CellTags -> 
                "DiracTrace"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrace[\(\(GA[\(\[Mu], \[Nu]\)]\), 
                     \(DiracTraceEvaluate \[Rule] True\), 
                     \(FCE \[Rule] True\)\)]\)], "Input", CellTags -> 
                "DiracTrace"], Cell[BoxData[
                \(TraditionalForm\`\(4\ g\^\(\[Mu]\[Nu]\)\)\)], "Output", 
               CellTags -> "DiracTrace"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "DiracTrace"], Cell[BoxData[
                \(4\ \(MT[\(\[Mu], \[Nu]\)]\)\)], "Output", CellTags -> 
                "DiracTrace"]}, Open]]}, Open]], Cell["DiracTraceEvaluate", 
         "ObjectName", CellTags -> "DiracTraceEvaluate"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracTraceEvaluate"], Cell["DiracTraceEvaluate is an \
option for DiracTrace and Tr. If set to False, DiracTrace remains \
unevaluated.", "Text", CellTags -> "DiracTraceEvaluate"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["DiracTrace", RuleDelayed[ButtonData, "DiracTrace"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrace"]], ", ", 
              ButtonBox["TR", RuleDelayed[ButtonData, "TR"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "TR"]], 
              "."}], "Text", CellTags -> "DiracTraceEvaluate"], 
           Cell[BoxData[""], "Input"]}, Open]], Cell["DiracTrick", 
         "ObjectName", CellTags -> "DiracTrick"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DiracTrick"], Cell["DiracTrick[exp] contracts gamma \
matrices with each other and performs several simplifications, but no \
expansion, use Calc or DiracSimplify for non-commutative expansion.", "Text", 
            CellTags -> "DiracTrick"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[DiracTrick]\)], "Input", CellTags -> "DiracTrick"], 
              Cell[BoxData[\(TraditionalForm\`\({Expanding \[Rule] False}\)\)]
                , "Output", CellTags -> "DiracTrick"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Calc", RuleDelayed[ButtonData, "Calc"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Calc"]], 
              ", ", 
              ButtonBox["DiracGammaExpand", 
                RuleDelayed[ButtonData, "DiracGammaExpand"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracGammaExpand"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], "."}], "Text", 
            CellTags -> "DiracTrick"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DiracTrick"], 
           Cell["This is a string of Dirac matrices in four dimensions. ", 
            "Text", CellTags -> "DiracTrick"], Cell[CellGroupData[
             {Cell[BoxData[\(t1 = \(GA[\(\[Mu], \[Nu], \[Mu]\)]\)\)], 
               "Input", CellTags -> "DiracTrick"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^\[Mu]\)\)], "Output", CellTags -> 
                "DiracTrick"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrick[t1]\)], "Input", CellTags -> "DiracTrick"], 
              Cell[BoxData[FormBox[RowBox[{\(-2\), " ", SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "DiracTrick"]}, Open]], 
           Cell["This is a string of Dirac matrices in D dimensions. ", 
            "Text", CellTags -> "DiracTrick"], Cell[CellGroupData[
             {Cell[BoxData[\(t2 = \(GAD[\(\[Mu], \[Nu], \[Mu]\)]\)\)], 
               "Input", CellTags -> "DiracTrick"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^\[Mu]\)\)], "Output", CellTags -> 
                "DiracTrick"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrick[t2]\)], "Input", CellTags -> "DiracTrick"], 
              Cell[BoxData[FormBox[RowBox[{\((2 - D)\), " ", SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "DiracTrick"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t3 = \(GA[\(5, \[Mu], \[Nu]\)]\)\)], "Input", CellTags -> 
                "DiracTrick"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5 . \[Gamma]\^\[Mu] . 
                     \[Gamma]\^\[Nu]\)\)], "Output", CellTags -> 
                "DiracTrick"]}, Open]], Cell[TextData[{"By default ", 
              Cell[BoxData[\(TraditionalForm\`\(\[Gamma]\^5\)\)]], 
              "is moved to the right."}], "Text", CellTags -> "DiracTrick"], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracTrick[t3]\)], "Input", 
               CellTags -> "DiracTrick"], Cell[BoxData[FormBox[RowBox[
                  {SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(\[Gamma]\^5\)}], TraditionalForm]], "Output", 
               CellTags -> "DiracTrick"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(t4 = \(GA[\(6, \[Mu], 7\)]\)\)]
                , "Input", CellTags -> "DiracTrick"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^6 . \[Gamma]\^\[Mu] . 
                     \[Gamma]\^7\)\)], "Output", CellTags -> "DiracTrick"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(DiracTrick[t4]\)], 
               "Input", CellTags -> "DiracTrick"], Cell[BoxData[
                FormBox[RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                      "\[Mu]", "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(\[Gamma]\^7\)}], TraditionalForm]], "Output", 
               CellTags -> "DiracTrick"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t5 = \(\(GS[\(a + b\)]\)\ .\ \(GS[p]\) . \(GS[p]\) . 
                     \(GS[\(c + d\)]\)\)\)], "Input", CellTags -> 
                "DiracTrick"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"(", RowBox[{"\[Gamma]", "\[CenterDot]", "(", 
                       FormBox[\(a + b\), "TraditionalForm"], ")"}], ")"}], 
                   ".", \((\[Gamma] \[CenterDot] p)\), ".", 
                   \((\[Gamma] \[CenterDot] p)\), ".", RowBox[{"(", 
                     RowBox[{"\[Gamma]", "\[CenterDot]", "(", FormBox[
                        \(c + d\), "TraditionalForm"], ")"}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracTrick"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(DiracTrick[t5]\)], 
               "Input", CellTags -> "DiracTrick"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         "(", FormBox[\(a + b\), "TraditionalForm"], ")"}], 
                       ")"}], ".", RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         "(", FormBox[\(c + d\), "TraditionalForm"], ")"}], 
                       ")"}]}], " ", SuperscriptBox[FormBox["p", 
                     "TraditionalForm"], "2"]}], TraditionalForm]], "Output", 
               CellTags -> "DiracTrick"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Calc[t5]\)], "Input", 
               CellTags -> "DiracTrick"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["a", "TraditionalForm"]}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["c", 
                          "TraditionalForm"]}], ")"}]}], " ", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], "2"]}], "+", 
                   RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["a", "TraditionalForm"]}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["d", 
                          "TraditionalForm"]}], ")"}]}], " ", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], "2"]}], "+", 
                   RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["b", "TraditionalForm"]}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["c", 
                          "TraditionalForm"]}], ")"}]}], " ", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], "2"]}], "+", 
                   RowBox[{RowBox[{RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["b", "TraditionalForm"]}], ")"}], ".", 
                       RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["d", 
                          "TraditionalForm"]}], ")"}]}], " ", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], "2"]}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracTrick"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(GAD @@ \(Join[\(\({\[Mu]}\), 
                       \(Table[\(\[Nu]\_i, \({i, 6}\)\)]\), \({\[Mu]}\)\)]\)\
\)], "Input", CellTags -> "DiracTrick"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\(\[Nu]\_1\)
                      . \[Gamma]\^\(\[Nu]\_2\) . \[Gamma]\^\(\[Nu]\_3\) . 
                     \[Gamma]\^\(\[Nu]\_4\) . \[Gamma]\^\(\[Nu]\_5\) . 
                     \[Gamma]\^\(\[Nu]\_6\) . \[Gamma]\^\[Mu]\)\)], "Output", 
               CellTags -> "DiracTrick"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DiracTrick[%]\)], "Input", 
               CellTags -> "DiracTrick"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{\((D - 12)\), " ", RowBox[{SuperscriptBox[
                        "\[Gamma]", FormBox[FormBox[\(\[Nu]\_1\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox[\(\[Nu]\_2\)
                          , "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox[\(\[Nu]\_3\)
                          , "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox[\(\[Nu]\_4\)
                          , "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox[\(\[Nu]\_5\)
                          , "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\)
                          , "TraditionalForm"], "TraditionalForm"]]}]}], "-", 
                   RowBox[{"4", " ", RowBox[{"(", RowBox[{RowBox[{RowBox[
                          {"-", RowBox[{SuperscriptBox["\[Gamma]", FormBox[
                          FormBox[\(\[Nu]\_3\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_4\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_5\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}]}], " ", 
                          \(g\^\(\[Nu]\_1 \[Nu]\_2\)\)}], "+", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_2\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_4\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_5\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_1 \[Nu]\_3\)\)}], "-", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_2\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_3\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_5\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_1 \[Nu]\_4\)\)}], "+", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_2\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_3\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_4\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_1 \[Nu]\_5\)\)}], "-", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_2\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_3\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_4\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_5\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_1 \[Nu]\_6\)\)}], "-", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_4\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_5\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_2 \[Nu]\_3\)\)}], "+", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_3\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_5\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_2 \[Nu]\_4\)\)}], "-", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_3\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_4\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_2 \[Nu]\_5\)\)}], "+", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_3\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_4\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_5\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_2 \[Nu]\_6\)\)}], "-", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_2\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_5\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_3 \[Nu]\_4\)\)}], "+", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_2\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_4\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_3 \[Nu]\_5\)\)}], "-", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_2\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_4\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_5\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_3 \[Nu]\_6\)\)}], "-", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_2\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_3\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_6\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_4 \[Nu]\_5\)\)}], "+", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_2\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_3\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_5\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_4 \[Nu]\_6\)\)}], "-", RowBox[
                          {RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_1\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_2\), 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SuperscriptBox["\[Gamma]", FormBox[FormBox[
                          \(\[Nu]\_3\), "TraditionalForm"], 
                          "TraditionalForm"]], ".", SuperscriptBox[
                          "\[Gamma]", FormBox[FormBox[\(\[Nu]\_4\), 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(g\^\(\[Nu]\_5 \[Nu]\_6\)\)}]}], ")"}]}]}], 
                 TraditionalForm]], "Output", CellTags -> "DiracTrick"]}, 
             Open]]}, Open]], Cell["Divideout", "ObjectName", 
         CellTags -> "Divideout"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Divideout"], 
           Cell["Divideout is an option for OPEInt and OPEIntegrate. The \
setting is divided out at the end.", "Text", CellTags -> "Divideout"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["OPEInt", RuleDelayed[ButtonData, "OPEInt"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "OPEInt"]], 
              ", ", 
              ButtonBox["OPEIntegrate", 
                RuleDelayed[ButtonData, "OPEIntegrate"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "OPEIntegrate"]], "."}], "Text", 
            CellTags -> "Divideout"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["DOT", "ObjectName", CellTags -> "DOT"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DOT"], Cell["DOT[a, b, ...] is the FeynCalc function \
for non-commutative multiplication. By default it is set to the Mathematica \
Dot function. this can in principle be disabled (by editing the file \
\"FeynCalc.m\"), but then non-commutative products should to be entered like \
DOT[ DiracMatrix[mu], m + DiracSlash[p], DiracMatrix[mu] ] etc.", "Text", 
            CellTags -> "DOT"], Cell[TextData[{"See also: ", 
              ButtonBox["DotSimplify", RuleDelayed[ButtonData, 
                 "DotSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DotSimplify"]], "."}], "Text", 
            CellTags -> "DOT"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["DotExpand", "ObjectName", CellTags -> "DotExpand"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DotExpand"], 
           Cell["DotExpand[expr] expands DOT products in expr.", "Text", 
            CellTags -> "DotExpand"], Cell[TextData[{"See also: ", 
              ButtonBox["DOT", RuleDelayed[ButtonData, "DOT"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "DOT"]], 
              ", ", 
              ButtonBox["DotSimplify", RuleDelayed[ButtonData, 
                 "DotSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DotSimplify"]], ", ", 
              ButtonBox["DeclareNonCommutative", 
                RuleDelayed[ButtonData, "DeclareNonCommutative"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DeclareNonCommutative"]], ", ", 
              ButtonBox["UnDeclareNonCommutative", 
                RuleDelayed[ButtonData, "UnDeclareNonCommutative"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "UnDeclareNonCommutative"]], "."}], "Text", 
            CellTags -> "DotExpand"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DotExpand"], Cell[CellGroupData[{Cell[BoxData[
                \(DotExpand[\(DOT[\(\(\(a\ x\) + \(b\ y\) + \(c\ z\)\), 
                       \(d + e + f\)\)]\)]\)], "Input", CellTags -> 
                "DotExpand"], Cell[BoxData[
                \(TraditionalForm\`\(\(a\ d\ x\) + \(a\ e\ x\) + \(a\ f\ x\) 
                     + \(b\ d\ y\) + \(b\ e\ y\) + \(b\ f\ y\) + \(c\ d\ z\) 
                     + \(c\ e\ z\) + \(c\ f\ z\)\)\)], "Output", CellTags -> 
                "DotExpand"]}, Open]], Cell[BoxData[
             \(\(DeclareNonCommutative/@\({a, b, c, d, e, f}\)\) ;\)], 
            "Input", CellTags -> "DotExpand"], Cell[CellGroupData[
             {Cell[BoxData[
                \(DotExpand[\(DOT[\(\(\(a\ x\) + \(b\ y\) + \(c\ z\)\), 
                       \(d + e + f\)\)]\)]\)], "Input", CellTags -> 
                "DotExpand"], Cell[BoxData[
                \(TraditionalForm\`\(\(x\ \(a . d\)\) + \(x\ \(a . e\)\) + 
                     \(x\ \(a . f\)\) + \(y\ \(b . d\)\) + \(y\ \(b . e\)\) +
                      \(y\ \(b . f\)\) + \(z\ \(c . d\)\) + \(z\ \(c . e\)\) 
                     + \(z\ \(c . f\)\)\)\)], "Output", CellTags -> 
                "DotExpand"]}, Open]], Cell[BoxData[
             \(\(UnDeclareNonCommutative/@\({a, b, c, d, e, f}\)\) ;\)], 
            "Input", CellTags -> "DotExpand"], Cell[CellGroupData[
             {Cell[BoxData[
                \(DotExpand[\(DOT[\(\(\(a\ x\) + \(b\ y\) + \(c\ z\)\), 
                       \(d + e + f\)\)]\)]\)], "Input", CellTags -> 
                "DotExpand"], Cell[BoxData[
                \(TraditionalForm\`\(\(a\ d\ x\) + \(a\ e\ x\) + \(a\ f\ x\) 
                     + \(b\ d\ y\) + \(b\ e\ y\) + \(b\ f\ y\) + \(c\ d\ z\) 
                     + \(c\ e\ z\) + \(c\ f\ z\)\)\)], "Output", CellTags -> 
                "DotExpand"]}, Open]]}, Open]], Cell["DotPower", 
         "ObjectName", CellTags -> "DotPower"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DotPower"], Cell["DotPower is an option for \
DotSimplify. It determines whether non-commutative powers are represented by \
succesive multiplication or by Power.", "Text", CellTags -> "DotPower"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["DotSimplify", RuleDelayed[ButtonData, 
                 "DotSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DotSimplify"]], "."}], "Text", 
            CellTags -> "DotPower"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["DotProduct", "ObjectName", CellTags -> "DotProduct"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DotProduct"], Cell["DotProduct[x, y] denotes the \
three-dimensional dot-product. If x and y have Head List, DotProduct[x, a] \
(where a is a vector) performs Sum[ x[[k]] a[[k]], {k, 0, 3}].", "Text", 
            CellTags -> "DotProduct"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["CrossProduct", 
                RuleDelayed[ButtonData, "CrossProduct"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "CrossProduct"]], ", ", 
              ButtonBox["ThreeVector", RuleDelayed[ButtonData, 
                 "ThreeVector"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ThreeVector"]], "."}], "Text", 
            CellTags -> "DotProduct"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DotProduct"], Cell[CellGroupData[{Cell[BoxData[
                \(DotProduct[\(\(ThreeVector[a]\), \(3\(ThreeVector[b]\)\)\)]
                  \)], "Input", CellTags -> "DotProduct"], Cell[BoxData[
                FormBox[RowBox[{"3", " ", RowBox[{FormBox[
                      \(a\&\[RightVector]\), "TraditionalForm"], 
                     "\[CenterDot]", FormBox[\(b\&\[RightVector]\), 
                      "TraditionalForm"]}]}], TraditionalForm]], "Output", 
               CellTags -> "DotProduct"]}, Open]]}, Open]], 
        Cell["DotSimplifyRelations", "ObjectName", CellTags -> 
          "DotSimplifyRelations"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "DotSimplifyRelations"], Cell["DotSimplifyRelations is an option \
for DotSimplify. Its setting may be a list of substitution rules of the form \
DotSimplifyRelations \[Rule] {a . b \[Rule] c, b^2 \[Rule] 0, ...}.", "Text", 
            CellTags -> "DotSimplifyRelations"], Cell[TextData[{"See also: ", 
              ButtonBox["DotSimplify", RuleDelayed[ButtonData, 
                 "DotSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DotSimplify"]], "."}], "Text", 
            CellTags -> "DotSimplifyRelations"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["DotSimplify", "ObjectName", CellTags -> 
          "DotSimplify"], Cell[CellGroupData[{Cell["Description", 
            "Subsubsection", CellTags -> "DotSimplify"], Cell["DotSimplify[ex\
pr] expands and reorders noncommutative terms in expr. Simplifying relations \
may be specified by the option DotSimplifyRelations or by Commutator and \
AntiCommutator definitions. Whether expr is expanded noncommutatively depends \
on the option Expanding.", "Text", CellTags -> "DotSimplify"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[DotSimplify]\)], 
               "Input", CellTags -> "DotSimplify"], Cell[BoxData[
                \(TraditionalForm\`\({\(Expanding \[Rule] True\), 
                      \(DotSimplifyRelations \[Rule] \({}\)\), 
                      \(DotPower \[Rule] False\), 
                      \(FeynCalcInternal \[Rule] True\)}\)\)], "Output", 
               CellTags -> "DotSimplify"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["AntiCommutator", 
                RuleDelayed[ButtonData, "AntiCommutator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "AntiCommutator"]], ", ", 
              ButtonBox["Commutator", RuleDelayed[ButtonData, "Commutator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Commutator"]], ", ", 
              ButtonBox["Calc", RuleDelayed[ButtonData, "Calc"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Calc"]], 
              "."}], "Text", CellTags -> "DotSimplify"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "DotSimplify"], Cell[CellGroupData[{Cell[BoxData[
                \(t1 = \(\(GA[\[Mu]]\) . \((\(2\ \(GS[p]\)\) - \(GS[q]\))\) .
                      \(GA[\[Nu]]\)\)\)], "Input", CellTags -> 
                "DotSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . 
                     \((\(2\ \(\[Gamma] \[CenterDot] p\)\) - 
                        \(\[Gamma] \[CenterDot] q\))\) . \[Gamma]\^\[Nu]\)\)]\
, "Output", CellTags -> "DotSimplify"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(DotSimplify[t1]\)], "Input", CellTags -> 
                "DotSimplify"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"2", " ", RowBox[{SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{"(", RowBox[
                          {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                         ")"}], ".", SuperscriptBox["\[Gamma]", FormBox[
                         FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"]]}]}], "-", RowBox[{SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"]], ".", 
                     RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], ".", SuperscriptBox[
                      "\[Gamma]", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"]]}]}], 
                 TraditionalForm]], "Output", CellTags -> "DotSimplify"]}, 
             Open]], Cell[BoxData[\(DeclareNonCommutative[\(a, b, c\)]\)], 
            "Input", CellTags -> "DotSimplify"], Cell[CellGroupData[
             {Cell[BoxData[\(t2 = \(a . \((b - \(z\ c\))\) . a\)\)], "Input", 
               CellTags -> "DotSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(a . \((b - \(c\ z\))\) . a\)\)], 
               "Output", CellTags -> "DotSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DotSimplify[t2]\)], "Input", 
               CellTags -> "DotSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\(a . b . a\) - \(z\ \(a . c . a\)\)\)\)]\
, "Output", CellTags -> "DotSimplify"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(\(Commutator[\(a, c\)]\) = 1\)], "Input", 
               CellTags -> "DotSimplify"], Cell[BoxData[\(TraditionalForm\`1\)
                ], "Output", CellTags -> "DotSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DotSimplify[t2]\)], "Input", 
               CellTags -> "DotSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\(a . b . a\) - 
                     \(z\ \((a + \(c . a . a\))\)\)\)\)], "Output", 
               CellTags -> "DotSimplify"]}, Open]], Cell[BoxData[
             \(\(Commutator[\(a, c\)]\) = .\)], "Input", CellTags -> 
             "DotSimplify"], Cell[CellGroupData[{Cell[BoxData[
                \(DotSimplify[t2]\)], "Input", CellTags -> "DotSimplify"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\(a . b . a\) - \(z\ \(a . c . a\)\)\)\)]\
, "Output", CellTags -> "DotSimplify"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(\(AntiCommutator[\(b, a\)]\) = c\)], "Input", 
               CellTags -> "DotSimplify"], Cell[BoxData[\(TraditionalForm\`c\)
                ], "Output", CellTags -> "DotSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(DotSimplify[t2]\)], "Input", 
               CellTags -> "DotSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\(a . c\) - \(a . a . b\) - 
                     \(z\ \(a . c . a\)\)\)\)], "Output", CellTags -> 
                "DotSimplify"]}, Open]], Cell[BoxData[
             \(\(AntiCommutator[\(b, a\)]\) = .\)], "Input", 
            CellTags -> "DotSimplify"], Cell[CellGroupData[{Cell[BoxData[
                \(DotSimplify[\(t2, \(DotSimplifyRelations \[Rule] 
                       \({\(a . c\) \[Rule] \(1/z\)}\)\)\)]\)], "Input", 
               CellTags -> "DotSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(\(a . b . a\) - a\)\)], "Output", 
               CellTags -> "DotSimplify"]}, Open]], Cell[BoxData[
             \(DeclareNonCommutative[x]\)], "Input", CellTags -> 
             "DotSimplify"], Cell[CellGroupData[{Cell[BoxData[
                \(DotSimplify[\(x . x . x\)]\)], "Input", CellTags -> 
                "DotSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(x . x . x\)\)], "Output", CellTags -> 
                "DotSimplify"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DotSimplify[\(\(x . x . x\), \(DotPower \[Rule] False\)\)]
                  \)], "Input", CellTags -> "DotSimplify"], Cell[BoxData[
                \(TraditionalForm\`\(x . x . x\)\)], "Output", CellTags -> 
                "DotSimplify"]}, Open]], Cell[BoxData[
             \(UnDeclareNonCommutative[\(a, b, c, x\)]\)], "Input", 
            CellTags -> "DotSimplify"]}, Open]], Cell["DummyIndex", 
         "ObjectName", CellTags -> "DummyIndex"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "DummyIndex"], Cell["DummyIndex is an option of \
CovariantD specifying an index to use as dummy summation index. If set to \
Automatic, unique indices are generated", "Text", CellTags -> "DummyIndex"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["CovariantD", RuleDelayed[ButtonData, "CovariantD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "CovariantD"]], "."}], "Text", 
            CellTags -> "DummyIndex"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["D0", "ObjectName", CellTags -> "D0"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "D0"], Cell[TextData[{"D0[ p10, p12, p23, p30, p20, \
p13, m1^2, m2^2, m3^2, m4^2 ] is the Passarino-Veltman ", Cell[BoxData[
                \(TraditionalForm\`D\_0\)]], " function. The convention for \
the arguments is that if the denominator of the integrand has the form \
([q^2-m1^2] [(q+p1)^2-m2^2] [(q+p2)^2-m3^2] [(q+p3)^2-m4^2] ), the first six \
arguments of D0 are the scalar products p10 = p1^2, p12 = (p1-p2)^2, p23 = \
(p2-p3)^2, p30 = p3^2, p20 = p2^2, p13 = (p1-p3)^2."}], "Text", 
            CellTags -> "D0"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["B0", RuleDelayed[ButtonData, "B0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "B0"]], 
              ", ", 
              ButtonBox["C0", RuleDelayed[ButtonData, "C0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "C0"]], 
              ", ", 
              ButtonBox["PaVe", RuleDelayed[ButtonData, "PaVe"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "PaVe"]], 
              ", ", 
              ButtonBox["PaVeOrder", RuleDelayed[ButtonData, "PaVeOrder"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PaVeOrder"]], "."}], "Text", 
            CellTags -> "D0"]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "D0"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(D0[\(p10, p12, p23, p30, p20, p13, \(m1^2\), \(m2^2\), 
                     \(m3^2\), \(m4^2\)\)]\)], "Input", CellTags -> "D0"], 
              Cell[BoxData[FormBox[RowBox[{FormBox[\("D"\_"0"\), 
                    "TraditionalForm"], "(", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                           Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]]\)\_10\), 
                    "TraditionalForm"], ",", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                           Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]]\)\_12\), 
                    "TraditionalForm"], ",", "p23", ",", "p30", ",", "p20", 
                   ",", "p13", ",", FormBox[\(m1\^2\), "TraditionalForm"], 
                   ",", FormBox[\(m2\^2\), "TraditionalForm"], ",", FormBox[
                    \(m3\^2\), "TraditionalForm"], ",", FormBox[\(m4\^2\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "D0"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(PaVeOrder[\(\(D0[\(p10, p12, p23, p30, p20, p13, \(m1^2\), 
                         \(m2^2\), \(m3^2\), \(m4^2\)\)]\), 
                     \(PaVeOrderList \[Rule] \({p13, p20}\)\)\)]\)], "Input", 
               CellTags -> "D0"], Cell[BoxData[FormBox[RowBox[{FormBox[
                    \("D"\_"0"\), "TraditionalForm"], "(", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                           Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]]\)\_10\), 
                    "TraditionalForm"], ",", "p30", ",", "p23", ",", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                           Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]]\)\_12\), 
                    "TraditionalForm"], ",", "p13", ",", "p20", ",", FormBox[
                    \(m2\^2\), "TraditionalForm"], ",", FormBox[\(m1\^2\), 
                    "TraditionalForm"], ",", FormBox[\(m4\^2\), 
                    "TraditionalForm"], ",", FormBox[\(m3\^2\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "D0"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(PaVeOrder[%]\)], "Input", CellTags -> "D0"], 
              Cell[BoxData[FormBox[RowBox[{FormBox[\("D"\_"0"\), 
                    "TraditionalForm"], "(", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                           Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]]\)\_10\), 
                    "TraditionalForm"], ",", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                           Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]]\)\_12\), 
                    "TraditionalForm"], ",", "p23", ",", "p30", ",", "p20", 
                   ",", "p13", ",", FormBox[\(m1\^2\), "TraditionalForm"], 
                   ",", FormBox[\(m2\^2\), "TraditionalForm"], ",", FormBox[
                    \(m3\^2\), "TraditionalForm"], ",", FormBox[\(m4\^2\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "D0"]}, Open]]}, Open]], Cell["D0Convention", 
         "ObjectName", CellTags -> "D0Convention"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "D0Convention"], Cell["D0Convention is an option for \
Write2. If set to 1, the convention for the arguments of D0 is changed when \
writing a Fortran file with Write2: The fifth and sixth argument of D0 are \
interchanged and the square root is taken of the last four arguments.", 
            "Text", CellTags -> "D0Convention"], Cell[TextData[{"See also: ", 
              ButtonBox["D0", RuleDelayed[ButtonData, "D0"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "D0"]], 
              ", ", 
              ButtonBox["Write2", RuleDelayed[ButtonData, "Write2"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Write2"]], 
              "."}], "Text", CellTags -> "D0Convention"], Cell[BoxData[""], 
            "Input"]}, Open]], Cell["Eps", "ObjectName", CellTags -> "Eps"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Eps"], Cell[TextData[
             {"Eps[a, b, c, d] is the head of the totally antisymmetric ", 
              Cell[BoxData[\(TraditionalForm\`\(\ \[Epsilon]\)\)]], " \
(Levi-Civita) tensor. The a,b, ... may have head LorentzIndex, Momentum or \
Integer. In case of integers the Levi-Civita tensor is evaluated immediately. \
"}], "Text", CellTags -> "Eps"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[Eps]\)], "Input", CellTags -> "Eps"], Cell[BoxData[
                \(TraditionalForm\`\({Dimension \[Rule] 4}\)\)], "Output", 
               CellTags -> "Eps"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["EpsEvaluate", RuleDelayed[ButtonData, 
                 "EpsEvaluate"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "EpsEvaluate"]], ", ", 
              ButtonBox["LC", RuleDelayed[ButtonData, "LC"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "LC"]], 
              ", ", 
              ButtonBox["LCD", RuleDelayed[ButtonData, "LCD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "LCD"]], 
              ", ", 
              ButtonBox["LeviCivita", RuleDelayed[ButtonData, "LeviCivita"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LeviCivita"]], "."}], "Text", 
            CellTags -> "Eps"]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "Eps"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Eps[\(\(LorentzIndex[\[Mu]]\), \(LorentzIndex[\[Nu]]\), 
                     \(LorentzIndex[\[Rho]]\), \(LorentzIndex[\[Sigma]]\)\)]\
\)], "Input", CellTags -> "Eps"], Cell[BoxData[FormBox[SuperscriptBox[
                  "\[Epsilon]", RowBox[{FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     FormBox["\[Nu]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                      "TraditionalForm"], "TraditionalForm"]}]], 
                 TraditionalForm]], "Output", CellTags -> "Eps"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Eps[\(\(Momentum[p]\), \(LorentzIndex[\[Nu]]\), 
                     \(LorentzIndex[\[Rho]]\), \(LorentzIndex[\[Sigma]]\)\)]\
\)], "Input", CellTags -> "Eps"], Cell[BoxData[FormBox[SuperscriptBox[
                  "\[Epsilon]", RowBox[{FormBox["p", "TraditionalForm"], 
                    FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     FormBox["\[Sigma]", "TraditionalForm"], 
                     "TraditionalForm"]}]], TraditionalForm]], "Output", 
               CellTags -> "Eps"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(Eps[\(b, a, c, d\)]\)//StandardForm\)], "Input", 
               CellTags -> "Eps"], Cell[BoxData[\(-\(Eps[\(a, b, c, d\)]\)\)]
                , "Output", CellTags -> "Eps"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Eps[\(0, 1, 2, 3\)]\)], 
               "Input", CellTags -> "Eps"], Cell[BoxData[
                \(TraditionalForm\`1\)], "Output", CellTags -> "Eps"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(Eps[\(1, 0, 2, 3\)]\)]
                , "Input", CellTags -> "Eps"], Cell[BoxData[
                \(TraditionalForm\`\(-1\)\)], "Output", CellTags -> "Eps"]}, 
             Open]], Cell[BoxData[
             \(\(SetOptions[\(Eps, \(Dimension \[Rule] 4\)\)]\) ;\)], 
            "Input", CellTags -> "Eps"], Cell[CellGroupData[{Cell[BoxData[
                \(a1\ = \(Eps[\(\(LorentzIndex[\(\[Mu], D\)]\), 
                       \(LorentzIndex[\(\[Nu], D\)]\), 
                       \(LorentzIndex[\(\[Rho], D\)]\), 
                       \(LorentzIndex[\(\[Sigma], D\)]\)\)]\)\)], "Input", 
               CellTags -> "Eps"], Cell[BoxData[FormBox[SuperscriptBox[
                  "\[Epsilon]", RowBox[{FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     FormBox["\[Nu]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                      "TraditionalForm"], "TraditionalForm"]}]], 
                 TraditionalForm]], "Output", CellTags -> "Eps"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Contract[a1a1]\)], "Input", 
               CellTags -> "Eps"], Cell[BoxData[\(TraditionalForm\`a1a1\)], 
               "Output", CellTags -> "Eps"]}, Open]], Cell[BoxData[
             \(\(SetOptions[\(Eps, \(Dimension \[Rule] D\)\)]\) ;\)], 
            "Input", CellTags -> "Eps"], Cell[CellGroupData[{Cell[BoxData[
                \(a2\ = \(Eps[\(\(LorentzIndex[\(\[Mu], D\)]\), 
                       \(LorentzIndex[\(\[Nu], D\)]\), 
                       \(LorentzIndex[\(\[Rho], D\)]\), 
                       \(LorentzIndex[\(\[Sigma], D\)]\)\)]\)\)], "Input", 
               CellTags -> "Eps"], Cell[BoxData[FormBox[SuperscriptBox[
                  "\[Epsilon]", RowBox[{FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     FormBox["\[Nu]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                      "TraditionalForm"], "TraditionalForm"]}]], 
                 TraditionalForm]], "Output", CellTags -> "Eps"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(\(Contract[a2a2]\)//Factor2\)], 
               "Input", CellTags -> "Eps"], Cell[BoxData[
                \(TraditionalForm\`a2a2\)], "Output", CellTags -> "Eps"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\ \(\(LCD[\(\[Mu], \[Nu], \[Rho], \[Alpha]\)]\) . 
                     \(GAD[\(\[Mu], \[Nu], \[Rho], \[Alpha]\)]\)\)\)], 
               "Input"], Cell[BoxData[
                \(TraditionalForm\`\(\[Epsilon]\^\(\[Mu]\[Nu]\[Rho]\[Alpha]\)
                      . \[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . \[Gamma]\^
                      \[Rho] . \[Gamma]\^\[Alpha]\)\)], "Output"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//FCI\)], "Input"], 
              Cell[BoxData[FormBox[RowBox[{SuperscriptBox["\[Epsilon]", 
                    RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["\[Rho]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Alpha]", 
                        "TraditionalForm"], "TraditionalForm"]}]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Rho]", 
                      "TraditionalForm"], "TraditionalForm"]], ".", 
                   SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Alpha]", 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(g5 = \(\(\(-\(\[ImaginaryI]\/24\)\) 
                       \(\(LCD[\(\[Mu], \[Nu], \[Rho], \[Alpha]\)]\) . 
                         \(GAD[\(\[Mu], \[Nu], \[Rho], \[Alpha]\)]\)\)\)//FCI
                \)\)], "Input", CellTags -> "Eps"], Cell[BoxData[
                FormBox[RowBox[{\(-\(1\/24\)\), " ", "\[ImaginaryI]", " ", 
                   RowBox[{SuperscriptBox["\[Epsilon]", RowBox[{FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Alpha]", 
                          "TraditionalForm"], "TraditionalForm"]}]], ".", 
                     SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"]], ".", 
                     SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"]], ".", 
                     SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Rho]", 
                        "TraditionalForm"], "TraditionalForm"]], ".", 
                     SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Alpha]", 
                        "TraditionalForm"], "TraditionalForm"]]}]}], 
                 TraditionalForm]], "Output", CellTags -> "Eps"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(g5p = \(\(\(-\(\[ImaginaryI]\/24\)\)\ 
                       \(\(LCD[\(\*SuperscriptBox["\[Mu]", "\[Prime]", 
                               Rule[MultilineFunction, None]], 
                             \*SuperscriptBox["\[Nu]", "\[Prime]", 
                               Rule[MultilineFunction, None]], 
                             \*SuperscriptBox["\[Rho]", "\[Prime]", 
                               Rule[MultilineFunction, None]], 
                             \*SuperscriptBox["\[Alpha]", "\[Prime]", 
                               Rule[MultilineFunction, None]]\)]\) . 
                         \(GAD[\(\*SuperscriptBox["\[Mu]", "\[Prime]", 
                               Rule[MultilineFunction, None]], 
                             \*SuperscriptBox["\[Nu]", "\[Prime]", 
                               Rule[MultilineFunction, None]], 
                             \*SuperscriptBox["\[Rho]", "\[Prime]", 
                               Rule[MultilineFunction, None]], 
                             \*SuperscriptBox["\[Alpha]", "\[Prime]", 
                               Rule[MultilineFunction, None]]\)]\)\)\)//FCI\)
                \)], "Input", CellTags -> "Eps"], Cell[BoxData[FormBox[
                 RowBox[{\(-\(1\/24\)\), " ", "\[ImaginaryI]", " ", 
                   RowBox[{SuperscriptBox["\[Epsilon]", RowBox[{FormBox[
                         FormBox[
                          SuperscriptBox["\[Mu]", "\[Prime]", 
                            Rule[MultilineFunction, None]], 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox[
                          SuperscriptBox["\[Nu]", "\[Prime]", 
                            Rule[MultilineFunction, None]], 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox[
                          SuperscriptBox["\[Rho]", "\[Prime]", 
                            Rule[MultilineFunction, None]], 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox[
                          SuperscriptBox["\[Alpha]", "\[Prime]", 
                            Rule[MultilineFunction, None]], 
                          "TraditionalForm"], "TraditionalForm"]}]], ".", 
                     SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        SuperscriptBox["\[Mu]", "\[Prime]", 
                          Rule[MultilineFunction, None]], "TraditionalForm"], 
                       "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                      FormBox[FormBox[
                        SuperscriptBox["\[Nu]", "\[Prime]", 
                          Rule[MultilineFunction, None]], "TraditionalForm"], 
                       "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                      FormBox[FormBox[
                        SuperscriptBox["\[Rho]", "\[Prime]", 
                          Rule[MultilineFunction, None]], "TraditionalForm"], 
                       "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                      FormBox[FormBox[
                        SuperscriptBox["\[Alpha]", "\[Prime]", 
                          Rule[MultilineFunction, None]], "TraditionalForm"], 
                       "TraditionalForm"]]}]}], TraditionalForm]], "Output", 
               CellTags -> "Eps"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(g52 = \(Factor2[\(Calc[\(g5 . g5p\)]\)]\)\)], "Input", 
               CellTags -> "Eps"], Cell[BoxData[
                \(TraditionalForm\`\(\(-\(1\/24\)\)\ \((1 - D)\)\ \((2 - D)\)
                     \ \((3 - D)\)\ D\)\)], "Output", CellTags -> "Eps"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(g52/.\(D \[Rule] 4\)\)
                ], "Input", CellTags -> "Eps"], Cell[BoxData[
                \(TraditionalForm\`1\)], "Output", CellTags -> "Eps"]}, 
             Open]], Cell[BoxData[\(Clear[\(a1, a2, g5, g5p, g52\)]\)], 
            "Input", CellTags -> "Eps"]}, Open]], Cell["EpsChisholm", 
         "ObjectName", CellTags -> "EpsChisholm"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "EpsChisholm"], Cell["EpsChisholm[expr] substitutes \
for a gamma matrix contracted with a Levi-Civita tensor (Eps) the Chisholm \
identity.", "Text", CellTags -> "EpsChisholm"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Chisholm", RuleDelayed[ButtonData, "Chisholm"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Chisholm"]], "."}], "Text", 
            CellTags -> "EpsChisholm"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "EpsChisholm"], Cell[CellGroupData[{Cell[BoxData[
                \(Chisholm[\(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\)]\)], 
               "Input", CellTags -> "EpsChisholm"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{\(-\[ImaginaryI]\), " ", RowBox[
                      {SuperscriptBox["\[Gamma]", FormBox[FormBox["$MU$799", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SuperscriptBox["\[Gamma]", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       \(\[Gamma]\^5\)}], " ", SuperscriptBox["\[Epsilon]", 
                      RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["$MU$799", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "+", 
                   RowBox[{RowBox[{SuperscriptBox["\[Gamma]", FormBox[
                         FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Nu]\)\)}], 
                   "-", RowBox[{RowBox[{SuperscriptBox["\[Gamma]", FormBox[
                         FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Mu]\[Rho]\)\)}]
                     , "+", RowBox[{RowBox[{SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(g\^\(\[Nu]\[Rho]\)\)}]}
                     ], TraditionalForm]], "Output", CellTags -> 
                "EpsChisholm"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(EpsChisholm[%]\)], "Input", CellTags -> "EpsChisholm"], 
              Cell[BoxData[FormBox[RowBox[{SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", SuperscriptBox["\[Gamma]", 
                    FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "EpsChisholm"]}, Open]]}, Open]], 
        Cell["EpsContract", "ObjectName", CellTags -> "EpsContract"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "EpsContract"], Cell["EpsContract is an option of \
Contract specifying whether Levi-Civita tensors Eps[...] will be contracted, \
i.e., products of two  Eps are replaced via the determinant formula.", 
            "Text", CellTags -> "EpsContract"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Eps", RuleDelayed[ButtonData, "Eps"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Eps"]], 
              ", ", 
              ButtonBox["Contract", RuleDelayed[ButtonData, "Contract"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Contract"]], "."}], "Text", 
            CellTags -> "EpsContract"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "EpsContract"], Cell[CellGroupData[{Cell[BoxData[
                \(a1\ = \(Eps[\(\(LorentzIndex[\(\[Mu], D\)]\), 
                       \(LorentzIndex[\(\[Nu], D\)]\), 
                       \(LorentzIndex[\(\[Rho], D\)]\), 
                       \(LorentzIndex[\(\[Sigma], D\)]\)\)]\)\)], "Input", 
               CellTags -> "EpsContract"], Cell[BoxData[FormBox[
                 SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                      "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     FormBox["\[Sigma]", "TraditionalForm"], 
                     "TraditionalForm"]}]], TraditionalForm]], "Output", 
               CellTags -> "EpsContract"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Contract[\(\(a1\ a1\), \(EpsContract \[Rule] False\)\)]\)], 
               "Input", CellTags -> "EpsContract"], Cell[BoxData[
                FormBox[SuperscriptBox[RowBox[{"(", SuperscriptBox[
                     "\[Epsilon]", RowBox[{FormBox[FormBox["\[Mu]", 
                         "TraditionalForm"], "TraditionalForm"], FormBox[
                        FormBox["\[Nu]", "TraditionalForm"], 
                        "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                         "TraditionalForm"], "TraditionalForm"], FormBox[
                        FormBox["\[Sigma]", "TraditionalForm"], 
                        "TraditionalForm"]}]], ")"}], "2"], 
                 TraditionalForm]], "Output", CellTags -> "EpsContract"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Contract[\(\(a1\ a1\), \(EpsContract \[Rule] True\)\)]\)], 
               "Input", CellTags -> "EpsContract"], Cell[BoxData[
                \(TraditionalForm\`\(\(-D\^4\) + \(6\ D\^3\) - \(11\ D\^2\) +
                      \(6\ D\)\)\)], "Output", CellTags -> "EpsContract"]}, 
             Open]], Cell[BoxData[\(Clear[a1]\)], "Input"]}, Open]], 
        Cell["EpsDiscard", "ObjectName", CellTags -> "EpsDiscard"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "EpsDiscard"], Cell["EpsDiscard is an option for \
FeynCalc2FORM. If set to True all Levi-Civita tensors are replaced by 0 after \
contraction.", "Text", CellTags -> "EpsDiscard"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynCalc2FORM", 
                RuleDelayed[ButtonData, "FeynCalc2FORM"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalc2FORM"]], "."}], "Text", 
            CellTags -> "EpsDiscard"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["EpsEvaluate", "ObjectName", CellTags -> "EpsEvaluate"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "EpsEvaluate"], Cell["EpsEvaluate[expr] applies total \
antisymmetry and linearity (w.r.t. Momentum's) to all Levi-Civita tensors \
(Eps') in expr.", "Text", CellTags -> "EpsEvaluate"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Contract", RuleDelayed[ButtonData, "Contract"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Contract"]], ", ", 
              ButtonBox["Eps", RuleDelayed[ButtonData, "Eps"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Eps"]], 
              ", ", 
              ButtonBox["LeviCivita", RuleDelayed[ButtonData, "LeviCivita"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LeviCivita"]], ", ", 
              ButtonBox["Trick", RuleDelayed[ButtonData, "Trick"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Trick"]], 
              "."}], "Text", CellTags -> "EpsEvaluate"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "EpsEvaluate"], Cell[CellGroupData[{Cell[BoxData[
                \(Trick[\(\(LeviCivita[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\)
                     \ \(FourVector[\(\(p + q\), \[Sigma]\)]\)\)]\)], 
               "Input", CellTags -> "EpsEvaluate"], Cell[BoxData[
                FormBox[SuperscriptBox["\[Epsilon]", RowBox[{FormBox[
                     FormBox["\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     \(p + q\), "TraditionalForm"]}]], TraditionalForm]], 
               "Output", CellTags -> "EpsEvaluate"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(EpsEvaluate[%]\)], "Input", 
               CellTags -> "EpsEvaluate"], Cell[BoxData[FormBox[
                 SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                      "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     \(p + q\), "TraditionalForm"]}]], TraditionalForm]], 
               "Output", CellTags -> "EpsEvaluate"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(StandardForm[%]\)], "Input", 
               CellTags -> "EpsEvaluate"], Cell[BoxData[
                \(Eps[\(\(LorentzIndex[\(\[Mu], D\)]\), 
                     \(LorentzIndex[\(\[Nu], D\)]\), 
                     \(LorentzIndex[\(\[Rho], D\)]\), \(Momentum[\(p + q\)]\)
                \)]\)], "Output", CellTags -> "EpsEvaluate"]}, Open]]}, 
          Open]], Cell["EpsUncontract", "ObjectName", 
         CellTags -> "EpsUncontract"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "EpsUncontract"], 
           Cell[
            "EpsUncontract does Uncontract on scalar products involving Eps."\
, "Text", CellTags -> "EpsUncontract"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Eps", RuleDelayed[ButtonData, "Eps"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Eps"]], 
              ", ", 
              ButtonBox["Uncontract", RuleDelayed[ButtonData, "Uncontract"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Uncontract"]], "."}], "Text", 
            CellTags -> "EpsUncontract"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["Epsilon", "ObjectName", CellTags -> "Epsilon"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Epsilon"], Cell[TextData[{"Epsilon is (", 
              StyleBox["n", Rule[FontSlant, "Italic"]], "-4), where ", 
              StyleBox["n", Rule[FontSlant, "Italic"]], " is the space-time \
dimension. Epsilon stands for a small positive number."}], "Text", 
            CellTags -> "Epsilon"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Series2", RuleDelayed[ButtonData, "Series2"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Series2"]]\
, "."}], "Text", CellTags -> "Epsilon"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Epsilon"], Cell[CellGroupData[
             {Cell[BoxData["Epsilon"], "Input", CellTags -> "Epsilon"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\*TagBox["\[CurlyEpsilon]", 
                      TraditionalForm]\)\)], "Output", CellTags -> 
                "Epsilon"]}, Open]], Cell["Epsilon has no functional \
properties, but some upvalues are changed:", "Text", CellTags -> "Epsilon"], 
           Cell[CellGroupData[{Cell[BoxData[
                \({\(\(Re[Epsilon]\)\ >\ \(-4\)\), 
                    \(\(Re[Epsilon]\)\ >\ \(-3\)\), 
                    \(\(Re[Epsilon]\)\ >\ \(-2\)\), 
                    \(\(Re[Epsilon]\)\ >\ \(-1\)\), \(\(Re[Epsilon]\)\ >\ 0\)\
}\)], "Input", CellTags -> "Epsilon"], Cell[BoxData[
                \(TraditionalForm\`\({True, True, True, True, True}\)\)], 
               "Output", CellTags -> "Epsilon"]}, Open]]}, Open]], 
        Cell["EpsilonOrder", "ObjectName", CellTags -> "EpsilonOrder"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "EpsilonOrder"], Cell[TextData[{"EpsilonOrder is an \
option of OPEIntegrateDelta and RHI. The setting determines the order ", "n", 
              " (", Cell[BoxData[
                \(TraditionalForm\`\(Epsilon\^
                     \*StyleBox["n", Rule[FontSlant, "Plain"]]\)\)]], 
              ") which should be kept."}], "Text", CellTags -> 
             "EpsilonOrder"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["OPEIntegrateDelta", 
                RuleDelayed[ButtonData, "OPEIntegrateDelta"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "OPEIntegrateDelta"]], ", ", 
              ButtonBox["RHI", RuleDelayed[ButtonData, "RHI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "RHI"]], 
              "."}], "Text", CellTags -> "EpsilonOrder"], Cell[BoxData[""], 
            "Input"]}, Open]], Cell["Expanding", "ObjectName", 
         CellTags -> "Expanding"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Expanding"], 
           Cell["Expanding is an option for Calc, Contract, \
DiracSimplify,DotSimplify, SUNSimplify etc. As option for Contract it \
specifies whether expansion w.r.t. LorentzIndex is done BEFORE contraction. \
If set to False in DiracSimplify or SUNSimplify, only a limited set of \
simplifications (multiplicative linearity etc.) is performed.", "Text", 
            CellTags -> "Expanding"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Calc", RuleDelayed[ButtonData, "Calc"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Calc"]], 
              ", ", 
              ButtonBox["Contract", RuleDelayed[ButtonData, "Contract"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Contract"]], ", ", 
              ButtonBox["DiracSimplify", 
                RuleDelayed[ButtonData, "DiracSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracSimplify"]], ", ", 
              ButtonBox["DotSimplify", RuleDelayed[ButtonData, 
                 "DotSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DotSimplify"]], ", ", 
              ButtonBox["SUNSimplify", RuleDelayed[ButtonData, 
                 "SUNSimplify"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SUNSimplify"]], "."}], "Text", 
            CellTags -> "Expanding"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["ExpandPartialD", "ObjectName", CellTags -> "ExpandPartialD"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "ExpandPartialD"], Cell["ExpandPartialD[exp] expands \
all products of QuantumField's and partial differentiation operators in exp \
and applies the Leibniz rule.", "Text", CellTags -> "ExpandPartialD"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[ExpandPartialD]\)], 
               "Input"], Cell[BoxData[FormBox[RowBox[{"{", RowBox[
                    {"PartialDRelations", "\[Rule]", RowBox[{"{", RowBox[
                        {RowBox[{RowBox[{"a$___", ".", RowBox[{"\[PartialD]", 
                          "/", "\[PartialD]", SuperscriptBox[FormBox["x$_", 
                          "TraditionalForm"], FormBox[FormBox["mu$_", 
                          "TraditionalForm"], "TraditionalForm"]]}], ".", 
                          "b$___"}], "\[RuleDelayed]", RowBox[{"a$", ".", 
                          RowBox[{SubscriptBox[
                          TagBox[StyleBox["\"\[PartialD]\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], TagBox[FormBox[
                          FormBox["mu$", "TraditionalForm"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]], "(", TagBox[FormBox[\(Dot[b$]\), 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], ")"}]}]}], ",", RowBox[{RowBox[{RowBox[
                          {"UMatrix", "(", RowBox[{FormBox[
                          TagBox[StyleBox["\"\[DoubleStruckCapitalI]\[Doub\
leStruckD]\"", Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], ",", "___"}], ")"}], 
                          "\[SixPointedStar]", 
                          \(\((PartialD | RightPartialD | LeftPartialD)\)[__]
                            \)}], "\[RuleDelayed]", "0"}], ",", RowBox[
                          {RowBox[{RowBox[{"a___", "\[SixPointedStar]", 
                          SubscriptBox["D", FormBox[FormBox["mu_", 
                          "TraditionalForm"], "TraditionalForm"]]}], 
                          "\[SixPointedStar]", "b___"}], "\[RuleDelayed]", 
                          RowBox[{RowBox[{"a", "\[SixPointedStar]", RowBox[
                          {SubscriptBox[
                          TagBox[StyleBox["\"\[ScriptCapitalD]\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], TagBox[FormBox[
                          FormBox["mu", "TraditionalForm"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]], "(", TagBox[FormBox["b", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], ")"}]}], "/;", RowBox[{"(", RowBox[{
                          \(go = False\), ";", RowBox[{\({b}\), "/.", 
                          "\[InvisibleSpace]", RowBox[{RowBox[{FormBox["__", 
                          "TraditionalForm"], "|", RowBox[{RowBox[{"_", "[", 
                          RowBox[{"___", ",", FormBox["__", 
                          "TraditionalForm"], ",", "___"}], "]"}], "[", 
                          \(y_ ? AtomQ\), "]"}]}], "\[RuleDelayed]", 
                          \((\(go = True\) ; \(z = y\))\)}]}], ";", "go"}], 
                          ")"}]}]}], ",", RowBox[{RowBox[{RowBox[{"a___", 
                          "\[SixPointedStar]", RowBox[{"\[PartialD]", "/", 
                          "D", SuperscriptBox[FormBox["x_", 
                          "TraditionalForm"], FormBox[FormBox["mu_", 
                          "TraditionalForm"], "TraditionalForm"]]}]}], 
                          "\[SixPointedStar]", "b___"}], "\[RuleDelayed]", 
                          RowBox[{"a", "\[SixPointedStar]", RowBox[
                          {SubscriptBox[
                          TagBox[StyleBox["\"\[ScriptCapitalD]\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], TagBox[FormBox[
                          FormBox["mu", "TraditionalForm"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]], "(", TagBox[FormBox["b", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], ")"}]}]}], ",", RowBox[{RowBox[{RowBox[
                          {"a___", "\[SixPointedStar]", SubscriptBox[
                          \(\[PartialD]\&\[LeftArrow]\), FormBox[FormBox[
                          "mu_", "TraditionalForm"], "TraditionalForm"]]}], 
                          "\[SixPointedStar]", "b___"}], "\[RuleDelayed]", 
                          RowBox[{RowBox[{RowBox[{SubscriptBox[
                          TagBox[StyleBox["\"\[PartialD]\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], TagBox[FormBox[
                          FormBox["mu", "TraditionalForm"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]], "(", TagBox[FormBox["a", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], ")"}], "\[SixPointedStar]", "b"}], "/;", 
                          RowBox[{"(", RowBox[{\(go = False\), ";", RowBox[{
                          \({a}\), "/.", "\[InvisibleSpace]", RowBox[{RowBox[
                          {FormBox["__", "TraditionalForm"], "|", RowBox[
                          {RowBox[{"_", "[", RowBox[{"___", ",", FormBox[
                          "__", "TraditionalForm"], ",", "___"}], "]"}], "[", 
                          \(y_ ? AtomQ\), "]"}]}], "\[RuleDelayed]", 
                          \((\(go = True\) ; \(z = y\))\)}]}], ";", "go"}], 
                          ")"}]}]}], ",", RowBox[{RowBox[{RowBox[{"a___", 
                          "\[SixPointedStar]", RowBox[{"LeftPartialD", "(", 
                          RowBox[{"x_", ",", FormBox["mu_", 
                          "TraditionalForm"]}], ")"}]}], "\[SixPointedStar]", 
                          "b___"}], "\[RuleDelayed]", RowBox[{RowBox[
                          {SubscriptBox[
                          TagBox[StyleBox["\"\[PartialD]\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], TagBox[FormBox[
                          FormBox["mu", "TraditionalForm"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]], "(", TagBox[FormBox["a", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], ")"}], "\[SixPointedStar]", "b"}]}], ",", 
                         RowBox[{RowBox[{RowBox[{"a___", "\[SixPointedStar]", 
                          RowBox[{\((PartialD | RightPartialD)\), "[", 
                          FormBox["mu_", "TraditionalForm"], "]"}]}], 
                          "\[SixPointedStar]", "b___"}], "\[RuleDelayed]", 
                          RowBox[{RowBox[{"a", "\[SixPointedStar]", RowBox[
                          {SubscriptBox[
                          TagBox[StyleBox["\"\[PartialD]\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], TagBox[FormBox[
                          FormBox["mu", "TraditionalForm"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]], "(", TagBox[FormBox["b", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], ")"}]}], "/;", RowBox[{"(", RowBox[{
                          \(go = False\), ";", RowBox[{\({b}\), "/.", 
                          "\[InvisibleSpace]", RowBox[{RowBox[{FormBox["__", 
                          "TraditionalForm"], "|", RowBox[{RowBox[{"_", "[", 
                          RowBox[{"___", ",", FormBox["__", 
                          "TraditionalForm"], ",", "___"}], "]"}], "[", 
                          \(y_ ? AtomQ\), "]"}]}], "\[RuleDelayed]", 
                          \((\(go = True\) ; \(z = y\))\)}]}], ";", "go"}], 
                          ")"}]}]}], ",", RowBox[{RowBox[{RowBox[{"a___", 
                          "\[SixPointedStar]", RowBox[{
                          \((PartialD | RightPartialD)\), "[", RowBox[{"x_", 
                          ",", FormBox["mu_", "TraditionalForm"]}], "]"}]}], 
                          "\[SixPointedStar]", "b___"}], "\[RuleDelayed]", 
                          RowBox[{"a", "\[SixPointedStar]", RowBox[
                          {SubscriptBox[
                          TagBox[StyleBox["\"\[PartialD]\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], TagBox[FormBox[
                          FormBox["mu", "TraditionalForm"], 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True]], "(", TagBox[FormBox["b", 
                          "TraditionalForm"], TraditionalForm, Editable -> 
                          True], ")"}]}]}]}], "}"}]}], "}"}], 
                 TraditionalForm]], "Output"]}, Open]], 
           Cell[TextData[{"See also: ", 
              ButtonBox["ExplicitPartialD", 
                RuleDelayed[ButtonData, "ExplicitPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ExplicitPartialD"]], ", ", 
              ButtonBox["LeftPartialD", 
                RuleDelayed[ButtonData, "LeftPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LeftPartialD"]], ", ", 
              ButtonBox["LeftRightPartialD", 
                RuleDelayed[ButtonData, "LeftRightPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LeftRightPartialD"]], ", ", 
              ButtonBox["PartialDRelations", 
                RuleDelayed[ButtonData, "PartialDRelations"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PartialDRelations"]], ", ", 
              ButtonBox["RightPartialD", 
                RuleDelayed[ButtonData, "RightPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "RightPartialD"]], "."}], "Text", 
            CellTags -> "ExpandPartialD"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ExpandPartialD"], Cell[CellGroupData[{Cell[BoxData[
                \(\(RightPartialD[\[Mu]]\) . 
                   \(QuantumField[\(A, \(LorentzIndex[\[Mu]]\)\)]\) . 
                   \(QuantumField[\(A, \(LorentzIndex[\[Nu]]\)\)]\)\)], 
               "Input", CellTags -> "ExpandPartialD"], Cell[BoxData[
                FormBox[RowBox[{SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                    FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", \(A\_\[Mu]\), ".", \(A\_\[Nu]\)
                   }], TraditionalForm]], "Output", CellTags -> 
                "ExpandPartialD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(ExpandPartialD[%]\)], "Input", CellTags -> 
                "ExpandPartialD"], Cell[BoxData[FormBox[RowBox[{RowBox[{
                     \(A\_\[Mu]\), ".", RowBox[{SubscriptBox["\[PartialD]", 
                        FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], "\[Null]"]}]}], "+", 
                   RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], "\[Null]"]}], ".", \(A\_\[Nu]\)}]
                     }], TraditionalForm]], "Output", CellTags -> 
                "ExpandPartialD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%//StandardForm\)], "Input", CellTags -> "ExpandPartialD"], 
              Cell[BoxData[
                \(\(\(QuantumField[\(A, \(LorentzIndex[\[Mu]]\)\)]\) . 
                     \(QuantumField[\(\(PartialD[\(LorentzIndex[\[Mu]]\)]\), 
                         A, \(LorentzIndex[\[Nu]]\)\)]\)\) + 
                   \(\(QuantumField[\(\(PartialD[\(LorentzIndex[\[Mu]]\)]\), 
                         A, \(LorentzIndex[\[Mu]]\)\)]\) . 
                     \(QuantumField[\(A, \(LorentzIndex[\[Nu]]\)\)]\)\)\)], 
               "Output", CellTags -> "ExpandPartialD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(LeftRightPartialD[\[Mu]]\) . 
                   \(QuantumField[\(A, \(LorentzIndex[\[Nu]]\)\)]\)\)], 
               "Input", CellTags -> "ExpandPartialD"], Cell[BoxData[
                FormBox[RowBox[{SubscriptBox[
                    \(\[PartialD]\&\[LeftRightArrow]\), FormBox[FormBox[
                      "\[Mu]", "TraditionalForm"], "TraditionalForm"]], ".", 
                   \(A\_\[Nu]\)}], TraditionalForm]], "Output", CellTags -> 
                "ExpandPartialD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(ExpandPartialD[%]\)], "Input", CellTags -> 
                "ExpandPartialD"], Cell[BoxData[FormBox[RowBox[{\(1\/2\), 
                   " ", RowBox[{"(", RowBox[{RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], 
                          "\[Null]"]}], "-", RowBox[{SubscriptBox[
                          \(\[PartialD]\&\[LeftArrow]\), FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                         ".", \(A\_\[Nu]\)}]}], ")"}]}], TraditionalForm]], 
               "Output", CellTags -> "ExpandPartialD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(QuantumField[\(A, \(LorentzIndex[\[Mu]]\)\)]\) . 
                   \((\(LeftRightPartialD[OPEDelta]\)^2)\) . 
                   \(QuantumField[\(A, \(LorentzIndex[\[Rho]]\)\)]\)\)], 
               "Input", CellTags -> "ExpandPartialD"], Cell[BoxData[
                FormBox[RowBox[{\(A\_\[Mu]\), ".", SubsuperscriptBox[
                    \(\[PartialD]\&\[LeftRightArrow]\), FormBox[
                     "\[CapitalDelta]", "TraditionalForm"], "2"], ".", 
                   \(A\_\[Rho]\)}], TraditionalForm]], "Output", CellTags -> 
                "ExpandPartialD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(ExpandPartialD[%]\)], "Input", CellTags -> 
                "ExpandPartialD"], Cell[BoxData[FormBox[RowBox[{\(1\/4\), 
                   " ", RowBox[{"(", RowBox[{RowBox[{\(A\_\[Mu]\), ".", 
                         RowBox[{"(", RowBox[{RowBox[{FormBox[SubscriptBox[
                          "\[PartialD]", FormBox["\[CapitalDelta]", 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                          SubscriptBox["\[PartialD]", FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]], 
                          "TraditionalForm"]}], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"], "\[Null]"]}], ")"}]}], "-", 
                       RowBox[{"2", " ", RowBox[{RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox["\[CapitalDelta]", 
                          "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], "\[Null]"]}], ".", RowBox[
                          {SubscriptBox["\[PartialD]", FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]], 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], 
                          "\[Null]"]}]}]}], "+", RowBox[{RowBox[{"(", RowBox[
                          {RowBox[{FormBox[SubscriptBox["\[PartialD]", 
                          FormBox["\[CapitalDelta]", "TraditionalForm"]], 
                          "TraditionalForm"], FormBox[SubscriptBox[
                          "\[PartialD]", FormBox["\[CapitalDelta]", 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], 
                          "\[Null]"]}], ")"}], ".", \(A\_\[Rho]\)}]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "ExpandPartialD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(8\ \(\(LeftRightPartialD[OPEDelta]\)^3\)\)], "Input", 
               CellTags -> "ExpandPartialD"], Cell[BoxData[FormBox[
                 RowBox[{"8", " ", SubsuperscriptBox[
                    \(\[PartialD]\&\[LeftRightArrow]\), FormBox[
                     "\[CapitalDelta]", "TraditionalForm"], "3"]}], 
                 TraditionalForm]], "Output", CellTags -> "ExpandPartialD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(ExplicitPartialD[%]\)]
                , "Input", CellTags -> "ExpandPartialD"], Cell[BoxData[
                FormBox[SuperscriptBox[RowBox[{"(", RowBox[{SubscriptBox[
                       \(\[PartialD]\&\[RightArrow]\), FormBox[
                        "\[CapitalDelta]", "TraditionalForm"]], "-", 
                      SubscriptBox[\(\[PartialD]\&\[LeftArrow]\), FormBox[
                        "\[CapitalDelta]", "TraditionalForm"]]}], ")"}], 
                  "3"], TraditionalForm]], "Output", CellTags -> 
                "ExpandPartialD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(ExpandPartialD[%]\)], "Input", CellTags -> 
                "ExpandPartialD"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"-", RowBox[{SubscriptBox[
                        \(\[PartialD]\&\[LeftArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]], ".", 
                       SubscriptBox[\(\[PartialD]\&\[LeftArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]], ".", 
                       SubscriptBox[\(\[PartialD]\&\[LeftArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]]}]}], "+", 
                   RowBox[{"3", " ", RowBox[{SubscriptBox[
                        \(\[PartialD]\&\[LeftArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]], ".", 
                       SubscriptBox[\(\[PartialD]\&\[LeftArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]], ".", 
                       SubscriptBox[\(\[PartialD]\&\[RightArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]]}]}], "-", 
                   RowBox[{"3", " ", RowBox[{SubscriptBox[
                        \(\[PartialD]\&\[LeftArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]], ".", 
                       SubscriptBox[\(\[PartialD]\&\[RightArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]], ".", 
                       SubscriptBox[\(\[PartialD]\&\[RightArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]]}]}], "+", 
                   RowBox[{SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                      FormBox["\[CapitalDelta]", "TraditionalForm"]], ".", 
                     SubscriptBox[\(\[PartialD]\&\[RightArrow]\), FormBox[
                       "\[CapitalDelta]", "TraditionalForm"]], ".", 
                     SubscriptBox[\(\[PartialD]\&\[RightArrow]\), FormBox[
                       "\[CapitalDelta]", "TraditionalForm"]]}]}], 
                 TraditionalForm]], "Output", CellTags -> "ExpandPartialD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(LeviCivita[\(\[Mu], \[Nu], \[Rho], \[Tau]\)]\)\ 
                   \(RightPartialD[\(\[Alpha], \[Mu], \[Beta], \[Nu]\)]\)\)], 
               "Input", CellTags -> "ExpandPartialD"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{SubscriptBox[
                      \(\[PartialD]\&\[RightArrow]\), FormBox[FormBox[
                        "\[Alpha]", "TraditionalForm"], "TraditionalForm"]], 
                     ".", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"]], ".", SubscriptBox[
                      \(\[PartialD]\&\[RightArrow]\), FormBox[FormBox[
                        "\[Beta]", "TraditionalForm"], "TraditionalForm"]], 
                     ".", SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"]]}], " ", SuperscriptBox[
                    "\[Epsilon]", RowBox[{FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["\[Tau]", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "ExpandPartialD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(ExpandPartialD[%]\)], "Input", 
               CellTags -> "ExpandPartialD"], Cell[BoxData[
                \(TraditionalForm\`0\)], "Output", CellTags -> 
                "ExpandPartialD"]}, Open]]}, Open]], 
        Cell["ExpandScalarProduct, ScalarProductExpand", "ObjectName", 
         CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}], 
           Cell["ExpandScalarProduct[expr] expands scalar products of sums of \
momenta in expr. ExpandScalarProduct does not use Expand on \
expr.\nScalarProductExpand=ExpandScalarProduct.", "Text", 
            CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[ExpandScalarProduct]\)]
                , "Input", CellTags -> {"ExpandScalarProduct", 
                 "ScalarProductExpand"}], Cell[BoxData[
                \(TraditionalForm\`\({FeynCalcInternal \[Rule] True}\)\)], 
               "Output", CellTags -> {"ExpandScalarProduct", 
                 "ScalarProductExpand"}]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Calc", RuleDelayed[ButtonData, "Calc"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Calc"]], 
              ", ", 
              ButtonBox["MomentumExpand", 
                RuleDelayed[ButtonData, "MomentumExpand"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "MomentumExpand"]], ", ", 
              ButtonBox["MomentumCombine", 
                RuleDelayed[ButtonData, "MomentumCombine"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "MomentumCombine"]], "."}], "Text", 
            CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}]}, 
          Open]], Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\ \(SP[\(\(p1 + p2 + p3\), \(p4 + p5 + p6\)\)]\)\)], 
               "Input", CellTags -> {"ExpandScalarProduct", 
                 "ScalarProductExpand"}], Cell[BoxData[FormBox[RowBox[
                  {"(", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_1 + 
                       \(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_2 + 
                       \(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_3\), 
                    "TraditionalForm"], ")", "\[CenterDot]", "(", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_4 + 
                       \(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_5 + 
                       \(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_6\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%//ScalarProductExpand\)], "Input", CellTags -> 
                {"ExpandScalarProduct", "ScalarProductExpand"}], 
              Cell[BoxData[FormBox[RowBox[{"(", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_1 + 
                       \(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_2 + 
                       \(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_3\), 
                    "TraditionalForm"], ")", "\[CenterDot]", "(", FormBox[
                    \(\(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_4 + 
                       \(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_5 + 
                       \(\*TagBox[StyleBox["\"p\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_6\), 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(SP[\(p, \(p - q\)\)]\)
                ], "Input", CellTags -> {"ExpandScalarProduct", 
                 "ScalarProductExpand"}], Cell[BoxData[FormBox[RowBox[
                  {FormBox["p", "TraditionalForm"], "\[CenterDot]", "(", 
                   FormBox[\(p - q\), "TraditionalForm"], ")"}], 
                 TraditionalForm]], "Output", CellTags -> 
                {"ExpandScalarProduct", "ScalarProductExpand"}]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(ExpandScalarProduct[%]\)], 
               "Input", CellTags -> {"ExpandScalarProduct", 
                 "ScalarProductExpand"}], Cell[BoxData[FormBox[RowBox[
                  {FormBox["p", "TraditionalForm"], "\[CenterDot]", "(", 
                   FormBox[\(p - q\), "TraditionalForm"], ")"}], 
                 TraditionalForm]], "Output", CellTags -> 
                {"ExpandScalarProduct", "ScalarProductExpand"}]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(FV[\(\(p - q\), \[Mu]\)]\)], 
               "Input", CellTags -> {"ExpandScalarProduct", 
                 "ScalarProductExpand"}], Cell[BoxData[FormBox[SuperscriptBox[
                  FormBox[\(p - q\), "TraditionalForm"], "\[Mu]"], 
                 TraditionalForm]], "Output", CellTags -> 
                {"ExpandScalarProduct", "ScalarProductExpand"}]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(ExpandScalarProduct[%]\)], 
               "Input", CellTags -> {"ExpandScalarProduct", 
                 "ScalarProductExpand"}], Cell[BoxData[FormBox[SuperscriptBox[
                  FormBox[\(p - q\), "TraditionalForm"], "\[Mu]"], 
                 TraditionalForm]], "Output", CellTags -> 
                {"ExpandScalarProduct", "ScalarProductExpand"}]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(SP[\(\(p - q\), \(q - r\)\)]\)//FCI\)], "Input", 
               CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}], 
              Cell[BoxData[FormBox[RowBox[{"(", FormBox[\(p - q\), 
                    "TraditionalForm"], ")", "\[CenterDot]", "(", FormBox[
                    \(q - r\), "TraditionalForm"], ")"}], TraditionalForm]], 
               "Output", CellTags -> {"ExpandScalarProduct", 
                 "ScalarProductExpand"}]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(%/.\(Pair \[Rule] ExpandScalarProduct\)\)], "Input", 
               CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}], 
              Cell[BoxData[FormBox[RowBox[{RowBox[{FormBox["p", 
                      "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                      "TraditionalForm"]}], "-", RowBox[{FormBox["p", 
                      "TraditionalForm"], "\[CenterDot]", FormBox["r", 
                      "TraditionalForm"]}], "-", SuperscriptBox[FormBox["q", 
                     "TraditionalForm"], "2"], "+", RowBox[{FormBox["q", 
                      "TraditionalForm"], "\[CenterDot]", FormBox["r", 
                      "TraditionalForm"]}]}], TraditionalForm]], "Output", 
               CellTags -> {"ExpandScalarProduct", "ScalarProductExpand"}]}, 
             Open]]}, Open]], Cell["Expand2", "ObjectName", 
         CellTags -> "Expand2"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Expand2"], 
           Cell["Expand2[exp, x] expands all sums containing x. Expand2[exp, \
{x1, x2, ...}]  expands all sums containing x1, x2, ....", "Text", 
            CellTags -> "Expand2"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Expand2"], Cell[CellGroupData[{Cell[BoxData[
                \(Expand2[\(\(\(\((x1 + x2 + x3)\) \((\(2x1\) + \(3x2\))\)\) 
                       + \(\((y1 + y2 + y3)\) \((\(2y1\) + \(3y2\))\)\)\), 
                     \({x1, x2}\)\)]\)], "Input", CellTags -> "Expand2"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\(2\ x1\^2\) + \(5\ x2\ x1\) + 
                     \(2\ x3\ x1\) + \(3\ x2\^2\) + \(3\ x2\ x3\) + 
                     \(\((\(2\ y1\) + \(3\ y2\))\)\ \((y1 + y2 + y3)\)\)\)\)]\
, "Output", CellTags -> "Expand2"]}, Open]]}, Open]], Cell["Explicit", 
         "ObjectName", CellTags -> "Explicit"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Explicit"], Cell[TextData[{"Explicit is an option \
for FieldStrength, GluonVertex, SUNF, and Twist2GluonOperator. If set to True \
the full form of the operator is inserted. ", 
              StyleBox["Explicit[exp]", 
                Rule[FontVariations, List[Rule["CompatibilityType", 0]]]], " \
inserts explicit expressions of GluonVertex, Twist2GluonOperator etc. in exp. \
SUNF's are replaced by SUNTrace objects."}], "Text", CellTags -> "Explicit"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["GluonVertex", RuleDelayed[ButtonData, 
                 "GluonVertex"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "GluonVertex"]], ", ", 
              ButtonBox["Twist2GluonOperator", 
                RuleDelayed[ButtonData, "Twist2GluonOperator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Twist2GluonOperator"]], "."}], "Text", 
            CellTags -> "Explicit"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[Explicit]\)], "Input"], Cell[BoxData[
                \(TraditionalForm\`\({\(CouplingConstant \[Rule] g\_s\), 
                      \(Dimension \[Rule] D\), \(Gauge \[Rule] 1\), 
                      \(\[CapitalOmega] \[Rule] False\)}\)\)], "Output"]}, 
             Open]]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "Explicit"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(GluonPropagator[\(p, \[Mu], \[Nu]\)]\)], "Input"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\[CapitalPi]\_g\%\(\[Mu]\[Nu]\)(p)\)\)], 
               "Output"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Explicit[%]\)], "Input"], Cell[BoxData[
                \(TraditionalForm\`\(-\(\(\[ImaginaryI]\ g\^\(\[Mu]\[Nu]\)\)
                       \/p\^2\)\)\)], "Output"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Explicit[\(\(GluonPropagator[\(p, \[Mu], \[Nu]\)]\), 
                     \(Gauge \[Rule] \[Xi]\)\)]\)], "Input"], 
              Cell[BoxData[FormBox[FractionBox[RowBox[{"\[ImaginaryI]", " ", 
                    RowBox[{"(", RowBox[{FractionBox[RowBox[{\((1 - \[Xi])\), 
                          " ", SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], \(p\^2\)], "-", 
                        \(g\^\(\[Mu]\[Nu]\)\)}], ")"}]}], \(p\^2\)], 
                 TraditionalForm]], "Output"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(GluonVertex[\(p, \[Mu], a,\ q, \[Nu], b, r, \[Rho], c\)]\)]\
, "Input", CellTags -> "Explicit"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{SuperscriptBox["V", RowBox[{FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"]}]], "(", 
                     RowBox[{FormBox["p", "TraditionalForm"], \(,\ \), 
                       FormBox["q", "TraditionalForm"], \(,\ \), FormBox["r", 
                        "TraditionalForm"]}], ")"}], " ", SubscriptBox["f", 
                    RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "Explicit"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Explicit[%]\)], "Input", CellTags -> 
                "Explicit"], Cell[BoxData[FormBox[RowBox[{\(g\_s\), " ", 
                   RowBox[{"(", RowBox[{RowBox[{RowBox[{"(", RowBox[
                          {SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "-", SuperscriptBox[FormBox[
                          "r", "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}], 
                         " ", \(g\^\(\[Nu]\[Rho]\)\)}], "+", RowBox[{
                         \(g\^\(\[Mu]\[Rho]\)\), " ", RowBox[{"(", RowBox[
                          {SuperscriptBox[FormBox["r", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], "-", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}]}], 
                       "+", RowBox[{\(g\^\(\[Mu]\[Nu]\)\), " ", RowBox[
                          {"(", RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"]], "-", 
                          SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}]}], ")"}], " ", 
                   SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["c", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "Explicit"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Twist2GluonOperator[\(p, \[Mu], a, \[Nu], b\)]\)]
                , "Input", CellTags -> "Explicit"], Cell[BoxData[
                FormBox[RowBox[{\(1\/2\), " ", RowBox[{"(", RowBox[{FormBox[
                        \(\((\(-1\))\)\^m\), "TraditionalForm"], "+", "1"}], 
                     ")"}], " ", SubscriptBox["\[Delta]", RowBox[
                     {FormBox[FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"]}]], " ", 
                   RowBox[{"(", RowBox[{SubsuperscriptBox["O", RowBox[
                         {FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], "\[VeryThinSpace]", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]}], "G2"], "(", FormBox["p", 
                        "TraditionalForm"], ")"}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "Explicit"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(Explicit[%]\)], 
               "Input", CellTags -> "Explicit"], Cell[BoxData[FormBox[RowBox[{
                   \(1\/2\), " ", RowBox[{"(", RowBox[{RowBox[{
                         \(g\^\(\[Mu]\[Nu]\)\), " ", SuperscriptBox[FormBox[
                          RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], "TraditionalForm"], "2"]}], 
                       "-", RowBox[{RowBox[{"(", RowBox[{RowBox[
                          {SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", SuperscriptBox[FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{SuperscriptBox[
                          FormBox["\[CapitalDelta]", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]]}]}], ")"}], 
                         " ", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}]}], "+", RowBox[{SuperscriptBox[
                          FormBox["\[CapitalDelta]", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", SuperscriptBox[FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"]}]}], ")"}], " ", 
                   RowBox[{"(", RowBox[{FormBox[\(\((\(-1\))\)\^m\), 
                        "TraditionalForm"], "+", "1"}], ")"}], " ", 
                   FormBox[SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                         "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                       ")"}], \(m - 2\)], "TraditionalForm"], " ", 
                   SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "Explicit"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(FieldStrength[\(\[Mu], \[Nu], a\)]\)], "Input", 
               CellTags -> "Explicit"], Cell[BoxData[
                \(TraditionalForm\`F\_\(\[Mu]\[Nu]\)\%a\)], "Output", 
               CellTags -> "Explicit"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Explicit[%]\)], "Input", CellTags -> 
                "Explicit"], Cell[BoxData[FormBox[RowBox[{RowBox[
                    {SubscriptBox["\[PartialD]", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                        "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]]}], "+", 
                   RowBox[{\(g\_s\), " ", RowBox[{SubsuperscriptBox[FormBox[
                         "A", "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b1", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox[FormBox[
                         "A", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c16", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b1", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c16", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "Explicit"]}, Open]]}, Open]], 
        Cell["ExplicitLorentzIndex", "ObjectName", CellTags -> 
          "ExplicitLorentzIndex"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "ExplicitLorentzIndex"], Cell["ExplicitLorentzIndex[ind] is an \
explicit Lorentz index, i.e., ind is an integer.", "Text", 
            CellTags -> "ExplicitLorentzIndex"], Cell[TextData[{"See also: ", 
              ButtonBox["LorentzIndex", 
                RuleDelayed[ButtonData, "LorentzIndex"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LorentzIndex"]], ", ", 
              ButtonBox["Pair", RuleDelayed[ButtonData, "Pair"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Pair"]], 
              "."}], "Text", CellTags -> "ExplicitLorentzIndex"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ExplicitLorentzIndex"], Cell[CellGroupData[
             {Cell[BoxData[
                \(Pair[\(\(LorentzIndex[1]\), \(LorentzIndex[\[Mu]]\)\)]\)], 
               "Input", CellTags -> "ExplicitLorentzIndex"], Cell[BoxData[
                FormBox[SuperscriptBox["g", RowBox[{FormBox["1", 
                     "TraditionalForm"], "\[Mu]"}]], TraditionalForm]], 
               "Output", CellTags -> "ExplicitLorentzIndex"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "ExplicitLorentzIndex"], Cell[BoxData[
                \(Pair[\(\(ExplicitLorentzIndex[1]\), \(LorentzIndex[\[Mu]]\)
                    \)]\)], "Output", CellTags -> "ExplicitLorentzIndex"]}, 
             Open]]}, Open]], Cell["ExplicitPartialD", "ObjectName", 
         CellTags -> "ExplicitPartialD"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "ExplicitPartialD"], Cell["ExplicitPartialD[exp] inserts in exp \
the definition for LeftRightPartialD[z] (and LeftRightPartialD2[z]).", 
            "Text", CellTags -> "ExplicitPartialD"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["ExpandPartialD", 
                RuleDelayed[ButtonData, "ExpandPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ExpandPartialD"]], ", ", 
              ButtonBox["LeftRightPartialD", 
                RuleDelayed[ButtonData, "LeftRightPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LeftRightPartialD"]], ", ", 
              ButtonBox["LeftRightPartialD2", 
                RuleDelayed[ButtonData, "LeftRightPartialD2"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "LeftRightPartialD2"]], "."}], "Text", 
            CellTags -> "ExplicitPartialD"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ExplicitPartialD"], Cell[CellGroupData[{Cell[BoxData[
                \(ExplicitPartialD[\ \(LeftRightPartialD[\[Mu]]\)\ ]\)], 
               "Input", CellTags -> "ExplicitPartialD"], Cell[BoxData[
                FormBox[RowBox[{\(1\/2\), " ", RowBox[{"(", RowBox[
                      {SubscriptBox[\(\[PartialD]\&\[RightArrow]\), FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], "-", SubscriptBox[
                        \(\[PartialD]\&\[LeftArrow]\), FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "ExplicitPartialD"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(ExplicitPartialD[\ \(LeftRightPartialD2[\[Mu]]\)\ ]\)], 
               "Input", CellTags -> "ExplicitPartialD"], Cell[BoxData[
                FormBox[RowBox[{SubscriptBox[\(\[PartialD]\&\[LeftArrow]\), 
                    FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]], "+", SubscriptBox[
                    \(\[PartialD]\&\[RightArrow]\), FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "ExplicitPartialD"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(ExplicitPartialD[\ \(LeftRightPartialD[OPEDelta]\)\ ]\)], 
               "Input", CellTags -> "ExplicitPartialD"], Cell[BoxData[
                FormBox[RowBox[{\(1\/2\), " ", RowBox[{"(", RowBox[
                      {SubscriptBox[\(\[PartialD]\&\[RightArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]], "-", 
                       SubscriptBox[\(\[PartialD]\&\[LeftArrow]\), FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "ExplicitPartialD"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(16\ \(\(LeftRightPartialD[OPEDelta]\)^4\)\)], 
               "Input", CellTags -> "ExplicitPartialD"], Cell[BoxData[
                FormBox[RowBox[{"16", " ", SubsuperscriptBox[
                    \(\[PartialD]\&\[LeftRightArrow]\), FormBox[
                     "\[CapitalDelta]", "TraditionalForm"], "4"]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "ExplicitPartialD"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(ExplicitPartialD[%]\)], "Input", CellTags -> 
                "ExplicitPartialD"], Cell[BoxData[FormBox[SuperscriptBox[
                  RowBox[{"(", RowBox[{SubscriptBox[
                       \(\[PartialD]\&\[RightArrow]\), FormBox[
                        "\[CapitalDelta]", "TraditionalForm"]], "-", 
                      SubscriptBox[\(\[PartialD]\&\[LeftArrow]\), FormBox[
                        "\[CapitalDelta]", "TraditionalForm"]]}], ")"}], 
                  "4"], TraditionalForm]], "Output", CellTags -> 
                "ExplicitPartialD"]}, Open]]}, Open]], 
        Cell["ExplicitSUNIndex", "ObjectName", CellTags -> 
          "ExplicitSUNIndex"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "ExplicitSUNIndex"], Cell[TextData[
             {"ExplicitSUNIndex[ind] is a specific SU(", 
              StyleBox["N", Rule[FontSlant, "Italic"]], 
              ") index, i.e., ind is an integer."}], "Text", 
            CellTags -> "ExplicitSUNIndex"], Cell[TextData[{"See also: ", 
              ButtonBox["FCI", RuleDelayed[ButtonData, "FCI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCI"]], 
              ", ", 
              ButtonBox["SUNDelta", RuleDelayed[ButtonData, "SUNDelta"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SUNDelta"]], ", ", 
              ButtonBox["SUNF", RuleDelayed[ButtonData, "SUNF"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "SUNF"]], 
              ", ", 
              ButtonBox["SUNIndex", RuleDelayed[ButtonData, "SUNIndex"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SUNIndex"]], "."}], "Text", 
            CellTags -> "ExplicitSUNIndex"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "ExplicitSUNIndex"], Cell[CellGroupData[{Cell[BoxData[
                \(ExplicitSUNIndex[1]\)], "Input", CellTags -> 
                "ExplicitSUNIndex"], Cell[BoxData[\(TraditionalForm\`1\)], 
               "Output", CellTags -> "ExplicitSUNIndex"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(\(SUNDelta[\(1, a\)]\)//FCI\)//StandardForm\)], "Input"], 
              Cell[BoxData[
                \(SUNDelta[\(\(ExplicitSUNIndex[1]\), \(SUNIndex[a]\)\)]\)], 
               "Output"]}, Open]]}, Open]], Cell["ExtraFactor", "ObjectName", 
         CellTags -> "ExtraFactor"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "ExtraFactor"], 
           Cell["ExtraFactor is an option for FermionSpinSum. The setting \
ExtraFactor \[Rule] fa  multiplies the whole amplitude with the factor fa \
before squaring.", "Text", CellTags -> "ExtraFactor"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["FermionSpinSum", 
                RuleDelayed[ButtonData, "FermionSpinSum"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FermionSpinSum"]], "."}], "Text", 
            CellTags -> "ExtraFactor"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["ExtraVariables", "ObjectName", CellTags -> "ExtraVariables"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "ExtraVariables"], Cell["ExtraVariables is an option \
for OneLoopSum; it may be set to a list of variables which are also bracketed \
out in the result, just like B0, C0, D0 and  PaVe.", "Text", 
            CellTags -> "ExtraVariables"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["OneLoop", RuleDelayed[ButtonData, "OneLoop"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "OneLoop"]]\
, ", ", 
              ButtonBox["OneLoopSum", RuleDelayed[ButtonData, "OneLoopSum"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "OneLoopSum"]], "."}], "Text", 
            CellTags -> "ExtraVariables"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["FactorFull", "ObjectName", CellTags -> "FactorFull"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FactorFull"], Cell[TextData[{"FactorFull is an \
option of Factor2 (default False). If set to False, products like (", 
              StyleBox["a", Rule[FontSlant, "Italic"]], "-", 
              StyleBox["b", Rule[FontSlant, "Italic"]], ") (", 
              StyleBox["a", Rule[FontSlant, "Italic"]], "+", 
              StyleBox["b", Rule[FontSlant, "Italic"]], 
              ") will be replaced by (", Cell[BoxData[
                \(TraditionalForm\`\(a\^2\)\)]], "-", Cell[BoxData[
                \(TraditionalForm\`\(b\^2\)\)]], ")."}], "Text", 
            CellTags -> "FactorFull"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Factor2", RuleDelayed[ButtonData, "Factor2"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Factor2"]]\
, "."}], "Text", CellTags -> "FactorFull"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["Factoring", "ObjectName", CellTags -> "Factoring"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Factoring"], Cell["Factoring is an option for \
Collect2, Contract, Tr and more functions. If set to True, the result will be \
factored, using Factor2. If set to any function f, this function will be \
used.", "Text", CellTags -> "Factoring"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Collect2", RuleDelayed[ButtonData, "Collect2"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Collect2"]], ", ", 
              ButtonBox["Contract", RuleDelayed[ButtonData, "Contract"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Contract"]], ", ", 
              ButtonBox["Tr", RuleDelayed[ButtonData, "Tr"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Tr"]], 
              "."}], "Text", CellTags -> "Factoring"], Cell[BoxData[""], 
            "Input"]}, Open]], Cell["Factorout", "ObjectName", 
         CellTags -> "Factorout"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "Factorout"], 
           Cell["Factorout is an option for OPEInt and OPEIntegrate.", 
            "Text", CellTags -> "Factorout"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["OPEInt", RuleDelayed[ButtonData, "OPEInt"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "OPEInt"]], 
              ", ", 
              ButtonBox["OPEIntegrate", 
                RuleDelayed[ButtonData, "OPEIntegrate"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "OPEIntegrate"]], "."}], "Text", 
            CellTags -> "Factorout"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["Factor1", "ObjectName", CellTags -> "Factor1"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Factor1"], Cell["Factor1[poly] factorizes common \
terms  in the summands of poly. It uses basically PolynomialGCD.", "Text", 
            CellTags -> "Factor1"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Factor2", RuleDelayed[ButtonData, "Factor2"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Factor2"]]\
, "."}], "Text", CellTags -> "Factor1"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Factor1"], Cell[CellGroupData[{Cell[BoxData[
                \(t1 = \(\((a - x)\) \((b - x)\)\)\)], "Input", CellTags -> 
                "Factor1"], Cell[BoxData[
                \(TraditionalForm\`\(\((a - x)\)\ \((b - x)\)\)\)], "Output", 
               CellTags -> "Factor1"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(t2 = \({\(Factor1[t1]\),\ \(Factor[t1]\)}\)\)], 
               "Input", CellTags -> "Factor1"], Cell[BoxData[
                \(TraditionalForm\`\({\(\((a - x)\)\ \((b - x)\)\), 
                      \(\(-\((a - x)\)\)\ \((x - b)\)\)}\)\)], "Output", 
               CellTags -> "Factor1"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(t3 = \(Expand[\(\((a - b)\) \((a + b)\)\)]\)\)], 
               "Input", CellTags -> "Factor1"], Cell[BoxData[
                \(TraditionalForm\`\(a\^2 - b\^2\)\)], "Output", CellTags -> 
                "Factor1"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Factor[t3]\)], "Input", CellTags -> "Factor1"], 
              Cell[BoxData[\(TraditionalForm\`\(\((a - b)\)\ \((a + b)\)\)\)]
                , "Output", CellTags -> "Factor1"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Factor1[t3]\)], "Input", 
               CellTags -> "Factor1"], Cell[BoxData[
                \(TraditionalForm\`\(a\^2 - b\^2\)\)], "Output", CellTags -> 
                "Factor1"]}, Open]], Cell[BoxData[\(Clear[\(t1, t2, t3\)]\)], 
            "Input", CellTags -> "Factor1"]}, Open]], 
        Cell["Factor2", "ObjectName", CellTags -> "Factor2"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "Factor2"], Cell["Factor2[poly] factors a polynomial \
in a standard way. Factor2 works sometimes better than Factor on polynomials \
involving rationals with sums in the denominator. Factor2 uses Factor \
internally and is in general slower than Factor. There are four possible \
settings of the option Method (0,1,2,3). In general Factor will work faster \
than Factor2.", "Text", CellTags -> "Factor2"], Cell[CellGroupData[
             {Cell[BoxData[\(Options[Factor2]\)], "Input", CellTags -> 
                "Factor2"], Cell[BoxData[
                \(TraditionalForm\`\({\(HighEnergyPhysics`FeynCalc`FactorFul\
l`FactorFull \[Rule] False\), \(Method \[Rule] 3\)}\)\)], "Output", 
               CellTags -> "Factor2"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Collect2", RuleDelayed[ButtonData, "Collect2"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Collect2"]], "."}], "Text", 
            CellTags -> "Factor2"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "Factor2"], Cell[CellGroupData[{Cell[BoxData[
                \(t1 = \(\((a - x)\) \((b - x)\)\)\)], "Input", CellTags -> 
                "Factor2"], Cell[BoxData[
                \(TraditionalForm\`\(\((a - x)\)\ \((b - x)\)\)\)], "Output", 
               CellTags -> "Factor2"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(t2 = \({\(Factor2[t1]\),\ \(Factor[t1]\)}\)\)], 
               "Input", CellTags -> "Factor2"], Cell[BoxData[
                \(TraditionalForm\`\({\(\((a - x)\)\ \((b - x)\)\), 
                      \(\(-\((a - x)\)\)\ \((x - b)\)\)}\)\)], "Output", 
               CellTags -> "Factor2"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(t3 = \(Expand[\(\((a - b)\) \((a + b)\)\)]\)\)], 
               "Input", CellTags -> "Factor2"], Cell[BoxData[
                \(TraditionalForm\`\(a\^2 - b\^2\)\)], "Output", CellTags -> 
                "Factor2"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Factor[t3]\)], "Input", CellTags -> "Factor2"], 
              Cell[BoxData[\(TraditionalForm\`\(\((a - b)\)\ \((a + b)\)\)\)]
                , "Output", CellTags -> "Factor2"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Factor2[t3]\)], "Input", 
               CellTags -> "Factor2"], Cell[BoxData[
                \(TraditionalForm\`\(a\^2 - b\^2\)\)], "Output", CellTags -> 
                "Factor2"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Factor2[\(t3, \(FactorFull \[Rule] True\)\)]\)], "Input", 
               CellTags -> "Factor2"], Cell[BoxData[
                \(TraditionalForm\`\(\((a - b)\)\ \((a + b)\)\)\)], "Output", 
               CellTags -> "Factor2"]}, Open]], Cell[BoxData[
             \(Clear[\(t1, t2, t3\)]\)], "Input", CellTags -> "Factor2"]}, 
          Open]], Cell["FAD", "ObjectName", CellTags -> "FAD"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FAD"], Cell["FAD is the FeynCalc external form of \
FeynAmpDenominator and denotes an inverse propagator. FAD[q, q-p, ...] is \
1/(q^2 (q-p)^2 ...). FAD[{q1,m}, {q1-p,m}, q2, ...] is 1/( (q1^2 - m^2) ( \
(q1-p)^2 - m^2 ) q2^2 ... ). Translation into FeynCalc internal form is \
performed by FeynCalcInternal.", "Text", CellTags -> "FAD"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FAD", RuleDelayed[ButtonData, "FAD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FAD"]], 
              ", ", 
              ButtonBox["FCE", RuleDelayed[ButtonData, "FCE"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCE"]], 
              ", ", 
              ButtonBox["FCI", RuleDelayed[ButtonData, "FCI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCI"]], 
              ", ", 
              ButtonBox["FeynAmpDenominator", 
                RuleDelayed[ButtonData, "FeynAmpDenominator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynAmpDenominator"]], ", ", 
              ButtonBox["FeynAmpDenominatorSimplify", 
                RuleDelayed[ButtonData, "FeynAmpDenominatorSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynAmpDenominatorSimplify"]], ", ", 
              ButtonBox["PropagatorDenominator", 
                RuleDelayed[ButtonData, "PropagatorDenominator"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PropagatorDenominator"]], "."}], "Text", 
            CellTags -> "FAD"]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "FAD"], 
           Cell[CellGroupData[{Cell[BoxData[\(FAD[\(q, \(p - q\)\)]\)], 
               "Input", CellTags -> "FAD"], Cell[BoxData[
                \(TraditionalForm\`\(1\/\(
                      \((\*InterpretationBox[\(
                            "["\[InvisibleSpace] \((p - q)\)\^2 
                             \[InvisibleSpace]"]"\), 
                           SequenceForm["[", 
                            Power[Plus[p, Times[-1, q]], 2], "]"], 
                           Rule[Editable, False]])\)\ 
                       \((\*InterpretationBox[\(
                            "["\[InvisibleSpace] q\^2 \[InvisibleSpace]"]"\)\
, SequenceForm["[", Power[q, 2], "]"], Rule[Editable, False]]\
)\)\)\)\)], "Output", CellTags -> "FAD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(FAD[\(p, \({\(p - q\), m}\)\)]\)
                ], "Input", CellTags -> "FAD"], Cell[BoxData[
                \(TraditionalForm\`\(1\/\(
                      \((\*InterpretationBox[\(
                            "["\[InvisibleSpace] p\^2 \[InvisibleSpace]"]"\)\
, SequenceForm["[", Power[p, 2], "]"], Rule[Editable, False]]\
)\)\ \((\*InterpretationBox[\(
                            "["\[InvisibleSpace] \((p - q)\)\^2 
                             \[InvisibleSpace]"-"\[InvisibleSpace] m\^2 
                             \[InvisibleSpace]"]"\), 
                           SequenceForm["[", 
                            Power[Plus[p, Times[-1, q]], 2], "-", 
                            Power[m, 2], "]"], Rule[Editable, False]])\)\)\)\
\)], "Output", CellTags -> "FAD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(\(FAD[\(q, \(p - q\)\)]\)//FCI\)//FCE\)//StandardForm\)]\
, "Input", CellTags -> "FAD"], Cell[BoxData[\(FAD[\(q, \(p - q\)\)]\)], 
               "Output", CellTags -> "FAD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(\(FAD[\(q, \(p - q\)\)]\)//FCI\)//StandardForm\)], 
               "Input", CellTags -> "FAD"], Cell[BoxData[
                \(FeynAmpDenominator[\(\(
                      PropagatorDenominator[\(\(Momentum[\(q, D\)]\), 0\)]\),
                      \(PropagatorDenominator[
                       \(\(\(Momentum[\(p, D\)]\) - \(Momentum[\(q, D\)]\)\),
                          0\)]\)\)]\)], "Output", CellTags -> "FAD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(\(FAD[p]\)\ \(FAD[\(p - q\)]\)\)\ //\ 
                     FeynAmpDenominatorCombine\)//StandardForm\)], "Input", 
               CellTags -> "FAD"], Cell[BoxData[
                \(FeynAmpDenominator[\(\(
                      PropagatorDenominator[\(\(Momentum[\(p, D\)]\), 0\)]\),
                      \(PropagatorDenominator[
                       \(\(\(Momentum[\(p, D\)]\) - \(Momentum[\(q, D\)]\)\),
                          0\)]\)\)]\)], "Output", CellTags -> "FAD"]}, 
             Open]]}, Open]], Cell["FC", "ObjectName", CellTags -> "FC"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FC"], Cell["FC changes the output format to \
FeynCalcForm. To change to InputForm use FI.", "Text", CellTags -> "FC"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynCalcForm", 
                RuleDelayed[ButtonData, "FeynCalcForm"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcForm"]], ", ", 
              ButtonBox["FI", RuleDelayed[ButtonData, "FI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FI"]], 
              ", ", 
              ButtonBox["FeynCalcExternal", 
                RuleDelayed[ButtonData, "FeynCalcExternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcExternal"]], ", ", 
              ButtonBox["FeynCalcInternal", 
                RuleDelayed[ButtonData, "FeynCalcInternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcInternal"]], "."}], "Text", 
            CellTags -> "FC"]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "FC"], 
           Cell[BoxData["FI"], "Input", CellTags -> "FC"], 
           Cell[CellGroupData[{Cell[BoxData[
                \({\(DiracGamma[5]\), \(DiracGamma[\(Momentum[p]\)]\)}\)], 
               "Input", CellTags -> "FC"], Cell[
               "{DiracGamma[5], DiracGamma[Momentum[p]]}", "Output", 
               CellTags -> "FC"]}, Open]], Cell[BoxData["FC"], "Input", 
            CellTags -> "FC"], Cell[CellGroupData[{Cell[BoxData[
                \({\(DiracGamma[5]\), \(DiracGamma[\(Momentum[p]\)]\)}\)], 
               "Input", CellTags -> "FC"], Cell[BoxData[FormBox[
                 RowBox[{"{", RowBox[{\(\[Gamma]\^5\), ",", RowBox[
                      {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["p", "TraditionalForm"]}]}], 
                   "}"}], TraditionalForm]], "Output", CellTags -> "FC"]}, 
             Open]]}, Open]], Cell["FCE", "ObjectName", CellTags -> "FCE"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FCE"], Cell["FCE[exp] translates exp from the \
internal FeynCalc representation to a short form.", "Text", 
            CellTags -> "FCE"], Cell[
            "FCE is equivalent to FeynCalcExternal.", "Text", 
            CellTags -> "FCE"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynCalcExternal", 
                RuleDelayed[ButtonData, "FeynCalcExternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcExternal"]], ", ", 
              ButtonBox["FCI", RuleDelayed[ButtonData, "FCI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCI"]], 
              ", ", 
              ButtonBox["FeynCalcInternal", 
                RuleDelayed[ButtonData, "FeynCalcInternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcInternal"]], "."}], "Text", 
            CellTags -> "FCE"]}, Open]], Cell[CellGroupData[
          {Cell["Examples", "Subsubsection", CellTags -> "FCE"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FCE[\({\(DiracGamma[5]\), \(DiracGamma[\(Momentum[p]\)]\)}
                    \)]\)], "Input", CellTags -> "FCE"], Cell[BoxData[
                \(TraditionalForm\`\({\[Gamma]\^5, 
                      \(\[Gamma] \[CenterDot] p\)}\)\)], "Output", 
               CellTags -> "FCE"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%//StandardForm\)], "Input", CellTags -> "FCE"], 
              Cell[BoxData[\({\(GA[5]\), \(GS[p]\)}\)], "Output", CellTags -> 
                "FCE"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Input", CellTags -> "FCE"], 
              Cell[BoxData[FormBox[RowBox[{"{", RowBox[{\(\[Gamma]\^\[Mu]\), 
                     ",", \(\[Gamma]\^\[Rho]\), ",", 
                     \(\[Gamma] \[CenterDot] p\), ",", FormBox[RowBox[
                       {FormBox["p", "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q", "TraditionalForm"]}], 
                      "TraditionalForm"], ",", \(g\^\(\[Alpha]\[Beta]\)\), 
                     ",", \(p\^\[Mu]\)}], "}"}], TraditionalForm]], "Output", 
               CellTags -> "FCE"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%//StandardForm\)], "Input", CellTags -> "FCE"], 
              Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Output", CellTags -> "FCE"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(%//FCI\)], "Input", 
               CellTags -> "FCE"], Cell[BoxData[FormBox[RowBox[{"{", 
                   RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     ",", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Rho]", "TraditionalForm"], "TraditionalForm"]], 
                     ",", RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                     ",", RowBox[{FormBox["p", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                     ",", \(g\^\(\[Alpha]\[Beta]\)\), ",", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]]}], 
                   "}"}], TraditionalForm]], "Output", CellTags -> "FCE"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], 
               "Input", CellTags -> "FCE"], Cell[BoxData[
                \({\(DiracGamma[\(LorentzIndex[\[Mu]]\)]\), 
                    \(DiracGamma[\(\(LorentzIndex[\(\[Rho], D\)]\), D\)]\), 
                    \(DiracGamma[\(Momentum[p]\)]\), 
                    \(Pair[\(\(Momentum[p]\), \(Momentum[q]\)\)]\), 
                    \(Pair[\(\(LorentzIndex[\[Alpha]]\), 
                        \(LorentzIndex[\[Beta]]\)\)]\), 
                    \(Pair[\(\(LorentzIndex[\[Mu]]\), \(Momentum[p]\)\)]\)}\)]\
, "Output", CellTags -> "FCE"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(FCE[%]\)//StandardForm\)], "Input", CellTags -> "FCE"], 
              Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Output", CellTags -> "FCE"]}, 
             Open]]}, Open]], Cell["FCI", "ObjectName", CellTags -> "FCI"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FCI"], Cell["FCI[exp] translates exp into the \
internal FeynCalc (datatype-)representation.FCI is equivalent to \
FeynCalcInternal.", "Text", CellTags -> "FCI"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynCalcExternal", 
                RuleDelayed[ButtonData, "FeynCalcExternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcExternal"]], ", ", 
              ButtonBox["FeynCalcInternal", 
                RuleDelayed[ButtonData, "FeynCalcInternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcInternal"]], ", ", 
              ButtonBox["FCE", RuleDelayed[ButtonData, "FCE"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCE"]], 
              "."}], "Text", CellTags -> "FCI"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FCI"], Cell[CellGroupData[{Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Input", CellTags -> "FCI"], 
              Cell[BoxData[FormBox[RowBox[{"{", RowBox[{\(\[Gamma]\^\[Mu]\), 
                     ",", \(\[Gamma]\^\[Rho]\), ",", 
                     \(\[Gamma] \[CenterDot] p\), ",", FormBox[RowBox[
                       {FormBox["p", "TraditionalForm"], "\[CenterDot]", 
                        FormBox["q", "TraditionalForm"]}], 
                      "TraditionalForm"], ",", \(g\^\(\[Alpha]\[Beta]\)\), 
                     ",", \(p\^\[Mu]\)}], "}"}], TraditionalForm]], "Output", 
               CellTags -> "FCI"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%//StandardForm\)], "Input", CellTags -> "FCI"], 
              Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Output", CellTags -> "FCI"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(%//FCI\)], "Input", 
               CellTags -> "FCI"], Cell[BoxData[FormBox[RowBox[{"{", 
                   RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     ",", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Rho]", "TraditionalForm"], "TraditionalForm"]], 
                     ",", RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                     ",", RowBox[{FormBox["p", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                     ",", \(g\^\(\[Alpha]\[Beta]\)\), ",", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]]}], 
                   "}"}], TraditionalForm]], "Output", CellTags -> "FCI"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], 
               "Input", CellTags -> "FCI"], Cell[BoxData[
                \({\(DiracGamma[\(LorentzIndex[\[Mu]]\)]\), 
                    \(DiracGamma[\(\(LorentzIndex[\(\[Rho], D\)]\), D\)]\), 
                    \(DiracGamma[\(Momentum[p]\)]\), 
                    \(Pair[\(\(Momentum[p]\), \(Momentum[q]\)\)]\), 
                    \(Pair[\(\(LorentzIndex[\[Alpha]]\), 
                        \(LorentzIndex[\[Beta]]\)\)]\), 
                    \(Pair[\(\(LorentzIndex[\[Mu]]\), \(Momentum[p]\)\)]\)}\)]\
, "Output", CellTags -> "FCI"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(FCE[%]\)//StandardForm\)], "Input", CellTags -> "FCI"], 
              Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Output", CellTags -> "FCI"]}, 
             Open]]}, Open]], Cell["FCIntegral", "ObjectName", 
         CellTags -> "FCIntegral"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "FCIntegral"], 
           Cell["FCIntegral is the head of integrals in a setting of the \
option IntegralTable of FeynAmpDenominatorSimplify. Currently implemented \
only for 2-loop integrals.", "Text", CellTags -> "FCIntegral"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["IntegralTable", 
                RuleDelayed[ButtonData, "IntegralTable"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "IntegralTable"]], ", ", 
              ButtonBox["FeynAmpDenominatorSimplify", 
                RuleDelayed[ButtonData, "FeynAmpDenominatorSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynAmpDenominatorSimplify"]], "."}], 
            "Text", CellTags -> "FCIntegral"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["FCIntegrate", "ObjectName", CellTags -> 
          "FCIntegrate"], Cell[CellGroupData[{Cell["Description", 
            "Subsubsection", CellTags -> "FCIntegrate"], Cell["FCIntegrate is \
an option of certain Feynman integral related functions. It determines which \
integration function is used to evaluate analytic integrals. Possible \
settings include Integrate, NIntegrate, (Dot[Integratedx@@#2, #1] &).", 
            "Text", CellTags -> "FCIntegrate"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FCNIntegrate", 
                RuleDelayed[ButtonData, "FCNIntegrate"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FCNIntegrate"]], "."}], "Text", 
            CellTags -> "FCIntegrate"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["FCNIntegrate", "ObjectName", CellTags -> "FCNIntegrate"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FCNIntegrate"], Cell["FCNIntegrate is an option of \
certain Feynman integral related functions which may return output containing \
both integrals that can be evaluated and integrals that can only be evaluated \
numerically. It then determines which integration function is used to \
evaluate numeric integrals. Possible settings include NIntegrate, (0*#1)&, \
(Dot[Integratedx@@#2, #1] &).", "Text", CellTags -> "FCNIntegrate"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FCIntegrate", RuleDelayed[ButtonData, 
                 "FCIntegrate"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FCIntegrate"]], "."}], "Text", 
            CellTags -> "FCNIntegrate"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["FC2RHI ", "ObjectName", CellTags -> "FC2RHI"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FC2RHI"], Cell["FC2RHI[exp, k1, k2] transforms all \
2-loop OPE-integrals in FeynAmpDenominator form to the RHI-integrals.  \
FC2RHI[exp] is equivalent to FC2RHI[exp,q1,q2]. The option IncludePair \
governs the inclusion  of scalar products p.k1, p.k2 and k1.k2 (setting \
True).", "Text", CellTags -> "FC2RHI"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[FC2RHI]\)], "Input", CellTags -> "FC2RHI"], 
              Cell[BoxData[
                \(TraditionalForm\`\({\(Dimension \[Rule] D\), 
                      \(IncludePair \[Rule] True\), \(Do \[Rule] True\)}\)\)]\
, "Output", CellTags -> "FC2RHI"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t = \(\(\(FAD[\(q1, \(q1 - q2\), \(q2 - p\)\)]\)\ 
                       \(\(SP[\(q1, OPEDelta\)]\)^OPEm\)\)//FCI\)\)], 
               "Input"], Cell[BoxData[FormBox[FractionBox[SuperscriptBox[
                   RowBox[{"(", RowBox[{FormBox["\[CapitalDelta]", 
                        "TraditionalForm"], "\[CenterDot]", FormBox[
                        \(\(\*TagBox[StyleBox["\"q\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_1\), 
                        "TraditionalForm"]}], ")"}], "m"], 
                  \(\(\*TagBox[StyleBox["\"q\"", Rule[FontSlant, "Italic"]], 
                         Function[StyleForm[Slot[1], 
                           Rule[FontSlant, "Italic"]]]]\)\_1\%2 . 
                     \((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1 - 
                         \(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2)\)\^2 . 
                     \((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2 - p)\)\^2\)]\
, TraditionalForm]], "Output"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FC2RHI[\(t, q1, q2\)]\)], "Input"], Cell[BoxData[
                FormBox[SubsuperscriptBox[
                  StyleBox["T", Rule[FontFamily, "Times"], 
                    Rule[FontWeight, "Bold"]], 
                  StyleBox[\(10011\), Rule[FontColor, 
                     RGBColor[0.`, 0.`, 1.`]]], RowBox[{FormBox["m", 
                     "TraditionalForm"], FormBox["0", "TraditionalForm"], 
                    FormBox["0", "TraditionalForm"], FormBox["0", 
                     "TraditionalForm"], FormBox["0", "TraditionalForm"]}]], 
                 TraditionalForm]], "Output"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//InputForm\)], "Input"], 
              Cell["RHI[{0, 0, OPEm, 0, 0}, {0, 1, 1, 0, 1}]", "Output"]}, 
             Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["RHI", RuleDelayed[ButtonData, "RHI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "RHI"]], 
              "."}], "Text", CellTags -> "FC2RHI"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FC2RHI"], Cell[BoxData[""], "Input", 
            CellTags -> "FC2RHI"]}, Open]], Cell["FC2TLI ", "ObjectName", 
         CellTags -> "FC2TLI"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "FC2TLI"], 
           Cell["FC2TLI[exp, k1, k2] transforms all 2-loop OPE-integrals in \
FeynAmpDenominator form to the TLI-integrals.  The option IncludePair governs \
the inclusion  of scalar products p.k1, p.k2 and k1.k2 (setting True).", 
            "Text", CellTags -> "FC2TLI"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[FC2TLI]\)], "Input", CellTags -> "FC2TLI"], 
              Cell[BoxData[
                \(TraditionalForm\`\({\(Dimension \[Rule] D\), 
                      \(IncludePair \[Rule] True\), \(Do \[Rule] True\)}\)\)]\
, "Output", CellTags -> "FC2TLI"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(? FAD\)], "Input"], Cell[BoxData["\"FAD[q, q-p, ...] \
denotes 1/(q^2 (q-p)^2 ...). FAD[{q1,m}, {q1-p,m}, q2, ...] is 1/( (q1^2 - \
m^2) ( (q1-p)^2 - m^2 ) q2^2 ... ). (Translation into FeynCalc internal form \
is performed by FeynCalcInternal.)\""], "Print", CellTags -> 
                "Info3353009147-5915384"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t = \(\(FAD[\(\({q1, m1}\), \(q2 - q1\), \(q2 - p\)\)]\)\ 
                     \(\(SP[\(q1, OPEDelta\)]\)^OPEm\)\)\)], "Input"], 
              Cell[BoxData[FormBox[RowBox[{FormBox[
                    \(1\/\(\((\*InterpretationBox[\(
                              "["\[InvisibleSpace] 
                               \((\(\*TagBox[StyleBox["\"q\"", 
                                       Rule[FontSlant, "Italic"]], 
                                       Function[StyleForm[Slot[1], 
                                       Rule[FontSlant, "Italic"]]]]\)\_2 - p\
)\)\^2 \[InvisibleSpace]"]"\), 
                             SequenceForm["[", 
                              Power[Plus[Times[-1, p], q2], 2], "]"], 
                             Rule[Editable, False]])\)\ 
                         \((\*InterpretationBox[\(
                              "["\[InvisibleSpace] 
                               \((\(\*TagBox[StyleBox["\"q\"", 
                                       Rule[FontSlant, "Italic"]], 
                                       Function[StyleForm[Slot[1], 
                                       Rule[FontSlant, "Italic"]]]]\)\_2 - 
                                   \(\*TagBox[StyleBox["\"q\"", 
                                       Rule[FontSlant, "Italic"]], 
                                       Function[StyleForm[Slot[1], 
                                       Rule[FontSlant, "Italic"]]]]\)\_1)\)\
\^2 \[InvisibleSpace]"]"\), 
                             SequenceForm["[", 
                              Power[Plus[Times[-1, q1], q2], 2], "]"], 
                             Rule[Editable, False]])\)\ 
                         \((\*InterpretationBox[\(
                              "["\[InvisibleSpace] 
                               \(\*TagBox[StyleBox["\"q\"", 
                                    Rule[FontSlant, "Italic"]], 
                                   Function[StyleForm[Slot[1], 
                                     Rule[FontSlant, "Italic"]]]]\)\_1\%2 
                               \[InvisibleSpace]"-"\[InvisibleSpace] m1\^2 
                               \[InvisibleSpace]"]"\), 
                             SequenceForm["[", Power[q1, 2], "-", 
                              Power[m1, 2], "]"], Rule[Editable, False]])\)\)
                    \), "TraditionalForm"], " ", SuperscriptBox[RowBox[
                     {"(", FormBox[RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "TraditionalForm"], ")"}], 
                    "m"]}], TraditionalForm]], "Output"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(FC2TLI[\(t, q1, q2\)]\)], 
               "Input"], Cell[BoxData[FormBox[SubsuperscriptBox[
                  StyleBox["T", Rule[FontFamily, "Times"], 
                    Rule[FontWeight, "Bold"]], 
                  \(\*StyleBox["1", Rule[FontWeight, "Bold"], 
                       Rule[FontColor, RGBColor[1.`, 0.`, 0.`]]]\*
                      StyleBox["0", Rule[FontColor, RGBColor[0.`, 0.`, 1.`]]]
                  \*StyleBox["0", Rule[FontColor, RGBColor[0.`, 0.`, 1.`]]]\*
                      StyleBox["1", Rule[FontColor, RGBColor[0.`, 0.`, 1.`]]]
                  \*StyleBox["1", Rule[FontColor, RGBColor[0.`, 0.`, 1.`]]]\)\
, RowBox[{FormBox["m", "TraditionalForm"], FormBox["0", "TraditionalForm"], 
                    FormBox["0", "TraditionalForm"], FormBox["0", 
                     "TraditionalForm"], FormBox["0", "TraditionalForm"]}]], 
                 TraditionalForm]], "Output"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//InputForm\)], "Input"], 
              Cell["TLI[{OPEm, 0, 0, 0, 0}, {{1, m1}, 0, 0, 1, 1}]", 
               "Output"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(TLI2FC[%]\)], "Input"], Cell[BoxData[FormBox[FractionBox[
                  SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                        "\[CapitalDelta]", "TraditionalForm"], 
                       "\[CenterDot]", FormBox[
                        \(\(\*TagBox[StyleBox["\"q\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_1\), 
                        "TraditionalForm"]}], ")"}], "m"], 
                  \(\((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2 - p)\)\^2 . 
                     \((\(\*TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\%2 - m1\^2)\)\
 . \((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1 - 
                         \(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2)\)\^2\)], 
                 TraditionalForm]], "Output"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["TLI", RuleDelayed[ButtonData, "TLI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "TLI"]], 
              "."}], "Text", CellTags -> "FC2TLI"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FC2TLI"], Cell[BoxData[""], "Input", 
            CellTags -> "FC2TLI"]}, Open]], Cell["FDS", "ObjectName", 
         CellTags -> "FDS"], Cell[CellGroupData[{Cell["Description", 
            "Subsubsection", CellTags -> "FDS"], 
           Cell["FDS is shorthand for FeynAmpDenominatorSimplify.", "Text", 
            CellTags -> "FDS"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynAmpDenominatorSimplify", 
                RuleDelayed[ButtonData, "FeynAmpDenominatorSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynAmpDenominatorSimplify"]], "."}], 
            "Text", CellTags -> "FDS"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["FermionSpinSum", "ObjectName", CellTags -> "FermionSpinSum"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FermionSpinSum"], Cell["FermionSpinSum[x] constructs \
the Traces out of squared ampliudes.", "Text", CellTags -> "FermionSpinSum"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[FermionSpinSum]\)], 
               "Input", CellTags -> "FermionSpinSum"], Cell[BoxData[
                \(TraditionalForm\`\({\(SpinPolarizationSum \[Rule] Identity
                       \), \(SpinorCollect \[Rule] False\), 
                      \(ExtraFactor \[Rule] 1\)}\)\)], "Output", CellTags -> 
                "FermionSpinSum"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Spinor", RuleDelayed[ButtonData, "Spinor"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Spinor"]], 
              ", ", 
              ButtonBox["ComplexConjugate", 
                RuleDelayed[ButtonData, "ComplexConjugate"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ComplexConjugate"]], ", ", 
              ButtonBox["DiracTrace", RuleDelayed[ButtonData, "DiracTrace"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracTrace"]], ", ", 
              ButtonBox["Tr", RuleDelayed[ButtonData, "Tr"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Tr"]], 
              "."}], "Text", CellTags -> "FermionSpinSum"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FermionSpinSum"], Cell[TextData[
             {"Spinors of fermions of mass ", 
              StyleBox["m", Rule[FontSlant, "Italic"]], 
              " are normalized to have square 2 ", 
              StyleBox["m", Rule[FontSlant, "Italic"]], " or -2 ", 
              StyleBox["m", Rule[FontSlant, "Italic"]], "."}], "Text", 
            CellTags -> "FermionSpinSum"], Cell[CellGroupData[{Cell[BoxData[
                \(\(SpinorUBar[\(\(Momentum[p]\), m\)]\) . 
                   \(SpinorU[\(\(Momentum[p]\), m\)]\)\)], "Input", 
               CellTags -> "FermionSpinSum"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{FormBox[\("u"\&_\), "TraditionalForm"], "(", 
                     FormBox["p", "TraditionalForm"], ",", "m", ")"}], ".", 
                   RowBox[{"u", "(", FormBox["p", "TraditionalForm"], ",", 
                     "m", ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "FermionSpinSum"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(%//FCI\)//FermionSpinSum\)], "Input", CellTags -> 
                "FermionSpinSum"], Cell[BoxData[FormBox[RowBox[{"tr", "(", 
                   FormBox[RowBox[{"m", "+", RowBox[{FormBox["\"\[Gamma]\"", 
                         "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                         "TraditionalForm"]}]}], "TraditionalForm"], ")"}], 
                 TraditionalForm]], "Output", CellTags -> "FermionSpinSum"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%/.\(DiracTrace \[Rule] TR\)\)], "Input", CellTags -> 
                "FermionSpinSum"], Cell[BoxData[\(TraditionalForm\`\(4\ m\)\)]
                , "Output", CellTags -> "FermionSpinSum"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(SpinorVBar[\(\(Momentum[p]\), m\)]\) . 
                   \(SpinorV[\(\(Momentum[p]\), m\)]\)\)], "Input", 
               CellTags -> "FermionSpinSum"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{FormBox[\("v"\&_\), "TraditionalForm"], "(", 
                     FormBox["p", "TraditionalForm"], ",", "m", ")"}], ".", 
                   RowBox[{"v", "(", FormBox["p", "TraditionalForm"], ",", 
                     "m", ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "FermionSpinSum"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(%//FCI\)//FermionSpinSum\)], "Input", CellTags -> 
                "FermionSpinSum"], Cell[BoxData[FormBox[RowBox[{"tr", "(", 
                   FormBox[RowBox[{RowBox[{FormBox["\"\[Gamma]\"", 
                         "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                         "TraditionalForm"]}], "-", "m"}], 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "FermionSpinSum"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%/.\(DiracTrace \[Rule] TR\)\)]
                , "Input", CellTags -> "FermionSpinSum"], Cell[BoxData[
                \(TraditionalForm\`\(\(-4\)\ m\)\)], "Output", CellTags -> 
                "FermionSpinSum"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t = \(\(Spinor[\(k1, m\)]\) . \(DiracSlash[p]\) . \(GA[5]\)
                      . \(Spinor[\(p1, m\)]\)\)\)], "Input", CellTags -> 
                "FermionSpinSum"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"\[CurlyPhi]", "(", FormBox[
                      \(\(\*TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\), 
                      "TraditionalForm"], ",", "m", ")"}], ".", RowBox[
                    {"(", RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                     ")"}], ".", \(\[Gamma]\^5\), ".", RowBox[{"\[CurlyPhi]", 
                     "(", FormBox[
                      \(\(\*TagBox[StyleBox["\"p\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\), 
                      "TraditionalForm"], ",", "m", ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "FermionSpinSum"]}, 
             Open]], Cell["Notice that SpinorUBar and SpinorU are only input \
functions. Internally they are converted to Spinor objects.", "Text", 
            CellTags -> "FermionSpinSum"], Cell[CellGroupData[{Cell[BoxData[
                \(ct = \(ComplexConjugate[t]\)\)], "Input", CellTags -> 
                "FermionSpinSum"], Cell[BoxData[FormBox[RowBox[{"-", 
                   RowBox[{RowBox[{"\[CurlyPhi]", "(", FormBox[
                        \(\(\*TagBox[StyleBox["\"p\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_1\), 
                        "TraditionalForm"], ",", "m", ")"}], ".", 
                     \(\[Gamma]\^5\), ".", RowBox[{"(", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         FormBox["p", "TraditionalForm"]}], ")"}], ".", 
                     RowBox[{"\[CurlyPhi]", "(", FormBox[
                        \(\(\*TagBox[StyleBox["\"k\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_1\), 
                        "TraditionalForm"], ",", "m", ")"}]}]}], 
                 TraditionalForm]], "Output", CellTags -> "FermionSpinSum"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FermionSpinSum[\(t\ ct\)]\)], "Input", CellTags -> 
                "FermionSpinSum"], Cell[BoxData[FormBox[RowBox[{"-", 
                   RowBox[{"tr", "(", FormBox[RowBox[{RowBox[{"(", RowBox[
                          {"m", "+", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], ")"}], ".", RowBox[
                         {"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], ")"}], ".", \(\[Gamma]\^5\), 
                        ".", RowBox[{"(", RowBox[{"m", "+", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                          FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], ")"}], ".", \(\[Gamma]\^5\)
                        , ".", RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], ")"}]}], "TraditionalForm"], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "FermionSpinSum"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%\ /.\(DiracTrace \[Rule] TR\)\)], "Input", CellTags -> 
                "FermionSpinSum"], Cell[BoxData[FormBox[RowBox[{\(-4\), " ", 
                   RowBox[{"(", RowBox[{RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], "2"], " ", \(m\^2\)}], "+", 
                       RowBox[{RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], "2"]}], "-", RowBox[
                        {"2", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], " ", RowBox[{FormBox["p", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "FermionSpinSum"]}, 
             Open]], Cell[BoxData[\(Clear[\(t,\ ct\)]\)], "Input", 
            CellTags -> "FermionSpinSum"]}, Open]], Cell["FeynAmp", 
         "ObjectName", CellTags -> "FeynAmp"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynAmp"], Cell["FeynAmp[q, amp] is the head of a \
Feynman amplitude, where amp denotes the analytical expression for the \
amplitude and q is the integration variable. FeynAmp[q1, q2, amp] denotes a \
two-loop amplitude.", "Text", CellTags -> "FeynAmp"], Cell["FeynAmp has no \
functional properties and serves just as a head. There are however special \
typesetting rules attached.", "Text", CellTags -> "FeynAmp"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Amplitude", RuleDelayed[ButtonData, "Amplitude"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Amplitude"]], "."}], "Text", 
            CellTags -> "FeynAmp"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynAmp"], Cell["This is a 1-loop gluon self-energy \
amplitude (ignoring factors of (2 \[Pi])).", "Text", CellTags -> "FeynAmp"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FeynAmp[\(q, \(\(GV[\(p, \[Mu], a,\ \(q - p\), \[Alpha], c,
                           \ \(-q\), \[Beta], e\)]\)\ 
                       \(GP[\(\(p - q\),\ \[Alpha], c,\ \[Rho], d\)]\) 
                       \(GV[\(\(-p\), \[Nu], b,\ \(p - q\), \[Rho], d,\ q, 
                           \[Sigma], f\)]\)\ 
                       \(GP[\(q,\ \[Beta], e,\ \[Sigma], f\)]\)\)\)]\)], 
               "Input", CellTags -> "FeynAmp"], Cell[BoxData[FormBox[
                 RowBox[{"\[Integral]", 
                   StyleBox[\(\[DifferentialD]\^D q\), 
                     Rule[ZeroWidthTimes, True]], "(", FormBox[RowBox[
                     {RowBox[{\(\[CapitalPi]\_\(cd\)\%\(\[Alpha]\[Rho]\)\), 
                        "(", FormBox[\(p - q\), "TraditionalForm"], ")"}], 
                      " ", \(\[CapitalPi]\_\(ef\)\%\(\[Beta]\[Sigma]\)(q)\), 
                      " ", RowBox[{SuperscriptBox["V", RowBox[{FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]}]], "(", RowBox[{FormBox[\(-p\), 
                          "TraditionalForm"], \(,\ \), FormBox[\(p - q\), 
                          "TraditionalForm"], \(,\ \), FormBox["q", 
                          "TraditionalForm"]}], ")"}], " ", RowBox[
                       {SuperscriptBox["V", RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Alpha]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Beta]", 
                          "TraditionalForm"], "TraditionalForm"]}]], "(", 
                        RowBox[{FormBox["p", "TraditionalForm"], \(,\ \), 
                          FormBox[\(q - p\), "TraditionalForm"], \(,\ \), 
                          FormBox[\(-q\), "TraditionalForm"]}], ")"}], " ", 
                      SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                      SubscriptBox["f", RowBox[{FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["f", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "FeynAmp"]}, Open]], 
           Cell["This is a generic 2-loop amplitude.", "Text", 
            CellTags -> "FeynAmp"], Cell[CellGroupData[{Cell[BoxData[
                \(FeynAmp[\(q\_1, q\_2, anyexpression\)]\)], "Input", 
               CellTags -> "FeynAmp"], Cell[BoxData[
                \(TraditionalForm\`\(\[Integral] 
                     \(\*StyleBox[\(\[DifferentialD]\^D q\_1\), 
                         Rule[ZeroWidthTimes, True]] \[Integral] 
                       \(\[DifferentialD]\^D q\_2\)\) (anyexpression)\)\)], 
               "Output", CellTags -> "FeynAmp"]}, Open]]}, Open]], 
        Cell["FeynAmpDenominator", "ObjectName", CellTags -> 
          "FeynAmpDenominator"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "FeynAmpDenominator"], Cell["FeynAmpDenominator[ \
PropagatorDenominator[ ... ], PropagatorDenominator[ ... ], ...] is the head \
of the denominators of the propagators, i.e., FeynAmpDenominator[x] is the \
representation of 1/x .", "Text", CellTags -> "FeynAmpDenominator"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FAD", RuleDelayed[ButtonData, "FAD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FAD"]], 
              ", ", 
              ButtonBox["FeynAmpDenominatorSimplify", 
                RuleDelayed[ButtonData, "FeynAmpDenominatorSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynAmpDenominatorSimplify"]], "."}], 
            "Text", CellTags -> "FeynAmpDenominator"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynAmpDenominator"], Cell[CellGroupData[
             {Cell[BoxData[
                \(FeynAmpDenominator[\(PropagatorDenominator[\(p, m\)]\)]\)], 
               "Input", CellTags -> "FeynAmpDenominator"], Cell[BoxData[
                \(TraditionalForm\`\(1\/\(p\^2 - m\^2\)\)\)], "Output", 
               CellTags -> "FeynAmpDenominator"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FeynAmpDenominator[\(\(PropagatorDenominator[\(p, m\)]\), 
                     \(PropagatorDenominator[\(\(p - q\), m\)]\)\)]\)], 
               "Input", CellTags -> "FeynAmpDenominator"], Cell[BoxData[
                \(TraditionalForm\`\(1\/\(
                      \((p\^2 - m\^2)\) . \((\((p - q)\)\^2 - m\^2)\)\)\)\)], 
               "Output", CellTags -> "FeynAmpDenominator"]}, Open]], 
           Cell[BoxData[
             \(\(t = \(FeynAmpDenominator[\(PropagatorDenominator[\(p, m\)]\)
                    ]\)\) ;\)], "Input", CellTags -> "FeynAmpDenominator"], 
           Cell[CellGroupData[{Cell[BoxData[\(StandardForm[\(t//FCI\)]\)], 
               "Input", CellTags -> "FeynAmpDenominator"], Cell[BoxData[
                \(FeynAmpDenominator[\(PropagatorDenominator[
                     \(\(Momentum[\(p, D\)]\), m\)]\)]\)], "Output", 
               CellTags -> "FeynAmpDenominator"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(StandardForm[\(t//FCE\)]\)], 
               "Input", CellTags -> "FeynAmpDenominator"], Cell[BoxData[
                \(FAD[\({p, m}\)]\)], "Output", CellTags -> 
                "FeynAmpDenominator"]}, Open]], Cell[BoxData[
             \(\(Clear[t]\) ;\)], "Input", CellTags -> 
             "FeynAmpDenominator"]}, Open]], 
        Cell["FeynAmpDenominatorCombine", "ObjectName", 
         CellTags -> "FeynAmpDenominatorCombine"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynAmpDenominatorCombine"], Cell["FeynAmpDenominato\
rCombine[expr] expands expr with respect to FeynAmpDenominator and combines \
products of FeynAmpDenominator in expr into one FeynAmpDenominator.", "Text", 
            CellTags -> "FeynAmpDenominatorCombine"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynAmpDenominatorSplit", 
                RuleDelayed[ButtonData, "FeynAmpDenominatorSplit"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynAmpDenominatorSplit"]], "."}], "Text", 
            CellTags -> "FeynAmpDenominatorCombine"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynAmpDenominatorCombine"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t\ =\ \(\(FAD[q]\)\ \(FAD[\(q - p\)]\)\)\)], "Input", 
               CellTags -> "FeynAmpDenominatorCombine"], Cell[BoxData[
                FormBox[RowBox[{FormBox[
                    \(1\/\*InterpretationBox[\(
                          "["\[InvisibleSpace] q\^2 \[InvisibleSpace]"]"\), 
                         SequenceForm["[", Power[q, 2], "]"], 
                         Rule[Editable, False]]\), "TraditionalForm"], " ", 
                   FormBox[
                    \(1\/\*InterpretationBox[\(
                          "["\[InvisibleSpace] \((q - p)\)\^2 
                           \[InvisibleSpace]"]"\), 
                         SequenceForm["[", Power[Plus[Times[-1, p], q], 2], 
                          "]"], Rule[Editable, False]]\), 
                    "TraditionalForm"]}], TraditionalForm]], "Output", 
               CellTags -> "FeynAmpDenominatorCombine"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(\(FeynAmpDenominatorCombine[%]\)//FCE\)//StandardForm\)], 
               "Input", CellTags -> "FeynAmpDenominatorCombine"], 
              Cell[BoxData[\(FAD[\(q, \(\(-p\) + q\)\)]\)], "Output", 
               CellTags -> "FeynAmpDenominatorCombine"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(\(FeynAmpDenominatorSplit[%]\)//FCE\)//StandardForm\)], 
               "Input", CellTags -> "FeynAmpDenominatorCombine"], 
              Cell[BoxData[\(\(FAD[q]\)\ \(FAD[\(\(-p\) + q\)]\)\)], 
               "Output", CellTags -> "FeynAmpDenominatorCombine"]}, Open]]}, 
          Open]], Cell["FeynAmpDenominatorSimplify", "ObjectName", 
         CellTags -> "FeynAmpDenominatorSimplify"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynAmpDenominatorSimplify"], Cell["FeynAmpDenominat\
orSimplify[exp] tries to simplify each PropagatorDenominator in a canonical \
way. FeynAmpDenominatorSimplify[exp, q1] simplifies all FeynAmpDenominator's \
in exp in a canonical way, including some translation of momenta. \
FeynAmpDenominatorSimplify[exp, q1, q2] additionally removes integrals with \
no mass scale.", "Text", CellTags -> "FeynAmpDenominatorSimplify"], 
           Cell["FDS can be used as an alias.", "Text", CellTags -> 
             "FeynAmpDenominatorSimplify"], Cell[CellGroupData[
             {Cell[BoxData["FDS"], "Input", CellTags -> 
                "FeynAmpDenominatorSimplify"], Cell[BoxData[
                \(TraditionalForm\`FeynAmpDenominatorSimplify\)], "Output", 
               CellTags -> "FeynAmpDenominatorSimplify"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["OneLoopSimplify", 
                RuleDelayed[ButtonData, "OneLoopSimplify"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "OneLoopSimplify"]], "."}], "Text", 
            CellTags -> "FeynAmpDenominatorSimplify"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynAmpDenominatorSimplify"], 
           Cell[TextData[
             {"The cornerstone of dimensional regularization is that ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\(\[Integral] 
                       \(d\^n k\ \(\(f(k)\)/k\^\(2m\)\)\)\) =\ \(0\ .\)\)\)]]}\
], "Text", CellTags -> "FeynAmpDenominatorSimplify"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FeynAmpDenominatorSimplify[
                   \(\(\(f[k]\)\ \(FAD[\(k, k\)]\)\), k\)]\)], "Input", 
               CellTags -> "FeynAmpDenominatorSimplify"], Cell[BoxData[
                \(TraditionalForm\`0\)], "Output", CellTags -> 
                "FeynAmpDenominatorSimplify"]}, Open]], 
           Cell[TextData[{"This brings ", Cell[BoxData[
                \(TraditionalForm\`\(1/\(
                      (\((k - p\_1)\)\^2\ \((k - p\_2)\)\^2)\)\)\)]], 
              " into a standard form."}], "Text", CellTags -> 
             "FeynAmpDenominatorSimplify"], Cell[CellGroupData[{Cell[BoxData[
                \(FeynAmpDenominatorSimplify[
                   \(\(FAD[\(\(k - p\_1\), \(k - p\_2\)\)]\), k\)]\)], 
               "Input", CellTags -> "FeynAmpDenominatorSimplify"], 
              Cell[BoxData[FormBox[FractionBox["1", RowBox[{SuperscriptBox[
                     FormBox[
                      TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                        Function[StyleForm[Slot[1], 
                          Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                     "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", \(p\_1\), "+", \(p\_2\)}], 
                       ")"}], "2"]}]], TraditionalForm]], "Output", 
               CellTags -> "FeynAmpDenominatorSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FeynAmpDenominatorSimplify[
                   \(\(FAD[\(k, k, \(k - q\)\)]\), k\)]\)], "Input", 
               CellTags -> "FeynAmpDenominatorSimplify"], Cell[BoxData[
                FormBox[FractionBox["1", RowBox[{SuperscriptBox[FormBox[
                      TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                        Function[StyleForm[Slot[1], 
                          Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                     "2"], ".", SuperscriptBox[FormBox[
                      TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                        Function[StyleForm[Slot[1], 
                          Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                     "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", "q"}], ")"}], "2"]}]], 
                 TraditionalForm]], "Output", CellTags -> 
                "FeynAmpDenominatorSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FeynAmpDenominatorSimplify[
                   \(\(\(f[k]\) \(FAD[\(k, \(k - q\), \(k - q\)\)]\)\), k\)]\
\)], "Input", CellTags -> "FeynAmpDenominatorSimplify"], Cell[BoxData[
                FormBox[FractionBox[RowBox[{"f", "(", RowBox[{"q", "-", 
                      FormBox[
                       TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                         Function[StyleForm[Slot[1], 
                           Rule[FontSlant, "Italic"]]]], 
                       "TraditionalForm"]}], ")"}], RowBox[{SuperscriptBox[
                     FormBox[
                      TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                        Function[StyleForm[Slot[1], 
                          Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                     "2"], ".", SuperscriptBox[FormBox[
                      TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                        Function[StyleForm[Slot[1], 
                          Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                     "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", "q"}], ")"}], "2"]}]], 
                 TraditionalForm]], "Output", CellTags -> 
                "FeynAmpDenominatorSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t = \(FeynAmpDenominatorSimplify[
                     \(\(\(FAD[\(\(k - p\_1\), \(k - p\_2\)\)]\)\ 
                         \(SPD[\(k, k\)]\)\), k\)]\)\)], "Input", CellTags -> 
                "FeynAmpDenominatorSimplify"], Cell[BoxData[FormBox[
                 RowBox[{FractionBox[SuperscriptBox[FormBox[FormBox[
                       TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                         Function[StyleForm[Slot[1], 
                           Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                      "TraditionalForm"], "2"], RowBox[{SuperscriptBox[
                       FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", \(p\_1\), "+", \(p\_2\)}], 
                         ")"}], "2"]}]], "+", FractionBox[RowBox[{"2", " ", 
                      RowBox[{FormBox[FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "TraditionalForm"], 
                        "\[CenterDot]", FormBox[\(p\_2\), 
                         "TraditionalForm"]}]}], RowBox[{SuperscriptBox[
                       FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", \(p\_1\), "+", \(p\_2\)}], 
                         ")"}], "2"]}]], "+", FractionBox[\(p\_2\%2\), 
                    RowBox[{SuperscriptBox[FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", \(p\_1\), "+", \(p\_2\)}], 
                         ")"}], "2"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FeynAmpDenominatorSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(r = \(SPC[\(t, k, \(FDS \[Rule] True\)\)]\)\)], "Input", 
               CellTags -> "FeynAmpDenominatorSimplify"], Cell[BoxData[
                FormBox[RowBox[{FractionBox[\(p\_2\%2\), RowBox[
                     {SuperscriptBox[FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", \(p\_1\), "+", \(p\_2\)}], 
                         ")"}], "2"]}]], "-", FractionBox[RowBox[{"2", " ", 
                      RowBox[{FormBox[FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "TraditionalForm"], 
                        "\[CenterDot]", FormBox[\(p\_2\), 
                         "TraditionalForm"]}]}], RowBox[{SuperscriptBox[
                       FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "+", \(p\_1\), "-", \(p\_2\)}], 
                         ")"}], "2"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FeynAmpDenominatorSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(OneLoopSimplify[\(r, k\)]\)], 
               "Input", CellTags -> "FeynAmpDenominatorSimplify"], 
              Cell[BoxData[FormBox[RowBox[{FractionBox[RowBox[{"2", " ", 
                      RowBox[{FormBox[FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "TraditionalForm"], 
                        "\[CenterDot]", FormBox[\(p\_2\), 
                         "TraditionalForm"]}]}], RowBox[{SuperscriptBox[
                       FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", \(p\_1\), "+", \(p\_2\)}], 
                         ")"}], "2"]}]], "+", FractionBox[\(p\_2\%2\), 
                    RowBox[{SuperscriptBox[FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", \(p\_1\), "+", \(p\_2\)}], 
                         ")"}], "2"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FeynAmpDenominatorSimplify"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FDS[\(\(\(FAD[\(\(k - p1\), \(k - p2\)\)]\) 
                       \(\(SPD[\(k, OPEDelta\)]\)^2\)\), k\)]\)], "Input", 
               CellTags -> "FeynAmpDenominatorSimplify"], Cell[BoxData[
                FormBox[RowBox[{FractionBox[SuperscriptBox[FormBox[RowBox[
                       {FormBox[FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "TraditionalForm"], 
                        "\[CenterDot]", FormBox["\[CapitalDelta]", 
                         "TraditionalForm"]}], "TraditionalForm"], "2"], 
                    RowBox[{SuperscriptBox[FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", 
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), "+", 
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\)}], 
                         ")"}], "2"]}]], "+", FractionBox[RowBox[{"2", " ", 
                      RowBox[{FormBox[FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "TraditionalForm"], 
                        "\[CenterDot]", FormBox["\[CapitalDelta]", 
                         "TraditionalForm"]}], " ", RowBox[{FormBox[
                         "\[CapitalDelta]", "TraditionalForm"], 
                        "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2\), 
                         "TraditionalForm"]}]}], RowBox[{SuperscriptBox[
                       FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", 
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), "+", 
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\)}], 
                         ")"}], "2"]}]], "+", FractionBox[SuperscriptBox[
                     FormBox[RowBox[{FormBox["\[CapitalDelta]", 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2\), 
                         "TraditionalForm"]}], "TraditionalForm"], "2"], 
                    RowBox[{SuperscriptBox[FormBox[
                        TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                          Function[StyleForm[Slot[1], 
                            Rule[FontSlant, "Italic"]]]], "TraditionalForm"], 
                       "2"], ".", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          TagBox[StyleBox["\"k\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]], 
                          "TraditionalForm"], "-", 
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), "+", 
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\)}], 
                         ")"}], "2"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FeynAmpDenominatorSimplify"]}, Open]], 
           Cell[BoxData[\(Clear[\(t, r\)]\)], "Input", CellTags -> 
             "FeynAmpDenominatorSimplify"]}, Open]], 
        Cell["FeynAmpDenominatorSplit", "ObjectName", 
         CellTags -> "FeynAmpDenominatorSplit"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynAmpDenominatorSplit"], Cell["FeynAmpDenominatorS\
plit[expr] splits all FeynAmpDenominator[a,b, ...] in expr into \
FeynAmpDenominator[a]*FeynAmpDenominator[b] ... . \
FeynAmpDenominatorSplit[expr, q1] splits all FeynAmpDenominator in expr into \
a product of two, one containing q1 and other momenta, the second without \
q1.", "Text", CellTags -> "FeynAmpDenominatorSplit"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynAmpDenominatorCombine", 
                RuleDelayed[ButtonData, "FeynAmpDenominatorCombine"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynAmpDenominatorCombine"]], "."}], 
            "Text", CellTags -> "FeynAmpDenominatorSplit"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynAmpDenominatorSplit"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t = \(\(FAD[\(q1, \(q1 - p\), \(q1 - q2\), q2, \(q2 - p\)\)
                       ]\)//FCI\)\)], "Input", CellTags -> 
                "FeynAmpDenominatorSplit"], Cell[BoxData[
                \(TraditionalForm\`\(1\/\(
                      \(\*TagBox[StyleBox["\"q\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_1\%2 . 
                       \((\(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1 - p)\)\^2\
 . \((\(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1 - 
                           \(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2)\)\^2 . 
                       \(\*TagBox[StyleBox["\"q\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_2\%2 . 
                       \((\(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2 - p)\)\^2\
\)\)\)], "Output", CellTags -> "FeynAmpDenominatorSplit"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(t//Head\)], "Input", 
               CellTags -> "FeynAmpDenominatorSplit"], Cell[BoxData[
                \(TraditionalForm\`FeynAmpDenominator\)], "Output", 
               CellTags -> "FeynAmpDenominatorSplit"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(FeynAmpDenominatorSplit[t]\)], 
               "Input", CellTags -> "FeynAmpDenominatorSplit"], Cell[BoxData[
                \(TraditionalForm\`\(1\/\(
                      \(\*TagBox[StyleBox["\"q\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_1\%2\ 
                       \((\(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1 - p)\)\^2\
\ \((\(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1 - 
                           \(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2)\)\^2\ 
                       \(\*TagBox[StyleBox["\"q\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_2\%2\ 
                       \((\(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2 - p)\)\^2\
\)\)\)], "Output", CellTags -> "FeynAmpDenominatorSplit"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(\(%//FCE\)//StandardForm\)], 
               "Input", CellTags -> "FeynAmpDenominatorSplit"], Cell[BoxData[
                \(\(FAD[q1]\)\ \(FAD[\(\(-p\) + q1\)]\)\ \(FAD[\(q1 - q2\)]\)
                   \ \(FAD[q2]\)\ \(FAD[\(\(-p\) + q2\)]\)\)], "Output", 
               CellTags -> "FeynAmpDenominatorSplit"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(\(FeynAmpDenominatorSplit[\(t, q1\)]\)//FCE\)//
                   StandardForm\)], "Input", CellTags -> 
                "FeynAmpDenominatorSplit"], Cell[BoxData[
                \(\(FAD[\(q2, \(\(-p\) + q2\)\)]\)\ 
                   \(FAD[\(q1, \(\(-p\) + q1\), \(q1 - q2\)\)]\)\)], 
               "Output", CellTags -> "FeynAmpDenominatorSplit"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(\(FeynAmpDenominatorCombine[%]\)//FCE\)//StandardForm\)], 
               "Input", CellTags -> "FeynAmpDenominatorSplit"], Cell[BoxData[
                \(FAD[\(q1, q2, \(q1 - q2\), \(\(-p\) + q1\), \(\(-p\) + q2\)
                    \)]\)], "Output", CellTags -> 
                "FeynAmpDenominatorSplit"]}, Open]], Cell[BoxData[\(Clear[t]\)
             ], "Input", CellTags -> "FeynAmpDenominatorSplit"]}, Open]], 
        Cell["FeynAmpList", "ObjectName", CellTags -> "FeynAmpList"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynAmpList"], Cell["FeynAmpList[info][FeynAmp[...], \
FeynAmp[...], ...] is a head of a list of Feynman amplitudes.", "Text", 
            CellTags -> "FeynAmpList"], Cell["FeynAmpList has no functional \
properties and serves just as a head.", "Text", CellTags -> "FeynAmpList"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynAmp", RuleDelayed[ButtonData, "FeynAmp"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FeynAmp"]]\
, "."}], "Text", CellTags -> "FeynAmpList"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["FeynCalc", "ObjectName", CellTags -> "FeynCalc"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynCalc"], 
           Cell["FeynCalc is simply a symbol with a usage definition.", 
            "Text", CellTags -> "FeynCalc"], Cell[CellGroupData[{Cell[BoxData[
                \(? FeynCalc\)], "Input", CellTags -> "FeynCalc"], 
              Cell[BoxData["\"For installation notes visit \
www.feyncalc.org\\n For a list of availabe objects type $FeynCalcStuff, which \
contains a list of all functions and options in StringForm. You can get \
on-line information by ?function, e.g. ?Contract.\\n There are several useful \
functions for short input, type $FCS for a list of short commands. Then type, \
e.g., ?GA.\\n\\n To enable/disable start-up messages, put the line\\n \
$FeynCalcStartupMessages = True;\\n or\\n $FeynCalcStartupMessages = \
False;\\n  into your \\\"init.m\\\" file or into your \\\"FCConfig.m\\\" \
file.\""], "Print", CellTags -> {"FeynCalc", "Info3353009150-9818237"}]}, 
             Open]]}, Open]], Cell["FeynCalcExternal", "ObjectName", 
         CellTags -> "FeynCalcExternal"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "FeynCalcExternal"], Cell["FeynCalcExternal[exp] translates exp \
from the internal FeynCalc representation to a shorthand form.", "Text", 
            CellTags -> "FeynCalcExternal"], Cell[TextData[{"See also: ", 
              " ", 
              ButtonBox["FeynCalcInternal", 
                RuleDelayed[ButtonData, "FeynCalcInternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcInternal"]], "."}], "Text", 
            CellTags -> "FeynCalcExternal"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynCalcExternal"], Cell[CellGroupData[{Cell[BoxData[
                \(FeynCalcExternal[\(DiracGamma[5]\)]\)], "Input", 
               CellTags -> "FeynCalcExternal"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^5\)\)], "Output", CellTags -> 
                "FeynCalcExternal"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(%//StandardForm\)], "Input", CellTags -> 
                "FeynCalcExternal"], Cell[BoxData[\(GA[5]\)], "Output", 
               CellTags -> "FeynCalcExternal"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Input", CellTags -> 
                "FeynCalcExternal"], Cell[BoxData[FormBox[RowBox[
                  {"{", RowBox[{\(\[Gamma]\^\[Mu]\), ",", \(\[Gamma]\^\[Rho]\)
                     , ",", \(\[Gamma] \[CenterDot] p\), ",", FormBox[
                      RowBox[{FormBox["p", "TraditionalForm"], 
                        "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                      "TraditionalForm"], ",", \(g\^\(\[Alpha]\[Beta]\)\), 
                     ",", \(p\^\[Mu]\)}], "}"}], TraditionalForm]], "Output", 
               CellTags -> "FeynCalcExternal"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "FeynCalcExternal"], Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Output", CellTags -> 
                "FeynCalcExternal"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(%//FeynCalcInternal\)], "Input", CellTags -> 
                "FeynCalcExternal"], Cell[BoxData[FormBox[RowBox[
                  {"{", RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     ",", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Rho]", "TraditionalForm"], "TraditionalForm"]], 
                     ",", RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                     ",", RowBox[{FormBox["p", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                     ",", \(g\^\(\[Alpha]\[Beta]\)\), ",", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]]}], 
                   "}"}], TraditionalForm]], "Output", CellTags -> 
                "FeynCalcExternal"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(%//StandardForm\)], "Input", CellTags -> 
                "FeynCalcExternal"], Cell[BoxData[
                \({\(DiracGamma[\(LorentzIndex[\[Mu]]\)]\), 
                    \(DiracGamma[\(\(LorentzIndex[\(\[Rho], D\)]\), D\)]\), 
                    \(DiracGamma[\(Momentum[p]\)]\), 
                    \(Pair[\(\(Momentum[p]\), \(Momentum[q]\)\)]\), 
                    \(Pair[\(\(LorentzIndex[\[Alpha]]\), 
                        \(LorentzIndex[\[Beta]]\)\)]\), 
                    \(Pair[\(\(LorentzIndex[\[Mu]]\), \(Momentum[p]\)\)]\)}\)]\
, "Output", CellTags -> "FeynCalcExternal"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(FeynCalcExternal[%]\)//StandardForm\)], "Input", 
               CellTags -> "FeynCalcExternal"], Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Output", CellTags -> 
                "FeynCalcExternal"]}, Open]]}, Open]], Cell["FeynCalcForm", 
         "ObjectName", CellTags -> "FeynCalcForm"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynCalcForm"], Cell[TextData[{"FeynCalcForm[expr] \
changes the printed output to a an easy-to-read form. It allows a readable \
output also when running a terminal based ", 
              StyleBox["Mathematica", Rule[FontSlant, "Italic"]], " session. \
Whether the result of FeynCalcForm[expr] is displayed or not, depends on the \
setting of $PrePrint. $PrePrint = FeynCalcForm forces displaying everything \
after applying FeynCalcForm. In order to change to the normal (internal) \
Mathematica OutputForm, do: ($PrePrint=.)."}], "Text", CellTags -> 
             "FeynCalcForm"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["FC", RuleDelayed[ButtonData, "FC"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FC"]], 
              ", ", 
              ButtonBox["FeynCalcExternal", 
                RuleDelayed[ButtonData, "FeynCalcExternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcExternal"]], ", ", 
              ButtonBox["FeynCalcInternal", 
                RuleDelayed[ButtonData, "FeynCalcInternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcInternal"]], "."}], "Text", 
            CellTags -> "FeynCalcForm"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynCalcForm"], 
           Cell["This is the normal notebook display:", "Text", 
            CellTags -> "FeynCalcForm"], Cell[CellGroupData[{Cell[BoxData[
                \(SUNTrace[\(\(SUNT[a]\) . \(SUNT[b]\) . \(SUNT[c]\)\)]\)], 
               "Input", CellTags -> "FeynCalcForm"], Cell[BoxData[
                FormBox[RowBox[{"tr", "(", FormBox[RowBox[{SubscriptBox["T", 
                       FormBox[FormBox["a", "TraditionalForm"], 
                        "TraditionalForm"]], ".", SubscriptBox["T", FormBox[
                        FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                      ".", SubscriptBox["T", FormBox[FormBox["c", 
                         "TraditionalForm"], "TraditionalForm"]]}], 
                    "TraditionalForm"], ")"}], TraditionalForm]], "Output", 
               CellTags -> "FeynCalcForm"]}, Open]], Cell["This is the \
shorthand (terminal) display (easy-to-read form):", "Text", 
            CellTags -> "FeynCalcForm"], Cell[BoxData[
             \(\($PrePrint\ =\ FeynCalcForm\) ;\)], "Input", 
            CellTags -> "FeynCalcForm"], Cell[BoxData[
             \(\(SetOptions[\($FrontEnd, 
                    \(Evaluate[\(\((\(Options[
                             \($FrontEnd, "CommonDefaultFormatTypes"\)]\)/.
                           \(\(("Output" \[Rule] _)\) \[Rule] 
                             \(("Output" \[Rule] OutputForm)\)\))\)[\([1]\)]\
\)]\)\)]\) ;\)], "Input", CellTags -> "FeynCalcForm"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(SUNTrace[\(\(SUNT[a]\) . \(SUNT[b]\) . \(SUNT[c]\)\)]\)], 
               "Input", CellTags -> "FeynCalcForm"], Cell[OutputFormData["SUN\
Trace[SUNT[SUNIndex[a]] . SUNT[SUNIndex[b]] . SUNT[SUNIndex[c]]]", 
                "tr[T[a] T[b] T[c]]"], "Output", CellTags -> 
                "FeynCalcForm"]}, Open]], 
           Cell["Reset to normal notebook display:", "Text", 
            CellTags -> "FeynCalcForm"], Cell[BoxData[\(\($PrePrint=.\) ;\)], 
            "Input", CellTags -> "FeynCalcForm"], Cell[BoxData[
             \(\(SetOptions[\($FrontEnd, 
                    \(Evaluate[\(\((\(Options[
                             \($FrontEnd, "CommonDefaultFormatTypes"\)]\)/.
                           \(\(("Output" \[Rule] _)\) \[Rule] 
                             \(("Output" \[Rule] TraditionalForm)\)\))\)[
                        \([1]\)]\)]\)\)]\) ;\)], "Input", 
            CellTags -> "FeynCalcForm"]}, Open]], Cell["FeynCalcInternal", 
         "ObjectName", CellTags -> "FeynCalcInternal"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynCalcInternal"], Cell["FeynCalcInternal[exp] \
translates exp into the internal FeynCalc (abstract data-type) \
representation.", "Text", CellTags -> "FeynCalcInternal"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynCalcExternal", 
                RuleDelayed[ButtonData, "FeynCalcExternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcExternal"]], ", ", 
              ButtonBox["FCI", RuleDelayed[ButtonData, "FCI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCI"]], 
              ", ", 
              ButtonBox["FCE", RuleDelayed[ButtonData, "FCE"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCE"]], 
              "."}], "Text", CellTags -> "FeynCalcInternal"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynCalcInternal"], Cell[CellGroupData[{Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Input", CellTags -> 
                "FeynCalcInternal"], Cell[BoxData[FormBox[RowBox[
                  {"{", RowBox[{\(\[Gamma]\^\[Mu]\), ",", \(\[Gamma]\^\[Rho]\)
                     , ",", \(\[Gamma] \[CenterDot] p\), ",", FormBox[
                      RowBox[{FormBox["p", "TraditionalForm"], 
                        "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                      "TraditionalForm"], ",", \(g\^\(\[Alpha]\[Beta]\)\), 
                     ",", \(p\^\[Mu]\)}], "}"}], TraditionalForm]], "Output", 
               CellTags -> "FeynCalcInternal"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "FeynCalcInternal"], Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Output", CellTags -> 
                "FeynCalcInternal"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(%//FeynCalcInternal\)], "Input", CellTags -> 
                "FeynCalcInternal"], Cell[BoxData[FormBox[RowBox[
                  {"{", RowBox[{SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     ",", SuperscriptBox["\[Gamma]", FormBox[FormBox[
                        "\[Rho]", "TraditionalForm"], "TraditionalForm"]], 
                     ",", RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                     ",", RowBox[{FormBox["p", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                     ",", \(g\^\(\[Alpha]\[Beta]\)\), ",", SuperscriptBox[
                      FormBox["p", "TraditionalForm"], FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]]}], 
                   "}"}], TraditionalForm]], "Output", CellTags -> 
                "FeynCalcInternal"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(%//StandardForm\)], "Input", CellTags -> 
                "FeynCalcInternal"], Cell[BoxData[
                \({\(DiracGamma[\(LorentzIndex[\[Mu]]\)]\), 
                    \(DiracGamma[\(\(LorentzIndex[\(\[Rho], D\)]\), D\)]\), 
                    \(DiracGamma[\(Momentum[p]\)]\), 
                    \(Pair[\(\(Momentum[p]\), \(Momentum[q]\)\)]\), 
                    \(Pair[\(\(LorentzIndex[\[Alpha]]\), 
                        \(LorentzIndex[\[Beta]]\)\)]\), 
                    \(Pair[\(\(LorentzIndex[\[Mu]]\), \(Momentum[p]\)\)]\)}\)]\
, "Output", CellTags -> "FeynCalcInternal"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(FeynCalcExternal[%]\)//StandardForm\)], "Input", 
               CellTags -> "FeynCalcInternal"], Cell[BoxData[
                \({\(GA[\[Mu]]\), \(GAD[\[Rho]]\), \(GS[p]\), 
                    \(SP[\(p, q\)]\), \(MT[\(\[Alpha], \[Beta]\)]\), 
                    \(FV[\(p, \[Mu]\)]\)}\)], "Output", CellTags -> 
                "FeynCalcInternal"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(FCI[\({\(SD[\(a, b\)]\), \(SUND[\(a, b, c\)]\), 
                      \(SUNF[\(a, b, c\)]\), \(FAD[q]\), 
                      \(LC[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\)}\)]\)], 
               "Input", CellTags -> "FeynCalcInternal"], Cell[BoxData[
                FormBox[RowBox[{"{", RowBox[{SubscriptBox["\[Delta]", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]}]], ",", 
                     SubscriptBox["d", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"]}]], ",", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"]}]], ",", \(1\/q\^2\), ",", 
                     SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "}"}], TraditionalForm]], 
               "Output", CellTags -> "FeynCalcInternal"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "FeynCalcInternal"], Cell[BoxData[
                \({\(SUNDelta[\(\(SUNIndex[a]\), \(SUNIndex[b]\)\)]\), 
                    \(SUND[\(\(SUNIndex[a]\), \(SUNIndex[b]\), 
                        \(SUNIndex[c]\)\)]\), 
                    \(SUNF[\(\(SUNIndex[a]\), \(SUNIndex[b]\), 
                        \(SUNIndex[c]\)\)]\), 
                    \(FeynAmpDenominator[
                      \(PropagatorDenominator[\(\(Momentum[\(q, D\)]\), 0\)]
                       \)]\), \(Eps[\(\(LorentzIndex[\[Mu]]\), 
                        \(LorentzIndex[\[Nu]]\), \(LorentzIndex[\[Rho]]\), 
                        \(LorentzIndex[\[Sigma]]\)\)]\)}\)], "Output", 
               CellTags -> "FeynCalcInternal"]}, Open]]}, Open]], 
        Cell["FeynCalc2FORM", "ObjectName", CellTags -> "FeynCalc2FORM"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynCalc2FORM"], Cell["FeynCalc2FORM[expr] displays \
expr in FORM syntax. FeynCalc2FORM[file, x] writes x in FORM syntax to a \
file. FeynCalc2FORM[file, x==y] writes x=y to a file in FORM syntax.", 
            "Text", CellTags -> "FeynCalc2FORM"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FORM2FeynCalc", 
                RuleDelayed[ButtonData, "FORM2FeynCalc"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FORM2FeynCalc"]], "."}], "Text", 
            CellTags -> "FeynCalc2FORM"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[FeynCalc2FORM]\)], "Input", CellTags -> 
                "FeynCalc2FORM"], Cell[BoxData[
                \(TraditionalForm\`\({\(EpsDiscard \[Rule] False\), 
                      \(FORMEpilog \[Rule] ""\), 
                      \(FORMProlog \[Rule] "write statistics;"\), 
                      \(Replace \[Rule] \(
                         {\("\\[Alpha]" \[Rule] "al"\), 
                           \("\\[Beta]" \[Rule] "be"\), 
                           \("\\[Gamma]" \[Rule] "ga"\), 
                           \("\\[Delta]" \[Rule] "de"\), 
                           \("\\[Mu]" \[Rule] "mu"\), 
                           \("\\[Nu]" \[Rule] "nu"\), 
                           \("\\[Rho]" \[Rule] "ro"\), 
                           \("\\[Sigma]" \[Rule] "si"\)}\)\), 
                      \(TraceDimension \[Rule] 4\)}\)\)], "Output", 
               CellTags -> "FeynCalc2FORM"]}, Open]]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynCalc2FORM"], Cell[CellGroupData[{Cell[BoxData[
                \(\(MT[\(\[Mu], \[Nu]\)]\) \(FV[\(p, \[Rho]\)]\)\ 
                   \(\(y^2\)/d\)\)], "Input", CellTags -> "FeynCalc2FORM"], 
              Cell[BoxData[
                \(TraditionalForm\`\(\(y\^2\ p\^\[Rho]\ g\^\(\[Mu]\[Nu]\)\)\/
                     d\)\)], "Output", CellTags -> "FeynCalc2FORM"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(\(FeynCalc2FORM[%]\) ;\)], 
               "Input", CellTags -> "FeynCalc2FORM"], 
              Cell["(y^2*d_(mu,nu)*p(ro))/d", "Print", CellTags -> 
                "FeynCalc2FORM"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\ \(LC[\(\[Alpha], \[Beta], \[Delta], \[Rho]\)]\)\)], 
               "Input", CellTags -> "FeynCalc2FORM"], Cell[BoxData[
                \(TraditionalForm\`\(\[Epsilon]\^
                     \(\[Alpha]\[Beta]\[Delta]\[Rho]\)\)\)], "Output", 
               CellTags -> "FeynCalc2FORM"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(\(FeynCalc2FORM[%]\) ;\)], 
               "Input", CellTags -> "FeynCalc2FORM"], 
              Cell["(-i_)*e_(al,be,de,ro)", "Print", CellTags -> 
                "FeynCalc2FORM"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(DiracTrace[\(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\)]\)], 
               "Input", CellTags -> "FeynCalc2FORM"], Cell[BoxData[
                FormBox[RowBox[{"tr", "(", FormBox[
                    \(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . \[Gamma]\^\[Rho] . 
                       \[Gamma]\^\[Sigma]\), "TraditionalForm"], ")"}], 
                 TraditionalForm]], "Output", CellTags -> "FeynCalc2FORM"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(FeynCalc2FORM[%]\) ;\)], "Input", CellTags -> 
                "FeynCalc2FORM"], Cell["g_(0,mu)*g_(0,nu)*g_(0,ro)*g_(0,si)", 
               "Print", CellTags -> "FeynCalc2FORM"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(DiracTrace[\(GA[\(\[Mu], \[Nu]\)]\)]\) 
                   \(DiracTrace[\(GA[\(\[Mu], \[Rho]\)]\)]\)\)], "Input", 
               CellTags -> "FeynCalc2FORM"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{"tr", "(", FormBox[
                      \(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu]\), 
                      "TraditionalForm"], ")"}], " ", RowBox[{"tr", "(", 
                     FormBox[\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Rho]\), 
                      "TraditionalForm"], ")"}]}], TraditionalForm]], 
               "Output", CellTags -> "FeynCalc2FORM"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(\(FeynCalc2FORM[%]\) ;\)], 
               "Input", CellTags -> "FeynCalc2FORM"], 
              Cell["g_(0,mu)*g_(0,nu)*g_(1,mu)*g_(1,ro)", "Print", 
               CellTags -> "FeynCalc2FORM"]}, Open]], Cell[BoxData[
             \(\(FeynCalc2FORM[\("fc2ftest.f", 
                    \(\(MT[\(\[Mu], \[Nu]\)]\) \(FV[\(p, \[Mu]\)]\)\)\)]\) ;\
\)], "Input", CellTags -> "FeynCalc2FORM"], Cell[CellGroupData[{Cell[BoxData[
                \(ReadList[\(\(\(If[\(\($OperatingSystem === "MacOS"
                            \), ":", ""\)]\) <> "fc2ftest.f"\), String\)]\)], 
               "Input", CellTags -> "FeynCalc2FORM"], Cell[BoxData[
                \(TraditionalForm\`\({"d_(mu,nu)*p(mu)"}\)\)], "Output", 
               CellTags -> "FeynCalc2FORM"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t = \(TR[\(\(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\) . 
                       \(GS[\(p, q\)]\)\)]\)\)], "Input", CellTags -> 
                "FeynCalc2FORM"], Cell[BoxData[FormBox[RowBox[{"4", " ", 
                   RowBox[{"(", RowBox[{RowBox[{SuperscriptBox[FormBox["q", 
                          "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                         SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(\[Rho]\[Sigma]\)\)}
                         ], "-", RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                         SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(\[Rho]\[Sigma]\)\)}
                         ], "+", RowBox[{\(g\^\(\[Mu]\[Nu]\)\), " ", RowBox[
                          {FormBox["p", "TraditionalForm"], "\[CenterDot]", 
                          FormBox["q", "TraditionalForm"]}], " ", 
                         \(g\^\(\[Rho]\[Sigma]\)\)}], "-", RowBox[
                        {SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(\[Nu]\[Sigma]\)\), 
                         " ", SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{
                         \(g\^\(\[Mu]\[Sigma]\)\), " ", SuperscriptBox[
                          FormBox["q", "TraditionalForm"], FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                         " ", SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{SuperscriptBox[
                          FormBox["p", "TraditionalForm"], FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                         " ", \(g\^\(\[Nu]\[Sigma]\)\), " ", SuperscriptBox[
                          FormBox["q", "TraditionalForm"], FormBox[FormBox[
                          "\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", RowBox[{
                         \(g\^\(\[Mu]\[Sigma]\)\), " ", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                         " ", SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{SuperscriptBox[
                          FormBox["q", "TraditionalForm"], FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                         " ", \(g\^\(\[Nu]\[Rho]\)\), " ", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", RowBox[{
                         \(g\^\(\[Mu]\[Rho]\)\), " ", SuperscriptBox[FormBox[
                          "q", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                         SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{
                         \(g\^\(\[Mu]\[Nu]\)\), " ", SuperscriptBox[FormBox[
                          "q", "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                         SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", RowBox[{SuperscriptBox[
                          FormBox["p", "TraditionalForm"], FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                         " ", \(g\^\(\[Nu]\[Rho]\)\), " ", SuperscriptBox[
                          FormBox["q", "TraditionalForm"], FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{
                         \(g\^\(\[Mu]\[Rho]\)\), " ", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                         SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", RowBox[{
                         \(g\^\(\[Mu]\[Nu]\)\), " ", SuperscriptBox[FormBox[
                          "p", "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                         SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{
                         \(g\^\(\[Mu]\[Sigma]\)\), " ", \(g\^\(\[Nu]\[Rho]\)\)
                         , " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}]}], "-", RowBox[{
                         \(g\^\(\[Mu]\[Rho]\)\), " ", \(g\^\(\[Nu]\[Sigma]\)\)
                         , " ", RowBox[{FormBox["p", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}]}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "FeynCalc2FORM"]}, 
             Open]], Cell[BoxData[
             \(\(FeynCalc2FORM[\("fc2ftest.f", \(L\ == t\)\)]\) ;\)], 
            "Input", CellTags -> "FeynCalc2FORM"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(TableForm[\(ReadList[\(
                      \(\(If[\(\($OperatingSystem === "MacOS"\), ":", ""\)]\)
                          <> "fc2ftest.f"\), String\)]\)]\)], "Input", 
               CellTags -> "FeynCalc2FORM"], Cell[BoxData[
                \(TraditionalForm\`\(\*InterpretationBox[GridBox[
                       {{"\"Indices \
\\\\[Mu],\\\\[Nu],\\\\[Rho],\\\\[Sigma];\""}, 
                        {"\"Vectors p,q;\""}, {"\"\""}, 
                        {"\"write statistics;\""}, {"\"\""}, 
                        {"\"Local L = ( \""}, 
                        {"\"4*(d_(mu,si)*d_(nu,ro)*q.p-d_(mu,ro)*d_(nu,si\
)*q.p+d_(mu,\
nu)*d_(ro,si)*q.p+\""}, 
                        {"\"d_(ro,si)*p(nu)*q(mu)-d_(nu,si)*p(ro)*q(mu)+d\
_(nu,ro)*p(s\
i)*q(mu)-\""}, 
                        {"\"d_(ro,si)*p(mu)*q(nu)+d_(mu,si)*p(ro)*q(nu)-d\
_(mu,ro)*p(s\
i)*q(nu)+\""}, 
                        {"\"d_(nu,si)*p(mu)*q(ro)-d_(mu,si)*p(nu)*q(ro)+d\
_(mu,nu)*p(s\
i)*q(ro)-\""}, 
                        {"\"d_(nu,ro)*p(mu)*q(si)+d_(mu,ro)*p(nu)*q(si)-d\
_(mu,nu)*p(r\
o)*q(si)) ); \""}, {"\"   \""}, 
                        {"\"Print; \""}, {"\".end\""}}, RowSpacings -> 1., 
                       ColumnSpacings -> 3., RowAlignments -> Baseline, 
                       ColumnAlignments -> {Left}], 
                      TableForm[List["Indices \
\\[Mu],\\[Nu],\\[Rho],\\[Sigma];", "Vectors p,q;", "", 
                        "write statistics;", "", "Local L = ( ", 
                        "4*(d_(mu,si)*d_(nu,ro)*q.p-d_(mu,ro)*d_(nu,si)*q.p+\
d_(mu,nu)*d_(ro,si)*q.p+", 
                        "d_(ro,si)*p(nu)*q(mu)-d_(nu,si)*p(ro)*q(mu)+d_(nu,r\
o)*p(si)*q(mu)-", "d_(ro,si)*p(mu)*q(nu)+d_(mu,si)*p(ro)*q(n\
u)-d_(mu,ro)*p(si)*q(nu)+", 
                        "d_(nu,si)*p(mu)*q(ro)-d_(mu,si)*p(nu)*q(ro)+d_(mu,n\
u)*p(si)*q(ro)-", "d_(nu,ro)*p(mu)*q(si)+d_(mu,ro)*p(nu)*q(s\
i)-d_(mu,nu)*p(ro)*q(si)) ); ", "   ", "Print; ", ".end"]]]\)
                \)], "Output", CellTags -> "FeynCalc2FORM"]}, Open]], 
           Cell[BoxData[
             \(\(If[\(\(\(FileNames["fc2ftest.f"]\) =!= \({}\)\), 
                    \(DeleteFile["fc2ftest.f"]\)\)]\) ;\)], "Input", 
            CellTags -> "FeynCalc2FORM"], Cell[BoxData[\(\(Clear[t]\) ;\)], 
            "Input", CellTags -> "FeynCalc2FORM"]}, Open]], 
        Cell["FeynCalcToLaTeX", "ObjectName", CellTags -> "FeynCalcToLaTeX"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynCalcToLaTeX"], Cell["FeynCalcToLaTeX[expr] \
generates LaTeX with line-breaking  for expr. \nFeynCalcToLaTeX[expr, 500] \
generates LaTeX for expr where 500 is the Window width  setting for the \
Mathematica frontend. Increasing its value will generate less line breaks.", 
            "Text", CellTags -> "FeynCalcToLaTeX"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(GluonPropagator[\(p, 1, 2\)]\)//Explicit\)], "Input"], 
              Cell[BoxData[FormBox[RowBox[{"-", FractionBox[RowBox[
                     {"\[ImaginaryI]", " ", \(g\^\(li1li2\)\), " ", 
                      SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox["ci1", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["ci2", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], \(p\^2\)]}], 
                 TraditionalForm]], "Output"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(FeynCalcToLaTeX[%]\)], 
               "Input"], Cell[BoxData[
                \(TraditionalForm\`"%% AMS-LaTeX Created by Wolfram \
Mathematica \
5.2\\documentclass{article}\n\\usepackage{amsmath, amssymb, \
graphics}\\newcommand{\\mathsym}[1]{{}}\n\\newcommand{\\unic\
ode}{{}}\\begin{document}\\noindent\\(-\\frac{i \
g^{\\text{li1}\\text{li2}} \\delta \
_{\\text{ci1}\\text{ci2}}}{p^2}\\)"\)], "Output"]}, Open]]}, Open]], 
        Cell["FeynmanParameterNames", "ObjectName", CellTags -> 
          "FeynmanParameterNames"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "FeynmanParameterNames"], Cell["FeynmanParameterNames is an \
option for FeynmanParametrize and other functions.", "Text", 
            CellTags -> "FeynmanParameterNames"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynmanParametrize", 
                RuleDelayed[ButtonData, "FeynmanParametrize"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynmanParametrize"]], "."}], "Text", 
            CellTags -> "FeynmanParameterNames"], Cell[BoxData[""], 
            "Input"]}, Open]], Cell["FeynmanParametrize ***unfinished***", 
         "ObjectName", CellTags -> "FeynmanParametrize"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynmanParametrize"], Cell["FeynmanParametrize[exp,k\
] introduces feynman parameters for all one-loop integrals in exp (k = \
integration momentum).", "Text", CellTags -> "FeynmanParametrize"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[FeynmanParametrize]\)], 
               "Input", CellTags -> "FeynmanParametrize"], Cell[BoxData[
                \(TraditionalForm\`\({FeynmanParameterNames \[Rule] 
                      \({x, y, z}\)}\)\)], "Output", CellTags -> 
                "FeynmanParametrize"]}, Open]]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynmanParametrize"], Cell[BoxData[""], "Input", 
            CellTags -> "FeynmanParametrize"]}, Open]], 
        Cell["FeynRule", "ObjectName", CellTags -> "FeynRule"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FeynRule"], Cell["FeynRule[lag, {fields}] derives \
the Feynman rule corresponding to the field configuration fields of the \
lagrangian lag.", "Text", CellTags -> "FeynRule"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[FeynRule]\)], "Input", 
               CellTags -> "FeynRule"], Cell[BoxData[
                \(TraditionalForm\`\({\(Anti5 \[Rule] \(-\[Infinity]\)\), 
                      \(Contract \[Rule] False\), \(Factor1 \[Rule] False\), 
                      \(FinalSubstitutions \[Rule] \({}\)\), 
                      \(PartialD \[Rule] RightPartialD\), 
                      \(Schouten \[Rule] False\), 
                      \(ZeroMomentumInsertion \[Rule] True\), 
                      \(InitialFunction \[Rule] PhiToFC\)}\)\)], "Output", 
               CellTags -> "FeynRule"]}, Open]], 
           Cell["FeynRule does not calculate propagator Feynman rules.", 
            "Text", CellTags -> "FeynRule"], Cell["The option \
ZeroMomentumInsertion can be used for twist-2 and higher twist operators.", 
            "Text", CellTags -> "FeynRule"], Cell[TextData[{"See also: ", 
              " ", 
              ButtonBox["Lagrangian", RuleDelayed[ButtonData, "Lagrangian"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Lagrangian"]], "."}], "Text", 
            CellTags -> "FeynRule"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FeynRule"], Cell[CellGroupData[{Cell[BoxData[
                \(gou = \(Lagrangian["ogu"]\)\)], "Input", CellTags -> 
                "FeynRule"], Cell[BoxData[FormBox[RowBox[{\(1\/2\), " ", 
                   \(\[ImaginaryI]\^\(m - 1\)\), " ", RowBox[
                    {SubsuperscriptBox["F", RowBox[{"\[Alpha]", FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]}], "a"], ".", 
                     SuperscriptBox[RowBox[{"(", SubsuperscriptBox["D", 
                         FormBox["\[CapitalDelta]", "TraditionalForm"], \(ab\)
                         ], ")"}], \(m - 2\)], ".", SubsuperscriptBox["F", 
                      RowBox[{"\[Alpha]", FormBox["\[CapitalDelta]", 
                         "TraditionalForm"]}], "b"]}]}], TraditionalForm]], 
               "Output", CellTags -> "FeynRule"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(gop = \(Lagrangian["ogp"]\)\)], 
               "Input", CellTags -> "FeynRule"], Cell[BoxData[FormBox[RowBox[{
                   \(1\/2\), " ", \(\[ImaginaryI]\^m\), " ", RowBox[
                    {SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                          "\[Alpha]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Beta]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Gamma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]}]], ".", 
                     \(F\_\(\[Beta]\[Gamma]\)\%a\), ".", SuperscriptBox[
                      RowBox[{"(", SubsuperscriptBox["D", FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], \(ab\)], 
                        ")"}], \(m - 2\)], ".", SubsuperscriptBox["F", 
                      RowBox[{"\[Alpha]", FormBox["\[CapitalDelta]", 
                         "TraditionalForm"]}], "b"]}]}], TraditionalForm]], 
               "Output", CellTags -> "FeynRule"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(Explicit[gop]\)], "Input", 
               CellTags -> "FeynRule"], Cell[BoxData[FormBox[RowBox[{\(1\/2\)
                   , " ", \(\[ImaginaryI]\^m\), " ", RowBox[{SuperscriptBox[
                      "\[Epsilon]", RowBox[{FormBox[FormBox["\[Alpha]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Beta]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Gamma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         "\[CapitalDelta]", "TraditionalForm"]}]], ".", 
                     RowBox[{"(", RowBox[{RowBox[{SubscriptBox["\[PartialD]", 
                          FormBox[FormBox["\[Beta]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox[FormBox["A", 
                          "TraditionalForm"], FormBox[FormBox["\[Gamma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Gamma]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                          SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                          FormBox[FormBox["\[Beta]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], "+", 
                         RowBox[{\(g\_s\), " ", RowBox[{SubsuperscriptBox[
                          FormBox["A", "TraditionalForm"], FormBox[FormBox[
                          "\[Beta]", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["b2", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SubsuperscriptBox[FormBox[
                          "A", "TraditionalForm"], FormBox[FormBox[
                          "\[Gamma]", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["c17", "TraditionalForm"], 
                          "TraditionalForm"]]}], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b2", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["c17", "TraditionalForm"], 
                          "TraditionalForm"]}]]}]}], ")"}], ".", 
                     SuperscriptBox[RowBox[{"(", SubsuperscriptBox["D", 
                         FormBox["\[CapitalDelta]", "TraditionalForm"], \(ab\)
                         ], ")"}], \(m - 2\)], ".", RowBox[{"(", RowBox[
                        {RowBox[{"QuantumField", "(", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Alpha]", 
                          "TraditionalForm"], "TraditionalForm"]], ",", "A", 
                          ",", "\[CapitalDelta]", ",", FormBox["b", 
                          "TraditionalForm"]}], ")"}], "-", RowBox[
                          {SubscriptBox["\[PartialD]", FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]], 
                          SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                          FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], "+", 
                         RowBox[{\(g\_s\), " ", RowBox[{SubsuperscriptBox[
                          FormBox["A", "TraditionalForm"], FormBox[FormBox[
                          "\[Alpha]", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["b3", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SubsuperscriptBox[FormBox[
                          "A", "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox["c18", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          SubscriptBox["f", RowBox[{FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["b3", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["c18", 
                          "TraditionalForm"], "TraditionalForm"]}]]}]}], 
                       ")"}]}]}], TraditionalForm]], "Output", CellTags -> 
                "FeynRule"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Cases2[\(%, QuantumField\)]\)], "Input", CellTags -> 
                "FeynRule"], Cell[BoxData[FormBox[RowBox[{"{", RowBox[
                    {SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Alpha]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b3", 
                        "TraditionalForm"], "TraditionalForm"]], ",", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Beta]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b2", 
                        "TraditionalForm"], "TraditionalForm"]], ",", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Gamma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c17", 
                        "TraditionalForm"], "TraditionalForm"]], ",", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox["\[CapitalDelta]", "TraditionalForm"], 
                      FormBox[FormBox["c18", "TraditionalForm"], 
                       "TraditionalForm"]], ",", RowBox[{"QuantumField", "(", 
                       RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Alpha]", "TraditionalForm"], 
                          "TraditionalForm"]], ",", "A", ",", 
                         "\[CapitalDelta]", ",", FormBox["b", 
                          "TraditionalForm"]}], ")"}], ",", RowBox[
                      {SubscriptBox["\[PartialD]", FormBox[FormBox["\[Beta]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                        FormBox[FormBox["\[Gamma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], ",", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Gamma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox[FormBox["A", 
                         "TraditionalForm"], FormBox[FormBox["\[Beta]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"]]}], ",", RowBox[{SubscriptBox[
                        "\[PartialD]", FormBox["\[CapitalDelta]", 
                         "TraditionalForm"]], SubsuperscriptBox[FormBox["A", 
                         "TraditionalForm"], FormBox[FormBox["\[Alpha]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]]}]}], "}"}], TraditionalForm]], 
               "Output", CellTags -> "FeynRule"]}, Open]], 
           Cell["2-gluon Feynman rules (unpolarized)", "Text", 
            CellTags -> "FeynRule"], Cell[CellGroupData[{Cell[BoxData[
                \(fi = \({\(\(QuantumField[
                          \(GaugeField, \({\[Mu]}\), \({a}\)\)]\)[p]\), 
                      \(\(QuantumField[\(GaugeField, \({\[Nu]}\), \({b}\)\)]
                         \)[q]\)}\)\)], "Input", CellTags -> "FeynRule"], 
              Cell[BoxData[FormBox[RowBox[{"{", RowBox[{SubsuperscriptBox[
                      FormBox["A", "TraditionalForm"], FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"]], ",", SubsuperscriptBox[FormBox[
                       "A", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], 
                       "TraditionalForm"]]}], "}"}], TraditionalForm]], 
               "Output", CellTags -> "FeynRule"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(f2u = \(FullSimplify/@\(
                      Factor2[\(FeynRule[
                         \(gou, fi, \(ZeroMomentumInsertion \[Rule] False\)\)
                         ]\)]\)\)\)], "Input", CellTags -> "FeynRule"], 
              Cell[BoxData[FormBox[FractionBox[RowBox[{RowBox[{"(", 
                      RowBox[{RowBox[{SuperscriptBox[FormBox[RowBox[
                          {FormBox["\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                          "TraditionalForm"], "2"], " ", SuperscriptBox[
                          RowBox[{"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], ")"}], "m"]}], "+", RowBox[
                         {SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                          ")"}], "m"], " ", SuperscriptBox[FormBox[RowBox[
                          {FormBox["\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                          "TraditionalForm"], "2"]}]}], ")"}], " ", 
                    RowBox[{"(", RowBox[{RowBox[{SuperscriptBox[FormBox["q", 
                          "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                          SuperscriptBox[FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                          RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}]}], "-", RowBox[{
                          \(g\^\(\[Mu]\[Nu]\)\), " ", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                          " ", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}]}], "+", RowBox[{SuperscriptBox[
                          FormBox["\[CapitalDelta]", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", RowBox[{"(", RowBox[
                          {RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], " ", 
                          RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}]}], "-", RowBox[{SuperscriptBox[
                          FormBox["\[CapitalDelta]", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", RowBox[{FormBox["p", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}]}]}], ")"}]}]}], ")"}], " ", 
                    SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox["a", 
                         "TraditionalForm"], "TraditionalForm"], FormBox[
                        FormBox["b", "TraditionalForm"], 
                        "TraditionalForm"]}]]}], RowBox[{"2", " ", 
                    SuperscriptBox[FormBox[RowBox[{FormBox["\[CapitalDelta]", 
                         "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                         "TraditionalForm"]}], "TraditionalForm"], "2"], " ", 
                    SuperscriptBox[FormBox[RowBox[{FormBox["\[CapitalDelta]", 
                         "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                         "TraditionalForm"]}], "TraditionalForm"], "2"]}]], 
                 TraditionalForm]], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell["2-gluon Feynman rules (polarized)", "Text", 
            CellTags -> "FeynRule"], Cell[CellGroupData[{Cell[BoxData[
                \(fi = \({\(\(QuantumField[
                          \(GaugeField, \({\[Mu]}\), \({a}\)\)]\)[p]\), 
                      \(\(QuantumField[\(GaugeField, \({\[Nu]}\), \({b}\)\)]
                         \)[q]\)}\)\)], "Input", CellTags -> "FeynRule"], 
              Cell[BoxData[FormBox[RowBox[{"{", RowBox[{SubsuperscriptBox[
                      FormBox["A", "TraditionalForm"], FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"]], ",", SubsuperscriptBox[FormBox[
                       "A", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], 
                       "TraditionalForm"]]}], "}"}], TraditionalForm]], 
               "Output", CellTags -> "FeynRule"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(f2p = \(FullSimplify/@\(
                      Factor2[\(FeynRule[
                         \(gop, fi, \(ZeroMomentumInsertion \[Rule] False\)\)
                         ]\)]\)\)\)], "Input", CellTags -> "FeynRule"], 
              Cell[BoxData[FormBox[RowBox[{"-", FractionBox[RowBox[
                     {"\[ImaginaryI]", " ", RowBox[{"(", RowBox[{RowBox[
                          {SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                          ")"}], "m"], " ", RowBox[{"(", RowBox[{RowBox[
                          {SuperscriptBox["\[Epsilon]", RowBox[{FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox["p", 
                          "TraditionalForm"], FormBox["q", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"]}]], " ", SuperscriptBox[FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{SuperscriptBox[
                          "\[Epsilon]", RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox["q", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"]}]], " ", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}]}]}], ")"}], " ", 
                          SuperscriptBox[FormBox[RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                          "TraditionalForm"], "2"]}], "-", RowBox[
                          {SuperscriptBox[FormBox[RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                          "TraditionalForm"], "2"], " ", SuperscriptBox[
                          RowBox[{"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], "m"], " ", RowBox[
                          {"(", RowBox[{RowBox[{SuperscriptBox["\[Epsilon]", 
                          RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          "p", "TraditionalForm"], FormBox["q", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"]}]], " ", SuperscriptBox[FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{SuperscriptBox[
                          "\[Epsilon]", RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox["p", 
                          "TraditionalForm"], FormBox["\[CapitalDelta]", 
                          "TraditionalForm"]}]], " ", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}]}]}], ")"}]}]}], ")"}], " ", 
                      SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], RowBox[{SuperscriptBox[
                       FormBox[RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], "TraditionalForm"], "2"], 
                      " ", SuperscriptBox[FormBox[RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                        "TraditionalForm"], "2"]}]]}], TraditionalForm]], 
               "Output", CellTags -> "FeynRule"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Factor2[\(Calc[\(f2p/.\(p \[Rule] \(-q\)\)\)]\)]\)], 
               "Input", CellTags -> "FeynRule"], Cell[BoxData[FormBox[RowBox[{
                   \(-\[ImaginaryI]\), " ", \((1 - \((\(-1\))\)\^m)\), " ", 
                   SuperscriptBox["\[Epsilon]", RowBox[{FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox["q", "TraditionalForm"], 
                      FormBox["\[CapitalDelta]", "TraditionalForm"]}]], " ", 
                   SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                         "\[CapitalDelta]", "TraditionalForm"], 
                        "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                      ")"}], \(m - 1\)], " ", SubscriptBox["\[Delta]", 
                    RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"]}]]}], 
                 TraditionalForm]], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell["Compare with the Feynman rule tabulated in \
Twist2GluonOperator.", "Text", CellTags -> "FeynRule"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(Twist2GluonOperator[\(q, \({\[Mu], a}\), \({\[Nu], b}\), 
                     \(Polarization \[Rule] 1\), \(Explicit \[Rule] True\)\)]
                \)], "Input", CellTags -> "FeynRule"], Cell[BoxData[
                FormBox[RowBox[{"\[ImaginaryI]", " ", SuperscriptBox[
                    "\[Epsilon]", RowBox[{FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox["\[CapitalDelta]", 
                       "TraditionalForm"], FormBox["q", 
                       "TraditionalForm"]}]], " ", RowBox[{"(", RowBox[
                      {"1", "-", FormBox[\(\((\(-1\))\)\^m\), 
                        "TraditionalForm"]}], ")"}], " ", FormBox[
                    SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                         "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                       ")"}], \(m - 1\)], "TraditionalForm"], " ", 
                   SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FeynRule"]}, Open]], 
           Cell["quark-quark Feynman rule (unpolarized)", "Text", 
            CellTags -> "FeynRule"], Cell[CellGroupData[{Cell[BoxData[
                \(qo = \(Lagrangian["oqu"]\)\)], "Input", CellTags -> 
                "FeynRule"], Cell[BoxData[FormBox[RowBox[{\(\[ImaginaryI]\^m\)
                   , " ", RowBox[{FormBox[\(\[Psi]\&_\), "TraditionalForm"], 
                     ".", RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]}], ")"}], 
                     ".", SuperscriptBox[SubscriptBox["D", FormBox[
                        "\[CapitalDelta]", "TraditionalForm"]], \(m - 1\)], 
                     ".", FormBox["\[Psi]", "TraditionalForm"]}]}], 
                 TraditionalForm]], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell[
            "quark-quark -gluon-gluon Feynman rule (unpolarized)", "Text", 
            CellTags -> "FeynRule"], Cell[CellGroupData[{Cell[BoxData[
                \(qo = \(Lagrangian["oqu"]\)\)], "Input", CellTags -> 
                "FeynRule"], Cell[BoxData[FormBox[RowBox[{\(\[ImaginaryI]\^m\)
                   , " ", RowBox[{FormBox[\(\[Psi]\&_\), "TraditionalForm"], 
                     ".", RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]}], ")"}], 
                     ".", SuperscriptBox[SubscriptBox["D", FormBox[
                        "\[CapitalDelta]", "TraditionalForm"]], \(m - 1\)], 
                     ".", FormBox["\[Psi]", "TraditionalForm"]}]}], 
                 TraditionalForm]], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(qggf = \({\(\(QuantumField[QuarkField]\)[p]\), 
                      \(\(QuantumField[AntiQuarkField]\)[q]\), 
                      \(\(QuantumField[\(GaugeField, \({\[Mu]}\), \({a}\)\)]
                         \)[r]\), \(\(QuantumField[
                          \(GaugeField, \({\[Nu]}\), \({b}\)\)]\)[s]\)}\)\)], 
               "Input", CellTags -> "FeynRule"], Cell[BoxData[FormBox[
                 RowBox[{"{", RowBox[{FormBox["\[Psi]", "TraditionalForm"], 
                     ",", FormBox[\(\[Psi]\&_\), "TraditionalForm"], ",", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], ",", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"]]}], "}"}], 
                 TraditionalForm]], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(n4 = \(FeynRule[\(qo, qggf, 
                       \(ZeroMomentumInsertion \[Rule] True\), 
                       \(InitialFunction \[Rule] Identity\)\)]\)\)], "Input", 
               CellTags -> "FeynRule"], Cell[BoxData[FormBox[RowBox[{RowBox[{
                     \(g\_s\%2\), " ", RowBox[{SubscriptBox["T", FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubscriptBox["T", FormBox[
                         FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{"(", RowBox[
                          {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["\[CapitalDelta]", 
                          "TraditionalForm"]}], ")"}]}], " ", RowBox[
                      {"(", RowBox[{FormBox[
                          TagBox[\(\[Sum]\+\(j = 0\)\%\(m - 3\) ""\), 
                            HoldForm], "TraditionalForm"], FormBox[
                          \(""\ \((j + 1)\)\), "TraditionalForm"], FormBox[
                          RowBox[{\(\((\(-1\))\)\^j\), " ", SuperscriptBox[
                          RowBox[{"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], ")"}], \(\(-j\) + m - 3\)], 
                          " ", SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                          ")"}], "i"], " ", SuperscriptBox[RowBox[{"(", 
                          RowBox[{RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], "+", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["s", 
                          "TraditionalForm"]}]}], ")"}], \(j - i\)]}], 
                          "TraditionalForm"]}], ")"}], " ", SuperscriptBox[
                      FormBox["\[CapitalDelta]", "TraditionalForm"], 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"]], " ", SuperscriptBox[FormBox[
                       "\[CapitalDelta]", "TraditionalForm"], FormBox[
                       FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"]]}], "-", RowBox[{\(\((\(-1\))\)\^m\)
                     , " ", \(g\_s\%2\), " ", RowBox[{SubscriptBox["T", 
                        FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubscriptBox["T", FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{"(", RowBox[
                          {FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["\[CapitalDelta]", 
                          "TraditionalForm"]}], ")"}]}], " ", RowBox[
                      {"(", RowBox[{FormBox[
                          TagBox[\(\[Sum]\+\(j = 0\)\%\(m - 3\) ""\), 
                            HoldForm], "TraditionalForm"], FormBox[
                          \(""\ \((j + 1)\)\), "TraditionalForm"], FormBox[
                          RowBox[{\(\((\(-1\))\)\^j\), " ", SuperscriptBox[
                          RowBox[{"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], ")"}], "i"], " ", 
                          SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                          ")"}], \(\(-j\) + m - 3\)], " ", SuperscriptBox[
                          RowBox[{"(", RowBox[{RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", "TraditionalForm"]}], 
                          "+", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["s", 
                          "TraditionalForm"]}]}], ")"}], \(j - i\)]}], 
                          "TraditionalForm"]}], ")"}], " ", SuperscriptBox[
                      FormBox["\[CapitalDelta]", "TraditionalForm"], 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"]], " ", SuperscriptBox[FormBox[
                       "\[CapitalDelta]", "TraditionalForm"], FormBox[
                       FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"]]}]}], TraditionalForm]], "Output", 
               CellTags -> "FeynRule"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(t4 = \(Twist2QuarkOperator[
                     \(\({p}\), \({q}\), \({r, \[Mu], a}\), \({s, \[Nu], b}\)
                       , \(Polarization \[Rule] 0\)\)]\)\)], "Input", 
               CellTags -> "FeynRule"], Cell[BoxData[FormBox[RowBox[{
                   \(-\((\(-1\))\)\^m\), " ", \(g\_s\%2\), " ", RowBox[
                    {RowBox[{"(", RowBox[{FormBox["\"\[Gamma]\"", 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          "\[CapitalDelta]", "TraditionalForm"]}], ")"}], 
                     ".", RowBox[{"(", RowBox[{RowBox[{RowBox[{SubscriptBox[
                          "T", FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SubscriptBox["T", FormBox[
                          FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"]]}], " ", RowBox[{"(", RowBox[
                          {FormBox[
                          TagBox[\(\[Sum]\+\(i = 0\)\%\(m - 3\) ""\), 
                            HoldForm], "TraditionalForm"], FormBox[
                          \(""\ \((i + 1)\)\), "TraditionalForm"], FormBox[
                          RowBox[{SuperscriptBox[RowBox[{"(", RowBox[{"-", 
                          RowBox[{"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], ")"}]}], ")"}], 
                          \(\(-i\) + m - 3\)], " ", SuperscriptBox[RowBox[
                          {"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], "j"], " ", 
                          SuperscriptBox[RowBox[{"(", RowBox[{RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                          "+", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["r", 
                          "TraditionalForm"]}]}], ")"}], \(i - j\)]}], 
                          "TraditionalForm"]}], ")"}]}], "+", RowBox[
                          {RowBox[{SubscriptBox["T", FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SubscriptBox["T", FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          RowBox[{"(", RowBox[{FormBox[
                          TagBox[\(\[Sum]\+\(i = 0\)\%\(m - 3\) ""\), 
                            HoldForm], "TraditionalForm"], FormBox[
                          \(""\ \((i + 1)\)\), "TraditionalForm"], FormBox[
                          RowBox[{SuperscriptBox[RowBox[{"(", RowBox[{"-", 
                          RowBox[{"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}], ")"}]}], ")"}], 
                          \(\(-i\) + m - 3\)], " ", SuperscriptBox[RowBox[
                          {"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], "j"], " ", 
                          SuperscriptBox[RowBox[{"(", RowBox[{RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                          "+", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["s", 
                          "TraditionalForm"]}]}], ")"}], \(i - j\)]}], 
                          "TraditionalForm"]}], ")"}]}]}], ")"}]}], " ", 
                   SuperscriptBox[FormBox["\[CapitalDelta]", 
                     "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]], " ", 
                   SuperscriptBox[FormBox["\[CapitalDelta]", 
                     "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Calc[\(\(\(\(n4 - t4\)/.\(OPEm \[Rule] 5\)\)/.
                       \(s \[Rule] \(\(-p\) - q - r\)\)\)/.\(D \[Rule] 4\)\)]
                \)], "Input", CellTags -> "FeynRule"], Cell[BoxData[
                \(TraditionalForm\`0\)], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell[" In general equality can be shown by \
Timing[Factor2[ \
FCE[Calc[ChangeDimension[FCE[OPESumExplicit[n4-t4]],4]/.s\[Rule]-p-q-r]]]] \
but it is a little bit slow ...", "Text", CellTags -> "FeynRule"], 
           Cell[BoxData[\(Clear[\(qggf, n2, n4\)]\)], "Input", 
            CellTags -> "FeynRule"], Cell["QCD vertices", "Text", 
            CellTags -> "FeynRule"], Cell[CellGroupData[{Cell[BoxData[
                \(fii = \({\(\(QuantumField[
                          \(GaugeField, \({\[Mu]}\), \({a}\)\)]\)[p]\), 
                      \(\(QuantumField[\(GaugeField, \({\[Nu]}\), \({b}\)\)]
                         \)[q]\), \(\(QuantumField[
                          \(GaugeField, \({\[Rho]}\), \({c}\)\)]\)[r]\)}\)\)]\
, "Input", CellTags -> "FeynRule"], Cell[BoxData[FormBox[RowBox[
                  {"{", RowBox[{SubsuperscriptBox[FormBox["A", 
                       "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     ",", SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"]], ",", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"]]}], "}"}], 
                 TraditionalForm]], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(g3 = \(FeynRule[\(\(Lagrangian["QCD"]\), fii\)]\)\)], 
               "Input", CellTags -> "FeynRule"], Cell[BoxData[FormBox[RowBox[{
                   \(g\_s\), " ", RowBox[{"(", RowBox[{RowBox[{RowBox[
                          {"(", RowBox[{SuperscriptBox[FormBox["q", 
                          "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], "-", 
                          SuperscriptBox[FormBox["r", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}], " ", 
                         \(g\^\(\[Nu]\[Rho]\)\)}], "-", RowBox[{
                         \(g\^\(\[Mu]\[Rho]\)\), " ", RowBox[{"(", RowBox[
                          {SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], "-", SuperscriptBox[FormBox[
                          "r", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}]}], 
                       "+", RowBox[{\(g\^\(\[Mu]\[Nu]\)\), " ", RowBox[
                          {"(", RowBox[{SuperscriptBox[FormBox["p", 
                          "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"]], "-", 
                          SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}]}], ")"}], " ", 
                   SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["c", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FeynRule"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[
                \(GluonVertex[\(\({p, \[Mu], a}\), \({q, \[Nu], b}\), 
                     \({r, \[Rho], c}\), \(Explicit \[Rule] True\)\)]\)], 
               "Input", CellTags -> "FeynRule"], Cell[BoxData[FormBox[RowBox[{
                   \(g\_s\), " ", RowBox[{"(", RowBox[{RowBox[{SuperscriptBox[
                          RowBox[{"(", FormBox[\(q - r\), "TraditionalForm"], 
                          ")"}], FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(\[Nu]\[Rho]\)\)}], 
                       "+", RowBox[{\(g\^\(\[Mu]\[Rho]\)\), " ", 
                         SuperscriptBox[RowBox[{"(", FormBox[\(r - p\), 
                          "TraditionalForm"], ")"}], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]]}], "+", 
                       RowBox[{\(g\^\(\[Mu]\[Nu]\)\), " ", SuperscriptBox[
                          RowBox[{"(", FormBox[\(p - q\), "TraditionalForm"], 
                          ")"}], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"]]}]}], ")"}], 
                   " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["c", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FeynRule"]}, Open]], Cell[CellGroupData[
             {Cell[BoxData[\(Calc[\(g3 - \(ChangeDimension[\(%, 4\)]\)\)]\)], 
               "Input", CellTags -> "FeynRule"], Cell[BoxData[
                \(TraditionalForm\`0\)], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(fi4 = \({\(\(QuantumField[
                          \(GaugeField, \({\[Mu]}\), \({a}\)\)]\)[p]\), 
                      \(\(QuantumField[\(GaugeField, \({\[Nu]}\), \({b}\)\)]
                         \)[q]\), \(\(QuantumField[
                          \(GaugeField, \({\[Rho]}\), \({c}\)\)]\)[r]\), 
                      \(\(QuantumField[\(GaugeField, \({\[Sigma]}\), \({d}\)
                           \)]\)[s]\)}\)\)], "Input", CellTags -> 
                "FeynRule"], Cell[BoxData[FormBox[RowBox[{"{", RowBox[
                    {SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], ",", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"]], ",", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"]], ",", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["d", 
                        "TraditionalForm"], "TraditionalForm"]]}], "}"}], 
                 TraditionalForm]], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(g4 = \(FeynRule[\(\(Lagrangian["QCD"]\), fi4\)]\)\)], 
               "Input", CellTags -> "FeynRule"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{"\[ImaginaryI]", " ", 
                     \((\(g\^\(\[Mu]\[Rho]\)\ g\^\(\[Nu]\[Sigma]\)\) - 
                         \(g\^\(\[Mu]\[Nu]\)\ g\^\(\[Rho]\[Sigma]\)\))\), 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["d", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["si1", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["si1", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", \(g\_s\%2\)}], "+", 
                   RowBox[{"\[ImaginaryI]", " ", 
                     \((\(g\^\(\[Mu]\[Sigma]\)\ g\^\(\[Nu]\[Rho]\)\) - 
                         \(g\^\(\[Mu]\[Nu]\)\ g\^\(\[Rho]\[Sigma]\)\))\), 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["si1", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["si1", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", \(g\_s\%2\)}], "+", 
                   RowBox[{"\[ImaginaryI]", " ", 
                     \((\(g\^\(\[Mu]\[Sigma]\)\ g\^\(\[Nu]\[Rho]\)\) - 
                         \(g\^\(\[Mu]\[Rho]\)\ g\^\(\[Nu]\[Sigma]\)\))\), 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["si1", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["si1", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", \(g\_s\%2\)}]}], 
                 TraditionalForm]], "Output", CellTags -> "FeynRule"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(GluonVertex[\(\({p, \[Mu], a}\), \({q, \[Nu], b}\), 
                     \({r, \[Rho], c}\), \({s, \[Sigma], d}\), 
                     \(Explicit \[Rule] True\)\)]\)], "Input", CellTags -> 
                "FeynRule"], Cell[BoxData[FormBox[RowBox[{\(-\[ImaginaryI]\), 
                   " ", \(g\_s\%2\), " ", RowBox[{"(", RowBox[{RowBox[{
                         \((\(g\^\(\[Mu]\[Nu]\)\ g\^\(\[Rho]\[Sigma]\)\) - 
                             \(g\^\(\[Mu]\[Rho]\)\ g\^\(\[Nu]\[Sigma]\)\))\), 
                         " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u8", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                         SubscriptBox["f", RowBox[{FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u8", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "+", 
                       RowBox[{
                         \((\(g\^\(\[Mu]\[Nu]\)\ g\^\(\[Rho]\[Sigma]\)\) - 
                             \(g\^\(\[Mu]\[Sigma]\)\ g\^\(\[Nu]\[Rho]\)\))\), 
                         " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u8", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                         SubscriptBox["f", RowBox[{FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u8", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], "+", 
                       RowBox[{
                         \((\(g\^\(\[Mu]\[Rho]\)\ g\^\(\[Nu]\[Sigma]\)\) - 
                             \(g\^\(\[Mu]\[Sigma]\)\ g\^\(\[Nu]\[Rho]\)\))\), 
                         " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u8", 
                          "TraditionalForm"], "TraditionalForm"]}]], " ", 
                         SubscriptBox["f", RowBox[{FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["u8", 
                          "TraditionalForm"], "TraditionalForm"]}]]}]}], 
                     ")"}]}], TraditionalForm]], "Output", CellTags -> 
                "FeynRule"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Calc[\(g4 - \(ChangeDimension[\(%, 4\)]\)\)]\)], "Input", 
               CellTags -> "FeynRule"], Cell[BoxData[\(TraditionalForm\`0\)], 
               "Output", CellTags -> "FeynRule"]}, Open]], Cell[BoxData[
             \(Clear[\(f2p, f2u, f3, f32, fi, fi4, fii, g3, g4, gop, gou, n3,
                   nf3, n4, np2, npf3, p33, pf3, pn3, pqo, qf, qp, qgf, qo, 
                  t4\)]\)], "Input", CellTags -> "FeynRule"]}, Open]], 
        Cell["FI", "ObjectName", CellTags -> "FI"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FI"], Cell["FI changes the output format to \
InputForm. This is useful to see the internal representation of FeynCalc \
objects. To change back to FeynCalcForm use FC.", "Text", CellTags -> "FI"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynCalcForm", 
                RuleDelayed[ButtonData, "FeynCalcForm"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcForm"]], ", ", 
              ButtonBox["FC", RuleDelayed[ButtonData, "FC"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FC"]], 
              ", ", 
              ButtonBox["FeynCalcExternal", 
                RuleDelayed[ButtonData, "FeynCalcExternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcExternal"]], ", ", 
              ButtonBox["FeynCalcInternal", 
                RuleDelayed[ButtonData, "FeynCalcInternal"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalcInternal"]], "."}], "Text", 
            CellTags -> "FI"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["FieldDerivative", "ObjectName", CellTags -> "FieldDerivative"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FieldDerivative"], Cell["FieldDerivative[f[x],x,li1,\
li2,...] is the derivative of f[x] with respect to space-time variables x and \
with Lorentz indices li1, li2, ..., where li1, li2, ... have head \
LorentzIndex. FieldDerivative[f[x],x,li1,li2,...] can be given as \
FieldDerivative[f[x],x,{l1,l2,...}], where l1 is li1 without the head, ... \
FieldDerivative is defined only for objects with head QuantumField[...]. If \
the space-time derivative of other objects is wanted, the corresponding rule \
must be specified.", "Text", CellTags -> "FieldDerivative"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["PartialD", RuleDelayed[ButtonData, "PartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "PartialD"]], ", ", 
              ButtonBox["ExpandPartialD", 
                RuleDelayed[ButtonData, "ExpandPartialD"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "ExpandPartialD"]], "."}], "Text", 
            CellTags -> "FieldDerivative"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FieldDerivative"], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(QuantumField[\(A, \({\[Mu]}\)\)]\)[x]\) . 
                   \(\(QuantumField[\(B, \({\[Nu]}\)\)]\)[y]\) . 
                   \(\(QuantumField[\(C, \({\[Rho]}\)\)]\)[x]\) . 
                   \(\(QuantumField[\(D, \({\[Sigma]}\)\)]\)[y]\)\)], 
               "Input", CellTags -> "FieldDerivative"], Cell[BoxData[
                FormBox[RowBox[{\(A\_\[Mu]\), ".", \(B\_\[Nu]\), ".", 
                   SubscriptBox[FormBox["C", "TraditionalForm"], "\[Rho]"], 
                   ".", SubscriptBox[FormBox["D", "TraditionalForm"], 
                    "\[Sigma]"]}], TraditionalForm]], "Output", CellTags -> 
                "FieldDerivative"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(FieldDerivative[\(%, x, \({\[Mu]}\)\)]\)//DotExpand\)], 
               "Input", CellTags -> "FieldDerivative"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{\(A\_\[Mu]\), ".", \(B\_\[Nu]\), ".", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox[FormBox["C", "TraditionalForm"], 
                        FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], "\[Null]"]}], ".", SubscriptBox[
                      FormBox["D", "TraditionalForm"], "\[Sigma]"]}], "+", 
                   RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], "\[Null]"]}], ".", \(B\_\[Nu]\), 
                     ".", SubscriptBox[FormBox["C", "TraditionalForm"], 
                      "\[Rho]"], ".", SubscriptBox[FormBox["D", 
                       "TraditionalForm"], "\[Sigma]"]}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "FieldDerivative"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(FieldDerivative[\(%, y, \({\[Nu]}\)\)]\)//DotExpand\)], 
               "Input", CellTags -> "FieldDerivative"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{\(A\_\[Mu]\), ".", \(B\_\[Nu]\), ".", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox[FormBox["C", "TraditionalForm"], 
                        FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], "\[Null]"]}], ".", RowBox[
                      {SubscriptBox["\[PartialD]", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox[FormBox["D", "TraditionalForm"], 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], "\[Null]"]}]}], "+", RowBox[{
                     \(A\_\[Mu]\), ".", RowBox[{SubscriptBox["\[PartialD]", 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["B", FormBox[
                         FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], "\[Null]"]}], ".", RowBox[
                      {SubscriptBox["\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox[FormBox["C", "TraditionalForm"], 
                        FormBox[FormBox["\[Rho]", "TraditionalForm"], 
                         "TraditionalForm"], "\[Null]"]}], ".", SubscriptBox[
                      FormBox["D", "TraditionalForm"], "\[Sigma]"]}], "+", 
                   RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], "\[Null]"]}], ".", \(B\_\[Nu]\), 
                     ".", SubscriptBox[FormBox["C", "TraditionalForm"], 
                      "\[Rho]"], ".", RowBox[{SubscriptBox["\[PartialD]", 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox[FormBox["D", 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], 
                        "\[Null]"]}]}], "+", RowBox[{RowBox[{SubscriptBox[
                        "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], 
                        "\[Null]"]}], ".", RowBox[{SubscriptBox[
                        "\[PartialD]", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox["B", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], 
                        "\[Null]"]}], ".", SubscriptBox[FormBox["C", 
                       "TraditionalForm"], "\[Rho]"], ".", SubscriptBox[
                      FormBox["D", "TraditionalForm"], "\[Sigma]"]}]}], 
                 TraditionalForm]], "Output", CellTags -> 
                "FieldDerivative"]}, Open]]}, Open]], Cell["FieldStrength", 
         "ObjectName", CellTags -> "FieldStrength"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FieldStrength"], Cell[TextData[
             {"FieldStrength[\[Mu], \[Nu], a] is the field strength tensor ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\(\[PartialD]\_\[Mu] A\_\[Nu]\%a\) - 
                     \(\[PartialD]\_\[Nu] A\_\[Mu]\%a\) + 
                     \(g\_s\ A\_\[Mu]\%b1 A\_\[Nu]\%c1\)\)\)]], Cell[BoxData[
                \(TraditionalForm\`\(\ f\^\(a\ b1\ c1\)\)\)]], 
              ". FieldStrength[\[Mu], \[Nu]] is the field strength tensor ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\(\[PartialD]\_\[Mu] A\_\[Nu]\%\[Null]\)
                      - \(\(\[PartialD]\_\[Nu] A\_\[Mu]\%\[Null]\) .\)\)\)]], 
              " The name of the field (A) and the coupling constant (g) can \
be set through the options or by additional arguments. The first two indices \
are interpreted as type LorentzIndex, except OPEDelta, which is converted to \
Momentum[OPEDelta]."}], "Text", CellTags -> "FieldStrength"], 
           Cell[CellGroupData[{Cell[BoxData[\(Options[FieldStrength]\)], 
               "Input", CellTags -> "FieldStrength"], Cell[BoxData[
                \(TraditionalForm\`\({\(CouplingConstant \[Rule] g\_s\), 
                      \(Explicit \[Rule] False\), 
                      \(HighEnergyPhysics`fctools`IndexPosition`IndexPosition
                         \[Rule] \({0, 0}\)\), \(Symbol \[Rule] "F"\), 
                      \(QuantumField \[Rule] A\)}\)\)], "Output", CellTags -> 
                "FieldStrength"]}, Open]], Cell[TextData[{"See also: ", " ", 
              ButtonBox["QuantumField", 
                RuleDelayed[ButtonData, "QuantumField"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "QuantumField"]], "."}], "Text", 
            CellTags -> "FieldStrength"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FieldStrength"], Cell[CellGroupData[{Cell[BoxData[
                \(FieldStrength[\(\[Mu], \[Nu]\)]\)], "Input", CellTags -> 
                "FieldStrength"], Cell[BoxData[
                \(TraditionalForm\`F\_\(\[Mu]\[Nu]\)\%\[Null]\)], "Output", 
               CellTags -> "FieldStrength"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FieldStrength[\(\[Mu], \[Nu], a\)]\)], "Input", CellTags -> 
                "FieldStrength"], Cell[BoxData[
                \(TraditionalForm\`F\_\(\[Mu]\[Nu]\)\%a\)], "Output", 
               CellTags -> "FieldStrength"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FieldStrength[\(\[Mu], \[Nu], \(Explicit \[Rule] True\)\)]
                  \)], "Input", CellTags -> "FieldStrength"], 
              Cell[BoxData[FormBox[RowBox[{RowBox[{SubscriptBox[
                      "\[PartialD]", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], "\[Null]"]}], "-", RowBox[
                    {SubscriptBox["\[PartialD]", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], "\[Null]"]}]}], TraditionalForm]], 
               "Output", CellTags -> "FieldStrength"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FieldStrength[\(\[Mu], \[Nu], a, \(Explicit \[Rule] True\)
                    \)]\)], "Input", CellTags -> "FieldStrength"], 
              Cell[BoxData[FormBox[RowBox[{RowBox[{SubscriptBox[
                      "\[PartialD]", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                        "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]]}], "+", 
                   RowBox[{\(g\_s\), " ", RowBox[{SubsuperscriptBox[FormBox[
                         "A", "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b12", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox[FormBox[
                         "A", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c61", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(f\_\(ab12c61\)\)}]}], 
                 TraditionalForm]], "Output", CellTags -> "FieldStrength"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(FieldStrength[
                     \(\[Mu], \[Nu], \(Explicit \[Rule] True\)\)]\)]\)], 
               "Input", CellTags -> "FieldStrength"], Cell[BoxData[
                \(\(QuantumField[\(\(PartialD[\(LorentzIndex[\[Mu]]\)]\), 
                       GaugeField, \(LorentzIndex[\[Nu]]\)\)]\) - 
                   \(QuantumField[\(\(PartialD[\(LorentzIndex[\[Nu]]\)]\), 
                       GaugeField, \(LorentzIndex[\[Mu]]\)\)]\)\)], "Output", 
               CellTags -> "FieldStrength"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(FieldStrength[
                     \(\[Mu], OPEDelta, \(Explicit \[Rule] True\)\)]\)]\)], 
               "Input", CellTags -> "FieldStrength"], Cell[BoxData[
                \(\(QuantumField[\(\(PartialD[\(LorentzIndex[\[Mu]]\)]\), 
                       GaugeField, \(Momentum[OPEDelta]\)\)]\) - 
                   \(QuantumField[\(\(PartialD[\(Momentum[OPEDelta]\)]\), 
                       GaugeField, \(LorentzIndex[\[Mu]]\)\)]\)\)], "Output", 
               CellTags -> "FieldStrength"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FieldStrength[\(\[Mu], \[Nu], a, 
                     \(CouplingConstant \[Rule] \(-Gstrong\)\), 
                     \(Explicit \[Rule] True\)\)]\)], "Input", CellTags -> 
                "FieldStrength"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                        "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{\(g\_s\), " ", RowBox[{SubsuperscriptBox[FormBox[
                         "A", "TraditionalForm"], FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b13", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox[FormBox[
                         "A", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c62", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", \(f\_\(ab13c62\)\)}]}], 
                 TraditionalForm]], "Output", CellTags -> "FieldStrength"]}, 
             Open]]}, Open]], Cell["FinalFunction", "ObjectName", 
         CellTags -> "FinalFunction"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "FinalFunction"], 
           Cell["FinalFunction is an option for OneLoopSum.", "Text", 
            CellTags -> "FinalFunction"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["OneLoopSum", RuleDelayed[ButtonData, "OneLoopSum"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "OneLoopSum"]], "."}], "Text", 
            CellTags -> "FinalFunction"], Cell[BoxData[""], "Input"]}, 
          Open]], Cell["FinalSubstitutions", "ObjectName", 
         CellTags -> "FinalSubstitutions"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FinalSubstitutions"], Cell["FinalSubstitutions is an \
option for OneLoop and OneLoopSum and Write2. All substitutions indicated \
hereby are done at the end of the calculation.", "Text", CellTags -> 
             "FinalSubstitutions"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["OneLoop", RuleDelayed[ButtonData, "OneLoop"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "OneLoop"]]\
, ", ", 
              ButtonBox["OneLoopSum", RuleDelayed[ButtonData, "OneLoopSum"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "OneLoopSum"]], ", ", 
              ButtonBox["Write2", RuleDelayed[ButtonData, "Write2"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Write2"]], 
              "."}], "Text", CellTags -> "FinalSubstitutions"], 
           Cell[BoxData[""], "Input"]}, Open]], Cell["FORM", "ObjectName", 
         CellTags -> "FORM"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "FORM"], 
           Cell["FORM is an option for RHI. If set to True a FORM file is \
generated and run from Mathematica (provided R. Hamberg's FORM-program is \
installed correctly ... ).", "Text", CellTags -> "FORM"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["RHI", RuleDelayed[ButtonData, "RHI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "RHI"]], 
              ", ", 
              ButtonBox["FeynCalc2FORM", 
                RuleDelayed[ButtonData, "FeynCalc2FORM"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalc2FORM"]], "."}], "Text", 
            CellTags -> "FORM"]}, Open]], Cell["FORMEpilog", "ObjectName", 
         CellTags -> "FORMEpilog"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "FORMEpilog"], 
           Cell["FORMEpilog is an option for FeynCalc2FORM. It may be set to \
a string which is put at the end of the FORM-file.", "Text", 
            CellTags -> "FORMEpilog"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynCalc2FORM", 
                RuleDelayed[ButtonData, "FeynCalc2FORM"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalc2FORM"]], ", ", 
              ButtonBox["FORMProlog", RuleDelayed[ButtonData, "FORMProlog"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FORMProlog"]], "."}], "Text", 
            CellTags -> "FORMEpilog"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["FORMProlog", "ObjectName", CellTags -> "FORMProlog"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FORMProlog"], Cell["FORMProlog is an option for \
FeynCalc2FORM. It may be set to a string which is put after the type \
declarations of the FORM-file.", "Text", CellTags -> "FORMProlog"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynCalc2FORM", 
                RuleDelayed[ButtonData, "FeynCalc2FORM"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalc2FORM"]], ", ", 
              ButtonBox["FORMEpilog", RuleDelayed[ButtonData, "FORMEpilog"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FORMEpilog"]], "."}], "Text", 
            CellTags -> "FORMProlog"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["FORM2FeynCalc", "ObjectName", CellTags -> "FORM2FeynCalc"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FORM2FeynCalc"], Cell["FORM2FeynCalc[expr] \
translates the FORM expr into FeynCalc notation. FORM2FeynCalc[file] \
translates the FORM expresssions in file into FeynCalcnotation. \
FORM2FeynCalc[file, x1, x2, ...] reads in a file in FORM-format and \
translates the assignments for the variables a, b, ... into FeynCalc syntax. \
If the option Set is True, the variables x1, x2 are assigned to the right \
hand sides defined in the FORM-file.", "Text", CellTags -> "FORM2FeynCalc"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynCalc2FORM", 
                RuleDelayed[ButtonData, "FeynCalc2FORM"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynCalc2FORM"]], "."}], "Text", 
            CellTags -> "FORM2FeynCalc"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[FORM2FeynCalc]\)], "Input", CellTags -> 
                "FORM2FeynCalc"], Cell[BoxData[
                \(TraditionalForm\`\({\(Dimension \[Rule] 4\), 
                      \(FinalSubstitutions \[Rule] \({}\)\), 
                      \(Dot \[Rule] Dot\), \(HoldForm \[Rule] True\), 
                      \(LorentzIndex \[Rule] \({mu, nu, al, be}\)\), 
                      \(Set \[Rule] False\), \(Replace \[Rule] \({}\)\), 
                      \(Vectors \[Rule] Automatic\)}\)\)], "Output", 
               CellTags -> "FORM2FeynCalc"]}, Open]]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FORM2FeynCalc"], Cell[CellGroupData[{Cell[BoxData[
                \(FORM2FeynCalc["p.q + 2*x m^2"]\)], "Input", CellTags -> 
                "FORM2FeynCalc"], Cell[BoxData[FormBox[RowBox[{
                   \(2\ \(x . m\^2\)\), "+", FormBox[RowBox[{FormBox["p", 
                       "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                       "TraditionalForm"]}], "TraditionalForm"]}], 
                 TraditionalForm]], "Output", CellTags -> "FORM2FeynCalc"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], 
               "Input", CellTags -> "FORM2FeynCalc"], Cell[BoxData[
                \(\(2\ \(x . m\^2\)\) + \(SP[\(p, q\)]\)\)], "Output", 
               CellTags -> "FORM2FeynCalc"]}, Open]], Cell["Functions are \
automatically converted right, but bracketed expressions need to be \
substituted explicitly.", "Text", CellTags -> "FORM2FeynCalc"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FORM2FeynCalc[\("x +f(z)+ log(x)^2+[li2(1-x)]", 
                     \(Replace \[Rule] \(
                        {"[li2(1-x)]" \[Rule] "PolyLog[2,1-x]"}\)\)\)]\)], 
               "Input", CellTags -> "FORM2FeynCalc"], Cell[BoxData[
                \(TraditionalForm\`\(\(\(log\^2\)(x)\) + x + \(f(z)\) + 
                     \(\(\*InterpretationBox["Li", PolyLog, 
                           Rule[Editable, False], Rule[Selectable, False]]\)\
\_2(\(1 - x\))\)\)\)], "Output", CellTags -> "FORM2FeynCalc"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "FORM2FeynCalc"], Cell[BoxData[
                \(x + \(f[z]\) + \(Log[x]\)\^2 + 
                   \(PolyLog[\(2, \(1 - x\)\)]\)\)], "Output", CellTags -> 
                "FORM2FeynCalc"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FORM2FeynCalc["x + [(1)]*y -[(-1)^m]"]\)], "Input", 
               CellTags -> "FORM2FeynCalc"], Cell[BoxData[
                \(TraditionalForm\`\(x + \(\(Hold[1]\) . y\) - 
                     \(Hold[\(\((\(-1\))\)\^m\)]\)\)\)], "Output", 
               CellTags -> "FORM2FeynCalc"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(ReleaseHold[%]\)], "Input", 
               CellTags -> "FORM2FeynCalc"], Cell[BoxData[
                \(TraditionalForm\`\(x - \((\(-1\))\)\^m + \(1 . y\)\)\)], 
               "Output", CellTags -> "FORM2FeynCalc"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FORM2FeynCalc["p(mu)*q(nu)+d_(mu,nu)"]\)], "Input", 
               CellTags -> "FORM2FeynCalc"], Cell[BoxData[
                \(TraditionalForm\`\(\(p\^mu . q\^nu\) + g\^\(munu\)\)\)], 
               "Output", CellTags -> "FORM2FeynCalc"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//StandardForm\)], "Input", 
               CellTags -> "FORM2FeynCalc"], Cell[BoxData[
                \(\(\(FV[\(p, mu\)]\) . \(FV[\(q, nu\)]\)\) + 
                   \(MT[\(mu, nu\)]\)\)], "Output", CellTags -> 
                "FORM2FeynCalc"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FORM2FeynCalc[\("p(mu)*q(nu)+d_(mu,nu)", 
                     \(Replace \[Rule] \(
                        {\(mu \[Rule] \[Mu]\), \(nu \[Rule] \[Nu]\)}\)\)\)]\)]\
, "Input", CellTags -> "FORM2FeynCalc"], Cell[BoxData[
                \(TraditionalForm\`\(\(p\^\[Mu] . q\^\[Nu]\) + 
                     g\^\(\[Mu]\[Nu]\)\)\)], "Output", CellTags -> 
                "FORM2FeynCalc"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FORM2FeynCalc["i_*az*bz*aM^2*D1*[(1)]*b_G1 * ( \
4*eperp(mu,nu)*avec.bvec*blam )"]\)], "Input", CellTags -> "FORM2FeynCalc"], 
              Cell[BoxData[FormBox[RowBox[{\((4\ \[ImaginaryI])\), ".", "az", 
                   ".", "bz", ".", \(aM\^2\), ".", "D1", ".", \(Hold[1]\), 
                   ".", "b$G1", ".", \(eperp(mu, nu)\), ".", RowBox[
                    {"(", FormBox[RowBox[{FormBox["avec", "TraditionalForm"], 
                        "\[CenterDot]", FormBox["bvec", "TraditionalForm"]}], 
                      "TraditionalForm"], ")"}], ".", "blam"}], 
                 TraditionalForm]], "Output", CellTags -> "FORM2FeynCalc"]}, 
             Open]]}, Open]], Cell["FourDivergence", "ObjectName", 
         CellTags -> "FourDivergence"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> 
             "FourDivergence"], Cell["FourDivergence[exp, FourVector[p, mu]] \
calculates the partial derivative of exp w.r.t. p(mu). FourDivergence[exp, \
FourVector[p, mu], FourVector[p,nu], ...]gives the multiple derivative.", 
            "Text", CellTags -> "FourDivergence"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["RussianTrick", 
                RuleDelayed[ButtonData, "RussianTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "RussianTrick"]], "."}], "Text", 
            CellTags -> "FourDivergence"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FourDivergence"], Cell[CellGroupData[{Cell[BoxData[
                \(t = \(ScalarProduct[\(p, q\)]\)\)], "Input", CellTags -> 
                "FourDivergence"], Cell[BoxData[FormBox[RowBox[
                  {FormBox["p", "TraditionalForm"], "\[CenterDot]", 
                   FormBox["q", "TraditionalForm"]}], TraditionalForm]], 
               "Output", CellTags -> "FourDivergence"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FourDivergence[\(t, \(FourVector[\(q, \[Mu]\)]\)\)]\)], 
               "Input", CellTags -> "FourDivergence"], Cell[BoxData[
                FormBox[SuperscriptBox[FormBox["p", "TraditionalForm"], 
                  FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                   "TraditionalForm"]], TraditionalForm]], "Output", 
               CellTags -> "FourDivergence"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t = \(ScalarProduct[\(\(p - k\), q\)]\)\)], "Input", 
               CellTags -> "FourDivergence"], Cell[BoxData[FormBox[
                 RowBox[{"(", FormBox[RowBox[{"p", "-", FormBox[
                       TagBox[StyleBox["\"k\"", Rule[FontSlant, "Italic"]], 
                         Function[StyleForm[Slot[1], 
                           Rule[FontSlant, "Italic"]]]], 
                       "TraditionalForm"]}], "TraditionalForm"], ")", 
                   "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                 TraditionalForm]], "Output", CellTags -> "FourDivergence"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FourDivergence[\(t, \(FourVector[\(\(k - p\), \[Mu]\)]\)\)]
                  \)], "Input", CellTags -> "FourDivergence"], Cell[BoxData[
                \(TraditionalForm\`0\)], "Output", CellTags -> 
                "FourDivergence"]}, Open]], Cell[BoxData[\(Clear[t]\)], 
            "Input", CellTags -> "FourDivergence"]}, Open]], 
        Cell["FourLaplacian", "ObjectName", CellTags -> "FourLaplacian"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FourLaplacian"], Cell[TextData[
             {"FourLaplacian[exp, p, q] is ", Cell[BoxData[
                \(TraditionalForm\`\(\[PartialD]\(/\(\[PartialD] p\_\[Mu]\)\)
                     \ \)\)]], Cell[BoxData[
                \(TraditionalForm\`\(\[PartialD]\(/\(\[PartialD] q\_\[Mu]\)\)
                     \ \)\)]], "exp."}], "Text", CellTags -> 
             "FourLaplacian"], Cell[CellGroupData[{Cell[BoxData[
                \(Options[FourLaplacian]\)], "Input", CellTags -> 
                "FourLaplacian"], Cell[BoxData[
                \(TraditionalForm\`\({Dimension \[Rule] D}\)\)], "Output", 
               CellTags -> "FourLaplacian"]}, Open]], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FourDivergence", 
                RuleDelayed[ButtonData, "FourDivergence"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FourDivergence"]], ", ", 
              ButtonBox["RussianTrick", 
                RuleDelayed[ButtonData, "RussianTrick"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "RussianTrick"]], "."}], "Text", 
            CellTags -> "FourLaplacian"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FourLaplacian"], Cell[CellGroupData[{Cell[BoxData[
                \(SP[\(q, q\)]\)], "Input", CellTags -> "FourLaplacian"], 
              Cell[BoxData[FormBox[SuperscriptBox[FormBox["q", 
                   "TraditionalForm"], "2"], TraditionalForm]], "Output", 
               CellTags -> "FourLaplacian"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(FourLaplacian[\(%, q, q\)]\)], 
               "Input", CellTags -> "FourLaplacian"], Cell[BoxData[
                \(TraditionalForm\`\(2\ D\)\)], "Output", CellTags -> 
                "FourLaplacian"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(\(\(SOD[q]\)^OPEm\)\(FAD[\(q, \(q - p\)\)]\)\)//FCI\)], 
               "Input", CellTags -> "FourLaplacian"], Cell[BoxData[
                FormBox[FractionBox[SuperscriptBox[RowBox[{"(", RowBox[
                      {FormBox["\[CapitalDelta]", "TraditionalForm"], 
                       "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                     ")"}], "m"], \(q\^2 . \((q - p)\)\^2\)], 
                 TraditionalForm]], "Output", CellTags -> "FourLaplacian"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FourLaplacian[\(%, q,\ q\)]\)], "Input", CellTags -> 
                "FourLaplacian"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"-", FractionBox[RowBox[{"4", " ", "m", " ", 
                        SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                          ")"}], \(m - 1\)], " ", RowBox[{"(", RowBox[
                          {RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], "-", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["p", 
                          "TraditionalForm"]}]}], ")"}]}], 
                      \(q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)]}], "-", 
                   FractionBox[RowBox[{"2", " ", "D", " ", SuperscriptBox[
                       RowBox[{"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], "m"]}], 
                    \(q\^2 . q\^2 . \((q - p)\)\^2\)], "-", FractionBox[
                    RowBox[{"4", " ", "m", " ", SuperscriptBox[RowBox[
                        {"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], "m"]}], 
                    \(q\^2 . q\^2 . \((q - p)\)\^2\)], "+", FractionBox[
                    RowBox[{"12", " ", SuperscriptBox[RowBox[{"(", RowBox[
                          {FormBox["\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                         ")"}], "m"]}], \(q\^2 . q\^2 . \((q - p)\)\^2\)], 
                   "-", FractionBox[RowBox[{"2", " ", "D", " ", 
                      SuperscriptBox[RowBox[{"(", RowBox[{FormBox[
                          "\[CapitalDelta]", "TraditionalForm"], 
                          "\[CenterDot]", FormBox["q", "TraditionalForm"]}], 
                         ")"}], "m"]}], 
                    \(q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)], "+", 
                   FractionBox[RowBox[{"12", " ", SuperscriptBox[RowBox[
                        {"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], "m"]}], 
                    \(q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)], "-", 
                   FractionBox[RowBox[{"4", " ", SuperscriptBox[RowBox[
                        {"(", RowBox[{FormBox["\[CapitalDelta]", 
                          "TraditionalForm"], "\[CenterDot]", FormBox["q", 
                          "TraditionalForm"]}], ")"}], "m"], " ", 
                      SuperscriptBox[FormBox["p", "TraditionalForm"], "2"]}], 
                    \(q\^2 . q\^2 . \((q - p)\)\^2 . \((q - p)\)\^2\)]}], 
                 TraditionalForm]], "Output", CellTags -> "FourLaplacian"]}, 
             Open]]}, Open]], Cell["FourVector", "ObjectName", 
         CellTags -> "FourVector"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "FourVector"], 
           Cell[TextData[{"FourVector[p, ", Cell[BoxData[
                \(TraditionalForm\`\[Mu]\)]], 
              "] is the four-dimensional vector p with Lorentz index ", 
              Cell[BoxData[\(TraditionalForm\`\[Mu]\)]], ". A vector with \
space-time Dimension D is obtained by supplying the option Dimension \[Rule] \
D."}], "Text", CellTags -> "FourVector"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["FV", RuleDelayed[ButtonData, "FV"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FV"]], 
              ", ", 
              ButtonBox["FVD", RuleDelayed[ButtonData, "FVD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FVD"]], 
              ", ", 
              ButtonBox["Pair", RuleDelayed[ButtonData, "Pair"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Pair"]], 
              "."}], "Text", CellTags -> "FourVector"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FourVector"], Cell[CellGroupData[{Cell[BoxData[
                \(FourVector[\(p, \[Mu]\)]\)], "Input", CellTags -> 
                "FourVector"], Cell[BoxData[\(TraditionalForm\`p\_\[Mu]\)], 
               "Output", CellTags -> "FourVector"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FourVector[\(\(p - q\), \[Mu]\)]\)], "Input", CellTags -> 
                "FourVector"], Cell[BoxData[FormBox[SubscriptBox[
                  RowBox[{"(", FormBox[TagBox[\(p - q\), HoldForm], 
                     "TraditionalForm"], ")"}], "\[Mu]"], TraditionalForm]], 
               "Output", CellTags -> "FourVector"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(FourVector[\(p, \[Mu]\)]\)]\)], "Input", 
               CellTags -> "FourVector"], Cell[BoxData[
                \(FourVector[\(p, \[Mu]\)]\)], "Output", CellTags -> 
                "FourVector"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(FourVector[
                     \(p, \[Mu], \(Dimension \[Rule] D\)\)]\)]\)], "Input", 
               CellTags -> "FourVector"], Cell[BoxData[
                \(FourVector[\(p, \[Mu], \(Dimension \[Rule] D\)\)]\)], 
               "Output", CellTags -> "FourVector"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(FCE[\(FourVector[\(p, \[Mu]\)]\)]\)]\)], 
               "Input", CellTags -> "FourVector"], Cell[BoxData[
                \(FourVector[\(p, \[Mu]\)]\)], "Output", CellTags -> 
                "FourVector"]}, Open]], Cell["There is no special function to \
expand momenta in FourVector. Since FourVector is turned into Pair internally \
ExpandScalarProduct may be used.", "Text", CellTags -> "FourVector"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(ExpandScalarProduct[\(FourVector[\(\(p - q\), \[Mu]\)]\)]\)]\
, "Input", CellTags -> "FourVector"], Cell[BoxData[FormBox[SubscriptBox[
                  RowBox[{"(", FormBox[TagBox[\(p - q\), HoldForm], 
                     "TraditionalForm"], ")"}], "\[Mu]"], TraditionalForm]], 
               "Output", CellTags -> "FourVector"]}, Open]]}, Open]], 
        Cell["FreeIndex", "ObjectName", CellTags -> "FreeIndex"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FreeIndex"], Cell["FreeIndex is a datatype which is \
recognized by Contract. Possible use: DataType[mu, FreeIndex] = True.", 
            "Text", CellTags -> "FreeIndex"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["Contract", RuleDelayed[ButtonData, "Contract"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "Contract"]], ", ", 
              ButtonBox["DataType", RuleDelayed[ButtonData, "DataType"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DataType"]], "."}], "Text", 
            CellTags -> "FreeIndex"], Cell[BoxData[""], "Input"]}, Open]], 
        Cell["FreeQ2", "ObjectName", CellTags -> "FreeQ2"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FreeQ2"], Cell["FreeQ2[expr, {form1, form2, ...}] \
yields True if expr does not contain any occurence of form1, form2, ... and \
False otherwise. FreeQ2[expr, form] is the same as FreeQ[expr, form].", 
            "Text", CellTags -> "FreeQ2"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["SelectFree", RuleDelayed[ButtonData, "SelectFree"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SelectFree"]], ", ", 
              ButtonBox["SelectNotFree", 
                RuleDelayed[ButtonData, "SelectNotFree"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "SelectNotFree"]], "."}], "Text", 
            CellTags -> "FreeQ2"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FreeQ2"], Cell[CellGroupData[{Cell[BoxData[
                \(FreeQ2[\(\(x + \(f[x]\) + y\),\ \({a, x}\)\)]\)], "Input", 
               CellTags -> "FreeQ2"], Cell[BoxData[\(TraditionalForm\`False\)]
                , "Output", CellTags -> "FreeQ2"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FreeQ2[\(\(x + \(f[x]\) + y\), \({a, b}\)\)]\)], "Input", 
               CellTags -> "FreeQ2"], Cell[BoxData[\(TraditionalForm\`True\)]
                , "Output", CellTags -> "FreeQ2"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(FreeQ2[\(x,\ y\)]\)], "Input", 
               CellTags -> "FreeQ2"], Cell[BoxData[\(TraditionalForm\`True\)]
                , "Output", CellTags -> "FreeQ2"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(FreeQ2[\(\(f[x]\),\ f\)]\)], 
               "Input", CellTags -> "FreeQ2"], Cell[BoxData[
                \(TraditionalForm\`False\)], "Output", CellTags -> 
                "FreeQ2"]}, Open]]}, Open]], Cell["FRH", "ObjectName", 
         CellTags -> "FRH"], Cell[CellGroupData[{Cell["Description", 
            "Subsubsection", CellTags -> "FRH"], Cell["FRH[exp_] := \
FixedPoint[ReleaseHold, exp], i.e., FRH removes all HoldForm and Hold in \
exp.", "Text", CellTags -> "FRH"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Isolate", RuleDelayed[ButtonData, "Isolate"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Isolate"]]\
, "."}], "Text", CellTags -> "FRH"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FRH"], Cell[CellGroupData[{Cell[BoxData[
                \(Hold[\(1 - 1\ -\ \(Hold[\(2 - 2\)]\)\)]\)], "Input", 
               CellTags -> "FRH"], Cell[BoxData[
                \(TraditionalForm\`\(Hold[
                     \(\(-\(Hold[\(2 - 2\)]\)\) + 1 - 1\)]\)\)], "Output", 
               CellTags -> "FRH"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FRH[%]\)], "Input", CellTags -> "FRH"], Cell[BoxData[
                \(TraditionalForm\`0\)], "Output", CellTags -> "FRH"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(Isolate[\(\(Solve[\(\(\(x^3\) - x - 1\) == 0\)]\), x, 
                     \(IsolateNames \[Rule] hh\)\)]\)], "Input", CellTags -> 
                "FRH"], Cell[BoxData[
                \(TraditionalForm\`\({\({
                        x \[Rule] \*TagBox[\(hh(3)\), HoldForm]}\), 
                      \({x \[Rule] \*TagBox[\(hh(6)\), HoldForm]}\), 
                      \({x \[Rule] \*TagBox[\(hh(7)\), HoldForm]}\)}\)\)], 
               "Output", CellTags -> "FRH"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(FRH[\(hh[3]\)]\)], "Input", 
               CellTags -> "FRH"], Cell[BoxData[
                \(TraditionalForm\`\(\(1\/3\ \@\(27\/2 - \(3\ \@69\)\/2\)\%3
                      \) + \@\(1\/2\ \((9 + \@69)\)\)\%3\/3\^\(2/3\)\)\)], 
               "Output", CellTags -> "FRH"]}, Open]], Cell[BoxData[
             \(Clear[hh]\)], "Input", CellTags -> "FRH"]}, Open]], 
        Cell["FromTFI", "ObjectName", CellTags -> "FromTFI"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FromTFI"], Cell["FromTFI[expr, q1, q2, p] translates \
the TFI notatation from the TARCER package to the usual FeynCalc notation. \
See the TARCER documentation on TFI for details on the conventions.", "Text", 
            CellTags -> "FromTFI"], Cell[TextData[{"See also: ", 
              ButtonBox["ToTFI", RuleDelayed[ButtonData, "ToTFI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "ToTFI"]], 
              "."}], "Text", CellTags -> "FromTFI"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FromTFI"], Cell[CellGroupData[{Cell[BoxData[
                \(ToTFI[\(\(FAD[\(q1, \(q1 - p\), \({q2, M}\), 
                         \({\(q2 - p\), m}\), \(q1 - q2\)\)]\), q1, q2, p\)]\
\)], "Input", CellTags -> "FromTFI"], Cell[BoxData[FormBox[InterpretationBox[
                  SubsuperscriptBox[
                   StyleBox["F", Rule[SingleLetterItalics, False], 
                     Rule[FontWeight, "Bold"]], RowBox[{FormBox[\({1, 0}\), 
                      "TraditionalForm"], FormBox[\({1, M}\), 
                      "TraditionalForm"], FormBox[\({1, 0}\), 
                      "TraditionalForm"], FormBox[\({1, m}\), 
                      "TraditionalForm"], FormBox[\({1, 0}\), 
                      "TraditionalForm"]}], RowBox[{"(", FormBox["D", 
                      "TraditionalForm"], ")"}]], TFI[D, m^2, {{1, 0}, 
                    {1, M}, {1, 0}, {1, m}, {1, 0}}], Editable -> True], 
                 TraditionalForm]], "Output", CellTags -> "FromTFI"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FromTFI[\(\(TFI[\(D, \(SPD[\(p, p\)]\), \(SOD[p]\), 
                         \({\({1, 0}\), \({1, M}\), \({1, 0}\), \({1, m}\), 
                            \({1, 0}\)}\)\)]\), q1, q2, p\)]\)], "Input", 
               CellTags -> "FromTFI"], Cell[BoxData[
                \(TraditionalForm\`\(1\/\(
                      \(\*TagBox[StyleBox["\"q\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_2\%2 . 
                       \((\((\(\*TagBox[StyleBox["\"q\"", 
                                   Rule[FontSlant, "Italic"]], 
                                  Function[StyleForm[Slot[1], 
                                    Rule[FontSlant, "Italic"]]]]\)\_1 - p)\)\
\^2 - M\^2)\) . \((\(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2 - p)\)\^2\
 . \((\(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1 - 
                           \(\*TagBox[StyleBox["\"q\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2)\)\^2 . 
                       \((\(\*TagBox[StyleBox["\"q\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_1\%2 - m\^2)\
\)\)\)\)], "Output", CellTags -> "FromTFI"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FromTFI[\(\(TFI[\(D, \(SPD[\(p, p\)]\), \(SOD[p]\), 
                         \({0, 1}\), \({\({1, m}\), \({1, M}\), \({1, 0}\), 
                            \({1, m}\), \({1, 0}\)}\)\)]\), q1, q2, p\)]\)], 
               "Input", CellTags -> "FromTFI"], Cell[BoxData[FormBox[
                 FractionBox[RowBox[{FormBox["\[CapitalDelta]", 
                     "TraditionalForm"], "\[CenterDot]", FormBox[
                     \(\(\*TagBox[StyleBox["\"q\"", 
                            Rule[FontSlant, "Italic"]], 
                           Function[StyleForm[Slot[1], 
                             Rule[FontSlant, "Italic"]]]]\)\_2\), 
                     "TraditionalForm"]}], 
                  \(\((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1 - 
                         \(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_2)\)\^2 . 
                     \((\(\*TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_2\%2 - M\^2)\)\
 . \((\((\(\*TagBox[StyleBox["\"q\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2 - p)\)\^2\
 - m\^2)\) . \((\(\*TagBox[StyleBox["\"q\"", 
                             Rule[FontSlant, "Italic"]], 
                            Function[StyleForm[Slot[1], 
                              Rule[FontSlant, "Italic"]]]]\)\_1\%2 - m\^2)\)\
 . \((\(\*TagBox[StyleBox["\"q\"", 
                              Rule[FontSlant, "Italic"]], 
                             Function[StyleForm[Slot[1], 
                               Rule[FontSlant, "Italic"]]]]\)\_1 - p)\)\^2\)]\
, TraditionalForm]], "Output", CellTags -> "FromTFI"]}, Open]]}, Open]], 
        Cell["FUNCTION", "ObjectName", CellTags -> "FUNCTION"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FUNCTION"], Cell["FUNCTION[exp, string] is a head of \
an expression to be declared a function (of type string), if used in Write2."\
, "Text", CellTags -> "FUNCTION"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["Write2", RuleDelayed[ButtonData, "Write2"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Write2"]], 
              "."}], "Text", CellTags -> "FUNCTION"], Cell[BoxData[""], 
            "Input"]}, Open]], Cell["FunctionalD", "ObjectName", 
         CellTags -> "FunctionalD"], Cell[CellGroupData[
          {Cell["Description", "Subsubsection", CellTags -> "FunctionalD"], 
           Cell["FunctionalD[expr, {QuantumField[name, {mu}, {a}][p], ...}] \
calculates the functional derivative of expr with respect to the field list \
(with incoming momenta p etc.) and does the fourier transform. \
FunctionalD[expr, {QuantumField[name, {mu},{a}], ...}] calculates the \
functional derivative and does partial integration but omits the x-space \
delta functions.", "Text", CellTags -> "FunctionalD"], 
           Cell["FunctionalD is a low level function used in FeynRule.", 
            "Text", CellTags -> "FunctionalD"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FeynRule", RuleDelayed[ButtonData, "FeynRule"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FeynRule"]], ", ", 
              ButtonBox["QuantumField", 
                RuleDelayed[ButtonData, "QuantumField"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "QuantumField"]], "."}], "Text", 
            CellTags -> "FunctionalD"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FunctionalD"], Cell[TextData[
             {"Instead of the usual ", Cell[BoxData[
                \(TraditionalForm\`\(\(\(\[Delta]\[Phi](x)\)/
                       \(\[Delta]\[Phi](y)\)\) = 
                     \(\(\[Delta]\^\((D)\)\)(\(x - y\))\)\)\)]], " the \
arguments and the \[Delta] function are omitted, i.e., for the program for \
simplicity: ", Cell[BoxData[
                \(TraditionalForm\`\(\(\[Delta]\[Phi]/\[Delta]\[Phi]\) = 1\)
                  \)]]}], "Text", CellTags -> "FunctionalD"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FunctionalD[\(\(QuantumField[\[Phi]]\), 
                     \(QuantumField[\[Phi]]\)\)]\)], "Input", CellTags -> 
                "FunctionalD"], Cell[BoxData[\(TraditionalForm\`1\)], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(FunctionalD[\(\(\(QuantumField[\[Phi]]\)^2\), 
                     \(QuantumField[\[Phi]]\)\)]\)], "Input", CellTags -> 
                "FunctionalD"], Cell[BoxData[
                \(TraditionalForm\`\(2\ \[Phi]\)\)], "Output", CellTags -> 
                "FunctionalD"]}, Open]], Cell[TextData[
             {"Instead of the usual ", Cell[BoxData[
                \(TraditionalForm\`\(\(\(
                        (\[Delta]\ \(\[PartialD]\_\[Mu] \(\[Phi](x)\)\))\)/
                       \(\[Delta]\[Phi](y)\)\) = 
                     \(\[PartialD]\_\[Mu] 
                       \(\(\[Delta]\^\((D)\)\)(\(x - y\))\)\)\)\)]], 
              " the arguments are omitted, and the ", Cell[BoxData[
                \(TraditionalForm\`\[PartialD]\_\[Mu]\)]], "operator is \
specified by default to be an integration by parts operator, i.e., the right \
hand side will be just ", Cell[BoxData[FormBox[RowBox[{RowBox[{"-", FormBox[
                      \(\[PartialD]\_\[Mu]\), "TraditionalForm"]}], ","}], 
                 TraditionalForm]]], " or, more precisely (by default) ", 
              Cell[BoxData[FormBox[RowBox[{"-", SubscriptBox[
                    \(\[PartialD]\&\[RightArrow]\), FormBox[FormBox["\[Mu]", 
                      "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]]], "."}], "Text", ZeroWidthTimes -> True, 
            CellTags -> "FunctionalD"], Cell[CellGroupData[{Cell[BoxData[
                \(FunctionalD[\(\(QuantumField[
                       \(\(PartialD[\[Mu]]\), \[Phi]\)]\), 
                     \(QuantumField[\[Phi]]\)\)]\)], "Input", CellTags -> 
                "FunctionalD"], Cell[BoxData[FormBox[RowBox[{"-", 
                   SubscriptBox[\(\[PartialD]\&\[RightArrow]\), FormBox[
                     FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "FunctionalD"]}, Open]], 
           Cell[TextData[Cell[BoxData[
               \(TraditionalForm\`\(\(S[\[Phi]]\)\ = 
                    \(\(1/2\) \(\[Integral]\ 
                        \(d\^D \(x\ [\ \(
                             \(\(\[PartialD]\_\[Mu] \(\[Phi](x)\)\)\ 
                                \(\[PartialD]\^\[Mu] \(\[Phi](x)\)\)\) - 
                              \(m\^2 \(\[Phi](x)\)\ \(\[Phi](y)\)\)\)]\)\)\)\
\)\)\)]]], "Text", ZeroWidthTimes -> True, CellTags -> "FunctionalD"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(s[\[Phi]]\) = \(\((\(
                         \(QuantumField[\(\(PartialD[\[Mu]]\), \[Phi]\)]\) . 
                          \(QuantumField[\(\(PartialD[\[Mu]]\), \[Phi]\)]\)\)\
 - \(\(m^2\)\ \(\(QuantumField[\[Phi]]\) . 
                            \(QuantumField[\[Phi]]\)\)\))\)/2\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[RowBox[{
                   \(1\/2\), " ", RowBox[{"(", RowBox[{RowBox[{RowBox[
                          {SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                          \(\[Phi]\_\[Null]\%\[Null]\)}], ".", RowBox[
                          {SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                          \(\[Phi]\_\[Null]\%\[Null]\)}]}], "-", 
                       \(m\^2\ \(\[Phi] . \[Phi]\)\)}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "FunctionalD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FunctionalD[\(\(s[\[Phi]]\), \(QuantumField[\[Phi]]\)\)]\)]\
, "Input", CellTags -> "FunctionalD"], Cell[BoxData[FormBox[RowBox[{
                   \(\(-\[Phi]\)\ m\^2\), "-", RowBox[{RowBox[{FormBox[
                        SubscriptBox["\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"], FormBox[SubscriptBox[
                         "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"]}], \(\[Phi]\_\[Null]\%\[Null]\)}]}]
                     , TraditionalForm]], "Output", CellTags -> 
                "FunctionalD"]}, Open]], Cell[TextData[Cell[BoxData[
               \(TraditionalForm\`\(\(S[A]\)\ =\ 
                    \(-\(\[Integral]\ \(
                         d\^D x\ 1\/4\ \(F\_a\%\[Mu]\[Nu](x)\)\ 
                          \(F\_\[Mu]\[Nu]a(x)\)\)\)\)\)\)]]], "Text", 
            ZeroWidthTimes -> True, CellTags -> "FunctionalD"], Cell[TextData[
             StyleBox["First approach", Rule[FontWeight, "Bold"]]], "Text", 
            CellTags -> "FunctionalD"], Cell[CellGroupData[{Cell[BoxData[
                \(F1 = \(FieldStrength[\(
                      \[Mu], \[Nu], a, \({A, b, c}\), 1, 
                       \(Explicit \[Rule] True\)\)]\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                       FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                       FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                        "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"]]}], "+", RowBox[{RowBox[
                      {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     \(f\_\(abc\)\)}]}], TraditionalForm]], "Output", 
               CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(F2 = \(FieldStrength[\(
                      \[Mu], \[Nu], a, \({A, d, e}\), 1, 
                       \(Explicit \[Rule] True\)\)]\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                       FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                       FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                        "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"]]}], "+", RowBox[{RowBox[
                      {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     \(f\_\(ade\)\)}]}], TraditionalForm]], "Output", 
               CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(S[A]\) = \(\(-\(1/4\)\)\(F1 . F2\)\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[RowBox[{
                   \(-\(1\/4\)\), " ", RowBox[{RowBox[{"(", RowBox[
                        {RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{RowBox[
                          {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(f\_\(abc\)\)}]}], ")"}], ".", RowBox[{"(", 
                       RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], "-", 
                         RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{RowBox[
                          {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(f\_\(ade\)\)}]}], ")"}]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[TextData[{"In order to derive the equation of motion the \
functional derivative of ", Cell[BoxData[\(TraditionalForm\`S\)]], 
              " with respect to ", Cell[BoxData[
                \(TraditionalForm\`A\_\[Sigma]\%g\)]], "has to be set to \
zero. Bearing in mind that for FeynCalc we have to be precise as to where \
which operators (coming from the substitution of the derivative of the \
\[Delta] function) act:, act with the functional derivative operator on the \
first field strength:"}], "Text", CellTags -> "FunctionalD"], 
           Cell[TextData[{Cell[BoxData[FormBox[RowBox[{RowBox[
                    {FormBox[RowBox[{FormBox[RowBox[{FormBox[RowBox[{"0", 
                          " ", "=", " ", RowBox[{FormBox[
                          \(\((\[Delta]S)\)/\((\[Delta] \(A\_\[Sigma]\%g(y)\)
                               )\)\), "TraditionalForm"], "=", \(-\(2/4\)\)}]}
                          ], "TraditionalForm"], \(\[Integral] \(d\^D x\)\)}]
                          , "TraditionalForm"], " ", 
                        \((\[Delta]/\((\[Delta] \(A\_\[Sigma]\%g(y)\))\)\)}], 
                      "TraditionalForm"], " ", \(F\_\[Mu]\[Nu]a(x)\)}], 
                   ")"}], TraditionalForm]]], Cell[BoxData[FormBox[
                 RowBox[{FormBox[\(\ F\_a\%\(, \[Mu]\[Nu]\)\), 
                    "TraditionalForm"], "(", "x", ")"}], 
                 TraditionalForm]]]}], "Text", ZeroWidthTimes -> True, 
            CellTags -> "FunctionalD"], Cell[TextData[
             Cell[BoxData[FormBox[RowBox[{"See", " ", "what", " ", "happens", 
                  " ", "with", " ", "just", RowBox[{FormBox[
                     \(\((\[Delta]\(S[A]\))\)/\((\[Delta] A\_\[Sigma]\%g)\)\)\
, "TraditionalForm"], "."}]}], TraditionalForm]]]], "Text", 
            CellTags -> "FunctionalD"], Cell[CellGroupData[{Cell[BoxData[
                \(Ag = \(QuantumField[\(A, \({\[Sigma]}\), \({g}\)\)]\)\)], 
               "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                    "TraditionalForm"], "TraditionalForm"], FormBox[
                   FormBox["g", "TraditionalForm"], "TraditionalForm"]], 
                 TraditionalForm]], "Output", CellTags -> "FunctionalD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t1 = \(FunctionalD[\(F1, Ag\)]\)\)], "Input", CellTags -> 
                "FunctionalD"], Cell[BoxData[FormBox[RowBox[{RowBox[{
                     \(-g\^\(\[Nu]\[Sigma]\)\), " ", SubscriptBox[
                      \(\[PartialD]\&\[RightArrow]\), FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{
                     \(g\^\(\[Mu]\[Sigma]\)\), " ", SubscriptBox[
                      \(\[PartialD]\&\[RightArrow]\), FormBox[FormBox[
                        "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{
                     \(g\^\(\[Nu]\[Sigma]\)\), " ", SubsuperscriptBox["A", 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{
                     \(g\^\(\[Mu]\[Sigma]\)\), " ", SubsuperscriptBox["A", 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell["In order to minimize the number of dummy indices, replace b \
\[Rule] c.", "Text", CellTags -> "FunctionalD"], Cell[CellGroupData[
             {Cell[BoxData[\(t1\ =\ \(t1\ /.\ \(b \[Rule] c\)\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{\(-g\^\(\[Nu]\[Sigma]\)\), " ", SubscriptBox[
                      \(\[PartialD]\&\[RightArrow]\), FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{
                     \(g\^\(\[Mu]\[Sigma]\)\), " ", SubscriptBox[
                      \(\[PartialD]\&\[RightArrow]\), FormBox[FormBox[
                        "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{
                     \(g\^\(\[Nu]\[Sigma]\)\), " ", SubsuperscriptBox["A", 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{
                     \(g\^\(\[Mu]\[Sigma]\)\), " ", SubsuperscriptBox["A", 
                      FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[TextData[
             {"Instead of inserting the definition for the second ", 
              Cell[BoxData[\(TraditionalForm\`F\_a\%\[Mu]\[Nu]\)]], ", \
introduce a QuantumField object with antisymmetry built into the Lorentz \
indices:"}], "Text", CellTags -> "FunctionalD"], Cell[BoxData[
             \(F/:\ \(QuantumField[\(pard___, F, \[Beta]_, \[Alpha]_, s_\)]\)
                 := \(\(-\(QuantumField[\(pard, F, \[Alpha], \[Beta], s\)]\)
                   \)/;\(! \(OrderedQ[\({\[Beta], \[Alpha]}\)]\)\)\)\)], 
            "Input", CellTags -> "FunctionalD"], Cell[CellGroupData[
             {Cell[BoxData[
                \(QuantumField[\(F, \({\[Mu], \[Nu]}\), \({a}\)\)]\)], 
               "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[SubsuperscriptBox["F", RowBox[{FormBox[FormBox[
                      "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                    FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"]}], FormBox[FormBox["a", 
                    "TraditionalForm"], "TraditionalForm"]], 
                 TraditionalForm]], "Output", CellTags -> "FunctionalD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(%/.\({\(\[Mu] \[RuleDelayed] \[Nu]\), 
                      \(\[Nu] \[RuleDelayed] \[Mu]\)}\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[
                 RowBox[{"-", SubsuperscriptBox["F", RowBox[{FormBox[
                       FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"]}], FormBox[
                     FormBox["a", "TraditionalForm"], "TraditionalForm"]]}], 
                 TraditionalForm]], "Output", CellTags -> "FunctionalD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[
                \(t2 = \(\(Contract[\(ExpandPartialD[
                         \(\(-\(1/2\)\)\ 
                           \(t1 . \(QuantumField[
                               \(F, \(LorentzIndex[\[Mu]]\), 
                                 \(LorentzIndex[\[Nu]]\), \(SUNIndex[a]\)\)]\
\)\)\)]\)]\)/.\(Dot \[Rule] Times\)\)\)], "Input", CellTags -> 
                "FunctionalD"], Cell[BoxData[FormBox[RowBox[{RowBox[{\(1\/2\)
                     , " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["F", 
                        RowBox[{FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]}], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]]}]}], "+", RowBox[{\(1\/2\), " ", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox["F", RowBox[{FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]}], FormBox[FormBox["g", 
                          "TraditionalForm"], "TraditionalForm"]]}]}], "-", 
                   RowBox[{\(1\/2\), " ", SubsuperscriptBox["A", FormBox[
                       FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubsuperscriptBox["F", RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]}], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/2\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["F", RowBox[{FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]}], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t3\ =\ \(t2\ /.\ \(\[Nu] \[Rule] \[Mu]\)\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                       FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"]], SubsuperscriptBox["F", RowBox[
                       {FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]}], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]]}], "-", RowBox[{SubsuperscriptBox[
                      "A", FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubsuperscriptBox["F", RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]}], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(t4 = \(\(FCE[t3]\)/.\ \(
                      \(SUNF[\(a, c, g\)]\) \[Rule] 
                       \(-\(SUNF[\(g, c, a\)]\)\)\)\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                       FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"]], SubsuperscriptBox["F", RowBox[
                       {FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]}], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]]}], "+", RowBox[{SubsuperscriptBox[
                      "A", FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubsuperscriptBox["F", RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]}], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     \(f\_\(gca\)\)}]}], TraditionalForm]], "Output", 
               CellTags -> "FunctionalD"]}, Open]], 
           Cell[TextData[
             {"Since the variational derivative vanishes t4 implies that 0 = \
", Cell[BoxData[\(TraditionalForm\`\(D\_\[Mu] F\_g\%\[Mu]\[Sigma]\)\)]], 
              " ."}], "Text", CellTags -> "FunctionalD"], Cell[TextData[
             StyleBox["Second approach", Rule[FontWeight, "Bold"]]], "Text", 
            CellTags -> "FunctionalD"], Cell["It is of course also possible \
to do the functional deriviate on the S[A] with both field strength tensors \
inserted.", "Text", CellTags -> "FunctionalD"], Cell[CellGroupData[
             {Cell[BoxData[\(S[A]\)], "Input", CellTags -> "FunctionalD"], 
              Cell[BoxData[FormBox[RowBox[{\(-\(1\/4\)\), " ", RowBox[
                    {RowBox[{"(", RowBox[{RowBox[{SubscriptBox["\[PartialD]", 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], "-", 
                         RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{RowBox[
                          {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(f\_\(abc\)\)}]}], ")"}], ".", RowBox[{"(", 
                       RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], "-", 
                         RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{RowBox[
                          {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          \(f\_\(ade\)\)}]}], ")"}]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(r1 = \(FunctionalD[\(\(S[A]\), Ag\)]\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{\(1\/2\), " ", RowBox[{"(", RowBox[
                        {RowBox[{FormBox[SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                          "TraditionalForm"]}], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["g", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}]}], 
                   "-", RowBox[{\(1\/2\), " ", RowBox[{"(", RowBox[
                        {RowBox[{FormBox[SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["g", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}], "+", RowBox[{
                     \(1\/2\), " ", RowBox[{"(", RowBox[{RowBox[{FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                          "TraditionalForm"], FormBox[SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                          "TraditionalForm"]}], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["g", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}]}], 
                   "-", RowBox[{\(1\/2\), " ", RowBox[{"(", RowBox[
                        {RowBox[{FormBox[SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["g", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}], "-", RowBox[{
                     \(1\/4\), " ", RowBox[{SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                        FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                        FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["e", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     RowBox[{SubsuperscriptBox["A", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]], ".", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["e", "TraditionalForm"], 
                          "TraditionalForm"]]}]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{\(1\/4\), " ", 
                     RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"]]}], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     RowBox[{RowBox[{SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["d", 
                          "TraditionalForm"], "TraditionalForm"]]}], ".", 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["e", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell["This is just funcional derivation and partial integration \
and simple contraction of indices. No attempt is made to rename dummy indices \
(since this is difficult in general).", "Text", CellTags -> "FunctionalD"], 
           Cell["With a general replacement rule only valid for commuting \
fields the color indices can be canonicalized a bit more. The idea is to use \
the commutative properties of the vector fields, and canonicalize the color \
indices by a trick. This function will work on any commuting product of \
fields.", "Text", CellTags -> "FunctionalD"], Cell[BoxData[
             \(\(Clear[symfun]\) ;\)], "Input", CellTags -> "FunctionalD"], 
           Cell[BoxData[
             \(\(symfun[\(z_, fieldname_Symbol\)]\) := 
                \(Expand[\(SUNSimplify[
                    \(FixedPoint[\(\(\(
                           Collect2[\(\(
                               \(\(DotSimplify[\(#1/.\(Times \[Rule] Dot\)\)]
                                   \)/.
                                  \(\((
                                   \((\((qi___)\) . 
                                   \(QuantumField[
                                   \(par1___, fieldname, li1_, sui1_\)]\) . 
                                   \(QuantumField[
                                   \(par2___, fieldname, li2_, sui2_\)]\) . 
                                   qf___\ )\) any_)\) \[RuleDelayed] 
                                   \(\(
                                   (\((
                                   qi . 
                                   \(QuantumField[\(par1, A, li1, sui2\)]\) .
                                    \(QuantumField[
                                   \(par2, fieldname, li2, sui1\)]\) . qf\ )\
\) \((any/.\({\(sui1 \[RuleDelayed] sui2\), 
                                   \(sui2 \[RuleDelayed] sui1\)}\))\))\)/;
                                   \(\(
                                   (\(! 
                                   \((\(FreeQ2[\(any, \({sui1, su2}\)\)]\))\)
             \))\) && \(! \((\(OrderedQ[\({sui1, sui2}\)]\))\)\)\)\)\)\)/.
                                \(Dot \[Rule] Times\)\), QuantumField\)]\) &\
\), z, 42\)]\)]\)]\)\)], "Input", CellTags -> "FunctionalD"], 
           Cell[CellGroupData[{Cell[BoxData[\(r2\ =\ \(symfun[\(r1, A\)]\)\)]
                , "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{\(1\/2\), " ", RowBox[{"(", RowBox[
                        {RowBox[{FormBox[SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                          "TraditionalForm"]}], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["g", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}]}], 
                   "-", RowBox[{\(1\/2\), " ", RowBox[{"(", RowBox[
                        {RowBox[{FormBox[SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["g", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}], "+", RowBox[{
                     \(1\/2\), " ", RowBox[{"(", RowBox[{RowBox[{FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Nu]", "TraditionalForm"], "TraditionalForm"]], 
                          "TraditionalForm"], FormBox[SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                          "TraditionalForm"]}], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["g", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}]}], 
                   "-", RowBox[{\(1\/2\), " ", RowBox[{"(", RowBox[
                        {RowBox[{FormBox[SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                         SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["g", "TraditionalForm"], 
                          "TraditionalForm"]]}], ")"}]}], "-", RowBox[{
                     \(1\/2\), " ", SubsuperscriptBox["A", FormBox[FormBox[
                        "\[Sigma]", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"]], " ", RowBox[{SubscriptBox[
                        "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/2\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/2\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/2\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Nu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/2\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Nu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(r3 = \(r2/.\(\[Nu] \[Rule] \[Mu]\)\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{RowBox[{FormBox[SubscriptBox["\[PartialD]", 
                         FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                        SubscriptBox["\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"]}], SubsuperscriptBox["A", 
                      FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["g", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{RowBox[{FormBox[SubscriptBox["\[PartialD]", 
                         FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                        SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]]}], "-", RowBox[{SubsuperscriptBox[
                      "A", FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{"2", " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(3\/4\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[TextData[{"Inspection reveals that still terms are the same. \
Gather the terms with two ", Cell[BoxData[\(TraditionalForm\`\(f\ \)\)]], 
              "'s:"}], "Text", CellTags -> "FunctionalD"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(twof = \(Select[\(r3, \(
                        \(\(Count[\(#, \(SUNF[__]\)\)]\) === 2\) &\)\)]\)\)], 
               "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{\(-\(3\/4\)\), " ", SubsuperscriptBox[
                      "A", FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{\(1\/4\), " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(twofnew = \(\((\(twof \[LeftDoubleBracket] 1 
                          \[RightDoubleBracket]\) + 
                        \((\(twof[\([2]\)]\)/.
                           \({\(b \[RuleDelayed] c\), \(c \[RuleDelayed] b\)}
                            \))\))\)/.\({
                       \(a \[RuleDelayed] c\), \(c \[RuleDelayed] a\)}\)\)\)]\
, "Input", CellTags -> "FunctionalD"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"-", SubsuperscriptBox["A", FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["a", "TraditionalForm"], 
                       "TraditionalForm"]]}], " ", SubsuperscriptBox["A", 
                    FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"], FormBox[FormBox["b", 
                      "TraditionalForm"], "TraditionalForm"]], " ", 
                   SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                      "TraditionalForm"], "TraditionalForm"], FormBox[
                     FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                   " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["e", "TraditionalForm"], 
                       "TraditionalForm"]}]], " ", SubscriptBox["f", 
                    RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(r4\ =\ \(r3 - twof + twofnew\)\)
                ], "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{RowBox[{FormBox[SubscriptBox[
                         "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"], FormBox[SubscriptBox[
                         "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"]}], SubsuperscriptBox["A", 
                      FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["g", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{RowBox[{FormBox[SubscriptBox["\[PartialD]", 
                         FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                        SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]]}], "-", RowBox[{SubsuperscriptBox[
                      "A", FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{"2", " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell["Check that this is now indeed the same as the t4 result from \
the first attempt.", "Text", CellTags -> "FunctionalD"], 
           Cell[CellGroupData[{Cell[BoxData["t4"], "Input", CellTags -> 
                "FunctionalD"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     SubsuperscriptBox["F", RowBox[{FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]}], FormBox[FormBox["g", 
                        "TraditionalForm"], "TraditionalForm"]]}], "+", 
                   RowBox[{SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["F", RowBox[{FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]}], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     \(f\_\(gca\)\)}]}], TraditionalForm]], "Output", 
               CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(w0 = \(\(\(RightPartialD[\[Mu]]\) . 
                       \(FieldStrength[\(\[Mu], \[Sigma], g, \({A, a, b}\), 1
                          \)]\)\) + \(\(QuantumField[
                         \(A, \(LorentzIndex[\[Mu]]\), \(SUNIndex[c]\)\)]\) 
                       \(FieldStrength[\(\[Mu], \[Sigma], a, \({A, b, d}\), 1
                          \)]\) \(SUNF[\(g, c, a\)]\)\)\)\)], "Input", 
               CellTags -> "FunctionalD"], Cell[BoxData[FormBox[
                 RowBox[{RowBox[{SubscriptBox[\(\[PartialD]\&\[RightArrow]\), 
                      FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"]], ".", SubsuperscriptBox["F", 
                      \(\[Mu]\[Sigma]\), RowBox[{"g", FormBox[\({A, a, b}\), 
                         "TraditionalForm"], FormBox["1", 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["F", \(\[Mu]\[Sigma]\), RowBox[
                       {"a", FormBox[\({A, b, d}\), "TraditionalForm"], 
                        FormBox["1", "TraditionalForm"]}]], " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", \(f\_\(gca\)\)}]}], TraditionalForm]], "Output", 
               CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(w1 = \(Explicit[w0]\)\)], 
               "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{SubscriptBox[
                      \(\[PartialD]\&\[RightArrow]\), FormBox[FormBox[
                        "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                     ".", RowBox[{"(", RowBox[{RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["g", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", RowBox[{SubscriptBox[
                          "\[PartialD]", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["g", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{RowBox[
                          {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"]], ".", SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                          SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["g", 
                          "TraditionalForm"], "TraditionalForm"]}]]}]}], 
                       ")"}]}], "-", RowBox[{SubsuperscriptBox["A", FormBox[
                       FormBox["\[Mu]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["c", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     RowBox[{"(", RowBox[{RowBox[{SubscriptBox["\[PartialD]", 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                          FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], "-", 
                         RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], "+", 
                         RowBox[{RowBox[{SubsuperscriptBox["A", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]], ".", 
                          SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"]]}], " ", SubscriptBox["f", 
                          RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                          FormBox["d", "TraditionalForm"], 
                          "TraditionalForm"]}]]}]}], ")"}], " ", SubscriptBox[
                      "f", RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(w2 = \(\(ExpandPartialD[w1]\)/.\(Dot \[Rule] Times\)\)\)], 
               "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{RowBox[{FormBox[SubscriptBox[
                         "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"], FormBox[SubscriptBox[
                         "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"]}], SubsuperscriptBox["A", 
                      FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["g", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{RowBox[{FormBox[SubscriptBox["\[PartialD]", 
                         FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                        SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]]}], "+", RowBox[{SubsuperscriptBox[
                      "A", FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["b", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["d", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(dif1\ =\ \(w2 - r4\)\)], 
               "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"-", RowBox[{"(", RowBox[
                        {RowBox[{FormBox[SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                          "TraditionalForm"]}], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["g", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}]}], 
                   "+", RowBox[{RowBox[{FormBox[SubscriptBox["\[PartialD]", 
                         FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                        SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]]}], "+", RowBox[{RowBox[
                      {FormBox[SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"], FormBox[SubscriptBox[
                         "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"]}], SubsuperscriptBox["A", 
                      FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["g", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{RowBox[{FormBox[SubscriptBox["\[PartialD]", 
                         FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                        SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]]}], "+", RowBox[{SubsuperscriptBox[
                      "A", FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{"2", " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["d", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["e", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["c", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["e", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(dif2 = \(symfun[\(dif1, A\)]\)\)
                ], "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[RowBox[{RowBox[{"-", RowBox[{"(", RowBox[
                        {RowBox[{FormBox[SubscriptBox["\[PartialD]", FormBox[
                          FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                          SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                          "TraditionalForm"]}], SubsuperscriptBox["A", 
                          FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["g", 
                          "TraditionalForm"], "TraditionalForm"]]}], ")"}]}], 
                   "+", RowBox[{RowBox[{FormBox[SubscriptBox["\[PartialD]", 
                         FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                        SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]]}], "+", RowBox[{RowBox[
                      {FormBox[SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"], FormBox[SubscriptBox[
                         "\[PartialD]", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"]], 
                        "TraditionalForm"]}], SubsuperscriptBox["A", 
                      FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["g", 
                        "TraditionalForm"], "TraditionalForm"]]}], "-", 
                   RowBox[{RowBox[{FormBox[SubscriptBox["\[PartialD]", 
                         FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"], FormBox[
                        SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Sigma]", "TraditionalForm"], 
                          "TraditionalForm"]], "TraditionalForm"]}], 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["g", "TraditionalForm"], 
                       "TraditionalForm"]]}], "+", RowBox[{SubsuperscriptBox[
                      "A", FormBox[FormBox["\[Sigma]", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"]], " ", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], 
                         "TraditionalForm"]]}], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[{"2", " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[{"2", " ", 
                     SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["a", "TraditionalForm"], "TraditionalForm"]], 
                     " ", RowBox[{SubscriptBox["\[PartialD]", FormBox[
                         FormBox["\[Sigma]", "TraditionalForm"], 
                         "TraditionalForm"]], SubsuperscriptBox["A", FormBox[
                         FormBox["\[Mu]", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["b", 
                          "TraditionalForm"], "TraditionalForm"]]}], " ", 
                     SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "+", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["d", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}], "-", RowBox[
                    {SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Mu]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["c", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubsuperscriptBox["A", FormBox[FormBox["\[Sigma]", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["d", "TraditionalForm"], "TraditionalForm"]], 
                     " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                        FormBox[FormBox["d", "TraditionalForm"], 
                         "TraditionalForm"]}]], " ", SubscriptBox["f", 
                      RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["c", 
                          "TraditionalForm"], "TraditionalForm"], FormBox[
                         FormBox["g", "TraditionalForm"], 
                         "TraditionalForm"]}]]}]}], TraditionalForm]], 
               "Output", CellTags -> "FunctionalD"]}, Open]], 
           Cell["quod erat demonstrandum.", "Text", CellTags -> 
             "FunctionalD"], Cell[BoxData[
             \(\(Unset[\(s[\[Phi]]\)]\) ; \(Unset[\(S[A]\)]\) ; 
                \(Clear[\(Ag, F1, F2, t1, t2, t3, t4, F, r1, r2, r3, r4, 
                    symfun, twof, twofnew, w0, w1, w2, dif1, dif2, dif3\)]\)\
\)], "Input", CellTags -> "FunctionalD"]}, Open]], 
        Cell[CellGroupData[
          {Cell["Example of funcional differentiation as used in FeynRule", 
            "Subsubsection", CellTags -> "FunctionalD"], 
           Cell["This is a part of the QCD Lagrangian.", "Text", 
            CellTags -> "FunctionalD"], Cell[CellGroupData[{Cell[BoxData[
                \(\((Gstrong * \(\(QuantumField[
                          \(GaugeField,\ \(LorentzIndex[li1]\),\(\ \ \)
                            \(SUNIndex[si2]\)\)]\) .\(\ \ \)
                        \(QuantumField[\(
                           GaugeField,\ \(LorentzIndex[li2]\),\(\ \ \ \)
                            \(SUNIndex[si4]\)\)]\)\ .\(\ \ \)
                        \(QuantumField[\(
                           \(PartialD[\(LorentzIndex[li1]\)]\),\ GaugeField,
                            \(\ \ \ \)\(LorentzIndex[li2]\),\ 
                            \(SUNIndex[si1]\)\)]\)\) *\(\ \ \)
                      \(SUNF[\(\(SUNIndex[si1]\),\ \(SUNIndex[si2]\),\ 
                          \(SUNIndex[si4]\)\)]\))\)/4\)], "Input"], 
              Cell[BoxData[FormBox[RowBox[{\(1\/4\), " ", \(g\_s\), " ", 
                   RowBox[{SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["li1", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["si2", 
                        "TraditionalForm"], "TraditionalForm"]], ".", 
                     SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                      FormBox[FormBox["li2", "TraditionalForm"], 
                       "TraditionalForm"], FormBox[FormBox["si4", 
                        "TraditionalForm"], "TraditionalForm"]], ".", 
                     RowBox[{SubscriptBox["\[PartialD]", FormBox[FormBox[
                          "li1", "TraditionalForm"], "TraditionalForm"]], 
                       SubsuperscriptBox[FormBox["A", "TraditionalForm"], 
                        FormBox[FormBox["li2", "TraditionalForm"], 
                         "TraditionalForm"], FormBox[FormBox["si1", 
                          "TraditionalForm"], "TraditionalForm"]]}]}], " ", 
                   SubscriptBox["f", RowBox[{FormBox[FormBox["si1", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["si2", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["si4", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], 
               "Output"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FunctionalD[\(%,\ \({\(
                         \(QuantumField[\(GaugeField, \({\[Mu]}\), \({a}\)\)]
                           \)[p]\),\ \(\(
                           QuantumField[\(GaugeField, \({\[Nu]}\), \({b}\)\)]
                           \)[q]\),\ \(\(
                           QuantumField[\(GaugeField, \({\[Rho]}\), \({c}\)\)
                            ]\)[r]\)}\)\)]\)], "Input", CellTags -> 
                "FunctionalD"], Cell[BoxData[FormBox[RowBox[{\(1\/4\), " ", 
                   \(g\_s\), " ", RowBox[{"(", RowBox[{RowBox[{RowBox[
                          {"(", RowBox[{\(g\^\(li1\[Mu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si2", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(g\^\(li2\[Nu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "b", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si4", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(-\[ImaginaryI]\), " ", 
                          SuperscriptBox[FormBox["r", "TraditionalForm"], 
                          FormBox[FormBox["li1", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(li2\[Rho]\)\), 
                          " ", SubscriptBox["\[Delta]", RowBox[{FormBox[
                          FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["si1", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], 
                          ")"}]}], "+", RowBox[{RowBox[{"(", RowBox[{
                          \(g\^\(li1\[Mu]\)\), " ", SubscriptBox["\[Delta]", 
                          RowBox[{FormBox[FormBox["a", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["si2", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], ")"}], 
                         ".", RowBox[{"(", RowBox[{\(g\^\(li2\[Rho]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "c", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si4", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(-\[ImaginaryI]\), " ", 
                          SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["li1", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(li2\[Nu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "b", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si1", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}]}], "+", RowBox[
                        {RowBox[{"(", RowBox[{\(g\^\(li1\[Nu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "b", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si2", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(g\^\(li2\[Mu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si4", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(-\[ImaginaryI]\), " ", 
                          SuperscriptBox[FormBox["r", "TraditionalForm"], 
                          FormBox[FormBox["li1", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(li2\[Rho]\)\), 
                          " ", SubscriptBox["\[Delta]", RowBox[{FormBox[
                          FormBox["c", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["si1", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], 
                          ")"}]}], "+", RowBox[{RowBox[{"(", RowBox[{
                          \(g\^\(li1\[Nu]\)\), " ", SubscriptBox["\[Delta]", 
                          RowBox[{FormBox[FormBox["b", "TraditionalForm"], 
                          "TraditionalForm"], FormBox[FormBox["si2", 
                          "TraditionalForm"], "TraditionalForm"]}]]}], ")"}], 
                         ".", RowBox[{"(", RowBox[{\(g\^\(li2\[Rho]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "c", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si4", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(-\[ImaginaryI]\), " ", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["li1", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(li2\[Mu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si1", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}]}], "+", RowBox[
                        {RowBox[{"(", RowBox[{\(g\^\(li1\[Rho]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "c", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si2", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(g\^\(li2\[Mu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si4", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(-\[ImaginaryI]\), " ", 
                          SuperscriptBox[FormBox["q", "TraditionalForm"], 
                          FormBox[FormBox["li1", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(li2\[Nu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "b", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si1", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}]}], "+", RowBox[
                        {RowBox[{"(", RowBox[{\(g\^\(li1\[Rho]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "c", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si2", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(g\^\(li2\[Nu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "b", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si4", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}], ".", RowBox[
                          {"(", RowBox[{\(-\[ImaginaryI]\), " ", 
                          SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["li1", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(li2\[Mu]\)\), " ", 
                          SubscriptBox["\[Delta]", RowBox[{FormBox[FormBox[
                          "a", "TraditionalForm"], "TraditionalForm"], 
                          FormBox[FormBox["si1", "TraditionalForm"], 
                          "TraditionalForm"]}]]}], ")"}]}]}], ")"}], " ", 
                   SubscriptBox["f", RowBox[{FormBox[FormBox["si1", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["si2", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["si4", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FunctionalD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[\(\(Calc[\(%//Calc\)]\)//Factor\)]
                , "Input", CellTags -> "FunctionalD"], Cell[BoxData[
                FormBox[RowBox[{\(1\/4\), " ", "\[ImaginaryI]", " ", \(g\_s\)
                   , " ", RowBox[{"(", RowBox[{RowBox[{SuperscriptBox[
                          FormBox["q", "TraditionalForm"], FormBox[FormBox[
                          "\[Mu]", "TraditionalForm"], "TraditionalForm"]], 
                         " ", \(g\^\(\[Nu]\[Rho]\)\)}], "-", RowBox[
                        {SuperscriptBox[FormBox["r", "TraditionalForm"], 
                          FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                          "TraditionalForm"]], " ", \(g\^\(\[Nu]\[Rho]\)\)}], 
                       "-", RowBox[{\(g\^\(\[Mu]\[Rho]\)\), " ", 
                         SuperscriptBox[FormBox["p", "TraditionalForm"], 
                          FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "+", RowBox[{
                         \(g\^\(\[Mu]\[Rho]\)\), " ", SuperscriptBox[FormBox[
                          "r", "TraditionalForm"], FormBox[FormBox["\[Nu]", 
                          "TraditionalForm"], "TraditionalForm"]]}], "+", 
                       RowBox[{\(g\^\(\[Mu]\[Nu]\)\), " ", SuperscriptBox[
                          FormBox["p", "TraditionalForm"], FormBox[FormBox[
                          "\[Rho]", "TraditionalForm"], 
                          "TraditionalForm"]]}], "-", RowBox[{
                         \(g\^\(\[Mu]\[Nu]\)\), " ", SuperscriptBox[FormBox[
                          "q", "TraditionalForm"], FormBox[FormBox["\[Rho]", 
                          "TraditionalForm"], "TraditionalForm"]]}]}], ")"}], 
                   " ", SubscriptBox["f", RowBox[{FormBox[FormBox["a", 
                        "TraditionalForm"], "TraditionalForm"], FormBox[
                       FormBox["b", "TraditionalForm"], "TraditionalForm"], 
                      FormBox[FormBox["c", "TraditionalForm"], 
                       "TraditionalForm"]}]]}], TraditionalForm]], "Output", 
               CellTags -> "FunctionalD"]}, Open]]}, Open]], 
        Cell["FV", "ObjectName", CellTags -> "FV"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FV"], Cell[TextData[{"FV[", 
              StyleBox["p", Rule[FontSlant, "Italic"]], ", ", Cell[BoxData[
                \(TraditionalForm\`\[Mu]\)]], 
              "] is the four-dimensional vector ", Cell[BoxData[
                \(TraditionalForm\`\(p\^\[Mu]\)\)]], ". "}], "Text", 
            CellTags -> "FV"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["FCE", RuleDelayed[ButtonData, "FCE"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCE"]], 
              ", ", 
              ButtonBox["FCI", RuleDelayed[ButtonData, "FCI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCI"]], 
              ", ", 
              ButtonBox["FVD", RuleDelayed[ButtonData, "FVD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FVD"]], 
              ", ", 
              ButtonBox["FourVector", RuleDelayed[ButtonData, "FourVector"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FourVector"]], ", ", 
              ButtonBox["Pair", RuleDelayed[ButtonData, "Pair"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Pair"]], 
              "."}], "Text", CellTags -> "FV"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FV"], Cell[CellGroupData[{Cell[BoxData[
                \(FV[\(p, \[Mu]\)]\)], "Input", CellTags -> "FV"], 
              Cell[BoxData[\(TraditionalForm\`\(p\^\[Mu]\)\)], "Output", 
               CellTags -> "FV"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FV[\(\(p - q\), \[Mu]\)]\)], "Input", CellTags -> "FV"], 
              Cell[BoxData[FormBox[SuperscriptBox[FormBox[\(p - q\), 
                   "TraditionalForm"], "\[Mu]"], TraditionalForm]], "Output", 
               CellTags -> "FV"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(FV[\(p, \[Mu]\)]\)//StandardForm\)], "Input", CellTags -> 
                "FV"], Cell[BoxData[\(FV[\(p, \[Mu]\)]\)], "Output", 
               CellTags -> "FV"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(FCI[\(FV[\(p, \[Mu]\)]\)]\)//StandardForm\)], "Input", 
               CellTags -> "FV"], Cell[BoxData[
                \(Pair[\(\(LorentzIndex[\[Mu]]\), \(Momentum[p]\)\)]\)], 
               "Output", CellTags -> "FV"]}, Open]], Cell["There is no \
special function to expand momenta in FV; ExpandScalarProduct does the job.", 
            "Text", CellTags -> "FV"], Cell[CellGroupData[{Cell[BoxData[
                \(ExpandScalarProduct[\(FV[\(\(p - q\), \[Mu]\)]\)]\)], 
               "Input", CellTags -> "FV"], Cell[BoxData[FormBox[
                 SuperscriptBox[FormBox[\(p - q\), "TraditionalForm"], 
                  "\[Mu]"], TraditionalForm]], "Output", CellTags -> "FV"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(StandardForm[%]\)], 
               "Input", CellTags -> "FV"], Cell[BoxData[
                \(FV[\(\(p - q\), \[Mu]\)]\)], "Output", CellTags -> "FV"]}, 
             Open]]}, Open]], Cell["FVD", "ObjectName", CellTags -> "FVD"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "FVD"], Cell[TextData[{"FVD[", 
              StyleBox["p", Rule[FontSlant, "Italic"]], ", ", Cell[BoxData[
                \(TraditionalForm\`\[Mu]\)]], 
              "] is the D-dimensional vector ", 
              StyleBox["p", Rule[FontSlant, "Italic"]], 
              " with Lorentz index ", Cell[BoxData[\(TraditionalForm\`\[Mu]\)]
                ], "."}], "Text", CellTags -> "FVD"], 
           Cell[TextData[{"See also: ", " ", 
              ButtonBox["FCE", RuleDelayed[ButtonData, "FCE"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCE"]], 
              ", ", 
              ButtonBox["FCI", RuleDelayed[ButtonData, "FCI"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FCI"]], 
              ", ", 
              ButtonBox["FV", RuleDelayed[ButtonData, "FV"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FV"]], 
              ", ", 
              ButtonBox["FourVector", RuleDelayed[ButtonData, "FourVector"], 
                Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "FourVector"]], ", ", 
              ButtonBox["Pair", RuleDelayed[ButtonData, "Pair"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Pair"]], 
              "."}], "Text", CellTags -> "FVD"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "FVD"], Cell[CellGroupData[{Cell[BoxData[
                \(FVD[\(p, \[Mu]\)]\)], "Input", CellTags -> "FVD"], 
              Cell[BoxData[\(TraditionalForm\`\(p\^\[Mu]\)\)], "Output", 
               CellTags -> "FVD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(FVD[\(\(p - q\), \[Mu]\)]\)], "Input", CellTags -> "FVD"], 
              Cell[BoxData[FormBox[SuperscriptBox[FormBox[\(p - q\), 
                   "TraditionalForm"], "\[Mu]"], TraditionalForm]], "Output", 
               CellTags -> "FVD"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(FVD[\(p, \[Mu]\)]\)//StandardForm\)], "Input", 
               CellTags -> "FVD"], Cell[BoxData[\(FVD[\(p, \[Mu]\)]\)], 
               "Output", CellTags -> "FVD"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(FCI[\(FVD[\(p, \[Mu]\)]\)]\)//StandardForm\)], "Input", 
               CellTags -> "FVD"], Cell[BoxData[
                \(Pair[\(\(LorentzIndex[\(\[Mu], D\)]\), 
                     \(Momentum[\(p, D\)]\)\)]\)], "Output", CellTags -> 
                "FVD"]}, Open]], Cell[
            "There is no special function to expand momenta in FVD.", "Text", 
            CellTags -> "FVD"], Cell[CellGroupData[{Cell[BoxData[
                \(ExpandScalarProduct[\(FVD[\(\(p - q\), \[Mu]\)]\)]\)], 
               "Input", CellTags -> "FVD"], Cell[BoxData[FormBox[
                 SuperscriptBox[FormBox[\(p - q\), "TraditionalForm"], 
                  "\[Mu]"], TraditionalForm]], "Output", CellTags -> "FVD"]}, 
             Open]], Cell[CellGroupData[{Cell[BoxData[\(StandardForm[%]\)], 
               "Input", CellTags -> "FVD"], Cell[BoxData[
                \(FVD[\(\(p - q\), \[Mu]\)]\)], "Output", CellTags -> 
                "FVD"]}, Open]]}, Open]], Cell["GA", "ObjectName", 
         CellTags -> "GA"], Cell[CellGroupData[{Cell["Description", 
            "Subsubsection", CellTags -> "GA"], 
           Cell[TextData[{"GA[", Cell[BoxData[\(TraditionalForm\`\[Mu]\)]], 
              "] can be used as input for a 4-dimensional ", Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(\[Mu]\ \)\)]], 
              "and is transformed into DiracGamma[LorentzIndex[", 
              Cell[BoxData[\(TraditionalForm\`\[Mu]\)]], 
              "]] by FeynCalcInternal (=FCI).GA[", Cell[BoxData[
                \(TraditionalForm\`\(\[Mu], \[Nu],\)\)]], 
              " ...] is a short form for GA[", Cell[BoxData[
                \(TraditionalForm\`\[Mu]\)]], "].GA[", Cell[BoxData[
                \(TraditionalForm\`\[Nu]\)]], "]. ... ."}], "Text", 
            CellTags -> "GA"], Cell[TextData[{"See also: ", " ", 
              ButtonBox["DiracMatrix", RuleDelayed[ButtonData, 
                 "DiracMatrix"], Rule[ButtonStyle, "AddOnsLink"], 
                Rule[ButtonNote, "DiracMatrix"]], ", ", 
              ButtonBox["GAD", RuleDelayed[ButtonData, "GAD"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "GAD"]], 
              ", ", 
              ButtonBox["GS", RuleDelayed[ButtonData, "GS"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "GS"]], 
              "."}], "Text", CellTags -> "GA"]}, Open]], 
        Cell[CellGroupData[{Cell["Examples", "Subsubsection", 
            CellTags -> "GA"], Cell[CellGroupData[{Cell[BoxData[\(GA[\[Mu]]\)]
                , "Input", CellTags -> "GA"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu]\)\)], "Output", 
               CellTags -> "GA"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(\(GA[\(\[Mu], \[Nu]\)]\) - \(GA[\(\[Nu], \[Mu]\)]\)\)], 
               "Input", CellTags -> "GA"], Cell[BoxData[
                \(TraditionalForm\`\(\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu]\) - 
                     \(\[Gamma]\^\[Nu] . \[Gamma]\^\[Mu]\)\)\)], "Output", 
               CellTags -> "GA"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(FCI[\(GA[\[Mu]]\)]\)]\)], "Input", 
               CellTags -> "GA"], Cell[BoxData[
                \(DiracGamma[\(LorentzIndex[\[Mu]]\)]\)], "Output", 
               CellTags -> "GA"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\)], "Input", 
               CellTags -> "GA"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Mu] . \[Gamma]\^\[Nu] . 
                     \[Gamma]\^\[Rho] . \[Gamma]\^\[Sigma]\)\)], "Output", 
               CellTags -> "GA"]}, Open]], Cell[CellGroupData[{Cell[BoxData[
                \(StandardForm[\(GA[\(\[Mu], \[Nu], \[Rho], \[Sigma]\)]\)]\)]\
, "Input", CellTags -> "GA"], Cell[BoxData[
                \(\(GA[\[Mu]]\) . \(GA[\[Nu]]\) . \(GA[\[Rho]]\) . 
                   \(GA[\[Sigma]]\)\)], "Output", CellTags -> "GA"]}, Open]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(GA[\[Alpha]]\) . \((\(GS[p]\) + m)\) . \(GA[\[Beta]]\)\)]\
, "Input", CellTags -> "GA"], Cell[BoxData[
                \(TraditionalForm\`\(\[Gamma]\^\[Alpha] . 
                     \((m + \(\[Gamma] \[CenterDot] p\))\) . 
                     \[Gamma]\^\[Beta]\)\)], "Output", CellTags -> "GA"]}, 
             Open]]}, Open]], Cell["GAD", "ObjectName", CellTags -> "GAD"], 
        Cell[CellGroupData[{Cell["Description", "Subsubsection", 
            CellTags -> "GAD"], Cell[TextData[{"GAD[", Cell[BoxData[
                \(TraditionalForm\`\[Mu]\)]], 
              "] can be used as input for a D-dimensional ", Cell[BoxData[
                \(TraditionalForm\`\[Gamma]\_\(\[Mu]\ \)\)]], 
              "and is transformed into DiracGamma[LorentzIndex[", 
              Cell[BoxData[\(TraditionalForm\`\[Mu]\)]], 
              ",D],D] by FeynCalcInternal (=FCI).GAD[", Cell[BoxData[
                \(TraditionalForm\`\(\[Mu], \[Nu],\ ...\)\)]], 
              "] is a short form for GAD[", Cell[BoxData[
                \(TraditionalForm\`\[Mu]\)]], "].GAD[", Cell[BoxData[
                \(TraditionalForm\`\[Nu]\)]], "]. ..