(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    128290,       4612]
NotebookOptionsPosition[    101520,       3762]
NotebookOutlinePosition[    115584,       4185]
CellTagsIndexPosition[    115076,       4166]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["FeynCalc 6.0", "Title",
 TextAlignment->Center],

Cell["Tools for quantum field theory calculations", "Subtitle",
 TextAlignment->Center],

Cell[TextData[StyleBox["Short manual",
 FontWeight->"Bold"]], "Subtitle",
 PageBreakBelow->True,
 TextAlignment->Center],

Cell["Rolf Mertig and Frederik Orellana", "Subsubtitle",
 TextAlignment->Center],

Cell[TextData[{
 "HTML version: ",
 ButtonBox["http://www.feyncalc.org/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feyncalc.org/"], None},
  ButtonNote->"http://www.feyncalc.org/"]
}], "Subsubtitle",
 TextAlignment->Center],

Cell[BoxData[
 ButtonBox[
  RowBox[{
  "Click", " ", "to", " ", "save", " ", "this", " ", "notebook", " ", 
   "without", " ", "cache", " ", "and", " ", "FrontEndVersion", " ", "info"}],
  
  ButtonFunction:>(Module[{$CellContext`fn}, SetDirectory[
      DirectoryName[$CellContext`fn = ToFileName[
         ReplaceAll["FileName", 
          NotebookInformation[
           InputNotebook[]]]]]]; $CellContext`newfn = 
     StringReplace[$CellContext`fn, ".nb" -> "NoCache.nb"]; 
    If[FileNames[$CellContext`newfn] =!= {}, 
      DeleteFile[$CellContext`newfn]]; Put[
      ReplaceAll[
       NotebookGet[
        InputNotebook[]], {
       Condition[FrontEndVersion -> Pattern[$CellContext`v, 
            Blank[]], Head[$CellContext`v] == String] :> Sequence[], 
        Condition[CellLabel -> Pattern[$CellContext`v, 
            Blank[]], Head[$CellContext`v] == String] :> Sequence[]}], 
      "fcr.nb"]; CopyFile["fcr.nb", $CellContext`newfn]; 
    DeleteFile["fcr.nb"]]),
  Evaluator->Automatic]], NotebookDefault,
 Active->True,
 CellTags->"ClickSave"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 PageBreakAbove->True,
 CellTags->{"Short Overview", "intro"}],

Cell[TextData[{
 "FeynCalc is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package for algebraic calculations in high energy physics. It provides \
tools for Lorentz structure manipulations, Dirac algebra manipulations, color \
factor calculations, Feynman rule derivation, Feynman loop integral \
calculations (e.g. Passarino-Veltman reduction) and noncommutative algebra \
calculations, as well as various tabulations of Feynman parameter integrals, \
Mellin ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["transforms", 
    ButtonBox["\[Dagger]",
     BaseStyle->"Hyperlink",
     ButtonData:>"introfoot"]], TraditionalForm]]],
 ", convolutions, lagrangians and Feynman rules. Also, translation facilities \
are provided to change the FeynCalc syntax to and from FORM syntax and to \
generate FORTRAN code."
}], "Text",
 CellTags->"intro"],

Cell[TextData[{
 "Some functions for input of objects like ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["p", "\[Mu]"], ",", 
    SuperscriptBox["\[Gamma]", "\[Nu]"], ",", 
    SuperscriptBox["g", 
     RowBox[{"\[Mu]", " ", "\[Nu]"}]], ",", " ", 
    SuperscriptBox["\[CurlyEpsilon]", 
     RowBox[{"\[Mu]", " ", "\[Nu]", " ", "\[Rho]", " ", "\[Sigma]"}]], ",", 
    " ", 
    RowBox[{"etc", "."}]}], TraditionalForm]]],
 " (abbreviations in parentheses) are:"
}], "Text",
 CellTags->"intro"],

Cell[TextData[{
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix"],
 " (",
 ButtonBox["GA",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GA"],
 "), ",
 ButtonBox["DiracSlash",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSlash"],
 " (",
 ButtonBox["GS",
  BaseStyle->"AddOnsLink",
  ButtonData:>"GS"],
 "), ",
 ButtonBox["FourVector",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FourVector",
  ButtonNote->"FourVector"],
 " (",
 ButtonBox["FV",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FV"],
 "), ",
 ButtonBox["LeviCivita",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LeviCivita"],
 " (",
 ButtonBox["LC",
  BaseStyle->"AddOnsLink",
  ButtonData:>"LC"],
 "), ",
 ButtonBox["MetricTensor",
  BaseStyle->"AddOnsLink",
  ButtonData:>"MetricTensor"],
 " (",
 ButtonBox["MT",
  BaseStyle->"AddOnsLink",
  ButtonData:>"MT"],
 "), ",
 ButtonBox["Spinor",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Spinor"],
 ", ",
 ButtonBox["SUNDelta",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNDelta"],
 ", ",
 ButtonBox["SUNF",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNF"],
 ", ",
 ButtonBox["ScalarProduct",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ScalarProduct"],
 " (",
 ButtonBox["SP",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SP"],
 "). "
}], "Text"],

Cell["Some functions for manipulations are:", "Text",
 CellTags->"intro"],

Cell[TextData[{
 ButtonBox["Contract",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Contract"],
 ", ",
 ButtonBox["Tr",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Tr"],
 ", ",
 ButtonBox["DiracSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSimplify"],
 ", ",
 ButtonBox["DiracTrick",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracTrick"],
 ", ",
 ButtonBox["Calc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Calc"],
 ", ",
 ButtonBox["Convolute",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Convolute"],
 ", ",
 ButtonBox["FeynRule",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynRule"],
 ", ",
 ButtonBox["Integrate2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Integrate2"],
 ", ",
 ButtonBox["FeynCalc2FORM",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FeynCalc2FORM"],
 ", ",
 ButtonBox["PaVeReduce",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVeReduce"],
 " ,",
 ButtonBox["SimplifyPolyLog",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SimplifyPolyLog"],
 " , ",
 ButtonBox["SUNSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"SUNSimplify"],
 " , ",
 ButtonBox["Isolate",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Isolate"],
 " , ",
 ButtonBox["Collect2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Collect2"],
 " , ",
 ButtonBox["OneLoopSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoopSimplify"],
 ", ",
 ButtonBox["Series2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Series2",
  ButtonNote->"Series2"],
 " , ",
 ButtonBox["ScalarProductCancel",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ScalarProductCancel"],
 "."
}], "Text",
 CellTags->"intro"],

Cell["Some functions for Feyman loop integral manipulations:", "Text",
 CellTags->"intro"],

Cell[TextData[{
 ButtonBox["OneLoop",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoop"],
 ", ",
 ButtonBox["OneLoopSimplify",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoopSimplify"],
 " and ",
 ButtonBox["PaVeReduce",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVeReduce"],
 " ."
}], "Text",
 CellTags->"intro"],

Cell[TextData[{
 "FeynCalc (>4.2) is still compatible with FeynArts (>2.2) if the FeynArts \
function ToFA1Convention is used on the generated amplitudes. While ",
 ButtonBox["OneLoop",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoop"],
 " and ",
 ButtonBox["OneLoopSum",
  BaseStyle->"AddOnsLink",
  ButtonData:>"OneLoopSum"],
 "  work fine for not too complicated self-energy, triangle and box diagrams, \
the reader should be aware of the package ",
 ButtonBox["FormCalc",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feynarts.de/formcalc/"], None}],
 " by Thomas Hahn, which is more efficient for the adventurous researcher \
calculating thousands of diagrams, e.g. involving four external gauge bosons. \
Notice however that FormCalc does not reduce the Passarino-Veltman integrals \
to scalar integrals. Also, FormCalc is limited to the 't Hooft Feynman gauge. \
FeynCalc provides algebraic redution of Passarino-Veltman integrals to scalar \
integrals via the function ",
 ButtonBox["PaVeReduce",
  BaseStyle->"AddOnsLink",
  ButtonData:>"PaVeReduce"],
 " ."
}], "Text",
 CellTags->"intro"],

Cell["\<\
For more detailed information on FeynCalc functions, use the help system or \
consult the source code in the file \"FeynCalc.m\" in the directory \
\"HighEnergyPhysics\" and the further packages in the sub-directories \
\"fctools\", \"fctables\" and others. A complete list of FeynCalc objects is \
stored in the variable $FeynCalcStuff. Not all functions are equally well \
documented in this notebook. Some are very special ones (e.g. for tools for \
2-loop QCD diagrams originating in twist-2 OPE), some are still experimental.\
\
\>", "Text",
 CellTags->"intro"],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Gamma]", "5"], TraditionalForm]]],
 "scheme used in OneLoop is the naive one, i.e., ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["\[Gamma]", "5"], ",", 
       SuperscriptBox["\[Gamma]", "\[Mu]"]}]}], ")"}], "=", "0"}], 
   TraditionalForm]]],
 " in 4 and D dimensions. See also ",
 ButtonBox["ToLarin",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ToLarin"]
}], "Text",
 CellTags->"intro"],

Cell["The metric used is the one from Bjorken and Drell (+---).", "Text",
 CellTags->"intro"],

Cell[TextData[{
 "For suggestions and bug reports please see ",
 ButtonBox["http://www.feyncalc.org/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feyncalc.org/"], None}],
 "."
}], "Text",
 CellTags->"intro"],

Cell[TextData[{
 "On a Pentium II 300 MHz computer with 128 MB of RAM running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 3.0 for Linux, this noteboook needs less than 15 minutes to evaluate, not \
exceeding 16 MB of memory usage."
}], "Text",
 CellTags->"intro"],

Cell[TextData[{
 "\[Dagger] Mellin transforms (e.g. all integrals - except 57,58 and 59, and \
correcting a minor misprint in 14) of Appendix 7 from ",
 ButtonBox["hep-ph/9810241",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://xxx.lanl.gov/abs/hep-ph/9810241"], None}],
 " are tabulated in ",
 ButtonBox["Integrate2.",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Integrate2"]
}], "SmallText",
 CellTags->{"intro", "introfoot"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Starting FeynCalc", "Section",
 CellTags->{"Load FeynCalc", "start"}],

Cell[TextData[{
 "If the directory \"HighEnergyPhysics\" has been put in the directory \
\"Applications\" in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation tree, you should be able to load FeynCalc from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session with no further ado."
}], "Text",
 CellTags->"start"],

Cell[BoxData[
 RowBox[{"<<", "HighEnergyPhysics`FeynCalc`"}]], "Input",
 CellTags->"start",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Date", "[", "]"}], ",", "$Version", ",", "$FeynCalcVersion"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "2007", ",", "5", ",", "9", ",", "15", ",", "32", ",", 
      "56.787324`8.50682637770895"}], "}"}], 
    ",", "\<\"6.0 for Linux x86 (64-bit) (March 26, 2007)\"\>", 
    ",", "\<\"6.0.0\"\>"}], "}"}], TraditionalForm]], "Output",
 CellLabel->"Out[2]="]
}, Open  ]],

Cell["This loads FeynCalc.", "MathCaption",
 CellTags->"start"],

Cell[TextData[{
 "You can also put this line into your \"init.m\" file. This will cause \
automatic loading of FeynCalc on every ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " startup."
}], "Text",
 CellTags->"start"],

Cell[TextData[{
 "By loading FeynCalc the setting of the default output format type is \
automatically set to TraditionalForm. You might want to reverse this after \
quitting FeynCalc by clicking on the ",
 StyleBox["Cell", "TextNormal",
  FontWeight->"Bold"],
 " menu, then go to the ",
 StyleBox["Default Output Format Type ", "TextNormal",
  FontWeight->"Bold"],
 "item and select ",
 StyleBox["StandardForm",
  FontWeight->"Bold"],
 ", or by evaluating"
}], "Text",
 CellTags->"start"],

Cell[BoxData[
 StyleBox[
  RowBox[{"SetOptions", "[", 
   RowBox[{"$FrontEnd", ",", 
    RowBox[{"\"\<CommonDefaultFormatTypes\>\"", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Output\>\"", "\[Rule]", "StandardForm"}], "}"}]}]}], "]"}],
   "Input"]], "Input",
 CellTags->"start",
 CellLabel->"In[3]:="],

Cell["This sets the default output form to StandardForm.", "MathCaption",
 CellTags->"start"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"B0", "[", 
   RowBox[{"p", ",", 
    RowBox[{"m1", "^", "2"}], ",", 
    RowBox[{"m2", "^", "2"}]}], "]"}], "Input"]], "Input",
 CellTags->"start",
 CellLabel->"In[4]:="],

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"p", ",", 
   SuperscriptBox["m1", "2"], ",", 
   SuperscriptBox["m2", "2"]}], "]"}]], "Output",
 CellTags->"start",
 CellLabel->"Out[4]="]
}, Open  ]],

Cell["Now FeynCalc functions, like e.g. B0, are not typeset.", "MathCaption",
 CellTags->"start"],

Cell[BoxData[
 StyleBox[
  RowBox[{"SetOptions", "[", 
   RowBox[{"$FrontEnd", ",", 
    RowBox[{"\"\<CommonDefaultFormatTypes\>\"", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Output\>\"", "\[Rule]", "TraditionalForm"}], "}"}]}]}], 
   "]"}], "Input"]], "Input",
 CellTags->"start",
 CellLabel->"In[5]:="],

Cell["This sets the default output form to TraditionalForm.", "MathCaption",
 CellTags->"start"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"B0", "[", 
   RowBox[{"p", ",", 
    RowBox[{"m1", "^", "2"}], ",", 
    RowBox[{"m2", "^", "2"}]}], "]"}], "Input"]], "Input",
 CellTags->"start",
 CellLabel->"In[6]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["B", "0"], "(", "p", ",", 
   SuperscriptBox["m1", "2"], ",", 
   SuperscriptBox["m2", "2"], ")"}], TraditionalForm]], "Output",
 CellTags->"start",
 CellLabel->"Out[6]="]
}, Open  ]],

Cell["Now FeynCalc functions, like e.g. B0, are again typeset.", "MathCaption",
 CellTags->"start"],

Cell[BoxData[{
 RowBox[{"m1", "/:", 
  RowBox[{"MakeBoxes", "[", 
   RowBox[{"m1", ",", "TraditionalForm"}], "]"}], ":=", 
  RowBox[{"InterpretationBox", "[", 
   RowBox[{
    RowBox[{"SubscriptBox", "[", 
     RowBox[{"m", ",", "1"}], "]"}], ",", "m1"}], "]"}]}], "\n", 
 RowBox[{"m2", "/:", 
  RowBox[{"MakeBoxes", "[", 
   RowBox[{"m2", ",", "TraditionalForm"}], "]"}], ":=", 
  RowBox[{"InterpretationBox", "[", 
   RowBox[{
    RowBox[{"SubscriptBox", "[", 
     RowBox[{"m", ",", "2"}], "]"}], ",", "m2"}], "]"}]}]}], "Input",
 CellTags->"start",
 CellLabel->"In[7]:="],

Cell[TextData[{
 "This defines additional typesetting rules for m",
 StyleBox["1",
  FontFamily->"Courier"],
 " and m",
 StyleBox["2",
  FontFamily->"Courier"],
 " for the output format type TraditionalForm."
}], "MathCaption",
 CellTags->"start"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"B0", "[", 
   RowBox[{"p", ",", 
    RowBox[{"m1", "^", "2"}], ",", 
    RowBox[{"m2", "^", "2"}]}], "]"}], "Input"]], "Input",
 CellTags->"start",
 CellLabel->"In[9]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["B", "0"], "(", "p", ",", 
   SuperscriptBox[
    InterpretationBox[
     SubscriptBox["Global`m", "1"],
     $CellContext`m1], "2"], ",", 
   SuperscriptBox[
    InterpretationBox[
     SubscriptBox["Global`m", "2"],
     $CellContext`m2], "2"], ")"}], TraditionalForm]], "Output",
 CellTags->"start",
 CellLabel->"Out[9]="]
}, Open  ]],

Cell[TextData[{
 "Evaluating m",
 StyleBox["1",
  FontFamily->"Courier"],
 " and m",
 StyleBox["2",
  FontFamily->"Courier"],
 " now returns formatted TraditionalForm output."
}], "MathCaption",
 CellTags->"start"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "StandardForm"}]], "Input",
 CellTags->"start",
 CellLabel->"In[10]:="],

Cell[BoxData[
 RowBox[{"B0", "[", 
  RowBox[{"p", ",", 
   SuperscriptBox["m1", "2"], ",", 
   SuperscriptBox["m2", "2"]}], "]"}]], "Output",
 CellTags->"start",
 CellLabel->"Out[10]//StandardForm="]
}, Open  ]],

Cell["\<\
Enforcing StandardForm gives 'raw' output, usable for copying, pasting and \
re-evaluating.\
\>", "MathCaption",
 CellTags->"start"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extra subpackages", "Section",
 PageBreakAbove->True,
 CellTags->"About Extras"],

Cell[TextData[{
 "The directory  \"HighEnergyPhysics\" contains various files and \
subdirectories belonging to third-party packages which are not necessary to \
run 'standard' FeynCalc calculations and which do not use the autoloading \
conventions of FeynCalc. These packages are not initialized by default when \
starting FeynCalc. Loading them can be switched on and off by setting \
appropiate variables to False or True before ",
 ButtonBox["loading FeynCalc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Load FeynCalc",
  ButtonNote->"start"],
 ". "
}], "Text",
 CellTags->"About Extras"],

Cell[BoxData[
 FormBox[
  StyleBox[
   FrameBox[
    StyleBox[GridBox[{
       {
        StyleBox["$LoadTARCER",
         FontFamily->"Courier"], 
        RowBox[{
        "Specifies", " ", "if", " ", "TARCER", " ", "should", " ", "be", " ", 
         "loaded", " ", "by", " ", "FeynCalc"}]},
       {
        StyleBox["$LoadPhi",
         FontFamily->"Courier"], 
        RowBox[{
        "Specifies", " ", "if", " ", "PHI", " ", "should", " ", "be", " ", 
         "loaded", " ", "by", " ", "FeynCalc"}]},
       {
        StyleBox["$LoadFeynArts",
         FontFamily->"Courier"], 
        RowBox[{"Specifies", " ", "if", " ", 
         SuperscriptBox["FeynArts", 
          ButtonBox["\[Dagger]",
           BaseStyle->"Hyperlink",
           ButtonData:>"extrafoot"]], " ", "should", " ", "be", " ", "loaded",
          " ", "by", " ", "FeynCalc"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
     GridBoxOptions->{
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
       "RowsIndexed" -> {}}}]], "2ColumnBox"], TraditionalForm]], "Text",
 Background->None,
 CellTags->"About Extras"],

Cell["Variables switching loading of extra packages on and off. ", "Caption",
 CellTags->"About Extras"],

Cell[CellGroupData[{

Cell[TextData[{
 "TARCER -\n",
 "A ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program for the reduction of two-loop propagator integrals"
}], "Subsection",
 CellTags->"tarcer"],

Cell["R. Mertig, R. Scharf", "InspectorLevel2",
 CellTags->"tarcer"],

Cell[TextData[{
 ButtonBox["hep-ph/9801383",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://xxx.lanl.gov/abs/hep-ph/9801383"], None}],
 " on the Los Alamos preprint server"
}], "Text",
 CellDingbat->"\[GrayCircle]",
 CellTags->"tarcer"],

Cell[TextData[{
 "published in ",
 StyleBox["Comp. Phys. Comm.",
  CellDingbat->"\[GrayCircle]"],
 " ",
 StyleBox["111",
  FontWeight->"Bold"],
 " (1998) 265-173"
}], "Text",
 CellDingbat->"\[GrayCircle]",
 CellTags->"tarcer"],

Cell["Loading TARCER", "Subsubsection",
 CellTags->"tarcer"],

Cell[TextData[{
 "If FeynCalc is not needed, simply evaluate the file \"TARCER.nb\". This \
produces a file of the form \"tarcer*.mx\". Later it is then only necessary \
to load this file (e.g. ",
 StyleBox["<<\"tarcer06.mx\"",
  FontFamily->"Courier"],
 "). You can later change parameters in \"TARCER.nb\" and reevaluate it. \
Alternatively you can get a preproduced .mx file at ",
 ButtonBox["http://www.feyncalc.org/tarcer/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feyncalc.org/tarcer/"], None},
  ButtonNote->"http://www.feyncalc.org/tarcer/"],
 "."
}], "Text",
 CellTags->"tarcer"],

Cell[TextData[{
 "If instructed to do so, FeynCalc automatically loads any tarcer*.mx file \
found the directory \"Tarcer\" (if several are present, the last one found by \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s FileNames is loaded). To have FeynCalc load TARCER, evaluate"
}], "Text",
 CellTags->"tarcer"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$LoadTARCER", "=", "True"}], ";"}]], "Input",
 CellTags->"tarcer",
 CellLabel->"In[11]:="],

Cell[TextData[{
 "before ",
 ButtonBox["loading FeynCalc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Load FeynCalc",
  ButtonNote->"start"],
 ". You can also put the last input line into your \"FCConfig.m\" file."
}], "Text",
 CellTags->"tarcer"],

Cell[TextData[{
 "An example notebook is also available at ",
 ButtonBox["http://www.feyncalc.org/tarcer/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feyncalc.org/tarcer/"], None},
  ButtonNote->"http://www.feyncalc.org/tarcer/"],
 "."
}], "Text",
 CellTags->"tarcer"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "PHI -\nA ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package for ChPT calculations"
}], "Subsection",
 CellTags->"phi"],

Cell["F. J. Orellana", "InspectorLevel2",
 CellTags->"phi"],

Cell[TextData[{
 "PHI is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package for manipulating covariant derivatives etc. of effective theories \
like Chiral Perturbation Theory. Moreover it provides an alternative way of \
creating coupling definitions for FeynArts. This is convenient if one needs \
to generate a large number of Feynman rules from different lagrangians."
}], "Text",
 CellTags->"phi"],

Cell["To have FeynCalc load PHI, evaluate", "Text",
 CellTags->"phi"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$LoadPhi", "=", "True"}], ";"}]], "Input",
 CellTags->"phi",
 CellLabel->"In[12]:="],

Cell[TextData[{
 "before ",
 ButtonBox["loading FeynCalc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Load FeynCalc",
  ButtonNote->"start"],
 ". You can also put this line into your \"FCConfig.m\" file."
}], "Text",
 CellTags->"phi"],

Cell[TextData[{
 "More information is available at ",
 ButtonBox["http://www.feyncalc.org/phi/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feyncalc.org/phi/"], None},
  ButtonNote->"http://www.feyncalc.org/phi/"],
 "."
}], "Text",
 CellTags->"phi"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynArts", "Subsection",
 CellTags->"fa"],

Cell["\<\
Hagen Eck, Sepp K\[UDoubleDot]blbeck and Thomas Hahn\
\>", "InspectorLevel2",
 CellTags->"fa"],

Cell[TextData[{
 ButtonBox["hep-ph/0012260",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://xxx.lanl.gov/abs/hep-ph/0012260"], None}],
 " on the Los Alamos preprint server"
}], "Text",
 CellDingbat->"\[GrayCircle]",
 CellTags->"fa"],

Cell[TextData[{
 "old version published in ",
 StyleBox["Comp. Phys. Comm. ",
  CellDingbat->"\[GrayCircle]"],
 StyleBox["60",
  CellDingbat->"\[GrayCircle]",
  FontWeight->"Bold"],
 StyleBox[" (1990) 165",
  CellDingbat->"\[GrayCircle]"]
}], "Text",
 CellDingbat->"\[GrayCircle]",
 CellTags->"fa"],

Cell["\<\
FeynArts is a Mathematica package written by Hagen Eck, Sepp \
K\[UDoubleDot]blbeck and Thomas Hahn for the generation and visualization of \
Feynman diagrams and amplitudes. The current version is being developed by \
Thomas Hahn independently of FeynCalc. As it turns out, it can, however, be \
used with FeynCalc with only a few modifications, which are done \
automatically when it is loaded by FeynCalc.\
\>", "Text",
 CellTags->"fa"],

Cell["\<\
One use of FeynCalc and FeynArts together is to use FeynCalc to process the \
output you get from FeynArts. Another use is to use FeynCalc and PHI to \
generate the many Feynman rules needed in effective theories like ChPT and \
feed them to FeynArts.\
\>", "Text",
 CellTags->"fa"],

Cell[TextData[{
 "To have FeynArts loaded by FeynCalc, you need first of all to get FeynArts \
at ",
 ButtonBox["http://www.feynarts.de/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feynarts.de/"], None},
  ButtonNote->"Download FeynArts"],
 " and put it in the directory \"HighEnergyPhysics\". Then evaluate"
}], "Text",
 CellTags->"fa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$LoadPhi", "=", "True"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"$LoadFeynArts", "=", "True"}], ";"}]}], "Input",
 CellTags->"fa",
 CellLabel->"In[13]:="],

Cell[TextData[{
 "before ",
 ButtonBox["loading FeynCalc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Load FeynCalc",
  ButtonNote->"start"],
 ". You can also put these lines into your \"FCConfig.m\" file."
}], "Text",
 CellTags->"fa"],

Cell[TextData[{
 "More information about FeynArts is available at ",
 ButtonBox["http://www.feynarts.de/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feynarts.de/"], None},
  ButtonNote->"Download FeynArts"],
 ". More information about using FeynArts, FeynCalc and PHI is available at \
",
 ButtonBox["http://www.feyncalc.org/phi/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feyncalc.org/phi/"], None},
  ButtonNote->"http://www.feyncalc.org/phi/"],
 "."
}], "Text",
 CellTags->"fa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Calculations", "Section",
 PageBreakAbove->True,
 CellTags->{"Example Calculations", "ex"}],

Cell[TextData[{
 "This section is under development ... Please post suggestions on ",
 ButtonBox["www.feyncalc.org/forum/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.feyncalc.org/forum/"], None},
  ButtonNote->"http://www.feyncalc.org/forum/"],
 "."
}], "Commentary",
 CellTags->"ex"],

Cell[CellGroupData[{

Cell[TextData[{
 "Tree level ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Gamma]", " ", "\[Gamma]"}], " ", "\[Rule]", " ", 
    RowBox[{
     SuperscriptBox["e", "+"], 
     SuperscriptBox["e", "-"]}]}], TraditionalForm]]],
 " in the standard model"
}], "Subsection",
 CellTags->"Tree level"],

Cell["Define typesetting rules for p1, p2, k1, k2:", "Text",
 CellTags->"Tree level"],

Cell["\<\
p1/: MakeBoxes[p1, fmt_] := InterpretationBox[SubscriptBox[\"p\", 1], p1];
k1/: MakeBoxes[k1, fmt_] := InterpretationBox[SubscriptBox[\"k\", 1], k1];
p2/: MakeBoxes[p2, fmt_] := InterpretationBox[SubscriptBox[\"p\", 2], p2];
k2/: MakeBoxes[k2, fmt_] := InterpretationBox[SubscriptBox[\"k\", 2], k2];\
\>", "Input",
 CellTags->"Tree level",
 CellLabel->"In[15]:="],

Cell["Define slashes of external momenta to save future typing:", "Text",
 CellTags->"Tree level"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"p1sl", ",", "p2sl", ",", "k1sl", ",", "k2sl"}], "}"}], "=", 
  RowBox[{"DiracSlash", "/@", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "k1", ",", "k2"}], "}"}]}]}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[19]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox[
      InterpretationBox[
       SubscriptBox["p", "1"],
       $CellContext`p1],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox[
      InterpretationBox[
       SubscriptBox["p", "2"],
       $CellContext`p2],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox[
      InterpretationBox[
       SubscriptBox["k", "1"],
       $CellContext`k1],
      TraditionalForm]}], ",", 
    RowBox[{
     FormBox["\<\"\[Gamma]\"\>",
      TraditionalForm], "\[CenterDot]", 
     FormBox[
      InterpretationBox[
       SubscriptBox["k", "2"],
       $CellContext`k2],
      TraditionalForm]}]}], "}"}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[19]="]
}, Open  ]],

Cell[TextData[{
 "Kinematic definitions so that only ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["p", "1"], ".", 
    SubscriptBox["k", "1"]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["p", "1"], ".", 
    SubscriptBox["k", "2"]}], TraditionalForm]]],
 " appear in final results. I.e., define ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["p", "1", "2"], "=", 
    RowBox[{
     SubsuperscriptBox["p", "2", "2"], "=", " ", 
     SuperscriptBox["m", "2"]}]}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["k", "1", "2"], "=", 
    RowBox[{
     SubsuperscriptBox["k", "2", "2"], "=", " ", "0"}]}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["k", "1"], "\[CenterDot]", 
     SubscriptBox["k", "2"]}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["p", "1"], "\[CenterDot]", 
      SubscriptBox["p", "2"]}], "+", 
     SuperscriptBox["m", "2"]}]}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["k", "1"], "\[CenterDot]", 
     SubscriptBox["p", "2"]}], " ", "=", " ", 
    RowBox[{
     SubscriptBox["k", "2"], "\[CenterDot]", 
     SubscriptBox["p", "1"]}]}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["k", "2"], "\[CenterDot]", 
     SubscriptBox["p", "2"]}], " ", "=", " ", 
    RowBox[{
     SubscriptBox["k", "1"], "\[CenterDot]", 
     SubscriptBox["p", "1"]}]}], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["p", "1"], "\[CenterDot]", 
     SubscriptBox["p", "2"]}], "=", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "2"], "\[CenterDot]", 
      SubscriptBox["p", "1"]}], "-", 
     SuperscriptBox["m", "2"], "+", 
     RowBox[{
      SubscriptBox["k", "1"], "\[CenterDot]", 
      SubscriptBox["p", "1"]}]}]}], TraditionalForm]]],
 "."
}], "Text",
 CellTags->"Tree level"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p1"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"p2", ",", "p2"}], "]"}], "=", 
    SuperscriptBox["m", "2"]}]}], ";"}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[20]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"k1", ",", "k1"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"k2", ",", "k2"}], "]"}], "=", "0"}]}], ";"}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[21]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"k1", ",", "k2"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"p1", ",", "p2"}], "]"}], "+", 
    SuperscriptBox["m", "2"]}]}], ";"}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[22]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"k1", ",", "p2"}], "]"}], "=", 
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"k2", ",", "p1"}], "]"}]}], ";"}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[23]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"k2", ",", "p2"}], "]"}], "=", 
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"k1", ",", "p1"}], "]"}]}], ";"}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[24]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ScalarProduct", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], "=", 
   RowBox[{
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"k2", ",", "p1"}], "]"}], "-", 
    SuperscriptBox["m", "2"], "+", 
    RowBox[{"ScalarProduct", "[", 
     RowBox[{"k1", ",", "p1"}], "]"}]}]}], ";"}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[25]:="],

Cell["Define the amplitudes:", "Text",
 CellTags->"Tree level"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", "=", 
  RowBox[{
   RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], ".", 
   RowBox[{"(", 
    RowBox[{"p1sl", "-", "k1sl", "+", "m"}], ")"}], ".", 
   RowBox[{"DiracMatrix", "[", "\[Nu]", "]"}]}]}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[26]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"(", 
    RowBox[{"m", "-", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "1"],
        $CellContext`k1],
       TraditionalForm]}], "+", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[26]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "=", 
  RowBox[{
   RowBox[{"DiracMatrix", "[", "\[Nu]", "]"}], ".", 
   RowBox[{"(", 
    RowBox[{"p1sl", "-", "k2sl", "+", "m"}], ")"}], ".", 
   RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}]}]}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[27]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"(", 
    RowBox[{"m", "-", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "2"],
        $CellContext`k2],
       TraditionalForm]}], "+", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[27]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f3", "=", 
  RowBox[{
   RowBox[{"DiracMatrix", "[", "\[Nu]", "]"}], ".", 
   RowBox[{"(", 
    RowBox[{"p1sl", "-", "k1sl", "+", "m"}], ")"}], ".", 
   RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}]}]}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[28]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"(", 
    RowBox[{"m", "-", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "1"],
        $CellContext`k1],
       TraditionalForm]}], "+", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[28]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f4", "=", 
  RowBox[{
   RowBox[{"DiracMatrix", "[", "\[Mu]", "]"}], ".", 
   RowBox[{"(", 
    RowBox[{"p1sl", "-", "k2sl", "+", "m"}], ")"}], ".", 
   RowBox[{"DiracMatrix", "[", "\[Nu]", "]"}]}]}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[29]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"(", 
    RowBox[{"m", "-", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "2"],
        $CellContext`k2],
       TraditionalForm]}], "+", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[29]="]
}, Open  ]],

Cell[" Calculate the four traces:", "Text",
 CellTags->"Tree level"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"p1sl", " ", "+", " ", "m"}], ")"}], " ", ".", " ", "f1", " ", ".",
   " ", 
  RowBox[{"(", 
   RowBox[{"p2sl", " ", "-", " ", "m"}], ")"}], " ", ".", " ", 
  "f3"}]], "Input",
 CellLabel->"In[30]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"m", "+", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"(", 
    RowBox[{"m", "-", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "1"],
        $CellContext`k1],
       TraditionalForm]}], "+", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "2"],
        $CellContext`p2],
       TraditionalForm]}], "-", "m"}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Nu]",
      TraditionalForm],
     TraditionalForm]], ".", 
   RowBox[{"(", 
    RowBox[{"m", "-", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "1"],
        $CellContext`k1],
       TraditionalForm]}], "+", 
     RowBox[{
      FormBox["\<\"\[Gamma]\"\>",
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}], ")"}], ".", 
   SuperscriptBox["\[Gamma]", 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellLabel->"Out[30]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[31]:="],

Cell["\<\
(m + DiracGamma[Momentum[p1]]) . DiracGamma[LorentzIndex[\[Mu]]] . 
 (m - DiracGamma[Momentum[k1]] + DiracGamma[Momentum[p1]]) . \
DiracGamma[LorentzIndex[\[Nu]]] . 
 (-m + DiracGamma[Momentum[p2]]) . DiracGamma[LorentzIndex[\[Nu]]] . 
 (m - DiracGamma[Momentum[k1]] + DiracGamma[Momentum[p1]]) . \
DiracGamma[LorentzIndex[\[Mu]]]\
\>", "Output",
 CellLabel->"Out[31]//InputForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DiracTrace", "]"}]], "Input",
 CellLabel->"In[32]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EpsContract", "\[Rule]", "False"}], ",", 
    RowBox[{"Factoring", "\[Rule]", "False"}], ",", 
    RowBox[{"FeynCalcExternal", "\[Rule]", "False"}], ",", 
    RowBox[{"Mandelstam", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"PairCollect", "\[Rule]", "True"}], ",", 
    RowBox[{"DiracTraceEvaluate", "\[Rule]", "False"}], ",", 
    RowBox[{"Schouten", "\[Rule]", "0"}], ",", 
    RowBox[{"LeviCivitaSign", "\[RuleDelayed]", "$LeviCivitaSign"}], ",", 
    RowBox[{"TraceOfOne", "\[Rule]", "4"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellLabel->"Out[32]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrace", "//", "Context"}]], "Input",
 CellLabel->"In[33]:="],

Cell[BoxData[
 FormBox["\<\"HighEnergyPhysics`fctools`DiracTrace`\"\>", 
  TraditionalForm]], "Output",
 CellLabel->"Out[33]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SetOptions"}]], "Input",
 CellLabel->"In[34]:="],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"SetOptions\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"s\\\", \\\"TI\\\"], \\\",\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"name\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\"->\\\", SubscriptBox[StyleBox[\\\"value\\\", \\\"TI\\\"], \
StyleBox[\\\"1\\\", \\\"TR\\\"]]}], \\\",\\\", RowBox[{SubscriptBox[StyleBox[\
\\\"name\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\"->\\\", \
SubscriptBox[StyleBox[\\\"value\\\", \\\"TI\\\"], StyleBox[\\\"2\\\", \
\\\"TR\\\"]]}], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\
\\\"}]\) sets the specified default options for a symbol \!\(\*StyleBox[\\\"s\
\\\", \\\"TI\\\"]\). \\n\!\(\*RowBox[{\\\"SetOptions\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"stream\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"\
\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) or \!\(\*RowBox[{\\\"SetOptions\
\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"\\\\\\\"\\\\!\\\\(\\\\*StyleBox[\\\\\\\"name\\\\\\\",\\\\\
\\\"TI\\\\\\\"]\\\\)\\\\\\\"\\\", ShowStringCharacters->True], \\\",\\\", \
StyleBox[\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) sets options \
associated with a particular stream. \\n\!\(\*RowBox[{\\\"SetOptions\\\", \
\\\"[\\\", RowBox[{StyleBox[\\\"object\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\
\\\"\[Ellipsis]\\\", \\\"TR\\\"]}], \\\"]\\\"}]\) sets options associated \
with an external object such as a NotebookObject. \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]}]], "Print", "PrintUsage",
 CellTags->"Info3387713579-2928036"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiracTrace", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"DiracGamma", "[", 
       RowBox[{"Momentum", "[", "p1", "]"}], "]"}]}], ")"}], ".", 
    RowBox[{"DiracGamma", "[", 
     RowBox[{"LorentzIndex", "[", "\[Mu]", "]"}], "]"}]}], ",", 
   RowBox[{"DiracTraceEvaluate", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[35]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", 
   SuperscriptBox[
    FormBox[
     InterpretationBox[
      SubscriptBox["p", "1"],
      $CellContext`p1],
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellLabel->"Out[35]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TR", "@", "%"}]], "Input",
 CellLabel->"In[36]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"16", " ", 
   SuperscriptBox[
    FormBox[
     InterpretationBox[
      SubscriptBox["p", "1"],
      $CellContext`p1],
     TraditionalForm], 
    FormBox[
     FormBox["\[Mu]",
      TraditionalForm],
     TraditionalForm]]}], TraditionalForm]], "Output",
 CellLabel->"Out[36]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["tr1 = TR[(p1sl + m) . f1 . (p2sl - m) . f3]", "Input",
 CellTags->"Tree level",
 CellLabel->"In[37]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["m", "4"]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "1"],
         $CellContext`k1],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      SuperscriptBox["m", "2"]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "1"],
         $CellContext`k1],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "2"],
         $CellContext`k2],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[37]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["tr2 = Tr[(p1sl + m) . f1 . (p2sl - m) . f4]", "Input",
 CellTags->"Tree level",
 CellLabel->"In[38]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["m", "4"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "1"],
         $CellContext`k1],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      SuperscriptBox["m", "2"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "2"],
         $CellContext`k2],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      SuperscriptBox["m", "2"]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[38]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["tr3 = Tr[(p1sl + m) . f2 . (p2sl - m) . f3]", "Input",
 CellTags->"Tree level",
 CellLabel->"In[39]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["m", "4"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "1"],
         $CellContext`k1],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      SuperscriptBox["m", "2"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "2"],
         $CellContext`k2],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      SuperscriptBox["m", "2"]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[39]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["tr4 = Tr[(p1sl + m) . f2 . (p2sl - m) . f4]", "Input",
 CellTags->"Tree level",
 CellLabel->"In[40]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["m", "4"]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "2"],
         $CellContext`k2],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      SuperscriptBox["m", "2"]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "1"],
         $CellContext`k1],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "2"],
         $CellContext`k2],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}]}]}], ")"}]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[40]="]
}, Open  ]],

Cell["Divide by the denominators and add everything up:", "Text",
 CellTags->"Tree level"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matrixsq", "=", 
  RowBox[{
   FractionBox["tr1", 
    SuperscriptBox[
     RowBox[{"ScalarProduct", "[", 
      RowBox[{
       RowBox[{"2", " ", "p1"}], ",", "k1"}], "]"}], "2"]], "+", 
   FractionBox["tr4", 
    SuperscriptBox[
     RowBox[{"ScalarProduct", "[", 
      RowBox[{
       RowBox[{"2", " ", "p1"}], ",", "k2"}], "]"}], "2"]], "+", 
   FractionBox[
    RowBox[{"tr2", "+", "tr3"}], 
    RowBox[{
     RowBox[{"ScalarProduct", "[", 
      RowBox[{
       RowBox[{"2", " ", "p1"}], ",", "k1"}], "]"}], " ", 
     RowBox[{"ScalarProduct", "[", 
      RowBox[{
       RowBox[{"2", " ", "p1"}], ",", "k2"}], "]"}]}]]}]}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[41]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "8"}], " ", 
        SuperscriptBox["m", "4"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         FormBox[
          InterpretationBox[
           SubscriptBox["k", "1"],
           $CellContext`k1],
          TraditionalForm], "\[CenterDot]", 
         FormBox[
          InterpretationBox[
           SubscriptBox["p", "1"],
           $CellContext`p1],
          TraditionalForm]}], " ", 
        SuperscriptBox["m", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{
         FormBox[
          InterpretationBox[
           SubscriptBox["k", "2"],
           $CellContext`k2],
          TraditionalForm], "\[CenterDot]", 
         FormBox[
          InterpretationBox[
           SubscriptBox["p", "1"],
           $CellContext`p1],
          TraditionalForm]}], " ", 
        SuperscriptBox["m", "2"]}]}], ")"}]}], 
    RowBox[{
     RowBox[{
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "1"],
        $CellContext`k1],
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}], " ", 
     RowBox[{
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "2"],
        $CellContext`k2],
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["m", "4"]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "1"],
         $CellContext`k1],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      SuperscriptBox["m", "2"]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "1"],
         $CellContext`k1],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "2"],
         $CellContext`k2],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}]}]}], 
    SuperscriptBox[
     FormBox[
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "1"],
         $CellContext`k1],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}],
      TraditionalForm], "2"]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["m", "4"]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "2"],
         $CellContext`k2],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      SuperscriptBox["m", "2"]}], "+", 
     RowBox[{"8", " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "1"],
         $CellContext`k1],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}], " ", 
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "2"],
         $CellContext`k2],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}]}]}], 
    SuperscriptBox[
     FormBox[
      RowBox[{
       FormBox[
        InterpretationBox[
         SubscriptBox["k", "2"],
         $CellContext`k2],
        TraditionalForm], "\[CenterDot]", 
       FormBox[
        InterpretationBox[
         SubscriptBox["p", "1"],
         $CellContext`p1],
        TraditionalForm]}],
      TraditionalForm], "2"]]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[41]="]
}, Open  ]],

Cell[TextData[{
 "Collect with respect to powers of ",
 StyleBox["m",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellTags->"Tree level"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Collect2", "[", 
   RowBox[{"matrixsq", ",", "m"}], "]"}]}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[42]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FormBox[
           InterpretationBox[
            SubscriptBox["k", "1"],
            $CellContext`k1],
           TraditionalForm], "\[CenterDot]", 
          FormBox[
           InterpretationBox[
            SubscriptBox["p", "1"],
            $CellContext`p1],
           TraditionalForm]}], "+", 
         RowBox[{
          FormBox[
           InterpretationBox[
            SubscriptBox["k", "2"],
            $CellContext`k2],
           TraditionalForm], "\[CenterDot]", 
          FormBox[
           InterpretationBox[
            SubscriptBox["p", "1"],
            $CellContext`p1],
           TraditionalForm]}]}], ")"}], "2"], " ", 
      SuperscriptBox["m", "4"]}], 
     RowBox[{
      SuperscriptBox[
       FormBox[
        RowBox[{
         FormBox[
          InterpretationBox[
           SubscriptBox["k", "1"],
           $CellContext`k1],
          TraditionalForm], "\[CenterDot]", 
         FormBox[
          InterpretationBox[
           SubscriptBox["p", "1"],
           $CellContext`p1],
          TraditionalForm]}],
        TraditionalForm], "2"], " ", 
      SuperscriptBox[
       FormBox[
        RowBox[{
         FormBox[
          InterpretationBox[
           SubscriptBox["k", "2"],
           $CellContext`k2],
          TraditionalForm], "\[CenterDot]", 
         FormBox[
          InterpretationBox[
           SubscriptBox["p", "1"],
           $CellContext`p1],
          TraditionalForm]}],
        TraditionalForm], "2"]}]]}], "+", 
   FractionBox[
    RowBox[{"16", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FormBox[
         InterpretationBox[
          SubscriptBox["k", "1"],
          $CellContext`k1],
         TraditionalForm], "\[CenterDot]", 
        FormBox[
         InterpretationBox[
          SubscriptBox["p", "1"],
          $CellContext`p1],
         TraditionalForm]}], "+", 
       RowBox[{
        FormBox[
         InterpretationBox[
          SubscriptBox["k", "2"],
          $CellContext`k2],
         TraditionalForm], "\[CenterDot]", 
        FormBox[
         InterpretationBox[
          SubscriptBox["p", "1"],
          $CellContext`p1],
         TraditionalForm]}]}], ")"}], " ", 
     SuperscriptBox["m", "2"]}], 
    RowBox[{
     RowBox[{
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "1"],
        $CellContext`k1],
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}], " ", 
     RowBox[{
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "2"],
        $CellContext`k2],
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}]], "+", 
   FractionBox[
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        FormBox[
         RowBox[{
          FormBox[
           InterpretationBox[
            SubscriptBox["k", "1"],
            $CellContext`k1],
           TraditionalForm], "\[CenterDot]", 
          FormBox[
           InterpretationBox[
            SubscriptBox["p", "1"],
            $CellContext`p1],
           TraditionalForm]}],
         TraditionalForm], "2"], "+", 
       SuperscriptBox[
        FormBox[
         RowBox[{
          FormBox[
           InterpretationBox[
            SubscriptBox["k", "2"],
            $CellContext`k2],
           TraditionalForm], "\[CenterDot]", 
          FormBox[
           InterpretationBox[
            SubscriptBox["p", "1"],
            $CellContext`p1],
           TraditionalForm]}],
         TraditionalForm], "2"]}], ")"}]}], 
    RowBox[{
     RowBox[{
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "1"],
        $CellContext`k1],
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}], " ", 
     RowBox[{
      FormBox[
       InterpretationBox[
        SubscriptBox["k", "2"],
        $CellContext`k2],
       TraditionalForm], "\[CenterDot]", 
      FormBox[
       InterpretationBox[
        SubscriptBox["p", "1"],
        $CellContext`p1],
       TraditionalForm]}]}]]}], TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[42]="]
}, Open  ]],

Cell[TextData[{
 "The symmetry with respect to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["k", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["k", "2"], TraditionalForm]]],
 " can be checked explicitly:"
}], "Text",
 CellTags->"Tree level"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{"r", " ", "-", " ", 
   RowBox[{"(", 
    RowBox[{"r", " ", "/.", " ", 
     RowBox[{"{", " ", 
      RowBox[{"k1", "\[RuleDelayed]", "k2"}], ",", " ", 
      RowBox[{"k2", "\[RuleDelayed]", "k1"}], "}"}]}], ")"}]}], 
  ")"}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[43]:="],

Cell[BoxData[
 FormBox["0", TraditionalForm]], "Output",
 CellTags->"Tree level",
 CellLabel->"Out[43]="]
}, Open  ]],

Cell["\<\
Remove the definitions for the scalar products and for the typesetting \
definitions:\
\>", "Text",
 CellTags->"Tree level"],

Cell[BoxData[
 RowBox[{"ClearScalarProducts", ";", " ", 
  RowBox[{"Clear", "[", 
   RowBox[{"p1", ",", "p2", ",", "k1", ",", "k2", ",", "r"}], "]"}], 
  ";"}]], "Input",
 CellTags->"Tree level",
 CellLabel->"In[44]:="],

Cell[TextData[{
 "See also: ",
 ButtonBox["ClearScalarProducts",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ClearScalarProducts"],
 ", ",
 ButtonBox["Collect2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Collect2"],
 ", ",
 ButtonBox["DiracMatrix",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracMatrix"],
 ", ",
 ButtonBox["DiracSlash",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DiracSlash"],
 ", ",
 ButtonBox["ScalarProduct",
  BaseStyle->"AddOnsLink",
  ButtonData:>"ScalarProduct"],
 ", ",
 ButtonBox["Tr",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Tr"],
 "."
}], "Text",
 CellTags->"Tree level"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A moment integral", "Subsection",
 CellTags->"A moment integral"],

Cell[TextData[{
 "This section shows how to calculate the moments of ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox[
    StyleBox[
     OverscriptBox[
      StyleBox["A",
       FontSlant->"Plain"], "^"],
     FontSlant->"Plain"], "qq", 
    RowBox[{"NS", ",", "PHYS"}]], TraditionalForm]]],
 " from ",
 ButtonBox["hep-ph/9801224",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://xxx.lanl.gov/abs/hep-ph/9801224"], None}],
 ". Notice that due to current conservation the first moment of ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox[
    StyleBox[
     OverscriptBox[
      StyleBox["A",
       FontSlant->"Plain"], "^"],
     FontSlant->"Plain"], "qq", 
    RowBox[{"NS", ",", "PHYS"}]], TraditionalForm]]],
 "should vanish."
}], "Text",
 CellTags->"A moment integral"],

Cell["First e is defined to be \[CurlyEpsilon]:", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", " ", "=", " ", "Epsilon"}], ";"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[45]:="],

Cell[TextData[{
 "Next, FORM output from the file \"jqq12.log\" is translated to FeynCalc \
syntax. The FORM file \"jqq12.log\" was generated by one of the authors of ",
 ButtonBox["hep-ph/9801224",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://xxx.lanl.gov/abs/hep-ph/9801224"], None}],
 ". "
}], "Text",
 CellTags->"A moment integral"],

Cell["\<\
FORM convenctions like ln(1-x) can be translated automatically by \
FORM2FeynCalc, but they have to be listed once in the option Replace of \
FORM2FeynCalc :\
\>", "Text",
 CellTags->"A moment integral"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"FORM2FeynCalc", ",", 
    RowBox[{"Replace", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ln(x)\>\"", "\[Rule]", "\"\<Log[x]\>\""}], ",", 
       RowBox[{"\"\<ln(1+x)\>\"", "\[Rule]", "\"\<Log[1+x]\>\""}], ",", 
       RowBox[{"\"\<ln(1-x)\>\"", "\[Rule]", "\"\<Log[1-x]\>\""}], ",", 
       RowBox[{"\"\<Li2(-x)\>\"", "\[Rule]", "\"\<Li2[-x]\>\""}], ",", 
       RowBox[{"\"\<Li2(1-x)\>\"", "\[Rule]", "\"\<Li2[1-x]\>\""}], ",", 
       RowBox[{"\"\<Li3(1-x)\>\"", "\[Rule]", "\"\<Li3[1-x]\>\""}], ",", 
       RowBox[{"\"\<Li3(-x)\>\"", "\[Rule]", "\"\<Li3[-x]\>\""}], ",", 
       RowBox[{"\"\<S12(1-x)\>\"", "\[Rule]", "\"\<Nielsen[1,2,1-x]\>\""}], 
       ",", 
       RowBox[{"\"\<S12(-x)\>\"", "\[Rule]", "\"\<Nielsen[1,2,-x]\>\""}], ",",
        
       RowBox[{"\"\<S12(x^2)\>\"", "\[Rule]", "\"\<Nielsen[1,2,x^2]\>\""}], 
       ",", 
       RowBox[{"\"\<Z2\>\"", "\[Rule]", "\"\<Zeta2\>\""}], ",", 
       RowBox[{"\"\<Z3\>\"", "\[Rule]", "\"\<Zeta[3]\>\""}], ",", 
       RowBox[{"\"\<[1+x]^-1\>\"", "\[Rule]", "\"\<(1+x)^-1\>\""}], ",", 
       RowBox[{"\"\<[(1-x)+]^-1\>\"", "\[Rule]", "\"\<(1-x)^-1\>\""}], ",", 
       RowBox[{"\"\<[1-x]^-1\>\"", "\[Rule]", "\"\<(1-x)^-1\>\""}], ",", 
       RowBox[{"\"\<delta\>\"", "\[Rule]", "\"\<DeltaFunction[1-x]\>\""}], 
       ",", 
       RowBox[{"\"\<Ca\>\"", "\[Rule]", "\"\<CA\>\""}], ",", 
       RowBox[{"\"\<Cf\>\"", "\[Rule]", "\"\<CF\>\""}]}], "}"}]}], ",", 
    RowBox[{"Dot", "\[Rule]", "Times"}], ",", 
    RowBox[{"HoldForm", "\[Rule]", "False"}]}], "]"}], ";"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[46]:="],

Cell["\<\
Copy the FORM output from jqq12.log into the next cell and put \
FORM2CFeynCalc[\" \"]//ReleaseHold around it.\
\>", "Text",
 CellTags->"A moment integral"],

Cell["\<\
aqq=FORM2FeynCalc[\"

          + [(-1)^m]*e^-1*O1*Ca*Cf * (
          - 8
          + 4*x*Z2
          + 8*x
          + 8*Z2*[1+x]^-1
          - 4*Z2
          - 4*ln(x)
          - 4*ln(x)*x
          - 8*ln(x)*ln(1 + x)
          + 8*ln(x)*ln(1 + x)*x
          + 16*ln(x)*ln(1 + x)*[1+x]^-1
          + 2*ln(x)*ln(x)
          - 2*ln(x)*ln(x)*x
          - 4*ln(x)*ln(x)*[1+x]^-1
          - 8*Li2( - x)
          + 8*Li2( - x)*x
          + 16*Li2( - x)*[1+x]^-1
          )

       + [(-1)^m]*e^-1*O1*Cf^2 * (
          + 16
          - 8*x*Z2
          - 16*x
          - 16*Z2*[1+x]^-1
          + 8*Z2
          + 8*ln(x)
          + 8*ln(x)*x
          + 16*ln(x)*ln(1 + x)
          - 16*ln(x)*ln(1 + x)*x
          - 32*ln(x)*ln(1 + x)*[1+x]^-1
          - 4*ln(x)*ln(x)
          + 4*ln(x)*ln(x)*x
          + 8*ln(x)*ln(x)*[1+x]^-1
          + 16*Li2( - x)
          - 16*Li2( - x)*x
          - 32*Li2( - x)*[1+x]^-1
          )

       + [(-1)^m]*O1*Ca*Cf * (
          - 41/3
          - 6*x*Z2
          - 2*x*Z3
          + 41/3*x
          + 16/3*x^2*Z2
          + 6*Z2
          + 4*Z3*[1+x]^-1
          - 6*Z3
          - 8*ln(1 - x)
          + 8*ln(1 - x)*x
          - 8*ln(1 - x)*Li2(1 - x)
          + 8*ln(1 - x)*Li2(1 - x)*x
          + 16*ln(1 - x)*Li2(1 - x)*[1+x]^-1
          + 8*ln(1 + x)*x*Z2
          + 8*ln(1 + x)*Z2*[1+x]^-1
          - 8*ln(1 + x)*Li2(1 - x)
          + 8*ln(1 + x)*Li2(1 - x)*x
          + 16*ln(1 + x)*Li2(1 - x)*[1+x]^-1
          + 16*ln(1 + x)*Li2( - x)*x
          + 16*ln(1 + x)*Li2( - x)*[1+x]^-1
          - 37/3*ln(x)
          - 25/3*ln(x)*x
          - 4*ln(x)*ln(1 - x)
          - 4*ln(x)*ln(1 - x)*x
          - 4*ln(x)*ln(1 - x)*ln(1 - x)
          + 4*ln(x)*ln(1 - x)*ln(1 - x)*x
          + 8*ln(x)*ln(1 - x)*ln(1 - x)*[1+x]^-1
          - 8*ln(x)*ln(1 - x)*ln(1 + x)
          + 8*ln(x)*ln(1 - x)*ln(1 + x)*x
          + 16*ln(x)*ln(1 - x)*ln(1 + x)*[1+x]^-1
          + 4/3*ln(x)*ln(1 + x)*x^-1
          + 4*ln(x)*ln(1 + x)*x
          + 16/3*ln(x)*ln(1 + x)*x^2
          + 8*ln(x)*ln(1 + x)*ln(1 + x)*x
          + 8*ln(x)*ln(1 + x)*ln(1 + x)*[1+x]^-1
          - 6*ln(x)*ln(x)
          - 8/3*ln(x)*ln(x)*x^2
          + 2*ln(x)*ln(x)*ln(1 - x)
          - 2*ln(x)*ln(x)*ln(1 - x)*x
          - 4*ln(x)*ln(x)*ln(1 - x)*[1+x]^-1
          - 6*ln(x)*ln(x)*ln(1 + x)
          + 2*ln(x)*ln(x)*ln(1 + x)*x
          + 8*ln(x)*ln(x)*ln(1 + x)*[1+x]^-1
          + ln(x)*ln(x)*ln(x)
          - ln(x)*ln(x)*ln(x)*x
          - 2*ln(x)*ln(x)*ln(x)*[1+x]^-1
          + 4*ln(x)*Li2(1 - x)
          - 4*ln(x)*Li2(1 - x)*x
          - 8*ln(x)*Li2(1 - x)*[1+x]^-1
          - 4*ln(x)*Li2( - x)
          + 4*ln(x)*Li2( - x)*x
          + 8*ln(x)*Li2( - x)*[1+x]^-1
          - 4*Li2(1 - x)
          - 4*Li2(1 - x)*x
          + 4/3*Li2( - x)*x^-1
          + 4*Li2( - x)*x
          + 16/3*Li2( - x)*x^2
          + 8*Li3(1 - x)
          - 8*Li3(1 - x)*x
          - 16*Li3(1 - x)*[1+x]^-1
          - 4*Li3( - x)
          - 4*Li3( - x)*x
          + 4*S12(1 - x)
          - 4*S12(1 - x)*x
          - 8*S12(1 - x)*[1+x]^-1
          - 8*S12( - x)
          + 24*S12( - x)*x
          + 32*S12( - x)*[1+x]^-1
          + 4*S12(x^2)
          - 4*S12(x^2)*x
          - 8*S12(x^2)*[1+x]^-1
          )

       + [(-1)^m]*O1*Cf^2 * (
          + 82/3
          + 12*x*Z2
          + 4*x*Z3
          - 82/3*x
          - 32/3*x^2*Z2
          - 12*Z2
          - 8*Z3*[1+x]^-1
          + 12*Z3
          + 16*ln(1 - x)
          - 16*ln(1 - x)*x
          + 16*ln(1 - x)*Li2(1 - x)
          - 16*ln(1 - x)*Li2(1 - x)*x
          - 32*ln(1 - x)*Li2(1 - x)*[1+x]^-1
          - 16*ln(1 + x)*x*Z2
          - 16*ln(1 + x)*Z2*[1+x]^-1
          + 16*ln(1 + x)*Li2(1 - x)
          - 16*ln(1 + x)*Li2(1 - x)*x
          - 32*ln(1 + x)*Li2(1 - x)*[1+x]^-1
          - 32*ln(1 + x)*Li2( - x)*x
          - 32*ln(1 + x)*Li2( - x)*[1+x]^-1
          + 74/3*ln(x)
          + 50/3*ln(x)*x
          + 8*ln(x)*ln(1 - x)
          + 8*ln(x)*ln(1 - x)*x
          + 8*ln(x)*ln(1 - x)*ln(1 - x)
          - 8*ln(x)*ln(1 - x)*ln(1 - x)*x
          - 16*ln(x)*ln(1 - x)*ln(1 - x)*[1+x]^-1
          + 16*ln(x)*ln(1 - x)*ln(1 + x)
          - 16*ln(x)*ln(1 - x)*ln(1 + x)*x
          - 32*ln(x)*ln(1 - x)*ln(1 + x)*[1+x]^-1
          - 8/3*ln(x)*ln(1 + x)*x^-1
          - 8*ln(x)*ln(1 + x)*x
          - 32/3*ln(x)*ln(1 + x)*x^2
          - 16*ln(x)*ln(1 + x)*ln(1 + x)*x
          - 16*ln(x)*ln(1 + x)*ln(1 + x)*[1+x]^-1
          + 12*ln(x)*ln(x)
          + 16/3*ln(x)*ln(x)*x^2
          - 4*ln(x)*ln(x)*ln(1 - x)
          + 4*ln(x)*ln(x)*ln(1 - x)*x
          + 8*ln(x)*ln(x)*ln(1 - x)*[1+x]^-1
          + 12*ln(x)*ln(x)*ln(1 + x)
          - 4*ln(x)*ln(x)*ln(1 + x)*x
          - 16*ln(x)*ln(x)*ln(1 + x)*[1+x]^-1
          - 2*ln(x)*ln(x)*ln(x)
          + 2*ln(x)*ln(x)*ln(x)*x
          + 4*ln(x)*ln(x)*ln(x)*[1+x]^-1
          - 8*ln(x)*Li2(1 - x)
          + 8*ln(x)*Li2(1 - x)*x
          + 16*ln(x)*Li2(1 - x)*[1+x]^-1
          + 8*ln(x)*Li2( - x)
          - 8*ln(x)*Li2( - x)*x
          - 16*ln(x)*Li2( - x)*[1+x]^-1
          + 8*Li2(1 - x)
          + 8*Li2(1 - x)*x
          - 8/3*Li2( - x)*x^-1
          - 8*Li2( - x)*x
          - 32/3*Li2( - x)*x^2
          - 16*Li3(1 - x)
          + 16*Li3(1 - x)*x
          + 32*Li3(1 - x)*[1+x]^-1
          + 8*Li3( - x)
          + 8*Li3( - x)*x
          - 8*S12(1 - x)
          + 8*S12(1 - x)*x
          + 16*S12(1 - x)*[1+x]^-1
          + 16*S12( - x)
          - 48*S12( - x)*x
          - 64*S12( - x)*[1+x]^-1
          - 8*S12(x^2)
          + 8*S12(x^2)*x
          + 16*S12(x^2)*[1+x]^-1
          )

       + [(-1)^m]*O2*Ca*Cf * (
          + 8/3
          - 8/3*x
          - 16/3*x^2*Z2
          - 8/3*ln(x)
          + 16/3*ln(x)*x
          + 8/3*ln(x)*ln(1 + x)*x^-1
          - 8*ln(x)*ln(1 + x)*x
          - 16/3*ln(x)*ln(1 + x)*x^2
          + 8/3*ln(x)*ln(x)*x^2
          + 8/3*Li2( - x)*x^-1
          - 8*Li2( - x)*x
          - 16/3*Li2( - x)*x^2
          )

       + [(-1)^m]*O2*Cf^2 * (
          - 16/3
          + 16/3*x
          + 32/3*x^2*Z2
          + 16/3*ln(x)
          - 32/3*ln(x)*x
          - 16/3*ln(x)*ln(1 + x)*x^-1
          + 16*ln(x)*ln(1 + x)*x
          + 32/3*ln(x)*ln(1 + x)*x^2
          - 16/3*ln(x)*ln(x)*x^2
          - 16/3*Li2( - x)*x^-1
          + 16*Li2( - x)*x
          + 32/3*Li2( - x)*x^2
          )

       + e^-2*delta*O1*Ca*Cf * (
          - 22
          )

       + e^-2*delta*O1*Cf*Tf * (
          + 8
          )

       + e^-2*delta*O1*Cf^2 * (
          - 18
          + 32*Z2
          )

       + e^-2*O1*Ca*Cf * (
          + 44/3
          + 44/3*x
          - 88/3*[(1-x)+]^-1
          )

       + e^-2*O1*Cf*Tf * (
          - 16/3
          - 16/3*x
          + 32/3*[(1-x)+]^-1
          )

       + e^-2*O1*Cf^2 * (
          + 40
          + 8*x
          - 48*[(1-x)+]^-1
          + 32*ln(1 - x)
          + 32*ln(1 - x)*x
          - 64*ln(1 - x)*[(1-x)+]^-1
          - 24*ln(x)
          - 24*ln(x)*x
          + 32*ln(x)*[1-x]^-1
          )

       + e^-1*delta*O1*Ca*Cf * (
          + 325/6
          - 44/3*Z2
          - 12*Z3
          )

       + e^-1*delta*O1*Cf*Tf * (
          - 58/3
          + 16/3*Z2
          )

       + e^-1*delta*O1*Cf^2 * (
          + 87/2
          - 36*Z2
          - 8*Z3
          )

       + e^-1*O1*Ca*Cf * (
          - 158/9
          + 4*x*Z2
          + 22/9*x
          - 8*Z2*[(1-x)+]^-1
          + 4*Z2
          + 238/9*[(1-x)+]^-1
          + 44/3*ln(1 - x)
          + 44/3*ln(1 - x)*x
          - 88/3*ln(1 - x)*[(1-x)+]^-1
          + 34/3*ln(x)
          + 34/3*ln(x)*x
          - 44/3*ln(x)*[1-x]^-1
          - 2*ln(x)*ln(x)
          - 2*ln(x)*ln(x)*x
          + 4*ln(x)*ln(x)*[1-x]^-1
          )

       + e^-1*O1*Cf*Tf * (
          + 88/9
          - 56/9*x
          - 56/9*[(1-x)+]^-1
          - 16/3*ln(1 - x)
          - 16/3*ln(1 - x)*x
          + 32/3*ln(1 - x)*[(1-x)+]^-1
          - 8/3*ln(x)
          - 8/3*ln(x)*x
          + 16/3*ln(x)*[1-x]^-1
          )

       + e^-1*O1*Cf^2 * (
          - 40
          - 4*x
          + 56*[(1-x)+]^-1
          - 4*ln(1 - x)
          + 44*ln(1 - x)*x
          - 24*ln(1 - x)*[(1-x)+]^-1
          + 24*ln(1 - x)*ln(1 - x)
          + 24*ln(1 - x)*ln(1 - x)*x
          - 48*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1
          + 36*ln(x)
          - 20*ln(x)*x
          - 36*ln(x)*[1-x]^-1
          - 16*ln(x)*ln(1 - x)*[1-x]^-1
          - 14*ln(x)*ln(x)
          - 14*ln(x)*ln(x)*x
          + 16*ln(x)*ln(x)*[1-x]^-1
          - 8*Li2(1 - x)
          - 8*Li2(1 - x)*x
          )

       + e^-1*O2*Ca*Cf * (
          + 20/3
          - 88/3*x
          )

       + e^-1*O2*Cf*Tf * (
          - 16/3
          + 32/3*x
          )

       + e^-1*O2*Cf^2 * (
          - 16
          - 8*x
          - 32*ln(1 - x)*x
          + 16*ln(x)*x
          )

       + delta*O1*Ca*Cf * (
          - 7081/72
          + 301/18*Z2
          + 49/5*Z2^2
          + 28*Z3
          )

       + delta*O1*Cf*Tf * (
          + 569/18
          - 46/9*Z2
          - 8*Z3
          )

       + delta*O1*Cf^2 * (
          - 541/8
          + 97/2*Z2
          - 74/5*Z2^2
          + 54*Z3
          )

       + O1*Ca*Cf * (
          + 941/27
          + 17/3*x*Z2
          - 8*x*Z3
          - 580/27*x
          - 16/3*x^2*Z2
          - 24*x^2*Z3
          - 28/3*Z2*[(1-x)+]^-1
          - 1/3*Z2
          + 12*Z3*[1-x]^-1
          + 22*Z3*[(1-x)+]^-1
          - 20*Z3
          - 670/27*[(1-x)+]^-1
          - 122/9*ln(1 - x)
          + 6*ln(1 - x)*x*Z2
          - 32/9*ln(1 - x)*x
          + 8*ln(1 - x)*x^2*Z2
          - 10*ln(1 - x)*Z2*[(1-x)+]^-1
          + 2*ln(1 - x)*Z2
          + 238/9*ln(1 - x)*[(1-x)+]^-1
          + 22/3*ln(1 - x)*ln(1 - x)
          + 22/3*ln(1 - x)*ln(1 - x)*x
          - 44/3*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1
          + 2*ln(1 - x)*Li2(1 - x)
          - 2*ln(1 - x)*Li2(1 - x)*x
          + 8*ln(1 - x)*Li2(1 - x)*x^2
          - 2*ln(1 - x)*Li2(1 - x)*[1-x]^-1
          + 14/9*ln(x)
          - 2*ln(x)*x*Z2
          + 176/9*ln(x)*x
          - 8*ln(x)*x^2*Z2
          + 10*ln(x)*Z2*[1-x]^-1
          - 6*ln(x)*Z2
          + 101/9*ln(x)*[1-x]^-1
          + 28/3*ln(x)*ln(1 - x)
          + 10/3*ln(x)*ln(1 - x)*x
          - 38/3*ln(x)*ln(1 - x)*[1-x]^-1
          - 12*ln(x)*ln(1 + x)
          - 4/3*ln(x)*ln(1 + x)*x^-1
          - 16*ln(x)*ln(1 + x)*x
          - 16/3*ln(x)*ln(1 + x)*x^2
          + 47/6*ln(x)*ln(x)
          + 47/6*ln(x)*ln(x)*x
          + 8/3*ln(x)*ln(x)*x^2
          - 11/3*ln(x)*ln(x)*[1-x]^-1
          + ln(x)*ln(x)*ln(1 - x)
          - ln(x)*ln(x)*ln(1 - x)*x
          + 4*ln(x)*ln(x)*ln(1 - x)*x^2
          - ln(x)*ln(x)*ln(1 - x)*[1-x]^-1
          - ln(x)*ln(x)*ln(x)
          - ln(x)*ln(x)*ln(x)*x
          + 2*ln(x)*ln(x)*ln(x)*[1-x]^-1
          + 8*ln(x)*Li2(1 - x)
          + 16*ln(x)*Li2(1 - x)*x^2
          - 12*ln(x)*Li2(1 - x)*[1-x]^-1
          + 8*ln(x)*Li2( - x)
          - 8*ln(x)*Li2( - x)*[1-x]^-1
          - 12*Li2(1 - x)*x
          + 4*Li2(1 - x)*[1-x]^-1
          - 12*Li2( - x)
          - 4/3*Li2( - x)*x^-1
          - 16*Li2( - x)*x
          - 16/3*Li2( - x)*x^2
          - 6*Li3(1 - x)
          + 6*Li3(1 - x)*x
          - 24*Li3(1 - x)*x^2
          + 6*Li3(1 - x)*[1-x]^-1
          - 16*Li3( - x)
          + 16*Li3( - x)*[1-x]^-1
          + 14*S12(1 - x)
          - 6*S12(1 - x)*x
          + 24*S12(1 - x)*x^2
          - 14*S12(1 - x)*[1-x]^-1
          )

       + O1*Cf*Tf * (
          - 88/27
          - 4/3*x*Z2
          + 20/27*x
          + 8/3*Z2*[(1-x)+]^-1
          - 4/3*Z2
          + 128/27*[(1-x)+]^-1
          + 88/9*ln(1 - x)
          - 56/9*ln(1 - x)*x
          - 56/9*ln(1 - x)*[(1-x)+]^-1
          - 8/3*ln(1 - x)*ln(1 - x)
          - 8/3*ln(1 - x)*ln(1 - x)*x
          + 16/3*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1
          + 44/9*ln(x)
          - 28/9*ln(x)*x
          - 28/9*ln(x)*[1-x]^-1
          - 8/3*ln(x)*ln(1 - x)
          - 8/3*ln(x)*ln(1 - x)*x
          + 16/3*ln(x)*ln(1 - x)*[1-x]^-1
          - 2/3*ln(x)*ln(x)
          - 2/3*ln(x)*ln(x)*x
          + 4/3*ln(x)*ln(x)*[1-x]^-1
          )

       + O1*Cf^2 * (
          + 188/3
          - 4*x*Z2
          - 24*x*Z3
          + 4/3*x
          + 32/3*x^2*Z2
          + 48*x^2*Z3
          - 4*Z2*[(1-x)+]^-1
          + 20*Z2
          - 24*Z3*[1-x]^-1
          + 24*Z3
          - 56*[(1-x)+]^-1
          - 38*ln(1 - x)
          + 8*ln(1 - x)*x*Z2
          + 38*ln(1 - x)*x
          - 16*ln(1 - x)*x^2*Z2
          - 8*ln(1 - x)*Z2*[(1-x)+]^-1
          + 8*ln(1 - x)*Z2
          + 28*ln(1 - x)*[(1-x)+]^-1
          - 13*ln(1 - x)*ln(1 - x)
          + 31*ln(1 - x)*ln(1 - x)*x
          - 6*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1
          + 28/3*ln(1 - x)*ln(1 - x)*ln(1 - x)
          + 28/3*ln(1 - x)*ln(1 - x)*ln(1 - x)*x
          - 56/3*ln(1 - x)*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1
          - 12*ln(1 - x)*Li2(1 - x)
          + 4*ln(1 - x)*Li2(1 - x)*x
          - 16*ln(1 - x)*Li2(1 - x)*x^2
          - 68/3*ln(x)
          - 14*ln(x)*x*Z2
          - 68/3*ln(x)*x
          + 16*ln(x)*x^2*Z2
          + 2*ln(x)*Z2
          + 44*ln(x)*[1-x]^-1
          - 6*ln(x)*ln(1 - x)
          + 34*ln(x)*ln(1 - x)*x
          - 20*ln(x)*ln(1 - x)*[1-x]^-1
          + 6*ln(x)*ln(1 - x)*ln(1 - x)
          + 6*ln(x)*ln(1 - x)*ln(1 - x)*x
          - 20*ln(x)*ln(1 - x)*ln(1 - x)*[1-x]^-1
          + 24*ln(x)*ln(1 + x)
          + 8/3*ln(x)*ln(1 + x)*x^-1
          + 32*ln(x)*ln(1 + x)*x
          + 32/3*ln(x)*ln(1 + x)*x^2
          + 11*ln(x)*ln(x)
          - 23*ln(x)*ln(x)*x
          - 16/3*ln(x)*ln(x)*x^2
          - 15*ln(x)*ln(x)*[1-x]^-1
          - 6*ln(x)*ln(x)*ln(1 - x)
          + 2*ln(x)*ln(x)*ln(1 - x)*x
          - 8*ln(x)*ln(x)*ln(1 - x)*x^2
          - 4*ln(x)*ln(x)*ln(1 - x)*[1-x]^-1
          - 5*ln(x)*ln(x)*ln(x)
          - 5*ln(x)*ln(x)*ln(x)*x
          + 16/3*ln(x)*ln(x)*ln(x)*[1-x]^-1
          - 8*ln(x)*Li2(1 - x)
          + 24*ln(x)*Li2(1 - x)*x
          - 32*ln(x)*Li2(1 - x)*x^2
          - 16*ln(x)*Li2(1 - x)*[1-x]^-1
          - 16*ln(x)*Li2( - x)
          + 16*ln(x)*Li2( - x)*[1-x]^-1
          - 24*Li2(1 - x)
          + 48*Li2(1 - x)*x
          - 4*Li2(1 - x)*[1-x]^-1
          + 24*Li2( - x)
          + 8/3*Li2( - x)*x^-1
          + 32*Li2( - x)*x
          + 32/3*Li2( - x)*x^2
          + 20*Li3(1 - x)
          - 28*Li3(1 - x)*x
          + 48*Li3(1 - x)*x^2
          + 32*Li3( - x)
          - 32*Li3( - x)*[1-x]^-1
          - 8*S12(1 - x)
          + 56*S12(1 - x)*x
          - 48*S12(1 - x)*x^2
          - 32*S12(1 - x)*[1-x]^-1
          )

       + O2*Ca*Cf * (
          - 26/9
          - 8*x*Z2
          - 24*x*Z3
          + 232/9*x
          + 16/3*x^2*Z2
          + 24*x^2*Z3
          + 4*Z2
          - 16/3*ln(1 - x)
          + 8*ln(1 - x)*x*Z2
          - 64/3*ln(1 - x)*x
          - 8*ln(1 - x)*x^2*Z2
          + 8*ln(1 - x)*Li2(1 - x)*x
          - 8*ln(1 - x)*Li2(1 - x)*x^2
          + 6*ln(x)
          - 8*ln(x)*x*Z2
          - 28*ln(x)*x
          + 8*ln(x)*x^2*Z2
          - 4*ln(x)*ln(1 - x)
          + 8*ln(x)*ln(1 - x)*x
          - 8/3*ln(x)*ln(1 + x)*x^-1
          + 8*ln(x)*ln(1 + x)*x
          + 16/3*ln(x)*ln(1 + x)*x^2
          - 8/3*ln(x)*ln(x)*x^2
          + 4*ln(x)*ln(x)*ln(1 - x)*x
          - 4*ln(x)*ln(x)*ln(1 - x)*x^2
          + 16*ln(x)*Li2(1 - x)*x
          - 16*ln(x)*Li2(1 - x)*x^2
          - 8*Li2(1 - x)
          + 16*Li2(1 - x)*x
          - 8/3*Li2( - x)*x^-1
          + 8*Li2( - x)*x
          + 16/3*Li2( - x)*x^2
          - 24*Li3(1 - x)*x
          + 24*Li3(1 - x)*x^2
          + 24*S12(1 - x)*x
          - 24*S12(1 - x)*x^2
          )

       + O2*Cf*Tf * (
          - 8/9
          - 32/9*x
          - 16/3*ln(1 - x)
          + 32/3*ln(1 - x)*x
          - 8/3*ln(x)
          + 16/3*ln(x)*x
          )

       + O2*Cf^2 * (
          - 32/3
          + 16*x*Z2
          + 48*x*Z3
          - 16/3*x
          - 32/3*x^2*Z2
          - 48*x^2*Z3
          - 8*Z2
          - 16*ln(1 - x)*x*Z2
          - 44*ln(1 - x)*x
          + 16*ln(1 - x)*x^2*Z2
          - 24*ln(1 - x)*ln(1 - x)*x
          - 16*ln(1 - x)*Li2(1 - x)*x
          + 16*ln(1 - x)*Li2(1 - x)*x^2
          - 40/3*ln(x)
          + 16*ln(x)*x*Z2
          + 68/3*ln(x)*x
          - 16*ln(x)*x^2*Z2
          + 8*ln(x)*ln(1 - x)
          - 32*ln(x)*ln(1 - x)*x
          + 16/3*ln(x)*ln(1 + x)*x^-1
          - 16*ln(x)*ln(1 + x)*x
          - 32/3*ln(x)*ln(1 + x)*x^2
          + 12*ln(x)*ln(x)*x
          + 16/3*ln(x)*ln(x)*x^2
          - 8*ln(x)*ln(x)*ln(1 - x)*x
          + 8*ln(x)*ln(x)*ln(1 - x)*x^2
          - 32*ln(x)*Li2(1 - x)*x
          + 32*ln(x)*Li2(1 - x)*x^2
          + 16*Li2(1 - x)
          - 48*Li2(1 - x)*x
          + 16/3*Li2( - x)*x^-1
          - 16*Li2( - x)*x
          - 32/3*Li2( - x)*x^2
          + 48*Li3(1 - x)*x
          - 48*Li3(1 - x)*x^2
          - 48*S12(1 - x)*x
          + 48*S12(1 - x)*x^2
          )
          
          \"]//ReleaseHold;\
\>", "Input",
 CellTags->"A moment integral",
 CellLabel->"In[47]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", "aqq", "]"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[48]:="],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{
    FractionBox[
     RowBox[{"O1", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"32", " ", 
         RowBox[{"\[Zeta]", "(", "2", ")"}]}], "-", "18"}], ")"}], " ", 
      RowBox[{"\[Delta]", "(", 
       FormBox[
        RowBox[{"1", "-", "x"}],
        TraditionalForm], ")"}], " ", 
      SubsuperscriptBox["C", "F", "2"]}], 
     SuperscriptBox[
      TagBox["\[CurlyEpsilon]",
       TraditionalForm], "2"]], "+", 
    RowBox[{"\[LeftSkeleton]", "29", "\[RightSkeleton]"}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "m"], " ", 
     SubscriptBox["C", "A"], " ", "O1", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "x"}], " ", 
        RowBox[{
         SuperscriptBox["log", "3"], "(", "x", ")"}]}], "-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"\[LeftSkeleton]", "3", "\[RightSkeleton]"}], "3"], "(", 
          "x", ")"}]}], 
        RowBox[{"x", "+", "1"}]], "+", 
       RowBox[{"\[LeftSkeleton]", "101", "\[RightSkeleton]"}]}], ")"}], " ", 
     SubscriptBox["C", "F"]}]}],
   Short], TraditionalForm]], "Output",
 CellTags->"A moment integral",
 CellLabel->"Out[48]//Short="]
}, Open  ]],

Cell["\<\
By default all bracketed FORM expressions are translated to a Hold[] \
expression.\
\>", "Commentary",
 CellTags->"A moment integral"],

Cell[CellGroupData[{

Cell["FORM2FeynCalc[\"-[(-1)^m]\"]", "Input",
 CellTags->"A moment integral",
 CellLabel->"In[49]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{"Hold", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "m"], "]"}]}], TraditionalForm]], "Output",
 CellTags->"A moment integral",
 CellLabel->"Out[49]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "ReleaseHold"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[50]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "m"]}], TraditionalForm]], "Output",
 CellTags->"A moment integral",
 CellLabel->"Out[50]="]
}, Open  ]],

Cell["\<\
The first moment should be zero, which is verified by Integrate2 in a \
reasonable amount of time. The variable O2 can be set to zero since it is the \
coefficient of unphysical matrix elements.\
\>", "Text",
 CellTags->"A moment integral"],

Cell[TextData[{
 "This calculates for m=1 the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", 
     RowBox[{"1", " "}]], " ", 
    RowBox[{
     SubsuperscriptBox[
      StyleBox[
       OverscriptBox[
        StyleBox["A",
         FontSlant->"Plain"], "^"],
       FontSlant->"Plain"], "qq", 
      RowBox[{"NS", ",", "PHYS"}]], " ", 
     RowBox[{"\[DifferentialD]", "x"}]}], " "}], TraditionalForm]]],
 ":"
}], "Text",
 CellTags->"A moment integral"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Integrate2", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"aqq", "/.", 
      RowBox[{"m", "\[Rule]", "1"}]}], "/.", 
     RowBox[{"O2", "\[Rule]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[51]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"1.5800990000000001`", ",", "0"}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"A moment integral",
 CellLabel->"Out[51]="]
}, Open  ]],

Cell["\<\
If you know that no partial fraction decomposition has to be done then \
Integrate3 will be much faster on an expanded or collected integral:\
\>", "Text",
 CellTags->"A moment integral"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{"Integrate3", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"aqq", "/.", 
        RowBox[{"m", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"O2", "\[Rule]", "0"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[52]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"0.2560160000000007`", ",", "0"}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"A moment integral",
 CellLabel->"Out[52]="]
}, Open  ]],

Cell["Define an auxiliary typesetting function:", "Text",
 CellTags->"A moment integral"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{"big", "[", "a_", "]"}], ",", " ", "f_"}], "]"}], " ", ":=", " ",
    
   RowBox[{"StyleBox", "[", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{"a", ",", " ", "f"}], "]"}], ",", " ", 
     RowBox[{"FontColor", " ", "\[Rule]", " ", 
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "]"}]}], ",", " ", " ", 
     " ", 
     RowBox[{"FontSize", " ", "\[Rule]", " ", "18"}]}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[53]:="],

Cell["The second moment takes a little bit longer.", "Text",
 CellTags->"A moment integral"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Timing", "[", 
   RowBox[{"Collect2", "[", 
    RowBox[{
     RowBox[{"Integrate2", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", " ", "aqq"}], "/.", 
          RowBox[{"m", "\[Rule]", "2"}]}], "/.", 
         RowBox[{"O2", "\[Rule]", "0"}]}], "/.", 
        RowBox[{"O1", "\[Rule]", "1"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"CA", ",", "CF", ",", "Tf"}], "}"}], ",", 
     RowBox[{"Factoring", "\[Rule]", "False"}]}], "]"}], "]"}], "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"CA", " ", "CF"}], " ", "\[RuleDelayed]", " ", 
     RowBox[{"big", "[", " ", 
      RowBox[{"CA", " ", "CF"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"CF", "^", "2"}], "\[RuleDelayed]", 
     RowBox[{"big", "[", 
      RowBox[{"CF", "^", "2"}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"a_", " ", "CF", " ", "Tf"}], " ", "\[RuleDelayed]", 
     RowBox[{"HoldForm", "[", " ", 
      RowBox[{
       RowBox[{"big", "[", 
        RowBox[{"CF", " ", "Tf"}], "]"}], " ", "a"}], "]"}]}]}], 
   "}"}]}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[54]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"2.196136`", ",", 
    RowBox[{
     TagBox[
      RowBox[{
       RowBox[{"(", 
        StyleBox[
         RowBox[{
          SubscriptBox["C", "F"], " ", 
          SubscriptBox["T", "f"]}],
         FontSize->18,
         FontColor->RGBColor[0, 0, 1]], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"16", " ", 
           RowBox[{"\[Zeta]", "(", "2", ")"}]}], "9"], "+", 
         FractionBox["376", 
          RowBox[{"27", " ", 
           TagBox["\[CurlyEpsilon]",
            TraditionalForm]}]], "-", 
         FractionBox["64", 
          RowBox[{"9", " ", 
           SuperscriptBox[
            TagBox["\[CurlyEpsilon]",
             TraditionalForm], "2"]}]], "-", 
         FractionBox["2086", "81"]}], ")"}]}],
      HoldForm], "+", 
     RowBox[{
      RowBox[{"(", 
       StyleBox[
        RowBox[{
         SubscriptBox["C", "A"], " ", 
         SubscriptBox["C", "F"]}],
        FontSize->18,
        FontColor->RGBColor[0, 0, 1]], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"44", " ", 
           RowBox[{"\[Zeta]", "(", "2", ")"}]}], "9"]}], "-", 
        FractionBox["1166", 
         RowBox[{"27", " ", 
          TagBox["\[CurlyEpsilon]",
           TraditionalForm]}]], "+", 
        FractionBox["176", 
         RowBox[{"9", " ", 
          SuperscriptBox[
           TagBox["\[CurlyEpsilon]",
            TraditionalForm], "2"]}]], "-", 
        RowBox[{"12", " ", 
         TagBox[
          RowBox[{"\[Zeta]", "(", 
           TagBox["3",
            Zeta,
            Editable->True,
            Selectable->True], ")"}],
          InterpretTemplate[
           Function[BoxForm`e$, 
            Zeta[BoxForm`e$]]],
          Editable->False,
          Selectable->False]}], "+", 
        FractionBox["12133", "162"]}], ")"}]}], "+", 
     RowBox[{
      StyleBox[
       SubsuperscriptBox["C", "F", "2"],
       FontSize->18,
       FontColor->RGBColor[0, 0, 1]], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"32", " ", 
          RowBox[{"\[Zeta]", "(", "2", ")"}]}], "9"], "+", 
        FractionBox["752", 
         RowBox[{"27", " ", 
          TagBox["\[CurlyEpsilon]",
           TraditionalForm]}]], "-", 
        FractionBox["128", 
         RowBox[{"9", " ", 
          SuperscriptBox[
           TagBox["\[CurlyEpsilon]",
            TraditionalForm], "2"]}]], "+", 
        RowBox[{"8", " ", 
         TagBox[
          RowBox[{"\[Zeta]", "(", 
           TagBox["3",
            Zeta,
            Editable->True,
            Selectable->True], ")"}],
          InterpretTemplate[
           Function[BoxForm`e$, 
            Zeta[BoxForm`e$]]],
          Editable->False,
          Selectable->False]}], "-", 
        FractionBox["3452", "81"]}], ")"}]}]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"A moment integral",
 CellLabel->"Out[54]="]
}, Open  ]],

Cell["\<\
Try to do the general Mellin transform (replace m by OPEm, which has special \
properties):\
\>", "Text",
 CellTags->"A moment integral"],

Cell[BoxData[
 RowBox[{
  RowBox[{"gqq", " ", "=", " ", 
   RowBox[{"Collect2", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"OPEm", "-", "1"}]], 
        RowBox[{"(", 
         RowBox[{"aqq", "/.", 
          RowBox[{"m", "\[Rule]", "OPEm"}]}], ")"}]}], "/.", 
       RowBox[{"O2", "\[Rule]", "0"}]}], "/.", 
      RowBox[{"O1", "\[Rule]", "1"}]}], ",", "x"}], "]"}]}], ";"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[55]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gqq", "//", "Length"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[56]:="],

Cell[BoxData[
 FormBox["102", TraditionalForm]], "Output",
 CellTags->"A moment integral",
 CellLabel->"Out[56]="]
}, Open  ]],

Cell["\<\
There are 102 integrals. However, some of the Mellin transforms cannot be \
done at the moment.\
\>", "Text",
 CellTags->"A moment integral"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ww", "=", 
   RowBox[{"Integrate3", "[", 
    RowBox[{"gqq", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[57]:="],

Cell["\<\
If an integral cannot be performed the head Hold[Integrate3] is substituted \
for Integrate3. Thus, in order to find the list of integrals not done you can \
do:\
\>", "Text",
 CellTags->"A moment integral"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases2", "[", 
  RowBox[{"ww", ",", 
   RowBox[{"Hold", "[", "Integrate3", "]"}]}], "]"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[58]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Hold", "[", "Integrate3", "]"}], "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "1"}]], " ", 
       RowBox[{
        SubscriptBox["S", 
         RowBox[{
          FormBox["1",
           TraditionalForm], 
          FormBox["2",
           TraditionalForm]}]], "(", 
        FormBox[
         SuperscriptBox["x", "2"],
         TraditionalForm], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"Hold", "[", "Integrate3", "]"}], "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       RowBox[{
        SubscriptBox["S", 
         RowBox[{
          FormBox["1",
           TraditionalForm], 
          FormBox["2",
           TraditionalForm]}]], "(", 
        FormBox[
         SuperscriptBox["x", "2"],
         TraditionalForm], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"Hold", "[", "Integrate3", "]"}], "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{
         SubscriptBox["S", 
          RowBox[{
           FormBox["1",
            TraditionalForm], 
           FormBox["2",
            TraditionalForm]}]], "(", 
         FormBox[
          SuperscriptBox["x", "2"],
          TraditionalForm], ")"}]}], 
       RowBox[{"x", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"Hold", "[", "Integrate3", "]"}], "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{"log", "(", 
         RowBox[{"1", "-", "x"}], ")"}], " ", 
        RowBox[{
         SubscriptBox[
          InterpretationBox["Li",
           PolyLog,
           Editable->False,
           Selectable->False], "2"], "(", 
         RowBox[{"1", "-", "x"}], ")"}]}], 
       RowBox[{"x", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"Hold", "[", "Integrate3", "]"}], "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "1"}]], " ", 
       RowBox[{"log", "(", 
        RowBox[{"x", "+", "1"}], ")"}], " ", 
       RowBox[{
        SubscriptBox[
         InterpretationBox["Li",
          PolyLog,
          Editable->False,
          Selectable->False], "2"], "(", 
        RowBox[{"1", "-", "x"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"Hold", "[", "Integrate3", "]"}], "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       RowBox[{"log", "(", 
        RowBox[{"x", "+", "1"}], ")"}], " ", 
       RowBox[{
        SubscriptBox[
         InterpretationBox["Li",
          PolyLog,
          Editable->False,
          Selectable->False], "2"], "(", 
        RowBox[{"1", "-", "x"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{
     RowBox[{"Hold", "[", "Integrate3", "]"}], "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{"log", "(", 
         RowBox[{"x", "+", "1"}], ")"}], " ", 
        RowBox[{
         SubscriptBox[
          InterpretationBox["Li",
           PolyLog,
           Editable->False,
           Selectable->False], "2"], "(", 
         RowBox[{"1", "-", "x"}], ")"}]}], 
       RowBox[{"x", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "}"}], 
  TraditionalForm]], "Output",
 CellTags->"A moment integral",
 CellLabel->"Out[58]="]
}, Open  ]],

Cell[TextData[{
 "Change the appearance and retain only those integrals with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "-", "1"}]], ":"}], TraditionalForm]]]
}], "Text",
 CellTags->"A moment integral"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select2", "[", 
   RowBox[{"%", ",", 
    SuperscriptBox["x", 
     RowBox[{"OPEm", "-", "1"}]]}], "]"}], "/.", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Hold", "[", "Integrate3", "]"}], "[", "z__", "]"}], 
   "\[RuleDelayed]", " ", 
   RowBox[{"HoldForm", "[", 
    RowBox[{"Integrate", "[", "z", "]"}], "]"}]}]}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[59]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    TagBox[
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{
         SubscriptBox["S", 
          RowBox[{
           FormBox["1",
            TraditionalForm], 
           FormBox["2",
            TraditionalForm]}]], "(", 
         FormBox[
          SuperscriptBox["x", "2"],
          TraditionalForm], ")"}]}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}],
     HoldForm], ",", 
    TagBox[
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "1"}]], " ", 
         RowBox[{
          SubscriptBox["S", 
           RowBox[{
            FormBox["1",
             TraditionalForm], 
            FormBox["2",
             TraditionalForm]}]], "(", 
          FormBox[
           SuperscriptBox["x", "2"],
           TraditionalForm], ")"}]}], 
        RowBox[{"x", "+", "1"}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}],
     HoldForm], ",", 
    TagBox[
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "1"}]], " ", 
         RowBox[{"log", "(", 
          RowBox[{"1", "-", "x"}], ")"}], " ", 
         RowBox[{
          SubscriptBox[
           InterpretationBox["Li",
            PolyLog,
            Editable->False,
            Selectable->False], "2"], "(", 
          RowBox[{"1", "-", "x"}], ")"}]}], 
        RowBox[{"x", "+", "1"}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}],
     HoldForm], ",", 
    TagBox[
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{"log", "(", 
         RowBox[{"x", "+", "1"}], ")"}], " ", 
        RowBox[{
         SubscriptBox[
          InterpretationBox["Li",
           PolyLog,
           Editable->False,
           Selectable->False], "2"], "(", 
         RowBox[{"1", "-", "x"}], ")"}]}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}],
     HoldForm], ",", 
    TagBox[
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "1"}]], " ", 
         RowBox[{"log", "(", 
          RowBox[{"x", "+", "1"}], ")"}], " ", 
         RowBox[{
          SubscriptBox[
           InterpretationBox["Li",
            PolyLog,
            Editable->False,
            Selectable->False], "2"], "(", 
          RowBox[{"1", "-", "x"}], ")"}]}], 
        RowBox[{"x", "+", "1"}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}],
     HoldForm]}], "}"}], TraditionalForm]], "Output",
 CellTags->"A moment integral",
 CellLabel->"Out[59]="]
}, Open  ]],

Cell["\<\
If you know the answers for these integrals please share the knowledge.\
\>", "Text",
 CellTags->"A moment integral"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"e", ",", "ww", ",", "gqq", ",", "big", ",", "aqq"}], 
  "]"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[60]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"FORM2FeynCalc", ",", 
    RowBox[{"Replace", "\[Rule]", 
     RowBox[{"{", "}"}]}]}], "]"}], ";"}]], "Input",
 CellTags->"A moment integral",
 CellLabel->"In[61]:="],

Cell[TextData[{
 "See also: ",
 ButtonBox["CA",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CA"],
 ", ",
 ButtonBox["CF",
  BaseStyle->"AddOnsLink",
  ButtonData:>"CF"],
 ", ",
 ButtonBox["Cases2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Cases2"],
 ", ",
 ButtonBox["Collect2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Collect2"],
 ", ",
 ButtonBox["DeltaFunction",
  BaseStyle->"AddOnsLink",
  ButtonData:>"DeltaFunction"],
 ", ",
 ButtonBox["Epsilon",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Epsilon"],
 ", ",
 ButtonBox["FORM2FeynCalc",
  BaseStyle->"AddOnsLink",
  ButtonData:>"FORM2FeynCalc"],
 ", ",
 ButtonBox["Integrate2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Integrate3"],
 ", ",
 ButtonBox["Integrate3",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Integrate3"],
 ", ",
 ButtonBox["Li2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Li2"],
 ", ",
 ButtonBox["Li3",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Li3"],
 ", ",
 ButtonBox["Nielsen",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Nielsen"],
 ", ",
 ButtonBox["Zeta2",
  BaseStyle->"AddOnsLink",
  ButtonData:>"Zeta2"],
 "."
}], "Text",
 CellTags->"A moment integral"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
ScreenStyleEnvironment->"AllBrackets",
WindowToolbars->"EditBar",
EvaluationCompletionAction->{},
CellGrouping->Manual,
WindowSize->{945, 853},
WindowMargins->{{41, Automatic}, {Automatic, 21}},
PrintingStartingPageNumber->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Inherited, 
   Cell[
    TextData[
     ValueBox["FileName"]], "Header"], Inherited}, {Inherited, 
   Cell[
    TextData[
     ValueBox["FileName"]], "Header"], Inherited}},
PageFooters->{{Inherited, 
   Cell[
    TextData[
     ValueBox["DateLong"]], "Footer"], Inherited}, {Inherited, 
   Cell[
    TextData[
     ValueBox["DateLong"]], "Footer"], Inherited}},
PrintingOptions->{"FacingPages"->True,
"FirstPageFace"->Left,
"FirstPageFooter"->True,
"FirstPageHeader"->False,
"GraphicsPrintingFormat"->"Automatic",
"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{597.5625, 842.375},
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->True,
"PrintSelectionHighlighting"->False,
"PrintingMargins"->{{54., 54.}, {72., 72.}}},
PrivateNotebookOptions->{"ShortBoxForm"->False},
ShowSelection->True,
TaggingRules:>{
 "MakeContentsNonDefaultOptions" -> {$CellContext`AutomaticCellTagging -> \
$CellContext`FromContent, $CellContext`PageNumbers -> 
    False, $CellContext`SaveOptions -> 
    True, $CellContext`SelectCellStyles -> {
     "Section", "Subsection"}, $CellContext`TOCCellStyles -> {
     "Contents", "Index"}}},
CellLabelAutoDelete->True,
ShowCellTags->True,
Magnification->1.,
FrontEndVersion->"6.0 for Linux x86 (64-bit) (March 26, 2007)",
StyleDefinitions->"HelpBrowser.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ClickSave"->{
  Cell[1189, 47, 1061, 25, 52, NotebookDefault,
   CellTags->"ClickSave"]},
 "Short Overview"->{
  Cell[2275, 76, 94, 2, 81, "Section",
   PageBreakAbove->True,
   CellTags->{"Short Overview", "intro"}]},
 "intro"->{
  Cell[2275, 76, 94, 2, 81, "Section",
   PageBreakAbove->True,
   CellTags->{"Short Overview", "intro"}],
  Cell[2372, 80, 854, 20, 124, "Text",
   CellTags->"intro"],
  Cell[3229, 102, 507, 15, 41, "Text",
   CellTags->"intro"],
  Cell[5014, 183, 73, 1, 41, "Text",
   CellTags->"intro"],
  Cell[5090, 186, 1569, 71, 59, "Text",
   CellTags->"intro"],
  Cell[6662, 259, 90, 1, 41, "Text",
   CellTags->"intro"],
  Cell[6755, 262, 317, 14, 41, "Text",
   CellTags->"intro"],
  Cell[7075, 278, 1116, 27, 131, "Text",
   CellTags->"intro"],
  Cell[8194, 307, 576, 10, 95, "Text",
   CellTags->"intro"],
  Cell[8773, 319, 524, 20, 41, "Text",
   CellTags->"intro"],
  Cell[9300, 341, 93, 1, 41, "Text",
   CellTags->"intro"],
  Cell[9396, 344, 226, 8, 41, "Text",
   CellTags->"intro"],
  Cell[9625, 354, 274, 7, 59, "Text",
   CellTags->"intro"],
  Cell[9902, 363, 437, 12, 37, "SmallText",
   CellTags->{"intro", "introfoot"}]},
 "introfoot"->{
  Cell[9902, 363, 437, 12, 37, "SmallText",
   CellTags->{"intro", "introfoot"}]},
 "Load FeynCalc"->{
  Cell[10376, 380, 75, 1, 81, "Section",
   CellTags->{"Load FeynCalc", "start"}]},
 "start"->{
  Cell[10376, 380, 75, 1, 81, "Section",
   CellTags->{"Load FeynCalc", "start"}],
  Cell[10454, 383, 347, 10, 59, "Text",
   CellTags->"start"],
  Cell[10804, 395, 114, 3, 44, "Input",
   CellTags->"start"],
  Cell[11460, 422, 63, 1, 57, "MathCaption",
   CellTags->"start"],
  Cell[11526, 425, 225, 7, 41, "Text",
   CellTags->"start"],
  Cell[11754, 434, 489, 14, 79, "Text",
   CellTags->"start"],
  Cell[12246, 450, 308, 9, 44, "Input",
   CellTags->"start"],
  Cell[12557, 461, 93, 1, 57, "MathCaption",
   CellTags->"start"],
  Cell[12675, 466, 206, 7, 44, "Input",
   CellTags->"start"],
  Cell[12884, 475, 184, 6, 42, "Output",
   CellTags->"start"],
  Cell[13083, 484, 97, 1, 57, "MathCaption",
   CellTags->"start"],
  Cell[13183, 487, 312, 9, 44, "Input",
   CellTags->"start"],
  Cell[13498, 498, 96, 1, 57, "MathCaption",
   CellTags->"start"],
  Cell[13619, 503, 206, 7, 44, "Input",
   CellTags->"start"],
  Cell[13828, 512, 222, 7, 43, "Output",
   CellTags->"start"],
  Cell[14065, 522, 99, 1, 57, "MathCaption",
   CellTags->"start"],
  Cell[14167, 525, 575, 16, 66, "Input",
   CellTags->"start"],
  Cell[14745, 543, 247, 9, 57, "MathCaption",
   CellTags->"start"],
  Cell[15017, 556, 206, 7, 44, "Input",
   CellTags->"start"],
  Cell[15226, 565, 376, 13, 43, "Output",
   CellTags->"start"],
  Cell[15617, 581, 214, 9, 57, "MathCaption",
   CellTags->"start"],
  Cell[15856, 594, 105, 3, 44, "Input",
   CellTags->"start"],
  Cell[15964, 599, 199, 6, 57, "Output",
   CellTags->"start"],
  Cell[16178, 608, 142, 4, 57, "MathCaption",
   CellTags->"start"]},
 "About Extras"->{
  Cell[16357, 617, 86, 2, 81, "Section",
   PageBreakAbove->True,
   CellTags->"About Extras"],
  Cell[16446, 621, 593, 13, 95, "Text",
   CellTags->"About Extras"],
  Cell[17042, 636, 1249, 35, 91, "Text",
   CellTags->"About Extras"],
  Cell[18294, 673, 104, 1, 33, "Caption",
   CellTags->"About Extras"]},
 "tarcer"->{
  Cell[18423, 678, 188, 7, 79, "Subsection",
   CellTags->"tarcer"],
  Cell[18614, 687, 68, 1, 48, "InspectorLevel2",
   CellTags->"tarcer"],
  Cell[18685, 690, 247, 8, 41, "Text",
   CellTags->"tarcer"],
  Cell[18935, 700, 226, 10, 41, "Text",
   CellTags->"tarcer"],
  Cell[19164, 712, 60, 1, 52, "Subsubsection",
   CellTags->"tarcer"],
  Cell[19227, 715, 610, 15, 73, "Text",
   CellTags->"tarcer"],
  Cell[19840, 732, 324, 8, 59, "Text",
   CellTags->"tarcer"],
  Cell[20167, 742, 125, 4, 44, "Input",
   CellTags->"tarcer"],
  Cell[20295, 748, 246, 8, 41, "Text",
   CellTags->"tarcer"],
  Cell[20544, 758, 288, 9, 41, "Text",
   CellTags->"tarcer"]},
 "phi"->{
  Cell[20869, 772, 148, 6, 79, "Subsection",
   CellTags->"phi"],
  Cell[21020, 780, 59, 1, 48, "InspectorLevel2",
   CellTags->"phi"],
  Cell[21082, 783, 416, 9, 77, "Text",
   CellTags->"phi"],
  Cell[21501, 794, 69, 1, 41, "Text",
   CellTags->"phi"],
  Cell[21573, 797, 119, 4, 44, "Input",
   CellTags->"phi"],
  Cell[21695, 803, 233, 8, 41, "Text",
   CellTags->"phi"],
  Cell[21931, 813, 268, 9, 41, "Text",
   CellTags->"phi"]},
 "fa"->{
  Cell[22236, 827, 47, 1, 56, "Subsection",
   CellTags->"fa"],
  Cell[22286, 830, 104, 3, 48, "InspectorLevel2",
   CellTags->"fa"],
  Cell[22393, 835, 243, 8, 41, "Text",
   CellTags->"fa"],
  Cell[22639, 845, 298, 11, 41, "Text",
   CellTags->"fa"],
  Cell[22940, 858, 449, 8, 77, "Text",
   CellTags->"fa"],
  Cell[23392, 868, 292, 6, 59, "Text",
   CellTags->"fa"],
  Cell[23687, 876, 357, 10, 59, "Text",
   CellTags->"fa"],
  Cell[24047, 888, 186, 6, 66, "Input",
   CellTags->"fa"],
  Cell[24236, 896, 234, 8, 41, "Text",
   CellTags->"fa"],
  Cell[24473, 906, 522, 16, 59, "Text",
   CellTags->"fa"]},
 "Example Calculations"->{
  Cell[25044, 928, 105, 2, 81, "Section",
   PageBreakAbove->True,
   CellTags->{"Example Calculations", "ex"}]},
 "ex"->{
  Cell[25044, 928, 105, 2, 81, "Section",
   PageBreakAbove->True,
   CellTags->{"Example Calculations", "ex"}],
  Cell[25152, 932, 304, 9, 47, "Commentary",
   CellTags->"ex"]},
 "Tree level"->{
  Cell[25481, 945, 303, 11, 56, "Subsection",
   CellTags->"Tree level"],
  Cell[25787, 958, 85, 1, 41, "Text",
   CellTags->"Tree level"],
  Cell[25875, 961, 373, 7, 108, "Input",
   CellTags->"Tree level"],
  Cell[26251, 970, 98, 1, 41, "Text",
   CellTags->"Tree level"],
  Cell[26374, 975, 283, 8, 44, "Input",
   CellTags->"Tree level"],
  Cell[26660, 985, 988, 37, 43, "Output",
   CellTags->"Tree level"],
  Cell[27663, 1025, 2023, 77, 59, "Text",
   CellTags->"Tree level"],
  Cell[29689, 1104, 304, 10, 44, "Input",
   CellTags->"Tree level"],
  Cell[29996, 1116, 278, 9, 44, "Input",
   CellTags->"Tree level"],
  Cell[30277, 1127, 304, 10, 44, "Input",
   CellTags->"Tree level"],
  Cell[30584, 1139, 252, 8, 44, "Input",
   CellTags->"Tree level"],
  Cell[30839, 1149, 252, 8, 44, "Input",
   CellTags->"Tree level"],
  Cell[31094, 1159, 384, 12, 44, "Input",
   CellTags->"Tree level"],
  Cell[31481, 1173, 63, 1, 41, "Text",
   CellTags->"Tree level"],
  Cell[31569, 1178, 283, 8, 44, "Input",
   CellTags->"Tree level"],
  Cell[31855, 1188, 841, 32, 43, "Output",
   CellTags->"Tree level"],
  Cell[32733, 1225, 283, 8, 44, "Input",
   CellTags->"Tree level"],
  Cell[33019, 1235, 841, 32, 43, "Output",
   CellTags->"Tree level"],
  Cell[33897, 1272, 283, 8, 44, "Input",
   CellTags->"Tree level"],
  Cell[34183, 1282, 841, 32, 43, "Output",
   CellTags->"Tree level"],
  Cell[35061, 1319, 283, 8, 44, "Input",
   CellTags->"Tree level"],
  Cell[35347, 1329, 841, 32, 43, "Output",
   CellTags->"Tree level"],
  Cell[36203, 1364, 68, 1, 41, "Text",
   CellTags->"Tree level"],
  Cell[43168, 1605, 109, 2, 44, "Input",
   CellTags->"Tree level"],
  Cell[43280, 1609, 1227, 45, 27, "Output",
   CellTags->"Tree level"],
  Cell[44544, 1659, 109, 2, 44, "Input",
   CellTags->"Tree level"],
  Cell[44656, 1663, 967, 35, 27, "Output",
   CellTags->"Tree level"],
  Cell[45660, 1703, 109, 2, 44, "Input",
   CellTags->"Tree level"],
  Cell[45772, 1707, 967, 35, 27, "Output",
   CellTags->"Tree level"],
  Cell[46776, 1747, 109, 2, 44, "Input",
   CellTags->"Tree level"],
  Cell[46888, 1751, 1227, 45, 27, "Output",
   CellTags->"Tree level"],
  Cell[48130, 1799, 90, 1, 41, "Text",
   CellTags->"Tree level"],
  Cell[48245, 1804, 714, 23, 83, "Input",
   CellTags->"Tree level"],
  Cell[48962, 1829, 4563, 170, 62, "Output",
   CellTags->"Tree level"],
  Cell[53540, 2002, 135, 6, 41, "Text",
   CellTags->"Tree level"],
  Cell[53700, 2012, 164, 5, 44, "Input",
   CellTags->"Tree level"],
  Cell[53867, 2019, 4539, 167, 64, "Output",
   CellTags->"Tree level"],
  Cell[58421, 2189, 273, 11, 41, "Text",
   CellTags->"Tree level"],
  Cell[58719, 2204, 324, 10, 44, "Input",
   CellTags->"Tree level"],
  Cell[59046, 2216, 105, 3, 43, "Output",
   CellTags->"Tree level"],
  Cell[59166, 2222, 134, 4, 41, "Text",
   CellTags->"Tree level"],
  Cell[59303, 2228, 219, 6, 44, "Input",
   CellTags->"Tree level"],
  Cell[59525, 2236, 599, 27, 41, "Text",
   CellTags->"Tree level"]},
 "Info3387713579-2928036"->{
  Cell[40298, 1520, 1649, 27, 100, "Print",
   CellTags->"Info3387713579-2928036"]},
 "A moment integral"->{
  Cell[60161, 2268, 71, 1, 56, "Subsection",
   CellTags->"A moment integral"],
  Cell[60235, 2271, 787, 28, 69, "Text",
   CellTags->"A moment integral"],
  Cell[61085, 2303, 139, 4, 44, "Input",
   CellTags->"A moment integral"],
  Cell[61227, 2309, 349, 9, 59, "Text",
   CellTags->"A moment integral"],
  Cell[61579, 2320, 213, 5, 59, "Text",
   CellTags->"A moment integral"],
  Cell[61795, 2327, 1687, 32, 154, "Input",
   CellTags->"A moment integral"],
  Cell[63485, 2361, 166, 4, 41, "Text",
   CellTags->"A moment integral"],
  Cell[63654, 2367, 17159, 630, 13347, "Input",
   CellTags->"A moment integral"],
  Cell[80838, 3001, 116, 3, 44, "Input",
   CellTags->"A moment integral"],
  Cell[80957, 3006, 1299, 41, 75, "Output",
   CellTags->"A moment integral"],
  Cell[82271, 3050, 144, 4, 47, "Commentary",
   CellTags->"A moment integral"],
  Cell[82440, 3058, 101, 2, 44, "Input",
   CellTags->"A moment integral"],
  Cell[82544, 3062, 236, 8, 43, "Output",
   CellTags->"A moment integral"],
  Cell[82817, 3075, 116, 3, 44, "Input",
   CellTags->"A moment integral"],
  Cell[82936, 3080, 201, 7, 43, "Output",
   CellTags->"A moment integral"],
  Cell[83152, 3090, 250, 5, 59, "Text",
   CellTags->"A moment integral"],
  Cell[83405, 3097, 498, 18, 47, "Text",
   CellTags->"A moment integral"],
  Cell[83928, 3119, 358, 11, 44, "Input",
   CellTags->"A moment integral"],
  Cell[84289, 3132, 180, 6, 43, "Output",
   CellTags->"A moment integral"],
  Cell[84484, 3141, 197, 4, 41, "Text",
   CellTags->"A moment integral"],
  Cell[84706, 3149, 442, 14, 44, "Input",
   CellTags->"A moment integral"],
  Cell[85151, 3165, 180, 6, 43, "Output",
   CellTags->"A moment integral"],
  Cell[85346, 3174, 89, 1, 41, "Text",
   CellTags->"A moment integral"],
  Cell[85438, 3177, 598, 18, 44, "Input",
   CellTags->"A moment integral"],
  Cell[86039, 3197, 92, 1, 41, "Text",
   CellTags->"A moment integral"],
  Cell[86156, 3202, 1240, 37, 88, "Input",
   CellTags->"A moment integral"],
  Cell[87399, 3241, 2995, 100, 100, "Output",
   CellTags->"A moment integral"],
  Cell[90409, 3344, 147, 4, 41, "Text",
   CellTags->"A moment integral"],
  Cell[90559, 3350, 508, 16, 44, "Input",
   CellTags->"A moment integral"],
  Cell[91092, 3370, 113, 3, 44, "Input",
   CellTags->"A moment integral"],
  Cell[91208, 3375, 114, 3, 43, "Output",
   CellTags->"A moment integral"],
  Cell[91337, 3381, 151, 4, 41, "Text",
   CellTags->"A moment integral"],
  Cell[91491, 3387, 252, 8, 44, "Input",
   CellTags->"A moment integral"],
  Cell[91746, 3397, 217, 5, 59, "Text",
   CellTags->"A moment integral"],
  Cell[91988, 3406, 180, 5, 44, "Input",
   CellTags->"A moment integral"],
  Cell[92171, 3413, 3940, 132, 138, "Output",
   CellTags->"A moment integral"],
  Cell[96126, 3548, 243, 8, 41, "Text",
   CellTags->"A moment integral"],
  Cell[96394, 3560, 416, 13, 44, "Input",
   CellTags->"A moment integral"],
  Cell[96813, 3575, 2974, 103, 61, "Output",
   CellTags->"A moment integral"],
  Cell[99802, 3681, 127, 3, 41, "Text",
   CellTags->"A moment integral"],
  Cell[99932, 3686, 177, 5, 44, "Input",
   CellTags->"A moment integral"],
  Cell[100112, 3693, 231, 7, 44, "Input",
   CellTags->"A moment integral"],
  Cell[100346, 3702, 1134, 55, 59, "Text",
   CellTags->"A moment integral"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ClickSave", 103262, 3817},
 {"Short Overview", 103359, 3820},
 {"intro", 103479, 3824},
 {"introfoot", 104424, 3854},
 {"Load FeynCalc", 104527, 3857},
 {"start", 104623, 3860},
 {"About Extras", 106223, 3909},
 {"tarcer", 106546, 3919},
 {"phi", 107214, 3940},
 {"fa", 107660, 3955},
 {"Example Calculations", 108298, 3976},
 {"ex", 108421, 3980},
 {"Tree level", 108617, 3986},
 {"Info3387713579-2928036", 111638, 4073},
 {"A moment integral", 111747, 4076}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 53, 1, 104, "Title"],
Cell[646, 26, 87, 1, 66, "Subtitle"],
Cell[736, 29, 120, 3, 66, "Subtitle",
 PageBreakBelow->True],
Cell[859, 34, 80, 1, 53, "Subsubtitle"],
Cell[942, 37, 244, 8, 53, "Subsubtitle"],
Cell[1189, 47, 1061, 25, 52, NotebookDefault,
 CellTags->"ClickSave"],
Cell[CellGroupData[{
Cell[2275, 76, 94, 2, 81, "Section",
 PageBreakAbove->True,
 CellTags->{"Short Overview", "intro"}],
Cell[2372, 80, 854, 20, 124, "Text",
 CellTags->"intro"],
Cell[3229, 102, 507, 15, 41, "Text",
 CellTags->"intro"],
Cell[3739, 119, 1272, 62, 43, "Text"],
Cell[5014, 183, 73, 1, 41, "Text",
 CellTags->"intro"],
Cell[5090, 186, 1569, 71, 59, "Text",
 CellTags->"intro"],
Cell[6662, 259, 90, 1, 41, "Text",
 CellTags->"intro"],
Cell[6755, 262, 317, 14, 41, "Text",
 CellTags->"intro"],
Cell[7075, 278, 1116, 27, 131, "Text",
 CellTags->"intro"],
Cell[8194, 307, 576, 10, 95, "Text",
 CellTags->"intro"],
Cell[8773, 319, 524, 20, 41, "Text",
 CellTags->"intro"],
Cell[9300, 341, 93, 1, 41, "Text",
 CellTags->"intro"],
Cell[9396, 344, 226, 8, 41, "Text",
 CellTags->"intro"],
Cell[9625, 354, 274, 7, 59, "Text",
 CellTags->"intro"],
Cell[9902, 363, 437, 12, 37, "SmallText",
 CellTags->{"intro", "introfoot"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[10376, 380, 75, 1, 81, "Section",
 CellTags->{"Load FeynCalc", "start"}],
Cell[10454, 383, 347, 10, 59, "Text",
 CellTags->"start"],
Cell[10804, 395, 114, 3, 44, "Input",
 CellTags->"start"],
Cell[CellGroupData[{
Cell[10943, 402, 157, 5, 28, "Input"],
Cell[11103, 409, 342, 10, 27, "Output"]
}, Open  ]],
Cell[11460, 422, 63, 1, 57, "MathCaption",
 CellTags->"start"],
Cell[11526, 425, 225, 7, 41, "Text",
 CellTags->"start"],
Cell[11754, 434, 489, 14, 79, "Text",
 CellTags->"start"],
Cell[12246, 450, 308, 9, 44, "Input",
 CellTags->"start"],
Cell[12557, 461, 93, 1, 57, "MathCaption",
 CellTags->"start"],
Cell[CellGroupData[{
Cell[12675, 466, 206, 7, 44, "Input",
 CellTags->"start"],
Cell[12884, 475, 184, 6, 42, "Output",
 CellTags->"start"]
}, Open  ]],
Cell[13083, 484, 97, 1, 57, "MathCaption",
 CellTags->"start"],
Cell[13183, 487, 312, 9, 44, "Input",
 CellTags->"start"],
Cell[13498, 498, 96, 1, 57, "MathCaption",
 CellTags->"start"],
Cell[CellGroupData[{
Cell[13619, 503, 206, 7, 44, "Input",
 CellTags->"start"],
Cell[13828, 512, 222, 7, 43, "Output",
 CellTags->"start"]
}, Open  ]],
Cell[14065, 522, 99, 1, 57, "MathCaption",
 CellTags->"start"],
Cell[14167, 525, 575, 16, 66, "Input",
 CellTags->"start"],
Cell[14745, 543, 247, 9, 57, "MathCaption",
 CellTags->"start"],
Cell[CellGroupData[{
Cell[15017, 556, 206, 7, 44, "Input",
 CellTags->"start"],
Cell[15226, 565, 376, 13, 43, "Output",
 CellTags->"start"]
}, Open  ]],
Cell[15617, 581, 214, 9, 57, "MathCaption",
 CellTags->"start"],
Cell[CellGroupData[{
Cell[15856, 594, 105, 3, 44, "Input",
 CellTags->"start"],
Cell[15964, 599, 199, 6, 57, "Output",
 CellTags->"start"]
}, Open  ]],
Cell[16178, 608, 142, 4, 57, "MathCaption",
 CellTags->"start"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16357, 617, 86, 2, 81, "Section",
 PageBreakAbove->True,
 CellTags->"About Extras"],
Cell[16446, 621, 593, 13, 95, "Text",
 CellTags->"About Extras"],
Cell[17042, 636, 1249, 35, 91, "Text",
 CellTags->"About Extras"],
Cell[18294, 673, 104, 1, 33, "Caption",
 CellTags->"About Extras"],
Cell[CellGroupData[{
Cell[18423, 678, 188, 7, 79, "Subsection",
 CellTags->"tarcer"],
Cell[18614, 687, 68, 1, 48, "InspectorLevel2",
 CellTags->"tarcer"],
Cell[18685, 690, 247, 8, 41, "Text",
 CellTags->"tarcer"],
Cell[18935, 700, 226, 10, 41, "Text",
 CellTags->"tarcer"],
Cell[19164, 712, 60, 1, 52, "Subsubsection",
 CellTags->"tarcer"],
Cell[19227, 715, 610, 15, 73, "Text",
 CellTags->"tarcer"],
Cell[19840, 732, 324, 8, 59, "Text",
 CellTags->"tarcer"],
Cell[20167, 742, 125, 4, 44, "Input",
 CellTags->"tarcer"],
Cell[20295, 748, 246, 8, 41, "Text",
 CellTags->"tarcer"],
Cell[20544, 758, 288, 9, 41, "Text",
 CellTags->"tarcer"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20869, 772, 148, 6, 79, "Subsection",
 CellTags->"phi"],
Cell[21020, 780, 59, 1, 48, "InspectorLevel2",
 CellTags->"phi"],
Cell[21082, 783, 416, 9, 77, "Text",
 CellTags->"phi"],
Cell[21501, 794, 69, 1, 41, "Text",
 CellTags->"phi"],
Cell[21573, 797, 119, 4, 44, "Input",
 CellTags->"phi"],
Cell[21695, 803, 233, 8, 41, "Text",
 CellTags->"phi"],
Cell[21931, 813, 268, 9, 41, "Text",
 CellTags->"phi"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22236, 827, 47, 1, 56, "Subsection",
 CellTags->"fa"],
Cell[22286, 830, 104, 3, 48, "InspectorLevel2",
 CellTags->"fa"],
Cell[22393, 835, 243, 8, 41, "Text",
 CellTags->"fa"],
Cell[22639, 845, 298, 11, 41, "Text",
 CellTags->"fa"],
Cell[22940, 858, 449, 8, 77, "Text",
 CellTags->"fa"],
Cell[23392, 868, 292, 6, 59, "Text",
 CellTags->"fa"],
Cell[23687, 876, 357, 10, 59, "Text",
 CellTags->"fa"],
Cell[24047, 888, 186, 6, 66, "Input",
 CellTags->"fa"],
Cell[24236, 896, 234, 8, 41, "Text",
 CellTags->"fa"],
Cell[24473, 906, 522, 16, 59, "Text",
 CellTags->"fa"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25044, 928, 105, 2, 81, "Section",
 PageBreakAbove->True,
 CellTags->{"Example Calculations", "ex"}],
Cell[25152, 932, 304, 9, 47, "Commentary",
 CellTags->"ex"],
Cell[CellGroupData[{
Cell[25481, 945, 303, 11, 56, "Subsection",
 CellTags->"Tree level"],
Cell[25787, 958, 85, 1, 41, "Text",
 CellTags->"Tree level"],
Cell[25875, 961, 373, 7, 108, "Input",
 CellTags->"Tree level"],
Cell[26251, 970, 98, 1, 41, "Text",
 CellTags->"Tree level"],
Cell[CellGroupData[{
Cell[26374, 975, 283, 8, 44, "Input",
 CellTags->"Tree level"],
Cell[26660, 985, 988, 37, 43, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[27663, 1025, 2023, 77, 59, "Text",
 CellTags->"Tree level"],
Cell[29689, 1104, 304, 10, 44, "Input",
 CellTags->"Tree level"],
Cell[29996, 1116, 278, 9, 44, "Input",
 CellTags->"Tree level"],
Cell[30277, 1127, 304, 10, 44, "Input",
 CellTags->"Tree level"],
Cell[30584, 1139, 252, 8, 44, "Input",
 CellTags->"Tree level"],
Cell[30839, 1149, 252, 8, 44, "Input",
 CellTags->"Tree level"],
Cell[31094, 1159, 384, 12, 44, "Input",
 CellTags->"Tree level"],
Cell[31481, 1173, 63, 1, 41, "Text",
 CellTags->"Tree level"],
Cell[CellGroupData[{
Cell[31569, 1178, 283, 8, 44, "Input",
 CellTags->"Tree level"],
Cell[31855, 1188, 841, 32, 43, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32733, 1225, 283, 8, 44, "Input",
 CellTags->"Tree level"],
Cell[33019, 1235, 841, 32, 43, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33897, 1272, 283, 8, 44, "Input",
 CellTags->"Tree level"],
Cell[34183, 1282, 841, 32, 43, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35061, 1319, 283, 8, 44, "Input",
 CellTags->"Tree level"],
Cell[35347, 1329, 841, 32, 43, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[36203, 1364, 68, 1, 41, "Text",
 CellTags->"Tree level"],
Cell[CellGroupData[{
Cell[36296, 1369, 251, 8, 28, "Input"],
Cell[36550, 1379, 2091, 79, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38678, 1463, 82, 2, 28, "Input"],
Cell[38763, 1467, 391, 8, 102, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39191, 1480, 93, 2, 28, "Input"],
Cell[39287, 1484, 638, 15, 49, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39962, 1504, 89, 2, 28, "Input"],
Cell[40054, 1508, 127, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40218, 1516, 77, 2, 28, "Input"],
Cell[40298, 1520, 1649, 27, 100, "Print",
 CellTags->"Info3387713579-2928036"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41984, 1552, 397, 11, 28, "Input"],
Cell[42384, 1565, 316, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42737, 1583, 74, 2, 28, "Input"],
Cell[42814, 1587, 317, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43168, 1605, 109, 2, 44, "Input",
 CellTags->"Tree level"],
Cell[43280, 1609, 1227, 45, 27, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44544, 1659, 109, 2, 44, "Input",
 CellTags->"Tree level"],
Cell[44656, 1663, 967, 35, 27, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45660, 1703, 109, 2, 44, "Input",
 CellTags->"Tree level"],
Cell[45772, 1707, 967, 35, 27, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46776, 1747, 109, 2, 44, "Input",
 CellTags->"Tree level"],
Cell[46888, 1751, 1227, 45, 27, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[48130, 1799, 90, 1, 41, "Text",
 CellTags->"Tree level"],
Cell[CellGroupData[{
Cell[48245, 1804, 714, 23, 83, "Input",
 CellTags->"Tree level"],
Cell[48962, 1829, 4563, 170, 62, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[53540, 2002, 135, 6, 41, "Text",
 CellTags->"Tree level"],
Cell[CellGroupData[{
Cell[53700, 2012, 164, 5, 44, "Input",
 CellTags->"Tree level"],
Cell[53867, 2019, 4539, 167, 64, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[58421, 2189, 273, 11, 41, "Text",
 CellTags->"Tree level"],
Cell[CellGroupData[{
Cell[58719, 2204, 324, 10, 44, "Input",
 CellTags->"Tree level"],
Cell[59046, 2216, 105, 3, 43, "Output",
 CellTags->"Tree level"]
}, Open  ]],
Cell[59166, 2222, 134, 4, 41, "Text",
 CellTags->"Tree level"],
Cell[59303, 2228, 219, 6, 44, "Input",
 CellTags->"Tree level"],
Cell[59525, 2236, 599, 27, 41, "Text",
 CellTags->"Tree level"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60161, 2268, 71, 1, 56, "Subsection",
 CellTags->"A moment integral"],
Cell[60235, 2271, 787, 28, 69, "Text",
 CellTags->"A moment integral"],
Cell[61025, 2301, 57, 0, 25, "Text"],
Cell[61085, 2303, 139, 4, 44, "Input",
 CellTags->"A moment integral"],
Cell[61227, 2309, 349, 9, 59, "Text",
 CellTags->"A moment integral"],
Cell[61579, 2320, 213, 5, 59, "Text",
 CellTags->"A moment integral"],
Cell[61795, 2327, 1687, 32, 154, "Input",
 CellTags->"A moment integral"],
Cell[63485, 2361, 166, 4, 41, "Text",
 CellTags->"A moment integral"],
Cell[63654, 2367, 17159, 630, 13347, "Input",
 CellTags->"A moment integral"],
Cell[CellGroupData[{
Cell[80838, 3001, 116, 3, 44, "Input",
 CellTags->"A moment integral"],
Cell[80957, 3006, 1299, 41, 75, "Output",
 CellTags->"A moment integral"]
}, Open  ]],
Cell[82271, 3050, 144, 4, 47, "Commentary",
 CellTags->"A moment integral"],
Cell[CellGroupData[{
Cell[82440, 3058, 101, 2, 44, "Input",
 CellTags->"A moment integral"],
Cell[82544, 3062, 236, 8, 43, "Output",
 CellTags->"A moment integral"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82817, 3075, 116, 3, 44, "Input",
 CellTags->"A moment integral"],
Cell[82936, 3080, 201, 7, 43, "Output",
 CellTags->"A moment integral"]
}, Open  ]],
Cell[83152, 3090, 250, 5, 59, "Text",
 CellTags->"A moment integral"],
Cell[83405, 3097, 498, 18, 47, "Text",
 CellTags->"A moment integral"],
Cell[CellGroupData[{
Cell[83928, 3119, 358, 11, 44, "Input",
 CellTags->"A moment integral"],
Cell[84289, 3132, 180, 6, 43, "Output",
 CellTags->"A moment integral"]
}, Open  ]],
Cell[84484, 3141, 197, 4, 41, "Text",
 CellTags->"A moment integral"],
Cell[CellGroupData[{
Cell[84706, 3149, 442, 14, 44, "Input",
 CellTags->"A moment integral"],
Cell[85151, 3165, 180, 6, 43, "Output",
 CellTags->"A moment integral"]
}, Open  ]],
Cell[85346, 3174, 89, 1, 41, "Text",
 CellTags->"A moment integral"],
Cell[85438, 3177, 598, 18, 44, "Input",
 CellTags->"A moment integral"],
Cell[86039, 3197, 92, 1, 41, "Text",
 CellTags->"A moment integral"],
Cell[CellGroupData[{
Cell[86156, 3202, 1240, 37, 88, "Input",
 CellTags->"A moment integral"],
Cell[87399, 3241, 2995, 100, 100, "Output",
 CellTags->"A moment integral"]
}, Open  ]],
Cell[90409, 3344, 147, 4, 41, "Text",
 CellTags->"A moment integral"],
Cell[90559, 3350, 508, 16, 44, "Input",
 CellTags->"A moment integral"],
Cell[CellGroupData[{
Cell[91092, 3370, 113, 3, 44, "Input",
 CellTags->"A moment integral"],
Cell[91208, 3375, 114, 3, 43, "Output",
 CellTags->"A moment integral"]
}, Open  ]],
Cell[91337, 3381, 151, 4, 41, "Text",
 CellTags->"A moment integral"],
Cell[91491, 3387, 252, 8, 44, "Input",
 CellTags->"A moment integral"],
Cell[91746, 3397, 217, 5, 59, "Text",
 CellTags->"A moment integral"],
Cell[CellGroupData[{
Cell[91988, 3406, 180, 5, 44, "Input",
 CellTags->"A moment integral"],
Cell[92171, 3413, 3940, 132, 138, "Output",
 CellTags->"A moment integral"]
}, Open  ]],
Cell[96126, 3548, 243, 8, 41, "Text",
 CellTags->"A moment integral"],
Cell[CellGroupData[{
Cell[96394, 3560, 416, 13, 44, "Input",
 CellTags->"A moment integral"],
Cell[96813, 3575, 2974, 103, 61, "Output",
 CellTags->"A moment integral"]
}, Open  ]],
Cell[99802, 3681, 127, 3, 41, "Text",
 CellTags->"A moment integral"],
Cell[99932, 3686, 177, 5, 44, "Input",
 CellTags->"A moment integral"],
Cell[100112, 3693, 231, 7, 44, "Input",
 CellTags->"A moment integral"],
Cell[100346, 3702, 1134, 55, 59, "Text",
 CellTags->"A moment integral"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
