Notebook[{Cell[CellGroupData[{Cell["FeynCalc 5.1", "Title", 
      TextAlignment -> Center], 
     Cell["Tools for quantum field theory calculations", "Subtitle", 
      TextAlignment -> Center], Cell[TextData[
       StyleBox["Short manual", Rule[FontWeight, "Bold"]]], "Subtitle", 
      PageBreakBelow -> True, TextAlignment -> Center], 
     Cell["Rolf Mertig and Frederik Orellana", "Subsubtitle", 
      TextAlignment -> Center], Cell[TextData[{"HTML version: ", 
        ButtonBox["http://www.feyncalc.org/", 
          RuleDelayed[ButtonData, List[URL["http://www.feyncalc.org/"], 
            None]], Rule[ButtonStyle, "Hyperlink"], 
          Rule[ButtonNote, "http://www.feyncalc.org/"]]}], "Subsubtitle", 
      TextAlignment -> Center], Cell[BoxData[
       ButtonBox[\(Click\ to\ save\ this\ notebook\ without\ cache\ and\ 
           FrontEndVersion\ info\), 
         RuleDelayed[ButtonFunction, 
          CompoundExpression[Module[List[fn], 
            CompoundExpression[SetDirectory[DirectoryName[Set[fn, 
                ToFileName[ReplaceAll["FileName", 
                  NotebookInformation[InputNotebook[]]]]]]], 
             Set[newfn, StringReplace[fn, Rule[".nb", "NoCache.nb"]]], 
             If[UnsameQ[FileNames[newfn], List[]], DeleteFile[newfn]], 
             Put[ReplaceAll[NotebookGet[InputNotebook[]], 
               List[RuleDelayed[Condition[Rule[FrontEndVersion, 
                   Pattern[v, Blank[]]], Equal[Head[v], String]], 
                 Sequence[]], RuleDelayed[Condition[Rule[CellLabel, 
                   Pattern[v, Blank[]]], Equal[Head[v], String]], 
                 Sequence[]]]], "fcr.nb"], CopyFile["fcr.nb", newfn], 
             DeleteFile["fcr.nb"]]]]], Rule[ButtonEvaluator, Automatic]]], 
      "NotebookDefault", Active -> True, CellTags -> "ClickSave"], 
     Cell[CellGroupData[{Cell["Introduction", "Section", 
         PageBreakAbove -> True, CellTags -> {"Short Overview", "intro"}], 
        Cell[TextData[{"FeynCalc is a ", 
           StyleBox["Mathematica", Rule[FontSlant, "Italic"]], " package for \
algebraic calculations in high energy physics. It provides tools for Lorentz \
structure manipulations, Dirac algebra manipulations, color factor \
calculations, Feynman rule derivation, Feynman loop integral calculations \
(e.g. Passarino-Veltman reduction) and noncommutative algebra calculations, \
as well as various tabulations of Feynman parameter integrals, Mellin ", 
           Cell[BoxData[
             \(TraditionalForm\`\(transforms\^
                  \*ButtonBox["\[Dagger]", 
                    RuleDelayed[ButtonData, "introfoot"], 
                    Rule[ButtonStyle, "Hyperlink"]]\)\)]], ", convolutions, \
lagrangians and Feynman rules. Also, translation facilities are provided to \
change the FeynCalc syntax to and from FORM syntax and to generate FORTRAN \
code."}], "Text", CellTags -> "intro"], 
        Cell[TextData[{"Some functions for input of objects like ", 
           Cell[BoxData[
             \(TraditionalForm\`\(p\^\[Mu], \[Gamma]\^\[Nu], 
                  g\^\(\[Mu]\ \[Nu]\),\ 
                  \[CurlyEpsilon]\^\(\[Mu]\ \[Nu]\ \[Rho]\ \[Sigma]\),\ 
                  \(etc .\)\)\)]], " (abbreviations in parentheses) are:"}], 
         "Text", CellTags -> "intro"], Cell[TextData[{
           ButtonBox["DiracMatrix", RuleDelayed[ButtonData, "DiracMatrix"], 
             Rule[ButtonStyle, "AddOnsLink"]], " (", 
           ButtonBox["GA", RuleDelayed[ButtonData, "GA"], 
             Rule[ButtonStyle, "AddOnsLink"]], "), ", 
           ButtonBox["DiracSlash", RuleDelayed[ButtonData, "DiracSlash"], 
             Rule[ButtonStyle, "AddOnsLink"]], " (", 
           ButtonBox["GS", RuleDelayed[ButtonData, "GS"], 
             Rule[ButtonStyle, "AddOnsLink"]], "), ", 
           ButtonBox["FourVector", RuleDelayed[ButtonData, "FourVector"], 
             Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "FourVector"]]\
, " (", 
           ButtonBox["FV", RuleDelayed[ButtonData, "FV"], 
             Rule[ButtonStyle, "AddOnsLink"]], "), ", 
           ButtonBox["LeviCivita", RuleDelayed[ButtonData, "LeviCivita"], 
             Rule[ButtonStyle, "AddOnsLink"]], " (", 
           ButtonBox["LC", RuleDelayed[ButtonData, "LC"], 
             Rule[ButtonStyle, "AddOnsLink"]], "), ", 
           ButtonBox["MetricTensor", RuleDelayed[ButtonData, 
              "MetricTensor"], Rule[ButtonStyle, "AddOnsLink"]], " (", 
           ButtonBox["MT", RuleDelayed[ButtonData, "MT"], 
             Rule[ButtonStyle, "AddOnsLink"]], "), ", 
           ButtonBox["Spinor", RuleDelayed[ButtonData, "Spinor"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["SUNDelta", RuleDelayed[ButtonData, "SUNDelta"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["SUNF", RuleDelayed[ButtonData, "SUNF"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["ScalarProduct", 
             RuleDelayed[ButtonData, "ScalarProduct"], 
             Rule[ButtonStyle, "AddOnsLink"]], " (", 
           ButtonBox["SP", RuleDelayed[ButtonData, "SP"], 
             Rule[ButtonStyle, "AddOnsLink"]], "). "}], "Text"], 
        Cell["Some functions for manipulations are:", "Text", 
         CellTags -> "intro"], Cell[TextData[{
           ButtonBox["Contract", RuleDelayed[ButtonData, "Contract"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["Tr", RuleDelayed[ButtonData, "Tr"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["DiracSimplify", 
             RuleDelayed[ButtonData, "DiracSimplify"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["DiracTrick", RuleDelayed[ButtonData, "DiracTrick"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["Calc", RuleDelayed[ButtonData, "Calc"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["Convolute", RuleDelayed[ButtonData, "Convolute"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["FeynRule", RuleDelayed[ButtonData, "FeynRule"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["Integrate2", RuleDelayed[ButtonData, "Integrate2"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["FeynCalc2FORM", 
             RuleDelayed[ButtonData, "FeynCalc2FORM"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["PaVeReduce", RuleDelayed[ButtonData, "PaVeReduce"], 
             Rule[ButtonStyle, "AddOnsLink"]], " ,", 
           ButtonBox["SimplifyPolyLog", 
             RuleDelayed[ButtonData, "SimplifyPolyLog"], 
             Rule[ButtonStyle, "AddOnsLink"]], " , ", 
           ButtonBox["SUNSimplify", RuleDelayed[ButtonData, "SUNSimplify"], 
             Rule[ButtonStyle, "AddOnsLink"]], " , ", 
           ButtonBox["Isolate", RuleDelayed[ButtonData, "Isolate"], 
             Rule[ButtonStyle, "AddOnsLink"]], " , ", 
           ButtonBox["Collect2", RuleDelayed[ButtonData, "Collect2"], 
             Rule[ButtonStyle, "AddOnsLink"]], " , ", 
           ButtonBox["OneLoopSimplify", 
             RuleDelayed[ButtonData, "OneLoopSimplify"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["Series2", RuleDelayed[ButtonData, "Series2"], 
             Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "Series2"]], 
           " , ", 
           ButtonBox["ScalarProductCancel", 
             RuleDelayed[ButtonData, "ScalarProductCancel"], 
             Rule[ButtonStyle, "AddOnsLink"]], "."}], "Text", 
         CellTags -> "intro"], 
        Cell["Some functions for Feyman loop integral manipulations:", 
         "Text", CellTags -> "intro"], Cell[TextData[{
           ButtonBox["OneLoop", RuleDelayed[ButtonData, "OneLoop"], 
             Rule[ButtonStyle, "AddOnsLink"]], ", ", 
           ButtonBox["OneLoopSimplify", 
             RuleDelayed[ButtonData, "OneLoopSimplify"], 
             Rule[ButtonStyle, "AddOnsLink"]], " and ", 
           ButtonBox["PaVeReduce", RuleDelayed[ButtonData, "PaVeReduce"], 
             Rule[ButtonStyle, "AddOnsLink"]], " ."}], "Text", 
         CellTags -> "intro"], Cell[TextData[{"FeynCalc (>4.2) is still \
compatible with FeynArts (>2.2) if the FeynArts function ToFA1Convention is \
used on the generated amplitudes. While ", 
           ButtonBox["OneLoop", RuleDelayed[ButtonData, "OneLoop"], 
             Rule[ButtonStyle, "AddOnsLink"]], " and ", 
           ButtonBox["OneLoopSum", RuleDelayed[ButtonData, "OneLoopSum"], 
             Rule[ButtonStyle, "AddOnsLink"]], "  work fine for not too \
complicated self-energy, triangle and box diagrams, the reader should be \
aware of the package ", 
           ButtonBox["FormCalc", RuleDelayed[ButtonData, 
              List[URL["http://www.feynarts.de/formcalc/"], None]], 
             Rule[ButtonStyle, "Hyperlink"]], " by Thomas Hahn, which is more \
efficient for the adventurous researcher calculating thousands of diagrams, \
e.g. involving four external gauge bosons. Notice however that FormCalc does \
not reduce the Passarino-Veltman integrals to scalar integrals. Also, \
FormCalc is limited to the 't Hooft Feynman gauge. FeynCalc provides \
algebraic redution of Passarino-Veltman integrals to scalar integrals via the \
function ", 
           ButtonBox["PaVeReduce", RuleDelayed[ButtonData, "PaVeReduce"], 
             Rule[ButtonStyle, "AddOnsLink"]], " ."}], "Text", 
         CellTags -> "intro"], Cell["For more detailed information on \
FeynCalc functions, use the help system or consult the source code in the \
file \"FeynCalc.m\" in the directory \"HighEnergyPhysics\" and the further \
packages in the sub-directories \"fctools\", \"fctables\" and others. A \
complete list of FeynCalc objects is stored in the variable $FeynCalcStuff. \
Not all functions are equally well documented in this notebook. Some are very \
special ones (e.g. for tools for 2-loop QCD diagrams originating in twist-2 \
OPE), some are still experimental.", "Text", CellTags -> "intro"], 
        Cell[TextData[{"The ", Cell[BoxData[
             \(TraditionalForm\`\(\[Gamma]\^5\)\)]], 
           "scheme used in OneLoop is the naive one, i.e., ", Cell[BoxData[
             \(TraditionalForm\`\(\({\[Gamma]\^5, \[Gamma]\^\[Mu])\) = 0\)\)]]\
, " in 4 and D dimensions. See also ", 
           ButtonBox["ToLarin", RuleDelayed[ButtonData, "ToLarin"], 
             Rule[ButtonStyle, "AddOnsLink"]]}], "Text", 
         CellTags -> "intro"], 
        Cell["The metric used is the one from Bjorken and Drell (+---).", 
         "Text", CellTags -> "intro"], 
        Cell[TextData[{"For suggestions and bug reports please see ", 
           ButtonBox["http://www.feyncalc.org/", 
             RuleDelayed[ButtonData, List[URL["http://www.feyncalc.org/"], 
               None]], Rule[ButtonStyle, "Hyperlink"]], "."}], "Text", 
         CellTags -> "intro"], Cell[TextData[
          {"On a Pentium II 300 MHz computer with 128 MB of RAM running ", 
           StyleBox["Mathematica", Rule[FontSlant, "Italic"]], " 3.0 for \
Linux, this noteboook needs less than 15 minutes to evaluate, not exceeding \
16 MB of memory usage."}], "Text", CellTags -> "intro"], 
        Cell[TextData[{"\[Dagger] Mellin transforms (e.g. all integrals - \
except 57,58 and 59, and correcting a minor misprint in 14) of Appendix 7 \
from ", 
           ButtonBox["hep-ph/9810241", 
             RuleDelayed[ButtonData, List[URL["http://xxx.lanl.gov/abs/hep\
-ph/9810241"], None]], Rule[ButtonStyle, "Hyperlink"]], " are tabulated in ", 
           ButtonBox["Integrate2.", RuleDelayed[ButtonData, "Integrate2"], 
             Rule[ButtonStyle, "AddOnsLink"]]}], "SmallText", 
         CellTags -> {"intro", "introfoot"}]}, Closed]], 
     Cell[CellGroupData[{Cell["Starting FeynCalc", "Section", 
         CellTags -> {"Load FeynCalc", "start"}], 
        Cell[TextData[{"If the directory \"HighEnergyPhysics\" has been put \
in the directory \"Applications\" in your ", 
           StyleBox["Mathematica", Rule[FontSlant, "Italic"]], 
           " installation tree, you should be able to load FeynCalc from a ", 
           StyleBox["Mathematica", Rule[FontSlant, "Italic"]], 
           " session with no further ado."}], "Text", CellTags -> "start"], 
        Cell[BoxData[\(<< HighEnergyPhysics`FeynCalc`\)], "Input", 
         CellTags -> "start"], Cell["This loads FeynCalc.", "MathCaption", 
         CellTags -> "start"], Cell[TextData[{"You can also put this line \
into your \"init.m\" file. This will cause automatic loading of FeynCalc on \
every ", StyleBox["Mathematica", Rule[FontSlant, "Italic"]], " startup."}], 
         "Text", CellTags -> "start"], Cell[TextData[{"By loading FeynCalc \
the setting of the default output format type is automatically set to \
TraditionalForm. You might want to reverse this after quitting FeynCalc by \
clicking on the ", StyleBox["Cell", "TextNormal", Rule[FontWeight, "Bold"]], 
           " menu, then go to the ", 
           StyleBox["Default Output Format Type ", "TextNormal", 
             Rule[FontWeight, "Bold"]], "item and select ", 
           StyleBox["StandardForm", Rule[FontWeight, "Bold"]], 
           ", or by evaluating"}], "Text", CellTags -> "start"], Cell[BoxData[
          StyleBox[\(SetOptions[\($FrontEnd, 
                \("CommonDefaultFormatTypes" \[Rule] 
                  \({"Output" \[Rule] StandardForm}\)\)\)]\), "Input"]], 
         "Input", CellTags -> "start"], 
        Cell["This sets the default output form to StandardForm.", 
         "MathCaption", CellTags -> "start"], 
        Cell[CellGroupData[{Cell[BoxData[
             StyleBox[\(B0[\(p, \(m1^2\), \(m2^2\)\)]\), "Input"]], "Input", 
            CellTags -> "start"], Cell[BoxData[\(B0[\(p, m1\^2, m2\^2\)]\)], 
            "Output", CellTags -> "start"]}, Closed]], 
        Cell["Now FeynCalc functions, like e.g. B0, are not typeset.", 
         "MathCaption", CellTags -> "start"], Cell[BoxData[
          StyleBox[\(SetOptions[\($FrontEnd, 
                \("CommonDefaultFormatTypes" \[Rule] 
                  \({"Output" \[Rule] TraditionalForm}\)\)\)]\), "Input"]], 
         "Input", CellTags -> "start"], 
        Cell["This sets the default output form to TraditionalForm.", 
         "MathCaption", CellTags -> "start"], 
        Cell[CellGroupData[{Cell[BoxData[
             StyleBox[\(B0[\(p, \(m1^2\), \(m2^2\)\)]\), "Input"]], "Input", 
            CellTags -> "start"], Cell[BoxData[
             \(TraditionalForm\`\(B\_0(\(p, m1\^2, m2\^2\))\)\)], "Output", 
            CellTags -> "start"]}, Closed]], 
        Cell["Now FeynCalc functions, like e.g. B0, are again typeset.", 
         "MathCaption", CellTags -> "start"], Cell[BoxData[{
           \(m1/:\(MakeBoxes[\(m1, TraditionalForm\)]\) := 
              \(InterpretationBox[\(\(SubscriptBox[\(m, 1\)]\), m1\)]\)\), 
           \(m2/:\(MakeBoxes[\(m2, TraditionalForm\)]\) := 
              \(InterpretationBox[\(\(SubscriptBox[\(m, 2\)]\), m2\)]\)\)}], 
         "Input", CellTags -> "start"], 
        Cell[TextData[{"This defines additional typesetting rules for m", 
           StyleBox["1", Rule[FontFamily, "Courier"]], " and m", 
           StyleBox["2", Rule[FontFamily, "Courier"]], 
           " for the output format type TraditionalForm."}], "MathCaption", 
         CellTags -> "start"], Cell[CellGroupData[{Cell[BoxData[
             StyleBox[\(B0[\(p, \(m1^2\), \(m2^2\)\)]\), "Input"]], "Input", 
            CellTags -> "start"], Cell[BoxData[
             \(TraditionalForm\`\(B\_0(
                  \(p, \*InterpretationBox[\(m\_1\), m1]\^2, 
                    \*InterpretationBox[\(m\_2\), m2]\^2\))\)\)], "Output", 
            CellTags -> "start"]}, Closed]], Cell[TextData[{"Evaluating m", 
           StyleBox["1", Rule[FontFamily, "Courier"]], " and m", 
           StyleBox["2", Rule[FontFamily, "Courier"]], 
           " now returns formatted TraditionalForm output."}], "MathCaption", 
         CellTags -> "start"], Cell[CellGroupData[{Cell[BoxData[
             \(%//StandardForm\)], "Input", CellTags -> "start"], 
           Cell[BoxData[\(B0[\(p, m1\^2, m2\^2\)]\)], "Output", 
            CellTags -> "start"]}, Closed]], Cell["Enforcing StandardForm \
gives 'raw' output, usable for copying, pasting and re-evaluating.", 
         "MathCaption", CellTags -> "start"]}, Closed]], 
     Cell[CellGroupData[{Cell["Extra subpackages", "Section", 
         PageBreakAbove -> True, CellTags -> "About Extras"], 
        Cell[TextData[{"The directory  \"HighEnergyPhysics\" contains various \
files and subdirectories belonging to third-party packages which are not \
necessary to run 'standard' FeynCalc calculations and which do not use the \
autoloading conventions of FeynCalc. These packages are not initialized by \
default when starting FeynCalc. Loading them can be switched on and off by \
setting appropiate variables to False or True before ", 
           ButtonBox["loading FeynCalc", 
             RuleDelayed[ButtonData, "Load FeynCalc"], 
             Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "start"]], 
           ". "}], "Text", CellTags -> "About Extras"], Cell[BoxData[
          \(TraditionalForm\`\(\*StyleBox[FrameBox[StyleBox[GridBox[
                   {{StyleBox["$LoadTARCER", 
                      Rule[FontFamily, "Courier"]], 
                     \(Specifies\ if\ TARCER\ should\ be\ loaded\ by\ 
                       FeynCalc\)}, 
                    {StyleBox["$LoadPhi", Rule[FontFamily, "Courier"]], 
                     \(Specifies\ if\ PHI\ should\ be\ loaded\ by\ 
                       FeynCalc\)}, 
                    {StyleBox["$LoadFeynArts", 
                      Rule[FontFamily, "Courier"]], 
                     \(Specifies\ if\ 
                       FeynArts\^\*ButtonBox["\[Dagger]", 
                          RuleDelayed[ButtonData, "extrafoot"], 
                          Rule[ButtonStyle, "Hyperlink"]]\ should\ be\ 
                       loaded\ by\ FeynCalc\)}}, 
                   ColumnAlignments -> {Right, Left}], 
                  Rule[GridBoxOptions, List[Rule[RowLines, False]]]]], 
                "2ColumnBox"]\)\)], "Text", Background -> None, 
         CellTags -> "About Extras"], 
        Cell["Variables switching loading of extra packages on and off. ", 
         "Caption", CellTags -> "About Extras"], 
        Cell[CellGroupData[{Cell[TextData[{"TARCER -\n", "A ", 
              StyleBox["Mathematica", Rule[FontSlant, "Italic"]], 
              " program for the reduction of two-loop propagator integrals"}]\
, "Subsection", CellTags -> "tarcer"], Cell["R. Mertig, R. Scharf", 
            "InspectorLevel2", CellTags -> "tarcer"], Cell[TextData[{
              ButtonBox["hep-ph/9801383", 
                RuleDelayed[ButtonData, 
                 List[URL["http://xxx.lanl.gov/abs/hep-ph/9801383"], None]], 
                Rule[ButtonStyle, "Hyperlink"]], 
              " on the Los Alamos preprint server"}], "Text", 
            CellDingbat -> "\[GrayCircle]", CellTags -> "tarcer"], 
           Cell[TextData[{"published in ", 
              StyleBox["Comp. Phys. Comm.", 
                Rule[CellDingbat, "\[GrayCircle]"]], " ", 
              StyleBox["111", Rule[FontWeight, "Bold"]], " (1998) 265-173"}], 
            "Text", CellDingbat -> "\[GrayCircle]", CellTags -> "tarcer"], 
           Cell["Loading TARCER", "Subsubsection", CellTags -> "tarcer"], 
           Cell[TextData[{"If FeynCalc is not needed, simply evaluate the \
file \"TARCER.nb\". This produces a file of the form \"tarcer*.mx\". Later it \
is then only necessary to load this file (e.g. ", 
              StyleBox["<<\"tarcer06.mx\"", Rule[FontFamily, "Courier"]], "). \
You can later change parameters in \"TARCER.nb\" and reevaluate it. \
Alternatively you can get a preproduced .mx file at ", 
              ButtonBox["http://www.feyncalc.org/tarcer/", 
                RuleDelayed[ButtonData, 
                 List[URL["http://www.feyncalc.org/tarcer/"], None]], 
                Rule[ButtonStyle, "Hyperlink"], 
                Rule[ButtonNote, "http://www.feyncalc.org/tarcer/"]], "."}], 
            "Text", CellTags -> "tarcer"], Cell[TextData[{"If instructed to \
do so, FeynCalc automatically loads any tarcer*.mx file found the directory \
\"Tarcer\" (if several are present, the last one found by ", 
              StyleBox["Mathematica", Rule[FontSlant, "Italic"]], "'s \
FileNames is loaded). To have FeynCalc load TARCER, evaluate"}], "Text", 
            CellTags -> "tarcer"], Cell[BoxData[\(\($LoadTARCER = True\) ;\)]
             , "Input", CellTags -> "tarcer"], Cell[TextData[{"before ", 
              ButtonBox["loading FeynCalc", 
                RuleDelayed[ButtonData, "Load FeynCalc"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "start"]], 
              ". You can also put the last input line into your \
\"FCConfig.m\" file."}], "Text", CellTags -> "tarcer"], 
           Cell[TextData[{"An example notebook is also available at ", 
              ButtonBox["http://www.feyncalc.org/tarcer/", 
                RuleDelayed[ButtonData, 
                 List[URL["http://www.feyncalc.org/tarcer/"], None]], 
                Rule[ButtonStyle, "Hyperlink"], 
                Rule[ButtonNote, "http://www.feyncalc.org/tarcer/"]], "."}], 
            "Text", CellTags -> "tarcer"]}, Closed]], 
        Cell[CellGroupData[{Cell[TextData[{"PHI -\nA ", 
              StyleBox["Mathematica", Rule[FontSlant, "Italic"]], 
              " package for ChPT calculations"}], "Subsection", 
            CellTags -> "phi"], Cell["F. J. Orellana", "InspectorLevel2", 
            CellTags -> "phi"], Cell[TextData[{"PHI is a ", 
              StyleBox["Mathematica", Rule[FontSlant, "Italic"]], " package \
for manipulating covariant derivatives etc. of effective theories like Chiral \
Perturbation Theory. Moreover it provides an alternative way of creating \
coupling definitions for FeynArts. This is convenient if one needs to \
generate a large number of Feynman rules from different lagrangians."}], 
            "Text", CellTags -> "phi"], 
           Cell["To have FeynCalc load PHI, evaluate", "Text", 
            CellTags -> "phi"], Cell[BoxData[\(\($LoadPhi = True\) ;\)], 
            "Input", CellTags -> "phi"], Cell[TextData[{"before ", 
              ButtonBox["loading FeynCalc", 
                RuleDelayed[ButtonData, "Load FeynCalc"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "start"]], 
              ". You can also put this line into your \"FCConfig.m\" file."}]\
, "Text", CellTags -> "phi"], Cell[TextData[
             {"More information is available at ", 
              ButtonBox["http://www.feyncalc.org/phi/", 
                RuleDelayed[ButtonData, 
                 List[URL["http://www.feyncalc.org/phi/"], None]], 
                Rule[ButtonStyle, "Hyperlink"], 
                Rule[ButtonNote, "http://www.feyncalc.org/phi/"]], "."}], 
            "Text", CellTags -> "phi"]}, Closed]], 
        Cell[CellGroupData[{Cell["FeynArts", "Subsection", CellTags -> "fa"], 
           Cell["Hagen Eck, Sepp K\[UDoubleDot]blbeck and Thomas Hahn", 
            "InspectorLevel2", CellTags -> "fa"], Cell[TextData[{
              ButtonBox["hep-ph/0012260", 
                RuleDelayed[ButtonData, 
                 List[URL["http://xxx.lanl.gov/abs/hep-ph/0012260"], None]], 
                Rule[ButtonStyle, "Hyperlink"]], 
              " on the Los Alamos preprint server"}], "Text", 
            CellDingbat -> "\[GrayCircle]", CellTags -> "fa"], 
           Cell[TextData[{"old version published in ", 
              StyleBox["Comp. Phys. Comm. ", 
                Rule[CellDingbat, "\[GrayCircle]"]], 
              StyleBox["60", Rule[CellDingbat, "\[GrayCircle]"], 
                Rule[FontWeight, "Bold"]], 
              StyleBox[" (1990) 165", Rule[CellDingbat, "\[GrayCircle]"]]}], 
            "Text", CellDingbat -> "\[GrayCircle]", CellTags -> "fa"], 
           Cell["FeynArts is a Mathematica package written by Hagen Eck, Sepp \
K\[UDoubleDot]blbeck and Thomas Hahn for the generation and visualization of \
Feynman diagrams and amplitudes. The current version is being developed by \
Thomas Hahn independently of FeynCalc. As it turns out, it can, however, be \
used with FeynCalc with only a few modifications, which are done \
automatically when it is loaded by FeynCalc.", "Text", CellTags -> "fa"], 
           Cell["One use of FeynCalc and FeynArts together is to use FeynCalc \
to process the output you get from FeynArts. Another use is to use FeynCalc \
and PHI to generate the many Feynman rules needed in effective theories like \
ChPT and feed them to FeynArts.", "Text", CellTags -> "fa"], 
           Cell[TextData[{"To have FeynArts loaded by FeynCalc, you need \
first of all to get FeynArts at ", 
              ButtonBox["http://www.feynarts.de/", 
                RuleDelayed[ButtonData, 
                 List[URL["http://www.feynarts.de/"], None]], 
                Rule[ButtonStyle, "Hyperlink"], 
                Rule[ButtonNote, "Download FeynArts"]], " and put it in the \
directory \"HighEnergyPhysics\". Then evaluate"}], "Text", CellTags -> "fa"], 
           Cell[BoxData[{\(\($LoadPhi = True\) ;\), 
              \(\($LoadFeynArts = True\) ;\)}], "Input", CellTags -> "fa"], 
           Cell[TextData[{"before ", 
              ButtonBox["loading FeynCalc", 
                RuleDelayed[ButtonData, "Load FeynCalc"], 
                Rule[ButtonStyle, "AddOnsLink"], Rule[ButtonNote, "start"]], 
              ". You can also put these lines into your \"FCConfig.m\" file."}\
], "Text", CellTags -> "fa"], Cell[TextData[
             {"More information about FeynArts is available at ", 
              ButtonBox["http://www.feynarts.de/", 
                RuleDelayed[ButtonData, 
                 List[URL["http://www.feynarts.de/"], None]], 
                Rule[ButtonStyle, "Hyperlink"], 
                Rule[ButtonNote, "Download FeynArts"]], ". More information \
about using FeynArts, FeynCalc and PHI is available at ", 
              ButtonBox["http://www.feyncalc.org/phi/", 
                RuleDelayed[ButtonData, 
                 List[URL["http://www.feyncalc.org/phi/"], None]], 
                Rule[ButtonStyle, "Hyperlink"], 
                Rule[ButtonNote, "http://www.feyncalc.org/phi/"]], "."}], 
            "Text", CellTags -> "fa"]}, Closed]]}, Closed]], 
     Cell[CellGroupData[{Cell["Example Calculations", "Section", 
         PageBreakAbove -> True, CellTags -> {"Example Calculations", "ex"}], 
        Cell[TextData[
          {"This section is under development ... Please post suggestions on \
", 
           ButtonBox["www.feyncalc.org/forum/", 
             RuleDelayed[ButtonData, List[URL["http://www.feyncalc.org/for\
um/"], None]], Rule[ButtonStyle, "Hyperlink"], 
             Rule[ButtonNote, "http://www.feyncalc.org/forum/"]], "."}], 
         "Commentary", CellTags -> "ex"], Cell[CellGroupData[
          {Cell[TextData[{"Tree level ", Cell[BoxData[
                \(TraditionalForm\`\(\(\[Gamma]\ \[Gamma]\)\ \[Rule]\ 
                     \(\(e\^+\) \(e\^-\)\)\)\)]], " in the standard model"}], 
            "Subsection", CellTags -> "Tree level"], 
           Cell["Define typesetting rules for p1, p2, k1, k2:", "Text", 
            CellTags -> "Tree level"], Cell["p1/: MakeBoxes[p1, fmt_] := \
InterpretationBox[SubscriptBox[p, 1], p1];\nk1/: MakeBoxes[k1, fmt_] := \
InterpretationBox[SubscriptBox[k, 1], k1];\np2/: MakeBoxes[p2, fmt_] := \
InterpretationBox[SubscriptBox[p, 2], p2];\nk2/: MakeBoxes[k2, fmt_] := \
InterpretationBox[SubscriptBox[k, 2], k2];", "Input", CellTags -> 
             "Tree level"], Cell[
            "Define slashes of external momenta to save future typing:", 
            "Text", CellTags -> "Tree level"], Cell[CellGroupData[
             {Cell[BoxData[
                \(\({p1sl, p2sl, k1sl, k2sl}\) = 
                   \(DiracSlash/@\({p1, p2, k1, k2}\)\)\)], "Input", 
               CellTags -> "Tree level"], Cell[BoxData[FormBox[RowBox[
                  {"{", RowBox[{RowBox[{FormBox["\"\[Gamma]\"", 
                        "TraditionalForm"], "\[CenterDot]", FormBox[
                        \(\(\*TagBox[StyleBox["\"p\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_1\), 
                        "TraditionalForm"]}], ",", RowBox[{FormBox[
                        "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                       FormBox[
                        \(\(\*TagBox[StyleBox["\"p\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_2\), 
                        "TraditionalForm"]}], ",", RowBox[{FormBox[
                        "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                       FormBox[
                        \(\(\*TagBox[StyleBox["\"k\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_1\), 
                        "TraditionalForm"]}], ",", RowBox[{FormBox[
                        "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                       FormBox[
                        \(\(\*TagBox[StyleBox["\"k\"", 
                               Rule[FontSlant, "Italic"]], 
                              Function[StyleForm[Slot[1], 
                                Rule[FontSlant, "Italic"]]]]\)\_2\), 
                        "TraditionalForm"]}]}], "}"}], TraditionalForm]], 
               "Output", CellTags -> "Tree level"]}, Closed]], 
           Cell[TextData[{"Kinematic definitions so that only ", Cell[BoxData[
                \(TraditionalForm\`\(p\_1 . k\_1\)\)]], ", ", Cell[BoxData[
                \(TraditionalForm\`\(p\_1 . k\_2\)\)]], 
              " appear in final results. I.e., define ", Cell[BoxData[
                \(TraditionalForm\`\(p\_1\%2 = \(p\_2\%2 =\ m\^2\)\)\)]], 
              " ", Cell[BoxData[
                \(TraditionalForm\`\(k\_1\%2 = \(k\_2\%2 =\ 0\)\)\)]], " ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\(k\_1 \[CenterDot] k\_2\)\ =\ 
                     \(\(p\_1 \[CenterDot] p\_2\) + m\^2\)\)\)]], " ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\(k\_1 \[CenterDot] p\_2\)\ =\ 
                     \(k\_2 \[CenterDot] p\_1\)\)\)]], " ", Cell[BoxData[
                \(TraditionalForm\`\(\(k\_2 \[CenterDot] p\_2\)\ =\ 
                     \(k\_1 \[CenterDot] p\_1\)\)\)]], " ", Cell[BoxData[
                \(TraditionalForm\`\(\(p\_1 \[CenterDot] p\_2\) =\ 
                     \(\(k\_2 \[CenterDot] p\_1\) - m\^2 + 
                       \(k\_1 \[CenterDot] p\_1\)\)\)\)]], "."}], "Text", 
            CellTags -> "Tree level"], Cell[BoxData[
             \(\(\(ScalarProduct[\(p1, p1\)]\) = 
                  \(\(ScalarProduct[\(p2, p2\)]\) = m\^2\)\) ;\)], "Input", 
            CellTags -> "Tree level"], Cell[BoxData[
             \(\(\(ScalarProduct[\(k1, k1\)]\) = 
                  \(\(ScalarProduct[\(k2, k2\)]\) = 0\)\) ;\)], "Input", 
            CellTags -> "Tree level"], Cell[BoxData[
             \(\(\(ScalarProduct[\(k1, k2\)]\) = 
                  \(\(ScalarProduct[\(p1, p2\)]\) + m\^2\)\) ;\)], "Input", 
            CellTags -> "Tree level"], Cell[BoxData[
             \(\(\(ScalarProduct[\(k1, p2\)]\) = 
                  \(ScalarProduct[\(k2, p1\)]\)\) ;\)], "Input", 
            CellTags -> "Tree level"], Cell[BoxData[
             \(\(\(ScalarProduct[\(k2, p2\)]\) = 
                  \(ScalarProduct[\(k1, p1\)]\)\) ;\)], "Input", 
            CellTags -> "Tree level"], Cell[BoxData[
             \(\(\(ScalarProduct[\(p1, p2\)]\) = 
                  \(\(ScalarProduct[\(k2, p1\)]\) - m\^2 + 
                    \(ScalarProduct[\(k1, p1\)]\)\)\) ;\)], "Input", 
            CellTags -> "Tree level"], Cell["Define the amplitudes:", "Text", 
            CellTags -> "Tree level"], Cell[CellGroupData[{Cell[BoxData[
                \(f1 = \(\(DiracMatrix[\[Mu]]\) . \((p1sl - k1sl + m)\) . 
                     \(DiracMatrix[\[Nu]]\)\)\)], "Input", CellTags -> 
                "Tree level"], Cell[BoxData[FormBox[RowBox[{SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", RowBox[{"(", RowBox[{"m", "-", 
                       RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                         "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "+", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], ")"}], ".", SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "Tree level"]}, Closed]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(f2 = \(\(DiracMatrix[\[Nu]]\) . \((p1sl - k2sl + m)\) . 
                     \(DiracMatrix[\[Mu]]\)\)\)], "Input", CellTags -> 
                "Tree level"], Cell[BoxData[FormBox[RowBox[{SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", RowBox[{"(", RowBox[{"m", "-", 
                       RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                         "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"]}], "+", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], ")"}], ".", SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "Tree level"]}, Closed]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(f3 = \(\(DiracMatrix[\[Nu]]\) . \((p1sl - k1sl + m)\) . 
                     \(DiracMatrix[\[Mu]]\)\)\)], "Input", CellTags -> 
                "Tree level"], Cell[BoxData[FormBox[RowBox[{SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", RowBox[{"(", RowBox[{"m", "-", 
                       RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                         "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "+", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], ")"}], ".", SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "Tree level"]}, Closed]], 
           Cell[CellGroupData[{Cell[BoxData[
                \(f4 = \(\(DiracMatrix[\[Mu]]\) . \((p1sl - k2sl + m)\) . 
                     \(DiracMatrix[\[Nu]]\)\)\)], "Input", CellTags -> 
                "Tree level"], Cell[BoxData[FormBox[RowBox[{SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Mu]", "TraditionalForm"], 
                     "TraditionalForm"]], ".", RowBox[{"(", RowBox[{"m", "-", 
                       RowBox[{FormBox["\"\[Gamma]\"", "TraditionalForm"], 
                         "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"]}], "+", RowBox[{FormBox[
                          "\"\[Gamma]\"", "TraditionalForm"], "\[CenterDot]", 
                         FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], ")"}], ".", SuperscriptBox[
                    "\[Gamma]", FormBox[FormBox["\[Nu]", "TraditionalForm"], 
                     "TraditionalForm"]]}], TraditionalForm]], "Output", 
               CellTags -> "Tree level"]}, Closed]], 
           Cell[" Calculate the four traces:", "Text", CellTags -> 
             "Tree level"], Cell[CellGroupData[
             {Cell["tr1 = Tr[(p1sl + m) . f1 . (p2sl - m) . f3]", "Input", 
               CellTags -> "Tree level"], Cell[BoxData[FormBox[RowBox[
                  {"4", " ", RowBox[{"(", RowBox[{\(\(-8\)\ m\^4\), "+", 
                       RowBox[{"8", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}], "+", 
                       RowBox[{"8", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "Tree level"]}, 
             Closed]], Cell[CellGroupData[
             {Cell["tr2 = Tr[(p1sl + m) . f1 . (p2sl - m) . f4]", "Input", 
               CellTags -> "Tree level"], Cell[BoxData[FormBox[RowBox[
                  {"4", " ", RowBox[{"(", RowBox[{\(\(-8\)\ m\^4\), "+", 
                       RowBox[{"4", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}], "+", 
                       RowBox[{"4", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "Tree level"]}, 
             Closed]], Cell[CellGroupData[
             {Cell["tr3 = Tr[(p1sl + m) . f2 . (p2sl - m) . f3]", "Input", 
               CellTags -> "Tree level"], Cell[BoxData[FormBox[RowBox[
                  {"4", " ", RowBox[{"(", RowBox[{\(\(-8\)\ m\^4\), "+", 
                       RowBox[{"4", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}], "+", 
                       RowBox[{"4", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "Tree level"]}, 
             Closed]], Cell[CellGroupData[
             {Cell["tr4 = Tr[(p1sl + m) . f2 . (p2sl - m) . f4]", "Input", 
               CellTags -> "Tree level"], Cell[BoxData[FormBox[RowBox[
                  {"4", " ", RowBox[{"(", RowBox[{\(\(-8\)\ m\^4\), "+", 
                       RowBox[{"8", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}], "+", 
                       RowBox[{"8", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}]}], ")"}]}], 
                 TraditionalForm]], "Output", CellTags -> "Tree level"]}, 
             Closed]], Cell[
            "Divide by the denominators and add everything up:", "Text", 
            CellTags -> "Tree level"], Cell[CellGroupData[{Cell[BoxData[
                \(matrixsq = \(tr1\/\(ScalarProduct[\(\(2\ p1\), k1\)]\)\^2 +
                      tr4\/\(ScalarProduct[\(\(2\ p1\), k2\)]\)\^2 + 
                     \(tr2 + tr3\)\/\(\(ScalarProduct[\(\(2\ p1\), k1\)]\)\ 
                        \(ScalarProduct[\(\(2\ p1\), k2\)]\)\)\)\)], "Input", 
               CellTags -> "Tree level"], Cell[BoxData[FormBox[RowBox[
                  {FractionBox[RowBox[{"2", " ", RowBox[{"(", RowBox[{
                          \(\(-8\)\ m\^4\), "+", RowBox[{"4", " ", RowBox[
                          {FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}], "+", 
                          RowBox[{"4", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}]}], ")"}]}], 
                    RowBox[{RowBox[{FormBox[
                         \(\(\*TagBox[StyleBox["\"k\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"]}], " ", RowBox[{FormBox[
                         \(\(\*TagBox[StyleBox["\"k\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2\), 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"]}]}]], "+", FractionBox[RowBox[{
                      \(\(-8\)\ m\^4\), "+", RowBox[{"8", " ", RowBox[
                         {FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}], "+", 
                      RowBox[{"8", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}]}], SuperscriptBox[FormBox[
                      RowBox[{FormBox[
                         \(\(\*TagBox[StyleBox["\"k\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"]}], "TraditionalForm"], "2"]], 
                   "+", FractionBox[RowBox[{\(\(-8\)\ m\^4\), "+", RowBox[
                       {"8", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", \(m\^2\)}], "+", 
                      RowBox[{"8", " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], " ", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}]}], SuperscriptBox[FormBox[
                      RowBox[{FormBox[
                         \(\(\*TagBox[StyleBox["\"k\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2\), 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"]}], "TraditionalForm"], "2"]]}], 
                 TraditionalForm]], "Output", CellTags -> "Tree level"]}, 
             Closed]], Cell[TextData[{"Collect with respect to powers of ", 
              StyleBox["m", Rule[FontSlant, "Italic"]], ":"}], "Text", 
            CellTags -> "Tree level"], Cell[CellGroupData[{Cell[BoxData[
                \(r = \(Collect2[\(matrixsq, m\)]\)\)], "Input", CellTags -> 
                "Tree level"], Cell[BoxData[FormBox[RowBox[
                  {RowBox[{"-", FractionBox[RowBox[{"8", " ", SuperscriptBox[
                         RowBox[{"(", RowBox[{RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "+", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], ")"}], "2"], " ", \(m\^4\)}]
                        , RowBox[{SuperscriptBox[FormBox[RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "TraditionalForm"], "2"], 
                        " ", SuperscriptBox[FormBox[RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "TraditionalForm"], 
                         "2"]}]]}], "+", FractionBox[RowBox[{"16", " ", 
                      RowBox[{"(", RowBox[{RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "+", RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}]}], ")"}], " ", \(m\^2\)}], 
                    RowBox[{RowBox[{FormBox[
                         \(\(\*TagBox[StyleBox["\"k\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"]}], " ", RowBox[{FormBox[
                         \(\(\*TagBox[StyleBox["\"k\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2\), 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"]}]}]], "+", FractionBox[
                    RowBox[{"8", " ", RowBox[{"(", RowBox[{SuperscriptBox[
                          FormBox[RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "TraditionalForm"], "2"], 
                          "+", SuperscriptBox[FormBox[RowBox[{FormBox[
                          \(\(\*TagBox[StyleBox["\"k\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_2\), 
                          "TraditionalForm"], "\[CenterDot]", FormBox[
                          \(\(\*TagBox[StyleBox["\"p\"", 
                                 Rule[FontSlant, "Italic"]], 
                                Function[StyleForm[Slot[1], 
                                  Rule[FontSlant, "Italic"]]]]\)\_1\), 
                          "TraditionalForm"]}], "TraditionalForm"], "2"]}], 
                        ")"}]}], RowBox[{RowBox[{FormBox[
                         \(\(\*TagBox[StyleBox["\"k\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"]}], " ", RowBox[{FormBox[
                         \(\(\*TagBox[StyleBox["\"k\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_2\), 
                         "TraditionalForm"], "\[CenterDot]", FormBox[
                         \(\(\*TagBox[StyleBox["\"p\"", 
                                Rule[FontSlant, "Italic"]], 
                               Function[StyleForm[Slot[1], 
                                 Rule[FontSlant, "Italic"]]]]\)\_1\), 
                         "TraditionalForm"]}]}]]}], TraditionalForm]], 
               "Output", CellTags -> "Tree level"]}, Closed]], 
           Cell[TextData[{"The symmetry with respect to ", Cell[BoxData[
                \(TraditionalForm\`k\_1\)]], " and ", Cell[BoxData[
                \(TraditionalForm\`k\_2\)]], " can be checked explicitly:"}], 
            "Text", CellTags -> "Tree level"], Cell[CellGroupData[
             {Cell[BoxData[
                \((r\ -\ \((r\ /.\ \({\ \(k1 \[RuleDelayed] k2\),\ 
                          \(k2 \[RuleDelayed] k1\)}\))\))\)], "Input", 
               CellTags -> "Tree level"], Cell[BoxData[\(TraditionalForm\`0\)]
                , "Output", CellTags -> "Tree level"]}, Closed]], 
           Cell["Remove the definitions for the scalar products and for the \
typesetting definitions:", "Text", CellTags -> "Tree level"], Cell[BoxData[
             \(ClearScalarProducts ;\ \(Clear[\(p1, p2, k1, k2, r\)]\) ;\)], 
            "Input", CellTags -> "Tree level"], Cell[TextData[{"See also: ", 
              ButtonBox["ClearScalarProducts", 
                RuleDelayed[ButtonData, "ClearScalarProducts"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Collect2", RuleDelayed[ButtonData, "Collect2"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["DiracMatrix", RuleDelayed[ButtonData, 
                 "DiracMatrix"], Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["DiracSlash", RuleDelayed[ButtonData, "DiracSlash"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["ScalarProduct", 
                RuleDelayed[ButtonData, "ScalarProduct"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Tr", RuleDelayed[ButtonData, "Tr"], 
                Rule[ButtonStyle, "AddOnsLink"]], "."}], "Text", 
            CellTags -> "Tree level"]}, Closed]], 
        Cell[CellGroupData[{Cell["A moment integral", "Subsection", 
            CellTags -> "A moment integral"], 
           Cell[TextData[
             {"This section shows how to calculate the moments of ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox[\(
                        \(\*StyleBox["A", Rule[FontSlant, "Plain"]]\)\&^\), 
                       Rule[FontSlant, "Plain"]]\)\_qq\%\(NS, PHYS\)\)]], 
              " from ", 
              ButtonBox["hep-ph/9801224", 
                RuleDelayed[ButtonData, 
                 List[URL["http://xxx.lanl.gov/abs/hep-ph/9801224"], None]], 
                Rule[ButtonStyle, "Hyperlink"]], ". Notice that due to \
current conservation the first moment of ", Cell[BoxData[
                \(TraditionalForm\`\(\*StyleBox[\(
                        \(\*StyleBox["A", Rule[FontSlant, "Plain"]]\)\&^\), 
                       Rule[FontSlant, "Plain"]]\)\_qq\%\(NS, PHYS\)\)]], 
              "should vanish."}], "Text", CellTags -> "A moment integral"], 
           Cell["First e is defined to be \[CurlyEpsilon]:", "Text"], 
           Cell[BoxData[\(\(e\ =\ Epsilon\) ;\)], "Input", 
            CellTags -> "A moment integral"], 
           Cell[TextData[{"Next, FORM output from the file \"jqq12.log\" is \
translated to FeynCalc syntax. The FORM file \"jqq12.log\" was generated by \
one of the authors of ", 
              ButtonBox["hep-ph/9801224", 
                RuleDelayed[ButtonData, 
                 List[URL["http://xxx.lanl.gov/abs/hep-ph/9801224"], None]], 
                Rule[ButtonStyle, "Hyperlink"]], ". "}], "Text", 
            CellTags -> "A moment integral"], Cell["FORM convenctions like \
ln(1-x) can be translated automatically by FORM2FeynCalc, but they have to be \
listed once in the option Replace of FORM2FeynCalc :", "Text", 
            CellTags -> "A moment integral"], Cell[BoxData[
             \(\(SetOptions[\(FORM2FeynCalc, 
                    \(Replace \[Rule] \(
                       {\("ln(x)" \[Rule] "Log[x]"\), 
                         \("ln(1+x)" \[Rule] "Log[1+x]"\), 
                         \("ln(1-x)" \[Rule] "Log[1-x]"\), 
                         \("Li2(-x)" \[Rule] "Li2[-x]"\), 
                         \("Li2(1-x)" \[Rule] "Li2[1-x]"\), 
                         \("Li3(1-x)" \[Rule] "Li3[1-x]"\), 
                         \("Li3(-x)" \[Rule] "Li3[-x]"\), 
                         \("S12(1-x)" \[Rule] "Nielsen[1,2,1-x]"\), 
                         \("S12(-x)" \[Rule] "Nielsen[1,2,-x]"\), 
                         \("S12(x^2)" \[Rule] "Nielsen[1,2,x^2]"\), 
                         \("Z2" \[Rule] "Zeta2"\), \("Z3" \[Rule] "Zeta[3]"\)
                         , \("[1+x]^-1" \[Rule] "(1+x)^-1"\), 
                         \("[(1-x)+]^-1" \[Rule] "(1-x)^-1"\), 
                         \("[1-x]^-1" \[Rule] "(1-x)^-1"\), 
                         \("delta" \[Rule] "DeltaFunction[1-x]"\), 
                         \("Ca" \[Rule] "CA"\), \("Cf" \[Rule] "CF"\)}\)\), 
                    \(Dot \[Rule] Times\), \(HoldForm \[Rule] False\)\)]\) ;\
\)], "Input", CellTags -> "A moment integral"], Cell["Copy the FORM output \
from jqq12.log into the next cell and put FORM2CFeynCalc[\" \"]//ReleaseHold \
around it.", "Text", CellTags -> "A moment integral"], Cell["aqq=FORM2FeynCal\
c[\"\n\n          + [(-1)^m]*e^-1*O1*Ca*Cf * (\n          - 8\n          + \
4*x*Z2\n          + 8*x\n          + 8*Z2*[1+x]^-1\n          - 4*Z2\n        \
  - 4*ln(x)\n          - 4*ln(x)*x\n          - 8*ln(x)*ln(1 + x)\n          \
+ 8*ln(x)*ln(1 + x)*x\n          + 16*ln(x)*ln(1 + x)*[1+x]^-1\n          + \
2*ln(x)*ln(x)\n          - 2*ln(x)*ln(x)*x\n          - \
4*ln(x)*ln(x)*[1+x]^-1\n          - 8*Li2( - x)\n          + 8*Li2( - x)*x\n  \
        + 16*Li2( - x)*[1+x]^-1\n          )\n\n       + \
[(-1)^m]*e^-1*O1*Cf^2 * (\n          + 16\n          - 8*x*Z2\n          - \
16*x\n          - 16*Z2*[1+x]^-1\n          + 8*Z2\n          + 8*ln(x)\n     \
     + 8*ln(x)*x\n          + 16*ln(x)*ln(1 + x)\n          - 16*ln(x)*ln(1 + \
x)*x\n          - 32*ln(x)*ln(1 + x)*[1+x]^-1\n          - 4*ln(x)*ln(x)\n    \
      + 4*ln(x)*ln(x)*x\n          + 8*ln(x)*ln(x)*[1+x]^-1\n          + \
16*Li2( - x)\n          - 16*Li2( - x)*x\n          - 32*Li2( - x)*[1+x]^-1\n \
         )\n\n       + [(-1)^m]*O1*Ca*Cf * (\n          - 41/3\n          - \
6*x*Z2\n          - 2*x*Z3\n          + 41/3*x\n          + 16/3*x^2*Z2\n     \
     + 6*Z2\n          + 4*Z3*[1+x]^-1\n          - 6*Z3\n          - 8*ln(1 \
- x)\n          + 8*ln(1 - x)*x\n          - 8*ln(1 - x)*Li2(1 - x)\n         \
 + 8*ln(1 - x)*Li2(1 - x)*x\n          + 16*ln(1 - x)*Li2(1 - x)*[1+x]^-1\n   \
       + 8*ln(1 + x)*x*Z2\n          + 8*ln(1 + x)*Z2*[1+x]^-1\n          - \
8*ln(1 + x)*Li2(1 - x)\n          + 8*ln(1 + x)*Li2(1 - x)*x\n          + \
16*ln(1 + x)*Li2(1 - x)*[1+x]^-1\n          + 16*ln(1 + x)*Li2( - x)*x\n      \
    + 16*ln(1 + x)*Li2( - x)*[1+x]^-1\n          - 37/3*ln(x)\n          - \
25/3*ln(x)*x\n          - 4*ln(x)*ln(1 - x)\n          - 4*ln(x)*ln(1 - \
x)*x\n          - 4*ln(x)*ln(1 - x)*ln(1 - x)\n          + 4*ln(x)*ln(1 - \
x)*ln(1 - x)*x\n          + 8*ln(x)*ln(1 - x)*ln(1 - x)*[1+x]^-1\n          - \
8*ln(x)*ln(1 - x)*ln(1 + x)\n          + 8*ln(x)*ln(1 - x)*ln(1 + x)*x\n      \
    + 16*ln(x)*ln(1 - x)*ln(1 + x)*[1+x]^-1\n          + 4/3*ln(x)*ln(1 + \
x)*x^-1\n          + 4*ln(x)*ln(1 + x)*x\n          + 16/3*ln(x)*ln(1 + \
x)*x^2\n          + 8*ln(x)*ln(1 + x)*ln(1 + x)*x\n          + 8*ln(x)*ln(1 + \
x)*ln(1 + x)*[1+x]^-1\n          - 6*ln(x)*ln(x)\n          - \
8/3*ln(x)*ln(x)*x^2\n          + 2*ln(x)*ln(x)*ln(1 - x)\n          - \
2*ln(x)*ln(x)*ln(1 - x)*x\n          - 4*ln(x)*ln(x)*ln(1 - x)*[1+x]^-1\n     \
     - 6*ln(x)*ln(x)*ln(1 + x)\n          + 2*ln(x)*ln(x)*ln(1 + x)*x\n       \
   + 8*ln(x)*ln(x)*ln(1 + x)*[1+x]^-1\n          + ln(x)*ln(x)*ln(x)\n        \
  - ln(x)*ln(x)*ln(x)*x\n          - 2*ln(x)*ln(x)*ln(x)*[1+x]^-1\n          \
+ 4*ln(x)*Li2(1 - x)\n          - 4*ln(x)*Li2(1 - x)*x\n          - \
8*ln(x)*Li2(1 - x)*[1+x]^-1\n          - 4*ln(x)*Li2( - x)\n          + \
4*ln(x)*Li2( - x)*x\n          + 8*ln(x)*Li2( - x)*[1+x]^-1\n          - \
4*Li2(1 - x)\n          - 4*Li2(1 - x)*x\n          + 4/3*Li2( - x)*x^-1\n    \
      + 4*Li2( - x)*x\n          + 16/3*Li2( - x)*x^2\n          + 8*Li3(1 - \
x)\n          - 8*Li3(1 - x)*x\n          - 16*Li3(1 - x)*[1+x]^-1\n          \
- 4*Li3( - x)\n          - 4*Li3( - x)*x\n          + 4*S12(1 - x)\n          \
- 4*S12(1 - x)*x\n          - 8*S12(1 - x)*[1+x]^-1\n          - 8*S12( - \
x)\n          + 24*S12( - x)*x\n          + 32*S12( - x)*[1+x]^-1\n          \
+ 4*S12(x^2)\n          - 4*S12(x^2)*x\n          - 8*S12(x^2)*[1+x]^-1\n     \
     )\n\n       + [(-1)^m]*O1*Cf^2 * (\n          + 82/3\n          + \
12*x*Z2\n          + 4*x*Z3\n          - 82/3*x\n          - 32/3*x^2*Z2\n    \
      - 12*Z2\n          - 8*Z3*[1+x]^-1\n          + 12*Z3\n          + \
16*ln(1 - x)\n          - 16*ln(1 - x)*x\n          + 16*ln(1 - x)*Li2(1 - \
x)\n          - 16*ln(1 - x)*Li2(1 - x)*x\n          - 32*ln(1 - x)*Li2(1 - \
x)*[1+x]^-1\n          - 16*ln(1 + x)*x*Z2\n          - 16*ln(1 + \
x)*Z2*[1+x]^-1\n          + 16*ln(1 + x)*Li2(1 - x)\n          - 16*ln(1 + \
x)*Li2(1 - x)*x\n          - 32*ln(1 + x)*Li2(1 - x)*[1+x]^-1\n          - \
32*ln(1 + x)*Li2( - x)*x\n          - 32*ln(1 + x)*Li2( - x)*[1+x]^-1\n       \
   + 74/3*ln(x)\n          + 50/3*ln(x)*x\n          + 8*ln(x)*ln(1 - x)\n    \
      + 8*ln(x)*ln(1 - x)*x\n          + 8*ln(x)*ln(1 - x)*ln(1 - x)\n        \
  - 8*ln(x)*ln(1 - x)*ln(1 - x)*x\n          - 16*ln(x)*ln(1 - x)*ln(1 - \
x)*[1+x]^-1\n          + 16*ln(x)*ln(1 - x)*ln(1 + x)\n          - \
16*ln(x)*ln(1 - x)*ln(1 + x)*x\n          - 32*ln(x)*ln(1 - x)*ln(1 + \
x)*[1+x]^-1\n          - 8/3*ln(x)*ln(1 + x)*x^-1\n          - 8*ln(x)*ln(1 + \
x)*x\n          - 32/3*ln(x)*ln(1 + x)*x^2\n          - 16*ln(x)*ln(1 + \
x)*ln(1 + x)*x\n          - 16*ln(x)*ln(1 + x)*ln(1 + x)*[1+x]^-1\n          \
+ 12*ln(x)*ln(x)\n          + 16/3*ln(x)*ln(x)*x^2\n          - \
4*ln(x)*ln(x)*ln(1 - x)\n          + 4*ln(x)*ln(x)*ln(1 - x)*x\n          + \
8*ln(x)*ln(x)*ln(1 - x)*[1+x]^-1\n          + 12*ln(x)*ln(x)*ln(1 + x)\n      \
    - 4*ln(x)*ln(x)*ln(1 + x)*x\n          - 16*ln(x)*ln(x)*ln(1 + \
x)*[1+x]^-1\n          - 2*ln(x)*ln(x)*ln(x)\n          + \
2*ln(x)*ln(x)*ln(x)*x\n          + 4*ln(x)*ln(x)*ln(x)*[1+x]^-1\n          - \
8*ln(x)*Li2(1 - x)\n          + 8*ln(x)*Li2(1 - x)*x\n          + \
16*ln(x)*Li2(1 - x)*[1+x]^-1\n          + 8*ln(x)*Li2( - x)\n          - \
8*ln(x)*Li2( - x)*x\n          - 16*ln(x)*Li2( - x)*[1+x]^-1\n          + \
8*Li2(1 - x)\n          + 8*Li2(1 - x)*x\n          - 8/3*Li2( - x)*x^-1\n    \
      - 8*Li2( - x)*x\n          - 32/3*Li2( - x)*x^2\n          - 16*Li3(1 - \
x)\n          + 16*Li3(1 - x)*x\n          + 32*Li3(1 - x)*[1+x]^-1\n         \
 + 8*Li3( - x)\n          + 8*Li3( - x)*x\n          - 8*S12(1 - x)\n         \
 + 8*S12(1 - x)*x\n          + 16*S12(1 - x)*[1+x]^-1\n          + 16*S12( - \
x)\n          - 48*S12( - x)*x\n          - 64*S12( - x)*[1+x]^-1\n          \
- 8*S12(x^2)\n          + 8*S12(x^2)*x\n          + 16*S12(x^2)*[1+x]^-1\n    \
      )\n\n       + [(-1)^m]*O2*Ca*Cf * (\n          + 8/3\n          - \
8/3*x\n          - 16/3*x^2*Z2\n          - 8/3*ln(x)\n          + \
16/3*ln(x)*x\n          + 8/3*ln(x)*ln(1 + x)*x^-1\n          - 8*ln(x)*ln(1 \
+ x)*x\n          - 16/3*ln(x)*ln(1 + x)*x^2\n          + \
8/3*ln(x)*ln(x)*x^2\n          + 8/3*Li2( - x)*x^-1\n          - 8*Li2( - \
x)*x\n          - 16/3*Li2( - x)*x^2\n          )\n\n       + \
[(-1)^m]*O2*Cf^2 * (\n          - 16/3\n          + 16/3*x\n          + \
32/3*x^2*Z2\n          + 16/3*ln(x)\n          - 32/3*ln(x)*x\n          - \
16/3*ln(x)*ln(1 + x)*x^-1\n          + 16*ln(x)*ln(1 + x)*x\n          + \
32/3*ln(x)*ln(1 + x)*x^2\n          - 16/3*ln(x)*ln(x)*x^2\n          - \
16/3*Li2( - x)*x^-1\n          + 16*Li2( - x)*x\n          + 32/3*Li2( - \
x)*x^2\n          )\n\n       + e^-2*delta*O1*Ca*Cf * (\n          - 22\n     \
     )\n\n       + e^-2*delta*O1*Cf*Tf * (\n          + 8\n          )\n\n    \
   + e^-2*delta*O1*Cf^2 * (\n          - 18\n          + 32*Z2\n          \
)\n\n       + e^-2*O1*Ca*Cf * (\n          + 44/3\n          + 44/3*x\n       \
   - 88/3*[(1-x)+]^-1\n          )\n\n       + e^-2*O1*Cf*Tf * (\n          - \
16/3\n          - 16/3*x\n          + 32/3*[(1-x)+]^-1\n          )\n\n       \
+ e^-2*O1*Cf^2 * (\n          + 40\n          + 8*x\n          - \
48*[(1-x)+]^-1\n          + 32*ln(1 - x)\n          + 32*ln(1 - x)*x\n        \
  - 64*ln(1 - x)*[(1-x)+]^-1\n          - 24*ln(x)\n          - 24*ln(x)*x\n  \
        + 32*ln(x)*[1-x]^-1\n          )\n\n       + e^-1*delta*O1*Ca*Cf * \
(\n          + 325/6\n          - 44/3*Z2\n          - 12*Z3\n          )\n\n \
      + e^-1*delta*O1*Cf*Tf * (\n          - 58/3\n          + 16/3*Z2\n      \
    )\n\n       + e^-1*delta*O1*Cf^2 * (\n          + 87/2\n          - \
36*Z2\n          - 8*Z3\n          )\n\n       + e^-1*O1*Ca*Cf * (\n          \
- 158/9\n          + 4*x*Z2\n          + 22/9*x\n          - \
8*Z2*[(1-x)+]^-1\n          + 4*Z2\n          + 238/9*[(1-x)+]^-1\n          \
+ 44/3*ln(1 - x)\n          + 44/3*ln(1 - x)*x\n          - 88/3*ln(1 - \
x)*[(1-x)+]^-1\n          + 34/3*ln(x)\n          + 34/3*ln(x)*x\n          - \
44/3*ln(x)*[1-x]^-1\n          - 2*ln(x)*ln(x)\n          - 2*ln(x)*ln(x)*x\n \
         + 4*ln(x)*ln(x)*[1-x]^-1\n          )\n\n       + e^-1*O1*Cf*Tf * \
(\n          + 88/9\n          - 56/9*x\n          - 56/9*[(1-x)+]^-1\n       \
   - 16/3*ln(1 - x)\n          - 16/3*ln(1 - x)*x\n          + 32/3*ln(1 - \
x)*[(1-x)+]^-1\n          - 8/3*ln(x)\n          - 8/3*ln(x)*x\n          + \
16/3*ln(x)*[1-x]^-1\n          )\n\n       + e^-1*O1*Cf^2 * (\n          - \
40\n          - 4*x\n          + 56*[(1-x)+]^-1\n          - 4*ln(1 - x)\n    \
      + 44*ln(1 - x)*x\n          - 24*ln(1 - x)*[(1-x)+]^-1\n          + \
24*ln(1 - x)*ln(1 - x)\n          + 24*ln(1 - x)*ln(1 - x)*x\n          - \
48*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1\n          + 36*ln(x)\n          - \
20*ln(x)*x\n          - 36*ln(x)*[1-x]^-1\n          - 16*ln(x)*ln(1 - \
x)*[1-x]^-1\n          - 14*ln(x)*ln(x)\n          - 14*ln(x)*ln(x)*x\n       \
   + 16*ln(x)*ln(x)*[1-x]^-1\n          - 8*Li2(1 - x)\n          - 8*Li2(1 - \
x)*x\n          )\n\n       + e^-1*O2*Ca*Cf * (\n          + 20/3\n          \
- 88/3*x\n          )\n\n       + e^-1*O2*Cf*Tf * (\n          - 16/3\n       \
   + 32/3*x\n          )\n\n       + e^-1*O2*Cf^2 * (\n          - 16\n       \
   - 8*x\n          - 32*ln(1 - x)*x\n          + 16*ln(x)*x\n          )\n\n \
      + delta*O1*Ca*Cf * (\n          - 7081/72\n          + 301/18*Z2\n      \
    + 49/5*Z2^2\n          + 28*Z3\n          )\n\n       + delta*O1*Cf*Tf * \
(\n          + 569/18\n          - 46/9*Z2\n          - 8*Z3\n          )\n\n \
      + delta*O1*Cf^2 * (\n          - 541/8\n          + 97/2*Z2\n          \
- 74/5*Z2^2\n          + 54*Z3\n          )\n\n       + O1*Ca*Cf * (\n        \
  + 941/27\n          + 17/3*x*Z2\n          - 8*x*Z3\n          - 580/27*x\n \
         - 16/3*x^2*Z2\n          - 24*x^2*Z3\n          - \
28/3*Z2*[(1-x)+]^-1\n          - 1/3*Z2\n          + 12*Z3*[1-x]^-1\n         \
 + 22*Z3*[(1-x)+]^-1\n          - 20*Z3\n          - 670/27*[(1-x)+]^-1\n     \
     - 122/9*ln(1 - x)\n          + 6*ln(1 - x)*x*Z2\n          - 32/9*ln(1 - \
x)*x\n          + 8*ln(1 - x)*x^2*Z2\n          - 10*ln(1 - \
x)*Z2*[(1-x)+]^-1\n          + 2*ln(1 - x)*Z2\n          + 238/9*ln(1 - \
x)*[(1-x)+]^-1\n          + 22/3*ln(1 - x)*ln(1 - x)\n          + 22/3*ln(1 - \
x)*ln(1 - x)*x\n          - 44/3*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1\n          + \
2*ln(1 - x)*Li2(1 - x)\n          - 2*ln(1 - x)*Li2(1 - x)*x\n          + \
8*ln(1 - x)*Li2(1 - x)*x^2\n          - 2*ln(1 - x)*Li2(1 - x)*[1-x]^-1\n     \
     + 14/9*ln(x)\n          - 2*ln(x)*x*Z2\n          + 176/9*ln(x)*x\n      \
    - 8*ln(x)*x^2*Z2\n          + 10*ln(x)*Z2*[1-x]^-1\n          - \
6*ln(x)*Z2\n          + 101/9*ln(x)*[1-x]^-1\n          + 28/3*ln(x)*ln(1 - \
x)\n          + 10/3*ln(x)*ln(1 - x)*x\n          - 38/3*ln(x)*ln(1 - \
x)*[1-x]^-1\n          - 12*ln(x)*ln(1 + x)\n          - 4/3*ln(x)*ln(1 + \
x)*x^-1\n          - 16*ln(x)*ln(1 + x)*x\n          - 16/3*ln(x)*ln(1 + \
x)*x^2\n          + 47/6*ln(x)*ln(x)\n          + 47/6*ln(x)*ln(x)*x\n        \
  + 8/3*ln(x)*ln(x)*x^2\n          - 11/3*ln(x)*ln(x)*[1-x]^-1\n          + \
ln(x)*ln(x)*ln(1 - x)\n          - ln(x)*ln(x)*ln(1 - x)*x\n          + \
4*ln(x)*ln(x)*ln(1 - x)*x^2\n          - ln(x)*ln(x)*ln(1 - x)*[1-x]^-1\n     \
     - ln(x)*ln(x)*ln(x)\n          - ln(x)*ln(x)*ln(x)*x\n          + \
2*ln(x)*ln(x)*ln(x)*[1-x]^-1\n          + 8*ln(x)*Li2(1 - x)\n          + \
16*ln(x)*Li2(1 - x)*x^2\n          - 12*ln(x)*Li2(1 - x)*[1-x]^-1\n          \
+ 8*ln(x)*Li2( - x)\n          - 8*ln(x)*Li2( - x)*[1-x]^-1\n          - \
12*Li2(1 - x)*x\n          + 4*Li2(1 - x)*[1-x]^-1\n          - 12*Li2( - \
x)\n          - 4/3*Li2( - x)*x^-1\n          - 16*Li2( - x)*x\n          - \
16/3*Li2( - x)*x^2\n          - 6*Li3(1 - x)\n          + 6*Li3(1 - x)*x\n    \
      - 24*Li3(1 - x)*x^2\n          + 6*Li3(1 - x)*[1-x]^-1\n          - \
16*Li3( - x)\n          + 16*Li3( - x)*[1-x]^-1\n          + 14*S12(1 - x)\n  \
        - 6*S12(1 - x)*x\n          + 24*S12(1 - x)*x^2\n          - 14*S12(1 \
- x)*[1-x]^-1\n          )\n\n       + O1*Cf*Tf * (\n          - 88/27\n      \
    - 4/3*x*Z2\n          + 20/27*x\n          + 8/3*Z2*[(1-x)+]^-1\n         \
 - 4/3*Z2\n          + 128/27*[(1-x)+]^-1\n          + 88/9*ln(1 - x)\n       \
   - 56/9*ln(1 - x)*x\n          - 56/9*ln(1 - x)*[(1-x)+]^-1\n          - \
8/3*ln(1 - x)*ln(1 - x)\n          - 8/3*ln(1 - x)*ln(1 - x)*x\n          + \
16/3*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1\n          + 44/9*ln(x)\n          - \
28/9*ln(x)*x\n          - 28/9*ln(x)*[1-x]^-1\n          - 8/3*ln(x)*ln(1 - \
x)\n          - 8/3*ln(x)*ln(1 - x)*x\n          + 16/3*ln(x)*ln(1 - \
x)*[1-x]^-1\n          - 2/3*ln(x)*ln(x)\n          - 2/3*ln(x)*ln(x)*x\n     \
     + 4/3*ln(x)*ln(x)*[1-x]^-1\n          )\n\n       + O1*Cf^2 * (\n        \
  + 188/3\n          - 4*x*Z2\n          - 24*x*Z3\n          + 4/3*x\n       \
   + 32/3*x^2*Z2\n          + 48*x^2*Z3\n          - 4*Z2*[(1-x)+]^-1\n       \
   + 20*Z2\n          - 24*Z3*[1-x]^-1\n          + 24*Z3\n          - \
56*[(1-x)+]^-1\n          - 38*ln(1 - x)\n          + 8*ln(1 - x)*x*Z2\n      \
    + 38*ln(1 - x)*x\n          - 16*ln(1 - x)*x^2*Z2\n          - 8*ln(1 - \
x)*Z2*[(1-x)+]^-1\n          + 8*ln(1 - x)*Z2\n          + 28*ln(1 - \
x)*[(1-x)+]^-1\n          - 13*ln(1 - x)*ln(1 - x)\n          + 31*ln(1 - \
x)*ln(1 - x)*x\n          - 6*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1\n          + \
28/3*ln(1 - x)*ln(1 - x)*ln(1 - x)\n          + 28/3*ln(1 - x)*ln(1 - x)*ln(1 \
- x)*x\n          - 56/3*ln(1 - x)*ln(1 - x)*ln(1 - x)*[(1-x)+]^-1\n          \
- 12*ln(1 - x)*Li2(1 - x)\n          + 4*ln(1 - x)*Li2(1 - x)*x\n          - \
16*ln(1 - x)*Li2(1 - x)*x^2\n          - 68/3*ln(x)\n          - \
14*ln(x)*x*Z2\n          - 68/3*ln(x)*x\n          + 16*ln(x)*x^2*Z2\n        \
  + 2*ln(x)*Z2\n          + 44*ln(x)*[1-x]^-1\n          - 6*ln(x)*ln(1 - \
x)\n          + 34*ln(x)*ln(1 - x)*x\n          - 20*ln(x)*ln(1 - \
x)*[1-x]^-1\n          + 6*ln(x)*ln(1 - x)*ln(1 - x)\n          + \
6*ln(x)*ln(1 - x)*ln(1 - x)*x\n          - 20*ln(x)*ln(1 - x)*ln(1 - \
x)*[1-x]^-1\n          + 24*ln(x)*ln(1 + x)\n          + 8/3*ln(x)*ln(1 + \
x)*x^-1\n          + 32*ln(x)*ln(1 + x)*x\n          + 32/3*ln(x)*ln(1 + \
x)*x^2\n          + 11*ln(x)*ln(x)\n          - 23*ln(x)*ln(x)*x\n          - \
16/3*ln(x)*ln(x)*x^2\n          - 15*ln(x)*ln(x)*[1-x]^-1\n          - \
6*ln(x)*ln(x)*ln(1 - x)\n          + 2*ln(x)*ln(x)*ln(1 - x)*x\n          - \
8*ln(x)*ln(x)*ln(1 - x)*x^2\n          - 4*ln(x)*ln(x)*ln(1 - x)*[1-x]^-1\n   \
       - 5*ln(x)*ln(x)*ln(x)\n          - 5*ln(x)*ln(x)*ln(x)*x\n          + \
16/3*ln(x)*ln(x)*ln(x)*[1-x]^-1\n          - 8*ln(x)*Li2(1 - x)\n          + \
24*ln(x)*Li2(1 - x)*x\n          - 32*ln(x)*Li2(1 - x)*x^2\n          - \
16*ln(x)*Li2(1 - x)*[1-x]^-1\n          - 16*ln(x)*Li2( - x)\n          + \
16*ln(x)*Li2( - x)*[1-x]^-1\n          - 24*Li2(1 - x)\n          + 48*Li2(1 \
- x)*x\n          - 4*Li2(1 - x)*[1-x]^-1\n          + 24*Li2( - x)\n         \
 + 8/3*Li2( - x)*x^-1\n          + 32*Li2( - x)*x\n          + 32/3*Li2( - \
x)*x^2\n          + 20*Li3(1 - x)\n          - 28*Li3(1 - x)*x\n          + \
48*Li3(1 - x)*x^2\n          + 32*Li3( - x)\n          - 32*Li3( - \
x)*[1-x]^-1\n          - 8*S12(1 - x)\n          + 56*S12(1 - x)*x\n          \
- 48*S12(1 - x)*x^2\n          - 32*S12(1 - x)*[1-x]^-1\n          )\n\n      \
 + O2*Ca*Cf * (\n          - 26/9\n          - 8*x*Z2\n          - 24*x*Z3\n  \
        + 232/9*x\n          + 16/3*x^2*Z2\n          + 24*x^2*Z3\n          \
+ 4*Z2\n          - 16/3*ln(1 - x)\n          + 8*ln(1 - x)*x*Z2\n          - \
64/3*ln(1 - x)*x\n          - 8*ln(1 - x)*x^2*Z2\n          + 8*ln(1 - \
x)*Li2(1 - x)*x\n          - 8*ln(1 - x)*Li2(1 - x)*x^2\n          + \
6*ln(x)\n          - 8*ln(x)*x*Z2\n          - 28*ln(x)*x\n          + \
8*ln(x)*x^2*Z2\n          - 4*ln(x)*ln(1 - x)\n          + 8*ln(x)*ln(1 - \
x)*x\n          - 8/3*ln(x)*ln(1 + x)*x^-1\n          + 8*ln(x)*ln(1 + x)*x\n \
         + 16/3*ln(x)*ln(1 + x)*x^2\n          - 8/3*ln(x)*ln(x)*x^2\n        \
  + 4*ln(x)*ln(x)*ln(1 - x)*x\n          - 4*ln(x)*ln(x)*ln(1 - x)*x^2\n      \
    + 16*ln(x)*Li2(1 - x)*x\n          - 16*ln(x)*Li2(1 - x)*x^2\n          - \
8*Li2(1 - x)\n          + 16*Li2(1 - x)*x\n          - 8/3*Li2( - x)*x^-1\n   \
       + 8*Li2( - x)*x\n          + 16/3*Li2( - x)*x^2\n          - 24*Li3(1 \
- x)*x\n          + 24*Li3(1 - x)*x^2\n          + 24*S12(1 - x)*x\n          \
- 24*S12(1 - x)*x^2\n          )\n\n       + O2*Cf*Tf * (\n          - 8/9\n  \
        - 32/9*x\n          - 16/3*ln(1 - x)\n          + 32/3*ln(1 - x)*x\n  \
        - 8/3*ln(x)\n          + 16/3*ln(x)*x\n          )\n\n       + \
O2*Cf^2 * (\n          - 32/3\n          + 16*x*Z2\n          + 48*x*Z3\n     \
     - 16/3*x\n          - 32/3*x^2*Z2\n          - 48*x^2*Z3\n          - \
8*Z2\n          - 16*ln(1 - x)*x*Z2\n          - 44*ln(1 - x)*x\n          + \
16*ln(1 - x)*x^2*Z2\n          - 24*ln(1 - x)*ln(1 - x)*x\n          - \
16*ln(1 - x)*Li2(1 - x)*x\n          + 16*ln(1 - x)*Li2(1 - x)*x^2\n          \
- 40/3*ln(x)\n          + 16*ln(x)*x*Z2\n          + 68/3*ln(x)*x\n          \
- 16*ln(x)*x^2*Z2\n          + 8*ln(x)*ln(1 - x)\n          - 32*ln(x)*ln(1 - \
x)*x\n          + 16/3*ln(x)*ln(1 + x)*x^-1\n          - 16*ln(x)*ln(1 + \
x)*x\n          - 32/3*ln(x)*ln(1 + x)*x^2\n          + 12*ln(x)*ln(x)*x\n    \
      + 16/3*ln(x)*ln(x)*x^2\n          - 8*ln(x)*ln(x)*ln(1 - x)*x\n         \
 + 8*ln(x)*ln(x)*ln(1 - x)*x^2\n          - 32*ln(x)*Li2(1 - x)*x\n          \
+ 32*ln(x)*Li2(1 - x)*x^2\n          + 16*Li2(1 - x)\n          - 48*Li2(1 - \
x)*x\n          + 16/3*Li2( - x)*x^-1\n          - 16*Li2( - x)*x\n          \
- 32/3*Li2( - x)*x^2\n          + 48*Li3(1 - x)*x\n          - 48*Li3(1 - \
x)*x^2\n          - 48*S12(1 - x)*x\n          + 48*S12(1 - x)*x^2\n          \
)\n          \n          \"]//ReleaseHold;", "Input", CellTags -> 
             "A moment integral"], Cell[CellGroupData[{Cell[BoxData[
                \(Short[aqq]\)], "Input", CellTags -> "A moment integral"], 
              Cell[BoxData[FormBox[TagBox[RowBox[{FractionBox[RowBox[
                      {"O1", " ", \((\(32\ \(\[Zeta](2)\)\) - 18)\), " ", 
                       RowBox[{"\[Delta]", "(", FormBox[\(1 - x\), 
                          "TraditionalForm"], ")"}], " ", \(C\_F\%2\)}], 
                     \(\*TagBox["\[CurlyEpsilon]", TraditionalForm]\^2\)], 
                    "+", \(\[LeftSkeleton] 29 \[RightSkeleton]\), "+", 
                    \(\((\(-1\))\)\^m\ C\_A\ O1\ 
                       \((\(\(-x\)\ \(log\^3(x)\)\) - 
                          \(2\ \(\[LeftSkeleton] 1 \[RightSkeleton]\)\)\/
                           \(x + 1\) + \(\[LeftSkeleton] 101 \[RightSkeleton]
                           \))\)\ C\_F\)}], Short], TraditionalForm]], 
               "Output", CellTags -> "A moment integral"]}, Closed]], 
           Cell["By default all bracketed FORM expressions are translated to \
a Hold[] expression.", "Commentary", CellTags -> "A moment integral"], 
           Cell[CellGroupData[{Cell["FORM2FeynCalc[\"-[(-1)^m]\"]", "Input", 
               CellTags -> "A moment integral"], Cell[BoxData[
                \(TraditionalForm\`\(-\(Hold[\(\((\(-1\))\)\^m\)]\)\)\)], 
               "Output", CellTags -> "A moment integral"]}, Closed]], 
           Cell[CellGroupData[{Cell[BoxData[\(%//ReleaseHold\)], "Input", 
               CellTags -> "A moment integral"], Cell[BoxData[
                \(TraditionalForm\`\(-\((\(-1\))\)\^m\)\)], "Output", 
               CellTags -> "A moment integral"]}, Closed]], 
           Cell["The first moment should be zero, which is verified by \
Integrate2 in a reasonable amount of time. The variable O2 can be set to zero \
since it is the coefficient of unphysical matrix elements.", "Text", 
            CellTags -> "A moment integral"], 
           Cell[TextData[{"This calculates for m=1 the integral ", 
              Cell[BoxData[
                \(TraditionalForm\`\(\[Integral]\_0\%\(1\ \)\ 
                     \(\(\*StyleBox[\(\(
                              \*StyleBox["A", Rule[FontSlant, "Plain"]]\)\&^
                \), Rule[FontSlant, "Plain"]]\)\_qq\%\(NS, PHYS\)\ 
                       \(\[DifferentialD] x\)\)\ \)\)]], ":"}], "Text", 
            CellTags -> "A moment integral"], Cell[CellGroupData[
             {Cell[BoxData[
                \(Timing[\(Integrate2[\(\(
                        \(aqq/.\(m \[Rule] 1\)\)/.\(O2 \[Rule] 0\)\), 
                       \({x, 0, 1}\)\)]\)]\)], "Input", CellTags -> 
                "A moment integral"], Cell[BoxData[
                \(TraditionalForm\`\({\(3.0425379999999995`\ Second\), 0}\)\)]\
, "Output", CellTags -> "A moment integral"]}, Closed]], Cell["If you know \
that no partial fraction decomposition has to be done then Integrate3 will be \
much faster on an expanded or collected integral:", "Text", 
            CellTags -> "A moment integral"], Cell[CellGroupData[
             {Cell[BoxData[
                \(Timing[\(Expand[\(Integrate3[
                       \(\(Expand[\(\(aqq/.\(m \[Rule] 1\)\)/.
                             \(O2 \[Rule] 0\)\)]\), \({x, 0, 1}\)\)]\)]\)]\)]\
, "Input", CellTags -> "A moment integral"], Cell[BoxData[
                \(TraditionalForm\`\({\(0.8498709999999996`\ Second\), 0}\)\)]\
, "Output", CellTags -> "A moment integral"]}, Closed]], 
           Cell["Define an auxiliary typesetting function:", "Text", 
            CellTags -> "A moment integral"], Cell[BoxData[
             \(\(\(MakeBoxes[\(\(big[a_]\),\ f_\)]\)\ :=\ 
                  \(StyleBox[\(\(MakeBoxes[\(a,\ f\)]\),\ 
                      \(FontColor\ \[Rule]\ \(RGBColor[\(0,\ 0,\ 1\)]\)\),
                      \(\ \ \ \)\(FontSize\ \[Rule]\ 18\)\)]\)\) ;\)], 
            "Input", CellTags -> "A moment integral"], 
           Cell["The second moment takes a little bit longer.", "Text", 
            CellTags -> "A moment integral"], Cell[CellGroupData[
             {Cell[BoxData[
                \(\(Timing[\(Collect2[\(\(
                          Integrate2[\(\(
                              \(\(\(x\ aqq\)/.\(m \[Rule] 2\)\)/.
                                 \(O2 \[Rule] 0\)\)/.\(O1 \[Rule] 1\)\), 
                             \({x, 0, 1}\)\)]\), \({CA, CF, Tf}\), 
                         \(Factoring \[Rule] False\)\)]\)]\)/.\ 
                   \({\(\(CA\ CF\)\ \[RuleDelayed]\ \(big[\ \(CA\ CF\)]\)\), 
                      \(\(CF^2\) \[RuleDelayed] \(big[\(CF^2\)]\)\), 
                      \(\(a_\ CF\ Tf\)\ \[RuleDelayed] 
                        \(HoldForm[\ \(\(big[\(CF\ Tf\)]\)\ a\)]\)\)}\)\)], 
               "Input", CellTags -> "A moment integral"], Cell[BoxData[
                \(TraditionalForm\`\({\(4.427326999999999`\ Second\), 
                      \(\*TagBox[\(\((\*
                               StyleBox[\(C\_F\ T\_f\), 
                                Rule[FontSize, 18.`], 
                                Rule[FontColor, RGBColor[0.`, 0.`, 1.`]]])\)
                \ \((\(16\ \(\[Zeta] \((2)\)\)\)\/9 + 
                               376\/\(27\ 
                                  \*TagBox["\[CurlyEpsilon]", 
                                    TraditionalForm]\) - 
                               64\/\(9\ 
                                  \*TagBox["\[CurlyEpsilon]", 
                                     TraditionalForm]\^2\) - 2086\/81)\)\), 
                          HoldForm] + \(\(
                           (\*StyleBox[\(C\_A\ C\_F\), Rule[FontSize, 18.`], 
                              Rule[FontColor, RGBColor[0.`, 0.`, 1.`]]])\)\ 
                          \((\(-\(\(44\ \(\[Zeta](2)\)\)\/9\)\) - 
                             1166\/\(27\ 
                                \*TagBox["\[CurlyEpsilon]", TraditionalForm]\
\) + 176\/\(9\ \*TagBox["\[CurlyEpsilon]", TraditionalForm]\^
                                 2\) - \(
                              12\ \*TagBox[\(
                                  \[Zeta] 
                                   \((\*
                                     TagBox["3", Zeta, Rule[Editable, True]]\
)\)\), InterpretTemplate[Function[BoxForm`e$, 
                                   Zeta[BoxForm`e$]]]]\) + 12133\/162)\)\) + 
                        \(\*StyleBox[\(C\_F\%2\), Rule[FontSize, 18.`], 
                            Rule[FontColor, RGBColor[0.`, 0.`, 1.`]]]\ 
                          \((\(32\ \(\[Zeta](2)\)\)\/9 + 
                             752\/\(27\ \*
                                 TagBox["\[CurlyEpsilon]", TraditionalForm]\)\
 - 128\/\(9\ \*TagBox["\[CurlyEpsilon]", TraditionalForm]\^2
                               \) + \(8\ 
                               \*TagBox[\(
                                  \[Zeta] 
                                   \((\*
                                     TagBox["3", Zeta, Rule[Editable, True]]\
)\)\), InterpretTemplate[Function[BoxForm`e$, 
                                   Zeta[BoxForm`e$]]]]\) - 3452\/81)\)\)\)}\)
                \)], "Output", CellTags -> "A moment integral"]}, Closed]], 
           Cell["Try to do the general Mellin transform (replace m by OPEm, \
which has special properties):", "Text", CellTags -> "A moment integral"], 
           Cell[BoxData[
             \(\(gqq\ =\ \(Collect2[\(\(
                       \(\(x\^\(OPEm - 1\) \((aqq/.\(m \[Rule] OPEm\))\)\)/.
                          \(O2 \[Rule] 0\)\)/.\(O1 \[Rule] 1\)\), x\)]\)\) ;\
\)], "Input", CellTags -> "A moment integral"], Cell[CellGroupData[
             {Cell[BoxData[\(gqq//Length\)], "Input", CellTags -> 
                "A moment integral"], Cell[BoxData[\(TraditionalForm\`102\)], 
               "Output", CellTags -> "A moment integral"]}, Closed]], 
           Cell["There are 102 integrals. However, some of the Mellin \
transforms cannot be done at the moment.", "Text", CellTags -> 
             "A moment integral"], Cell[BoxData[
             \(\(ww = \(Integrate3[\(gqq, \({x, 0, 1}\)\)]\)\) ;\)], "Input", 
            CellTags -> "A moment integral"], Cell["If an integral cannot be \
performed the head Hold[Integrate3] is substituted for Integrate3. Thus, in \
order to find the list of integrals not done you can do:", "Text", 
            CellTags -> "A moment integral"], Cell[CellGroupData[
             {Cell[BoxData[\(Cases2[\(ww, \(Hold[Integrate3]\)\)]\)], 
               "Input", CellTags -> "A moment integral"], Cell[BoxData[
                FormBox[RowBox[{"{", RowBox[{RowBox[{\(Hold[Integrate3]\), 
                       "[", RowBox[{RowBox[{\(x\^\(m - 1\)\), " ", RowBox[
                          {SubscriptBox["S", RowBox[{FormBox["1", 
                          "TraditionalForm"], FormBox["2", 
                          "TraditionalForm"]}]], "(", FormBox[\(x\^2\), 
                          "TraditionalForm"], ")"}]}], ",", \({x, 0, 1}\)}], 
                       "]"}], ",", RowBox[{\(Hold[Integrate3]\), "[", 
                       RowBox[{RowBox[{\(x\^m\), " ", RowBox[{SubscriptBox[
                          "S", RowBox[{FormBox["1", "TraditionalForm"], 
                          FormBox["2", "TraditionalForm"]}]], "(", FormBox[
                          \(x\^2\), "TraditionalForm"], ")"}]}], ",", 
                         \({x, 0, 1}\)}], "]"}], ",", RowBox[{
                       \(Hold[Integrate3]\), "[", RowBox[{FractionBox[RowBox[{
                          \(x\^\(m - 1\)\), " ", RowBox[{SubscriptBox["S", 
                          RowBox[{FormBox["1", "TraditionalForm"], FormBox[
                          "2", "TraditionalForm"]}]], "(", FormBox[\(x\^2\), 
                          "TraditionalForm"], ")"}]}], \(x + 1\)], ",", 
                         \({x, 0, 1}\)}], "]"}], ",", 
                     \(\(Hold[Integrate3]\)[
                        \(\(x\^\(m - 1\)\ \(log(1 - x)\)\ 
                             \(\(\*InterpretationBox["Li", PolyLog, 
                                   Rule[Editable, False], 
                                   Rule[Selectable, False]]\)\_2(1 - x)\)\)\/
                           \(x + 1\), \({x, 0, 1}\)\)]\), ",", 
                     \(\(Hold[Integrate3]\)[
                        \(\(x\^\(m - 1\)\ \(log(x + 1)\)\ 
                            \(\(\*InterpretationBox["Li", PolyLog, 
                                  Rule[Editable, False], 
                                  Rule[Selectable, False]]\)\_2(1 - x)\)\), 
                          \({x, 0, 1}\)\)]\), ",", 
                     \(\(Hold[Integrate3]\)[
                        \(\(x\^m\ \(log(x + 1)\)\ 
                            \(\(\*InterpretationBox["Li", PolyLog, 
                                  Rule[Editable, False], 
                                  Rule[Selectable, False]]\)\_2(1 - x)\)\), 
                          \({x, 0, 1}\)\)]\), ",", 
                     \(\(Hold[Integrate3]\)[
                        \(\(x\^\(m - 1\)\ \(log(x + 1)\)\ 
                             \(\(\*InterpretationBox["Li", PolyLog, 
                                   Rule[Editable, False], 
                                   Rule[Selectable, False]]\)\_2(1 - x)\)\)\/
                           \(x + 1\), \({x, 0, 1}\)\)]\)}], "}"}], 
                 TraditionalForm]], "Output", CellTags -> 
                "A moment integral"]}, Closed]], 
           Cell[TextData[
             {"Change the appearance and retain only those integrals with ", 
              Cell[BoxData[\(TraditionalForm\`\(x\^\(m - 1\) :\)\)]]}], 
            "Text", CellTags -> "A moment integral"], 
           Cell[CellGroupData[{Cell[BoxData[
                \(\(Select2[\(%, x\^\(OPEm - 1\)\)]\)/.\ 
                   \(\(\(Hold[Integrate3]\)[z__]\) \[RuleDelayed]\ 
                     \(HoldForm[\(Integrate[z]\)]\)\)\)], "Input", 
               CellTags -> "A moment integral"], Cell[BoxData[FormBox[
                 RowBox[{"{", RowBox[{TagBox[RowBox[{\(\[Integral]\_0\%1\), 
                        RowBox[{RowBox[{\(x\^\(m - 1\)\), " ", RowBox[
                          {SubscriptBox["S", RowBox[{FormBox["1", 
                          "TraditionalForm"], FormBox["2", 
                          "TraditionalForm"]}]], "(", FormBox[\(x\^2\), 
                          "TraditionalForm"], ")"}]}], \(\[DifferentialD] x\)}
                          ]}], HoldForm], ",", TagBox[RowBox[{
                        \(\[Integral]\_0\%1\), RowBox[{FractionBox[RowBox[{
                          \(x\^\(m - 1\)\), " ", RowBox[{SubscriptBox["S", 
                          RowBox[{FormBox["1", "TraditionalForm"], FormBox[
                          "2", "TraditionalForm"]}]], "(", FormBox[\(x\^2\), 
                          "TraditionalForm"], ")"}]}], \(x + 1\)], 
                          \(\[DifferentialD] x\)}]}], HoldForm], ",", 
                     TagBox[\(\[Integral]\_0\%1 
                         \(\(x\^\(m - 1\)\ \(log(1 - x)\)\ 
                              \(\(\*InterpretationBox["Li", PolyLog, 
                                    Rule[Editable, False], 
                                    Rule[Selectable, False]]\)\_2(1 - x)\)\)
                     \/\(x + 1\) \(\[DifferentialD] x\)\)\), HoldForm], ",", 
                     TagBox[\(\[Integral]\_0\%1 
                         \(\(x\^\(m - 1\)\ \(log(x + 1)\)\ 
                             \(\(\*InterpretationBox["Li", PolyLog, 
                                   Rule[Editable, False], 
                                   Rule[Selectable, False]]\)\_2(1 - x)\)\) 
                           \(\[DifferentialD] x\)\)\), HoldForm], ",", 
                     TagBox[\(\[Integral]\_0\%1 
                         \(\(x\^\(m - 1\)\ \(log(x + 1)\)\ 
                              \(\(\*InterpretationBox["Li", PolyLog, 
                                    Rule[Editable, False], 
                                    Rule[Selectable, False]]\)\_2(1 - x)\)\)
                     \/\(x + 1\) \(\[DifferentialD] x\)\)\), HoldForm]}], 
                   "}"}], TraditionalForm]], "Output", CellTags -> 
                "A moment integral"]}, Closed]], Cell["If you know the \
answers for these integrals please share the knowledge.", "Text", 
            CellTags -> "A moment integral"], Cell[BoxData[
             \(Clear[\(e, ww, gqq, big, aqq\)]\)], "Input", 
            CellTags -> "A moment integral"], Cell[BoxData[
             \(\(SetOptions[\(FORM2FeynCalc, \(Replace \[Rule] \({}\)\)\)]
                 \) ;\)], "Input", CellTags -> "A moment integral"], 
           Cell[TextData[{"See also: ", 
              ButtonBox["CA", RuleDelayed[ButtonData, "CA"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["CF", RuleDelayed[ButtonData, "CF"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Cases2", RuleDelayed[ButtonData, "Cases2"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Collect2", RuleDelayed[ButtonData, "Collect2"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["DeltaFunction", 
                RuleDelayed[ButtonData, "DeltaFunction"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Epsilon", RuleDelayed[ButtonData, "Epsilon"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["FORM2FeynCalc", 
                RuleDelayed[ButtonData, "FORM2FeynCalc"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Integrate2", RuleDelayed[ButtonData, "Integrate3"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Integrate3", RuleDelayed[ButtonData, "Integrate3"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Li2", RuleDelayed[ButtonData, "Li2"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Li3", RuleDelayed[ButtonData, "Li3"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Nielsen", RuleDelayed[ButtonData, "Nielsen"], 
                Rule[ButtonStyle, "AddOnsLink"]], ", ", 
              ButtonBox["Zeta2", RuleDelayed[ButtonData, "Zeta2"], 
                Rule[ButtonStyle, "AddOnsLink"]], "."}], "Text", 
            CellTags -> "A moment integral"]}, Closed]]}, Closed]]}, Open]]}, 
 ScreenRectangle -> {{0., 1024.}, {0., 723.}}, 
 ScreenStyleEnvironment -> "AllBrackets", ShowPageBreaks -> False, 
 WindowToolbars -> "EditBar", EvaluationCompletionAction -> {}, 
 CellGrouping -> Manual, WindowSize -> {728., 619.}, 
 WindowMargins -> {{81., Automatic}, {Automatic, 22.}}, 
 PrintingStartingPageNumber -> 1, PrintingPageRange -> 
  {Automatic, Automatic}, PageHeaders -> 
  {{Inherited, Cell[TextData[ValueBox["FileName"]], "Header"], Inherited}, 
   {Inherited, Cell[TextData[ValueBox["FileName"]], "Header"], Inherited}}, 
 PageFooters -> {{Inherited, Cell[TextData[ValueBox["DateLong"]], "Footer"], 
    Inherited}, {Inherited, Cell[TextData[ValueBox["DateLong"]], "Footer"], 
    Inherited}}, PrintingOptions -> 
  {"PrintingMargins" -> {{54., 54.}, {72., 72.}}, 
   "PaperSize" -> {597.5625, 842.375}, "PaperOrientation" -> "Portrait", 
   "PrintCellBrackets" -> False, "PrintSelectionHighlighting" -> False, 
   "PrintRegistrationMarks" -> True, "PrintMultipleHorizontalPages" -> False, 
   "FirstPageHeader" -> False, "FirstPageFooter" -> True, 
   "FacingPages" -> True, "FirstPageFace" -> Left, 
   "GraphicsPrintingFormat" -> "Automatic", "Magnification" -> 1.}, 
 PrivateNotebookOptions -> {"ShortBoxForm" -> False}, ShowSelection -> True, 
 TaggingRules :> {"MakeContentsNonDefaultOptions" -> 
    {AutomaticCellTagging -> FromContent, PageNumbers -> False, 
     SaveOptions -> True, SelectCellStyles -> {"Section", "Subsection"}, 
     TOCCellStyles -> {"Contents", "Index"}}}, CellLabelAutoDelete -> True, 
 ShowCellTags -> True, Magnification -> 1., 
 StyleDefinitions -> "HelpBrowser.nb"]
