BrowserCategory["High Energy Physics",
    None, {
    Item["Introduction", "FeynCalcManual.nb", 
          IndexTag -> "Short Overview", CopyTag -> "intro"],

    Item["Starting FeynCalc", "FeynCalcManual.nb",
          IndexTag -> "Load FeynCalc", CopyTag ->"start"],

    BrowserCategory["Example Calculations",
        None, {
        Item["About Example Calculations", "FeynCalcManual.nb", IndexTag -> "ex"],
        Item["Pair Production", "FeynCalcManual.nb", IndexTag->"Tree level"],
        Item["Moment Integral", "FeynCalcManual.nb", IndexTag->"A moment integral"]}
    ],

    BrowserCategory["Extras",
        None, {
        Item["About Extras", "FeynCalcManual.nb",
          IndexTag->"About Extras"],
        Item["TARCER", "FeynCalcManual.nb", IndexTag->"tarcer"],
        Item["Phi", "FeynCalcManual.nb", IndexTag->"phi"],
        Item["FeynArts", "FeynCalcManual.nb", IndexTag->"fa"]}
    ],


    BrowserCategory["Functions", None, {
      BrowserCategory["Core", None, {
        (* Functions *)
        Item["Abbreviation", "FeynCalcRef.nb"],
        Item["Anti5", "FeynCalcRef.nb"],
        Item["AntiCommutator", "FeynCalcRef.nb"],
        Item["AntiQuarkField", "FeynCalcRef.nb"],
        Item["Cases2", "FeynCalcRef.nb"],
        Item["CheckDB", "FeynCalcRef.nb"],
        Item["ChiralityProjector", "FeynCalcRef.nb"],
        Item["Commutator", "FeynCalcRef.nb"],
        Item["CommutatorExplicit", "FeynCalcRef.nb"],
        Item["CounterT", "FeynCalcRef.nb"],
        Item["CouplingConstant", "FeynCalcRef.nb"],
        Item["DataType", "FeynCalcRef.nb"],
        Item["DeclareNonCommutative", "FeynCalcRef.nb"],
        Item["DeltaFunction", "FeynCalcRef.nb"],
        Item["DeltaFunctionDoublePrime", "FeynCalcRef.nb"],
        Item["DeltaFunctionPrime", "FeynCalcRef.nb"],
        Item["DiracBasis", "FeynCalcRef.nb"],
        Item["DiracGamma", "FeynCalcRef.nb"],
        Item["DiracGammaCombine", "FeynCalcRef.nb"],
        Item["DiracGammaExpand", "FeynCalcRef.nb"],
        Item["DiracGammaT", "FeynCalcRef.nb"],
        Item["DiracMatrix", "FeynCalcRef.nb"],
        Item["DiracOrder", "FeynCalcRef.nb"],
        Item["DiracSigma", "FeynCalcRef.nb"],
        Item["DiracSigmaExplicit", "FeynCalcRef.nb"],
        Item["DiracSlash", "FeynCalcRef.nb"],
        Item["DiracSpinor", "FeynCalcRef.nb"],
        Item["DOT", "FeynCalcRef.nb"],
        Item["Eps", "FeynCalcRef.nb"],
        Item["EpsEvaluate", "FeynCalcRef.nb"],
        Item["ExpandScalarProduct", "FeynCalcRef.nb", IndexTag -> {"ExpandScalarProduct" , "ScalarProductExpand"}],
        Item["ExplicitLorentzIndex", "FeynCalcRef.nb"],
        Item["ExplicitSUNIndex", "FeynCalcRef.nb"],
        Item["FeynAmp", "FeynCalcRef.nb"],
        Item["FeynAmpDenominator", "FeynCalcRef.nb"],
        Item["FeynAmpList", "FeynCalcRef.nb"],
        Item["FeynCalc", "FeynCalcRef.nb"],
        Item["FourVector", "FeynCalcRef.nb"],
        Item["FreeIndex", "FeynCalcRef.nb"],
        Item["FreeQ2", "FeynCalcRef.nb"],
        Item["GammaExpand", "FeynCalcRef.nb"],
        Item["GaugeField", "FeynCalcRef.nb"],
        Item["GaugeXi", "FeynCalcRef.nb"],
        Item["GluonField", "FeynCalcRef.nb"],
        Item["GrassmannParity", "FeynCalcRef.nb"],
        Item["Gstrong", "FeynCalcRef.nb"],
        Item["IFPD", "FeynCalcRef.nb"],
        Item["Integratedx", "FeynCalcRef.nb"],
        Item["KK", "FeynCalcRef.nb"],
        Item["LeftPartialD", "FeynCalcRef.nb"],
        Item["LeftRightPartialD", "FeynCalcRef.nb"],
        Item["LeftRightPartialD2", "FeynCalcRef.nb"],
        Item["LeviCivita", "FeynCalcRef.nb"],
        Item["Li2", "FeynCalcRef.nb"],
        Item["Li3", "FeynCalcRef.nb"],
        Item["LorentzIndex", "FeynCalcRef.nb"],
        Item["Lower", "FeynCalcRef.nb"],
        Item["Mandelstam", "FeynCalcRef.nb"],
        Item["MetricTensor", "FeynCalcRef.nb"],
        Item["Momentum", "FeynCalcRef.nb"],
        Item["MomentumCombine", "FeynCalcRef.nb"],
        Item["MomentumCombine2", "FeynCalcRef.nb"],
        Item["MomentumExpand", "FeynCalcRef.nb"],
        Item["NegativeInteger", "FeynCalcRef.nb"],
        Item["NonCommFreeQ", "FeynCalcRef.nb"],
        Item["NonCommQ", "FeynCalcRef.nb"],
        Item["NonCommutative", "FeynCalcRef.nb"],
        Item["Pair", "FeynCalcRef.nb"],
        Item["PairContract", "FeynCalcRef.nb"],
        Item["PairContract2", "FeynCalcRef.nb"],
        Item["PairContract3", "FeynCalcRef.nb"],
        Item["PartialD", "FeynCalcRef.nb"],
        Item["PauliSigma", "FeynCalcRef.nb"],
        Item["PlusDistribution", "FeynCalcRef.nb"],
        Item["Polarization", "FeynCalcRef.nb"],
        Item["PolarizationVector", "FeynCalcRef.nb"],
        Item["PositiveInteger", "FeynCalcRef.nb"],
        Item["PositiveNumber", "FeynCalcRef.nb"],
        Item["PropagatorDenominator", "FeynCalcRef.nb"],
        Item["QuantumField", "FeynCalcRef.nb"],
        Item["QuarkField", "FeynCalcRef.nb"],
        Item["ScalarProduct", "FeynCalcRef.nb"],
        Item["ScalarProductExpand", "FeynCalcRef.nb", IndexTag -> "ExpandScalarProduct"],
        Item["SmallVariable", "FeynCalcRef.nb"],
        Item["Spinor", "FeynCalcRef.nb"],
        Item["SpinorU", "FeynCalcRef.nb"],
        Item["SpinorUBar", "FeynCalcRef.nb"],
        Item["SpinorV", "FeynCalcRef.nb"],
        Item["SpinorVBar", "FeynCalcRef.nb"],
        Item["SUND", "FeynCalcRef.nb"],
        Item["SUNDelta", "FeynCalcRef.nb"],
        Item["SUNDeltaContract", "FeynCalcRef.nb"],
        Item["SUNF", "FeynCalcRef.nb"],
        Item["SUNIndex", "FeynCalcRef.nb"],
        Item["SUNT", "FeynCalcRef.nb"],
        Item["Trick", "FeynCalcRef.nb"],
        Item["UnDeclareNonCommutative", "FeynCalcRef.nb"],
        Item["Upper", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Abbreviations *)
        Item["FAD", "FeynCalcRef.nb"],
        Item["FV", "FeynCalcRef.nb"],
        Item["FVD", "FeynCalcRef.nb"],
        Item["GA", "FeynCalcRef.nb"],
        Item["GA5", "FeynCalcRef.nb"],
        Item["GAD", "FeynCalcRef.nb"],
        Item["GS", "FeynCalcRef.nb"],
        Item["GSD", "FeynCalcRef.nb"],
        Item["LC", "FeynCalcRef.nb"],
        Item["LCD", "FeynCalcRef.nb"],
        Item["MT", "FeynCalcRef.nb"],
        Item["MTD", "FeynCalcRef.nb"],
        Item["PD", "FeynCalcRef.nb"],
        Item["SD", "FeynCalcRef.nb"],
        Item["SO", "FeynCalcRef.nb"],
        Item["SOD", "FeynCalcRef.nb"],
        Item["SP", "FeynCalcRef.nb"],
        Item["SPC", "FeynCalcRef.nb"],
        Item["SPD", "FeynCalcRef.nb"],
        Item["SPL", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Variables and constants *)
        Item["CA", "FeynCalcRef.nb"],
        Item["CF", "FeynCalcRef.nb"],
        Item["Epsilon", "FeynCalcRef.nb"],
        Item["Nf", "FeynCalcRef.nb"],
        Item["ScaleMu", "FeynCalcRef.nb"],
        Item["SmallDelta", "FeynCalcRef.nb"],
        Item["SmallEpsilon", "FeynCalcRef.nb"],
        Item["SUNN", "FeynCalcRef.nb"],
        Item["$Abbreviations", "FeynCalcRef.nb"],
        Item["$AL", "FeynCalcRef.nb"],
        Item["$BreitMaison", "FeynCalcRef.nb"],
        Item["$Color", "FeynCalcRef.nb"],
        Item["$Covariant", "FeynCalcRef.nb"],
        Item["$FCS", "FeynCalcRef.nb"],
        Item["$FCT", "FeynCalcRef.nb"],
        Item["$FeynCalcStuff", "FeynCalcRef.nb"],
        Item["$FeynCalcVersion", "FeynCalcRef.nb"],
        Item["$Gauge", "FeynCalcRef.nb"],
        Item["$Larin", "FeynCalcRef.nb"],
        Item["$LimitTo4", "FeynCalcRef.nb"],
        Item["$LorentzIndices", "FeynCalcRef.nb"],
        Item["$MemoryAvailable", "FeynCalcRef.nb"],
        Item["$MU", "FeynCalcRef.nb"],
        Item["$NonComm", "FeynCalcRef.nb"],
        Item["$PairBrackets", "FeynCalcRef.nb"],
        Item["$SpinorMinimal", "FeynCalcRef.nb"],
        Item["$VeryVerbose", "FeynCalcRef.nb"],
        Item["$West", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Options *)
        Item["Collecting", "FeynCalcRef.nb"],
        Item["Dimension", "FeynCalcRef.nb"],
        Item["DimensionalReduction", "FeynCalcRef.nb"],
        Item["DiracTraceEvaluate", "FeynCalcRef.nb"],
        Item["Divideout", "FeynCalcRef.nb"],
        Item["EpsContract", "FeynCalcRef.nb"],
        Item["EpsDiscard", "FeynCalcRef.nb"],
        Item["EpsilonOrder", "FeynCalcRef.nb"],
        Item["Expanding", "FeynCalcRef.nb"],
        Item["Explicit", "FeynCalcRef.nb"],
        Item["ExtraFactor", "FeynCalcRef.nb"],
        Item["Factoring", "FeynCalcRef.nb"],
        Item["Factorout", "FeynCalcRef.nb"],
        Item["FCIntegrate", "FeynCalcRef.nb"],
        Item["FCNIntegrate", "FeynCalcRef.nb"],
        Item["FeynmanParameterNames", "FeynCalcRef.nb"],
        Item["FinalSubstitutions", "FeynCalcRef.nb"],
        Item["Gauge", "FeynCalcRef.nb"],
        Item["IncludePair", "FeynCalcRef.nb"],
        Item["InitialSubstitutions", "FeynCalcRef.nb"],
        Item["IntegralTable", "FeynCalcRef.nb"],
        Item["IntermediateSubstitutions", "FeynCalcRef.nb"],
        Item["IsolateNames", "FeynCalcRef.nb"],
        Item["LeviCivitaSign", "FeynCalcRef.nb"],
        Item["Loop", "FeynCalcRef.nb"],
        Item["PairCollect", "FeynCalcRef.nb"],
        Item["PaVeOrderList", "FeynCalcRef.nb"],
        Item["QuarkMass", "FeynCalcRef.nb"],
        Item["SUNNToCACF", "FeynCalcRef.nb"],
        Item["TraceOfOne", "FeynCalcRef.nb"],
        Item["WriteOut", "FeynCalcRef.nb"],
        Item["WriteOutPaVe", "FeynCalcRef.nb"],
        Item["ZeroMomentumInsertion", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Internal objects *)
        Item["CheckContext", "FeynCalcRef.nb"],
        Item["FC", "FeynCalcRef.nb"],
        Item["FeynCalcForm", "FeynCalcRef.nb"],
        Item["FI", "FeynCalcRef.nb"],
        Item["MakeContext", "FeynCalcRef.nb"],
        Item["MemoryAvailable", "FeynCalcRef.nb"],
        Item["MemSet", "FeynCalcRef.nb"],
        Item["OPE", "FeynCalcRef.nb"],
        Item["SubContext", "FeynCalcRef.nb"],
        Item["Tbox", "FeynCalcRef.nb", IndexTag -> "TBox"],
        Item["TBox", "FeynCalcRef.nb", IndexTag -> {"TBox", "Tbox"}]
      }],
      BrowserCategory["Tools", None, {
        (* Functions *)
        Item["Amputate", "FeynCalcRef.nb"],
        Item["Apart2", "FeynCalcRef.nb"],
        Item["Calc", "FeynCalcRef.nb"],
        Item["ChangeDimension", "FeynCalcRef.nb"],
        Item["ChargeConjugationMatrixInv", "FeynCalcRef.nb"],
        Item["ChargeConjugationMatrix", "FeynCalcRef.nb"],
        Item["Chisholm", "FeynCalcRef.nb"],
        Item["ChisholmSpinor", "FeynCalcRef.nb"],
        Item["ClearScalarProducts", "FeynCalcRef.nb"],
        Item["CompleteSquare", "FeynCalcRef.nb"],
        Item["ComplexConjugate", "FeynCalcRef.nb"],
        Item["Contract", "FeynCalcRef.nb"],
        Item["Contract1", "FeynCalcRef.nb"],
        Item["CovariantD", "FeynCalcRef.nb"],
        Item["CovariantFieldDerivative", "FeynCalcRef.nb"],
        Item["CrossProduct", "FeynCalcRef.nb"],
        Item["DiracEquation", "FeynCalcRef.nb"],
        Item["DiracReduce", "FeynCalcRef.nb"],
        Item["DiracSimplify", "FeynCalcRef.nb"],
        Item["DiracSimplify2", "FeynCalcRef.nb"],
        Item["DiracTrace", "FeynCalcRef.nb"],
        Item["DiracTrick", "FeynCalcRef.nb"],
        Item["DotExpand", "FeynCalcRef.nb"],
        Item["DotProduct", "FeynCalcRef.nb"],
        Item["DotSimplify", "FeynCalcRef.nb"],
        Item["EpsChisholm", "FeynCalcRef.nb"],
        Item["EpsUncontract", "FeynCalcRef.nb"],
        Item["ExpandPartialD", "FeynCalcRef.nb"],
        Item["ExplicitPartialD", "FeynCalcRef.nb"],
        Item["FCIntegral", "FeynCalcRef.nb"],
        Item["FermionSpinSum", "FeynCalcRef.nb"],
        Item["FeynCalc2FORM", "FeynCalcRef.nb"],
        Item["FeynRule", "FeynCalcRef.nb"],
        Item["FieldStrength", "FeynCalcRef.nb"],
        Item["FieldDerivative", "FeynCalcRef.nb"],
        Item["FORM2FeynCalc", "FeynCalcRef.nb"],
        Item["FourDivergence", "FeynCalcRef.nb"],
        Item["FourLaplacian", "FeynCalcRef.nb"],
        Item["FunctionalD", "FeynCalcRef.nb"],
        Item["PartialFourVector", "FeynCalcRef.nb"],
        Item["PolarizationSum", "FeynCalcRef.nb"],
        Item["PolarizationUncontract", "FeynCalcRef.nb"],
        Item["RightPartialD", "FeynCalcRef.nb"],
        Item["RussianTrick", "FeynCalcRef.nb"],
        Item["ScalarProductCancel", "FeynCalcRef.nb"],
        Item["Schouten", "FeynCalcRef.nb"],
        Item["SetMandelstam", "FeynCalcRef.nb"],
        Item["SimplifyDeltaFunction", "FeynCalcRef.nb"],
        Item["TensorFunction", "FeynCalcRef.nb"],
        Item["ThreeVector", "FeynCalcRef.nb"],
        Item["Tr", "FeynCalcRef.nb"],
        Item["Tr2", "FeynCalcRef.nb"],
        Item["TrickMandelstam", "FeynCalcRef.nb"],
        Item["Uncontract", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Options *)
        Item["DiracCanonical", "FeynCalcRef.nb"],
        Item["DiracSimpCombine", "FeynCalcRef.nb"],
        Item["DiracSubstitute67", "FeynCalcRef.nb"],
        Item["DotPower", "FeynCalcRef.nb"],
        Item["DotSimplifyRelations", "FeynCalcRef.nb"],
        Item["DummyIndex", "FeynCalcRef.nb"],
        Item["FORMEpilog", "FeynCalcRef.nb"],
        Item["FORMProlog", "FeynCalcRef.nb"],
        Item["IndexPosition", "FeynCalcRef.nb"],
        Item["InitialFunction", "FeynCalcRef.nb"],
        Item["InsideDiracTrace", "FeynCalcRef.nb"],
        Item["PartialDRelations", "FeynCalcRef.nb"],
        Item["Rename", "FeynCalcRef.nb"],
        Item["SpinorCollect", "FeynCalcRef.nb"],
        Item["SUNFJacobi", "FeynCalcRef.nb"],
        Item["SUNIndexRename", "FeynCalcRef.nb"],
        Item["TraceDimension", "FeynCalcRef.nb"],
        Item["Vectors", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Internal objects *)
        Item["FCE", "FeynCalcRef.nb"],
        Item["FCI", "FeynCalcRef.nb"],
        Item["FeynCalcExternal", "FeynCalcRef.nb"],
        Item["FeynCalcInternal", "FeynCalcRef.nb"]
      }],
      BrowserCategory["Loops", None, {
        (* Functions *)
        Item["FCIntegral", "FeynCalcRef.nb"],
        Item["FC2RHI", "FeynCalcRef.nb"],
        Item["FC2TLI", "FeynCalcRef.nb"],
        Item["FeynAmpDenominatorCombine", "FeynCalcRef.nb"],
        Item["FeynAmpDenominatorSimplify", "FeynCalcRef.nb"],
        Item["FeynAmpDenominatorSplit", "FeynCalcRef.nb"],
        Item["FeynmanParametrize", "FeynCalcRef.nb"],
        Item["FromTFI", "FeynCalcRef.nb"],
        Item["FUNCTION", "FeynCalcRef.nb"],
        Item["IFPDOff", "FeynCalcRef.nb"],
        Item["IFPDOn", "FeynCalcRef.nb"],
        Item["IntegrateByParts", "FeynCalcRef.nb"],
        Item["OneLoop", "FeynCalcRef.nb"],
        Item["OneLoopSum", "FeynCalcRef.nb"],
        Item["OneLoopSimplify", "FeynCalcRef.nb"],
        Item["PartialIntegrate", "FeynCalcRef.nb"],
        Item["PaVe", "FeynCalcRef.nb"],
        Item["PaVeOrder", "FeynCalcRef.nb"],
        Item["PaVeReduce", "FeynCalcRef.nb"],
        Item["PropagatorDenominatorExplicit", "FeynCalcRef.nb"],
        Item["StandardMatrixElement", "FeynCalcRef.nb"],
        Item["Tdec", "FeynCalcRef.nb"],
        Item["TID", "FeynCalcRef.nb"],
        Item["TIDL", "FeynCalcRef.nb"],
        Item["ToTFI", "FeynCalcRef.nb"],
        Item["TrickIntegrate", "FeynCalcRef.nb"],
        Item["TwoLoopSimplify", "FeynCalcRef.nb"],
        Item["UVPart", "FeynCalcRef.nb"],
        Item["Write2", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Abbreviations *)
        Item["FDS", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Variables and constants *)
        Item["$FortranContinuationCharacter", "FeynCalcRef.nb"],
        (* Options *)
        Item["CancelQP", "FeynCalcRef.nb"],
        Item["CombineGraphs", "FeynCalcRef.nb"],
        Item["DenominatorOrder", "FeynCalcRef.nb"],
        Item["ExtraVariables", "FeynCalcRef.nb"],
        Item["FinalFunction", "FeynCalcRef.nb"],
        Item["KeepOnly", "FeynCalcRef.nb"],
        Item["NumberOfMetricTensors", "FeynCalcRef.nb"],
        Item["PostFortranFile", "FeynCalcRef.nb"],
        Item["Prefactor", "FeynCalcRef.nb"],
        Item["PreFortranFile", "FeynCalcRef.nb"],
        Item["ReduceGamma", "FeynCalcRef.nb"],
        Item["ReduceToScalars", "FeynCalcRef.nb"],
        Item["SelectGraphs", "FeynCalcRef.nb"],
        Item["SmallVariables", "FeynCalcRef.nb"]
    }],
    BrowserCategory["Tables", None, {
        (* Functions *)
        Item["A0", "FeynCalcRef.nb"],
        Item["Amplitude", "FeynCalcRef.nb"],
        Item["AnomalousDimension", "FeynCalcRef.nb"],
        Item["B0", "FeynCalcRef.nb"],
        Item["B00", "FeynCalcRef.nb"],
        Item["B1", "FeynCalcRef.nb"],
        Item["B11", "FeynCalcRef.nb"],
        Item["C0", "FeynCalcRef.nb"],
        Item["Convolute", "FeynCalcRef.nb"],
        Item["ConvoluteTable", "FeynCalcRef.nb"],
        Item["CounterTerm", "FeynCalcRef.nb"],
        Item["D0", "FeynCalcRef.nb"],
        Item["DB0", "FeynCalcRef.nb"],
        Item["DB1", "FeynCalcRef.nb"],
        Item["Integrate2", "FeynCalcRef.nb"],
        Item["Integrate3", "FeynCalcRef.nb"],
        Item["Integrate4", "FeynCalcRef.nb"],
        Item["Integrate5", "FeynCalcRef.nb"],
        Item["Lagrangian", "FeynCalcRef.nb"],
        Item["RTL", "FeynCalcRef.nb"],
        Item["SimplifyPolyLog", "FeynCalcRef.nb"],
        Item["SMP", "FeynCalcRef.nb"],
        Item["SMVertex", "FeynCalcRef.nb"],
        Item["SplittingFunction", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Options *)
        Item["A0ToB0", "FeynCalcRef.nb"],
        Item["Bracket", "FeynCalcRef.nb"],
        Item["B0Real", "FeynCalcRef.nb"],
        Item["B0Unique", "FeynCalcRef.nb"],
        Item["BReduce", "FeynCalcRef.nb"],
        Item["D0Convention", "FeynCalcRef.nb"],
        Item["SpinPolarizationSum", "FeynCalcRef.nb"]
     }],
    BrowserCategory["QCD", None, {
        (* Functions *)
        Item["BackgroundGluonVertex", "FeynCalcRef.nb"],
        Item["CalcColorFactor", "FeynCalcRef.nb"],
        Item["GhostPropagator", "FeynCalcRef.nb"],
        Item["GluonGhostVertex", "FeynCalcRef.nb"],
        Item["GluonPropagator", "FeynCalcRef.nb"],
        Item["GluonSelfEnergy", "FeynCalcRef.nb"],
        Item["GluonVertex", "FeynCalcRef.nb"],
        Item["GTI", "FeynCalcRef.nb"],
        Item["InverseMellin", "FeynCalcRef.nb"],
        Item["OPE1Loop", "FeynCalcRef.nb"],
        Item["OPE2TID", "FeynCalcRef.nb"],
        Item["OPEDelta", "FeynCalcRef.nb"],
        Item["OPEi", "FeynCalcRef.nb", IndexTag -> {"OPEi", "OPEj", "OPEk", "OPEl", "OPEm", "OPEn", "OPEo"}],

        Item["OPEIntegrate2", "FeynCalcRef.nb"],
        Item["OPEIntegrateDelta", "FeynCalcRef.nb"],
        Item["OPEIntegrate", "FeynCalcRef.nb"],

        Item["OPEInt", "FeynCalcRef.nb"],
        Item["OPEj", "FeynCalcRef.nb", IndexTag -> "OPEi"],
        Item["OPEk", "FeynCalcRef.nb", IndexTag -> "OPEi"],
        Item["OPEl", "FeynCalcRef.nb", IndexTag -> "OPEi"],
        Item["OPEm", "FeynCalcRef.nb", IndexTag -> "OPEi"],
        Item["OPEn", "FeynCalcRef.nb", IndexTag -> "OPEi"],
        Item["OPEo", "FeynCalcRef.nb", IndexTag -> "OPEi"],
        Item["OPESumExplicit", "FeynCalcRef.nb"],
        Item["OPESum", "FeynCalcRef.nb"],
        Item["OPESumSimplify", "FeynCalcRef.nb"],
        Item["PowerSimplify", "FeynCalcRef.nb"],
        Item["Power2", "FeynCalcRef.nb"],
        Item["QuarkGluonVertex", "FeynCalcRef.nb"],
        Item["QuarkPropagator", "FeynCalcRef.nb"],
        Item["RHI", "FeynCalcRef.nb"],
        Item["RHI2FC", "FeynCalcRef.nb"],
        Item["RHM", "FeynCalcRef.nb"],
        Item["RHO", "FeynCalcRef.nb"],
        Item["RHP", "FeynCalcRef.nb"],
        Item["ScalarGluonVertex", "FeynCalcRef.nb"],
        Item["SimplifyGTI", "FeynCalcRef.nb"],
        Item["Simplify2", "FeynCalcRef.nb"],
        Item["Smu", "FeynCalcRef.nb"],
        Item["Sn", "FeynCalcRef.nb"],
        Item["SUNSimplify", "FeynCalcRef.nb"],
        Item["SUNTrace", "FeynCalcRef.nb"],
        Item["SymbolicSum2", "FeynCalcRef.nb"],
        Item["SymbolicSum3", "FeynCalcRef.nb"],
        Item["TLI", "FeynCalcRef.nb"],
        Item["TLI2FC", "FeynCalcRef.nb"],
        Item["TLI2", "FeynCalcRef.nb"],
        Item["TLIFP", "FeynCalcRef.nb"],
        Item["TLIHYP", "FeynCalcRef.nb"],
        Item["ToDistribution", "FeynCalcRef.nb"],
        Item["ToLarin", "FeynCalcRef.nb"],
        Item["Twist2AlienOperator", "FeynCalcRef.nb"],
        Item["Twist2CounterOperator", "FeynCalcRef.nb"],
        Item["Twist2GluonOperator", "FeynCalcRef.nb"],
        Item["Twist2QuarkOperator", "FeynCalcRef.nb"],
        Item["Twist3QuarkOperator", "FeynCalcRef.nb"],
        Item["Twist4GluonOperator", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Abbreviations *)
        Item["GGV", "FeynCalcRef.nb"],
        Item["GHP", "FeynCalcRef.nb"],
        Item["GO", "FeynCalcRef.nb"],
        Item["GP", "FeynCalcRef.nb"],
        Item["GV", "FeynCalcRef.nb"],
        Item["QGV", "FeynCalcRef.nb"],
        Item["QO", "FeynCalcRef.nb"],
        Item["QP", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Variables and constants *)
        Item["Tf", "FeynCalcRef.nb"],
        Item["$MIntegrate", "FeynCalcRef.nb"],
        Item[Delimiter],
        (* Options *)
        Item["SubLoop", "FeynCalcRef.nb"],
        Item["FORM", "FeynCalcRef.nb"]
     }],
    BrowserCategory["General",
      None, {
        (* Functions *)
        Item["AntiSymmetrize", "FeynCalcRef.nb"],
        Item["Apart1", "FeynCalcRef.nb"],
        Item["Apart3", "FeynCalcRef.nb"],
        Item["Collect2", "FeynCalcRef.nb"],
        Item["Collect3", "FeynCalcRef.nb"],
        Item["Combine", "FeynCalcRef.nb"],
        Item["Expand2", "FeynCalcRef.nb"],
        Item["Factor1", "FeynCalcRef.nb"],
        Item["Factor2", "FeynCalcRef.nb"],
        Item["FRH", "FeynCalcRef.nb"],
        Item["Gamma1", "FeynCalcRef.nb"],
        Item["Gamma2", "FeynCalcRef.nb"],
        Item["Gamma3", "FeynCalcRef.nb"],
        Item["GammaEpsilon", "FeynCalcRef.nb"],
        Item["Hill", "FeynCalcRef.nb"],
        Item["HypergeometricAC", "FeynCalcRef.nb"],
        Item["HypergeometricIR", "FeynCalcRef.nb"],
        Item["HypergeometricSE", "FeynCalcRef.nb"],
        Item["HypExplicit", "FeynCalcRef.nb"],
        Item["HypInt", "FeynCalcRef.nb"],
        Item["Isolate", "FeynCalcRef.nb"],
        Item["IsolatePrint", "FeynCalcRef.nb"],
        Item["IsolateSplit", "FeynCalcRef.nb"],
        Item["Kummer", "FeynCalcRef.nb"],
        Item["Map2", "FeynCalcRef.nb"],
        Item["MLimit", "FeynCalcRef.nb"],
        Item["Nielsen", "FeynCalcRef.nb"],
        Item["NTerms", "FeynCalcRef.nb"],
        Item["NumericalFactor", "FeynCalcRef.nb"],
        Item["NumericQ1", "FeynCalcRef.nb"],
        Item["PartitHead", "FeynCalcRef.nb"],
        Item["PowerFactor", "FeynCalcRef.nb"],
        Item["SelectSplit", "FeynCalcRef.nb"],
        Item["Select1", "FeynCalcRef.nb"],
        Item["Select2", "FeynCalcRef.nb"],
        Item["SelectFree", "FeynCalcRef.nb"],
        Item["SelectNotFree", "FeynCalcRef.nb"],
        Item["Series2", "FeynCalcRef.nb"],
        Item["Series3", "FeynCalcRef.nb"],
        Item["Solve2", "FeynCalcRef.nb"],
        Item["Solve3", "FeynCalcRef.nb"],
        Item["SumP", "FeynCalcRef.nb"],
        Item["SumS", "FeynCalcRef.nb"],
        Item["SumT", "FeynCalcRef.nb"],
        Item["Symmetrize", "FeynCalcRef.nb"],
        Item["TimedIntegrate", "FeynCalcRef.nb"],
        Item["ToHypergeometric", "FeynCalcRef.nb"],
        Item["XYT", "FeynCalcRef.nb"],
        Item["Zeta2", "FeynCalcRef.nb"],
        (* Options *)
        Item["FactorFull", "FeynCalcRef.nb"]       
    }],
    BrowserCategory["Development",
      None, {
        Item["CalculateCounterTerm", "FeynCalcRef.nb"],
        Item["DoPolarizationSums", "FeynCalcRef.nb"],
        Item["FeynmanDoIntegrals", "FeynCalcRef.nb"],
        Item["FeynmanParametrize1", "FeynCalcRef.nb"],
        Item["FeynmanReduce", "FeynCalcRef.nb"]
    }]
  }]
}]
